(function polyfill() {
  const relList = document.createElement(`\u006c\u0069\u006e\u006b`).relList;
  if (relList && relList.supports && relList.supports(`\u006d\u006f\u0064\u0075\u006c\u0065\u0070\u0072\u0065\u006c\u006f\u0061\u0064`)) {
    return;
  }
  for (const link of document.querySelectorAll(`\u006c\u0069\u006e\u006b\u005b\u0072\u0065\u006c\u003d\u0022\u006d\u006f\u0064\u0075\u006c\u0065\u0070\u0072\u0065\u006c\u006f\u0061\u0064\u0022\u005d`)) {
    processPreload(link);
  }
  new MutationObserver(mutations => {
    for (const mutation of mutations) {
      if (mutation.type !== `\u0063\u0068\u0069\u006c\u0064\u004c\u0069\u0073\u0074`) {
        continue;
      }
      for (const node of mutation.addedNodes) {
        if (node.tagName === `\u004c\u0049\u004e\u004b` && node.rel === `\u006d\u006f\u0064\u0075\u006c\u0065\u0070\u0072\u0065\u006c\u006f\u0061\u0064`) processPreload(node);
      }
    }
  }).observe(document, {
    childList: true,
    subtree: true
  });
  function getFetchOpts(link) {
    const fetchOpts = {};
    if (link.integrity) fetchOpts.integrity = link.integrity;
    if (link.referrerPolicy) fetchOpts.referrerPolicy = link.referrerPolicy;
    if (link.crossOrigin === `\u0075\u0073\u0065\u002d\u0063\u0072\u0065\u0064\u0065\u006e\u0074\u0069\u0061\u006c\u0073`) fetchOpts.credentials = `\u0069\u006e\u0063\u006c\u0075\u0064\u0065`;else if (link.crossOrigin === `\u0061\u006e\u006f\u006e\u0079\u006d\u006f\u0075\u0073`) fetchOpts.credentials = `\u006f\u006d\u0069\u0074`;else fetchOpts.credentials = `\u0073\u0061\u006d\u0065\u002d\u006f\u0072\u0069\u0067\u0069\u006e`;
    return fetchOpts;
  }
  function processPreload(link) {
    if (link.ep) return;
    link.ep = true;
    const fetchOpts = getFetchOpts(link);
    fetch(link.href, fetchOpts);
  }
})();
const _export_sfc = (sfc, props) => {
  const target = sfc.__vccOpts || sfc;
  for (const [key, val] of props) {
    target[key] = val;
  }
  return target;
};
export { _export_sfc as _ };