function _extends() {
  _extends = Object.assign ? Object.assign.bind() : function (target) {
    for (var i = 1; i < arguments.length; i++) {
      var source = arguments[i];
      for (var key in source) {
        if (Object.prototype.hasOwnProperty.call(source, key)) {
          target[key] = source[key];
        }
      }
    }
    return target;
  };
  return _extends.apply(this, arguments);
}
function _inheritsLoose(subClass, superClass) {
  subClass.prototype = Object.create(superClass.prototype);
  subClass.prototype.constructor = subClass;
  _setPrototypeOf(subClass, superClass);
}
function _getPrototypeOf(o) {
  _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf.bind() : function _getPrototypeOf2(o2) {
    return o2.__proto__ || Object.getPrototypeOf(o2);
  };
  return _getPrototypeOf(o);
}
function _setPrototypeOf(o, p) {
  _setPrototypeOf = Object.setPrototypeOf ? Object.setPrototypeOf.bind() : function _setPrototypeOf2(o2, p2) {
    o2.__proto__ = p2;
    return o2;
  };
  return _setPrototypeOf(o, p);
}
function _isNativeReflectConstruct() {
  if (typeof Reflect === `\u0075\u006e\u0064\u0065\u0066\u0069\u006e\u0065\u0064` || !Reflect.construct) return false;
  if (Reflect.construct.sham) return false;
  if (typeof Proxy === `\u0066\u0075\u006e\u0063\u0074\u0069\u006f\u006e`) return true;
  try {
    Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {}));
    return true;
  } catch (e) {
    return false;
  }
}
function _construct(Parent, args, Class) {
  if (_isNativeReflectConstruct()) {
    _construct = Reflect.construct.bind();
  } else {
    _construct = function _construct2(Parent2, args2, Class2) {
      var a = [null];
      a.push.apply(a, args2);
      var Constructor = Function.bind.apply(Parent2, a);
      var instance = new Constructor();
      if (Class2) _setPrototypeOf(instance, Class2.prototype);
      return instance;
    };
  }
  return _construct.apply(null, arguments);
}
function _isNativeFunction(fn) {
  return Function.toString.call(fn).indexOf(`\u005b\u006e\u0061\u0074\u0069\u0076\u0065\u0020\u0063\u006f\u0064\u0065\u005d`) !== -1;
}
function _wrapNativeSuper(Class) {
  var _cache = typeof Map === `\u0066\u0075\u006e\u0063\u0074\u0069\u006f\u006e` ? /* @__PURE__ */new Map() : void 0;
  _wrapNativeSuper = function _wrapNativeSuper2(Class2) {
    if (Class2 === null || !_isNativeFunction(Class2)) return Class2;
    if (typeof Class2 !== `\u0066\u0075\u006e\u0063\u0074\u0069\u006f\u006e`) {
      throw new TypeError(`\u0053\u0075\u0070\u0065\u0072\u0020\u0065\u0078\u0070\u0072\u0065\u0073\u0073\u0069\u006f\u006e\u0020\u006d\u0075\u0073\u0074\u0020\u0065\u0069\u0074\u0068\u0065\u0072\u0020\u0062\u0065\u0020\u006e\u0075\u006c\u006c\u0020\u006f\u0072\u0020\u0061\u0020\u0066\u0075\u006e\u0063\u0074\u0069\u006f\u006e`);
    }
    if (typeof _cache !== `\u0075\u006e\u0064\u0065\u0066\u0069\u006e\u0065\u0064`) {
      if (_cache.has(Class2)) return _cache.get(Class2);
      _cache.set(Class2, Wrapper);
    }
    function Wrapper() {
      return _construct(Class2, arguments, _getPrototypeOf(this).constructor);
    }
    Wrapper.prototype = Object.create(Class2.prototype, {
      constructor: {
        value: Wrapper,
        enumerable: false,
        writable: true,
        configurable: true
      }
    });
    return _setPrototypeOf(Wrapper, Class2);
  };
  return _wrapNativeSuper(Class);
}
var formatRegExp = /%[sdj%]/g;
var warning = function warning2() {};
function convertFieldsError(errors) {
  if (!errors || !errors.length) return null;
  var fields = {};
  errors.forEach(function (error) {
    var field = error.field;
    fields[field] = fields[field] || [];
    fields[field].push(error);
  });
  return fields;
}
function format(template) {
  for (var _len = arguments.length, args = new Array(_len > 1 ? _len - 1 : 0), _key = 1; _key < _len; _key++) {
    args[_key - 1] = arguments[_key];
  }
  var i = 0;
  var len = args.length;
  if (typeof template === `\u0066\u0075\u006e\u0063\u0074\u0069\u006f\u006e`) {
    return template.apply(null, args);
  }
  if (typeof template === `\u0073\u0074\u0072\u0069\u006e\u0067`) {
    var str = template.replace(formatRegExp, function (x) {
      if (x === `\u0025\u0025`) {
        return `\u0025`;
      }
      if (i >= len) {
        return x;
      }
      switch (x) {
        case `\u0025\u0073`:
          return String(args[i++]);
        case `\u0025\u0064`:
          return Number(args[i++]);
        case `\u0025\u006a`:
          try {
            return JSON.stringify(args[i++]);
          } catch (_) {
            return `\u005b\u0043\u0069\u0072\u0063\u0075\u006c\u0061\u0072\u005d`;
          }
          break;
        default:
          return x;
      }
    });
    return str;
  }
  return template;
}
function isNativeStringType(type4) {
  return type4 === `\u0073\u0074\u0072\u0069\u006e\u0067` || type4 === `\u0075\u0072\u006c` || type4 === `\u0068\u0065\u0078` || type4 === `\u0065\u006d\u0061\u0069\u006c` || type4 === `\u0064\u0061\u0074\u0065` || type4 === `\u0070\u0061\u0074\u0074\u0065\u0072\u006e`;
}
function isEmptyValue(value, type4) {
  if (value === void 0 || value === null) {
    return true;
  }
  if (type4 === `\u0061\u0072\u0072\u0061\u0079` && Array.isArray(value) && !value.length) {
    return true;
  }
  if (isNativeStringType(type4) && typeof value === `\u0073\u0074\u0072\u0069\u006e\u0067` && !value) {
    return true;
  }
  return false;
}
function asyncParallelArray(arr, func, callback) {
  var results = [];
  var total = 0;
  var arrLength = arr.length;
  function count(errors) {
    results.push.apply(results, errors || []);
    total++;
    if (total === arrLength) {
      callback(results);
    }
  }
  arr.forEach(function (a) {
    func(a, count);
  });
}
function asyncSerialArray(arr, func, callback) {
  var index = 0;
  var arrLength = arr.length;
  function next(errors) {
    if (errors && errors.length) {
      callback(errors);
      return;
    }
    var original = index;
    index = index + 1;
    if (original < arrLength) {
      func(arr[original], next);
    } else {
      callback([]);
    }
  }
  next([]);
}
function flattenObjArr(objArr) {
  var ret = [];
  Object.keys(objArr).forEach(function (k) {
    ret.push.apply(ret, objArr[k] || []);
  });
  return ret;
}
var AsyncValidationError = /* @__PURE__ */function (_Error) {
  _inheritsLoose(AsyncValidationError2, _Error);
  function AsyncValidationError2(errors, fields) {
    var _this;
    _this = _Error.call(this, `\u0041\u0073\u0079\u006e\u0063\u0020\u0056\u0061\u006c\u0069\u0064\u0061\u0074\u0069\u006f\u006e\u0020\u0045\u0072\u0072\u006f\u0072`) || this;
    _this.errors = errors;
    _this.fields = fields;
    return _this;
  }
  return AsyncValidationError2;
}(/* @__PURE__ */_wrapNativeSuper(Error));
function asyncMap(objArr, option, func, callback, source) {
  if (option.first) {
    var _pending = new Promise(function (resolve, reject) {
      var next = function next2(errors) {
        callback(errors);
        return errors.length ? reject(new AsyncValidationError(errors, convertFieldsError(errors))) : resolve(source);
      };
      var flattenArr = flattenObjArr(objArr);
      asyncSerialArray(flattenArr, func, next);
    });
    _pending[`\u0063\u0061\u0074\u0063\u0068`](function (e) {
      return e;
    });
    return _pending;
  }
  var firstFields = option.firstFields === true ? Object.keys(objArr) : option.firstFields || [];
  var objArrKeys = Object.keys(objArr);
  var objArrLength = objArrKeys.length;
  var total = 0;
  var results = [];
  var pending = new Promise(function (resolve, reject) {
    var next = function next2(errors) {
      results.push.apply(results, errors);
      total++;
      if (total === objArrLength) {
        callback(results);
        return results.length ? reject(new AsyncValidationError(results, convertFieldsError(results))) : resolve(source);
      }
    };
    if (!objArrKeys.length) {
      callback(results);
      resolve(source);
    }
    objArrKeys.forEach(function (key) {
      var arr = objArr[key];
      if (firstFields.indexOf(key) !== -1) {
        asyncSerialArray(arr, func, next);
      } else {
        asyncParallelArray(arr, func, next);
      }
    });
  });
  pending[`\u0063\u0061\u0074\u0063\u0068`](function (e) {
    return e;
  });
  return pending;
}
function isErrorObj(obj) {
  return !!(obj && obj.message !== void 0);
}
function getValue(value, path) {
  var v = value;
  for (var i = 0; i < path.length; i++) {
    if (v == void 0) {
      return v;
    }
    v = v[path[i]];
  }
  return v;
}
function complementError(rule, source) {
  return function (oe) {
    var fieldValue;
    if (rule.fullFields) {
      fieldValue = getValue(source, rule.fullFields);
    } else {
      fieldValue = source[oe.field || rule.fullField];
    }
    if (isErrorObj(oe)) {
      oe.field = oe.field || rule.fullField;
      oe.fieldValue = fieldValue;
      return oe;
    }
    return {
      message: typeof oe === `\u0066\u0075\u006e\u0063\u0074\u0069\u006f\u006e` ? oe() : oe,
      fieldValue,
      field: oe.field || rule.fullField
    };
  };
}
function deepMerge(target, source) {
  if (source) {
    for (var s in source) {
      if (source.hasOwnProperty(s)) {
        var value = source[s];
        if (typeof value === `\u006f\u0062\u006a\u0065\u0063\u0074` && typeof target[s] === `\u006f\u0062\u006a\u0065\u0063\u0074`) {
          target[s] = _extends({}, target[s], value);
        } else {
          target[s] = value;
        }
      }
    }
  }
  return target;
}
var required$1 = function required(rule, value, source, errors, options, type4) {
  if (rule.required && (!source.hasOwnProperty(rule.field) || isEmptyValue(value, type4 || rule.type))) {
    errors.push(format(options.messages.required, rule.fullField));
  }
};
var whitespace = function whitespace2(rule, value, source, errors, options) {
  if (/^\s+$/.test(value) || value === ``) {
    errors.push(format(options.messages.whitespace, rule.fullField));
  }
};
var urlReg;
var getUrlRegex = function () {
  if (urlReg) {
    return urlReg;
  }
  var word = `\u005b\u0061\u002d\u0066\u0041\u002d\u0046\u005c\u0064\u003a\u005d`;
  var b = function b2(options) {
    return options && options.includeBoundaries ? `\u0028\u003f\u003a\u0028\u003f\u003c\u003d\u005c\u0073\u007c\u005e\u0029\u0028\u003f\u003d` + word + `\u0029\u007c\u0028\u003f\u003c\u003d` + word + `\u0029\u0028\u003f\u003d\u005c\u0073\u007c\u0024\u0029\u0029` : ``;
  };
  var v4 = `\u0028\u003f\u003a\u0032\u0035\u005b\u0030\u002d\u0035\u005d\u007c\u0032\u005b\u0030\u002d\u0034\u005d\u005c\u0064\u007c\u0031\u005c\u0064\u005c\u0064\u007c\u005b\u0031\u002d\u0039\u005d\u005c\u0064\u007c\u005c\u0064\u0029\u0028\u003f\u003a\u005c\u002e\u0028\u003f\u003a\u0032\u0035\u005b\u0030\u002d\u0035\u005d\u007c\u0032\u005b\u0030\u002d\u0034\u005d\u005c\u0064\u007c\u0031\u005c\u0064\u005c\u0064\u007c\u005b\u0031\u002d\u0039\u005d\u005c\u0064\u007c\u005c\u0064\u0029\u0029\u007b\u0033\u007d`;
  var v6seg = `\u005b\u0061\u002d\u0066\u0041\u002d\u0046\u005c\u0064\u005d\u007b\u0031\u002c\u0034\u007d`;
  var v6 = (`\u000a\u0028\u003f\u003a\u000a\u0028\u003f\u003a` + v6seg + `\u003a\u0029\u007b\u0037\u007d\u0028\u003f\u003a` + v6seg + `\u007c\u003a\u0029\u007c\u0020\u0020\u0020\u0020\u0020\u0020\u0020\u0020\u0020\u0020\u0020\u0020\u0020\u0020\u0020\u0020\u0020\u0020\u0020\u0020\u0020\u0020\u0020\u0020\u0020\u0020\u0020\u0020\u0020\u0020\u0020\u0020\u0020\u0020\u0020\u0020\u002f\u002f\u0020\u0031\u003a\u0032\u003a\u0033\u003a\u0034\u003a\u0035\u003a\u0036\u003a\u0037\u003a\u003a\u0020\u0020\u0031\u003a\u0032\u003a\u0033\u003a\u0034\u003a\u0035\u003a\u0036\u003a\u0037\u003a\u0038\u000a\u0028\u003f\u003a` + v6seg + `\u003a\u0029\u007b\u0036\u007d\u0028\u003f\u003a` + v4 + `\u007c\u003a` + v6seg + `\u007c\u003a\u0029\u007c\u0020\u0020\u0020\u0020\u0020\u0020\u0020\u0020\u0020\u0020\u0020\u0020\u0020\u0020\u0020\u0020\u0020\u0020\u0020\u0020\u0020\u0020\u0020\u0020\u0020\u0020\u0020\u0020\u0020\u002f\u002f\u0020\u0031\u003a\u0032\u003a\u0033\u003a\u0034\u003a\u0035\u003a\u0036\u003a\u003a\u0020\u0020\u0020\u0020\u0031\u003a\u0032\u003a\u0033\u003a\u0034\u003a\u0035\u003a\u0036\u003a\u003a\u0038\u0020\u0020\u0020\u0031\u003a\u0032\u003a\u0033\u003a\u0034\u003a\u0035\u003a\u0036\u003a\u003a\u0038\u0020\u0020\u0031\u003a\u0032\u003a\u0033\u003a\u0034\u003a\u0035\u003a\u0036\u003a\u003a\u0031\u002e\u0032\u002e\u0033\u002e\u0034\u000a\u0028\u003f\u003a` + v6seg + `\u003a\u0029\u007b\u0035\u007d\u0028\u003f\u003a\u003a` + v4 + `\u007c\u0028\u003f\u003a\u003a` + v6seg + `\u0029\u007b\u0031\u002c\u0032\u007d\u007c\u003a\u0029\u007c\u0020\u0020\u0020\u0020\u0020\u0020\u0020\u0020\u0020\u0020\u0020\u0020\u0020\u0020\u0020\u0020\u0020\u0020\u0020\u002f\u002f\u0020\u0031\u003a\u0032\u003a\u0033\u003a\u0034\u003a\u0035\u003a\u003a\u0020\u0020\u0020\u0020\u0020\u0020\u0031\u003a\u0032\u003a\u0033\u003a\u0034\u003a\u0035\u003a\u003a\u0037\u003a\u0038\u0020\u0020\u0020\u0031\u003a\u0032\u003a\u0033\u003a\u0034\u003a\u0035\u003a\u003a\u0038\u0020\u0020\u0020\u0020\u0031\u003a\u0032\u003a\u0033\u003a\u0034\u003a\u0035\u003a\u003a\u0037\u003a\u0031\u002e\u0032\u002e\u0033\u002e\u0034\u000a\u0028\u003f\u003a` + v6seg + `\u003a\u0029\u007b\u0034\u007d\u0028\u003f\u003a\u0028\u003f\u003a\u003a` + v6seg + `\u0029\u007b\u0030\u002c\u0031\u007d\u003a` + v4 + `\u007c\u0028\u003f\u003a\u003a` + v6seg + `\u0029\u007b\u0031\u002c\u0033\u007d\u007c\u003a\u0029\u007c\u0020\u002f\u002f\u0020\u0031\u003a\u0032\u003a\u0033\u003a\u0034\u003a\u003a\u0020\u0020\u0020\u0020\u0020\u0020\u0020\u0020\u0031\u003a\u0032\u003a\u0033\u003a\u0034\u003a\u003a\u0036\u003a\u0037\u003a\u0038\u0020\u0020\u0020\u0031\u003a\u0032\u003a\u0033\u003a\u0034\u003a\u003a\u0038\u0020\u0020\u0020\u0020\u0020\u0020\u0031\u003a\u0032\u003a\u0033\u003a\u0034\u003a\u003a\u0036\u003a\u0037\u003a\u0031\u002e\u0032\u002e\u0033\u002e\u0034\u000a\u0028\u003f\u003a` + v6seg + `\u003a\u0029\u007b\u0033\u007d\u0028\u003f\u003a\u0028\u003f\u003a\u003a` + v6seg + `\u0029\u007b\u0030\u002c\u0032\u007d\u003a` + v4 + `\u007c\u0028\u003f\u003a\u003a` + v6seg + `\u0029\u007b\u0031\u002c\u0034\u007d\u007c\u003a\u0029\u007c\u0020\u002f\u002f\u0020\u0031\u003a\u0032\u003a\u0033\u003a\u003a\u0020\u0020\u0020\u0020\u0020\u0020\u0020\u0020\u0020\u0020\u0031\u003a\u0032\u003a\u0033\u003a\u003a\u0035\u003a\u0036\u003a\u0037\u003a\u0038\u0020\u0020\u0020\u0031\u003a\u0032\u003a\u0033\u003a\u003a\u0038\u0020\u0020\u0020\u0020\u0020\u0020\u0020\u0020\u0031\u003a\u0032\u003a\u0033\u003a\u003a\u0035\u003a\u0036\u003a\u0037\u003a\u0031\u002e\u0032\u002e\u0033\u002e\u0034\u000a\u0028\u003f\u003a` + v6seg + `\u003a\u0029\u007b\u0032\u007d\u0028\u003f\u003a\u0028\u003f\u003a\u003a` + v6seg + `\u0029\u007b\u0030\u002c\u0033\u007d\u003a` + v4 + `\u007c\u0028\u003f\u003a\u003a` + v6seg + `\u0029\u007b\u0031\u002c\u0035\u007d\u007c\u003a\u0029\u007c\u0020\u002f\u002f\u0020\u0031\u003a\u0032\u003a\u003a\u0020\u0020\u0020\u0020\u0020\u0020\u0020\u0020\u0020\u0020\u0020\u0020\u0031\u003a\u0032\u003a\u003a\u0034\u003a\u0035\u003a\u0036\u003a\u0037\u003a\u0038\u0020\u0020\u0020\u0031\u003a\u0032\u003a\u003a\u0038\u0020\u0020\u0020\u0020\u0020\u0020\u0020\u0020\u0020\u0020\u0031\u003a\u0032\u003a\u003a\u0034\u003a\u0035\u003a\u0036\u003a\u0037\u003a\u0031\u002e\u0032\u002e\u0033\u002e\u0034\u000a\u0028\u003f\u003a` + v6seg + `\u003a\u0029\u007b\u0031\u007d\u0028\u003f\u003a\u0028\u003f\u003a\u003a` + v6seg + `\u0029\u007b\u0030\u002c\u0034\u007d\u003a` + v4 + `\u007c\u0028\u003f\u003a\u003a` + v6seg + `\u0029\u007b\u0031\u002c\u0036\u007d\u007c\u003a\u0029\u007c\u0020\u002f\u002f\u0020\u0031\u003a\u003a\u0020\u0020\u0020\u0020\u0020\u0020\u0020\u0020\u0020\u0020\u0020\u0020\u0020\u0020\u0031\u003a\u003a\u0033\u003a\u0034\u003a\u0035\u003a\u0036\u003a\u0037\u003a\u0038\u0020\u0020\u0020\u0031\u003a\u003a\u0038\u0020\u0020\u0020\u0020\u0020\u0020\u0020\u0020\u0020\u0020\u0020\u0020\u0031\u003a\u003a\u0033\u003a\u0034\u003a\u0035\u003a\u0036\u003a\u0037\u003a\u0031\u002e\u0032\u002e\u0033\u002e\u0034\u000a\u0028\u003f\u003a\u003a\u0028\u003f\u003a\u0028\u003f\u003a\u003a` + v6seg + `\u0029\u007b\u0030\u002c\u0035\u007d\u003a` + v4 + `\u007c\u0028\u003f\u003a\u003a` + v6seg + `\u0029\u007b\u0031\u002c\u0037\u007d\u007c\u003a\u0029\u0029\u0020\u0020\u0020\u0020\u0020\u0020\u0020\u0020\u0020\u0020\u0020\u0020\u0020\u002f\u002f\u0020\u003a\u003a\u0032\u003a\u0033\u003a\u0034\u003a\u0035\u003a\u0036\u003a\u0037\u003a\u0038\u0020\u0020\u003a\u003a\u0032\u003a\u0033\u003a\u0034\u003a\u0035\u003a\u0036\u003a\u0037\u003a\u0038\u0020\u0020\u003a\u003a\u0038\u0020\u0020\u0020\u0020\u0020\u0020\u0020\u0020\u0020\u0020\u0020\u0020\u0020\u003a\u003a\u0031\u002e\u0032\u002e\u0033\u002e\u0034\u000a\u0029\u0028\u003f\u003a\u0025\u005b\u0030\u002d\u0039\u0061\u002d\u007a\u0041\u002d\u005a\u005d\u007b\u0031\u002c\u007d\u0029\u003f\u0020\u0020\u0020\u0020\u0020\u0020\u0020\u0020\u0020\u0020\u0020\u0020\u0020\u0020\u0020\u0020\u0020\u0020\u0020\u0020\u0020\u0020\u0020\u0020\u0020\u0020\u0020\u0020\u0020\u0020\u0020\u0020\u0020\u0020\u0020\u0020\u0020\u0020\u0020\u0020\u0020\u0020\u0020\u0020\u0020\u002f\u002f\u0020\u0025\u0065\u0074\u0068\u0030\u0020\u0020\u0020\u0020\u0020\u0020\u0020\u0020\u0020\u0020\u0020\u0020\u0025\u0031\u000a`).replace(/\s*\/\/.*$/gm, ``).replace(/\n/g, ``).trim();
  var v46Exact = new RegExp(`\u0028\u003f\u003a\u005e` + v4 + `\u0024\u0029\u007c\u0028\u003f\u003a\u005e` + v6 + `\u0024\u0029`);
  var v4exact = new RegExp(`\u005e` + v4 + `\u0024`);
  var v6exact = new RegExp(`\u005e` + v6 + `\u0024`);
  var ip = function ip2(options) {
    return options && options.exact ? v46Exact : new RegExp(`\u0028\u003f\u003a` + b(options) + v4 + b(options) + `\u0029\u007c\u0028\u003f\u003a` + b(options) + v6 + b(options) + `\u0029`, `\u0067`);
  };
  ip.v4 = function (options) {
    return options && options.exact ? v4exact : new RegExp(`` + b(options) + v4 + b(options), `\u0067`);
  };
  ip.v6 = function (options) {
    return options && options.exact ? v6exact : new RegExp(`` + b(options) + v6 + b(options), `\u0067`);
  };
  var protocol = `\u0028\u003f\u003a\u0028\u003f\u003a\u005b\u0061\u002d\u007a\u005d\u002b\u003a\u0029\u003f\u002f\u002f\u0029`;
  var auth = `\u0028\u003f\u003a\u005c\u0053\u002b\u0028\u003f\u003a\u003a\u005c\u0053\u002a\u0029\u003f\u0040\u0029\u003f`;
  var ipv4 = ip.v4().source;
  var ipv6 = ip.v6().source;
  var host = `\u0028\u003f\u003a\u0028\u003f\u003a\u005b\u0061\u002d\u007a\u005c\u0075\u0030\u0030\u0061\u0031\u002d\u005c\u0075\u0066\u0066\u0066\u0066\u0030\u002d\u0039\u005d\u005b\u002d\u005f\u005d\u002a\u0029\u002a\u005b\u0061\u002d\u007a\u005c\u0075\u0030\u0030\u0061\u0031\u002d\u005c\u0075\u0066\u0066\u0066\u0066\u0030\u002d\u0039\u005d\u002b\u0029`;
  var domain = `\u0028\u003f\u003a\u005c\u002e\u0028\u003f\u003a\u005b\u0061\u002d\u007a\u005c\u0075\u0030\u0030\u0061\u0031\u002d\u005c\u0075\u0066\u0066\u0066\u0066\u0030\u002d\u0039\u005d\u002d\u002a\u0029\u002a\u005b\u0061\u002d\u007a\u005c\u0075\u0030\u0030\u0061\u0031\u002d\u005c\u0075\u0066\u0066\u0066\u0066\u0030\u002d\u0039\u005d\u002b\u0029\u002a`;
  var tld = `\u0028\u003f\u003a\u005c\u002e\u0028\u003f\u003a\u005b\u0061\u002d\u007a\u005c\u0075\u0030\u0030\u0061\u0031\u002d\u005c\u0075\u0066\u0066\u0066\u0066\u005d\u007b\u0032\u002c\u007d\u0029\u0029`;
  var port = `\u0028\u003f\u003a\u003a\u005c\u0064\u007b\u0032\u002c\u0035\u007d\u0029\u003f`;
  var path = `\u0028\u003f\u003a\u005b\u002f\u003f\u0023\u005d\u005b\u005e\u005c\u0073\u0022\u005d\u002a\u0029\u003f`;
  var regex = `\u0028\u003f\u003a` + protocol + `\u007c\u0077\u0077\u0077\u005c\u002e\u0029` + auth + `\u0028\u003f\u003a\u006c\u006f\u0063\u0061\u006c\u0068\u006f\u0073\u0074\u007c` + ipv4 + `\u007c` + ipv6 + `\u007c` + host + domain + tld + `\u0029` + port + path;
  urlReg = new RegExp(`\u0028\u003f\u003a\u005e` + regex + `\u0024\u0029`, `\u0069`);
  return urlReg;
};
var pattern$2 = {
  // http://emailregex.com/
  email: /^(([^<>()\[\]\\.,;:\s@"]+(\.[^<>()\[\]\\.,;:\s@"]+)*)|(".+"))@((\[[0-9]{1,3}\.[0-9]{1,3}\.[0-9]{1,3}\.[0-9]{1,3}])|(([a-zA-Z\-0-9\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF]+\.)+[a-zA-Z\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF]{2,}))$/,
  // url: new RegExp(
  //   '^(?!mailto:)(?:(?:http|https|ftp)://|//)(?:\\S+(?::\\S*)?@)?(?:(?:(?:[1-9]\\d?|1\\d\\d|2[01]\\d|22[0-3])(?:\\.(?:1?\\d{1,2}|2[0-4]\\d|25[0-5])){2}(?:\\.(?:[0-9]\\d?|1\\d\\d|2[0-4]\\d|25[0-4]))|(?:(?:[a-z\\u00a1-\\uffff0-9]+-*)*[a-z\\u00a1-\\uffff0-9]+)(?:\\.(?:[a-z\\u00a1-\\uffff0-9]+-*)*[a-z\\u00a1-\\uffff0-9]+)*(?:\\.(?:[a-z\\u00a1-\\uffff]{2,})))|localhost)(?::\\d{2,5})?(?:(/|\\?|#)[^\\s]*)?$',
  //   'i',
  // ),
  hex: /^#?([a-f0-9]{6}|[a-f0-9]{3})$/i
};
var types = {
  integer: function integer(value) {
    return types.number(value) && parseInt(value, 10) === value;
  },
  "float": function float(value) {
    return types.number(value) && !types.integer(value);
  },
  array: function array(value) {
    return Array.isArray(value);
  },
  regexp: function regexp(value) {
    if (value instanceof RegExp) {
      return true;
    }
    try {
      return !!new RegExp(value);
    } catch (e) {
      return false;
    }
  },
  date: function date(value) {
    return typeof value.getTime === `\u0066\u0075\u006e\u0063\u0074\u0069\u006f\u006e` && typeof value.getMonth === `\u0066\u0075\u006e\u0063\u0074\u0069\u006f\u006e` && typeof value.getYear === `\u0066\u0075\u006e\u0063\u0074\u0069\u006f\u006e` && !isNaN(value.getTime());
  },
  number: function number(value) {
    if (isNaN(value)) {
      return false;
    }
    return typeof value === `\u006e\u0075\u006d\u0062\u0065\u0072`;
  },
  object: function object(value) {
    return typeof value === `\u006f\u0062\u006a\u0065\u0063\u0074` && !types.array(value);
  },
  method: function method(value) {
    return typeof value === `\u0066\u0075\u006e\u0063\u0074\u0069\u006f\u006e`;
  },
  email: function email(value) {
    return typeof value === `\u0073\u0074\u0072\u0069\u006e\u0067` && value.length <= 320 && !!value.match(pattern$2.email);
  },
  url: function url(value) {
    return typeof value === `\u0073\u0074\u0072\u0069\u006e\u0067` && value.length <= 2048 && !!value.match(getUrlRegex());
  },
  hex: function hex(value) {
    return typeof value === `\u0073\u0074\u0072\u0069\u006e\u0067` && !!value.match(pattern$2.hex);
  }
};
var type$1 = function type(rule, value, source, errors, options) {
  if (rule.required && value === void 0) {
    required$1(rule, value, source, errors, options);
    return;
  }
  var custom = [`\u0069\u006e\u0074\u0065\u0067\u0065\u0072`, `\u0066\u006c\u006f\u0061\u0074`, `\u0061\u0072\u0072\u0061\u0079`, `\u0072\u0065\u0067\u0065\u0078\u0070`, `\u006f\u0062\u006a\u0065\u0063\u0074`, `\u006d\u0065\u0074\u0068\u006f\u0064`, `\u0065\u006d\u0061\u0069\u006c`, `\u006e\u0075\u006d\u0062\u0065\u0072`, `\u0064\u0061\u0074\u0065`, `\u0075\u0072\u006c`, `\u0068\u0065\u0078`];
  var ruleType = rule.type;
  if (custom.indexOf(ruleType) > -1) {
    if (!types[ruleType](value)) {
      errors.push(format(options.messages.types[ruleType], rule.fullField, rule.type));
    }
  } else if (ruleType && typeof value !== rule.type) {
    errors.push(format(options.messages.types[ruleType], rule.fullField, rule.type));
  }
};
var range = function range2(rule, value, source, errors, options) {
  var len = typeof rule.len === `\u006e\u0075\u006d\u0062\u0065\u0072`;
  var min = typeof rule.min === `\u006e\u0075\u006d\u0062\u0065\u0072`;
  var max = typeof rule.max === `\u006e\u0075\u006d\u0062\u0065\u0072`;
  var spRegexp = /[\uD800-\uDBFF][\uDC00-\uDFFF]/g;
  var val = value;
  var key = null;
  var num = typeof value === `\u006e\u0075\u006d\u0062\u0065\u0072`;
  var str = typeof value === `\u0073\u0074\u0072\u0069\u006e\u0067`;
  var arr = Array.isArray(value);
  if (num) {
    key = `\u006e\u0075\u006d\u0062\u0065\u0072`;
  } else if (str) {
    key = `\u0073\u0074\u0072\u0069\u006e\u0067`;
  } else if (arr) {
    key = `\u0061\u0072\u0072\u0061\u0079`;
  }
  if (!key) {
    return false;
  }
  if (arr) {
    val = value.length;
  }
  if (str) {
    val = value.replace(spRegexp, `\u005f`).length;
  }
  if (len) {
    if (val !== rule.len) {
      errors.push(format(options.messages[key].len, rule.fullField, rule.len));
    }
  } else if (min && !max && val < rule.min) {
    errors.push(format(options.messages[key].min, rule.fullField, rule.min));
  } else if (max && !min && val > rule.max) {
    errors.push(format(options.messages[key].max, rule.fullField, rule.max));
  } else if (min && max && (val < rule.min || val > rule.max)) {
    errors.push(format(options.messages[key].range, rule.fullField, rule.min, rule.max));
  }
};
var ENUM$1 = `\u0065\u006e\u0075\u006d`;
var enumerable$1 = function enumerable(rule, value, source, errors, options) {
  rule[ENUM$1] = Array.isArray(rule[ENUM$1]) ? rule[ENUM$1] : [];
  if (rule[ENUM$1].indexOf(value) === -1) {
    errors.push(format(options.messages[ENUM$1], rule.fullField, rule[ENUM$1].join(`\u002c\u0020`)));
  }
};
var pattern$1 = function pattern(rule, value, source, errors, options) {
  if (rule.pattern) {
    if (rule.pattern instanceof RegExp) {
      rule.pattern.lastIndex = 0;
      if (!rule.pattern.test(value)) {
        errors.push(format(options.messages.pattern.mismatch, rule.fullField, value, rule.pattern));
      }
    } else if (typeof rule.pattern === `\u0073\u0074\u0072\u0069\u006e\u0067`) {
      var _pattern = new RegExp(rule.pattern);
      if (!_pattern.test(value)) {
        errors.push(format(options.messages.pattern.mismatch, rule.fullField, value, rule.pattern));
      }
    }
  }
};
var rules = {
  required: required$1,
  whitespace,
  type: type$1,
  range,
  "enum": enumerable$1,
  pattern: pattern$1
};
var string = function string2(rule, value, callback, source, options) {
  var errors = [];
  var validate = rule.required || !rule.required && source.hasOwnProperty(rule.field);
  if (validate) {
    if (isEmptyValue(value, `\u0073\u0074\u0072\u0069\u006e\u0067`) && !rule.required) {
      return callback();
    }
    rules.required(rule, value, source, errors, options, `\u0073\u0074\u0072\u0069\u006e\u0067`);
    if (!isEmptyValue(value, `\u0073\u0074\u0072\u0069\u006e\u0067`)) {
      rules.type(rule, value, source, errors, options);
      rules.range(rule, value, source, errors, options);
      rules.pattern(rule, value, source, errors, options);
      if (rule.whitespace === true) {
        rules.whitespace(rule, value, source, errors, options);
      }
    }
  }
  callback(errors);
};
var method2 = function method3(rule, value, callback, source, options) {
  var errors = [];
  var validate = rule.required || !rule.required && source.hasOwnProperty(rule.field);
  if (validate) {
    if (isEmptyValue(value) && !rule.required) {
      return callback();
    }
    rules.required(rule, value, source, errors, options);
    if (value !== void 0) {
      rules.type(rule, value, source, errors, options);
    }
  }
  callback(errors);
};
var number2 = function number3(rule, value, callback, source, options) {
  var errors = [];
  var validate = rule.required || !rule.required && source.hasOwnProperty(rule.field);
  if (validate) {
    if (value === ``) {
      value = void 0;
    }
    if (isEmptyValue(value) && !rule.required) {
      return callback();
    }
    rules.required(rule, value, source, errors, options);
    if (value !== void 0) {
      rules.type(rule, value, source, errors, options);
      rules.range(rule, value, source, errors, options);
    }
  }
  callback(errors);
};
var _boolean = function _boolean2(rule, value, callback, source, options) {
  var errors = [];
  var validate = rule.required || !rule.required && source.hasOwnProperty(rule.field);
  if (validate) {
    if (isEmptyValue(value) && !rule.required) {
      return callback();
    }
    rules.required(rule, value, source, errors, options);
    if (value !== void 0) {
      rules.type(rule, value, source, errors, options);
    }
  }
  callback(errors);
};
var regexp2 = function regexp3(rule, value, callback, source, options) {
  var errors = [];
  var validate = rule.required || !rule.required && source.hasOwnProperty(rule.field);
  if (validate) {
    if (isEmptyValue(value) && !rule.required) {
      return callback();
    }
    rules.required(rule, value, source, errors, options);
    if (!isEmptyValue(value)) {
      rules.type(rule, value, source, errors, options);
    }
  }
  callback(errors);
};
var integer2 = function integer3(rule, value, callback, source, options) {
  var errors = [];
  var validate = rule.required || !rule.required && source.hasOwnProperty(rule.field);
  if (validate) {
    if (isEmptyValue(value) && !rule.required) {
      return callback();
    }
    rules.required(rule, value, source, errors, options);
    if (value !== void 0) {
      rules.type(rule, value, source, errors, options);
      rules.range(rule, value, source, errors, options);
    }
  }
  callback(errors);
};
var floatFn = function floatFn2(rule, value, callback, source, options) {
  var errors = [];
  var validate = rule.required || !rule.required && source.hasOwnProperty(rule.field);
  if (validate) {
    if (isEmptyValue(value) && !rule.required) {
      return callback();
    }
    rules.required(rule, value, source, errors, options);
    if (value !== void 0) {
      rules.type(rule, value, source, errors, options);
      rules.range(rule, value, source, errors, options);
    }
  }
  callback(errors);
};
var array2 = function array3(rule, value, callback, source, options) {
  var errors = [];
  var validate = rule.required || !rule.required && source.hasOwnProperty(rule.field);
  if (validate) {
    if ((value === void 0 || value === null) && !rule.required) {
      return callback();
    }
    rules.required(rule, value, source, errors, options, `\u0061\u0072\u0072\u0061\u0079`);
    if (value !== void 0 && value !== null) {
      rules.type(rule, value, source, errors, options);
      rules.range(rule, value, source, errors, options);
    }
  }
  callback(errors);
};
var object2 = function object3(rule, value, callback, source, options) {
  var errors = [];
  var validate = rule.required || !rule.required && source.hasOwnProperty(rule.field);
  if (validate) {
    if (isEmptyValue(value) && !rule.required) {
      return callback();
    }
    rules.required(rule, value, source, errors, options);
    if (value !== void 0) {
      rules.type(rule, value, source, errors, options);
    }
  }
  callback(errors);
};
var ENUM = `\u0065\u006e\u0075\u006d`;
var enumerable2 = function enumerable3(rule, value, callback, source, options) {
  var errors = [];
  var validate = rule.required || !rule.required && source.hasOwnProperty(rule.field);
  if (validate) {
    if (isEmptyValue(value) && !rule.required) {
      return callback();
    }
    rules.required(rule, value, source, errors, options);
    if (value !== void 0) {
      rules[ENUM](rule, value, source, errors, options);
    }
  }
  callback(errors);
};
var pattern2 = function pattern3(rule, value, callback, source, options) {
  var errors = [];
  var validate = rule.required || !rule.required && source.hasOwnProperty(rule.field);
  if (validate) {
    if (isEmptyValue(value, `\u0073\u0074\u0072\u0069\u006e\u0067`) && !rule.required) {
      return callback();
    }
    rules.required(rule, value, source, errors, options);
    if (!isEmptyValue(value, `\u0073\u0074\u0072\u0069\u006e\u0067`)) {
      rules.pattern(rule, value, source, errors, options);
    }
  }
  callback(errors);
};
var date2 = function date3(rule, value, callback, source, options) {
  var errors = [];
  var validate = rule.required || !rule.required && source.hasOwnProperty(rule.field);
  if (validate) {
    if (isEmptyValue(value, `\u0064\u0061\u0074\u0065`) && !rule.required) {
      return callback();
    }
    rules.required(rule, value, source, errors, options);
    if (!isEmptyValue(value, `\u0064\u0061\u0074\u0065`)) {
      var dateObject;
      if (value instanceof Date) {
        dateObject = value;
      } else {
        dateObject = new Date(value);
      }
      rules.type(rule, dateObject, source, errors, options);
      if (dateObject) {
        rules.range(rule, dateObject.getTime(), source, errors, options);
      }
    }
  }
  callback(errors);
};
var required2 = function required3(rule, value, callback, source, options) {
  var errors = [];
  var type4 = Array.isArray(value) ? `\u0061\u0072\u0072\u0061\u0079` : typeof value;
  rules.required(rule, value, source, errors, options, type4);
  callback(errors);
};
var type2 = function type3(rule, value, callback, source, options) {
  var ruleType = rule.type;
  var errors = [];
  var validate = rule.required || !rule.required && source.hasOwnProperty(rule.field);
  if (validate) {
    if (isEmptyValue(value, ruleType) && !rule.required) {
      return callback();
    }
    rules.required(rule, value, source, errors, options, ruleType);
    if (!isEmptyValue(value, ruleType)) {
      rules.type(rule, value, source, errors, options);
    }
  }
  callback(errors);
};
var any = function any2(rule, value, callback, source, options) {
  var errors = [];
  var validate = rule.required || !rule.required && source.hasOwnProperty(rule.field);
  if (validate) {
    if (isEmptyValue(value) && !rule.required) {
      return callback();
    }
    rules.required(rule, value, source, errors, options);
  }
  callback(errors);
};
var validators = {
  string,
  method: method2,
  number: number2,
  "boolean": _boolean,
  regexp: regexp2,
  integer: integer2,
  "float": floatFn,
  array: array2,
  object: object2,
  "enum": enumerable2,
  pattern: pattern2,
  date: date2,
  url: type2,
  hex: type2,
  email: type2,
  required: required2,
  any
};
function newMessages() {
  return {
    "default": `\u0056\u0061\u006c\u0069\u0064\u0061\u0074\u0069\u006f\u006e\u0020\u0065\u0072\u0072\u006f\u0072\u0020\u006f\u006e\u0020\u0066\u0069\u0065\u006c\u0064\u0020\u0025\u0073`,
    required: `\u0025\u0073\u0020\u0069\u0073\u0020\u0072\u0065\u0071\u0075\u0069\u0072\u0065\u0064`,
    "enum": `\u0025\u0073\u0020\u006d\u0075\u0073\u0074\u0020\u0062\u0065\u0020\u006f\u006e\u0065\u0020\u006f\u0066\u0020\u0025\u0073`,
    whitespace: `\u0025\u0073\u0020\u0063\u0061\u006e\u006e\u006f\u0074\u0020\u0062\u0065\u0020\u0065\u006d\u0070\u0074\u0079`,
    date: {
      format: `\u0025\u0073\u0020\u0064\u0061\u0074\u0065\u0020\u0025\u0073\u0020\u0069\u0073\u0020\u0069\u006e\u0076\u0061\u006c\u0069\u0064\u0020\u0066\u006f\u0072\u0020\u0066\u006f\u0072\u006d\u0061\u0074\u0020\u0025\u0073`,
      parse: `\u0025\u0073\u0020\u0064\u0061\u0074\u0065\u0020\u0063\u006f\u0075\u006c\u0064\u0020\u006e\u006f\u0074\u0020\u0062\u0065\u0020\u0070\u0061\u0072\u0073\u0065\u0064\u002c\u0020\u0025\u0073\u0020\u0069\u0073\u0020\u0069\u006e\u0076\u0061\u006c\u0069\u0064\u0020`,
      invalid: `\u0025\u0073\u0020\u0064\u0061\u0074\u0065\u0020\u0025\u0073\u0020\u0069\u0073\u0020\u0069\u006e\u0076\u0061\u006c\u0069\u0064`
    },
    types: {
      string: `\u0025\u0073\u0020\u0069\u0073\u0020\u006e\u006f\u0074\u0020\u0061\u0020\u0025\u0073`,
      method: `\u0025\u0073\u0020\u0069\u0073\u0020\u006e\u006f\u0074\u0020\u0061\u0020\u0025\u0073\u0020\u0028\u0066\u0075\u006e\u0063\u0074\u0069\u006f\u006e\u0029`,
      array: `\u0025\u0073\u0020\u0069\u0073\u0020\u006e\u006f\u0074\u0020\u0061\u006e\u0020\u0025\u0073`,
      object: `\u0025\u0073\u0020\u0069\u0073\u0020\u006e\u006f\u0074\u0020\u0061\u006e\u0020\u0025\u0073`,
      number: `\u0025\u0073\u0020\u0069\u0073\u0020\u006e\u006f\u0074\u0020\u0061\u0020\u0025\u0073`,
      date: `\u0025\u0073\u0020\u0069\u0073\u0020\u006e\u006f\u0074\u0020\u0061\u0020\u0025\u0073`,
      "boolean": `\u0025\u0073\u0020\u0069\u0073\u0020\u006e\u006f\u0074\u0020\u0061\u0020\u0025\u0073`,
      integer: `\u0025\u0073\u0020\u0069\u0073\u0020\u006e\u006f\u0074\u0020\u0061\u006e\u0020\u0025\u0073`,
      "float": `\u0025\u0073\u0020\u0069\u0073\u0020\u006e\u006f\u0074\u0020\u0061\u0020\u0025\u0073`,
      regexp: `\u0025\u0073\u0020\u0069\u0073\u0020\u006e\u006f\u0074\u0020\u0061\u0020\u0076\u0061\u006c\u0069\u0064\u0020\u0025\u0073`,
      email: `\u0025\u0073\u0020\u0069\u0073\u0020\u006e\u006f\u0074\u0020\u0061\u0020\u0076\u0061\u006c\u0069\u0064\u0020\u0025\u0073`,
      url: `\u0025\u0073\u0020\u0069\u0073\u0020\u006e\u006f\u0074\u0020\u0061\u0020\u0076\u0061\u006c\u0069\u0064\u0020\u0025\u0073`,
      hex: `\u0025\u0073\u0020\u0069\u0073\u0020\u006e\u006f\u0074\u0020\u0061\u0020\u0076\u0061\u006c\u0069\u0064\u0020\u0025\u0073`
    },
    string: {
      len: `\u0025\u0073\u0020\u006d\u0075\u0073\u0074\u0020\u0062\u0065\u0020\u0065\u0078\u0061\u0063\u0074\u006c\u0079\u0020\u0025\u0073\u0020\u0063\u0068\u0061\u0072\u0061\u0063\u0074\u0065\u0072\u0073`,
      min: `\u0025\u0073\u0020\u006d\u0075\u0073\u0074\u0020\u0062\u0065\u0020\u0061\u0074\u0020\u006c\u0065\u0061\u0073\u0074\u0020\u0025\u0073\u0020\u0063\u0068\u0061\u0072\u0061\u0063\u0074\u0065\u0072\u0073`,
      max: `\u0025\u0073\u0020\u0063\u0061\u006e\u006e\u006f\u0074\u0020\u0062\u0065\u0020\u006c\u006f\u006e\u0067\u0065\u0072\u0020\u0074\u0068\u0061\u006e\u0020\u0025\u0073\u0020\u0063\u0068\u0061\u0072\u0061\u0063\u0074\u0065\u0072\u0073`,
      range: `\u0025\u0073\u0020\u006d\u0075\u0073\u0074\u0020\u0062\u0065\u0020\u0062\u0065\u0074\u0077\u0065\u0065\u006e\u0020\u0025\u0073\u0020\u0061\u006e\u0064\u0020\u0025\u0073\u0020\u0063\u0068\u0061\u0072\u0061\u0063\u0074\u0065\u0072\u0073`
    },
    number: {
      len: `\u0025\u0073\u0020\u006d\u0075\u0073\u0074\u0020\u0065\u0071\u0075\u0061\u006c\u0020\u0025\u0073`,
      min: `\u0025\u0073\u0020\u0063\u0061\u006e\u006e\u006f\u0074\u0020\u0062\u0065\u0020\u006c\u0065\u0073\u0073\u0020\u0074\u0068\u0061\u006e\u0020\u0025\u0073`,
      max: `\u0025\u0073\u0020\u0063\u0061\u006e\u006e\u006f\u0074\u0020\u0062\u0065\u0020\u0067\u0072\u0065\u0061\u0074\u0065\u0072\u0020\u0074\u0068\u0061\u006e\u0020\u0025\u0073`,
      range: `\u0025\u0073\u0020\u006d\u0075\u0073\u0074\u0020\u0062\u0065\u0020\u0062\u0065\u0074\u0077\u0065\u0065\u006e\u0020\u0025\u0073\u0020\u0061\u006e\u0064\u0020\u0025\u0073`
    },
    array: {
      len: `\u0025\u0073\u0020\u006d\u0075\u0073\u0074\u0020\u0062\u0065\u0020\u0065\u0078\u0061\u0063\u0074\u006c\u0079\u0020\u0025\u0073\u0020\u0069\u006e\u0020\u006c\u0065\u006e\u0067\u0074\u0068`,
      min: `\u0025\u0073\u0020\u0063\u0061\u006e\u006e\u006f\u0074\u0020\u0062\u0065\u0020\u006c\u0065\u0073\u0073\u0020\u0074\u0068\u0061\u006e\u0020\u0025\u0073\u0020\u0069\u006e\u0020\u006c\u0065\u006e\u0067\u0074\u0068`,
      max: `\u0025\u0073\u0020\u0063\u0061\u006e\u006e\u006f\u0074\u0020\u0062\u0065\u0020\u0067\u0072\u0065\u0061\u0074\u0065\u0072\u0020\u0074\u0068\u0061\u006e\u0020\u0025\u0073\u0020\u0069\u006e\u0020\u006c\u0065\u006e\u0067\u0074\u0068`,
      range: `\u0025\u0073\u0020\u006d\u0075\u0073\u0074\u0020\u0062\u0065\u0020\u0062\u0065\u0074\u0077\u0065\u0065\u006e\u0020\u0025\u0073\u0020\u0061\u006e\u0064\u0020\u0025\u0073\u0020\u0069\u006e\u0020\u006c\u0065\u006e\u0067\u0074\u0068`
    },
    pattern: {
      mismatch: `\u0025\u0073\u0020\u0076\u0061\u006c\u0075\u0065\u0020\u0025\u0073\u0020\u0064\u006f\u0065\u0073\u0020\u006e\u006f\u0074\u0020\u006d\u0061\u0074\u0063\u0068\u0020\u0070\u0061\u0074\u0074\u0065\u0072\u006e\u0020\u0025\u0073`
    },
    clone: function clone() {
      var cloned = JSON.parse(JSON.stringify(this));
      cloned.clone = this.clone;
      return cloned;
    }
  };
}
var messages = newMessages();
var Schema = /* @__PURE__ */function () {
  function Schema2(descriptor) {
    this.rules = null;
    this._messages = messages;
    this.define(descriptor);
  }
  var _proto = Schema2.prototype;
  _proto.define = function define(rules2) {
    var _this = this;
    if (!rules2) {
      throw new Error(`\u0043\u0061\u006e\u006e\u006f\u0074\u0020\u0063\u006f\u006e\u0066\u0069\u0067\u0075\u0072\u0065\u0020\u0061\u0020\u0073\u0063\u0068\u0065\u006d\u0061\u0020\u0077\u0069\u0074\u0068\u0020\u006e\u006f\u0020\u0072\u0075\u006c\u0065\u0073`);
    }
    if (typeof rules2 !== `\u006f\u0062\u006a\u0065\u0063\u0074` || Array.isArray(rules2)) {
      throw new Error(`\u0052\u0075\u006c\u0065\u0073\u0020\u006d\u0075\u0073\u0074\u0020\u0062\u0065\u0020\u0061\u006e\u0020\u006f\u0062\u006a\u0065\u0063\u0074`);
    }
    this.rules = {};
    Object.keys(rules2).forEach(function (name) {
      var item = rules2[name];
      _this.rules[name] = Array.isArray(item) ? item : [item];
    });
  };
  _proto.messages = function messages2(_messages) {
    if (_messages) {
      this._messages = deepMerge(newMessages(), _messages);
    }
    return this._messages;
  };
  _proto.validate = function validate(source_, o, oc) {
    var _this2 = this;
    if (o === void 0) {
      o = {};
    }
    if (oc === void 0) {
      oc = function oc2() {};
    }
    var source = source_;
    var options = o;
    var callback = oc;
    if (typeof options === `\u0066\u0075\u006e\u0063\u0074\u0069\u006f\u006e`) {
      callback = options;
      options = {};
    }
    if (!this.rules || Object.keys(this.rules).length === 0) {
      if (callback) {
        callback(null, source);
      }
      return Promise.resolve(source);
    }
    function complete(results) {
      var errors = [];
      var fields = {};
      function add(e) {
        if (Array.isArray(e)) {
          var _errors;
          errors = (_errors = errors).concat.apply(_errors, e);
        } else {
          errors.push(e);
        }
      }
      for (var i = 0; i < results.length; i++) {
        add(results[i]);
      }
      if (!errors.length) {
        callback(null, source);
      } else {
        fields = convertFieldsError(errors);
        callback(errors, fields);
      }
    }
    if (options.messages) {
      var messages$1 = this.messages();
      if (messages$1 === messages) {
        messages$1 = newMessages();
      }
      deepMerge(messages$1, options.messages);
      options.messages = messages$1;
    } else {
      options.messages = this.messages();
    }
    var series = {};
    var keys = options.keys || Object.keys(this.rules);
    keys.forEach(function (z) {
      var arr = _this2.rules[z];
      var value = source[z];
      arr.forEach(function (r) {
        var rule = r;
        if (typeof rule.transform === `\u0066\u0075\u006e\u0063\u0074\u0069\u006f\u006e`) {
          if (source === source_) {
            source = _extends({}, source);
          }
          value = source[z] = rule.transform(value);
        }
        if (typeof rule === `\u0066\u0075\u006e\u0063\u0074\u0069\u006f\u006e`) {
          rule = {
            validator: rule
          };
        } else {
          rule = _extends({}, rule);
        }
        rule.validator = _this2.getValidationMethod(rule);
        if (!rule.validator) {
          return;
        }
        rule.field = z;
        rule.fullField = rule.fullField || z;
        rule.type = _this2.getType(rule);
        series[z] = series[z] || [];
        series[z].push({
          rule,
          value,
          source,
          field: z
        });
      });
    });
    var errorFields = {};
    return asyncMap(series, options, function (data, doIt) {
      var rule = data.rule;
      var deep = (rule.type === `\u006f\u0062\u006a\u0065\u0063\u0074` || rule.type === `\u0061\u0072\u0072\u0061\u0079`) && (typeof rule.fields === `\u006f\u0062\u006a\u0065\u0063\u0074` || typeof rule.defaultField === `\u006f\u0062\u006a\u0065\u0063\u0074`);
      deep = deep && (rule.required || !rule.required && data.value);
      rule.field = data.field;
      function addFullField(key, schema) {
        return _extends({}, schema, {
          fullField: rule.fullField + `\u002e` + key,
          fullFields: rule.fullFields ? [].concat(rule.fullFields, [key]) : [key]
        });
      }
      function cb(e) {
        if (e === void 0) {
          e = [];
        }
        var errorList = Array.isArray(e) ? e : [e];
        if (!options.suppressWarning && errorList.length) {
          Schema2.warning(`\u0061\u0073\u0079\u006e\u0063\u002d\u0076\u0061\u006c\u0069\u0064\u0061\u0074\u006f\u0072\u003a`, errorList);
        }
        if (errorList.length && rule.message !== void 0) {
          errorList = [].concat(rule.message);
        }
        var filledErrors = errorList.map(complementError(rule, source));
        if (options.first && filledErrors.length) {
          errorFields[rule.field] = 1;
          return doIt(filledErrors);
        }
        if (!deep) {
          doIt(filledErrors);
        } else {
          if (rule.required && !data.value) {
            if (rule.message !== void 0) {
              filledErrors = [].concat(rule.message).map(complementError(rule, source));
            } else if (options.error) {
              filledErrors = [options.error(rule, format(options.messages.required, rule.field))];
            }
            return doIt(filledErrors);
          }
          var fieldsSchema = {};
          if (rule.defaultField) {
            Object.keys(data.value).map(function (key) {
              fieldsSchema[key] = rule.defaultField;
            });
          }
          fieldsSchema = _extends({}, fieldsSchema, data.rule.fields);
          var paredFieldsSchema = {};
          Object.keys(fieldsSchema).forEach(function (field) {
            var fieldSchema = fieldsSchema[field];
            var fieldSchemaList = Array.isArray(fieldSchema) ? fieldSchema : [fieldSchema];
            paredFieldsSchema[field] = fieldSchemaList.map(addFullField.bind(null, field));
          });
          var schema = new Schema2(paredFieldsSchema);
          schema.messages(options.messages);
          if (data.rule.options) {
            data.rule.options.messages = options.messages;
            data.rule.options.error = options.error;
          }
          schema.validate(data.value, data.rule.options || options, function (errs) {
            var finalErrors = [];
            if (filledErrors && filledErrors.length) {
              finalErrors.push.apply(finalErrors, filledErrors);
            }
            if (errs && errs.length) {
              finalErrors.push.apply(finalErrors, errs);
            }
            doIt(finalErrors.length ? finalErrors : null);
          });
        }
      }
      var res;
      if (rule.asyncValidator) {
        res = rule.asyncValidator(rule, data.value, cb, data.source, options);
      } else if (rule.validator) {
        try {
          res = rule.validator(rule, data.value, cb, data.source, options);
        } catch (error) {
          console.error == null ? void 0 : console.error(error);
          if (!options.suppressValidatorError) {
            setTimeout(function () {
              throw error;
            }, 0);
          }
          cb(error.message);
        }
        if (res === true) {
          cb();
        } else if (res === false) {
          cb(typeof rule.message === `\u0066\u0075\u006e\u0063\u0074\u0069\u006f\u006e` ? rule.message(rule.fullField || rule.field) : rule.message || (rule.fullField || rule.field) + `\u0020\u0066\u0061\u0069\u006c\u0073`);
        } else if (res instanceof Array) {
          cb(res);
        } else if (res instanceof Error) {
          cb(res.message);
        }
      }
      if (res && res.then) {
        res.then(function () {
          return cb();
        }, function (e) {
          return cb(e);
        });
      }
    }, function (results) {
      complete(results);
    }, source);
  };
  _proto.getType = function getType(rule) {
    if (rule.type === void 0 && rule.pattern instanceof RegExp) {
      rule.type = `\u0070\u0061\u0074\u0074\u0065\u0072\u006e`;
    }
    if (typeof rule.validator !== `\u0066\u0075\u006e\u0063\u0074\u0069\u006f\u006e` && rule.type && !validators.hasOwnProperty(rule.type)) {
      throw new Error(format(`\u0055\u006e\u006b\u006e\u006f\u0077\u006e\u0020\u0072\u0075\u006c\u0065\u0020\u0074\u0079\u0070\u0065\u0020\u0025\u0073`, rule.type));
    }
    return rule.type || `\u0073\u0074\u0072\u0069\u006e\u0067`;
  };
  _proto.getValidationMethod = function getValidationMethod(rule) {
    if (typeof rule.validator === `\u0066\u0075\u006e\u0063\u0074\u0069\u006f\u006e`) {
      return rule.validator;
    }
    var keys = Object.keys(rule);
    var messageIndex = keys.indexOf(`\u006d\u0065\u0073\u0073\u0061\u0067\u0065`);
    if (messageIndex !== -1) {
      keys.splice(messageIndex, 1);
    }
    if (keys.length === 1 && keys[0] === `\u0072\u0065\u0071\u0075\u0069\u0072\u0065\u0064`) {
      return validators.required;
    }
    return validators[this.getType(rule)] || void 0;
  };
  return Schema2;
}();
Schema.register = function register(type4, validator) {
  if (typeof validator !== `\u0066\u0075\u006e\u0063\u0074\u0069\u006f\u006e`) {
    throw new Error(`\u0043\u0061\u006e\u006e\u006f\u0074\u0020\u0072\u0065\u0067\u0069\u0073\u0074\u0065\u0072\u0020\u0061\u0020\u0076\u0061\u006c\u0069\u0064\u0061\u0074\u006f\u0072\u0020\u0062\u0079\u0020\u0074\u0079\u0070\u0065\u002c\u0020\u0076\u0061\u006c\u0069\u0064\u0061\u0074\u006f\u0072\u0020\u0069\u0073\u0020\u006e\u006f\u0074\u0020\u0061\u0020\u0066\u0075\u006e\u0063\u0074\u0069\u006f\u006e`);
  }
  validators[type4] = validator;
};
Schema.warning = warning;
Schema.messages = messages;
Schema.validators = validators;
export { Schema as S };