var __defProp = Object.defineProperty;
var __defNormalProp = (obj, key, value) => key in obj ? __defProp(obj, key, {
  enumerable: true,
  configurable: true,
  writable: true,
  value
}) : obj[key] = value;
var __publicField = (obj, key, value) => __defNormalProp(obj, typeof key !== `\u0073\u0079\u006d\u0062\u006f\u006c` ? key + `` : key, value);
const _StorageUtil = class _StorageUtil {
  constructor() {
    __publicField(this, `\u006f\u006e\u0043\u0061\u006c\u006c\u0042\u0061\u0063\u006b\u0048\u0061\u006e\u0064\u006c\u0065\u0072\u0073`);
    this.onCallBackHandlers = [];
  }
  // 获取唯一实例的方法
  static getInstance() {
    if (!_StorageUtil.instance) {
      _StorageUtil.instance = new _StorageUtil();
    }
    return _StorageUtil.instance;
  }
  addHandlers(handler) {
    this.onCallBackHandlers.push(handler);
  }
  removeListener(handler) {
    let removeIndex = -1;
    for (let i = 0; i < this.onCallBackHandlers.length; i++) {
      if (this.onCallBackHandlers[i] === handler) {
        removeIndex = i;
        break;
      }
    }
    if (removeIndex !== -1) {
      this.onCallBackHandlers.splice(removeIndex, 1);
    }
  }
  startOnChangedListener() {
    chrome.storage.onChanged.addListener((changes, namespace) => {
      this.onCallBackHandlers.forEach(onCallBackHandler => {
        onCallBackHandler(changes, namespace);
      });
    });
  }
};
__publicField(_StorageUtil, `\u0069\u006e\u0073\u0074\u0061\u006e\u0063\u0065`);
let StorageUtil = _StorageUtil;
let storageUtil = StorageUtil.getInstance();
const indexPage = `\u0058\u0069\u0061\u006f\u0048\u006f\u006e\u0067\u0053\u0068\u0075\u005f\u0053\u0065\u0074\u0074\u0069\u006e\u0067`;
const runPages = [`\u0058\u0069\u0061\u006f\u0048\u006f\u006e\u0067\u0053\u0068\u0075\u005f\u0052\u0075\u006e`];
const reportPages = [`\u0058\u0069\u0061\u006f\u0048\u006f\u006e\u0067\u0053\u0068\u0075\u005f\u0053\u0065\u0074\u0074\u0069\u006e\u0067`];
const _UseCounterStore = class _UseCounterStore {
  constructor() {
    /**
     * 用户id
     */
    __publicField(this, `\u0075\u0073\u0065\u0072\u0049\u0064`);
    __publicField(this, `\u0075\u0073\u0065\u0072\u004e\u0061\u006d\u0065`);
    __publicField(this, `\u0074\u0065\u006e\u0061\u006e\u0074\u0049\u0064`);
    __publicField(this, `\u0077\u0065\u0062\u0055\u0073\u0065\u0072\u0049\u0064`);
    __publicField(this, `\u0077\u0065\u0062\u0055\u0073\u0065\u0072\u004e\u0061\u006d\u0065`);
    __publicField(this, `\u0077\u0065\u0062\u0055\u0073\u0065\u0072\u0041\u0076\u0061\u0074\u0061\u0072\u0055\u0072\u006c`);
    __publicField(this, `\u0077\u0065\u0062\u0050\u006f\u0072\u0074`);
    __publicField(this, `\u0061\u0063\u0063\u0065\u0073\u0073\u0054\u006f\u006b\u0065\u006e`);
    __publicField(this, `\u0072\u0075\u006e\u004c\u006f\u0067\u0073`);
    // 当前页面
    __publicField(this, `\u0061\u0063\u0074\u0069\u0076\u0061\u0074\u0065\u0050\u0061\u0067\u0065`);
    // 是否关闭了
    __publicField(this, `\u0063\u006c\u006f\u0073\u0065\u0053\u0074\u006f\u0070`);
    // 配置
    __publicField(this, `\u0058\u0069\u0061\u006f\u0048\u006f\u006e\u0067\u0053\u0068\u0075\u005f\u0053\u0065\u0074\u0074\u0069\u006e\u0067`);
    //浏览数量
    __publicField(this, `\u0076\u0069\u0065\u0077\u0043\u006f\u0075\u006e\u0074`);
    // 评论数量
    __publicField(this, `\u0043\u006f\u006d\u006d\u0065\u006e\u0074\u0043\u006f\u0075\u006e\u0074`);
    // 点赞数量
    __publicField(this, `\u006c\u0069\u006b\u0065\u0043\u006f\u0075\u006e\u0074`);
    // 关注数量
    __publicField(this, `\u0066\u006f\u006c\u006c\u006f\u0077\u0043\u006f\u0075\u006e\u0074`);
    //收藏
    __publicField(this, `\u0063\u006f\u006c\u006c\u0065\u0063\u0074\u0043\u006f\u0075\u006e\u0074`);
    __publicField(this, `\u0078\u0068\u0073\u005f\u0076\u0069\u0065\u0077\u0043\u006f\u0075\u006e\u0074`);
    __publicField(this, `\u0078\u0068\u0073\u005f\u0043\u006f\u006d\u006d\u0065\u006e\u0074\u0043\u006f\u0075\u006e\u0074`);
    // 初始化
    __publicField(this, `\u0078\u0068\u0073\u005f\u006c\u0069\u006b\u0065\u0043\u006f\u0075\u006e\u0074`);
    // 初始化
    __publicField(this, `\u0078\u0068\u0073\u005f\u0066\u006f\u006c\u006c\u006f\u0077\u0043\u006f\u0075\u006e\u0074`);
    // 初始化
    __publicField(this, `\u0078\u0068\u0073\u005f\u0063\u006f\u006c\u006c\u0065\u0063\u0074\u0043\u006f\u0075\u006e\u0074`);
    __publicField(this, `\u0064\u0079\u005f\u0076\u0069\u0065\u0077\u0043\u006f\u0075\u006e\u0074`);
    __publicField(this, `\u0064\u0079\u005f\u0043\u006f\u006d\u006d\u0065\u006e\u0074\u0043\u006f\u0075\u006e\u0074`);
    // 初始化
    __publicField(this, `\u0064\u0079\u005f\u006c\u0069\u006b\u0065\u0043\u006f\u0075\u006e\u0074`);
    // 初始化
    __publicField(this, `\u0064\u0079\u005f\u0066\u006f\u006c\u006c\u006f\u0077\u0043\u006f\u0075\u006e\u0074`);
    // 初始化
    __publicField(this, `\u0064\u0079\u005f\u0063\u006f\u006c\u006c\u0065\u0063\u0074\u0043\u006f\u0075\u006e\u0074`);
    //弹窗验证码出现次数
    __publicField(this, `\u0063\u0061\u0070\u0074\u0063\u0068\u0061\u005f\u0063\u006f\u006e\u0074\u0061\u0069\u006e\u0065\u0072\u005f\u006e\u0075\u006d`);
    //工作状态
    // run：工作中
    // end: 已结束（到达底部）
    __publicField(this, `\u0058\u0069\u0061\u006f\u0048\u006f\u006e\u0067\u0053\u0068\u0075\u005f\u0077\u006f\u0072\u006b\u0053\u0074\u0061\u0074\u0075\u0073`);
    __publicField(this, `\u006c\u006f\u0061\u0064\u0065\u006e\u0064`);
    //当前窗口的tabId
    __publicField(this, `\u0063\u0068\u0072\u006f\u006d\u0065\u0054\u0061\u0062\u0049\u0064`);
    __publicField(this, `\u0069\u0073\u0044\u0065\u0062\u0075\u0067\u004d\u006f\u0064\u0065`);
    __publicField(this, `\u006f\u0070\u0065\u0072\u0061\u0074\u0069\u006f\u006e\u0054\u0069\u006d\u0065`);
    __publicField(this, `\u0058\u0069\u0061\u006f\u0048\u006f\u006e\u0067\u0053\u0068\u0075\u005f\u0073\u0065\u0061\u0072\u0063\u0068\u005f\u0072\u0075\u006e\u004e\u0075\u006d\u0062\u0065\u0072`);
    __publicField(this, `\u0044\u006f\u0075\u0059\u0069\u006e\u005f\u0073\u0065\u0061\u0072\u0063\u0068\u005f\u0072\u0075\u006e\u004e\u0075\u006d\u0062\u0065\u0072`);
    __publicField(this, `\u0058\u0069\u0061\u006f\u0048\u006f\u006e\u0067\u0053\u0068\u0075\u005f\u0061\u0076\u0067\u0054\u0069\u006d\u0065`);
    //今日运行小红书的账号时间
    __publicField(this, `\u0078\u0069\u0061\u006f\u0048\u006f\u006e\u0067\u0053\u0068\u0075\u0041\u0063\u0063\u006f\u0075\u006e\u0074\u0052\u0075\u006e\u0054\u006f\u0064\u0061\u0079\u0044\u0061\u0074\u0065`);
    //今日运行小红书的账号次数
    __publicField(this, `\u0078\u0069\u0061\u006f\u0048\u006f\u006e\u0067\u0053\u0068\u0075\u0041\u0063\u0063\u006f\u0075\u006e\u0074\u0049\u0064\u0073`);
    //今日运行小红书的账号最大次数
    __publicField(this, `\u0078\u0069\u0061\u006f\u0048\u006f\u006e\u0067\u0053\u0068\u0075\u0041\u0063\u0063\u006f\u0075\u006e\u0074\u0052\u0075\u006e\u0054\u006f\u0064\u0061\u0079\u004d\u0061\u0078\u004e\u0075\u006d`);
    __publicField(this, `\u0065\u0078\u0065\u0063\u0075\u0074\u0065\u004f\u0070\u0065\u0072\u0061\u0074\u0069\u006f\u006e\u0053\u0074\u0061\u0072\u0074\u0054\u0069\u006d\u0065`);
    __publicField(this, `\u0065\u0078\u0065\u0063\u0075\u0074\u0065\u004f\u0070\u0065\u0072\u0061\u0074\u0069\u006f\u006e\u0045\u006e\u0064\u0054\u0069\u006d\u0065`);
    //客户端id
    __publicField(this, `\u0063\u006c\u0069\u0065\u006e\u0074\u0056\u0069\u0073\u0069\u0074\u006f\u0072\u0049\u0064`);
    // vip到期时间
    __publicField(this, `\u0075\u0073\u0065\u0072\u0049\u006e\u0066\u006f\u0045\u006e\u0064\u0044\u0061\u0074\u0065`);
    //vip日期更新
    __publicField(this, `\u0075\u0070\u0064\u0061\u0074\u0065\u0056\u0069\u0070\u0044\u0061\u0074\u0065\u0054\u0069\u006d\u0065`);
    //小红书 关键词 列表
    __publicField(this, `\u0078\u0068\u0073\u005f\u006b\u0065\u0079\u0077\u006f\u0072\u0064\u0073\u005f\u006c\u0069\u0073\u0074`);
    __publicField(this, `\u0064\u006f\u0075\u0059\u0069\u006e\u005f\u006b\u0065\u0079\u0077\u006f\u0072\u0064\u0073\u005f\u006c\u0069\u0073\u0074`);
    __publicField(this, `\u006d\u0071\u0074\u0074\u0053\u0074\u0061\u0072\u0074`);
    __publicField(this, `\u006f\u0070\u0074\u0069\u006f\u006e\u0057\u0068\u0065\u0072\u0065`);
    __publicField(this, `\u0072\u0065\u0066\u0072\u0065\u0073\u0068\u0046\u0072\u0065\u0071\u0075\u0065\u006e\u0063\u0079\u004e\u0075\u006d`);
    __publicField(this, `\u0074\u0065\u0072\u006d\u0069\u006e\u0061\u006c\u0044\u0061\u0074\u0061`);
    __publicField(this, `\u0074\u0061\u0073\u006b\u0049\u0064`);
    __publicField(this, `\u0065\u0078\u0065\u0063\u0075\u0074\u0065\u0049\u0064`);
    // 运行时长
    __publicField(this, `\u0072\u0075\u006e\u0054\u0069\u006d\u0065\u004e\u0075\u006d`);
    __publicField(this, `\u0072\u0075\u006e\u0054\u0069\u006d\u0065\u004d\u0061\u0078\u004e\u0075\u006d`);
    __publicField(this, `\u0078\u0068\u0073\u005f\u006d\u0069\u006e\u0075\u0074\u0065`);
    __publicField(this, `\u0064\u0079\u005f\u006d\u0069\u006e\u0075\u0074\u0065`);
    __publicField(this, `\u0063\u006f\u0072\u0070\u0075\u0073\u0044\u0061\u0074\u0061`);
    // 自动回复评论数量
    __publicField(this, `\u0058\u0069\u0061\u006f\u0048\u006f\u006e\u0067\u0053\u0068\u0075\u005f\u0043\u006f\u006d\u006d\u0065\u006e\u0074\u0043\u006f\u0075\u006e\u0074`);
    //赞和收藏的
    // 取关数量
    __publicField(this, `\u0058\u0069\u0061\u006f\u0048\u006f\u006e\u0067\u0053\u0068\u0075\u005f\u006c\u0069\u006b\u0065\u0073\u005f\u0075\u006e\u0066\u006f\u006c\u006c\u006f\u0077`);
    // 回关数量
    __publicField(this, `\u0058\u0069\u0061\u006f\u0048\u006f\u006e\u0067\u0053\u0068\u0075\u005f\u006c\u0069\u006b\u0065\u0073\u005f\u0066\u006f\u006c\u006c\u006f\u0077`);
    //新增关注
    // 取关数量
    __publicField(this, `\u0058\u0069\u0061\u006f\u0048\u006f\u006e\u0067\u0053\u0068\u0075\u005f\u0063\u006f\u006e\u006e\u0065\u0063\u0074\u0069\u006f\u006e\u0073\u005f\u0075\u006e\u0066\u006f\u006c\u006c\u006f\u0077`);
    // 回关数量
    __publicField(this, `\u0058\u0069\u0061\u006f\u0048\u006f\u006e\u0067\u0053\u0068\u0075\u005f\u0063\u006f\u006e\u006e\u0065\u0063\u0074\u0069\u006f\u006e\u0073\u005f\u0066\u006f\u006c\u006c\u006f\u0077`);
    //自动回复评论的记录
    __publicField(this, `\u0063\u006f\u006d\u006d\u0065\u006e\u0074\u0056\u0069\u0065\u0077\u0050\u0061\u0074\u0068\u0073`);
    //回关的记录
    __publicField(this, `\u0076\u0069\u0065\u0077\u0065\u0064\u0050\u0061\u0074\u0068\u0073`);
    //取关的记录
    __publicField(this, `\u0063\u006f\u006e\u006e\u0065\u0063\u0074\u0069\u006f\u006e\u0073\u005f\u0075\u006e\u0066\u006f\u006c\u006c\u006f\u0077\u005f\u0076\u0069\u0065\u0077\u0065\u0064\u0050\u0061\u0074\u0068\u0073`);
    __publicField(this, `\u0066\u006f\u006c\u006c\u006f\u0077\u0050\u0061\u0074\u0068\u0073`);
    __publicField(this, `\u006c\u0061\u0073\u0074\u004c\u0069\u006b\u0065\u0046\u006c\u006f\u0077\u0044\u0061\u0074\u0065`);
    __publicField(this, `\u0063\u006f\u006e\u0074\u0065\u006e\u0074\u0054\u0065\u0078\u0074`);
    __publicField(this, `\u0072\u0065\u0070\u006c\u0079\u0043\u006f\u006d\u006d\u0065\u006e\u0074`);
    this.userId = ``;
    this.userName = ``;
    this.tenantId = ``;
    this.webUserId = ``;
    this.webUserName = ``;
    this.webUserAvatarUrl = ``;
    this.webPort = 65400;
    this.accessToken = ``;
    this.runLogs = ``;
    this.mqttStart = ``;
    this.activatePage = indexPage;
    this.closeStop = false;
    this.XiaoHongShu_Setting = `\u007b\u007d`;
    this.viewCount = 0;
    this.CommentCount = 0;
    this.likeCount = 0;
    this.followCount = 0;
    this.collectCount = 0;
    this.xhs_viewCount = 0;
    this.xhs_CommentCount = 0;
    this.xhs_likeCount = 0;
    this.xhs_followCount = 0;
    this.xhs_collectCount = 0;
    this.dy_viewCount = 0;
    this.dy_CommentCount = 0;
    this.dy_likeCount = 0;
    this.dy_followCount = 0;
    this.dy_collectCount = 0;
    this.captcha_container_num = 0;
    this.XiaoHongShu_workStatus = `\u0072\u0075\u006e`;
    this.loadend = false;
    this.chromeTabId = 0;
    this.isDebugMode = false;
    this.operationTime = 0;
    this.XiaoHongShu_avgTime = 0;
    this.XiaoHongShu_search_runNumber = 1;
    this.DouYin_search_runNumber = 1;
    this.xiaoHongShuAccountRunTodayDate = {};
    this.xiaoHongShuAccountIds = {};
    this.xiaoHongShuAccountRunTodayMaxNum = 3;
    this.executeOperationStartTime = 0;
    this.executeOperationEndTime = 0;
    this.clientVisitorId = ``;
    this.userInfoEndDate = ``;
    this.updateVipDateTime = ``;
    this.xhs_keywords_list = [];
    this.douYin_keywords_list = [];
    this.optionWhere = {};
    this.refreshFrequencyNum = 60 * 60 * 1e3;
    this.taskId = ``;
    this.executeId = ``;
    this.terminalData = {};
    this.runTimeNum = 0;
    this.runTimeMaxNum = 9999;
    this.xhs_minute = [];
    this.dy_minute = [];
    this.terminalData = {};
    this.runLogs = ``;
    this.corpusData = {};
    this.contentText = ``;
    this.replyComment = ``;
    this.XiaoHongShu_CommentCount = 0;
    this.XiaoHongShu_likes_unfollow = 0;
    this.XiaoHongShu_likes_follow = 0;
    this.XiaoHongShu_connections_unfollow = 0;
    this.XiaoHongShu_connections_follow = 0;
    this.viewedPaths = [];
    this.connections_unfollow_viewedPaths = [];
    this.commentViewPaths = [];
    this.followPaths = [];
    this.lastLikeFlowDate = null;
  }
  // 获取唯一实例的方法
  static getInstance() {
    if (!_UseCounterStore.instance) {
      _UseCounterStore.instance = new _UseCounterStore();
      _UseCounterStore.instance.loadFromStorage();
    }
    return _UseCounterStore.instance;
  }
  setOperationTime(operationTime) {
    this.operationTime = operationTime;
    chrome.storage.local.set({
      "operationTime": this.operationTime
    });
  }
  setChromeTabId(chromeTabId) {
    this.chromeTabId = chromeTabId;
  }
  setWebUserId(userId) {
    this.webUserId = userId;
  }
  setWebUserName(webUserName) {
    this.webUserName = webUserName;
  }
  setWebUserAvatarUrl(webUserAvatarUrl) {
    this.webUserAvatarUrl = webUserAvatarUrl;
  }
  setUserId(userId) {
    this.userId = userId;
  }
  setAccessToken(accessToken) {
    this.accessToken = accessToken;
    chrome.storage.local.set({
      "accessToken": this.accessToken
    });
  }
  set_updateVipDateTime(updateVipDateTime) {
    this.updateVipDateTime = updateVipDateTime;
    chrome.storage.local.set({
      "updateVipDateTime": this.updateVipDateTime
    });
  }
  setUserInfoEndDate(userInfoEndDate) {
    this.userInfoEndDate = userInfoEndDate;
    chrome.storage.local.set({
      "userInfoEndDate": userInfoEndDate
    });
  }
  increment_xhs_viewCount() {
    this.xhs_viewCount++;
    chrome.storage.local.set({
      "xhs_viewCount": this.xhs_viewCount
    });
  }
  increment_xhs_CommentCount() {
    this.xhs_CommentCount++;
    chrome.storage.local.set({
      "xhs_CommentCount": this.xhs_CommentCount
    });
  }
  increment_xhs_likeCount() {
    this.xhs_likeCount++;
    chrome.storage.local.set({
      "xhs_likeCount": this.xhs_likeCount
    });
  }
  increment_xhs_followCount() {
    this.xhs_followCount++;
    chrome.storage.local.set({
      "xhs_followCount": this.xhs_followCount
    });
  }
  increment_xhs_collectCount() {
    this.xhs_collectCount++;
    chrome.storage.local.set({
      "xhs_collectCount": this.xhs_collectCount
    });
  }
  increment_dy_viewCount() {
    this.dy_viewCount++;
    chrome.storage.local.set({
      "dy_viewCount": this.dy_viewCount
    });
  }
  increment_dy_CommentCount() {
    this.dy_CommentCount++;
    chrome.storage.local.set({
      "dy_CommentCount": this.dy_CommentCount
    });
  }
  increment_dy_likeCount() {
    this.dy_likeCount++;
    chrome.storage.local.set({
      "dy_likeCount": this.dy_likeCount
    });
  }
  increment_dy_followCount() {
    this.dy_followCount++;
    chrome.storage.local.set({
      "dy_followCount": this.dy_followCount
    });
  }
  increment_dy_collectCount() {
    this.dy_collectCount++;
    chrome.storage.local.set({
      "dy_collectCount": this.dy_collectCount
    });
  }
  isNotRunWork() {
    console.log(`\u0069\u0073\u004e\u006f\u0074\u0052\u0075\u006e\u0057\u006f\u0072\u006b\u0020\u0061\u0063\u0074\u0069\u0076\u0061\u0074\u0065\u0050\u0061\u0067\u0065`, this.activatePage, !runPages.includes(this.activatePage));
    return !runPages.includes(this.activatePage);
  }
  increment_captcha_container_num() {
    this.captcha_container_num++;
    chrome.storage.local.set({
      "captcha_container_num": this.captcha_container_num
    });
  }
  setActivatePage(page) {
    console.log(`\u0073\u0065\u0074\u0041\u0063\u0074\u0069\u0076\u0061\u0074\u0065\u0050\u0061\u0067\u0065`, this.activatePage);
    this.activatePage = page;
  }
  setCloseStop(closeStop) {
    this.closeStop = closeStop;
  }
  setXiaoHongShu_workStatus(status) {
    this.XiaoHongShu_workStatus = status;
    chrome.storage.local.set({
      "XiaoHongShu_workStatus": this.XiaoHongShu_workStatus
    });
  }
  setXiaoHongShu_avgTime(avgTime) {
    this.XiaoHongShu_avgTime = avgTime;
    chrome.storage.local.set({
      "XiaoHongShu_avgTime": this.XiaoHongShu_avgTime
    });
  }
  setExecuteOperationStartTime(executeOperationStartTime) {
    this.executeOperationStartTime = executeOperationStartTime;
  }
  setExecuteOperationEndTime(executeOperationEndTime) {
    this.executeOperationEndTime = executeOperationEndTime;
    chrome.storage.local.set({
      "executeOperationEndTime": this.executeOperationEndTime
    });
  }
  setXHSKeywords_list(xhs_keywords_list) {
    this.xhs_keywords_list = xhs_keywords_list;
    chrome.storage.local.set({
      "xhs_keywords_list": JSON.stringify(this.xhs_keywords_list)
    });
  }
  setDouYinKeywords_list(douYin_keywords_list) {
    this.douYin_keywords_list = douYin_keywords_list;
    chrome.storage.local.set({
      "douYin_keywords_list": JSON.stringify(this.douYin_keywords_list)
    });
  }
  increment_XiaoHongShu_search_runNumber() {
    this.XiaoHongShu_search_runNumber += 1;
    chrome.storage.local.set({
      "XiaoHongShu_search_runNumber": this.XiaoHongShu_search_runNumber
    });
  }
  increment_DouYin_search_runNumber() {
    this.DouYin_search_runNumber += 1;
    chrome.storage.local.set({
      "DouYin_search_runNumber": this.DouYin_search_runNumber
    });
  }
  increment_XiaoHongShuAccountRunTodayIds(platform, xiaoHongShuAccountIds) {
    let recordData = this.xiaoHongShuAccountIds[platform];
    if (!recordData) {
      recordData = /* @__PURE__ */new Set();
      this.xiaoHongShuAccountIds[platform] = recordData;
    }
    recordData.add(xiaoHongShuAccountIds);
  }
  setXiaoHongShuAccountRunTodayIds(platform, xiaoHongShuAccountIds) {
    this.xiaoHongShuAccountIds[platform] = xiaoHongShuAccountIds;
  }
  getXiaoHongShuAccountRunTodayIds(platform) {
    let recordData = this.xiaoHongShuAccountIds[platform];
    if (!recordData) {
      recordData = /* @__PURE__ */new Set();
    }
    return recordData;
  }
  setXiaoHongShuAccountRunTodayDate(platform, xiaoHongShuAccountRunTodayDate) {
    this.xiaoHongShuAccountRunTodayDate[platform] = xiaoHongShuAccountRunTodayDate;
  }
  getXiaoHongShuAccountRunTodayDate(platform) {
    return this.xiaoHongShuAccountRunTodayDate[platform] ?? ``;
  }
  setXiaoHongShuAccountErrorTip(errorMessage) {
    chrome.storage.local.set({
      "xiaoHongShuAccountErrorTip": errorMessage
    });
  }
  setClientVisitorId(clientVisitorId) {
    this.clientVisitorId = clientVisitorId;
    chrome.storage.local.set({
      "clientVisitorId": clientVisitorId
    });
  }
  getOptionWhere() {
    return this.optionWhere;
  }
  setRefreshFrequencyNum(refreshFrequencyNum) {
    this.refreshFrequencyNum = refreshFrequencyNum;
    chrome.storage.local.set({
      "refreshFrequencyNum": refreshFrequencyNum
    });
  }
  increment_XiaoHongShu_CommentCount() {
    this.XiaoHongShu_CommentCount++;
    chrome.storage.local.set({
      "XiaoHongShu_CommentCount": this.XiaoHongShu_CommentCount
    });
  }
  increment_XiaoHongShu_likes_unfollow() {
    this.XiaoHongShu_likes_unfollow++;
    chrome.storage.local.set({
      "XiaoHongShu_likes_unfollow": this.XiaoHongShu_likes_unfollow
    });
  }
  increment_XiaoHongShu_likes_follow() {
    this.XiaoHongShu_likes_follow++;
    chrome.storage.local.set({
      "XiaoHongShu_likes_follow": this.XiaoHongShu_likes_follow
    });
  }
  increment_XiaoHongShu_connections_unfollow() {
    this.XiaoHongShu_connections_unfollow++;
    chrome.storage.local.set({
      "XiaoHongShu_connections_unfollow": this.XiaoHongShu_connections_unfollow
    });
  }
  increment_XiaoHongShu_connections_follow() {
    this.XiaoHongShu_connections_follow++;
    chrome.storage.local.set({
      "XiaoHongShu_connections_follow": this.XiaoHongShu_connections_follow
    });
  }
  setLastLikeFlowDate(lastLikeFlowDate) {
    this.lastLikeFlowDate = lastLikeFlowDate;
    let lastLikeFlowDate_str = `${lastLikeFlowDate.getFullYear()}\u002d${String(lastLikeFlowDate.getMonth() + 1).padStart(2, `\u0030`)}\u002d${String(lastLikeFlowDate.getDate()).padStart(2, `\u0030`)}\u0020${String(lastLikeFlowDate.getHours()).padStart(2, `\u0030`)}\u003a${String(lastLikeFlowDate.getMinutes()).padStart(2, `\u0030`)}\u003a${String(lastLikeFlowDate.getSeconds()).padStart(2, `\u0030`)}`;
    chrome.storage.local.set({
      "lastLikeFlowDate": lastLikeFlowDate_str
    });
  }
  setCorpusData(corpusData) {
    if (corpusData == null) {
      corpusData = {};
    }
    this.corpusData = corpusData;
    chrome.storage.local.set({
      "corpusData": JSON.stringify(this.corpusData)
    });
  }
  setRunLogs(runLogs) {
    this.runLogs = runLogs;
    chrome.storage.local.set({
      "runLogs": this.runLogs
    });
  }
  setContentText(contentText) {
    this.contentText = contentText;
    chrome.storage.local.set({
      "contentText": this.contentText
    });
  }
  setReplyComment(replyComment2) {
    this.replyComment = replyComment2;
    chrome.storage.local.set({
      "replyComment": this.replyComment
    });
  }
  checkLoadend() {
    let maxNum = 60,
      timeout = 30;
    let num = 0;
    return new Promise(resolve => {
      const checkInterval2 = setInterval(() => {
        const loadend = this.loadend;
        if (loadend || num > maxNum) {
          if (num > maxNum) {
            console.error(`\u0063\u0068\u0065\u0063\u006b\u004c\u006f\u0061\u0064\u0065\u006e\u0064\u0020\u52a0\u8f7d\u8d85\u65f6`);
          }
          clearInterval(checkInterval2);
          resolve();
        }
        num++;
      }, timeout);
    });
  }
  loadFromStorage() {
    chrome.storage.local.get([`\u0075\u0073\u0065\u0072\u0049\u0064`, `\u0075\u0073\u0065\u0072\u004e\u0061\u006d\u0065`, `\u0077\u0065\u0062\u0055\u0073\u0065\u0072\u0049\u0064`, `\u0077\u0065\u0062\u0055\u0073\u0065\u0072\u004e\u0061\u006d\u0065`, `\u0077\u0065\u0062\u0055\u0073\u0065\u0072\u0041\u0076\u0061\u0074\u0061\u0072\u0055\u0072\u006c`, `\u0077\u0065\u0062\u0050\u006f\u0072\u0074`, `\u0074\u0065\u006e\u0061\u006e\u0074\u0049\u0064`, `\u0061\u0063\u0063\u0065\u0073\u0073\u0054\u006f\u006b\u0065\u006e`, `\u0061\u0063\u0074\u0069\u0076\u0061\u0074\u0065\u0050\u0061\u0067\u0065`, `\u0058\u0069\u0061\u006f\u0048\u006f\u006e\u0067\u0053\u0068\u0075\u005f\u0053\u0065\u0074\u0074\u0069\u006e\u0067`, `\u0078\u0068\u0073\u005f\u0076\u0069\u0065\u0077\u0043\u006f\u0075\u006e\u0074`, `\u0078\u0068\u0073\u005f\u0043\u006f\u006d\u006d\u0065\u006e\u0074\u0043\u006f\u0075\u006e\u0074`, `\u0078\u0068\u0073\u005f\u006c\u0069\u006b\u0065\u0043\u006f\u0075\u006e\u0074`, `\u0078\u0068\u0073\u005f\u0066\u006f\u006c\u006c\u006f\u0077\u0043\u006f\u0075\u006e\u0074`, `\u0078\u0068\u0073\u005f\u0063\u006f\u006c\u006c\u0065\u0063\u0074\u0043\u006f\u0075\u006e\u0074`, `\u0064\u0079\u005f\u0076\u0069\u0065\u0077\u0043\u006f\u0075\u006e\u0074`, `\u0064\u0079\u005f\u0043\u006f\u006d\u006d\u0065\u006e\u0074\u0043\u006f\u0075\u006e\u0074`, `\u0064\u0079\u005f\u006c\u0069\u006b\u0065\u0043\u006f\u0075\u006e\u0074`, `\u0064\u0079\u005f\u0066\u006f\u006c\u006c\u006f\u0077\u0043\u006f\u0075\u006e\u0074`, `\u0064\u0079\u005f\u0063\u006f\u006c\u006c\u0065\u0063\u0074\u0043\u006f\u0075\u006e\u0074`, `\u0063\u0061\u0070\u0074\u0063\u0068\u0061\u005f\u0063\u006f\u006e\u0074\u0061\u0069\u006e\u0065\u0072\u005f\u006e\u0075\u006d`, `\u0058\u0069\u0061\u006f\u0048\u006f\u006e\u0067\u0053\u0068\u0075\u005f\u0077\u006f\u0072\u006b\u0053\u0074\u0061\u0074\u0075\u0073`, `\u0058\u0069\u0061\u006f\u0048\u006f\u006e\u0067\u0053\u0068\u0075\u005f\u0061\u0076\u0067\u0054\u0069\u006d\u0065`, `\u0058\u0069\u0061\u006f\u0048\u006f\u006e\u0067\u0053\u0068\u0075\u005f\u0073\u0065\u0061\u0072\u0063\u0068\u005f\u0072\u0075\u006e\u004e\u0075\u006d\u0062\u0065\u0072`, `\u0044\u006f\u0075\u0059\u0069\u006e\u005f\u0073\u0065\u0061\u0072\u0063\u0068\u005f\u0072\u0075\u006e\u004e\u0075\u006d\u0062\u0065\u0072`, `\u0065\u0078\u0065\u0063\u0075\u0074\u0065\u004f\u0070\u0065\u0072\u0061\u0074\u0069\u006f\u006e\u0053\u0074\u0061\u0072\u0074\u0054\u0069\u006d\u0065`, `\u0063\u006c\u0069\u0065\u006e\u0074\u0056\u0069\u0073\u0069\u0074\u006f\u0072\u0049\u0064`, `\u0075\u0073\u0065\u0072\u0049\u006e\u0066\u006f\u0045\u006e\u0064\u0044\u0061\u0074\u0065`, `\u0078\u0068\u0073\u005f\u006d\u0069\u006e\u0075\u0074\u0065`, `\u0064\u0079\u005f\u006d\u0069\u006e\u0075\u0074\u0065`, `\u006d\u0071\u0074\u0074\u0053\u0074\u0061\u0072\u0074`, `\u006f\u0070\u0074\u0069\u006f\u006e\u0057\u0068\u0065\u0072\u0065`, `\u0074\u0065\u0072\u006d\u0069\u006e\u0061\u006c\u0044\u0061\u0074\u0061`, `\u0074\u0061\u0073\u006b\u0049\u0064`, `\u0065\u0078\u0065\u0063\u0075\u0074\u0065\u0049\u0064`, `\u0072\u0075\u006e\u0054\u0069\u006d\u0065\u004e\u0075\u006d`, `\u0072\u0075\u006e\u0054\u0069\u006d\u0065\u004d\u0061\u0078\u004e\u0075\u006d`, `\u0063\u006f\u0072\u0070\u0075\u0073\u0044\u0061\u0074\u0061`], result => {
      console.log(`\u0072\u0065\u0073\u0075\u006c\u0074\u0020\u0061\u0063\u0074\u0069\u0076\u0061\u0074\u0065\u0050\u0061\u0067\u0065`, result);
      if (result.userId !== void 0) {
        this.userId = result.userId;
      }
      if (result.accessToken !== void 0) {
        this.accessToken = result.accessToken;
      }
      if (result.activatePage !== void 0) {
        this.activatePage = result.activatePage;
      }
      if (result.XiaoHongShu_Setting !== void 0) {
        this.XiaoHongShu_Setting = result.XiaoHongShu_Setting;
      }
      if (result.xhs_viewCount !== void 0) {
        this.xhs_viewCount = result.xhs_viewCount;
      }
      if (result.xhs_CommentCount !== void 0) {
        this.xhs_CommentCount = result.xhs_CommentCount;
      }
      if (result.xhs_likeCount !== void 0) {
        this.xhs_likeCount = result.xhs_likeCount;
      }
      if (result.xhs_followCount !== void 0) {
        this.xhs_followCount = result.xhs_followCount;
      }
      if (result.xhs_collectCount !== void 0) {
        this.xhs_collectCount = result.xhs_collectCount;
      }
      if (result.dy_viewCount !== void 0) {
        this.dy_viewCount = result.dy_viewCount;
      }
      if (result.dy_CommentCount !== void 0) {
        this.dy_CommentCount = result.dy_CommentCount;
      }
      if (result.dy_likeCount !== void 0) {
        this.dy_likeCount = result.dy_likeCount;
      }
      if (result.dy_followCount !== void 0) {
        this.dy_followCount = result.dy_followCount;
      }
      if (result.dy_collectCount !== void 0) {
        this.dy_collectCount = result.dy_collectCount;
      }
      if (result.captcha_container_num !== void 0) {
        this.captcha_container_num = result.captcha_container_num;
      }
      if (result.XiaoHongShu_workStatus !== void 0) {
        this.XiaoHongShu_workStatus = result.XiaoHongShu_workStatus;
      }
      if (result.XiaoHongShu_avgTime !== void 0) {
        this.XiaoHongShu_avgTime = result.XiaoHongShu_avgTime;
      }
      if (result.XiaoHongShu_search_runNumber !== void 0) {
        this.XiaoHongShu_search_runNumber = result.XiaoHongShu_search_runNumber;
      }
      if (result.DouYin_search_runNumber !== void 0) {
        this.DouYin_search_runNumber = result.DouYin_search_runNumber;
      }
      if (result.executeOperationStartTime !== void 0) {
        this.executeOperationStartTime = result.executeOperationStartTime;
      }
      if (result.clientVisitorId !== void 0) {
        this.clientVisitorId = result.clientVisitorId;
      }
      if (result.userInfoEndDate !== void 0) {
        this.userInfoEndDate = result.userInfoEndDate;
      }
      if (result.mqttStart !== void 0) {
        this.mqttStart = result.mqttStart;
      }
      if (result.taskId !== void 0) {
        this.taskId = result.taskId;
      }
      if (result.xhs_minute !== void 0) {
        this.xhs_minute = result.xhs_minute ? JSON.parse(result.xhs_minute) : [];
      }
      if (result.dy_minute !== void 0) {
        this.dy_minute = result.dy_minute ? JSON.parse(result.dy_minute) : [];
      }
      if (result.terminalData !== void 0) {
        this.terminalData = result.terminalData ? JSON.parse(result.terminalData) : {};
      }
      if (result.optionWhere !== void 0) {
        this.optionWhere = result.optionWhere ? JSON.parse(result.optionWhere) : {};
      }
      if (result.tenantId !== void 0) {
        this.tenantId = result.tenantId;
      }
      if (result.executeId !== void 0) {
        this.executeId = result.executeId;
      }
      if (result.runTimeNum !== void 0) {
        this.runTimeNum = result.runTimeNum;
      }
      if (result.runTimeMaxNum !== void 0) {
        this.runTimeMaxNum = result.runTimeMaxNum;
      }
      if (result.corpusData !== void 0) {
        this.corpusData = result.corpusData == `` ? {} : JSON.parse(result.corpusData);
      }
      if (result.webUserId !== void 0) {
        this.webUserId = result.webUserId;
      }
      if (result.webUserName !== void 0) {
        this.webUserName = result.webUserName;
      }
      if (result.webUserAvatarUrl !== void 0) {
        this.webUserAvatarUrl = result.webUserAvatarUrl;
      }
      if (result.webPort !== void 0) {
        this.webPort = result.webPort;
      }
      if (result.contentText !== void 0) {
        this.contentText = result.contentText;
      }
      if (result.replyComment !== void 0) {
        this.replyComment = result.replyComment;
      }
      if (result.userName !== void 0) {
        this.userName = result.userName;
      }
      this.loadend = true;
    });
    const callBackListener = (changes, namespace) => {
      for (let [key, {
        oldValue,
        newValue
      }] of Object.entries(changes)) {
        console.log(`\u0053\u0074\u006f\u0072\u0061\u0067\u0065\u0020\u006b\u0065\u0079\u0020\u0022${key}\u0022\u0020\u0069\u006e\u0020\u006e\u0061\u006d\u0065\u0073\u0070\u0061\u0063\u0065\u0020\u0022${namespace}\u0022\u0020\u0063\u0068\u0061\u006e\u0067\u0065\u0064\u002e`, `\u004f\u006c\u0064\u0020\u0076\u0061\u006c\u0075\u0065\u0020\u0077\u0061\u0073\u0020\u0022${oldValue}\u0022\u002c\u0020\u006e\u0065\u0077\u0020\u0076\u0061\u006c\u0075\u0065\u0020\u0069\u0073\u0020\u0022${newValue}\u0022\u002e`);
        switch (key) {
          case `\u0061\u0063\u0074\u0069\u0076\u0061\u0074\u0065\u0050\u0061\u0067\u0065`:
            this.setActivatePage(newValue);
            break;
          case `\u0078\u0068\u0073\u005f\u006c\u0069\u006b\u0065\u0043\u006f\u0075\u006e\u0074`:
            this.xhs_likeCount = newValue;
            break;
          case `\u0078\u0068\u0073\u005f\u0066\u006f\u006c\u006c\u006f\u0077\u0043\u006f\u0075\u006e\u0074`:
            this.xhs_followCount = newValue;
            break;
          case `\u0078\u0068\u0073\u005f\u0043\u006f\u006d\u006d\u0065\u006e\u0074\u0043\u006f\u0075\u006e\u0074`:
            this.xhs_CommentCount = newValue;
            break;
          case `\u0078\u0068\u0073\u005f\u0063\u006f\u006c\u006c\u0065\u0063\u0074\u0043\u006f\u0075\u006e\u0074`:
            this.xhs_collectCount = newValue;
            break;
          case `\u0078\u0068\u0073\u005f\u0076\u0069\u0065\u0077\u0043\u006f\u0075\u006e\u0074`:
            this.xhs_viewCount = newValue;
            break;
          case `\u0064\u0079\u005f\u006c\u0069\u006b\u0065\u0043\u006f\u0075\u006e\u0074`:
            this.dy_likeCount = newValue;
            break;
          case `\u0064\u0079\u005f\u0066\u006f\u006c\u006c\u006f\u0077\u0043\u006f\u0075\u006e\u0074`:
            this.dy_followCount = newValue;
            break;
          case `\u0064\u0079\u005f\u0043\u006f\u006d\u006d\u0065\u006e\u0074\u0043\u006f\u0075\u006e\u0074`:
            this.dy_CommentCount = newValue;
            break;
          case `\u0064\u0079\u005f\u0063\u006f\u006c\u006c\u0065\u0063\u0074\u0043\u006f\u0075\u006e\u0074`:
            this.dy_collectCount = newValue;
            break;
          case `\u0064\u0079\u005f\u0076\u0069\u0065\u0077\u0043\u006f\u0075\u006e\u0074`:
            this.dy_viewCount = newValue;
            break;
          case `\u0063\u0061\u0070\u0074\u0063\u0068\u0061\u005f\u0063\u006f\u006e\u0074\u0061\u0069\u006e\u0065\u0072\u005f\u006e\u0075\u006d`:
            this.captcha_container_num = newValue;
            break;
          case `\u0065\u0078\u0065\u0063\u0075\u0074\u0065\u004f\u0070\u0065\u0072\u0061\u0074\u0069\u006f\u006e\u0053\u0074\u0061\u0072\u0074\u0054\u0069\u006d\u0065`:
            this.executeOperationStartTime = newValue;
            break;
          case `\u0063\u006c\u0069\u0065\u006e\u0074\u0056\u0069\u0073\u0069\u0074\u006f\u0072\u0049\u0064`:
            this.clientVisitorId = newValue;
            break;
          case `\u0075\u0073\u0065\u0072\u0049\u006e\u0066\u006f\u0045\u006e\u0064\u0044\u0061\u0074\u0065`:
            this.userInfoEndDate = newValue;
            break;
          case `\u0074\u0061\u0073\u006b\u0049\u0064`:
            this.taskId = newValue;
            break;
          case `\u0078\u0068\u0073\u005f\u006d\u0069\u006e\u0075\u0074\u0065`:
            this.xhs_minute = newValue ? JSON.parse(newValue) : [];
            break;
          case `\u0064\u0079\u005f\u006d\u0069\u006e\u0075\u0074\u0065`:
            this.dy_minute = newValue ? JSON.parse(newValue) : [];
            break;
          case `\u006f\u0070\u0074\u0069\u006f\u006e\u0057\u0068\u0065\u0072\u0065`:
            this.optionWhere = newValue ? JSON.parse(newValue) : {};
            break;
          case `\u0074\u0065\u006e\u0061\u006e\u0074\u0049\u0064`:
            this.tenantId = newValue;
            break;
          case `\u0065\u0078\u0065\u0063\u0075\u0074\u0065\u0049\u0064`:
            this.executeId = newValue;
            break;
          case `\u0074\u0065\u0072\u006d\u0069\u006e\u0061\u006c\u0044\u0061\u0074\u0061`:
            this.terminalData = newValue == `` ? {} : JSON.parse(newValue);
            break;
          case `\u0072\u0075\u006e\u0054\u0069\u006d\u0065\u004e\u0075\u006d`:
            this.runTimeNum = newValue;
            break;
          case `\u0072\u0075\u006e\u0054\u0069\u006d\u0065\u004d\u0061\u0078\u004e\u0075\u006d`:
            this.runTimeMaxNum = newValue;
            break;
          case `\u0063\u006f\u0072\u0070\u0075\u0073\u0044\u0061\u0074\u0061`:
            this.corpusData = newValue == `` ? {} : JSON.parse(newValue);
            break;
          case `\u0075\u0073\u0065\u0072\u004e\u0061\u006d\u0065`:
            this.userName = newValue;
            break;
          case `\u0077\u0065\u0062\u0055\u0073\u0065\u0072\u0049\u0064`:
            this.webUserId = newValue;
            break;
          case `\u0077\u0065\u0062\u0055\u0073\u0065\u0072\u004e\u0061\u006d\u0065`:
            this.webUserName = newValue;
            break;
          case `\u0077\u0065\u0062\u0055\u0073\u0065\u0072\u0041\u0076\u0061\u0074\u0061\u0072\u0055\u0072\u006c`:
            this.webUserAvatarUrl = newValue;
            break;
          case `\u0077\u0065\u0062\u0050\u006f\u0072\u0074`:
            this.webPort = newValue;
            break;
          case `\u0058\u0069\u0061\u006f\u0048\u006f\u006e\u0067\u0053\u0068\u0075\u005f\u0061\u0076\u0067\u0054\u0069\u006d\u0065`:
            this.XiaoHongShu_avgTime = newValue;
            break;
          case `\u0063\u006f\u006e\u0074\u0065\u006e\u0074\u0054\u0065\u0078\u0074`:
            this.contentText = newValue;
            break;
          case `\u0072\u0065\u0070\u006c\u0079\u0043\u006f\u006d\u006d\u0065\u006e\u0074`:
            this.replyComment = newValue;
            break;
        }
      }
    };
    storageUtil.removeListener(callBackListener);
    storageUtil.addHandlers(callBackListener);
  }
};
__publicField(_UseCounterStore, `\u0069\u006e\u0073\u0074\u0061\u006e\u0063\u0065`);
let UseCounterStore = _UseCounterStore;
const store_console = UseCounterStore.getInstance();
store_console.isDebugMode = true;
if (!store_console.isDebugMode) {
  const originalConsoleLog = console.log;
  console.log = (...args) => {
    if (store_console.isDebugMode) {
      originalConsoleLog(...args);
    }
  };
}
if (!store_console.isDebugMode) {
  const originalConsoleError = console.error;
  console.error = (...args) => {
    if (store_console.isDebugMode) {
      originalConsoleError(...args);
    }
  };
}
if (!store_console.isDebugMode) {
  const originalConsoleInfo = console.info;
  console.info = (...args) => {
    if (store_console.isDebugMode) {
      originalConsoleInfo(...args);
    }
  };
}
const baseURL$1 = `\u0068\u0074\u0074\u0070\u0073\u003a\u002f\u002f\u0070\u006c\u0075\u0067\u0069\u006e\u002d\u0061\u0070\u0069\u002d\u0061\u0064\u006c\u0072\u0064\u006f\u006a\u0062\u0079\u0064\u002e\u0061\u0070\u002d\u006e\u006f\u0072\u0074\u0068\u0065\u0061\u0073\u0074\u002d\u0031\u002e\u0066\u0063\u0061\u0070\u0070\u002e\u0072\u0075\u006e`;
const VITE_LOGIN_API$1 = `\u0068\u0074\u0074\u0070\u0073\u003a\u002f\u002f\u0067\u006c\u006f\u0062\u0061\u006c\u002d\u0061\u0075\u0074\u0068\u002e\u0070\u0065\u0074\u0072\u006f\u006e\u002e\u0061\u0069`;
const store$9 = UseCounterStore.getInstance();
async function queryComment$1(refer_id) {
  const url = baseURL$1 + `\u002f\u0061\u0070\u0069\u002f\u0076\u0032\u002f\u006f\u0073\u0073\u002f\u006f\u0062\u006a\u0065\u0063\u0074\u0073\u002f${refer_id}`;
  const headers = {
    "Content-Type": `\u0061\u0070\u0070\u006c\u0069\u0063\u0061\u0074\u0069\u006f\u006e\u002f\u006a\u0073\u006f\u006e`,
    "Authorization": `\u0042\u0065\u0061\u0072\u0065\u0072\u0020` + store$9.accessToken
  };
  try {
    const response = await fetch(url, {
      method: `\u0047\u0045\u0054`,
      headers
    });
    if (!response.ok) {
      if (response.status === 404) {
        const result2 = await response.json();
        console.log(`\u0072\u0065\u0073\u0075\u006c\u0074`, result2);
        sendLog(`\u67e5\u8be2\u8bc4\u8bba\u9519\u8bef\u0020\u0034\u0030\u0034` + (result2 == null ? void 0 : result2.detail));
        if ((result2 == null ? void 0 : result2.detail) == `\u0058\u0068\u0073\u0043\u006f\u006e\u0074\u0065\u006e\u0074\u0020\u006e\u006f\u0074\u0020\u0066\u006f\u0075\u006e\u0064`) {
          return true;
        }
      }
      if (response.status === 401) {
        sendLog(`\u767b\u5f55\u5931\u6548`);
        store$9.setAccessToken(``);
      } else {
        const result2 = await response.json();
        console.log(`\u0072\u0065\u0073\u0075\u006c\u0074`, result2);
        sendLog(`\u67e5\u8be2\u8bc4\u8bba\u9519\u8bef\u0020\u5176\u4ed6` + (result2 == null ? void 0 : result2.detail));
      }
      console.error(`\u0048\u0054\u0054\u0050\u0020\u0065\u0072\u0072\u006f\u0072\u0021\u0020\u0073\u0074\u0061\u0074\u0075\u0073\u003a\u0020${response.status}`, response);
      return false;
    }
    const result = await response.json();
    console.log(`\u0072\u0065\u0073\u0075\u006c\u0074`, result);
    if (!result) {
      return true;
    }
    return false;
  } catch (error) {
    console.error(`\u0045\u0072\u0072\u006f\u0072\u003a`, error);
    sendLog(`\u67e5\u8be2\u8bc4\u8bba\u9519\u8bef` + error);
  }
  return false;
}
async function saveComment$1(saveData) {
  const url = baseURL$1 + `\u002f\u0061\u0070\u0069\u002f\u0076\u0032\u002f\u006f\u0073\u0073\u002f\u006f\u0062\u006a\u0065\u0063\u0074\u0073`;
  const headers = {
    "Content-Type": `\u0061\u0070\u0070\u006c\u0069\u0063\u0061\u0074\u0069\u006f\u006e\u002f\u006a\u0073\u006f\u006e`,
    "Authorization": `\u0042\u0065\u0061\u0072\u0065\u0072\u0020` + store$9.accessToken
  };
  try {
    const response = await fetch(url, {
      method: `\u0050\u004f\u0053\u0054`,
      headers,
      body: JSON.stringify(saveData)
    });
    if (!response.ok) {
      console.error(`\u0048\u0054\u0054\u0050\u0020\u0065\u0072\u0072\u006f\u0072\u0021\u0020\u0073\u0074\u0061\u0074\u0075\u0073\u003a\u0020${response.status}`, response);
      if (response.status === 401) {
        sendLog(`\u767b\u5f55\u5931\u6548`);
        store$9.setAccessToken(``);
      } else {
        const result2 = await response.json();
        console.log(`\u0072\u0065\u0073\u0075\u006c\u0074`, result2);
        sendLog(`\u4fdd\u5b58\u8bc4\u8bba\u9519\u8bef\u0020\u5176\u4ed6` + (result2 == null ? void 0 : result2.detail));
      }
      return false;
    }
    const result = await response.json();
    console.log(`\u0072\u0065\u0073\u0075\u006c\u0074`, result);
    return true;
  } catch (error) {
    console.error(`\u0045\u0072\u0072\u006f\u0072\u003a`, error);
    sendLog(`\u4fdd\u5b58\u8bc4\u8bba\u9519\u8bef` + error);
  }
  return false;
}
async function setXiaoHongShuAccountRunTodayNum(accessToken, postData) {
  const url = baseURL$1 + `\u002f\u0061\u0070\u0069\u002f\u0076\u0032\u002f\u006f\u0073\u0073\u002f\u006f\u0062\u006a\u0065\u0063\u0074\u0073`;
  try {
    const headers = {
      "Content-Type": `\u0061\u0070\u0070\u006c\u0069\u0063\u0061\u0074\u0069\u006f\u006e\u002f\u006a\u0073\u006f\u006e`,
      "Authorization": `\u0042\u0065\u0061\u0072\u0065\u0072\u0020` + accessToken
    };
    const response = await fetch(url, {
      method: `\u0050\u004f\u0053\u0054`,
      headers,
      body: JSON.stringify(postData)
    });
    if (!response.ok) {
      console.error(`\u0048\u0054\u0054\u0050\u0020\u0065\u0072\u0072\u006f\u0072\u0021\u0020\u0073\u0074\u0061\u0074\u0075\u0073\u003a\u0020${response.status}`, response);
      return void 0;
    }
    const result = await response.json();
    console.log(`\u0072\u0065\u0073\u0075\u006c\u0074`, result);
    return result;
  } catch (error) {
    console.error(`\u0045\u0072\u0072\u006f\u0072\u003a`, error);
  }
  return void 0;
}
async function getXiaoHongShuAccountRunTodayNum(accessToken, key, userId) {
  const url = baseURL$1 + `\u002f\u0061\u0070\u0069\u002f\u0076\u0032\u002f\u006f\u0073\u0073\u002f\u006f\u0062\u006a\u0065\u0063\u0074\u0073\u002f` + key + `\u003f\u0062\u0065\u006c\u006f\u006e\u0067\u005f\u0074\u006f\u003d` + userId;
  try {
    const headers = {
      "Content-Type": `\u0061\u0070\u0070\u006c\u0069\u0063\u0061\u0074\u0069\u006f\u006e\u002f\u006a\u0073\u006f\u006e`,
      "Authorization": `\u0042\u0065\u0061\u0072\u0065\u0072\u0020` + accessToken
    };
    const response = await fetch(url, {
      method: `\u0067\u0065\u0074`,
      headers
    });
    if (!response.ok) {
      console.error(`\u0048\u0054\u0054\u0050\u0020\u0065\u0072\u0072\u006f\u0072\u0021\u0020\u0073\u0074\u0061\u0074\u0075\u0073\u003a\u0020${response.status}`, response);
      return void 0;
    }
    const result = await response.json();
    console.log(`\u0072\u0065\u0073\u0075\u006c\u0074`, result);
    return result;
  } catch (error) {
    console.error(`\u0045\u0072\u0072\u006f\u0072\u003a`, error);
  }
  return void 0;
}
const addObjects = async postData => {
  const url = baseURL$1 + `\u002f\u0061\u0070\u0069\u002f\u0076\u0032\u002f\u006f\u0073\u0073\u002f\u006f\u0062\u006a\u0065\u0063\u0074\u0073`;
  const headers = {
    "Content-Type": `\u0061\u0070\u0070\u006c\u0069\u0063\u0061\u0074\u0069\u006f\u006e\u002f\u006a\u0073\u006f\u006e`,
    "Authorization": `\u0042\u0065\u0061\u0072\u0065\u0072\u0020` + store$9.accessToken
  };
  try {
    const response = await fetch(url, {
      method: `\u0050\u004f\u0053\u0054`,
      headers,
      body: JSON.stringify(postData)
    });
    if (!response.ok) {
      sendLog(`\u0061\u0064\u0064\u004f\u0062\u006a\u0065\u0063\u0074\u0073\u0020\u0075\u0072\u006c\u003a` + url + `\uff0c\u0068\u0065\u0061\u0064\u0065\u0072\u003a` + JSON.stringify(headers) + `\u002c\u0020\u0072\u0065\u0073\u0070\u006f\u006e\u0073\u0065\u0020\u0073\u0074\u0061\u0074\u0075\u0073\u003a` + response.status);
      console.error(`\u0048\u0054\u0054\u0050\u0020\u0065\u0072\u0072\u006f\u0072\u0021\u0020\u0073\u0074\u0061\u0074\u0075\u0073\u003a\u0020${response.status}`);
      return void 0;
    }
    const result = await response.json();
    sendLog(`\u0061\u0064\u0064\u004f\u0062\u006a\u0065\u0063\u0074\u0073\u0020\u0075\u0072\u006c\u003a` + url + `\uff0c\u0068\u0065\u0061\u0064\u0065\u0072\u003a` + JSON.stringify(headers) + `\u002c\u0070\u006f\u0073\u0074\u0044\u0061\u0074\u0061\uff1a` + JSON.stringify(postData) + `\u0020\u0072\u0065\u0073\u0070\u006f\u006e\u0073\u0065\u0020\u0073\u0074\u0061\u0074\u0075\u0073\u003a` + response.status + `\u002c\u0020\u0072\u0065\u0073\u0070\u006f\u006e\u0073\u0065\u0020\u0064\u0061\u0074\u0061\u003a` + JSON.stringify(result));
    console.log(`\u0072\u0065\u0073\u0075\u006c\u0074`, result);
    return result;
  } catch (error) {
    sendLog(`\u0061\u0064\u0064\u004f\u0062\u006a\u0065\u0063\u0074\u0073\u0020\u0075\u0072\u006c\u003a` + url + `\uff0c\u0068\u0065\u0061\u0064\u0065\u0072\u003a` + JSON.stringify(headers) + `\u002c\u0020\u0065\u0072\u0072\u006f\u0072` + error);
    console.error(`\u0045\u0072\u0072\u006f\u0072\u003a`, error);
  }
  return void 0;
};
const getObjects = async key => {
  const url = `${baseURL$1}\u002f\u0061\u0070\u0069\u002f\u0076\u0032\u002f\u006f\u0073\u0073\u002f\u006f\u0062\u006a\u0065\u0063\u0074\u0073\u002f${key}`;
  const headers = {
    "Content-Type": `\u0061\u0070\u0070\u006c\u0069\u0063\u0061\u0074\u0069\u006f\u006e\u002f\u006a\u0073\u006f\u006e`,
    "Authorization": `\u0042\u0065\u0061\u0072\u0065\u0072\u0020` + store$9.accessToken
  };
  try {
    const response = await fetch(url, {
      method: `\u0067\u0065\u0074`,
      headers
    });
    if (!response.ok) {
      sendLog(`\u0067\u0065\u0074\u004f\u0062\u006a\u0065\u0063\u0074\u0073\u0020\u0075\u0072\u006c\u003a` + url + `\uff0c\u0068\u0065\u0061\u0064\u0065\u0072\u003a` + JSON.stringify(headers) + `\u002c\u0020\u0072\u0065\u0073\u0070\u006f\u006e\u0073\u0065\u0020\u0073\u0074\u0061\u0074\u0075\u0073\u003a` + response.status);
      console.error(`\u0048\u0054\u0054\u0050\u0020\u0065\u0072\u0072\u006f\u0072\u0021\u0020\u0073\u0074\u0061\u0074\u0075\u0073\u003a\u0020${response.status}`, response);
      return void 0;
    }
    const result = await response.json();
    sendLog(`\u0067\u0065\u0074\u004f\u0062\u006a\u0065\u0063\u0074\u0073\u0020\u0075\u0072\u006c\u003a` + url + `\uff0c\u0068\u0065\u0061\u0064\u0065\u0072\u003a` + JSON.stringify(headers) + `\u002c\u0020\u0072\u0065\u0073\u0070\u006f\u006e\u0073\u0065\u0020\u0073\u0074\u0061\u0074\u0075\u0073\u003a` + response.status + `\u002c\u0020\u0072\u0065\u0073\u0070\u006f\u006e\u0073\u0065\u0020\u0064\u0061\u0074\u0061\u003a` + JSON.stringify(result));
    console.log(`\u0072\u0065\u0073\u0075\u006c\u0074`, result);
    return result;
  } catch (error) {
    sendLog(`\u0067\u0065\u0074\u004f\u0062\u006a\u0065\u0063\u0074\u0073\u0020\u0075\u0072\u006c\u003a` + url + `\uff0c\u0068\u0065\u0061\u0064\u0065\u0072\u003a` + JSON.stringify(headers) + `\u002c\u0020\u0065\u0072\u0072\u006f\u0072` + error);
    console.error(`\u0045\u0072\u0072\u006f\u0072\u003a`, error);
  }
  return void 0;
};
const queryObjects = async queryParams => {
  const params = new URLSearchParams();
  queryParams.forEach(param => params.append(param.key, String(param.value)));
  const url = `${baseURL$1}\u002f\u0061\u0070\u0069\u002f\u0076\u0032\u002f\u006f\u0073\u0073\u002f\u006f\u0062\u006a\u0065\u0063\u0074\u0073\u003f${params.toString()}`;
  const headers = {
    "Content-Type": `\u0061\u0070\u0070\u006c\u0069\u0063\u0061\u0074\u0069\u006f\u006e\u002f\u006a\u0073\u006f\u006e`,
    "Authorization": `\u0042\u0065\u0061\u0072\u0065\u0072\u0020` + store$9.accessToken
  };
  try {
    const response = await fetch(url, {
      method: `\u0067\u0065\u0074`,
      headers
    });
    if (!response.ok) {
      sendLog(`\u0071\u0075\u0065\u0072\u0079\u004f\u0062\u006a\u0065\u0063\u0074\u0073\u0020\u0075\u0072\u006c\u003a` + url + `\uff0c\u0068\u0065\u0061\u0064\u0065\u0072\u003a` + JSON.stringify(headers) + `\u002c\u0020\u0072\u0065\u0073\u0070\u006f\u006e\u0073\u0065\u0020\u0073\u0074\u0061\u0074\u0075\u0073\u003a` + response.status);
      console.error(`\u0071\u0075\u0065\u0072\u0079\u004f\u0062\u006a\u0065\u0063\u0074\u0073\u0020\u0048\u0054\u0054\u0050\u0020\u0065\u0072\u0072\u006f\u0072\u0021\u0020\u0073\u0074\u0061\u0074\u0075\u0073\u003a\u0020${response.status}`, response);
      return void 0;
    }
    const result = await response.json();
    sendLog(`\u0075\u0072\u006c\u003a` + url + `\uff0c\u0068\u0065\u0061\u0064\u0065\u0072\u003a` + JSON.stringify(headers) + `\u002c\u0020\u0072\u0065\u0073\u0070\u006f\u006e\u0073\u0065\u0020\u0073\u0074\u0061\u0074\u0075\u0073\u003a` + response.status + `\u002c\u0020\u0072\u0065\u0073\u0070\u006f\u006e\u0073\u0065\u0020\u0064\u0061\u0074\u0061\u003a` + JSON.stringify(result));
    console.log(`\u0071\u0075\u0065\u0072\u0079\u004f\u0062\u006a\u0065\u0063\u0074\u0073\u0020\u0072\u0065\u0073\u0075\u006c\u0074`, result);
    return result;
  } catch (error) {
    console.error(`\u0071\u0075\u0065\u0072\u0079\u004f\u0062\u006a\u0065\u0063\u0074\u0073\u0020\u0045\u0072\u0072\u006f\u0072\u003a`, error);
    sendLog(`\u0075\u0072\u006c\u003a` + url + `\uff0c\u0068\u0065\u0061\u0064\u0065\u0072\u003a` + JSON.stringify(headers) + `\u002c\u0020\u0065\u0072\u0072\u006f\u0072` + error);
  }
  return void 0;
};
async function logout(accessToken) {
  const url = VITE_LOGIN_API$1 + `\u002f\u0061\u0070\u0069\u002f\u0076\u0031\u002f\u0077\u006f\u0072\u006b\u006f\u0073\u002f\u006c\u006f\u0067\u006f\u0075\u0074`;
  const headers = {
    "Content-Type": `\u0061\u0070\u0070\u006c\u0069\u0063\u0061\u0074\u0069\u006f\u006e\u002f\u006a\u0073\u006f\u006e`,
    "Authorization": `\u0042\u0065\u0061\u0072\u0065\u0072\u0020` + accessToken
  };
  try {
    const response = await fetch(url, {
      method: `\u0067\u0065\u0074`,
      headers
    });
    if (!response.ok) {
      sendLog(`\u0075\u0072\u006c\u003a` + url + `\uff0c\u0068\u0065\u0061\u0064\u0065\u0072\u003a` + JSON.stringify(headers) + `\u002c\u0020\u0072\u0065\u0073\u0070\u006f\u006e\u0073\u0065\u0020\u0073\u0074\u0061\u0074\u0075\u0073\u003a` + response.status);
      console.error(`\u0048\u0054\u0054\u0050\u0020\u0065\u0072\u0072\u006f\u0072\u0021\u0020\u0073\u0074\u0061\u0074\u0075\u0073\u003a\u0020${response.status}`, response);
      if (response.status == 404) {
        return void 0;
      }
      return void 0;
    }
    const result = await response.json();
    sendLog(`\u0075\u0072\u006c\u003a` + url + `\uff0c\u0068\u0065\u0061\u0064\u0065\u0072\u003a` + JSON.stringify(headers) + `\u002c\u0020\u0072\u0065\u0073\u0070\u006f\u006e\u0073\u0065\u0020\u0073\u0074\u0061\u0074\u0075\u0073\u003a` + response.status + `\u002c\u0020\u0072\u0065\u0073\u0070\u006f\u006e\u0073\u0065\u0020\u0064\u0061\u0074\u0061\u003a` + JSON.stringify(result));
    console.log(`\u0072\u0065\u0073\u0075\u006c\u0074`, result);
    return result;
  } catch (error) {
    sendLog(`\u0075\u0072\u006c\u003a` + url + `\uff0c\u0068\u0065\u0061\u0064\u0065\u0072\u003a` + JSON.stringify(headers) + `\u002c\u0020\u0065\u0072\u0072\u006f\u0072` + error);
    console.error(`\u0045\u0072\u0072\u006f\u0072\u003a`, error);
  }
  return void 0;
}
async function putBurialPoint(postData) {
  console.log(`\u0070\u0075\u0074\u0042\u0075\u0072\u0069\u0061\u006c\u0050\u006f\u0069\u006e\u0074`, postData);
  const url = VITE_LOGIN_API$1 + `\u002f\u0061\u0070\u0069\u002f\u0076\u0031\u002f\u0061\u006e\u0061\u006c\u0079\u0074\u0069\u0063\u0073\u005f\u0065\u0076\u0065\u006e\u0074\u0073`;
  const headers = {
    "Content-Type": `\u0061\u0070\u0070\u006c\u0069\u0063\u0061\u0074\u0069\u006f\u006e\u002f\u006a\u0073\u006f\u006e`,
    "Authorization": `\u0042\u0065\u0061\u0072\u0065\u0072\u0020` + store$9.accessToken
  };
  try {
    const response = await fetch(url, {
      method: `\u0050\u004f\u0053\u0054`,
      headers,
      body: JSON.stringify(postData)
    });
    if (!response.ok) {
      sendLog(`\u0075\u0072\u006c\u003a` + url + `\uff0c\u0068\u0065\u0061\u0064\u0065\u0072\u003a` + JSON.stringify(headers) + `\u002c\u0020\u0072\u0065\u0073\u0070\u006f\u006e\u0073\u0065\u0020\u0073\u0074\u0061\u0074\u0075\u0073\u003a` + response.status);
      console.error(`\u0048\u0054\u0054\u0050\u0020\u0065\u0072\u0072\u006f\u0072\u0021\u0020\u0073\u0074\u0061\u0074\u0075\u0073\u003a\u0020${response.status}`);
      if (response.status === 401) {
        console.log(`\u767b\u5f55\u5931\u6548`);
        store$9.setAccessToken(``);
        store$9.set_updateVipDateTime(``);
        store$9.setUserInfoEndDate(``);
        await logout(store$9.accessToken);
      }
      if (response.status == 404) {
        return void 0;
      }
      return void 0;
    }
    const result = await response.json();
    sendLog(`\u0075\u0072\u006c\u003a` + url + `\uff0c\u0068\u0065\u0061\u0064\u0065\u0072\u003a` + JSON.stringify(headers) + `\u002c\u0070\u006f\u0073\u0074\u0044\u0061\u0074\u0061\uff1a` + JSON.stringify(postData) + `\u0020\u0072\u0065\u0073\u0070\u006f\u006e\u0073\u0065\u0020\u0073\u0074\u0061\u0074\u0075\u0073\u003a` + response.status + `\u002c\u0020\u0072\u0065\u0073\u0070\u006f\u006e\u0073\u0065\u0020\u0064\u0061\u0074\u0061\u003a` + JSON.stringify(result));
    console.log(`\u0072\u0065\u0073\u0075\u006c\u0074`, result);
    return result;
  } catch (error) {
    sendLog(`\u0075\u0072\u006c\u003a` + url + `\uff0c\u0068\u0065\u0061\u0064\u0065\u0072\u003a` + JSON.stringify(headers) + `\u002c\u0020\u0065\u0072\u0072\u006f\u0072` + error);
    console.error(`\u0045\u0072\u0072\u006f\u0072\u003a`, error);
  }
  return void 0;
}
const dify_base_url$1 = `\u0068\u0074\u0074\u0070\u0073\u003a\u002f\u002f\u0064\u0069\u0066\u0079\u002e\u0066\u0073\u006f\u0074\u006f\u006f\u006c\u002e\u0063\u006f\u006d`;
UseCounterStore.getInstance();
async function runWorkflow$1(inputs, files, apiKey) {
  const url = dify_base_url$1 + `\u002f\u0076\u0031\u002f\u0077\u006f\u0072\u006b\u0066\u006c\u006f\u0077\u0073\u002f\u0072\u0075\u006e`;
  const headers = {
    "Authorization": `\u0042\u0065\u0061\u0072\u0065\u0072\u0020${apiKey}`,
    "Content-Type": `\u0061\u0070\u0070\u006c\u0069\u0063\u0061\u0074\u0069\u006f\u006e\u002f\u006a\u0073\u006f\u006e`
  };
  const data = {
    inputs,
    response_mode: `\u0062\u006c\u006f\u0063\u006b\u0069\u006e\u0067`,
    files,
    user: `\u0061\u0062\u0063\u002d\u0031\u0032\u0033`
  };
  try {
    const response = await fetch(url, {
      method: `\u0050\u004f\u0053\u0054`,
      headers,
      body: JSON.stringify(data)
    });
    if (!response.ok) {
      console.error(`\u0048\u0054\u0054\u0050\u0020\u0065\u0072\u0072\u006f\u0072\u0021\u0020\u0073\u0074\u0061\u0074\u0075\u0073\u003a\u0020${response.status}`);
      sendLog(`\u751f\u6210\u8bc4\u8bba\u9519\u8bef` + response.status);
      return;
    }
    const result = await response.json();
    let resultText = ``;
    if (result && result.data && result.data.outputs && result.data.outputs.result) {
      resultText = result.data.outputs.result;
    } else if (result && result.data && result.data.outputs && result.data.outputs.text) {
      resultText = result.data.outputs.text;
    }
    console.log(`\u0072\u0065\u0073\u0075\u006c\u0074`, result);
    return resultText;
  } catch (error) {
    console.error(`\u0045\u0072\u0072\u006f\u0072\u003a`, error);
    sendLog(`\u751f\u6210\u8bc4\u8bba\u9519\u8bef` + error);
  }
}
async function runWorkflowVideoReviews(inputs, files) {
  const url = dify_base_url$1 + `\u002f\u0076\u0031\u002f\u0077\u006f\u0072\u006b\u0066\u006c\u006f\u0077\u0073\u002f\u0072\u0075\u006e`;
  const apiKey = `\u0061\u0070\u0070\u002d\u0063\u006d\u0068\u004e\u0072\u004c\u0054\u0043\u0077\u0065\u007a\u0075\u0075\u005a\u0032\u0058\u0056\u0047\u0056\u0031\u0072\u0056\u0038\u0075`;
  const headers = {
    "Authorization": `\u0042\u0065\u0061\u0072\u0065\u0072\u0020${apiKey}`,
    "Content-Type": `\u0061\u0070\u0070\u006c\u0069\u0063\u0061\u0074\u0069\u006f\u006e\u002f\u006a\u0073\u006f\u006e`
  };
  const data = {
    inputs,
    response_mode: `\u0062\u006c\u006f\u0063\u006b\u0069\u006e\u0067`,
    files,
    user: `\u0061\u0062\u0063\u002d\u0031\u0032\u0033`
  };
  try {
    const response = await fetch(url, {
      method: `\u0050\u004f\u0053\u0054`,
      headers,
      body: JSON.stringify(data)
    });
    if (!response.ok) {
      console.error(`\u0048\u0054\u0054\u0050\u0020\u0065\u0072\u0072\u006f\u0072\u0021\u0020\u0073\u0074\u0061\u0074\u0075\u0073\u003a\u0020${response.status}`);
      sendLog(`\u751f\u6210\u8bc4\u8bba\u9519\u8bef` + response.status);
      return;
    }
    const result = await response.json();
    let resultText = ``;
    if (result && result.data && result.data.outputs && result.data.outputs.text) {
      resultText = result.data.outputs.text;
    }
    console.log(`\u0072\u0065\u0073\u0075\u006c\u0074`, result);
    return resultText;
  } catch (error) {
    console.error(`\u0045\u0072\u0072\u006f\u0072\u003a`, error);
    sendLog(`\u751f\u6210\u8bc4\u8bba\u9519\u8bef` + error);
  }
}
async function keywordsIntelligentAssociation(inputs, files) {
  const url = dify_base_url$1 + `\u002f\u0076\u0031\u002f\u0077\u006f\u0072\u006b\u0066\u006c\u006f\u0077\u0073\u002f\u0072\u0075\u006e`;
  const apiKey = `\u0061\u0070\u0070\u002d\u005a\u0044\u0052\u004a\u004c\u004e\u0072\u0069\u006f\u0041\u0050\u0035\u0063\u0039\u0064\u0065\u0073\u0074\u006b\u0068\u0057\u006e\u004a\u0042`;
  const headers = {
    "Authorization": `\u0042\u0065\u0061\u0072\u0065\u0072\u0020${apiKey}`,
    "Content-Type": `\u0061\u0070\u0070\u006c\u0069\u0063\u0061\u0074\u0069\u006f\u006e\u002f\u006a\u0073\u006f\u006e`
  };
  const data = {
    inputs,
    response_mode: `\u0062\u006c\u006f\u0063\u006b\u0069\u006e\u0067`,
    files,
    user: `\u0061\u0062\u0063\u002d\u0031\u0032\u0033`
  };
  try {
    const response = await fetch(url, {
      method: `\u0050\u004f\u0053\u0054`,
      headers,
      body: JSON.stringify(data)
    });
    if (!response.ok) {
      console.error(`\u0048\u0054\u0054\u0050\u0020\u0065\u0072\u0072\u006f\u0072\u0021\u0020\u0073\u0074\u0061\u0074\u0075\u0073\u003a\u0020${response.status}`);
      sendLog(`\u751f\u6210\u8bc4\u8bba\u9519\u8bef` + response.status);
      return;
    }
    const result = await response.json();
    let resultText = ``;
    if (result && result.data && result.data.outputs && result.data.outputs.text) {
      resultText = result.data.outputs.text;
    }
    console.log(`\u0072\u0065\u0073\u0075\u006c\u0074`, result);
    return resultText;
  } catch (error) {
    console.error(`\u0045\u0072\u0072\u006f\u0072\u003a`, error);
    sendLog(`\u751f\u6210\u8bc4\u8bba\u9519\u8bef` + error);
  }
}
const store$8 = UseCounterStore.getInstance();
const VITE_PLUGIN_ID = `\u0078\u0069\u0061\u006f\u0073\u0068\u0075\u0074\u0069\u0061\u006f\u002d\u0061\u0075\u0074\u006f\u006d\u0061\u0074\u0069\u0063\u002d\u0072\u0065\u0076\u0069\u0065\u0077\u0073`;
function checkDomPromises(selectors, element = void 0, maxNum = 60, timeout = 1e3) {
  let num = 0;
  return new Promise(resolve => {
    const checkInterval2 = setInterval(() => {
      try {
        console.log(`\u6b63\u5728\u67e5\u627e\uff1a` + selectors);
        sendLog(`\u6b63\u5728\u67e5\u627e\uff1a` + selectors);
        if (!element) {
          element = document;
        }
        if (!element) {
          clearInterval(checkInterval2);
          return;
        }
        let in_bool = false;
        for (const selector of selectors) {
          const loginContainer = element.querySelector(selector);
          if (loginContainer) {
            in_bool = true;
            break;
          }
        }
        if (in_bool || num > maxNum) {
          if (num > maxNum) {
            console.error(`\u67e5\u627e\u8d85\u65f6`);
            sendLog(`\u67e5\u627e\u8d85\u65f6\uff1a` + selectors);
            resolve(false);
          } else {
            resolve(true);
            console.log(`\u67e5\u627e\u5b8c\u6210\uff1a` + selectors);
            sendLog(`\u67e5\u627e\u5b8c\u6210\uff1a` + selectors);
          }
          clearInterval(checkInterval2);
        }
        num++;
      } catch (e) {
        console.error(e);
      }
    }, timeout);
  });
}
function checkDomPromise(selectors, element = void 0, maxNum = 60, timeout = 1e3) {
  let num = 0;
  return new Promise(resolve => {
    const checkInterval2 = setInterval(() => {
      try {
        console.log(`\u6b63\u5728\u67e5\u627e\uff1a` + selectors);
        sendLog(`\u6b63\u5728\u67e5\u627e\uff1a` + selectors);
        if (!element) {
          element = document;
        }
        if (!element) {
          clearInterval(checkInterval2);
          return;
        }
        const loginContainer = element.querySelector(selectors);
        if (loginContainer || num > maxNum) {
          if (num > maxNum) {
            console.error(`\u67e5\u627e\u8d85\u65f6`);
            sendLog(`\u67e5\u627e\u8d85\u65f6\uff1a` + selectors);
            resolve(false);
          } else {
            resolve(true);
            console.log(`\u67e5\u627e\u5b8c\u6210\uff1a` + selectors);
            sendLog(`\u67e5\u627e\u5b8c\u6210\uff1a` + selectors);
          }
          clearInterval(checkInterval2);
        }
        num++;
      } catch (e) {
        console.error(e);
      }
    }, timeout);
  });
}
function checkDomByDom(element, maxNum = 60, timeout = 1e3) {
  let num = 0;
  return new Promise(resolve => {
    const checkInterval2 = setInterval(() => {
      try {
        console.log(`\u6b63\u5728\u67e5\u627e\uff1a`);
        sendLog(`\u6b63\u5728\u67e5\u627e\uff1a`);
        if (document.documentElement.contains(element) || num > maxNum) {
          if (num > maxNum) {
            console.error(`\u67e5\u627e\u8d85\u65f6`);
            sendLog(`\u67e5\u627e\u8d85\u65f6\uff1a`);
            resolve(false);
          } else {
            resolve(true);
            console.log(`\u67e5\u627e\u5b8c\u6210\uff1a`);
            sendLog(`\u67e5\u627e\u5b8c\u6210\uff1a`);
          }
          clearInterval(checkInterval2);
        }
        num++;
      } catch (e) {
        console.error(`\u0063\u0068\u0065\u0063\u006b\u0044\u006f\u006d\u0042\u0079\u0044\u006f\u006d`, e);
      }
    }, timeout);
  });
}
function delay(ms) {
  return new Promise(resolve => setTimeout(resolve, ms));
}
function isWithinProbability(probability) {
  if (probability < 1 || probability > 100) {
    throw new Error(`\u6982\u7387\u5fc5\u987b\u5728\u0031\u5230\u0031\u0030\u0030\u4e4b\u95f4`);
  }
  const randomValue = Math.floor(Math.random() * 100) + 1;
  return randomValue <= probability;
}
function getRandomNumberInRange(start, max) {
  if (start > max) {
    throw new Error(`\u5f00\u59cb\u6570\u5b57\u4e0d\u80fd\u5927\u4e8e\u6700\u5927\u6570\u5b57`);
  }
  return Math.floor(Math.random() * (max - start + 1)) + start;
}
function isElementInViewport(element, container = document.documentElement) {
  if (!container) {
    container = document.documentElement;
  }
  const elementRect = element.getBoundingClientRect();
  const containerRect = container.getBoundingClientRect();
  return elementRect.top >= containerRect.top && elementRect.bottom <= containerRect.bottom && elementRect.left >= containerRect.left && elementRect.right <= containerRect.right;
}
function ensureElementVisible(element, container = document.documentElement) {
  if (!container) {
    container = document.documentElement;
  }
  if (!isElementInViewport(element, container)) {
    element.scrollIntoView({
      behavior: `\u0073\u006d\u006f\u006f\u0074\u0068`,
      block: `\u0073\u0074\u0061\u0072\u0074`
    });
    return true;
  }
  return false;
}
function isElementInViewport2(element) {
  const rect = element.getBoundingClientRect();
  return rect.top >= 0 && rect.left >= 0 && rect.bottom <= (window.innerHeight || document.documentElement.clientHeight) && rect.right <= (window.innerWidth || document.documentElement.clientWidth);
}
function ensureElementVisible2(element) {
  if (!isElementInViewport2(element)) {
    element.scrollIntoView({
      behavior: `\u0073\u006d\u006f\u006f\u0074\u0068`,
      block: `\u0073\u0074\u0061\u0072\u0074`
    });
    return true;
  }
  return false;
}
async function ensureElementVisible3(element, offset = 0) {
  if (!isElementInViewport2(element)) {
    const rect = element.getBoundingClientRect();
    const scrollY = window.scrollY || document.documentElement.scrollTop;
    const topPosition = rect.top + scrollY - offset;
    window.scrollTo({
      top: topPosition,
      behavior: `\u0073\u006d\u006f\u006f\u0074\u0068`
    });
    await delay(1e3);
    return true;
  }
  return false;
}
function sendLog(...messages) {
  const combinedMessage = messages.map(String).join(`\u0020`);
  {
    chrome.runtime.sendMessage({
      action: `\u006c\u006f\u0067\u0073`,
      message: combinedMessage
    }, {
      includeTlsChannelId: false
    });
  }
}
function formatNowDateTimeSss() {
  const date = /* @__PURE__ */new Date();
  const year = date.getFullYear();
  const month = String(date.getMonth() + 1).padStart(2, `\u0030`);
  const day = String(date.getDate()).padStart(2, `\u0030`);
  const hours = String(date.getHours()).padStart(2, `\u0030`);
  const minutes = String(date.getMinutes()).padStart(2, `\u0030`);
  const seconds = String(date.getSeconds()).padStart(2, `\u0030`);
  const milliseconds = String(date.getMilliseconds()).padStart(3, `\u0030`);
  return `${year}\u002d${month}\u002d${day}\u0020${hours}\u003a${minutes}\u003a${seconds}\u002e${milliseconds}`;
}
function sendCloseTab(tag) {
  sendLog(`\u0073\u0065\u006e\u0064\u0043\u006c\u006f\u0073\u0065\u0054\u0061\u0062\u0020\u0074\u0061\u0067\uff1a` + tag);
  chrome.runtime.sendMessage({
    action: `\u0063\u006c\u006f\u0073\u0065\u0054\u0061\u0062`,
    tag
  }, {
    includeTlsChannelId: false
  }, () => {
    console.info(`\u0063\u006c\u006f\u0073\u0065\u0054\u0061\u0062`);
  });
}
const saveReportData = async () => {
  console.log(`\u0073\u0061\u0076\u0065\u0052\u0065\u0070\u006f\u0072\u0074\u0044\u0061\u0074\u0061`);
  const date = /* @__PURE__ */new Date();
  const year = date.getFullYear();
  const month = String(date.getMonth() + 1).padStart(2, `\u0030`);
  const day = String(date.getDate()).padStart(2, `\u0030`);
  const hours = String(date.getHours()).padStart(2, `\u0030`);
  const minutes = String(date.getMinutes()).padStart(2, `\u0030`);
  const addDate = `${year}\u002d${month}\u002d${day}\u0020${hours}\u003a${minutes}`;
  const saveInputs = {
    "key": store$8.userId + `\u005f` + store$8.taskId,
    "bucket": {
      XiaoHongShu_Setting: store$8.XiaoHongShu_Setting,
      // //评论数量
      // XiaoHongShu_viewCount: store.XiaoHongShu_viewCount,
      // XiaoHongShu_CommentCount:store.XiaoHongShu_CommentCount,
      // XiaoHongShu_likeCount:store.XiaoHongShu_likeCount,
      // XiaoHongShu_followCount:store.XiaoHongShu_followCount,
      // XiaoHongShu_collectCount:store.XiaoHongShu_collectCount,
      //评论数量
      xhs_viewCount: store$8.xhs_viewCount,
      xhs_CommentCount: store$8.xhs_CommentCount,
      xhs_likeCount: store$8.xhs_likeCount,
      xhs_followCount: store$8.xhs_followCount,
      xhs_collectCount: store$8.xhs_collectCount,
      //评论数量
      dy_viewCount: store$8.dy_viewCount,
      dy_CommentCount: store$8.dy_CommentCount,
      dy_likeCount: store$8.dy_likeCount,
      dy_followCount: store$8.dy_followCount,
      dy_collectCount: store$8.dy_collectCount,
      executeOperationStartTime: store$8.executeOperationStartTime,
      executeOperationEndTime: store$8.executeOperationEndTime,
      //小红书 关键词 列表
      xhs_keywords_list: store$8.xhs_keywords_list,
      douYin_keywords_list: store$8.douYin_keywords_list,
      xhs_minute: store$8.xhs_minute,
      dy_minute: store$8.dy_minute,
      taskId: store$8.taskId,
      addDate,
      addTime: (/* @__PURE__ */new Date()).getTime()
    },
    "size": 0,
    "content_type": ``,
    "belong_to": store$8.userId + `\u005f\u0063\u006f\u006d\u006d\u0065\u006e\u0074\u005f\u0077\u006f\u0072\u006b\u005f\u0064\u0065\u0074\u0061\u0069\u006c`,
    "object_metadata": {}
  };
  await saveComment$1(saveInputs);
};
let closeEndBool = false;
const closeEndFun = async tag => {
  sendLog(`\u0063\u006c\u006f\u0073\u0065\u0045\u006e\u0064\u0046\u0075\u006e\u0020\u0073\u0074\u006f\u0072\u0065\u002e\u0075\u0073\u0065\u0072\u0049\u006e\u0066\u006f\u0045\u006e\u0064\u0044\u0061\u0074\u0065\u003a`, store$8.userInfoEndDate, tag);
  if (store$8.userInfoEndDate) {
    try {
      await saveReportData();
      await chrome.storage.local.set({
        "optionsPageName": `\u0072\u0075\u006e\u0045\u0063\u0068\u0061\u0072\u0074\u0073\u0052\u0065\u0070\u006f\u0072\u0074`
      });
    } catch (error) {
      sendLog(`\u006f\u0070\u0065\u006e\u004f\u0070\u0074\u0069\u006f\u006e\u0073\u0050\u0061\u0067\u0065\u0020\u0065\u0072\u0072\u006f\u0072` + error);
    }
  }
  if (closeEndBool) {
    sendLog(`\u0063\u006c\u006f\u0073\u0065\u0045\u006e\u0064\u0042\u006f\u006f\u006c\u003a`, closeEndBool, tag);
    return sendCloseTab(tag);
  }
  closeEndBool = true;
  store$8.setExecuteOperationEndTime((/* @__PURE__ */new Date()).getTime());
  const task_execution_time = store$8.executeOperationEndTime - store$8.executeOperationStartTime;
  const postData = {
    "app_id": VITE_PLUGIN_ID,
    "client_id": store$8.clientVisitorId,
    "event": `\u0074\u0061\u0073\u006b\u005f\u0065\u0078\u0065\u0063\u0075\u0074\u0069\u006f\u006e\u005f\u0074\u0069\u006d\u0065`,
    "category": ``,
    "data": {
      "task_execution_time": task_execution_time
    },
    "data_type": ``,
    "description": ``
  };
  try {
    await putBurialPoint(postData);
  } catch (error) {
    sendLog(`\u0070\u0075\u0074\u0042\u0075\u0072\u0069\u0061\u006c\u0050\u006f\u0069\u006e\u0074\u0020\u0065\u0072\u0072\u006f\u0072` + error);
  }
  sendCloseTab(tag);
};
const vipCloseEndFun = async tag => {
  if (store$8.closeStop) {
    return;
  }
  store$8.setCloseStop(true);
  if (store$8.userInfoEndDate) {
    closeEndFun(`\u0063\u006c\u006f\u0073\u0065\u0054\u0061\u0062\u004c\u0069\u0073\u0074\u0065\u006e\u0065\u0072`).then(() => {});
  } else {
    closeEndFun(tag).then(() => {});
  }
};
function closeTabListener() {
  const callBackListener = (changes, namespace) => {
    for (let [key, {
      oldValue,
      newValue
    }] of Object.entries(changes)) {
      console.log(`\u0053\u0074\u006f\u0072\u0061\u0067\u0065\u0020\u006b\u0065\u0079\u0020\u0022${key}\u0022\u0020\u0069\u006e\u0020\u006e\u0061\u006d\u0065\u0073\u0070\u0061\u0063\u0065\u0020\u0022${namespace}\u0022\u0020\u0063\u0068\u0061\u006e\u0067\u0065\u0064\u002e`, `\u004f\u006c\u0064\u0020\u0076\u0061\u006c\u0075\u0065\u0020\u0077\u0061\u0073\u0020\u0022${oldValue}\u0022\u002c\u0020\u006e\u0065\u0077\u0020\u0076\u0061\u006c\u0075\u0065\u0020\u0069\u0073\u0020\u0022${newValue}\u0022\u002e`);
      sendLog(`\u0053\u0074\u006f\u0072\u0061\u0067\u0065\u0020\u006b\u0065\u0079\u0020\u0022${key}\u0022\u0020\u0069\u006e\u0020\u006e\u0061\u006d\u0065\u0073\u0070\u0061\u0063\u0065\u0020\u0022${namespace}\u0022\u0020\u0063\u0068\u0061\u006e\u0067\u0065\u0064\u002e\u004f\u006c\u0064\u0020\u0076\u0061\u006c\u0075\u0065\u0020\u0077\u0061\u0073\u0020\u0022${oldValue}\u0022\u002c\u0020\u006e\u0065\u0077\u0020\u0076\u0061\u006c\u0075\u0065\u0020\u0069\u0073\u0020\u0022${newValue}\u0022\u002e`);
      switch (key) {
        case `\u0061\u0063\u0074\u0069\u0076\u0061\u0074\u0065\u0050\u0061\u0067\u0065`:
          if (store$8.closeStop) {
            return;
          }
          store$8.setCloseStop(true);
          sendLog(`\u0073\u0074\u006f\u0072\u0065\u002e\u0075\u0073\u0065\u0072\u0049\u006e\u0066\u006f\u0045\u006e\u0064\u0044\u0061\u0074\u0065\u003a`, store$8.userInfoEndDate, `\uff0c\u0072\u0065\u0070\u006f\u0072\u0074\u0050\u0061\u0067\u0065\u0073\u003a`, JSON.stringify(reportPages), `\uff0c\u0073\u0074\u006f\u0072\u0065\u002e\u0061\u0063\u0074\u0069\u0076\u0061\u0074\u0065\u0050\u0061\u0067\u0065`, store$8.activatePage, `\uff0c\u0072\u0065\u0070\u006f\u0072\u0074\u0050\u0061\u0067\u0065\u0073\u002e\u0069\u006e\u0063\u006c\u0075\u0064\u0065\u0073\u0028\u0073\u0074\u006f\u0072\u0065\u002e\u0061\u0063\u0074\u0069\u0076\u0061\u0074\u0065\u0050\u0061\u0067\u0065\u0029\uff1a`, reportPages.includes(store$8.activatePage));
          if (store$8.userInfoEndDate && reportPages.includes(store$8.activatePage)) {
            closeEndFun(`\u0063\u006c\u006f\u0073\u0065\u0054\u0061\u0062\u004c\u0069\u0073\u0074\u0065\u006e\u0065\u0072`).then(() => {});
          } else {
            closeEndFun(`\u0063\u006c\u006f\u0073\u0065\u0054\u0061\u0062\u004c\u0069\u0073\u0074\u0065\u006e\u0065\u0072\u0020\u006e\u006f\u0074\u0020\u0072\u0065\u0070\u006f\u0072\u0074`).then(() => {});
          }
      }
    }
  };
  storageUtil.removeListener(callBackListener);
  storageUtil.addHandlers(callBackListener);
}
function getLastPathName$1(pathname) {
  if (pathname) {
    const extra_image_ids = pathname.split(`\u002f`);
    if (extra_image_ids && extra_image_ids.length > 0) {
      pathname = extra_image_ids[extra_image_ids.length - 1];
      return pathname.replace(/!.*$/, ``);
    }
  }
  return pathname;
}
function getTabTaskData() {
  return new Promise(resolve => {
    chrome.runtime.sendMessage({
      action: `\u0067\u0065\u0074\u0054\u0061\u0062\u0054\u0061\u0073\u006b\u0044\u0061\u0074\u0061`
    }, {
      includeTlsChannelId: false
    }, response => {
      if (response && response.tabId) {
        console.log(`\u0043\u0075\u0072\u0072\u0065\u006e\u0074\u0020\u0054\u0061\u0062\u0020\u0049\u0044\u003a`, response.tabId);
        resolve(response);
      } else {
        console.error(`\u0046\u0061\u0069\u006c\u0065\u0064\u0020\u0074\u006f\u0020\u0067\u0065\u0074\u0020\u0074\u0061\u0062\u0020\u0049\u0044\u002e`);
        resolve({});
      }
    });
  });
}
function getActivateTabId() {
  return new Promise(resolve => {
    chrome.runtime.sendMessage({
      message: `\u0071\u0075\u0065\u0072\u0079\u0041\u0063\u0074\u0069\u0076\u0061\u0074\u0065\u0054\u0061\u0062`
    }, {
      includeTlsChannelId: false
    }, response => {
      if (response) {
        console.log(`\u0041\u0063\u0074\u0069\u0076\u0065\u0020\u0054\u0061\u0062\u0020\u0049\u0044\u003a`, response.tabId);
        console.log(`\u0041\u0063\u0074\u0069\u0076\u0065\u0020\u0054\u0061\u0062\u0020\u0055\u0052\u004c\u003a`, response.url);
        resolve(response.tabId);
      } else {
        console.error(`\u0046\u0061\u0069\u006c\u0065\u0064\u0020\u0074\u006f\u0020\u0067\u0065\u0074\u0020\u0074\u0061\u0062\u0020\u0069\u006e\u0066\u006f\u0072\u006d\u0061\u0074\u0069\u006f\u006e\u002e`);
        resolve(0);
      }
    });
  });
}
function simulateInputSendMessage(content, interval_time_out = 200, checkFocus = false, keyDown = true) {
  return new Promise(resolve => {
    chrome.runtime.sendMessage({
      action: `\u0069\u006e\u0070\u0075\u0074\u004b\u0065\u0079`,
      "content": content,
      checkFocus,
      // ture: keyDown，
      // false: 使用\n
      keyDown,
      interval_time_out
    }, {
      includeTlsChannelId: false
    }).then(() => {}).finally(() => {
      resolve();
    });
  });
}
function simulateInput(content, content_textarea, interval_time_out = 200) {
  return new Promise(resolve => {
    let index = 0;
    let intervalId = setInterval(() => {
      if (index < content.length) {
        if (content_textarea instanceof HTMLTextAreaElement) {
          content_textarea.value += content[index];
        } else if (content_textarea instanceof HTMLElement) {
          content_textarea.innerText += content[index];
        }
        let input_event = new Event(`\u0069\u006e\u0070\u0075\u0074`, {
          bubbles: true,
          cancelable: true
        });
        content_textarea.dispatchEvent(input_event);
        index++;
      } else {
        clearInterval(intervalId);
        resolve();
      }
    }, interval_time_out);
  });
}
function queryLastTime() {
  return new Promise(resolve => {
    console.info(`\u0071\u0075\u0065\u0072\u0079\u004c\u0061\u0073\u0074\u0054\u0069\u006d\u0065`);
    chrome.runtime.sendMessage({
      action: store$8.chromeTabId + `\u005f\u0071\u0075\u0065\u0072\u0079\u004c\u0061\u0073\u0074\u0054\u0069\u006d\u0065`
    }, {
      includeTlsChannelId: false
    }, res => {
      console.info(`\u0071\u0075\u0065\u0072\u0079\u004c\u0061\u0073\u0074\u0054\u0069\u006d\u0065`, res);
      store$8.setOperationTime(res);
      resolve(res);
    });
  });
}
async function click_button(targetElement) {
  const content_edit_rect = targetElement.getBoundingClientRect();
  const content_edit_x = content_edit_rect.left + content_edit_rect.width / 2;
  const content_edit_y = content_edit_rect.top + content_edit_rect.height / 2;
  const clickEvents = [`\u006d\u006f\u0075\u0073\u0065\u006f\u0076\u0065\u0072`, `\u006d\u006f\u0075\u0073\u0065\u0064\u006f\u0077\u006e`, `\u006d\u006f\u0075\u0073\u0065\u0075\u0070`, `\u0063\u006c\u0069\u0063\u006b`];
  clickEvents.forEach(async eventType => {
    const event = new MouseEvent(eventType, {
      view: window,
      bubbles: true,
      cancelable: true,
      button: 0,
      clientX: content_edit_x,
      clientY: content_edit_y
    });
    targetElement.dispatchEvent(event);
    await delay(100);
  });
}
async function hover_button(hoverEl) {
  if (!hoverEl) {
    console.error(`\u9519\u8bef\uff0c\u91cd\u65b0\u5f00\u59cb`);
    sendLog(`\u6ca1\u6709\u627e\u5230\u0020\u9009\u62e9\u8fc7\u6ee4`);
    return;
  }
  const rect = hoverEl.getBoundingClientRect();
  const x = rect.left + rect.width / 2;
  const y = rect.top + rect.height / 2;
  console.log(`\u0078\u002c\u0079`, rect, x, y);
  const mouseOverEvent = new MouseEvent(`\u006d\u006f\u0075\u0073\u0065\u006f\u0076\u0065\u0072`, {
    view: window,
    bubbles: true,
    cancelable: true,
    clientX: x,
    clientY: y
  });
  hoverEl.dispatchEvent(mouseOverEvent);
  const mouseMoveEvent = new MouseEvent(`\u006d\u006f\u0075\u0073\u0065\u006d\u006f\u0076\u0065`, {
    view: window,
    bubbles: true,
    cancelable: true,
    clientX: x,
    clientY: y
  });
  hoverEl.dispatchEvent(mouseMoveEvent);
  const mouseEnterEvent = new MouseEvent(`\u006d\u006f\u0075\u0073\u0065\u0065\u006e\u0074\u0065\u0072`, {
    view: window,
    bubbles: true,
    cancelable: true,
    clientX: x,
    clientY: y
  });
  hoverEl.dispatchEvent(mouseEnterEvent);
}
async function getKeywordsIntelligentAssociation(title_texts, searchWord) {
  console.log(`\u0074\u0069\u0074\u006c\u0065\u005f\u0074\u0065\u0078\u0074\u0073`, title_texts);
  let test_text = ``;
  for (let i = 0; i < title_texts.length; i++) {
    if (test_text) {
      test_text += `\u000a`;
    }
    test_text += i + 1 + `\u3001` + title_texts[i];
  }
  const inputs_comment = {
    keyword: searchWord,
    test: test_text
  };
  const files_comment = [];
  const resultText = await keywordsIntelligentAssociation(inputs_comment, files_comment);
  console.log(`\u0072\u0065\u0073\u0075\u006c\u0074\u0054\u0065\u0078\u0074`, resultText);
  if (resultText) {
    if (resultText.includes(`\u3001`)) {
      return resultText.split(`\u3001`);
    }
    if (resultText.includes(`\u002c`)) {
      return resultText.split(`\u002c`);
    }
    if (resultText.includes(`\uff0c`)) {
      return resultText.split(`\uff0c`);
    }
  }
  return [];
}
function nowDate() {
  const date = /* @__PURE__ */new Date();
  const year = date.getFullYear();
  const month = String(date.getMonth() + 1).padStart(2, `\u0030`);
  const day = String(date.getDate()).padStart(2, `\u0030`);
  return `${year}\u002d${month}\u002d${day}`;
}
const checkXiaoHongShuAccountRunNum = async (platform, xiaoHongShuAccountId) => {
  switch (store$8.userInfoEndDate) {
    case `\u65b0\u624b`:
      store$8.xiaoHongShuAccountRunTodayMaxNum = 1;
      break;
    case `\u6807\u51c6`:
      store$8.xiaoHongShuAccountRunTodayMaxNum = 1;
      break;
    case `\u9ad8\u7ea7`:
      store$8.xiaoHongShuAccountRunTodayMaxNum = 3;
      break;
    default:
      return true;
  }
  const nowDateString = nowDate();
  const key = store$8.userId + `\u005f` + platform + `\u005f\u0041\u0063\u0063\u006f\u0075\u006e\u0074\u0052\u0075\u006e\u004e\u0075\u006d`;
  if (!store$8.getXiaoHongShuAccountRunTodayDate(platform)) {
    const res = await getXiaoHongShuAccountRunTodayNum(store$8.accessToken, key, store$8.userId);
    console.log(`\u0067\u0065\u0074\u0058\u0069\u0061\u006f\u0048\u006f\u006e\u0067\u0053\u0068\u0075\u0041\u0063\u0063\u006f\u0075\u006e\u0074\u0052\u0075\u006e\u0054\u006f\u0064\u0061\u0079\u004e\u0075\u006d\u0020\u0072\u0065\u0073`, res, store$8.getXiaoHongShuAccountRunTodayDate(platform));
    if (res && res[`\u0062\u0075\u0063\u006b\u0065\u0074`]) {
      if (res[`\u0062\u0075\u0063\u006b\u0065\u0074`][`\u0078\u0069\u0061\u006f\u0048\u006f\u006e\u0067\u0053\u0068\u0075\u0041\u0063\u0063\u006f\u0075\u006e\u0074\u0049\u0064\u0073`]) {
        if (res[`\u0062\u0075\u0063\u006b\u0065\u0074`][`\u0078\u0069\u0061\u006f\u0048\u006f\u006e\u0067\u0053\u0068\u0075\u0041\u0063\u0063\u006f\u0075\u006e\u0074\u0049\u0064\u0073`] instanceof Set) {
          store$8.setXiaoHongShuAccountRunTodayIds(platform, res[`\u0062\u0075\u0063\u006b\u0065\u0074`][`\u0078\u0069\u0061\u006f\u0048\u006f\u006e\u0067\u0053\u0068\u0075\u0041\u0063\u0063\u006f\u0075\u006e\u0074\u0049\u0064\u0073`]);
        } else if (res[`\u0062\u0075\u0063\u006b\u0065\u0074`][`\u0078\u0069\u0061\u006f\u0048\u006f\u006e\u0067\u0053\u0068\u0075\u0041\u0063\u0063\u006f\u0075\u006e\u0074\u0049\u0064\u0073`] instanceof Array) {
          const xiaoHongShuAccountSet = new Set(res[`\u0062\u0075\u0063\u006b\u0065\u0074`][`\u0078\u0069\u0061\u006f\u0048\u006f\u006e\u0067\u0053\u0068\u0075\u0041\u0063\u0063\u006f\u0075\u006e\u0074\u0049\u0064\u0073`]);
          store$8.setXiaoHongShuAccountRunTodayIds(platform, xiaoHongShuAccountSet);
        } else if (typeof res[`\u0062\u0075\u0063\u006b\u0065\u0074`][`\u0078\u0069\u0061\u006f\u0048\u006f\u006e\u0067\u0053\u0068\u0075\u0041\u0063\u0063\u006f\u0075\u006e\u0074\u0049\u0064\u0073`] === `\u0073\u0074\u0072\u0069\u006e\u0067`) {
          const xiaoHongShuAccountSet = new Set(JSON.parse(res[`\u0062\u0075\u0063\u006b\u0065\u0074`][`\u0078\u0069\u0061\u006f\u0048\u006f\u006e\u0067\u0053\u0068\u0075\u0041\u0063\u0063\u006f\u0075\u006e\u0074\u0049\u0064\u0073`]));
          store$8.setXiaoHongShuAccountRunTodayIds(platform, xiaoHongShuAccountSet);
        }
      } else {
        store$8.setXiaoHongShuAccountRunTodayIds(platform, /* @__PURE__ */new Set());
      }
      store$8.setXiaoHongShuAccountRunTodayDate(platform, res[`\u0062\u0075\u0063\u006b\u0065\u0074`][`\u0072\u0075\u006e\u0054\u006f\u0064\u0061\u0079\u0044\u0061\u0074\u0065`]);
    } else {
      store$8.increment_XiaoHongShuAccountRunTodayIds(platform, xiaoHongShuAccountId);
      store$8.setXiaoHongShuAccountRunTodayDate(platform, nowDateString);
      const postData2 = {
        "key": key,
        "bucket": {
          xiaoHongShuAccountIds: JSON.stringify(Array.from(store$8.getXiaoHongShuAccountRunTodayIds(platform))),
          runTodayDate: nowDateString
        },
        "size": 0,
        "content_type": ``,
        "belong_to": store$8.userId,
        "object_metadata": {}
      };
      await setXiaoHongShuAccountRunTodayNum(store$8.accessToken, postData2);
      return true;
    }
  }
  if (store$8.getXiaoHongShuAccountRunTodayDate(platform) != nowDateString) {
    store$8.setXiaoHongShuAccountRunTodayIds(platform, /* @__PURE__ */new Set());
    store$8.increment_XiaoHongShuAccountRunTodayIds(platform, xiaoHongShuAccountId);
    store$8.setXiaoHongShuAccountRunTodayDate(platform, nowDateString);
    const postData2 = {
      "key": key,
      "bucket": {
        xiaoHongShuAccountIds: JSON.stringify(Array.from(store$8.getXiaoHongShuAccountRunTodayIds(platform))),
        runTodayDate: nowDateString
      },
      "size": 0,
      "content_type": ``,
      "belong_to": store$8.userId,
      "object_metadata": {}
    };
    await setXiaoHongShuAccountRunTodayNum(store$8.accessToken, postData2);
    return true;
  }
  const newSet = new Set(store$8.getXiaoHongShuAccountRunTodayIds(platform));
  newSet.add(xiaoHongShuAccountId);
  if (newSet.size > store$8.xiaoHongShuAccountRunTodayMaxNum) {
    sendLog(`\u8d85\u8fc7\u6bcf\u65e5\u514d\u8d39\u6700\u5927\u6b21\u6570\u003a` + store$8.getXiaoHongShuAccountRunTodayIds(platform));
    store$8.setXiaoHongShuAccountErrorTip(`\u8d26\u53f7\u592a\u591a\u4e86\u002c\u5c0f\u85af\u6761\u6709\u70b9\u7d2f\u4e86\u3002\u8bf7\u660e\u65e5\u518d\u8bd5\u002c\u8be6\u60c5\u8bf7\u54a8\u8be2\u5ba2\u670d\u3002`);
    return false;
  }
  const oldSize = store$8.getXiaoHongShuAccountRunTodayIds(platform).size;
  store$8.increment_XiaoHongShuAccountRunTodayIds(platform, xiaoHongShuAccountId);
  if (oldSize == store$8.getXiaoHongShuAccountRunTodayIds(platform).size) {
    sendLog(`\u6ca1\u6709\u65b0\u589e\u8d26\u53f7\uff0c\u4e0d\u505a\u4fee\u6539`);
    return true;
  }
  store$8.setXiaoHongShuAccountRunTodayDate(platform, nowDateString);
  const postData = {
    "key": key,
    "bucket": {
      xiaoHongShuAccountIds: JSON.stringify(Array.from(store$8.getXiaoHongShuAccountRunTodayIds(platform))),
      runTodayDate: nowDateString
    },
    "size": 0,
    "content_type": ``,
    "belong_to": store$8.userId,
    "object_metadata": {}
  };
  await setXiaoHongShuAccountRunTodayNum(store$8.accessToken, postData);
  return true;
};
function getNoteData(message) {
  return new Promise(resolve => {
    chrome.runtime.sendMessage(message, {
      includeTlsChannelId: false
    }, response => {
      console.log(`\u0067\u0065\u0074\u004e\u006f\u0074\u0065\u0044\u0061\u0074\u0061\u003a`, response);
      if (response) {
        resolve(response);
      } else {
        console.error(`\u0046\u0061\u0069\u006c\u0065\u0064\u0020\u0074\u006f\u0020\u0067\u0065\u0074\u0020\u0074\u0061\u0062\u0020\u0069\u006e\u0066\u006f\u0072\u006d\u0061\u0074\u0069\u006f\u006e\u002e`);
        resolve(null);
      }
    });
  });
}
const openNewWindowNote = message => {
  return () => new Promise(async resolve => {
    const windowData = await getNoteData(message);
    let checkIfTabExistsSetInterval = null;
    if (windowData.tabId) {
      checkIfTabExistsSetInterval = setInterval(() => {
        chrome.runtime.sendMessage({
          action: `\u0063\u0068\u0065\u0063\u006b\u0049\u0066\u0054\u0061\u0062\u0045\u0078\u0069\u0073\u0074\u0073`,
          tabId: windowData.tabId
        }, {
          includeTlsChannelId: false
        }, response => {
          if (response && !response.tabExists) {
            clearInterval(checkIfTabExistsSetInterval);
            storageUtil.removeListener(changedCallBack);
            resolve();
          } else {
            console.error(`\u7a97\u53e3\u8fd8\u5b58\u5728`);
          }
        });
        chrome.runtime.sendMessage({
          action: `\u0063\u0068\u0065\u0063\u006b\u0054\u0061\u0073\u006b\u0043\u006f\u006d\u0070\u006c\u0065\u0074\u0065`,
          tabId: windowData.tabId
        }, {
          includeTlsChannelId: false
        }, response => {
          if (response && response.taskComplete) {
            clearInterval(checkIfTabExistsSetInterval);
            storageUtil.removeListener(changedCallBack);
            resolve();
          } else {
            console.error(`\u4efb\u52a1\u8fd8\u6ca1\u6709\u5b8c\u6210`);
          }
        });
      }, 60 * 1e3);
    }
    const changedCallBack = (changes, namespace) => {
      for (let [key, {
        oldValue,
        newValue
      }] of Object.entries(changes)) {
        console.log(`\u0053\u0074\u006f\u0072\u0061\u0067\u0065\u0020\u006b\u0065\u0079\u0020\u0022${key}\u0022\u0020\u0069\u006e\u0020\u006e\u0061\u006d\u0065\u0073\u0070\u0061\u0063\u0065\u0020\u0022${namespace}\u0022\u0020\u0063\u0068\u0061\u006e\u0067\u0065\u0064\u002e`, `\u004f\u006c\u0064\u0020\u0076\u0061\u006c\u0075\u0065\u0020\u0077\u0061\u0073\u0020\u0022${oldValue}\u0022\u002c\u0020\u006e\u0065\u0077\u0020\u0076\u0061\u006c\u0075\u0065\u0020\u0069\u0073\u0020\u0022${newValue}\u0022\u002e`);
        switch (key) {
          case `\u0074\u0061\u0073\u006b\u0043\u006f\u006d\u0070\u006c\u0065\u0074\u0065\u0044\u0061\u0074\u0061`:
            if (newValue) {
              try {
                const newValueJson = JSON.parse(newValue);
                if (newValueJson[windowData.tabId]) {
                  chrome.runtime.sendMessage({
                    action: `\u0063\u0075\u0072\u0072\u0065\u006e\u0074\u0041\u0063\u0074\u0069\u0076\u0061\u0074\u0065\u0054\u0061\u0062`
                  }, {
                    includeTlsChannelId: false
                  }, res => {
                    console.info(`\u0063\u0075\u0072\u0072\u0065\u006e\u0074\u0041\u0063\u0074\u0069\u0076\u0061\u0074\u0065\u0054\u0061\u0062`, res);
                  });
                  clearInterval(checkIfTabExistsSetInterval);
                  storageUtil.removeListener(changedCallBack);
                  resolve();
                } else {
                  console.log(`\u4e0d\u5b58\u5728\u8fd9\u4e2a\u0074\u0061\u0062\u0049\u0064`, windowData.tabId, newValue);
                }
              } catch (e) {
                console.log(`\u006e\u0065\u0077\u0056\u0061\u006c\u0075\u0065\u004a\u0073\u006f\u006e\u0020\u0065\u0072\u0072\u006f\u0072`, newValue);
              }
            } else {
              console.log(`\u0074\u0061\u0073\u006b\u0043\u006f\u006d\u0070\u006c\u0065\u0074\u0065\u0044\u0061\u0074\u0061\u0020\u006e\u0065\u0077\u0056\u0061\u006c\u0075\u0065\u0020\u4e3a\u7a7a`);
            }
            break;
          case `\u0044\u006f\u006e\u0065\u004e\u006f\u0074\u0065\u0049\u0064`:
            if (newValue == windowData.tabId) {
              clearInterval(checkIfTabExistsSetInterval);
              storageUtil.removeListener(changedCallBack);
              resolve();
            }
            break;
          case `\u0074\u0061\u0073\u006b\u0043\u006f\u006d\u0070\u006c\u0065\u0074\u0065`:
            if (newValue == windowData.tabId) {
              clearInterval(checkIfTabExistsSetInterval);
              storageUtil.removeListener(changedCallBack);
              resolve();
            }
            break;
        }
      }
    };
    storageUtil.removeListener(changedCallBack);
    storageUtil.addHandlers(changedCallBack);
  });
};
const extractPhoneNumbers = text => {
  const regex = /1[3-9]\d{9}/g;
  return text.match(regex) || [];
};
const setActiveElement = targetElement => {
  targetElement.focus();
  function findLastTextNode(node) {
    if (node.nodeType === Node.TEXT_NODE) {
      return node;
    }
    let lastTextNode2 = null;
    for (let i = 0; i < node.childNodes.length; i++) {
      const childTextNode = findLastTextNode(node.childNodes[i]);
      if (childTextNode) {
        lastTextNode2 = childTextNode;
      }
    }
    return lastTextNode2;
  }
  const lastTextNode = findLastTextNode(targetElement);
  if (lastTextNode) {
    const range = document.createRange();
    const selection = window.getSelection();
    range.setStart(lastTextNode, lastTextNode.length);
    range.setEnd(lastTextNode, lastTextNode.length);
    selection == null ? void 0 : selection.removeAllRanges();
    selection == null ? void 0 : selection.addRange(range);
  }
};
const queryActiveElement = (request2, sender2, sendResponse2, selectPath) => {
  console.log(`\u0071\u0075\u0065\u0072\u0079\u0041\u0063\u0074\u0069\u0076\u0065\u0045\u006c\u0065\u006d\u0065\u006e\u0074\u3002`, sender2, request2);
  if ((request2 == null ? void 0 : request2.messageType) === `\u0071\u0075\u0065\u0072\u0079\u0041\u0063\u0074\u0069\u0076\u0065\u0045\u006c\u0065\u006d\u0065\u006e\u0074`) {
    const textBox2List = Array.from(document.querySelectorAll(selectPath));
    if (textBox2List && textBox2List.length > 0) {
      const targetElement = textBox2List[0];
      setActiveElement(targetElement);
      sendResponse2(true);
    } else {
      sendResponse2(false);
    }
    return false;
  }
  if ((request2 == null ? void 0 : request2.messageType) === `\u0073\u0065\u0074\u0041\u0063\u0074\u0069\u0076\u0065\u0045\u006c\u0065\u006d\u0065\u006e\u0074`) {
    const textBox2List = Array.from(document.querySelectorAll(selectPath));
    if (textBox2List && textBox2List.length > 0) {
      const targetElement = textBox2List[0];
      setActiveElement(targetElement);
      sendResponse2(true);
    } else {
      sendResponse2(false);
    }
    return false;
  }
};
const store$7 = UseCounterStore.getInstance();
const baseURL = `\u0068\u0074\u0074\u0070\u0073\u003a\u002f\u002f\u0070\u006c\u0075\u0067\u0069\u006e\u002d\u0061\u0070\u0069\u002d\u0061\u0064\u006c\u0072\u0064\u006f\u006a\u0062\u0079\u0064\u002e\u0061\u0070\u002d\u006e\u006f\u0072\u0074\u0068\u0065\u0061\u0073\u0074\u002d\u0031\u002e\u0066\u0063\u0061\u0070\u0070\u002e\u0072\u0075\u006e`;
const dify_base_url = `\u0068\u0074\u0074\u0070\u0073\u003a\u002f\u002f\u0064\u0069\u0066\u0079\u002e\u0066\u0073\u006f\u0074\u006f\u006f\u006c\u002e\u0063\u006f\u006d`;
async function runWorkflow(inputs, files) {
  const url = dify_base_url + `\u002f\u0076\u0031\u002f\u0077\u006f\u0072\u006b\u0066\u006c\u006f\u0077\u0073\u002f\u0072\u0075\u006e`;
  const apiKey = `\u0061\u0070\u0070\u002d\u0045\u004c\u005a\u0047\u0055\u0076\u0069\u0042\u0072\u0075\u006b\u0076\u0058\u0045\u0075\u0043\u0077\u005a\u0043\u0061\u004e\u0078\u004b\u0036`;
  const headers = {
    "Authorization": `\u0042\u0065\u0061\u0072\u0065\u0072\u0020${apiKey}`,
    "Content-Type": `\u0061\u0070\u0070\u006c\u0069\u0063\u0061\u0074\u0069\u006f\u006e\u002f\u006a\u0073\u006f\u006e`
  };
  const data = {
    inputs,
    response_mode: `\u0062\u006c\u006f\u0063\u006b\u0069\u006e\u0067`,
    files,
    user: store$7.userId
  };
  try {
    const response = await fetch(url, {
      method: `\u0050\u004f\u0053\u0054`,
      headers,
      body: JSON.stringify(data)
    });
    if (!response.ok) {
      console.error(`\u0048\u0054\u0054\u0050\u0020\u0065\u0072\u0072\u006f\u0072\u0021\u0020\u0073\u0074\u0061\u0074\u0075\u0073\u003a\u0020${response.status}`);
      sendLog(`\u751f\u6210\u8bc4\u8bba\u9519\u8bef` + response.status);
      return;
    }
    const result = await response.json();
    let resultText = ``;
    if (result && result.data && result.data.outputs && result.data.outputs.result) {
      resultText = result.data.outputs.result;
    }
    console.log(`\u0072\u0065\u0073\u0075\u006c\u0074`, result);
    return resultText;
  } catch (error) {
    console.error(`\u0045\u0072\u0072\u006f\u0072\u003a`, error);
    sendLog(`\u751f\u6210\u8bc4\u8bba\u9519\u8bef` + error);
  }
}
async function queryComment(refer_id) {
  const url = baseURL + `\u002f\u0061\u0070\u0069\u002f\u0076\u0031\u002f\u0078\u0068\u0073\u005f\u0063\u006f\u006e\u0074\u0065\u006e\u0074\u0073\u002f${refer_id}`;
  const headers = {
    "Content-Type": `\u0061\u0070\u0070\u006c\u0069\u0063\u0061\u0074\u0069\u006f\u006e\u002f\u006a\u0073\u006f\u006e`,
    "Authorization": `\u0042\u0065\u0061\u0072\u0065\u0072\u0020` + store$7.accessToken
  };
  try {
    const response = await fetch(url, {
      method: `\u0047\u0045\u0054`,
      headers
    });
    if (!response.ok) {
      if (response.status === 404) {
        const result2 = await response.json();
        console.log(`\u0072\u0065\u0073\u0075\u006c\u0074`, result2);
        sendLog(`\u67e5\u8be2\u9519\u8bef\u0020\u0034\u0030\u0034` + (result2 == null ? void 0 : result2.detail) + `\u005f\u0072\u0065\u0066\u0065\u0072\u005f\u0069\u0064\u005f` + refer_id);
        if ((result2 == null ? void 0 : result2.detail) == `\u0058\u0068\u0073\u0043\u006f\u006e\u0074\u0065\u006e\u0074\u0020\u006e\u006f\u0074\u0020\u0066\u006f\u0075\u006e\u0064`) {
          return true;
        }
      }
      if (response.status === 401) {
        sendLog(`\u767b\u5f55\u5931\u6548`);
        store$7.setAccessToken(``);
      } else {
        const result2 = await response.json();
        console.log(`\u0072\u0065\u0073\u0075\u006c\u0074`, result2);
        sendLog(`\u67e5\u8be2\u9519\u8bef\u0020\u5176\u4ed6` + (result2 == null ? void 0 : result2.detail) + `\u005f\u0072\u0065\u0066\u0065\u0072\u005f\u0069\u0064\u005f` + refer_id);
      }
      console.error(`\u0048\u0054\u0054\u0050\u0020\u0065\u0072\u0072\u006f\u0072\u0021\u0020\u0073\u0074\u0061\u0074\u0075\u0073\u003a\u0020${response.status}`, response);
      return false;
    }
    const result = await response.json();
    console.log(`\u0072\u0065\u0073\u0075\u006c\u0074`, result);
    return false;
  } catch (error) {
    console.error(`\u0045\u0072\u0072\u006f\u0072\u003a`, error);
  }
  return false;
}
async function saveComment(saveData) {
  const url = baseURL + `\u002f\u0061\u0070\u0069\u002f\u0076\u0031\u002f\u0078\u0068\u0073\u005f\u0063\u006f\u006e\u0074\u0065\u006e\u0074\u0073`;
  const headers = {
    "Content-Type": `\u0061\u0070\u0070\u006c\u0069\u0063\u0061\u0074\u0069\u006f\u006e\u002f\u006a\u0073\u006f\u006e`,
    "Authorization": `\u0042\u0065\u0061\u0072\u0065\u0072\u0020` + store$7.accessToken
  };
  try {
    const response = await fetch(url, {
      method: `\u0050\u004f\u0053\u0054`,
      headers,
      body: JSON.stringify({
        "data": saveData
      })
    });
    if (!response.ok) {
      console.error(`\u0048\u0054\u0054\u0050\u0020\u0065\u0072\u0072\u006f\u0072\u0021\u0020\u0073\u0074\u0061\u0074\u0075\u0073\u003a\u0020${response.status}`, response);
      if (response.status === 401) {
        store$7.setAccessToken(``);
        sendLog(`\u767b\u5f55\u5931\u6548`);
      } else {
        const result2 = await response.json();
        console.log(`\u0072\u0065\u0073\u0075\u006c\u0074`, result2);
        sendLog(`\u4fdd\u5b58\u9519\u8bef\u0020\u5176\u4ed6` + (result2 == null ? void 0 : result2.detail));
      }
      return false;
    }
    const result = await response.json();
    console.log(`\u0072\u0065\u0073\u0075\u006c\u0074`, result);
    return true;
  } catch (error) {
    console.error(`\u0045\u0072\u0072\u006f\u0072\u003a`, error);
    sendLog(`\u4fdd\u5b58\u9519\u8bef\u0020\u5176\u4ed6` + error);
  }
  return false;
}
async function saveLikeFollows(saveData) {
  const url = baseURL + `\u002f\u0061\u0070\u0069\u002f\u0076\u0031\u002f\u0066\u006f\u006c\u006c\u006f\u0077\u0073`;
  const headers = {
    "Content-Type": `\u0061\u0070\u0070\u006c\u0069\u0063\u0061\u0074\u0069\u006f\u006e\u002f\u006a\u0073\u006f\u006e`,
    "Authorization": `\u0042\u0065\u0061\u0072\u0065\u0072\u0020` + store$7.accessToken
  };
  try {
    const response = await fetch(url, {
      method: `\u0050\u004f\u0053\u0054`,
      headers,
      body: JSON.stringify(saveData)
    });
    if (!response.ok) {
      console.error(`\u0048\u0054\u0054\u0050\u0020\u0065\u0072\u0072\u006f\u0072\u0021\u0020\u0073\u0074\u0061\u0074\u0075\u0073\u003a\u0020${response.status}`, response);
      if (response.status === 401) {
        store$7.setAccessToken(``);
        sendLog(`\u767b\u5f55\u5931\u6548`);
      } else {
        const result2 = await response.json();
        console.log(`\u0072\u0065\u0073\u0075\u006c\u0074`, result2);
        sendLog(`\u4fdd\u5b58\u9519\u8bef\u0020\u5176\u4ed6` + (result2 == null ? void 0 : result2.detail));
      }
      return false;
    }
    const result = await response.json();
    console.log(`\u0072\u0065\u0073\u0075\u006c\u0074`, result);
    return true;
  } catch (error) {
    console.error(`\u0045\u0072\u0072\u006f\u0072\u003a`, error);
    sendLog(`\u4fdd\u5b58\u9519\u8bef\u0020\u5176\u4ed6` + error);
  }
  return false;
}
async function saveLikeUnFollow(saveData) {
  const url = baseURL + `\u002f\u0061\u0070\u0069\u002f\u0076\u0031\u002f\u0075\u006e\u0066\u006f\u006c\u006c\u006f\u0077`;
  const headers = {
    "Content-Type": `\u0061\u0070\u0070\u006c\u0069\u0063\u0061\u0074\u0069\u006f\u006e\u002f\u006a\u0073\u006f\u006e`,
    "Authorization": `\u0042\u0065\u0061\u0072\u0065\u0072\u0020` + store$7.accessToken
  };
  try {
    const response = await fetch(url, {
      method: `\u0050\u004f\u0053\u0054`,
      headers,
      body: JSON.stringify(saveData)
    });
    if (!response.ok) {
      console.error(`\u0048\u0054\u0054\u0050\u0020\u0065\u0072\u0072\u006f\u0072\u0021\u0020\u0073\u0074\u0061\u0074\u0075\u0073\u003a\u0020${response.status}`, response);
      if (response.status === 401) {
        store$7.setAccessToken(``);
        sendLog(`\u767b\u5f55\u5931\u6548`);
      } else {
        const result2 = await response.json();
        console.log(`\u0072\u0065\u0073\u0075\u006c\u0074`, result2);
        sendLog(`\u4fdd\u5b58\u9519\u8bef\u0020\u5176\u4ed6` + (result2 == null ? void 0 : result2.detail));
      }
      return false;
    }
    const result = await response.json();
    console.log(`\u0072\u0065\u0073\u0075\u006c\u0074`, result);
    return true;
  } catch (error) {
    console.error(`\u0045\u0072\u0072\u006f\u0072\u003a`, error);
    sendLog(`\u4fdd\u5b58\u9519\u8bef\u0020\u5176\u4ed6` + error);
  }
  return false;
}
async function queryLikeFollowsByFollowedId(followed_id, queryParams) {
  const url = `${baseURL}\u002f\u0061\u0070\u0069\u002f\u0076\u0031\u002f\u0066\u006f\u006c\u006c\u006f\u0077\u0073\u002f${followed_id}\u003f${queryParams}`;
  const headers = {
    "Content-Type": `\u0061\u0070\u0070\u006c\u0069\u0063\u0061\u0074\u0069\u006f\u006e\u002f\u006a\u0073\u006f\u006e`,
    "Authorization": `\u0042\u0065\u0061\u0072\u0065\u0072\u0020` + store$7.accessToken
  };
  try {
    const response = await fetch(url, {
      method: `\u0047\u0045\u0054`,
      headers
    });
    if (!response.ok) {
      if (response.status === 404) {
        const result2 = await response.json();
        console.log(`\u0072\u0065\u0073\u0075\u006c\u0074`, result2);
        sendLog(`\u67e5\u8be2\u9519\u8bef\u0020\u0034\u0030\u0034` + (result2 == null ? void 0 : result2.detail) + `\u005f\u0066\u006f\u006c\u006c\u006f\u0077\u0065\u0064\u005f\u0069\u0064\u005f` + followed_id);
        if ((result2 == null ? void 0 : result2.detail) == `\u0058\u0068\u0073\u0043\u006f\u006e\u0074\u0065\u006e\u0074\u0020\u006e\u006f\u0074\u0020\u0066\u006f\u0075\u006e\u0064`) {
          return [];
        }
      }
      if (response.status === 401) {
        sendLog(`\u767b\u5f55\u5931\u6548`);
        store$7.setAccessToken(``);
      } else {
        const result2 = await response.json();
        console.log(`\u0072\u0065\u0073\u0075\u006c\u0074`, result2);
        sendLog(`\u67e5\u8be2\u9519\u8bef\u0020\u0034\u0030\u0034` + (result2 == null ? void 0 : result2.detail) + `\u005f\u0066\u006f\u006c\u006c\u006f\u0077\u0065\u0064\u005f\u0069\u0064\u005f` + followed_id);
      }
      console.error(`\u0048\u0054\u0054\u0050\u0020\u0065\u0072\u0072\u006f\u0072\u0021\u0020\u0073\u0074\u0061\u0074\u0075\u0073\u003a\u0020${response.status}`, response);
      return [];
    }
    const result = await response.json();
    console.log(`\u0072\u0065\u0073\u0075\u006c\u0074`, result);
    return result;
  } catch (error) {
    console.error(`\u0045\u0072\u0072\u006f\u0072\u003a`, error);
  }
  return [];
}
class AsyncTaskQueue {
  constructor(concurrency) {
    __publicField(this, `\u0063\u006f\u006e\u0063\u0075\u0072\u0072\u0065\u006e\u0063\u0079`);
    __publicField(this, `\u0072\u0075\u006e\u006e\u0069\u006e\u0067`, 0);
    __publicField(this, `\u0074\u0061\u0073\u006b\u0051\u0075\u0065\u0075\u0065`, []);
    this.concurrency = concurrency;
  }
  // 添加任务到队列，如果没有空余并发数则阻塞
  async enqueue(task) {
    if (this.running >= this.concurrency) {
      await new Promise(resolve => {
        this.taskQueue.push(() => {
          this.runTask(task);
          resolve();
        });
      });
    } else {
      this.runTask(task);
    }
  }
  // 执行任务，并控制并发数
  async runTask(task) {
    this.running++;
    try {
      await task();
    } finally {
      this.running--;
      if (this.taskQueue.length > 0) {
        const nextTask = this.taskQueue.shift();
        nextTask();
      }
    }
  }
  // 等待所有任务完成
  async waitForAll() {
    return new Promise(resolve => {
      const checkFinished = () => {
        if (this.running === 0 && this.taskQueue.length === 0) {
          resolve();
        } else {
          setTimeout(checkFinished, 50);
        }
      };
      checkFinished();
    });
  }
}
const store$6 = UseCounterStore.getInstance();
console.log(`\u0043\u006f\u006e\u0074\u0065\u006e\u0074\u0020\u0073\u0063\u0072\u0069\u0070\u0074\u0020\u006c\u006f\u0061\u0064\u0065\u0064\u003a`, window.location.href);
let XiaoHongShu_Setting$3 = JSON.parse(store$6.XiaoHongShu_Setting);
const extractNumber = text => {
  const match = text.match(/\d+/);
  return match ? parseInt(match[0], 10) : 0;
};
function getLastPathName(pathname) {
  if (pathname) {
    const extra_image_ids = pathname.split(`\u002f`);
    if (extra_image_ids && extra_image_ids.length > 0) {
      pathname = extra_image_ids[extra_image_ids.length - 1];
      return pathname.replace(/!.*$/, ``);
    }
  }
  return pathname;
}
function parseLine(input) {
  const trimmedInput = input.trim();
  const datePattern = /(\d{2}-\d{2}|今天|昨天|\d+ 天前)/;
  const timePattern = /(\d{2}:\d{2})/;
  const editPattern = /编辑于/;
  const locationPattern = /[\u4e00-\u9fa5]+/g;
  const currentDate = /* @__PURE__ */new Date();
  let publicationDate = null;
  let location = null;
  let isEdited = false;
  if (editPattern.test(trimmedInput)) {
    isEdited = true;
  }
  const dateMatch = trimmedInput.match(datePattern);
  if (dateMatch) {
    publicationDate = dateMatch[0];
    if (publicationDate.includes(`\u4eca\u5929`)) {
      publicationDate = `${currentDate.getFullYear()}\u002d${String(currentDate.getMonth() + 1).padStart(2, `\u0030`)}\u002d${String(currentDate.getDate()).padStart(2, `\u0030`)}`;
    } else if (publicationDate.includes(`\u6628\u5929`)) {
      const yesterday = new Date(currentDate);
      yesterday.setDate(currentDate.getDate() - 1);
      publicationDate = `${yesterday.getFullYear()}\u002d${String(yesterday.getMonth() + 1).padStart(2, `\u0030`)}\u002d${String(yesterday.getDate()).padStart(2, `\u0030`)}`;
    } else if (publicationDate.includes(`\u5929\u524d`)) {
      const daysAgo = parseInt(publicationDate);
      const pastDate = new Date(currentDate);
      pastDate.setDate(currentDate.getDate() - daysAgo);
      publicationDate = `${pastDate.getFullYear()}\u002d${String(pastDate.getMonth() + 1).padStart(2, `\u0030`)}\u002d${String(pastDate.getDate()).padStart(2, `\u0030`)}`;
    } else {
      publicationDate = `${currentDate.getFullYear()}\u002d${publicationDate}`;
    }
  }
  if (trimmedInput.includes(`\u521a\u521a`)) {
    const pastDate = currentDate;
    publicationDate = `${pastDate.getFullYear()}\u002d${String(pastDate.getMonth() + 1).padStart(2, `\u0030`)}\u002d${String(pastDate.getDate()).padStart(2, `\u0030`)}`;
  }
  const timeMatch = trimmedInput.match(timePattern);
  const time = timeMatch ? `${timeMatch[0]}\u003a\u0030\u0030` : `\u0030\u0030\u003a\u0030\u0030\u003a\u0030\u0030`;
  if (publicationDate) {
    publicationDate += `\u0020${time}`;
  }
  const locationMatches = trimmedInput.match(locationPattern);
  if (locationMatches) {
    for (const match of locationMatches) {
      if (![`\u7f16\u8f91\u4e8e`, `\u4eca\u5929`, `\u6628\u5929`, `\u5929\u524d`, `\u521a\u521a`].includes(match)) {
        location = match;
        break;
      }
    }
  }
  return {
    publicationDate,
    location,
    isEdited,
    originalStr: input
  };
}
async function auto_like_unfollow(note_url) {
  var _a, _b;
  const follow_button = document.querySelector(`\u002e\u0075\u0073\u0065\u0072\u002d\u0069\u006e\u0066\u006f\u0020\u002e\u0069\u006e\u0066\u006f\u002d\u0072\u0069\u0067\u0068\u0074\u002d\u0061\u0072\u0065\u0061\u0020\u002e\u0066\u006f\u006c\u006c\u006f\u0077\u002d\u0062\u0075\u0074\u0074\u006f\u006e`);
  console.log(`\u0066\u006f\u006c\u006c\u006f\u0077\u005f\u0062\u0075\u0074\u0074\u006f\u006e`, follow_button);
  if (!follow_button) {
    return;
  }
  let follow_button_text = ``;
  if (follow_button) {
    follow_button_text = ((_a = follow_button.textContent) == null ? void 0 : _a.trim()) || ``;
  }
  if (follow_button_text == `\u5df2\u5173\u6ce8`) {
    await click_button(follow_button);
    while (true) {
      if (follow_button) {
        follow_button_text = ((_b = follow_button.textContent) == null ? void 0 : _b.trim()) || ``;
      }
      if (follow_button_text == `\u56de\u5173` || follow_button_text == `\u5173\u6ce8`) {
        console.log(`\u53d6\u6d88\u5173\u6ce8\u6210\u529f\u4e86`);
        store$6.increment_XiaoHongShu_likes_unfollow();
        await saveLikeUnFollow({
          followed_id: store$6.userId,
          follower_id: note_url.replace(`\u0068\u0074\u0074\u0070\u0073\u003a\u002f\u002f\u0077\u0077\u0077\u002e\u0078\u0069\u0061\u006f\u0068\u006f\u006e\u0067\u0073\u0068\u0075\u002e\u0063\u006f\u006d`, ``)
        });
        break;
      } else {
        await delay(1e3);
      }
    }
  } else if (follow_button_text == `\u4e92\u76f8\u5173\u6ce8` || follow_button_text == `\u5173\u6ce8`) {
    console.log(`\u4e92\u76f8\u5173\u6ce8\u4e86`);
    await saveLikeUnFollow({
      followed_id: store$6.userId,
      follower_id: note_url.replace(`\u0068\u0074\u0074\u0070\u0073\u003a\u002f\u002f\u0077\u0077\u0077\u002e\u0078\u0069\u0061\u006f\u0068\u006f\u006e\u0067\u0073\u0068\u0075\u002e\u0063\u006f\u006d`, ``)
    });
  }
}
async function auto_replyComment() {
  await replyComment();
  console.log(`\u521d\u59cb\u5316\u5904\u7406\u5b8c\u6210`);
  sendLog(`\u521d\u59cb\u5316\u5904\u7406\u5b8c\u6210`);
  await intervalReplyComment();
  if (XiaoHongShu_Setting$3.likes_unfollow) {
    start_auto_like_follow().then(res => {
      console.log(`\u0073\u0074\u0061\u0072\u0074\u005f\u0061\u0075\u0074\u006f\u005f\u006c\u0069\u006b\u0065\u005f\u0066\u006f\u006c\u006c\u006f\u0077\u0020\u0072\u0065\u0073`, res);
    }).catch(err => {
      console.log(`\u0073\u0074\u0061\u0072\u0074\u005f\u0061\u0075\u0074\u006f\u005f\u006c\u0069\u006b\u0065\u005f\u0066\u006f\u006c\u006c\u006f\u0077\u0020\u0065\u0072\u0072`, err);
    });
  }
}
function getDateDaysAgo(days) {
  const today = /* @__PURE__ */new Date();
  const pastDate = new Date(today);
  pastDate.setDate(today.getDate() - days);
  return pastDate;
}
function getDateYearsAgo(years) {
  const today = /* @__PURE__ */new Date();
  const pastDate = new Date(today);
  pastDate.setFullYear(today.getFullYear() - years);
  return pastDate;
}
async function start_auto_like_follow() {
  console.log(`\u53d6\u6d88\u70b9\u8d5e\u5173\u6ce8\u6570\u91cf\u0020\u0073\u0074\u0061\u0072\u0074\u005f\u0061\u0075\u0074\u006f\u005f\u006c\u0069\u006b\u0065\u005f\u0066\u006f\u006c\u006c\u006f\u0077`);
  const pastDate = getDateDaysAgo(XiaoHongShu_Setting$3.likes_unfollow_num);
  const pastStr = `${pastDate.getFullYear()}\u002d${String(pastDate.getMonth() + 1).padStart(2, `\u0030`)}\u002d${String(pastDate.getDate()).padStart(2, `\u0030`)}`;
  const endedDate = getDateYearsAgo(1);
  const startDateStr = `${endedDate.getFullYear()}\u002d${String(endedDate.getMonth() + 1).padStart(2, `\u0030`)}\u002d${String(endedDate.getDate()).padStart(2, `\u0030`)}`;
  const queryParams = new URLSearchParams({
    started_at: startDateStr,
    ended_at: pastStr
  }).toString();
  const followList = await queryLikeFollowsByFollowedId(store$6.userId, queryParams);
  console.log(`\u53d6\u6d88\u5173\u6ce8\u6570\u91cf\uff0c\u0066\u006f\u006c\u006c\u006f\u0077\u004c\u0069\u0073\u0074\uff1a`, followList.length);
  const taskQueue = new AsyncTaskQueue(3);
  for (const followData of followList) {
    console.log(`\u0066\u006f\u006c\u006c\u006f\u0077\u0044\u0061\u0074\u0061`, followData);
    if (followData.follower_id) {
      const message = {
        action: `\u0065\u0078\u0065\u0063\u0075\u0074\u0065\u0054\u0061\u0073\u006b\u004e\u006f\u0054\u0061\u0073\u006b`,
        url: `\u0068\u0074\u0074\u0070\u0073\u003a\u002f\u002f\u0077\u0077\u0077\u002e\u0078\u0069\u0061\u006f\u0068\u006f\u006e\u0067\u0073\u0068\u0075\u002e\u0063\u006f\u006d` + followData.follower_id,
        taskName: `\u53d6\u6d88\u70b9\u8d5e\u7684\u5173\u6ce8`,
        taskPlatform: `\u5c0f\u7ea2\u4e66`
      };
      await taskQueue.enqueue(openNewWindowNote(message));
    }
  }
  await taskQueue.waitForAll();
}
async function intervalReplyComment() {
  if (!(await checkDomPromise(`\u002e\u0072\u0065\u0064\u0073\u002d\u0074\u0061\u0062\u002d\u0069\u0074\u0065\u006d\u002e\u0074\u0061\u0062\u002d\u0069\u0074\u0065\u006d\u0020\u002e\u0062\u0061\u0064\u0067\u0065\u002d\u0063\u006f\u006e\u0074\u0061\u0069\u006e\u0065\u0072`))) {
    return;
  }
  setInterval(async () => {
    var _a, _b;
    try {
      sendLog(`\u5f00\u59cb\u5b9a\u65f6\u5904\u7406\u65b0\u589e\u5173\u6ce8`);
      console.log(`\u5f00\u59cb\u5b9a\u65f6\u5904\u7406\u65b0\u589e\u5173\u6ce8`);
      const containers = document.querySelectorAll(`\u002e\u0072\u0065\u0064\u0073\u002d\u0074\u0061\u0062\u002d\u0069\u0074\u0065\u006d\u002e\u0074\u0061\u0062\u002d\u0069\u0074\u0065\u006d\u0020\u002e\u0062\u0061\u0064\u0067\u0065\u002d\u0063\u006f\u006e\u0074\u0061\u0069\u006e\u0065\u0072`);
      for (let i = 0; i < containers.length; i++) {
        const container = containers[i];
        const count_cls = container.querySelector(`\u002e\u0063\u006f\u0075\u006e\u0074`);
        let count_text = ``;
        if (count_cls) {
          count_text = ((_a = count_cls.textContent) == null ? void 0 : _a.trim()) || ``;
        }
        if (!count_text) {
          continue;
        }
        const span_tag = container.querySelector(`\u0073\u0070\u0061\u006e`);
        let span_txt = ``;
        if (span_tag) {
          span_txt = ((_b = span_tag.textContent) == null ? void 0 : _b.trim()) || ``;
        }
        if (!span_txt) {
          continue;
        }
        switch (span_txt) {
          case `\u8bc4\u8bba\u548c\u0040`:
            await refreshTabData(`\u8bc4\u8bba\u548c\u0040`);
            await autoComment(store$6.commentViewPaths);
            break;
          case `\u65b0\u589e\u5173\u6ce8`:
            if (XiaoHongShu_Setting$3.connections_follow) {
              await refreshTabData(`\u65b0\u589e\u5173\u6ce8`);
              await autoConnections(store$6.viewedPaths);
            }
            break;
        }
      }
    } finally {
      console.log(`\u7ed3\u675f\u5b9a\u65f6\u5904\u7406\u65b0\u589e\u5173\u6ce8`);
      sendLog(`\u7ed3\u675f\u5b9a\u65f6\u5904\u7406\u65b0\u589e\u5173\u6ce8`);
    }
  }, 10 * 1e3);
}
async function replyComment() {
  if (!(await checkDomPromise(`\u002e\u0072\u0065\u0064\u0073\u002d\u0074\u0061\u0062\u002d\u0069\u0074\u0065\u006d\u002e\u0061\u0063\u0074\u0069\u0076\u0065\u002e\u0074\u0061\u0062\u002d\u0069\u0074\u0065\u006d\u0020\u002e\u0062\u0061\u0064\u0067\u0065\u002d\u0063\u006f\u006e\u0074\u0061\u0069\u006e\u0065\u0072\u0020\u0073\u0070\u0061\u006e`))) {
    return;
  }
  if (XiaoHongShu_Setting$3.mentions) {
    try {
      await autoComment(store$6.commentViewPaths);
    } finally {}
  }
  if (XiaoHongShu_Setting$3.connections && XiaoHongShu_Setting$3.connections_follow) {
    try {
      await autoConnections(store$6.viewedPaths);
    } finally {}
  }
  if (XiaoHongShu_Setting$3.likes && XiaoHongShu_Setting$3.likes_follow) {
    try {
      await autoLikeFlow(store$6.followPaths);
    } finally {}
  }
}
async function switchTabItem(tabItem) {
  var _a;
  const detail_title_el = document.querySelector(`\u002e\u0072\u0065\u0064\u0073\u002d\u0074\u0061\u0062\u002d\u0069\u0074\u0065\u006d\u002e\u0061\u0063\u0074\u0069\u0076\u0065\u002e\u0074\u0061\u0062\u002d\u0069\u0074\u0065\u006d\u0020\u002e\u0062\u0061\u0064\u0067\u0065\u002d\u0063\u006f\u006e\u0074\u0061\u0069\u006e\u0065\u0072\u0020\u0073\u0070\u0061\u006e`);
  let current_tabItem = ``;
  if (detail_title_el) {
    current_tabItem = ((_a = detail_title_el.textContent) == null ? void 0 : _a.trim()) || ``;
  }
  console.log(`\u0063\u0075\u0072\u0072\u0065\u006e\u0074\u005f\u0074\u0061\u0062\u0049\u0074\u0065\u006d`, current_tabItem);
  switch (current_tabItem) {
    case `\u8bc4\u8bba\u548c\u0040`:
      switch (tabItem) {
        case `\u8bc4\u8bba\u548c\u0040`:
          return;
        default:
          await clickTabItem(tabItem);
          return;
      }
    case `\u8d5e\u548c\u6536\u85cf`:
      switch (tabItem) {
        case `\u8d5e\u548c\u6536\u85cf`:
          return;
        default:
          await clickTabItem(tabItem);
          return;
      }
    case `\u65b0\u589e\u5173\u6ce8`:
      switch (tabItem) {
        case `\u65b0\u589e\u5173\u6ce8`:
          return;
        default:
          await clickTabItem(tabItem);
          return;
      }
    default:
      console.log(`\u4e0d\u5339\u914d\u7684\u6570\u636e`);
      break;
  }
}
async function clickTabItem(tabItem) {
  var _a;
  const detail_tabitem_els = document.querySelectorAll(`\u002e\u0072\u0065\u0064\u0073\u002d\u0074\u0061\u0062\u002d\u0069\u0074\u0065\u006d\u002e\u0074\u0061\u0062\u002d\u0069\u0074\u0065\u006d\u0020\u002e\u0062\u0061\u0064\u0067\u0065\u002d\u0063\u006f\u006e\u0074\u0061\u0069\u006e\u0065\u0072\u0020\u0073\u0070\u0061\u006e`);
  let tabitem_els = Array.from(detail_tabitem_els);
  for (let i = 0; i < tabitem_els.length; i++) {
    let tabitem_el = tabitem_els[i];
    let current_tabItem = ((_a = tabitem_el.textContent) == null ? void 0 : _a.trim()) || ``;
    console.log(`\u0063\u006c\u0069\u0063\u006b\u0054\u0061\u0062\u0049\u0074\u0065\u006d\u0020\u0063\u0075\u0072\u0072\u0065\u006e\u0074\u005f\u0074\u0061\u0062\u0049\u0074\u0065\u006d\u003a`, current_tabItem, `\u0074\u0061\u0062\u0049\u0074\u0065\u006d\u003a`, tabItem);
    if (current_tabItem && current_tabItem == tabItem) {
      await click_button(tabitem_el);
      return;
    }
  }
}
async function refreshTabData(tabItem) {
  var _a;
  const detail_title_el = document.querySelector(`\u002e\u0072\u0065\u0064\u0073\u002d\u0074\u0061\u0062\u002d\u0069\u0074\u0065\u006d\u002e\u0061\u0063\u0074\u0069\u0076\u0065\u002e\u0074\u0061\u0062\u002d\u0069\u0074\u0065\u006d\u0020\u002e\u0062\u0061\u0064\u0067\u0065\u002d\u0063\u006f\u006e\u0074\u0061\u0069\u006e\u0065\u0072\u0020\u0073\u0070\u0061\u006e`);
  let current_tabItem = ``;
  if (detail_title_el) {
    current_tabItem = ((_a = detail_title_el.textContent) == null ? void 0 : _a.trim()) || ``;
  }
  console.log(`\u0063\u0075\u0072\u0072\u0065\u006e\u0074\u005f\u0074\u0061\u0062\u0049\u0074\u0065\u006d`, current_tabItem);
  switch (current_tabItem) {
    case `\u8bc4\u8bba\u548c\u0040`:
      switch (tabItem) {
        case `\u8bc4\u8bba\u548c\u0040`:
          await clickTabItem(`\u8d5e\u548c\u6536\u85cf`);
          await clickTabItem(`\u8bc4\u8bba\u548c\u0040`);
          return;
        default:
          await clickTabItem(tabItem);
          return;
      }
    case `\u8d5e\u548c\u6536\u85cf`:
      switch (tabItem) {
        case `\u8d5e\u548c\u6536\u85cf`:
          await clickTabItem(`\u8bc4\u8bba\u548c\u0040`);
          await clickTabItem(`\u8d5e\u548c\u6536\u85cf`);
          return;
        default:
          await clickTabItem(tabItem);
          return;
      }
    case `\u65b0\u589e\u5173\u6ce8`:
      switch (tabItem) {
        case `\u65b0\u589e\u5173\u6ce8`:
          await clickTabItem(`\u8d5e\u548c\u6536\u85cf`);
          await clickTabItem(`\u65b0\u589e\u5173\u6ce8`);
          return;
        default:
          await clickTabItem(tabItem);
          return;
      }
    default:
      console.log(`\u4e0d\u5339\u914d\u7684\u6570\u636e`);
      break;
  }
}
async function autoComment(viewedPaths) {
  var _a, _b, _c, _d;
  await switchTabItem(`\u8bc4\u8bba\u548c\u0040`);
  if (!(await checkDomPromise(`\u002e\u0074\u0061\u0062\u0073\u002d\u0063\u006f\u006e\u0074\u0065\u006e\u0074\u002d\u0063\u006f\u006e\u0074\u0061\u0069\u006e\u0065\u0072\u0020\u002e\u0063\u006f\u006e\u0074\u0061\u0069\u006e\u0065\u0072`))) {
    return;
  }
  const containers = document.querySelectorAll(`\u002e\u0074\u0061\u0062\u0073\u002d\u0063\u006f\u006e\u0074\u0065\u006e\u0074\u002d\u0063\u006f\u006e\u0074\u0061\u0069\u006e\u0065\u0072\u0020\u002e\u0063\u006f\u006e\u0074\u0061\u0069\u006e\u0065\u0072`);
  for (let i = 0; i < containers.length; i++) {
    const container = containers[i];
    const user_tag = container.querySelector(`\u002e\u0075\u0073\u0065\u0072\u002d\u0069\u006e\u0066\u006f\u0020\u002e\u0075\u0073\u0065\u0072\u002d\u0074\u0061\u0067`);
    let user_tag_text = ``;
    if (user_tag) {
      user_tag_text = ((_a = user_tag.textContent) == null ? void 0 : _a.trim()) || ``;
    }
    if (user_tag_text == `\u4f5c\u8005`) {
      console.info(`\u4f5c\u8005\uff0c\u4e0d\u505a\u56de\u590d\u3002\u0020\u0075\u0073\u0065\u0072\u005f\u0074\u0061\u0067\u005f\u0074\u0065\u0078\u0074\uff1a`, user_tag_text);
      continue;
    }
    const interaction_hint_spans = container.querySelectorAll(`\u002e\u006d\u0061\u0069\u006e\u0020\u002e\u0069\u006e\u0066\u006f\u0020\u002e\u0069\u006e\u0074\u0065\u0072\u0061\u0063\u0074\u0069\u006f\u006e\u002d\u0068\u0069\u006e\u0074\u0020\u0073\u0070\u0061\u006e`);
    let interaction_hint_span_one_text = ``;
    if (interaction_hint_spans.length > 0) {
      interaction_hint_span_one_text = ((_b = interaction_hint_spans[0].textContent) == null ? void 0 : _b.trim()) || ``;
    }
    if (interaction_hint_span_one_text == `\u5728\u8bc4\u8bba\u4e2d\u0040\u4e86\u4f60`) {
      console.info(`\u0040\u6211\u7684\u6d88\u606f\uff0c\u4e0d\u505a\u56de\u590d`, user_tag_text);
      continue;
    }
    const user_avatar = container.querySelector(`\u0061\u002e\u0075\u0073\u0065\u0072\u002d\u0061\u0076\u0061\u0074\u0061\u0072`);
    if (!user_avatar) {
      console.log(`\u5982\u679c\u5934\u50cf\u4e0d\u5b58\u5728\u3002\u4e0d\u505a\u56de\u590d`);
      continue;
    }
    const comment_user_url = user_avatar.href;
    let comment_user_id = ``;
    if (comment_user_url) {
      const pathname = new URL(comment_user_url).pathname;
      comment_user_id = getLastPathName(pathname);
    }
    const extra_image = container.querySelector(`\u002e\u0065\u0078\u0074\u0072\u0061\u0020\u002e\u0065\u0078\u0074\u0072\u0061\u002d\u0069\u006d\u0061\u0067\u0065`);
    let extra_image_url = ``;
    if (extra_image) {
      extra_image_url = extra_image.src;
    }
    console.log(`\u0065\u0078\u0074\u0072\u0061\u005f\u0069\u006d\u0061\u0067\u0065\u003a`, extra_image);
    console.log(`\u0065\u0078\u0074\u0072\u0061\u005f\u0069\u006d\u0061\u0067\u0065\u005f\u0075\u0072\u006c\u003a` + extra_image_url);
    let extra_image_id = ``;
    if (extra_image_url) {
      const pathname = new URL(extra_image_url).pathname;
      extra_image_id = getLastPathName(pathname);
    }
    const interaction_content = container.querySelector(`\u002e\u0069\u006e\u0074\u0065\u0072\u0061\u0063\u0074\u0069\u006f\u006e\u002d\u0063\u006f\u006e\u0074\u0065\u006e\u0074`);
    let interaction_content_text = ``;
    if (interaction_content) {
      interaction_content_text = ((_c = interaction_content.textContent) == null ? void 0 : _c.trim()) || ``;
    }
    if (interaction_content_text == `\u005b\u56fe\u7247\u005d`) {
      console.info(`\u8bc4\u8bba\u5185\u5bb9\u53ea\u6709\u56fe\u7247\uff0c\u4e0d\u8bc4\u8bba\u3002\u0069\u006e\u0074\u0065\u0072\u0061\u0063\u0074\u0069\u006f\u006e\u005f\u0063\u006f\u006e\u0074\u0065\u006e\u0074\u005f\u0074\u0065\u0078\u0074\uff1a`, interaction_content_text);
      continue;
    }
    const quote_info = container.querySelector(`\u002e\u0071\u0075\u006f\u0074\u0065\u002d\u0069\u006e\u0066\u006f`);
    let quote_info_text = ``;
    if (quote_info) {
      quote_info_text = ((_d = quote_info.textContent) == null ? void 0 : _d.trim()) || ``;
    }
    const action_reply_el = container.querySelector(`\u002e\u0061\u0063\u0074\u0069\u006f\u006e\u002d\u0072\u0065\u0070\u006c\u0079`);
    if (!action_reply_el) {
      console.log(`\u6ca1\u6709\u627e\u5230\u56de\u590d\u6309\u94ae\uff0c\u4e0d\u505a\u8bc4\u8bba`);
      continue;
    }
    const inputs = {
      text: interaction_content_text,
      before: quote_info_text,
      style: XiaoHongShu_Setting$3 == null ? void 0 : XiaoHongShu_Setting$3.style,
      word_limit: XiaoHongShu_Setting$3 == null ? void 0 : XiaoHongShu_Setting$3.charLimit,
      key_message: XiaoHongShu_Setting$3 == null ? void 0 : XiaoHongShu_Setting$3.keywordInfo
    };
    const files = [];
    let path = `\u0072\u0065\u0070\u006c\u0079\u0043\u006f\u006d\u006d\u0065\u006e\u0074\u005f\u0075\u0073\u0065\u0072\u005f` + store$6.userId + `\u005f\u0070\u0061\u0074\u0068\u005f` + extra_image_id + `\u005f\u0063\u006f\u006d\u006d\u0065\u006e\u0074\u005f\u0075\u0073\u0065\u0072\u005f\u0069\u0064\u005f` + comment_user_id;
    console.log(`\u0050\u0061\u0074\u0068\u003a\u0020`, path);
    if (viewedPaths.includes(path)) {
      console.log(`\u5df2\u7ecf\u5904\u7406\u8fc7\u4e86`);
      continue;
    }
    if (await queryComment(path)) {
      let replyCommentText = ``;
      if (XiaoHongShu_Setting$3.tag == `\u0061\u0069\u751f\u6210`) {
        replyCommentText = await runWorkflow(inputs, files);
      } else if (XiaoHongShu_Setting$3.tag == `\u56fa\u5b9a\u56de\u590d`) {
        replyCommentText = XiaoHongShu_Setting$3.replyComment;
      } else {
        console.log(`\u5de5\u4f5c\u65b9\u5f0f\u0020\u4e0d\u5b58\u5728`, XiaoHongShu_Setting$3.tag);
        continue;
      }
      if (replyCommentText) {
        await click_button(action_reply_el);
        console.log(`\u589e\u52a0\u8bc4\u8bba\u540e\u7f00\u4fe1\u606f`, XiaoHongShu_Setting$3 == null ? void 0 : XiaoHongShu_Setting$3.commentSuffix);
        if (XiaoHongShu_Setting$3.tag == `\u0061\u0069\u751f\u6210` && (XiaoHongShu_Setting$3 == null ? void 0 : XiaoHongShu_Setting$3.commentSuffix)) {
          console.log(`\u589e\u52a0\u8bc4\u8bba\u540e\u7f00\u4fe1\u606f`, XiaoHongShu_Setting$3 == null ? void 0 : XiaoHongShu_Setting$3.commentSuffix);
          replyCommentText += `\u000d\u000a` + (XiaoHongShu_Setting$3 == null ? void 0 : XiaoHongShu_Setting$3.commentSuffix);
        }
        const saveInputs = {
          refer_id: path,
          data_type: `\u0072\u0065\u0070\u006c\u0079\u0043\u006f\u006d\u006d\u0065\u006e\u0074`,
          title: ``,
          text: interaction_content_text,
          label: ``,
          style: XiaoHongShu_Setting$3 == null ? void 0 : XiaoHongShu_Setting$3.style,
          word_limit: XiaoHongShu_Setting$3 == null ? void 0 : XiaoHongShu_Setting$3.charLimit,
          key_message: XiaoHongShu_Setting$3 == null ? void 0 : XiaoHongShu_Setting$3.keywordInfo,
          commentSuffix: XiaoHongShu_Setting$3 == null ? void 0 : XiaoHongShu_Setting$3.commentSuffix,
          tag: XiaoHongShu_Setting$3.tag,
          comment_user_url,
          comment_user_id,
          extra_image_url,
          extra_image_id,
          replyComment: replyCommentText,
          userId: store$6.userId
        };
        await action_reply(container, replyCommentText, saveInputs);
        viewedPaths.push(path);
        await action_like(container);
      }
    } else {
      console.log(`\u5df2\u7ecf\u56de\u590d\u8fc7\u4e86`);
      viewedPaths.push(path);
    }
  }
}
async function action_reply(container, replyCommentText, saveInputs) {
  if (!(await checkDomPromise(`\u002e\u0069\u006e\u0070\u0075\u0074\u002d\u0077\u0072\u0061\u0070\u0070\u0065\u0072\u0020\u002e\u0063\u006f\u006d\u006d\u0065\u006e\u0074\u002d\u0069\u006e\u0070\u0075\u0074`))) {
    return;
  }
  let comment_input_el = container.querySelector(`\u002e\u0069\u006e\u0070\u0075\u0074\u002d\u0077\u0072\u0061\u0070\u0070\u0065\u0072\u0020\u002e\u0063\u006f\u006d\u006d\u0065\u006e\u0074\u002d\u0069\u006e\u0070\u0075\u0074`);
  if (!comment_input_el) {
    console.error(`\u6ca1\u6709\u627e\u5230\u8f93\u5165\u6846\uff0c\u4e0d\u505a\u8bc4\u8bba`);
    return;
  }
  let comment_html_input_el = comment_input_el;
  comment_html_input_el.value = replyCommentText;
  const event = new Event(`\u0069\u006e\u0070\u0075\u0074`, {
    bubbles: true,
    cancelable: true
  });
  comment_html_input_el.dispatchEvent(event);
  if (!(await checkDomPromise(`\u002e\u0061\u0063\u0074\u0069\u006f\u006e\u0073\u0020\u002e\u0073\u0075\u0062\u006d\u0069\u0074`))) {
    return;
  }
  const submit_el = container.querySelector(`\u002e\u0061\u0063\u0074\u0069\u006f\u006e\u0073\u0020\u002e\u0073\u0075\u0062\u006d\u0069\u0074`);
  if (!submit_el) {
    console.error(`\u6ca1\u6709\u627e\u5230\u8f93\u5165\u6846\uff0c\u4e0d\u505a\u8bc4\u8bba`);
    return;
  }
  await click_button(submit_el);
  await saveComment(saveInputs);
  store$6.increment_XiaoHongShu_CommentCount();
}
async function action_like(container) {
  if (!(await checkDomPromise(`\u002e\u0061\u0063\u0074\u0069\u006f\u006e\u002d\u006c\u0069\u006b\u0065\u0020\u002e\u006c\u0069\u006b\u0065\u002d\u006c\u006f\u0074\u0074\u0069\u0065`))) {
    return;
  }
  const action_like_el = container.querySelector(`\u002e\u0061\u0063\u0074\u0069\u006f\u006e\u002d\u006c\u0069\u006b\u0065\u0020\u002e\u006c\u0069\u006b\u0065\u002d\u006c\u006f\u0074\u0074\u0069\u0065`);
  if (!action_like_el) {
    console.error(`\u6ca1\u6709\u627e\u5230\u70b9\u8d5e\u6309\u94ae`);
    return;
  }
  await click_button(action_like_el);
}
async function autoConnections(viewedPaths) {
  var _a;
  await switchTabItem(`\u65b0\u589e\u5173\u6ce8`);
  if (!(await checkDomPromise(`\u002e\u0074\u0061\u0062\u0073\u002d\u0063\u006f\u006e\u0074\u0065\u006e\u0074\u002d\u0063\u006f\u006e\u0074\u0061\u0069\u006e\u0065\u0072\u0020\u002e\u0063\u006f\u006e\u0074\u0061\u0069\u006e\u0065\u0072`))) {
    return;
  }
  const containers = document.querySelectorAll(`\u002e\u0074\u0061\u0062\u0073\u002d\u0063\u006f\u006e\u0074\u0065\u006e\u0074\u002d\u0063\u006f\u006e\u0074\u0061\u0069\u006e\u0065\u0072\u0020\u002e\u0063\u006f\u006e\u0074\u0061\u0069\u006e\u0065\u0072`);
  console.log(`\u0063\u006f\u006e\u0074\u0061\u0069\u006e\u0065\u0072\u0073`, containers.length);
  for (let i = 0; i < containers.length; i++) {
    const container = containers[i];
    const reds_button_new = container.querySelector(`\u002e\u0072\u0065\u0064\u0073\u002d\u0062\u0075\u0074\u0074\u006f\u006e\u002d\u006e\u0065\u0077`);
    if (!reds_button_new) {
      console.log(`\u0072\u0065\u0064\u0073\u005f\u0062\u0075\u0074\u0074\u006f\u006e\u005f\u006e\u0065\u0077\u0020\u4e0d\u5b58\u5728`, reds_button_new);
      continue;
    }
    const user_avatar = container.querySelector(`\u0061\u002e\u0075\u0073\u0065\u0072\u002d\u0061\u0076\u0061\u0074\u0061\u0072`);
    if (!user_avatar) {
      console.log(`\u0072\u0065\u0064\u0073\u005f\u0062\u0075\u0074\u0074\u006f\u006e\u005f\u006e\u0065\u0077\u0020\u4e0d\u5b58\u5728`, user_avatar);
      continue;
    }
    const container_href = user_avatar.href;
    let container_user_id = ``;
    if (container_href) {
      const pathname = new URL(container_href).pathname;
      container_user_id = getLastPathName(pathname);
    }
    if (!container_user_id) {
      console.log(`\u5173\u6ce8\u7528\u6237\u0069\u0064\u4e3a\u7a7a`, container_user_id);
      continue;
    }
    const reds_button_new_text = container.querySelector(`\u002e\u0072\u0065\u0064\u0073\u002d\u0062\u0075\u0074\u0074\u006f\u006e\u002d\u006e\u0065\u0077\u002d\u0074\u0065\u0078\u0074`);
    let button_text = ``;
    if (reds_button_new_text) {
      button_text = ((_a = reds_button_new_text.textContent) == null ? void 0 : _a.trim()) || ``;
    }
    console.log(`\u0062\u0075\u0074\u0074\u006f\u006e\u005f\u0074\u0065\u0078\u0074`, button_text);
    if (button_text == `\u56de\u5173`) {
      const key = `\u0063\u006f\u006e\u006e\u0065\u0063\u0074\u0069\u006f\u006e\u0073\u005f\u0066\u006f\u006c\u006c\u006f\u0077\u005f` + store$6.userId + `\u005f` + container_user_id;
      if (viewedPaths.includes(key)) {
        console.log(`\u5df2\u56de\u5173\u4e86`);
        continue;
      }
      if (await queryComment(key)) {
        await click_button(reds_button_new);
        const saveInputs = {
          "refer_id": key,
          data_type: `\u0063\u006f\u006e\u006e\u0065\u0063\u0074\u0069\u006f\u006e\u0073\u005f\u0066\u006f\u006c\u006c\u006f\u0077`,
          "user_id": store$6.userId,
          "container_user_id": container_user_id,
          "container_url": container_href
        };
        await saveComment(saveInputs);
        store$6.increment_XiaoHongShu_connections_follow();
        viewedPaths.push(key);
      } else {
        console.log(`\u5df2\u56de\u5173\u4e86`);
        viewedPaths.push(key);
      }
    } else {
      console.log(`\u0063\u006f\u006e\u006e\u0065\u0063\u0074\u0069\u006f\u006e\u0073\u005f\u0075\u006e\u0066\u006f\u006c\u006c\u006f\u0077`, XiaoHongShu_Setting$3.connections_unfollow);
      if (XiaoHongShu_Setting$3.connections_unfollow && button_text == `\u4e92\u76f8\u5173\u6ce8`) {
        await autoConnections_unfollow(container, reds_button_new, container_user_id, container_href);
      }
    }
  }
}
async function autoConnections_unfollow(container, reds_button_new, container_user_id, container_href) {
  var _a;
  const interaction_time = container.querySelector(`\u002e\u0069\u006e\u0074\u0065\u0072\u0061\u0063\u0074\u0069\u006f\u006e\u002d\u0074\u0069\u006d\u0065`);
  let interaction_time_text = ``;
  if (interaction_time) {
    interaction_time_text = ((_a = interaction_time.textContent) == null ? void 0 : _a.trim()) || ``;
  }
  console.log(`\u0069\u006e\u0074\u0065\u0072\u0061\u0063\u0074\u0069\u006f\u006e\u005f\u0074\u0069\u006d\u0065\u005f\u0074\u0065\u0078\u0074`, interaction_time_text);
  if (!interaction_time_text) {
    console.log(`\u5173\u6ce8\u7684\u65e5\u671f\u4e3a\u7a7a`);
    return;
  }
  let num = 0;
  if (interaction_time_text.includes(`\u4eca\u5929`)) {
    return;
  } else if (interaction_time_text.includes(`\u521a\u521a`)) {
    return;
  } else if (interaction_time_text.includes(`\u6628\u5929`)) {
    num = 1;
  } else if (interaction_time_text.includes(`\u5929\u524d`)) {
    num = extractNumber(interaction_time_text);
    if (!num) {
      console.log(`\u5173\u6ce8\u7684\u65e5\u671f\u51e0\u5929\u524d\u7684\u6570\u5b57\u4e3a\u7a7a`, num);
      return;
    }
  } else {
    const interaction_time_texts = interaction_time_text.split(`\u002d`);
    if (!interaction_time_texts || interaction_time_texts.length !== 2) {
      return null;
    }
    const month = parseInt(interaction_time_texts[0], 10) - 1;
    const day = parseInt(interaction_time_texts[1], 10);
    const currentDate = /* @__PURE__ */new Date();
    const currentYear = currentDate.getFullYear();
    const interactionDate = new Date(currentYear, month, day);
    const timeDifference = currentDate.getTime() - interactionDate.getTime();
    num = Math.floor(timeDifference / (1e3 * 60 * 60 * 24));
  }
  if (!XiaoHongShu_Setting$3.connections_unfollow_num) {
    console.log(`\u53d6\u6d88\u5173\u6ce8\u7684\u65f6\u95f4\u4e3a\u7a7a`, XiaoHongShu_Setting$3.connections_unfollow_num);
    return;
  }
  if (XiaoHongShu_Setting$3.connections_unfollow_num > num) {
    console.log(`\u53d6\u6d88\u5173\u6ce8\u7684\u65f6\u95f4\u0020\u8fd8\u4e0d\u5230`, XiaoHongShu_Setting$3.connections_unfollow_num, num);
    return;
  }
  const key = `\u0063\u006f\u006e\u006e\u0065\u0063\u0074\u0069\u006f\u006e\u0073\u005f\u0075\u006e\u0066\u006f\u006c\u006c\u006f\u0077\u005f` + store$6.userId + `\u005f` + container_user_id;
  if (store$6.connections_unfollow_viewedPaths.includes(key)) {
    console.log(`\u5df2\u7ecf\u53d6\u5173\u4e86`);
    return;
  }
  if (await queryComment(key)) {
    await click_button(reds_button_new);
    const saveInputs = {
      "refer_id": key,
      data_type: `\u0063\u006f\u006e\u006e\u0065\u0063\u0074\u0069\u006f\u006e\u0073\u005f\u0075\u006e\u0066\u006f\u006c\u006c\u006f\u0077`,
      "user_id": store$6.userId,
      "container_user_id": container_user_id,
      "container_url": container_href
    };
    await saveComment(saveInputs);
    store$6.connections_unfollow_viewedPaths.push(key);
    store$6.increment_XiaoHongShu_connections_unfollow();
  } else {
    store$6.connections_unfollow_viewedPaths.push(key);
    console.log(`\u5df2\u7ecf\u53d6\u5173\u4e86`);
  }
}
async function autoLikeFlow(viewedPaths) {
  var _a, _b, _c, _d, _e;
  await switchTabItem(`\u8d5e\u548c\u6536\u85cf`);
  console.log(`\u0076\u0069\u0065\u0077\u0065\u0064\u0050\u0061\u0074\u0068\u0073`, viewedPaths);
  let end_num = 0;
  let last_date = store$6.lastLikeFlowDate;
  console.log(`\u006c\u0061\u0073\u0074\u005f\u0064\u0061\u0074\u0065`, last_date);
  try {
    while (true) {
      if (!(await checkDomPromise(`\u002e\u0074\u0061\u0062\u0073\u002d\u0063\u006f\u006e\u0074\u0065\u006e\u0074\u002d\u0063\u006f\u006e\u0074\u0061\u0069\u006e\u0065\u0072\u0020\u002e\u0063\u006f\u006e\u0074\u0061\u0069\u006e\u0065\u0072`))) {
        return;
      }
      const containers = document.querySelectorAll(`\u002e\u0074\u0061\u0062\u0073\u002d\u0063\u006f\u006e\u0074\u0065\u006e\u0074\u002d\u0063\u006f\u006e\u0074\u0061\u0069\u006e\u0065\u0072\u0020\u002e\u0063\u006f\u006e\u0074\u0061\u0069\u006e\u0065\u0072`);
      console.log(`\u0063\u006f\u006e\u0074\u0061\u0069\u006e\u0065\u0072\u0073`, containers.length);
      for (let i = 0; i < containers.length; i++) {
        const container = containers[i];
        const user_info_a = container.querySelector(`\u002e\u006d\u0061\u0069\u006e\u0020\u002e\u0069\u006e\u0066\u006f\u0020\u002e\u0075\u0073\u0065\u0072\u002d\u0069\u006e\u0066\u006f\u0020\u0061`);
        if (!user_info_a) {
          continue;
        }
        await ensureElementVisible3(user_info_a, 180);
        console.log(`\u0075\u0073\u0065\u0072\u005f\u0069\u006e\u0066\u006f\u005f\u0061`, user_info_a);
        const user_info_a_url = user_info_a.getAttribute(`\u0068\u0072\u0065\u0066`);
        if (!user_info_a_url) {
          continue;
        }
        if (viewedPaths.includes(user_info_a_url)) {
          continue;
        }
        viewedPaths.push(user_info_a_url);
        const user_info_user_tag = container.querySelector(`\u002e\u006d\u0061\u0069\u006e\u0020\u002e\u0069\u006e\u0066\u006f\u0020\u002e\u0075\u0073\u0065\u0072\u002d\u0069\u006e\u0066\u006f\u0020\u002e\u0075\u0073\u0065\u0072\u002d\u0074\u0061\u0067`);
        let user_info_user_tag_text = ``;
        if (user_info_user_tag) {
          user_info_user_tag_text = ((_a = user_info_user_tag.textContent) == null ? void 0 : _a.trim()) || ``;
        }
        console.log(`\u0075\u0073\u0065\u0072\u005f\u0069\u006e\u0066\u006f\u005f\u0075\u0073\u0065\u0072\u005f\u0074\u0061\u0067`, user_info_user_tag, user_info_user_tag_text);
        if (user_info_user_tag_text == `\u4f60\u7684\u597d\u53cb` || user_info_user_tag_text == `\u4f60\u7684\u5173\u6ce8`) {
          continue;
        }
        const interaction_time = container.querySelector(`\u002e\u006d\u0061\u0069\u006e\u0020\u002e\u0069\u006e\u0066\u006f\u0020\u002e\u0069\u006e\u0074\u0065\u0072\u0061\u0063\u0074\u0069\u006f\u006e\u002d\u0074\u0069\u006d\u0065`);
        let interaction_time_text = ``;
        if (interaction_time) {
          interaction_time_text = ((_b = interaction_time.textContent) == null ? void 0 : _b.trim()) || ``;
        }
        if (!(interaction_time_text.includes(`\u521a\u521a`) || interaction_time_text.includes(`\u4eca\u5929`) || interaction_time_text.includes(`\u6628\u5929`))) {
          console.log(`\u0069\u006e\u0074\u0065\u0072\u0061\u0063\u0074\u0069\u006f\u006e\u005f\u0074\u0069\u006d\u0065\u005f\u0074\u0065\u0078\u0074`, interaction_time_text);
          return;
        }
        const parsedInfo = parseLine(interaction_time_text);
        let dateObject = null;
        if (parsedInfo && parsedInfo.publicationDate) {
          console.log(`\u0070\u0061\u0072\u0073\u0065\u0064\u0049\u006e\u0066\u006f`, parsedInfo);
          dateObject = new Date(parsedInfo.publicationDate);
          if (store$6.lastLikeFlowDate && dateObject && store$6.lastLikeFlowDate.getTime() > dateObject.getTime()) {
            console.log(`\u006c\u0061\u0073\u0074\u004c\u0069\u006b\u0065\u0046\u006c\u006f\u0077\u0044\u0061\u0074\u0065\u0020\u5df2\u5b8c\u6210`, store$6.lastLikeFlowDate.getTime(), dateObject.getTime());
            return;
          }
        }
        let x = 0;
        let y = 0;
        try {
          let rect = user_info_a.getBoundingClientRect();
          x = rect.left + rect.width / 2;
          y = rect.top + rect.height / 2;
          console.log(`\u0078\u002c\u0079`, rect, x, y);
          let mouseOverEvent = new MouseEvent(`\u006d\u006f\u0075\u0073\u0065\u006f\u0076\u0065\u0072`, {
            view: window,
            bubbles: true,
            cancelable: true,
            clientX: x,
            clientY: y
          });
          user_info_a.dispatchEvent(mouseOverEvent);
          let mouseMoveEvent = new MouseEvent(`\u006d\u006f\u0075\u0073\u0065\u006d\u006f\u0076\u0065`, {
            view: window,
            bubbles: true,
            cancelable: true,
            clientX: x,
            clientY: y
          });
          user_info_a.dispatchEvent(mouseMoveEvent);
          let mouseEnterEvent = new MouseEvent(`\u006d\u006f\u0075\u0073\u0065\u0065\u006e\u0074\u0065\u0072`, {
            view: window,
            bubbles: true,
            cancelable: true,
            clientX: x,
            clientY: y
          });
          user_info_a.dispatchEvent(mouseEnterEvent);
          if (!(await checkDomPromise(`\u002e\u0074\u006f\u006f\u006c\u0074\u0069\u0070\u002d\u0063\u006f\u006e\u0074\u0065\u006e\u0074\u0020\u002e\u0075\u0073\u0065\u0072\u002d\u0063\u006f\u006e\u0074\u0065\u006e\u0074\u0020\u002e\u0068\u0065\u0061\u0064\u0065\u0072\u002d\u0061\u0072\u0065\u0061`))) {
            continue;
          }
          const follow_button = document.querySelector(`\u002e\u0074\u006f\u006f\u006c\u0074\u0069\u0070\u002d\u0063\u006f\u006e\u0074\u0065\u006e\u0074\u0020\u002e\u0075\u0073\u0065\u0072\u002d\u0063\u006f\u006e\u0074\u0065\u006e\u0074\u0020\u002e\u0068\u0065\u0061\u0064\u0065\u0072\u002d\u0061\u0072\u0065\u0061\u0020\u002e\u0066\u006f\u006c\u006c\u006f\u0077\u002d\u0062\u0075\u0074\u0074\u006f\u006e`);
          console.log(`\u0066\u006f\u006c\u006c\u006f\u0077\u005f\u0062\u0075\u0074\u0074\u006f\u006e`, follow_button);
          if (!follow_button) {
            continue;
          }
          let follow_button_text = ``;
          if (follow_button) {
            follow_button_text = ((_c = follow_button.textContent) == null ? void 0 : _c.trim()) || ``;
          }
          let focus = 0;
          let fans = 0;
          let likes_and_favorites = 0;
          const interactions = document.querySelectorAll(`\u002e\u0074\u006f\u006f\u006c\u0074\u0069\u0070\u002d\u0063\u006f\u006e\u0074\u0061\u0069\u006e\u0065\u0072\u0020\u002e\u0074\u006f\u006f\u006c\u0074\u0069\u0070\u002d\u0063\u006f\u006e\u0074\u0065\u006e\u0074\u0020\u002e\u0075\u0073\u0065\u0072\u002d\u0063\u006f\u006e\u0074\u0065\u006e\u0074\u0020\u002e\u0068\u0065\u0061\u0064\u0065\u0072\u002d\u0061\u0072\u0065\u0061\u0020\u002e\u0069\u006e\u0074\u0065\u0072\u0061\u0063\u0074\u0069\u006f\u006e\u002d\u0069\u006e\u0066\u006f\u0020\u002e\u0069\u006e\u0074\u0065\u0072\u0061\u0063\u0074\u0069\u006f\u006e`);
          for (const interaction of interactions) {
            let interaction_text = ``;
            if (interaction) {
              interaction_text = ((_d = interaction.textContent) == null ? void 0 : _d.trim()) || ``;
            }
            if (interaction_text) {
              if (interaction_text.includes(`\u5173\u6ce8`)) {
                focus = parseInt(interaction_text);
              } else if (interaction_text.includes(`\u7c89\u4e1d`)) {
                fans = parseInt(interaction_text);
              } else if (interaction_text.includes(`\u83b7\u8d5e\u4e0e\u6536\u85cf`)) {
                likes_and_favorites = parseInt(interaction_text);
              }
            }
          }
          if (fans < XiaoHongShu_Setting$3.connections_num) {
            console.log(`\u53ea\u5173\u6ce8\u7c89\u4e1d\u6570\u5927\u4e8e\u591a\u5c11\u7684\u8d26\u53f7\u2265`, fans, `\u003c`, XiaoHongShu_Setting$3.connections_num);
            continue;
          }
          if (likes_and_favorites < XiaoHongShu_Setting$3.like_num) {
            console.log(`\u53ea\u5173\u6ce8\u83b7\u8d5e\u5927\u4e8e\u591a\u5c11\u7684\u8d26\u53f7\u2265`, likes_and_favorites, `\u003c`, XiaoHongShu_Setting$3.like_num);
            continue;
          }
          if (XiaoHongShu_Setting$3.connections_ge_follow && fans < focus) {
            console.log(`\u53ea\u5173\u6ce8\u4e8e\u7c89\u4e1d\u6570\u003e\u5173\u6ce8\u6570\u7684\u8d26\u53f7`, XiaoHongShu_Setting$3.connections_ge_follow, fans, `\u003c\u003d`, focus);
            continue;
          }
          if (follow_button_text == `\u5173\u6ce8` || follow_button_text == `\u56de\u5173`) {
            await click_button(follow_button);
            if (follow_button) {
              follow_button_text = ((_e = follow_button.textContent) == null ? void 0 : _e.trim()) || ``;
            }
            while (true) {
              if (follow_button_text == `\u5173\u6ce8` || follow_button_text == `\u56de\u5173`) {
                console.log(`\u5173\u6ce8\u6210\u529f\u4e86`);
                if (dateObject) {
                  console.log(`\u0064\u0061\u0074\u0065\u004f\u0062\u006a\u0065\u0063\u0074`, dateObject, last_date);
                  if (!last_date) {
                    last_date = dateObject;
                  } else if (last_date < dateObject) {
                    last_date = dateObject;
                  }
                }
                store$6.increment_XiaoHongShu_likes_follow();
                await saveLikeFollows({
                  followed_id: store$6.userId,
                  follower_id: user_info_a_url
                });
                break;
              } else {
                await delay(1e3);
              }
            }
          }
        } finally {
          let mouseLeaveEvent2 = new MouseEvent(`\u006d\u006f\u0075\u0073\u0065\u006c\u0065\u0061\u0076\u0065`, {
            view: window,
            bubbles: true,
            cancelable: true,
            clientX: x,
            clientY: y
          });
          user_info_a.dispatchEvent(mouseLeaveEvent2);
        }
      }
      const end_container = document.querySelectorAll(`\u002e\u0065\u006e\u0064\u002d\u0063\u006f\u006e\u0074\u0061\u0069\u006e\u0065\u0072`);
      console.log(`\u0065\u006e\u0064\u005f\u0063\u006f\u006e\u0074\u0061\u0069\u006e\u0065\u0072`, end_container);
      if (end_container && end_container.length > 0) {
        if (end_num > 1) {
          console.log(`\u5904\u7406\u5b8c\u6210`);
          return;
        }
        end_num++;
      }
    }
  } catch (e) {
    console.log(`\u0061\u0075\u0074\u006f\u004c\u0069\u006b\u0065\u0046\u006c\u006f\u0077`, e);
  } finally {
    if (last_date) {
      console.log(`\u006c\u0061\u0073\u0074\u005f\u0064\u0061\u0074\u0065`, last_date);
      store$6.setLastLikeFlowDate(last_date);
    }
  }
}
const store$5 = UseCounterStore.getInstance();
let XiaoHongShu_Setting$2 = JSON.parse(store$5.XiaoHongShu_Setting);
const isWithinProbabilityOpen$1 = 80;
const isWithinProbabilitysend_comments$1 = 20;
const isWithinProbabilityclickCommentLike$1 = 50;
const isWithinProbabilityfollow_click$1 = 5;
const isWithinProbabilitycollect_click$1 = 5;
let checkInterval$2 = null;
function runYourCode() {
  if (checkInterval$2) {
    clearInterval(checkInterval$2);
    checkInterval$2 = null;
  }
  let runBool = false;
  checkInterval$2 = setInterval(async () => {
    var _a, _b, _c, _d, _e, _f;
    if (runBool) {
      return;
    }
    runBool = true;
    try {
      const loginContainer = document.querySelector(`\u002e\u006c\u006f\u0067\u0069\u006e\u002d\u0063\u006f\u006e\u0074\u0061\u0069\u006e\u0065\u0072`);
      if (loginContainer) {
        console.log(`\u0055\u0073\u0065\u0072\u0020\u0069\u0073\u0020\u006e\u006f\u0074\u0020\u006c\u006f\u0067\u0067\u0065\u0064\u0020\u0069\u006e`);
      } else {
        const userEl = document.querySelector(`\u002e\u0073\u0069\u0064\u0065\u002d\u0062\u0061\u0072\u0020\u002e\u0075\u0073\u0065\u0072\u002e\u0073\u0069\u0064\u0065\u002d\u0062\u0061\u0072\u002d\u0063\u006f\u006d\u0070\u006f\u006e\u0065\u006e\u0074\u0020\u002e\u006c\u0069\u006e\u006b\u002d\u0077\u0072\u0061\u0070\u0070\u0065\u0072\u0020\u0061`);
        if (userEl) {
          const href = new URL(userEl.href).pathname;
          if (href) {
            const segments = href.split(`\u002f`);
            const userId = segments.pop() || ``;
            if (userId) {
              console.log(`\u627e\u5230\u98de\u4e66\u7528\u6237\u0049\u0064`, userId);
              sendLog(`\u627e\u5230\u98de\u4e66\u7528\u6237\u0049\u0064` + userId);
              clearInterval(checkInterval$2);
              checkInterval$2 = null;
              const accountRunNum = await checkXiaoHongShuAccountRunNum(`\u0078\u0069\u0061\u006f\u0048\u006f\u006e\u0067\u0053\u0068\u0075`, userId);
              if (!accountRunNum) {
                return;
              }
              await store$5.checkLoadend();
              if (!XiaoHongShu_Setting$2 || Object.keys(XiaoHongShu_Setting$2).length == 0) {
                XiaoHongShu_Setting$2 = JSON.parse(store$5.XiaoHongShu_Setting);
              }
              if (store$5.isNotRunWork()) {
                vipCloseEndFun(`\u0072\u0075\u006e\u0059\u006f\u0075\u0072\u0043\u006f\u0064\u0065`).then();
                return;
              }
              const taskData = await getTabTaskData();
              store$5.setChromeTabId(taskData == null ? void 0 : taskData.tabId);
              const taskName = (_a = taskData == null ? void 0 : taskData.tabData) == null ? void 0 : _a.taskName;
              sendLog(`\u0063\u0068\u0072\u006f\u006d\u0065\u0054\u0061\u0062\u0049\u0064\u0020\u003a` + (taskData == null ? void 0 : taskData.tabId));
              if (taskName == `\u5173\u952e\u8bcd`) {
                xiaoHongshuSearch(taskData).then(() => {}).catch(err => {
                  console.error(`\u0078\u0069\u0061\u006f\u0048\u006f\u006e\u0067\u0073\u0068\u0075\u0053\u0065\u0061\u0072\u0063\u0068`, err);
                });
              } else if (taskName == `\u4fe1\u606f\u6d41`) {
                const searchWord = ``;
                const get_keyword_bool = false;
                const next_change_time = 0;
                if ((_b = taskData == null ? void 0 : taskData.tabData) == null ? void 0 : _b.taskId) {
                  const date = /* @__PURE__ */new Date();
                  const year = date.getFullYear();
                  const month = String(date.getMonth() + 1).padStart(2, `\u0030`);
                  const day = String(date.getDate()).padStart(2, `\u0030`);
                  const hours = String(date.getHours()).padStart(2, `\u0030`);
                  const minutes = String(date.getMinutes()).padStart(2, `\u0030`);
                  const addDate = `${year}\u002d${month}\u002d${day}\u0020${hours}\u003a${minutes}`;
                  const saveInputs = {
                    "key": store$5.userId + (/* @__PURE__ */new Date()).getTime(),
                    "bucket": {
                      taskType: (_c = taskData == null ? void 0 : taskData.tabData) == null ? void 0 : _c.taskName,
                      taskPlatform: (_d = taskData == null ? void 0 : taskData.tabData) == null ? void 0 : _d.taskPlatform,
                      taskId: (_e = taskData == null ? void 0 : taskData.tabData) == null ? void 0 : _e.taskId,
                      searchWord: XiaoHongShu_Setting$2 == null ? void 0 : XiaoHongShu_Setting$2.searchWord,
                      addDate,
                      addTime: (/* @__PURE__ */new Date()).getTime()
                    },
                    "size": 0,
                    "content_type": `\u0073\u0074\u0072\u0069\u006e\u0067`,
                    "belong_to": store$5.userId + `\u005f\u0058\u0069\u0061\u006f\u0048\u006f\u006e\u0067\u0053\u0068\u0075\u005f\u0077\u006f\u0072\u006b\u005f\u006c\u0069\u0073\u0074`,
                    "object_metadata": {}
                  };
                  await saveComment$1(saveInputs);
                }
                xiaoHongshuClick_cover_ld_mask([], searchWord, get_keyword_bool, next_change_time).then(res => {
                  console.log(`\u0078\u0069\u0061\u006f\u0048\u006f\u006e\u0067\u0073\u0068\u0075\u0043\u006c\u0069\u0063\u006b\u005f\u0063\u006f\u0076\u0065\u0072\u005f\u006c\u0064\u005f\u006d\u0061\u0073\u006b\u0020\u0072\u0065\u0073`, res);
                }).catch(err => {
                  console.error(`\u0078\u0069\u0061\u006f\u0048\u006f\u006e\u0067\u0073\u0068\u0075\u0043\u006c\u0069\u0063\u006b\u005f\u0063\u006f\u0076\u0065\u0072\u005f\u006c\u0064\u005f\u006d\u0061\u0073\u006b`, err);
                }).finally(() => {
                  vipCloseEndFun(`\u4fe1\u606f\u6d41\u0020\u0065\u006e\u0064`).then();
                });
              } else if (taskName == `\u81ea\u52a8\u56de\u590d`) {
                auto_replyComment().then(res => {
                  console.log(`\u0061\u0075\u0074\u006f\u005f\u0072\u0065\u0070\u006c\u0079\u0043\u006f\u006d\u006d\u0065\u006e\u0074\u0020\u0072\u0065\u0073`, res);
                }).catch(err => {
                  console.log(`\u0061\u0075\u0074\u006f\u005f\u0072\u0065\u0070\u006c\u0079\u0043\u006f\u006d\u006d\u0065\u006e\u0074\u0020\u0065\u0072\u0072`, err);
                });
              } else if (taskName == `\u53d6\u6d88\u70b9\u8d5e\u7684\u5173\u6ce8`) {
                auto_like_unfollow((_f = taskData == null ? void 0 : taskData.tabData) == null ? void 0 : _f.note_url).then(res => {
                  console.log(`\u0061\u0075\u0074\u006f\u005f\u006c\u0069\u006b\u0065\u005f\u0075\u006e\u0066\u006f\u006c\u006c\u006f\u0077\u0020\u0072\u0065\u0073`, res);
                }).catch(err => {
                  console.log(`\u0061\u0075\u0074\u006f\u005f\u006c\u0069\u006b\u0065\u005f\u0075\u006e\u0066\u006f\u006c\u006c\u006f\u0077\u0020\u0065\u0072\u0072`, err);
                }).finally(() => {
                  console.log(`\u53d6\u6d88\u70b9\u8d5e\u7684\u5173\u6ce8\u0020\u0066\u0069\u006e\u0061\u006c\u006c\u0079`);
                  sendCloseTab(`\u0061\u0075\u0074\u006f\u005f\u006c\u0069\u006b\u0065\u005f\u0075\u006e\u0066\u006f\u006c\u006c\u006f\u0077`);
                });
              }
            } else {
              console.log(`\u6ca1\u6709\u627e\u5230\u7528\u6237\u767b\u5f55\u4fe1\u606f\u0069\u0064`);
            }
          }
        } else {
          console.log(`\u6ca1\u6709\u627e\u5230\u7528\u6237\u767b\u5f55\u4fe1\u606f`);
        }
      }
    } finally {
      runBool = false;
    }
  }, 1e3);
  setTimeout(() => {
    clearInterval(checkInterval$2);
    checkInterval$2 = null;
    console.log(`\u0046\u0069\u006e\u0069\u0073\u0068\u0065\u0064\u0020\u0063\u0068\u0065\u0063\u006b\u0069\u006e\u0067\u0020\u006c\u006f\u0067\u0069\u006e\u0020\u0073\u0074\u0061\u0074\u0075\u0073\u002e`);
  }, 10 * 60 * getRandomNumberInRange(1e3, 5e3));
}
async function xiaoHongshuSearch(taskData) {
  var _a, _b, _c, _d;
  while (true) {
    if (!(await checkDomPromise(`\u0023\u0073\u0065\u0061\u0072\u0063\u0068\u002d\u0069\u006e\u0070\u0075\u0074`))) {
      console.error(`\u6ca1\u6709\u627e\u5230`, `\u0023\u0073\u0065\u0061\u0072\u0063\u0068\u002d\u0069\u006e\u0070\u0075\u0074`);
      sendLog(`\u6ca1\u6709\u627e\u5230\u0020\u641c\u7d22\u6846`);
      return;
    }
    if (!(XiaoHongShu_Setting$2 == null ? void 0 : XiaoHongShu_Setting$2.searchWord)) {
      XiaoHongShu_Setting$2 = JSON.parse(store$5.XiaoHongShu_Setting);
    }
    if (!(XiaoHongShu_Setting$2 == null ? void 0 : XiaoHongShu_Setting$2.searchWord)) {
      console.error(`\u914d\u7f6e\u6ca1\u6709\u751f\u6548`, store$5.XiaoHongShu_Setting);
      sendLog(`\u914d\u7f6e\u6ca1\u6709\u751f\u6548`);
      return;
    }
    let keywords_list = [];
    keywords_list.push(XiaoHongShu_Setting$2 == null ? void 0 : XiaoHongShu_Setting$2.searchWord);
    let get_keyword_bool = true;
    let next_change_time = 0;
    store$5.setXHSKeywords_list(keywords_list);
    if ((_a = taskData == null ? void 0 : taskData.tabData) == null ? void 0 : _a.taskId) {
      const date = /* @__PURE__ */new Date();
      const year = date.getFullYear();
      const month = String(date.getMonth() + 1).padStart(2, `\u0030`);
      const day = String(date.getDate()).padStart(2, `\u0030`);
      const hours = String(date.getHours()).padStart(2, `\u0030`);
      const minutes = String(date.getMinutes()).padStart(2, `\u0030`);
      const addDate = `${year}\u002d${month}\u002d${day}\u0020${hours}\u003a${minutes}`;
      const saveInputs = {
        "key": store$5.userId + (/* @__PURE__ */new Date()).getTime(),
        "bucket": {
          taskType: (_b = taskData == null ? void 0 : taskData.tabData) == null ? void 0 : _b.taskName,
          taskPlatform: (_c = taskData == null ? void 0 : taskData.tabData) == null ? void 0 : _c.taskPlatform,
          taskId: (_d = taskData == null ? void 0 : taskData.tabData) == null ? void 0 : _d.taskId,
          searchWord: XiaoHongShu_Setting$2 == null ? void 0 : XiaoHongShu_Setting$2.searchWord,
          addDate,
          addTime: (/* @__PURE__ */new Date()).getTime()
        },
        "size": 0,
        "content_type": `\u0073\u0074\u0072\u0069\u006e\u0067`,
        "belong_to": store$5.userId + `\u005f\u0058\u0069\u0061\u006f\u0048\u006f\u006e\u0067\u0053\u0068\u0075\u005f\u0077\u006f\u0072\u006b\u005f\u006c\u0069\u0073\u0074`,
        "object_metadata": {}
      };
      await saveComment$1(saveInputs);
    }
    for (let i = 0; i < keywords_list.length; i++) {
      console.log(`\u0078\u0069\u0061\u006f\u0048\u006f\u006e\u0067\u0073\u0068\u0075\u0053\u0065\u0061\u0072\u0063\u0068`);
      const searchWord = keywords_list[i];
      if (store$5.isNotRunWork()) {
        return;
      }
      const searchInput = document.querySelector(`\u0023\u0073\u0065\u0061\u0072\u0063\u0068\u002d\u0069\u006e\u0070\u0075\u0074`);
      if (!searchInput) {
        sendLog(`\u6ca1\u6709\u627e\u5230\u641c\u7d22\u6846`);
        console.error(`\u6ca1\u6709\u627e\u5230\u641c\u7d22\u6846\uff0c\u91cd\u65b0\u5f00\u59cb`);
        return;
      }
      searchInput.value = searchWord;
      const event = new Event(`\u0069\u006e\u0070\u0075\u0074`, {
        bubbles: true,
        cancelable: true
      });
      searchInput.dispatchEvent(event);
      if (!(await checkDomPromise(`\u0064\u0069\u0076\u005b\u0063\u006c\u0061\u0073\u0073\u003d\u0022\u0073\u0065\u0061\u0072\u0063\u0068\u002d\u0069\u0063\u006f\u006e\u0022\u005d`))) {
        console.log(`\u67e5\u627e\u4e0d\u5230\u0020\u0064\u0069\u0076\u005b\u0063\u006c\u0061\u0073\u0073\u003d\u0022\u0073\u0065\u0061\u0072\u0063\u0068\u002d\u0069\u0063\u006f\u006e\u0022\u005d`);
        return;
      }
      const searchButton = document.querySelector(`\u0064\u0069\u0076\u005b\u0063\u006c\u0061\u0073\u0073\u003d\u0022\u0073\u0065\u0061\u0072\u0063\u0068\u002d\u0069\u0063\u006f\u006e\u0022\u005d`);
      if (searchButton) {
        console.log(`\u70b9\u51fb\u641c\u7d22\u6309\u94ae`);
        await click_button(searchButton);
      }
      if (store$5.isNotRunWork()) {
        sendLog(`\u505c\u6b62\u4e86`);
        return;
      }
      const keywords_list_res = await xiaoHongshuClick_short_note(searchWord, get_keyword_bool, next_change_time);
      if (keywords_list_res && keywords_list_res.length == 2) {
        const keywords_list_data = keywords_list_res[0];
        next_change_time = keywords_list_res[1];
        get_keyword_bool = false;
        if (keywords_list_data && keywords_list_data.length > 0) {
          for (let j = 0; j < keywords_list_data.length; j++) {
            keywords_list.push(keywords_list_data[j]);
          }
          sendLog(`\u006b\u0065\u0079\u0077\u006f\u0072\u0064\u0073\u005f\u006c\u0069\u0073\u0074` + JSON.stringify(keywords_list));
          store$5.setXHSKeywords_list(keywords_list);
        }
      }
    }
    store$5.increment_XiaoHongShu_search_runNumber();
    sendLog(`\u0058\u0069\u0061\u006f\u0048\u006f\u006e\u0067\u0053\u0068\u0075\u005f\u0073\u0065\u0061\u0072\u0063\u0068\u005f\u0072\u0075\u006e\u004e\u0075\u006d\u0062\u0065\u0072\uff1a` + store$5.XiaoHongShu_search_runNumber);
    if (store$5.XiaoHongShu_search_runNumber > 3) {
      sendLog(`\u0063\u006f\u006e\u0074\u0065\u006e\u0074\u0020\u0061\u0063\u0074\u0069\u0076\u0061\u0074\u0065\u0050\u0061\u0067\u0065\u0020\u0058\u0069\u0061\u006f\u0048\u006f\u006e\u0067\u0053\u0068\u0075\u005f\u0073\u0065\u0061\u0072\u0063\u0068\u005f\u0072\u0075\u006e\u004e\u0075\u006d\u0062\u0065\u0072\uff1a`, store$5.XiaoHongShu_search_runNumber);
      chrome.storage.local.set({
        "activatePage": indexPage
      });
      return;
    }
    if (store$5.isNotRunWork()) {
      return;
    }
    sendLog(`\u4e0b\u4e00\u6b21\u5f00\u59cb`);
  }
}
async function xiaoHongshuClick_short_note(searchWord, get_keyword_bool, next_change_time) {
  let keywords_list = [];
  try {
    if (!(await checkDomPromise(`\u002e\u0066\u0065\u0065\u0064\u0073\u002d\u0063\u006f\u006e\u0074\u0061\u0069\u006e\u0065\u0072`))) {
      sendLog(`\u6ca1\u6709\u627e\u5230\u641c\u7d22\u7ed3\u679c`);
    }
    if (store$5.isNotRunWork()) {
      sendLog(`\u505c\u6b62\u4e86\u0037`);
      return;
    }
    await delay(getRandomNumberInRange(1e3, 5e3));
    keywords_list = await xiaoHongshuClick_filter_box(searchWord, get_keyword_bool, next_change_time);
  } catch (e) {
    console.error(`\u0065\u0065`, e);
    sendLog(`\u0078\u0069\u0061\u006f\u0048\u006f\u006e\u0067\u0073\u0068\u0075\u0043\u006c\u0069\u0063\u006b\u005f\u0073\u0068\u006f\u0072\u0074\u005f\u006e\u006f\u0074\u0065` + e);
  }
  return keywords_list;
}
async function xiaoHongshuClick_filter_box(searchWord, get_keyword_bool, next_change_time) {
  console.log(`\u9009\u62e9\u8fc7\u6ee4`);
  if (!(await checkDomPromise(`\u002e\u0066\u0065\u0065\u0064\u0073\u002d\u0070\u0061\u0067\u0065\u0020\u002e\u0066\u0069\u006c\u0074\u0065\u0072`))) {
    console.error(`\u6ca1\u6709\u627e\u5230`, `\u002e\u0066\u0065\u0065\u0064\u0073\u002d\u0070\u0061\u0067\u0065\u0020\u002e\u0066\u0069\u006c\u0074\u0065\u0072`);
    sendLog(`\u6ca1\u6709\u627e\u5230\u0020\u9009\u62e9\u8fc7\u6ee4`);
    return;
  }
  if (store$5.isNotRunWork()) {
    sendLog(`\u505c\u6b62\u4e86\u0038`);
    return;
  }
  const filter_box = document.querySelector(`\u002e\u0066\u0065\u0065\u0064\u0073\u002d\u0070\u0061\u0067\u0065\u0020\u002e\u0066\u0069\u006c\u0074\u0065\u0072`);
  if (!filter_box) {
    console.error(`\u9519\u8bef\uff0c\u91cd\u65b0\u5f00\u59cb`);
    sendLog(`\u6ca1\u6709\u627e\u5230\u0020\u9009\u62e9\u8fc7\u6ee4`);
    return;
  }
  const rect = filter_box.getBoundingClientRect();
  const x = rect.left + rect.width / 2;
  const y = rect.top + rect.height / 2;
  console.log(`\u0078\u002c\u0079`, rect, x, y);
  const mouseOverEvent = new MouseEvent(`\u006d\u006f\u0075\u0073\u0065\u006f\u0076\u0065\u0072`, {
    view: window,
    bubbles: true,
    cancelable: true,
    clientX: x,
    clientY: y
  });
  filter_box.dispatchEvent(mouseOverEvent);
  const mouseMoveEvent = new MouseEvent(`\u006d\u006f\u0075\u0073\u0065\u006d\u006f\u0076\u0065`, {
    view: window,
    bubbles: true,
    cancelable: true,
    clientX: x,
    clientY: y
  });
  filter_box.dispatchEvent(mouseMoveEvent);
  const mouseEnterEvent = new MouseEvent(`\u006d\u006f\u0075\u0073\u0065\u0065\u006e\u0074\u0065\u0072`, {
    view: window,
    bubbles: true,
    cancelable: true,
    clientX: x,
    clientY: y
  });
  filter_box.dispatchEvent(mouseEnterEvent);
  await delay(getRandomNumberInRange(1e3, 5e3));
  return await xiaoHongshuClick_dropdown_container(searchWord, get_keyword_bool, next_change_time);
}
const getFilterElementEl = selector => {
  const xpathResult = Array.from(document.querySelectorAll(selector));
  let targetElement = null;
  if (!(XiaoHongShu_Setting$2 == null ? void 0 : XiaoHongShu_Setting$2.category)) {
    console.error(`\u6ca1\u6709\u914d\u7f6e\u0020\u0063\u0061\u0074\u0065\u0067\u006f\u0072\u0079`, XiaoHongShu_Setting$2 == null ? void 0 : XiaoHongShu_Setting$2.category);
    sendLog(`\u6ca1\u6709\u914d\u7f6e\u0020\u0063\u0061\u0074\u0065\u0067\u006f\u0072\u0079`);
    return;
  }
  for (let i = 0; i < xpathResult.length; i++) {
    const element = xpathResult[i];
    if (!element) {
      continue;
    }
    console.log(element);
    console.log(element.childElementCount, XiaoHongShu_Setting$2 == null ? void 0 : XiaoHongShu_Setting$2.category);
    if (element && element.childElementCount === 0 && element.textContent && element.textContent.trim() === (XiaoHongShu_Setting$2 == null ? void 0 : XiaoHongShu_Setting$2.category)) {
      targetElement = element;
      break;
    }
  }
  if (!targetElement) {
    console.log(`\u0045\u006c\u0065\u006d\u0065\u006e\u0074\u0020\u006e\u006f\u0074\u0020\u0066\u006f\u0075\u006e\u0064`, XiaoHongShu_Setting$2 == null ? void 0 : XiaoHongShu_Setting$2.category);
    sendLog(`\u6ca1\u6709\u914d\u7f6e\u0020\u0063\u0061\u0074\u0065\u0067\u006f\u0072\u0079`);
  }
  console.log(`\u0045\u006c\u0065\u006d\u0065\u006e\u0074\u0020\u0066\u006f\u0075\u006e\u0064\u003a`, targetElement);
  return targetElement;
};
async function xiaoHongshuClick_dropdown_container(searchWord, get_keyword_bool, next_change_time) {
  console.log(`\u9009\u62e9\u6700\u65b0`);
  if (store$5.isNotRunWork()) {
    sendLog(`\u505c\u6b62\u4e86\u0039`);
    return;
  }
  let targetElement = getFilterElementEl(`\u002e\u0066\u0069\u006c\u0074\u0065\u0072\u002d\u0063\u006f\u006e\u0074\u0061\u0069\u006e\u0065\u0072\u0020\u0073\u0070\u0061\u006e`);
  if (!targetElement) {
    targetElement = getFilterElementEl(`\u002e\u0064\u0072\u006f\u0070\u0064\u006f\u0077\u006e\u002d\u0063\u006f\u006e\u0074\u0061\u0069\u006e\u0065\u0072\u0020\u0073\u0070\u0061\u006e`);
  }
  if (targetElement) {
    await click_button(targetElement);
  }
  const filter_box = document.querySelector(`\u002e\u0066\u0065\u0065\u0064\u0073\u002d\u0070\u0061\u0067\u0065\u0020\u002e\u0066\u0069\u006c\u0074\u0065\u0072`);
  if (filter_box) {
    await click_button(filter_box);
  }
  if (!(await checkDomPromise(`\u002e\u0063\u006f\u0076\u0065\u0072\u002e\u006c\u0064\u002e\u006d\u0061\u0073\u006b`))) {
    console.error(`\u6ca1\u6709\u627e\u5230`, `\u002e\u0063\u006f\u0076\u0065\u0072\u002e\u006c\u0064\u002e\u006d\u0061\u0073\u006b`);
    sendLog(`\u6ca1\u6709\u627e\u5230\u641c\u7d22\u7ed3\u679c`);
    return;
  }
  return await xiaoHongshuClick_cover_ld_mask([], searchWord, get_keyword_bool, next_change_time);
}
async function xiaoHongshuClick_cover_ld_mask(viewedPaths, searchWord, get_keyword_bool, next_change_time) {
  let keywords_list = [];
  while (true) {
    try {
      sendLog(`\u0078\u0069\u0061\u006f\u0048\u006f\u006e\u0067\u0073\u0068\u0075\u0043\u006c\u0069\u0063\u006b\u005f\u0063\u006f\u0076\u0065\u0072\u005f\u006c\u0064\u005f\u006d\u0061\u0073\u006b`);
      if (store$5.isNotRunWork()) {
        vipCloseEndFun(`\u0078\u0069\u0061\u006f\u0048\u006f\u006e\u0067\u0073\u0068\u0075\u0043\u006c\u0069\u0063\u006b\u005f\u0063\u006f\u0076\u0065\u0072\u005f\u006c\u0064\u005f\u006d\u0061\u0073\u006b`).then();
        return [];
      }
      let elements_ = document.querySelectorAll(`\u002e\u006e\u006f\u0074\u0065\u002d\u0069\u0074\u0065\u006d`);
      let elements = Array.from(elements_);
      sendLog(`\u0065\u006c\u0065\u006d\u0065\u006e\u0074\u0073\u003a` + elements.length);
      const title_texts = [];
      if (XiaoHongShu_Setting$2.smartKeywords == `\u667a\u80fd\u5173\u952e\u8bcd`) {
        if (get_keyword_bool) {
          Array.from(elements).filter(element => {
            var _a;
            const title_el = element.querySelector(`\u002e\u0074\u0069\u0074\u006c\u0065`);
            if (!title_el) {
              return false;
            }
            const title_text = (_a = title_el.textContent) == null ? void 0 : _a.trim();
            title_texts.push(title_text);
          });
          sendLog(`\u0074\u0069\u0074\u006c\u0065\u005f\u0074\u0065\u0078\u0074\u0073\uff1a` + JSON.stringify(title_texts));
          keywords_list = await getKeywordsIntelligentAssociation(title_texts, searchWord);
          sendLog(`\u006b\u0065\u0079\u0077\u006f\u0072\u0064\u0073\u005f\u006c\u0069\u0073\u0074\uff1a` + JSON.stringify(keywords_list));
          get_keyword_bool = false;
          const lastTime = await queryLastTime();
          sendLog(`\u0058\u0069\u0061\u006f\u0048\u006f\u006e\u0067\u0053\u0068\u0075\u005f\u0053\u0065\u0074\u0074\u0069\u006e\u0067\u002e\u006f\u0070\u0065\u0072\u0061\u0074\u0069\u006f\u006e\u0054\u0069\u006d\u0065\u0020` + lastTime + `\u0020` + XiaoHongShu_Setting$2.operationTime);
          let keywords_len = keywords_list.length;
          sendLog(`\u006b\u0065\u0079\u0077\u006f\u0072\u0064\u0073\u005f\u006c\u0065\u006e\uff1a` + keywords_len);
          const operationTime = parseInt(XiaoHongShu_Setting$2.operationTime);
          const avgTime = Math.ceil(operationTime / keywords_len);
          sendLog(`\u0058\u0069\u0061\u006f\u0048\u006f\u006e\u0067\u0053\u0068\u0075\u005f\u0061\u0076\u0067\u0054\u0069\u006d\u0065\uff1a` + avgTime);
          store$5.setXiaoHongShu_avgTime(avgTime);
          next_change_time = lastTime;
        }
      }
      if (XiaoHongShu_Setting$2.workType == `\u5173\u952e\u8bcd` && XiaoHongShu_Setting$2.smartKeywords !== `\u667a\u80fd\u5173\u952e\u8bcd`) {
        store$5.setXiaoHongShu_avgTime(0);
      }
      let view_bool = false;
      let element_a_els = [];
      Array.from(elements).filter(element => {
        const element_a_el = element.querySelector(`\u002e\u0063\u006f\u0076\u0065\u0072\u002e\u006c\u0064\u002e\u006d\u0061\u0073\u006b`);
        if (!element_a_el) {
          return false;
        }
        const href = new URL(element_a_el.href).pathname;
        if (!viewedPaths.includes(href)) {
          element_a_els.push(element_a_el);
        }
      });
      elements = element_a_els;
      if (elements.length > 0) {
        const element = elements[0];
        await xiaoHongshu_list_processElements(element, view_bool);
        if (store$5.isNotRunWork()) {
          vipCloseEndFun(`\u0078\u0069\u0061\u006f\u0048\u006f\u006e\u0067\u0073\u0068\u0075\u0043\u006c\u0069\u0063\u006b\u005f\u0063\u006f\u0076\u0065\u0072\u005f\u006c\u0064\u005f\u006d\u0061\u0073\u006b\u0032`).then();
          break;
        }
        const href = new URL(element.href).pathname;
        viewedPaths.push(href);
      }
      if (!(await checkDomPromise(`\u002e\u0063\u006f\u0076\u0065\u0072\u002e\u006c\u0064\u002e\u006d\u0061\u0073\u006b`))) {
        sendLog(`\u6ca1\u6709\u627e\u5230\u002e\u0063\u006f\u0076\u0065\u0072\u002e\u006c\u0064\u002e\u006d\u0061\u0073\u006b`);
        break;
      }
      if (elements.length == 0) {
        const end_container = document.querySelectorAll(`\u002e\u0065\u006e\u0064\u002d\u0063\u006f\u006e\u0074\u0061\u0069\u006e\u0065\u0072`);
        sendLog(`\u0065\u006e\u0064\u005f\u0063\u006f\u006e\u0074\u0061\u0069\u006e\u0065\u0072` + end_container);
        if (end_container && end_container.length > 0) {
          sendLog(`\u0065\u006e\u0064\u005f\u0063\u006f\u006e\u0074\u0061\u0069\u006e\u0065\u0072\u0020\u5904\u7406\u5b8c\u6210`);
          break;
        } else {
          sendLog(`\u7ee7\u7eed\u5904\u7406`);
        }
      }
      if (XiaoHongShu_Setting$2.workType == `\u5173\u952e\u8bcd`) {
        const lastTime = await queryLastTime();
        sendLog(`\u006c\u0061\u0073\u0074\u0054\u0069\u006d\u0065\uff1a` + lastTime + `\u0020` + store$5.XiaoHongShu_avgTime);
        const operationTime = parseInt(XiaoHongShu_Setting$2.operationTime);
        if (store$5.XiaoHongShu_avgTime && lastTime !== null && lastTime !== void 0 && lastTime != next_change_time && lastTime != operationTime && lastTime % store$5.XiaoHongShu_avgTime == 0) {
          sendLog(`\u5f00\u59cb\u641c\u7d22\u4e0b\u4e00\u4e2a\u5173\u952e\u8bcd\u0020` + lastTime + `\u0020` + store$5.XiaoHongShu_avgTime + `\u0020` + operationTime);
          next_change_time = lastTime;
          break;
        }
      } else {
        const lastTime = await queryLastTime();
        sendLog(`\u0071\u0075\u0065\u0072\u0079\u004c\u0061\u0073\u0074\u0054\u0069\u006d\u0065\u0020\u006c\u0061\u0073\u0074\u0054\u0069\u006d\u0065\u003a` + lastTime);
        if (lastTime <= 0) {
          break;
        }
      }
    } catch (e) {
      sendLog(`\u0078\u0069\u0061\u006f\u0048\u006f\u006e\u0067\u0073\u0068\u0075\u0043\u006c\u0069\u0063\u006b\u005f\u0063\u006f\u0076\u0065\u0072\u005f\u006c\u0064\u005f\u006d\u0061\u0073\u006b\uff0c\u7ed3\u675f` + e);
      console.error(`\u0078\u0069\u0061\u006f\u0048\u006f\u006e\u0067\u0073\u0068\u0075\u0043\u006c\u0069\u0063\u006b\u005f\u0063\u006f\u0076\u0065\u0072\u005f\u006c\u0064\u005f\u006d\u0061\u0073\u006b`, e);
    }
  }
  return [keywords_list, next_change_time];
}
async function xiaoHongshu_list_processElements(element, view_bool = false) {
  try {
    sendLog(`\u5f00\u59cb\u4e0b\u4e00\u4e2a\u7b14\u8bb0\u0031`);
    if (!(await checkDomByDom(element))) {
      return;
    }
    sendLog(`\u5f00\u59cb\u4e0b\u4e00\u4e2a\u7b14\u8bb0\u0032`);
    if (store$5.isNotRunWork()) {
      return;
    }
    console.log(`\u0065\u006c\u0065\u006d\u0065\u006e\u0074`, element);
    ensureElementVisible2(element);
    if (store$5.isNotRunWork()) {
      return;
    }
    if (!view_bool) {
      if (isWithinProbability(isWithinProbabilityOpen$1)) {
        await xiaoHongshu_tuwen_open(element);
        await delay(getRandomNumberInRange(3e3, 6e3));
      } else {
        console.log(`\u8df3\u8fc7\u0020\u4e0d\u6253\u5f00\u56fe\u6587`);
        await delay(getRandomNumberInRange(1e3, 5e3));
      }
    } else {
      console.log(`\u53ea\u662f\u4e3a\u4e86\u6eda\u52a8\u9875\u9762\uff0c\u4e0d\u505a\u4efb\u4f55\u7684\u64cd\u4f5c`);
    }
  } catch (e) {
    sendLog(`\u0078\u0069\u0061\u006f\u0048\u006f\u006e\u0067\u0073\u0068\u0075\u005f\u006c\u0069\u0073\u0074\u005f\u0070\u0072\u006f\u0063\u0065\u0073\u0073\u0045\u006c\u0065\u006d\u0065\u006e\u0074\u0073\u0020\u0065\u0072\u0072\u006f\u0072` + e);
    console.error(e);
  } finally {
    console.log(`\u0041\u006c\u006c\u0020\u0065\u006c\u0065\u006d\u0065\u006e\u0074\u0073\u0020\u0068\u0061\u0076\u0065\u0020\u0062\u0065\u0065\u006e\u0020\u0070\u0072\u006f\u0063\u0065\u0073\u0073\u0065\u0064\u002e`);
  }
}
async function xiaoHongshu_tuwen_open(element) {
  try {
    await click_button(element);
    console.log(`\u0065\u006c\u0065\u006d\u0065\u006e\u0074`, element);
    store$5.increment_xhs_viewCount();
    await xiaoHongshu_tuwen_start_exec();
    if (store$5.isNotRunWork()) {
      return;
    }
    await delay(getRandomNumberInRange(1e3, 5e3));
    if (!(await checkDomPromise(`\u002e\u0063\u006c\u006f\u0073\u0065\u002d\u0063\u0069\u0072\u0063\u006c\u0065\u0020\u002e\u0072\u0065\u0064\u0073\u002d\u0069\u0063\u006f\u006e`))) {
      return;
    }
    if (store$5.isNotRunWork()) {
      return;
    }
    const reds_icon_el = document.querySelector(`\u002e\u0063\u006c\u006f\u0073\u0065\u002d\u0063\u0069\u0072\u0063\u006c\u0065\u0020\u002e\u0072\u0065\u0064\u0073\u002d\u0069\u0063\u006f\u006e`);
    if (!reds_icon_el) {
      console.log(`\u6b63\u5728\u5173\u95ed\u6253\u5f00\u7684\u56fe\u6587\u0020\u6ca1\u6709\u627e\u5230\u5173\u95ed\u56fe\u6807`);
      return;
    }
    await click_button(reds_icon_el);
  } catch (e) {
    console.error(`\u0078\u0069\u0061\u006f\u0048\u006f\u006e\u0067\u0073\u0068\u0075\u005f\u0074\u0075\u0077\u0065\u006e\u005f\u006f\u0070\u0065\u006e\u0020\u0065\u0072\u0072\u006f\u0072`, e);
    sendLog(`\u0078\u0069\u0061\u006f\u0048\u006f\u006e\u0067\u0073\u0068\u0075\u005f\u0074\u0075\u0077\u0065\u006e\u005f\u006f\u0070\u0065\u006e\u0020\u0065\u0072\u0072\u006f\u0072` + e);
  }
}
async function xiaoHongshu_tuwen_start_exec() {
  if (!(await checkDomPromise(`\u0023\u0064\u0065\u0074\u0061\u0069\u006c\u002d\u0064\u0065\u0073\u0063`))) {
    console.error(`\u6ca1\u6709\u627e\u5230`, `\u0023\u0064\u0065\u0074\u0061\u0069\u006c\u002d\u0064\u0065\u0073\u0063`);
    return;
  }
  if (store$5.isNotRunWork()) {
    return;
  }
  const stringList = [];
  if (XiaoHongShu_Setting$2.reviewProbability == `\u9ed8\u8ba4\u0041\u0049\u63a7\u5236`) {
    if (isWithinProbability(isWithinProbabilitysend_comments$1)) {
      stringList.push(`\u0078\u0069\u0061\u006f\u0048\u006f\u006e\u0067\u0073\u0068\u0075\u005f\u0073\u0065\u006e\u0064\u005f\u0063\u006f\u006d\u006d\u0065\u006e\u0074\u0073`);
    } else {
      console.log(`\u8df3\u8fc7\u0020\u4e0d\u8bc4\u8bba`);
    }
  } else if (XiaoHongShu_Setting$2.reviewProbability == `\u81ea\u5b9a\u4e49\u6982\u7387` && XiaoHongShu_Setting$2.customProbabilitiesNum && isWithinProbability(XiaoHongShu_Setting$2.customProbabilitiesNum)) {
    stringList.push(`\u0078\u0069\u0061\u006f\u0048\u006f\u006e\u0067\u0073\u0068\u0075\u005f\u0073\u0065\u006e\u0064\u005f\u0063\u006f\u006d\u006d\u0065\u006e\u0074\u0073`);
  }
  if (XiaoHongShu_Setting$2 == null ? void 0 : XiaoHongShu_Setting$2.like) {
    if (isWithinProbability(isWithinProbabilityclickCommentLike$1)) {
      stringList.push(`\u0078\u0069\u0061\u006f\u0048\u006f\u006e\u0067\u0053\u0068\u0075\u005f\u0063\u006c\u0069\u0063\u006b\u0043\u006f\u006d\u006d\u0065\u006e\u0074\u004c\u0069\u006b\u0065`);
    } else {
      console.log(`\u8df3\u8fc7\u0020\u4e0d\u70b9\u8d5e`);
    }
  }
  if (XiaoHongShu_Setting$2 == null ? void 0 : XiaoHongShu_Setting$2.follow) {
    if (isWithinProbability(isWithinProbabilityfollow_click$1)) {
      stringList.push(`\u0078\u0069\u0061\u006f\u0048\u006f\u006e\u0067\u0053\u0068\u0075\u005f\u0066\u006f\u006c\u006c\u006f\u0077\u005f\u0063\u006c\u0069\u0063\u006b`);
    } else {
      console.log(`\u8df3\u8fc7\u0020\u4e0d\u5173\u6ce8`);
    }
  }
  if (XiaoHongShu_Setting$2 == null ? void 0 : XiaoHongShu_Setting$2.collect) {
    if (isWithinProbability(isWithinProbabilitycollect_click$1)) {
      stringList.push(`\u0078\u0069\u0061\u006f\u0048\u006f\u006e\u0067\u0053\u0068\u0075\u005f\u0063\u006f\u006c\u006c\u0065\u0063\u0074\u005f\u0063\u006c\u0069\u0063\u006b`);
    } else {
      console.log(`\u8df3\u8fc7\u0020\u4e0d\u6536\u85cf`);
    }
  }
  await randomExecFunction(stringList);
}
async function randomExecFunction(strings) {
  let remainingStrings = [...strings];
  while (remainingStrings.length > 0) {
    if (store$5.isNotRunWork()) {
      return;
    }
    const randomIndex = Math.floor(Math.random() * remainingStrings.length);
    console.log(remainingStrings[randomIndex]);
    switch (remainingStrings[randomIndex]) {
      case `\u0078\u0069\u0061\u006f\u0048\u006f\u006e\u0067\u0073\u0068\u0075\u005f\u0073\u0065\u006e\u0064\u005f\u0063\u006f\u006d\u006d\u0065\u006e\u0074\u0073`:
        await xiaoHongshu_tuwen_read_info();
        break;
      case `\u0078\u0069\u0061\u006f\u0048\u006f\u006e\u0067\u0053\u0068\u0075\u005f\u0063\u006c\u0069\u0063\u006b\u0043\u006f\u006d\u006d\u0065\u006e\u0074\u004c\u0069\u006b\u0065`:
        await xiaoHongShu_clickCommentLike();
        break;
      case `\u0078\u0069\u0061\u006f\u0048\u006f\u006e\u0067\u0053\u0068\u0075\u005f\u0066\u006f\u006c\u006c\u006f\u0077\u005f\u0063\u006c\u0069\u0063\u006b`:
        await xiaoHongShu_follow_click();
        break;
      case `\u0078\u0069\u0061\u006f\u0048\u006f\u006e\u0067\u0053\u0068\u0075\u005f\u0063\u006f\u006c\u006c\u0065\u0063\u0074\u005f\u0063\u006c\u0069\u0063\u006b`:
        await xiaoHongShu_collect_click();
        break;
      default:
        console.error(`\u9519\u8bef\u4fe1\u606f`, remainingStrings[randomIndex]);
    }
    remainingStrings.splice(randomIndex, 1);
  }
}
async function xiaoHongshu_tuwen_read_info() {
  var _a, _b;
  if (!(await checkDomPromise(`\u0023\u0064\u0065\u0074\u0061\u0069\u006c\u002d\u0064\u0065\u0073\u0063`))) {
    console.error(`\u6ca1\u6709\u627e\u5230`, `\u0023\u0064\u0065\u0074\u0061\u0069\u006c\u002d\u0064\u0065\u0073\u0063`);
    return;
  }
  if (store$5.isNotRunWork()) {
    return;
  }
  const img_container_el = document.querySelector(`\u002e\u0073\u0077\u0069\u0070\u0065\u0072\u002d\u0073\u006c\u0069\u0064\u0065\u002e\u0073\u0077\u0069\u0070\u0065\u0072\u002d\u0073\u006c\u0069\u0064\u0065\u002d\u0076\u0069\u0073\u0069\u0062\u006c\u0065\u002e\u0073\u0077\u0069\u0070\u0065\u0072\u002d\u0073\u006c\u0069\u0064\u0065\u002d\u0061\u0063\u0074\u0069\u0076\u0065\u0020\u002e\u0069\u006d\u0067\u002d\u0063\u006f\u006e\u0074\u0061\u0069\u006e\u0065\u0072\u0020\u002e\u006e\u006f\u0074\u0065\u002d\u0073\u006c\u0069\u0064\u0065\u0072\u002d\u0069\u006d\u0067`);
  let img_container_url = ``;
  if (img_container_el) {
    img_container_url = img_container_el.src;
  }
  console.log(`\u0069\u006d\u0067\u005f\u0063\u006f\u006e\u0074\u0061\u0069\u006e\u0065\u0072\u005f\u0065\u006c\u003a`, img_container_el);
  console.log(`\u0069\u006d\u0067\u005f\u0063\u006f\u006e\u0074\u0061\u0069\u006e\u0065\u0072\u005f\u0075\u0072\u006c\u003a` + img_container_url);
  const detail_title_el = document.querySelector(`\u0023\u0064\u0065\u0074\u0061\u0069\u006c\u002d\u0074\u0069\u0074\u006c\u0065`);
  let detail_title = ``;
  if (detail_title_el) {
    detail_title = ((_a = detail_title_el.textContent) == null ? void 0 : _a.trim()) || ``;
  }
  console.log(`\u0064\u0065\u0074\u0061\u0069\u006c\u005f\u0074\u0069\u0074\u006c\u0065\u005f\u0065\u006c\u003a`, detail_title_el);
  console.log(`\u0064\u0065\u0074\u0061\u0069\u006c\u005f\u0074\u0069\u0074\u006c\u0065\u003a`, detail_title);
  const detail_content_els = document.querySelectorAll(`\u0023\u0064\u0065\u0074\u0061\u0069\u006c\u002d\u0064\u0065\u0073\u0063\u0020\u0073\u0070\u0061\u006e`);
  let detail_content = ``;
  if (detail_content_els && detail_content_els.length > 0) {
    detail_content = ((_b = detail_content_els[0].textContent) == null ? void 0 : _b.trim()) || ``;
  }
  console.log(`\u0064\u0065\u0074\u0061\u0069\u006c\u005f\u0063\u006f\u006e\u0074\u0065\u006e\u0074\u005f\u0065\u006c\u0073\u003a`, detail_content_els);
  console.log(`\u0064\u0065\u0074\u0061\u0069\u006c\u005f\u0063\u006f\u006e\u0074\u0065\u006e\u0074\u003a`, detail_content);
  const detail_tags_els = document.querySelectorAll(`\u0023\u0064\u0065\u0074\u0061\u0069\u006c\u002d\u0064\u0065\u0073\u0063\u0020\u0061`);
  let detail_tags = [];
  detail_tags_els.forEach(detail_tags_el => {
    var _a2;
    if (detail_tags_el && detail_tags_el.textContent) {
      detail_tags.push((_a2 = detail_tags_el.textContent) == null ? void 0 : _a2.trim());
    }
  });
  let detail_tag_str = detail_tags.join(`\u0020`);
  console.log(`\u0064\u0065\u0074\u0061\u0069\u006c\u005f\u0074\u0061\u0067\u0073\u005f\u0065\u006c\u0073\u003a`, detail_tags_els);
  console.log(`\u0064\u0065\u0074\u0061\u0069\u006c\u005f\u0074\u0061\u0067\u005f\u0073\u0074\u0072\u003a`, detail_tag_str);
  let extra_image_id = ``;
  if (img_container_url) {
    const pathname = new URL(img_container_url).pathname;
    extra_image_id = getLastPathName$1(pathname);
  }
  if (store$5.isNotRunWork()) {
    return;
  }
  const currentUrl = window.location.href;
  const parsedUrl = new URL(currentUrl);
  const note_id = getLastPathName$1(parsedUrl.pathname);
  const user_infos = document.querySelectorAll(`\u002e\u0069\u006e\u0074\u0065\u0072\u0061\u0063\u0074\u0069\u006f\u006e\u002d\u0063\u006f\u006e\u0074\u0061\u0069\u006e\u0065\u0072\u0020\u002e\u0061\u0075\u0074\u0068\u006f\u0072\u002d\u0077\u0072\u0061\u0070\u0070\u0065\u0072\u0020\u002e\u0069\u006e\u0066\u006f\u0020\u0061`);
  let comment_user_url = ``;
  let comment_user_id = ``;
  if (user_infos && user_infos.length > 0) {
    const user_info = user_infos[0];
    comment_user_url = user_info.href;
    if (comment_user_url) {
      const pathname = new URL(comment_user_url).pathname;
      comment_user_id = getLastPathName$1(pathname);
    }
  }
  sendLog(`\u0050\u0061\u0074\u0068\u003a\u0020` + store$5.userId + `\u0020\u0020` + note_id);
  const refer_id = `\u0058\u0069\u0061\u006f\u0048\u006f\u006e\u0067\u0053\u0068\u0075\u005f\u0063\u006f\u006d\u006d\u0065\u006e\u0074\u005f\u0075\u0073\u0065\u0072\u005f` + store$5.userId + `\u005f\u0070\u0061\u0074\u0068\u005f` + note_id;
  const ogVideoMeta = document.querySelector(`\u006d\u0065\u0074\u0061\u005b\u006e\u0061\u006d\u0065\u003d\u0022\u006f\u0067\u003a\u0076\u0069\u0064\u0065\u006f\u0022\u005d`);
  if (await queryComment$1(refer_id)) {
    let result = null;
    if (ogVideoMeta) {
      const textContent_str = await get_xiaoHongshu_send_child_comment();
      sendLog(`\u56fe\u6587\u0020\u0058\u0069\u0061\u006f\u0048\u006f\u006e\u0067\u0053\u0068\u0075\u005f\u0053\u0065\u0074\u0074\u0069\u006e\u0067\u002e\u0063\u006f\u006d\u006d\u0065\u006e\u0074\u0042\u006c\u006f\u0063\u006b\u0069\u006e\u0067\u003a\u0020` + XiaoHongShu_Setting$2.commentBlocking);
      console.log(`\u56fe\u6587\u0020\u0058\u0069\u0061\u006f\u0048\u006f\u006e\u0067\u0053\u0068\u0075\u005f\u0053\u0065\u0074\u0074\u0069\u006e\u0067\u002e\u0063\u006f\u006d\u006d\u0065\u006e\u0074\u0042\u006c\u006f\u0063\u006b\u0069\u006e\u0067\u003a\u0020` + XiaoHongShu_Setting$2.commentBlocking);
      if (XiaoHongShu_Setting$2.commentBlocking == `\u8bc4\u8bba\u622a\u6d41` && XiaoHongShu_Setting$2.commentBlockingNum > 0) {
        const callbackFun = async () => {
          const inputs22 = {
            titles: detail_title,
            test: detail_content,
            tab: detail_tag_str,
            commentaries: textContent_str,
            style: XiaoHongShu_Setting$2 == null ? void 0 : XiaoHongShu_Setting$2.style,
            key_message: XiaoHongShu_Setting$2 == null ? void 0 : XiaoHongShu_Setting$2.keywordInfo
          };
          result = await runWorkflowVideoReviews(inputs22, []);
          return result;
        };
        await xiaoHongshu_send_child_comment(callbackFun);
      }
      const inputs2 = {
        titles: detail_title,
        test: detail_content,
        tab: detail_tag_str,
        commentaries: textContent_str,
        style: XiaoHongShu_Setting$2 == null ? void 0 : XiaoHongShu_Setting$2.style,
        key_message: XiaoHongShu_Setting$2 == null ? void 0 : XiaoHongShu_Setting$2.keywordInfo
      };
      result = await runWorkflowVideoReviews(inputs2, []);
    } else {
      sendLog(`\u6ca1\u6709\u914d\u7f6e\u0020\u0073\u0074\u0079\u006c\u0065\u0020` + (XiaoHongShu_Setting$2 == null ? void 0 : XiaoHongShu_Setting$2.style) + `\u0020` + (XiaoHongShu_Setting$2 == null ? void 0 : XiaoHongShu_Setting$2.keywordInfo));
      const inputs = {
        title: detail_title,
        text: detail_content,
        label: detail_tag_str,
        style: XiaoHongShu_Setting$2 == null ? void 0 : XiaoHongShu_Setting$2.style,
        key_message: XiaoHongShu_Setting$2 == null ? void 0 : XiaoHongShu_Setting$2.keywordInfo
      };
      const files = [];
      if (img_container_url) {
        files.push({
          type: `\u0069\u006d\u0061\u0067\u0065`,
          transfer_method: `\u0072\u0065\u006d\u006f\u0074\u0065\u005f\u0075\u0072\u006c`,
          url: img_container_url
        });
      }
      sendLog(`\u56fe\u6587\u0020\u0058\u0069\u0061\u006f\u0048\u006f\u006e\u0067\u0053\u0068\u0075\u005f\u0053\u0065\u0074\u0074\u0069\u006e\u0067\u002e\u0063\u006f\u006d\u006d\u0065\u006e\u0074\u0042\u006c\u006f\u0063\u006b\u0069\u006e\u0067\uff1a` + XiaoHongShu_Setting$2.commentBlocking);
      if (XiaoHongShu_Setting$2.commentBlocking == `\u8bc4\u8bba\u622a\u6d41` && XiaoHongShu_Setting$2.commentBlockingNum > 0) {
        const callbackFun = async () => {
          const apiKey2 = `\u0061\u0070\u0070\u002d\u0073\u0057\u0045\u004f\u0037\u0062\u0045\u0063\u0072\u0033\u0075\u0030\u004d\u0045\u0045\u0065\u0053\u0035\u0051\u0047\u006a\u0053\u004b\u0057`;
          result = await runWorkflow$1(inputs, files, apiKey2);
          return result;
        };
        await xiaoHongshu_send_child_comment(callbackFun);
      }
      const apiKey = `\u0061\u0070\u0070\u002d\u0073\u0057\u0045\u004f\u0037\u0062\u0045\u0063\u0072\u0033\u0075\u0030\u004d\u0045\u0045\u0065\u0053\u0035\u0051\u0047\u006a\u0053\u004b\u0057`;
      result = await runWorkflow$1(inputs, files, apiKey);
    }
    sendLog(`\u0072\u0065\u0073\u0075\u006c\u0074\u003a\u0020` + result);
    if (result) {
      const date = /* @__PURE__ */new Date();
      const year = date.getFullYear();
      const month = String(date.getMonth() + 1).padStart(2, `\u0030`);
      const day = String(date.getDate()).padStart(2, `\u0030`);
      const hours = String(date.getHours()).padStart(2, `\u0030`);
      const minutes = String(date.getMinutes()).padStart(2, `\u0030`);
      const addDate = `${year}\u002d${month}\u002d${day}\u0020${hours}\u003a${minutes}`;
      const saveInputsData = {
        refer_id,
        title: detail_title,
        //标题
        text: detail_content,
        // 详情内容
        label: detail_tag_str,
        // 标签
        style: XiaoHongShu_Setting$2 == null ? void 0 : XiaoHongShu_Setting$2.style,
        key_message: XiaoHongShu_Setting$2 == null ? void 0 : XiaoHongShu_Setting$2.keywordInfo,
        workType: XiaoHongShu_Setting$2 == null ? void 0 : XiaoHongShu_Setting$2.workType,
        searchWord: XiaoHongShu_Setting$2 == null ? void 0 : XiaoHongShu_Setting$2.searchWord,
        note_url: currentUrl,
        //帖子url
        note_id,
        //帖子id
        comment_user_url,
        // 帖子的作者url
        comment_user_id,
        // 帖子的作者id
        extra_image_id,
        // 帖子图片id
        extra_image_url: img_container_url,
        // 帖子图片url
        replyComment: result,
        // 评论内容
        userId: store$5.userId,
        // 用户id
        taskId: store$5.taskId,
        addDate,
        addTime: (/* @__PURE__ */new Date()).getTime()
      };
      const saveInputs = {
        "key": refer_id,
        "bucket": saveInputsData,
        "size": 0,
        "content_type": `\u0073\u0074\u0072\u0069\u006e\u0067`,
        "belong_to": store$5.userId + `\u005f\u0058\u0069\u0061\u006f\u0048\u006f\u006e\u0067\u0053\u0068\u0075\u005f\u0063\u006f\u006d\u006d\u0065\u006e\u0074`,
        "object_metadata": {}
      };
      await xiaoHongshu_send_comments(result, saveInputs);
    }
  } else {
    console.log(`\u5df2\u8bc4\u8bba\u8fc7\u3002\u8df3\u8fc7`);
  }
}
async function get_xiaoHongshu_send_child_comment() {
  var _a;
  const textContents = [];
  const parentComments = document.querySelectorAll(`\u002e\u0070\u0061\u0072\u0065\u006e\u0074\u002d\u0063\u006f\u006d\u006d\u0065\u006e\u0074\u0020\u003e\u0064\u0069\u0076\u003a\u006e\u0074\u0068\u002d\u0063\u0068\u0069\u006c\u0064\u0028\u0031\u0029`);
  for (let i = 0; i < 5; i++) {
    if (parentComments[i]) {
      const reply = parentComments[i].querySelector(`\u002e\u0063\u006f\u006e\u0074\u0065\u006e\u0074\u0020\u002e\u006e\u006f\u0074\u0065\u002d\u0074\u0065\u0078\u0074`);
      if (reply) {
        const textContent = (_a = reply.textContent) == null ? void 0 : _a.trim();
        textContents.push(textContent);
      }
    }
  }
  let textContent_str = ``;
  for (let i = 0; i < textContents.length; i++) {
    if (textContent_str) {
      textContent_str += `\u000a`;
    }
    textContent_str += i + 1 + `\u3001` + textContents[i];
  }
  return textContent_str;
}
async function xiaoHongshu_send_child_comment(callbackFun) {
  var _a;
  const chatWrapper = document.querySelectorAll(`\u002e\u0063\u0068\u0061\u0074\u002d\u0077\u0072\u0061\u0070\u0070\u0065\u0072\u0020\u002e\u0063\u006f\u0075\u006e\u0074`);
  const chatWrapperCountStr = (_a = chatWrapper[0].textContent) == null ? void 0 : _a.trim();
  console.log(`\u0063\u0068\u0061\u0074\u0057\u0072\u0061\u0070\u0070\u0065\u0072\u0043\u006f\u0075\u006e\u0074\u0053\u0074\u0072`, chatWrapperCountStr);
  if (chatWrapperCountStr) {
    let chatWrapperCount = parseInt(chatWrapperCountStr);
    if (XiaoHongShu_Setting$2.commentBlockingNum < chatWrapperCount) {
      console.log(`\u0063\u0068\u0061\u0074\u0057\u0072\u0061\u0070\u0070\u0065\u0072\u0043\u006f\u0075\u006e\u0074`, chatWrapperCount);
      const parentComments = document.querySelectorAll(`\u002e\u0070\u0061\u0072\u0065\u006e\u0074\u002d\u0063\u006f\u006d\u006d\u0065\u006e\u0074\u0020\u003e\u0064\u0069\u0076\u003a\u006e\u0074\u0068\u002d\u0063\u0068\u0069\u006c\u0064\u0028\u0031\u0029`);
      for (let i = 0; i < 3; i++) {
        if (parentComments[0]) {
          const reply = parentComments[i].querySelector(`\u002e\u0070\u0061\u0072\u0065\u006e\u0074\u002d\u0063\u006f\u006d\u006d\u0065\u006e\u0074\u0020\u003e\u0064\u0069\u0076\u003a\u006e\u0074\u0068\u002d\u0063\u0068\u0069\u006c\u0064\u0028\u0031\u0029\u0020\u002e\u0072\u0065\u0070\u006c\u0079`);
          if (reply) {
            ensureElementVisible2(reply);
            await click_button(reply);
            let content_str = await callbackFun();
            await xiaoHongshu_send_comments2(content_str);
          }
        }
      }
    }
  }
}
async function xiaoHongshu_send_comments2(content) {
  var _a;
  if (!content) {
    return;
  }
  if (store$5.isNotRunWork()) {
    return;
  }
  if (!(await checkDomPromise(`\u0023\u0063\u006f\u006e\u0074\u0065\u006e\u0074\u002d\u0074\u0065\u0078\u0074\u0061\u0072\u0065\u0061`))) {
    console.error(`\u6ca1\u6709\u627e\u5230`, `\u0023\u0063\u006f\u006e\u0074\u0065\u006e\u0074\u002d\u0074\u0065\u0078\u0074\u0061\u0072\u0065\u0061`);
    return;
  }
  const content_textarea = document.querySelector(`\u0023\u0063\u006f\u006e\u0074\u0065\u006e\u0074\u002d\u0074\u0065\u0078\u0074\u0061\u0072\u0065\u0061`);
  if (!content_textarea) {
    console.error(`\u6ca1\u6709\u627e\u5230\u8f93\u5165\u6846`);
    return;
  }
  console.log(`\u589e\u52a0\u8bc4\u8bba\u540e\u7f00\u4fe1\u606f`, XiaoHongShu_Setting$2 == null ? void 0 : XiaoHongShu_Setting$2.commentSuffix);
  if (XiaoHongShu_Setting$2 == null ? void 0 : XiaoHongShu_Setting$2.commentSuffix) {
    console.log(`\u589e\u52a0\u8bc4\u8bba\u540e\u7f00\u4fe1\u606f`, XiaoHongShu_Setting$2 == null ? void 0 : XiaoHongShu_Setting$2.commentSuffix);
    content += `\u000d\u000a` + (XiaoHongShu_Setting$2 == null ? void 0 : XiaoHongShu_Setting$2.commentSuffix);
  }
  await simulateInput(content, content_textarea);
  await delay(getRandomNumberInRange(1e3, 5e3));
  if (store$5.isNotRunWork()) {
    return;
  }
  for (let j = 0; j < 60; j++) {
    const submitGrayButton = document.querySelector(`\u002e\u0062\u0074\u006e\u002e\u0073\u0075\u0062\u006d\u0069\u0074\u002e\u0067\u0072\u0061\u0079`);
    if (submitGrayButton) {
      await delay(1e3);
    } else {
      break;
    }
  }
  const submit = document.querySelector(`\u002e\u0062\u0074\u006e\u002e\u0073\u0075\u0062\u006d\u0069\u0074`);
  if (!submit) {
    console.error(`\u70b9\u51fb\u53d1\u8868\u8bc4\u8bba\u5931\u8d25`);
    return;
  }
  await click_button(submit);
  if (!(await checkDomPromise(`\u002e\u0072\u0065\u0064\u0073\u002d\u0074\u006f\u0061\u0073\u0074\u002d\u0063\u006f\u006e\u0074\u0061\u0069\u006e\u0065\u0072\u0020\u002e\u0072\u0065\u0064\u0073\u002d\u0074\u006f\u0061\u0073\u0074\u002e\u0063\u0065\u006e\u0074\u0065\u0072`, null, 60, 500))) {
    console.error(`\u6ca1\u6709\u627e\u5230`, `\u002e\u0072\u0065\u0064\u0073\u002d\u0074\u006f\u0061\u0073\u0074\u002d\u0063\u006f\u006e\u0074\u0061\u0069\u006e\u0065\u0072\u0020\u002e\u0072\u0065\u0064\u0073\u002d\u0074\u006f\u0061\u0073\u0074\u002e\u0063\u0065\u006e\u0074\u0065\u0072`);
    return;
  }
  const response_text_el = document.querySelector(`\u002e\u0072\u0065\u0064\u0073\u002d\u0074\u006f\u0061\u0073\u0074\u002d\u0063\u006f\u006e\u0074\u0061\u0069\u006e\u0065\u0072\u0020\u002e\u0072\u0065\u0064\u0073\u002d\u0074\u006f\u0061\u0073\u0074\u002e\u0063\u0065\u006e\u0074\u0065\u0072`);
  if (!response_text_el) {
    console.error(`\u70b9\u51fb\u53d1\u8868\u8bc4\u8bba\u5931\u8d25\u0032`);
    return;
  }
  let response_text = ((_a = response_text_el.textContent) == null ? void 0 : _a.trim()) || ``;
  if (!response_text) {
    console.error(`\u70b9\u51fb\u53d1\u8868\u8bc4\u8bba\u5931\u8d25\u0020\u6587\u672c\u4e3a\u7a7a`);
    return;
  }
  switch (response_text) {
    case `\u4f5c\u8005\u53ea\u5141\u8bb8\u597d\u53cb\u8bc4\u8bba`:
      console.error(`\u4f5c\u8005\u53ea\u5141\u8bb8\u597d\u53cb\u8bc4\u8bba`);
      break;
    case `\u8bc4\u8bba\u6210\u529f`:
      store$5.increment_xhs_CommentCount();
      console.log(`\u8bc4\u8bba\u6210\u529f`);
      break;
    default:
      console.error(`\u0072\u0065\u0073\u0070\u006f\u006e\u0073\u0065\u005f\u0074\u0065\u0078\u0074`);
  }
  await delay(getRandomNumberInRange(1e3, 5e3));
}
async function xiaoHongshu_send_comments(content, saveInputs) {
  var _a;
  if (!(await checkDomPromise(`\u002e\u0063\u006f\u006e\u0074\u0065\u006e\u0074\u002d\u0065\u0064\u0069\u0074\u0020\u0064\u0069\u0076\u0020\u0064\u0069\u0076\u0020\u0073\u0070\u0061\u006e`))) {
    console.error(`\u6ca1\u6709\u627e\u5230`, `\u002e\u0063\u006f\u006e\u0074\u0065\u006e\u0074\u002d\u0065\u0064\u0069\u0074\u0020\u0064\u0069\u0076\u0020\u0064\u0069\u0076\u0020\u0073\u0070\u0061\u006e`);
    return;
  }
  if (store$5.isNotRunWork()) {
    return;
  }
  const content_edit = document.querySelector(`\u002e\u0063\u006f\u006e\u0074\u0065\u006e\u0074\u002d\u0065\u0064\u0069\u0074\u0020\u0064\u0069\u0076\u0020\u0064\u0069\u0076\u0020\u0073\u0070\u0061\u006e`);
  if (!content_edit) {
    console.error(`\u6ca1\u6709\u627e\u5230\u8f93\u5165\u8bc4\u8bba\u7684\u8f93\u5165\u6846`);
    return;
  }
  await click_button(content_edit);
  await delay(getRandomNumberInRange(1e3, 5e3));
  if (store$5.isNotRunWork()) {
    return;
  }
  if (!(await checkDomPromise(`\u0023\u0063\u006f\u006e\u0074\u0065\u006e\u0074\u002d\u0074\u0065\u0078\u0074\u0061\u0072\u0065\u0061`))) {
    console.error(`\u6ca1\u6709\u627e\u5230`, `\u0023\u0063\u006f\u006e\u0074\u0065\u006e\u0074\u002d\u0074\u0065\u0078\u0074\u0061\u0072\u0065\u0061`);
    return;
  }
  const content_textarea = document.querySelector(`\u0023\u0063\u006f\u006e\u0074\u0065\u006e\u0074\u002d\u0074\u0065\u0078\u0074\u0061\u0072\u0065\u0061`);
  if (!content_textarea) {
    console.error(`\u6ca1\u6709\u627e\u5230\u8f93\u5165\u6846`);
    return;
  }
  console.log(`\u589e\u52a0\u8bc4\u8bba\u540e\u7f00\u4fe1\u606f`, XiaoHongShu_Setting$2 == null ? void 0 : XiaoHongShu_Setting$2.commentSuffix);
  if (XiaoHongShu_Setting$2 == null ? void 0 : XiaoHongShu_Setting$2.commentSuffix) {
    console.log(`\u589e\u52a0\u8bc4\u8bba\u540e\u7f00\u4fe1\u606f`, XiaoHongShu_Setting$2 == null ? void 0 : XiaoHongShu_Setting$2.commentSuffix);
    content += `\u000d\u000a` + (XiaoHongShu_Setting$2 == null ? void 0 : XiaoHongShu_Setting$2.commentSuffix);
  }
  await simulateInput(content, content_textarea);
  await delay(getRandomNumberInRange(1e3, 5e3));
  if (store$5.isNotRunWork()) {
    return;
  }
  for (let j = 0; j < 60; j++) {
    const submitGrayButton = document.querySelector(`\u002e\u0062\u0074\u006e\u002e\u0073\u0075\u0062\u006d\u0069\u0074\u002e\u0067\u0072\u0061\u0079`);
    if (submitGrayButton) {
      await delay(1e3);
    } else {
      break;
    }
  }
  const submit = document.querySelector(`\u002e\u0062\u0074\u006e\u002e\u0073\u0075\u0062\u006d\u0069\u0074`);
  if (!submit) {
    console.error(`\u70b9\u51fb\u53d1\u8868\u8bc4\u8bba\u5931\u8d25`);
    return;
  }
  await click_button(submit);
  if (!(await checkDomPromise(`\u002e\u0072\u0065\u0064\u0073\u002d\u0074\u006f\u0061\u0073\u0074\u002d\u0063\u006f\u006e\u0074\u0061\u0069\u006e\u0065\u0072\u0020\u002e\u0072\u0065\u0064\u0073\u002d\u0074\u006f\u0061\u0073\u0074\u002e\u0063\u0065\u006e\u0074\u0065\u0072`, null, 60, 500))) {
    console.error(`\u6ca1\u6709\u627e\u5230`, `\u002e\u0072\u0065\u0064\u0073\u002d\u0074\u006f\u0061\u0073\u0074\u002d\u0063\u006f\u006e\u0074\u0061\u0069\u006e\u0065\u0072\u0020\u002e\u0072\u0065\u0064\u0073\u002d\u0074\u006f\u0061\u0073\u0074\u002e\u0063\u0065\u006e\u0074\u0065\u0072`);
    return;
  }
  const response_text_el = document.querySelector(`\u002e\u0072\u0065\u0064\u0073\u002d\u0074\u006f\u0061\u0073\u0074\u002d\u0063\u006f\u006e\u0074\u0061\u0069\u006e\u0065\u0072\u0020\u002e\u0072\u0065\u0064\u0073\u002d\u0074\u006f\u0061\u0073\u0074\u002e\u0063\u0065\u006e\u0074\u0065\u0072`);
  if (!response_text_el) {
    console.error(`\u70b9\u51fb\u53d1\u8868\u8bc4\u8bba\u5931\u8d25\u0032`);
    return;
  }
  let response_text = ((_a = response_text_el.textContent) == null ? void 0 : _a.trim()) || ``;
  if (!response_text) {
    console.error(`\u70b9\u51fb\u53d1\u8868\u8bc4\u8bba\u5931\u8d25\u0020\u6587\u672c\u4e3a\u7a7a`);
    return;
  }
  switch (response_text) {
    case `\u4f5c\u8005\u53ea\u5141\u8bb8\u597d\u53cb\u8bc4\u8bba`:
      console.error(`\u4f5c\u8005\u53ea\u5141\u8bb8\u597d\u53cb\u8bc4\u8bba`);
      break;
    case `\u8bc4\u8bba\u6210\u529f`:
      store$5.increment_xhs_CommentCount();
      console.log(`\u8bc4\u8bba\u6210\u529f`);
      await saveComment$1(saveInputs);
      break;
    default:
      console.error(`\u0072\u0065\u0073\u0070\u006f\u006e\u0073\u0065\u005f\u0074\u0065\u0078\u0074`);
  }
  await delay(getRandomNumberInRange(1e3, 5e3));
}
async function xiaoHongShu_clickCommentLike() {
  if (store$5.isNotRunWork()) {
    return;
  }
  if (!(XiaoHongShu_Setting$2 == null ? void 0 : XiaoHongShu_Setting$2.like)) {
    console.log(`\u4e0d\u9700\u8981\u70b9\u8d5e`);
    return;
  }
  if (!(await checkDomPromise(`\u0023\u006e\u006f\u0074\u0065\u0043\u006f\u006e\u0074\u0061\u0069\u006e\u0065\u0072\u0020\u002e\u0069\u006e\u0074\u0065\u0072\u0061\u0063\u0074\u0069\u006f\u006e\u0073\u002e\u0065\u006e\u0067\u0061\u0067\u0065\u002d\u0062\u0061\u0072\u0020\u002e\u006c\u0069\u006b\u0065\u002d\u0077\u0072\u0061\u0070\u0070\u0065\u0072\u002e\u006c\u0069\u006b\u0065\u002d\u0061\u0063\u0074\u0069\u0076\u0065`))) {
    console.error(`\u6ca1\u6709\u627e\u5230`, `\u0023\u006e\u006f\u0074\u0065\u0043\u006f\u006e\u0074\u0061\u0069\u006e\u0065\u0072\u0020\u002e\u0069\u006e\u0074\u0065\u0072\u0061\u0063\u0074\u0069\u006f\u006e\u0073\u002e\u0065\u006e\u0067\u0061\u0067\u0065\u002d\u0062\u0061\u0072\u0020\u002e\u006c\u0069\u006b\u0065\u002d\u0077\u0072\u0061\u0070\u0070\u0065\u0072\u002e\u006c\u0069\u006b\u0065\u002d\u0061\u0063\u0074\u0069\u0076\u0065`);
    return;
  }
  if (store$5.isNotRunWork()) {
    return;
  }
  const like_span = document.querySelector(`\u0023\u006e\u006f\u0074\u0065\u0043\u006f\u006e\u0074\u0061\u0069\u006e\u0065\u0072\u0020\u002e\u0069\u006e\u0074\u0065\u0072\u0061\u0063\u0074\u0069\u006f\u006e\u0073\u002e\u0065\u006e\u0067\u0061\u0067\u0065\u002d\u0062\u0061\u0072\u0020\u002e\u006c\u0069\u006b\u0065\u002d\u0077\u0072\u0061\u0070\u0070\u0065\u0072\u002e\u006c\u0069\u006b\u0065\u002d\u0061\u0063\u0074\u0069\u0076\u0065`);
  if (!like_span) {
    console.error(`\u6ca1\u6709\u627e\u5230\u70b9\u8d5e\u7684\u6807\u7b7e`);
    return;
  }
  const like_span_use = like_span.querySelector(`\u0023\u006e\u006f\u0074\u0065\u0043\u006f\u006e\u0074\u0061\u0069\u006e\u0065\u0072\u0020\u002e\u0069\u006e\u0074\u0065\u0072\u0061\u0063\u0074\u0069\u006f\u006e\u0073\u002e\u0065\u006e\u0067\u0061\u0067\u0065\u002d\u0062\u0061\u0072\u0020\u002e\u006c\u0069\u006b\u0065\u002d\u0077\u0072\u0061\u0070\u0070\u0065\u0072\u002e\u006c\u0069\u006b\u0065\u002d\u0061\u0063\u0074\u0069\u0076\u0065\u0020\u0075\u0073\u0065`);
  if (!like_span_use) {
    console.error(`\u6ca1\u6709\u627e\u5230\u70b9\u8d5e\u7684\u6807\u7b7e\u0020\u7684\u56fe\u6807`);
    return;
  }
  const xlinkHref = like_span_use.getAttribute(`\u0078\u006c\u0069\u006e\u006b\u003a\u0068\u0072\u0065\u0066`);
  console.log(`\u0054\u0068\u0065\u0020\u0075\u0073\u0065\u0020\u0074\u0061\u0067\u0020\u0020${xlinkHref}`);
  if (xlinkHref === `\u0023\u006c\u0069\u006b\u0065\u0064`) {
    console.log(`\u5df2\u7ecf\u70b9\u8d5e\u8fc7\u4e86`);
    return;
  } else if (xlinkHref === `\u0023\u006c\u0069\u006b\u0065`) ;else {
    console.error(`\u627e\u5230\u7684\u56fe\u6807\u6709\u9519\u8bef`);
    return;
  }
  await click_button(like_span);
  store$5.increment_xhs_likeCount();
  await delay(getRandomNumberInRange(1e3, 5e3));
}
async function xiaoHongShu_follow_click() {
  if (store$5.isNotRunWork()) {
    return;
  }
  if (!(XiaoHongShu_Setting$2 == null ? void 0 : XiaoHongShu_Setting$2.follow)) {
    console.log(`\u4e0d\u9700\u8981\u5173\u6ce8`);
    return;
  }
  if (!(await checkDomPromise(`\u0023\u006e\u006f\u0074\u0065\u0043\u006f\u006e\u0074\u0061\u0069\u006e\u0065\u0072\u0020\u002e\u0069\u006e\u0074\u0065\u0072\u0061\u0063\u0074\u0069\u006f\u006e\u002d\u0063\u006f\u006e\u0074\u0061\u0069\u006e\u0065\u0072\u0020\u002e\u0066\u006f\u006c\u006c\u006f\u0077\u002d\u0062\u0075\u0074\u0074\u006f\u006e`))) {
    console.error(`\u6ca1\u6709\u627e\u5230`, `\u0023\u006e\u006f\u0074\u0065\u0043\u006f\u006e\u0074\u0061\u0069\u006e\u0065\u0072\u0020\u002e\u0069\u006e\u0074\u0065\u0072\u0061\u0063\u0074\u0069\u006f\u006e\u002d\u0063\u006f\u006e\u0074\u0061\u0069\u006e\u0065\u0072\u0020\u002e\u0066\u006f\u006c\u006c\u006f\u0077\u002d\u0062\u0075\u0074\u0074\u006f\u006e`);
    return;
  }
  if (store$5.isNotRunWork()) {
    return;
  }
  const follow_div = document.querySelector(`\u0023\u006e\u006f\u0074\u0065\u0043\u006f\u006e\u0074\u0061\u0069\u006e\u0065\u0072\u0020\u002e\u0069\u006e\u0074\u0065\u0072\u0061\u0063\u0074\u0069\u006f\u006e\u002d\u0063\u006f\u006e\u0074\u0061\u0069\u006e\u0065\u0072\u0020\u002e\u0066\u006f\u006c\u006c\u006f\u0077\u002d\u0062\u0075\u0074\u0074\u006f\u006e`);
  if (!follow_div) {
    console.error(`\u6ca1\u6709\u627e\u5230\u0020\u5173\u6ce8\u7684\u6309\u94ae`);
    return;
  }
  const follow_div_outlined = document.querySelector(`\u0023\u006e\u006f\u0074\u0065\u0043\u006f\u006e\u0074\u0061\u0069\u006e\u0065\u0072\u0020\u002e\u0069\u006e\u0074\u0065\u0072\u0061\u0063\u0074\u0069\u006f\u006e\u002d\u0063\u006f\u006e\u0074\u0061\u0069\u006e\u0065\u0072\u0020\u002e\u0066\u006f\u006c\u006c\u006f\u0077\u002d\u0062\u0075\u0074\u0074\u006f\u006e\u002e\u006f\u0075\u0074\u006c\u0069\u006e\u0065\u0064`);
  if (follow_div_outlined) {
    console.error(`\u5df2\u5173\u6ce8\u4e86\uff0c\u4e0d\u9700\u8981\u91cd\u590d\u5173\u6ce8`);
    return;
  }
  await click_button(follow_div);
  store$5.increment_xhs_followCount();
  await delay(getRandomNumberInRange(1e3, 5e3));
}
async function xiaoHongShu_collect_click() {
  if (store$5.isNotRunWork()) {
    return;
  }
  if (!(XiaoHongShu_Setting$2 == null ? void 0 : XiaoHongShu_Setting$2.collect)) {
    console.log(`\u4e0d\u9700\u8981\u6536\u85cf`);
    return;
  }
  if (!(await checkDomPromise(`\u0023\u006e\u006f\u0074\u0065\u0043\u006f\u006e\u0074\u0061\u0069\u006e\u0065\u0072\u0020\u002e\u0069\u006e\u0074\u0065\u0072\u0061\u0063\u0074\u0069\u006f\u006e\u0073\u002e\u0065\u006e\u0067\u0061\u0067\u0065\u002d\u0062\u0061\u0072\u0020\u002e\u0063\u006f\u006c\u006c\u0065\u0063\u0074\u002d\u0077\u0072\u0061\u0070\u0070\u0065\u0072`))) {
    console.error(`\u6ca1\u6709\u627e\u5230`, `\u0023\u006e\u006f\u0074\u0065\u0043\u006f\u006e\u0074\u0061\u0069\u006e\u0065\u0072\u0020\u002e\u0069\u006e\u0074\u0065\u0072\u0061\u0063\u0074\u0069\u006f\u006e\u0073\u002e\u0065\u006e\u0067\u0061\u0067\u0065\u002d\u0062\u0061\u0072\u0020\u002e\u0063\u006f\u006c\u006c\u0065\u0063\u0074\u002d\u0077\u0072\u0061\u0070\u0070\u0065\u0072`);
    return;
  }
  if (store$5.isNotRunWork()) {
    return;
  }
  const collect_span = document.querySelector(`\u0023\u006e\u006f\u0074\u0065\u0043\u006f\u006e\u0074\u0061\u0069\u006e\u0065\u0072\u0020\u002e\u0069\u006e\u0074\u0065\u0072\u0061\u0063\u0074\u0069\u006f\u006e\u0073\u002e\u0065\u006e\u0067\u0061\u0067\u0065\u002d\u0062\u0061\u0072\u0020\u002e\u0063\u006f\u006c\u006c\u0065\u0063\u0074\u002d\u0077\u0072\u0061\u0070\u0070\u0065\u0072`);
  if (!collect_span) {
    console.error(`\u6ca1\u6709\u627e\u5230\u70b9\u8d5e\u7684\u6807\u7b7e`);
    return;
  }
  const collect_span_use = collect_span.querySelector(`\u0023\u006e\u006f\u0074\u0065\u0043\u006f\u006e\u0074\u0061\u0069\u006e\u0065\u0072\u0020\u002e\u0069\u006e\u0074\u0065\u0072\u0061\u0063\u0074\u0069\u006f\u006e\u0073\u002e\u0065\u006e\u0067\u0061\u0067\u0065\u002d\u0062\u0061\u0072\u0020\u002e\u0063\u006f\u006c\u006c\u0065\u0063\u0074\u002d\u0077\u0072\u0061\u0070\u0070\u0065\u0072\u0020\u0075\u0073\u0065`);
  if (!collect_span_use) {
    console.error(`\u6ca1\u6709\u627e\u5230\u70b9\u8d5e\u7684\u6807\u7b7e\u0020\u7684\u56fe\u6807`);
    return;
  }
  const xlinkHref = collect_span_use.getAttribute(`\u0078\u006c\u0069\u006e\u006b\u003a\u0068\u0072\u0065\u0066`);
  console.log(`\u0054\u0068\u0065\u0020\u0075\u0073\u0065\u0020\u0074\u0061\u0067\u0020\u0020${xlinkHref}`);
  if (xlinkHref === `\u0023\u0063\u006f\u006c\u006c\u0065\u0063\u0074\u0065\u0064`) {
    console.log(`\u5df2\u7ecf\u6536\u85cf\u8fc7\u4e86`);
    return;
  } else if (xlinkHref === `\u0023\u0063\u006f\u006c\u006c\u0065\u0063\u0074`) ;else {
    console.error(`\u627e\u5230\u7684\u56fe\u6807\u6709\u9519\u8bef`);
    return;
  }
  await click_button(collect_span);
  store$5.increment_xhs_collectCount();
  await delay(getRandomNumberInRange(1e3, 5e3));
}
async function send_fei_shu_warn_message(title, content) {
  const url = `\u0068\u0074\u0074\u0070\u0073\u003a\u002f\u002f\u006f\u0070\u0065\u006e\u002e\u0066\u0065\u0069\u0073\u0068\u0075\u002e\u0063\u006e\u002f\u006f\u0070\u0065\u006e\u002d\u0061\u0070\u0069\u0073\u002f\u0062\u006f\u0074\u002f\u0076\u0032\u002f\u0068\u006f\u006f\u006b\u002f\u0035\u0065\u0030\u0037\u0062\u0034\u0036\u0065\u002d\u0063\u0036\u0030\u0035\u002d\u0034\u0033\u0061\u0031\u002d\u0039\u0062\u0062\u0034\u002d\u0063\u0063\u0064\u0063\u0065\u0066\u0064\u0034\u0066\u0035\u0039\u0036`;
  const headers = {
    "Content-Type": `\u0061\u0070\u0070\u006c\u0069\u0063\u0061\u0074\u0069\u006f\u006e\u002f\u006a\u0073\u006f\u006e`
  };
  try {
    const postData = {
      "msg_type": `\u0074\u0065\u0078\u0074`,
      "content": {
        "title": title,
        "text": `${content}\u000a\u89e6\u53d1\u65f6\u95f4\u003a\u0020${formatNowDateTimeSss()}`
      }
    };
    const response = await fetch(url, {
      method: `\u0050\u004f\u0053\u0054`,
      headers,
      body: JSON.stringify(postData)
    });
    if (!response.ok) {
      sendLog(`\u0075\u0072\u006c\u003a` + url + `\uff0c\u0068\u0065\u0061\u0064\u0065\u0072\u003a` + JSON.stringify(headers) + `\u002c\u0020\u0072\u0065\u0073\u0070\u006f\u006e\u0073\u0065\u0020\u0073\u0074\u0061\u0074\u0075\u0073\u003a` + response.status);
      console.error(`\u0048\u0054\u0054\u0050\u0020\u0065\u0072\u0072\u006f\u0072\u0021\u0020\u0073\u0074\u0061\u0074\u0075\u0073\u003a\u0020${response.status}`);
      if (response.status == 404) {
        return void 0;
      }
      return void 0;
    }
    const result = await response.json();
    sendLog(`\u0075\u0072\u006c\u003a` + url + `\uff0c\u0068\u0065\u0061\u0064\u0065\u0072\u003a` + JSON.stringify(headers) + `\u0020\u0072\u0065\u0073\u0070\u006f\u006e\u0073\u0065\u0020\u0073\u0074\u0061\u0074\u0075\u0073\u003a` + response.status + `\u002c\u0020\u0072\u0065\u0073\u0070\u006f\u006e\u0073\u0065\u0020\u0064\u0061\u0074\u0061\u003a` + JSON.stringify(result));
    console.log(`\u0072\u0065\u0073\u0075\u006c\u0074`, result);
    return result;
  } catch (error) {
    sendLog(`\u0075\u0072\u006c\u003a` + url + `\uff0c\u0068\u0065\u0061\u0064\u0065\u0072\u003a` + JSON.stringify(headers) + `\u002c\u0020\u0065\u0072\u0072\u006f\u0072` + error);
    console.error(`\u0045\u0072\u0072\u006f\u0072\u003a`, error);
  }
  return void 0;
}
const VITE_LOGIN_API = `\u0068\u0074\u0074\u0070\u0073\u003a\u002f\u002f\u0067\u006c\u006f\u0062\u0061\u006c\u002d\u0061\u0075\u0074\u0068\u002e\u0070\u0065\u0074\u0072\u006f\u006e\u002e\u0061\u0069`;
const store$4 = UseCounterStore.getInstance();
async function queryTenantsCorpus(tenant_id) {
  console.log(`\u0074\u0065\u006e\u0061\u006e\u0074\u0073\u004d\u0069\u006e\u0065`);
  const url = VITE_LOGIN_API + `\u002f\u0061\u0070\u0069\u002f\u0076\u0031\u002f\u0074\u0065\u006e\u0061\u006e\u0074\u0073\u002f${tenant_id}\u002f\u0063\u006f\u0072\u0070\u0075\u0073`;
  const headers = {
    "Content-Type": `\u0061\u0070\u0070\u006c\u0069\u0063\u0061\u0074\u0069\u006f\u006e\u002f\u006a\u0073\u006f\u006e`,
    "Authorization": `\u0042\u0065\u0061\u0072\u0065\u0072\u0020` + store$4.accessToken
  };
  try {
    const response = await fetch(url, {
      method: `\u0047\u0045\u0054`,
      headers
    });
    if (!response.ok) {
      sendLog(`\u0075\u0072\u006c\u003a` + url + `\uff0c\u0068\u0065\u0061\u0064\u0065\u0072\u003a` + JSON.stringify(headers) + `\u002c\u0020\u0072\u0065\u0073\u0070\u006f\u006e\u0073\u0065\u0020\u0073\u0074\u0061\u0074\u0075\u0073\u003a` + response.status);
      console.error(`\u0048\u0054\u0054\u0050\u0020\u0065\u0072\u0072\u006f\u0072\u0021\u0020\u0073\u0074\u0061\u0074\u0075\u0073\u003a\u0020${response.status}`);
      if (response.status === 401) {
        console.log(`\u767b\u5f55\u5931\u6548`);
        store$4.setAccessToken(``);
        store$4.set_updateVipDateTime(``);
        store$4.setUserInfoEndDate(``);
        await logout(store$4.accessToken);
      }
      if (response.status == 404) {
        return void 0;
      }
      return void 0;
    }
    const result = await response.json();
    sendLog(`\u0075\u0072\u006c\u003a` + url + `\uff0c\u0068\u0065\u0061\u0064\u0065\u0072\u003a` + JSON.stringify(headers) + `\u002c\u0020\u0072\u0065\u0073\u0070\u006f\u006e\u0073\u0065\u0020\u0073\u0074\u0061\u0074\u0075\u0073\u003a` + response.status + `\u002c\u0020\u0072\u0065\u0073\u0070\u006f\u006e\u0073\u0065\u0020\u0064\u0061\u0074\u0061\u003a` + JSON.stringify(result));
    console.log(`\u0072\u0065\u0073\u0075\u006c\u0074`, result);
    return result;
  } catch (error) {
    sendLog(`\u0075\u0072\u006c\u003a` + url + `\uff0c\u0068\u0065\u0061\u0064\u0065\u0072\u003a` + JSON.stringify(headers) + `\u002c\u0020\u0065\u0072\u0072\u006f\u0072` + error);
    console.error(`\u0045\u0072\u0072\u006f\u0072\u003a`, error);
  }
  return void 0;
}
const VITE_CHAT_API = `\u0068\u0074\u0074\u0070\u0073\u003a\u002f\u002f\u0077\u0065\u0063\u006f\u006d\u002d\u0063\u002d\u0072\u0065\u006c\u0065\u0061\u0073\u0065\u002d\u006c\u0062\u0065\u0063\u006b\u006c\u006b\u0068\u0061\u0061\u002e\u0063\u006e\u002d\u0068\u0075\u0068\u0065\u0068\u0061\u006f\u0074\u0065\u002e\u0066\u0063\u0061\u0070\u0070\u002e\u0072\u0075\u006e`;
const store$3 = UseCounterStore.getInstance();
const getReplyContent = async postData => {
  const url = VITE_CHAT_API + `\u002f\u0063\u0061\u006c\u006c`;
  const headers = {
    "Content-Type": `\u0061\u0070\u0070\u006c\u0069\u0063\u0061\u0074\u0069\u006f\u006e\u002f\u006a\u0073\u006f\u006e`,
    "Authorization": `\u0042\u0065\u0061\u0072\u0065\u0072\u0020` + store$3.accessToken
  };
  try {
    const response = await fetch(url, {
      method: `\u0050\u004f\u0053\u0054`,
      headers,
      body: JSON.stringify(postData)
    });
    if (!response.ok) {
      sendLog(`\u0061\u0064\u0064\u004f\u0062\u006a\u0065\u0063\u0074\u0073\u0020\u0075\u0072\u006c\u003a` + url + `\uff0c\u0068\u0065\u0061\u0064\u0065\u0072\u003a` + JSON.stringify(headers) + `\u002c\u0020\u0072\u0065\u0073\u0070\u006f\u006e\u0073\u0065\u0020\u0073\u0074\u0061\u0074\u0075\u0073\u003a` + response.status);
      console.error(`\u0048\u0054\u0054\u0050\u0020\u0065\u0072\u0072\u006f\u0072\u0021\u0020\u0073\u0074\u0061\u0074\u0075\u0073\u003a\u0020${response.status}`);
      return void 0;
    }
    const result = await response.json();
    sendLog(`\u0061\u0064\u0064\u004f\u0062\u006a\u0065\u0063\u0074\u0073\u0020\u0075\u0072\u006c\u003a` + url + `\uff0c\u0068\u0065\u0061\u0064\u0065\u0072\u003a` + JSON.stringify(headers) + `\u002c\u0070\u006f\u0073\u0074\u0044\u0061\u0074\u0061\uff1a` + JSON.stringify(postData) + `\u0020\u0072\u0065\u0073\u0070\u006f\u006e\u0073\u0065\u0020\u0073\u0074\u0061\u0074\u0075\u0073\u003a` + response.status + `\u002c\u0020\u0072\u0065\u0073\u0070\u006f\u006e\u0073\u0065\u0020\u0064\u0061\u0074\u0061\u003a` + JSON.stringify(result));
    console.log(`\u0072\u0065\u0073\u0075\u006c\u0074`, result);
    return result;
  } catch (error) {
    sendLog(`\u0061\u0064\u0064\u004f\u0062\u006a\u0065\u0063\u0074\u0073\u0020\u0075\u0072\u006c\u003a` + url + `\uff0c\u0068\u0065\u0061\u0064\u0065\u0072\u003a` + JSON.stringify(headers) + `\u002c\u0020\u0065\u0072\u0072\u006f\u0072` + error);
    console.error(`\u0045\u0072\u0072\u006f\u0072\u003a`, error);
  }
  return void 0;
};
async function saveChat(postData) {
  console.log(`\u0074\u0065\u006e\u0061\u006e\u0074\u0073\u004d\u0069\u006e\u0065`);
  const url = VITE_CHAT_API + `\u002f\u0061\u0070\u0069\u002f\u0076\u0031\u002f\u0063\u0068\u0061\u0074\u002f\u0073\u0061\u0076\u0065\u005f\u0063\u0068\u0061\u0074`;
  const headers = {
    "Content-Type": `\u0061\u0070\u0070\u006c\u0069\u0063\u0061\u0074\u0069\u006f\u006e\u002f\u006a\u0073\u006f\u006e`,
    "Authorization": `\u0042\u0065\u0061\u0072\u0065\u0072\u0020` + store$3.accessToken
  };
  try {
    const response = await fetch(url, {
      method: `\u0050\u004f\u0053\u0054`,
      headers,
      body: JSON.stringify(postData)
    });
    if (!response.ok) {
      sendLog(`\u0075\u0072\u006c\u003a` + url + `\uff0c\u0068\u0065\u0061\u0064\u0065\u0072\u003a` + JSON.stringify(headers) + `\u002c\u0020\u0072\u0065\u0073\u0070\u006f\u006e\u0073\u0065\u0020\u0073\u0074\u0061\u0074\u0075\u0073\u003a` + response.status);
      console.error(`\u0048\u0054\u0054\u0050\u0020\u0065\u0072\u0072\u006f\u0072\u0021\u0020\u0073\u0074\u0061\u0074\u0075\u0073\u003a\u0020${response.status}`);
      if (response.status === 401) {
        console.log(`\u767b\u5f55\u5931\u6548`);
        store$3.setAccessToken(``);
        store$3.set_updateVipDateTime(``);
        store$3.setUserInfoEndDate(``);
        await logout(store$3.accessToken);
      }
      if (response.status == 404) {
        return void 0;
      }
      return void 0;
    }
    const result = await response.json();
    sendLog(`\u0075\u0072\u006c\u003a` + url + `\uff0c\u0068\u0065\u0061\u0064\u0065\u0072\u003a` + JSON.stringify(headers) + `\u002c\u0020\u0072\u0065\u0073\u0070\u006f\u006e\u0073\u0065\u0020\u0073\u0074\u0061\u0074\u0075\u0073\u003a` + response.status + `\u002c\u0020\u0072\u0065\u0073\u0070\u006f\u006e\u0073\u0065\u0020\u0064\u0061\u0074\u0061\u003a` + JSON.stringify(result));
    console.log(`\u0072\u0065\u0073\u0075\u006c\u0074`, result);
    return result;
  } catch (error) {
    sendLog(`\u0075\u0072\u006c\u003a` + url + `\uff0c\u0068\u0065\u0061\u0064\u0065\u0072\u003a` + JSON.stringify(headers) + `\u002c\u0020\u0065\u0072\u0072\u006f\u0072` + error);
    console.error(`\u0045\u0072\u0072\u006f\u0072\u003a`, error);
  }
  return void 0;
}
const changeAccount = async postData => {
  const url = VITE_CHAT_API + `\u002f\u0061\u0070\u0069\u002f\u0076\u0031\u002f\u0063\u0068\u0061\u0074\u002f\u0063\u0068\u0061\u006e\u0067\u0065\u005f\u0061\u0063\u0063\u006f\u0075\u006e\u0074`;
  const headers = {
    "Content-Type": `\u0061\u0070\u0070\u006c\u0069\u0063\u0061\u0074\u0069\u006f\u006e\u002f\u006a\u0073\u006f\u006e`,
    "Authorization": `\u0042\u0065\u0061\u0072\u0065\u0072\u0020` + store$3.accessToken
  };
  try {
    const response = await fetch(url, {
      method: `\u0050\u004f\u0053\u0054`,
      headers,
      body: JSON.stringify(postData)
    });
    if (!response.ok) {
      sendLog(`\u0061\u0064\u0064\u004f\u0062\u006a\u0065\u0063\u0074\u0073\u0020\u0075\u0072\u006c\u003a` + url + `\uff0c\u0068\u0065\u0061\u0064\u0065\u0072\u003a` + JSON.stringify(headers) + `\u002c\u0020\u0072\u0065\u0073\u0070\u006f\u006e\u0073\u0065\u0020\u0073\u0074\u0061\u0074\u0075\u0073\u003a` + response.status);
      console.error(`\u0048\u0054\u0054\u0050\u0020\u0065\u0072\u0072\u006f\u0072\u0021\u0020\u0073\u0074\u0061\u0074\u0075\u0073\u003a\u0020${response.status}`);
      return void 0;
    }
    const result = await response.json();
    sendLog(`\u0061\u0064\u0064\u004f\u0062\u006a\u0065\u0063\u0074\u0073\u0020\u0075\u0072\u006c\u003a` + url + `\uff0c\u0068\u0065\u0061\u0064\u0065\u0072\u003a` + JSON.stringify(headers) + `\u002c\u0070\u006f\u0073\u0074\u0044\u0061\u0074\u0061\uff1a` + JSON.stringify(postData) + `\u0020\u0072\u0065\u0073\u0070\u006f\u006e\u0073\u0065\u0020\u0073\u0074\u0061\u0074\u0075\u0073\u003a` + response.status + `\u002c\u0020\u0072\u0065\u0073\u0070\u006f\u006e\u0073\u0065\u0020\u0064\u0061\u0074\u0061\u003a` + JSON.stringify(result));
    console.log(`\u0072\u0065\u0073\u0075\u006c\u0074`, result);
    return result;
  } catch (error) {
    sendLog(`\u0061\u0064\u0064\u004f\u0062\u006a\u0065\u0063\u0074\u0073\u0020\u0075\u0072\u006c\u003a` + url + `\uff0c\u0068\u0065\u0061\u0064\u0065\u0072\u003a` + JSON.stringify(headers) + `\u002c\u0020\u0065\u0072\u0072\u006f\u0072` + error);
    console.error(`\u0045\u0072\u0072\u006f\u0072\u003a`, error);
  }
  return void 0;
};
const store$2 = UseCounterStore.getInstance();
const VITE_AGENT_BUSINESS_API = `\u0068\u0074\u0074\u0070\u0073\u003a\u002f\u002f\u0070\u0072\u006f\u0064\u002d\u0061\u0067\u0062\u0075\u0073\u0069\u006e\u0065\u0073\u0073\u002d\u007a\u0079\u0071\u0066\u006c\u0078\u0069\u0064\u0074\u0068\u002e\u0063\u006e\u002d\u0068\u0075\u0068\u0065\u0068\u0061\u006f\u0074\u0065\u002e\u0066\u0063\u0061\u0070\u0070\u002e\u0072\u0075\u006e`;
async function saveTerminalBind(terminalId, postData) {
  console.log(`\u0074\u0065\u0072\u006d\u0069\u006e\u0061\u006c`, postData);
  const url = VITE_AGENT_BUSINESS_API + `\u002f\u0061\u0070\u0069\u002f\u0074\u0065\u0072\u006d\u0069\u006e\u0061\u006c\u002f` + terminalId + `\u002f\u0062\u0069\u006e\u0064`;
  const headers = {
    "Content-Type": `\u0061\u0070\u0070\u006c\u0069\u0063\u0061\u0074\u0069\u006f\u006e\u002f\u006a\u0073\u006f\u006e`,
    "Authorization": `\u0042\u0065\u0061\u0072\u0065\u0072\u0020` + store$2.accessToken
  };
  try {
    const response = await fetch(url, {
      method: `\u0050\u004f\u0053\u0054`,
      headers,
      body: JSON.stringify(postData)
    });
    if (!response.ok) {
      sendLog(`\u0075\u0072\u006c\u003a` + url + `\uff0c\u0068\u0065\u0061\u0064\u0065\u0072\u003a` + JSON.stringify(headers) + `\u002c\u0020\u0072\u0065\u0073\u0070\u006f\u006e\u0073\u0065\u0020\u0073\u0074\u0061\u0074\u0075\u0073\u003a` + response.status);
      console.error(`\u0048\u0054\u0054\u0050\u0020\u0065\u0072\u0072\u006f\u0072\u0021\u0020\u0073\u0074\u0061\u0074\u0075\u0073\u003a\u0020${response.status}`);
      if (response.status === 401) {
        console.log(`\u767b\u5f55\u5931\u6548`);
        store$2.setAccessToken(``);
        store$2.set_updateVipDateTime(``);
        store$2.setUserInfoEndDate(``);
        await logout(store$2.accessToken);
      }
      if (response.status == 404) {
        return void 0;
      }
      return void 0;
    }
    const result = await response.json();
    sendLog(`\u0075\u0072\u006c\u003a` + url + `\uff0c\u0068\u0065\u0061\u0064\u0065\u0072\u003a` + JSON.stringify(headers) + `\u002c\u0070\u006f\u0073\u0074\u0044\u0061\u0074\u0061\uff1a` + JSON.stringify(postData) + `\u0020\u0072\u0065\u0073\u0070\u006f\u006e\u0073\u0065\u0020\u0073\u0074\u0061\u0074\u0075\u0073\u003a` + response.status + `\u002c\u0020\u0072\u0065\u0073\u0070\u006f\u006e\u0073\u0065\u0020\u0064\u0061\u0074\u0061\u003a` + JSON.stringify(result));
    console.log(`\u0072\u0065\u0073\u0075\u006c\u0074`, result);
    return result;
  } catch (error) {
    sendLog(`\u0075\u0072\u006c\u003a` + url + `\uff0c\u0068\u0065\u0061\u0064\u0065\u0072\u003a` + JSON.stringify(headers) + `\u002c\u0020\u0065\u0072\u0072\u006f\u0072` + error);
    console.error(`\u0045\u0072\u0072\u006f\u0072\u003a`, error);
  }
  return void 0;
}
var define_process_env_default = {};
const ACCOUNT_DATA_BASE_URL = define_process_env_default.ACCOUNT_DATA_BASE_URL || `\u0068\u0074\u0074\u0070\u0073\u003a\u002f\u002f\u0074\u0075\u0062\u0065\u0073\u0063\u0061\u006e\u006e\u0065\u0072\u002d\u0062\u006b\u0062\u006a\u0072\u006d\u0069\u0065\u0076\u0065\u002e\u0063\u006e\u002d\u0068\u0061\u006e\u0067\u007a\u0068\u006f\u0075\u002e\u0066\u0063\u0061\u0070\u0070\u002e\u0072\u0075\u006e`;
const ACCOUNT_DATA_API_AUTH_TOKEN = define_process_env_default.ACCOUNT_DATA_API_AUTH_TOKEN || `\u0077\u005a\u0045\u0052\u0046\u006a\u0070\u004e\u0067\u0045\u0045\u0061\u0074\u0070`;
const store$1 = UseCounterStore.getInstance();
let XiaoHongShu_Setting$1 = JSON.parse(store$1.XiaoHongShu_Setting);
const VITE_AGENT_ID = `\u0078\u0069\u0061\u006f\u0073\u0068\u0075\u0074\u0069\u0061\u006f\u002d\u0061\u0075\u0074\u006f\u006d\u0061\u0074\u0069\u0063\u002d\u0065\u0078\u0074\u0065\u006e\u0073\u0069\u006f\u006e`;
const isWithinProbabilityOpen = 80;
const isWithinProbabilitysend_comments = 20;
const isWithinProbabilityclickCommentLike = 50;
const isWithinProbabilityfollow_click = 5;
const isWithinProbabilitycollect_click = 5;
let checkInterval$1 = null;
const processedNoteIds = /* @__PURE__ */new Set();
const isNoteProcessed = noteId => {
  return processedNoteIds.has(noteId);
};
const markNoteAsProcessed = noteId => {
  processedNoteIds.add(noteId);
};
function convertTimeToSeconds(timeStr) {
  const [minutes, seconds] = timeStr.split(`\u003a`).map(num => parseInt(num, 10));
  return minutes * 60 + seconds;
}
function douYin_RunYourCode() {
  if (checkInterval$1) {
    clearInterval(checkInterval$1);
    checkInterval$1 = null;
  }
  sendLog(`\u5f00\u59cb\u4efb\u52a1\u0064\u006f\u0075\u0059\u0069\u006e\u005f\u0052\u0075\u006e\u0059\u006f\u0075\u0072\u0043\u006f\u0064\u0065\u0020\u0073\u0074\u0061\u0072\u0074`);
  let run_status = false;
  checkInterval$1 = setInterval(async () => {
    var _a;
    if (run_status) {
      return;
    }
    run_status = true;
    try {
      const loginContainer = document.querySelector(`\u0023\u0064\u006f\u0075\u0079\u0069\u006e\u002d\u0068\u0065\u0061\u0064\u0065\u0072\u0020\u002e\u0073\u0065\u006d\u0069\u002d\u0062\u0075\u0074\u0074\u006f\u006e`);
      if (loginContainer) {
        sendLog(`\u0055\u0073\u0065\u0072\u0020\u0069\u0073\u0020\u006e\u006f\u0074\u0020\u006c\u006f\u0067\u0067\u0065\u0064\u0020\u0069\u006e`);
      } else {
        const userInfo = await getWebUserIdAndUserName();
        if (userInfo) {
          clearInterval(checkInterval$1);
          checkInterval$1 = null;
          sendLog(`\u5f00\u59cb\u4efb\u52a1\u0064\u006f\u0075\u0059\u0069\u006e\u005f\u0052\u0075\u006e\u0059\u006f\u0075\u0072\u0043\u006f\u0064\u0065`);
          const accountRunNum = await checkXiaoHongShuAccountRunNum(`\u0064\u006f\u0075\u0059\u0069\u006e`, store$1.webUserId);
          if (!accountRunNum) {
            vipCloseEndFun(`\u0061\u0063\u0063\u006f\u0075\u006e\u0074\u0052\u0075\u006e\u004e\u0075\u006d`).then();
            return;
          }
          await store$1.checkLoadend();
          if (!XiaoHongShu_Setting$1 || Object.keys(XiaoHongShu_Setting$1).length == 0) {
            XiaoHongShu_Setting$1 = JSON.parse(store$1.XiaoHongShu_Setting);
          }
          if (store$1.isNotRunWork()) {
            vipCloseEndFun(`\u0064\u006f\u0075\u0059\u0069\u006e\u005f\u0052\u0075\u006e\u0059\u006f\u0075\u0072\u0043\u006f\u0064\u0065`).then();
            return;
          }
          const taskData = await getTabTaskData();
          store$1.setChromeTabId(taskData == null ? void 0 : taskData.tabId);
          const taskName = (_a = taskData == null ? void 0 : taskData.tabData) == null ? void 0 : _a.taskName;
          sendLog(`\u0063\u0068\u0072\u006f\u006d\u0065\u0054\u0061\u0062\u0049\u0064\u0020\u003a` + (taskData == null ? void 0 : taskData.tabId));
          if (taskName == `\u5173\u952e\u8bcd`) {
            await delay(getRandomNumberInRange(1e3, 5e3));
            douYinSearch(taskData).then(() => {}).catch(err => {
              console.error(`\u0064\u006f\u0075\u0059\u0069\u006e\u0053\u0065\u0061\u0072\u0063\u0068`, err);
            });
          } else if (taskName == `\u4fe1\u606f\u6d41`) {
            await delay(getRandomNumberInRange(1e3, 5e3));
            douYinTuiJian().then(() => {}).catch(err => {
              console.error(`\u0064\u006f\u0075\u0059\u0069\u006e\u0054\u0075\u0069\u004a\u0069\u0061\u006e`, err);
            });
          } else if (taskName == `\u641c\u7d22\u5173\u952e\u8bcd\u5173\u6ce8\u7528\u6237`) {
            douYin_follow_click().then(res => {
              sendLog(`\u0064\u006f\u0075\u0059\u0069\u006e\u005f\u0066\u006f\u006c\u006c\u006f\u0077\u005f\u0063\u006c\u0069\u0063\u006b\u0020\u0072\u0065\u0073` + res);
            }).catch(err => {
              sendLog(`\u0064\u006f\u0075\u0059\u0069\u006e\u005f\u0066\u006f\u006c\u006c\u006f\u0077\u005f\u0063\u006c\u0069\u0063\u006b\u0020\u0065\u0072\u0072` + err);
            }).finally(() => {
              sendLog(`\u0064\u006f\u0075\u0059\u0069\u006e\u005f\u0066\u006f\u006c\u006c\u006f\u0077\u005f\u0063\u006c\u0069\u0063\u006b\u0020\u0066\u0069\u006e\u0061\u006c\u006c\u0079`);
              chrome.runtime.sendMessage({
                action: `\u006e\u006f\u0043\u006c\u006f\u0073\u0065\u0052\u0075\u006e`
              }, {
                includeTlsChannelId: false
              }, () => {
                console.log(`\u006e\u006f\u0043\u006c\u006f\u0073\u0065\u0052\u0075\u006e\u0020\u0068\u0065\u006c\u006c\u006f\u0020\u0077\u006f\u0072\u006c\u0064`);
                closeEndFun(`\u0064\u006f\u0075\u0059\u0069\u006e\u005f\u0052\u0075\u006e\u0059\u006f\u0075\u0072\u0043\u006f\u0064\u0065\u0020\u641c\u7d22\u5173\u952e\u8bcd\u5173\u6ce8\u7528\u6237`).then();
              });
            });
          } else if (taskName == `\u83b7\u53d6\u6296\u97f3\u901a\u77e5`) {
            store$1.setRunLogs(`\u5f00\u59cb\u83b7\u53d6\u6296\u97f3\u901a\u77e5\u4efb\u52a1`);
            douYin_Notifications().then(res => {
              sendLog(`\u0064\u006f\u0075\u0059\u0069\u006e\u005f\u004e\u006f\u0074\u0069\u0066\u0069\u0063\u0061\u0074\u0069\u006f\u006e\u0073\u0020\u0072\u0065\u0073` + res);
            }).catch(err => {
              console.log(`\u0065\u0072\u0072`, err);
              sendLog(`\u0064\u006f\u0075\u0059\u0069\u006e\u005f\u004e\u006f\u0074\u0069\u0066\u0069\u0063\u0061\u0074\u0069\u006f\u006e\u0073\u0020\u0065\u0072\u0072` + err);
            }).finally(() => {
              sendLog(`\u0064\u006f\u0075\u0059\u0069\u006e\u005f\u004e\u006f\u0074\u0069\u0066\u0069\u0063\u0061\u0074\u0069\u006f\u006e\u0073\u0020\u0066\u0069\u006e\u0061\u006c\u006c\u0079`);
            });
          } else if (taskName == `\u83b7\u53d6\u7f51\u7ad9\u767b\u5f55\u8d26\u53f7\u7684\u540d\u79f0`) {
            saveTerminalWebUserName().then(res => {
              sendLog(`\u0067\u0065\u0074\u0057\u0065\u0062\u0055\u0073\u0065\u0072\u004e\u0061\u006d\u0065\u0020\u0072\u0065\u0073` + res);
            }).finally(() => {
              closeEndFun(`\u0064\u006f\u0075\u0059\u0069\u006e\u005f\u0052\u0075\u006e\u0059\u006f\u0075\u0072\u0043\u006f\u0064\u0065\u0020\u83b7\u53d6\u7f51\u7ad9\u767b\u5f55\u8d26\u53f7\u7684\u540d\u79f0`).then();
            });
          }
        } else {
          console.log(`\u6ca1\u6709\u627e\u5230\u7528\u6237\u767b\u5f55\u4fe1\u606f\u0069\u0064`);
        }
      }
    } catch (e) {
      sendLog(`\u0064\u006f\u0075\u0059\u0069\u006e\u005f\u0052\u0075\u006e\u0059\u006f\u0075\u0072\u0043\u006f\u0064\u0065\u0020\u0065\u0072\u0072\u006f\u0072\u003a` + JSON.stringify(e));
    } finally {
      run_status = false;
    }
  }, 1e3);
  setTimeout(() => {
    clearInterval(checkInterval$1);
    checkInterval$1 = null;
    console.log(`\u0046\u0069\u006e\u0069\u0073\u0068\u0065\u0064\u0020\u0063\u0068\u0065\u0063\u006b\u0069\u006e\u0067\u0020\u006c\u006f\u0067\u0069\u006e\u0020\u0073\u0074\u0061\u0074\u0075\u0073\u002e`);
  }, 10 * 60 * getRandomNumberInRange(1e3, 5e3));
}
const getWebUserIdAndUserName = async () => {
  var _a, _b;
  const userInfo = {};
  if (!store$1.webUserId) {
    let webUserId = getWebUserIdData();
    if (webUserId) {
      userInfo[`\u0077\u0065\u0062\u0055\u0073\u0065\u0072\u0049\u0064`] = webUserId;
    }
    let webUserAvatarUrl = ``;
    const userAvatarEl = document.querySelector(`\u0023\u0064\u006f\u0075\u0079\u0069\u006e\u002d\u0068\u0065\u0061\u0064\u0065\u0072\u0020\u002e\u0073\u0065\u006d\u0069\u002d\u0061\u0076\u0061\u0074\u0061\u0072\u0020\u0069\u006d\u0067`);
    if (userAvatarEl) {
      let src = userAvatarEl.src;
      if (src.startsWith(`\u002f\u002f`)) {
        src = `\u0068\u0074\u0074\u0070\u0073\u003a` + src;
      }
      webUserAvatarUrl = src;
      const href = new URL(src).pathname;
      if (href) {
        const segments = href.split(`\u002f`);
        if (!webUserId) {
          webUserId = segments.pop() || ``;
          webUserId = webUserId.replace(`\u002e`, ``);
          webUserId = webUserId.replace(`\u002d`, `\u005f`);
        }
      }
    } else {
      console.log(`\u6ca1\u6709\u627e\u5230\u7528\u6237\u767b\u5f55\u4fe1\u606f`);
    }
    if (!webUserId) {
      let userEl = document.querySelector(`\u0023\u0064\u006f\u0075\u0079\u0069\u006e\u002d\u0068\u0065\u0061\u0064\u0065\u0072\u0020\u002e\u0073\u0065\u006d\u0069\u002d\u0061\u0076\u0061\u0074\u0061\u0072\u0020\u0069\u006d\u0067`);
      let href = null;
      if (userEl == null) {
        userEl = document.querySelector(`\u0023\u0068\u0065\u0061\u0064\u0065\u0072\u002d\u0061\u0076\u0061\u0074\u0061\u0072\u0020\u003e\u0020\u0064\u0069\u0076`);
        if (userEl instanceof HTMLElement) {
          const backgroundImage = userEl.style.backgroundImage;
          console.log(`\u0062\u0061\u0063\u006b\u0067\u0072\u006f\u0075\u006e\u0064\u0049\u006d\u0061\u0067\u0065`, backgroundImage);
          const pattern = /url\("([^"]+)"\)/g;
          const result = [];
          let match;
          while ((match = pattern.exec(backgroundImage)) !== null) {
            result.push(match[1]);
          }
          href = result && result.length > 0 ? result[0] : ``;
          if (href && href.startsWith(`\u002f\u002f`)) {
            href = `\u0068\u0074\u0074\u0070\u0073\u003a` + href;
          }
          webUserAvatarUrl = href;
          console.log(`\u0062\u0061\u0063\u006b\u0067\u0072\u006f\u0075\u006e\u0064\u0049\u006d\u0061\u0067\u0065\u0020\u0068\u0072\u0065\u0066`, href);
        }
      } else {
        href = userEl.src;
        if (href && href.startsWith(`\u002f\u002f`)) {
          href = `\u0068\u0074\u0074\u0070\u0073\u003a` + href;
        }
        webUserAvatarUrl = href;
        console.log(`\u0062\u0061\u0063\u006b\u0067\u0072\u006f\u0075\u006e\u0064\u0049\u006d\u0061\u0067\u0065\u0020\u0068\u0072\u0065\u0066`, href);
      }
      if (userEl) {
        if (href) {
          console.log(`\u0068\u0072\u0065\u0066`, href);
          if (href && href.startsWith(`\u002f\u002f`)) {
            href = `\u0068\u0074\u0074\u0070\u0073\u003a` + href;
          }
          href = new URL(href).pathname;
          const segments = href.split(`\u002f`);
          webUserId = segments.pop() || ``;
          console.log(`\u0077\u0065\u0062\u0055\u0073\u0065\u0072\u0049\u0064`, webUserId);
        }
      }
    }
    if (webUserId) {
      console.log(`\u627e\u5230\u98de\u4e66\u7528\u6237\u0049\u0064`, webUserId);
      sendLog(`\u627e\u5230\u98de\u4e66\u7528\u6237\u0049\u0064` + webUserId);
      if (!store$1.webUserId) {
        userInfo[`\u0077\u0065\u0062\u0055\u0073\u0065\u0072\u0049\u0064`] = webUserId;
      }
      if (!store$1.webUserAvatarUrl) {
        userInfo[`\u0077\u0065\u0062\u0055\u0073\u0065\u0072\u0041\u0076\u0061\u0074\u0061\u0072\u0055\u0072\u006c`] = webUserAvatarUrl;
      }
    }
  } else {
    sendLog(`\u627e\u5230\u98de\u4e66\u7528\u6237\u0049\u0064` + store$1.webUserId);
  }
  if (!store$1.webUserName) {
    if (!(await checkDomPromises([`\u002e\u0075\u0073\u0065\u0072\u004d\u0065\u006e\u0075\u0050\u0061\u006e\u0065\u006c\u0053\u0068\u0061\u0064\u006f\u0077\u0041\u006e\u0069\u006d\u0061\u0074\u0069\u006f\u006e\u0020\u003e\u0064\u0069\u0076\u003a\u006e\u0074\u0068\u002d\u0063\u0068\u0069\u006c\u0064\u0028\u0031\u0029\u0020\u003e\u0064\u0069\u0076\u003a\u006e\u0074\u0068\u002d\u0063\u0068\u0069\u006c\u0064\u0028\u0031\u0029\u0020\u003e\u0064\u0069\u0076\u0020\u003e\u0061`, `\u0064\u0069\u0076\u005b\u0063\u006c\u0061\u0073\u0073\u002a\u003d\u0022\u0068\u0065\u0061\u0064\u0065\u0072\u002d\u0022\u005d\u0020\u0064\u0069\u0076\u005b\u0063\u006c\u0061\u0073\u0073\u002a\u003d\u0022\u006e\u0061\u006d\u0065\u002d\u0022\u005d`], null, 20))) {
      console.log(`\u6ca1\u6709\u627e\u5230`, `\u002e\u0075\u0073\u0065\u0072\u004d\u0065\u006e\u0075\u0050\u0061\u006e\u0065\u006c\u0053\u0068\u0061\u0064\u006f\u0077\u0041\u006e\u0069\u006d\u0061\u0074\u0069\u006f\u006e\u0020\u003e\u0064\u0069\u0076\u003a\u006e\u0074\u0068\u002d\u0063\u0068\u0069\u006c\u0064\u0028\u0031\u0029\u0020\u003e\u0064\u0069\u0076\u003a\u006e\u0074\u0068\u002d\u0063\u0068\u0069\u006c\u0064\u0028\u0031\u0029\u0020\u003e\u0064\u0069\u0076\u0020\u003e\u0061`);
    }
    let webUserNameEl = document.querySelector(`\u002e\u0075\u0073\u0065\u0072\u004d\u0065\u006e\u0075\u0050\u0061\u006e\u0065\u006c\u0053\u0068\u0061\u0064\u006f\u0077\u0041\u006e\u0069\u006d\u0061\u0074\u0069\u006f\u006e\u0020\u003e\u0064\u0069\u0076\u003a\u006e\u0074\u0068\u002d\u0063\u0068\u0069\u006c\u0064\u0028\u0031\u0029\u0020\u003e\u0064\u0069\u0076\u003a\u006e\u0074\u0068\u002d\u0063\u0068\u0069\u006c\u0064\u0028\u0031\u0029\u0020\u003e\u0064\u0069\u0076\u0020\u003e\u0061`);
    if (webUserNameEl) {
      const webUserNameText = (_a = webUserNameEl.textContent) == null ? void 0 : _a.trim();
      if (webUserNameText) {
        console.log(`\u7f51\u7ad9\u767b\u5f55\u8d26\u53f7\u7684\u540d\u79f0\uff1a` + webUserNameText);
        sendLog(`\u7f51\u7ad9\u767b\u5f55\u8d26\u53f7\u7684\u540d\u79f0\uff1a` + webUserNameText);
        if (!store$1.webUserName) {
          userInfo[`\u0077\u0065\u0062\u0055\u0073\u0065\u0072\u004e\u0061\u006d\u0065`] = webUserNameText;
        }
      } else {
        sendLog(`\u83b7\u53d6\u0077\u0065\u0062\u0055\u0073\u0065\u0072\u004e\u0061\u006d\u0065\u0054\u0065\u0078\u0074\u0020\u4e3a\u7a7a`);
      }
    } else {
      webUserNameEl = document.querySelector(`\u0064\u0069\u0076\u005b\u0063\u006c\u0061\u0073\u0073\u002a\u003d\u0022\u0068\u0065\u0061\u0064\u0065\u0072\u002d\u0022\u005d\u0020\u0064\u0069\u0076\u005b\u0063\u006c\u0061\u0073\u0073\u002a\u003d\u0022\u006e\u0061\u006d\u0065\u002d\u0022\u005d`);
      if (webUserNameEl) {
        const webUserNameText = (_b = webUserNameEl.textContent) == null ? void 0 : _b.trim();
        if (webUserNameText) {
          console.log(`\u7f51\u7ad9\u767b\u5f55\u8d26\u53f7\u7684\u540d\u79f0\uff1a` + webUserNameText);
          sendLog(`\u7f51\u7ad9\u767b\u5f55\u8d26\u53f7\u7684\u540d\u79f0\uff1a` + webUserNameText);
          if (!store$1.webUserName) {
            userInfo[`\u0077\u0065\u0062\u0055\u0073\u0065\u0072\u004e\u0061\u006d\u0065`] = webUserNameText;
          }
        } else {
          sendLog(`\u83b7\u53d6\u0077\u0065\u0062\u0055\u0073\u0065\u0072\u004e\u0061\u006d\u0065\u0054\u0065\u0078\u0074\u0020\u4e3a\u7a7a`);
        }
      } else {
        sendLog(`\u6ca1\u6709\u627e\u5230\u0020\u0077\u0065\u0062\u0055\u0073\u0065\u0072\u004e\u0061\u006d\u0065\u0045\u006c`);
      }
      sendLog(`\u6ca1\u6709\u627e\u5230\u0020\u0077\u0065\u0062\u0055\u0073\u0065\u0072\u004e\u0061\u006d\u0065\u0045\u006c`);
    }
  } else {
    sendLog(`\u7f51\u7ad9\u767b\u5f55\u8d26\u53f7\u7684\u540d\u79f0\uff1a` + store$1.webUserName);
  }
  if (!store$1.webUserId && userInfo[`\u0077\u0065\u0062\u0055\u0073\u0065\u0072\u0049\u0064`]) {
    store$1.setWebUserId(userInfo[`\u0077\u0065\u0062\u0055\u0073\u0065\u0072\u0049\u0064`]);
  }
  if (!store$1.webUserName && userInfo[`\u0077\u0065\u0062\u0055\u0073\u0065\u0072\u004e\u0061\u006d\u0065`]) {
    store$1.setWebUserName(userInfo[`\u0077\u0065\u0062\u0055\u0073\u0065\u0072\u004e\u0061\u006d\u0065`]);
  }
  if (!store$1.webUserAvatarUrl && userInfo[`\u0077\u0065\u0062\u0055\u0073\u0065\u0072\u0041\u0076\u0061\u0074\u0061\u0072\u0055\u0072\u006c`]) {
    store$1.setWebUserAvatarUrl(userInfo[`\u0077\u0065\u0062\u0055\u0073\u0065\u0072\u0041\u0076\u0061\u0074\u0061\u0072\u0055\u0072\u006c`]);
  }
  if (!userInfo[`\u0077\u0065\u0062\u0055\u0073\u0065\u0072\u0049\u0064`] && store$1.webUserId) {
    userInfo[`\u0077\u0065\u0062\u0055\u0073\u0065\u0072\u0049\u0064`] = store$1.webUserId;
  }
  if (!userInfo[`\u0077\u0065\u0062\u0055\u0073\u0065\u0072\u004e\u0061\u006d\u0065`] && store$1.webUserName) {
    userInfo[`\u0077\u0065\u0062\u0055\u0073\u0065\u0072\u004e\u0061\u006d\u0065`] = store$1.webUserName;
  }
  if (!userInfo[`\u0077\u0065\u0062\u0055\u0073\u0065\u0072\u0041\u0076\u0061\u0074\u0061\u0072\u0055\u0072\u006c`] && store$1.webUserAvatarUrl) {
    userInfo[`\u0077\u0065\u0062\u0055\u0073\u0065\u0072\u0041\u0076\u0061\u0074\u0061\u0072\u0055\u0072\u006c`] = store$1.webUserAvatarUrl;
  }
  return userInfo;
};
const getWebUserIdData = () => {
  var _a;
  const render_dataEl = document.querySelector(`\u0023\u0052\u0045\u004e\u0044\u0045\u0052\u005f\u0044\u0041\u0054\u0041`);
  if (render_dataEl) {
    const render_dataText = (_a = render_dataEl.textContent) == null ? void 0 : _a.trim();
    console.log(`\u0052\u0045\u004e\u0044\u0045\u0052\u005f\u0044\u0041\u0054\u0041\uff1a` + render_dataText);
    if (render_dataText) {
      let render_dataJson = null;
      try {
        render_dataJson = JSON.parse(decodeURIComponent(render_dataText));
      } catch (e) {
        sendLog(`\u004a\u0053\u004f\u004e\u002e\u0070\u0061\u0072\u0073\u0065\u0028\u0072\u0065\u006e\u0064\u0065\u0072\u005f\u0064\u0061\u0074\u0061\u0054\u0065\u0078\u0074\u0029\u0020\u9519\u8bef` + e + `\u002c\u0020\u0072\u0065\u006e\u0064\u0065\u0072\u005f\u0064\u0061\u0074\u0061\u0054\u0065\u0078\u0074\u003a` + render_dataText);
      }
      if (render_dataJson) {
        if (render_dataJson[`\u0061\u0070\u0070`]) {
          if (render_dataJson[`\u0061\u0070\u0070`][`\u0075\u0073\u0065\u0072`]) {
            if (render_dataJson[`\u0061\u0070\u0070`][`\u0075\u0073\u0065\u0072`][`\u0069\u006e\u0066\u006f`]) {
              if (render_dataJson[`\u0061\u0070\u0070`][`\u0075\u0073\u0065\u0072`][`\u0069\u006e\u0066\u006f`][`\u0073\u0065\u0063\u0055\u0069\u0064`]) {
                const secUid = render_dataJson[`\u0061\u0070\u0070`][`\u0075\u0073\u0065\u0072`][`\u0069\u006e\u0066\u006f`][`\u0073\u0065\u0063\u0055\u0069\u0064`];
                sendLog(`\u627e\u5230\u4e86\u0073\u0065\u0063\u0055\u0069\u0064\uff1a` + secUid);
                return secUid;
              } else {
                sendLog(`\u0072\u0065\u006e\u0064\u0065\u0072\u005f\u0064\u0061\u0074\u0061\u004a\u0073\u006f\u006e\u005b\u0027\u0061\u0070\u0070\u0027\u005d\u005b\u0027\u0075\u0073\u0065\u0072\u0027\u005d\u005b\u0027\u0069\u006e\u0066\u006f\u0027\u005d\u005b\u0027\u0073\u0065\u0063\u0055\u0069\u0064\u0027\u005d\uff1a\u4e3a\u7a7a\uff0c\u0072\u0065\u006e\u0064\u0065\u0072\u005f\u0064\u0061\u0074\u0061\u0054\u0065\u0078\u0074\uff1a` + JSON.stringify(render_dataJson[`\u0061\u0070\u0070`][`\u0075\u0073\u0065\u0072`][`\u0069\u006e\u0066\u006f`]));
              }
            } else {
              sendLog(`\u0072\u0065\u006e\u0064\u0065\u0072\u005f\u0064\u0061\u0074\u0061\u004a\u0073\u006f\u006e\u005b\u0027\u0061\u0070\u0070\u0027\u005d\u005b\u0027\u0075\u0073\u0065\u0072\u0027\u005d\u005b\u0027\u0069\u006e\u0066\u006f\u0027\u005d\uff1a\u4e3a\u7a7a\uff0c\u0072\u0065\u006e\u0064\u0065\u0072\u005f\u0064\u0061\u0074\u0061\u0054\u0065\u0078\u0074\uff1a` + JSON.stringify(render_dataJson[`\u0061\u0070\u0070`][`\u0075\u0073\u0065\u0072`]));
            }
          } else {
            sendLog(`\u0072\u0065\u006e\u0064\u0065\u0072\u005f\u0064\u0061\u0074\u0061\u004a\u0073\u006f\u006e\u005b\u0027\u0061\u0070\u0070\u0027\u005d\u005b\u0027\u0075\u0073\u0065\u0072\u0027\u005d\uff1a\u4e3a\u7a7a\uff0c\u0072\u0065\u006e\u0064\u0065\u0072\u005f\u0064\u0061\u0074\u0061\u0054\u0065\u0078\u0074\uff1a` + JSON.stringify(render_dataJson[`\u0061\u0070\u0070`]));
          }
        } else {
          sendLog(`\u0072\u0065\u006e\u0064\u0065\u0072\u005f\u0064\u0061\u0074\u0061\u004a\u0073\u006f\u006e\u005b\u0027\u0061\u0070\u0070\u0027\u005d\uff1a\u4e3a\u7a7a\uff0c\u0072\u0065\u006e\u0064\u0065\u0072\u005f\u0064\u0061\u0074\u0061\u0054\u0065\u0078\u0074\uff1a` + render_dataText);
        }
      } else {
        sendLog(`\u0072\u0065\u006e\u0064\u0065\u0072\u005f\u0064\u0061\u0074\u0061\u0054\u0065\u0078\u0074\uff1a\u4e3a\u7a7a`);
      }
    } else {
      sendLog(`\u0072\u0065\u006e\u0064\u0065\u0072\u005f\u0064\u0061\u0074\u0061\u0054\u0065\u0078\u0074\uff1a\u4e3a\u7a7a`);
    }
  } else {
    sendLog(`\u0072\u0065\u006e\u0064\u0065\u0072\u005f\u0064\u0061\u0074\u0061\u0045\u006c\uff1a\u4e3a\u7a7a`);
  }
  return ``;
};
async function douYinSearch(taskData) {
  console.log(`\u0064\u006f\u0075\u0059\u0069\u006e\u0053\u0065\u0061\u0072\u0063\u0068`);
  while (true) {
    store$1.setRunLogs(`\u5f00\u59cb\u5173\u952e\u8bcd\u641c\u7d22`);
    if (!(await checkDomPromise(`\u0023\u0064\u006f\u0075\u0079\u0069\u006e\u002d\u0068\u0065\u0061\u0064\u0065\u0072\u0020\u0069\u006e\u0070\u0075\u0074`))) {
      console.error(`\u6ca1\u6709\u627e\u5230`, `\u0023\u0064\u006f\u0075\u0079\u0069\u006e\u002d\u0068\u0065\u0061\u0064\u0065\u0072\u0020\u0069\u006e\u0070\u0075\u0074`);
      sendLog(`\u6ca1\u6709\u627e\u5230\u0020\u641c\u7d22\u6846`);
      store$1.setRunLogs(`\u6ca1\u6709\u627e\u5230\u641c\u7d22\u6846`);
      return;
    }
    if (!(XiaoHongShu_Setting$1 == null ? void 0 : XiaoHongShu_Setting$1.searchWord)) {
      XiaoHongShu_Setting$1 = JSON.parse(store$1.XiaoHongShu_Setting);
    }
    if (!(XiaoHongShu_Setting$1 == null ? void 0 : XiaoHongShu_Setting$1.searchWord)) {
      console.error(`\u914d\u7f6e\u6ca1\u6709\u751f\u6548`, store$1.XiaoHongShu_Setting);
      sendLog(`\u914d\u7f6e\u6ca1\u6709\u751f\u6548`);
      store$1.setRunLogs(`\u6ca1\u6709\u627e\u5230\u641c\u7d22\u5173\u952e\u8bcd`);
      return;
    }
    let keywords_list = [];
    keywords_list.push(XiaoHongShu_Setting$1 == null ? void 0 : XiaoHongShu_Setting$1.searchWord);
    let get_keyword_bool = true;
    let next_change_time = 0;
    store$1.setDouYinKeywords_list(keywords_list);
    store$1.setRunLogs(`\u5f00\u59cb\u641c\u7d22`);
    for (let i = 0; i < keywords_list.length; i++) {
      const searchWord = keywords_list[i];
      console.log(`\u0064\u006f\u0075\u0059\u0069\u006e\u0053\u0065\u0061\u0072\u0063\u0068`, searchWord);
      if (store$1.isNotRunWork()) {
        return;
      }
      const searchInput = document.querySelector(`\u0023\u0064\u006f\u0075\u0079\u0069\u006e\u002d\u0068\u0065\u0061\u0064\u0065\u0072\u0020\u0069\u006e\u0070\u0075\u0074`);
      if (!searchInput) {
        sendLog(`\u6ca1\u6709\u627e\u5230\u641c\u7d22\u6846`);
        console.error(`\u6ca1\u6709\u627e\u5230\u641c\u7d22\u6846\uff0c\u91cd\u65b0\u5f00\u59cb`);
        return;
      }
      searchInput.value = searchWord;
      const inputEvent = new Event(`\u0069\u006e\u0070\u0075\u0074`, {
        bubbles: true,
        cancelable: true
      });
      searchInput.dispatchEvent(inputEvent);
      const button_el = document.querySelector(`\u0062\u0075\u0074\u0074\u006f\u006e\u005b\u0064\u0061\u0074\u0061\u002d\u0065\u0032\u0065\u003d\u0022\u0073\u0065\u0061\u0072\u0063\u0068\u0062\u0061\u0072\u002d\u0062\u0075\u0074\u0074\u006f\u006e\u0022\u005d`);
      if (!button_el) {
        sendLog(`\u6ca1\u6709\u627e\u5230\u641c\u7d22\u6309\u94ae`);
        console.error(`\u6ca1\u6709\u627e\u5230\u641c\u7d22\u6309\u94ae\uff0c\u91cd\u65b0\u5f00\u59cb`);
        return;
      }
      await click_button(button_el);
      const keydownEvent = new KeyboardEvent(`\u006b\u0065\u0079\u0064\u006f\u0077\u006e`, {
        bubbles: true,
        cancelable: true,
        key: `\u0045\u006e\u0074\u0065\u0072`,
        code: `\u0045\u006e\u0074\u0065\u0072`,
        keyCode: 13,
        // keyCode 是一些旧的代码可能需要的
        which: 13
      });
      searchInput.dispatchEvent(keydownEvent);
      const keyupEvent = new KeyboardEvent(`\u006b\u0065\u0079\u0075\u0070`, {
        bubbles: true,
        cancelable: true,
        key: `\u0045\u006e\u0074\u0065\u0072`,
        code: `\u0045\u006e\u0074\u0065\u0072`,
        keyCode: 13,
        which: 13
      });
      searchInput.dispatchEvent(keyupEvent);
      const keypressEvent = new KeyboardEvent(`\u006b\u0065\u0079\u0070\u0072\u0065\u0073\u0073`, {
        bubbles: true,
        cancelable: true,
        key: `\u0045\u006e\u0074\u0065\u0072`,
        code: `\u0045\u006e\u0074\u0065\u0072`,
        keyCode: 13,
        which: 13
      });
      searchInput.dispatchEvent(keypressEvent);
      if (store$1.isNotRunWork()) {
        sendLog(`\u505c\u6b62\u4e86\u0031`);
        return;
      }
      store$1.setRunLogs(`\u641c\u7d22\u5b8c\u6210\uff0c\u5f00\u59cb\u529f\u80fd`);
      const keywords_list_res = await douYinClick_short_note(searchWord, get_keyword_bool, next_change_time);
      if (keywords_list_res && keywords_list_res.length == 2) {
        const keywords_list_data = keywords_list_res[0];
        next_change_time = keywords_list_res[1];
        get_keyword_bool = false;
        if (keywords_list_data && keywords_list_data.length > 0) {
          for (let j = 0; j < keywords_list_data.length; j++) {
            keywords_list.push(keywords_list_data[j]);
          }
          sendLog(`\u006b\u0065\u0079\u0077\u006f\u0072\u0064\u0073\u005f\u006c\u0069\u0073\u0074` + JSON.stringify(keywords_list));
          store$1.setDouYinKeywords_list(keywords_list);
        }
      }
    }
    store$1.increment_DouYin_search_runNumber();
    sendLog(`\u0044\u006f\u0075\u0059\u0069\u006e\u005f\u0073\u0065\u0061\u0072\u0063\u0068\u005f\u0072\u0075\u006e\u004e\u0075\u006d\u0062\u0065\u0072\uff1a` + store$1.DouYin_search_runNumber);
    if (store$1.DouYin_search_runNumber > 3) {
      sendLog(`\u0063\u006f\u006e\u0074\u0065\u006e\u0074\u0020\u0061\u0063\u0074\u0069\u0076\u0061\u0074\u0065\u0050\u0061\u0067\u0065\u0020\u0044\u006f\u0075\u0059\u0069\u006e\u005f\u0073\u0065\u0061\u0072\u0063\u0068\u005f\u0072\u0075\u006e\u004e\u0075\u006d\u0062\u0065\u0072\uff1a`, store$1.DouYin_search_runNumber);
      chrome.storage.local.set({
        "activatePage": indexPage
      });
      return;
    }
    if (store$1.isNotRunWork()) {
      return;
    }
    sendLog(`\u4e0b\u4e00\u6b21\u5f00\u59cb`);
  }
}
async function douYinClick_short_note(searchWord, get_keyword_bool, next_change_time) {
  let keywords_list = [];
  try {
    if (!(await checkDomPromise(`\u0023\u0073\u0065\u0061\u0072\u0063\u0068\u002d\u0063\u006f\u006e\u0074\u0065\u006e\u0074\u002d\u0061\u0072\u0065\u0061\u0020\u002e\u006d\u006c\u002d\u0032`))) {
      sendLog(`\u6ca1\u6709\u627e\u5230\u641c\u7d22\u7ed3\u679c`);
    }
    if (store$1.isNotRunWork()) {
      sendLog(`\u505c\u6b62\u4e86\u0032`);
      return keywords_list;
    }
    await delay(getRandomNumberInRange(1e3, 5e3));
    sendLog(`\u70b9\u51fb\u5355\u5217`);
    if (!(await checkDomPromise(`\u0023\u0073\u0065\u0061\u0072\u0063\u0068\u002d\u0063\u006f\u006e\u0074\u0065\u006e\u0074\u002d\u0061\u0072\u0065\u0061\u0020\u002e\u006d\u006c\u002d\u0032`))) {
      console.error(`\u6ca1\u6709\u627e\u5230`, `\u0023\u0073\u0065\u0061\u0072\u0063\u0068\u002d\u0063\u006f\u006e\u0074\u0065\u006e\u0074\u002d\u0061\u0072\u0065\u0061\u0020\u002e\u006d\u006c\u002d\u0032`);
      sendLog(`\u6ca1\u6709\u627e\u5230\u0020\u5355\u5217\u6309\u94ae`);
      return keywords_list;
    }
    if (store$1.isNotRunWork()) {
      sendLog(`\u505c\u6b62\u4e86\u0033`);
      return keywords_list;
    }
    let short_notes = document.querySelectorAll(`\u0023\u0073\u0065\u0061\u0072\u0063\u0068\u002d\u0063\u006f\u006e\u0074\u0065\u006e\u0074\u002d\u0061\u0072\u0065\u0061\u0020\u002e\u006d\u006c\u002d\u0032`);
    let short_note = void 0;
    short_notes.forEach(item => {
      var _a;
      if (((_a = item.textContent) == null ? void 0 : _a.trim()) == `\u5355\u5217`) {
        short_note = item;
      }
    });
    if (short_note == void 0) {
      sendLog(`\u6ca1\u6709\u627e\u5230\u0020\u5355\u5217\u6309\u94ae`);
      console.error(`\u9519\u8bef\uff0c\u91cd\u65b0\u5f00\u59cb`);
      return keywords_list;
    }
    await click_button(short_note);
    const parent = short_note.parentElement;
    let suaxuan_el = null;
    if (parent) {
      const sibling = parent.nextElementSibling;
      console.log(`\u0073\u0069\u0062\u006c\u0069\u006e\u0067`, sibling);
      if (sibling) {
        suaxuan_el = sibling.querySelector(`\u0073\u0070\u0061\u006e\u003a\u006e\u0074\u0068\u002d\u0063\u0068\u0069\u006c\u0064\u0028\u0031\u0029`);
        console.log(`\u0073\u0075\u0061\u0078\u0075\u0061\u006e\u005f\u0065\u006c`, suaxuan_el);
      }
    }
    keywords_list = await douYinClick_dropdown_container(suaxuan_el, searchWord, get_keyword_bool, next_change_time);
  } catch (e) {
    console.error(`\u0065\u0065`, e);
    sendLog(`\u0078\u0069\u0061\u006f\u0048\u006f\u006e\u0067\u0073\u0068\u0075\u0043\u006c\u0069\u0063\u006b\u005f\u0073\u0068\u006f\u0072\u0074\u005f\u006e\u006f\u0074\u0065` + e);
  }
  return keywords_list;
}
async function douYinClick_dropdown_container(filter_box, searchWord, get_keyword_bool, next_change_time) {
  var _a, _b, _c;
  console.log(`\u9009\u62e9\u6700\u65b0`);
  if (store$1.isNotRunWork()) {
    sendLog(`\u505c\u6b62\u4e86\u0034`);
    return [];
  }
  if (!(XiaoHongShu_Setting$1 == null ? void 0 : XiaoHongShu_Setting$1.category)) {
    console.error(`\u6ca1\u6709\u914d\u7f6e\u0020\u0063\u0061\u0074\u0065\u0067\u006f\u0072\u0079`, XiaoHongShu_Setting$1 == null ? void 0 : XiaoHongShu_Setting$1.category);
    sendLog(`\u6ca1\u6709\u914d\u7f6e\u0020\u0063\u0061\u0074\u0065\u0067\u006f\u0072\u0079`);
    return [];
  }
  if ((XiaoHongShu_Setting$1 == null ? void 0 : XiaoHongShu_Setting$1.category.indexOf(`\u7efc\u5408`)) > -1) ;else {
    console.log(`\u9009\u62e9\u8fc7\u6ee4`);
    if (store$1.isNotRunWork()) {
      sendLog(`\u505c\u6b62\u4e86\u0035`);
      return [];
    }
    if (!filter_box) {
      console.error(`\u9519\u8bef\uff0c\u91cd\u65b0\u5f00\u59cb`);
      sendLog(`\u6ca1\u6709\u627e\u5230\u0020\u9009\u62e9\u8fc7\u6ee4`);
      return [];
    }
    const rect = filter_box.getBoundingClientRect();
    const x = rect.left + rect.width / 2;
    const y = rect.top + rect.height / 2;
    console.log(`\u0078\u002c\u0079`, rect, x, y);
    const mouseOverEvent = new MouseEvent(`\u006d\u006f\u0075\u0073\u0065\u006f\u0076\u0065\u0072`, {
      view: window,
      bubbles: true,
      cancelable: true,
      clientX: x,
      clientY: y
    });
    filter_box.dispatchEvent(mouseOverEvent);
    const mouseMoveEvent = new MouseEvent(`\u006d\u006f\u0075\u0073\u0065\u006d\u006f\u0076\u0065`, {
      view: window,
      bubbles: true,
      cancelable: true,
      clientX: x,
      clientY: y
    });
    filter_box.dispatchEvent(mouseMoveEvent);
    const mouseEnterEvent = new MouseEvent(`\u006d\u006f\u0075\u0073\u0065\u0065\u006e\u0074\u0065\u0072`, {
      view: window,
      bubbles: true,
      cancelable: true,
      clientX: x,
      clientY: y
    });
    filter_box.dispatchEvent(mouseEnterEvent);
    await delay(getRandomNumberInRange(1e3, 5e3));
    let elements = Array.from(document.querySelectorAll(`\u0023\u0073\u0065\u0061\u0072\u0063\u0068\u002d\u0063\u006f\u006e\u0074\u0065\u006e\u0074\u002d\u0061\u0072\u0065\u0061\u0020\u0073\u0070\u0061\u006e\u005b\u0064\u0061\u0074\u0061\u002d\u0069\u006e\u0064\u0065\u0078\u0031\u003d\u0022\u0030\u0022\u005d`));
    let targetElement = null;
    let zonghe_el = null;
    for (let i = 0; i < elements.length; i++) {
      const element = elements[i];
      if (!element) {
        continue;
      }
      console.log(element);
      console.log(element.childElementCount, XiaoHongShu_Setting$1 == null ? void 0 : XiaoHongShu_Setting$1.category);
      if ((element == null ? void 0 : element.textContent) && ((_a = element == null ? void 0 : element.textContent) == null ? void 0 : _a.trim()) && ((_c = (_b = element == null ? void 0 : element.textContent) == null ? void 0 : _b.trim()) == null ? void 0 : _c.indexOf(`\u7efc\u5408`)) > -1) {
        zonghe_el = element;
      }
      if (element && element.childElementCount === 0 && element.textContent && (element.textContent.trim() === (XiaoHongShu_Setting$1 == null ? void 0 : XiaoHongShu_Setting$1.category) || element.textContent.trim().indexOf(XiaoHongShu_Setting$1 == null ? void 0 : XiaoHongShu_Setting$1.category) > -1)) {
        targetElement = element;
        break;
      }
    }
    if (targetElement) {
      console.log(`\u0045\u006c\u0065\u006d\u0065\u006e\u0074\u0020\u006e\u006f\u0074\u0020\u0066\u006f\u0075\u006e\u0064`, XiaoHongShu_Setting$1 == null ? void 0 : XiaoHongShu_Setting$1.category);
      sendLog(`\u6ca1\u6709\u914d\u7f6e\u0020\u0063\u0061\u0074\u0065\u0067\u006f\u0072\u0079`);
      console.log(`\u0045\u006c\u0065\u006d\u0065\u006e\u0074\u0020\u0066\u006f\u0075\u006e\u0064\u003a`, targetElement);
      await click_button(targetElement);
    } else if (zonghe_el) {
      targetElement = zonghe_el;
      await click_button(targetElement);
    } else {
      console.log(`\u007a\u006f\u006e\u0067\u0068\u0065\u005f\u0065\u006c\u0020\u4e3a\u0020\u7a7a`);
    }
    await delay(getRandomNumberInRange(1e3, 5e3));
    await click_button(filter_box);
  }
  console.log(`\u0078\u0069\u0061\u006f\u0048\u006f\u006e\u0067\u0073\u0068\u0075\u0043\u006c\u0069\u0063\u006b\u005f\u0063\u006f\u0076\u0065\u0072\u005f\u006c\u0064\u005f\u006d\u0061\u0073\u006b`);
  await delay(getRandomNumberInRange(1e3, 5e3));
  return await douYinClick_cover_ld_mask([], searchWord, get_keyword_bool, next_change_time);
}
async function douYinClick_cover_ld_mask(viewedPaths, searchWord, get_keyword_bool, next_change_time) {
  var _a;
  let keywords_list = [];
  if (!(await checkDomPromise(`\u0023\u0073\u0065\u0061\u0072\u0063\u0068\u002d\u0063\u006f\u006e\u0074\u0065\u006e\u0074\u002d\u0061\u0072\u0065\u0061\u0020\u0075\u006c\u005b\u0064\u0061\u0074\u0061\u002d\u0065\u0032\u0065\u003d\u0022\u0073\u0063\u0072\u006f\u006c\u006c\u002d\u006c\u0069\u0073\u0074\u0022\u005d`))) {
    console.error(`\u6ca1\u6709\u627e\u5230`, `\u0023\u0073\u0065\u0061\u0072\u0063\u0068\u002d\u0063\u006f\u006e\u0074\u0065\u006e\u0074\u002d\u0061\u0072\u0065\u0061\u0020\u0075\u006c\u005b\u0064\u0061\u0074\u0061\u002d\u0065\u0032\u0065\u003d\u0022\u0073\u0063\u0072\u006f\u006c\u006c\u002d\u006c\u0069\u0073\u0074\u0022\u005d`);
    sendLog(`\u6ca1\u6709\u627e\u5230\u641c\u7d22\u7ed3\u679c`);
    return keywords_list;
  }
  while (true) {
    try {
      sendLog(`\u0078\u0069\u0061\u006f\u0048\u006f\u006e\u0067\u0073\u0068\u0075\u0043\u006c\u0069\u0063\u006b\u005f\u0063\u006f\u0076\u0065\u0072\u005f\u006c\u0064\u005f\u006d\u0061\u0073\u006b`);
      if (store$1.isNotRunWork()) {
        vipCloseEndFun(`\u0064\u006f\u0075\u0059\u0069\u006e\u0043\u006c\u0069\u0063\u006b\u005f\u0063\u006f\u0076\u0065\u0072\u005f\u006c\u0064\u005f\u006d\u0061\u0073\u006b`).then();
        return [];
      }
      let ul_list = document.querySelectorAll(`\u0023\u0073\u0065\u0061\u0072\u0063\u0068\u002d\u0063\u006f\u006e\u0074\u0065\u006e\u0074\u002d\u0061\u0072\u0065\u0061\u0020\u0075\u006c\u005b\u0064\u0061\u0074\u0061\u002d\u0065\u0032\u0065\u003d\u0022\u0073\u0063\u0072\u006f\u006c\u006c\u002d\u006c\u0069\u0073\u0074\u0022\u005d`);
      if (!ul_list || ul_list.length == 0) {
        sendLog(`\u6ca1\u6709\u627e\u5230\u641c\u7d22\u5217\u8868`);
        return [];
      }
      const ul_el = ul_list[0];
      let elements_list = ul_el.querySelectorAll(`\u003a\u0073\u0063\u006f\u0070\u0065\u0020\u003e\u0020\u006c\u0069`);
      let elements = Array.from(elements_list);
      sendLog(`\u0065\u006c\u0065\u006d\u0065\u006e\u0074\u0073\u003a` + elements.length);
      savePlatformData(elements);
      const title_texts = [];
      if (XiaoHongShu_Setting$1.smartKeywords == `\u667a\u80fd\u5173\u952e\u8bcd`) {
        if (get_keyword_bool) {
          for (let kk = 0; kk < elements.length; kk++) {
            const element = elements[kk];
            ensureElementVisible(element);
            let title_el = element.querySelector(`\u0064\u0069\u0076\u0020\u003e\u0020\u0064\u0069\u0076\u0020\u003e\u0020\u0064\u0069\u0076\u003a\u006e\u0074\u0068\u002d\u0063\u0068\u0069\u006c\u0064\u0028\u0032\u0029`);
            if (!title_el) {
              let tryTimeBool = false;
              for (let i = 0; i < 3; i++) {
                await delay(getRandomNumberInRange(1e3, 3e3));
                title_el = element.querySelector(`\u0064\u0069\u0076\u0020\u003e\u0020\u0064\u0069\u0076\u0020\u003e\u0020\u0064\u0069\u0076\u003a\u006e\u0074\u0068\u002d\u0063\u0068\u0069\u006c\u0064\u0028\u0032\u0029`);
                if (title_el) {
                  tryTimeBool = true;
                  break;
                }
              }
              if (!tryTimeBool) {
                continue;
              }
            }
            if (!title_el) {
              continue;
            }
            const title_text = (_a = title_el.textContent) == null ? void 0 : _a.trim();
            title_texts.push(title_text);
          }
          if (elements && elements.length > 0) {
            ensureElementVisible(elements[0]);
          }
          sendLog(`\u0074\u0069\u0074\u006c\u0065\u005f\u0074\u0065\u0078\u0074\u0073\uff1a` + JSON.stringify(title_texts));
          keywords_list = await getKeywordsIntelligentAssociation(title_texts, searchWord);
          sendLog(`\u006b\u0065\u0079\u0077\u006f\u0072\u0064\u0073\u005f\u006c\u0069\u0073\u0074\uff1a` + JSON.stringify(keywords_list));
          get_keyword_bool = false;
          const lastTime2 = await queryLastTime();
          sendLog(`\u0058\u0069\u0061\u006f\u0048\u006f\u006e\u0067\u0053\u0068\u0075\u005f\u0053\u0065\u0074\u0074\u0069\u006e\u0067\u002e\u006f\u0070\u0065\u0072\u0061\u0074\u0069\u006f\u006e\u0054\u0069\u006d\u0065\u0020` + lastTime2 + `\u0020` + XiaoHongShu_Setting$1.operationTime);
          let keywords_len = keywords_list.length;
          sendLog(`\u006b\u0065\u0079\u0077\u006f\u0072\u0064\u0073\u005f\u006c\u0065\u006e\uff1a` + keywords_len);
          const operationTime2 = parseInt(XiaoHongShu_Setting$1.operationTime);
          const avgTime = Math.ceil(operationTime2 / keywords_len);
          sendLog(`\u0058\u0069\u0061\u006f\u0048\u006f\u006e\u0067\u0053\u0068\u0075\u005f\u0061\u0076\u0067\u0054\u0069\u006d\u0065\uff1a` + avgTime);
          store$1.setXiaoHongShu_avgTime(avgTime);
          next_change_time = lastTime2;
        }
      }
      if (XiaoHongShu_Setting$1.workType == `\u5173\u952e\u8bcd` && XiaoHongShu_Setting$1.smartKeywords !== `\u667a\u80fd\u5173\u952e\u8bcd`) {
        store$1.setXiaoHongShu_avgTime(0);
      }
      let view_bool = false;
      let element_a_els = [];
      Array.from(elements).filter(element => {
        const element_div_el = element.querySelector(`\u0023\u0073\u006c\u0069\u0064\u0065\u0072\u0056\u0069\u0064\u0065\u006f`);
        if (!element_div_el) {
          return false;
        }
        const vid = element_div_el.getAttribute(`\u0064\u0061\u0074\u0061\u002d\u0065\u0032\u0065\u002d\u0076\u0069\u0064`);
        if (!viewedPaths.includes(vid)) {
          element_a_els.push(element);
        }
      });
      if (element_a_els.length == 0 && elements.length > 0) {
        ensureElementVisible(elements[elements.length - 1]);
      }
      elements = element_a_els;
      if (elements.length > 0) {
        const element = elements[0];
        await douYinList_processElements(element, view_bool);
        if (store$1.isNotRunWork()) {
          vipCloseEndFun(`\u0064\u006f\u0075\u0059\u0069\u006e\u0043\u006c\u0069\u0063\u006b\u005f\u0063\u006f\u0076\u0065\u0072\u005f\u006c\u0064\u005f\u006d\u0061\u0073\u006b\u0032`).then();
          break;
        }
        const element_div_el = element.querySelector(`\u0023\u0073\u006c\u0069\u0064\u0065\u0072\u0056\u0069\u0064\u0065\u006f`);
        if (!element_div_el) {
          sendLog(`\u0065\u006c\u0065\u006d\u0065\u006e\u0074\u005f\u0064\u0069\u0076\u005f\u0065\u006c\u0020\u0023\u0073\u006c\u0069\u0064\u0065\u0072\u0056\u0069\u0064\u0065\u006f`);
          continue;
        }
        const vid = element_div_el.getAttribute(`\u0064\u0061\u0074\u0061\u002d\u0065\u0032\u0065\u002d\u0076\u0069\u0064`);
        viewedPaths.push(vid);
        if (!(await checkDomPromise(`\u0023\u0073\u006c\u0069\u0064\u0065\u0072\u0056\u0069\u0064\u0065\u006f`, elements[0]))) {
          sendLog(`\u6ca1\u6709\u627e\u5230\u0023\u0073\u006c\u0069\u0064\u0065\u0072\u0056\u0069\u0064\u0065\u006f`);
          continue;
        }
      }
      if (elements.length == 0) {
        const end_container = document.querySelectorAll(`\u002e\u0065\u006e\u0064\u002d\u0063\u006f\u006e\u0074\u0061\u0069\u006e\u0065\u0072`);
        sendLog(`\u0065\u006e\u0064\u005f\u0063\u006f\u006e\u0074\u0061\u0069\u006e\u0065\u0072` + end_container);
        if (end_container && end_container.length > 0) {
          sendLog(`\u0065\u006e\u0064\u005f\u0063\u006f\u006e\u0074\u0061\u0069\u006e\u0065\u0072\u0020\u5904\u7406\u5b8c\u6210`);
          break;
        } else {
          sendLog(`\u7ee7\u7eed\u5904\u7406`);
        }
        await delay(1e3);
      }
      const lastTime = await queryLastTime();
      sendLog(`\u006c\u0061\u0073\u0074\u0054\u0069\u006d\u0065\uff1a` + lastTime + `\u0020` + store$1.XiaoHongShu_avgTime);
      const operationTime = parseInt(XiaoHongShu_Setting$1.operationTime);
      if (store$1.XiaoHongShu_avgTime && lastTime != next_change_time && lastTime != operationTime && lastTime % store$1.XiaoHongShu_avgTime == 0) {
        sendLog(`\u5f00\u59cb\u641c\u7d22\u4e0b\u4e00\u4e2a\u5173\u952e\u8bcd\u0020` + lastTime + `\u0020` + store$1.XiaoHongShu_avgTime + `\u0020` + operationTime);
        next_change_time = lastTime;
        break;
      }
    } catch (e) {
      sendLog(`\u0078\u0069\u0061\u006f\u0048\u006f\u006e\u0067\u0073\u0068\u0075\u0043\u006c\u0069\u0063\u006b\u005f\u0063\u006f\u0076\u0065\u0072\u005f\u006c\u0064\u005f\u006d\u0061\u0073\u006b\uff0c\u7ed3\u675f` + e);
      console.error(`\u0078\u0069\u0061\u006f\u0048\u006f\u006e\u0067\u0073\u0068\u0075\u0043\u006c\u0069\u0063\u006b\u005f\u0063\u006f\u0076\u0065\u0072\u005f\u006c\u0064\u005f\u006d\u0061\u0073\u006b`, e);
      await delay(1e3);
    }
  }
  return [keywords_list, next_change_time];
}
async function douYinList_processElements(element, view_bool = false) {
  try {
    sendLog(`\u5f00\u59cb\u4e0b\u4e00\u4e2a\u7b14\u8bb0\u0031`);
    if (!(await checkDomByDom(element))) {
      return;
    }
    sendLog(`\u5f00\u59cb\u4e0b\u4e00\u4e2a\u7b14\u8bb0\u0032`);
    if (store$1.isNotRunWork()) {
      return;
    }
    console.log(`\u0065\u006c\u0065\u006d\u0065\u006e\u0074`, element);
    ensureElementVisible(element);
    if (store$1.isNotRunWork()) {
      return;
    }
    if (!view_bool) {
      if (isWithinProbability(isWithinProbabilityOpen)) {
        store$1.increment_dy_viewCount();
        await douYin_tuwen_start_exec(element);
        await delay(getRandomNumberInRange(3e3, 6e3));
      } else {
        console.log(`\u8df3\u8fc7\u0020\u4e0d\u6253\u5f00\u56fe\u6587`);
        await delay(getRandomNumberInRange(1e3, 5e3));
      }
    } else {
      console.log(`\u53ea\u662f\u4e3a\u4e86\u6eda\u52a8\u9875\u9762\uff0c\u4e0d\u505a\u4efb\u4f55\u7684\u64cd\u4f5c`);
    }
  } catch (e) {
    sendLog(`\u0078\u0069\u0061\u006f\u0048\u006f\u006e\u0067\u0073\u0068\u0075\u005f\u006c\u0069\u0073\u0074\u005f\u0070\u0072\u006f\u0063\u0065\u0073\u0073\u0045\u006c\u0065\u006d\u0065\u006e\u0074\u0073\u0020\u0065\u0072\u0072\u006f\u0072` + e);
    console.error(e);
  } finally {
    console.log(`\u0041\u006c\u006c\u0020\u0065\u006c\u0065\u006d\u0065\u006e\u0074\u0073\u0020\u0068\u0061\u0076\u0065\u0020\u0062\u0065\u0065\u006e\u0020\u0070\u0072\u006f\u0063\u0065\u0073\u0073\u0065\u0064\u002e`);
  }
}
async function douYin_tuwen_start_exec(element) {
  if (!(await checkDomPromises([`\u002e\u0073\u0065\u0061\u0072\u0063\u0068\u002d\u0072\u0065\u0073\u0075\u006c\u0074\u002d\u0063\u0061\u0072\u0064\u0020\u003e\u0064\u0069\u0076\u003e\u0064\u0069\u0076\u003a\u006e\u0074\u0068\u002d\u0063\u0068\u0069\u006c\u0064\u0028\u0032\u0029\u0020\u003e\u0020\u0064\u0069\u0076\u0020\u003e\u0073\u0070\u0061\u006e\u0020\u003e\u0073\u0070\u0061\u006e`, `\u002e\u0073\u0065\u0061\u0072\u0063\u0068\u002d\u0072\u0065\u0073\u0075\u006c\u0074\u002d\u0063\u0061\u0072\u0064\u0020\u003e\u0064\u0069\u0076\u003e\u0064\u0069\u0076\u003e\u0064\u0069\u0076\u003e\u0070`], element))) {
    console.error(`\u6ca1\u6709\u627e\u5230`, `\u002e\u0073\u0065\u0061\u0072\u0063\u0068\u002d\u0072\u0065\u0073\u0075\u006c\u0074\u002d\u0063\u0061\u0072\u0064\u0020\u003e\u0064\u0069\u0076\u003e\u0064\u0069\u0076\u003a\u006e\u0074\u0068\u002d\u0063\u0068\u0069\u006c\u0064\u0028\u0032\u0029\u0020\u003e\u0020\u0064\u0069\u0076\u0020\u003e\u0073\u0070\u0061\u006e\u0020\u003e\u0073\u0070\u0061\u006e`);
    return;
  }
  const zhiBo_el = element.querySelector(`\u002e\u0073\u0065\u006d\u0069\u002d\u0074\u0061\u0067\u002d\u0063\u006f\u006e\u0074\u0065\u006e\u0074`);
  if (zhiBo_el) {
    console.log(`\u76f4\u64ad\uff0c\u8df3\u8fc7`);
    return;
  }
  const guangGao_el = element.querySelector(`\u002e\u0061\u0063\u0063\u006f\u0075\u006e\u0074\u0020\u0073\u0076\u0067`);
  if (guangGao_el) {
    console.log(`\u5e7f\u544a\uff0c\u8df3\u8fc7`);
    return;
  }
  if (store$1.isNotRunWork()) {
    return;
  }
  const stringList = [];
  if (XiaoHongShu_Setting$1.reviewProbability == `\u9ed8\u8ba4\u0041\u0049\u63a7\u5236`) {
    if (isWithinProbability(isWithinProbabilitysend_comments)) {
      stringList.push(`\u0064\u006f\u0075\u0059\u0069\u006e\u005f\u0073\u0065\u006e\u0064\u005f\u0063\u006f\u006d\u006d\u0065\u006e\u0074\u0073`);
    } else {
      console.log(`\u8df3\u8fc7\u0020\u4e0d\u8bc4\u8bba`);
    }
  } else if (XiaoHongShu_Setting$1.reviewProbability == `\u81ea\u5b9a\u4e49\u6982\u7387` && XiaoHongShu_Setting$1.customProbabilitiesNum && isWithinProbability(XiaoHongShu_Setting$1.customProbabilitiesNum)) {
    stringList.push(`\u0064\u006f\u0075\u0059\u0069\u006e\u005f\u0073\u0065\u006e\u0064\u005f\u0063\u006f\u006d\u006d\u0065\u006e\u0074\u0073`);
  }
  if (XiaoHongShu_Setting$1 == null ? void 0 : XiaoHongShu_Setting$1.like) {
    if (isWithinProbability(isWithinProbabilityclickCommentLike)) {
      stringList.push(`\u0064\u006f\u0075\u0059\u0069\u006e\u005f\u0063\u006c\u0069\u0063\u006b\u0043\u006f\u006d\u006d\u0065\u006e\u0074\u004c\u0069\u006b\u0065`);
    } else {
      console.log(`\u8df3\u8fc7\u0020\u4e0d\u70b9\u8d5e`);
    }
  }
  if (XiaoHongShu_Setting$1 == null ? void 0 : XiaoHongShu_Setting$1.follow) {
    if (isWithinProbability(isWithinProbabilityfollow_click)) {
      stringList.push(`\u0064\u006f\u0075\u0059\u0069\u006e\u005f\u0066\u006f\u006c\u006c\u006f\u0077\u005f\u0063\u006c\u0069\u0063\u006b`);
    } else {
      console.log(`\u8df3\u8fc7\u0020\u4e0d\u5173\u6ce8`);
    }
  }
  if (XiaoHongShu_Setting$1 == null ? void 0 : XiaoHongShu_Setting$1.collect) {
    if (isWithinProbability(isWithinProbabilitycollect_click)) {
      stringList.push(`\u0064\u006f\u0075\u0059\u0069\u006e\u005f\u0063\u006f\u006c\u006c\u0065\u0063\u0074\u005f\u0063\u006c\u0069\u0063\u006b`);
    } else {
      console.log(`\u8df3\u8fc7\u0020\u4e0d\u6536\u85cf`);
    }
  }
  await douYin_randomExecFunction(stringList, element, `\u641c\u7d22\u5173\u952e\u8bcd`);
}
async function douYin_randomExecFunction(strings, element, optionType) {
  let remainingStrings = [...strings];
  await delay(getRandomNumberInRange(1e3, 5e3));
  while (remainingStrings.length > 0) {
    if (store$1.isNotRunWork()) {
      return;
    }
    const randomIndex = Math.floor(Math.random() * remainingStrings.length);
    console.log(remainingStrings[randomIndex]);
    switch (remainingStrings[randomIndex]) {
      case `\u0064\u006f\u0075\u0059\u0069\u006e\u005f\u0073\u0065\u006e\u0064\u005f\u0063\u006f\u006d\u006d\u0065\u006e\u0074\u0073`:
        if (optionType == `\u641c\u7d22\u5173\u952e\u8bcd`) {
          await douYin_tuwen_read_info(element);
        }
        if (optionType == `\u4fe1\u606f\u6d41`) {
          await douYin_tuijian_comment(element);
        }
        break;
      case `\u0064\u006f\u0075\u0059\u0069\u006e\u005f\u0063\u006c\u0069\u0063\u006b\u0043\u006f\u006d\u006d\u0065\u006e\u0074\u004c\u0069\u006b\u0065`:
        await douYin_clickCommentLike(element);
        break;
      case `\u0064\u006f\u0075\u0059\u0069\u006e\u005f\u0066\u006f\u006c\u006c\u006f\u0077\u005f\u0063\u006c\u0069\u0063\u006b`:
        if (optionType == `\u641c\u7d22\u5173\u952e\u8bcd`) {
          await get_follow_user_url(element);
        }
        if (optionType == `\u4fe1\u606f\u6d41`) {
          await tuijian_flow(element);
        }
        break;
      case `\u0064\u006f\u0075\u0059\u0069\u006e\u005f\u0063\u006f\u006c\u006c\u0065\u0063\u0074\u005f\u0063\u006c\u0069\u0063\u006b`:
        await douYin_collect_click(element);
        break;
      default:
        console.error(`\u9519\u8bef\u4fe1\u606f`, remainingStrings[randomIndex]);
    }
    remainingStrings.splice(randomIndex, 1);
  }
}
async function douYin_tuwen_read_info(element) {
  var _a, _b;
  if (!(await checkDomPromises([`\u002e\u0073\u0065\u0061\u0072\u0063\u0068\u002d\u0072\u0065\u0073\u0075\u006c\u0074\u002d\u0063\u0061\u0072\u0064\u0020\u003e\u0064\u0069\u0076\u003e\u0064\u0069\u0076\u003a\u006e\u0074\u0068\u002d\u0063\u0068\u0069\u006c\u0064\u0028\u0032\u0029\u0020\u003e\u0020\u0064\u0069\u0076\u0020\u003e\u0073\u0070\u0061\u006e\u0020\u003e\u0073\u0070\u0061\u006e`, `\u002e\u0073\u0065\u0061\u0072\u0063\u0068\u002d\u0072\u0065\u0073\u0075\u006c\u0074\u002d\u0063\u0061\u0072\u0064\u0020\u003e\u0064\u0069\u0076\u003e\u0064\u0069\u0076\u003e\u0064\u0069\u0076\u003e\u0070`], element))) {
    console.error(`\u6ca1\u6709\u627e\u5230`, `\u002e\u0073\u0065\u0061\u0072\u0063\u0068\u002d\u0072\u0065\u0073\u0075\u006c\u0074\u002d\u0063\u0061\u0072\u0064\u0020\u003e\u0064\u0069\u0076\u003e\u0064\u0069\u0076\u003a\u006e\u0074\u0068\u002d\u0063\u0068\u0069\u006c\u0064\u0028\u0032\u0029\u0020\u003e\u0020\u0064\u0069\u0076\u0020\u003e\u0073\u0070\u0061\u006e\u0020\u003e\u0073\u0070\u0061\u006e`);
    return;
  }
  if (store$1.isNotRunWork()) {
    return;
  }
  const img_container_el = element.querySelector(`\u002e\u0069\u006d\u0067\u0042\u0061\u0063\u006b\u0067\u0072\u006f\u0075\u006e\u0064\u0020\u0069\u006d\u0067`);
  let img_container_url = ``;
  if (img_container_el) {
    img_container_url = img_container_el.src;
  }
  console.log(`\u0069\u006d\u0067\u005f\u0063\u006f\u006e\u0074\u0061\u0069\u006e\u0065\u0072\u005f\u0065\u006c\u003a`, img_container_el);
  console.log(`\u0069\u006d\u0067\u005f\u0063\u006f\u006e\u0074\u0061\u0069\u006e\u0065\u0072\u005f\u0075\u0072\u006c\u003a` + img_container_url);
  let detail_title_el = element.querySelector(`\u002e\u0073\u0065\u0061\u0072\u0063\u0068\u002d\u0072\u0065\u0073\u0075\u006c\u0074\u002d\u0063\u0061\u0072\u0064\u0020\u003e\u0064\u0069\u0076\u003e\u0064\u0069\u0076\u003a\u006e\u0074\u0068\u002d\u0063\u0068\u0069\u006c\u0064\u0028\u0032\u0029\u0020\u003e\u0020\u0064\u0069\u0076\u0020\u003e\u0073\u0070\u0061\u006e\u0020\u003e\u0073\u0070\u0061\u006e`);
  let detail_title = ``;
  if (detail_title_el) {
    detail_title = ((_a = detail_title_el.textContent) == null ? void 0 : _a.trim()) || ``;
  } else {
    detail_title_el = element.querySelector(`\u002e\u0073\u0065\u0061\u0072\u0063\u0068\u002d\u0072\u0065\u0073\u0075\u006c\u0074\u002d\u0063\u0061\u0072\u0064\u0020\u003e\u0064\u0069\u0076\u003e\u0064\u0069\u0076\u003e\u0064\u0069\u0076\u003e\u0070`);
  }
  if (detail_title_el) {
    detail_title = ((_b = detail_title_el.textContent) == null ? void 0 : _b.trim()) || ``;
  }
  console.log(`\u0064\u0065\u0074\u0061\u0069\u006c\u005f\u0074\u0069\u0074\u006c\u0065\u005f\u0065\u006c\u003a`, detail_title_el);
  console.log(`\u0064\u0065\u0074\u0061\u0069\u006c\u005f\u0074\u0069\u0074\u006c\u0065\u003a`, detail_title);
  let detail_content = ``;
  let detail_tag_str = ``;
  console.log(`\u0064\u0065\u0074\u0061\u0069\u006c\u005f\u0074\u0061\u0067\u005f\u0073\u0074\u0072\u003a`, detail_tag_str);
  let note_id = ``;
  const element_div_el = element.querySelector(`\u0023\u0073\u006c\u0069\u0064\u0065\u0072\u0056\u0069\u0064\u0065\u006f`);
  if (!element_div_el) {
    console.log(`\u0064\u0065\u0074\u0061\u0069\u006c\u005f\u0074\u0061\u0067\u005f\u0073\u0074\u0072\u003a`, detail_tag_str);
    return;
  }
  if (element_div_el) {
    note_id = element_div_el.getAttribute(`\u0064\u0061\u0074\u0061\u002d\u0065\u0032\u0065\u002d\u0076\u0069\u0064`);
  }
  if (store$1.isNotRunWork()) {
    return;
  }
  await click_comment_button(element);
  const textContent_str = await get_douYin_send_child_comment();
  const user_infos = document.querySelectorAll(`\u002e\u0073\u0065\u0061\u0072\u0063\u0068\u002d\u0072\u0065\u0073\u0075\u006c\u0074\u002d\u0063\u0061\u0072\u0064\u0020\u003e\u0064\u0069\u0076\u0020\u003e\u0020\u0064\u0069\u0076\u0020\u003e\u0064\u0069\u0076\u0020\u003e\u0020\u0061`);
  let comment_user_url = ``;
  let comment_user_id = ``;
  if (user_infos && user_infos.length > 0) {
    const user_info = user_infos[0];
    comment_user_url = user_info.href;
    if (comment_user_url) {
      if (comment_user_url.startsWith(`\u002f\u002f`)) {
        comment_user_url = `\u0068\u0074\u0074\u0070\u0073\u003a` + comment_user_url;
      }
      const pathname = new URL(comment_user_url).pathname;
      comment_user_id = getLastPathName$1(pathname);
    }
  }
  sendLog(`\u0050\u0061\u0074\u0068\u003a\u0020` + store$1.userId + `\u0020\u0020` + note_id);
  const refer_id = `\u0061\u0075\u0074\u006f\u005f\u0063\u006f\u006d\u006d\u0065\u006e\u0074\u005f\u0064\u006f\u0075\u005f\u0079\u0069\u006e\u005f\u0075\u0073\u0065\u0072\u005f` + store$1.userId + `\u005f\u0070\u0061\u0074\u0068\u005f` + note_id;
  if (await queryComment$1(refer_id)) {
    let result = null;
    sendLog(`\u6ca1\u6709\u914d\u7f6e\u0020\u0073\u0074\u0079\u006c\u0065\u0020` + (XiaoHongShu_Setting$1 == null ? void 0 : XiaoHongShu_Setting$1.style) + `\u0020` + (XiaoHongShu_Setting$1 == null ? void 0 : XiaoHongShu_Setting$1.charLimit) + `\u0020` + (XiaoHongShu_Setting$1 == null ? void 0 : XiaoHongShu_Setting$1.keywordInfo));
    const inputs = {
      test: detail_title,
      commentaries: textContent_str,
      style: XiaoHongShu_Setting$1 == null ? void 0 : XiaoHongShu_Setting$1.style,
      word_limit: XiaoHongShu_Setting$1 == null ? void 0 : XiaoHongShu_Setting$1.charLimit,
      key_message: XiaoHongShu_Setting$1 == null ? void 0 : XiaoHongShu_Setting$1.keywordInfo
    };
    const files = [];
    if (img_container_url) {
      files.push({
        type: `\u0069\u006d\u0061\u0067\u0065`,
        transfer_method: `\u0072\u0065\u006d\u006f\u0074\u0065\u005f\u0075\u0072\u006c`,
        url: img_container_url
      });
    }
    if (XiaoHongShu_Setting$1.commentBlocking == `\u8bc4\u8bba\u622a\u6d41` && XiaoHongShu_Setting$1.commentBlockingNum > 0) {
      const callbackFun = async () => {
        const apiKey2 = `\u0061\u0070\u0070\u002d\u0049\u0069\u0037\u0056\u0045\u0062\u0062\u0031\u0065\u0052\u0078\u0038\u0034\u0052\u0068\u0068\u0074\u004c\u004c\u004c\u0052\u0041\u0044\u0039`;
        result = await runWorkflow$1(inputs, files, apiKey2);
        return result;
      };
      await douYin_send_child_comment(callbackFun, element, `\u002e\u0063\u006f\u006d\u006d\u0065\u006e\u0074\u0049\u006e\u0070\u0075\u0074\u002d\u0072\u0069\u0067\u0068\u0074\u002d\u0063\u0074\u0020\u0070\u0061\u0074\u0068\u005b\u0066\u0069\u006c\u006c\u003d\u0022\u0023\u0046\u0045\u0032\u0043\u0035\u0035\u0022\u005d`);
    }
    const apiKey = `\u0061\u0070\u0070\u002d\u0049\u0069\u0037\u0056\u0045\u0062\u0062\u0031\u0065\u0052\u0078\u0038\u0034\u0052\u0068\u0068\u0074\u004c\u004c\u004c\u0052\u0041\u0044\u0039`;
    result = await runWorkflow$1(inputs, files, apiKey);
    sendLog(`\u0072\u0065\u0073\u0075\u006c\u0074\u003a\u0020` + result);
    if (result) {
      const saveInputsData = {
        refer_id,
        // 数据唯一标识，格式为：auto_comment_dou_yin_user_{userId}_path_{note_id}
        title: detail_title,
        // 视频标题/描述文本
        text: detail_content,
        // 视频正文内容
        label: detail_tag_str,
        // 视频标签，包含话题标签
        style: XiaoHongShu_Setting$1 == null ? void 0 : XiaoHongShu_Setting$1.style,
        // 评论风格设置，如：幽默、正式等
        word_limit: XiaoHongShu_Setting$1 == null ? void 0 : XiaoHongShu_Setting$1.charLimit,
        // 评论字数限制
        key_message: XiaoHongShu_Setting$1 == null ? void 0 : XiaoHongShu_Setting$1.keywordInfo,
        // 评论关键信息/关键词设置
        note_url: `\u0068\u0074\u0074\u0070\u0073\u003a\u002f\u002f\u0077\u0077\u0077\u002e\u0064\u006f\u0075\u0079\u0069\u006e\u002e\u0063\u006f\u006d\u002f\u0076\u0069\u0064\u0065\u006f\u002f${note_id}`,
        // 视频链接地址，由视频ID拼接而成
        note_id,
        // 视频唯一ID，来自data-e2e-vid属性
        comment_user_url,
        // 视频作者主页链接
        comment_user_id,
        // 视频作者ID
        extra_image_id: ``,
        // 额外图片ID（当前为空）
        extra_image_url: img_container_url,
        // 视频封面图片URL
        replyComment: result,
        // AI生成的评论内容
        userId: store$1.userId,
        // 当前操作用户的ID
        taskId: store$1.taskId,
        // 当前任务ID
        addTime: (/* @__PURE__ */new Date()).getTime()
        // 数据添加时间戳，13位毫秒级
      };
      const saveInputs = {
        "key": refer_id,
        "bucket": saveInputsData,
        "size": 0,
        "content_type": `\u0073\u0074\u0072\u0069\u006e\u0067`,
        "belong_to": store$1.userId + `\u005f\u0064\u006f\u0075\u0059\u0069\u006e\u005f\u0063\u006f\u006d\u006d\u0065\u006e\u0074`,
        "object_metadata": {}
      };
      await douYin_send_comments(result, saveInputs, element, `\u002e\u0063\u006f\u006d\u006d\u0065\u006e\u0074\u0049\u006e\u0070\u0075\u0074\u002d\u0072\u0069\u0067\u0068\u0074\u002d\u0063\u0074\u0020\u0070\u0061\u0074\u0068\u005b\u0066\u0069\u006c\u006c\u003d\u0022\u0023\u0046\u0045\u0032\u0043\u0035\u0035\u0022\u005d`);
    }
  } else {
    console.log(`\u5df2\u8bc4\u8bba\u8fc7\u3002\u8df3\u8fc7`);
  }
}
async function click_comment_button(element) {
  if (!(await checkDomPromise(`\u0064\u0069\u0076\u005b\u0064\u0061\u0074\u0061\u002d\u0065\u0032\u0065\u003d\u0022\u0066\u0065\u0065\u0064\u002d\u0063\u006f\u006d\u006d\u0065\u006e\u0074\u002d\u0069\u0063\u006f\u006e\u0022\u005d`, element))) {
    console.error(`\u6ca1\u6709\u627e\u5230`, `\u0064\u0069\u0076\u005b\u0064\u0061\u0074\u0061\u002d\u0065\u0032\u0065\u003d\u0022\u0066\u0065\u0065\u0064\u002d\u0063\u006f\u006d\u006d\u0065\u006e\u0074\u002d\u0069\u0063\u006f\u006e\u0022\u005d`);
    return;
  }
  if (store$1.isNotRunWork()) {
    return;
  }
  const content_edit = element.querySelector(`\u0064\u0069\u0076\u005b\u0064\u0061\u0074\u0061\u002d\u0065\u0032\u0065\u003d\u0022\u0066\u0065\u0065\u0064\u002d\u0063\u006f\u006d\u006d\u0065\u006e\u0074\u002d\u0069\u0063\u006f\u006e\u0022\u005d`);
  if (!content_edit) {
    console.error(`\u6ca1\u6709\u627e\u5230\u8f93\u5165\u8bc4\u8bba\u7684\u8f93\u5165\u6846`);
    return;
  }
  const input_el = document.querySelector(`\u0023\u006d\u0065\u0072\u0067\u0065\u002d\u0061\u006c\u006c\u002d\u0063\u006f\u006d\u006d\u0065\u006e\u0074\u002d\u0063\u006f\u006e\u0074\u0061\u0069\u006e\u0065\u0072\u0020\u002e\u0063\u006f\u006d\u006d\u0065\u006e\u0074\u002d\u0069\u006e\u0070\u0075\u0074\u002d\u0069\u006e\u006e\u0065\u0072\u002d\u0063\u006f\u006e\u0074\u0061\u0069\u006e\u0065\u0072\u0020\u003e\u0064\u0069\u0076\u003a\u006e\u0074\u0068\u002d\u0063\u0068\u0069\u006c\u0064\u0028\u0031\u0029`);
  if (input_el) {
    sendLog(`\u8f93\u5165\u6846\u5b58\u5728\uff0c\u8bc4\u8bba\u5df2\u5c55\u5f00\uff0c\u4e0d\u9700\u8981\u518d\u70b9\u51fb\u8bc4\u8bba\u6309\u94ae\uff0c\u5c55\u5f00\u8bc4\u8bba`);
    return;
  }
  await click_button(content_edit);
}
async function get_douYin_send_child_comment() {
  var _a, _b, _c;
  if (!(await checkDomPromise(`\u002e\u0063\u006f\u006d\u006d\u0065\u006e\u0074\u002d\u006d\u0061\u0069\u006e\u0043\u006f\u006e\u0074\u0065\u006e\u0074`))) {
    console.error(`\u6ca1\u6709\u627e\u5230`, `\u002e\u0063\u006f\u006d\u006d\u0065\u006e\u0074\u002d\u006d\u0061\u0069\u006e\u0043\u006f\u006e\u0074\u0065\u006e\u0074`);
    return;
  }
  const newList = [];
  const parentComments = document.querySelectorAll(`\u002e\u0063\u006f\u006d\u006d\u0065\u006e\u0074\u002d\u006d\u0061\u0069\u006e\u0043\u006f\u006e\u0074\u0065\u006e\u0074\u0020\u0064\u0069\u0076\u005b\u0064\u0061\u0074\u0061\u002d\u0065\u0032\u0065\u003d\u0022\u0063\u006f\u006d\u006d\u0065\u006e\u0074\u002d\u0069\u0074\u0065\u006d\u0022\u005d\u0020\u003e\u0064\u0069\u0076\u003a\u006e\u0074\u0068\u002d\u0063\u0068\u0069\u006c\u0064\u0028\u0032\u0029\u0020\u003e\u0064\u0069\u0076`);
  for (let i = 0; i < 10; i++) {
    if (parentComments[i]) {
      const selfEl = parentComments[i].querySelector(`\u002e\u0073\u0065\u006d\u0069\u002d\u0074\u0061\u0067\u002d\u0063\u006f\u006e\u0074\u0065\u006e\u0074\u002d\u0063\u0065\u006e\u0074\u0065\u0072`);
      if (selfEl) {
        const selfEl_text = (_a = selfEl.textContent) == null ? void 0 : _a.trim();
        if (selfEl_text == `\u4f5c\u8005`) {
          continue;
        }
        continue;
      }
      const nextSibling_el = (_b = parentComments[i].querySelector(`\u002e\u0063\u006f\u006d\u006d\u0065\u006e\u0074\u002d\u0069\u0074\u0065\u006d\u002d\u0069\u006e\u0066\u006f\u002d\u0077\u0072\u0061\u0070`)) == null ? void 0 : _b.nextElementSibling;
      if (nextSibling_el) {
        const textContent = (_c = nextSibling_el.textContent) == null ? void 0 : _c.trim();
        if (textContent) {
          newList.push(textContent);
          if (newList.length == 5) {
            break;
          }
        }
      }
    }
  }
  console.log(`\u006e\u0065\u0077\u004c\u0069\u0073\u0074`, newList);
  let textContent_str = ``;
  for (let i = 0; i < newList.length; i++) {
    if (textContent_str) {
      textContent_str += `\u000a`;
    }
    textContent_str += i + 1 + `\u3001` + newList[i];
  }
  return textContent_str;
}
async function douYin_send_comments(content, saveInputs, element, sendButtonQuerySelector = `\u002e\u0063\u006f\u006d\u006d\u0065\u006e\u0074\u0049\u006e\u0070\u0075\u0074\u002d\u0072\u0069\u0067\u0068\u0074\u002d\u0063\u0074\u0020\u0070\u0061\u0074\u0068\u005b\u0066\u0069\u006c\u006c\u003d\u0022\u0023\u0046\u0045\u0032\u0043\u0035\u0035\u0022\u005d`) {
  var _a;
  console.log(`\u0064\u006f\u0075\u0059\u0069\u006e\u005f\u0073\u0065\u006e\u0064\u005f\u0063\u006f\u006d\u006d\u0065\u006e\u0074\u0073`);
  await delay(getRandomNumberInRange(1e3, 5e3));
  if (store$1.isNotRunWork()) {
    return;
  }
  if (!(await checkDomPromise(`\u0023\u006d\u0065\u0072\u0067\u0065\u002d\u0061\u006c\u006c\u002d\u0063\u006f\u006d\u006d\u0065\u006e\u0074\u002d\u0063\u006f\u006e\u0074\u0061\u0069\u006e\u0065\u0072\u0020\u002e\u0063\u006f\u006d\u006d\u0065\u006e\u0074\u002d\u0069\u006e\u0070\u0075\u0074\u002d\u0069\u006e\u006e\u0065\u0072\u002d\u0063\u006f\u006e\u0074\u0061\u0069\u006e\u0065\u0072\u0020\u003e\u0064\u0069\u0076\u003a\u006e\u0074\u0068\u002d\u0063\u0068\u0069\u006c\u0064\u0028\u0031\u0029`))) {
    console.error(`\u6ca1\u6709\u627e\u5230`, `\u0023\u0063\u006f\u006e\u0074\u0065\u006e\u0074\u002d\u0074\u0065\u0078\u0074\u0061\u0072\u0065\u0061`);
    return;
  }
  const comment_input_el = element.querySelector(`\u0023\u006d\u0065\u0072\u0067\u0065\u002d\u0061\u006c\u006c\u002d\u0063\u006f\u006d\u006d\u0065\u006e\u0074\u002d\u0063\u006f\u006e\u0074\u0061\u0069\u006e\u0065\u0072\u0020\u002e\u0063\u006f\u006d\u006d\u0065\u006e\u0074\u002d\u0069\u006e\u0070\u0075\u0074\u002d\u0069\u006e\u006e\u0065\u0072\u002d\u0063\u006f\u006e\u0074\u0061\u0069\u006e\u0065\u0072\u0020\u003e\u0064\u0069\u0076\u003a\u006e\u0074\u0068\u002d\u0063\u0068\u0069\u006c\u0064\u0028\u0031\u0029`);
  if (!comment_input_el) {
    console.error(`\u6ca1\u6709\u627e\u5230\u8f93\u5165\u8bc4\u8bba\u7684\u8f93\u5165\u6846`);
    return;
  }
  await click_button(comment_input_el);
  if (!(await checkDomPromise(`\u002e\u006e\u006f\u0074\u0072\u0061\u006e\u0073\u006c\u0061\u0074\u0065\u002e\u0070\u0075\u0062\u006c\u0069\u0063\u002d\u0044\u0072\u0061\u0066\u0074\u0045\u0064\u0069\u0074\u006f\u0072\u002d\u0063\u006f\u006e\u0074\u0065\u006e\u0074`))) {
    sendLog(`\u6ca1\u6709\u627e\u5230\u0020\u0023\u0063\u006f\u006e\u0074\u0065\u006e\u0074\u002d\u0074\u0065\u0078\u0074\u0061\u0072\u0065\u0061`);
    return;
  }
  const targetElement = document.querySelector(`\u002e\u006e\u006f\u0074\u0072\u0061\u006e\u0073\u006c\u0061\u0074\u0065\u002e\u0070\u0075\u0062\u006c\u0069\u0063\u002d\u0044\u0072\u0061\u0066\u0074\u0045\u0064\u0069\u0074\u006f\u0072\u002d\u0063\u006f\u006e\u0074\u0065\u006e\u0074`);
  if (!targetElement) {
    console.error(`\u6ca1\u6709\u627e\u5230\u8f93\u5165\u6846`);
    return;
  }
  console.log(`\u589e\u52a0\u8bc4\u8bba\u540e\u7f00\u4fe1\u606f`, XiaoHongShu_Setting$1 == null ? void 0 : XiaoHongShu_Setting$1.commentSuffix);
  if (XiaoHongShu_Setting$1 == null ? void 0 : XiaoHongShu_Setting$1.commentSuffix) {
    console.log(`\u589e\u52a0\u8bc4\u8bba\u540e\u7f00\u4fe1\u606f`, XiaoHongShu_Setting$1 == null ? void 0 : XiaoHongShu_Setting$1.commentSuffix);
    content += `\u000d\u000a` + (XiaoHongShu_Setting$1 == null ? void 0 : XiaoHongShu_Setting$1.commentSuffix);
  }
  if (targetElement) {
    sendLog(`\u6267\u884c\u0020\u0074\u0061\u0072\u0067\u0065\u0074\u0045\u006c\u0065\u006d\u0065\u006e\u0074\uff1a` + store$1.chromeTabId);
    chrome.runtime.onMessage.addListener((request2, sender2, sendResponse2) => queryActiveElement(request2, sender2, sendResponse2, `\u002e\u006e\u006f\u0074\u0072\u0061\u006e\u0073\u006c\u0061\u0074\u0065\u002e\u0070\u0075\u0062\u006c\u0069\u0063\u002d\u0044\u0072\u0061\u0066\u0074\u0045\u0064\u0069\u0074\u006f\u0072\u002d\u0063\u006f\u006e\u0074\u0065\u006e\u0074`));
    await simulateInputSendMessage(content, 200, true);
    chrome.runtime.onMessage.removeListener((request2, sender2, sendResponse2) => queryActiveElement(request2, sender2, sendResponse2, `\u002e\u006e\u006f\u0074\u0072\u0061\u006e\u0073\u006c\u0061\u0074\u0065\u002e\u0070\u0075\u0062\u006c\u0069\u0063\u002d\u0044\u0072\u0061\u0066\u0074\u0045\u0064\u0069\u0074\u006f\u0072\u002d\u0063\u006f\u006e\u0074\u0065\u006e\u0074`));
  } else {
    sendLog(`\u0054\u0061\u0072\u0067\u0065\u0074\u0020\u0065\u006c\u0065\u006d\u0065\u006e\u0074\u0020\u006e\u006f\u0074\u0020\u0066\u006f\u0075\u006e\u0064\u002e`);
  }
  if (store$1.isNotRunWork()) {
    return;
  }
  if (!(await checkDomPromise(sendButtonQuerySelector))) {
    sendLog(`\u6ca1\u6709\u627e\u5230\u0020\u0023\u0063\u006f\u006e\u0074\u0065\u006e\u0074\u002d\u0074\u0065\u0078\u0074\u0061\u0072\u0065\u0061`);
    return;
  }
  const submit = element.querySelector(sendButtonQuerySelector);
  if (!submit) {
    console.error(`\u70b9\u51fb\u53d1\u8868\u8bc4\u8bba\u5931\u8d25`);
    return;
  }
  await click_button(submit);
  let indexNum = 0;
  while (true) {
    if (indexNum > 60) {
      break;
    }
    if (indexNum > 1) {
      console.log(`\u0069\u006e\u0064\u0065\u0078\u004e\u0075\u006d`, indexNum++);
      await delay(1e3);
    }
    indexNum++;
    const response_text_el = element.querySelector(`\u002e\u0070\u0075\u0062\u006c\u0069\u0063\u002d\u0044\u0072\u0061\u0066\u0074\u0045\u0064\u0069\u0074\u006f\u0072\u002d\u0063\u006f\u006e\u0074\u0065\u006e\u0074\u0020\u003e\u0020\u0064\u0069\u0076\u0020\u003e\u0020\u0064\u0069\u0076\u0020\u003e\u0020\u0064\u0069\u0076\u0020\u003e\u0020\u0073\u0070\u0061\u006e\u003a\u006e\u0074\u0068\u002d\u0063\u0068\u0069\u006c\u0064\u0028\u0031\u0029`);
    if (!response_text_el) {
      console.log(`\u6ca1\u6709\u627e\u5230\u8f93\u5165\u6846`);
      continue;
    }
    let response_text = ((_a = response_text_el.textContent) == null ? void 0 : _a.trim()) || ``;
    if (response_text) {
      console.log(`\u8f93\u5165\u6846\u4e0d\u4e3a\u7a7a`);
      continue;
    }
    break;
  }
  store$1.increment_dy_CommentCount();
  console.log(`\u8bc4\u8bba\u6210\u529f`);
  await saveComment$1(saveInputs);
  await delay(getRandomNumberInRange(1e3, 5e3));
}
async function douYin_clickCommentLike(element) {
  if (store$1.isNotRunWork()) {
    return;
  }
  if (!(XiaoHongShu_Setting$1 == null ? void 0 : XiaoHongShu_Setting$1.like)) {
    console.log(`\u4e0d\u9700\u8981\u70b9\u8d5e`);
    return;
  }
  if (!(await checkDomPromise(`\u0064\u0069\u0076\u005b\u0064\u0061\u0074\u0061\u002d\u0065\u0032\u0065\u003d\u0022\u0076\u0069\u0064\u0065\u006f\u002d\u0070\u006c\u0061\u0079\u0065\u0072\u002d\u0064\u0069\u0067\u0067\u0022\u005d`, element))) {
    console.error(`\u6ca1\u6709\u627e\u5230`, `\u0064\u0069\u0076\u005b\u0064\u0061\u0074\u0061\u002d\u0065\u0032\u0065\u003d\u0022\u0076\u0069\u0064\u0065\u006f\u002d\u0070\u006c\u0061\u0079\u0065\u0072\u002d\u0064\u0069\u0067\u0067\u0022\u005d`);
    return;
  }
  if (store$1.isNotRunWork()) {
    return;
  }
  const like_el = element.querySelector(`\u0064\u0069\u0076\u005b\u0064\u0061\u0074\u0061\u002d\u0065\u0032\u0065\u003d\u0022\u0076\u0069\u0064\u0065\u006f\u002d\u0070\u006c\u0061\u0079\u0065\u0072\u002d\u0064\u0069\u0067\u0067\u0022\u005d`);
  if (!like_el) {
    console.log(`\u6ca1\u6709\u70b9\u8d5e\u6309\u94ae`);
    return;
  }
  const liked = like_el.getAttribute(`\u0064\u0061\u0074\u0061\u002d\u0065\u0032\u0065\u002d\u0073\u0074\u0061\u0074\u0065`);
  if (!liked) {
    console.log(`\u6ca1\u6709\u627e\u5230\u70b9\u8d5e\u60c5\u51b5`);
    return;
  }
  console.log(`\u006c\u0069\u006b\u0065\u0064\u0020`, liked);
  if (liked == `\u0076\u0069\u0064\u0065\u006f\u002d\u0070\u006c\u0061\u0079\u0065\u0072\u002d\u0069\u0073\u002d\u0064\u0069\u0067\u0067\u0065\u0064`) {
    console.log(`\u5df2\u70b9\u8d5e`);
    return;
  }
  await click_button(like_el);
  store$1.increment_dy_likeCount();
  await delay(getRandomNumberInRange(1e3, 5e3));
}
async function get_follow_user_url(element) {
  if (store$1.isNotRunWork()) {
    return;
  }
  if (!(XiaoHongShu_Setting$1 == null ? void 0 : XiaoHongShu_Setting$1.follow)) {
    console.log(`\u4e0d\u9700\u8981\u5173\u6ce8`);
    return;
  }
  if (!(await checkDomPromises([`\u002e\u0073\u0065\u0061\u0072\u0063\u0068\u002d\u0072\u0065\u0073\u0075\u006c\u0074\u002d\u0063\u0061\u0072\u0064\u0020\u003e\u0064\u0069\u0076\u0020\u003e\u0020\u0064\u0069\u0076\u0020\u003e\u0064\u0069\u0076\u0020\u003e\u0064\u0069\u0076\u003e\u0064\u0069\u0076\u0020\u003e\u0020\u0061`], element))) {
    console.error(`\u6ca1\u6709\u627e\u5230`, `\u002e\u0073\u0065\u0061\u0072\u0063\u0068\u002d\u0072\u0065\u0073\u0075\u006c\u0074\u002d\u0063\u0061\u0072\u0064\u0020\u003e\u0064\u0069\u0076\u0020\u003e\u0020\u0064\u0069\u0076\u0020\u003e\u0064\u0069\u0076\u0020\u003e\u0064\u0069\u0076\u003e\u0064\u0069\u0076\u0020\u003e\u0020\u0061`);
    return;
  }
  if (store$1.isNotRunWork()) {
    return;
  }
  let user_url_el = element.querySelector(`\u002e\u0073\u0065\u0061\u0072\u0063\u0068\u002d\u0072\u0065\u0073\u0075\u006c\u0074\u002d\u0063\u0061\u0072\u0064\u0020\u003e\u0064\u0069\u0076\u0020\u003e\u0020\u0064\u0069\u0076\u0020\u003e\u0064\u0069\u0076\u0020\u003e\u0064\u0069\u0076\u003e\u0064\u0069\u0076\u0020\u003e\u0020\u0061`);
  if (!user_url_el) {
    console.log(`\u0075\u0073\u0065\u0072\u005f\u0075\u0072\u006c`, user_url_el);
    return;
  }
  const href_url = user_url_el.getAttribute(`\u0068\u0072\u0065\u0066`);
  let protocol = ``;
  try {
    let url = window.location.href;
    if (url.startsWith(`\u002f\u002f`)) {
      url = `\u0068\u0074\u0074\u0070\u0073\u003a` + url;
    }
    const parsedUrl = new URL(url);
    protocol = parsedUrl.protocol;
  } catch (error) {
    console.error(`\u0049\u006e\u0076\u0061\u006c\u0069\u0064\u0020\u0055\u0052\u004c\u003a`, error);
    return `\u0049\u006e\u0076\u0061\u006c\u0069\u0064\u0020\u0055\u0052\u004c`;
  }
  const taskQueue = new AsyncTaskQueue(1);
  const message = {
    action: `\u0065\u0078\u0065\u0063\u0075\u0074\u0065\u0054\u0061\u0073\u006b\u004e\u006f\u0054\u0061\u0073\u006b`,
    url: protocol + href_url,
    taskName: `\u641c\u7d22\u5173\u952e\u8bcd\u5173\u6ce8\u7528\u6237`,
    taskPlatform: `\u6296\u97f3`
  };
  await taskQueue.enqueue(openNewWindowNote(message));
  await taskQueue.waitForAll();
}
async function douYin_follow_click() {
  var _a;
  if (store$1.isNotRunWork()) {
    return;
  }
  if (!(XiaoHongShu_Setting$1 == null ? void 0 : XiaoHongShu_Setting$1.follow)) {
    console.log(`\u4e0d\u9700\u8981\u5173\u6ce8`);
    return;
  }
  if (!(await checkDomPromise(`\u0064\u0069\u0076\u005b\u0064\u0061\u0074\u0061\u002d\u0065\u0032\u0065\u003d\u0022\u0075\u0073\u0065\u0072\u002d\u0064\u0065\u0074\u0061\u0069\u006c\u0022\u005d\u0020\u0062\u0075\u0074\u0074\u006f\u006e\u005b\u0064\u0061\u0074\u0061\u002d\u0065\u0032\u0065\u003d\u0022\u0075\u0073\u0065\u0072\u002d\u0069\u006e\u0066\u006f\u002d\u0066\u006f\u006c\u006c\u006f\u0077\u002d\u0062\u0074\u006e\u0022\u005d`))) {
    console.error(`\u6ca1\u6709\u627e\u5230`, `\u0064\u0069\u0076\u005b\u0064\u0061\u0074\u0061\u002d\u0065\u0032\u0065\u003d\u0022\u0075\u0073\u0065\u0072\u002d\u0064\u0065\u0074\u0061\u0069\u006c\u0022\u005d\u0020\u0062\u0075\u0074\u0074\u006f\u006e\u005b\u0064\u0061\u0074\u0061\u002d\u0065\u0032\u0065\u003d\u0022\u0075\u0073\u0065\u0072\u002d\u0069\u006e\u0066\u006f\u002d\u0066\u006f\u006c\u006c\u006f\u0077\u002d\u0062\u0074\u006e\u0022\u005d`);
    return;
  }
  if (store$1.isNotRunWork()) {
    return;
  }
  const follows_div = document.querySelectorAll(`\u0064\u0069\u0076\u005b\u0064\u0061\u0074\u0061\u002d\u0065\u0032\u0065\u003d\u0022\u0075\u0073\u0065\u0072\u002d\u0064\u0065\u0074\u0061\u0069\u006c\u0022\u005d\u0020\u0062\u0075\u0074\u0074\u006f\u006e\u005b\u0064\u0061\u0074\u0061\u002d\u0065\u0032\u0065\u003d\u0022\u0075\u0073\u0065\u0072\u002d\u0069\u006e\u0066\u006f\u002d\u0066\u006f\u006c\u006c\u006f\u0077\u002d\u0062\u0074\u006e\u0022\u005d`);
  let follow_div = null;
  if (follows_div && follows_div.length > 0) {
    if (follows_div.length == 2) {
      follow_div = follows_div[1];
    } else {
      follow_div = follows_div[0];
    }
  }
  if (!follow_div) {
    console.error(`\u6ca1\u6709\u627e\u5230\u0020\u5173\u6ce8\u7684\u6309\u94ae`);
    return;
  }
  const follow_div_text = ((_a = follow_div.textContent) == null ? void 0 : _a.trim()) || ``;
  if (!follow_div_text) {
    console.error(`\u6ca1\u6709\u67e5\u5230\u5173\u6ce8\u6587\u672c`);
    return;
  }
  if (follow_div_text == `\u5df2\u5173\u6ce8`) {
    console.error(`\u5df2\u5173\u6ce8\u4e86\uff0c\u4e0d\u9700\u8981\u91cd\u590d\u5173\u6ce8`);
    return;
  }
  await click_button(follow_div);
  store$1.increment_dy_followCount();
  await delay(getRandomNumberInRange(1e3, 5e3));
}
async function douYin_collect_click(element) {
  if (store$1.isNotRunWork()) {
    return;
  }
  if (!(XiaoHongShu_Setting$1 == null ? void 0 : XiaoHongShu_Setting$1.collect)) {
    console.log(`\u4e0d\u9700\u8981\u6536\u85cf`);
    return;
  }
  if (!(await checkDomPromise(`\u0064\u0069\u0076\u005b\u0064\u0061\u0074\u0061\u002d\u0065\u0032\u0065\u003d\u0022\u0076\u0069\u0064\u0065\u006f\u002d\u0070\u006c\u0061\u0079\u0065\u0072\u002d\u0063\u006f\u006c\u006c\u0065\u0063\u0074\u0022\u005d`, element))) {
    console.error(`\u6ca1\u6709\u627e\u5230`, `\u0064\u0069\u0076\u005b\u0064\u0061\u0074\u0061\u002d\u0065\u0032\u0065\u003d\u0022\u0076\u0069\u0064\u0065\u006f\u002d\u0070\u006c\u0061\u0079\u0065\u0072\u002d\u0063\u006f\u006c\u006c\u0065\u0063\u0074\u0022\u005d`);
    return;
  }
  if (store$1.isNotRunWork()) {
    return;
  }
  const collect_el = element.querySelector(`\u0064\u0069\u0076\u005b\u0064\u0061\u0074\u0061\u002d\u0065\u0032\u0065\u003d\u0022\u0076\u0069\u0064\u0065\u006f\u002d\u0070\u006c\u0061\u0079\u0065\u0072\u002d\u0063\u006f\u006c\u006c\u0065\u0063\u0074\u0022\u005d`);
  if (!collect_el) {
    console.error(`\u6ca1\u6709\u627e\u5230\u70b9\u8d5e\u7684\u6807\u7b7e`);
    return;
  }
  const collectd = collect_el.getAttribute(`\u0064\u0061\u0074\u0061\u002d\u0065\u0032\u0065\u002d\u0073\u0074\u0061\u0074\u0065`);
  if (!collectd) {
    console.log(`\u6ca1\u6709\u627e\u5230\u70b9\u8d5e\u60c5\u51b5`);
    return;
  }
  console.log(`\u0063\u006f\u006c\u006c\u0065\u0063\u0074\u0064\u0020`, collectd);
  if (collectd == `\u0076\u0069\u0064\u0065\u006f\u002d\u0070\u006c\u0061\u0079\u0065\u0072\u002d\u0069\u0073\u002d\u0063\u006f\u006c\u006c\u0065\u0063\u0074`) {
    console.log(`\u5df2\u70b9\u8d5e`);
    return;
  }
  await click_button(collect_el);
  store$1.increment_dy_collectCount();
  await delay(getRandomNumberInRange(1e3, 5e3));
}
async function douYinTuiJian() {
  const viewedPaths = [];
  while (true) {
    if (!(await checkDomPromise(`\u002e\u0070\u0061\u0067\u0065\u002d\u0072\u0065\u0063\u006f\u006d\u006d\u0065\u006e\u0064\u002d\u0063\u006f\u006e\u0074\u0061\u0069\u006e\u0065\u0072`))) {
      console.error(`\u6ca1\u6709\u627e\u5230`, `\u002e\u0070\u0061\u0067\u0065\u002d\u0072\u0065\u0063\u006f\u006d\u006d\u0065\u006e\u0064\u002d\u0063\u006f\u006e\u0074\u0061\u0069\u006e\u0065\u0072`);
      await delay(1e3);
      continue;
    }
    const feedVideo = document.querySelector(`\u0064\u0069\u0076\u005b\u0064\u0061\u0074\u0061\u002d\u0065\u0032\u0065\u003d\u0022\u0066\u0065\u0065\u0064\u002d\u0061\u0063\u0074\u0069\u0076\u0065\u002d\u0076\u0069\u0064\u0065\u006f\u0022\u005d`);
    if (!feedVideo) {
      await goToNext();
      continue;
    }
    const note_id = feedVideo.getAttribute(`\u0064\u0061\u0074\u0061\u002d\u0065\u0032\u0065\u002d\u0076\u0069\u0064`);
    sendLog(`\u0064\u0061\u0074\u0061\u002d\u0065\u0032\u0065\u002d\u0076\u0069\u0064\uff1a` + note_id);
    if (viewedPaths.includes(note_id)) {
      sendLog(`\u5df2\u5b58\u5728\u0020\u0064\u0061\u0074\u0061\u002d\u0065\u0032\u0065\u002d\u0076\u0069\u0064\uff1a` + note_id);
      continue;
    }
    store$1.increment_dy_viewCount();
    const guangGao_el = feedVideo.querySelector(`\u002e\u0061\u0063\u0063\u006f\u0075\u006e\u0074\u0020\u0073\u0076\u0067`);
    if (guangGao_el) {
      sendLog(`\u5e7f\u544a\uff0c\u8df3\u8fc7`);
      await goToNext();
      continue;
    }
    const vipZhiBo_el = feedVideo.querySelector(`\u002e\u0070\u0063\u0056\u0047\u0052\u0062\u0039\u0054`);
    if (vipZhiBo_el) {
      sendLog(`\u4f1a\u5458\u76f4\u64ad\uff0c\u8df3\u8fc7`);
      await goToNext();
      continue;
    }
    await douYintuijian_start(feedVideo);
    await goToNext();
    viewedPaths.push(note_id);
  }
}
const douYintuijian_start = async element => {
  if (store$1.isNotRunWork()) {
    return;
  }
  const stringList = [];
  if (XiaoHongShu_Setting$1.reviewProbability == `\u9ed8\u8ba4\u0041\u0049\u63a7\u5236`) {
    if (isWithinProbability(isWithinProbabilitysend_comments)) {
      stringList.push(`\u0064\u006f\u0075\u0059\u0069\u006e\u005f\u0073\u0065\u006e\u0064\u005f\u0063\u006f\u006d\u006d\u0065\u006e\u0074\u0073`);
    } else {
      console.log(`\u8df3\u8fc7\u0020\u4e0d\u8bc4\u8bba`);
    }
  } else if (XiaoHongShu_Setting$1.reviewProbability == `\u81ea\u5b9a\u4e49\u6982\u7387` && XiaoHongShu_Setting$1.customProbabilitiesNum && isWithinProbability(XiaoHongShu_Setting$1.customProbabilitiesNum)) {
    stringList.push(`\u0064\u006f\u0075\u0059\u0069\u006e\u005f\u0073\u0065\u006e\u0064\u005f\u0063\u006f\u006d\u006d\u0065\u006e\u0074\u0073`);
  }
  if (XiaoHongShu_Setting$1 == null ? void 0 : XiaoHongShu_Setting$1.like) {
    if (isWithinProbability(isWithinProbabilityclickCommentLike)) {
      stringList.push(`\u0064\u006f\u0075\u0059\u0069\u006e\u005f\u0063\u006c\u0069\u0063\u006b\u0043\u006f\u006d\u006d\u0065\u006e\u0074\u004c\u0069\u006b\u0065`);
    } else {
      console.log(`\u8df3\u8fc7\u0020\u4e0d\u70b9\u8d5e`);
    }
  }
  if (XiaoHongShu_Setting$1 == null ? void 0 : XiaoHongShu_Setting$1.follow) {
    if (isWithinProbability(isWithinProbabilityfollow_click)) {
      stringList.push(`\u0064\u006f\u0075\u0059\u0069\u006e\u005f\u0066\u006f\u006c\u006c\u006f\u0077\u005f\u0063\u006c\u0069\u0063\u006b`);
    } else {
      console.log(`\u8df3\u8fc7\u0020\u4e0d\u5173\u6ce8`);
    }
  }
  if (XiaoHongShu_Setting$1 == null ? void 0 : XiaoHongShu_Setting$1.collect) {
    if (isWithinProbability(isWithinProbabilitycollect_click)) {
      stringList.push(`\u0064\u006f\u0075\u0059\u0069\u006e\u005f\u0063\u006f\u006c\u006c\u0065\u0063\u0074\u005f\u0063\u006c\u0069\u0063\u006b`);
    } else {
      console.log(`\u8df3\u8fc7\u0020\u4e0d\u6536\u85cf`);
    }
  }
  await douYin_randomExecFunction(stringList, element, `\u4fe1\u606f\u6d41`);
};
const douYin_tuijian_comment = async feedVideo => {
  var _a;
  const img_container_el = feedVideo.querySelector(`\u002e\u0069\u006d\u0067\u0042\u0061\u0063\u006b\u0067\u0072\u006f\u0075\u006e\u0064\u0020\u0069\u006d\u0067`);
  let img_container_url = ``;
  if (img_container_el) {
    img_container_url = img_container_el.src;
  }
  console.log(`\u0069\u006d\u0067\u005f\u0063\u006f\u006e\u0074\u0061\u0069\u006e\u0065\u0072\u005f\u0065\u006c\u003a`, img_container_el);
  console.log(`\u0069\u006d\u0067\u005f\u0063\u006f\u006e\u0074\u0061\u0069\u006e\u0065\u0072\u005f\u0075\u0072\u006c\u003a` + img_container_url);
  const detail_title_el = feedVideo.querySelector(`\u0064\u0069\u0076\u005b\u0064\u0061\u0074\u0061\u002d\u0065\u0032\u0065\u003d\u0022\u0076\u0069\u0064\u0065\u006f\u002d\u0064\u0065\u0073\u0063\u0022\u005d\u0020\u003e\u0064\u0069\u0076\u003e\u0064\u0069\u0076\u003e\u0073\u0070\u0061\u006e`);
  let detail_title = ``;
  if (detail_title_el) {
    detail_title = ((_a = detail_title_el.textContent) == null ? void 0 : _a.trim()) || ``;
  }
  console.log(`\u0064\u0065\u0074\u0061\u0069\u006c\u005f\u0074\u0069\u0074\u006c\u0065\u005f\u0065\u006c\u003a`, detail_title_el);
  console.log(`\u0064\u0065\u0074\u0061\u0069\u006c\u005f\u0074\u0069\u0074\u006c\u0065\u003a`, detail_title);
  const detail_content = ``;
  const detail_tag_str = ``;
  const note_id = feedVideo.getAttribute(`\u0064\u0061\u0074\u0061\u002d\u0065\u0032\u0065\u002d\u0076\u0069\u0064`);
  const comment_input_el = feedVideo.querySelector(`\u0023\u006d\u0065\u0072\u0067\u0065\u002d\u0061\u006c\u006c\u002d\u0063\u006f\u006d\u006d\u0065\u006e\u0074\u002d\u0063\u006f\u006e\u0074\u0061\u0069\u006e\u0065\u0072\u0020\u002e\u0063\u006f\u006d\u006d\u0065\u006e\u0074\u002d\u0069\u006e\u0070\u0075\u0074\u002d\u0069\u006e\u006e\u0065\u0072\u002d\u0063\u006f\u006e\u0074\u0061\u0069\u006e\u0065\u0072\u0020\u003e\u0064\u0069\u0076\u003a\u006e\u0074\u0068\u002d\u0063\u0068\u0069\u006c\u0064\u0028\u0031\u0029`);
  if (!comment_input_el) {
    await click_comment_button(feedVideo);
  }
  const textContent_str = await get_douYin_send_child_comment();
  console.log(`\u0074\u0065\u0078\u0074\u0043\u006f\u006e\u0074\u0065\u006e\u0074\u005f\u0073\u0074\u0072`, textContent_str);
  const user_infos = feedVideo.querySelectorAll(`\u0061\u005b\u0064\u0061\u0074\u0061\u002d\u0065\u0032\u0065\u003d\u0022\u0076\u0069\u0064\u0065\u006f\u002d\u0061\u0076\u0061\u0074\u0061\u0072\u0022\u005d`);
  let comment_user_url = ``;
  let comment_user_id = ``;
  if (user_infos && user_infos.length > 0) {
    const user_info = user_infos[0];
    comment_user_url = user_info.href;
    if (comment_user_url) {
      if (comment_user_url.startsWith(`\u002f\u002f`)) {
        comment_user_url = `\u0068\u0074\u0074\u0070\u0073\u003a` + comment_user_url;
      }
      const pathname = new URL(comment_user_url).pathname;
      comment_user_id = getLastPathName$1(pathname);
    }
  }
  sendLog(`\u0050\u0061\u0074\u0068\u003a\u0020` + store$1.userId + `\u0020\u0020` + note_id);
  const refer_id = `\u0061\u0075\u0074\u006f\u005f\u0063\u006f\u006d\u006d\u0065\u006e\u0074\u005f\u0064\u006f\u0075\u005f\u0079\u0069\u006e\u005f\u0075\u0073\u0065\u0072\u005f` + store$1.userId + `\u005f\u0070\u0061\u0074\u0068\u005f` + note_id;
  if (await queryComment$1(refer_id)) {
    let result = null;
    sendLog(`\u6ca1\u6709\u914d\u7f6e\u0020\u0073\u0074\u0079\u006c\u0065\u0020` + (XiaoHongShu_Setting$1 == null ? void 0 : XiaoHongShu_Setting$1.style) + `\u0020` + (XiaoHongShu_Setting$1 == null ? void 0 : XiaoHongShu_Setting$1.charLimit) + `\u0020` + (XiaoHongShu_Setting$1 == null ? void 0 : XiaoHongShu_Setting$1.keywordInfo));
    const inputs = {
      test: detail_title,
      commentaries: textContent_str,
      style: XiaoHongShu_Setting$1 == null ? void 0 : XiaoHongShu_Setting$1.style,
      word_limit: XiaoHongShu_Setting$1 == null ? void 0 : XiaoHongShu_Setting$1.charLimit,
      key_message: XiaoHongShu_Setting$1 == null ? void 0 : XiaoHongShu_Setting$1.keywordInfo
    };
    const files = [];
    if (img_container_url) {
      files.push({
        type: `\u0069\u006d\u0061\u0067\u0065`,
        transfer_method: `\u0072\u0065\u006d\u006f\u0074\u0065\u005f\u0075\u0072\u006c`,
        url: img_container_url
      });
    }
    if (XiaoHongShu_Setting$1.commentBlocking == `\u8bc4\u8bba\u622a\u6d41` && XiaoHongShu_Setting$1.commentBlockingNum > 0) {
      const callbackFun = async () => {
        const apiKey2 = `\u0061\u0070\u0070\u002d\u0049\u0069\u0037\u0056\u0045\u0062\u0062\u0031\u0065\u0052\u0078\u0038\u0034\u0052\u0068\u0068\u0074\u004c\u004c\u004c\u0052\u0041\u0044\u0039`;
        result = await runWorkflow$1(inputs, files, apiKey2);
        return result;
      };
      await douYin_send_child_comment(callbackFun, feedVideo, `\u002e\u0063\u006f\u006d\u006d\u0065\u006e\u0074\u0049\u006e\u0070\u0075\u0074\u002d\u0072\u0069\u0067\u0068\u0074\u002d\u0063\u0074\u0020\u0070\u0061\u0074\u0068\u005b\u0066\u0069\u006c\u006c\u003d\u0022\u0023\u0046\u0045\u0032\u0043\u0035\u0035\u0022\u005d`);
    }
    const apiKey = `\u0061\u0070\u0070\u002d\u0049\u0069\u0037\u0056\u0045\u0062\u0062\u0031\u0065\u0052\u0078\u0038\u0034\u0052\u0068\u0068\u0074\u004c\u004c\u004c\u0052\u0041\u0044\u0039`;
    result = await runWorkflow$1(inputs, files, apiKey);
    sendLog(`\u0072\u0065\u0073\u0075\u006c\u0074\u003a\u0020` + result);
    if (result) {
      const saveInputsData = {
        refer_id,
        // 数据唯一标识，格式为：auto_comment_dou_yin_user_{userId}_path_{note_id}
        title: detail_title,
        // 视频标题/描述文本
        text: detail_content,
        // 视频正文内容
        label: detail_tag_str,
        // 视频标签，包含话题标签
        style: XiaoHongShu_Setting$1 == null ? void 0 : XiaoHongShu_Setting$1.style,
        // 评论风格设置，如：幽默、正式等
        word_limit: XiaoHongShu_Setting$1 == null ? void 0 : XiaoHongShu_Setting$1.charLimit,
        // 评论字数限制
        key_message: XiaoHongShu_Setting$1 == null ? void 0 : XiaoHongShu_Setting$1.keywordInfo,
        // 评论关键信息/关键词设置
        note_url: `\u0068\u0074\u0074\u0070\u0073\u003a\u002f\u002f\u0077\u0077\u0077\u002e\u0064\u006f\u0075\u0079\u0069\u006e\u002e\u0063\u006f\u006d\u002f\u0076\u0069\u0064\u0065\u006f\u002f${note_id}`,
        // 视频链接地址，由视频ID拼接而成
        note_id,
        // 视频唯一ID，来自data-e2e-vid属性
        comment_user_url,
        // 视频作者主页链接
        comment_user_id,
        // 视频作者ID
        extra_image_id: ``,
        // 额外图片ID（当前为空）
        extra_image_url: img_container_url,
        // 视频封面图片URL
        replyComment: result,
        // AI生成的评论内容
        userId: store$1.userId,
        // 当前操作用户的ID
        taskId: store$1.taskId,
        // 当前任务ID
        addTime: (/* @__PURE__ */new Date()).getTime()
        // 数据添加时间戳，13位毫秒级
      };
      const saveInputs = {
        "key": refer_id,
        "bucket": saveInputsData,
        "size": 0,
        "content_type": `\u0073\u0074\u0072\u0069\u006e\u0067`,
        "belong_to": store$1.userId + `\u005f\u0064\u006f\u0075\u0059\u0069\u006e\u005f\u0063\u006f\u006d\u006d\u0065\u006e\u0074`,
        "object_metadata": {}
      };
      await douYin_send_comments(result, saveInputs, feedVideo, `\u002e\u0063\u006f\u006d\u006d\u0065\u006e\u0074\u0049\u006e\u0070\u0075\u0074\u002d\u0072\u0069\u0067\u0068\u0074\u002d\u0063\u0074\u0020\u0070\u0061\u0074\u0068\u005b\u0066\u0069\u006c\u006c\u003d\u0022\u0023\u0046\u0045\u0032\u0043\u0035\u0035\u0022\u005d`);
    }
  } else {
    console.log(`\u5df2\u8bc4\u8bba\u8fc7\u3002\u8df3\u8fc7`);
  }
};
const goToNext = async () => {
  const next_el = document.querySelector(`\u002e\u0078\u0067\u0070\u006c\u0061\u0079\u0065\u0072\u002d\u0069\u0063\u006f\u006e\u0020\u002e\u0078\u0067\u0070\u006c\u0061\u0079\u0065\u0072\u002d\u0070\u006c\u0061\u0079\u0073\u0077\u0069\u0074\u0063\u0068\u002d\u006e\u0065\u0078\u0074`);
  if (!next_el) {
    console.error(`\u6ca1\u6709\u627e\u5230\u8f93\u5165\u8bc4\u8bba\u7684\u8f93\u5165\u6846`);
    return;
  }
  await click_button(next_el);
  await delay(getRandomNumberInRange(1e3, 5e3));
};
const tuijian_flow = async element => {
  const flow_el = element.querySelector(`\u0064\u0069\u0076\u005b\u0064\u0061\u0074\u0061\u002d\u0065\u0032\u0065\u003d\u0022\u0066\u0065\u0065\u0064\u002d\u0066\u006f\u006c\u006c\u006f\u0077\u002d\u0069\u0063\u006f\u006e\u0022\u005d\u0020\u002e\u0073\u0065\u006d\u0069\u002d\u0069\u0063\u006f\u006e\u0020\u0073\u0076\u0067`);
  if (!flow_el) {
    console.log(`\u6ca1\u6709\u627e\u5230\u5173\u6ce8\u6309\u94ae`);
    return;
  }
  await click_button(flow_el);
  store$1.increment_dy_followCount();
};
async function douYin_send_child_comment(callbackFun, element, sendButtonQuerySelector) {
  var _a, _b, _c;
  const chatWrapper = element.querySelectorAll(`\u0064\u0069\u0076\u005b\u0064\u0061\u0074\u0061\u002d\u0065\u0032\u0065\u003d\u0022\u0066\u0065\u0065\u0064\u002d\u0063\u006f\u006d\u006d\u0065\u006e\u0074\u002d\u0069\u0063\u006f\u006e\u0022\u005d\u0020\u003e\u0064\u0069\u0076\u003a\u006e\u0074\u0068\u002d\u0063\u0068\u0069\u006c\u0064\u0028\u0032\u0029`);
  const chatWrapperCountStr = (_a = chatWrapper[0].textContent) == null ? void 0 : _a.trim();
  sendLog(`\u0064\u006f\u0075\u0059\u0069\u006e\u005f\u0073\u0065\u006e\u0064\u005f\u0063\u0068\u0069\u006c\u0064\u005f\u0063\u006f\u006d\u006d\u0065\u006e\u0074\u0020\u8bc4\u8bba\u6570\u91cf\u003a` + chatWrapperCountStr + `\u002c\u0020\u0058\u0069\u0061\u006f\u0048\u006f\u006e\u0067\u0053\u0068\u0075\u005f\u0053\u0065\u0074\u0074\u0069\u006e\u0067\u002e\u0063\u006f\u006d\u006d\u0065\u006e\u0074\u0042\u006c\u006f\u0063\u006b\u0069\u006e\u0067\u004e\u0075\u006d\u003a` + XiaoHongShu_Setting$1.commentBlockingNum);
  if (chatWrapperCountStr) {
    let chatWrapperCount = parseInt(chatWrapperCountStr);
    if (XiaoHongShu_Setting$1.commentBlockingNum < chatWrapperCount) {
      console.log(`\u0063\u0068\u0061\u0074\u0057\u0072\u0061\u0070\u0070\u0065\u0072\u0043\u006f\u0075\u006e\u0074`, chatWrapperCount);
      const parentComments = document.querySelectorAll(`\u002e\u0063\u006f\u006d\u006d\u0065\u006e\u0074\u002d\u006d\u0061\u0069\u006e\u0043\u006f\u006e\u0074\u0065\u006e\u0074\u0020\u0064\u0069\u0076\u005b\u0064\u0061\u0074\u0061\u002d\u0065\u0032\u0065\u003d\u0022\u0063\u006f\u006d\u006d\u0065\u006e\u0074\u002d\u0069\u0074\u0065\u006d\u0022\u005d\u0020\u003e\u0064\u0069\u0076\u003a\u006e\u0074\u0068\u002d\u0063\u0068\u0069\u006c\u0064\u0028\u0032\u0029\u0020\u003e\u0064\u0069\u0076`);
      let comment_num = 0;
      for (let i = 0; i < 10; i++) {
        if (!parentComments[i]) {
          continue;
        }
        const selfEl = parentComments[i].querySelector(`\u002e\u0073\u0065\u006d\u0069\u002d\u0074\u0061\u0067\u002d\u0063\u006f\u006e\u0074\u0065\u006e\u0074\u002d\u0063\u0065\u006e\u0074\u0065\u0072`);
        if (selfEl) {
          sendLog(`\u5b50\u8bc4\u8bba\u662f\u4f5c\u8005`);
          const selfEl_text = (_b = selfEl.textContent) == null ? void 0 : _b.trim();
          if (selfEl_text == `\u4f5c\u8005`) {
            continue;
          }
          continue;
        }
        const reply = parentComments[i].querySelector(`\u002e\u0063\u006f\u006d\u006d\u0065\u006e\u0074\u002d\u0069\u0074\u0065\u006d\u002d\u0073\u0074\u0061\u0074\u0073\u002d\u0063\u006f\u006e\u0074\u0061\u0069\u006e\u0065\u0072\u0020\u003e\u0064\u0069\u0076\u003a\u006e\u0074\u0068\u002d\u0063\u0068\u0069\u006c\u0064\u0028\u0033\u0029\u0020\u003e\u0064\u0069\u0076`);
        if (!reply) {
          sendLog(`\u6ca1\u6709\u627e\u5230\u4e86\u5b50\u8bc4\u8bba\u7684\u56de\u590d\u6309\u94ae`);
          continue;
        }
        sendLog(`\u627e\u5230\u4e86\u5b50\u8bc4\u8bba\u7684\u56de\u590d\u6309\u94ae`);
        ensureElementVisible(reply);
        await click_button(reply);
        let replyButtonBool = false;
        for (let j = 0; j < 60; j++) {
          const reply_text = (_c = reply.textContent) == null ? void 0 : _c.trim();
          if (reply_text == `\u56de\u590d\u4e2d`) {
            replyButtonBool = true;
            break;
          }
          const reply_ = document.querySelector(`\u002e\u0063\u006f\u006d\u006d\u0065\u006e\u0074\u002d\u0069\u006e\u0070\u0075\u0074\u002d\u0063\u006f\u006e\u0074\u0061\u0069\u006e\u0065\u0072\u0020\u002e\u0075\u0066\u0065\u006d\u004f\u0046\u0042\u0066`);
          if (reply_) {
            replyButtonBool = true;
            break;
          }
          sendLog(`\u67e5\u627e\u70b9\u51fb\u6309\u94ae\u7684\u7ed3\u679c`);
          await delay(1e3);
        }
        if (!replyButtonBool) {
          sendLog(`\u6ca1\u6709\u627e\u5230\u56de\u590d\u7684\u6570\u636e\u0020\u0072\u0065\u0070\u006c\u0079\u0042\u0075\u0074\u0074\u006f\u006e\u0042\u006f\u006f\u006c\uff1a` + replyButtonBool);
          return;
        }
        let content_str = await callbackFun();
        if (!content_str) {
          continue;
        }
        await douYin_send_comments2(content_str, element, sendButtonQuerySelector);
        comment_num++;
        if (comment_num == 3) {
          break;
        }
      }
    }
  }
}
async function douYin_send_comments2(content, element, sendButtonQuerySelector = `\u002e\u0063\u006f\u006d\u006d\u0065\u006e\u0074\u0049\u006e\u0070\u0075\u0074\u002d\u0072\u0069\u0067\u0068\u0074\u002d\u0063\u0074\u0020\u0070\u0061\u0074\u0068\u005b\u0066\u0069\u006c\u006c\u003d\u0022\u0023\u0046\u0045\u0032\u0043\u0035\u0035\u0022\u005d`) {
  var _a;
  console.log(`\u0064\u006f\u0075\u0059\u0069\u006e\u005f\u0073\u0065\u006e\u0064\u005f\u0063\u006f\u006d\u006d\u0065\u006e\u0074\u0073`);
  await delay(getRandomNumberInRange(1e3, 5e3));
  if (!(await checkDomPromise(`\u002e\u006e\u006f\u0074\u0072\u0061\u006e\u0073\u006c\u0061\u0074\u0065\u002e\u0070\u0075\u0062\u006c\u0069\u0063\u002d\u0044\u0072\u0061\u0066\u0074\u0045\u0064\u0069\u0074\u006f\u0072\u002d\u0063\u006f\u006e\u0074\u0065\u006e\u0074`))) {
    sendLog(`\u6ca1\u6709\u627e\u5230\u0020\u0023\u0063\u006f\u006e\u0074\u0065\u006e\u0074\u002d\u0074\u0065\u0078\u0074\u0061\u0072\u0065\u0061`);
    return;
  }
  const targetElement = document.querySelector(`\u002e\u006e\u006f\u0074\u0072\u0061\u006e\u0073\u006c\u0061\u0074\u0065\u002e\u0070\u0075\u0062\u006c\u0069\u0063\u002d\u0044\u0072\u0061\u0066\u0074\u0045\u0064\u0069\u0074\u006f\u0072\u002d\u0063\u006f\u006e\u0074\u0065\u006e\u0074`);
  if (!targetElement) {
    console.error(`\u6ca1\u6709\u627e\u5230\u8f93\u5165\u6846`);
    return;
  }
  console.log(`\u589e\u52a0\u8bc4\u8bba\u540e\u7f00\u4fe1\u606f`, XiaoHongShu_Setting$1 == null ? void 0 : XiaoHongShu_Setting$1.commentSuffix);
  if (XiaoHongShu_Setting$1 == null ? void 0 : XiaoHongShu_Setting$1.commentSuffix) {
    console.log(`\u589e\u52a0\u8bc4\u8bba\u540e\u7f00\u4fe1\u606f`, XiaoHongShu_Setting$1 == null ? void 0 : XiaoHongShu_Setting$1.commentSuffix);
    content += `\u000d\u000a` + (XiaoHongShu_Setting$1 == null ? void 0 : XiaoHongShu_Setting$1.commentSuffix);
  }
  if (targetElement) {
    sendLog(`\u6267\u884c\u0020\u0074\u0061\u0072\u0067\u0065\u0074\u0045\u006c\u0065\u006d\u0065\u006e\u0074\uff1a` + store$1.chromeTabId);
    chrome.runtime.onMessage.addListener((request2, sender2, sendResponse2) => queryActiveElement(request2, sender2, sendResponse2, `\u002e\u006e\u006f\u0074\u0072\u0061\u006e\u0073\u006c\u0061\u0074\u0065\u002e\u0070\u0075\u0062\u006c\u0069\u0063\u002d\u0044\u0072\u0061\u0066\u0074\u0045\u0064\u0069\u0074\u006f\u0072\u002d\u0063\u006f\u006e\u0074\u0065\u006e\u0074`));
    await simulateInputSendMessage(content, 200, true);
    chrome.runtime.onMessage.removeListener((request2, sender2, sendResponse2) => queryActiveElement(request2, sender2, sendResponse2, `\u002e\u006e\u006f\u0074\u0072\u0061\u006e\u0073\u006c\u0061\u0074\u0065\u002e\u0070\u0075\u0062\u006c\u0069\u0063\u002d\u0044\u0072\u0061\u0066\u0074\u0045\u0064\u0069\u0074\u006f\u0072\u002d\u0063\u006f\u006e\u0074\u0065\u006e\u0074`));
  } else {
    sendLog(`\u0054\u0061\u0072\u0067\u0065\u0074\u0020\u0065\u006c\u0065\u006d\u0065\u006e\u0074\u0020\u006e\u006f\u0074\u0020\u0066\u006f\u0075\u006e\u0064\u002e`);
  }
  if (store$1.isNotRunWork()) {
    return;
  }
  if (!(await checkDomPromise(sendButtonQuerySelector))) {
    sendLog(`\u6ca1\u6709\u627e\u5230\u0020\u0023\u0063\u006f\u006e\u0074\u0065\u006e\u0074\u002d\u0074\u0065\u0078\u0074\u0061\u0072\u0065\u0061`);
    return;
  }
  const submit = element.querySelector(sendButtonQuerySelector);
  if (!submit) {
    console.error(`\u70b9\u51fb\u53d1\u8868\u8bc4\u8bba\u5931\u8d25`);
    return;
  }
  await click_button(submit);
  let indexNum = 0;
  while (true) {
    if (indexNum > 60) {
      break;
    }
    if (indexNum > 1) {
      console.log(`\u0069\u006e\u0064\u0065\u0078\u004e\u0075\u006d`, indexNum++);
      await delay(1e3);
    }
    indexNum++;
    const response_text_el = element.querySelector(`\u002e\u0070\u0075\u0062\u006c\u0069\u0063\u002d\u0044\u0072\u0061\u0066\u0074\u0045\u0064\u0069\u0074\u006f\u0072\u002d\u0063\u006f\u006e\u0074\u0065\u006e\u0074\u0020\u003e\u0020\u0064\u0069\u0076\u0020\u003e\u0020\u0064\u0069\u0076\u0020\u003e\u0020\u0064\u0069\u0076\u0020\u003e\u0020\u0073\u0070\u0061\u006e\u003a\u006e\u0074\u0068\u002d\u0063\u0068\u0069\u006c\u0064\u0028\u0031\u0029`);
    if (!response_text_el) {
      console.log(`\u6ca1\u6709\u627e\u5230\u8f93\u5165\u6846`);
      continue;
    }
    let response_text = ((_a = response_text_el.textContent) == null ? void 0 : _a.trim()) || ``;
    if (response_text) {
      console.log(`\u8f93\u5165\u6846\u4e0d\u4e3a\u7a7a`);
      continue;
    }
    break;
  }
  store$1.increment_dy_CommentCount();
  console.log(`\u8bc4\u8bba\u6210\u529f`);
  await delay(getRandomNumberInRange(1e3, 5e3));
}
function savePlatformData(elements) {
  var _a, _b, _c, _d, _e, _f, _g, _h, _i, _j, _k, _l, _m;
  for (const element of elements) {
    const element_div_el_video = element.querySelector(`\u0023\u0073\u006c\u0069\u0064\u0065\u0072\u0056\u0069\u0064\u0065\u006f`);
    if (!element_div_el_video) {
      continue;
    }
    const element_div_el = element.querySelector(`\u0023\u0073\u006c\u0069\u0064\u0065\u0072\u0056\u0069\u0064\u0065\u006f`);
    const note_id = (element_div_el == null ? void 0 : element_div_el.getAttribute(`\u0064\u0061\u0074\u0061\u002d\u0065\u0032\u0065\u002d\u0076\u0069\u0064`)) || ``;
    if (!note_id || isNoteProcessed(note_id)) {
      sendLog(`\u8df3\u8fc7\u91cd\u590d\u89c6\u9891\u003a\u0020${note_id}`);
      continue;
    }
    markNoteAsProcessed(note_id);
    let detail_title_el = element.querySelector(`\u002e\u0073\u0065\u0061\u0072\u0063\u0068\u002d\u0072\u0065\u0073\u0075\u006c\u0074\u002d\u0063\u0061\u0072\u0064\u0020\u003e\u0064\u0069\u0076\u003e\u0064\u0069\u0076\u003a\u006e\u0074\u0068\u002d\u0063\u0068\u0069\u006c\u0064\u0028\u0032\u0029\u0020\u003e\u0020\u0064\u0069\u0076\u0020\u003e\u0073\u0070\u0061\u006e\u0020\u003e\u0073\u0070\u0061\u006e`);
    let detail_title = ``;
    if (detail_title_el) {
      detail_title = ((_a = detail_title_el.textContent) == null ? void 0 : _a.trim()) || ``;
    } else {
      detail_title_el = element.querySelector(`\u002e\u0073\u0065\u0061\u0072\u0063\u0068\u002d\u0072\u0065\u0073\u0075\u006c\u0074\u002d\u0063\u0061\u0072\u0064\u0020\u003e\u0064\u0069\u0076\u003e\u0064\u0069\u0076\u003e\u0064\u0069\u0076\u003e\u0070`);
    }
    if (detail_title_el) {
      detail_title = ((_b = detail_title_el.textContent) == null ? void 0 : _b.trim()) || ``;
    }
    const img_container_el = element.querySelector(`\u002e\u0069\u006d\u0067\u0042\u0061\u0063\u006b\u0067\u0072\u006f\u0075\u006e\u0064\u0020\u0069\u006d\u0067`);
    const img_container_url = (img_container_el == null ? void 0 : img_container_el.src) || ``;
    const like_count_el = (_c = element.querySelector(`\u005b\u0064\u0061\u0074\u0061\u002d\u0065\u0032\u0065\u003d\u0022\u0076\u0069\u0064\u0065\u006f\u002d\u0070\u006c\u0061\u0079\u0065\u0072\u002d\u0064\u0069\u0067\u0067\u0022\u005d`)) == null ? void 0 : _c.lastElementChild;
    const like_count = ((_d = like_count_el == null ? void 0 : like_count_el.textContent) == null ? void 0 : _d.trim()) || `\u0030`;
    const comment_count_el = (_e = element.querySelector(`\u005b\u0064\u0061\u0074\u0061\u002d\u0065\u0032\u0065\u003d\u0022\u0076\u0069\u0064\u0065\u006f\u002d\u0070\u006c\u0061\u0079\u0065\u0072\u002d\u0063\u006f\u006d\u006d\u0065\u006e\u0074\u0022\u005d`)) == null ? void 0 : _e.lastElementChild;
    let comment_count = ((_f = comment_count_el == null ? void 0 : comment_count_el.textContent) == null ? void 0 : _f.trim()) || null;
    if (comment_count === null) {
      const alt_comment_el = element.querySelector(`\u005b\u0064\u0061\u0074\u0061\u002d\u0065\u0032\u0065\u003d\u0022\u0066\u0065\u0065\u0064\u002d\u0063\u006f\u006d\u006d\u0065\u006e\u0074\u002d\u0069\u0063\u006f\u006e\u0022\u005d\u0020\u003e\u0020\u0064\u0069\u0076\u003a\u006e\u0074\u0068\u002d\u0063\u0068\u0069\u006c\u0064\u0028\u0032\u0029`);
      comment_count = ((_g = alt_comment_el == null ? void 0 : alt_comment_el.textContent) == null ? void 0 : _g.trim()) || `\u0030`;
    }
    const share_count_el = (_h = element.querySelector(`\u005b\u0064\u0061\u0074\u0061\u002d\u0065\u0032\u0065\u003d\u0022\u0076\u0069\u0064\u0065\u006f\u002d\u0070\u006c\u0061\u0079\u0065\u0072\u002d\u0073\u0068\u0061\u0072\u0065\u0022\u005d`)) == null ? void 0 : _h.lastElementChild;
    const shareCount = ((_i = share_count_el == null ? void 0 : share_count_el.textContent) == null ? void 0 : _i.trim()) || `\u0030`;
    const collect_count_el = (_j = element.querySelector(`\u005b\u0064\u0061\u0074\u0061\u002d\u0065\u0032\u0065\u003d\u0022\u0076\u0069\u0064\u0065\u006f\u002d\u0070\u006c\u0061\u0079\u0065\u0072\u002d\u0063\u006f\u006c\u006c\u0065\u0063\u0074\u0022\u005d`)) == null ? void 0 : _j.lastElementChild;
    const collectCount = ((_k = collect_count_el == null ? void 0 : collect_count_el.textContent) == null ? void 0 : _k.trim()) || `\u0030`;
    const length_el = element.querySelector(`\u0023\u0073\u006c\u0069\u0064\u0065\u0072\u0056\u0069\u0064\u0065\u006f\u0020\u002e\u0078\u0067\u0070\u006c\u0061\u0079\u0065\u0072\u002d\u0074\u0069\u006d\u0065\u0020\u002e\u0074\u0069\u006d\u0065\u002d\u0064\u0075\u0072\u0061\u0074\u0069\u006f\u006e`);
    const length = ((_l = length_el == null ? void 0 : length_el.textContent) == null ? void 0 : _l.trim()) || `\u0030\u0030\u003a\u0030\u0030`;
    const lengthInSeconds = convertTimeToSeconds(length);
    const user_info = element.querySelector(`\u002e\u0073\u0065\u0061\u0072\u0063\u0068\u002d\u0072\u0065\u0073\u0075\u006c\u0074\u002d\u0063\u0061\u0072\u0064\u0020\u003e\u0064\u0069\u0076\u0020\u003e\u0020\u0064\u0069\u0076\u0020\u003e\u0064\u0069\u0076\u0020\u003e\u0020\u0061`);
    const comment_user_url = (user_info == null ? void 0 : user_info.href) || ``;
    let comment_user_id = ``;
    if (comment_user_url) {
      const pathname = new URL(comment_user_url).pathname;
      comment_user_id = getLastPathName$1(pathname);
    }
    const nickname_el = element.querySelector(`\u0023\u0073\u0065\u0061\u0072\u0063\u0068\u002d\u0072\u0065\u0073\u0075\u006c\u0074\u002d\u0063\u006f\u006e\u0074\u0061\u0069\u006e\u0065\u0072\u0020\u0064\u0069\u0076\u002e\u0047\u0052\u0065\u0063\u0072\u0044\u0075\u006f\u0020\u0064\u0069\u0076\u002e\u0052\u0038\u0042\u0044\u0043\u0071\u0061\u0076\u0020\u0061`);
    const nickname = ((_m = nickname_el == null ? void 0 : nickname_el.textContent) == null ? void 0 : _m.trim()) || ``;
    const platform_data = {
      platform: `\u0044\u006f\u0075\u0079\u0069\u006e`,
      url: `\u0068\u0074\u0074\u0070\u0073\u003a\u002f\u002f\u0077\u0077\u0077\u002e\u0064\u006f\u0075\u0079\u0069\u006e\u002e\u0063\u006f\u006d\u002f\u0076\u0069\u0064\u0065\u006f\u002f${note_id}`,
      account_id: comment_user_id,
      content: {
        // 基础信息字段
        title: detail_title,
        description: detail_title,
        share_url: `\u0068\u0074\u0074\u0070\u0073\u003a\u002f\u002f\u0077\u0077\u0077\u002e\u0064\u006f\u0075\u0079\u0069\u006e\u002e\u0063\u006f\u006d\u002f\u0076\u0069\u0064\u0065\u006f\u002f${note_id}`,
        thumbnail: img_container_url,
        // 统计数据字段
        view_count: 0,
        like_count: parseCount(like_count),
        comment_count: parseCount(comment_count),
        share_count: parseCount(shareCount),
        collect_count: parseCount(collectCount),
        // 添加收藏数
        length: lengthInSeconds,
        // 作者相关字段
        nickname,
        avatar: ``,
        bio: ``,
        author_url: comment_user_url,
        follower: 0,
        following: 0,
        video_count: 0,
        author_total_likes: 0,
        account_id: comment_user_id,
        // 时间相关字段
        published_time: (/* @__PURE__ */new Date()).toLocaleString(`\u0073\u0076`).replace(`\u0020`, `\u0054`)
        // 输出格式: "2024-03-21T16:30:15"
      }
    };
    if (!comment_user_id || !note_id) {
      sendLog(`\u7f3a\u5c11\u0020\u0061\u0063\u0063\u006f\u0075\u006e\u0074\u005f\u0069\u0064\uff0c\u8df3\u8fc7\u63d0\u4ea4\u6570\u636e`);
    }
    if (comment_user_id && note_id) {
      setTimeout(() => {
        submitPlatformData(platform_data).then(() => {
          processedNoteIds.add(note_id);
        }).catch(error => {
          sendLog(`\u63d0\u4ea4\u5e73\u53f0\u6570\u636e\u5931\u8d25\u003a\u0020` + error);
        });
      }, 0);
    }
    console.log(`\u006c\u0069\u0073\u0074\u0020\u0068\u0065\u0072\u0065\u0020\u0070\u006c\u0061\u0074\u0066\u006f\u0072\u006d\u005f\u0064\u0061\u0074\u0061\u003a`, platform_data);
  }
}
function meetsCoreMetrics(metrics) {
  try {
    if (!metrics.like_count || !metrics.comment_count || !metrics.share_count || !metrics.collect_count) {
      sendLog(`\u6307\u6807\u6570\u636e\u4e0d\u5b8c\u6574\uff0c\u8df3\u8fc7\u68c0\u67e5`);
      return false;
    }
    if (metrics.share_count === 0) {
      sendLog(`\u5206\u6bcd\u4e3a\u0030\uff0c\u65e0\u6cd5\u8ba1\u7b97\u6536\u85cf\u002f\u8f6c\u53d1\u6bd4\u503c`);
      return false;
    }
    const meetsLikeThreshold = metrics.like_count >= 500;
    const meetsCommentThreshold = metrics.comment_count >= 50;
    const collectShareRatio = metrics.collect_count / metrics.share_count;
    const meetsRatioThreshold = collectShareRatio >= 0.8;
    if (!meetsLikeThreshold) sendLog(`\u70b9\u8d5e\u91cf\u672a\u8fbe\u6807${metrics.like_count}`);
    if (!meetsCommentThreshold) sendLog(`\u8bc4\u8bba\u91cf\u672a\u8fbe\u6807${metrics.comment_count}`);
    if (!meetsRatioThreshold) sendLog(`\u6536\u85cf\u002f\u8f6c\u53d1\u6bd4\u503c\u672a\u8fbe\u6807${collectShareRatio}`);
    return meetsLikeThreshold && meetsCommentThreshold && meetsRatioThreshold;
  } catch (error) {
    sendLog(`\u68c0\u67e5\u6838\u5fc3\u6307\u6807\u65f6\u53d1\u751f\u9519\u8bef\u003a\u0020` + error);
    return false;
  }
}
async function fetchAccountData(platform, author_url) {
  if (!platform || !author_url) {
    sendLog(`\u7f3a\u5c11\u5fc5\u8981\u53c2\u6570\uff0c\u0070\u006c\u0061\u0074\u0066\u006f\u0072\u006d\u6216\u0061\u0075\u0074\u0068\u006f\u0072\u005f\u0075\u0072\u006c\u4e3a\u7a7a`);
    throw new Error(`\u004d\u0069\u0073\u0073\u0069\u006e\u0067\u0020\u0072\u0065\u0071\u0075\u0069\u0072\u0065\u0064\u0020\u0070\u0061\u0072\u0061\u006d\u0065\u0074\u0065\u0072\u0073`);
  }
  try {
    const response = await fetch(`${ACCOUNT_DATA_BASE_URL}\u002f\u0061\u0063\u0063\u006f\u0075\u006e\u0074\u005f\u0064\u0061\u0074\u0061`, {
      method: `\u0050\u004f\u0053\u0054`,
      headers: {
        "Content-Type": `\u0061\u0070\u0070\u006c\u0069\u0063\u0061\u0074\u0069\u006f\u006e\u002f\u006a\u0073\u006f\u006e`,
        "Authorization": `\u0042\u0065\u0061\u0072\u0065\u0072\u0020${ACCOUNT_DATA_API_AUTH_TOKEN}`
      },
      body: JSON.stringify({
        platform,
        author_url
      })
    });
    if (!response.ok) {
      const errorText = await response.text();
      sendLog(`\u83b7\u53d6\u8d26\u53f7\u6570\u636e\u5931\u8d25\u003a\u0020\u0048\u0054\u0054\u0050\u0020${response.status}\u0020\u002d\u0020${errorText}`);
      throw new Error(`\u0048\u0054\u0054\u0050\u0020\u0065\u0072\u0072\u006f\u0072\u0021\u0020\u0073\u0074\u0061\u0074\u0075\u0073\u003a\u0020${response.status}`);
    }
    const accountData = await response.json();
    if (!accountData) {
      sendLog(`\u83b7\u53d6\u8d26\u53f7\u6570\u636e\u6210\u529f\u4f46\u6570\u636e\u4e3a\u7a7a`);
      throw new Error(`\u0045\u006d\u0070\u0074\u0079\u0020\u0072\u0065\u0073\u0070\u006f\u006e\u0073\u0065\u0020\u0064\u0061\u0074\u0061`);
    }
    sendLog(`\u83b7\u53d6\u8d26\u53f7\u6570\u636e\u6210\u529f\u003a\u0020` + JSON.stringify(accountData));
    return accountData;
  } catch (error) {
    sendLog(`\u83b7\u53d6\u8d26\u53f7\u6570\u636e\u5931\u8d25\u003a\u0020` + error);
    console.error(`\u83b7\u53d6\u8d26\u53f7\u6570\u636e\u5931\u8d25\u003a`, error);
    throw error;
  }
}
async function checkTaskCompletionStatus() {
  try {
    const eventSource = new EventSource(`${ACCOUNT_DATA_BASE_URL}\u002f\u0074\u0061\u0073\u006b\u005f\u0063\u006f\u006d\u0070\u006c\u0065\u0074\u0069\u006f\u006e\u005f\u0073\u0074\u0061\u0074\u0075\u0073`);
    const timeout = setTimeout(() => {
      eventSource.close();
      sendLog(`\u4efb\u52a1\u72b6\u6001\u68c0\u67e5\u8d85\u65f6`);
    }, 30 * 60 * 1e3);
    return new Promise((resolve, reject) => {
      eventSource.onmessage = event => {
        try {
          const data = JSON.parse(event.data);
          if (data.status === `\u0072\u0075\u006e\u006e\u0069\u006e\u0067`) {
            sendLog(`\u4efb\u52a1\u8fdb\u884c\u4e2d\uff0c\u5269\u4f59\u4efb\u52a1\u6570\u003a\u0020${data.pending_tasks}`);
          } else if (data.status === `\u0063\u006f\u006d\u0070\u006c\u0065\u0074\u0065\u0064`) {
            sendLog(`\u6240\u6709\u4efb\u52a1\u5df2\u5b8c\u6210`);
            clearTimeout(timeout);
            eventSource.close();
            resolve();
          }
        } catch (error) {
          sendLog(`\u89e3\u6790\u4efb\u52a1\u72b6\u6001\u6570\u636e\u5931\u8d25\u003a\u0020` + error);
        }
      };
      eventSource.onerror = error => {
        clearTimeout(timeout);
        eventSource.close();
        reject(new Error(`\u4efb\u52a1\u72b6\u6001\u68c0\u67e5\u5931\u8d25\u003a\u0020` + error));
      };
    });
  } catch (error) {
    sendLog(`\u68c0\u67e5\u4efb\u52a1\u5b8c\u6210\u72b6\u6001\u65f6\u53d1\u751f\u9519\u8bef\u003a\u0020` + error);
    throw error;
  }
}
async function submitPlatformData(platform_data) {
  var _a;
  try {
    if (!platform_data || !platform_data.content) {
      sendLog(`\u5e73\u53f0\u6570\u636e\u683c\u5f0f\u65e0\u6548`);
      throw new Error(`\u0049\u006e\u0076\u0061\u006c\u0069\u0064\u0020\u0070\u006c\u0061\u0074\u0066\u006f\u0072\u006d\u0020\u0064\u0061\u0074\u0061\u0020\u0066\u006f\u0072\u006d\u0061\u0074`);
    }
    const metrics = {
      like_count: platform_data.content.like_count || 0,
      comment_count: platform_data.content.comment_count || 0,
      share_count: platform_data.content.share_count || 0,
      collect_count: platform_data.content.collect_count || 0
    };
    if (meetsCoreMetrics(metrics)) {
      try {
        await fetchAccountData(platform_data.platform, ((_a = platform_data == null ? void 0 : platform_data.content) == null ? void 0 : _a.author_url) || ``);
        await checkTaskCompletionStatus().then(() => {
          sendLog(`\u4efb\u52a1\u72b6\u6001\u76d1\u63a7\u5b8c\u6210`);
        }).catch(error => {
          sendLog(`\u4efb\u52a1\u72b6\u6001\u76d1\u63a7\u5931\u8d25\u003a\u0020` + error);
        });
      } catch (error) {
        sendLog(`\u83b7\u53d6\u8d26\u53f7\u6570\u636e\u5931\u8d25\uff0c\u7ee7\u7eed\u63d0\u4ea4\u5e73\u53f0\u6570\u636e\u003a\u0020` + error);
      }
    } else {
      sendLog(`\u4e0d\u6ee1\u8db3\u6838\u5fc3\u6307\u6807\uff0c\u8df3\u8fc7\u63d0\u4ea4\u5e73\u53f0\u6570\u636e`);
      return;
    }
    const response = await fetch(`${ACCOUNT_DATA_BASE_URL}\u002f\u0073\u0075\u0062\u006d\u0069\u0074`, {
      method: `\u0050\u004f\u0053\u0054`,
      headers: {
        "Content-Type": `\u0061\u0070\u0070\u006c\u0069\u0063\u0061\u0074\u0069\u006f\u006e\u002f\u006a\u0073\u006f\u006e`,
        "Authorization": `\u0042\u0065\u0061\u0072\u0065\u0072\u0020${ACCOUNT_DATA_API_AUTH_TOKEN}`
      },
      body: JSON.stringify(platform_data)
    });
    if (!response.ok) {
      const errorText = await response.text();
      sendLog(`\u63d0\u4ea4\u5e73\u53f0\u6570\u636e\u5931\u8d25\u003a\u0020\u0048\u0054\u0054\u0050\u0020${response.status}\u0020\u002d\u0020${errorText}`);
      throw new Error(`\u0048\u0054\u0054\u0050\u0020\u0065\u0072\u0072\u006f\u0072\u0021\u0020\u0073\u0074\u0061\u0074\u0075\u0073\u003a\u0020${response.status}`);
    }
    const result = await response.json();
    if (!result) {
      sendLog(`\u63d0\u4ea4\u5e73\u53f0\u6570\u636e\u6210\u529f\u4f46\u8fd4\u56de\u6570\u636e\u4e3a\u7a7a`);
      throw new Error(`\u0045\u006d\u0070\u0074\u0079\u0020\u0072\u0065\u0073\u0070\u006f\u006e\u0073\u0065\u0020\u0064\u0061\u0074\u0061`);
    }
    sendLog(`\u63d0\u4ea4\u5e73\u53f0\u6570\u636e\u6210\u529f\u003a\u0020` + JSON.stringify(result));
    return result;
  } catch (error) {
    sendLog(`\u63d0\u4ea4\u5e73\u53f0\u6570\u636e\u5931\u8d25\u003a\u0020` + error);
    console.error(`\u63d0\u4ea4\u5e73\u53f0\u6570\u636e\u5931\u8d25\u003a`, error);
    throw error;
  }
}
function parseCount(numStr) {
  if (!numStr) return 0;
  numStr = numStr.trim().toLowerCase();
  const cnUnitMap = {
    "千": 1e3,
    "k": 1e3,
    "万": 1e4,
    "w": 1e4,
    "亿": 1e8
  };
  for (const [unit, multiplier] of Object.entries(cnUnitMap)) {
    if (numStr.includes(unit)) {
      const numberPart = numStr.replace(unit, ``);
      return Math.floor(parseFloat(numberPart) * multiplier);
    }
  }
  return Math.floor(parseFloat(numStr) || 0);
}
const click_douYin_Notifications = async (paramTile, paramUrl, clickText) => {
  console.log(`\u0070\u0061\u0072\u0061\u006d\u0054\u0069\u006c\u0065`, paramTile, paramUrl, clickText);
  return new Promise(resolve => {
    chrome.runtime.sendMessage({
      action: `\u0063\u006c\u0069\u0063\u006b\u005f\u0064\u006f\u0075\u0059\u0069\u006e\u005f\u004e\u006f\u0074\u0069\u0066\u0069\u0063\u0061\u0074\u0069\u006f\u006e\u0073`,
      paramTile,
      paramUrl,
      clickText
    }, {
      includeTlsChannelId: false
    }, () => {
      console.info(`\u0063\u006c\u0069\u0063\u006b\u005f\u0064\u006f\u0075\u0059\u0069\u006e\u005f\u004e\u006f\u0074\u0069\u0066\u0069\u0063\u0061\u0074\u0069\u006f\u006e\u0073\u0020\u006f\u006b`);
      resolve({});
    });
  });
};
const douYin_Notifications = async () => {
  var _a, _b;
  const optionWhere = store$1.getOptionWhere();
  console.log(`\u0064\u006f\u0075\u0059\u0069\u006e\u005f\u004e\u006f\u0074\u0069\u0066\u0069\u0063\u0061\u0074\u0069\u006f\u006e\u0073`);
  if (!(await checkDomPromise(`\u0064\u0069\u0076\u005b\u0064\u0061\u0074\u0061\u002d\u0065\u0032\u0065\u003d\u0022\u0073\u006f\u006d\u0065\u0074\u0068\u0069\u006e\u0067\u002d\u0062\u0075\u0074\u0074\u006f\u006e\u0022\u005d`))) {
    console.error(`\u6ca1\u6709\u627e\u5230`, `\u0064\u0069\u0076\u005b\u0064\u0061\u0074\u0061\u002d\u0065\u0032\u0065\u003d\u0022\u0073\u006f\u006d\u0065\u0074\u0068\u0069\u006e\u0067\u002d\u0062\u0075\u0074\u0074\u006f\u006e\u0022\u005d`);
    return;
  }
  while (true) {
    let findBool = false;
    await delay(500);
    let navigationEl = null;
    let somethingButtonList = null;
    for (let k = 0; k <= 2; k++) {
      sendLog(`\u0064\u006f\u0075\u0059\u0069\u006e\u005f\u004e\u006f\u0074\u0069\u0066\u0069\u0063\u0061\u0074\u0069\u006f\u006e\u0073\u0020\u0069\u003a` + k);
      somethingButtonList = Array.from(document.querySelectorAll(`\u0064\u0069\u0076\u005b\u0064\u0061\u0074\u0061\u002d\u0065\u0032\u0065\u003d\u0022\u0073\u006f\u006d\u0065\u0074\u0068\u0069\u006e\u0067\u002d\u0062\u0075\u0074\u0074\u006f\u006e\u0022\u005d`));
      navigationEl = document.querySelector(`\u0064\u0069\u0076\u005b\u0069\u0064\u003d\u0022\u0064\u006f\u0075\u0079\u0069\u006e\u002d\u006e\u0061\u0076\u0069\u0067\u0061\u0074\u0069\u006f\u006e\u0022\u005d`);
      if (navigationEl && navigationEl.firstElementChild) {
        navigationEl = navigationEl.firstElementChild;
      }
      const captcha_container = document.querySelector(`\u0023\u0063\u0061\u0070\u0074\u0063\u0068\u0061\u005f\u0063\u006f\u006e\u0074\u0061\u0069\u006e\u0065\u0072`);
      if (captcha_container) {
        sendLog(`\u51fa\u73b0\u4e86\u5f39\u51fa\u9a8c\u8bc1\u7801\uff0c\u9700\u8981\u9a8c\u8bc1`);
        if (store$1.captcha_container_num % 10 == 0) {
          sendLog(`\u51fa\u73b0\u4e86\u5f39\u51fa\u9a8c\u8bc1\u7801\uff0c\u9700\u8981\u9a8c\u8bc1\u0020\u8b66\u544a\u0020\u0063\u0061\u0070\u0074\u0063\u0068\u0061\u005f\u0063\u006f\u006e\u0074\u0061\u0069\u006e\u0065\u0072\u005f\u006e\u0075\u006d\u0025\u0031\u0030`, store$1.captcha_container_num % 10, store$1.captcha_container_num);
          let message = `\u6296\u97f3\u8d26\u53f7\uff1a` + store$1.webUserName + `\u000d\u000a\u767b\u5f55\u8d26\u53f7\u0049\u0064\uff1a` + store$1.userId + `\u000d\u000a\u767b\u5f55\u8d26\u53f7\uff1a` + store$1.userName + `\u000d\u000a\u5df2\u7ecf\u51fa\u73b0\u4e86\u003a` + store$1.captcha_container_num + `\u6b21\uff0c\u8bf7\u5c3d\u5feb\u5904\u7406\u0021\u0021\u0021`;
          await send_fei_shu_warn_message(`\u51fa\u73b0\u4e86\u56fe\u50cf\u9a8c\u8bc1\u7801\uff01`, message);
        }
        store$1.increment_captcha_container_num();
        await click_button(navigationEl);
        break;
      }
      for (let i = 0; i < somethingButtonList.length; i++) {
        const text = (_a = somethingButtonList[i].textContent) == null ? void 0 : _a.trim();
        sendLog(`\u0073\u006f\u006d\u0065\u0074\u0068\u0069\u006e\u0067\u0042\u0075\u0074\u0074\u006f\u006e\u004c\u0069\u0073\u0074\u0020\u0074\u0065\u0078\u0074\uff1a` + text);
        if (text == `\u901a\u77e5`) {
          let contentUrl = window.location.href;
          let pageTitle = document.title;
          await click_douYin_Notifications(pageTitle, contentUrl, `\u901a\u77e5`);
          try {
            store$1.setRunLogs(`\u5f00\u59cb\u5904\u7406\u6296\u97f3\u7684\u901a\u77e5\u4fe1\u606f`);
            await handle_Notifications();
            store$1.setRunLogs(`\u5904\u7406\u6296\u97f3\u7684\u901a\u77e5\u4fe1\u606f\u5b8c\u6210`);
          } catch (err) {
            console.log(`\u0068\u0061\u006e\u0064\u006c\u0065\u005f\u004e\u006f\u0074\u0069\u0066\u0069\u0063\u0061\u0074\u0069\u006f\u006e\u0073\u0020\u0065\u0072\u0072`, err);
            sendLog(`\u0068\u0061\u006e\u0064\u006c\u0065\u005f\u004e\u006f\u0074\u0069\u0066\u0069\u0063\u0061\u0074\u0069\u006f\u006e\u0073\u0020\u0065\u0072\u0072` + err);
          }
          contentUrl = window.location.href;
          pageTitle = document.title;
          await click_douYin_Notifications(pageTitle, contentUrl, `\u901a\u77e5`);
          findBool = true;
          continue;
        } else if (text == `\u79c1\u4fe1`) {
          let contentUrl = window.location.href;
          let pageTitle = document.title;
          await click_douYin_Notifications(pageTitle, contentUrl, `\u79c1\u4fe1`);
          store$1.setRunLogs(`\u5f00\u59cb\u5904\u7406\u6296\u97f3\u7684\u79c1\u4fe1\u4fe1\u606f`);
          await handle_PrivateMessage();
          store$1.setRunLogs(`\u5904\u7406\u6296\u97f3\u7684\u79c1\u4fe1\u4fe1\u606f\u5b8c\u6210`);
          findBool = true;
          break;
        }
        if (store$1.isNotRunWork()) {
          break;
        }
        await delay(500);
      }
      if (findBool) {
        break;
      }
    }
    if (somethingButtonList) {
      for (let i = 0; i < somethingButtonList.length; i++) {
        const text = (_b = somethingButtonList[i].textContent) == null ? void 0 : _b.trim();
        sendLog(`\u0073\u006f\u006d\u0065\u0074\u0068\u0069\u006e\u0067\u0042\u0075\u0074\u0074\u006f\u006e\u004c\u0069\u0073\u0074\u0020\u0074\u0065\u0078\u0074\uff1a` + text);
        if (text == `\u6295\u7a3f`) {
          await hover_button(somethingButtonList[i]);
        }
      }
    }
    const delayNum = getRandomNumberInRange(optionWhere.refreshFrequencyStart * 60 * 1e3, optionWhere.refreshFrequencyEnd * 60 * 1e3);
    store$1.setRefreshFrequencyNum(delayNum);
    await delay(delayNum);
    if (navigationEl) {
      const nowTime = (/* @__PURE__ */new Date()).getTime();
      console.log(`\u006e\u006f\u0077\u0054\u0069\u006d\u0065`, nowTime);
      if (store$1.runTimeMaxNum && store$1.runTimeNum && nowTime - store$1.runTimeNum >= store$1.runTimeMaxNum * 60 * 60 * 1e3) {
        closeEndFun(`\u0064\u006f\u0075\u0059\u0069\u006e\u005f\u0052\u0075\u006e\u0059\u006f\u0075\u0072\u0043\u006f\u0064\u0065\u0020\u901a\u77e5\u548c\u79c1\u4fe1\u0020\u5012\u8ba1\u65f6\u7ed3\u675f`).then();
        return;
      }
    }
    if (store$1.isNotRunWork()) {
      break;
    }
  }
};
const handle_Notifications = async () => {
  var _a, _b, _c, _d, _e, _f, _g, _h, _i, _j, _k, _l, _m, _n, _o, _p, _q, _r, _s, _t, _u, _v, _w, _x;
  console.log(`\u0068\u0061\u006e\u0064\u006c\u0065\u005f\u004e\u006f\u0074\u0069\u0066\u0069\u0063\u0061\u0074\u0069\u006f\u006e\u0073`);
  if (!(await checkDomPromise(`\u0064\u0069\u0076\u005b\u0064\u0061\u0074\u0061\u002d\u0065\u0032\u0065\u003d\u0022\u006c\u0069\u0073\u0074\u0044\u006c\u0067\u0054\u0065\u0073\u0074\u002d\u0063\u006f\u006e\u0074\u0061\u0069\u006e\u0065\u0072\u0022\u005d\u0020\u003e\u0064\u0069\u0076\u003a\u006e\u0074\u0068\u002d\u0063\u0068\u0069\u006c\u0064\u0028\u0032\u0029\u0020\u003e\u0020\u0064\u0069\u0076`))) {
    sendLog(`\u6ca1\u6709\u627e\u5230\u0020\u0064\u0069\u0076\u005b\u0064\u0061\u0074\u0061\u002d\u0065\u0032\u0065\u003d\u0022\u006c\u0069\u0073\u0074\u0044\u006c\u0067\u0054\u0065\u0073\u0074\u002d\u0063\u006f\u006e\u0074\u0061\u0069\u006e\u0065\u0072\u0022\u005d\u0020\u003e\u0064\u0069\u0076\u003a\u006e\u0074\u0068\u002d\u0063\u0068\u0069\u006c\u0064\u0028\u0032\u0029\u0020\u003e\u0020\u0064\u0069\u0076`);
    store$1.setRunLogs(`\u6ca1\u6709\u627e\u5230\u901a\u77e5\u4fe1\u606f`);
    return;
  }
  const key = store$1.userId + `\u005f` + store$1.webUserId + `\u005f\u006c\u0061\u0073\u0074\u005f\u004e\u006f\u0074\u0069\u0066\u0069\u0063\u0061\u0074\u0069\u006f\u006e\u0073`;
  const objectData = await getObjects(key);
  console.log(`\u0068\u0061\u006e\u0064\u006c\u0065\u005f\u004e\u006f\u0074\u0069\u0066\u0069\u0063\u0061\u0074\u0069\u006f\u006e\u0073\u0020\u006f\u0062\u006a\u0065\u0063\u0074\u0044\u0061\u0074\u0061`, objectData);
  const errorPageEl = document.querySelector(`\u0064\u0069\u0076\u005b\u0064\u0061\u0074\u0061\u002d\u0065\u0032\u0065\u003d\u0022\u0065\u0072\u0072\u006f\u0072\u002d\u0070\u0061\u0067\u0065\u0022\u005d`);
  if (errorPageEl) {
    const errorPageText = (_a = errorPageEl.textContent) == null ? void 0 : _a.trim();
    if (errorPageText && errorPageText == `\u6682\u65e0\u4e92\u52a8\u6d88\u606f`) {
      if (!objectData) {
        const addResult2 = await addObjects({
          "key": key,
          "bucket": {
            lastText: JSON.stringify([])
          },
          "size": 0,
          "content_type": ``,
          "belong_to": store$1.userId + `\u005f\u006c\u0061\u0073\u0074\u005f\u004e\u006f\u0074\u0069\u0066\u0069\u0063\u0061\u0074\u0069\u006f\u006e\u0073`,
          "object_metadata": {}
        });
        if (!addResult2 && !addResult2[`\u006b\u0065\u0079`]) {
          console.log(`\u65b0\u589e\u6570\u636e\u9519\u8bef`, addResult2);
          sendLog(`\u0068\u0061\u006e\u0064\u006c\u0065\u005f\u004e\u006f\u0074\u0069\u0066\u0069\u0063\u0061\u0074\u0069\u006f\u006e\u0073\u0020\u65b0\u589e\u6570\u636e\u9519\u8bef` + JSON.stringify(addResult2));
          return;
        }
        sendLog(`\u6ca1\u6709\u6570\u636e\uff0c\u521d\u59cb\u5316\u6570\u636e`);
        return;
      } else {
        sendLog(`\u6ca1\u6709\u4e92\u52a8\u6d88\u606f\uff0c\u5e76\u4e14\u006f\u0062\u006a\u0065\u0063\u0074\u0044\u0061\u0074\u0061\u0020\u4e0d\u4e3a\u006e\u0075\u006c\u006c\u002c\u0020\u006f\u0062\u006a\u0065\u0063\u0074\u0044\u0061\u0074\u0061\u003a` + JSON.stringify({
          objectData
        }));
        return;
      }
    } else {
      store$1.setRunLogs(`\u9519\u8bef\u4e86\uff1a` + errorPageText);
      sendLog(`\u627e\u5230\u4e86\u0064\u0069\u0076\u005b\u0064\u0061\u0074\u0061\u002d\u0065\u0032\u0065\u003d\u0022\u0065\u0072\u0072\u006f\u0072\u002d\u0070\u0061\u0067\u0065\u0022\u005d\uff0c\u0020\u4f46\u662f\u5143\u7d20\u7684\u6587\u672c\u4e0d\u662f\uff1a\u6682\u65e0\u4e92\u52a8\u6d88\u606f\uff0c\u800c\u662f\uff1a` + errorPageText);
      return;
    }
  }
  let listDlgTest = Array.from(document.querySelectorAll(`\u0064\u0069\u0076\u005b\u0064\u0061\u0074\u0061\u002d\u0065\u0032\u0065\u003d\u0022\u006c\u0069\u0073\u0074\u0044\u006c\u0067\u0054\u0065\u0073\u0074\u002d\u0063\u006f\u006e\u0074\u0061\u0069\u006e\u0065\u0072\u0022\u005d\u0020\u003e\u0064\u0069\u0076\u003a\u006e\u0074\u0068\u002d\u0063\u0068\u0069\u006c\u0064\u0028\u0032\u0029\u0020\u003e\u0020\u0064\u0069\u0076`));
  let lastTextList = [];
  for (let i = 0; i < listDlgTest.length; i++) {
    const dlgTest = listDlgTest[i];
    if (!dlgTest) {
      continue;
    }
    const dlgText = (_b = dlgTest.textContent) == null ? void 0 : _b.trim();
    if (dlgText && dlgText.indexOf(`\u53ef\u5728\u3010\u8bbe\u7f6e\u3011\u002d\u3010\u9690\u79c1\u8bbe\u7f6e\u3011\u4e2d\u4fee\u6539\u5728\u7ebf\u72b6\u6001\uff0c\u5f00\u542f\u540e\u67e5\u770b\u4e92\u5173\u670b\u53cb\u5728\u7ebf\u72b6\u6001\u3002`) > 0) {
      sendLog(`\u8fd9\u4e2a\u662f\u0020\u3010\u53ef\u5728\u3010\u8bbe\u7f6e\u3011\u002d\u3010\u9690\u79c1\u8bbe\u7f6e\u3011\u4e2d\u4fee\u6539\u5728\u7ebf\u72b6\u6001\uff0c\u5f00\u542f\u540e\u67e5\u770b\u4e92\u5173\u670b\u53cb\u5728\u7ebf\u72b6\u6001\u3002\u3011\u8df3\u8fc7`);
      continue;
    }
    const divEl = dlgTest.querySelector(`\u003a\u0073\u0063\u006f\u0070\u0065\u0020\u0020\u003e\u0064\u0069\u0076`);
    if (divEl) {
      ensureElementVisible(divEl);
    }
    const preEl = dlgTest.querySelector(`\u0070\u0072\u0065`);
    let content = ``;
    if (preEl) {
      console.log(`\u0070\u0072\u0065\u0045\u006c`, (_c = preEl.textContent) == null ? void 0 : _c.trim());
      content = (_d = preEl.textContent) == null ? void 0 : _d.trim();
    } else {
      const noMoreText = (_e = dlgTest.textContent) == null ? void 0 : _e.trim();
      if (noMoreText == `\u6682\u65f6\u6ca1\u6709\u66f4\u591a\u4e86`) {
        sendLog(`\u6700\u540e\u4e00\u6761\u662f\u6ca1\u6709\u66f4\u591a\u6570\u636e\u4e86\uff0c\u0020\u6682\u65f6\u6ca1\u6709\u66f4\u591a\u4e86\u3002\u8df3\u8fc7`);
        continue;
      }
    }
    if (!((_f = dlgTest.textContent) == null ? void 0 : _f.trim())) {
      sendLog(`\u627e\u5230\u7684\u5143\u7d20\uff0c\u6ca1\u6709\u4efb\u4f55\u7684\u5185\u5bb9\u3002`);
      continue;
    }
    if (!(await checkDomPromise(`\u0064\u0069\u0076\u005b\u0064\u0061\u0074\u0061\u002d\u0065\u0032\u0065\u003d\u0022\u0075\u0073\u0065\u0072\u002d\u006e\u0061\u006d\u0065\u002d\u0063\u0061\u0072\u0064\u0022\u005d`, dlgTest))) {
      console.log(`\u6ca1\u6709\u627e\u5230\u0020\u0064\u0069\u0076\u005b\u0064\u0061\u0074\u0061\u002d\u0065\u0032\u0065\u003d\u0022\u0075\u0073\u0065\u0072\u002d\u006e\u0061\u006d\u0065\u002d\u0063\u0061\u0072\u0064\u0022\u005d`);
      return;
    }
    const userNameEl = dlgTest.querySelector(`\u0064\u0069\u0076\u005b\u0064\u0061\u0074\u0061\u002d\u0065\u0032\u0065\u003d\u0022\u0075\u0073\u0065\u0072\u002d\u006e\u0061\u006d\u0065\u002d\u0063\u0061\u0072\u0064\u0022\u005d`);
    let userName = ``;
    if (userNameEl) {
      console.log(`\u0075\u0073\u0065\u0072\u004e\u0061\u006d\u0065\u0045\u006c`, (_g = userNameEl.textContent) == null ? void 0 : _g.trim());
      userName = (_h = userNameEl.textContent) == null ? void 0 : _h.trim();
    }
    if (!userName) {
      console.log(`\u6ca1\u6709\u627e\u5230\u7528\u6237\u540d\u79f0`);
      sendLog(`\u6ca1\u6709\u627e\u5230\u7528\u6237\u540d\u79f0`);
      return;
    }
    let userPath = ``;
    const aEl = dlgTest.querySelector(`\u0061\u005b\u0072\u0065\u006c\u003d\u0022\u006e\u006f\u006f\u0070\u0065\u006e\u0065\u0072\u0020\u006e\u006f\u0072\u0065\u0066\u0065\u0072\u0072\u0065\u0072\u0022\u005d`);
    if (aEl) {
      console.log(`\u0061\u0045\u006c`);
      let href = aEl.getAttribute(`\u0068\u0072\u0065\u0066`);
      sendLog(`\u0068\u0072\u0065\u0066\uff1a` + href);
      if (href) {
        if (href.startsWith(`\u002f\u002f`)) {
          href = `\u0068\u0074\u0074\u0070\u0073\u003a` + href;
        }
        userPath = new URL(href).pathname;
        userPath = userPath.replace(`\u002f\u0075\u0073\u0065\u0072\u002f`, ``);
        sendLog(`\u0068\u0072\u0065\u0066\u0020\u0070\u0061\u0074\u0068\u006e\u0061\u006d\u0065\u003a` + userPath);
      }
    }
    lastTextList.push({
      userName: userPath ? userPath : userName ? userName : ``,
      content: content ? content : ``
    });
    await delay(1e3);
    if (i >= 1) {
      break;
    }
  }
  if (lastTextList.length == 0) {
    console.log(`\u0068\u0061\u006e\u0064\u006c\u0065\u005f\u004e\u006f\u0074\u0069\u0066\u0069\u0063\u0061\u0074\u0069\u006f\u006e\u0073\u0020\u6ca1\u6709\u627e\u5230\u6570\u636e`);
    sendLog(`\u0068\u0061\u006e\u0064\u006c\u0065\u005f\u004e\u006f\u0074\u0069\u0066\u0069\u0063\u0061\u0074\u0069\u006f\u006e\u0073\u0020\u6ca1\u6709\u627e\u5230\u6570\u636e`);
    store$1.setRunLogs(`\u6ca1\u6709\u627e\u5230\u6570\u636e`);
    return;
  }
  const lastText = JSON.stringify(lastTextList);
  if (objectData && objectData[`\u0062\u0075\u0063\u006b\u0065\u0074`] && objectData[`\u0062\u0075\u0063\u006b\u0065\u0074`][`\u006c\u0061\u0073\u0074\u0054\u0065\u0078\u0074`] && objectData[`\u0062\u0075\u0063\u006b\u0065\u0074`][`\u006c\u0061\u0073\u0074\u0054\u0065\u0078\u0074`] == lastText) {
    console.log(`\u0068\u0061\u006e\u0064\u006c\u0065\u005f\u004e\u006f\u0074\u0069\u0066\u0069\u0063\u0061\u0074\u0069\u006f\u006e\u0073\u0020\u006c\u0061\u0073\u0074\u0054\u0065\u0078\u0074`, lastText);
    sendLog(`\u0068\u0061\u006e\u0064\u006c\u0065\u005f\u004e\u006f\u0074\u0069\u0066\u0069\u0063\u0061\u0074\u0069\u006f\u006e\u0073\u0020\u6ca1\u6709\u6700\u65b0\u7684\u6570\u636e`);
    store$1.setRunLogs(`\u6ca1\u6709\u6700\u65b0\u7684\u6570\u636e`);
    return;
  }
  const addResult = await addObjects({
    "key": key,
    "bucket": {
      lastText
    },
    "size": 0,
    "content_type": ``,
    "belong_to": store$1.userId + `\u005f\u006c\u0061\u0073\u0074\u005f\u004e\u006f\u0074\u0069\u0066\u0069\u0063\u0061\u0074\u0069\u006f\u006e\u0073`,
    "object_metadata": {}
  });
  if (!addResult && !addResult[`\u006b\u0065\u0079`]) {
    console.log(`\u65b0\u589e\u6570\u636e\u9519\u8bef`, addResult);
    sendLog(`\u0068\u0061\u006e\u0064\u006c\u0065\u005f\u004e\u006f\u0074\u0069\u0066\u0069\u0063\u0061\u0074\u0069\u006f\u006e\u0073\u0020\u65b0\u589e\u6570\u636e\u9519\u8bef` + JSON.stringify(addResult));
    store$1.setRunLogs(`\u65b0\u589e\u6570\u636e\u9519\u8bef`);
    return;
  }
  console.log(`\u0068\u0061\u006e\u0064\u006c\u0065\u005f\u004e\u006f\u0074\u0069\u0066\u0069\u0063\u0061\u0074\u0069\u006f\u006e\u0073\u0020\u006c\u0061\u0073\u0074\u0054\u0065\u0078\u0074\u003a`, lastText);
  lastTextList = [];
  if (objectData && objectData[`\u0062\u0075\u0063\u006b\u0065\u0074`] && objectData[`\u0062\u0075\u0063\u006b\u0065\u0074`][`\u006c\u0061\u0073\u0074\u0054\u0065\u0078\u0074`] && objectData[`\u0062\u0075\u0063\u006b\u0065\u0074`][`\u006c\u0061\u0073\u0074\u0054\u0065\u0078\u0074`]) {
    lastTextList = JSON.parse(objectData[`\u0062\u0075\u0063\u006b\u0065\u0074`][`\u006c\u0061\u0073\u0074\u0054\u0065\u0078\u0074`]);
  }
  if (!objectData) {
    console.log(`\u7b2c\u4e00\u6b21\u521d\u59cb\u5316\u6570\u636e`);
    sendLog(`\u7b2c\u4e00\u6b21\u521d\u59cb\u5316\u6570\u636e`);
    store$1.setRunLogs(`\u7b2c\u4e00\u6b21\u521d\u59cb\u5316\u6570\u636e`);
    return;
  }
  let matchNum = 0;
  const messageList = [];
  const preMessageList = [];
  let endBool = false;
  let maxNum = 60;
  let num = 0;
  while (!endBool) {
    if (!(await checkDomPromise(`\u0064\u0069\u0076\u005b\u0064\u0061\u0074\u0061\u002d\u0065\u0032\u0065\u003d\u0022\u006c\u0069\u0073\u0074\u0044\u006c\u0067\u0054\u0065\u0073\u0074\u002d\u0063\u006f\u006e\u0074\u0061\u0069\u006e\u0065\u0072\u0022\u005d\u0020\u003e\u0064\u0069\u0076\u003a\u006e\u0074\u0068\u002d\u0063\u0068\u0069\u006c\u0064\u0028\u0032\u0029\u0020\u003e\u0020\u0064\u0069\u0076`))) {
      sendLog(`\u6ca1\u6709\u627e\u5230\u0020\u0064\u0069\u0076\u005b\u0064\u0061\u0074\u0061\u002d\u0065\u0032\u0065\u003d\u0022\u006c\u0069\u0073\u0074\u0044\u006c\u0067\u0054\u0065\u0073\u0074\u002d\u0063\u006f\u006e\u0074\u0061\u0069\u006e\u0065\u0072\u0022\u005d\u0020\u003e\u0064\u0069\u0076\u003a\u006e\u0074\u0068\u002d\u0063\u0068\u0069\u006c\u0064\u0028\u0032\u0029\u0020\u003e\u0020\u0064\u0069\u0076`);
      store$1.setRunLogs(`\u6ca1\u6709\u627e\u5230\u901a\u77e5\u4fe1\u606f`);
      return;
    }
    listDlgTest = Array.from(document.querySelectorAll(`\u0064\u0069\u0076\u005b\u0064\u0061\u0074\u0061\u002d\u0065\u0032\u0065\u003d\u0022\u006c\u0069\u0073\u0074\u0044\u006c\u0067\u0054\u0065\u0073\u0074\u002d\u0063\u006f\u006e\u0074\u0061\u0069\u006e\u0065\u0072\u0022\u005d\u0020\u003e\u0064\u0069\u0076\u003a\u006e\u0074\u0068\u002d\u0063\u0068\u0069\u006c\u0064\u0028\u0032\u0029\u0020\u003e\u0020\u0064\u0069\u0076`));
    num++;
    if (num > maxNum) {
      endBool = true;
    }
    for (let i = 0; i < listDlgTest.length; i++) {
      const dlgTest = listDlgTest[i];
      if (!dlgTest) {
        sendLog(`\u0064\u006c\u0067\u0054\u0065\u0073\u0074\u0020\u4e3a\u006e\u0075\u006c\u006c`);
        console.log(`\u0064\u006c\u0067\u0054\u0065\u0073\u0074\u0020\u4e3a\u006e\u0075\u006c\u006c`);
        continue;
      }
      const divEl = dlgTest.querySelector(`\u003a\u0073\u0063\u006f\u0070\u0065\u0020\u003e\u0064\u0069\u0076`);
      if (divEl) {
        ensureElementVisible(divEl);
      }
      const preEl2 = dlgTest.querySelector(`\u0070\u0072\u0065`);
      let content = ``;
      if (preEl2) {
        console.log(`\u0070\u0072\u0065\u0045\u006c`, (_i = preEl2.textContent) == null ? void 0 : _i.trim());
        content = (_j = preEl2.textContent) == null ? void 0 : _j.trim();
      }
      const userNameEl2 = dlgTest.querySelector(`\u0064\u0069\u0076\u005b\u0064\u0061\u0074\u0061\u002d\u0065\u0032\u0065\u003d\u0022\u0075\u0073\u0065\u0072\u002d\u006e\u0061\u006d\u0065\u002d\u0063\u0061\u0072\u0064\u0022\u005d`);
      let userName = ``;
      if (userNameEl2) {
        console.log(`\u0075\u0073\u0065\u0072\u004e\u0061\u006d\u0065\u0045\u006c`, (_k = userNameEl2.textContent) == null ? void 0 : _k.trim());
        userName = (_l = userNameEl2.textContent) == null ? void 0 : _l.trim();
      }
      let userPath = ``;
      const aEl2 = dlgTest.querySelector(`\u0061\u005b\u0072\u0065\u006c\u003d\u0022\u006e\u006f\u006f\u0070\u0065\u006e\u0065\u0072\u0020\u006e\u006f\u0072\u0065\u0066\u0065\u0072\u0072\u0065\u0072\u0022\u005d`);
      if (aEl2) {
        let href = aEl2.getAttribute(`\u0068\u0072\u0065\u0066`);
        sendLog(`\u0068\u0072\u0065\u0066\uff1a` + href);
        if (href) {
          if (href.startsWith(`\u002f\u002f`)) {
            href = `\u0068\u0074\u0074\u0070\u0073\u003a` + href;
          }
          userPath = new URL(href).pathname;
          userPath = userPath.replace(`\u002f\u0075\u0073\u0065\u0072\u002f`, ``);
          sendLog(`\u0068\u0072\u0065\u0066\u0020\u0070\u0061\u0074\u0068\u006e\u0061\u006d\u0065\u003a` + userPath);
        }
      }
      const textContent = (userPath ? userPath : userName ? userName : ``) + (content ? content : ``);
      if (preMessageList.includes(textContent)) {
        console.log(`\u5df2\u7ecf\u56de\u590d\u8fc7\u4e86`);
        sendLog(`\u5df2\u7ecf\u56de\u590d\u8fc7\u4e86`);
        continue;
      }
      preMessageList.push(textContent);
      if (lastTextList && lastTextList[0] && matchNum == 0 && ((_m = lastTextList[0]) == null ? void 0 : _m.userName) + ((_n = lastTextList[0]) == null ? void 0 : _n.content) == textContent) {
        console.log(`\u0074\u0065\u0078\u0074\u0043\u006f\u006e\u0074\u0065\u006e\u0074`, textContent);
        matchNum = 1;
        console.log(`\u901a\u77e5\u6d88\u606f`, (_o = dlgTest.textContent) == null ? void 0 : _o.trim());
        if (lastTextList && lastTextList.length == 1 && matchNum == 1) {
          console.log(`\u0068\u0061\u006e\u0064\u006c\u0065\u005f\u004e\u006f\u0074\u0069\u0066\u0069\u0063\u0061\u0074\u0069\u006f\u006e\u0073\u0020\u0065\u006e\u0064\uff0c\u006d\u0061\u0074\u0063\u0068\u004e\u0075\u006d\uff1a` + matchNum + `\uff0c\u006c\u0061\u0073\u0074\u0054\u0065\u0078\u0074\u004c\u0069\u0073\u0074\u002e\u006c\u0065\u006e\u0067\u0074\u0068\uff1a` + lastTextList.length);
          sendLog(`\u0068\u0061\u006e\u0064\u006c\u0065\u005f\u004e\u006f\u0074\u0069\u0066\u0069\u0063\u0061\u0074\u0069\u006f\u006e\u0073\u0020\u0065\u006e\u0064\uff0c\u006d\u0061\u0074\u0063\u0068\u004e\u0075\u006d\uff1a` + matchNum + `\uff0c\u006c\u0061\u0073\u0074\u0054\u0065\u0078\u0074\u004c\u0069\u0073\u0074\u002e\u006c\u0065\u006e\u0067\u0074\u0068\uff1a` + lastTextList.length);
          endBool = true;
          break;
        }
        continue;
      }
      if (matchNum == 1) {
        if (lastTextList && lastTextList[1] && matchNum == 1 && ((_p = lastTextList[1]) == null ? void 0 : _p.userName) + ((_q = lastTextList[1]) == null ? void 0 : _q.content) == textContent) {
          console.log(`\u0074\u0065\u0078\u0074\u0043\u006f\u006e\u0074\u0065\u006e\u0074`, textContent);
          matchNum = 2;
          console.log(`\u901a\u77e5\u6d88\u606f\u0032`, (_r = dlgTest.textContent) == null ? void 0 : _r.trim());
          if (lastTextList && lastTextList.length >= 2 && matchNum == 2) {
            console.log(`\u0068\u0061\u006e\u0064\u006c\u0065\u005f\u004e\u006f\u0074\u0069\u0066\u0069\u0063\u0061\u0074\u0069\u006f\u006e\u0073\u0020\u0065\u006e\u0064\uff0c\u006d\u0061\u0074\u0063\u0068\u004e\u0075\u006d\uff1a` + matchNum + `\uff0c\u006c\u0061\u0073\u0074\u0054\u0065\u0078\u0074\u004c\u0069\u0073\u0074\u002e\u006c\u0065\u006e\u0067\u0074\u0068\uff1a` + lastTextList.length);
            sendLog(`\u0068\u0061\u006e\u0064\u006c\u0065\u005f\u004e\u006f\u0074\u0069\u0066\u0069\u0063\u0061\u0074\u0069\u006f\u006e\u0073\u0020\u0065\u006e\u0064\uff0c\u006d\u0061\u0074\u0063\u0068\u004e\u0075\u006d\uff1a` + matchNum + `\uff0c\u006c\u0061\u0073\u0074\u0054\u0065\u0078\u0074\u004c\u0069\u0073\u0074\u002e\u006c\u0065\u006e\u0067\u0074\u0068\uff1a` + lastTextList.length);
            endBool = true;
            break;
          }
        } else {
          console.log(`\u006d\u0061\u0074\u0063\u0068\u004e\u0075\u006d\uff1a`, matchNum);
          matchNum = 0;
        }
      }
      const spanList = Array.from(dlgTest.querySelectorAll(`\u0073\u0070\u0061\u006e`));
      let spanBoolean = false;
      spanList.forEach(span => {
        var _a2;
        if (span && ((_a2 = span.textContent) == null ? void 0 : _a2.trim()) == `\u8bc4\u8bba\u4e86\u4f60\u7684\u4f5c\u54c1`) {
          spanBoolean = true;
        }
      });
      if (!spanBoolean) {
        console.log(`\u4e0d\u662f\u8bc4\u8bba\u4e86\u4f60\u7684\u0020\u4f5c\u54c1`);
        continue;
      }
      const messageData = {};
      messageData[`\u0073\u006f\u0075\u0072\u0063\u0065`] = `\u6296\u97f3`;
      messageData[`\u0063\u006c\u0075\u0065\u0054\u0079\u0070\u0065`] = `\u901a\u77e5`;
      const preEl = dlgTest.querySelector(`\u0070\u0072\u0065`);
      if (preEl) {
        console.log(`\u0070\u0072\u0065\u0045\u006c`, (_s = preEl.textContent) == null ? void 0 : _s.trim());
        messageData[`\u0063\u006f\u006e\u0074\u0065\u006e\u0074`] = (_t = preEl.textContent) == null ? void 0 : _t.trim();
        await hover_button(preEl);
        await click_button(preEl);
        await delay(1e3);
      }
      const userNameEl = dlgTest.querySelector(`\u0064\u0069\u0076\u005b\u0064\u0061\u0074\u0061\u002d\u0065\u0032\u0065\u003d\u0022\u0075\u0073\u0065\u0072\u002d\u006e\u0061\u006d\u0065\u002d\u0063\u0061\u0072\u0064\u0022\u005d`);
      if (userNameEl) {
        console.log(`\u0075\u0073\u0065\u0072\u004e\u0061\u006d\u0065\u0045\u006c`, (_u = userNameEl.textContent) == null ? void 0 : _u.trim());
        messageData[`\u0075\u0073\u0065\u0072\u004e\u0061\u006d\u0065`] = (_v = userNameEl.textContent) == null ? void 0 : _v.trim();
      }
      const aEl = dlgTest.querySelector(`\u0061\u005b\u0072\u0065\u006c\u003d\u0022\u006e\u006f\u006f\u0070\u0065\u006e\u0065\u0072\u0020\u006e\u006f\u0072\u0065\u0066\u0065\u0072\u0072\u0065\u0072\u0022\u005d`);
      if (aEl) {
        console.log(`\u0061\u0045\u006c`);
        let href = aEl.getAttribute(`\u0068\u0072\u0065\u0066`);
        sendLog(`\u0068\u0072\u0065\u0066\uff1a` + href);
        messageData[`\u0075\u0073\u0065\u0072\u0055\u0072\u006c`] = href;
        if (href) {
          if (href.startsWith(`\u002f\u002f`)) {
            href = `\u0068\u0074\u0074\u0070\u0073\u003a` + href;
          }
          userPath = new URL(href).pathname;
          userPath = userPath.replace(`\u002f\u0075\u0073\u0065\u0072\u002f`, ``);
          sendLog(`\u0068\u0072\u0065\u0066\u0020\u0070\u0061\u0074\u0068\u006e\u0061\u006d\u0065\u003a` + userPath);
          messageData[`\u0075\u0073\u0065\u0072\u0050\u0061\u0074\u0068`] = userPath;
        }
      }
      const avatarImgEl = dlgTest.querySelector(`\u0064\u0069\u0076\u005b\u0064\u0061\u0074\u0061\u002d\u0065\u0032\u0065\u003d\u0022\u0075\u0073\u0065\u0072\u002d\u0061\u0076\u0061\u0074\u0061\u0072\u002d\u0063\u0061\u0072\u0064\u0022\u005d\u0020\u0069\u006d\u0067`);
      let avatarPath = ``;
      let avatarUrl = ``;
      if (avatarImgEl) {
        avatarUrl = avatarImgEl.src;
        if (avatarUrl) {
          try {
            if (avatarUrl.startsWith(`\u002f\u002f`)) {
              avatarUrl = `\u0068\u0074\u0074\u0070\u0073\u003a` + avatarUrl;
            }
            const avatarURL = new URL(avatarUrl);
            avatarPath = avatarURL.pathname;
            if (avatarPath) {
              avatarPath = getLastPathName$1(avatarPath);
            } else {
              sendLog(`\u7528\u6237\u5934\u50cf\u4e3a\u7a7a\uff0c\u0070\u0061\u0074\u0068\u006e\u0061\u006d\u0065\u003a` + avatarPath);
            }
          } catch (error) {
            sendLog(`\u7528\u6237\u5934\u50cf\u4e3a\u7a7a\u0020\u0075\u0072\u006c\u0020\u9519\u8bef\u0020` + avatarUrl);
          }
        } else {
          sendLog(`\u7528\u6237\u5934\u50cf\u7684\u5730\u5740\u4e0d\u662f\u0055\u0072\u006c\u003a` + avatarUrl);
        }
      } else {
        sendLog(`\u6ca1\u6709\u627e\u5230\u7528\u6237\u5934\u50cf`);
      }
      messageData[`\u0061\u0076\u0061\u0074\u0061\u0072`] = avatarUrl;
      messageData[`\u0061\u0076\u0061\u0074\u0061\u0072\u0050\u0061\u0074\u0068`] = avatarPath;
      const timeEl = dlgTest.querySelector(`\u003a\u0073\u0063\u006f\u0070\u0065\u0020\u003e\u0064\u0069\u0076\u0020\u003e\u0064\u0069\u0076\u0020\u003e\u0064\u0069\u0076\u0020\u003e\u0064\u0069\u0076\u003a\u006e\u0074\u0068\u002d\u0063\u0068\u0069\u006c\u0064\u0028\u0033\u0029\u0020\u003e\u0073\u0070\u0061\u006e\u003a\u006e\u0074\u0068\u002d\u0063\u0068\u0069\u006c\u0064\u0028\u0032\u0029`);
      if (timeEl) {
        const timeText = (_w = timeEl.textContent) == null ? void 0 : _w.trim();
        console.log(`\u0074\u0069\u006d\u0065\u0054\u0065\u0078\u0074`, timeText);
        messageData[`\u0074\u0069\u006d\u0065\u0054\u0065\u0078\u0074`] = timeText;
      }
      const date = /* @__PURE__ */new Date();
      const year = date.getFullYear();
      const month = String(date.getMonth() + 1).padStart(2, `\u0030`);
      const day = String(date.getDate()).padStart(2, `\u0030`);
      const hours = String(date.getHours()).padStart(2, `\u0030`);
      const minutes = String(date.getMinutes()).padStart(2, `\u0030`);
      messageData[`\u0063\u0072\u0065\u0061\u0074\u0065\u0044\u0061\u0074\u0065`] = `${year}\u002d${month}\u002d${day}\u0020${hours}\u003a${minutes}`;
      messageData[`\u0061\u0064\u0064\u0054\u0069\u006d\u0065`] = (/* @__PURE__ */new Date()).getTime();
      messageData[`\u0074\u0065\u006e\u0061\u006e\u0074\u0049\u0064`] = store$1.tenantId;
      messageData[`\u0075\u0073\u0065\u0072\u0049\u0064`] = store$1.userId;
      messageData[`\u0061\u0067\u0065\u006e\u0074\u0049\u0064`] = VITE_AGENT_ID;
      messageData[`\u0074\u0061\u0073\u006b\u0049\u0064`] = store$1.taskId;
      messageData[`\u0065\u0078\u0065\u0063\u0075\u0074\u0065\u0049\u0064`] = store$1.executeId;
      messageData[`\u0074\u0065\u0072\u006d\u0069\u006e\u0061\u006c\u0049\u0064`] = (_x = store$1.terminalData) == null ? void 0 : _x.terminalId;
      messageData[`\u0077\u0065\u0062\u0055\u0073\u0065\u0072\u0049\u0064`] = store$1.webUserId;
      messageData[`\u0077\u0065\u0062\u0055\u0073\u0065\u0072\u004e\u0061\u006d\u0065`] = store$1.webUserName;
      const contentUrlData = await getContentUrl(messageData);
      if (contentUrlData && contentUrlData.contentUrl) {
        messageData[`\u0063\u006f\u006e\u0074\u0065\u006e\u0074\u0055\u0072\u006c`] = contentUrlData.contentUrl;
      }
      if (contentUrlData == null ? void 0 : contentUrlData.replayBoolean) {
        store$1.setRunLogs(`\u5f00\u59cb\u56de\u590d\u6296\u97f3\u7684\u901a\u77e5\u7684\u89c6\u9891\uff1a` + contentUrlData[`\u0076\u0069\u0064\u0065\u006f\u0044\u0065\u0073\u0063`] + `\u7684\u8bc4\u8bba`);
        messageList.push(messageData);
        const userData = await get_PrivateMessage_userId(messageData[`\u0061\u0076\u0061\u0074\u0061\u0072\u0050\u0061\u0074\u0068`], messageData[`\u0075\u0073\u0065\u0072\u004e\u0061\u006d\u0065`], messageData[`\u0075\u0073\u0065\u0072\u0050\u0061\u0074\u0068`]);
        messageData[`\u0063\u006f\u006e\u0074\u0065\u006e\u0074\u0057\u0065\u0062\u0055\u0073\u0065\u0072\u0049\u0064`] = userData[`\u0077\u0065\u0062\u0055\u0073\u0065\u0072\u0049\u0064`];
        messageData[`\u0063\u006f\u006e\u0074\u0065\u006e\u0074\u0055\u0073\u0065\u0072\u0049\u0064`] = userData[`\u0075\u0073\u0065\u0072\u0049\u0064`];
        const key2 = `\u0064\u006f\u0075\u0059\u0069\u006e\u005f\u004e\u006f\u0074\u0069\u0066\u0069\u0063\u0061\u0074\u0069\u006f\u006e\u0073\u005f` + (/* @__PURE__ */new Date()).getTime();
        const postDataObj = {
          "key": key2,
          "bucket": messageData,
          "size": 0,
          "content_type": ``,
          "belong_to": store$1.userId + `\u005f\u0064\u006f\u0075\u0059\u0069\u006e\u004c\u0069\u0073\u0074`,
          "object_metadata": {}
        };
        await addObjects(postDataObj);
        if (!userData[`\u0077\u0065\u0062\u0055\u0073\u0065\u0072\u0049\u0064`] && messageData[`\u0075\u0073\u0065\u0072\u0050\u0061\u0074\u0068`]) {
          userData[`\u0077\u0065\u0062\u0055\u0073\u0065\u0072\u0049\u0064`] = messageData[`\u0075\u0073\u0065\u0072\u0050\u0061\u0074\u0068`];
          const bucket = userData[`\u0062\u0075\u0063\u006b\u0065\u0074`];
          bucket[`\u0077\u0065\u0062\u0055\u0073\u0065\u0072\u0049\u0064`] = userData[`\u0077\u0065\u0062\u0055\u0073\u0065\u0072\u0049\u0064`];
          await update_Private_userId(userData.key, bucket);
          const changePostData = {
            "old_id": userData[`\u0075\u0073\u0065\u0072\u0049\u0064`],
            "new_id": userData[`\u0077\u0065\u0062\u0055\u0073\u0065\u0072\u0049\u0064`]
          };
          await changeAccount(changePostData);
        }
        store$1.setContentText(messageData[`\u0063\u006f\u006e\u0074\u0065\u006e\u0074`]);
        store$1.setReplyComment(contentUrlData[`\u0072\u0065\u0070\u006c\u0079\u0043\u006f\u006e\u0074\u0065\u006e\u0074\u0054\u0065\u0078\u0074`]);
        await saveChat({
          "session": {
            // 登录网站用户id
            "account_id": store$1.webUserId,
            // 视频名称
            "video_name": contentUrlData[`\u0076\u0069\u0064\u0065\u006f\u0044\u0065\u0073\u0063`],
            // 视频地址
            "video_url": messageData[`\u0063\u006f\u006e\u0074\u0065\u006e\u0074\u0055\u0072\u006c`],
            // 会话来源，通知和私信
            "source": `\u901a\u77e5`
          },
          "chat_list": [{
            // 发送id
            "sender": userData[`\u0077\u0065\u0062\u0055\u0073\u0065\u0072\u0049\u0064`] ? userData[`\u0077\u0065\u0062\u0055\u0073\u0065\u0072\u0049\u0064`] : userData[`\u0075\u0073\u0065\u0072\u0049\u0064`],
            // 发送人的名称
            "sender_name": messageData[`\u0075\u0073\u0065\u0072\u004e\u0061\u006d\u0065`],
            "sender_avatar": messageData[`\u0061\u0076\u0061\u0074\u0061\u0072`],
            // 接收人id
            "receiver": store$1.webUserId,
            // 接收人的id
            "receiver_name": store$1.webUserName,
            "receiver_avatar": store$1.webUserAvatarUrl,
            // 发送内容
            "content": messageData[`\u0063\u006f\u006e\u0074\u0065\u006e\u0074`]
          }, {
            // 发送id
            "sender": store$1.webUserId,
            // 发送人的名称
            "sender_name": store$1.webUserName,
            "sender_avatar": store$1.webUserAvatarUrl,
            // 接收人id
            "receiver": userData[`\u0077\u0065\u0062\u0055\u0073\u0065\u0072\u0049\u0064`] ? userData[`\u0077\u0065\u0062\u0055\u0073\u0065\u0072\u0049\u0064`] : userData[`\u0075\u0073\u0065\u0072\u0049\u0064`],
            // 接收人的id
            "receiver_name": messageData[`\u0075\u0073\u0065\u0072\u004e\u0061\u006d\u0065`],
            "receiver_avatar": messageData[`\u0061\u0076\u0061\u0074\u0061\u0072`],
            // 发送内容
            "content": contentUrlData[`\u0072\u0065\u0070\u006c\u0079\u0043\u006f\u006e\u0074\u0065\u006e\u0074\u0054\u0065\u0078\u0074`]
          }]
        });
        break;
      } else {
        console.log(`\u0063\u006f\u006e\u0074\u0065\u006e\u0074\u0055\u0072\u006c\u0044\u0061\u0074\u0061\u003f\u002e\u0072\u0065\u0070\u006c\u0061\u0079\u0042\u006f\u006f\u006c\u0065\u0061\u006e\u0020\u4e3a\u0020\u0066\u0061\u006c\u0073\u0065`);
      }
    }
  }
  console.log(`\u0068\u0061\u006e\u0064\u006c\u0065\u005f\u004e\u006f\u0074\u0069\u0066\u0069\u0063\u0061\u0074\u0069\u006f\u006e\u0073\u0020\u006d\u0065\u0073\u0073\u0061\u0067\u0065\u004c\u0069\u0073\u0074`, messageList);
};
const findFirstMessageToScroll = async () => {
  let preFirstChild = null;
  let num = 0;
  while (true) {
    if (num > 60) {
      sendLog(`\u8d85\u8fc7\u0036\u0030\u8fd8\u6ca1\u6709\u627e\u5230`);
      break;
    }
    num++;
    let container = document.querySelector(`\u0064\u0069\u0076\u005b\u0064\u0061\u0074\u0061\u002d\u0065\u0032\u0065\u003d\u0022\u006c\u0069\u0073\u0074\u0044\u006c\u0067\u002d\u0063\u006f\u006e\u0074\u0061\u0069\u006e\u0065\u0072\u0022\u005d\u0020\u003e\u0020\u0064\u0069\u0076\u003a\u006e\u0074\u0068\u002d\u0063\u0068\u0069\u006c\u0064\u0028\u0032\u0029\u0020\u003e\u0020\u0064\u0069\u0076\u003a\u006e\u0074\u0068\u002d\u0063\u0068\u0069\u006c\u0064\u0028\u0031\u0029`);
    const firstChild = container == null ? void 0 : container.firstElementChild;
    if (!firstChild) {
      await delay(200);
      continue;
    }
    if (preFirstChild == null || firstChild != preFirstChild) {
      firstChild.scrollIntoView({
        behavior: `\u0073\u006d\u006f\u006f\u0074\u0068`,
        block: `\u0073\u0074\u0061\u0072\u0074`
      });
    }
    await delay(200);
    if (firstChild == preFirstChild) {
      sendLog(`\u5df2\u7ecf\u6eda\u52a8\u5230\u4e86\u5bb9\u5668\u7684\u9876\u90e8\uff0c\u627e\u5230\u4e86\u7b2c\u4e00\u4e2a\u5143\u7d20`);
      break;
    }
    preFirstChild = firstChild;
  }
};
const getCorpusContentText = async messageData => {
  let corpus_id = ``;
  if (store$1.corpusData && store$1.corpusData[`\u0063\u0068\u0061\u0074`]) {
    corpus_id = store$1.corpusData[`\u0063\u0068\u0061\u0074`];
  }
  if (!corpus_id) {
    if (store$1.tenantId) {
      const corpusResult = await queryTenantsCorpus(store$1.tenantId);
      sendLog(`\u0063\u006f\u0072\u0070\u0075\u0073\u0052\u0065\u0073\u0075\u006c\u0074\uff1a` + JSON.stringify(corpusResult));
      if (corpusResult && corpusResult[`\u0063\u006f\u0064\u0065`] == 0) {
        sendLog(`\u0063\u006f\u0072\u0070\u0075\u0073\u0052\u0065\u0073\u0075\u006c\u0074\u005b\u0027\u0064\u0061\u0074\u0061\u0027\u005d\u003a` + typeof corpusResult[`\u0064\u0061\u0074\u0061`]);
        store$1.setCorpusData(corpusResult[`\u0064\u0061\u0074\u0061`]);
      }
      if (store$1.corpusData && store$1.corpusData[`\u0063\u0068\u0061\u0074`]) {
        corpus_id = store$1.corpusData[`\u0063\u0068\u0061\u0074`];
      }
    } else {
      sendLog(`\u6ca1\u6709\u79df\u6237\u0069\u0064`);
    }
  }
  let contentText = ``;
  if (corpus_id) {
    const postData = {
      "corpus_id": corpus_id,
      "content": messageData[`\u0063\u006f\u006e\u0074\u0065\u006e\u0074`]
    };
    const chatTextJson = await getReplyContent(postData);
    if (chatTextJson && chatTextJson[`\u0064\u0061\u0074\u0061`]) {
      contentText = chatTextJson[`\u0064\u0061\u0074\u0061`];
    } else {
      sendLog(`\u6ca1\u6709\u83b7\u53d6\u5230\u5bf9\u8bdd\u5185\u5bb9\u0020\u0063\u0068\u0061\u0074\u0054\u0065\u0078\u0074\u004a\u0073\u006f\u006e\u003a` + JSON.stringify(chatTextJson));
    }
  } else {
    sendLog(`\u6ca1\u6709\u627e\u5230\u0063\u006f\u0072\u0070\u0075\u0073\u005f\u0069\u0064\uff1a` + JSON.stringify(store$1.corpusData));
  }
  return contentText;
};
const handle_PrivateMessage = async () => {
  var _a, _b, _c, _d, _e, _f, _g, _h, _i;
  console.log(`\u0068\u0061\u006e\u0064\u006c\u0065\u005f\u0050\u0072\u0069\u0076\u0061\u0074\u0065\u004d\u0065\u0073\u0073\u0061\u0067\u0065`);
  if (!(await checkDomPromise(`\u0064\u0069\u0076\u005b\u0064\u0061\u0074\u0061\u002d\u0065\u0032\u0065\u003d\u0022\u006c\u0069\u0073\u0074\u0044\u006c\u0067\u002d\u0063\u006f\u006e\u0074\u0061\u0069\u006e\u0065\u0072\u0022\u005d\u003e\u0064\u0069\u0076\u003a\u006e\u0074\u0068\u002d\u0063\u0068\u0069\u006c\u0064\u0028\u0032\u0029\u0020\u003e\u0064\u0069\u0076\u0020\u003e\u0064\u0069\u0076`))) {
    console.error(`\u6ca1\u6709\u627e\u5230`, `\u0064\u0069\u0076\u005b\u0064\u0061\u0074\u0061\u002d\u0065\u0032\u0065\u003d\u0022\u006c\u0069\u0073\u0074\u0044\u006c\u0067\u002d\u0063\u006f\u006e\u0074\u0061\u0069\u006e\u0065\u0072\u0022\u005d\u003e\u0064\u0069\u0076\u003a\u006e\u0074\u0068\u002d\u0063\u0068\u0069\u006c\u0064\u0028\u0032\u0029\u0020\u003e\u0064\u0069\u0076\u0020\u003e\u0064\u0069\u0076`);
    store$1.setRunLogs(`\u6ca1\u6709\u627e\u5230\u79c1\u4fe1\u4fe1\u606f`);
    return;
  }
  const errorPageEl = document.querySelector(`\u0064\u0069\u0076\u005b\u0064\u0061\u0074\u0061\u002d\u0065\u0032\u0065\u003d\u0022\u006c\u0069\u0073\u0074\u0044\u006c\u0067\u002d\u0063\u006f\u006e\u0074\u0061\u0069\u006e\u0065\u0072\u0022\u005d\u0020\u0064\u0069\u0076\u005b\u0064\u0061\u0074\u0061\u002d\u0065\u0032\u0065\u003d\u0022\u0065\u0072\u0072\u006f\u0072\u002d\u0070\u0061\u0067\u0065\u0022\u005d`);
  if (errorPageEl) {
    const errorPageText = (_a = errorPageEl.textContent) == null ? void 0 : _a.trim();
    if (errorPageText && errorPageText == `\u6682\u65e0\u79c1\u4fe1`) {
      sendLog(`\u0068\u0061\u006e\u0064\u006c\u0065\u005f\u0050\u0072\u0069\u0076\u0061\u0074\u0065\u004d\u0065\u0073\u0073\u0061\u0067\u0065\u0020\u6682\u65e0\u79c1\u4fe1`);
      store$1.setRunLogs(`\u6682\u65e0\u79c1\u4fe1`);
      return;
    } else {
      store$1.setRunLogs(`\u9519\u8bef\u4e86` + errorPageText);
      sendLog(`\u627e\u5230\u4e86\u0064\u0069\u0076\u005b\u0064\u0061\u0074\u0061\u002d\u0065\u0032\u0065\u003d\u0022\u0065\u0072\u0072\u006f\u0072\u002d\u0070\u0061\u0067\u0065\u0022\u005d\uff0c\u0020\u4f46\u662f\u5143\u7d20\u7684\u6587\u672c\u4e0d\u662f\uff1a\u6682\u65e0\u79c1\u4fe1\uff0c\u800c\u662f\uff1a` + errorPageText);
      return;
    }
  }
  sendLog(`\u0068\u0061\u006e\u0064\u006c\u0065\u005f\u0050\u0072\u0069\u0076\u0061\u0074\u0065\u004d\u0065\u0073\u0073\u0061\u0067\u0065\u0020\u5c55\u5f00`);
  store$1.setRunLogs(`\u5c55\u5f00\u79c1\u4fe1`);
  let num = 0;
  let findZhanKaiEl = null;
  let first_PrivateMessage_Stranger = false;
  let unreadPrivateMessageList = [];
  const noReadHandle = (i, dlg) => {
    var _a2, _b2;
    const zuoZhiEl = dlg.querySelector(`\u003a\u0073\u0063\u006f\u0070\u0065\u0020\u003e\u0064\u0069\u0076\u0020\u003e\u0064\u0069\u0076\u003e\u0064\u0069\u0076\u003a\u006e\u0074\u0068\u002d\u0063\u0068\u0069\u006c\u0064\u0028\u0032\u0029\u0020\u003e\u0064\u0069\u0076\u003a\u006e\u0074\u0068\u002d\u0063\u0068\u0069\u006c\u0064\u0028\u0031\u0029`);
    let zuoZhiText = ``;
    if (zuoZhiEl) {
      const zuoZhiText2 = (_a2 = zuoZhiEl.textContent) == null ? void 0 : _a2.trim();
      console.log(`\u007a\u0075\u006f\u005a\u0068\u0069\u0054\u0065\u0078\u0074\u0032`, zuoZhiText2);
      if (zuoZhiText2) {
        zuoZhiText = zuoZhiText2;
      }
    }
    if (i == 0 && zuoZhiText == `\u964c\u751f\u4eba\u6d88\u606f`) {
      first_PrivateMessage_Stranger = true;
    }
    const dianEl = dlg.querySelector(`\u003a\u0073\u0063\u006f\u0070\u0065\u0020\u003e\u0064\u0069\u0076\u0020\u003e\u0064\u0069\u0076\u003e\u0064\u0069\u0076\u003a\u006e\u0074\u0068\u002d\u0063\u0068\u0069\u006c\u0064\u0028\u0033\u0029\u0020\u003e\u0020\u0073\u0070\u0061\u006e`);
    const dianDivEl = dlg.querySelector(`\u003a\u0073\u0063\u006f\u0070\u0065\u0020\u003e\u0064\u0069\u0076\u0020\u003e\u0064\u0069\u0076\u003e\u0064\u0069\u0076\u003a\u006e\u0074\u0068\u002d\u0063\u0068\u0069\u006c\u0064\u0028\u0033\u0029\u0020\u003e\u0020\u0064\u0069\u0076`);
    let hongDianBool = true;
    if (!dianEl && !dianDivEl) {
      sendLog(`\u5df2\u8bfb\u53d6\u8fc7\u4e86\uff1a` + zuoZhiText);
      hongDianBool = false;
      return;
    }
    if (hongDianBool) {
      let preText = ``;
      const preEl = dlg.querySelector(`\u0070\u0072\u0065`);
      if (preEl) {
        const preText2 = (_b2 = preEl.textContent) == null ? void 0 : _b2.trim();
        if (preText2) {
          preText = preText2;
        }
      }
      sendLog(`\u627e\u5230\u672a\u8bfb\u7684\u6570\u636e\uff1a` + zuoZhiText + preText);
      unreadPrivateMessageList.push(zuoZhiText + preText);
    }
  };
  while (true) {
    if (num > 60) {
      break;
    }
    num++;
    const listDlg2 = Array.from(document.querySelectorAll(`\u0064\u0069\u0076\u005b\u0064\u0061\u0074\u0061\u002d\u0065\u0032\u0065\u003d\u0022\u006c\u0069\u0073\u0074\u0044\u006c\u0067\u002d\u0063\u006f\u006e\u0074\u0061\u0069\u006e\u0065\u0072\u0022\u005d\u003e\u0064\u0069\u0076\u003a\u006e\u0074\u0068\u002d\u0063\u0068\u0069\u006c\u0064\u0028\u0032\u0029\u0020\u003e\u0064\u0069\u0076\u0020\u003e\u0064\u0069\u0076`));
    let container2 = document.querySelector(`\u0064\u0069\u0076\u005b\u0064\u0061\u0074\u0061\u002d\u0065\u0032\u0065\u003d\u0022\u006c\u0069\u0073\u0074\u0044\u006c\u0067\u002d\u0063\u006f\u006e\u0074\u0061\u0069\u006e\u0065\u0072\u0022\u005d\u0020\u003e\u0020\u0064\u0069\u0076\u003a\u006e\u0074\u0068\u002d\u0063\u0068\u0069\u006c\u0064\u0028\u0032\u0029`);
    if (listDlg2.length == 0) {
      sendLog(`\u6ca1\u6709\u79c1\u4fe1\u5185\u5bb9`);
      store$1.setRunLogs(`\u6ca1\u6709\u79c1\u4fe1\u5185\u5bb9`);
      await delay(100);
      continue;
    }
    const divList = Array.from(document.querySelectorAll(`\u0064\u0069\u0076\u005b\u0064\u0061\u0074\u0061\u002d\u0065\u0032\u0065\u003d\u0022\u006c\u0069\u0073\u0074\u0044\u006c\u0067\u002d\u0063\u006f\u006e\u0074\u0061\u0069\u006e\u0065\u0072\u0022\u005d\u0020\u0064\u0069\u0076`));
    let noMoreBoolean = false;
    for (let i = divList.length - 1; i >= 0; i--) {
      const divEl = divList[i];
      if (divEl && ((_b = divEl.textContent) == null ? void 0 : _b.trim()) == `\u6682\u65f6\u6ca1\u6709\u66f4\u591a\u4e86`) {
        noMoreBoolean = true;
        break;
      }
    }
    let findMinNum = 3;
    for (let i = 0; i < listDlg2.length; i++) {
      const dlg = listDlg2[i];
      if (!dlg) {
        continue;
      }
      const divEl = dlg.querySelector(`\u003a\u0073\u0063\u006f\u0070\u0065\u0020\u003e\u0064\u0069\u0076`);
      if (divEl) {
        ensureElementVisible(divEl, container2);
      }
      console.log(`\u0064\u006c\u0067`, dlg);
      const dianEl = dlg.querySelector(`\u003a\u0073\u0063\u006f\u0070\u0065\u0020\u003e\u0064\u0069\u0076\u0020\u003e\u0064\u0069\u0076\u003e\u0064\u0069\u0076\u003a\u006e\u0074\u0068\u002d\u0063\u0068\u0069\u006c\u0064\u0028\u0033\u0029\u0020\u003e\u0020\u0073\u0070\u0061\u006e`);
      const dianDivEl = dlg.querySelector(`\u003a\u0073\u0063\u006f\u0070\u0065\u0020\u003e\u0064\u0069\u0076\u0020\u003e\u0064\u0069\u0076\u003e\u0064\u0069\u0076\u003a\u006e\u0074\u0068\u002d\u0063\u0068\u0069\u006c\u0064\u0028\u0033\u0029\u0020\u003e\u0020\u0064\u0069\u0076`);
      if (!dianEl && !dianDivEl) {
        const clickDiv = dlg.querySelector(`\u0064\u0069\u0076\u005b\u0064\u0061\u0074\u0061\u002d\u0065\u0032\u0065\u003d\u0022\u0063\u006f\u006e\u0076\u0065\u0072\u0073\u0061\u0074\u0069\u006f\u006e\u002d\u0069\u0074\u0065\u006d\u0022\u005d\u003e\u0064\u0069\u0076\u0020\u003e\u0064\u0069\u0076\u003a\u006e\u0074\u0068\u002d\u0063\u0068\u0069\u006c\u0064\u0028\u0032\u0029`);
        if (clickDiv) {
          findZhanKaiEl = clickDiv;
          if (findMinNum <= 0) {
            break;
          }
          findMinNum--;
        }
      }
      const zuoZhiEl = dlg.querySelector(`\u003a\u0073\u0063\u006f\u0070\u0065\u0020\u003e\u0064\u0069\u0076\u0020\u003e\u0064\u0069\u0076\u003e\u0064\u0069\u0076\u003a\u006e\u0074\u0068\u002d\u0063\u0068\u0069\u006c\u0064\u0028\u0032\u0029\u0020\u003e\u0064\u0069\u0076\u003a\u006e\u0074\u0068\u002d\u0063\u0068\u0069\u006c\u0064\u0028\u0031\u0029`);
      let zuoZhiText = ``;
      if (zuoZhiEl) {
        const zuoZhiText2 = (_c = zuoZhiEl.textContent) == null ? void 0 : _c.trim();
        console.log(`\u007a\u0075\u006f\u005a\u0068\u0069\u0054\u0065\u0078\u0074\u0032`, zuoZhiText2);
        if (zuoZhiText2) {
          zuoZhiText = zuoZhiText2;
        }
      }
      if (i == 0 && zuoZhiText == `\u964c\u751f\u4eba\u6d88\u606f`) {
        const clickDiv = dlg.querySelector(`\u0070\u0072\u0065`);
        if (clickDiv) {
          findZhanKaiEl = clickDiv;
          first_PrivateMessage_Stranger = true;
          break;
        }
      }
    }
    if (findZhanKaiEl) {
      break;
    }
    if (noMoreBoolean) {
      sendLog(`\u627e\u5230\u4e86\uff1a\u6682\u65f6\u6ca1\u6709\u66f4\u591a\u4e86`);
      for (let i = listDlg2.length - 1; i >= 0; i--) {
        if (findZhanKaiEl) {
          break;
        }
        const dlg = listDlg2[i];
        const clickDiv = dlg.querySelector(`\u0064\u0069\u0076\u005b\u0064\u0061\u0074\u0061\u002d\u0065\u0032\u0065\u003d\u0022\u0063\u006f\u006e\u0076\u0065\u0072\u0073\u0061\u0074\u0069\u006f\u006e\u002d\u0069\u0074\u0065\u006d\u0022\u005d\u003e\u0064\u0069\u0076\u0020\u003e\u0064\u0069\u0076\u003a\u006e\u0074\u0068\u002d\u0063\u0068\u0069\u006c\u0064\u0028\u0032\u0029`);
        if (clickDiv) {
          findZhanKaiEl = clickDiv;
        }
        noReadHandle(i, dlg);
      }
      break;
    }
  }
  if (findZhanKaiEl) {
    await click_button(findZhanKaiEl);
    await delay(1e3);
  } else {
    sendLog(`\u65e0\u6cd5\u5c55\u5f00`);
    return;
  }
  if (first_PrivateMessage_Stranger) {
    store$1.setRunLogs(`\u7b2c\u4e00\u6761\u662f\u964c\u751f\u4eba`);
    sendLog(`\u7b2c\u4e00\u6761\u662f\u964c\u751f\u4eba\u0020\u5c55\u5f00\u7684`);
    await delay(1e3);
    await handler_PrivateMessage_Stranger();
    return;
  } else {
    if (!(await checkDomPromise(`\u0064\u0069\u0076\u005b\u0064\u0061\u0074\u0061\u002d\u0065\u0032\u0065\u003d\u0022\u006c\u0069\u0073\u0074\u0044\u006c\u0067\u002d\u0063\u006f\u006e\u0074\u0061\u0069\u006e\u0065\u0072\u0022\u005d\u0020\u003e\u0064\u0069\u0076\u0020\u003e\u0073\u0070\u0061\u006e`))) {
      sendLog(`\u6ca1\u6709\u627e\u5230\u0020\u0064\u0069\u0076\u005b\u0064\u0061\u0074\u0061\u002d\u0065\u0032\u0065\u003d\u0022\u006c\u0069\u0073\u0074\u0044\u006c\u0067\u002d\u0063\u006f\u006e\u0074\u0061\u0069\u006e\u0065\u0072\u0022\u005d\u0020\u003e\u0064\u0069\u0076\u0020\u003e\u0073\u0070\u0061\u006e`);
      return;
    }
    const rectEl = document.querySelector(`\u0064\u0069\u0076\u005b\u0064\u0061\u0074\u0061\u002d\u0065\u0032\u0065\u003d\u0022\u006c\u0069\u0073\u0074\u0044\u006c\u0067\u002d\u0063\u006f\u006e\u0074\u0061\u0069\u006e\u0065\u0072\u0022\u005d\u0020\u003e\u0064\u0069\u0076\u0020\u003e\u0073\u0070\u0061\u006e\u0020\u0072\u0065\u0063\u0074`);
    if (rectEl) {
      const y = rectEl.getAttribute(`\u0079`);
      if (!y) {
        store$1.setRunLogs(`\u5c55\u5f00\u7528\u6237\u5217\u8868`);
        const iconEl = document.querySelector(`\u0064\u0069\u0076\u005b\u0064\u0061\u0074\u0061\u002d\u0065\u0032\u0065\u003d\u0022\u006c\u0069\u0073\u0074\u0044\u006c\u0067\u002d\u0063\u006f\u006e\u0074\u0061\u0069\u006e\u0065\u0072\u0022\u005d\u0020\u003e\u0064\u0069\u0076\u0020\u003e\u0073\u0070\u0061\u006e`);
        if (iconEl) {
          await click_button(iconEl);
          await delay(1e3);
        }
      } else {
        console.log(`\u5df2\u7ecf\u5c55\u5f00\u4e86`);
        store$1.setRunLogs(`\u5df2\u7ecf\u5c55\u5f00\u4e86`);
      }
    }
    if (!(await checkDomPromise(`\u0064\u0069\u0076\u005b\u0064\u0061\u0074\u0061\u002d\u0065\u0032\u0065\u003d\u0022\u006c\u0069\u0073\u0074\u0044\u006c\u0067\u002d\u0063\u006f\u006e\u0074\u0061\u0069\u006e\u0065\u0072\u0022\u005d\u003e\u0064\u0069\u0076\u003a\u006e\u0074\u0068\u002d\u0063\u0068\u0069\u006c\u0064\u0028\u0032\u0029\u0020\u003e\u0064\u0069\u0076\u0020\u003e\u0064\u0069\u0076`))) {
      sendLog(`\u6ca1\u6709\u627e\u5230\u0020\u0064\u0069\u0076\u005b\u0064\u0061\u0074\u0061\u002d\u0065\u0032\u0065\u003d\u0022\u006c\u0069\u0073\u0074\u0044\u006c\u0067\u002d\u0063\u006f\u006e\u0074\u0061\u0069\u006e\u0065\u0072\u0022\u005d\u003e\u0064\u0069\u0076\u003a\u006e\u0074\u0068\u002d\u0063\u0068\u0069\u006c\u0064\u0028\u0032\u0029\u0020\u003e\u0064\u0069\u0076\u0020\u003e\u0064\u0069\u0076`);
      return;
    }
  }
  first_PrivateMessage_Stranger = false;
  store$1.setRunLogs(`\u5c55\u5f00\u4e4b\u540e\uff0c\u8bfb\u53d6\u672a\u8bfb\u6570\u636e`);
  sendLog(`\u5c55\u5f00\u4e4b\u540e\uff0c\u8bfb\u53d6\u672a\u8bfb\u6570\u636e`);
  await findFirstMessageToScroll();
  let listDlg = Array.from(document.querySelectorAll(`\u0064\u0069\u0076\u005b\u0064\u0061\u0074\u0061\u002d\u0065\u0032\u0065\u003d\u0022\u006c\u0069\u0073\u0074\u0044\u006c\u0067\u002d\u0063\u006f\u006e\u0074\u0061\u0069\u006e\u0065\u0072\u0022\u005d\u003e\u0064\u0069\u0076\u003a\u006e\u0074\u0068\u002d\u0063\u0068\u0069\u006c\u0064\u0028\u0032\u0029\u0020\u003e\u0064\u0069\u0076\u0020\u003e\u0064\u0069\u0076`));
  let container = document.querySelector(`\u0064\u0069\u0076\u005b\u0064\u0061\u0074\u0061\u002d\u0065\u0032\u0065\u003d\u0022\u006c\u0069\u0073\u0074\u0044\u006c\u0067\u002d\u0063\u006f\u006e\u0074\u0061\u0069\u006e\u0065\u0072\u0022\u005d\u0020\u003e\u0020\u0064\u0069\u0076\u003a\u006e\u0074\u0068\u002d\u0063\u0068\u0069\u006c\u0064\u0028\u0032\u0029`);
  for (let i = 0; i < listDlg.length; i++) {
    const dlg = listDlg[i];
    if (!dlg) {
      continue;
    }
    const divEl = dlg.querySelector(`\u003a\u0073\u0063\u006f\u0070\u0065\u0020\u003e\u0064\u0069\u0076`);
    if (divEl) {
      ensureElementVisible(divEl, container);
    }
    console.log(`\u0064\u006c\u0067`, dlg);
    noReadHandle(i, dlg);
  }
  sendLog(`\u0075\u006e\u0072\u0065\u0061\u0064\u0050\u0072\u0069\u0076\u0061\u0074\u0065\u004d\u0065\u0073\u0073\u0061\u0067\u0065\u004c\u0069\u0073\u0074\u003a` + JSON.stringify(unreadPrivateMessageList));
  const messageList = [];
  if (first_PrivateMessage_Stranger) {
    store$1.setRunLogs(`\u5f00\u59cb\u5904\u7406\u79c1\u4fe1\u964c\u751f\u4eba`);
    sendLog(`\u5f00\u59cb\u5904\u7406\u79c1\u4fe1\u964c\u751f\u4eba`);
    await handler_PrivateMessage_Stranger_list();
  }
  if (!(await checkDomPromise(`\u0064\u0069\u0076\u005b\u0064\u0061\u0074\u0061\u002d\u0065\u0032\u0065\u003d\u0022\u006c\u0069\u0073\u0074\u0044\u006c\u0067\u002d\u0063\u006f\u006e\u0074\u0061\u0069\u006e\u0065\u0072\u0022\u005d\u003e\u0064\u0069\u0076\u003a\u006e\u0074\u0068\u002d\u0063\u0068\u0069\u006c\u0064\u0028\u0032\u0029\u0020\u003e\u0064\u0069\u0076\u0020\u003e\u0064\u0069\u0076`))) {
    sendLog(`\u6ca1\u6709\u627e\u5230\u0020\u0064\u0069\u0076\u005b\u0064\u0061\u0074\u0061\u002d\u0065\u0032\u0065\u003d\u0022\u006c\u0069\u0073\u0074\u0044\u006c\u0067\u002d\u0063\u006f\u006e\u0074\u0061\u0069\u006e\u0065\u0072\u0022\u005d\u003e\u0064\u0069\u0076\u003a\u006e\u0074\u0068\u002d\u0063\u0068\u0069\u006c\u0064\u0028\u0032\u0029\u0020\u003e\u0064\u0069\u0076\u0020\u003e\u0064\u0069\u0076`);
    return;
  }
  sendLog(`\u5c55\u5f00\u4e4b\u540e\uff0c\u5f00\u59cb\u5904\u7406\u6eda\u52a8\u5230\u5bb9\u5668\u7684\u9876\u90e8`);
  store$1.setRunLogs(`\u5c55\u5f00\u4e4b\u540e\uff0c\u5f00\u59cb\u5904\u7406\u6eda\u52a8\u5230\u5bb9\u5668\u7684\u9876\u90e8`);
  await findFirstMessageToScroll();
  sendLog(`\u5c55\u5f00\u4e4b\u540e\uff0c\u5f00\u59cb\u5904\u7406\u672a\u8bfb\u7684\u6570\u636e`);
  store$1.setRunLogs(`\u5c55\u5f00\u4e4b\u540e\uff0c\u5f00\u59cb\u5904\u7406\u672a\u8bfb\u7684\u6570\u636e`);
  listDlg = Array.from(document.querySelectorAll(`\u0064\u0069\u0076\u005b\u0064\u0061\u0074\u0061\u002d\u0065\u0032\u0065\u003d\u0022\u006c\u0069\u0073\u0074\u0044\u006c\u0067\u002d\u0063\u006f\u006e\u0074\u0061\u0069\u006e\u0065\u0072\u0022\u005d\u003e\u0064\u0069\u0076\u003a\u006e\u0074\u0068\u002d\u0063\u0068\u0069\u006c\u0064\u0028\u0032\u0029\u0020\u003e\u0064\u0069\u0076\u0020\u003e\u0064\u0069\u0076`));
  container = document.querySelector(`\u0064\u0069\u0076\u005b\u0064\u0061\u0074\u0061\u002d\u0065\u0032\u0065\u003d\u0022\u006c\u0069\u0073\u0074\u0044\u006c\u0067\u002d\u0063\u006f\u006e\u0074\u0061\u0069\u006e\u0065\u0072\u0022\u005d\u0020\u003e\u0020\u0064\u0069\u0076\u003a\u006e\u0074\u0068\u002d\u0063\u0068\u0069\u006c\u0064\u0028\u0032\u0029`);
  for (let i = 0; i < listDlg.length; i++) {
    const dlg = listDlg[i];
    if (!dlg) {
      continue;
    }
    const divEl = dlg.querySelector(`\u0070\u0072\u0065`);
    if (divEl) {
      ensureElementVisible(divEl, container);
    }
    console.log(`\u0064\u006c\u0067`, dlg);
    const zuoZhiEl = dlg.querySelector(`\u003a\u0073\u0063\u006f\u0070\u0065\u0020\u003e\u0064\u0069\u0076\u0020\u003e\u0064\u0069\u0076\u003e\u0064\u0069\u0076\u003a\u006e\u0074\u0068\u002d\u0063\u0068\u0069\u006c\u0064\u0028\u0032\u0029\u0020\u003e\u0064\u0069\u0076\u003a\u006e\u0074\u0068\u002d\u0063\u0068\u0069\u006c\u0064\u0028\u0031\u0029`);
    let zuoZhiText = ``;
    if (zuoZhiEl) {
      const zuoZhiText2 = (_d = zuoZhiEl.textContent) == null ? void 0 : _d.trim();
      console.log(`\u007a\u0075\u006f\u005a\u0068\u0069\u0054\u0065\u0078\u0074\u0032`, zuoZhiText2);
      if (zuoZhiText2) {
        zuoZhiText = zuoZhiText2;
      }
    }
    const avatarImgEl = dlg.querySelector(`\u0069\u006d\u0067`);
    let avatarPath = ``;
    let avatarUrl = ``;
    if (avatarImgEl) {
      avatarUrl = avatarImgEl.src;
      if (avatarUrl) {
        try {
          if (avatarUrl.startsWith(`\u002f\u002f`)) {
            avatarUrl = `\u0068\u0074\u0074\u0070\u0073\u003a` + avatarUrl;
          }
          const avatarURL = new URL(avatarUrl);
          avatarPath = avatarURL.pathname;
          if (avatarPath) {
            avatarPath = getLastPathName$1(avatarPath);
          } else {
            sendLog(`\u7528\u6237\u5934\u50cf\u4e3a\u7a7a\uff0c\u0070\u0061\u0074\u0068\u006e\u0061\u006d\u0065\u003a` + avatarPath);
          }
        } catch (error) {
          sendLog(`\u7528\u6237\u5934\u50cf\u4e3a\u7a7a\u0020\u0075\u0072\u006c\u0020\u9519\u8bef\u0020` + avatarUrl);
        }
      } else {
        sendLog(`\u7528\u6237\u5934\u50cf\u7684\u5730\u5740\u4e0d\u662f\u0055\u0072\u006c\u003a` + avatarUrl);
      }
    } else {
      sendLog(`\u6ca1\u6709\u627e\u5230\u7528\u6237\u5934\u50cf`);
    }
    const messageData = {};
    messageData[`\u0075\u0073\u0065\u0072\u004e\u0061\u006d\u0065`] = zuoZhiText;
    messageData[`\u0061\u0076\u0061\u0074\u0061\u0072`] = avatarUrl;
    messageData[`\u0061\u0076\u0061\u0074\u0061\u0072\u0050\u0061\u0074\u0068`] = avatarPath;
    messageData[`\u0073\u006f\u0075\u0072\u0063\u0065`] = `\u6296\u97f3`;
    messageData[`\u0063\u006c\u0075\u0065\u0054\u0079\u0070\u0065`] = `\u79c1\u4fe1`;
    const preEl = dlg.querySelector(`\u0070\u0072\u0065`);
    let preText = ``;
    if (preEl) {
      const preText2 = (_e = preEl.textContent) == null ? void 0 : _e.trim();
      console.log(`\u0068\u0061\u006e\u0064\u006c\u0065\u005f\u0050\u0072\u0069\u0076\u0061\u0074\u0065\u004d\u0065\u0073\u0073\u0061\u0067\u0065\u0020\u0070\u0072\u0065\u0054\u0065\u0078\u0074`, preText2);
      if (preText2) {
        preText = preText2;
      }
      messageData[`\u0063\u006f\u006e\u0074\u0065\u006e\u0074`] = preText;
    }
    sendLog(`\u0075\u006e\u0072\u0065\u0061\u0064\u0050\u0072\u0069\u0076\u0061\u0074\u0065\u004d\u0065\u0073\u0073\u0061\u0067\u0065\u004c\u0069\u0073\u0074\u002e\u0069\u006e\u0063\u006c\u0075\u0064\u0065\u0073\uff1a` + unreadPrivateMessageList.includes(zuoZhiText + preText) + `\u002d\u002d` + zuoZhiText + preText);
    if (!unreadPrivateMessageList.includes(zuoZhiText + preText)) {
      sendLog(`\u4e0d\u662f\u672a\u8bfb\u7684\u0020\uff1a` + zuoZhiText + preText);
      continue;
    }
    const timeEl = dlg.querySelector(`\u003a\u0073\u0063\u006f\u0070\u0065\u0020\u003e\u0064\u0069\u0076\u0020\u003e\u0064\u0069\u0076\u003e\u0064\u0069\u0076\u003a\u006e\u0074\u0068\u002d\u0063\u0068\u0069\u006c\u0064\u0028\u0032\u0029\u0020\u003e\u0064\u0069\u0076\u003a\u006e\u0074\u0068\u002d\u0063\u0068\u0069\u006c\u0064\u0028\u0032\u0029\u0020\u003e\u0064\u0069\u0076\u003a\u006e\u0074\u0068\u002d\u0063\u0068\u0069\u006c\u0064\u0028\u0032\u0029`);
    if (timeEl) {
      const timeText = (_f = timeEl.textContent) == null ? void 0 : _f.trim();
      console.log(`\u0074\u0069\u006d\u0065\u0054\u0065\u0078\u0074`, timeText);
      messageData[`\u0074\u0069\u006d\u0065\u0054\u0065\u0078\u0074`] = timeText;
    }
    const clickDiv = dlg.querySelector(`\u0064\u0069\u0076\u005b\u0064\u0061\u0074\u0061\u002d\u0065\u0032\u0065\u003d\u0022\u0063\u006f\u006e\u0076\u0065\u0072\u0073\u0061\u0074\u0069\u006f\u006e\u002d\u0069\u0074\u0065\u006d\u0022\u005d\u003e\u0064\u0069\u0076\u0020\u003e\u0064\u0069\u0076\u003a\u006e\u0074\u0068\u002d\u0063\u0068\u0069\u006c\u0064\u0028\u0032\u0029`);
    if (!clickDiv) {
      sendLog(`\u6ca1\u6709\u627e\u5230\u0063\u006c\u0069\u0063\u006b\u0044\u0069\u0076`);
      continue;
    }
    await click_button(clickDiv);
    await delay(1e3);
    const preText3 = await getUserSendReplyContent();
    if (preText3) {
      messageData[`\u0063\u006f\u006e\u0074\u0065\u006e\u0074`] = preText3;
    }
    const date = /* @__PURE__ */new Date();
    const year = date.getFullYear();
    const month = String(date.getMonth() + 1).padStart(2, `\u0030`);
    const day = String(date.getDate()).padStart(2, `\u0030`);
    const hours = String(date.getHours()).padStart(2, `\u0030`);
    const minutes = String(date.getMinutes()).padStart(2, `\u0030`);
    messageData[`\u0063\u0072\u0065\u0061\u0074\u0065\u0044\u0061\u0074\u0065`] = `${year}\u002d${month}\u002d${day}\u0020${hours}\u003a${minutes}`;
    messageData[`\u0061\u0064\u0064\u0054\u0069\u006d\u0065`] = (/* @__PURE__ */new Date()).getTime();
    messageData[`\u0074\u0065\u006e\u0061\u006e\u0074\u0049\u0064`] = store$1.tenantId;
    messageData[`\u0075\u0073\u0065\u0072\u0049\u0064`] = store$1.userId;
    messageData[`\u0061\u0067\u0065\u006e\u0074\u0049\u0064`] = VITE_AGENT_ID;
    messageData[`\u0074\u0061\u0073\u006b\u0049\u0064`] = store$1.taskId;
    messageData[`\u0065\u0078\u0065\u0063\u0075\u0074\u0065\u0049\u0064`] = store$1.executeId;
    messageData[`\u0074\u0065\u0072\u006d\u0069\u006e\u0061\u006c\u0049\u0064`] = (_g = store$1.terminalData) == null ? void 0 : _g.terminalId;
    messageData[`\u0077\u0065\u0062\u0055\u0073\u0065\u0072\u0049\u0064`] = store$1.webUserId;
    messageData[`\u0077\u0065\u0062\u0055\u0073\u0065\u0072\u004e\u0061\u006d\u0065`] = store$1.webUserName;
    if (messageData && messageData[`\u0063\u006f\u006e\u0074\u0065\u006e\u0074`]) {
      store$1.setContentText(messageData[`\u0063\u006f\u006e\u0074\u0065\u006e\u0074`]);
      const textContent = messageData[`\u0063\u006f\u006e\u0074\u0065\u006e\u0074`];
      const contentArray = Array.from(textContent);
      console.log(`\u0063\u006f\u006e\u0074\u0065\u006e\u0074\u0041\u0072\u0072\u0061\u0079`, contentArray);
      const phoneNums = extractPhoneNumbers(textContent);
      const optionWhere = store$1.getOptionWhere();
      console.log(`\u0070\u0068\u006f\u006e\u0065\u004e\u0075\u006d\u0073`, phoneNums);
      if (phoneNums.length > 0) {
        messageData[`\u0063\u006f\u006e\u0074\u0061\u0063\u0074\u0049\u006e\u0066\u006f\u0072\u006d\u0061\u0074\u0069\u006f\u006e`] = phoneNums[0];
        messageData[`\u0063\u006f\u006e\u0074\u0061\u0063\u0074\u0049\u006e\u0066\u006f\u0072\u006d\u0061\u0074\u0069\u006f\u006e\u0042\u006f\u006f\u006c`] = 1;
      }
      chrome.storage.local.set({
        "douYinDataList": JSON.stringify(messageData)
      });
      const userData = await get_PrivateMessage_userId(avatarPath, zuoZhiText);
      let userFirstCommentBool = false;
      if (optionWhere.enableFirstReplyBool) {
        sendLog(`\u4f7f\u7528\u8f6f\u4ef6\u7a0b\u5e8f\u8fdb\u884c\u0020\u79c1\u4fe1\u5efa\u7acb\u56de\u590d\u8bdd\u672f`);
        userFirstCommentBool = await query_user_chat_num(userData[`\u0075\u0073\u0065\u0072\u0049\u0064`]);
      }
      messageData[`\u0063\u006f\u006e\u0074\u0065\u006e\u0074\u0057\u0065\u0062\u0055\u0073\u0065\u0072\u0049\u0064`] = userData[`\u0077\u0065\u0062\u0055\u0073\u0065\u0072\u0049\u0064`];
      messageData[`\u0063\u006f\u006e\u0074\u0065\u006e\u0074\u0055\u0073\u0065\u0072\u0049\u0064`] = userData[`\u0075\u0073\u0065\u0072\u0049\u0064`];
      if (userFirstCommentBool) {
        if (optionWhere.enableFirstReplyBool && (optionWhere.phoneNumberReplyContent || optionWhere.phoneNumberReplyContent1 || optionWhere.phoneNumberReplyContent3)) {
          sendLog(`\u7b2c\u4e00\u6b21\u56de\u590d`);
          store$1.setRunLogs(`\u7b2c\u4e00\u6b21\u56de\u590d`);
          const chatList = [{
            // 发送id
            "sender": userData[`\u0077\u0065\u0062\u0055\u0073\u0065\u0072\u0049\u0064`] ? userData[`\u0077\u0065\u0062\u0055\u0073\u0065\u0072\u0049\u0064`] : userData[`\u0075\u0073\u0065\u0072\u0049\u0064`],
            // 发送人的名称
            "sender_name": messageData[`\u0075\u0073\u0065\u0072\u004e\u0061\u006d\u0065`],
            "sender_avatar": messageData[`\u0061\u0076\u0061\u0074\u0061\u0072`],
            // 接收人id
            "receiver": store$1.webUserId,
            // 接收人的id
            "receiver_name": store$1.webUserName,
            "receiver_avatar": store$1.webUserAvatarUrl,
            // 发送内容
            "content": messageData[`\u0063\u006f\u006e\u0074\u0065\u006e\u0074`]
          }];
          if (optionWhere.phoneNumberReplyContent1) {
            store$1.setRunLogs(`\u56de\u590d\u5185\u5bb9\uff1a` + optionWhere.phoneNumberReplyContent1);
            await replyContent_PrivateMessage(optionWhere.phoneNumberReplyContent1);
            await delay(getRandomNumberInRange(3e3, 5e3));
            chatList.push({
              // 发送id
              "sender": store$1.webUserId,
              // 发送人的名称
              "sender_name": store$1.webUserName,
              "sender_avatar": store$1.webUserAvatarUrl,
              // 接收人id
              "receiver": userData[`\u0077\u0065\u0062\u0055\u0073\u0065\u0072\u0049\u0064`] ? userData[`\u0077\u0065\u0062\u0055\u0073\u0065\u0072\u0049\u0064`] : userData[`\u0075\u0073\u0065\u0072\u0049\u0064`],
              // 接收人的id
              "receiver_name": messageData[`\u0075\u0073\u0065\u0072\u004e\u0061\u006d\u0065`],
              "receiver_avatar": messageData[`\u0061\u0076\u0061\u0074\u0061\u0072`],
              // 发送内容
              "content": optionWhere.phoneNumberReplyContent1
            });
            store$1.setReplyComment(optionWhere.phoneNumberReplyContent1);
          }
          if (optionWhere.phoneNumberReplyContent) {
            store$1.setRunLogs(`\u56de\u590d\u5185\u5bb9\uff1a` + optionWhere.phoneNumberReplyContent);
            await replyContent_PrivateMessage(optionWhere.phoneNumberReplyContent);
            await delay(getRandomNumberInRange(3e3, 5e3));
            chatList.push({
              // 发送id
              "sender": store$1.webUserId,
              // 发送人的名称
              "sender_name": store$1.webUserName,
              "sender_avatar": store$1.webUserAvatarUrl,
              // 接收人id
              "receiver": userData[`\u0077\u0065\u0062\u0055\u0073\u0065\u0072\u0049\u0064`] ? userData[`\u0077\u0065\u0062\u0055\u0073\u0065\u0072\u0049\u0064`] : userData[`\u0075\u0073\u0065\u0072\u0049\u0064`],
              // 接收人的id
              "receiver_name": messageData[`\u0075\u0073\u0065\u0072\u004e\u0061\u006d\u0065`],
              "receiver_avatar": messageData[`\u0061\u0076\u0061\u0074\u0061\u0072`],
              // 发送内容
              "content": optionWhere.phoneNumberReplyContent
            });
            store$1.setReplyComment(optionWhere.phoneNumberReplyContent);
          }
          if (optionWhere.phoneNumberReplyContent3) {
            store$1.setRunLogs(`\u56de\u590d\u5185\u5bb9\uff1a` + optionWhere.phoneNumberReplyContent3);
            await replyContent_PrivateMessage(optionWhere.phoneNumberReplyContent3);
            chatList.push({
              // 发送id
              "sender": store$1.webUserId,
              // 发送人的名称
              "sender_name": store$1.webUserName,
              "sender_avatar": store$1.webUserAvatarUrl,
              // 接收人id
              "receiver": userData[`\u0077\u0065\u0062\u0055\u0073\u0065\u0072\u0049\u0064`] ? userData[`\u0077\u0065\u0062\u0055\u0073\u0065\u0072\u0049\u0064`] : userData[`\u0075\u0073\u0065\u0072\u0049\u0064`],
              // 接收人的id
              "receiver_name": messageData[`\u0075\u0073\u0065\u0072\u004e\u0061\u006d\u0065`],
              "receiver_avatar": messageData[`\u0061\u0076\u0061\u0074\u0061\u0072`],
              // 发送内容
              "content": optionWhere.phoneNumberReplyContent3
            });
            store$1.setReplyComment(optionWhere.phoneNumberReplyContent3);
          }
          await delay(getRandomNumberInRange(2 * 1e3, 10 * 1e3));
          messageData[`\u0072\u0065\u0070\u006c\u0079\u0054\u0065\u0078\u0074`] = optionWhere.phoneNumberReplyContent;
          messageData[`\u0072\u0065\u0070\u006c\u0079\u0054\u0079\u0070\u0065`] = `\u0066\u0069\u0072\u0073\u0074`;
          messageList.push(messageData);
          await delay(1e3);
          const key = `\u0068\u0061\u006e\u0064\u006c\u0065\u0072\u005f\u0050\u0072\u0069\u0076\u0061\u0074\u0065\u004d\u0065\u0073\u0073\u0061\u0067\u0065\u005f\u0053\u0074\u0072\u0061\u006e\u0067\u0065\u0072\u005f` + (/* @__PURE__ */new Date()).getTime();
          const postDataObj = {
            "key": key,
            "bucket": messageData,
            "size": 0,
            "content_type": ``,
            "belong_to": store$1.userId + `\u005f\u0064\u006f\u0075\u0059\u0069\u006e\u004c\u0069\u0073\u0074`,
            "object_metadata": {}
          };
          await addObjects(postDataObj);
          store$1.setRunLogs(`\u4fdd\u5b58\u7edf\u4e00\u805a\u5408\u4fe1\u606f`);
          await saveChat({
            "session": {
              // 登录网站用户id
              "account_id": store$1.webUserId,
              // 视频名称
              "video_name": ``,
              // 视频地址
              "video_url": ``,
              // 会话来源，通知和私信
              "source": `\u79c1\u4fe1`
            },
            "chat_list": chatList
          });
        } else {
          store$1.setRunLogs(`\u7b2c\u4e00\u6b21\u0020\u6ca1\u6709\u56de\u590d\u7684\u5185\u5bb9`);
          sendLog(`\u7b2c\u4e00\u6b21\u0020\u6ca1\u6709\u56de\u590d\u7684\u5185\u5bb9`);
        }
      } else {
        sendLog(`\u7b2c\u4e8c\u6b21\u56de\u590d\u0020\u8c03\u7528\u5bf9\u8bdd\uff0c\u83b7\u53d6\u56de\u590d\u5185\u5bb9`);
        store$1.setRunLogs(`\u7b2c\u4e8c\u6b21\u56de\u590d\u0020\u8c03\u7528\u5bf9\u8bdd\uff0c\u83b7\u53d6\u56de\u590d\u5185\u5bb9`);
        const msgItemContentListEl = Array.from(document.querySelectorAll(`\u0064\u0069\u0076\u005b\u0064\u0061\u0074\u0061\u002d\u0065\u0032\u0065\u003d\u0022\u006d\u0073\u0067\u002d\u0069\u0074\u0065\u006d\u002d\u0063\u006f\u006e\u0074\u0065\u006e\u0074\u0022\u005d`));
        const textContentList = [];
        for (let j = 0; j < msgItemContentListEl.length; j++) {
          const textContent2 = (_h = msgItemContentListEl[0].textContent) == null ? void 0 : _h.trim();
          if (textContent2 && textContent2 != messageData[`\u0063\u006f\u006e\u0074\u0065\u006e\u0074`]) {
            textContentList.push(textContent2);
          }
        }
        console.log(`\u0074\u0065\u0078\u0074\u0043\u006f\u006e\u0074\u0065\u006e\u0074\u004c\u0069\u0073\u0074\uff1a`, textContentList);
        let contentText = await getCorpusContentText(messageData);
        if (contentText == `\u5df2\u7ecf\u53d6\u5f97\u8054\u7cfb\u65b9\u5f0f`) {
          sendLog(`\u5df2\u7ecf\u53d6\u5f97\u8054\u7cfb\u65b9\u5f0f\u0020\u4e0d\u5728\u56de\u590d`);
          contentText = `\u6536\u5230\uff0c\u6211\u4eec\u4f1a\u5c3d\u5feb\u8054\u7cfb\u60a8\u3002`;
        }
        if (optionWhere.keFuNullReplyContent && !contentText) {
          contentText = optionWhere.keFuNullReplyContent;
          sendLog(`\u56de\u590d\u7684\u5185\u5bb9\u4e3a\u7a7a\uff0c\u4f7f\u7528\u515c\u5e95\u7684\u56de\u590d\u5185\u5bb9\uff0c\u0020\u006b\u0065\u0046\u0075\u004e\u0075\u006c\u006c\u0052\u0065\u0070\u006c\u0079\u0043\u006f\u006e\u0074\u0065\u006e\u0074\uff1a` + optionWhere.keFuNullReplyContent);
          messageData[`\u006b\u0065\u0046\u0075\u004e\u0075\u006c\u006c\u0052\u0065\u0070\u006c\u0079\u0043\u006f\u006e\u0074\u0065\u006e\u0074`] = `\u0079\u0065\u0073`;
        }
        if (!contentText) {
          sendLog(`\u56de\u590d\u7684\u5185\u5bb9\u4e3a\u7a7a\uff0c\u4e0d\u9700\u8981\u56de\u590d`);
          store$1.setRunLogs(`\u56de\u590d\u7684\u5185\u5bb9\u4e3a\u7a7a\uff0c\u4e0d\u9700\u8981\u56de\u590d`);
        } else {
          store$1.setRunLogs(`\u56de\u590d\u7684\u5185\u5bb9\uff1a` + contentText);
          sendLog(`\u56de\u590d\u7684\u5185\u5bb9\uff1a` + contentText);
          messageData[`\u0072\u0065\u0070\u006c\u0079\u0054\u0065\u0078\u0074`] = contentText;
          messageData[`\u0072\u0065\u0070\u006c\u0079\u0054\u0079\u0070\u0065`] = `\u0073\u0065\u0063\u006f\u006e\u0064`;
          await replyContent_PrivateMessage(contentText);
          store$1.setReplyComment(contentText);
          await delay(1e3);
          const key = `\u0068\u0061\u006e\u0064\u006c\u0065\u0072\u005f\u0050\u0072\u0069\u0076\u0061\u0074\u0065\u004d\u0065\u0073\u0073\u0061\u0067\u0065\u005f\u0053\u0074\u0072\u0061\u006e\u0067\u0065\u0072\u005f` + (/* @__PURE__ */new Date()).getTime();
          const postDataObj = {
            "key": key,
            "bucket": messageData,
            "size": 0,
            "content_type": ``,
            "belong_to": store$1.userId + `\u005f\u0064\u006f\u0075\u0059\u0069\u006e\u004c\u0069\u0073\u0074`,
            "object_metadata": {}
          };
          await addObjects(postDataObj);
          const chatList = [{
            // 发送id
            "sender": userData[`\u0077\u0065\u0062\u0055\u0073\u0065\u0072\u0049\u0064`] ? userData[`\u0077\u0065\u0062\u0055\u0073\u0065\u0072\u0049\u0064`] : userData[`\u0075\u0073\u0065\u0072\u0049\u0064`],
            // 发送人的名称
            "sender_name": messageData[`\u0075\u0073\u0065\u0072\u004e\u0061\u006d\u0065`],
            "sender_avatar": messageData[`\u0061\u0076\u0061\u0074\u0061\u0072`],
            // 接收人id
            "receiver": store$1.webUserId,
            // 接收人的id
            "receiver_name": store$1.webUserName,
            "receiver_avatar": store$1.webUserAvatarUrl,
            // 发送内容
            "content": messageData[`\u0063\u006f\u006e\u0074\u0065\u006e\u0074`]
          }, {
            // 发送id
            "sender": store$1.webUserId,
            // 发送人的名称
            "sender_name": store$1.webUserName,
            "sender_avatar": store$1.webUserAvatarUrl,
            // 接收人id
            "receiver": userData[`\u0077\u0065\u0062\u0055\u0073\u0065\u0072\u0049\u0064`] ? userData[`\u0077\u0065\u0062\u0055\u0073\u0065\u0072\u0049\u0064`] : userData[`\u0075\u0073\u0065\u0072\u0049\u0064`],
            // 接收人的id
            "receiver_name": messageData[`\u0075\u0073\u0065\u0072\u004e\u0061\u006d\u0065`],
            "receiver_avatar": messageData[`\u0061\u0076\u0061\u0074\u0061\u0072`],
            // 发送内容
            "content": contentText
          }];
          store$1.setRunLogs(`\u4fdd\u5b58\u7edf\u4e00\u805a\u5408\u4fe1\u606f`);
          await saveChat({
            "session": {
              // 登录网站用户id
              "account_id": store$1.webUserId,
              // 视频名称
              "video_name": ``,
              // 视频地址
              "video_url": ``,
              // 会话来源，通知和私信
              "source": `\u79c1\u4fe1`
            },
            "chat_list": chatList
          });
        }
      }
    } else {
      sendLog(`\u006d\u0065\u0073\u0073\u0061\u0067\u0065\u0044\u0061\u0074\u0061\u005b\u0027\u0063\u006f\u006e\u0074\u0065\u006e\u0074\u0027\u005d\u0020\u4e0d\u4e3a\u771f`);
      store$1.setRunLogs(`\u6ca1\u6709\u79c1\u4fe1\u5185\u5bb9`);
    }
  }
  console.log(`\u0068\u0061\u006e\u0064\u006c\u0065\u005f\u0050\u0072\u0069\u0076\u0061\u0074\u0065\u004d\u0065\u0073\u0073\u0061\u0067\u0065\u0020\u006d\u0065\u0073\u0073\u0061\u0067\u0065\u004c\u0069\u0073\u0074`, messageList);
  sendLog(`\u0066\u0069\u0072\u0073\u0074\u005f\u0050\u0072\u0069\u0076\u0061\u0074\u0065\u004d\u0065\u0073\u0073\u0061\u0067\u0065\u005f\u0053\u0074\u0072\u0061\u006e\u0067\u0065\u0072\uff1a` + first_PrivateMessage_Stranger);
  if (!first_PrivateMessage_Stranger) {
    sendLog(`\u5f00\u59cb\u5904\u7406\u79c1\u4fe1\u964c\u751f\u4eba`);
    store$1.setRunLogs(`\u5f00\u59cb\u5904\u7406\u79c1\u4fe1\u964c\u751f\u4eba`);
    await handler_PrivateMessage_Stranger_list();
  }
  const loginOutEls = Array.from(document.querySelectorAll(`\u0064\u0069\u0076\u005b\u0064\u0061\u0074\u0061\u002d\u006d\u0061\u0073\u006b\u003d\u0022\u0063\u006f\u006e\u0076\u0065\u0072\u0073\u0061\u0074\u006f\u006e\u002d\u0064\u0065\u0074\u0061\u0069\u006c\u002d\u0063\u006f\u006e\u0074\u0065\u006e\u0074\u0022\u005d\u0020\u003e\u0064\u0069\u0076\u0020\u003e\u0073\u0070\u0061\u006e`));
  if (loginOutEls) {
    for (let i = 0; i < loginOutEls.length; i++) {
      const loginOutEl = loginOutEls[i];
      if (!loginOutEl) {
        continue;
      }
      if (((_i = loginOutEl.textContent) == null ? void 0 : _i.trim()) == `\u9000\u51fa\u4f1a\u8bdd`) {
        await click_button(loginOutEls[i]);
        sendLog(`\u9000\u51fa\u4f1a\u8bdd`);
        console.log(`\u9000\u51fa\u4f1a\u8bdd`);
      }
    }
  }
};
function compareHalves(str) {
  if (!str) {
    return str;
  }
  const length = str.length;
  if (length % 2 !== 0) {
    return str;
  }
  const halfLength = length / 2;
  const firstHalf = str.slice(0, halfLength);
  const secondHalf = str.slice(halfLength);
  return firstHalf === secondHalf ? firstHalf : str;
}
const getUserSendReplyContent = async () => {
  var _a;
  if (!(await checkDomPromise(`\u0023\u006d\u0065\u0073\u0073\u0061\u0067\u0065\u0043\u006f\u006e\u0074\u0065\u006e\u0074\u0020\u003e\u0064\u0069\u0076\u0020\u003e\u0064\u0069\u0076`))) {
    sendLog(`\u6ca1\u6709\u627e\u5230\u0020\u0023\u006d\u0065\u0073\u0073\u0061\u0067\u0065\u0043\u006f\u006e\u0074\u0065\u006e\u0074\u0020\u003e\u0064\u0069\u0076\u0020\u003e\u0064\u0069\u0076`);
    return;
  }
  const messageContentList = Array.from(document.querySelectorAll(`\u0023\u006d\u0065\u0073\u0073\u0061\u0067\u0065\u0043\u006f\u006e\u0074\u0065\u006e\u0074\u0020\u003e\u0064\u0069\u0076\u0020\u003e\u0064\u0069\u0076`));
  let textContentTotal = ``;
  for (let j = 0; j < messageContentList.length; j++) {
    let textContentBool = false;
    console.log(`\u006d\u0065\u0073\u0073\u0061\u0067\u0065\u0043\u006f\u006e\u0074\u0065\u006e\u0074\u004c\u0069\u0073\u0074\u005b\u006a\u005d`, messageContentList[j]);
    const messageContent = messageContentList[j];
    const divList = Array.from(messageContent.querySelectorAll(`\u003a\u0073\u0063\u006f\u0070\u0065\u0020\u003e\u0064\u0069\u0076`));
    console.log(`\u0064\u0069\u0076\u004c\u0069\u0073\u0074`, divList);
    if (!divList || divList.length == 0) {
      continue;
    }
    if (divList && divList.length >= 1) {
      for (let i = 0; i < divList.length; i++) {
        const computedStyle = window.getComputedStyle(divList[i]);
        const justifyContentValue = computedStyle.getPropertyValue(`\u006a\u0075\u0073\u0074\u0069\u0066\u0079\u002d\u0063\u006f\u006e\u0074\u0065\u006e\u0074`);
        if (justifyContentValue) {
          if (justifyContentValue == `\u0073\u0070\u0061\u0063\u0065\u002d\u0062\u0065\u0074\u0077\u0065\u0065\u006e`) {
            console.log(`\u5143\u7d20\u0020${divList[i].tagName}\u0020\u5b58\u5728\u0020\u006a\u0075\u0073\u0074\u0069\u0066\u0079\u002d\u0063\u006f\u006e\u0074\u0065\u006e\u0074\u0020\u6837\u5f0f\uff0c\u503c\u4e3a\u003a\u0020${justifyContentValue}`);
            let textContent = (_a = divList[i].textContent) == null ? void 0 : _a.trim();
            console.log(`\u0074\u0065\u0078\u0074\u0043\u006f\u006e\u0074\u0065\u006e\u0074`, textContent);
            if (textContent && textContent == `\u6211\u53d1\u5e03\u4e86\u65b0\u4f5c\u54c1\uff0c\u5feb\u6765\u770b\u770b\uff01`) {
              textContentBool = true;
              continue;
            }
            textContentBool = true;
            textContent = textContent == null ? void 0 : textContent.replace(`\u70b9\u8d5e\u70b9\u8d5e\u56de\u590d\u5220\u9664`, ``);
            textContent = textContent == null ? void 0 : textContent.replace(`\u70b9\u8d5e\u56de\u590d\u5220\u9664`, ``);
            textContent = compareHalves(textContent);
            textContentTotal += textContent;
          } else {
            console.log(`\u006a\u0075\u0073\u0074\u0069\u0066\u0079\u0043\u006f\u006e\u0074\u0065\u006e\u0074\u0056\u0061\u006c\u0075\u0065\u0020\u4e0d\u662f\u0020\u0073\u0070\u0061\u0063\u0065\u002d\u0062\u0065\u0074\u0077\u0065\u0065\u006e`, justifyContentValue);
          }
        } else {
          console.log(`\u5143\u7d20\u0020${divList[i].tagName}\u0020\u4e0d\u5b58\u5728\u0020\u006a\u0075\u0073\u0074\u0069\u0066\u0079\u002d\u0063\u006f\u006e\u0074\u0065\u006e\u0074\u0020\u6837\u5f0f`);
        }
      }
    }
    if (!textContentBool) {
      break;
    }
  }
  sendLog(`\u0074\u0065\u0078\u0074\u0043\u006f\u006e\u0074\u0065\u006e\u0074\u0054\u006f\u0074\u0061\u006c\u003a\u0020` + textContentTotal);
  return textContentTotal;
};
const update_Private_userId = async (key, bucket) => {
  const user_list_key = store$1.userId + `\u005f` + store$1.webUserId + `\u005f\u0064\u006f\u0075\u0059\u0069\u006e\u005f\u0077\u0065\u0062\u005f\u0075\u0073\u0065\u0072\u005f\u006c\u0069\u0073\u0074`;
  const postDataObj = {
    "key": key,
    "bucket": bucket,
    "size": 0,
    "content_type": ``,
    "belong_to": user_list_key,
    "object_metadata": {}
  };
  await addObjects(postDataObj);
};
const get_PrivateMessage_userId = async (avatarPath, zuoZhiText, webUserId = ``) => {
  try {
    const user_list_key = store$1.userId + `\u005f` + store$1.webUserId + `\u005f\u0064\u006f\u0075\u0059\u0069\u006e\u005f\u0077\u0065\u0062\u005f\u0075\u0073\u0065\u0072\u005f\u006c\u0069\u0073\u0074`;
    const userData = {
      key: ``,
      webUserId: ``,
      userId: ``,
      bucket: {}
    };
    let userRes = null;
    if (webUserId) {
      userRes = await queryObjects([{
        key: `\u0062\u0065\u006c\u006f\u006e\u0067\u005f\u0074\u006f`,
        value: user_list_key
      }, {
        key: `\u0066\u0072\u0069\u0065\u006e\u0064\u0073\u0055\u0073\u0065\u0072\u0049\u0064`,
        value: store$1.webUserId
      }, {
        key: `\u0077\u0065\u0062\u0055\u0073\u0065\u0072\u0049\u0064`,
        value: webUserId
      }]);
      console.log(`\u0071\u0075\u0065\u0072\u0079\u004f\u0062\u006a\u0065\u0063\u0074\u0073\u0020\u0075\u0073\u0065\u0072\u0052\u0065\u0073`, userRes);
    } else {
      userRes = await queryObjects([{
        key: `\u0062\u0065\u006c\u006f\u006e\u0067\u005f\u0074\u006f`,
        value: user_list_key
      }, {
        key: `\u0066\u0072\u0069\u0065\u006e\u0064\u0073\u0055\u0073\u0065\u0072\u0049\u0064`,
        value: store$1.webUserId
      }, {
        key: `\u0061\u0076\u0061\u0074\u0061\u0072\u0050\u0061\u0074\u0068`,
        value: avatarPath
      }]);
      console.log(`\u0071\u0075\u0065\u0072\u0079\u004f\u0062\u006a\u0065\u0063\u0074\u0073\u0020\u0075\u0073\u0065\u0072\u0052\u0065\u0073`, userRes);
    }
    if ((userRes == null ? void 0 : userRes.items) && (userRes == null ? void 0 : userRes.items.length) == 0) {
      userRes = await queryObjects([{
        key: `\u0062\u0065\u006c\u006f\u006e\u0067\u005f\u0074\u006f`,
        value: user_list_key
      }, {
        key: `\u0066\u0072\u0069\u0065\u006e\u0064\u0073\u0055\u0073\u0065\u0072\u0049\u0064`,
        value: store$1.webUserId
      }, {
        key: `\u0061\u0076\u0061\u0074\u0061\u0072\u0050\u0061\u0074\u0068`,
        value: avatarPath
      }]);
      console.log(`\u0071\u0075\u0065\u0072\u0079\u004f\u0062\u006a\u0065\u0063\u0074\u0073\u0020\u0075\u0073\u0065\u0072\u0052\u0065\u0073`, userRes);
    }
    if ((userRes == null ? void 0 : userRes.items) && (userRes == null ? void 0 : userRes.items.length) == 0) {
      userRes = await queryObjects([{
        key: `\u0062\u0065\u006c\u006f\u006e\u0067\u005f\u0074\u006f`,
        value: user_list_key
      }, {
        key: `\u0066\u0072\u0069\u0065\u006e\u0064\u0073\u0055\u0073\u0065\u0072\u0049\u0064`,
        value: store$1.webUserId
      }, {
        key: `\u0075\u0073\u0065\u0072\u004e\u0061\u006d\u0065`,
        value: zuoZhiText
      }]);
      if ((userRes == null ? void 0 : userRes.items.length) > 1) {
        sendLog(`\u4f7f\u7528\u0020\u007a\u0075\u006f\u005a\u0068\u0069\u0054\u0065\u0078\u0074\u003a${zuoZhiText}\u67e5\u8be2\u5230\u7684\u6570\u636e\u6761\u6570\u5927\u4e8e\u0031\uff1a` + (userRes == null ? void 0 : userRes.items.length));
      }
    } else {
      if ((userRes == null ? void 0 : userRes.items.length) > 1) {
        sendLog(`\u4f7f\u7528\u0020\u0061\u0076\u0061\u0074\u0061\u0072\u0050\u0061\u0074\u0068\u003a${avatarPath}\u67e5\u8be2\u5230\u7684\u6570\u636e\u6761\u6570\u5927\u4e8e\u0031\uff1a` + (userRes == null ? void 0 : userRes.items.length));
      }
    }
    if ((userRes == null ? void 0 : userRes.items) && (userRes == null ? void 0 : userRes.items.length) == 0) {
      userData[`\u0075\u0073\u0065\u0072\u0049\u0064`] = `\u0064\u006f\u0075\u0059\u0069\u006e` + (/* @__PURE__ */new Date()).getTime();
      const key = `\u0064\u006f\u0075\u0059\u0069\u006e\u005f\u0077\u0065\u0062\u005f\u0075\u0073\u0065\u0072\u005f\u006c\u0069\u0073\u0074\u005f` + (/* @__PURE__ */new Date()).getTime();
      const postDataObj = {
        "key": key,
        "bucket": {
          // 自定义的用户Id
          userId: userData[`\u0075\u0073\u0065\u0072\u0049\u0064`],
          // 评论或私信的用户Id
          webUserId,
          // 网站登录的用户Id
          friendsUserId: store$1.webUserId,
          // 评论作者名称
          userName: zuoZhiText,
          // 评论头像地址
          avatarPath
        },
        "size": 0,
        "content_type": ``,
        "belong_to": user_list_key,
        "object_metadata": {}
      };
      userData[`\u006b\u0065\u0079`] = postDataObj[`\u006b\u0065\u0079`];
      userData[`\u0077\u0065\u0062\u0055\u0073\u0065\u0072\u0049\u0064`] = postDataObj[`\u0062\u0075\u0063\u006b\u0065\u0074`][`\u0077\u0065\u0062\u0055\u0073\u0065\u0072\u0049\u0064`];
      userData[`\u0075\u0073\u0065\u0072\u0049\u0064`] = postDataObj[`\u0062\u0075\u0063\u006b\u0065\u0074`][`\u0075\u0073\u0065\u0072\u0049\u0064`];
      userData[`\u0062\u0075\u0063\u006b\u0065\u0074`] = postDataObj[`\u0062\u0075\u0063\u006b\u0065\u0074`];
      await addObjects(postDataObj);
    } else {
      const item = userRes == null ? void 0 : userRes.items[0];
      userData[`\u006b\u0065\u0079`] = item[`\u006b\u0065\u0079`];
      if (item[`\u0062\u0075\u0063\u006b\u0065\u0074`] && item[`\u0062\u0075\u0063\u006b\u0065\u0074`][`\u0077\u0065\u0062\u0055\u0073\u0065\u0072\u0049\u0064`]) {
        userData[`\u0077\u0065\u0062\u0055\u0073\u0065\u0072\u0049\u0064`] = item[`\u0062\u0075\u0063\u006b\u0065\u0074`][`\u0077\u0065\u0062\u0055\u0073\u0065\u0072\u0049\u0064`];
        userData[`\u0062\u0075\u0063\u006b\u0065\u0074`] = item[`\u0062\u0075\u0063\u006b\u0065\u0074`];
      }
      if (item[`\u0062\u0075\u0063\u006b\u0065\u0074`] && item[`\u0062\u0075\u0063\u006b\u0065\u0074`][`\u0075\u0073\u0065\u0072\u0049\u0064`]) {
        userData[`\u0075\u0073\u0065\u0072\u0049\u0064`] = item[`\u0062\u0075\u0063\u006b\u0065\u0074`][`\u0075\u0073\u0065\u0072\u0049\u0064`];
        userData[`\u0062\u0075\u0063\u006b\u0065\u0074`] = item[`\u0062\u0075\u0063\u006b\u0065\u0074`];
      }
    }
    return userData;
  } catch (error) {
    sendLog(`\u83b7\u53d6\u7528\u6237\u0069\u0064\u9519\u8bef`);
    return {
      key: ``,
      webUserId: ``,
      userId: ``,
      bucket: {}
    };
  }
};
const query_user_chat_num = async contentUserId => {
  console.log(`\u0071\u0075\u0065\u0072\u0079\u005f\u0075\u0073\u0065\u0072\u005f\u0063\u0068\u0061\u0074\u005f\u006e\u0075\u006d\u0020\u0075\u0073\u0065\u0072\u0049\u0064` + contentUserId);
  let userRes = await queryObjects([{
    key: `\u0062\u0065\u006c\u006f\u006e\u0067\u005f\u0074\u006f`,
    value: store$1.userId + `\u005f\u0064\u006f\u0075\u0059\u0069\u006e\u004c\u0069\u0073\u0074`
  }, {
    key: `\u0063\u006f\u006e\u0074\u0065\u006e\u0074\u0055\u0073\u0065\u0072\u0049\u0064`,
    value: contentUserId
  }, {
    key: `\u0072\u0065\u0070\u006c\u0079\u0054\u0079\u0070\u0065`,
    value: `\u0066\u0069\u0072\u0073\u0074`
  }]);
  console.log(`\u0071\u0075\u0065\u0072\u0079\u004f\u0062\u006a\u0065\u0063\u0074\u0073\u0020\u0075\u0073\u0065\u0072\u0052\u0065\u0073`, userRes);
  if (userRes && (userRes == null ? void 0 : userRes.items) && (userRes == null ? void 0 : userRes.items.length) > 0) {
    return false;
  }
  return true;
};
const handler_PrivateMessage_Stranger_list = async () => {
  var _a;
  sendLog(`\u79c1\u4fe1\u964c\u751f\u4eba\uff0c\u6eda\u52a8\u5230\u5bb9\u5668\u7684\u9876\u90e8`);
  await findFirstMessageToScroll();
  const listDlg = Array.from(document.querySelectorAll(`\u0064\u0069\u0076\u005b\u0064\u0061\u0074\u0061\u002d\u0065\u0032\u0065\u003d\u0022\u006c\u0069\u0073\u0074\u0044\u006c\u0067\u002d\u0063\u006f\u006e\u0074\u0061\u0069\u006e\u0065\u0072\u0022\u005d\u003e\u0064\u0069\u0076\u003a\u006e\u0074\u0068\u002d\u0063\u0068\u0069\u006c\u0064\u0028\u0032\u0029\u0020\u003e\u0064\u0069\u0076\u0020\u003e\u0064\u0069\u0076`));
  let container = document.querySelector(`\u0064\u0069\u0076\u005b\u0064\u0061\u0074\u0061\u002d\u0065\u0032\u0065\u003d\u0022\u006c\u0069\u0073\u0074\u0044\u006c\u0067\u002d\u0063\u006f\u006e\u0074\u0061\u0069\u006e\u0065\u0072\u0022\u005d\u0020\u003e\u0020\u0064\u0069\u0076\u003a\u006e\u0074\u0068\u002d\u0063\u0068\u0069\u006c\u0064\u0028\u0032\u0029`);
  for (let i = 0; i < listDlg.length; i++) {
    const dlg = listDlg[i];
    if (!dlg) {
      continue;
    }
    const divEl = dlg.querySelector(`\u003a\u0073\u0063\u006f\u0070\u0065\u0020\u003e\u0064\u0069\u0076`);
    if (divEl) {
      ensureElementVisible(divEl, container);
    }
    console.log(`\u0064\u006c\u0067`, dlg);
    const zuoZhiEl = dlg.querySelector(`\u003a\u0073\u0063\u006f\u0070\u0065\u0020\u003e\u0064\u0069\u0076\u0020\u003e\u0064\u0069\u0076\u003e\u0064\u0069\u0076\u003a\u006e\u0074\u0068\u002d\u0063\u0068\u0069\u006c\u0064\u0028\u0032\u0029\u0020\u003e\u0064\u0069\u0076\u003a\u006e\u0074\u0068\u002d\u0063\u0068\u0069\u006c\u0064\u0028\u0031\u0029`);
    await delay(300);
    let zuoZhiText = ``;
    if (zuoZhiEl) {
      zuoZhiText = (_a = zuoZhiEl.textContent) == null ? void 0 : _a.trim();
      sendLog(`\u4f5c\u8005\u540d\u79f0\u0020\u007a\u0075\u006f\u005a\u0068\u0069\u0054\u0065\u0078\u0074\uff1a` + zuoZhiText);
      if (zuoZhiText == `\u964c\u751f\u4eba\u6d88\u606f`) {
        const clickDiv = dlg.querySelector(`\u0070\u0072\u0065`);
        if (clickDiv) {
          await click_button(clickDiv);
        }
        await delay(1e3);
        await handler_PrivateMessage_Stranger();
        break;
      }
    } else {
      sendLog(`\u964c\u751f\u4eba\u7684\u4f5c\u8005\u007a\u0075\u006f\u005a\u0068\u0069\u0045\u006c\u4e3a\u7a7a`);
    }
  }
};
const handler_PrivateMessage_Stranger = async () => {
  var _a, _b, _c, _d, _e;
  sendLog(`\u5f00\u59cb\u5904\u7406\u964c\u751f\u4eba\u6d88\u606f\u0020\u0068\u0061\u006e\u0064\u006c\u0065\u0072\u005f\u0050\u0072\u0069\u0076\u0061\u0074\u0065\u004d\u0065\u0073\u0073\u0061\u0067\u0065\u005f\u0053\u0074\u0072\u0061\u006e\u0067\u0065\u0072`);
  if (!(await checkDomPromise(`\u0064\u0069\u0076\u005b\u0064\u0061\u0074\u0061\u002d\u0065\u0032\u0065\u003d\u0022\u006c\u0069\u0073\u0074\u0044\u006c\u0067\u002d\u0063\u006f\u006e\u0074\u0061\u0069\u006e\u0065\u0072\u0022\u005d\u003e\u0064\u0069\u0076\u003a\u006e\u0074\u0068\u002d\u0063\u0068\u0069\u006c\u0064\u0028\u0032\u0029\u0020\u003e\u0064\u0069\u0076\u0020\u003e\u0064\u0069\u0076`))) {
    sendLog(`\u6ca1\u6709\u67e5\u5230\u0020\u0064\u0069\u0076\u005b\u0064\u0061\u0074\u0061\u002d\u0065\u0032\u0065\u003d\u0022\u006c\u0069\u0073\u0074\u0044\u006c\u0067\u002d\u0063\u006f\u006e\u0074\u0061\u0069\u006e\u0065\u0072\u0022\u005d\u003e\u0064\u0069\u0076\u003a\u006e\u0074\u0068\u002d\u0063\u0068\u0069\u006c\u0064\u0028\u0032\u0029\u0020\u003e\u0064\u0069\u0076\u0020\u003e\u0064\u0069\u0076`);
    return;
  }
  await findFirstMessageToScroll();
  const listDlgList = document.querySelectorAll(`\u0064\u0069\u0076\u005b\u0064\u0061\u0074\u0061\u002d\u0065\u0032\u0065\u003d\u0022\u006c\u0069\u0073\u0074\u0044\u006c\u0067\u002d\u0063\u006f\u006e\u0074\u0061\u0069\u006e\u0065\u0072\u0022\u005d\u003e\u0064\u0069\u0076\u003a\u006e\u0074\u0068\u002d\u0063\u0068\u0069\u006c\u0064\u0028\u0032\u0029\u0020\u003e\u0064\u0069\u0076\u0020\u003e\u0064\u0069\u0076`);
  let container = document.querySelector(`\u0064\u0069\u0076\u005b\u0064\u0061\u0074\u0061\u002d\u0065\u0032\u0065\u003d\u0022\u006c\u0069\u0073\u0074\u0044\u006c\u0067\u002d\u0063\u006f\u006e\u0074\u0061\u0069\u006e\u0065\u0072\u0022\u005d\u0020\u003e\u0020\u0064\u0069\u0076\u003a\u006e\u0074\u0068\u002d\u0063\u0068\u0069\u006c\u0064\u0028\u0032\u0029`);
  for (let i = 0; i < listDlgList.length; i++) {
    const listDlg = listDlgList[i];
    console.log(`\u006c\u0069\u0073\u0074\u0044\u006c\u0067`, listDlg);
    if (!listDlg) {
      sendLog(`\u4e0d\u5b58\u5728\u0020\u006c\u0069\u0073\u0074\u0044\u006c\u0067`);
      continue;
    }
    if (listDlg) {
      ensureElementVisible(listDlg, container);
    }
    const hongDianEl = listDlg.querySelector(`\u0064\u0069\u0076\u0020\u003e\u0064\u0069\u0076\u003e\u0064\u0069\u0076\u003a\u006e\u0074\u0068\u002d\u0063\u0068\u0069\u006c\u0064\u0028\u0033\u0029`);
    if (!hongDianEl) {
      sendLog(`\u7ea2\u70b9\u4e0d\u5b58\u5728`);
      continue;
    }
    const messageData = {};
    messageData[`\u0073\u006f\u0075\u0072\u0063\u0065`] = `\u6296\u97f3`;
    messageData[`\u0063\u006c\u0075\u0065\u0054\u0079\u0070\u0065`] = `\u79c1\u4fe1\u964c\u751f\u4eba`;
    const zuoZhiEl = listDlg.querySelector(`\u003a\u0073\u0063\u006f\u0070\u0065\u0020\u003e\u0064\u0069\u0076\u0020\u003e\u0064\u0069\u0076\u003e\u0064\u0069\u0076\u003a\u006e\u0074\u0068\u002d\u0063\u0068\u0069\u006c\u0064\u0028\u0032\u0029\u0020\u003e\u0064\u0069\u0076\u003a\u006e\u0074\u0068\u002d\u0063\u0068\u0069\u006c\u0064\u0028\u0031\u0029`);
    let zuoZhiText = ``;
    if (zuoZhiEl) {
      const zuoZhiText2 = (_a = zuoZhiEl.textContent) == null ? void 0 : _a.trim();
      console.log(`\u007a\u0075\u006f\u005a\u0068\u0069\u0054\u0065\u0078\u0074\u0032`, zuoZhiText2);
      if (zuoZhiText2) {
        zuoZhiText = zuoZhiText2;
      }
    }
    const preEl = listDlg.querySelector(`\u0070\u0072\u0065`);
    if (preEl) {
      const preText = (_b = preEl.textContent) == null ? void 0 : _b.trim();
      console.log(`\u0070\u0072\u0065\u0054\u0065\u0078\u0074`, preText);
      messageData[`\u0063\u006f\u006e\u0074\u0065\u006e\u0074`] = preText;
    }
    const timeEl = listDlg.querySelector(`\u003a\u0073\u0063\u006f\u0070\u0065\u0020\u003e\u0064\u0069\u0076\u0020\u003e\u0064\u0069\u0076\u003e\u0064\u0069\u0076\u003a\u006e\u0074\u0068\u002d\u0063\u0068\u0069\u006c\u0064\u0028\u0032\u0029\u0020\u003e\u0064\u0069\u0076\u003a\u006e\u0074\u0068\u002d\u0063\u0068\u0069\u006c\u0064\u0028\u0032\u0029\u0020\u003e\u0064\u0069\u0076\u003a\u006e\u0074\u0068\u002d\u0063\u0068\u0069\u006c\u0064\u0028\u0032\u0029`);
    if (timeEl) {
      const timeText = (_c = timeEl.textContent) == null ? void 0 : _c.trim();
      console.log(`\u0074\u0069\u006d\u0065\u0054\u0065\u0078\u0074`, timeText);
      messageData[`\u0074\u0069\u006d\u0065\u0054\u0065\u0078\u0074`] = timeText;
    }
    const avatarImgEl = listDlg.querySelector(`\u0069\u006d\u0067`);
    let avatarPath = ``;
    let avatarUrl = ``;
    if (avatarImgEl) {
      avatarUrl = avatarImgEl.src;
      if (avatarUrl) {
        try {
          if (avatarUrl.startsWith(`\u002f\u002f`)) {
            avatarUrl = `\u0068\u0074\u0074\u0070\u0073\u003a` + avatarUrl;
          }
          const avatarURL = new URL(avatarUrl);
          avatarPath = avatarURL.pathname;
          if (avatarPath) {
            avatarPath = getLastPathName$1(avatarPath);
          } else {
            sendLog(`\u7528\u6237\u5934\u50cf\u4e3a\u7a7a\uff0c\u0070\u0061\u0074\u0068\u006e\u0061\u006d\u0065\u003a` + avatarPath);
          }
        } catch (error) {
          sendLog(`\u7528\u6237\u5934\u50cf\u4e3a\u7a7a\u0020\u0075\u0072\u006c\u0020\u9519\u8bef\u0020` + avatarUrl);
        }
      } else {
        sendLog(`\u7528\u6237\u5934\u50cf\u7684\u5730\u5740\u4e0d\u662f\u0055\u0072\u006c\u003a` + avatarUrl);
      }
    } else {
      sendLog(`\u6ca1\u6709\u627e\u5230\u7528\u6237\u5934\u50cf`);
    }
    messageData[`\u0075\u0073\u0065\u0072\u004e\u0061\u006d\u0065`] = zuoZhiText;
    messageData[`\u0061\u0076\u0061\u0074\u0061\u0072`] = avatarUrl;
    messageData[`\u0061\u0076\u0061\u0074\u0061\u0072\u0050\u0061\u0074\u0068`] = avatarPath;
    const clickDiv = listDlg.querySelector(`\u0064\u0069\u0076\u005b\u0064\u0061\u0074\u0061\u002d\u0065\u0032\u0065\u003d\u0022\u0063\u006f\u006e\u0076\u0065\u0072\u0073\u0061\u0074\u0069\u006f\u006e\u002d\u0069\u0074\u0065\u006d\u0022\u005d\u003e\u0064\u0069\u0076\u0020\u003e\u0064\u0069\u0076\u003a\u006e\u0074\u0068\u002d\u0063\u0068\u0069\u006c\u0064\u0028\u0032\u0029`);
    if (!clickDiv) {
      sendLog(`\u6ca1\u6709\u627e\u5230\u0020\u0063\u006c\u0069\u0063\u006b\u0044\u0069\u0076\u003a`);
      continue;
    }
    await click_button(clickDiv);
    await delay(1e3);
    const preText3 = await getUserSendReplyContent();
    if (preText3) {
      messageData[`\u0063\u006f\u006e\u0074\u0065\u006e\u0074`] = preText3;
    }
    const date = /* @__PURE__ */new Date();
    const year = date.getFullYear();
    const month = String(date.getMonth() + 1).padStart(2, `\u0030`);
    const day = String(date.getDate()).padStart(2, `\u0030`);
    const hours = String(date.getHours()).padStart(2, `\u0030`);
    const minutes = String(date.getMinutes()).padStart(2, `\u0030`);
    messageData[`\u0063\u0072\u0065\u0061\u0074\u0065\u0044\u0061\u0074\u0065`] = `${year}\u002d${month}\u002d${day}\u0020${hours}\u003a${minutes}`;
    messageData[`\u0061\u0064\u0064\u0054\u0069\u006d\u0065`] = (/* @__PURE__ */new Date()).getTime();
    messageData[`\u0074\u0065\u006e\u0061\u006e\u0074\u0049\u0064`] = store$1.tenantId;
    messageData[`\u0075\u0073\u0065\u0072\u0049\u0064`] = store$1.userId;
    messageData[`\u0061\u0067\u0065\u006e\u0074\u0049\u0064`] = VITE_AGENT_ID;
    messageData[`\u0074\u0061\u0073\u006b\u0049\u0064`] = store$1.taskId;
    messageData[`\u0065\u0078\u0065\u0063\u0075\u0074\u0065\u0049\u0064`] = store$1.executeId;
    messageData[`\u0074\u0065\u0072\u006d\u0069\u006e\u0061\u006c\u0049\u0064`] = (_d = store$1.terminalData) == null ? void 0 : _d.terminalId;
    messageData[`\u0077\u0065\u0062\u0055\u0073\u0065\u0072\u0049\u0064`] = store$1.webUserId;
    messageData[`\u0077\u0065\u0062\u0055\u0073\u0065\u0072\u004e\u0061\u006d\u0065`] = store$1.webUserName;
    if (messageData && messageData[`\u0063\u006f\u006e\u0074\u0065\u006e\u0074`]) {
      store$1.setContentText(messageData[`\u0063\u006f\u006e\u0074\u0065\u006e\u0074`]);
      const textContent = messageData[`\u0063\u006f\u006e\u0074\u0065\u006e\u0074`];
      const contentArray = Array.from(textContent);
      sendLog(`\u0063\u006f\u006e\u0074\u0065\u006e\u0074\u0041\u0072\u0072\u0061\u0079\u003a` + contentArray.length);
      const phoneNums = extractPhoneNumbers(textContent);
      sendLog(`\u0065\u0078\u0074\u0072\u0061\u0063\u0074\u0050\u0068\u006f\u006e\u0065\u004e\u0075\u006d\u0062\u0065\u0072\u0073\u003a` + JSON.stringify({
        phoneNums,
        textContent
      }));
      const optionWhere = store$1.getOptionWhere();
      let replayBoolean = false;
      replayBoolean = true;
      sendLog(`\u0070\u0068\u006f\u006e\u0065\u004e\u0075\u006d\u0073\u003a` + phoneNums);
      if (phoneNums.length > 0) {
        messageData[`\u0063\u006f\u006e\u0074\u0061\u0063\u0074\u0049\u006e\u0066\u006f\u0072\u006d\u0061\u0074\u0069\u006f\u006e`] = phoneNums[0];
        messageData[`\u0063\u006f\u006e\u0074\u0061\u0063\u0074\u0049\u006e\u0066\u006f\u0072\u006d\u0061\u0074\u0069\u006f\u006e\u0042\u006f\u006f\u006c`] = 1;
      }
      if (replayBoolean) {
        chrome.storage.local.set({
          "douYinDataList": JSON.stringify(messageData)
        });
        const userData = await get_PrivateMessage_userId(avatarPath, zuoZhiText);
        let userFirstCommentBool = false;
        if (optionWhere.enableFirstReplyBool) {
          sendLog(`\u4f7f\u7528\u8f6f\u4ef6\u7a0b\u5e8f\u8fdb\u884c\u0020\u79c1\u4fe1\u5efa\u7acb\u56de\u590d\u8bdd\u672f`);
          userFirstCommentBool = await query_user_chat_num(userData[`\u0075\u0073\u0065\u0072\u0049\u0064`]);
        }
        messageData[`\u0063\u006f\u006e\u0074\u0065\u006e\u0074\u0057\u0065\u0062\u0055\u0073\u0065\u0072\u0049\u0064`] = userData[`\u0077\u0065\u0062\u0055\u0073\u0065\u0072\u0049\u0064`];
        messageData[`\u0063\u006f\u006e\u0074\u0065\u006e\u0074\u0055\u0073\u0065\u0072\u0049\u0064`] = userData[`\u0075\u0073\u0065\u0072\u0049\u0064`];
        if (userFirstCommentBool) {
          if (optionWhere.enableFirstReplyBool && (optionWhere.phoneNumberReplyContent || optionWhere.phoneNumberReplyContent1 || optionWhere.phoneNumberReplyContent3)) {
            const chatList = [{
              // 发送id
              "sender": userData[`\u0077\u0065\u0062\u0055\u0073\u0065\u0072\u0049\u0064`] ? userData[`\u0077\u0065\u0062\u0055\u0073\u0065\u0072\u0049\u0064`] : userData[`\u0075\u0073\u0065\u0072\u0049\u0064`],
              // 发送人的名称
              "sender_name": messageData[`\u0075\u0073\u0065\u0072\u004e\u0061\u006d\u0065`],
              "sender_avatar": messageData[`\u0061\u0076\u0061\u0074\u0061\u0072`],
              // 接收人id
              "receiver": store$1.webUserId,
              // 接收人的id
              "receiver_name": store$1.webUserName,
              "receiver_avatar": store$1.webUserAvatarUrl,
              // 发送内容
              "content": messageData[`\u0063\u006f\u006e\u0074\u0065\u006e\u0074`]
            }];
            if (optionWhere.phoneNumberReplyContent1) {
              await replyContent_PrivateMessage(optionWhere.phoneNumberReplyContent1);
              await delay(getRandomNumberInRange(3e3, 5e3));
              chatList.push({
                // 发送id
                "sender": store$1.webUserId,
                // 发送人的名称
                "sender_name": store$1.webUserName,
                "sender_avatar": store$1.webUserAvatarUrl,
                // 接收人id
                "receiver": userData[`\u0077\u0065\u0062\u0055\u0073\u0065\u0072\u0049\u0064`] ? userData[`\u0077\u0065\u0062\u0055\u0073\u0065\u0072\u0049\u0064`] : userData[`\u0075\u0073\u0065\u0072\u0049\u0064`],
                // 接收人的id
                "receiver_name": messageData[`\u0075\u0073\u0065\u0072\u004e\u0061\u006d\u0065`],
                "receiver_avatar": messageData[`\u0061\u0076\u0061\u0074\u0061\u0072`],
                // 发送内容
                "content": optionWhere.phoneNumberReplyContent1
              });
              store$1.setReplyComment(optionWhere.phoneNumberReplyContent1);
            }
            if (optionWhere.phoneNumberReplyContent) {
              await replyContent_PrivateMessage(optionWhere.phoneNumberReplyContent);
              await delay(getRandomNumberInRange(3e3, 5e3));
              chatList.push({
                // 发送id
                "sender": store$1.webUserId,
                // 发送人的名称
                "sender_name": store$1.webUserName,
                "sender_avatar": store$1.webUserAvatarUrl,
                // 接收人id
                "receiver": userData[`\u0077\u0065\u0062\u0055\u0073\u0065\u0072\u0049\u0064`] ? userData[`\u0077\u0065\u0062\u0055\u0073\u0065\u0072\u0049\u0064`] : userData[`\u0075\u0073\u0065\u0072\u0049\u0064`],
                // 接收人的id
                "receiver_name": messageData[`\u0075\u0073\u0065\u0072\u004e\u0061\u006d\u0065`],
                "receiver_avatar": messageData[`\u0061\u0076\u0061\u0074\u0061\u0072`],
                // 发送内容
                "content": optionWhere.phoneNumberReplyContent
              });
              store$1.setReplyComment(optionWhere.phoneNumberReplyContent);
            }
            if (optionWhere.phoneNumberReplyContent3) {
              await replyContent_PrivateMessage(optionWhere.phoneNumberReplyContent3);
              chatList.push({
                // 发送id
                "sender": store$1.webUserId,
                // 发送人的名称
                "sender_name": store$1.webUserName,
                "sender_avatar": store$1.webUserAvatarUrl,
                // 接收人id
                "receiver": userData[`\u0077\u0065\u0062\u0055\u0073\u0065\u0072\u0049\u0064`] ? userData[`\u0077\u0065\u0062\u0055\u0073\u0065\u0072\u0049\u0064`] : userData[`\u0075\u0073\u0065\u0072\u0049\u0064`],
                // 接收人的id
                "receiver_name": messageData[`\u0075\u0073\u0065\u0072\u004e\u0061\u006d\u0065`],
                "receiver_avatar": messageData[`\u0061\u0076\u0061\u0074\u0061\u0072`],
                // 发送内容
                "content": optionWhere.phoneNumberReplyContent3
              });
              store$1.setReplyComment(optionWhere.phoneNumberReplyContent3);
            }
            await delay(getRandomNumberInRange(2 * 1e3, 10 * 1e3));
            messageData[`\u0072\u0065\u0070\u006c\u0079\u0054\u0065\u0078\u0074`] = optionWhere.phoneNumberReplyContent;
            messageData[`\u0072\u0065\u0070\u006c\u0079\u0054\u0079\u0070\u0065`] = `\u0066\u0069\u0072\u0073\u0074`;
            await delay(1e3);
            const key = `\u0068\u0061\u006e\u0064\u006c\u0065\u0072\u005f\u0050\u0072\u0069\u0076\u0061\u0074\u0065\u004d\u0065\u0073\u0073\u0061\u0067\u0065\u005f\u0053\u0074\u0072\u0061\u006e\u0067\u0065\u0072\u005f` + (/* @__PURE__ */new Date()).getTime();
            const postDataObj = {
              "key": key,
              "bucket": messageData,
              "size": 0,
              "content_type": ``,
              "belong_to": store$1.userId + `\u005f\u0064\u006f\u0075\u0059\u0069\u006e\u004c\u0069\u0073\u0074`,
              "object_metadata": {}
            };
            await addObjects(postDataObj);
            await saveChat({
              "session": {
                // 登录网站用户id
                "account_id": store$1.webUserId,
                // 视频名称
                "video_name": ``,
                // 视频地址
                "video_url": ``,
                // 会话来源，通知和私信
                "source": `\u79c1\u4fe1`
              },
              "chat_list": chatList
            });
          } else {
            sendLog(`\u7b2c\u4e00\u6b21\u0020\u6ca1\u6709\u56de\u590d\u7684\u5185\u5bb9`);
          }
        } else {
          sendLog(`\u7b2c\u4e8c\u6b21\u56de\u590d\u0020\u8c03\u7528\u5bf9\u8bdd\uff0c\u83b7\u53d6\u56de\u590d\u5185\u5bb9`);
          const msgItemContentListEl = Array.from(document.querySelectorAll(`\u0064\u0069\u0076\u005b\u0064\u0061\u0074\u0061\u002d\u0065\u0032\u0065\u003d\u0022\u006d\u0073\u0067\u002d\u0069\u0074\u0065\u006d\u002d\u0063\u006f\u006e\u0074\u0065\u006e\u0074\u0022\u005d`));
          const textContentList = [];
          for (let j = 0; j < msgItemContentListEl.length; j++) {
            const textContent2 = (_e = msgItemContentListEl[0].textContent) == null ? void 0 : _e.trim();
            if (textContent2 && textContent2 != messageData[`\u0063\u006f\u006e\u0074\u0065\u006e\u0074`]) {
              textContentList.push(textContent2);
            }
          }
          console.log(`\u0074\u0065\u0078\u0074\u0043\u006f\u006e\u0074\u0065\u006e\u0074\u004c\u0069\u0073\u0074\uff1a`, textContentList);
          let contentText = await getCorpusContentText(messageData);
          if (contentText == `\u5df2\u7ecf\u53d6\u5f97\u8054\u7cfb\u65b9\u5f0f`) {
            sendLog(`\u5df2\u7ecf\u53d6\u5f97\u8054\u7cfb\u65b9\u5f0f\u0020\u4e0d\u5728\u56de\u590d`);
            contentText = `\u6536\u5230\uff0c\u6211\u4eec\u4f1a\u5c3d\u5feb\u8054\u7cfb\u60a8\u3002`;
          }
          if (optionWhere.keFuNullReplyContent && !contentText) {
            contentText = optionWhere.keFuNullReplyContent;
            sendLog(`\u56de\u590d\u7684\u5185\u5bb9\u4e3a\u7a7a\uff0c\u4f7f\u7528\u515c\u5e95\u7684\u56de\u590d\u5185\u5bb9\uff0c\u0020\u006b\u0065\u0046\u0075\u004e\u0075\u006c\u006c\u0052\u0065\u0070\u006c\u0079\u0043\u006f\u006e\u0074\u0065\u006e\u0074\uff1a` + optionWhere.keFuNullReplyContent);
            messageData[`\u006b\u0065\u0046\u0075\u004e\u0075\u006c\u006c\u0052\u0065\u0070\u006c\u0079\u0043\u006f\u006e\u0074\u0065\u006e\u0074`] = `\u0079\u0065\u0073`;
          }
          if (!contentText) {
            sendLog(`\u56de\u590d\u7684\u5185\u5bb9\u4e3a\u7a7a\uff0c\u4e0d\u9700\u8981\u56de\u590d`);
          } else {
            sendLog(`\u56de\u590d\u7684\u5185\u5bb9\uff1a` + contentText);
            messageData[`\u0072\u0065\u0070\u006c\u0079\u0054\u0065\u0078\u0074`] = contentText;
            messageData[`\u0072\u0065\u0070\u006c\u0079\u0054\u0079\u0070\u0065`] = `\u0073\u0065\u0063\u006f\u006e\u0064`;
            await replyContent_PrivateMessage(contentText);
            store$1.setReplyComment(contentText);
            await delay(1e3);
            const key = `\u0068\u0061\u006e\u0064\u006c\u0065\u0072\u005f\u0050\u0072\u0069\u0076\u0061\u0074\u0065\u004d\u0065\u0073\u0073\u0061\u0067\u0065\u005f\u0053\u0074\u0072\u0061\u006e\u0067\u0065\u0072\u005f` + (/* @__PURE__ */new Date()).getTime();
            const postDataObj = {
              "key": key,
              "bucket": messageData,
              "size": 0,
              "content_type": ``,
              "belong_to": store$1.userId + `\u005f\u0064\u006f\u0075\u0059\u0069\u006e\u004c\u0069\u0073\u0074`,
              "object_metadata": {}
            };
            await addObjects(postDataObj);
            const chatList = [{
              // 发送id
              "sender": userData[`\u0077\u0065\u0062\u0055\u0073\u0065\u0072\u0049\u0064`] ? userData[`\u0077\u0065\u0062\u0055\u0073\u0065\u0072\u0049\u0064`] : userData[`\u0075\u0073\u0065\u0072\u0049\u0064`],
              // 发送人的名称
              "sender_name": messageData[`\u0075\u0073\u0065\u0072\u004e\u0061\u006d\u0065`],
              "sender_avatar": messageData[`\u0061\u0076\u0061\u0074\u0061\u0072`],
              // 接收人id
              "receiver": store$1.webUserId,
              // 接收人的id
              "receiver_name": store$1.webUserName,
              "receiver_avatar": store$1.webUserAvatarUrl,
              // 发送内容
              "content": messageData[`\u0063\u006f\u006e\u0074\u0065\u006e\u0074`]
            }, {
              // 发送id
              "sender": store$1.webUserId,
              // 发送人的名称
              "sender_name": store$1.webUserName,
              "sender_avatar": store$1.webUserAvatarUrl,
              // 接收人id
              "receiver": userData[`\u0077\u0065\u0062\u0055\u0073\u0065\u0072\u0049\u0064`] ? userData[`\u0077\u0065\u0062\u0055\u0073\u0065\u0072\u0049\u0064`] : userData[`\u0075\u0073\u0065\u0072\u0049\u0064`],
              // 接收人的id
              "receiver_name": messageData[`\u0075\u0073\u0065\u0072\u004e\u0061\u006d\u0065`],
              "receiver_avatar": messageData[`\u0061\u0076\u0061\u0074\u0061\u0072`],
              // 发送内容
              "content": contentText
            }];
            await saveChat({
              "session": {
                // 登录网站用户id
                "account_id": store$1.webUserId,
                // 视频名称
                "video_name": ``,
                // 视频地址
                "video_url": ``,
                // 会话来源，通知和私信
                "source": `\u79c1\u4fe1`
              },
              "chat_list": chatList
            });
          }
        }
      } else {
        sendLog(`\u0072\u0065\u0070\u006c\u0061\u0079\u0042\u006f\u006f\u006c\u0065\u0061\u006e\u0020\u0026\u0026\u0020\u0072\u0065\u0070\u006c\u0079\u0043\u006f\u006e\u0074\u0065\u006e\u0074\u0054\u0065\u0078\u0074\u0020\u4e0d\u4e3a\u771f\uff1a` + replayBoolean + `\u002c\u0020\u006f\u0070\u0074\u0069\u006f\u006e\u0057\u0068\u0065\u0072\u0065\u002e\u0065\u006e\u0061\u0062\u006c\u0065\u0046\u0069\u0072\u0073\u0074\u0052\u0065\u0070\u006c\u0079\u0042\u006f\u006f\u006c` + optionWhere.enableFirstReplyBool + `\u002d` + JSON.stringify([optionWhere.phoneNumberReplyContent, optionWhere.phoneNumberReplyContent1, optionWhere.phoneNumberReplyContent3]));
      }
    } else {
      sendLog(`\u006d\u0065\u0073\u0073\u0061\u0067\u0065\u0044\u0061\u0074\u0061\u0020\u0026\u0026\u0020\u006d\u0065\u0073\u0073\u0061\u0067\u0065\u0044\u0061\u0074\u0061\u005b\u0027\u0063\u006f\u006e\u0074\u0065\u006e\u0074\u0027\u005d\u003a` + messageData && messageData[`\u0063\u006f\u006e\u0074\u0065\u006e\u0074`]);
    }
  }
  const backButtonEl = document.querySelector(`\u0064\u0069\u0076\u005b\u0064\u0061\u0074\u0061\u002d\u0065\u0032\u0065\u003d\u0022\u006c\u0069\u0073\u0074\u0044\u006c\u0067\u002d\u0063\u006f\u006e\u0074\u0061\u0069\u006e\u0065\u0072\u0022\u005d\u0020\u0073\u0076\u0067\u005b\u0066\u0069\u006c\u006c\u003d\u0022\u006e\u006f\u006e\u0065\u0022\u005d`);
  if (backButtonEl) {
    await click_button(backButtonEl);
  }
  await delay(1e3);
};
const getContentUrl = async messageData => {
  var _a, _b;
  if (!(await checkDomPromise(`\u0064\u0069\u0076\u005b\u0064\u0061\u0074\u0061\u002d\u0065\u0032\u0065\u003d\u0022\u0063\u006f\u006d\u006d\u0065\u006e\u0074\u002d\u006c\u0069\u0073\u0074\u0022\u005d\u0020\u0064\u0069\u0076\u005b\u0064\u0061\u0074\u0061\u002d\u0065\u0032\u0065\u003d\u0022\u0063\u006f\u006d\u006d\u0065\u006e\u0074\u002d\u0069\u0074\u0065\u006d\u0022\u005d`))) {
    sendLog(`\u6ca1\u6709\u627e\u5230\u0020\u0064\u0069\u0076\u005b\u0064\u0061\u0074\u0061\u002d\u0065\u0032\u0065\u003d\u0022\u0063\u006f\u006d\u006d\u0065\u006e\u0074\u002d\u006c\u0069\u0073\u0074\u0022\u005d\u0020\u0064\u0069\u0076\u005b\u0064\u0061\u0074\u0061\u002d\u0065\u0032\u0065\u003d\u0022\u0063\u006f\u006d\u006d\u0065\u006e\u0074\u002d\u0069\u0074\u0065\u006d\u0022\u005d`);
    return;
  }
  const commentItemList = document.querySelectorAll(`\u0064\u0069\u0076\u005b\u0064\u0061\u0074\u0061\u002d\u0065\u0032\u0065\u003d\u0022\u0063\u006f\u006d\u006d\u0065\u006e\u0074\u002d\u006c\u0069\u0073\u0074\u0022\u005d\u0020\u0064\u0069\u0076\u005b\u0064\u0061\u0074\u0061\u002d\u0065\u0032\u0065\u003d\u0022\u0063\u006f\u006d\u006d\u0065\u006e\u0074\u002d\u0069\u0074\u0065\u006d\u0022\u005d`);
  if (!commentItemList || commentItemList.length == 0) {
    sendLog(`\u0063\u006f\u006d\u006d\u0065\u006e\u0074\u0049\u0074\u0065\u006d\u004c\u0069\u0073\u0074\u0020\u6ca1\u6709\u627e\u5230\u5217\u8868`);
    return;
  }
  const commentItemContentEl = commentItemList[0].querySelector(`\u003a\u0073\u0063\u006f\u0070\u0065\u0020\u003e\u0064\u0069\u0076\u003a\u006e\u0074\u0068\u002d\u0063\u0068\u0069\u006c\u0064\u0028\u0032\u0029\u0020\u003e\u0064\u0069\u0076\u0020\u003e\u0064\u0069\u0076\u003a\u006e\u0074\u0068\u002d\u0063\u0068\u0069\u006c\u0064\u0028\u0033\u0029`);
  if (!commentItemContentEl) {
    sendLog(`\u0063\u006f\u006d\u006d\u0065\u006e\u0074\u0049\u0074\u0065\u006d\u0043\u006f\u006e\u0074\u0065\u006e\u0074\u0045\u006c\u0020\u6ca1\u6709\u627e\u5230\u8bc4\u8bba\u5185\u5bb9`);
    return;
  }
  let textContent = (_a = commentItemContentEl.textContent) == null ? void 0 : _a.trim();
  sendLog(`\u0067\u0065\u0074\u0043\u006f\u006e\u0074\u0065\u006e\u0074\u0055\u0072\u006c\u0020\u0074\u0065\u0078\u0074\u0043\u006f\u006e\u0074\u0065\u006e\u0074\uff1a` + textContent);
  let replayBoolean = false;
  let replyContentText = ``;
  if (textContent) {
    const contentArray = Array.from(textContent);
    sendLog(`\u0063\u006f\u006e\u0074\u0065\u006e\u0074\u0041\u0072\u0072\u0061\u0079\u003a\u0020` + contentArray.length + `\u002c` + JSON.stringify(contentArray));
    const phoneNums = extractPhoneNumbers(textContent);
    const optionWhere = store$1.getOptionWhere();
    if (optionWhere && optionWhere.wordWhereNum && contentArray.length >= optionWhere.wordWhereNum && contentArray.length <= optionWhere.wordWhereNumEnd && optionWhere.wordReplyContent) {
      replayBoolean = true;
      replyContentText = optionWhere.wordReplyContent;
      sendLog(`\u5b57\u6570\u8bc4\u8bba`);
    }
    sendLog(`\u0072\u0065\u0070\u006c\u0061\u0079\u0042\u006f\u006f\u006c\u0065\u0061\u006e\u002c` + replayBoolean + `\uff0c\u0070\u0068\u006f\u006e\u0065\u004e\u0075\u006d\u0073\u003a` + phoneNums + `\u002c\u006f\u0070\u0074\u0069\u006f\u006e\u0057\u0068\u0065\u0072\u0065\u003a` + JSON.stringify(optionWhere) + `\u002c\u0020\u0072\u0065\u0070\u006c\u0079\u0043\u006f\u006e\u0074\u0065\u006e\u0074\u0054\u0065\u0078\u0074\u003a` + replyContentText);
    if (replayBoolean && replyContentText) {
      chrome.storage.local.set({
        "douYinDataList": JSON.stringify(messageData)
      });
      sendLog(`\u5f00\u59cb\u56de\u590d\u8bc4\u8bba\u7684\u5185\u5bb9\uff0c\u0072\u0065\u0070\u006c\u0079\u0043\u006f\u006e\u0074\u0065\u006e\u0074\u0054\u0065\u0078\u0074\uff1a` + replyContentText);
      await replyContent(commentItemList[0], replyContentText);
    } else {
      sendLog(`\u0072\u0065\u0070\u006c\u0061\u0079\u0042\u006f\u006f\u006c\u0065\u0061\u006e\u0020\u0026\u0026\u0020\u0072\u0065\u0070\u006c\u0079\u0043\u006f\u006e\u0074\u0065\u006e\u0074\u0054\u0065\u0078\u0074\u0020\u4e0d\u662f\u771f`);
    }
  }
  const avatarAEl = commentItemList[0].querySelector(`\u003a\u0073\u0063\u006f\u0070\u0065\u0020\u003e\u0064\u0069\u0076\u002e\u0063\u006f\u006d\u006d\u0065\u006e\u0074\u002d\u0069\u0074\u0065\u006d\u002d\u0061\u0076\u0061\u0074\u0061\u0072\u0020\u0061`);
  if (avatarAEl) {
    let href = avatarAEl.getAttribute(`\u0068\u0072\u0065\u0066`);
    console.log(`\u0068\u0072\u0065\u0066`, href);
    if (href) {
      if (href.startsWith(`\u002f\u002f`)) {
        href = `\u0068\u0074\u0074\u0070\u0073\u003a` + href;
      }
      const pathname = new URL(href).pathname;
      console.log(`\u0070\u0061\u0074\u0068\u006e\u0061\u006d\u0065`, pathname);
    }
  }
  const videoDescEl = document.querySelector(`\u0064\u0069\u0076\u005b\u0064\u0061\u0074\u0061\u002d\u0065\u0032\u0065\u003d\u0022\u0076\u0069\u0064\u0065\u006f\u002d\u0064\u0065\u0073\u0063\u0022\u005d`);
  let videoDesc = ``;
  if (videoDescEl) {
    videoDesc = (_b = videoDescEl.textContent) == null ? void 0 : _b.trim();
  }
  const contentUrl = window.location.href;
  sendLog(`\u0063\u006f\u006e\u0074\u0065\u006e\u0074\u0055\u0072\u006c\uff1a` + contentUrl);
  let backButton = document.querySelector(`\u0073\u0070\u0061\u006e\u005b\u0072\u006f\u006c\u0065\u003d\u0022\u0069\u006d\u0067\u0022\u005d\u0020\u0070\u0061\u0074\u0068\u005b\u0073\u0074\u0072\u006f\u006b\u0065\u003d\u0022\u0063\u0075\u0072\u0072\u0065\u006e\u0074\u0043\u006f\u006c\u006f\u0072\u0022\u005d`);
  if (backButton) {
    await click_button(backButton);
  }
  backButton = document.querySelector(`\u0023\u0064\u006f\u0075\u0079\u0069\u006e\u002d\u0072\u0069\u0067\u0068\u0074\u002d\u0063\u006f\u006e\u0074\u0061\u0069\u006e\u0065\u0072\u0020\u003e\u0064\u0069\u0076\u0020\u003e\u0064\u0069\u0076\u003a\u006e\u0074\u0068\u002d\u0063\u0068\u0069\u006c\u0064\u0028\u0031\u0029\u002e\u0069\u0073\u0044\u0061\u0072\u006b`);
  if (backButton) {
    await click_button(backButton);
  }
  if (!backButton) {
    sendLog(`\u6ca1\u6709\u0020\u0062\u0061\u0063\u006b\u0042\u0075\u0074\u0074\u006f\u006e`);
  }
  return {
    contentUrl,
    videoDesc: videoDesc ? videoDesc : ``,
    replyContentText,
    replayBoolean
  };
};
const replyContent = async (commentItem, content) => {
  var _a, _b;
  sendLog(`\u8fdb\u5165\u5230\u0020\u0072\u0065\u0070\u006c\u0079\u0043\u006f\u006e\u0074\u0065\u006e\u0074`);
  const replyButton = commentItem.querySelector(`\u002e\u0063\u006f\u006d\u006d\u0065\u006e\u0074\u002d\u0069\u0074\u0065\u006d\u002d\u0073\u0074\u0061\u0074\u0073\u002d\u0063\u006f\u006e\u0074\u0061\u0069\u006e\u0065\u0072\u0020\u0064\u0069\u0076\u005b\u0074\u0061\u0062\u0069\u006e\u0064\u0065\u0078\u003d\u0022\u0030\u0022\u005d\u0020\u003e\u0020\u0064\u0069\u0076`);
  if (replyButton) {
    ensureElementVisible(replyButton);
    await click_button(replyButton);
  } else {
    sendLog(`\u6ca1\u6709\u0020\u0072\u0065\u0070\u006c\u0079\u0042\u0075\u0074\u0074\u006f\u006e`);
    return;
  }
  if (!(await checkDomPromise(`\u002e\u0063\u006f\u006d\u006d\u0065\u006e\u0074\u002d\u0069\u006e\u0070\u0075\u0074\u002d\u0063\u006f\u006e\u0074\u0061\u0069\u006e\u0065\u0072\u0020\u003e\u0064\u0069\u0076\u003a\u006e\u0074\u0068\u002d\u0063\u0068\u0069\u006c\u0064\u0028\u0032\u0029\u0020\u003e\u0064\u0069\u0076\u003a\u006e\u0074\u0068\u002d\u0063\u0068\u0069\u006c\u0064\u0028\u0031\u0029`))) {
    sendLog(`\u662f\u5426\u5b58\u5728\u56de\u590d\u6309\u94ae\u4e2d\u0020\u002e\u0063\u006f\u006d\u006d\u0065\u006e\u0074\u002d\u0069\u006e\u0070\u0075\u0074\u002d\u0063\u006f\u006e\u0074\u0061\u0069\u006e\u0065\u0072\u0020\u003e\u0064\u0069\u0076\u003a\u006e\u0074\u0068\u002d\u0063\u0068\u0069\u006c\u0064\u0028\u0032\u0029\u0020\u003e\u0064\u0069\u0076\u003a\u006e\u0074\u0068\u002d\u0063\u0068\u0069\u006c\u0064\u0028\u0031\u0029`);
  }
  const replyClickButton = commentItem.querySelector(`\u002e\u0063\u006f\u006d\u006d\u0065\u006e\u0074\u002d\u0069\u0074\u0065\u006d\u002d\u0073\u0074\u0061\u0074\u0073\u002d\u0063\u006f\u006e\u0074\u0061\u0069\u006e\u0065\u0072\u0020\u0064\u0069\u0076\u005b\u0074\u0061\u0062\u0069\u006e\u0064\u0065\u0078\u003d\u0022\u0030\u0022\u005d\u0020\u003e\u0020\u0064\u0069\u0076`);
  if (replyClickButton) {
    const replyText = (_a = replyClickButton.textContent) == null ? void 0 : _a.trim();
    if (replyText == `\u56de\u590d\u4e2d`) {
      sendLog(`\u0072\u0065\u0070\u006c\u0079\u0054\u0065\u0078\u0074\uff1a` + replyText);
    }
  }
  sendLog(`\u0064\u006f\u0075\u0059\u0069\u006e\u005f\u0073\u0065\u006e\u0064\u005f\u0063\u006f\u006d\u006d\u0065\u006e\u0074\u0073`);
  await delay(getRandomNumberInRange(1e3, 5e3));
  if (store$1.isNotRunWork()) {
    return;
  }
  if (!(await checkDomPromise(`\u0023\u006d\u0065\u0072\u0067\u0065\u002d\u0061\u006c\u006c\u002d\u0063\u006f\u006d\u006d\u0065\u006e\u0074\u002d\u0063\u006f\u006e\u0074\u0061\u0069\u006e\u0065\u0072\u0020\u002e\u0063\u006f\u006d\u006d\u0065\u006e\u0074\u002d\u0069\u006e\u0070\u0075\u0074\u002d\u0069\u006e\u006e\u0065\u0072\u002d\u0063\u006f\u006e\u0074\u0061\u0069\u006e\u0065\u0072\u0020\u003e\u0064\u0069\u0076\u003a\u006e\u0074\u0068\u002d\u0063\u0068\u0069\u006c\u0064\u0028\u0031\u0029`))) {
    sendLog(`\u6ca1\u6709\u627e\u5230\u0020\u0023\u0063\u006f\u006e\u0074\u0065\u006e\u0074\u002d\u0074\u0065\u0078\u0074\u0061\u0072\u0065\u0061`);
    return;
  }
  const comment_input_el = document.querySelector(`\u0023\u006d\u0065\u0072\u0067\u0065\u002d\u0061\u006c\u006c\u002d\u0063\u006f\u006d\u006d\u0065\u006e\u0074\u002d\u0063\u006f\u006e\u0074\u0061\u0069\u006e\u0065\u0072\u0020\u002e\u0063\u006f\u006d\u006d\u0065\u006e\u0074\u002d\u0069\u006e\u0070\u0075\u0074\u002d\u0069\u006e\u006e\u0065\u0072\u002d\u0063\u006f\u006e\u0074\u0061\u0069\u006e\u0065\u0072\u0020\u003e\u0064\u0069\u0076\u003a\u006e\u0074\u0068\u002d\u0063\u0068\u0069\u006c\u0064\u0028\u0031\u0029`);
  if (!comment_input_el) {
    sendLog(`\u6ca1\u6709\u627e\u5230\u8f93\u5165\u8bc4\u8bba\u7684\u8f93\u5165\u6846`);
    return;
  }
  await click_button(comment_input_el);
  if (!(await checkDomPromise(`\u002e\u006e\u006f\u0074\u0072\u0061\u006e\u0073\u006c\u0061\u0074\u0065\u002e\u0070\u0075\u0062\u006c\u0069\u0063\u002d\u0044\u0072\u0061\u0066\u0074\u0045\u0064\u0069\u0074\u006f\u0072\u002d\u0063\u006f\u006e\u0074\u0065\u006e\u0074`))) {
    sendLog(`\u6ca1\u6709\u627e\u5230\u0020\u0023\u0063\u006f\u006e\u0074\u0065\u006e\u0074\u002d\u0074\u0065\u0078\u0074\u0061\u0072\u0065\u0061`);
    return;
  }
  const targetElement = document.querySelector(`\u002e\u006e\u006f\u0074\u0072\u0061\u006e\u0073\u006c\u0061\u0074\u0065\u002e\u0070\u0075\u0062\u006c\u0069\u0063\u002d\u0044\u0072\u0061\u0066\u0074\u0045\u0064\u0069\u0074\u006f\u0072\u002d\u0063\u006f\u006e\u0074\u0065\u006e\u0074`);
  if (!targetElement) {
    sendLog(`\u6ca1\u6709\u627e\u5230\u8f93\u5165\u6846`);
    return;
  }
  if (targetElement) {
    sendLog(`\u6267\u884c\u0020\u0074\u0061\u0072\u0067\u0065\u0074\u0045\u006c\u0065\u006d\u0065\u006e\u0074\uff1a` + store$1.chromeTabId);
    sendLog(`\u0061\u0064\u0064\u004c\u0069\u0073\u0074\u0065\u006e\u0065\u0072\u0028\u0071\u0075\u0065\u0072\u0079\u0041\u0063\u0074\u0069\u0076\u0065\u0045\u006c\u0065\u006d\u0065\u006e\u0074\u0029`);
    chrome.runtime.onMessage.addListener((request2, sender2, sendResponse2) => queryActiveElement(request2, sender2, sendResponse2, `\u002e\u006e\u006f\u0074\u0072\u0061\u006e\u0073\u006c\u0061\u0074\u0065\u002e\u0070\u0075\u0062\u006c\u0069\u0063\u002d\u0044\u0072\u0061\u0066\u0074\u0045\u0064\u0069\u0074\u006f\u0072\u002d\u0063\u006f\u006e\u0074\u0065\u006e\u0074`));
    await simulateInputSendMessage(content, 200, true, false);
    chrome.runtime.onMessage.removeListener((request2, sender2, sendResponse2) => queryActiveElement(request2, sender2, sendResponse2, `\u002e\u006e\u006f\u0074\u0072\u0061\u006e\u0073\u006c\u0061\u0074\u0065\u002e\u0070\u0075\u0062\u006c\u0069\u0063\u002d\u0044\u0072\u0061\u0066\u0074\u0045\u0064\u0069\u0074\u006f\u0072\u002d\u0063\u006f\u006e\u0074\u0065\u006e\u0074`));
  } else {
    sendLog(`\u0054\u0061\u0072\u0067\u0065\u0074\u0020\u0065\u006c\u0065\u006d\u0065\u006e\u0074\u0020\u006e\u006f\u0074\u0020\u0066\u006f\u0075\u006e\u0064\u002e`);
  }
  if (store$1.isNotRunWork()) {
    return;
  }
  const sendButtonQuerySelector = `\u002e\u0063\u006f\u006d\u006d\u0065\u006e\u0074\u0049\u006e\u0070\u0075\u0074\u002d\u0072\u0069\u0067\u0068\u0074\u002d\u0063\u0074\u0020\u0070\u0061\u0074\u0068`;
  if (!(await checkDomPromise(sendButtonQuerySelector))) {
    sendLog(`\u6ca1\u6709\u627e\u5230\u0020\u0023\u0063\u006f\u006e\u0074\u0065\u006e\u0074\u002d\u0074\u0065\u0078\u0074\u0061\u0072\u0065\u0061`);
    return;
  }
  let submit = null;
  let indexNum = 0;
  while (true) {
    if (indexNum > 60) {
      break;
    }
    if (indexNum > 1) {
      console.log(`\u0069\u006e\u0064\u0065\u0078\u004e\u0075\u006d`, indexNum++);
      await delay(1e3);
    }
    indexNum++;
    const submitList = Array.from(document.querySelectorAll(sendButtonQuerySelector));
    for (let i = 0; i < submitList.length; i++) {
      const submitTemp = submitList[i];
      if (submitTemp) {
        const fill = submitTemp.getAttribute(`\u0066\u0069\u006c\u006c`);
        if (fill == `\u0023\u0046\u0045\u0032\u0043\u0035\u0035`) {
          submit = submitTemp;
          sendLog(`\u901a\u8fc7\u0020\u0020\u0023\u0046\u0045\u0032\u0043\u0035\u0035\u0020\u627e\u5230\u4e86\u0073\u0075\u0062\u006d\u0069\u0074`);
          break;
        }
        const fillrule = submitTemp.getAttribute(`\u0066\u0069\u006c\u006c\u002d\u0072\u0075\u006c\u0065`);
        const fillOpacity = submitTemp.getAttribute(`\u0066\u0069\u006c\u006c\u002d\u006f\u0070\u0061\u0063\u0069\u0074\u0079`);
        if (fillrule == `\u0065\u0076\u0065\u006e\u006f\u0064\u0064` && !fillOpacity) {
          submit = submitTemp;
          sendLog(`\u901a\u8fc7\u0020\u0065\u0076\u0065\u006e\u006f\u0064\u0064\u0020\u0066\u0069\u006c\u006c\u004f\u0070\u0061\u0063\u0069\u0074\u0079\u0020\u627e\u5230\u4e86\u0073\u0075\u0062\u006d\u0069\u0074\u0020`);
          break;
        }
        const names = submitTemp.getAttributeNames();
        if (names) {
          const nameValue = [];
          names.forEach(name => {
            nameValue.push(name + `\u003a` + submitTemp.getAttribute(name));
          });
          sendLog(`\u0073\u0075\u0062\u006d\u0069\u0074\u004c\u0069\u0073\u0074\u0020\u006e\u0061\u006d\u0065\u0056\u0061\u006c\u0075\u0065\u0020\u003a` + nameValue.join(`\u002c`));
        }
      }
    }
    if (submit) {
      break;
    }
  }
  if (!submit) {
    sendLog(`\u70b9\u51fb\u53d1\u8868\u8bc4\u8bba\u5931\u8d25`);
    return;
  }
  await click_button(submit);
  indexNum = 0;
  while (true) {
    if (indexNum > 60) {
      break;
    }
    if (indexNum > 1) {
      console.log(`\u0069\u006e\u0064\u0065\u0078\u004e\u0075\u006d`, indexNum++);
      await delay(1e3);
    }
    indexNum++;
    const response_text_el = document.querySelector(`\u002e\u0070\u0075\u0062\u006c\u0069\u0063\u002d\u0044\u0072\u0061\u0066\u0074\u0045\u0064\u0069\u0074\u006f\u0072\u002d\u0063\u006f\u006e\u0074\u0065\u006e\u0074\u0020\u003e\u0020\u0064\u0069\u0076\u0020\u003e\u0020\u0064\u0069\u0076\u0020\u003e\u0020\u0064\u0069\u0076\u0020\u003e\u0020\u0073\u0070\u0061\u006e\u003a\u006e\u0074\u0068\u002d\u0063\u0068\u0069\u006c\u0064\u0028\u0031\u0029`);
    if (!response_text_el) {
      sendLog(`\u6ca1\u6709\u627e\u5230\u8f93\u5165\u6846`);
      continue;
    }
    let response_text = ((_b = response_text_el.textContent) == null ? void 0 : _b.trim()) || ``;
    if (response_text) {
      sendLog(`\u8f93\u5165\u6846\u4e0d\u4e3a\u7a7a`);
      continue;
    }
    break;
  }
  await delay(getRandomNumberInRange(2 * 1e3, 10 * 1e3));
  sendLog(`\u56de\u590d\u6210\u529f`);
};
const replyContent_PrivateMessage = async (content, sendButtonQuerySelector = `\u0064\u0069\u0076\u005b\u0064\u0061\u0074\u0061\u002d\u0065\u0032\u0065\u003d\u0022\u006d\u0073\u0067\u002d\u0069\u006e\u0070\u0075\u0074\u0022\u005d\u0020\u0070\u0061\u0074\u0068\u005b\u0066\u0069\u006c\u006c\u003d\u0022\u0023\u0046\u0045\u0032\u0043\u0035\u0035\u0022\u005d`) => {
  var _a;
  sendLog(`\u8fdb\u5165\u5230\u0072\u0065\u0070\u006c\u0079\u0043\u006f\u006e\u0074\u0065\u006e\u0074\u005f\u0050\u0072\u0069\u0076\u0061\u0074\u0065\u004d\u0065\u0073\u0073\u0061\u0067\u0065`);
  if (!(await checkDomPromise(`\u002e\u006e\u006f\u0074\u0072\u0061\u006e\u0073\u006c\u0061\u0074\u0065\u002e\u0070\u0075\u0062\u006c\u0069\u0063\u002d\u0044\u0072\u0061\u0066\u0074\u0045\u0064\u0069\u0074\u006f\u0072\u002d\u0063\u006f\u006e\u0074\u0065\u006e\u0074`))) {
    sendLog(`\u6ca1\u6709\u627e\u5230\u0020\u0023\u0063\u006f\u006e\u0074\u0065\u006e\u0074\u002d\u0074\u0065\u0078\u0074\u0061\u0072\u0065\u0061`);
    return;
  }
  const comment_input_el = document.querySelector(`\u002e\u006e\u006f\u0074\u0072\u0061\u006e\u0073\u006c\u0061\u0074\u0065\u002e\u0070\u0075\u0062\u006c\u0069\u0063\u002d\u0044\u0072\u0061\u0066\u0074\u0045\u0064\u0069\u0074\u006f\u0072\u002d\u0063\u006f\u006e\u0074\u0065\u006e\u0074`);
  if (!comment_input_el) {
    sendLog(`\u6ca1\u6709\u627e\u5230\u8f93\u5165\u8bc4\u8bba\u7684\u8f93\u5165\u6846`);
    return;
  }
  await click_button(comment_input_el);
  const targetElement = document.querySelector(`\u002e\u006e\u006f\u0074\u0072\u0061\u006e\u0073\u006c\u0061\u0074\u0065\u002e\u0070\u0075\u0062\u006c\u0069\u0063\u002d\u0044\u0072\u0061\u0066\u0074\u0045\u0064\u0069\u0074\u006f\u0072\u002d\u0063\u006f\u006e\u0074\u0065\u006e\u0074`);
  if (!targetElement) {
    sendLog(`\u6ca1\u6709\u627e\u5230\u8f93\u5165\u6846`);
    return;
  }
  if (targetElement) {
    sendLog(`\u6267\u884c\u0020\u0074\u0061\u0072\u0067\u0065\u0074\u0045\u006c\u0065\u006d\u0065\u006e\u0074\uff1a` + store$1.chromeTabId);
    sendLog(`\u0061\u0064\u0064\u004c\u0069\u0073\u0074\u0065\u006e\u0065\u0072\u0028\u0071\u0075\u0065\u0072\u0079\u0041\u0063\u0074\u0069\u0076\u0065\u0045\u006c\u0065\u006d\u0065\u006e\u0074\u0029`);
    chrome.runtime.onMessage.addListener((request2, sender2, sendResponse2) => queryActiveElement(request2, sender2, sendResponse2, `\u002e\u006e\u006f\u0074\u0072\u0061\u006e\u0073\u006c\u0061\u0074\u0065\u002e\u0070\u0075\u0062\u006c\u0069\u0063\u002d\u0044\u0072\u0061\u0066\u0074\u0045\u0064\u0069\u0074\u006f\u0072\u002d\u0063\u006f\u006e\u0074\u0065\u006e\u0074`));
    await simulateInputSendMessage(content, 200, true, false);
    chrome.runtime.onMessage.removeListener((request2, sender2, sendResponse2) => queryActiveElement(request2, sender2, sendResponse2, `\u002e\u006e\u006f\u0074\u0072\u0061\u006e\u0073\u006c\u0061\u0074\u0065\u002e\u0070\u0075\u0062\u006c\u0069\u0063\u002d\u0044\u0072\u0061\u0066\u0074\u0045\u0064\u0069\u0074\u006f\u0072\u002d\u0063\u006f\u006e\u0074\u0065\u006e\u0074`));
  } else {
    sendLog(`\u0054\u0061\u0072\u0067\u0065\u0074\u0020\u0065\u006c\u0065\u006d\u0065\u006e\u0074\u0020\u006e\u006f\u0074\u0020\u0066\u006f\u0075\u006e\u0064\u002e`);
  }
  if (store$1.isNotRunWork()) {
    return;
  }
  if (!(await checkDomPromise(sendButtonQuerySelector))) {
    sendLog(`\u6ca1\u6709\u627e\u5230\u0020\u0023\u0063\u006f\u006e\u0074\u0065\u006e\u0074\u002d\u0074\u0065\u0078\u0074\u0061\u0072\u0065\u0061`);
    return;
  }
  const submit = document.querySelector(sendButtonQuerySelector);
  if (!submit) {
    sendLog(`\u70b9\u51fb\u53d1\u8868\u8bc4\u8bba\u5931\u8d25`);
    return;
  }
  await click_button(submit);
  let indexNum = 0;
  while (true) {
    if (indexNum > 60) {
      break;
    }
    if (indexNum > 1) {
      console.log(`\u0069\u006e\u0064\u0065\u0078\u004e\u0075\u006d`, indexNum++);
      await delay(1e3);
    }
    indexNum++;
    const response_text_el = document.querySelector(`\u002e\u0070\u0075\u0062\u006c\u0069\u0063\u002d\u0044\u0072\u0061\u0066\u0074\u0045\u0064\u0069\u0074\u006f\u0072\u002d\u0063\u006f\u006e\u0074\u0065\u006e\u0074\u0020\u003e\u0020\u0064\u0069\u0076\u0020\u003e\u0020\u0064\u0069\u0076\u0020\u003e\u0020\u0064\u0069\u0076\u0020\u003e\u0020\u0073\u0070\u0061\u006e\u003a\u006e\u0074\u0068\u002d\u0063\u0068\u0069\u006c\u0064\u0028\u0031\u0029`);
    if (!response_text_el) {
      sendLog(`\u6ca1\u6709\u627e\u5230\u8f93\u5165\u6846`);
      continue;
    }
    let response_text = ((_a = response_text_el.textContent) == null ? void 0 : _a.trim()) || ``;
    if (response_text) {
      sendLog(`\u8f93\u5165\u6846\u4e0d\u4e3a\u7a7a`);
      continue;
    }
    break;
  }
  sendLog(`\u56de\u590d\u6210\u529f`);
};
const saveTerminalWebUserName = async () => {
  var _a, _b;
  if (!((_a = store$1 == null ? void 0 : store$1.terminalData) == null ? void 0 : _a.terminalId)) {
    sendLog(`\u7ec8\u7aef\u7684\u0069\u0064\u4e3a\u7a7a`);
    return;
  }
  const saveTerminalBindData = {
    "terminal_name": store$1.webUserName ? store$1.webUserName : `\u8bf7\u8bbe\u7f6e\u8bbe\u5907\u540d\u79f0`,
    "terminal_info": {
      "webUserName": store$1.webUserName,
      "webUserAvatarUrl": store$1.webUserAvatarUrl,
      "webUserId": store$1.webUserId
    }
  };
  const saveTerminalBindRes = await saveTerminalBind((_b = store$1 == null ? void 0 : store$1.terminalData) == null ? void 0 : _b.terminalId, saveTerminalBindData);
  sendLog(`\u0061\u0067\u0065\u006e\u0074\u0042\u0075\u0073\u0069\u006e\u0065\u0073\u0073\u0020\u0073\u0061\u0076\u0065\u0054\u0065\u0072\u006d\u0069\u006e\u0061\u006c\u0042\u0069\u006e\u0064\u0052\u0065\u0073\uff1a` + JSON.stringify(saveTerminalBindRes));
};
const store = UseCounterStore.getInstance();
let XiaoHongShu_Setting = JSON.parse(store.XiaoHongShu_Setting);
chrome.runtime.onMessage.addListener(async (request, sender, sendResponse) => {
  console.log(`\u0054\u0061\u0062\u0020\u6fc0\u6d3b\u4e86\u3002`, sender, request);
  if ((request == null ? void 0 : request.messageType) === `\u0074\u0061\u0062\u0043\u0068\u0061\u006e\u0067\u0065`) {
    if (!request.status) ;
    if (request.tabId != store.chromeTabId) {
      console.log(`\u5f53\u524d\u0074\u0061\u0062\u4e0d\u662f\u6fc0\u6d3b\u0074\u0061\u0062\u4e86`);
      const tabInfo = await getActivateTabId();
      if (tabInfo) {
        console.log(`\u5f53\u524d\u6fc0\u6d3b\u0074\u0061\u0062`, tabInfo);
      }
    }
    sendResponse(`\u6536\u5230\u6d88\u606f`);
    return false;
  }
});
storageUtil.startOnChangedListener();
let checkInterval = null;
function distributingTasks() {
  sendLog(`\u5f00\u59cb\u4efb\u52a1\u0064\u0069\u0073\u0074\u0072\u0069\u0062\u0075\u0074\u0069\u006e\u0067\u0054\u0061\u0073\u006b\u0073\u0020\u0073\u0074\u0061\u0072\u0074`);
  closeTabListener();
  store.setXiaoHongShu_workStatus(`\u0072\u0075\u006e`);
  let runBool = false;
  if (checkInterval) {
    clearInterval(checkInterval);
    checkInterval = null;
  }
  checkInterval = setInterval(async () => {
    var _a;
    if (runBool) {
      return;
    }
    runBool = true;
    try {
      await store.checkLoadend();
      clearInterval(checkInterval);
      checkInterval = null;
      sendLog(`\u5f00\u59cb\u4efb\u52a1\u0064\u0069\u0073\u0074\u0072\u0069\u0062\u0075\u0074\u0069\u006e\u0067\u0054\u0061\u0073\u006b\u0073`);
      if (!XiaoHongShu_Setting || Object.keys(XiaoHongShu_Setting).length == 0) {
        XiaoHongShu_Setting = JSON.parse(store.XiaoHongShu_Setting);
      }
      if (store.isNotRunWork()) {
        vipCloseEndFun(`\u0064\u0069\u0073\u0074\u0072\u0069\u0062\u0075\u0074\u0069\u006e\u0067\u0054\u0061\u0073\u006b\u0073`).then();
        return;
      }
      const taskData = await getTabTaskData();
      store.setChromeTabId(taskData == null ? void 0 : taskData.tabId);
      const taskPlatform = (_a = taskData == null ? void 0 : taskData.tabData) == null ? void 0 : _a.taskPlatform;
      console.log(`\u0063\u0068\u0072\u006f\u006d\u0065\u0054\u0061\u0062\u0049\u0064\u0020\u003a` + (taskData == null ? void 0 : taskData.tabId) + `\uff0c\u0074\u0061\u0073\u006b\u0050\u006c\u0061\u0074\u0066\u006f\u0072\u006d\uff1a` + taskPlatform);
      sendLog(`\u0063\u0068\u0072\u006f\u006d\u0065\u0054\u0061\u0062\u0049\u0064\u0020\u003a` + (taskData == null ? void 0 : taskData.tabId) + `\uff0c\u0074\u0061\u0073\u006b\u0050\u006c\u0061\u0074\u0066\u006f\u0072\u006d\uff1a` + taskPlatform);
      console.log(`\u0052\u0075\u006e\u006e\u0069\u006e\u0067\u0020\u0079\u006f\u0075\u0072\u0020\u0063\u006f\u0064\u0065`);
      store.setXiaoHongShu_workStatus(`\u0072\u0075\u006e`);
      if (taskPlatform == `\u5c0f\u7ea2\u4e66`) {
        runYourCode();
      }
      if (taskPlatform == `\u6296\u97f3`) {
        douYin_RunYourCode();
      }
    } catch (error) {
      console.log(`\u0064\u0069\u0073\u0074\u0072\u0069\u0062\u0075\u0074\u0069\u006e\u0067\u0054\u0061\u0073\u006b\u0073\u0020\u0065\u0072\u0072\u006f\u0072`, error);
    } finally {
      runBool = false;
    }
  }, 1e3);
  setTimeout(() => {
    clearInterval(checkInterval);
    checkInterval = null;
    console.log(`\u0046\u0069\u006e\u0069\u0073\u0068\u0065\u0064\u0020\u0063\u0068\u0065\u0063\u006b\u0069\u006e\u0067\u0020\u006c\u006f\u0067\u0069\u006e\u0020\u0073\u0074\u0061\u0074\u0075\u0073\u002e`);
  }, 10 * 60 * getRandomNumberInRange(1e3, 5e3));
}
console.log(`\u0043\u006f\u006e\u0074\u0065\u006e\u0074\u0020\u0073\u0063\u0072\u0069\u0070\u0074\u0020\u006c\u006f\u0061\u0064\u0065\u0064\u003a`, window.location.href);
if (document.readyState === `\u0063\u006f\u006d\u0070\u006c\u0065\u0074\u0065` || document.readyState === `\u0069\u006e\u0074\u0065\u0072\u0061\u0063\u0074\u0069\u0076\u0065`) {
  console.log(`\u0044\u006f\u0063\u0075\u006d\u0065\u006e\u0074\u0020\u0061\u006c\u0072\u0065\u0061\u0064\u0079\u0020\u006c\u006f\u0061\u0064\u0065\u0064`, document.readyState);
  distributingTasks();
}