var __defProp = Object.defineProperty;
var __defNormalProp = (obj, key, value) => key in obj ? __defProp(obj, key, {
  enumerable: true,
  configurable: true,
  writable: true,
  value
}) : obj[key] = value;
var __publicField = (obj, key, value) => __defNormalProp(obj, typeof key !== `\u0073\u0079\u006d\u0062\u006f\u006c` ? key + `` : key, value);
import { _ as _export_sfc } from "./js-_plugin-vue_export-helper.js";
import { d as defineComponent, j as onMounted, w as watch, D as onUnmounted, c as createElementBlock, o as openBlock, Q as normalizeStyle, J as createBlock, K as withCtx, M as createVNode, u as unref, r as ref, V as reactive, a as createBaseVNode, G as createCommentVNode, P as toDisplayString, a3 as createTextVNode, k as inject, R as onBeforeUnmount, H as Fragment, af as renderList, al as createApp } from "./js-@vue.js";
import { v as ElRow, w as ElCol, x as ElStatistic, y as ElSegmented, g as ElButton, z as ElDialog, u as ElForm, l as ElFormItem, e as ElInput, c as ElLoading, a as ElMessage } from "./js-element-plus.js";
import { i as init } from "./js-echarts.js";
import { c as createPinia, d as defineStore, s as setActivePinia } from "./js-pinia.js";
import { i as indexPage } from "./js-indexConfig.js";
import { _ as _imports_0$1, a as _imports_1$1, b as _imports_2 } from "./js-executeButton3.js";
import { t as search_default } from "./js-@element-plus.js";
import { g as getLocalizedMessage, a as splitChineseAndEnglish, s as setLocale } from "./js-i18n.js";
import { i as index } from "./js-vue3-lottie.js";
import "./js-dayjs.js";
import "./js-clientjs.js";
import "./js-lodash-es.js";
import "./js-@vueuse.js";
import "./js-async-validator.js";
import "./js-@popperjs.js";
import "./js-normalize-wheel-es.js";
import "./js-memoize-one.js";
import "./js-@ctrl.js";
import "./js-zrender.js";
import "./js-lottie-web.js";
const _hoisted_1$5 = [`\u0069\u0064`];
const _sfc_main$6 = /* @__PURE__ */defineComponent({
  __name: `\u0072\u0075\u006e\u0045\u0063\u0068\u0061\u0072\u0074\u0073\u0052\u0065\u0070\u006f\u0072\u0074`,
  props: {
    option: {
      type: Object,
      default: () => ({})
    },
    id: {
      type: String,
      default: () => Math.random().toString(36).substring(2, 8)
    },
    width: {
      type: String,
      default: `\u0031\u0030\u0030\u0025`
    },
    height: {
      type: String,
      default: `\u0033\u0035\u0030\u0070\u0078`
    },
    autoResize: {
      type: Boolean,
      default: true
    }
  },
  setup(__props) {
    const props = __props;
    let myChart = null;
    onMounted(() => {
      myChart = init(document.getElementById(props.id));
      myChart.setOption(props.option);
      if (props.autoResize) {
        window.addEventListener(`\u0072\u0065\u0073\u0069\u007a\u0065`, () => {
          myChart == null ? void 0 : myChart.resize();
        });
      }
    });
    watch(props.option, () => {
      if (myChart) {
        myChart.setOption(props.option);
      }
    }, {
      deep: true
    });
    onUnmounted(() => {
      if (props.autoResize) {
        window.removeEventListener(`\u0072\u0065\u0073\u0069\u007a\u0065`, () => {
          myChart == null ? void 0 : myChart.resize();
        });
      }
      myChart == null ? void 0 : myChart.dispose();
    });
    return (_ctx, _cache) => {
      return openBlock(), createElementBlock(`\u0064\u0069\u0076`, {
        style: normalizeStyle({
          width: __props.width,
          height: __props.height
        }),
        id: props.id
      }, null, 12, _hoisted_1$5);
    };
  }
});
const pinia = createPinia();
const _StorageUtil = class _StorageUtil {
  constructor() {
    __publicField(this, `\u006f\u006e\u0043\u0061\u006c\u006c\u0042\u0061\u0063\u006b\u0048\u0061\u006e\u0064\u006c\u0065\u0072\u0073`);
    this.onCallBackHandlers = [];
  }
  // 获取唯一实例的方法
  static getInstance() {
    if (!_StorageUtil.instance) {
      _StorageUtil.instance = new _StorageUtil();
    }
    return _StorageUtil.instance;
  }
  addHandlers(handler) {
    this.onCallBackHandlers.push(handler);
  }
  removeListener(handler) {
    let removeIndex = -1;
    for (let i = 0; i < this.onCallBackHandlers.length; i++) {
      if (this.onCallBackHandlers[i] === handler) {
        removeIndex = i;
        break;
      }
    }
    if (removeIndex !== -1) {
      this.onCallBackHandlers.splice(removeIndex, 1);
    }
  }
  startOnChangedListener() {
    chrome.storage.onChanged.addListener((changes, namespace) => {
      this.onCallBackHandlers.forEach(onCallBackHandler => {
        onCallBackHandler(changes, namespace);
      });
    });
  }
};
__publicField(_StorageUtil, `\u0069\u006e\u0073\u0074\u0061\u006e\u0063\u0065`);
let StorageUtil = _StorageUtil;
let storageUtil = StorageUtil.getInstance();
const useCounterStore = defineStore(`\u0063\u006f\u0075\u006e\u0074\u0065\u0072`, {
  state: () => ({
    userId: ``,
    tenantId: ``,
    tenantName: ``,
    terminalData: {
      "terminalName": ``
    },
    userName: ``,
    //当前页面
    activatePage: indexPage,
    //配置
    XiaoHongShu_Setting: `\u007b\u007d`,
    //评论数量
    XiaoHongShu_viewCount: 0,
    XiaoHongShu_CommentCount: 0,
    XiaoHongShu_likeCount: 0,
    XiaoHongShu_followCount: 0,
    XiaoHongShu_collectCount: 0,
    //评论数量
    xhs_viewCount: 0,
    xhs_CommentCount: 0,
    xhs_likeCount: 0,
    xhs_followCount: 0,
    xhs_collectCount: 0,
    //评论数量
    dy_viewCount: 0,
    dy_CommentCount: 0,
    dy_likeCount: 0,
    dy_followCount: 0,
    dy_collectCount: 0,
    //工作状态
    // run：工作中
    // end: 已结束（到达底部）
    XiaoHongShu_workStatus: `\u0072\u0075\u006e`,
    checkUpdateDateStr: ``,
    update: false,
    loadend: false,
    isDebugMode: false,
    loadFromStorage_load: false,
    accessToken: ``,
    // vip到期时间
    userInfoEndDate: ``,
    //今日运行时间
    runTodayDate: ``,
    //今日运行次数
    runTodayNum: 0,
    //今日运行最大次数
    runTodayMaxNum: 3,
    //vip日期更新
    updateVipDateTime: ``,
    // optionsPageName 页面
    optionsPageName: ``,
    loginAuthUrl: ``,
    buyUrl: ``,
    accessToken_request_id: ``,
    gotoYearBuyOrderId: ``,
    //客户端id
    clientVisitorId: ``,
    executeOperationStartTime: 0,
    executeOperationEndTime: 0,
    //小红书 关键词 列表
    xhs_keywords_list: [],
    douYin_keywords_list: [],
    xhs_minute: [],
    dy_minute: []
  }),
  actions: {
    set_checkUpdateDateStr(checkUpdateDateStr) {
      this.checkUpdateDateStr = checkUpdateDateStr;
      chrome.storage.local.set({
        "checkUpdateDateStr": this.checkUpdateDateStr
      });
    },
    set_updateVipDateTime(updateVipDateTime) {
      this.updateVipDateTime = updateVipDateTime;
      chrome.storage.local.set({
        "updateVipDateTime": this.updateVipDateTime
      });
    },
    set_update(update) {
      this.update = update;
      chrome.storage.local.set({
        "update": this.update
      });
    },
    setXiaoHongShu_viewCount(count) {
      this.XiaoHongShu_viewCount = count;
      chrome.storage.local.set({
        "XiaoHongShu_viewCount": this.XiaoHongShu_viewCount
      });
    },
    setXiaoHongShu_CommentCount(count) {
      this.XiaoHongShu_CommentCount = count;
      chrome.storage.local.set({
        "XiaoHongShu_CommentCount": this.XiaoHongShu_CommentCount
      });
    },
    setXiaoHongShu_likeCount(count) {
      this.XiaoHongShu_likeCount = count;
      chrome.storage.local.set({
        "XiaoHongShu_likeCount": this.XiaoHongShu_likeCount
      });
    },
    setXiaoHongShu_followCount(count) {
      this.XiaoHongShu_followCount = count;
      chrome.storage.local.set({
        "XiaoHongShu_followCount": this.XiaoHongShu_followCount
      });
    },
    setXiaoHongShu_collectCount(count) {
      this.XiaoHongShu_collectCount = count;
      chrome.storage.local.set({
        "XiaoHongShu_collectCount": this.XiaoHongShu_collectCount
      });
    },
    setXiaoHongShu_workStatus(status) {
      this.XiaoHongShu_workStatus = status;
    },
    setUserId(userId) {
      this.userId = userId;
      chrome.storage.local.set({
        "userId": this.userId
      });
    },
    setTenantId(tenantId) {
      this.tenantId = tenantId;
      chrome.storage.local.set({
        "tenantId": this.tenantId
      });
    },
    setTenantName(tenantName) {
      this.tenantName = tenantName;
      chrome.storage.local.set({
        "tenantName": this.tenantName
      });
    },
    setTerminalData(terminalData) {
      this.terminalData = terminalData;
      chrome.storage.local.set({
        "terminalData": JSON.stringify(terminalData)
      });
    },
    setUserName(userName) {
      this.userName = userName;
      chrome.storage.local.set({
        "userName": this.userName
      });
    },
    setAccessToken(accessToken) {
      this.accessToken = accessToken;
      chrome.storage.local.set({
        "accessToken": this.accessToken
      });
    },
    setOptionsPageName(optionsPageName) {
      this.optionsPageName = optionsPageName;
    },
    setLoginAuthUrl(loginAuthUrl) {
      this.loginAuthUrl = loginAuthUrl;
    },
    setBuyUrl(buyUrl) {
      this.buyUrl = buyUrl;
    },
    setAccessToken_request_id2(request_id) {
      this.accessToken_request_id = request_id;
    },
    setAccessToken_request_id(request_id) {
      this.accessToken_request_id = request_id;
      chrome.storage.local.set({
        "accessToken_request_id": this.accessToken_request_id
      });
    },
    setGotoYearBuyOrderId(gotoYearBuyOrderId) {
      this.gotoYearBuyOrderId = gotoYearBuyOrderId;
    },
    setActivatePage(page) {
      this.activatePage = page;
    },
    setXiaoHongShu_Setting(setting) {
      this.XiaoHongShu_Setting = setting;
      chrome.storage.local.set({
        "XiaoHongShu_Setting": this.XiaoHongShu_Setting
      });
    },
    setOperationTime(operationTime) {
      chrome.storage.local.set({
        "operationTime": operationTime
      });
    },
    setUserInfoEndDate(userInfoEndDate) {
      this.userInfoEndDate = userInfoEndDate;
      chrome.storage.local.set({
        "userInfoEndDate": userInfoEndDate
      });
    },
    increment_RunTodayNum() {
      this.runTodayNum++;
      chrome.storage.local.set({
        "runTodayNum": this.runTodayNum
      });
    },
    setRunTodayNum(runTodayNum) {
      this.runTodayNum = runTodayNum;
      chrome.storage.local.set({
        "runTodayNum": this.runTodayNum
      });
    },
    setRunTodayDate(runTodayDate) {
      this.runTodayDate = runTodayDate;
      chrome.storage.local.set({
        "runTodayDate": this.runTodayDate
      });
    },
    setClientVisitorId(clientVisitorId) {
      this.clientVisitorId = clientVisitorId;
      chrome.storage.local.set({
        "clientVisitorId": clientVisitorId
      });
    },
    checkLoadend() {
      let maxNum = 60,
        timeout = 30;
      let num = 0;
      return new Promise(resolve => {
        const checkInterval = setInterval(() => {
          const loadend = this.loadend;
          if (loadend || num > maxNum) {
            if (num > maxNum) {
              console.error(`\u0063\u0068\u0065\u0063\u006b\u004c\u006f\u0061\u0064\u0065\u006e\u0064\u0020\u52a0\u8f7d\u8d85\u65f6`);
            }
            clearInterval(checkInterval);
            resolve();
          }
          num++;
        }, timeout);
      });
    },
    loadFromStorage() {
      if (this.loadFromStorage_load) {
        return;
      }
      this.loadFromStorage_load = true;
      chrome.storage.local.get([`\u0063\u0068\u0065\u0063\u006b\u0055\u0070\u0064\u0061\u0074\u0065\u0044\u0061\u0074\u0065\u0053\u0074\u0072`, `\u0075\u0070\u0064\u0061\u0074\u0065\u0056\u0069\u0070\u0044\u0061\u0074\u0065\u0054\u0069\u006d\u0065`, `\u0075\u0073\u0065\u0072\u0049\u006e\u0066\u006f\u0045\u006e\u0064\u0044\u0061\u0074\u0065`, `\u0075\u0070\u0064\u0061\u0074\u0065`, `\u0075\u0073\u0065\u0072\u0049\u0064`, `\u0075\u0073\u0065\u0072\u004e\u0061\u006d\u0065`, `\u0061\u0063\u0063\u0065\u0073\u0073\u0054\u006f\u006b\u0065\u006e`, `\u0061\u0063\u0074\u0069\u0076\u0061\u0074\u0065\u0050\u0061\u0067\u0065`, `\u0058\u0069\u0061\u006f\u0048\u006f\u006e\u0067\u0053\u0068\u0075\u005f\u0053\u0065\u0074\u0074\u0069\u006e\u0067`, `\u0058\u0069\u0061\u006f\u0048\u006f\u006e\u0067\u0053\u0068\u0075\u005f\u0076\u0069\u0065\u0077\u0043\u006f\u0075\u006e\u0074`, `\u0058\u0069\u0061\u006f\u0048\u006f\u006e\u0067\u0053\u0068\u0075\u005f\u0043\u006f\u006d\u006d\u0065\u006e\u0074\u0043\u006f\u0075\u006e\u0074`, `\u0058\u0069\u0061\u006f\u0048\u006f\u006e\u0067\u0053\u0068\u0075\u005f\u006c\u0069\u006b\u0065\u0043\u006f\u0075\u006e\u0074`, `\u0058\u0069\u0061\u006f\u0048\u006f\u006e\u0067\u0053\u0068\u0075\u005f\u0066\u006f\u006c\u006c\u006f\u0077\u0043\u006f\u0075\u006e\u0074`, `\u0058\u0069\u0061\u006f\u0048\u006f\u006e\u0067\u0053\u0068\u0075\u005f\u0063\u006f\u006c\u006c\u0065\u0063\u0074\u0043\u006f\u0075\u006e\u0074`, `\u0078\u0068\u0073\u005f\u0076\u0069\u0065\u0077\u0043\u006f\u0075\u006e\u0074`, `\u0078\u0068\u0073\u005f\u0043\u006f\u006d\u006d\u0065\u006e\u0074\u0043\u006f\u0075\u006e\u0074`, `\u0078\u0068\u0073\u005f\u006c\u0069\u006b\u0065\u0043\u006f\u0075\u006e\u0074`, `\u0078\u0068\u0073\u005f\u0066\u006f\u006c\u006c\u006f\u0077\u0043\u006f\u0075\u006e\u0074`, `\u0078\u0068\u0073\u005f\u0063\u006f\u006c\u006c\u0065\u0063\u0074\u0043\u006f\u0075\u006e\u0074`, `\u0064\u0079\u005f\u0076\u0069\u0065\u0077\u0043\u006f\u0075\u006e\u0074`, `\u0064\u0079\u005f\u0043\u006f\u006d\u006d\u0065\u006e\u0074\u0043\u006f\u0075\u006e\u0074`, `\u0064\u0079\u005f\u006c\u0069\u006b\u0065\u0043\u006f\u0075\u006e\u0074`, `\u0064\u0079\u005f\u0066\u006f\u006c\u006c\u006f\u0077\u0043\u006f\u0075\u006e\u0074`, `\u0064\u0079\u005f\u0063\u006f\u006c\u006c\u0065\u0063\u0074\u0043\u006f\u0075\u006e\u0074`, `\u0058\u0069\u0061\u006f\u0048\u006f\u006e\u0067\u0053\u0068\u0075\u005f\u0077\u006f\u0072\u006b\u0053\u0074\u0061\u0074\u0075\u0073`, `\u0072\u0075\u006e\u0054\u006f\u0064\u0061\u0079\u0044\u0061\u0074\u0065`, `\u0072\u0075\u006e\u0054\u006f\u0064\u0061\u0079\u004e\u0075\u006d`, `\u006f\u0070\u0074\u0069\u006f\u006e\u0073\u0050\u0061\u0067\u0065\u004e\u0061\u006d\u0065`, `\u006c\u006f\u0067\u0069\u006e\u0041\u0075\u0074\u0068\u0055\u0072\u006c`, `\u0062\u0075\u0079\u0055\u0072\u006c`, `\u0061\u0063\u0063\u0065\u0073\u0073\u0054\u006f\u006b\u0065\u006e\u005f\u0072\u0065\u0071\u0075\u0065\u0073\u0074\u005f\u0069\u0064`, `\u0067\u006f\u0074\u006f\u0059\u0065\u0061\u0072\u0042\u0075\u0079\u004f\u0072\u0064\u0065\u0072\u0049\u0064`, `\u0063\u006c\u0069\u0065\u006e\u0074\u0056\u0069\u0073\u0069\u0074\u006f\u0072\u0049\u0064`, `\u0065\u0078\u0065\u0063\u0075\u0074\u0065\u004f\u0070\u0065\u0072\u0061\u0074\u0069\u006f\u006e\u0053\u0074\u0061\u0072\u0074\u0054\u0069\u006d\u0065`, `\u0065\u0078\u0065\u0063\u0075\u0074\u0065\u004f\u0070\u0065\u0072\u0061\u0074\u0069\u006f\u006e\u0045\u006e\u0064\u0054\u0069\u006d\u0065`, `\u0078\u0068\u0073\u005f\u006b\u0065\u0079\u0077\u006f\u0072\u0064\u0073\u005f\u006c\u0069\u0073\u0074`, `\u0064\u006f\u0075\u0059\u0069\u006e\u005f\u006b\u0065\u0079\u0077\u006f\u0072\u0064\u0073\u005f\u006c\u0069\u0073\u0074`, `\u0078\u0068\u0073\u005f\u006d\u0069\u006e\u0075\u0074\u0065`, `\u0064\u0079\u005f\u006d\u0069\u006e\u0075\u0074\u0065`, `\u0074\u0065\u0072\u006d\u0069\u006e\u0061\u006c\u0044\u0061\u0074\u0061`], result => {
        console.log(`\u0072\u0065\u0073\u0075\u006c\u0074\u0020\u0061\u0063\u0074\u0069\u0076\u0061\u0074\u0065\u0050\u0061\u0067\u0065`, result);
        if (result.checkUpdateDateStr !== void 0) {
          this.checkUpdateDateStr = result.checkUpdateDateStr;
        }
        if (result.updateVipDateTime !== void 0) {
          this.updateVipDateTime = result.updateVipDateTime;
        }
        if (result.userInfoEndDate !== void 0) {
          this.userInfoEndDate = result.userInfoEndDate;
        }
        if (result.update !== void 0) {
          this.update = result.update;
        }
        if (result.userId !== void 0) {
          this.userId = result.userId;
        }
        if (result.userName !== void 0) {
          this.userName = result.userName;
        }
        if (result.accessToken !== void 0) {
          this.accessToken = result.accessToken;
        }
        if (result.activatePage !== void 0) {
          this.activatePage = result.activatePage;
        }
        if (result.XiaoHongShu_Setting !== void 0) {
          this.XiaoHongShu_Setting = result.XiaoHongShu_Setting;
        }
        if (result.XiaoHongShu_viewCount !== void 0) {
          this.XiaoHongShu_viewCount = result.XiaoHongShu_viewCount;
        }
        if (result.XiaoHongShu_CommentCount !== void 0) {
          this.XiaoHongShu_CommentCount = result.XiaoHongShu_CommentCount;
        }
        if (result.XiaoHongShu_likeCount !== void 0) {
          this.XiaoHongShu_likeCount = result.XiaoHongShu_likeCount;
        }
        if (result.XiaoHongShu_followCount !== void 0) {
          this.XiaoHongShu_followCount = result.XiaoHongShu_followCount;
        }
        if (result.XiaoHongShu_collectCount !== void 0) {
          this.XiaoHongShu_collectCount = result.XiaoHongShu_collectCount;
        }
        if (result.xhs_viewCount !== void 0) {
          this.xhs_viewCount = result.xhs_viewCount;
        }
        if (result.xhs_CommentCount !== void 0) {
          this.xhs_CommentCount = result.xhs_CommentCount;
        }
        if (result.xhs_likeCount !== void 0) {
          this.xhs_likeCount = result.xhs_likeCount;
        }
        if (result.xhs_followCount !== void 0) {
          this.xhs_followCount = result.xhs_followCount;
        }
        if (result.xhs_collectCount !== void 0) {
          this.xhs_collectCount = result.xhs_collectCount;
        }
        if (result.dy_viewCount !== void 0) {
          this.dy_viewCount = result.dy_viewCount;
        }
        if (result.dy_CommentCount !== void 0) {
          this.dy_CommentCount = result.dy_CommentCount;
        }
        if (result.dy_likeCount !== void 0) {
          this.dy_likeCount = result.dy_likeCount;
        }
        if (result.dy_followCount !== void 0) {
          this.dy_followCount = result.dy_followCount;
        }
        if (result.dy_collectCount !== void 0) {
          this.dy_collectCount = result.dy_collectCount;
        }
        if (result.XiaoHongShu_workStatus !== void 0) {
          this.XiaoHongShu_workStatus = result.XiaoHongShu_workStatus;
        }
        if (result.runTodayDate !== void 0) {
          this.runTodayDate = result.runTodayDate;
        }
        if (result.runTodayNum !== void 0) {
          this.runTodayNum = result.runTodayNum;
        }
        if (result.optionsPageName !== void 0) {
          this.optionsPageName = result.optionsPageName;
        }
        if (result.loginAuthUrl !== void 0) {
          this.loginAuthUrl = result.loginAuthUrl;
        }
        if (result.buyUrl !== void 0) {
          this.buyUrl = result.buyUrl;
        }
        if (result.accessToken_request_id !== void 0) {
          this.accessToken_request_id = result.accessToken_request_id;
        }
        if (result.gotoYearBuyOrderId !== void 0) {
          this.gotoYearBuyOrderId = result.gotoYearBuyOrderId;
        }
        if (result.clientVisitorId !== void 0) {
          this.clientVisitorId = result.clientVisitorId;
        }
        if (result.executeOperationStartTime !== void 0) {
          this.executeOperationStartTime = result.executeOperationStartTime;
        }
        if (result.executeOperationEndTime !== void 0) {
          this.executeOperationEndTime = result.executeOperationEndTime;
        }
        if (result.xhs_keywords_list !== void 0) {
          this.xhs_keywords_list = result.xhs_keywords_list ? JSON.parse(result.xhs_keywords_list) : [];
        }
        if (result.douYin_keywords_list !== void 0) {
          this.douYin_keywords_list = result.douYin_keywords_list ? JSON.parse(result.douYin_keywords_list) : [];
        }
        if (result.xhs_minute !== void 0) {
          this.xhs_minute = result.xhs_minute ? JSON.parse(result.xhs_minute) : [];
        }
        if (result.dy_minute !== void 0) {
          this.dy_minute = result.dy_minute ? JSON.parse(result.dy_minute) : [];
        }
        if (result.terminalData !== void 0) {
          this.terminalData = result.terminalData ? JSON.parse(result.terminalData) : {};
        }
        this.loadend = true;
      });
      storageUtil.addHandlers((changes, namespace) => {
        for (let [key, {
          oldValue,
          newValue
        }] of Object.entries(changes)) {
          console.log(`\u0063\u006f\u0075\u006e\u0074\u0065\u0072\u0020\u0053\u0074\u006f\u0072\u0061\u0067\u0065\u0020\u006b\u0065\u0079\u0020\u0022${key}\u0022\u0020\u0069\u006e\u0020\u006e\u0061\u006d\u0065\u0073\u0070\u0061\u0063\u0065\u0020\u0022${namespace}\u0022\u0020\u0063\u0068\u0061\u006e\u0067\u0065\u0064\u002e`, `\u004f\u006c\u0064\u0020\u0076\u0061\u006c\u0075\u0065\u0020\u0077\u0061\u0073\u0020\u0022${oldValue}\u0022\u002c\u0020\u006e\u0065\u0077\u0020\u0076\u0061\u006c\u0075\u0065\u0020\u0069\u0073\u0020\u0022${newValue}\u0022\u002e`);
          switch (key) {
            case `\u0061\u0063\u0074\u0069\u0076\u0061\u0074\u0065\u0050\u0061\u0067\u0065`:
              this.activatePage = newValue;
              break;
            case `\u0058\u0069\u0061\u006f\u0048\u006f\u006e\u0067\u0053\u0068\u0075\u005f\u0043\u006f\u006d\u006d\u0065\u006e\u0074\u0043\u006f\u0075\u006e\u0074`:
              this.XiaoHongShu_CommentCount = newValue;
              break;
            case `\u0058\u0069\u0061\u006f\u0048\u006f\u006e\u0067\u0053\u0068\u0075\u005f\u006c\u0069\u006b\u0065\u0043\u006f\u0075\u006e\u0074`:
              this.XiaoHongShu_likeCount = newValue;
              break;
            case `\u0058\u0069\u0061\u006f\u0048\u006f\u006e\u0067\u0053\u0068\u0075\u005f\u0066\u006f\u006c\u006c\u006f\u0077\u0043\u006f\u0075\u006e\u0074`:
              this.XiaoHongShu_followCount = newValue;
              break;
            case `\u0058\u0069\u0061\u006f\u0048\u006f\u006e\u0067\u0053\u0068\u0075\u005f\u0063\u006f\u006c\u006c\u0065\u0063\u0074\u0043\u006f\u0075\u006e\u0074`:
              this.XiaoHongShu_collectCount = newValue;
              break;
            case `\u0058\u0069\u0061\u006f\u0048\u006f\u006e\u0067\u0053\u0068\u0075\u005f\u0076\u0069\u0065\u0077\u0043\u006f\u0075\u006e\u0074`:
              this.XiaoHongShu_viewCount = newValue;
              break;
            case `\u0058\u0069\u0061\u006f\u0048\u006f\u006e\u0067\u0053\u0068\u0075\u005f\u0077\u006f\u0072\u006b\u0053\u0074\u0061\u0074\u0075\u0073`:
              this.XiaoHongShu_workStatus = newValue;
              break;
            case `\u0061\u0063\u0063\u0065\u0073\u0073\u0054\u006f\u006b\u0065\u006e`:
              this.accessToken = newValue;
              this.setActivatePage(indexPage);
              break;
            case `\u0063\u006c\u0069\u0065\u006e\u0074\u0056\u0069\u0073\u0069\u0074\u006f\u0072\u0049\u0064`:
              this.clientVisitorId = newValue;
              break;
            case `\u0065\u0078\u0065\u0063\u0075\u0074\u0065\u004f\u0070\u0065\u0072\u0061\u0074\u0069\u006f\u006e\u0053\u0074\u0061\u0072\u0074\u0054\u0069\u006d\u0065`:
              this.executeOperationStartTime = newValue;
              break;
            case `\u0074\u0065\u0072\u006d\u0069\u006e\u0061\u006c\u0044\u0061\u0074\u0061`:
              this.terminalData = newValue ? JSON.parse(newValue) : {};
          }
        }
      });
    }
  }
});
setActivePinia(pinia);
const store = useCounterStore();
const _sfc_main$5 = /* @__PURE__ */defineComponent({
  __name: `\u0072\u0075\u006e\u0053\u0074\u0061\u0074\u0069\u0073\u0074\u0069\u0063`,
  setup(__props) {
    return (_ctx, _cache) => {
      const _component_el_statistic = ElStatistic;
      const _component_el_col = ElCol;
      const _component_el_row = ElRow;
      return openBlock(), createBlock(_component_el_row, null, {
        default: withCtx(() => [createVNode(_component_el_col, {
          span: 4
        }, {
          default: withCtx(() => [createVNode(_component_el_statistic, {
            title: `\u6d4f\u89c8\u91cf`,
            value: unref(store).xhs_viewCount + unref(store).dy_viewCount
          }, null, 8, [`\u0076\u0061\u006c\u0075\u0065`])]),
          _: 1
        }), createVNode(_component_el_col, {
          span: 5
        }, {
          default: withCtx(() => [createVNode(_component_el_statistic, {
            title: `\u8bc4\u8bba\u6570`,
            value: unref(store).xhs_CommentCount + unref(store).dy_CommentCount
          }, null, 8, [`\u0076\u0061\u006c\u0075\u0065`])]),
          _: 1
        }), createVNode(_component_el_col, {
          span: 5
        }, {
          default: withCtx(() => [createVNode(_component_el_statistic, {
            title: `\u70b9\u8d5e\u6570`,
            value: unref(store).xhs_likeCount + unref(store).dy_likeCount
          }, null, 8, [`\u0076\u0061\u006c\u0075\u0065`])]),
          _: 1
        }), createVNode(_component_el_col, {
          span: 5
        }, {
          default: withCtx(() => [createVNode(_component_el_statistic, {
            title: `\u6536\u85cf\u6570`,
            value: unref(store).xhs_collectCount + unref(store).dy_collectCount
          }, null, 8, [`\u0076\u0061\u006c\u0075\u0065`])]),
          _: 1
        }), createVNode(_component_el_col, {
          span: 5
        }, {
          default: withCtx(() => [createVNode(_component_el_statistic, {
            title: `\u5173\u6ce8\u6570`,
            value: unref(store).xhs_followCount + unref(store).dy_followCount
          }, null, 8, [`\u0076\u0061\u006c\u0075\u0065`])]),
          _: 1
        })]),
        _: 1
      });
    };
  }
});
const RunStatistic = /* @__PURE__ */_export_sfc(_sfc_main$5, [[`\u005f\u005f\u0073\u0063\u006f\u0070\u0065\u0049\u0064`, `\u0064\u0061\u0074\u0061\u002d\u0076\u002d\u0064\u0038\u0063\u0035\u0033\u0033\u0061\u0063`]]);
const _hoisted_1$4 = {
  style: {
    "width": `\u0031\u0030\u0030\u0025`,
    "height": `\u0031\u0030\u0030\u0025`
  }
};
const _hoisted_2$3 = {
  style: {
    "margin-left": `\u0032\u0065\u006d`
  }
};
const _hoisted_3$3 = {
  style: {
    "height": `\u0032\u0036\u0070\u0078`,
    "line-height": `\u0032\u0036\u0070\u0078`,
    "font-size": `\u0031\u0034\u0070\u0078`
  }
};
const _hoisted_4$3 = {
  style: {
    "height": `\u0032\u0036\u0070\u0078`,
    "line-height": `\u0032\u0036\u0070\u0078`,
    "font-size": `\u0031\u0034\u0070\u0078`
  }
};
const _hoisted_5$3 = {
  style: {
    "height": `\u0032\u0036\u0070\u0078`,
    "line-height": `\u0032\u0036\u0070\u0078`,
    "font-size": `\u0031\u0034\u0070\u0078`
  }
};
const _hoisted_6$3 = {
  key: 0,
  style: {
    "height": `\u0032\u0036\u0070\u0078`,
    "line-height": `\u0032\u0036\u0070\u0078`,
    "font-size": `\u0031\u0034\u0070\u0078`
  }
};
const _hoisted_7$3 = {
  key: 1,
  style: {
    "height": `\u0032\u0036\u0070\u0078`,
    "line-height": `\u0032\u0036\u0070\u0078`,
    "margin-left": `\u0032\u0065\u006d`,
    "font-size": `\u0031\u0034\u0070\u0078`
  }
};
const _hoisted_8$2 = {
  key: 2,
  style: {
    "height": `\u0032\u0036\u0070\u0078`,
    "line-height": `\u0032\u0036\u0070\u0078`,
    "margin-left": `\u0032\u0065\u006d`,
    "font-size": `\u0031\u0034\u0070\u0078`
  }
};
const _hoisted_9$2 = {
  style: {
    "margin-left": `\u0032\u0065\u006d`
  }
};
const _hoisted_10$2 = {
  style: {
    "width": `\u0034\u0030\u0030\u0070\u0078`
  }
};
const _sfc_main$4 = /* @__PURE__ */defineComponent({
  __name: `\u0072\u0075\u006e\u0045\u0063\u0068\u0061\u0072\u0074\u0073\u0052\u0065\u0070\u006f\u0072\u0074\u0044\u0065\u006d\u006f`,
  setup(__props) {
    function formatTimestamp(timestamp) {
      const date = new Date(timestamp);
      const month = String(date.getMonth() + 1).padStart(2, `\u0030`);
      const day = String(date.getDate()).padStart(2, `\u0030`);
      const hours = String(date.getHours()).padStart(2, `\u0030`);
      const minutes = String(date.getMinutes()).padStart(2, `\u0030`);
      return `${month}\u002d${day}\u0020${hours}\u003a${minutes}`;
    }
    function calculateTimeDifference(startTimestamp, endTimestamp) {
      const differenceInMs = Math.abs(endTimestamp - startTimestamp);
      const totalMinutes = Math.floor(differenceInMs / (1e3 * 60));
      return `${totalMinutes}`;
    }
    const executeOperationStartTime = ref(formatTimestamp(store.executeOperationStartTime));
    const executeOperationEndTime = ref(formatTimestamp(store.executeOperationEndTime));
    const run_time = ref(calculateTimeDifference(store.executeOperationStartTime, store.executeOperationEndTime));
    const xhs_keywords_list_str = ref(``);
    if (store.xhs_keywords_list.length > 0) {
      xhs_keywords_list_str.value = store.xhs_keywords_list.join(`\uff0c`);
    }
    const douYin_keywords_list_str = ref(``);
    if (store.douYin_keywords_list.length > 0) {
      douYin_keywords_list_str.value = store.douYin_keywords_list.join(`\uff0c`);
    }
    let XiaoHongShu_Setting = JSON.parse(store.XiaoHongShu_Setting);
    const workRunPlatform = ref(``);
    if (XiaoHongShu_Setting.workDouYinPlatform) {
      if (!workRunPlatform.value) {
        workRunPlatform.value = XiaoHongShu_Setting.workDouYinPlatform;
      } else {
        workRunPlatform.value += `\u002b` + XiaoHongShu_Setting.workDouYinPlatform;
      }
    }
    if (XiaoHongShu_Setting.workXiaoHongShuPlatform) {
      if (!workRunPlatform.value) {
        workRunPlatform.value = XiaoHongShu_Setting.workXiaoHongShuPlatform;
      } else {
        workRunPlatform.value += `\u002b` + XiaoHongShu_Setting.workXiaoHongShuPlatform;
      }
    }
    reactive({
      title: {
        text: `\u0045\u0043\u0068\u0061\u0072\u0074\u0073\u0020\u5165\u95e8\u793a\u4f8b\u0032`
      },
      tooltip: {},
      xAxis: {
        data: [`\u886c\u886b`, `\u7f8a\u6bdb\u886b`, `\u96ea\u7eba\u886b`, `\u88e4\u5b50`, `\u9ad8\u8ddf\u978b`, `\u889c\u5b50`]
      },
      yAxis: {},
      series: [{
        name: `\u9500\u91cf`,
        type: `\u0062\u0061\u0072`,
        data: [5, 20, 36, 10, 10, 20]
      }]
    });
    const uniqueMinutes = [... /* @__PURE__ */new Set([...store.xhs_minute.map(item => item.minute), ...store.dy_minute.map(item => item.minute)])].sort((a, b) => a - b);
    const xhsNums = uniqueMinutes.map(minute => {
      var _a;
      return ((_a = store.xhs_minute.find(item => item.minute === minute)) == null ? void 0 : _a.num) || 0;
    });
    const dyNums = uniqueMinutes.map(minute => {
      var _a;
      return ((_a = store.dy_minute.find(item => item.minute === minute)) == null ? void 0 : _a.num) || 0;
    });
    let LineChartConfigRel = reactive({
      title: {
        text: ``
      },
      tooltip: {
        trigger: `\u0061\u0078\u0069\u0073`
      },
      legend: {
        data: [`\u5c0f\u7ea2\u4e66`, `\u6296\u97f3`]
      },
      grid: {
        left: `\u0033\u0025`,
        right: `\u0034\u0025`,
        bottom: `\u0033\u0025`,
        containLabel: true
      },
      toolbox: {
        feature: {
          saveAsImage: {}
        }
      },
      xAxis: {
        type: `\u0063\u0061\u0074\u0065\u0067\u006f\u0072\u0079`,
        boundaryGap: false,
        data: uniqueMinutes
      },
      yAxis: {
        type: `\u0076\u0061\u006c\u0075\u0065`
      },
      series: [{
        name: `\u5c0f\u7ea2\u4e66`,
        type: `\u006c\u0069\u006e\u0065`,
        stack: `\u0054\u006f\u0074\u0061\u006c`,
        data: xhsNums
      }, {
        name: `\u6296\u97f3`,
        type: `\u006c\u0069\u006e\u0065`,
        stack: `\u0054\u006f\u0074\u0061\u006c`,
        data: dyNums
      }]
    });
    let data = reactive({
      pieNumber: []
    });
    data.pieNumber = [{
      value: 10,
      name: `\u70b9\u8d5e`
    }, {
      value: 10,
      name: `\u8bc4\u8bba`
    }, {
      value: 10,
      name: `\u5173\u6ce8`
    }, {
      value: 20,
      name: `\u6536\u85cf`
    }];
    const setXHSPieData = () => {
      data.pieNumber = [{
        value: store.xhs_likeCount,
        name: `\u70b9\u8d5e`
      }, {
        value: store.xhs_CommentCount,
        name: `\u8bc4\u8bba`
      }, {
        value: store.xhs_followCount,
        name: `\u5173\u6ce8`
      }, {
        value: store.xhs_collectCount,
        name: `\u6536\u85cf`
      }];
    };
    const setDyPieData = () => {
      data.pieNumber = [{
        value: store.dy_likeCount,
        name: `\u70b9\u8d5e`
      }, {
        value: store.dy_CommentCount,
        name: `\u8bc4\u8bba`
      }, {
        value: store.dy_followCount,
        name: `\u5173\u6ce8`
      }, {
        value: store.dy_collectCount,
        name: `\u6536\u85cf`
      }];
    };
    const setAllPieData = () => {
      data.pieNumber = [{
        value: store.xhs_likeCount + store.dy_likeCount,
        name: `\u70b9\u8d5e`
      }, {
        value: store.xhs_CommentCount + store.dy_CommentCount,
        name: `\u8bc4\u8bba`
      }, {
        value: store.xhs_followCount + store.dy_followCount,
        name: `\u5173\u6ce8`
      }, {
        value: store.xhs_collectCount + store.dy_collectCount,
        name: `\u6536\u85cf`
      }];
    };
    let PieChartConfigRel = reactive({
      tooltip: {
        trigger: `\u0069\u0074\u0065\u006d`,
        formatter: `\u007b\u0061\u007d\u0020\u003c\u0062\u0072\u002f\u003e\u007b\u0062\u007d\u0020\u003a\u0020\u007b\u0063\u007d\u0020\u4e2a\u002c\u5360\u6bd4\uff1a\u0020\u0028\u007b\u0064\u007d\u0025\u0029`
      },
      legend: {
        orient: `\u0076\u0065\u0072\u0074\u0069\u0063\u0061\u006c`,
        position: `\u0072\u0069\u0067\u0068\u0074`,
        right: `\u0032\u0025`,
        top: `\u0032\u0030\u0025`,
        data: data.pieTitle
        //这里的渲染的数据需要与series里面渲染的数据中的name保持一致
      },
      series: [{
        name: `\u4efb\u52a1\u7c7b\u578b\u5360\u6bd4\u5206\u6790\u8868`,
        type: `\u0070\u0069\u0065`,
        radius: `\u0037\u0030\u0025`,
        center: [`\u0034\u0035\u0025`, `\u0035\u0035\u0025`],
        data: data.pieNumber,
        //渲染的数据
        emphasis: {
          itemStyle: {
            shadowBlur: 10,
            shadowOffsetX: 0,
            shadowColor: `\u0072\u0067\u0062\u0061\u0028\u0030\u002c\u0020\u0030\u002c\u0020\u0030\u002c\u0020\u0030\u002e\u0035\u0029`
          }
        },
        label: {
          show: true,
          // 显示标签
          formatter: `\u007b\u0062\u007d\uff1a\u007b\u0063\u007d\u0020\u4e2a\u002c\u5360\u6bd4\uff1a\u007b\u0064\u007d\u0025`
        }
      }]
    });
    setAllPieData();
    PieChartConfigRel.series[0].data = data.pieNumber;
    const PieChartValue = ref(`\u5168\u90e8`);
    const PieChartSegmentedOptions = reactive([`\u5168\u90e8`, `\u5c0f\u7ea2\u4e66`, `\u6296\u97f3`]);
    const segmentedChange = val => {
      if (val == `\u5168\u90e8`) {
        setAllPieData();
        PieChartConfigRel.series[0].data = data.pieNumber;
      } else if (val == `\u5c0f\u7ea2\u4e66`) {
        setXHSPieData();
        PieChartConfigRel.series[0].data = data.pieNumber;
      } else if (val == `\u6296\u97f3`) {
        setDyPieData();
        PieChartConfigRel.series[0].data = data.pieNumber;
      } else {
        console.log(``);
      }
    };
    console.log(`\u0072\u0075\u006e\u0045\u0063\u0068\u0061\u0072\u0074\u0073\u0052\u0065\u0070\u006f\u0072\u0074\u0044\u0065\u006d\u006f`);
    return (_ctx, _cache) => {
      const _component_el_segmented = ElSegmented;
      return openBlock(), createElementBlock(`\u0064\u0069\u0076`, _hoisted_1$4, [_cache[6] || (_cache[6] = createBaseVNode(`\u0064\u0069\u0076`, {
        style: {
          "height": `\u0033\u0034\u0070\u0078`,
          "line-height": `\u0033\u0034\u0070\u0078`,
          "font-weight": `\u0062\u006f\u006c\u0064\u0065\u0072`,
          "font-size": `\u0031\u0038\u0070\u0078`
        }
      }, `\u0031\u3001\u4efb\u52a1\u57fa\u672c\u4fe1\u606f`, -1)), createBaseVNode(`\u0064\u0069\u0076`, _hoisted_2$3, [createBaseVNode(`\u0064\u0069\u0076`, _hoisted_3$3, `\u65f6\u95f4\uff1a` + toDisplayString(executeOperationStartTime.value) + `\u81f3` + toDisplayString(executeOperationEndTime.value), 1), createBaseVNode(`\u0064\u0069\u0076`, _hoisted_4$3, `\u5e73\u53f0\uff1a` + toDisplayString(workRunPlatform.value), 1), createBaseVNode(`\u0064\u0069\u0076`, _hoisted_5$3, `\u672c\u6b21\u8fd0\u884c\u65f6\u957f\uff1a` + toDisplayString(run_time.value) + `\u0020\u006d\u0069\u006e`, 1), douYin_keywords_list_str.value || xhs_keywords_list_str.value ? (openBlock(), createElementBlock(`\u0064\u0069\u0076`, _hoisted_6$3, `\u5173\u952e\u8bcd\uff1a`)) : createCommentVNode(``, true), xhs_keywords_list_str.value ? (openBlock(), createElementBlock(`\u0064\u0069\u0076`, _hoisted_7$3, [_cache[1] || (_cache[1] = createBaseVNode(`\u0073\u0070\u0061\u006e`, {
        style: {
          "font-weight": `\u0062\u006f\u006c\u0064\u0065\u0072`,
          "font-size": `\u0031\u0034\u0070\u0078`
        }
      }, `\u5c0f\u7ea2\u4e66\uff1a`, -1)), createTextVNode(toDisplayString(xhs_keywords_list_str.value), 1)])) : createCommentVNode(``, true), douYin_keywords_list_str.value ? (openBlock(), createElementBlock(`\u0064\u0069\u0076`, _hoisted_8$2, [_cache[2] || (_cache[2] = createBaseVNode(`\u0073\u0070\u0061\u006e`, {
        style: {
          "font-weight": `\u0062\u006f\u006c\u0064\u0065\u0072`,
          "font-size": `\u0031\u0034\u0070\u0078`
        }
      }, `\u6296\u97f3\uff1a`, -1)), createTextVNode(toDisplayString(douYin_keywords_list_str.value), 1)])) : createCommentVNode(``, true)]), _cache[7] || (_cache[7] = createBaseVNode(`\u0064\u0069\u0076`, {
        style: {
          "height": `\u0033\u0034\u0070\u0078`,
          "line-height": `\u0033\u0034\u0070\u0078`,
          "font-weight": `\u0062\u006f\u006c\u0064\u0065\u0072`,
          "font-size": `\u0031\u0038\u0070\u0078`
        }
      }, `\u0032\u3001\u4e92\u52a8\u6570\u636e\u603b\u89c8`, -1)), createBaseVNode(`\u0064\u0069\u0076`, _hoisted_9$2, [_cache[3] || (_cache[3] = createBaseVNode(`\u0064\u0069\u0076`, {
        style: {
          "height": `\u0031\u0030\u0070\u0078`,
          "line-height": `\u0031\u0030\u0070\u0078`
        }
      }, null, -1)), createVNode(RunStatistic), _cache[4] || (_cache[4] = createBaseVNode(`\u0064\u0069\u0076`, {
        style: {
          "height": `\u0033\u0034\u0070\u0078`,
          "line-height": `\u0033\u0034\u0070\u0078`
        }
      }, null, -1)), createVNode(_sfc_main$6, {
        class: `\u006d\u002d\u0031\u0030`,
        height: `\u0034\u0030\u0030\u0070\u0078`,
        option: unref(LineChartConfigRel)
      }, null, 8, [`\u006f\u0070\u0074\u0069\u006f\u006e`]), _cache[5] || (_cache[5] = createBaseVNode(`\u0064\u0069\u0076`, {
        style: {
          "height": `\u0033\u0034\u0070\u0078`,
          "line-height": `\u0033\u0034\u0070\u0078`
        }
      }, null, -1)), createBaseVNode(`\u0064\u0069\u0076`, _hoisted_10$2, [createVNode(_component_el_segmented, {
        modelValue: PieChartValue.value,
        "onUpdate:modelValue": _cache[0] || (_cache[0] = $event => PieChartValue.value = $event),
        options: PieChartSegmentedOptions,
        block: ``,
        onChange: segmentedChange
      }, null, 8, [`\u006d\u006f\u0064\u0065\u006c\u0056\u0061\u006c\u0075\u0065`, `\u006f\u0070\u0074\u0069\u006f\u006e\u0073`])]), createVNode(_sfc_main$6, {
        class: `\u006d\u002d\u0031\u0030`,
        height: `\u0034\u0030\u0030\u0070\u0078`,
        option: unref(PieChartConfigRel)
      }, null, 8, [`\u006f\u0070\u0074\u0069\u006f\u006e`])])]);
    };
  }
});
const _imports_0 = `\u002f\u0061\u0073\u0073\u0065\u0074\u0073\u002f\u0061\u0073\u0073\u0065\u0074\u0073\u002d\u0068\u0065\u0061\u0064\u0031\u002e\u006a\u0070\u0065\u0067`;
const _imports_1 = `\u002f\u0061\u0073\u0073\u0065\u0074\u0073\u002f\u0061\u0073\u0073\u0065\u0074\u0073\u002d\u0068\u0065\u0061\u0064\u0032\u002e\u006a\u0070\u0065\u0067`;
const _hoisted_1$3 = {
  style: {
    "background": `\u0023\u0046\u0039\u0034\u0032\u0035\u0042`,
    "border-radius": `\u0031\u0030\u0070\u0078`,
    "height": `\u0033\u0030\u0070\u0078`,
    "line-height": `\u0033\u0030\u0070\u0078`,
    "width": `\u0032\u0030\u0030\u0070\u0078`,
    "padding-left": `\u0038\u0070\u0078`,
    "color": `\u0023\u0066\u0066\u0066`,
    "font-weight": `\u0062\u006f\u006c\u0064`
  }
};
const _hoisted_2$2 = {
  style: {
    "font-size": `\u0031\u0036\u0070\u0078`,
    "color": `\u0023\u0032\u0031\u0033\u0035\u0034\u0037`
  }
};
const _hoisted_3$2 = {
  style: {
    "color": `\u0062\u006c\u0061\u0063\u006b`,
    "font-size": `\u0031\u0036\u0070\u0078`,
    "font-weight": `\u0062\u006f\u006c\u0064`
  }
};
const _hoisted_4$2 = {
  style: {
    "font-size": `\u0031\u0036\u0070\u0078`,
    "color": `\u0023\u0032\u0031\u0033\u0035\u0034\u0037`
  }
};
const _hoisted_5$2 = {
  style: {
    "color": `\u0062\u006c\u0061\u0063\u006b`,
    "font-size": `\u0031\u0036\u0070\u0078`,
    "font-weight": `\u0062\u006f\u006c\u0064`
  }
};
const _hoisted_6$2 = {
  style: {
    "font-size": `\u0031\u0036\u0070\u0078`,
    "color": `\u0023\u0032\u0031\u0033\u0035\u0034\u0037`
  }
};
const _hoisted_7$2 = {
  style: {
    "color": `\u0062\u006c\u0061\u0063\u006b`,
    "font-size": `\u0031\u0036\u0070\u0078`,
    "font-weight": `\u0062\u006f\u006c\u0064`
  }
};
const _sfc_main$3 = /* @__PURE__ */defineComponent({
  __name: `\u0069\u006e\u0073\u0074\u0061\u006c\u006c\u0050\u006c\u0075\u0067\u0069\u006e\u0073`,
  setup(__props) {
    const openExtensions = async () => {
      await chrome.tabs.create({
        url: `\u0063\u0068\u0072\u006f\u006d\u0065\u003a\u002f\u002f\u0065\u0078\u0074\u0065\u006e\u0073\u0069\u006f\u006e\u0073\u002f`
      });
    };
    const $t = inject(`\u0024\u0074`);
    return (_ctx, _cache) => {
      const _component_el_button = ElButton;
      return openBlock(), createElementBlock(`\u0064\u0069\u0076`, null, [createBaseVNode(`\u0064\u0069\u0076`, _hoisted_1$3, toDisplayString(unref($t)(`\u006f\u0070\u0074\u0069\u006f\u006e\u0073\u0057\u0069\u006e\u0064\u006f\u0077\u0048\u006f\u0077\u0054\u006f\u0049\u006e\u0073\u0074\u0061\u006c\u006c\u0054\u0065\u0078\u0074`)), 1), _cache[1] || (_cache[1] = createBaseVNode(`\u0064\u0069\u0076`, {
        style: {
          "height": `\u0031\u0030\u0070\u0078`,
          "line-height": `\u0031\u0030\u0070\u0078`
        }
      }, null, -1)), createBaseVNode(`\u0064\u0069\u0076`, _hoisted_2$2, [createBaseVNode(`\u0073\u0070\u0061\u006e`, _hoisted_3$2, toDisplayString(unref($t)(`\u006f\u0070\u0074\u0069\u006f\u006e\u0073\u0057\u0069\u006e\u0064\u006f\u0077\u0053\u0074\u0065\u0070\u004e\u0075\u006d\u0054\u0065\u0078\u0074`)), 1), createTextVNode(toDisplayString(unref($t)(`\u006f\u0070\u0074\u0069\u006f\u006e\u0073\u0057\u0069\u006e\u0064\u006f\u0077\u0053\u0074\u0065\u0070\u004e\u0075\u006d\u0054\u0065\u0078\u0074\u0032`)), 1), _cache[0] || (_cache[0] = createBaseVNode(`\u0073\u0070\u0061\u006e`, {
        style: {
          "color": `\u0023\u0046\u0039\u0034\u0032\u0035\u0042`,
          "font-weight": `\u0062\u006f\u006c\u0064`,
          "padding-left": `\u0035\u0070\u0078`
        }
      }, `\u0063\u0068\u0072\u006f\u006d\u0065\u003a\u002f\u002f\u0065\u0078\u0074\u0065\u006e\u0073\u0069\u006f\u006e\u0073`, -1)), createVNode(_component_el_button, {
        round: ``,
        style: {
          "margin-left": `\u0031\u0030\u0070\u0078`
        },
        onClick: openExtensions
      }, {
        default: withCtx(() => [createTextVNode(toDisplayString(unref($t)(`\u006f\u0070\u0074\u0069\u006f\u006e\u0073\u0057\u0069\u006e\u0064\u006f\u0077\u0053\u0074\u0065\u0070\u004e\u0075\u006d\u0054\u0065\u0078\u0074\u0033`)), 1)]),
        _: 1
      })]), _cache[2] || (_cache[2] = createBaseVNode(`\u0064\u0069\u0076`, {
        style: {
          "height": `\u0033\u0030\u0070\u0078`,
          "line-height": `\u0033\u0030\u0070\u0078`
        }
      }, null, -1)), createBaseVNode(`\u0064\u0069\u0076`, _hoisted_4$2, [createBaseVNode(`\u0073\u0070\u0061\u006e`, _hoisted_5$2, toDisplayString(unref($t)(`\u006f\u0070\u0074\u0069\u006f\u006e\u0073\u0057\u0069\u006e\u0064\u006f\u0077\u0053\u0074\u0065\u0070\u0032\u004e\u0075\u006d\u0054\u0065\u0078\u0074`)), 1), createTextVNode(toDisplayString(unref($t)(`\u006f\u0070\u0074\u0069\u006f\u006e\u0073\u0057\u0069\u006e\u0064\u006f\u0077\u0053\u0074\u0065\u0070\u0032\u004e\u0075\u006d\u0054\u0065\u0078\u0074\u0032`)), 1)]), _cache[3] || (_cache[3] = createBaseVNode(`\u0064\u0069\u0076`, {
        style: {
          "height": `\u0031\u0030\u0070\u0078`,
          "line-height": `\u0031\u0030\u0070\u0078`
        }
      }, null, -1)), _cache[4] || (_cache[4] = createBaseVNode(`\u0069\u006d\u0067`, {
        src: _imports_0,
        style: {
          "width": `\u0036\u0030\u0030\u0070\u0078`
        },
        alt: `\u0056\u0075\u0065\u0020\u006c\u006f\u0067\u006f`
      }, null, -1)), _cache[5] || (_cache[5] = createBaseVNode(`\u0064\u0069\u0076`, {
        style: {
          "height": `\u0033\u0030\u0070\u0078`,
          "line-height": `\u0033\u0030\u0070\u0078`
        }
      }, null, -1)), createBaseVNode(`\u0064\u0069\u0076`, _hoisted_6$2, [createBaseVNode(`\u0073\u0070\u0061\u006e`, _hoisted_7$2, toDisplayString(unref($t)(`\u006f\u0070\u0074\u0069\u006f\u006e\u0073\u0057\u0069\u006e\u0064\u006f\u0077\u0053\u0074\u0065\u0070\u0033\u004e\u0075\u006d\u0054\u0065\u0078\u0074`)), 1), createTextVNode(toDisplayString(unref($t)(`\u006f\u0070\u0074\u0069\u006f\u006e\u0073\u0057\u0069\u006e\u0064\u006f\u0077\u0053\u0074\u0065\u0070\u0033\u004e\u0075\u006d\u0054\u0065\u0078\u0074\u0032`)), 1)]), _cache[6] || (_cache[6] = createBaseVNode(`\u0064\u0069\u0076`, {
        style: {
          "height": `\u0031\u0030\u0070\u0078`,
          "line-height": `\u0031\u0030\u0070\u0078`
        }
      }, null, -1)), _cache[7] || (_cache[7] = createBaseVNode(`\u0069\u006d\u0067`, {
        src: _imports_1,
        style: {
          "width": `\u0036\u0030\u0030\u0070\u0078`
        },
        alt: `\u0056\u0075\u0065\u0020\u006c\u006f\u0067\u006f`
      }, null, -1))]);
    };
  }
});
function sendLog(message) {
  chrome.runtime.sendMessage({
    action: `\u006c\u006f\u0067\u0073`,
    message
  }).then(() => {}).catch(err => {
    console.error(err);
  });
}
function sendCloseTab() {
  chrome.runtime.sendMessage({
    action: `\u0063\u006c\u006f\u0073\u0065\u0054\u0061\u0062`
  }).then(res => {
    console.info(res);
  }).catch(err => {
    console.error(err);
  });
}
function formatDate(isoString) {
  const date = new Date(isoString);
  const year = date.getFullYear();
  const month = String(date.getMonth() + 1).padStart(2, `\u0030`);
  const day = String(date.getDate()).padStart(2, `\u0030`);
  return `${year}\u002d${month}\u002d${day}`;
}
function delay$1(ms) {
  return new Promise(resolve => setTimeout(resolve, ms));
}
const VITE_LOGIN_API$2 = `\u0068\u0074\u0074\u0070\u0073\u003a\u002f\u002f\u0067\u006c\u006f\u0062\u0061\u006c\u002d\u0061\u0075\u0074\u0068\u002e\u0070\u0065\u0074\u0072\u006f\u006e\u002e\u0061\u0069`;
async function getLoginToken(request_id, signal) {
  for (let i = 0; i < 3; i++) {
    const url = VITE_LOGIN_API$2 + `\u002f\u0061\u0070\u0069\u002f\u0076\u0031\u002f\u0077\u006f\u0072\u006b\u006f\u0073\u002f\u0061\u0063\u0063\u0065\u0073\u0073\u005f\u0074\u006f\u006b\u0065\u006e\u002f\u0073\u0074\u0072\u0065\u0061\u006d\u003f\u0072\u0065\u0071\u0075\u0065\u0073\u0074\u005f\u0069\u0064\u003d` + request_id + `\u0026\u0074\u0069\u006d\u0065\u003d` + (/* @__PURE__ */new Date()).getTime();
    const headers = {};
    try {
      const response = await fetch(url, {
        method: `\u0067\u0065\u0074`,
        signal
      });
      if (!response.ok) {
        sendLog(`\u0075\u0072\u006c\u003a` + url + `\uff0c\u0068\u0065\u0061\u0064\u0065\u0072\u003a` + JSON.stringify(headers) + `\u002c\u0020\u0072\u0065\u0073\u0070\u006f\u006e\u0073\u0065\u0020\u0073\u0074\u0061\u0074\u0075\u0073\u003a` + response.status);
        console.error(`\u0048\u0054\u0054\u0050\u0020\u0065\u0072\u0072\u006f\u0072\u0021\u0020\u0073\u0074\u0061\u0074\u0075\u0073\u003a\u0020${response.status}`, response);
        if (response.status === 401) {
          console.log(`\u767b\u5f55\u5931\u6548`);
          store.setAccessToken(``);
          store.set_updateVipDateTime(``);
          store.setUserInfoEndDate(``);
          setTimeout(async () => {
            const accessToken = store.accessToken;
            await logout(accessToken);
          }, 1);
        }
        if (response.status == 404) {
          return void 0;
        }
        return void 0;
      }
      let result = await response.text();
      console.log(`\u0072\u0065\u0073\u0075\u006c\u0074`, result);
      sendLog(`\u0075\u0072\u006c\u003a` + url + `\uff0c\u0068\u0065\u0061\u0064\u0065\u0072\u003a` + JSON.stringify(headers) + `\u002c\u0020\u0072\u0065\u0073\u0070\u006f\u006e\u0073\u0065\u0020\u0073\u0074\u0061\u0074\u0075\u0073\u003a` + response.status + `\u002c\u0020\u0072\u0065\u0073\u0070\u006f\u006e\u0073\u0065\u0020\u0064\u0061\u0074\u0061\u003a` + JSON.stringify(result));
      if (result) {
        result = JSON.parse(result);
      } else {
        return void 0;
      }
      return result;
    } catch (error) {
      if (error.name === `\u0041\u0062\u006f\u0072\u0074\u0045\u0072\u0072\u006f\u0072`) {
        console.log(`\u0046\u0065\u0074\u0063\u0068\u0020\u0061\u0062\u006f\u0072\u0074\u0065\u0064`);
      } else {
        console.error(`\u0046\u0065\u0074\u0063\u0068\u0020\u0065\u0072\u0072\u006f\u0072\u003a`, error);
      }
      sendLog(`\u0075\u0072\u006c\u003a` + url + `\uff0c\u0068\u0065\u0061\u0064\u0065\u0072\u003a` + JSON.stringify(headers) + `\u002c\u0020\u0065\u0072\u0072\u006f\u0072` + error);
    }
  }
  return void 0;
}
async function logout(accessToken) {
  const url = VITE_LOGIN_API$2 + `\u002f\u0061\u0070\u0069\u002f\u0076\u0031\u002f\u0077\u006f\u0072\u006b\u006f\u0073\u002f\u006c\u006f\u0067\u006f\u0075\u0074`;
  try {
    const headers = {
      "Content-Type": `\u0061\u0070\u0070\u006c\u0069\u0063\u0061\u0074\u0069\u006f\u006e\u002f\u006a\u0073\u006f\u006e`,
      "Authorization": `\u0042\u0065\u0061\u0072\u0065\u0072\u0020` + accessToken
    };
    const response = await fetch(url, {
      method: `\u0067\u0065\u0074`,
      headers
    });
    if (!response.ok) {
      console.error(`\u0048\u0054\u0054\u0050\u0020\u0065\u0072\u0072\u006f\u0072\u0021\u0020\u0073\u0074\u0061\u0074\u0075\u0073\u003a\u0020${response.status}`, response);
      return void 0;
    }
    const result = await response.json();
    console.log(`\u0072\u0065\u0073\u0075\u006c\u0074`, result);
    return result;
  } catch (error) {
    console.error(`\u0045\u0072\u0072\u006f\u0072\u003a`, error);
  }
  return void 0;
}
const VITE_LOGIN_API$1 = `\u0068\u0074\u0074\u0070\u0073\u003a\u002f\u002f\u0067\u006c\u006f\u0062\u0061\u006c\u002d\u0061\u0075\u0074\u0068\u002e\u0070\u0065\u0074\u0072\u006f\u006e\u002e\u0061\u0069`;
async function putBurialPoint(postData) {
  console.log(`\u0070\u0075\u0074\u0042\u0075\u0072\u0069\u0061\u006c\u0050\u006f\u0069\u006e\u0074`, postData);
  const url = VITE_LOGIN_API$1 + `\u002f\u0061\u0070\u0069\u002f\u0076\u0031\u002f\u0061\u006e\u0061\u006c\u0079\u0074\u0069\u0063\u0073\u005f\u0065\u0076\u0065\u006e\u0074\u0073`;
  const headers = {
    "Content-Type": `\u0061\u0070\u0070\u006c\u0069\u0063\u0061\u0074\u0069\u006f\u006e\u002f\u006a\u0073\u006f\u006e`,
    "Authorization": `\u0042\u0065\u0061\u0072\u0065\u0072\u0020` + store.accessToken
  };
  try {
    const response = await fetch(url, {
      method: `\u0050\u004f\u0053\u0054`,
      headers,
      body: JSON.stringify(postData)
    });
    if (!response.ok) {
      sendLog(`\u0075\u0072\u006c\u003a` + url + `\uff0c\u0068\u0065\u0061\u0064\u0065\u0072\u003a` + JSON.stringify(headers) + `\u002c\u0020\u0072\u0065\u0073\u0070\u006f\u006e\u0073\u0065\u0020\u0073\u0074\u0061\u0074\u0075\u0073\u003a` + response.status);
      console.error(`\u0048\u0054\u0054\u0050\u0020\u0065\u0072\u0072\u006f\u0072\u0021\u0020\u0073\u0074\u0061\u0074\u0075\u0073\u003a\u0020${response.status}`);
      if (response.status === 401) {
        console.log(`\u767b\u5f55\u5931\u6548`);
        store.setAccessToken(``);
        store.set_updateVipDateTime(``);
        store.setUserInfoEndDate(``);
        await logout(store.accessToken);
      }
      if (response.status == 404) {
        return void 0;
      }
      return void 0;
    }
    const result = await response.json();
    sendLog(`\u0075\u0072\u006c\u003a` + url + `\uff0c\u0068\u0065\u0061\u0064\u0065\u0072\u003a` + JSON.stringify(headers) + `\u002c\u0070\u006f\u0073\u0074\u0044\u0061\u0074\u0061\uff1a` + JSON.stringify(postData) + `\u0020\u0072\u0065\u0073\u0070\u006f\u006e\u0073\u0065\u0020\u0073\u0074\u0061\u0074\u0075\u0073\u003a` + response.status + `\u002c\u0020\u0072\u0065\u0073\u0070\u006f\u006e\u0073\u0065\u0020\u0064\u0061\u0074\u0061\u003a` + JSON.stringify(result));
    console.log(`\u0072\u0065\u0073\u0075\u006c\u0074`, result);
    return result;
  } catch (error) {
    sendLog(`\u0075\u0072\u006c\u003a` + url + `\uff0c\u0068\u0065\u0061\u0064\u0065\u0072\u003a` + JSON.stringify(headers) + `\u002c\u0020\u0065\u0072\u0072\u006f\u0072` + error);
    console.error(`\u0045\u0072\u0072\u006f\u0072\u003a`, error);
  }
  return void 0;
}
const VITE_LOGIN_API = `\u0068\u0074\u0074\u0070\u0073\u003a\u002f\u002f\u0067\u006c\u006f\u0062\u0061\u006c\u002d\u0061\u0075\u0074\u0068\u002e\u0070\u0065\u0074\u0072\u006f\u006e\u002e\u0061\u0069`;
async function createTenants(postData) {
  console.log(`\u0063\u0072\u0065\u0061\u0074\u0065\u0054\u0065\u006e\u0061\u006e\u0074\u0073`, postData);
  const url = VITE_LOGIN_API + `\u002f\u0061\u0070\u0069\u002f\u0076\u0031\u002f\u0074\u0065\u006e\u0061\u006e\u0074\u0073`;
  const headers = {
    "Content-Type": `\u0061\u0070\u0070\u006c\u0069\u0063\u0061\u0074\u0069\u006f\u006e\u002f\u006a\u0073\u006f\u006e`,
    "Authorization": `\u0042\u0065\u0061\u0072\u0065\u0072\u0020` + store.accessToken
  };
  try {
    const response = await fetch(url, {
      method: `\u0050\u004f\u0053\u0054`,
      headers,
      body: JSON.stringify(postData)
    });
    if (!response.ok) {
      sendLog(`\u0075\u0072\u006c\u003a` + url + `\uff0c\u0068\u0065\u0061\u0064\u0065\u0072\u003a` + JSON.stringify(headers) + `\u002c\u0020\u0072\u0065\u0073\u0070\u006f\u006e\u0073\u0065\u0020\u0073\u0074\u0061\u0074\u0075\u0073\u003a` + response.status);
      console.error(`\u0048\u0054\u0054\u0050\u0020\u0065\u0072\u0072\u006f\u0072\u0021\u0020\u0073\u0074\u0061\u0074\u0075\u0073\u003a\u0020${response.status}`);
      if (response.status === 401) {
        console.log(`\u767b\u5f55\u5931\u6548`);
        store.setAccessToken(``);
        store.set_updateVipDateTime(``);
        store.setUserInfoEndDate(``);
        await logout(store.accessToken);
      }
      if (response.status == 404) {
        return void 0;
      }
      return void 0;
    }
    const result = await response.json();
    sendLog(`\u0075\u0072\u006c\u003a` + url + `\uff0c\u0068\u0065\u0061\u0064\u0065\u0072\u003a` + JSON.stringify(headers) + `\u002c\u0070\u006f\u0073\u0074\u0044\u0061\u0074\u0061\uff1a` + JSON.stringify(postData) + `\u0020\u0072\u0065\u0073\u0070\u006f\u006e\u0073\u0065\u0020\u0073\u0074\u0061\u0074\u0075\u0073\u003a` + response.status + `\u002c\u0020\u0072\u0065\u0073\u0070\u006f\u006e\u0073\u0065\u0020\u0064\u0061\u0074\u0061\u003a` + JSON.stringify(result));
    console.log(`\u0072\u0065\u0073\u0075\u006c\u0074`, result);
    return result;
  } catch (error) {
    sendLog(`\u0075\u0072\u006c\u003a` + url + `\uff0c\u0068\u0065\u0061\u0064\u0065\u0072\u003a` + JSON.stringify(headers) + `\u002c\u0020\u0065\u0072\u0072\u006f\u0072` + error);
    console.error(`\u0045\u0072\u0072\u006f\u0072\u003a`, error);
  }
  return void 0;
}
async function queryTenants(tenantName) {
  console.log(`\u0071\u0075\u0065\u0072\u0079\u0054\u0065\u006e\u0061\u006e\u0074\u0073`, tenantName);
  const url = VITE_LOGIN_API + `\u002f\u0061\u0070\u0069\u002f\u0076\u0031\u002f\u0074\u0065\u006e\u0061\u006e\u0074\u0073\u003f\u006e\u0061\u006d\u0065\u003d` + tenantName;
  const headers = {
    "Content-Type": `\u0061\u0070\u0070\u006c\u0069\u0063\u0061\u0074\u0069\u006f\u006e\u002f\u006a\u0073\u006f\u006e`,
    "Authorization": `\u0042\u0065\u0061\u0072\u0065\u0072\u0020` + store.accessToken
  };
  try {
    const response = await fetch(url, {
      method: `\u0067\u0065\u0074`,
      headers
    });
    if (!response.ok) {
      sendLog(`\u0075\u0072\u006c\u003a` + url + `\uff0c\u0068\u0065\u0061\u0064\u0065\u0072\u003a` + JSON.stringify(headers) + `\u002c\u0020\u0072\u0065\u0073\u0070\u006f\u006e\u0073\u0065\u0020\u0073\u0074\u0061\u0074\u0075\u0073\u003a` + response.status);
      console.error(`\u0048\u0054\u0054\u0050\u0020\u0065\u0072\u0072\u006f\u0072\u0021\u0020\u0073\u0074\u0061\u0074\u0075\u0073\u003a\u0020${response.status}`);
      if (response.status === 401) {
        console.log(`\u767b\u5f55\u5931\u6548`);
        store.setAccessToken(``);
        store.set_updateVipDateTime(``);
        store.setUserInfoEndDate(``);
        await logout(store.accessToken);
      }
      if (response.status == 404) {
        return void 0;
      }
      return void 0;
    }
    const result = await response.json();
    sendLog(`\u0075\u0072\u006c\u003a` + url + `\uff0c\u0068\u0065\u0061\u0064\u0065\u0072\u003a` + JSON.stringify(headers) + `\u002c\u0074\u0065\u006e\u0061\u006e\u0074\u004e\u0061\u006d\u0065\uff1a` + tenantName + `\u0020\u0072\u0065\u0073\u0070\u006f\u006e\u0073\u0065\u0020\u0073\u0074\u0061\u0074\u0075\u0073\u003a` + response.status + `\u002c\u0020\u0072\u0065\u0073\u0070\u006f\u006e\u0073\u0065\u0020\u0064\u0061\u0074\u0061\u003a` + JSON.stringify(result));
    console.log(`\u0072\u0065\u0073\u0075\u006c\u0074`, result);
    return result;
  } catch (error) {
    sendLog(`\u0075\u0072\u006c\u003a` + url + `\u002c\u0074\u0065\u006e\u0061\u006e\u0074\u004e\u0061\u006d\u0065\uff1a` + tenantName + `\uff0c\u0068\u0065\u0061\u0064\u0065\u0072\u003a` + JSON.stringify(headers) + `\u002c\u0020\u0065\u0072\u0072\u006f\u0072` + error);
    console.error(`\u0045\u0072\u0072\u006f\u0072\u003a`, error);
  }
  return void 0;
}
async function bingingTenants(tenant_id) {
  console.log(`\u0062\u0069\u006e\u0067\u0069\u006e\u0067\u0054\u0065\u006e\u0061\u006e\u0074\u0073`, tenant_id);
  const url = VITE_LOGIN_API + `\u002f\u0061\u0070\u0069\u002f\u0076\u0031\u002f\u0074\u0065\u006e\u0061\u006e\u0074\u0073\u002f${tenant_id}\u002f\u0062\u0069\u006e\u0064\u0069\u006e\u0067`;
  const headers = {
    "Content-Type": `\u0061\u0070\u0070\u006c\u0069\u0063\u0061\u0074\u0069\u006f\u006e\u002f\u006a\u0073\u006f\u006e`,
    "Authorization": `\u0042\u0065\u0061\u0072\u0065\u0072\u0020` + store.accessToken
  };
  try {
    const response = await fetch(url, {
      method: `\u0050\u004f\u0053\u0054`,
      headers
    });
    if (!response.ok) {
      sendLog(`\u0075\u0072\u006c\u003a` + url + `\uff0c\u0068\u0065\u0061\u0064\u0065\u0072\u003a` + JSON.stringify(headers) + `\u002c\u0020\u0072\u0065\u0073\u0070\u006f\u006e\u0073\u0065\u0020\u0073\u0074\u0061\u0074\u0075\u0073\u003a` + response.status);
      console.error(`\u0048\u0054\u0054\u0050\u0020\u0065\u0072\u0072\u006f\u0072\u0021\u0020\u0073\u0074\u0061\u0074\u0075\u0073\u003a\u0020${response.status}`);
      if (response.status === 401) {
        console.log(`\u767b\u5f55\u5931\u6548`);
        store.setAccessToken(``);
        store.set_updateVipDateTime(``);
        store.setUserInfoEndDate(``);
        await logout(store.accessToken);
      }
      if (response.status == 404) {
        return void 0;
      }
      return void 0;
    }
    const result = await response.json();
    sendLog(`\u0075\u0072\u006c\u003a` + url + `\uff0c\u0068\u0065\u0061\u0064\u0065\u0072\u003a` + JSON.stringify(headers) + `\u002c\u0020\u0072\u0065\u0073\u0070\u006f\u006e\u0073\u0065\u0020\u0073\u0074\u0061\u0074\u0075\u0073\u003a` + response.status + `\u002c\u0020\u0072\u0065\u0073\u0070\u006f\u006e\u0073\u0065\u0020\u0064\u0061\u0074\u0061\u003a` + JSON.stringify(result));
    console.log(`\u0072\u0065\u0073\u0075\u006c\u0074`, result);
    return result;
  } catch (error) {
    sendLog(`\u0075\u0072\u006c\u003a` + url + `\uff0c\u0068\u0065\u0061\u0064\u0065\u0072\u003a` + JSON.stringify(headers) + `\u002c\u0020\u0065\u0072\u0072\u006f\u0072` + error);
    console.error(`\u0045\u0072\u0072\u006f\u0072\u003a`, error);
  }
  return void 0;
}
async function tenantsMine() {
  console.log(`\u0074\u0065\u006e\u0061\u006e\u0074\u0073\u004d\u0069\u006e\u0065`);
  const url = VITE_LOGIN_API + `\u002f\u0061\u0070\u0069\u002f\u0076\u0031\u002f\u0074\u0065\u006e\u0061\u006e\u0074\u0073\u002f\u006d\u0069\u006e\u0065`;
  const headers = {
    "Content-Type": `\u0061\u0070\u0070\u006c\u0069\u0063\u0061\u0074\u0069\u006f\u006e\u002f\u006a\u0073\u006f\u006e`,
    "Authorization": `\u0042\u0065\u0061\u0072\u0065\u0072\u0020` + store.accessToken
  };
  try {
    const response = await fetch(url, {
      method: `\u0047\u0045\u0054`,
      headers
    });
    if (!response.ok) {
      sendLog(`\u0075\u0072\u006c\u003a` + url + `\uff0c\u0068\u0065\u0061\u0064\u0065\u0072\u003a` + JSON.stringify(headers) + `\u002c\u0020\u0072\u0065\u0073\u0070\u006f\u006e\u0073\u0065\u0020\u0073\u0074\u0061\u0074\u0075\u0073\u003a` + response.status);
      console.error(`\u0048\u0054\u0054\u0050\u0020\u0065\u0072\u0072\u006f\u0072\u0021\u0020\u0073\u0074\u0061\u0074\u0075\u0073\u003a\u0020${response.status}`);
      if (response.status === 401) {
        console.log(`\u767b\u5f55\u5931\u6548`);
        store.setAccessToken(``);
        store.set_updateVipDateTime(``);
        store.setUserInfoEndDate(``);
        await logout(store.accessToken);
      }
      if (response.status == 404) {
        return void 0;
      }
      return void 0;
    }
    const result = await response.json();
    sendLog(`\u0075\u0072\u006c\u003a` + url + `\uff0c\u0068\u0065\u0061\u0064\u0065\u0072\u003a` + JSON.stringify(headers) + `\u002c\u0020\u0072\u0065\u0073\u0070\u006f\u006e\u0073\u0065\u0020\u0073\u0074\u0061\u0074\u0075\u0073\u003a` + response.status + `\u002c\u0020\u0072\u0065\u0073\u0070\u006f\u006e\u0073\u0065\u0020\u0064\u0061\u0074\u0061\u003a` + JSON.stringify(result));
    console.log(`\u0072\u0065\u0073\u0075\u006c\u0074`, result);
    return result;
  } catch (error) {
    sendLog(`\u0075\u0072\u006c\u003a` + url + `\uff0c\u0068\u0065\u0061\u0064\u0065\u0072\u003a` + JSON.stringify(headers) + `\u002c\u0020\u0065\u0072\u0072\u006f\u0072` + error);
    console.error(`\u0045\u0072\u0072\u006f\u0072\u003a`, error);
  }
  return void 0;
}
const VITE_TERMINAL_API = `\u0068\u0074\u0074\u0070\u0073\u003a\u002f\u002f\u0061\u0067\u0065\u006e\u0074\u002d\u006e\u0065\u0074\u002e\u0070\u0061\u0069\u0074\u006f\u006e\u0067\u0061\u0069\u002e\u006e\u0065\u0074\u002f\u0074\u0065\u0072\u006d\u0069\u006e\u0061\u006c`;
async function register_terminal(agent_id, agent_name) {
  sendLog(`\u0072\u0065\u0067\u0069\u0073\u0074\u0065\u0072\u005f\u0074\u0065\u0072\u006d\u0069\u006e\u0061\u006c\u0020\u0061\u0063\u0063\u0065\u0073\u0073\u0054\u006f\u006b\u0065\u006e\u003a\u0020` + store.accessToken);
  const url = VITE_TERMINAL_API + `\u002f\u0061\u0070\u0069\u002f\u0074\u0065\u0072\u006d\u0069\u006e\u0061\u006c\u0073\u002f\u0072\u0065\u0067\u0069\u0073\u0074\u0065\u0072\u005f\u0074\u0065\u0072\u006d\u0069\u006e\u0061\u006c\u003f\u0061\u0067\u0065\u006e\u0074\u005f\u0069\u0064\u003d` + agent_id + `\u0026\u0061\u0067\u0065\u006e\u0074\u005f\u006e\u0061\u006d\u0065\u003d` + agent_name;
  const headers = {
    "Content-Type": `\u0061\u0070\u0070\u006c\u0069\u0063\u0061\u0074\u0069\u006f\u006e\u002f\u006a\u0073\u006f\u006e`,
    "Authorization": `\u0042\u0065\u0061\u0072\u0065\u0072\u0020` + store.accessToken
  };
  try {
    const response = await fetch(url, {
      method: `\u0050\u004f\u0053\u0054`,
      headers
    });
    if (!response.ok) {
      sendLog(`\u0075\u0072\u006c\u003a` + url + `\uff0c\u0068\u0065\u0061\u0064\u0065\u0072\u003a` + JSON.stringify(headers) + `\u002c\u0020\u0072\u0065\u0073\u0070\u006f\u006e\u0073\u0065\u0020\u0073\u0074\u0061\u0074\u0075\u0073\u003a` + response.status);
      console.error(`\u0048\u0054\u0054\u0050\u0020\u0065\u0072\u0072\u006f\u0072\u0021\u0020\u0073\u0074\u0061\u0074\u0075\u0073\u003a\u0020${response.status}`);
      if (response.status === 401) {
        console.log(`\u767b\u5f55\u5931\u6548`);
        store.setAccessToken(``);
        store.set_updateVipDateTime(``);
        store.setUserInfoEndDate(``);
        await logout(store.accessToken);
      }
      if (response.status == 404) {
        return void 0;
      }
      return void 0;
    }
    const result = await response.json();
    sendLog(`\u0075\u0072\u006c\u003a` + url + `\uff0c\u0068\u0065\u0061\u0064\u0065\u0072\u003a` + JSON.stringify(headers) + `\u0020\u0072\u0065\u0073\u0070\u006f\u006e\u0073\u0065\u0020\u0073\u0074\u0061\u0074\u0075\u0073\u003a` + response.status + `\u002c\u0020\u0072\u0065\u0073\u0070\u006f\u006e\u0073\u0065\u0020\u0064\u0061\u0074\u0061\u003a` + JSON.stringify(result));
    console.log(`\u0072\u0065\u0073\u0075\u006c\u0074`, result);
    return result;
  } catch (error) {
    sendLog(`\u0075\u0072\u006c\u003a` + url + `\uff0c\u0068\u0065\u0061\u0064\u0065\u0072\u003a` + JSON.stringify(headers) + `\u002c\u0020\u0065\u0072\u0072\u006f\u0072` + error);
    console.error(`\u0045\u0072\u0072\u006f\u0072\u003a`, error);
  }
  return void 0;
}
const VITE_AGENT_BUSINESS_API = `\u0068\u0074\u0074\u0070\u0073\u003a\u002f\u002f\u0070\u0072\u006f\u0064\u002d\u0061\u0067\u0062\u0075\u0073\u0069\u006e\u0065\u0073\u0073\u002d\u007a\u0079\u0071\u0066\u006c\u0078\u0069\u0064\u0074\u0068\u002e\u0063\u006e\u002d\u0068\u0075\u0068\u0065\u0068\u0061\u006f\u0074\u0065\u002e\u0066\u0063\u0061\u0070\u0070\u002e\u0072\u0075\u006e`;
const VITE_AGENT_ID = `\u0078\u0069\u0061\u006f\u0073\u0068\u0075\u0074\u0069\u0061\u006f\u002d\u0061\u0075\u0074\u006f\u006d\u0061\u0074\u0069\u0063\u002d\u0065\u0078\u0074\u0065\u006e\u0073\u0069\u006f\u006e`;
const VITE_AGENT_NAME = `\u5ba2\u8d44\u5de5\u5177`;
async function saveTerminal(terminalId, postData) {
  console.log(`\u0074\u0065\u0072\u006d\u0069\u006e\u0061\u006c`, postData);
  const url = VITE_AGENT_BUSINESS_API + `\u002f\u0061\u0070\u0069\u002f\u0074\u0065\u0072\u006d\u0069\u006e\u0061\u006c\u002f` + terminalId;
  const headers = {
    "Content-Type": `\u0061\u0070\u0070\u006c\u0069\u0063\u0061\u0074\u0069\u006f\u006e\u002f\u006a\u0073\u006f\u006e`,
    "Authorization": `\u0042\u0065\u0061\u0072\u0065\u0072\u0020` + store.accessToken
  };
  try {
    const response = await fetch(url, {
      method: `\u0050\u004f\u0053\u0054`,
      headers,
      body: JSON.stringify(postData)
    });
    if (!response.ok) {
      sendLog(`\u0075\u0072\u006c\u003a` + url + `\uff0c\u0068\u0065\u0061\u0064\u0065\u0072\u003a` + JSON.stringify(headers) + `\u002c\u0020\u0072\u0065\u0073\u0070\u006f\u006e\u0073\u0065\u0020\u0073\u0074\u0061\u0074\u0075\u0073\u003a` + response.status);
      console.error(`\u0048\u0054\u0054\u0050\u0020\u0065\u0072\u0072\u006f\u0072\u0021\u0020\u0073\u0074\u0061\u0074\u0075\u0073\u003a\u0020${response.status}`);
      if (response.status === 401) {
        console.log(`\u767b\u5f55\u5931\u6548`);
        store.setAccessToken(``);
        store.set_updateVipDateTime(``);
        store.setUserInfoEndDate(``);
        await logout(store.accessToken);
      }
      if (response.status == 404) {
        return void 0;
      }
      return void 0;
    }
    const result = await response.json();
    sendLog(`\u0075\u0072\u006c\u003a` + url + `\uff0c\u0068\u0065\u0061\u0064\u0065\u0072\u003a` + JSON.stringify(headers) + `\u002c\u0070\u006f\u0073\u0074\u0044\u0061\u0074\u0061\uff1a` + JSON.stringify(postData) + `\u0020\u0072\u0065\u0073\u0070\u006f\u006e\u0073\u0065\u0020\u0073\u0074\u0061\u0074\u0075\u0073\u003a` + response.status + `\u002c\u0020\u0072\u0065\u0073\u0070\u006f\u006e\u0073\u0065\u0020\u0064\u0061\u0074\u0061\u003a` + JSON.stringify(result));
    console.log(`\u0072\u0065\u0073\u0075\u006c\u0074`, result);
    return result;
  } catch (error) {
    sendLog(`\u0075\u0072\u006c\u003a` + url + `\uff0c\u0068\u0065\u0061\u0064\u0065\u0072\u003a` + JSON.stringify(headers) + `\u002c\u0020\u0065\u0072\u0072\u006f\u0072` + error);
    console.error(`\u0045\u0072\u0072\u006f\u0072\u003a`, error);
  }
  return void 0;
}
async function queryTerminal() {
  const url = `${VITE_AGENT_BUSINESS_API}\u002f\u0061\u0070\u0069\u002f\u0074\u0065\u0072\u006d\u0069\u006e\u0061\u006c\u003f\u006f\u006e\u006c\u0079\u005f\u0062\u006f\u0075\u006e\u0064\u003d\u0074\u0072\u0075\u0065\u0026\u0061\u0067\u0065\u006e\u0074\u005f\u0069\u0064\u003d${VITE_AGENT_ID}`;
  const headers = {
    "Content-Type": `\u0061\u0070\u0070\u006c\u0069\u0063\u0061\u0074\u0069\u006f\u006e\u002f\u006a\u0073\u006f\u006e`,
    "Authorization": `\u0042\u0065\u0061\u0072\u0065\u0072\u0020` + store.accessToken
  };
  try {
    const response = await fetch(url, {
      method: `\u0047\u0045\u0054`,
      headers
    });
    if (!response.ok) {
      sendLog(`\u0075\u0072\u006c\u003a` + url + `\uff0c\u0068\u0065\u0061\u0064\u0065\u0072\u003a` + JSON.stringify(headers) + `\u002c\u0020\u0072\u0065\u0073\u0070\u006f\u006e\u0073\u0065\u0020\u0073\u0074\u0061\u0074\u0075\u0073\u003a` + response.status);
      console.error(`\u0048\u0054\u0054\u0050\u0020\u0065\u0072\u0072\u006f\u0072\u0021\u0020\u0073\u0074\u0061\u0074\u0075\u0073\u003a\u0020${response.status}`);
      if (response.status === 401) {
        console.log(`\u767b\u5f55\u5931\u6548`);
        store.setAccessToken(``);
        store.set_updateVipDateTime(``);
        store.setUserInfoEndDate(``);
        await logout(store.accessToken);
      }
      if (response.status == 404) {
        return void 0;
      }
      return void 0;
    }
    const result = await response.json();
    sendLog(`\u0075\u0072\u006c\u003a` + url + `\uff0c\u0068\u0065\u0061\u0064\u0065\u0072\u003a` + JSON.stringify(headers) + `\u0020\u0072\u0065\u0073\u0070\u006f\u006e\u0073\u0065\u0020\u0073\u0074\u0061\u0074\u0075\u0073\u003a` + response.status + `\u002c\u0020\u0072\u0065\u0073\u0070\u006f\u006e\u0073\u0065\u0020\u0064\u0061\u0074\u0061\u003a` + JSON.stringify(result));
    console.log(`\u0072\u0065\u0073\u0075\u006c\u0074`, result);
    if (!result || result.total == 0 || !result.data) {
      return;
    }
    return {
      terminalId: result.data[0].terminal_id,
      terminalName: result.data[0].terminal_name
    };
  } catch (error) {
    sendLog(`\u0075\u0072\u006c\u003a` + url + `\uff0c\u0068\u0065\u0061\u0064\u0065\u0072\u003a` + JSON.stringify(headers) + `\u002c\u0020\u0065\u0072\u0072\u006f\u0072` + error);
    console.error(`\u0045\u0072\u0072\u006f\u0072\u003a`, error);
  }
  return void 0;
}
async function saveTerminalBind(terminalId, postData) {
  console.log(`\u0074\u0065\u0072\u006d\u0069\u006e\u0061\u006c`, postData);
  const url = VITE_AGENT_BUSINESS_API + `\u002f\u0061\u0070\u0069\u002f\u0074\u0065\u0072\u006d\u0069\u006e\u0061\u006c\u002f` + terminalId + `\u002f\u0062\u0069\u006e\u0064`;
  const headers = {
    "Content-Type": `\u0061\u0070\u0070\u006c\u0069\u0063\u0061\u0074\u0069\u006f\u006e\u002f\u006a\u0073\u006f\u006e`,
    "Authorization": `\u0042\u0065\u0061\u0072\u0065\u0072\u0020` + store.accessToken
  };
  try {
    const response = await fetch(url, {
      method: `\u0050\u004f\u0053\u0054`,
      headers,
      body: JSON.stringify(postData)
    });
    if (!response.ok) {
      sendLog(`\u0075\u0072\u006c\u003a` + url + `\uff0c\u0068\u0065\u0061\u0064\u0065\u0072\u003a` + JSON.stringify(headers) + `\u002c\u0020\u0072\u0065\u0073\u0070\u006f\u006e\u0073\u0065\u0020\u0073\u0074\u0061\u0074\u0075\u0073\u003a` + response.status);
      console.error(`\u0048\u0054\u0054\u0050\u0020\u0065\u0072\u0072\u006f\u0072\u0021\u0020\u0073\u0074\u0061\u0074\u0075\u0073\u003a\u0020${response.status}`);
      if (response.status === 401) {
        console.log(`\u767b\u5f55\u5931\u6548`);
        store.setAccessToken(``);
        store.set_updateVipDateTime(``);
        store.setUserInfoEndDate(``);
        await logout(store.accessToken);
      }
      if (response.status == 404) {
        return void 0;
      }
      return void 0;
    }
    const result = await response.json();
    sendLog(`\u0075\u0072\u006c\u003a` + url + `\uff0c\u0068\u0065\u0061\u0064\u0065\u0072\u003a` + JSON.stringify(headers) + `\u002c\u0070\u006f\u0073\u0074\u0044\u0061\u0074\u0061\uff1a` + JSON.stringify(postData) + `\u0020\u0072\u0065\u0073\u0070\u006f\u006e\u0073\u0065\u0020\u0073\u0074\u0061\u0074\u0075\u0073\u003a` + response.status + `\u002c\u0020\u0072\u0065\u0073\u0070\u006f\u006e\u0073\u0065\u0020\u0064\u0061\u0074\u0061\u003a` + JSON.stringify(result));
    console.log(`\u0072\u0065\u0073\u0075\u006c\u0074`, result);
    return result;
  } catch (error) {
    sendLog(`\u0075\u0072\u006c\u003a` + url + `\uff0c\u0068\u0065\u0061\u0064\u0065\u0072\u003a` + JSON.stringify(headers) + `\u002c\u0020\u0065\u0072\u0072\u006f\u0072` + error);
    console.error(`\u0045\u0072\u0072\u006f\u0072\u003a`, error);
  }
  return void 0;
}
async function terminalCredentials(terminalId, accessToken) {
  const url = VITE_AGENT_BUSINESS_API + `\u002f\u0061\u0070\u0069\u002f\u0074\u0065\u0072\u006d\u0069\u006e\u0061\u006c\u002f` + terminalId + `\u002f\u0063\u0072\u0065\u0064\u0065\u006e\u0074\u0069\u0061\u006c\u0073`;
  const headers = {
    "Content-Type": `\u0061\u0070\u0070\u006c\u0069\u0063\u0061\u0074\u0069\u006f\u006e\u002f\u006a\u0073\u006f\u006e`,
    "Authorization": `\u0042\u0065\u0061\u0072\u0065\u0072\u0020` + accessToken
  };
  try {
    const response = await fetch(url, {
      method: `\u0047\u0045\u0054`,
      headers
    });
    if (!response.ok) {
      sendLog(`\u0075\u0072\u006c\u003a` + url + `\uff0c\u0068\u0065\u0061\u0064\u0065\u0072\u003a` + JSON.stringify(headers) + `\u002c\u0020\u0072\u0065\u0073\u0070\u006f\u006e\u0073\u0065\u0020\u0073\u0074\u0061\u0074\u0075\u0073\u003a` + response.status);
      console.error(`\u0048\u0054\u0054\u0050\u0020\u0065\u0072\u0072\u006f\u0072\u0021\u0020\u0073\u0074\u0061\u0074\u0075\u0073\u003a\u0020${response.status}`);
      if (response.status === 401) {
        console.log(`\u767b\u5f55\u5931\u6548`);
        store.setAccessToken(``);
        store.set_updateVipDateTime(``);
        store.setUserInfoEndDate(``);
        await logout(accessToken);
      }
      if (response.status == 404) {
        return void 0;
      }
      return void 0;
    }
    const result = await response.json();
    sendLog(`\u0075\u0072\u006c\u003a` + url + `\uff0c\u0068\u0065\u0061\u0064\u0065\u0072\u003a` + JSON.stringify(headers) + `\u0020\u0072\u0065\u0073\u0070\u006f\u006e\u0073\u0065\u0020\u0073\u0074\u0061\u0074\u0075\u0073\u003a` + response.status + `\u002c\u0020\u0072\u0065\u0073\u0070\u006f\u006e\u0073\u0065\u0020\u0064\u0061\u0074\u0061\u003a` + JSON.stringify(result));
    console.log(`\u0072\u0065\u0073\u0075\u006c\u0074`, result);
    return result;
  } catch (error) {
    sendLog(`\u0075\u0072\u006c\u003a` + url + `\uff0c\u0068\u0065\u0061\u0064\u0065\u0072\u003a` + JSON.stringify(headers) + `\u002c\u0020\u0065\u0072\u0072\u006f\u0072` + error);
    console.error(`\u0045\u0072\u0072\u006f\u0072\u003a`, error);
  }
  return void 0;
}
const agentBusiness = async (boolBind = false) => {
  try {
    let terminalInfo = await queryTerminal();
    if (!terminalInfo) {
      const terminal_result = await register_terminal(VITE_AGENT_ID, VITE_AGENT_NAME);
      if (!terminal_result || !terminal_result.terminalId) {
        sendLog(`\u6ce8\u518c\u8bbe\u5907\u9519\u8bef`);
        return false;
      }
      const postTerminalData = {
        "agent_id": VITE_AGENT_ID,
        "terminal_name": store.terminalData && store.terminalData.terminalName ? store.terminalData.terminalName : `\u8bf7\u8bbe\u7f6e\u8bbe\u5907\u540d\u79f0`,
        "tenant_id": store.tenantId
      };
      const saveTerminalResult = await saveTerminal(terminal_result.terminalId, postTerminalData);
      if (!saveTerminalResult || !saveTerminalResult.data) {
        sendLog(`\u4fdd\u5b58\u8bbe\u5907\u9519\u8bef`);
        return false;
      }
      terminalInfo = await queryTerminal();
      if (!terminalInfo) {
        sendLog(`\u6ca1\u6709\u8bbe\u5907\u4fe1\u606f`);
        return false;
      }
    } else {
      if (boolBind) {
        const saveTerminalBindData = {
          "terminal_name": terminalInfo.terminalName ? terminalInfo.terminalName : `\u8bf7\u8bbe\u7f6e\u8bbe\u5907\u540d\u79f0`
        };
        const saveTerminalBindRes = await saveTerminalBind(terminalInfo.terminalId, saveTerminalBindData);
        console.log(`\u0061\u0067\u0065\u006e\u0074\u0042\u0075\u0073\u0069\u006e\u0065\u0073\u0073\u0020\u0073\u0061\u0076\u0065\u0054\u0065\u0072\u006d\u0069\u006e\u0061\u006c\u0042\u0069\u006e\u0064\u0052\u0065\u0073`, saveTerminalBindRes);
      }
    }
    const terminalCredentialsResult = await terminalCredentials(terminalInfo.terminalId, store.accessToken);
    if (!terminalCredentialsResult || !terminalCredentialsResult.data || !terminalCredentialsResult.data.mqtt_username || !terminalCredentialsResult.data.mqtt_password) {
      sendLog(`\u83b7\u53d6\u5bc6\u7801\u9519\u8bef`);
      return false;
    }
    sendLog(`\u0074\u0065\u0072\u006d\u0069\u006e\u0061\u006c\u0043\u0072\u0065\u0064\u0065\u006e\u0074\u0069\u0061\u006c\u0073\u0052\u0065\u0073\u0075\u006c\u0074` + JSON.stringify(terminalCredentialsResult));
    sendLog(`\u0074\u0065\u0072\u006d\u0069\u006e\u0061\u006c\u0049\u006e\u0066\u006f` + JSON.stringify(terminalInfo));
    store.setTerminalData({
      terminalId: terminalInfo.terminalId,
      terminalName: terminalInfo.terminalName,
      topic: {
        // 订阅任务
        "task_topic": `\u002f\u006d\u0073\u0067\u002f\u0074\u0061\u0073\u006b\u002f${store.tenantId}\u002f\u002b\u002f${VITE_AGENT_ID}\u002f${terminalInfo.terminalId}`,
        // 任务执行状态
        "task_reply_topics": `\u002f\u006d\u0073\u0067\u002f\u0072\u0065\u0070\u006c\u0079\u002f\u0074\u0065\u0072\u006d\u0069\u006e\u0061\u006c\u002f${store.tenantId}\u002f${store.userId}\u002f${VITE_AGENT_ID}\u002f${terminalInfo.terminalId}`,
        // 终端状态
        "status_reply_topics": `\u002f\u006d\u0073\u0067\u002f\u0072\u0065\u0070\u006c\u0079\u002f\u0074\u0065\u0072\u006d\u0069\u006e\u0061\u006c\u002f${store.tenantId}\u002f${store.userId}\u002f${VITE_AGENT_ID}\u002f${terminalInfo.terminalId}\u002f\u0073\u0074\u0061\u0074\u0075\u0073`,
        // 运行日志
        "run_logs_reply_topics": `\u002f\u006d\u0073\u0067\u002f\u0072\u0065\u0070\u006c\u0079\u002f\u0074\u0065\u0072\u006d\u0069\u006e\u0061\u006c\u002f${store.tenantId}\u002f${store.userId}\u002f${VITE_AGENT_ID}\u002f${terminalInfo.terminalId}\u002f\u0072\u0075\u006e\u005f\u006c\u006f\u0067\u0073`,
        // 心跳
        "heart_beat_topics": `\u002f\u006d\u0073\u0067\u002f\u0072\u0065\u0070\u006c\u0079\u002f\u0074\u0065\u0072\u006d\u0069\u006e\u0061\u006c\u002f${store.tenantId}\u002f${store.userId}\u002f${VITE_AGENT_ID}\u002f${terminalInfo.terminalId}\u002f\u0068\u0065\u0061\u0072\u0074\u005f\u0062\u0065\u0061\u0074`,
        // 报告
        "report_topics": `\u002f\u006d\u0073\u0067\u002f\u0072\u0065\u0070\u006c\u0079\u002f\u0074\u0065\u0072\u006d\u0069\u006e\u0061\u006c\u002f${store.tenantId}\u002f${store.userId}\u002f${VITE_AGENT_ID}\u002f${terminalInfo.terminalId}\u002f\u0072\u0065\u0070\u006f\u0072\u0074`
      },
      "mqtt_username": terminalCredentialsResult.data.mqtt_username,
      "mqtt_password": terminalCredentialsResult.data.mqtt_password
    });
    return true;
  } catch (e) {
    sendLog(`\u0061\u0067\u0065\u006e\u0074\u0042\u0075\u0073\u0069\u006e\u0065\u0073\u0073\u0020\u0065` + e);
  }
  return false;
};
const _hoisted_1$2 = {
  key: 0,
  style: {
    "display": `\u0066\u006c\u0065\u0078`,
    "flex-direction": `\u0063\u006f\u006c\u0075\u006d\u006e`,
    "justify-content": `\u0063\u0065\u006e\u0074\u0065\u0072`,
    "align-items": `\u0063\u0065\u006e\u0074\u0065\u0072`,
    "font-size": `\u0032\u0034\u0070\u0078`
  }
};
const _hoisted_2$1 = {
  style: {
    "font-size": `\u0032\u0034\u0070\u0078`,
    "color": `\u0023\u0032\u0031\u0033\u0035\u0034\u0037`
  }
};
const _hoisted_3$1 = [`\u0073\u0072\u0063`];
const _hoisted_4$1 = {
  key: 1,
  style: {
    "display": `\u0066\u006c\u0065\u0078`,
    "align-items": `\u0063\u0065\u006e\u0074\u0065\u0072`,
    "height": `\u0034\u0035\u0070\u0078`,
    "line-height": `\u0034\u0035\u0070\u0078`
  }
};
const _hoisted_5$1 = {
  key: 0,
  style: {
    "position": `\u0072\u0065\u006c\u0061\u0074\u0069\u0076\u0065`,
    "display": `\u0066\u006c\u0065\u0078`,
    "cursor": `\u0070\u006f\u0069\u006e\u0074\u0065\u0072`
  }
};
const _hoisted_6$1 = {
  style: {
    "position": `\u0061\u0062\u0073\u006f\u006c\u0075\u0074\u0065`,
    "top": `\u0030`,
    "left": `\u0030`,
    "width": `\u0031\u0030\u0030\u0025`,
    "height": `\u0031\u0030\u0030\u0025`,
    "display": `\u0066\u006c\u0065\u0078`,
    "justify-content": `\u0063\u0065\u006e\u0074\u0065\u0072`,
    "align-items": `\u0063\u0065\u006e\u0074\u0065\u0072`,
    "text-align": `\u0063\u0065\u006e\u0074\u0065\u0072`
  }
};
const _hoisted_7$1 = {
  style: {
    "display": `\u0069\u006e\u006c\u0069\u006e\u0065\u002d\u0062\u006c\u006f\u0063\u006b`,
    "margin": `\u0030\u0020\u0030\u002e\u0039\u0065\u006d`,
    "color": `\u0077\u0068\u0069\u0074\u0065`,
    "font-weight": `\u0035\u0030\u0030`,
    "font-size": `\u0031\u0038\u0070\u0078`
  }
};
const _hoisted_8$1 = {
  key: 1,
  style: {
    "position": `\u0072\u0065\u006c\u0061\u0074\u0069\u0076\u0065`,
    "display": `\u0066\u006c\u0065\u0078`,
    "cursor": `\u0070\u006f\u0069\u006e\u0074\u0065\u0072`
  }
};
const _hoisted_9$1 = {
  style: {
    "position": `\u0061\u0062\u0073\u006f\u006c\u0075\u0074\u0065`,
    "top": `\u0030`,
    "left": `\u0030`,
    "width": `\u0031\u0030\u0030\u0025`,
    "height": `\u0031\u0030\u0030\u0025`,
    "display": `\u0066\u006c\u0065\u0078`,
    "justify-content": `\u0063\u0065\u006e\u0074\u0065\u0072`,
    "align-items": `\u0063\u0065\u006e\u0074\u0065\u0072`,
    "text-align": `\u0063\u0065\u006e\u0074\u0065\u0072`
  }
};
const _hoisted_10$1 = {
  style: {
    "display": `\u0069\u006e\u006c\u0069\u006e\u0065\u002d\u0062\u006c\u006f\u0063\u006b`,
    "margin": `\u0030\u0020\u0030\u002e\u0039\u0065\u006d`,
    "color": `\u0077\u0068\u0069\u0074\u0065`,
    "font-weight": `\u0035\u0030\u0030`,
    "font-size": `\u0031\u0038\u0070\u0078`
  }
};
const _hoisted_11$1 = {
  key: 2,
  style: {
    "position": `\u0072\u0065\u006c\u0061\u0074\u0069\u0076\u0065`,
    "display": `\u0066\u006c\u0065\u0078`,
    "cursor": `\u0070\u006f\u0069\u006e\u0074\u0065\u0072`
  }
};
const _hoisted_12$1 = {
  style: {
    "position": `\u0061\u0062\u0073\u006f\u006c\u0075\u0074\u0065`,
    "top": `\u0030`,
    "left": `\u0030`,
    "width": `\u0031\u0030\u0030\u0025`,
    "height": `\u0031\u0030\u0030\u0025`,
    "display": `\u0066\u006c\u0065\u0078`,
    "justify-content": `\u0063\u0065\u006e\u0074\u0065\u0072`,
    "align-items": `\u0063\u0065\u006e\u0074\u0065\u0072`,
    "text-align": `\u0063\u0065\u006e\u0074\u0065\u0072`
  }
};
const _hoisted_13$1 = {
  style: {
    "display": `\u0069\u006e\u006c\u0069\u006e\u0065\u002d\u0062\u006c\u006f\u0063\u006b`,
    "margin": `\u0030\u0020\u0030\u002e\u0039\u0065\u006d`,
    "color": `\u0077\u0068\u0069\u0074\u0065`,
    "font-weight": `\u0035\u0030\u0030`,
    "font-size": `\u0031\u0038\u0070\u0078`
  }
};
const _hoisted_14$1 = {
  key: 2,
  style: {
    "font-size": `\u0032\u0034\u0070\u0078`,
    "color": `\u0023\u0032\u0031\u0033\u0035\u0034\u0037`
  }
};
const _hoisted_15$1 = {
  key: 3,
  style: {
    "display": `\u0066\u006c\u0065\u0078`,
    "align-items": `\u0063\u0065\u006e\u0074\u0065\u0072`,
    "height": `\u0034\u0035\u0070\u0078`,
    "line-height": `\u0034\u0035\u0070\u0078`
  }
};
const _hoisted_16$1 = {
  key: 0,
  style: {
    "position": `\u0072\u0065\u006c\u0061\u0074\u0069\u0076\u0065`,
    "display": `\u0066\u006c\u0065\u0078`,
    "cursor": `\u0070\u006f\u0069\u006e\u0074\u0065\u0072`
  }
};
const _hoisted_17$1 = {
  style: {
    "position": `\u0061\u0062\u0073\u006f\u006c\u0075\u0074\u0065`,
    "top": `\u0030`,
    "left": `\u0030`,
    "width": `\u0031\u0030\u0030\u0025`,
    "height": `\u0031\u0030\u0030\u0025`,
    "display": `\u0066\u006c\u0065\u0078`,
    "justify-content": `\u0063\u0065\u006e\u0074\u0065\u0072`,
    "align-items": `\u0063\u0065\u006e\u0074\u0065\u0072`,
    "text-align": `\u0063\u0065\u006e\u0074\u0065\u0072`
  }
};
const _hoisted_18$1 = {
  style: {
    "display": `\u0069\u006e\u006c\u0069\u006e\u0065\u002d\u0062\u006c\u006f\u0063\u006b`,
    "margin": `\u0030\u0020\u0030\u002e\u0031\u0065\u006d`,
    "color": `\u0077\u0068\u0069\u0074\u0065`,
    "font-weight": `\u0035\u0030\u0030`,
    "font-size": `\u0031\u0038\u0070\u0078`
  }
};
const _hoisted_19$1 = {
  key: 1,
  style: {
    "position": `\u0072\u0065\u006c\u0061\u0074\u0069\u0076\u0065`,
    "display": `\u0066\u006c\u0065\u0078`,
    "cursor": `\u0070\u006f\u0069\u006e\u0074\u0065\u0072`
  }
};
const _hoisted_20$1 = {
  style: {
    "position": `\u0061\u0062\u0073\u006f\u006c\u0075\u0074\u0065`,
    "top": `\u0030`,
    "left": `\u0030`,
    "width": `\u0031\u0030\u0030\u0025`,
    "height": `\u0031\u0030\u0030\u0025`,
    "display": `\u0066\u006c\u0065\u0078`,
    "justify-content": `\u0063\u0065\u006e\u0074\u0065\u0072`,
    "align-items": `\u0063\u0065\u006e\u0074\u0065\u0072`,
    "text-align": `\u0063\u0065\u006e\u0074\u0065\u0072`
  }
};
const _hoisted_21$1 = {
  style: {
    "display": `\u0069\u006e\u006c\u0069\u006e\u0065\u002d\u0062\u006c\u006f\u0063\u006b`,
    "margin": `\u0030\u0020\u0030\u002e\u0031\u0065\u006d`,
    "color": `\u0077\u0068\u0069\u0074\u0065`,
    "font-weight": `\u0035\u0030\u0030`,
    "font-size": `\u0031\u0038\u0070\u0078`
  }
};
const _hoisted_22$1 = {
  key: 2,
  style: {
    "position": `\u0072\u0065\u006c\u0061\u0074\u0069\u0076\u0065`,
    "display": `\u0066\u006c\u0065\u0078`,
    "cursor": `\u0070\u006f\u0069\u006e\u0074\u0065\u0072`
  }
};
const _hoisted_23$1 = {
  style: {
    "position": `\u0061\u0062\u0073\u006f\u006c\u0075\u0074\u0065`,
    "top": `\u0030`,
    "left": `\u0030`,
    "width": `\u0031\u0030\u0030\u0025`,
    "height": `\u0031\u0030\u0030\u0025`,
    "display": `\u0066\u006c\u0065\u0078`,
    "justify-content": `\u0063\u0065\u006e\u0074\u0065\u0072`,
    "align-items": `\u0063\u0065\u006e\u0074\u0065\u0072`,
    "text-align": `\u0063\u0065\u006e\u0074\u0065\u0072`
  }
};
const _hoisted_24$1 = {
  style: {
    "display": `\u0069\u006e\u006c\u0069\u006e\u0065\u002d\u0062\u006c\u006f\u0063\u006b`,
    "margin": `\u0030\u0020\u0030\u002e\u0031\u0065\u006d`,
    "color": `\u0077\u0068\u0069\u0074\u0065`,
    "font-weight": `\u0035\u0030\u0030`,
    "font-size": `\u0031\u0038\u0070\u0078`
  }
};
const _hoisted_25 = {
  class: `\u0064\u0069\u0061\u006c\u006f\u0067\u002d\u0066\u006f\u006f\u0074\u0065\u0072`
};
const _hoisted_26 = {
  class: `\u0064\u0069\u0061\u006c\u006f\u0067\u002d\u0066\u006f\u006f\u0074\u0065\u0072`
};
const _hoisted_27 = {
  class: `\u0064\u0069\u0061\u006c\u006f\u0067\u002d\u0066\u006f\u006f\u0074\u0065\u0072`
};
const _sfc_main$2 = /* @__PURE__ */defineComponent({
  __name: `\u004c\u006f\u0067\u0069\u006e`,
  setup(__props) {
    const VITE_AGENT_BOOL = `\u0066\u0061\u006c\u0073\u0065`;
    const loginStatusText = ref(getLocalizedMessage(`\u006c\u006f\u0067\u0069\u006e\u004c\u006f\u0067\u0067\u0069\u006e\u0067\u0054\u0065\u0078\u0074`));
    const showIframeBool = ref(false);
    const optionsPageNameOrgin = ref(``);
    const getLoginTokenBool = ref(false);
    const getLoginTokenCancelBoolean = ref(false);
    const getLoginTokenFun = async () => {
      console.log(`\u006f\u0070\u0074\u0069\u006f\u006e\u0073\u0050\u0061\u0067\u0065\u004e\u0061\u006d\u0065\u0020\u0067\u0065\u0074\u0041\u0063\u0063\u0065\u0073\u0073\u0054\u006f\u006b\u0065\u006e`);
      window.addEventListener(`\u006d\u0065\u0073\u0073\u0061\u0067\u0065`, event => {
        if (event.data.type === `\u006f\u0070\u0065\u006e\u002d\u0061\u0075\u0074\u0068`) {
          window.open(event.data.url, `\u005f\u0062\u006c\u0061\u006e\u006b`);
        }
      });
      try {
        closeTimeOutNum.value = 10;
        getLoginTokenController = new AbortController();
        const signal = getLoginTokenController.signal;
        const res = await getLoginToken(store.accessToken_request_id, signal);
        if (getLoginTokenCancelBoolean.value) {
          console.log(`\u0067\u0065\u0074\u004c\u006f\u0067\u0069\u006e\u0054\u006f\u006b\u0065\u006e\u0043\u0061\u006e\u0063\u0065\u006c\u0042\u006f\u006f\u006c\u0065\u0061\u006e\uff1a`, getLoginTokenCancelBoolean.value);
          optionsPageNameOrgin.value = store.optionsPageName;
          chrome.storage.local.set({
            "optionsPageName": ``
          }).then(res2 => {
            console.log(`\u0072\u0065\u0073`, res2);
          });
          return;
        }
        if (!res) {
          loginStatusText.value = getLocalizedMessage(`\u006c\u006f\u0067\u0069\u006e\u004c\u006f\u0067\u0069\u006e\u0054\u0069\u006d\u0065\u004f\u0075\u0074\u0054\u0065\u0078\u0074`);
          optionsPageNameOrgin.value = store.optionsPageName;
          chrome.storage.local.set({
            "optionsPageName": ``
          }).then(res2 => {
            console.log(`\u0072\u0065\u0073`, res2);
          });
          getLoginTokenBool.value = false;
          getLoginTokenCancelBoolean.value = true;
          showIframeBool.value = false;
          setTimeout(() => {
            closeTimeOutFun();
          }, 1e3);
          return;
        }
        console.log(`\u0067\u0065\u0074\u004c\u006f\u0067\u0069\u006e\u0054\u006f\u006b\u0065\u006e`, res);
        store.setUserName(res[`\u0065\u006d\u0061\u0069\u006c`]);
        store.setTenantId(res[`\u0074\u0065\u006e\u0061\u006e\u0074\u005f\u0069\u0064`]);
        store.setUserId(res[`\u0075\u0073\u0065\u0072\u005f\u0069\u0064`]);
        store.setAccessToken(res[`\u0061\u0063\u0063\u0065\u0073\u0073\u005f\u0074\u006f\u006b\u0065\u006e`]);
        store.setAccessToken_request_id(``);
        console.log(`\u0056\u0049\u0054\u0045\u005f\u0041\u0047\u0045\u004e\u0054\u005f\u0042\u004f\u004f\u004c`, VITE_AGENT_BOOL);
        if (VITE_AGENT_BOOL == `\u0074\u0072\u0075\u0065`) ;
        const postData = {
          "app_id": `\u0078\u0069\u0061\u006f\u0073\u0068\u0075\u0074\u0069\u0061\u006f\u002d\u0061\u0075\u0074\u006f\u006d\u0061\u0074\u0069\u0063\u002d\u0072\u0065\u0076\u0069\u0065\u0077\u0073`,
          "client_id": store.clientVisitorId,
          "event": `\u006c\u006f\u0067\u0069\u006e\u0053\u0075\u0063\u0063\u0065\u0073\u0073`,
          "category": ``,
          "data": {},
          "data_type": ``,
          "description": ``
        };
        putBurialPoint(postData).then(() => {});
        loginStatusText.value = getLocalizedMessage(`\u006c\u006f\u0067\u0069\u006e\u004c\u006f\u0067\u0069\u006e\u0053\u0075\u0063\u0063\u0065\u0073\u0073\u0054\u0065\u0078\u0074`);
        showIframeBool.value = false;
        optionsPageNameOrgin.value = store.optionsPageName;
        chrome.storage.local.set({
          "optionsPageName": ``
        }).then(res2 => {
          console.log(`\u0072\u0065\u0073`, res2);
        });
        getLoginTokenBool.value = false;
        if (tenantDialogVisible.value == false) {
          getLoginTokenCancelBoolean.value = true;
          setTimeout(() => {
            closeTimeOutFun();
          }, 1e3);
        }
      } catch (error) {
        getLoginTokenBool.value = false;
        console.log(`\u0065\u0072\u0072\u006f\u0072`, error);
        ElMessage.error(getLocalizedMessage(`\u006c\u006f\u0067\u0069\u006e\u004c\u006f\u0067\u0069\u006e\u0054\u0069\u006d\u0065\u004f\u0075\u0074\u0054\u0065\u0078\u0074`));
        loginStatusText.value = getLocalizedMessage(`\u006c\u006f\u0067\u0069\u006e\u004c\u006f\u0067\u0069\u006e\u0054\u0069\u006d\u0065\u004f\u0075\u0074\u0054\u0065\u0078\u0074`);
        optionsPageNameOrgin.value = store.optionsPageName;
        chrome.storage.local.set({
          "optionsPageName": ``
        }).then(res => {
          console.log(`\u0072\u0065\u0073`, res);
        });
        getLoginTokenCancelBoolean.value = true;
        showIframeBool.value = false;
        if (tenantDialogVisible.value == false) {
          setTimeout(() => {
            closeTimeOutFun();
          }, 1e3);
        }
      } finally {
        store.setLoginAuthUrl(``);
        getLoginTokenBool.value = false;
        chrome.storage.local.set({
          "loginAuthUrl": ``
        });
      }
    };
    const callBackHandler = (changes, namespace) => {
      for (let [key, {
        oldValue,
        newValue
      }] of Object.entries(changes)) {
        sendLog(`\u006c\u006f\u0067\u0069\u006e\u0020\u0053\u0074\u006f\u0072\u0061\u0067\u0065\u0020\u006b\u0065\u0079\u0020\u0022${key}\u0022\u0020\u0069\u006e\u0020\u006e\u0061\u006d\u0065\u0073\u0070\u0061\u0063\u0065\u0020\u0022${namespace}\u0022\u0020\u0063\u0068\u0061\u006e\u0067\u0065\u0064\u002e\u004f\u006c\u0064\u0020\u0076\u0061\u006c\u0075\u0065\u0020\u0077\u0061\u0073\u0020\u0022${oldValue}\u0022\u002c\u0020\u006e\u0065\u0077\u0020\u0076\u0061\u006c\u0075\u0065\u0020\u0069\u0073\u0020\u0022${newValue}\u0022\u002e`);
        if (!newValue) {
          continue;
        }
        switch (key) {
          case `\u006f\u0070\u0074\u0069\u006f\u006e\u0073\u0050\u0061\u0067\u0065\u004e\u0061\u006d\u0065`:
            store.setOptionsPageName(newValue);
            if (newValue == `\u0067\u0065\u0074\u0041\u0063\u0063\u0065\u0073\u0073\u0054\u006f\u006b\u0065\u006e`) {
              console.log(`\u0063\u0068\u0072\u006f\u006d\u0065\u002e\u0073\u0074\u006f\u0072\u0061\u0067\u0065\u002e\u006f\u006e\u0043\u0068\u0061\u006e\u0067\u0065\u0064\u002e\u0061\u0064\u0064\u004c\u0069\u0073\u0074\u0065\u006e\u0065\u0072\u0020\u0067\u0065\u0074\u0041\u0063\u0063\u0065\u0073\u0073\u0054\u006f\u006b\u0065\u006e\u0020`, store.accessToken_request_id);
              loginStatusText.value = getLocalizedMessage(`\u006c\u006f\u0067\u0069\u006e\u004c\u006f\u0067\u0067\u0069\u006e\u0067\u0054\u0065\u0078\u0074`);
              if (store.accessToken_request_id && getLoginTokenBool.value == false) {
                getLoginTokenBool.value = true;
                getLoginTokenCancelBoolean.value = false;
                getLoginTokenFun().then(() => {});
              }
            }
            if (newValue == `\u0062\u0069\u006e\u0064\u0069\u006e\u0067\u0054\u0065\u006e\u0061\u006e\u0074\u0073`) {
              loginStatusText.value = getLocalizedMessage(`\u0062\u0069\u006e\u0064\u0069\u006e\u0067\u0054\u0065\u006e\u0061\u006e\u0074\u0073\u0054\u0065\u0078\u0074`);
              tenantDialogVisible.value = true;
            }
            chrome.storage.local.set({
              "optionsPageName": ``
            }).then(res => {
              console.log(`\u0072\u0065\u0073`, res);
            });
            break;
          case `\u006c\u006f\u0067\u0069\u006e\u0041\u0075\u0074\u0068\u0055\u0072\u006c`:
            store.setLoginAuthUrl(newValue);
            if (newValue) {
              showIframeBool.value = true;
            }
            chrome.storage.local.set({
              "loginAuthUrl": ``
            }).then(res => {
              console.log(`\u0072\u0065\u0073`, res);
            });
            break;
          case `\u0061\u0063\u0063\u0065\u0073\u0073\u0054\u006f\u006b\u0065\u006e\u005f\u0072\u0065\u0071\u0075\u0065\u0073\u0074\u005f\u0069\u0064`:
            store.setAccessToken_request_id2(newValue);
            console.log(`\u0063\u0068\u0072\u006f\u006d\u0065\u002e\u0073\u0074\u006f\u0072\u0061\u0067\u0065\u002e\u006f\u006e\u0043\u0068\u0061\u006e\u0067\u0065\u0064\u002e\u0061\u0064\u0064\u004c\u0069\u0073\u0074\u0065\u006e\u0065\u0072\u0020\u0061\u0063\u0063\u0065\u0073\u0073\u0054\u006f\u006b\u0065\u006e\u005f\u0072\u0065\u0071\u0075\u0065\u0073\u0074\u005f\u0069\u0064\u0020`, store.accessToken_request_id);
            if (store.accessToken_request_id && getLoginTokenBool.value == false) {
              getLoginTokenBool.value = true;
              getLoginTokenCancelBoolean.value = false;
              getLoginTokenFun().then(() => {});
            }
            chrome.storage.local.set({
              "accessToken_request_id": ``
            }).then(res => {
              console.log(`\u0072\u0065\u0073`, res);
            });
            break;
        }
      }
    };
    store.checkLoadend().then(async () => {
      if (store.optionsPageName == `\u0067\u0065\u0074\u0041\u0063\u0063\u0065\u0073\u0073\u0054\u006f\u006b\u0065\u006e` && getLoginTokenBool.value == false) {
        getLoginTokenBool.value = true;
        getLoginTokenCancelBoolean.value = false;
        loginStatusText.value = getLocalizedMessage(`\u006c\u006f\u0067\u0069\u006e\u004c\u006f\u0067\u0067\u0069\u006e\u0067\u0054\u0065\u0078\u0074`);
        sendLog(`\u0063\u0068\u0065\u0063\u006b\u004c\u006f\u0061\u0064\u0065\u006e\u0064\u0020\u0067\u0065\u0074\u0041\u0063\u0063\u0065\u0073\u0073\u0054\u006f\u006b\u0065\u006e\u003a` + store.optionsPageName);
        showIframeBool.value = true;
        storageUtil.addHandlers(callBackHandler);
        await getLoginTokenFun();
      }
      console.log(`\u006c\u006f\u0067\u0069\u006e\u0020\u0062\u0069\u006e\u0064\u0069\u006e\u0067\u0054\u0065\u006e\u0061\u006e\u0074\u0073`, store.optionsPageName);
      if (store.optionsPageName == `\u0062\u0069\u006e\u0064\u0069\u006e\u0067\u0054\u0065\u006e\u0061\u006e\u0074\u0073` && tenantDialogVisible.value == false) {
        setTimeout(() => {
          chrome.storage.local.set({
            "optionsPageName": ``
          });
        }, 5e3);
        loginStatusText.value = getLocalizedMessage(`\u0062\u0069\u006e\u0064\u0069\u006e\u0067\u0054\u0065\u006e\u0061\u006e\u0074\u0073\u0054\u0065\u0078\u0074`);
        tenantDialogVisible.value = true;
        storageUtil.addHandlers(callBackHandler);
      }
    });
    onBeforeUnmount(() => {
      console.log(`\u004c\u004f\u0047\u0049\u004e\u0020\u006f\u006e\u0042\u0065\u0066\u006f\u0072\u0065\u0055\u006e\u006d\u006f\u0075\u006e\u0074`);
      storageUtil.removeListener(callBackHandler);
    });
    const cancelPayOption = ref(0);
    const closeTimeOutNum = ref(10);
    let getLoginTokenController = void 0;
    const cancelGetLoginTokenFun = () => {
      getLoginTokenBool.value = false;
      getLoginTokenCancelBoolean.value = true;
      if (getLoginTokenController) {
        getLoginTokenController.abort();
        loginStatusText.value = getLocalizedMessage(`\u006c\u006f\u0067\u0069\u006e\u004c\u006f\u0067\u0069\u006e\u0043\u0061\u006e\u0063\u0065\u006c\u0054\u0065\u0078\u0074`);
        showIframeBool.value = false;
        store.setLoginAuthUrl(``);
        setTimeout(() => {
          closeTimeOutFun();
        }, 1e3);
      }
    };
    const closeTimeOutFun = () => {
      if (closeTimeOutNum.value <= 0) {
        sendCloseTab();
        return;
      }
      closeTimeOutNum.value = closeTimeOutNum.value - 1;
      setTimeout(() => {
        closeTimeOutFun();
      }, 1e3);
    };
    const tenantDialogVisible = ref(false);
    const tenantJoinDialogVisible = ref(false);
    const tenantCreateDialogVisible = ref(false);
    const buttonLoading = ref(false);
    const form = reactive({
      tenantId: ``,
      tenantName: ``,
      tenantName2: ``
    });
    const createTenantsFun = () => {
      buttonLoading.value = true;
      createTenants({
        name: form.tenantName
      }).then(async res => {
        console.log(`\u0063\u0072\u0065\u0061\u0074\u0065\u0054\u0065\u006e\u0061\u006e\u0074\u0073\u0046\u0075\u006e\u0020\u0072\u0065\u0073`, res);
        if (!res) {
          ElMessage.error(`\u521b\u5efa\u516c\u53f8\u9519\u8bef\uff01`);
        } else {
          if (res && res.data && res.data.id) {
            store.setTenantId(res.data.id);
            store.setTenantName(res.data.name);
            if (res.data.access_token) {
              sendLog(`\u0063\u0072\u0065\u0061\u0074\u0065\u0054\u0065\u006e\u0061\u006e\u0074\u0073\u0046\u0075\u006e\u0020\u0072\u0065\u0073\u002e\u0064\u0061\u0074\u0061\u002e\u0061\u0063\u0063\u0065\u0073\u0073\u005f\u0074\u006f\u006b\u0065\u006e` + res.data.access_token);
              store.setAccessToken(res.data.access_token);
            } else {
              sendLog(`\u0063\u0072\u0065\u0061\u0074\u0065\u0054\u0065\u006e\u0061\u006e\u0074\u0073\u0046\u0075\u006e\u0020\u006e\u006f\u0074\u0020\u0072\u0065\u0073\u002e\u0064\u0061\u0074\u0061\u002e\u0061\u0063\u0063\u0065\u0073\u0073\u005f\u0074\u006f\u006b\u0065\u006e` + res.data.access_token);
            }
            const agentBusinessRes = await agentBusiness(true);
            if (agentBusinessRes) {
              ElMessage.success(`\u521b\u5efa\u516c\u53f8\u6210\u529f`);
              tenantCreateDialogVisible.value = false;
              notTenants();
            } else {
              ElMessage.error(`\u521b\u5efa\u516c\u53f8\u9519\u8bef\uff01`);
            }
          } else {
            ElMessage.error(`\u521b\u5efa\u516c\u53f8\u9519\u8bef\uff01`);
          }
        }
      }).catch(error => {
        console.log(`\u0063\u0072\u0065\u0061\u0074\u0065\u0054\u0065\u006e\u0061\u006e\u0074\u0073\u0046\u0075\u006e\u0020\u0065\u0072\u0072\u006f\u0072`, error);
        ElMessage.error(`\u521b\u5efa\u516c\u53f8\u9519\u8bef\uff01`);
      }).finally(() => {
        console.log(`\u0063\u0072\u0065\u0061\u0074\u0065\u0054\u0065\u006e\u0061\u006e\u0074\u0073\u0046\u0075\u006e\u0020\u0066\u0069\u006e\u0061\u006c\u006c\u0079`);
        buttonLoading.value = false;
      });
    };
    const queryTenantsFun = () => {
      buttonLoading.value = true;
      if (!form.tenantName) {
        buttonLoading.value = false;
        return;
      }
      queryTenants(form.tenantName).then(res => {
        console.log(`\u0071\u0075\u0065\u0072\u0079\u0054\u0065\u006e\u0061\u006e\u0074\u0073\u0046\u0075\u006e\u0020\u0072\u0065\u0073`, res);
        if (!res) ;else {
          if (res && res.data && res.data.id) {
            form.tenantName2 = res.data.name;
            form.tenantId = res.data.id;
          }
        }
      }).catch(error => {
        console.log(`\u0063\u0072\u0065\u0061\u0074\u0065\u0054\u0065\u006e\u0061\u006e\u0074\u0073\u0046\u0075\u006e\u0020\u0065\u0072\u0072\u006f\u0072`, error);
      }).finally(() => {
        console.log(`\u0063\u0072\u0065\u0061\u0074\u0065\u0054\u0065\u006e\u0061\u006e\u0074\u0073\u0046\u0075\u006e\u0020\u0066\u0069\u006e\u0061\u006c\u006c\u0079`);
        buttonLoading.value = false;
      });
    };
    const bingingTenantsFun = () => {
      buttonLoading.value = true;
      bingingTenants(form.tenantId).then(async res => {
        console.log(`\u0062\u0069\u006e\u0067\u0069\u006e\u0067\u0054\u0065\u006e\u0061\u006e\u0074\u0073\u0020\u0072\u0065\u0073`, res);
        if (!res) {
          ElMessage.error(`\u7ed1\u5b9a\u516c\u53f8\u9519\u8bef\uff01`);
        } else {
          if (res && res.code === 0) {
            if (res.data.access_token) {
              sendLog(`\u0062\u0069\u006e\u0067\u0069\u006e\u0067\u0054\u0065\u006e\u0061\u006e\u0074\u0073\u0020\u0072\u0065\u0073\u002e\u0064\u0061\u0074\u0061\u002e\u0061\u0063\u0063\u0065\u0073\u0073\u005f\u0074\u006f\u006b\u0065\u006e` + res.data.access_token);
              store.setAccessToken(res.data.access_token);
            } else {
              sendLog(`\u0062\u0069\u006e\u0067\u0069\u006e\u0067\u0054\u0065\u006e\u0061\u006e\u0074\u0073\u0020\u006e\u006f\u0074\u0020\u0072\u0065\u0073\u002e\u0064\u0061\u0074\u0061\u002e\u0061\u0063\u0063\u0065\u0073\u0073\u005f\u0074\u006f\u006b\u0065\u006e` + res.data.access_token);
            }
            buttonLoading.value = true;
            return tenantsMine();
          } else {
            ElMessage.error(`\u7ed1\u5b9a\u516c\u53f8\u9519\u8bef\uff01`);
          }
        }
      }).then(async res => {
        if (res && res.data && res.data.id) {
          store.setTenantId(form.tenantId);
          store.setTenantName(res.data.name);
          const agentBusinessRes = await agentBusiness(true);
          if (agentBusinessRes) {
            ElMessage.success(`\u7ed1\u5b9a\u516c\u53f8\u6210\u529f\uff01`);
            tenantJoinDialogVisible.value = false;
            notTenants();
          } else {
            ElMessage.error(`\u7ed1\u5b9a\u516c\u53f8\u9519\u8bef\uff01`);
          }
        } else {
          ElMessage.error(`\u7ed1\u5b9a\u516c\u53f8\u9519\u8bef\uff01`);
        }
      }).catch(error => {
        console.log(`\u0062\u0069\u006e\u0067\u0069\u006e\u0067\u0054\u0065\u006e\u0061\u006e\u0074\u0073\u0020\u0065\u0072\u0072\u006f\u0072`, error);
        ElMessage.error(`\u7ed1\u5b9a\u516c\u53f8\u9519\u8bef\uff01`);
      }).finally(() => {
        console.log(`\u0062\u0069\u006e\u0067\u0069\u006e\u0067\u0054\u0065\u006e\u0061\u006e\u0074\u0073\u0020\u0066\u0069\u006e\u0061\u006c\u006c\u0079`);
        buttonLoading.value = false;
      });
    };
    const handleClose = done => {
      done();
      tenantJoinDialogVisible.value = false;
      tenantCreateDialogVisible.value = false;
      notTenants();
    };
    const notTenants = () => {
      if (getLoginTokenCancelBoolean.value == true) {
        return;
      }
      if (tenantJoinDialogVisible.value || tenantCreateDialogVisible.value) {
        return;
      }
      getLoginTokenCancelBoolean.value = true;
      tenantDialogVisible.value = false;
      setTimeout(() => {
        closeTimeOutFun();
      }, 1e3);
    };
    const $t = inject(`\u0024\u0074`);
    return (_ctx, _cache) => {
      const _component_el_button = ElButton;
      const _component_el_dialog = ElDialog;
      const _component_el_input = ElInput;
      const _component_el_form_item = ElFormItem;
      const _component_el_form = ElForm;
      return unref(store).optionsPageName == `\u0067\u0065\u0074\u0041\u0063\u0063\u0065\u0073\u0073\u0054\u006f\u006b\u0065\u006e` || optionsPageNameOrgin.value == `\u0067\u0065\u0074\u0041\u0063\u0063\u0065\u0073\u0073\u0054\u006f\u006b\u0065\u006e` || unref(store).optionsPageName == `\u0062\u0069\u006e\u0064\u0069\u006e\u0067\u0054\u0065\u006e\u0061\u006e\u0074\u0073` ? (openBlock(), createElementBlock(`\u0064\u0069\u0076`, _hoisted_1$2, [createBaseVNode(`\u0064\u0069\u0076`, _hoisted_2$1, toDisplayString(loginStatusText.value), 1), showIframeBool.value ? (openBlock(), createElementBlock(`\u0069\u0066\u0072\u0061\u006d\u0065`, {
        key: 0,
        src: unref(store).loginAuthUrl + `\u0026\u006f\u0070\u0065\u006e\u005f\u0062\u006c\u0061\u006e\u006b\u003d\u0074\u0072\u0075\u0065`,
        style: {
          "width": `\u0036\u0030\u0030\u0070\u0078`,
          "height": `\u0036\u0030\u0030\u0070\u0078`,
          "z-index": `\u0031\u0030\u0030\u0030\u0030\u0030\u0030\u0034`,
          "border": `\u006e\u006f\u006e\u0065`
        }
      }, null, 8, _hoisted_3$1)) : createCommentVNode(``, true), _cache[24] || (_cache[24] = createBaseVNode(`\u0064\u0069\u0076`, {
        style: {
          "height": `\u0033\u0030\u0070\u0078`,
          "line-height": `\u0033\u0030\u0070\u0078`
        }
      }, null, -1)), getLoginTokenBool.value ? (openBlock(), createElementBlock(`\u0064\u0069\u0076`, _hoisted_4$1, [createBaseVNode(`\u0064\u0069\u0076`, {
        onClick: cancelGetLoginTokenFun,
        onMouseover: _cache[0] || (_cache[0] = () => {
          cancelPayOption.value = 1;
        }),
        onMouseleave: _cache[1] || (_cache[1] = () => {
          cancelPayOption.value = 0;
        })
      }, [cancelPayOption.value == 0 ? (openBlock(), createElementBlock(`\u0064\u0069\u0076`, _hoisted_5$1, [_cache[12] || (_cache[12] = createBaseVNode(`\u0069\u006d\u0067`, {
        src: _imports_0$1,
        style: {
          "width": `\u0031\u0036\u0030\u0070\u0078`,
          "cursor": `\u0070\u006f\u0069\u006e\u0074\u0065\u0072`
        },
        alt: `\u0056\u0075\u0065\u0020\u006c\u006f\u0067\u006f`
      }, null, -1)), createBaseVNode(`\u0064\u0069\u0076`, _hoisted_6$1, [(openBlock(true), createElementBlock(Fragment, null, renderList(unref(splitChineseAndEnglish)(unref(getLocalizedMessage)(`\u006f\u0070\u0074\u0069\u006f\u006e\u0073\u0057\u0069\u006e\u0064\u006f\u0077\u0043\u0061\u006e\u0063\u0065\u006c\u0054\u0065\u0078\u0074`)), text => {
        return openBlock(), createElementBlock(`\u0073\u0070\u0061\u006e`, _hoisted_7$1, toDisplayString(text), 1);
      }), 256))])])) : createCommentVNode(``, true), cancelPayOption.value == 1 ? (openBlock(), createElementBlock(`\u0064\u0069\u0076`, _hoisted_8$1, [_cache[13] || (_cache[13] = createBaseVNode(`\u0069\u006d\u0067`, {
        src: _imports_1$1,
        style: {
          "width": `\u0031\u0036\u0030\u0070\u0078`,
          "cursor": `\u0070\u006f\u0069\u006e\u0074\u0065\u0072`
        },
        alt: `\u0056\u0075\u0065\u0020\u006c\u006f\u0067\u006f`
      }, null, -1)), createBaseVNode(`\u0064\u0069\u0076`, _hoisted_9$1, [(openBlock(true), createElementBlock(Fragment, null, renderList(unref(splitChineseAndEnglish)(unref(getLocalizedMessage)(`\u006f\u0070\u0074\u0069\u006f\u006e\u0073\u0057\u0069\u006e\u0064\u006f\u0077\u0043\u0061\u006e\u0063\u0065\u006c\u0054\u0065\u0078\u0074`)), text => {
        return openBlock(), createElementBlock(`\u0073\u0070\u0061\u006e`, _hoisted_10$1, toDisplayString(text), 1);
      }), 256))])])) : createCommentVNode(``, true), cancelPayOption.value == 2 ? (openBlock(), createElementBlock(`\u0064\u0069\u0076`, _hoisted_11$1, [_cache[14] || (_cache[14] = createBaseVNode(`\u0069\u006d\u0067`, {
        src: _imports_2,
        style: {
          "width": `\u0031\u0036\u0030\u0070\u0078`,
          "cursor": `\u0070\u006f\u0069\u006e\u0074\u0065\u0072`
        },
        alt: `\u0056\u0075\u0065\u0020\u006c\u006f\u0067\u006f`
      }, null, -1)), createBaseVNode(`\u0064\u0069\u0076`, _hoisted_12$1, [(openBlock(true), createElementBlock(Fragment, null, renderList(unref(splitChineseAndEnglish)(unref(getLocalizedMessage)(`\u006f\u0070\u0074\u0069\u006f\u006e\u0073\u0057\u0069\u006e\u0064\u006f\u0077\u0043\u0061\u006e\u0063\u0065\u006c\u0054\u0065\u0078\u0074`)), text => {
        return openBlock(), createElementBlock(`\u0073\u0070\u0061\u006e`, _hoisted_13$1, toDisplayString(text), 1);
      }), 256))])])) : createCommentVNode(``, true)], 32)])) : createCommentVNode(``, true), getLoginTokenCancelBoolean.value ? (openBlock(), createElementBlock(`\u0064\u0069\u0076`, _hoisted_14$1, toDisplayString(unref($t)(`\u006f\u0070\u0074\u0069\u006f\u006e\u0073\u0057\u0069\u006e\u0064\u006f\u0077\u0043\u006c\u006f\u0073\u0065\u0054\u0069\u006d\u0065\u004f\u0075\u0074\u0054\u0065\u0078\u0074`, closeTimeOutNum.value)), 1)) : createCommentVNode(``, true), getLoginTokenCancelBoolean.value ? (openBlock(), createElementBlock(`\u0064\u0069\u0076`, _hoisted_15$1, [createBaseVNode(`\u0064\u0069\u0076`, {
        onClick: _cache[2] || (_cache[2] =
        //@ts-ignore
        (...args) => unref(sendCloseTab) && unref(sendCloseTab)(...args)),
        onMouseover: _cache[3] || (_cache[3] = () => {
          cancelPayOption.value = 1;
        }),
        onMouseleave: _cache[4] || (_cache[4] = () => {
          cancelPayOption.value = 0;
        })
      }, [cancelPayOption.value == 0 ? (openBlock(), createElementBlock(`\u0064\u0069\u0076`, _hoisted_16$1, [_cache[15] || (_cache[15] = createBaseVNode(`\u0069\u006d\u0067`, {
        src: _imports_0$1,
        style: {
          "width": `\u0031\u0036\u0030\u0070\u0078`,
          "cursor": `\u0070\u006f\u0069\u006e\u0074\u0065\u0072`
        },
        alt: `\u0056\u0075\u0065\u0020\u006c\u006f\u0067\u006f`
      }, null, -1)), createBaseVNode(`\u0064\u0069\u0076`, _hoisted_17$1, [(openBlock(true), createElementBlock(Fragment, null, renderList(unref(splitChineseAndEnglish)(unref(getLocalizedMessage)(`\u006f\u0070\u0074\u0069\u006f\u006e\u0073\u0057\u0069\u006e\u0064\u006f\u0077\u0043\u006c\u006f\u0073\u0065\u0054\u0065\u0078\u0074`)), text => {
        return openBlock(), createElementBlock(`\u0073\u0070\u0061\u006e`, _hoisted_18$1, toDisplayString(text), 1);
      }), 256))])])) : createCommentVNode(``, true), cancelPayOption.value == 1 ? (openBlock(), createElementBlock(`\u0064\u0069\u0076`, _hoisted_19$1, [_cache[16] || (_cache[16] = createBaseVNode(`\u0069\u006d\u0067`, {
        src: _imports_1$1,
        style: {
          "width": `\u0031\u0036\u0030\u0070\u0078`,
          "cursor": `\u0070\u006f\u0069\u006e\u0074\u0065\u0072`
        },
        alt: `\u0056\u0075\u0065\u0020\u006c\u006f\u0067\u006f`
      }, null, -1)), createBaseVNode(`\u0064\u0069\u0076`, _hoisted_20$1, [(openBlock(true), createElementBlock(Fragment, null, renderList(unref(splitChineseAndEnglish)(unref(getLocalizedMessage)(`\u006f\u0070\u0074\u0069\u006f\u006e\u0073\u0057\u0069\u006e\u0064\u006f\u0077\u0043\u006c\u006f\u0073\u0065\u0054\u0065\u0078\u0074`)), text => {
        return openBlock(), createElementBlock(`\u0073\u0070\u0061\u006e`, _hoisted_21$1, toDisplayString(text), 1);
      }), 256))])])) : createCommentVNode(``, true), cancelPayOption.value == 2 ? (openBlock(), createElementBlock(`\u0064\u0069\u0076`, _hoisted_22$1, [_cache[17] || (_cache[17] = createBaseVNode(`\u0069\u006d\u0067`, {
        src: _imports_2,
        style: {
          "width": `\u0031\u0036\u0030\u0070\u0078`,
          "cursor": `\u0070\u006f\u0069\u006e\u0074\u0065\u0072`
        },
        alt: `\u0056\u0075\u0065\u0020\u006c\u006f\u0067\u006f`
      }, null, -1)), createBaseVNode(`\u0064\u0069\u0076`, _hoisted_23$1, [(openBlock(true), createElementBlock(Fragment, null, renderList(unref(splitChineseAndEnglish)(unref(getLocalizedMessage)(`\u006f\u0070\u0074\u0069\u006f\u006e\u0073\u0057\u0069\u006e\u0064\u006f\u0077\u0043\u006c\u006f\u0073\u0065\u0054\u0065\u0078\u0074`)), text => {
        return openBlock(), createElementBlock(`\u0073\u0070\u0061\u006e`, _hoisted_24$1, toDisplayString(text), 1);
      }), 256))])])) : createCommentVNode(``, true)], 32)])) : createCommentVNode(``, true), createVNode(_component_el_dialog, {
        modelValue: tenantDialogVisible.value,
        "onUpdate:modelValue": _cache[7] || (_cache[7] = $event => tenantDialogVisible.value = $event),
        title: `\u63d0\u793a`,
        width: `\u0035\u0030\u0030`,
        "close-on-click-modal": false,
        "close-on-press-escape": false,
        "before-close": handleClose
      }, {
        footer: withCtx(() => [createBaseVNode(`\u0064\u0069\u0076`, _hoisted_25, [createVNode(_component_el_button, {
          type: `\u0070\u0072\u0069\u006d\u0061\u0072\u0079`,
          onClick: _cache[5] || (_cache[5] = $event => {
            tenantDialogVisible.value = false;
            tenantJoinDialogVisible.value = true;
          })
        }, {
          default: withCtx(() => _cache[18] || (_cache[18] = [createTextVNode(`\u52a0\u5165\u5df2\u6709\u7684\u516c\u53f8`)])),
          _: 1
        }), createVNode(_component_el_button, {
          type: `\u0070\u0072\u0069\u006d\u0061\u0072\u0079`,
          onClick: _cache[6] || (_cache[6] = $event => {
            tenantDialogVisible.value = false;
            tenantCreateDialogVisible.value = true;
          })
        }, {
          default: withCtx(() => _cache[19] || (_cache[19] = [createTextVNode(`\u521b\u5efa\u65b0\u7684\u516c\u53f8`)])),
          _: 1
        }), createVNode(_component_el_button, {
          onClick: notTenants
        }, {
          default: withCtx(() => _cache[20] || (_cache[20] = [createTextVNode(`\u8df3\u8fc7\uff0c\u4e0d\u9700\u8981`)])),
          _: 1
        })])]),
        default: withCtx(() => [_cache[21] || (_cache[21] = createBaseVNode(`\u0073\u0070\u0061\u006e`, null, `\u5f53\u524d\u7528\u6237\u6ca1\u6709\u52a0\u5165\u4efb\u4f55\u516c\u53f8\uff0c\u8bf7\u786e\u8ba4\u662f\u5426\u9700\u8981\u521b\u5efa\u6216\u52a0\u5165\u516c\u53f8\uff01`, -1))]),
        _: 1
      }, 8, [`\u006d\u006f\u0064\u0065\u006c\u0056\u0061\u006c\u0075\u0065`]), createVNode(_component_el_dialog, {
        modelValue: tenantJoinDialogVisible.value,
        "onUpdate:modelValue": _cache[9] || (_cache[9] = $event => tenantJoinDialogVisible.value = $event),
        title: `\u52a0\u5165\u5df2\u6709\u7684\u516c\u53f8`,
        width: `\u0035\u0030\u0030`,
        "close-on-click-modal": false,
        "close-on-press-escape": false,
        "before-close": handleClose
      }, {
        footer: withCtx(() => [createBaseVNode(`\u0064\u0069\u0076`, _hoisted_26, [createVNode(_component_el_button, {
          disabled: form.tenantId == ``,
          loading: buttonLoading.value,
          type: `\u0070\u0072\u0069\u006d\u0061\u0072\u0079`,
          onClick: bingingTenantsFun
        }, {
          default: withCtx(() => _cache[22] || (_cache[22] = [createTextVNode(`\u52a0\u5165\u516c\u53f8`)])),
          _: 1
        }, 8, [`\u0064\u0069\u0073\u0061\u0062\u006c\u0065\u0064`, `\u006c\u006f\u0061\u0064\u0069\u006e\u0067`])])]),
        default: withCtx(() => [createVNode(_component_el_form, {
          model: form,
          "label-width": `\u0061\u0075\u0074\u006f`,
          style: {
            "max-width": `\u0036\u0030\u0030\u0070\u0078`
          }
        }, {
          default: withCtx(() => [createVNode(_component_el_form_item, {
            label: `\u516c\u53f8\u540d\u79f0`
          }, {
            default: withCtx(() => [createVNode(_component_el_input, {
              modelValue: form.tenantName,
              "onUpdate:modelValue": _cache[8] || (_cache[8] = $event => form.tenantName = $event),
              style: {
                "max-width": `\u0036\u0030\u0030\u0070\u0078`
              },
              placeholder: `\u8bf7\u8f93\u5165\u5df2\u6709\u7684\u516c\u53f8\u540d\u79f0\u67e5\u8be2`,
              class: `\u0069\u006e\u0070\u0075\u0074\u002d\u0077\u0069\u0074\u0068\u002d\u0073\u0065\u006c\u0065\u0063\u0074`
            }, {
              append: withCtx(() => [createVNode(_component_el_button, {
                loading: buttonLoading.value,
                icon: unref(search_default),
                onClick: queryTenantsFun
              }, null, 8, [`\u006c\u006f\u0061\u0064\u0069\u006e\u0067`, `\u0069\u0063\u006f\u006e`])]),
              _: 1
            }, 8, [`\u006d\u006f\u0064\u0065\u006c\u0056\u0061\u006c\u0075\u0065`])]),
            _: 1
          }), form.tenantId ? (openBlock(), createBlock(_component_el_form_item, {
            key: 0,
            label: `\u516c\u53f8\u0049\u0064`
          }, {
            default: withCtx(() => [createBaseVNode(`\u0073\u0070\u0061\u006e`, null, toDisplayString(form.tenantId), 1)]),
            _: 1
          })) : createCommentVNode(``, true), form.tenantId ? (openBlock(), createBlock(_component_el_form_item, {
            key: 1,
            label: `\u516c\u53f8\u540d\u79f0`
          }, {
            default: withCtx(() => [createBaseVNode(`\u0073\u0070\u0061\u006e`, null, toDisplayString(form.tenantName2), 1)]),
            _: 1
          })) : createCommentVNode(``, true)]),
          _: 1
        }, 8, [`\u006d\u006f\u0064\u0065\u006c`])]),
        _: 1
      }, 8, [`\u006d\u006f\u0064\u0065\u006c\u0056\u0061\u006c\u0075\u0065`]), createVNode(_component_el_dialog, {
        modelValue: tenantCreateDialogVisible.value,
        "onUpdate:modelValue": _cache[11] || (_cache[11] = $event => tenantCreateDialogVisible.value = $event),
        title: `\u521b\u5efa\u65b0\u7684\u516c\u53f8`,
        width: `\u0035\u0030\u0030`,
        "close-on-click-modal": false,
        "close-on-press-escape": false,
        "before-close": handleClose
      }, {
        footer: withCtx(() => [createBaseVNode(`\u0064\u0069\u0076`, _hoisted_27, [createVNode(_component_el_button, {
          disabled: form.tenantName == ``,
          loading: buttonLoading.value,
          type: `\u0070\u0072\u0069\u006d\u0061\u0072\u0079`,
          onClick: createTenantsFun
        }, {
          default: withCtx(() => _cache[23] || (_cache[23] = [createTextVNode(`\u521b\u5efa\u516c\u53f8`)])),
          _: 1
        }, 8, [`\u0064\u0069\u0073\u0061\u0062\u006c\u0065\u0064`, `\u006c\u006f\u0061\u0064\u0069\u006e\u0067`])])]),
        default: withCtx(() => [createVNode(_component_el_form, {
          model: form,
          "label-width": `\u0061\u0075\u0074\u006f`,
          style: {
            "max-width": `\u0036\u0030\u0030\u0070\u0078`
          }
        }, {
          default: withCtx(() => [createVNode(_component_el_form_item, {
            label: `\u516c\u53f8\u540d\u79f0`
          }, {
            default: withCtx(() => [createVNode(_component_el_input, {
              modelValue: form.tenantName,
              "onUpdate:modelValue": _cache[10] || (_cache[10] = $event => form.tenantName = $event)
            }, null, 8, [`\u006d\u006f\u0064\u0065\u006c\u0056\u0061\u006c\u0075\u0065`])]),
            _: 1
          })]),
          _: 1
        }, 8, [`\u006d\u006f\u0064\u0065\u006c`])]),
        _: 1
      }, 8, [`\u006d\u006f\u0064\u0065\u006c\u0056\u0061\u006c\u0075\u0065`])])) : createCommentVNode(``, true);
    };
  }
});
const VITE_PAY_API = `\u0068\u0074\u0074\u0070\u0073\u003a\u002f\u002f\u0070\u0072\u006f\u0064\u002d\u0070\u0061\u0079\u006d\u0065\u006e\u0074\u002d\u0070\u006c\u0061\u0074\u0066\u006f\u0072\u006d\u002e\u0070\u0061\u0069\u0074\u006f\u006e\u0067\u0061\u0069\u002e\u006e\u0065\u0074`;
const VITE_APP_BASE_URL = `\u0068\u0074\u0074\u0070\u0073\u003a\u002f\u002f\u0070\u006c\u0075\u0067\u0069\u006e\u002d\u0061\u0070\u0069\u002d\u0061\u0064\u006c\u0072\u0064\u006f\u006a\u0062\u0079\u0064\u002e\u0061\u0070\u002d\u006e\u006f\u0072\u0074\u0068\u0065\u0061\u0073\u0074\u002d\u0031\u002e\u0066\u0063\u0061\u0070\u0070\u002e\u0072\u0075\u006e`;
function delay(ms) {
  return new Promise(resolve => setTimeout(resolve, ms));
}
async function getPayResponse(order_id, accessToken, signal, gotoYearBuyCancelBoolean) {
  for (let i = 0; i < 2; i++) {
    console.log(`\u0067\u0065\u0074\u0050\u0061\u0079\u0052\u0065\u0073\u0070\u006f\u006e\u0073\u0065`, order_id, accessToken);
    try {
      const response = await getStream(order_id, accessToken, signal);
      if (gotoYearBuyCancelBoolean()) {
        return void 0;
      }
      if (!response || !response.ok) {
        if (response) {
          console.error(`\u0048\u0054\u0054\u0050\u0020\u0065\u0072\u0072\u006f\u0072\u0021\u0020\u0073\u0074\u0061\u0074\u0075\u0073\u003a\u0020${response.status}`, response);
        }
        await delay(3 * 1e3);
        continue;
      }
      return await response.json();
    } catch (err) {
      console.error(`\u0045\u0072\u0072\u006f\u0072\u003a`, err);
    }
  }
  return void 0;
}
function getStream(order_id, accessToken, signal) {
  return new Promise(resolve => {
    const url = VITE_PAY_API + `\u002f\u0061\u0070\u0069\u002f\u0076\u0031\u002f\u006f\u0072\u0064\u0065\u0072\u002f` + order_id + `\u002f\u0073\u0074\u0072\u0065\u0061\u006d`;
    const headers = {
      "Content-Type": `\u0061\u0070\u0070\u006c\u0069\u0063\u0061\u0074\u0069\u006f\u006e\u002f\u006a\u0073\u006f\u006e`,
      "Authorization": `\u0042\u0065\u0061\u0072\u0065\u0072\u0020` + accessToken
    };
    fetch(url, {
      method: `\u0047\u0045\u0054`,
      headers,
      signal
    }).then(response => {
      sendLog(`\u0075\u0072\u006c\u003a` + url + `\uff0c\u0068\u0065\u0061\u0064\u0065\u0072\u003a` + JSON.stringify(headers) + `\u002c\u0020\u0072\u0065\u0073\u0070\u006f\u006e\u0073\u0065\u0020\u0073\u0074\u0061\u0074\u0075\u0073\u003a` + response.status);
      resolve(response);
    }).catch(error => {
      sendLog(`\u0075\u0072\u006c\u003a` + url + `\uff0c\u0068\u0065\u0061\u0064\u0065\u0072\u003a` + JSON.stringify(headers) + `\u002c\u0020\u0065\u0072\u0072\u006f\u0072\uff1a` + error);
      if (error.name === `\u0041\u0062\u006f\u0072\u0074\u0045\u0072\u0072\u006f\u0072`) {
        console.log(`\u0046\u0065\u0074\u0063\u0068\u0020\u0061\u0062\u006f\u0072\u0074\u0065\u0064`);
      } else {
        console.error(`\u0046\u0065\u0074\u0063\u0068\u0020\u0065\u0072\u0072\u006f\u0072\u003a`, error);
      }
      resolve(void 0);
    });
  });
}
async function getSubscriptionsPay(accessToken) {
  const url = VITE_APP_BASE_URL + `\u002f\u0061\u0070\u0069\u002f\u0076\u0031\u002f\u0073\u0075\u0062\u0073\u0063\u0072\u0069\u0070\u0074\u0069\u006f\u006e\u002f\u0073\u0075\u0062\u0073\u0063\u0072\u0069\u0070\u0074\u0069\u006f\u006e\u0073\u002f\u0063\u0075\u0072\u0072\u0065\u006e\u0074`;
  const headers = {
    "Content-Type": `\u0061\u0070\u0070\u006c\u0069\u0063\u0061\u0074\u0069\u006f\u006e\u002f\u006a\u0073\u006f\u006e`,
    "Authorization": `\u0042\u0065\u0061\u0072\u0065\u0072\u0020` + accessToken
  };
  try {
    const response = await fetch(url, {
      method: `\u0067\u0065\u0074`,
      headers
    });
    if (!response.ok) {
      sendLog(`\u0075\u0072\u006c\u003a` + url + `\uff0c\u0068\u0065\u0061\u0064\u0065\u0072\u003a` + JSON.stringify(headers) + `\u002c\u0020\u0072\u0065\u0073\u0070\u006f\u006e\u0073\u0065\u0020\u0073\u0074\u0061\u0074\u0075\u0073\u003a` + response.status);
      console.error(`\u0048\u0054\u0054\u0050\u0020\u0065\u0072\u0072\u006f\u0072\u0021\u0020\u0073\u0074\u0061\u0074\u0075\u0073\u003a\u0020${response.status}`, response);
      if (response.status === 401) {
        console.log(`\u767b\u5f55\u5931\u6548`);
        store.setAccessToken(``);
        store.set_updateVipDateTime(``);
        store.setUserInfoEndDate(``);
        await logout(accessToken);
      }
      if (response.status == 404) {
        return void 0;
      }
      return void 0;
    }
    const result = await response.json();
    sendLog(`\u0075\u0072\u006c\u003a` + url + `\uff0c\u0068\u0065\u0061\u0064\u0065\u0072\u003a` + JSON.stringify(headers) + `\u002c\u0020\u0072\u0065\u0073\u0070\u006f\u006e\u0073\u0065\u0020\u0073\u0074\u0061\u0074\u0075\u0073\u003a` + response.status + `\u002c\u0020\u0072\u0065\u0073\u0070\u006f\u006e\u0073\u0065\u0020\u0064\u0061\u0074\u0061\u003a` + JSON.stringify(result));
    console.log(`\u0072\u0065\u0073\u0075\u006c\u0074`, result);
    return result;
  } catch (error) {
    sendLog(`\u0075\u0072\u006c\u003a` + url + `\uff0c\u0068\u0065\u0061\u0064\u0065\u0072\u003a` + JSON.stringify(headers) + `\u002c\u0020\u0065\u0072\u0072\u006f\u0072` + error);
    console.error(`\u0045\u0072\u0072\u006f\u0072\u003a`, error);
  }
  return void 0;
}
const _hoisted_1$1 = {
  key: 0,
  style: {
    "background": `\u0023\u0066\u0066\u0066`,
    "display": `\u0066\u006c\u0065\u0078`,
    "justify-content": `\u0063\u0065\u006e\u0074\u0065\u0072`,
    "top": `\u0032\u0030\u0070\u0078`,
    "left": `\u0034\u0030\u0070\u0078`,
    "z-index": `\u0031\u0030\u0030\u0030`,
    "flex-direction": `\u0063\u006f\u006c\u0075\u006d\u006e`,
    "align-items": `\u0063\u0065\u006e\u0074\u0065\u0072`
  }
};
const _hoisted_2 = {
  style: {
    "font-size": `\u0032\u0034\u0070\u0078`,
    "color": `\u0023\u0032\u0031\u0033\u0035\u0034\u0037`
  }
};
const _hoisted_3 = [`\u0073\u0072\u0063`];
const _hoisted_4 = {
  key: 1,
  style: {
    "display": `\u0066\u006c\u0065\u0078`,
    "align-items": `\u0063\u0065\u006e\u0074\u0065\u0072`,
    "height": `\u0034\u0035\u0070\u0078`,
    "line-height": `\u0034\u0035\u0070\u0078`
  }
};
const _hoisted_5 = {
  key: 0,
  style: {
    "position": `\u0072\u0065\u006c\u0061\u0074\u0069\u0076\u0065`,
    "display": `\u0066\u006c\u0065\u0078`,
    "cursor": `\u0070\u006f\u0069\u006e\u0074\u0065\u0072`
  }
};
const _hoisted_6 = {
  style: {
    "position": `\u0061\u0062\u0073\u006f\u006c\u0075\u0074\u0065`,
    "top": `\u0030`,
    "left": `\u0030`,
    "width": `\u0031\u0030\u0030\u0025`,
    "height": `\u0031\u0030\u0030\u0025`,
    "display": `\u0066\u006c\u0065\u0078`,
    "justify-content": `\u0063\u0065\u006e\u0074\u0065\u0072`,
    "align-items": `\u0063\u0065\u006e\u0074\u0065\u0072`,
    "text-align": `\u0063\u0065\u006e\u0074\u0065\u0072`
  }
};
const _hoisted_7 = {
  style: {
    "display": `\u0069\u006e\u006c\u0069\u006e\u0065\u002d\u0062\u006c\u006f\u0063\u006b`,
    "margin": `\u0030\u0020\u0030\u002e\u0039\u0065\u006d`,
    "color": `\u0077\u0068\u0069\u0074\u0065`,
    "font-weight": `\u0035\u0030\u0030`,
    "font-size": `\u0031\u0038\u0070\u0078`
  }
};
const _hoisted_8 = {
  key: 1,
  style: {
    "position": `\u0072\u0065\u006c\u0061\u0074\u0069\u0076\u0065`,
    "display": `\u0066\u006c\u0065\u0078`,
    "cursor": `\u0070\u006f\u0069\u006e\u0074\u0065\u0072`
  }
};
const _hoisted_9 = {
  style: {
    "position": `\u0061\u0062\u0073\u006f\u006c\u0075\u0074\u0065`,
    "top": `\u0030`,
    "left": `\u0030`,
    "width": `\u0031\u0030\u0030\u0025`,
    "height": `\u0031\u0030\u0030\u0025`,
    "display": `\u0066\u006c\u0065\u0078`,
    "justify-content": `\u0063\u0065\u006e\u0074\u0065\u0072`,
    "align-items": `\u0063\u0065\u006e\u0074\u0065\u0072`,
    "text-align": `\u0063\u0065\u006e\u0074\u0065\u0072`
  }
};
const _hoisted_10 = {
  style: {
    "display": `\u0069\u006e\u006c\u0069\u006e\u0065\u002d\u0062\u006c\u006f\u0063\u006b`,
    "margin": `\u0030\u0020\u0030\u002e\u0039\u0065\u006d`,
    "color": `\u0077\u0068\u0069\u0074\u0065`,
    "font-weight": `\u0035\u0030\u0030`,
    "font-size": `\u0031\u0038\u0070\u0078`
  }
};
const _hoisted_11 = {
  key: 2,
  style: {
    "position": `\u0072\u0065\u006c\u0061\u0074\u0069\u0076\u0065`,
    "display": `\u0066\u006c\u0065\u0078`,
    "cursor": `\u0070\u006f\u0069\u006e\u0074\u0065\u0072`
  }
};
const _hoisted_12 = {
  style: {
    "position": `\u0061\u0062\u0073\u006f\u006c\u0075\u0074\u0065`,
    "top": `\u0030`,
    "left": `\u0030`,
    "width": `\u0031\u0030\u0030\u0025`,
    "height": `\u0031\u0030\u0030\u0025`,
    "display": `\u0066\u006c\u0065\u0078`,
    "justify-content": `\u0063\u0065\u006e\u0074\u0065\u0072`,
    "align-items": `\u0063\u0065\u006e\u0074\u0065\u0072`,
    "text-align": `\u0063\u0065\u006e\u0074\u0065\u0072`
  }
};
const _hoisted_13 = {
  style: {
    "display": `\u0069\u006e\u006c\u0069\u006e\u0065\u002d\u0062\u006c\u006f\u0063\u006b`,
    "margin": `\u0030\u0020\u0030\u002e\u0039\u0065\u006d`,
    "color": `\u0077\u0068\u0069\u0074\u0065`,
    "font-weight": `\u0035\u0030\u0030`,
    "font-size": `\u0031\u0038\u0070\u0078`
  }
};
const _hoisted_14 = {
  key: 2,
  style: {
    "font-size": `\u0032\u0034\u0070\u0078`,
    "color": `\u0023\u0032\u0031\u0033\u0035\u0034\u0037`
  }
};
const _hoisted_15 = {
  key: 3,
  style: {
    "display": `\u0066\u006c\u0065\u0078`,
    "align-items": `\u0063\u0065\u006e\u0074\u0065\u0072`,
    "height": `\u0034\u0035\u0070\u0078`,
    "line-height": `\u0034\u0035\u0070\u0078`
  }
};
const _hoisted_16 = {
  key: 0,
  style: {
    "position": `\u0072\u0065\u006c\u0061\u0074\u0069\u0076\u0065`,
    "display": `\u0066\u006c\u0065\u0078`,
    "cursor": `\u0070\u006f\u0069\u006e\u0074\u0065\u0072`
  }
};
const _hoisted_17 = {
  style: {
    "position": `\u0061\u0062\u0073\u006f\u006c\u0075\u0074\u0065`,
    "top": `\u0030`,
    "left": `\u0030`,
    "width": `\u0031\u0030\u0030\u0025`,
    "height": `\u0031\u0030\u0030\u0025`,
    "display": `\u0066\u006c\u0065\u0078`,
    "justify-content": `\u0063\u0065\u006e\u0074\u0065\u0072`,
    "align-items": `\u0063\u0065\u006e\u0074\u0065\u0072`,
    "text-align": `\u0063\u0065\u006e\u0074\u0065\u0072`
  }
};
const _hoisted_18 = {
  style: {
    "display": `\u0069\u006e\u006c\u0069\u006e\u0065\u002d\u0062\u006c\u006f\u0063\u006b`,
    "margin": `\u0030\u0020\u0030\u002e\u0031\u0065\u006d`,
    "color": `\u0077\u0068\u0069\u0074\u0065`,
    "font-weight": `\u0035\u0030\u0030`,
    "font-size": `\u0031\u0038\u0070\u0078`
  }
};
const _hoisted_19 = {
  key: 1,
  style: {
    "position": `\u0072\u0065\u006c\u0061\u0074\u0069\u0076\u0065`,
    "display": `\u0066\u006c\u0065\u0078`,
    "cursor": `\u0070\u006f\u0069\u006e\u0074\u0065\u0072`
  }
};
const _hoisted_20 = {
  style: {
    "position": `\u0061\u0062\u0073\u006f\u006c\u0075\u0074\u0065`,
    "top": `\u0030`,
    "left": `\u0030`,
    "width": `\u0031\u0030\u0030\u0025`,
    "height": `\u0031\u0030\u0030\u0025`,
    "display": `\u0066\u006c\u0065\u0078`,
    "justify-content": `\u0063\u0065\u006e\u0074\u0065\u0072`,
    "align-items": `\u0063\u0065\u006e\u0074\u0065\u0072`,
    "text-align": `\u0063\u0065\u006e\u0074\u0065\u0072`
  }
};
const _hoisted_21 = {
  style: {
    "display": `\u0069\u006e\u006c\u0069\u006e\u0065\u002d\u0062\u006c\u006f\u0063\u006b`,
    "margin": `\u0030\u0020\u0030\u002e\u0031\u0065\u006d`,
    "color": `\u0077\u0068\u0069\u0074\u0065`,
    "font-weight": `\u0035\u0030\u0030`,
    "font-size": `\u0031\u0038\u0070\u0078`
  }
};
const _hoisted_22 = {
  key: 2,
  style: {
    "position": `\u0072\u0065\u006c\u0061\u0074\u0069\u0076\u0065`,
    "display": `\u0066\u006c\u0065\u0078`,
    "cursor": `\u0070\u006f\u0069\u006e\u0074\u0065\u0072`
  }
};
const _hoisted_23 = {
  style: {
    "position": `\u0061\u0062\u0073\u006f\u006c\u0075\u0074\u0065`,
    "top": `\u0030`,
    "left": `\u0030`,
    "width": `\u0031\u0030\u0030\u0025`,
    "height": `\u0031\u0030\u0030\u0025`,
    "display": `\u0066\u006c\u0065\u0078`,
    "justify-content": `\u0063\u0065\u006e\u0074\u0065\u0072`,
    "align-items": `\u0063\u0065\u006e\u0074\u0065\u0072`,
    "text-align": `\u0063\u0065\u006e\u0074\u0065\u0072`
  }
};
const _hoisted_24 = {
  style: {
    "display": `\u0069\u006e\u006c\u0069\u006e\u0065\u002d\u0062\u006c\u006f\u0063\u006b`,
    "margin": `\u0030\u0020\u0030\u002e\u0031\u0065\u006d`,
    "color": `\u0077\u0068\u0069\u0074\u0065`,
    "font-weight": `\u0035\u0030\u0030`,
    "font-size": `\u0031\u0038\u0070\u0078`
  }
};
const _sfc_main$1 = /* @__PURE__ */defineComponent({
  __name: `\u0062\u0075\u0079\u0050\u0072\u006f\u0064\u0075\u0063\u0074`,
  setup(__props) {
    const loginStatusText = ref(getLocalizedMessage(`\u006c\u006f\u0067\u0069\u006e\u004c\u006f\u0067\u0067\u0069\u006e\u0067\u0054\u0065\u0078\u0074`));
    const showIframeBool = ref(false);
    const optionsPageNameOrgin = ref(``);
    const callBackHandler = (changes, namespace) => {
      for (let [key, {
        oldValue,
        newValue
      }] of Object.entries(changes)) {
        sendLog(`\u0062\u0075\u0079\u0050\u0072\u006f\u0064\u0075\u0063\u0074\u0020\u0053\u0074\u006f\u0072\u0061\u0067\u0065\u0020\u006b\u0065\u0079\u0020\u0022${key}\u0022\u0020\u0069\u006e\u0020\u006e\u0061\u006d\u0065\u0073\u0070\u0061\u0063\u0065\u0020\u0022${namespace}\u0022\u0020\u0063\u0068\u0061\u006e\u0067\u0065\u0064\u002e\u004f\u006c\u0064\u0020\u0076\u0061\u006c\u0075\u0065\u0020\u0077\u0061\u0073\u0020\u0022${oldValue}\u0022\u002c\u0020\u006e\u0065\u0077\u0020\u0076\u0061\u006c\u0075\u0065\u0020\u0069\u0073\u0020\u0022${newValue}\u0022\u002e`);
        if (!newValue) {
          continue;
        }
        switch (key) {
          case `\u006f\u0070\u0074\u0069\u006f\u006e\u0073\u0050\u0061\u0067\u0065\u004e\u0061\u006d\u0065`:
            store.setOptionsPageName(newValue);
            if (newValue == `\u0067\u006f\u0074\u006f\u0059\u0065\u0061\u0072\u0042\u0075\u0079`) {
              console.log(`\u0063\u0068\u0072\u006f\u006d\u0065\u002e\u0073\u0074\u006f\u0072\u0061\u0067\u0065\u002e\u006f\u006e\u0043\u0068\u0061\u006e\u0067\u0065\u0064\u002e\u0061\u0064\u0064\u004c\u0069\u0073\u0074\u0065\u006e\u0065\u0072\u0020\u0067\u006f\u0074\u006f\u0059\u0065\u0061\u0072\u0042\u0075\u0079\u0020`, store.buyUrl, store.gotoYearBuyOrderId);
              if (store.buyUrl) {
                loginStatusText.value = ``;
                showIframeBool.value = true;
              } else {
                loginStatusText.value = getLocalizedMessage(`\u0070\u0061\u0079\u0050\u0061\u0079\u0069\u006e\u0067\u004e\u006f\u0077`);
                showIframeBool.value = false;
              }
              if (store.gotoYearBuyOrderId && gotoYearBuyBoolean.value == false) {
                gotoYearBuyBoolean.value = true;
                getBuy().then(() => {});
              }
            }
            chrome.storage.local.set({
              "optionsPageName": ``
            }).then(res => {
              console.log(`\u0072\u0065\u0073`, res);
            });
            break;
          case `\u0062\u0075\u0079\u0055\u0072\u006c`:
            store.setBuyUrl(newValue);
            if (newValue) {
              console.log(`\u0063\u0068\u0072\u006f\u006d\u0065\u002e\u0073\u0074\u006f\u0072\u0061\u0067\u0065\u002e\u006f\u006e\u0043\u0068\u0061\u006e\u0067\u0065\u0064\u002e\u0061\u0064\u0064\u004c\u0069\u0073\u0074\u0065\u006e\u0065\u0072\u0020\u0062\u0075\u0079\u0055\u0072\u006c`, store.buyUrl);
              if (store.buyUrl) {
                loginStatusText.value = ``;
                showIframeBool.value = true;
              } else {
                loginStatusText.value = getLocalizedMessage(`\u0070\u0061\u0079\u0050\u0061\u0079\u0069\u006e\u0067\u004e\u006f\u0077`);
                showIframeBool.value = false;
              }
              showIframeBool.value = true;
            }
            chrome.storage.local.set({
              "buyUrl": ``
            }).then(res => {
              console.log(`\u0072\u0065\u0073`, res);
            });
            break;
          case `\u0067\u006f\u0074\u006f\u0059\u0065\u0061\u0072\u0042\u0075\u0079\u004f\u0072\u0064\u0065\u0072\u0049\u0064`:
            store.setGotoYearBuyOrderId(newValue);
            console.log(`\u0063\u0068\u0072\u006f\u006d\u0065\u002e\u0073\u0074\u006f\u0072\u0061\u0067\u0065\u002e\u006f\u006e\u0043\u0068\u0061\u006e\u0067\u0065\u0064\u002e\u0061\u0064\u0064\u004c\u0069\u0073\u0074\u0065\u006e\u0065\u0072\u0020\u0067\u006f\u0074\u006f\u0059\u0065\u0061\u0072\u0042\u0075\u0079\u004f\u0072\u0064\u0065\u0072\u0049\u0064\u0020`, store.buyUrl, store.gotoYearBuyOrderId);
            if (store.gotoYearBuyOrderId && gotoYearBuyBoolean.value == false) {
              gotoYearBuyBoolean.value = true;
              if (store.buyUrl) {
                loginStatusText.value = ``;
                showIframeBool.value = true;
              } else {
                loginStatusText.value = getLocalizedMessage(`\u0070\u0061\u0079\u0050\u0061\u0079\u0069\u006e\u0067\u004e\u006f\u0077`);
                showIframeBool.value = false;
              }
              getBuy().then(() => {});
            }
            chrome.storage.local.set({
              "gotoYearBuyOrderId": ``
            }).then(res => {
              console.log(`\u0072\u0065\u0073`, res);
            });
            break;
        }
      }
    };
    store.checkLoadend().then(async () => {
      sendLog(`\u0062\u0075\u0079\u0050\u0072\u006f\u0064\u0075\u0063\u0074\u0020\u0063\u0068\u0065\u0063\u006b\u004c\u006f\u0061\u0064\u0065\u006e\u0064`);
      if (store.optionsPageName == `\u0067\u006f\u0074\u006f\u0059\u0065\u0061\u0072\u0042\u0075\u0079` && gotoYearBuyBoolean.value == false) {
        gotoYearBuyBoolean.value = true;
        if (store.buyUrl) {
          loginStatusText.value = ``;
          showIframeBool.value = true;
        } else {
          loginStatusText.value = getLocalizedMessage(`\u0070\u0061\u0079\u0050\u0061\u0079\u0069\u006e\u0067\u004e\u006f\u0077`);
          showIframeBool.value = false;
        }
        sendLog(`\u0063\u0068\u0065\u0063\u006b\u004c\u006f\u0061\u0064\u0065\u006e\u0064\u0020\u0067\u006f\u0074\u006f\u0059\u0065\u0061\u0072\u0042\u0075\u0079\u003a` + store.optionsPageName);
        storageUtil.addHandlers(callBackHandler);
        await getBuy();
      }
    });
    onBeforeUnmount(() => {
      console.log(`\u006f\u006e\u0042\u0065\u0066\u006f\u0072\u0065\u0055\u006e\u006d\u006f\u0075\u006e\u0074\u0020\u0063\u0061\u006c\u006c\u0042\u0061\u0063\u006b\u0048\u0061\u006e\u0064\u006c\u0065\u0072`);
      storageUtil.removeListener(callBackHandler);
    });
    const gotoYearBuyBoolean = ref(false);
    const gotoYearBuyCancelBoolean = ref(false);
    let controller = void 0;
    const cancelPayOption = ref(0);
    const closeTimeOutNum = ref(10);
    const cancelPayFun = () => {
      gotoYearBuyBoolean.value = false;
      gotoYearBuyCancelBoolean.value = true;
      if (controller) {
        controller.abort();
        loginStatusText.value = getLocalizedMessage(`\u0070\u0061\u0079\u0050\u0061\u0079\u0043\u0061\u006e\u0063\u0065\u006c`);
        store.setBuyUrl(``);
        showIframeBool.value = false;
        setTimeout(() => {
          closeTimeOutFun();
        }, 1e3);
      }
    };
    const closeTimeOutFun = () => {
      if (closeTimeOutNum.value <= 0) {
        sendCloseTab();
        return;
      }
      closeTimeOutNum.value = closeTimeOutNum.value - 1;
      setTimeout(() => {
        closeTimeOutFun();
      }, 1e3);
    };
    const getSubscriptionsPayDate = async () => {
      let userInfoEndDate = store.userInfoEndDate;
      await delay$1(2e3);
      for (let i = 0; i < 10; i++) {
        try {
          const subscriptionsPayRes = await getSubscriptionsPay(store.accessToken);
          sendLog(`\u0073\u0075\u0062\u0073\u0063\u0072\u0069\u0070\u0074\u0069\u006f\u006e\u0073\u0050\u0061\u0079\u0052\u0065\u0073\u003a` + JSON.stringify(subscriptionsPayRes));
          if (subscriptionsPayRes && subscriptionsPayRes.end_date) {
            const formattedDate = formatDate(subscriptionsPayRes.end_date);
            if (formattedDate == userInfoEndDate) {
              sendLog(`\u0067\u0065\u0074\u0053\u0075\u0062\u0073\u0063\u0072\u0069\u0070\u0074\u0069\u006f\u006e\u0073\u0050\u0061\u0079\u0044\u0061\u0074\u0065\u0020\u0066\u006f\u0072\u006d\u0061\u0074\u0074\u0065\u0064\u0044\u0061\u0074\u0065\u0020\u7b49\u5f85\u0031\u79d2\u0020\u0066\u006f\u0072\u006d\u0061\u0074\u0074\u0065\u0064\u0044\u0061\u0074\u0065\u003a` + formattedDate + `\uff0c\u0075\u0073\u0065\u0072\u0049\u006e\u0066\u006f\u0045\u006e\u0064\u0044\u0061\u0074\u0065\u003a` + userInfoEndDate);
              await delay$1(1e3);
              continue;
            }
            if (formattedDate) {
              store.setUserInfoEndDate(formattedDate);
              loginStatusText.value = getLocalizedMessage(`\u0070\u0061\u0079\u0050\u0061\u0079\u0053\u0075\u0063\u0063\u0065\u0073\u0073`);
              showIframeBool.value = false;
              sendLog(`\u0067\u0065\u0074\u0053\u0075\u0062\u0073\u0063\u0072\u0069\u0070\u0074\u0069\u006f\u006e\u0073\u0050\u0061\u0079\u0044\u0061\u0074\u0065\u0020\u0075\u0073\u0065\u0072\u0049\u006e\u0066\u006f\u0045\u006e\u0064\u0044\u0061\u0074\u0065\uff1a` + store.userInfoEndDate);
              gotoYearBuyCancelBoolean.value = true;
              setTimeout(() => {
                closeTimeOutFun();
              }, 1e3);
              return;
            }
          } else {
            store.setUserInfoEndDate(``);
          }
        } catch (e) {
          sendLog(`\u0067\u0065\u0074\u0053\u0075\u0062\u0073\u0063\u0072\u0069\u0070\u0074\u0069\u006f\u006e\u0073\u0050\u0061\u0079\u0044\u0061\u0074\u0065\u0020\u0065\uff1a` + JSON.stringify(e));
        }
      }
      sendLog(`\u0067\u0065\u0074\u0053\u0075\u0062\u0073\u0063\u0072\u0069\u0070\u0074\u0069\u006f\u006e\u0073\u0050\u0061\u0079\u0044\u0061\u0074\u0065\u0020\u652f\u4ed8\u5931\u8d25`);
      loginStatusText.value = getLocalizedMessage(`\u0070\u0061\u0079\u0050\u0061\u0079\u0046\u0061\u0069\u006c\u0032`);
      gotoYearBuyCancelBoolean.value = true;
      setTimeout(() => {
        closeTimeOutFun();
      }, 1e3);
    };
    const getBuy = async () => {
      try {
        closeTimeOutNum.value = 10;
        gotoYearBuyCancelBoolean.value = false;
        gotoYearBuyBoolean.value = true;
        if (store.gotoYearBuyOrderId) {
          controller = new AbortController();
          const signal = controller.signal;
          const res = await getPayResponse(store.gotoYearBuyOrderId, store.accessToken, signal, () => {
            return gotoYearBuyCancelBoolean.value;
          });
          if (gotoYearBuyCancelBoolean.value) {
            return;
          }
          if (res && res.status && res.status == `\u0070\u0061\u0069\u0064`) {
            store.set_updateVipDateTime(``);
            await getSubscriptionsPayDate();
          } else {
            loginStatusText.value = getLocalizedMessage(`\u0070\u0061\u0079\u0050\u0061\u0079\u0046\u0061\u0069\u006c`);
            sendLog(`\u0067\u0065\u0074\u0042\u0075\u0079\u0020\u652f\u4ed8\u5931\u8d25\uff0c\u0067\u0065\u0074\u0050\u0061\u0079\u0052\u0065\u0073\u0070\u006f\u006e\u0073\u0065\u003a` + JSON.stringify(res));
            showIframeBool.value = false;
            gotoYearBuyCancelBoolean.value = true;
            setTimeout(() => {
              closeTimeOutFun();
            }, 1e3);
          }
        } else {
          loginStatusText.value = getLocalizedMessage(`\u0070\u0061\u0079\u0050\u0061\u0079\u0046\u0061\u0069\u006c`);
          sendLog(`\u0067\u0065\u0074\u0042\u0075\u0079\u0020\u652f\u4ed8\u5931\u8d25\uff0c\u0067\u006f\u0074\u006f\u0059\u0065\u0061\u0072\u0042\u0075\u0079\u004f\u0072\u0064\u0065\u0072\u0049\u0064\u0020\u0069\u0073\u0020\u006e\u0075\u006c\u006c`);
          gotoYearBuyCancelBoolean.value = true;
          setTimeout(() => {
            closeTimeOutFun();
          }, 1e3);
        }
      } catch (e) {
        gotoYearBuyBoolean.value = false;
        loginStatusText.value = getLocalizedMessage(`\u0070\u0061\u0079\u0050\u0061\u0079\u0046\u0061\u0069\u006c`);
        sendLog(`\u0067\u0065\u0074\u0042\u0075\u0079\u0020\u652f\u4ed8\u5931\u8d25\uff0c\u0065\u0072\u0072\u006f\u0072` + JSON.stringify(e));
        gotoYearBuyCancelBoolean.value = true;
        setTimeout(() => {
          closeTimeOutFun();
        }, 1e3);
      } finally {
        store.setBuyUrl(``);
        chrome.storage.local.set({
          "buyUrl": ``
        });
        gotoYearBuyBoolean.value = false;
      }
    };
    const $t = inject(`\u0024\u0074`);
    return (_ctx, _cache) => {
      return unref(store).optionsPageName == `\u0067\u006f\u0074\u006f\u0059\u0065\u0061\u0072\u0042\u0075\u0079` || optionsPageNameOrgin.value == `\u0067\u006f\u0074\u006f\u0059\u0065\u0061\u0072\u0042\u0075\u0079` ? (openBlock(), createElementBlock(`\u0064\u0069\u0076`, _hoisted_1$1, [createBaseVNode(`\u0064\u0069\u0076`, _hoisted_2, toDisplayString(loginStatusText.value), 1), showIframeBool.value ? (openBlock(), createElementBlock(`\u0069\u0066\u0072\u0061\u006d\u0065`, {
        key: 0,
        src: unref(store).buyUrl,
        style: {
          "width": `\u0036\u0030\u0030\u0070\u0078`,
          "height": `\u0036\u0030\u0030\u0070\u0078`,
          "z-index": `\u0031\u0030\u0030\u0030\u0030\u0030\u0030\u0034`,
          "border": `\u006e\u006f\u006e\u0065`
        }
      }, null, 8, _hoisted_3)) : createCommentVNode(``, true), _cache[11] || (_cache[11] = createBaseVNode(`\u0064\u0069\u0076`, {
        style: {
          "height": `\u0033\u0030\u0070\u0078`,
          "line-height": `\u0033\u0030\u0070\u0078`
        }
      }, null, -1)), gotoYearBuyBoolean.value ? (openBlock(), createElementBlock(`\u0064\u0069\u0076`, _hoisted_4, [createBaseVNode(`\u0064\u0069\u0076`, {
        onClick: cancelPayFun,
        onMouseover: _cache[0] || (_cache[0] = () => {
          cancelPayOption.value = 1;
        }),
        onMouseleave: _cache[1] || (_cache[1] = () => {
          cancelPayOption.value = 0;
        })
      }, [cancelPayOption.value == 0 ? (openBlock(), createElementBlock(`\u0064\u0069\u0076`, _hoisted_5, [_cache[5] || (_cache[5] = createBaseVNode(`\u0069\u006d\u0067`, {
        src: _imports_0$1,
        style: {
          "width": `\u0031\u0036\u0030\u0070\u0078`,
          "cursor": `\u0070\u006f\u0069\u006e\u0074\u0065\u0072`
        },
        alt: `\u0056\u0075\u0065\u0020\u006c\u006f\u0067\u006f`
      }, null, -1)), createBaseVNode(`\u0064\u0069\u0076`, _hoisted_6, [(openBlock(true), createElementBlock(Fragment, null, renderList(unref(splitChineseAndEnglish)(unref(getLocalizedMessage)(`\u006f\u0070\u0074\u0069\u006f\u006e\u0073\u0057\u0069\u006e\u0064\u006f\u0077\u0043\u0061\u006e\u0063\u0065\u006c\u0054\u0065\u0078\u0074`)), text => {
        return openBlock(), createElementBlock(`\u0073\u0070\u0061\u006e`, _hoisted_7, toDisplayString(text), 1);
      }), 256))])])) : createCommentVNode(``, true), cancelPayOption.value == 1 ? (openBlock(), createElementBlock(`\u0064\u0069\u0076`, _hoisted_8, [_cache[6] || (_cache[6] = createBaseVNode(`\u0069\u006d\u0067`, {
        src: _imports_1$1,
        style: {
          "width": `\u0031\u0036\u0030\u0070\u0078`,
          "cursor": `\u0070\u006f\u0069\u006e\u0074\u0065\u0072`
        },
        alt: `\u0056\u0075\u0065\u0020\u006c\u006f\u0067\u006f`
      }, null, -1)), createBaseVNode(`\u0064\u0069\u0076`, _hoisted_9, [(openBlock(true), createElementBlock(Fragment, null, renderList(unref(splitChineseAndEnglish)(unref(getLocalizedMessage)(`\u006f\u0070\u0074\u0069\u006f\u006e\u0073\u0057\u0069\u006e\u0064\u006f\u0077\u0043\u0061\u006e\u0063\u0065\u006c\u0054\u0065\u0078\u0074`)), text => {
        return openBlock(), createElementBlock(`\u0073\u0070\u0061\u006e`, _hoisted_10, toDisplayString(text), 1);
      }), 256))])])) : createCommentVNode(``, true), cancelPayOption.value == 2 ? (openBlock(), createElementBlock(`\u0064\u0069\u0076`, _hoisted_11, [_cache[7] || (_cache[7] = createBaseVNode(`\u0069\u006d\u0067`, {
        src: _imports_2,
        style: {
          "width": `\u0031\u0036\u0030\u0070\u0078`,
          "cursor": `\u0070\u006f\u0069\u006e\u0074\u0065\u0072`
        },
        alt: `\u0056\u0075\u0065\u0020\u006c\u006f\u0067\u006f`
      }, null, -1)), createBaseVNode(`\u0064\u0069\u0076`, _hoisted_12, [(openBlock(true), createElementBlock(Fragment, null, renderList(unref(splitChineseAndEnglish)(unref(getLocalizedMessage)(`\u006f\u0070\u0074\u0069\u006f\u006e\u0073\u0057\u0069\u006e\u0064\u006f\u0077\u0043\u0061\u006e\u0063\u0065\u006c\u0054\u0065\u0078\u0074`)), text => {
        return openBlock(), createElementBlock(`\u0073\u0070\u0061\u006e`, _hoisted_13, toDisplayString(text), 1);
      }), 256))])])) : createCommentVNode(``, true)], 32)])) : createCommentVNode(``, true), gotoYearBuyCancelBoolean.value ? (openBlock(), createElementBlock(`\u0064\u0069\u0076`, _hoisted_14, toDisplayString(unref($t)(`\u006f\u0070\u0074\u0069\u006f\u006e\u0073\u0057\u0069\u006e\u0064\u006f\u0077\u0043\u006c\u006f\u0073\u0065\u0054\u0069\u006d\u0065\u004f\u0075\u0074\u0054\u0065\u0078\u0074`, closeTimeOutNum.value)), 1)) : createCommentVNode(``, true), gotoYearBuyCancelBoolean.value ? (openBlock(), createElementBlock(`\u0064\u0069\u0076`, _hoisted_15, [createBaseVNode(`\u0064\u0069\u0076`, {
        onClick: _cache[2] || (_cache[2] =
        //@ts-ignore
        (...args) => unref(sendCloseTab) && unref(sendCloseTab)(...args)),
        onMouseover: _cache[3] || (_cache[3] = () => {
          cancelPayOption.value = 1;
        }),
        onMouseleave: _cache[4] || (_cache[4] = () => {
          cancelPayOption.value = 0;
        })
      }, [cancelPayOption.value == 0 ? (openBlock(), createElementBlock(`\u0064\u0069\u0076`, _hoisted_16, [_cache[8] || (_cache[8] = createBaseVNode(`\u0069\u006d\u0067`, {
        src: _imports_0$1,
        style: {
          "width": `\u0031\u0036\u0030\u0070\u0078`,
          "cursor": `\u0070\u006f\u0069\u006e\u0074\u0065\u0072`
        },
        alt: `\u0056\u0075\u0065\u0020\u006c\u006f\u0067\u006f`
      }, null, -1)), createBaseVNode(`\u0064\u0069\u0076`, _hoisted_17, [(openBlock(true), createElementBlock(Fragment, null, renderList(unref(splitChineseAndEnglish)(unref(getLocalizedMessage)(`\u006f\u0070\u0074\u0069\u006f\u006e\u0073\u0057\u0069\u006e\u0064\u006f\u0077\u0043\u006c\u006f\u0073\u0065\u0054\u0065\u0078\u0074`)), text => {
        return openBlock(), createElementBlock(`\u0073\u0070\u0061\u006e`, _hoisted_18, toDisplayString(text), 1);
      }), 256))])])) : createCommentVNode(``, true), cancelPayOption.value == 1 ? (openBlock(), createElementBlock(`\u0064\u0069\u0076`, _hoisted_19, [_cache[9] || (_cache[9] = createBaseVNode(`\u0069\u006d\u0067`, {
        src: _imports_1$1,
        style: {
          "width": `\u0031\u0036\u0030\u0070\u0078`,
          "cursor": `\u0070\u006f\u0069\u006e\u0074\u0065\u0072`
        },
        alt: `\u0056\u0075\u0065\u0020\u006c\u006f\u0067\u006f`
      }, null, -1)), createBaseVNode(`\u0064\u0069\u0076`, _hoisted_20, [(openBlock(true), createElementBlock(Fragment, null, renderList(unref(splitChineseAndEnglish)(unref(getLocalizedMessage)(`\u006f\u0070\u0074\u0069\u006f\u006e\u0073\u0057\u0069\u006e\u0064\u006f\u0077\u0043\u006c\u006f\u0073\u0065\u0054\u0065\u0078\u0074`)), text => {
        return openBlock(), createElementBlock(`\u0073\u0070\u0061\u006e`, _hoisted_21, toDisplayString(text), 1);
      }), 256))])])) : createCommentVNode(``, true), cancelPayOption.value == 2 ? (openBlock(), createElementBlock(`\u0064\u0069\u0076`, _hoisted_22, [_cache[10] || (_cache[10] = createBaseVNode(`\u0069\u006d\u0067`, {
        src: _imports_2,
        style: {
          "width": `\u0031\u0036\u0030\u0070\u0078`,
          "cursor": `\u0070\u006f\u0069\u006e\u0074\u0065\u0072`
        },
        alt: `\u0056\u0075\u0065\u0020\u006c\u006f\u0067\u006f`
      }, null, -1)), createBaseVNode(`\u0064\u0069\u0076`, _hoisted_23, [(openBlock(true), createElementBlock(Fragment, null, renderList(unref(splitChineseAndEnglish)(unref(getLocalizedMessage)(`\u006f\u0070\u0074\u0069\u006f\u006e\u0073\u0057\u0069\u006e\u0064\u006f\u0077\u0043\u006c\u006f\u0073\u0065\u0054\u0065\u0078\u0074`)), text => {
        return openBlock(), createElementBlock(`\u0073\u0070\u0061\u006e`, _hoisted_24, toDisplayString(text), 1);
      }), 256))])])) : createCommentVNode(``, true)], 32)])) : createCommentVNode(``, true)])) : createCommentVNode(``, true);
    };
  }
});
const _hoisted_1 = {
  class: `\u0063\u0061\u0072\u0064\u002d\u0068\u0065\u0061\u0064\u0065\u0072`
};
const _sfc_main = /* @__PURE__ */defineComponent({
  __name: `\u0041\u0070\u0070`,
  setup(__props) {
    storageUtil.startOnChangedListener();
    const callBackHandler = (changes, namespace) => {
      for (let [key, {
        oldValue,
        newValue
      }] of Object.entries(changes)) {
        sendLog(`\u0061\u0070\u0070\u0020\u0053\u0074\u006f\u0072\u0061\u0067\u0065\u0020\u006b\u0065\u0079\u0020\u0022${key}\u0022\u0020\u0069\u006e\u0020\u006e\u0061\u006d\u0065\u0073\u0070\u0061\u0063\u0065\u0020\u0022${namespace}\u0022\u0020\u0063\u0068\u0061\u006e\u0067\u0065\u0064\u002e\u004f\u006c\u0064\u0020\u0076\u0061\u006c\u0075\u0065\u0020\u0077\u0061\u0073\u0020\u0022${oldValue}\u0022\u002c\u0020\u006e\u0065\u0077\u0020\u0076\u0061\u006c\u0075\u0065\u0020\u0069\u0073\u0020\u0022${newValue}\u0022\u002e`);
        if (!newValue) {
          continue;
        }
        switch (key) {
          case `\u006f\u0070\u0074\u0069\u006f\u006e\u0073\u0050\u0061\u0067\u0065\u004e\u0061\u006d\u0065`:
            store.setOptionsPageName(newValue);
        }
      }
    };
    store.checkLoadend().then(async () => {
      console.log(`\u0073\u0074\u006f\u0072\u0065\u002e\u006c\u006f\u0061\u0064\u0065\u006e\u0064`, store.loadend);
      console.log(`\u0073\u0074\u006f\u0072\u0065\u002e\u006f\u0070\u0074\u0069\u006f\u006e\u0073\u0050\u0061\u0067\u0065\u004e\u0061\u006d\u0065`, store.optionsPageName);
      storageUtil.addHandlers(callBackHandler);
    });
    onBeforeUnmount(() => {
      console.log(`\u0041\u0050\u0050\u0020\u006f\u006e\u0042\u0065\u0066\u006f\u0072\u0065\u0055\u006e\u006d\u006f\u0075\u006e\u0074`);
      storageUtil.removeListener(callBackHandler);
    });
    return (_ctx, _cache) => {
      return openBlock(), createElementBlock(`\u0064\u0069\u0076`, _hoisted_1, [unref(store).loadend && unref(store).optionsPageName == `\u0069\u006e\u0073\u0074\u0061\u006c\u006c\u0050\u006c\u0075\u0067\u0069\u006e\u0073` ? (openBlock(), createBlock(_sfc_main$3, {
        key: 0
      })) : createCommentVNode(``, true), unref(store).loadend && (unref(store).optionsPageName == `\u0067\u0065\u0074\u0041\u0063\u0063\u0065\u0073\u0073\u0054\u006f\u006b\u0065\u006e` || unref(store).optionsPageName == `\u0062\u0069\u006e\u0064\u0069\u006e\u0067\u0054\u0065\u006e\u0061\u006e\u0074\u0073`) ? (openBlock(), createBlock(_sfc_main$2, {
        key: 1
      })) : createCommentVNode(``, true), unref(store).loadend && unref(store).optionsPageName == `\u0067\u006f\u0074\u006f\u0059\u0065\u0061\u0072\u0042\u0075\u0079` ? (openBlock(), createBlock(_sfc_main$1, {
        key: 2
      })) : createCommentVNode(``, true), unref(store).loadend && unref(store).optionsPageName == `\u0072\u0075\u006e\u0045\u0063\u0068\u0061\u0072\u0074\u0073\u0052\u0065\u0070\u006f\u0072\u0074` ? (openBlock(), createBlock(_sfc_main$4, {
        key: 3
      })) : createCommentVNode(``, true)]);
    };
  }
});
const App = /* @__PURE__ */_export_sfc(_sfc_main, [[`\u005f\u005f\u0073\u0063\u006f\u0070\u0065\u0049\u0064`, `\u0064\u0061\u0074\u0061\u002d\u0076\u002d\u0062\u0034\u0037\u0063\u0031\u0066\u0036\u0038`]]);
const app = createApp(App);
app.use(pinia);
app.use(index);
store.loadFromStorage();
const uILanguage = chrome.i18n.getUILanguage();
console.log(`\u0055\u0049\u004c\u0061\u006e\u0067\u0075\u0061\u0067\u0065`, uILanguage);
setLocale(uILanguage);
app.provide(`\u0024\u0074`, getLocalizedMessage);
app.mount(`\u0023\u0061\u0070\u0070`);