var __defProp = Object.defineProperty;
var __defNormalProp = (obj, key, value) => key in obj ? __defProp(obj, key, {
  enumerable: true,
  configurable: true,
  writable: true,
  value
}) : obj[key] = value;
var __publicField = (obj, key, value) => __defNormalProp(obj, typeof key !== `\u0073\u0079\u006d\u0062\u006f\u006c` ? key + `` : key, value);
import { i as indexPage, r as runPages } from "./js-indexConfig.js";
import { m as mqtt } from "./js-mqtt.js";
const store_console = {
  isDebugMode: true
};
store_console.isDebugMode = true;
if (!store_console.isDebugMode) {
  const originalConsoleLog = console.log;
  console.log = (...args) => {
    if (store_console.isDebugMode) {
      originalConsoleLog(...args);
    }
  };
}
if (!store_console.isDebugMode) {
  const originalConsoleError = console.error;
  console.error = (...args) => {
    if (store_console.isDebugMode) {
      originalConsoleError(...args);
    }
  };
}
if (!store_console.isDebugMode) {
  const originalConsoleInfo = console.info;
  console.info = (...args) => {
    if (store_console.isDebugMode) {
      originalConsoleInfo(...args);
    }
  };
}
const _StorageUtil = class _StorageUtil {
  constructor() {
    __publicField(this, `\u006f\u006e\u0043\u0061\u006c\u006c\u0042\u0061\u0063\u006b\u0048\u0061\u006e\u0064\u006c\u0065\u0072\u0073`);
    this.onCallBackHandlers = [];
  }
  // 获取唯一实例的方法
  static getInstance() {
    if (!_StorageUtil.instance) {
      _StorageUtil.instance = new _StorageUtil();
    }
    return _StorageUtil.instance;
  }
  addHandlers(handler) {
    this.onCallBackHandlers.push(handler);
  }
  removeListener(handler) {
    let removeIndex = -1;
    for (let i = 0; i < this.onCallBackHandlers.length; i++) {
      if (this.onCallBackHandlers[i] === handler) {
        removeIndex = i;
        break;
      }
    }
    if (removeIndex !== -1) {
      this.onCallBackHandlers.splice(removeIndex, 1);
    }
  }
  startOnChangedListener() {
    chrome.storage.onChanged.addListener((changes, namespace) => {
      this.onCallBackHandlers.forEach(onCallBackHandler => {
        onCallBackHandler(changes, namespace);
      });
    });
  }
};
__publicField(_StorageUtil, `\u0069\u006e\u0073\u0074\u0061\u006e\u0063\u0065`);
let StorageUtil = _StorageUtil;
let storageUtil = StorageUtil.getInstance();
const _UseCounterStore = class _UseCounterStore {
  constructor() {
    /**
     * 用户id
     */
    __publicField(this, `\u0075\u0073\u0065\u0072\u0049\u0064`);
    __publicField(this, `\u006d\u0061\u0063\u0049\u0064`);
    __publicField(this, `\u0075\u0073\u0065\u0072\u004e\u0061\u006d\u0065`);
    __publicField(this, `\u0077\u0065\u0062\u0055\u0073\u0065\u0072\u0049\u0064`);
    __publicField(this, `\u0077\u0065\u0062\u0055\u0073\u0065\u0072\u004e\u0061\u006d\u0065`);
    __publicField(this, `\u0077\u0065\u0062\u0055\u0073\u0065\u0072\u0041\u0076\u0061\u0074\u0061\u0072\u0055\u0072\u006c`);
    __publicField(this, `\u0063\u0070\u0075\u0053\u0065\u0072\u0069\u0061\u006c\u004e\u0075\u006d\u0062\u0065\u0072`);
    __publicField(this, `\u0077\u0065\u0062\u0050\u006f\u0072\u0074`);
    __publicField(this, `\u0061\u0063\u0063\u0065\u0073\u0073\u0054\u006f\u006b\u0065\u006e`);
    __publicField(this, `\u0074\u0065\u006e\u0061\u006e\u0074\u0049\u0064`);
    __publicField(this, `\u0074\u0065\u006e\u0061\u006e\u0074\u004e\u0061\u006d\u0065`);
    __publicField(this, `\u0074\u0065\u0072\u006d\u0069\u006e\u0061\u006c\u0044\u0061\u0074\u0061`);
    // 当前页面
    __publicField(this, `\u0061\u0063\u0074\u0069\u0076\u0061\u0074\u0065\u0050\u0061\u0067\u0065`);
    // 配置
    __publicField(this, `\u0058\u0069\u0061\u006f\u0048\u006f\u006e\u0067\u0053\u0068\u0075\u005f\u0053\u0065\u0074\u0074\u0069\u006e\u0067`);
    //浏览数量
    __publicField(this, `\u0076\u0069\u0065\u0077\u0043\u006f\u0075\u006e\u0074`);
    // 评论数量
    __publicField(this, `\u0043\u006f\u006d\u006d\u0065\u006e\u0074\u0043\u006f\u0075\u006e\u0074`);
    // 点赞数量
    __publicField(this, `\u006c\u0069\u006b\u0065\u0043\u006f\u0075\u006e\u0074`);
    // 关注数量
    __publicField(this, `\u0066\u006f\u006c\u006c\u006f\u0077\u0043\u006f\u0075\u006e\u0074`);
    //收藏
    __publicField(this, `\u0063\u006f\u006c\u006c\u0065\u0063\u0074\u0043\u006f\u0075\u006e\u0074`);
    __publicField(this, `\u0078\u0068\u0073\u005f\u0076\u0069\u0065\u0077\u0043\u006f\u0075\u006e\u0074`);
    __publicField(this, `\u0078\u0068\u0073\u005f\u0043\u006f\u006d\u006d\u0065\u006e\u0074\u0043\u006f\u0075\u006e\u0074`);
    // 初始化
    __publicField(this, `\u0078\u0068\u0073\u005f\u006c\u0069\u006b\u0065\u0043\u006f\u0075\u006e\u0074`);
    // 初始化
    __publicField(this, `\u0078\u0068\u0073\u005f\u0066\u006f\u006c\u006c\u006f\u0077\u0043\u006f\u0075\u006e\u0074`);
    // 初始化
    __publicField(this, `\u0078\u0068\u0073\u005f\u0063\u006f\u006c\u006c\u0065\u0063\u0074\u0043\u006f\u0075\u006e\u0074`);
    __publicField(this, `\u0064\u0079\u005f\u0076\u0069\u0065\u0077\u0043\u006f\u0075\u006e\u0074`);
    __publicField(this, `\u0064\u0079\u005f\u0043\u006f\u006d\u006d\u0065\u006e\u0074\u0043\u006f\u0075\u006e\u0074`);
    // 初始化
    __publicField(this, `\u0064\u0079\u005f\u006c\u0069\u006b\u0065\u0043\u006f\u0075\u006e\u0074`);
    // 初始化
    __publicField(this, `\u0064\u0079\u005f\u0066\u006f\u006c\u006c\u006f\u0077\u0043\u006f\u0075\u006e\u0074`);
    // 初始化
    __publicField(this, `\u0064\u0079\u005f\u0063\u006f\u006c\u006c\u0065\u0063\u0074\u0043\u006f\u0075\u006e\u0074`);
    //工作状态
    // run：工作中
    // end: 已结束（到达底部）
    __publicField(this, `\u0058\u0069\u0061\u006f\u0048\u006f\u006e\u0067\u0053\u0068\u0075\u005f\u0077\u006f\u0072\u006b\u0053\u0074\u0061\u0074\u0075\u0073`);
    __publicField(this, `\u006c\u006f\u0061\u0064\u0065\u006e\u0064`);
    //当前窗口的tabId
    __publicField(this, `\u0063\u0068\u0072\u006f\u006d\u0065\u0054\u0061\u0062\u0049\u0064`);
    __publicField(this, `\u0069\u0073\u0044\u0065\u0062\u0075\u0067\u004d\u006f\u0064\u0065`);
    __publicField(this, `\u006f\u0070\u0065\u0072\u0061\u0074\u0069\u006f\u006e\u0054\u0069\u006d\u0065`);
    __publicField(this, `\u0058\u0069\u0061\u006f\u0048\u006f\u006e\u0067\u0053\u0068\u0075\u005f\u0073\u0065\u0061\u0072\u0063\u0068\u005f\u0072\u0075\u006e\u004e\u0075\u006d\u0062\u0065\u0072`);
    __publicField(this, `\u0044\u006f\u0075\u0059\u0069\u006e\u005f\u0073\u0065\u0061\u0072\u0063\u0068\u005f\u0072\u0075\u006e\u004e\u0075\u006d\u0062\u0065\u0072`);
    __publicField(this, `\u0058\u0069\u0061\u006f\u0048\u006f\u006e\u0067\u0053\u0068\u0075\u005f\u0061\u0076\u0067\u0054\u0069\u006d\u0065`);
    //今日运行小红书的账号时间
    __publicField(this, `\u0078\u0069\u0061\u006f\u0048\u006f\u006e\u0067\u0053\u0068\u0075\u0041\u0063\u0063\u006f\u0075\u006e\u0074\u0052\u0075\u006e\u0054\u006f\u0064\u0061\u0079\u0044\u0061\u0074\u0065`);
    //今日运行小红书的账号次数
    __publicField(this, `\u0078\u0069\u0061\u006f\u0048\u006f\u006e\u0067\u0053\u0068\u0075\u0041\u0063\u0063\u006f\u0075\u006e\u0074\u0049\u0064\u0073`);
    //今日运行小红书的账号最大次数
    __publicField(this, `\u0078\u0069\u0061\u006f\u0048\u006f\u006e\u0067\u0053\u0068\u0075\u0041\u0063\u0063\u006f\u0075\u006e\u0074\u0052\u0075\u006e\u0054\u006f\u0064\u0061\u0079\u004d\u0061\u0078\u004e\u0075\u006d`);
    __publicField(this, `\u0065\u0078\u0065\u0063\u0075\u0074\u0065\u004f\u0070\u0065\u0072\u0061\u0074\u0069\u006f\u006e\u0053\u0074\u0061\u0072\u0074\u0054\u0069\u006d\u0065`);
    __publicField(this, `\u0065\u0078\u0065\u0063\u0075\u0074\u0065\u004f\u0070\u0065\u0072\u0061\u0074\u0069\u006f\u006e\u0045\u006e\u0064\u0054\u0069\u006d\u0065`);
    //客户端id
    __publicField(this, `\u0063\u006c\u0069\u0065\u006e\u0074\u0056\u0069\u0073\u0069\u0074\u006f\u0072\u0049\u0064`);
    // vip到期时间
    __publicField(this, `\u0075\u0073\u0065\u0072\u0049\u006e\u0066\u006f\u0045\u006e\u0064\u0044\u0061\u0074\u0065`);
    //vip日期更新
    __publicField(this, `\u0075\u0070\u0064\u0061\u0074\u0065\u0056\u0069\u0070\u0044\u0061\u0074\u0065\u0054\u0069\u006d\u0065`);
    //小红书 关键词 列表
    __publicField(this, `\u0078\u0068\u0073\u005f\u006b\u0065\u0079\u0077\u006f\u0072\u0064\u0073\u005f\u006c\u0069\u0073\u0074`);
    __publicField(this, `\u0064\u006f\u0075\u0059\u0069\u006e\u005f\u006b\u0065\u0079\u0077\u006f\u0072\u0064\u0073\u005f\u006c\u0069\u0073\u0074`);
    __publicField(this, `\u006d\u0071\u0074\u0074\u0053\u0074\u0061\u0072\u0074`);
    __publicField(this, `\u0071\u0075\u0065\u0073\u0074\u0054\u0061\u0073\u006b\u0049\u0064`);
    __publicField(this, `\u006f\u0070\u0074\u0069\u006f\u006e\u0057\u0068\u0065\u0072\u0065`);
    __publicField(this, `\u0072\u0065\u0066\u0072\u0065\u0073\u0068\u0046\u0072\u0065\u0071\u0075\u0065\u006e\u0063\u0079\u004e\u0075\u006d`);
    this.userId = ``;
    this.macId = ``;
    this.webUserId = ``;
    this.webUserName = ``;
    this.webUserAvatarUrl = ``;
    this.webPort = 65400;
    this.accessToken = ``;
    this.userName = ``;
    this.tenantId = ``;
    this.tenantName = ``;
    this.terminalData = {
      "terminalName": ``
    };
    this.cpuSerialNumber = ``;
    this.mqttStart = ``;
    this.activatePage = indexPage;
    this.XiaoHongShu_Setting = `\u007b\u007d`;
    this.viewCount = 0;
    this.CommentCount = 0;
    this.likeCount = 0;
    this.followCount = 0;
    this.collectCount = 0;
    this.xhs_viewCount = 0;
    this.xhs_CommentCount = 0;
    this.xhs_likeCount = 0;
    this.xhs_followCount = 0;
    this.xhs_collectCount = 0;
    this.dy_viewCount = 0;
    this.dy_CommentCount = 0;
    this.dy_likeCount = 0;
    this.dy_followCount = 0;
    this.dy_collectCount = 0;
    this.XiaoHongShu_workStatus = `\u0072\u0075\u006e`;
    this.loadend = false;
    this.chromeTabId = 0;
    this.isDebugMode = false;
    this.operationTime = 0;
    this.XiaoHongShu_avgTime = 0;
    this.XiaoHongShu_search_runNumber = 1;
    this.DouYin_search_runNumber = 1;
    this.xiaoHongShuAccountRunTodayDate = ``;
    this.xiaoHongShuAccountIds = /* @__PURE__ */new Set();
    this.xiaoHongShuAccountRunTodayMaxNum = 3;
    this.executeOperationStartTime = 0;
    this.executeOperationEndTime = 0;
    this.clientVisitorId = ``;
    this.userInfoEndDate = ``;
    this.updateVipDateTime = ``;
    this.xhs_keywords_list = [];
    this.douYin_keywords_list = [];
    this.terminalData = {};
    this.questTaskId = ``;
    this.optionWhere = {};
    this.refreshFrequencyNum = 60 * 60 * 1e3;
  }
  // 获取唯一实例的方法
  static getInstance() {
    if (!_UseCounterStore.instance) {
      _UseCounterStore.instance = new _UseCounterStore();
      _UseCounterStore.instance.loadFromStorage();
    }
    return _UseCounterStore.instance;
  }
  setOperationTime(operationTime) {
    this.operationTime = operationTime;
    chrome.storage.local.set({
      "operationTime": this.operationTime
    });
  }
  setChromeTabId(chromeTabId) {
    this.chromeTabId = chromeTabId;
  }
  setWebUserId(userId) {
    this.webUserId = userId;
    chrome.storage.local.set({
      "webUserId": this.webUserId
    });
  }
  setWebUserName(userId) {
    this.webUserName = userId;
    chrome.storage.local.set({
      "webUserName": this.webUserName
    });
  }
  setWebUserAvatarUrl(webUserAvatarUrl) {
    this.webUserAvatarUrl = webUserAvatarUrl;
    chrome.storage.local.set({
      "webUserAvatarUrl": this.webUserAvatarUrl
    });
  }
  setCPUSerialNumber(cpuSerialNumber) {
    this.cpuSerialNumber = cpuSerialNumber;
    chrome.storage.local.set({
      "cpuSerialNumber": this.cpuSerialNumber
    });
  }
  setWebPort(webPort) {
    this.webPort = webPort;
    chrome.storage.local.set({
      "webPort": this.webPort
    });
  }
  setUserId(userId) {
    this.userId = userId;
    chrome.storage.local.set({
      "userId": this.userId
    });
  }
  setMacId(macId) {
    this.userId = macId;
    chrome.storage.local.set({
      "macId": this.macId
    });
  }
  setUserName(userName) {
    this.userName = userName;
    chrome.storage.local.set({
      "userName": this.userName
    });
  }
  setTenantId(tenantId) {
    this.tenantId = tenantId;
    chrome.storage.local.set({
      "tenantId": this.tenantId
    });
  }
  setTenantName(tenantName) {
    this.tenantName = tenantName;
    chrome.storage.local.set({
      "tenantName": this.tenantName
    });
  }
  setAccessToken(accessToken) {
    this.accessToken = accessToken;
    chrome.storage.local.set({
      "accessToken": this.accessToken
    });
  }
  set_updateVipDateTime(updateVipDateTime) {
    this.updateVipDateTime = updateVipDateTime;
    chrome.storage.local.set({
      "updateVipDateTime": this.updateVipDateTime
    });
  }
  setUserInfoEndDate(userInfoEndDate) {
    this.userInfoEndDate = userInfoEndDate;
    chrome.storage.local.set({
      "userInfoEndDate": userInfoEndDate
    });
  }
  increment_xhs_viewCount() {
    this.xhs_viewCount++;
    chrome.storage.local.set({
      "xhs_viewCount": this.xhs_viewCount
    });
  }
  increment_xhs_CommentCount() {
    this.xhs_CommentCount++;
    chrome.storage.local.set({
      "xhs_CommentCount": this.xhs_CommentCount
    });
  }
  increment_xhs_likeCount() {
    this.xhs_likeCount++;
    chrome.storage.local.set({
      "xhs_likeCount": this.xhs_likeCount
    });
  }
  increment_xhs_followCount() {
    this.xhs_followCount++;
    chrome.storage.local.set({
      "xhs_followCount": this.xhs_followCount
    });
  }
  increment_xhs_collectCount() {
    this.xhs_collectCount++;
    chrome.storage.local.set({
      "xhs_collectCount": this.xhs_collectCount
    });
  }
  increment_dy_viewCount() {
    this.dy_viewCount++;
    chrome.storage.local.set({
      "dy_viewCount": this.dy_viewCount
    });
  }
  increment_dy_CommentCount() {
    this.dy_CommentCount++;
    chrome.storage.local.set({
      "dy_CommentCount": this.dy_CommentCount
    });
  }
  increment_dy_likeCount() {
    this.dy_likeCount++;
    chrome.storage.local.set({
      "dy_likeCount": this.dy_likeCount
    });
  }
  increment_dy_followCount() {
    this.dy_followCount++;
    chrome.storage.local.set({
      "dy_followCount": this.dy_followCount
    });
  }
  increment_dy_collectCount() {
    this.dy_collectCount++;
    chrome.storage.local.set({
      "dy_collectCount": this.dy_collectCount
    });
  }
  isNotRunWork() {
    console.log(`\u0069\u0073\u004e\u006f\u0074\u0052\u0075\u006e\u0057\u006f\u0072\u006b\u0020\u0061\u0063\u0074\u0069\u0076\u0061\u0074\u0065\u0050\u0061\u0067\u0065`, this.activatePage, !runPages.includes(this.activatePage));
    return !runPages.includes(this.activatePage);
  }
  setActivatePage(page) {
    console.log(`\u0073\u0065\u0074\u0041\u0063\u0074\u0069\u0076\u0061\u0074\u0065\u0050\u0061\u0067\u0065`, this.activatePage);
    this.activatePage = page;
  }
  setXiaoHongShu_workStatus(status) {
    this.XiaoHongShu_workStatus = status;
    chrome.storage.local.set({
      "XiaoHongShu_workStatus": this.XiaoHongShu_workStatus
    });
  }
  setXiaoHongShu_avgTime(avgTime) {
    this.XiaoHongShu_avgTime = avgTime;
    chrome.storage.local.set({
      "XiaoHongShu_avgTime": this.XiaoHongShu_avgTime
    });
  }
  setExecuteOperationStartTime(executeOperationStartTime) {
    this.executeOperationStartTime = executeOperationStartTime;
  }
  setExecuteOperationEndTime(executeOperationEndTime) {
    this.executeOperationEndTime = executeOperationEndTime;
    chrome.storage.local.set({
      "executeOperationEndTime": this.executeOperationEndTime
    });
  }
  setXHSKeywords_list(xhs_keywords_list) {
    this.xhs_keywords_list = xhs_keywords_list;
    chrome.storage.local.set({
      "xhs_keywords_list": JSON.stringify(this.xhs_keywords_list)
    });
  }
  setDouYinKeywords_list(douYin_keywords_list) {
    this.douYin_keywords_list = douYin_keywords_list;
    chrome.storage.local.set({
      "douYin_keywords_list": JSON.stringify(this.douYin_keywords_list)
    });
  }
  increment_XiaoHongShu_search_runNumber() {
    this.XiaoHongShu_search_runNumber += 1;
    chrome.storage.local.set({
      "XiaoHongShu_search_runNumber": this.XiaoHongShu_search_runNumber
    });
  }
  increment_DouYin_search_runNumber() {
    this.DouYin_search_runNumber += 1;
    chrome.storage.local.set({
      "DouYin_search_runNumber": this.DouYin_search_runNumber
    });
  }
  increment_XiaoHongShuAccountRunTodayIds(platform, xiaoHongShuAccountIds) {
    this.xiaoHongShuAccountIds.add(xiaoHongShuAccountIds);
    const xiaoHongShuAccountIds_str = JSON.stringify([...this.xiaoHongShuAccountIds]);
    console.log(`\u0069\u006e\u0063\u0072\u0065\u006d\u0065\u006e\u0074\u005f\u0058\u0069\u0061\u006f\u0048\u006f\u006e\u0067\u0053\u0068\u0075\u0041\u0063\u0063\u006f\u0075\u006e\u0074\u0052\u0075\u006e\u0054\u006f\u0064\u0061\u0079\u0049\u0064\u0073\u0020\u0078\u0069\u0061\u006f\u0048\u006f\u006e\u0067\u0053\u0068\u0075\u0041\u0063\u0063\u006f\u0075\u006e\u0074\u0049\u0064\u0073\u005f\u0073\u0074\u0072`, xiaoHongShuAccountIds_str, xiaoHongShuAccountIds, this.xiaoHongShuAccountIds);
    const key = platform + `\u005f\u0078\u0069\u0061\u006f\u0048\u006f\u006e\u0067\u0053\u0068\u0075\u0041\u0063\u0063\u006f\u0075\u006e\u0074\u0049\u0064\u0073`;
    const items = {};
    items[key] = xiaoHongShuAccountIds_str;
    chrome.storage.local.set(items);
  }
  setXiaoHongShuAccountRunTodayIds(platform, xiaoHongShuAccountIds) {
    this.xiaoHongShuAccountIds = xiaoHongShuAccountIds;
    const xiaoHongShuAccountIds_str = JSON.stringify([...this.xiaoHongShuAccountIds]);
    console.log(`\u0073\u0065\u0074\u0058\u0069\u0061\u006f\u0048\u006f\u006e\u0067\u0053\u0068\u0075\u0041\u0063\u0063\u006f\u0075\u006e\u0074\u0052\u0075\u006e\u0054\u006f\u0064\u0061\u0079\u0049\u0064\u0073\u0020\u0078\u0069\u0061\u006f\u0048\u006f\u006e\u0067\u0053\u0068\u0075\u0041\u0063\u0063\u006f\u0075\u006e\u0074\u0049\u0064\u0073\u005f\u0073\u0074\u0072`, xiaoHongShuAccountIds_str, xiaoHongShuAccountIds, this.xiaoHongShuAccountIds);
    const key = platform + `\u005f\u0078\u0069\u0061\u006f\u0048\u006f\u006e\u0067\u0053\u0068\u0075\u0041\u0063\u0063\u006f\u0075\u006e\u0074\u0049\u0064\u0073`;
    const items = {};
    items[key] = xiaoHongShuAccountIds_str;
    chrome.storage.local.set(items);
  }
  setXiaoHongShuAccountRunTodayDate(platform, xiaoHongShuAccountRunTodayDate) {
    this.xiaoHongShuAccountRunTodayDate = xiaoHongShuAccountRunTodayDate;
    const key = platform + `\u005f\u0078\u0069\u0061\u006f\u0048\u006f\u006e\u0067\u0053\u0068\u0075\u0041\u0063\u0063\u006f\u0075\u006e\u0074\u0052\u0075\u006e\u0054\u006f\u0064\u0061\u0079\u0044\u0061\u0074\u0065`;
    const items = {};
    items[key] = this.xiaoHongShuAccountRunTodayDate;
    chrome.storage.local.set(items);
  }
  setXiaoHongShuAccountErrorTip(errorMessage) {
    chrome.storage.local.set({
      "xiaoHongShuAccountErrorTip": errorMessage
    });
  }
  setClientVisitorId(clientVisitorId) {
    this.clientVisitorId = clientVisitorId;
    chrome.storage.local.set({
      "clientVisitorId": clientVisitorId
    });
  }
  getOptionWhere() {
    return this.optionWhere;
  }
  setRefreshFrequencyNum(refreshFrequencyNum) {
    this.refreshFrequencyNum = refreshFrequencyNum;
    chrome.storage.local.set({
      "refreshFrequencyNum": refreshFrequencyNum
    });
  }
  setTerminalData(terminalData) {
    this.terminalData = terminalData;
    chrome.storage.local.set({
      "terminalData": JSON.stringify(terminalData)
    });
  }
  setQuestTaskId(questTaskId) {
    this.questTaskId = questTaskId;
    chrome.storage.local.set({
      "questTaskId": questTaskId
    });
  }
  checkLoadend() {
    let maxNum = 60,
      timeout = 30;
    let num = 0;
    return new Promise(resolve => {
      const checkInterval = setInterval(() => {
        const loadend = this.loadend;
        if (loadend || num > maxNum) {
          if (num > maxNum) {
            console.error(`\u0063\u0068\u0065\u0063\u006b\u004c\u006f\u0061\u0064\u0065\u006e\u0064\u0020\u52a0\u8f7d\u8d85\u65f6`);
          }
          clearInterval(checkInterval);
          resolve();
        }
        num++;
      }, timeout);
    });
  }
  loadFromStorage() {
    chrome.storage.local.get([`\u0075\u0073\u0065\u0072\u0049\u0064`, `\u0075\u0073\u0065\u0072\u004e\u0061\u006d\u0065`, `\u0074\u0065\u006e\u0061\u006e\u0074\u0049\u0064`, `\u0077\u0065\u0062\u0055\u0073\u0065\u0072\u0049\u0064`, `\u0077\u0065\u0062\u0055\u0073\u0065\u0072\u004e\u0061\u006d\u0065`, `\u0077\u0065\u0062\u0055\u0073\u0065\u0072\u0041\u0076\u0061\u0074\u0061\u0072\u0055\u0072\u006c`, `\u0063\u0070\u0075\u0053\u0065\u0072\u0069\u0061\u006c\u004e\u0075\u006d\u0062\u0065\u0072`, `\u0061\u0063\u0063\u0065\u0073\u0073\u0054\u006f\u006b\u0065\u006e`, `\u0061\u0063\u0074\u0069\u0076\u0061\u0074\u0065\u0050\u0061\u0067\u0065`, `\u0058\u0069\u0061\u006f\u0048\u006f\u006e\u0067\u0053\u0068\u0075\u005f\u0053\u0065\u0074\u0074\u0069\u006e\u0067`, `\u0078\u0068\u0073\u005f\u0076\u0069\u0065\u0077\u0043\u006f\u0075\u006e\u0074`, `\u0078\u0068\u0073\u005f\u0043\u006f\u006d\u006d\u0065\u006e\u0074\u0043\u006f\u0075\u006e\u0074`, `\u0078\u0068\u0073\u005f\u006c\u0069\u006b\u0065\u0043\u006f\u0075\u006e\u0074`, `\u0078\u0068\u0073\u005f\u0066\u006f\u006c\u006c\u006f\u0077\u0043\u006f\u0075\u006e\u0074`, `\u0078\u0068\u0073\u005f\u0063\u006f\u006c\u006c\u0065\u0063\u0074\u0043\u006f\u0075\u006e\u0074`, `\u0064\u0079\u005f\u0076\u0069\u0065\u0077\u0043\u006f\u0075\u006e\u0074`, `\u0064\u0079\u005f\u0043\u006f\u006d\u006d\u0065\u006e\u0074\u0043\u006f\u0075\u006e\u0074`, `\u0064\u0079\u005f\u006c\u0069\u006b\u0065\u0043\u006f\u0075\u006e\u0074`, `\u0064\u0079\u005f\u0066\u006f\u006c\u006c\u006f\u0077\u0043\u006f\u0075\u006e\u0074`, `\u0064\u0079\u005f\u0063\u006f\u006c\u006c\u0065\u0063\u0074\u0043\u006f\u0075\u006e\u0074`, `\u0058\u0069\u0061\u006f\u0048\u006f\u006e\u0067\u0053\u0068\u0075\u005f\u0077\u006f\u0072\u006b\u0053\u0074\u0061\u0074\u0075\u0073`, `\u0058\u0069\u0061\u006f\u0048\u006f\u006e\u0067\u0053\u0068\u0075\u005f\u0061\u0076\u0067\u0054\u0069\u006d\u0065`, `\u0058\u0069\u0061\u006f\u0048\u006f\u006e\u0067\u0053\u0068\u0075\u005f\u0073\u0065\u0061\u0072\u0063\u0068\u005f\u0072\u0075\u006e\u004e\u0075\u006d\u0062\u0065\u0072`, `\u0044\u006f\u0075\u0059\u0069\u006e\u005f\u0073\u0065\u0061\u0072\u0063\u0068\u005f\u0072\u0075\u006e\u004e\u0075\u006d\u0062\u0065\u0072`, `\u0078\u0069\u0061\u006f\u0048\u006f\u006e\u0067\u0053\u0068\u0075\u0041\u0063\u0063\u006f\u0075\u006e\u0074\u0052\u0075\u006e\u0054\u006f\u0064\u0061\u0079\u0044\u0061\u0074\u0065`, `\u0078\u0069\u0061\u006f\u0048\u006f\u006e\u0067\u0053\u0068\u0075\u0041\u0063\u0063\u006f\u0075\u006e\u0074\u0049\u0064\u0073`, `\u0065\u0078\u0065\u0063\u0075\u0074\u0065\u004f\u0070\u0065\u0072\u0061\u0074\u0069\u006f\u006e\u0053\u0074\u0061\u0072\u0074\u0054\u0069\u006d\u0065`, `\u0063\u006c\u0069\u0065\u006e\u0074\u0056\u0069\u0073\u0069\u0074\u006f\u0072\u0049\u0064`, `\u0075\u0073\u0065\u0072\u0049\u006e\u0066\u006f\u0045\u006e\u0064\u0044\u0061\u0074\u0065`, `\u006d\u0071\u0074\u0074\u0053\u0074\u0061\u0072\u0074`, `\u006f\u0070\u0074\u0069\u006f\u006e\u0057\u0068\u0065\u0072\u0065`, `\u0074\u0065\u0072\u006d\u0069\u006e\u0061\u006c\u0044\u0061\u0074\u0061`, `\u0071\u0075\u0065\u0073\u0074\u0054\u0061\u0073\u006b\u0049\u0064`], result => {
      console.log(`\u0072\u0065\u0073\u0075\u006c\u0074\u0020\u0061\u0063\u0074\u0069\u0076\u0061\u0074\u0065\u0050\u0061\u0067\u0065`, result);
      if (result.userId !== void 0) {
        this.userId = result.userId;
      }
      if (result.userName !== void 0) {
        this.userName = result.userName;
      }
      if (result.tenantId !== void 0) {
        this.tenantId = result.tenantId;
      }
      if (result.webUserId !== void 0) {
        this.webUserId = result.webUserId;
      }
      if (result.webUserName !== void 0) {
        this.webUserName = result.webUserName;
      }
      if (result.webUserAvatarUrl !== void 0) {
        this.webUserAvatarUrl = result.webUserAvatarUrl;
      }
      if (result.cpuSerialNumber !== void 0) {
        this.cpuSerialNumber = result.cpuSerialNumber;
      }
      if (result.accessToken !== void 0) {
        this.accessToken = result.accessToken;
      }
      if (result.activatePage !== void 0) {
        this.activatePage = result.activatePage;
      }
      if (result.XiaoHongShu_Setting !== void 0) {
        this.XiaoHongShu_Setting = result.XiaoHongShu_Setting;
      }
      if (result.xhs_viewCount !== void 0) {
        this.xhs_viewCount = result.xhs_viewCount;
      }
      if (result.xhs_CommentCount !== void 0) {
        this.xhs_CommentCount = result.xhs_CommentCount;
      }
      if (result.xhs_likeCount !== void 0) {
        this.xhs_likeCount = result.xhs_likeCount;
      }
      if (result.xhs_followCount !== void 0) {
        this.xhs_followCount = result.xhs_followCount;
      }
      if (result.xhs_collectCount !== void 0) {
        this.xhs_collectCount = result.xhs_collectCount;
      }
      if (result.dy_viewCount !== void 0) {
        this.dy_viewCount = result.dy_viewCount;
      }
      if (result.dy_CommentCount !== void 0) {
        this.dy_CommentCount = result.dy_CommentCount;
      }
      if (result.dy_likeCount !== void 0) {
        this.dy_likeCount = result.dy_likeCount;
      }
      if (result.dy_followCount !== void 0) {
        this.dy_followCount = result.dy_followCount;
      }
      if (result.dy_collectCount !== void 0) {
        this.dy_collectCount = result.dy_collectCount;
      }
      if (result.XiaoHongShu_workStatus !== void 0) {
        this.XiaoHongShu_workStatus = result.XiaoHongShu_workStatus;
      }
      if (result.XiaoHongShu_avgTime !== void 0) {
        this.XiaoHongShu_avgTime = result.XiaoHongShu_avgTime;
      }
      if (result.XiaoHongShu_search_runNumber !== void 0) {
        this.XiaoHongShu_search_runNumber = result.XiaoHongShu_search_runNumber;
      }
      if (result.DouYin_search_runNumber !== void 0) {
        this.DouYin_search_runNumber = result.DouYin_search_runNumber;
      }
      if (result.xiaoHongShuAccountRunTodayDate !== void 0) {
        this.xiaoHongShuAccountRunTodayDate = result.xiaoHongShuAccountRunTodayDate;
      }
      if (result.xiaoHongShuAccountIds !== void 0 && result.xiaoHongShuAccountIds) {
        if (typeof result.xiaoHongShuAccountIds === `\u0073\u0074\u0072\u0069\u006e\u0067`) {
          this.xiaoHongShuAccountIds = new Set(JSON.parse(result.xiaoHongShuAccountIds));
        } else if (result.xiaoHongShuAccountIds instanceof Set) {
          this.xiaoHongShuAccountIds = result.xiaoHongShuAccountIds;
        } else if (result.xiaoHongShuAccountIds instanceof Array) {
          this.xiaoHongShuAccountIds = new Set(result.xiaoHongShuAccountIds);
        }
      }
      if (result.executeOperationStartTime !== void 0) {
        this.executeOperationStartTime = result.executeOperationStartTime;
      }
      if (result.clientVisitorId !== void 0) {
        this.clientVisitorId = result.clientVisitorId;
      }
      if (result.userInfoEndDate !== void 0) {
        this.userInfoEndDate = result.userInfoEndDate;
      }
      if (result.mqttStart !== void 0) {
        this.mqttStart = result.mqttStart;
      }
      if (result.terminalData !== void 0) {
        this.terminalData = result.terminalData ? JSON.parse(result.terminalData) : {};
      }
      if (result.optionWhere !== void 0) {
        this.optionWhere = result.optionWhere ? JSON.parse(result.optionWhere) : {};
      }
      if (result.questTaskId !== void 0) {
        this.questTaskId = result.questTaskId;
      }
      this.loadend = true;
    });
    const callBackListener = (changes, namespace) => {
      for (let [key, {
        oldValue,
        newValue
      }] of Object.entries(changes)) {
        console.log(`\u0053\u0074\u006f\u0072\u0061\u0067\u0065\u0020\u006b\u0065\u0079\u0020\u0022${key}\u0022\u0020\u0069\u006e\u0020\u006e\u0061\u006d\u0065\u0073\u0070\u0061\u0063\u0065\u0020\u0022${namespace}\u0022\u0020\u0063\u0068\u0061\u006e\u0067\u0065\u0064\u002e`, `\u004f\u006c\u0064\u0020\u0076\u0061\u006c\u0075\u0065\u0020\u0077\u0061\u0073\u0020\u0022${oldValue}\u0022\u002c\u0020\u006e\u0065\u0077\u0020\u0076\u0061\u006c\u0075\u0065\u0020\u0069\u0073\u0020\u0022${newValue}\u0022\u002e`);
        switch (key) {
          case `\u0075\u0073\u0065\u0072\u0049\u0064`:
            this.userId = newValue;
            break;
          case `\u0061\u0063\u0063\u0065\u0073\u0073\u0054\u006f\u006b\u0065\u006e`:
            this.accessToken = newValue;
            break;
          case `\u0061\u0063\u0074\u0069\u0076\u0061\u0074\u0065\u0050\u0061\u0067\u0065`:
            this.setActivatePage(newValue);
            break;
          case `\u0078\u0068\u0073\u005f\u006c\u0069\u006b\u0065\u0043\u006f\u0075\u006e\u0074`:
            this.xhs_likeCount = newValue;
            break;
          case `\u0078\u0068\u0073\u005f\u0066\u006f\u006c\u006c\u006f\u0077\u0043\u006f\u0075\u006e\u0074`:
            this.xhs_followCount = newValue;
            break;
          case `\u0078\u0068\u0073\u005f\u0043\u006f\u006d\u006d\u0065\u006e\u0074\u0043\u006f\u0075\u006e\u0074`:
            this.xhs_CommentCount = newValue;
            break;
          case `\u0078\u0068\u0073\u005f\u0063\u006f\u006c\u006c\u0065\u0063\u0074\u0043\u006f\u0075\u006e\u0074`:
            this.xhs_collectCount = newValue;
            break;
          case `\u0078\u0068\u0073\u005f\u0076\u0069\u0065\u0077\u0043\u006f\u0075\u006e\u0074`:
            this.xhs_viewCount = newValue;
            break;
          case `\u0064\u0079\u005f\u006c\u0069\u006b\u0065\u0043\u006f\u0075\u006e\u0074`:
            this.dy_likeCount = newValue;
            break;
          case `\u0064\u0079\u005f\u0066\u006f\u006c\u006c\u006f\u0077\u0043\u006f\u0075\u006e\u0074`:
            this.dy_followCount = newValue;
            break;
          case `\u0064\u0079\u005f\u0043\u006f\u006d\u006d\u0065\u006e\u0074\u0043\u006f\u0075\u006e\u0074`:
            this.dy_CommentCount = newValue;
            break;
          case `\u0064\u0079\u005f\u0063\u006f\u006c\u006c\u0065\u0063\u0074\u0043\u006f\u0075\u006e\u0074`:
            this.dy_collectCount = newValue;
            break;
          case `\u0064\u0079\u005f\u0076\u0069\u0065\u0077\u0043\u006f\u0075\u006e\u0074`:
            this.dy_viewCount = newValue;
            break;
          case `\u0065\u0078\u0065\u0063\u0075\u0074\u0065\u004f\u0070\u0065\u0072\u0061\u0074\u0069\u006f\u006e\u0053\u0074\u0061\u0072\u0074\u0054\u0069\u006d\u0065`:
            this.executeOperationStartTime = newValue;
            break;
          case `\u0063\u006c\u0069\u0065\u006e\u0074\u0056\u0069\u0073\u0069\u0074\u006f\u0072\u0049\u0064`:
            this.clientVisitorId = newValue;
            break;
          case `\u0075\u0073\u0065\u0072\u0049\u006e\u0066\u006f\u0045\u006e\u0064\u0044\u0061\u0074\u0065`:
            this.userInfoEndDate = newValue;
            break;
          case `\u0074\u0065\u0072\u006d\u0069\u006e\u0061\u006c\u0044\u0061\u0074\u0061`:
            this.terminalData = newValue ? JSON.parse(newValue) : {};
            break;
          case `\u006f\u0070\u0074\u0069\u006f\u006e\u0057\u0068\u0065\u0072\u0065`:
            this.optionWhere = newValue ? JSON.parse(newValue) : {};
            break;
          case `\u0071\u0075\u0065\u0073\u0074\u0054\u0061\u0073\u006b\u0049\u0064`:
            this.questTaskId = newValue;
            break;
        }
      }
    };
    storageUtil.removeListener(callBackListener);
    storageUtil.addHandlers(callBackListener);
  }
};
__publicField(_UseCounterStore, `\u0069\u006e\u0073\u0074\u0061\u006e\u0063\u0065`);
let UseCounterStore = _UseCounterStore;
const store$g = UseCounterStore.getInstance();
const addObjects = async postData => {
  if (!store$g.accessToken) {
    console.log(`\u0061\u0064\u0064\u004f\u0062\u006a\u0065\u0063\u0074\u0073\u0020\u0073\u0074\u006f\u0072\u0065\u002e\u0061\u0063\u0063\u0065\u0073\u0073\u0054\u006f\u006b\u0065\u006e\u0020\u4e3a\u7a7a`, store$g.accessToken);
    return;
  }
  const baseURL = `\u0068\u0074\u0074\u0070\u0073\u003a\u002f\u002f\u0070\u006c\u0075\u0067\u0069\u006e\u002d\u0061\u0070\u0069\u002d\u0061\u0064\u006c\u0072\u0064\u006f\u006a\u0062\u0079\u0064\u002e\u0061\u0070\u002d\u006e\u006f\u0072\u0074\u0068\u0065\u0061\u0073\u0074\u002d\u0031\u002e\u0066\u0063\u0061\u0070\u0070\u002e\u0072\u0075\u006e`;
  const url = baseURL + `\u002f\u0061\u0070\u0069\u002f\u0076\u0032\u002f\u006f\u0073\u0073\u002f\u006f\u0062\u006a\u0065\u0063\u0074\u0073`;
  const headers = {
    "Content-Type": `\u0061\u0070\u0070\u006c\u0069\u0063\u0061\u0074\u0069\u006f\u006e\u002f\u006a\u0073\u006f\u006e`,
    "Authorization": `\u0042\u0065\u0061\u0072\u0065\u0072\u0020` + store$g.accessToken
  };
  try {
    const response = await fetch(url, {
      method: `\u0050\u004f\u0053\u0054`,
      headers,
      body: JSON.stringify(postData)
    });
    if (!response.ok) {
      console.error(`\u0061\u0064\u0064\u004f\u0062\u006a\u0065\u0063\u0074\u0073\u0020\u0075\u0072\u006c\u003a` + url + `\uff0c\u0068\u0065\u0061\u0064\u0065\u0072\u003a` + JSON.stringify(headers) + `\u002c\u0020\u0072\u0065\u0073\u0070\u006f\u006e\u0073\u0065\u0020\u0073\u0074\u0061\u0074\u0075\u0073\u003a` + response.status);
      return void 0;
    }
    const result = await response.json();
    console.log(`\u0061\u0064\u0064\u004f\u0062\u006a\u0065\u0063\u0074\u0073\u0020\u0075\u0072\u006c\u003a` + url + `\uff0c\u0068\u0065\u0061\u0064\u0065\u0072\u003a` + JSON.stringify(headers) + `\u002c\u0070\u006f\u0073\u0074\u0044\u0061\u0074\u0061\uff1a` + JSON.stringify(postData) + `\u0020\u0072\u0065\u0073\u0070\u006f\u006e\u0073\u0065\u0020\u0073\u0074\u0061\u0074\u0075\u0073\u003a` + response.status + `\u002c\u0020\u0072\u0065\u0073\u0070\u006f\u006e\u0073\u0065\u0020\u0064\u0061\u0074\u0061\u003a` + JSON.stringify(result));
    return result;
  } catch (error) {
    console.error(`\u0061\u0064\u0064\u004f\u0062\u006a\u0065\u0063\u0074\u0073\u0020\u0075\u0072\u006c\u003a` + url + `\uff0c\u0068\u0065\u0061\u0064\u0065\u0072\u003a` + JSON.stringify(headers) + `\u002c\u0020\u0065\u0072\u0072\u006f\u0072` + error);
  }
  return void 0;
};
UseCounterStore.getInstance();
function sendLog(...messages) {
  const combinedMessage = messages.map(String).join(`\u0020`);
  console.log(combinedMessage);
}
function requestKeepAwake() {
  chrome.power.requestKeepAwake(`\u0064\u0069\u0073\u0070\u006c\u0061\u0079`);
}
function releaseKeepAwake() {
  chrome.power.releaseKeepAwake();
}
function delay(ms) {
  return new Promise(resolve => setTimeout(resolve, ms));
}
function formatNowDateTime() {
  const date = /* @__PURE__ */new Date();
  const year = date.getFullYear();
  const month = String(date.getMonth() + 1).padStart(2, `\u0030`);
  const day = String(date.getDate()).padStart(2, `\u0030`);
  const hours = String(date.getHours()).padStart(2, `\u0030`);
  const minutes = String(date.getMinutes()).padStart(2, `\u0030`);
  return `${year}\u002d${month}\u002d${day}\u0020${hours}\u003a${minutes}`;
}
function formatNowDateTimeSss() {
  const date = /* @__PURE__ */new Date();
  const year = date.getFullYear();
  const month = String(date.getMonth() + 1).padStart(2, `\u0030`);
  const day = String(date.getDate()).padStart(2, `\u0030`);
  const hours = String(date.getHours()).padStart(2, `\u0030`);
  const minutes = String(date.getMinutes()).padStart(2, `\u0030`);
  const seconds = String(date.getSeconds()).padStart(2, `\u0030`);
  const milliseconds = String(date.getMilliseconds()).padStart(3, `\u0030`);
  return `${year}\u002d${month}\u002d${day}\u0020${hours}\u003a${minutes}\u003a${seconds}\u002e${milliseconds}`;
}
const lastTimeMap = /* @__PURE__ */new Map();
function throttle(func, delay2) {
  return function (...args) {
    const now = Date.now();
    const lastTime = lastTimeMap.get(func) || 0;
    if (now - lastTime >= delay2) {
      lastTimeMap.set(func, now);
      func(...args);
    }
  };
}
const VITE_PLUGIN_ID = `\u0078\u0069\u0061\u006f\u0073\u0068\u0075\u0074\u0069\u0061\u006f\u002d\u0061\u0075\u0074\u006f\u006d\u0061\u0074\u0069\u0063\u002d\u0072\u0065\u0076\u0069\u0065\u0077\u0073`;
const VITE_AGENT_ID$5 = `\u0078\u0069\u0061\u006f\u0073\u0068\u0075\u0074\u0069\u0061\u006f\u002d\u0061\u0075\u0074\u006f\u006d\u0061\u0074\u0069\u0063\u002d\u0065\u0078\u0074\u0065\u006e\u0073\u0069\u006f\u006e`;
const _MqttManage = class _MqttManage {
  constructor(params, retryInterval = 5e3) {
    __publicField(this, `\u0075\u0073\u0065\u0072\u0049\u0064`);
    __publicField(this, `\u0075\u0073\u0065\u0072\u004e\u0061\u006d\u0065`);
    __publicField(this, `\u0074\u0065\u006e\u0061\u006e\u0074\u0049\u0064`);
    __publicField(this, `\u0074\u0065\u006e\u0061\u006e\u0074\u004e\u0061\u006d\u0065`);
    __publicField(this, `\u0073\u0074\u0061\u0072\u0074\u004c\u006f\u0061\u0064`);
    __publicField(this, `\u006c\u006f\u0061\u0064\u0065\u006e\u0064`);
    __publicField(this, `\u006d\u0071\u0074\u0074\u0043\u006c\u0069\u0065\u006e\u0074`);
    __publicField(this, `\u0061\u0067\u0065\u006e\u0074\u0049\u0064`);
    __publicField(this, `\u0063\u006c\u0069\u0065\u006e\u0074\u0049\u0064`);
    __publicField(this, `\u0063\u006c\u0069\u0065\u006e\u0074\u0056\u0069\u0073\u0069\u0074\u006f\u0072\u0049\u0064`);
    __publicField(this, `\u0061\u0063\u0063\u0065\u0073\u0073\u0054\u006f\u006b\u0065\u006e`);
    __publicField(this, `\u0074\u0065\u0072\u006d\u0069\u006e\u0061\u006c\u0044\u0061\u0074\u0061`);
    __publicField(this, `\u0072\u0065\u0074\u0072\u0079\u0049\u006e\u0074\u0065\u0072\u0076\u0061\u006c`);
    __publicField(this, `\u006f\u006e\u004d\u0065\u0073\u0073\u0061\u0067\u0065\u0048\u0061\u006e\u0064\u006c\u0065\u0072\u0073`);
    __publicField(this, `\u006f\u006e\u0044\u0069\u0073\u0063\u006f\u006e\u006e\u0065\u0063\u0074\u0048\u0061\u006e\u0064\u006c\u0065\u0072\u0073`);
    __publicField(this, `\u0063\u0061\u006c\u006c\u0041\u0067\u0065\u006e\u0074\u0048\u0061\u006e\u0064\u006c\u0065\u0072`);
    __publicField(this, `\u0075\u0072\u006c`);
    __publicField(this, `\u0063\u006f\u006e\u006e\u0065\u0063\u0074\u0042\u006f\u006f\u006c`);
    __publicField(this, `\u006d\u0065\u0073\u0073\u0061\u0067\u0065\u0048\u0065\u0061\u0072\u0074\u0049\u006e\u0074\u0065\u0072\u0076\u0061\u006c`);
    __publicField(this, `\u0069\u0073\u0053\u0074\u0061\u0072\u0074\u0069\u006e\u0067\u0049\u006e\u0074\u0065\u0072\u0076\u0061\u006c`);
    __publicField(this, `\u0075\u0073\u0065\u0072\u0043\u006c\u006f\u0073\u0065\u0042\u006f\u006f\u006c`);
    // 运行的task
    __publicField(this, `\u0072\u0075\u006e\u0054\u0061\u0073\u006b\u0049\u006e\u0073\u0074\u0061\u006e\u0063\u0065`);
    __publicField(this, `\u0077\u0065\u0062\u0055\u0073\u0065\u0072\u0049\u0064`);
    __publicField(this, `\u0077\u0065\u0062\u0055\u0073\u0065\u0072\u004e\u0061\u006d\u0065`);
    __publicField(this, `\u0077\u0065\u0062\u0055\u0073\u0065\u0072\u0041\u0076\u0061\u0074\u0061\u0072\u0055\u0072\u006c`);
    __publicField(this, `\u006d\u0061\u0063\u0049\u0064`);
    __publicField(this, `\u0063\u0070\u0075\u0053\u0065\u0072\u0069\u0061\u006c\u004e\u0075\u006d\u0062\u0065\u0072`);
    __publicField(this, `\u0063\u0068\u006f\u006f\u0073\u0065\u0043\u0072\u0065\u0061\u0074\u0065\u0054\u0061\u0073\u006b`);
    __publicField(this, `\u0072\u0075\u006e\u0054\u0061\u0073\u006b\u004d\u0071\u0074\u0074\u004d\u0065\u0073\u0073\u0061\u0067\u0065`);
    //心跳去重处理
    __publicField(this, `\u006d\u0065\u0073\u0073\u0061\u0067\u0065\u0048\u0065\u0061\u0072\u0074\u0049\u006e\u0074\u0065\u0072\u0076\u0061\u006c\u0054\u0069\u006d\u0065`);
    __publicField(this, `\u0074\u0068\u0072\u006f\u0074\u0074\u006c\u0065\u004d\u0065\u0073\u0073\u0061\u0067\u0065\u0048\u0065\u0061\u0072\u0074`);
    __publicField(this, `\u0063\u0061\u006c\u006c\u0042\u0061\u0063\u006b\u0048\u0061\u006e\u0064\u006c\u0065\u0072`, (changes, namespace) => {
      for (let [key, {
        oldValue,
        newValue
      }] of Object.entries(changes)) {
        console.log(`\u0053\u0074\u006f\u0072\u0061\u0067\u0065\u0020\u006b\u0065\u0079\u0020\u0022${key}\u0022\u0020\u0069\u006e\u0020\u006e\u0061\u006d\u0065\u0073\u0070\u0061\u0063\u0065\u0020\u0022${namespace}\u0022\u0020\u0063\u0068\u0061\u006e\u0067\u0065\u0064\u002e`, `\u004f\u006c\u0064\u0020\u0076\u0061\u006c\u0075\u0065\u0020\u0077\u0061\u0073\u0020\u0022${oldValue}\u0022\u002c\u0020\u006e\u0065\u0077\u0020\u0076\u0061\u006c\u0075\u0065\u0020\u0069\u0073\u0020\u0022${newValue}\u0022\u002e`);
        switch (key) {
          case `\u0063\u006c\u0069\u0065\u006e\u0074\u0056\u0069\u0073\u0069\u0074\u006f\u0072\u0049\u0064`:
            this.clientVisitorId = newValue;
            break;
          case `\u0061\u0063\u0063\u0065\u0073\u0073\u0054\u006f\u006b\u0065\u006e`:
            this.accessToken = newValue;
            break;
          case `\u0075\u0073\u0065\u0072\u0049\u0064`:
            this.userId = newValue;
            if (newValue === `` && this.mqttClient) {
              this.closeMqtt();
              break;
            }
            if (this.userId && this.tenantId && this.terminalData && this.terminalData.terminalId) {
              this.connectMqtt();
            }
            break;
          case `\u0075\u0073\u0065\u0072\u004e\u0061\u006d\u0065`:
            this.userName = newValue;
            break;
          case `\u0074\u0065\u006e\u0061\u006e\u0074\u0049\u0064`:
            this.tenantId = newValue;
            if (newValue === `` && this.mqttClient) {
              this.closeMqtt();
              break;
            }
            if (this.userId && this.tenantId && this.terminalData && this.terminalData.terminalId) {
              this.connectMqtt();
            }
            break;
          case `\u0074\u0065\u006e\u0061\u006e\u0074\u004e\u0061\u006d\u0065`:
            this.tenantName = newValue;
            break;
          case `\u0074\u0065\u0072\u006d\u0069\u006e\u0061\u006c\u0044\u0061\u0074\u0061`:
            this.terminalData = newValue == `` ? {} : JSON.parse(newValue);
            if (this.userId && this.tenantId && this.terminalData && this.terminalData.terminalId) {
              this.connectMqtt();
            }
            break;
          case `\u0077\u0065\u0062\u0055\u0073\u0065\u0072\u0049\u0064`:
            this.webUserId = newValue;
            break;
          case `\u0077\u0065\u0062\u0055\u0073\u0065\u0072\u004e\u0061\u006d\u0065`:
            this.webUserName = newValue;
            break;
          case `\u0077\u0065\u0062\u0055\u0073\u0065\u0072\u0041\u0076\u0061\u0074\u0061\u0072\u0055\u0072\u006c`:
            this.webUserAvatarUrl = newValue;
            break;
          case `\u006d\u0061\u0063\u0049\u0064`:
            this.macId = newValue;
            break;
          case `\u0063\u0070\u0075\u0053\u0065\u0072\u0069\u0061\u006c\u004e\u0075\u006d\u0062\u0065\u0072`:
            this.cpuSerialNumber = newValue;
            break;
          case `\u0072\u0075\u006e\u0054\u0061\u0073\u006b\u004d\u0071\u0074\u0074\u004d\u0065\u0073\u0073\u0061\u0067\u0065`:
            this.runTaskMqttMessage = newValue;
            break;
        }
      }
    });
    this.url = `\u0077\u0073\u003a\u002f\u002f\u0038\u002e\u0031\u0033\u0030\u002e\u0031\u0033\u002e\u0032\u0032\u0036\u003a\u0038\u0039\u0034\u0035\u002f\u0077\u0073`;
    this.retryInterval = retryInterval;
    this.agentId = `\u0064\u0065\u0066\u0061\u0075\u006c\u0074`;
    this.clientId = `\u0064\u0065\u0066\u0061\u0075\u006c\u0074`;
    if (params.retryInterval) this.retryInterval = params.retryInterval;
    if (params.agentId) this.agentId = params.agentId;
    if (params.clientId) this.clientId = params.clientId;
    this.onMessageHandlers = [];
    this.onDisconnectHandlers = [];
    this.callAgentHandler = null;
    this.userId = ``;
    this.userName = ``;
    this.tenantId = ``;
    this.tenantName = ``;
    this.clientVisitorId = ``;
    this.accessToken = ``;
    this.userCloseBool = false;
    this.isStartingInterval = false;
    this.messageHeartIntervalTime = 5e3;
    this.throttleMessageHeart = throttle(this.messageHeart, this.messageHeartIntervalTime - 500);
    this.terminalData = {};
    this.startLoad = false;
    this.loadend = false;
    this.mqttClient = null;
    this.connectBool = false;
    this.messageHeartInterval = null;
    this.runTaskInstance = null;
    this.webUserId = ``;
    this.webUserName = ``;
    this.webUserAvatarUrl = ``;
    this.macId = ``;
    this.cpuSerialNumber = ``;
    this.runTaskMqttMessage = ``;
    this.chooseCreateTask = null;
    this.loadFromStorage();
  }
  updateParams(params) {
    if (params.retryInterval) this.retryInterval = params.retryInterval;
    if (params.accessToken) this.accessToken = params.accessToken;
    if (params.agentId) this.clientId = params.agentId;
    if (params.clientId) this.clientId = params.clientId;
    if (params.userId) this.userId = params.userId;
  }
  getDisconnectedStatus() {
    if (!this.mqttClient) {
      return true;
    }
    return this.mqttClient.disconnecting;
  }
  connectMqtt() {
    var _a, _b, _c, _d, _e, _f, _g, _h;
    if (!this.url) {
      sendLog(`\u0055\u0052\u004c\u0020\u006d\u0075\u0073\u0074\u0020\u0062\u0065\u0020\u0070\u0072\u006f\u0076\u0069\u0064\u0065\u0064`);
      return;
    }
    if (this.connectBool) {
      sendLog(`\u0043\u006f\u006e\u006e\u0065\u0063\u0074\u0069\u006e\u0067\u0020\u0074\u006f\u0020` + this.connectBool);
      return;
    }
    if (!((_b = (_a = this.terminalData) == null ? void 0 : _a.topic) == null ? void 0 : _b.task_topic)) {
      sendLog(`\u0074\u0068\u0069\u0073\u002e\u0074\u0065\u0072\u006d\u0069\u006e\u0061\u006c\u0044\u0061\u0074\u0061\u003f\u002e\u0074\u006f\u0070\u0069\u0063\u003f\u002e\u0074\u0061\u0073\u006b\u005f\u0074\u006f\u0070\u0069\u0063\u0020\u4e3a\u7a7a`, (_d = (_c = this.terminalData) == null ? void 0 : _c.topic) == null ? void 0 : _d.task_topic);
      return;
    }
    this.connectBool = true;
    sendLog(`\u0063\u006c\u0069\u0065\u006e\u0074\u0056\u0069\u0073\u0069\u0074\u006f\u0072\u0049\u0064\uff1a` + this.clientVisitorId);
    sendLog(`\u0074\u0068\u0069\u0073\u002e\u0074\u0065\u0072\u006d\u0069\u006e\u0061\u006c\u0044\u0061\u0074\u0061\u003f\u002e\u0074\u0065\u0072\u006d\u0069\u006e\u0061\u006c\u0049\u0064`, (_e = this.terminalData) == null ? void 0 : _e.terminalId);
    sendLog(`\u0063\u006c\u0069\u0065\u006e\u0074\u0049\u0064\uff1a` + this.clientId);
    sendLog(`\u0075\u0073\u0065\u0072\u005f\u0069\u0064`, this.userId);
    sendLog(`\u0074\u0065\u006e\u0061\u006e\u0074\u0049\u0064`, this.tenantId);
    sendLog(`\u0074\u0068\u0069\u0073\u002e\u0074\u0065\u0072\u006d\u0069\u006e\u0061\u006c\u0044\u0061\u0074\u0061`, JSON.stringify(this.terminalData));
    this.mqttClient = mqtt.connect(this.url, {
      username: (_f = this.terminalData) == null ? void 0 : _f.mqtt_username,
      password: (_g = this.terminalData) == null ? void 0 : _g.mqtt_password,
      reconnectPeriod: 0,
      // 设置重连间隔为 0，禁用重连
      keepalive: 15,
      // pingInterval: 5000,
      clientId: (_h = this.terminalData) == null ? void 0 : _h.terminalId
    });
    this.mqttClient.on(`\u0063\u006f\u006e\u006e\u0065\u0063\u0074`, () => {
      var _a2, _b2, _c2, _d2;
      sendLog(`\u005b\u004d\u0051\u0054\u0054\u0043\u006f\u006e\u006e\u0065\u0063\u0074\u0069\u006f\u006e\u003a\u003a\u0063\u006f\u006e\u006e\u0065\u0063\u0074\u005d\u0020\u0043\u006f\u006e\u006e\u0065\u0063\u0074\u0065\u0064\u0020\u0074\u006f\u0020${this.url}`);
      if (!this.mqttClient) {
        sendLog(`\u0074\u0068\u0069\u0073\u002e\u006d\u0071\u0074\u0074\u0043\u006c\u0069\u0065\u006e\u0074\u0020\u0069\u0073\u0020\u006e\u0075\u006c\u006c`);
        return;
      }
      sendLog(`\u0074\u0068\u0069\u0073\u002e\u0074\u0065\u0072\u006d\u0069\u006e\u0061\u006c\u0044\u0061\u0074\u0061\u003f\u002e\u0074\u006f\u0070\u0069\u0063\u003f\u002e\u0074\u0061\u0073\u006b\u005f\u0074\u006f\u0070\u0069\u0063`, (_b2 = (_a2 = this.terminalData) == null ? void 0 : _a2.topic) == null ? void 0 : _b2.task_topic);
      this.mqttClient.subscribe((_d2 = (_c2 = this.terminalData) == null ? void 0 : _c2.topic) == null ? void 0 : _d2.task_topic, err => {
        sendLog(`\u0073\u0075\u0062\u0073\u0063\u0072\u0069\u0062\u0065\u0031`, err);
        if (!err) {
          sendLog(`\u0053\u0075\u0062\u0073\u0063\u0072\u0069\u0062\u0065\u0064\u0020\u0074\u006f\u0020\u0074\u006f\u0070\u0069\u0063`);
          this.connectSuccess();
          this.checkRunTaskAndRestartTask();
          chrome.storage.local.set({
            "mqttConnectBool": true
          }, () => {});
          this.startMessageHeartInterval();
        }
      });
    });
    this.mqttClient.on(`\u0072\u0065\u0063\u006f\u006e\u006e\u0065\u0063\u0074`, () => {
      sendLog(`\u005b\u004d\u0051\u0054\u0054\u0043\u006f\u006e\u006e\u0065\u0063\u0074\u0069\u006f\u006e\u003a\u003a\u0072\u0065\u0063\u006f\u006e\u006e\u0065\u0063\u0074\u005d\u0020\u0052\u0065\u0063\u006f\u006e\u006e\u0065\u0063\u0074\u0065\u0064\u0020\u0074\u006f\u0020${this.url}`);
    });
    this.mqttClient.on(`\u006d\u0065\u0073\u0073\u0061\u0067\u0065`, async (topic, message) => {
      sendLog(`\u0074\u006f\u0070\u0069\u0063`, topic);
      const parsedMessage = JSON.parse(message.toString());
      this.onMessageHandlers.forEach(handler => handler(parsedMessage));
    });
    this.mqttClient.on(`\u0063\u006c\u006f\u0073\u0065`, () => {
      sendLog(`\u004d\u0051\u0054\u0054\u0020\u0063\u006f\u006e\u006e\u0065\u0063\u0074\u0069\u006f\u006e\u0020\u0063\u006c\u006f\u0073\u0065\u0064`);
      if (!this.userCloseBool) {
        this.reconnectingMqtt();
      }
    });
    this.mqttClient.on(`\u0065\u0072\u0072\u006f\u0072`, error => {
      console.error(`\u004d\u0051\u0054\u0054\u0020\u0065\u0072\u0072\u006f\u0072\u003a`, error);
      sendLog(`\u004d\u0051\u0054\u0054\u0020\u0065\u0072\u0072\u006f\u0072\u003a`, error);
      if (this.mqttClient) {
        this.mqttClient.end(true, {
          reasonCode: 500,
          properties: {
            reasonString: `\u9519\u8bef\u5904\u7406` + JSON.stringify(error)
          }
        }, () => {
          console.log(`\u0063\u006c\u006f\u0073\u0065\u0020\u0065\u006e\u0064`);
        });
      }
    });
    this.mqttClient.on(`\u0064\u0069\u0073\u0063\u006f\u006e\u006e\u0065\u0063\u0074`, packet => {
      sendLog(`\u0064\u0069\u0073\u0063\u006f\u006e\u006e\u0065\u0063\u0074\u0020\u0074\u0068\u0069\u0073\u002e\u0075\u0073\u0065\u0072\u0043\u006c\u006f\u0073\u0065\u0042\u006f\u006f\u006c`, packet, this.userCloseBool);
      if (!this.userCloseBool) {
        this.reconnectingMqtt();
      }
    });
    this.mqttClient.on(`\u006f\u0066\u0066\u006c\u0069\u006e\u0065`, () => {
      sendLog(`\u006f\u0066\u0066\u006c\u0069\u006e\u0065\u003a\u0020\u0074\u0068\u0069\u0073\u002e\u0075\u0073\u0065\u0072\u0043\u006c\u006f\u0073\u0065\u0042\u006f\u006f\u006c` + this.userCloseBool);
      if (!this.userCloseBool) {
        this.reconnectingMqtt();
      }
    });
  }
  registeMessageFromMQTT(handler) {
    this.onMessageHandlers.push(handler);
  }
  registeDisconnect(handler) {
    this.onDisconnectHandlers.push(handler);
  }
  clearMessageHeartInterval() {
    if (this.messageHeartInterval) {
      clearInterval(this.messageHeartInterval);
      this.messageHeartInterval = null;
    }
  }
  startMessageHeartInterval() {
    if (this.isStartingInterval) return;
    this.isStartingInterval = true;
    this.clearMessageHeartInterval();
    this.messageHeartInterval = setInterval(() => {
      this.throttleMessageHeart(this);
    }, this.messageHeartIntervalTime);
    this.isStartingInterval = false;
  }
  messageHeart(that) {
    var _a, _b, _c, _d;
    if (that && that.mqttClient && that.mqttClient.connected) {
      let heartReportData = (_a = that.runTaskInstance) == null ? void 0 : _a.getHeartReportData();
      if (!heartReportData) {
        heartReportData = {
          runStatus: {
            //运行页面状态
            stopButtonText: `\u6ca1\u6709\u8fd0\u884c\u4efb\u52a1`,
            formattedTime: ``
          }
        };
      }
      heartReportData = {
        ...heartReportData,
        webLoginInfo: {
          // 登录抖音账号的名称
          webUserId: that.webUserId,
          webUserName: that.webUserName,
          webUserAvatarUrl: that.webUserAvatarUrl,
          tenantId: that.tenantId,
          tenantName: that.tenantName,
          pluginName: `\u5ba2\u8d44\u5de5\u5177`,
          userId: that.userId,
          userName: that.userName,
          macId: that.macId,
          cpuSerialNumber: that.cpuSerialNumber
        }
      };
      const postMessage = {
        "s": `\u006f\u006b`,
        "n": (_b = that.terminalData) == null ? void 0 : _b.terminalName,
        "t": (/* @__PURE__ */new Date()).getTime(),
        taskData: heartReportData
      };
      console.log(`\u006d\u0065\u0073\u0073\u0061\u0067\u0065\u0048\u0065\u0061\u0072\u0074`, postMessage);
      that.mqttClient.publish((_d = (_c = that.terminalData) == null ? void 0 : _c.topic) == null ? void 0 : _d.heart_beat_topics, JSON.stringify(postMessage));
    } else {
      console.log(`\u006d\u0071\u0074\u0074\u0043\u006c\u0069\u0065\u006e\u0074\u0020\u6ca1\u6709\u8fde\u63a5\u6210\u529f`);
    }
  }
  connectSuccess() {
    setTimeout(() => {
      var _a, _b, _c;
      try {
        if (this.mqttClient && this.mqttClient.connected) {
          let heartReportData = {
            runStatus: {
              runLogs: `\u004d\u0071\u0074\u0074\u94fe\u63a5\u6210\u529f`,
              //运行页面状态
              stopButtonText: `\u6ca1\u6709\u8fd0\u884c\u4efb\u52a1`,
              formattedTime: ``
            },
            webLoginInfo: {
              // 登录抖音账号的名称
              webUserId: this.webUserId,
              webUserName: this.webUserName,
              webUserAvatarUrl: this.webUserAvatarUrl,
              tenantId: this.tenantId,
              tenantName: this.tenantName,
              pluginName: `\u5ba2\u8d44\u5de5\u5177`,
              userId: this.userId,
              userName: this.userName,
              macId: this.macId,
              cpuSerialNumber: this.cpuSerialNumber
            }
          };
          const postMessage = {
            "s": `\u006f\u006b`,
            "n": (_a = this.terminalData) == null ? void 0 : _a.terminalName,
            "t": (/* @__PURE__ */new Date()).getTime(),
            taskData: heartReportData
          };
          sendLog(`\u0063\u006f\u006e\u006e\u0065\u0063\u0074\u0053\u0075\u0063\u0063\u0065\u0073\u0073\u0020\u006d\u0065\u0073\u0073\u0061\u0067\u0065\u0048\u0065\u0061\u0072\u0074`, JSON.stringify(postMessage));
          this.mqttClient.publish((_c = (_b = this.terminalData) == null ? void 0 : _b.topic) == null ? void 0 : _c.heart_beat_topics, JSON.stringify(postMessage));
        }
      } catch (e) {
        console.log(`\u0063\u006f\u006e\u006e\u0065\u0063\u0074\u0053\u0075\u0063\u0063\u0065\u0073\u0073`, e);
      } finally {
        sendLog(`\u0063\u006f\u006e\u006e\u0065\u0063\u0074\u0053\u0075\u0063\u0063\u0065\u0073\u0073\u0020\u006d\u0065\u0073\u0073\u0061\u0067\u0065\u0048\u0065\u0061\u0072\u0074\u0020\u0065\u006e\u0064`);
      }
    }, 1e3);
  }
  setChooseCreateTask(chooseCreateTask2) {
    this.chooseCreateTask = chooseCreateTask2;
  }
  checkRunTaskAndRestartTask() {
    console.log(`\u0063\u0068\u0065\u0063\u006b\u0052\u0075\u006e\u0054\u0061\u0073\u006b\u0041\u006e\u0064\u0052\u0065\u0073\u0074\u0061\u0072\u0074\u0054\u0061\u0073\u006b`);
    if (this.runTaskMqttMessage && this.chooseCreateTask && false) ;
  }
  messageToReplyMQTT(message) {
    var _a, _b, _c, _d;
    if (this.mqttClient && this.mqttClient.connected) {
      sendLog(`\u0074\u0061\u0073\u006b\u005f\u0072\u0065\u0070\u006c\u0079\u005f\u0074\u006f\u0070\u0069\u0063\u0073\u0020\u006d\u0065\u0073\u0073\u0061\u0067\u0065`, JSON.stringify({
        task_reply_topics: (_b = (_a = this.terminalData) == null ? void 0 : _a.topic) == null ? void 0 : _b.task_reply_topics,
        message
      }));
      this.mqttClient.publish((_d = (_c = this.terminalData) == null ? void 0 : _c.topic) == null ? void 0 : _d.task_reply_topics, JSON.stringify(message));
    } else {
      sendLog(`\u006d\u0071\u0074\u0074\u0043\u006c\u0069\u0065\u006e\u0074\u0020\u6ca1\u6709\u8fde\u63a5\u6210\u529f`);
    }
  }
  messageToStatusMQTT(message) {
    var _a, _b, _c, _d;
    if (this.mqttClient && this.mqttClient.connected) {
      sendLog(`\u0073\u0074\u0061\u0074\u0075\u0073\u005f\u0072\u0065\u0070\u006c\u0079\u005f\u0074\u006f\u0070\u0069\u0063\u0073\u0020\u006d\u0065\u0073\u0073\u0061\u0067\u0065`, JSON.stringify({
        status_reply_topics: (_b = (_a = this.terminalData) == null ? void 0 : _a.topic) == null ? void 0 : _b.status_reply_topics,
        message
      }));
      this.mqttClient.publish((_d = (_c = this.terminalData) == null ? void 0 : _c.topic) == null ? void 0 : _d.status_reply_topics, JSON.stringify(message));
    } else {
      console.log(`\u006d\u0071\u0074\u0074\u0043\u006c\u0069\u0065\u006e\u0074\u0020\u6ca1\u6709\u8fde\u63a5\u6210\u529f`);
    }
  }
  messageToReportMQTT(message) {
    var _a, _b, _c, _d;
    if (this.mqttClient && this.mqttClient.connected) {
      sendLog(`\u0072\u0065\u0070\u006f\u0072\u0074\u005f\u0074\u006f\u0070\u0069\u0063\u0073\u0020\u006d\u0065\u0073\u0073\u0061\u0067\u0065`, JSON.stringify({
        report_topics: (_b = (_a = this.terminalData) == null ? void 0 : _a.topic) == null ? void 0 : _b.report_topics,
        message
      }));
      this.mqttClient.publish((_d = (_c = this.terminalData) == null ? void 0 : _c.topic) == null ? void 0 : _d.report_topics, JSON.stringify(message));
    } else {
      sendLog(`\u006d\u0071\u0074\u0074\u0043\u006c\u0069\u0065\u006e\u0074\u0020\u6ca1\u6709\u8fde\u63a5\u6210\u529f`);
    }
  }
  messageToRunLogsMQTT(message) {
    var _a, _b, _c, _d;
    if (this.mqttClient && this.mqttClient.connected) {
      sendLog(`\u0072\u0075\u006e\u005f\u006c\u006f\u0067\u0073\u005f\u0072\u0065\u0070\u006c\u0079\u005f\u0074\u006f\u0070\u0069\u0063\u0073\u0020\u006d\u0065\u0073\u0073\u0061\u0067\u0065`, JSON.stringify({
        run_logs_reply_topics: (_b = (_a = this.terminalData) == null ? void 0 : _a.topic) == null ? void 0 : _b.run_logs_reply_topics,
        message
      }));
      this.mqttClient.publish((_d = (_c = this.terminalData) == null ? void 0 : _c.topic) == null ? void 0 : _d.run_logs_reply_topics, JSON.stringify(message));
    } else {
      sendLog(`\u006d\u0071\u0074\u0074\u0043\u006c\u0069\u0065\u006e\u0074\u0020\u6ca1\u6709\u8fde\u63a5\u6210\u529f`);
    }
  }
  setRunTaskMqttMessage(runTaskMqttMessage) {
    this.runTaskMqttMessage = runTaskMqttMessage;
    chrome.storage.local.set({
      "runTaskMqttMessage": this.runTaskMqttMessage
    });
  }
  clearRunTaskMqttMessage() {
    this.runTaskMqttMessage = ``;
    chrome.storage.local.set({
      "runTaskMqttMessage": ``
    });
  }
  reconnectingMqtt() {
    if (this.connectBool) {
      this.connectBool = false;
      this.clearMessageHeartInterval();
      chrome.storage.local.set({
        "mqttConnectBool": false
      }, () => {});
      this.mqttClient = null;
      setTimeout(() => {
        this.connectMqtt();
      }, this.retryInterval);
      this.onDisconnectHandlers.forEach(handler => handler());
    } else {
      sendLog(`\u5df2\u7ecf\u5f00\u59cb\u91cd\u65b0\u8fde\u63a5\u4e86`);
    }
  }
  setRunTaskInstance(runTaskInstance) {
    this.runTaskInstance = runTaskInstance;
  }
  //
  // async messageFromTaskToAgent(message:any) {
  //     if(!this.callAgentHandler){
  //         return
  //     }
  //     return this.callAgentHandler(message);
  // }
  // disconnect() {
  //     console.log("disconnect")
  //     if (this.mqttClient && this.mqttClient.connected) {
  //         this.mqttClient.end();
  //     } else {
  //         console.warn("MQTT is already disconnected.");
  //     }
  // }
  // 获取唯一实例的方法
  static getInstance() {
    if (!_MqttManage.instance) {
      _MqttManage.instance = new _MqttManage({
        agentId: VITE_AGENT_ID$5,
        clientId: VITE_PLUGIN_ID
      });
    }
    return _MqttManage.instance;
  }
  closeMqtt() {
    sendLog(`\u0063\u006c\u006f\u0073\u0065\u004d\u0071\u0074\u0074`);
    if (this.mqttClient) {
      this.userCloseBool = true;
      this.mqttClient.end(true, {
        reasonCode: 500,
        properties: {
          reasonString: `\u7528\u6237\u9000\u51fa`
        }
      }, () => {
        sendLog(`\u0063\u006c\u006f\u0073\u0065\u004d\u0071\u0074\u0074\u0020\u0063\u006c\u006f\u0073\u0065\u0020\u0065\u006e\u0064`);
      });
    }
  }
  loadFromStorage() {
    if (this.startLoad) {
      sendLog(`\u0073\u0074\u0061\u0072\u0074\u004c\u006f\u0061\u0064`, this.startLoad);
      return;
    }
    this.startLoad = true;
    chrome.storage.local.get([`\u0075\u0073\u0065\u0072\u0049\u0064`, `\u0075\u0073\u0065\u0072\u004e\u0061\u006d\u0065`, `\u0074\u0065\u006e\u0061\u006e\u0074\u0049\u0064`, `\u0074\u0065\u006e\u0061\u006e\u0074\u004e\u0061\u006d\u0065`, `\u0063\u006c\u0069\u0065\u006e\u0074\u0056\u0069\u0073\u0069\u0074\u006f\u0072\u0049\u0064`, `\u0061\u0063\u0063\u0065\u0073\u0073\u0054\u006f\u006b\u0065\u006e`, `\u0074\u0065\u0072\u006d\u0069\u006e\u0061\u006c\u0044\u0061\u0074\u0061`, `\u0077\u0065\u0062\u0055\u0073\u0065\u0072\u0049\u0064`, `\u0077\u0065\u0062\u0055\u0073\u0065\u0072\u004e\u0061\u006d\u0065`, `\u0077\u0065\u0062\u0055\u0073\u0065\u0072\u0041\u0076\u0061\u0074\u0061\u0072\u0055\u0072\u006c`, `\u006d\u0061\u0063\u0049\u0064`, `\u0063\u0070\u0075\u0053\u0065\u0072\u0069\u0061\u006c\u004e\u0075\u006d\u0062\u0065\u0072`, `\u0072\u0075\u006e\u0054\u0061\u0073\u006b\u004d\u0071\u0074\u0074\u004d\u0065\u0073\u0073\u0061\u0067\u0065`], result => {
      console.log(`\u0072\u0065\u0073\u0075\u006c\u0074\u0020\u0061\u0063\u0074\u0069\u0076\u0061\u0074\u0065\u0050\u0061\u0067\u0065`, result);
      if (result.userId !== void 0) {
        this.userId = result.userId;
      }
      if (result.userName !== void 0) {
        this.userName = result.userName;
      }
      if (result.tenantId !== void 0) {
        this.tenantId = result.tenantId;
      }
      if (result.tenantName !== void 0) {
        this.tenantName = result.tenantName;
      }
      if (result.clientVisitorId !== void 0) {
        this.clientVisitorId = result.clientVisitorId;
      }
      if (result.accessToken !== void 0) {
        this.accessToken = result.accessToken;
      }
      if (result.terminalData !== void 0) {
        this.terminalData = result.terminalData == `` ? {} : JSON.parse(result.terminalData);
      }
      if (this.userId && this.tenantId && this.terminalData && this.terminalData.terminalId) {
        this.connectMqtt();
      }
      if (result.webUserId !== void 0) {
        this.webUserId = result.webUserId;
      }
      if (result.webUserName !== void 0) {
        this.webUserName = result.webUserName;
      }
      if (result.webUserAvatarUrl !== void 0) {
        this.webUserAvatarUrl = result.webUserAvatarUrl;
      }
      if (result.macId !== void 0) {
        this.macId = result.macId;
      }
      if (result.cpuSerialNumber !== void 0) {
        this.cpuSerialNumber = result.cpuSerialNumber;
      }
      if (result.runTaskMqttMessage !== void 0) {
        this.runTaskMqttMessage = result.runTaskMqttMessage;
      }
      this.startLoad = true;
      this.loadend = true;
    });
    storageUtil.removeListener(this.callBackHandler);
    storageUtil.addHandlers(this.callBackHandler);
  }
};
__publicField(_MqttManage, `\u0069\u006e\u0073\u0074\u0061\u006e\u0063\u0065`);
let MqttManage = _MqttManage;
const mqttManage = MqttManage.getInstance();
class AsyncTaskQueue {
  constructor(concurrency) {
    __publicField(this, `\u0063\u006f\u006e\u0063\u0075\u0072\u0072\u0065\u006e\u0063\u0079`);
    __publicField(this, `\u0072\u0075\u006e\u006e\u0069\u006e\u0067`, 0);
    __publicField(this, `\u0074\u0061\u0073\u006b\u0051\u0075\u0065\u0075\u0065`, []);
    this.concurrency = concurrency;
  }
  // 添加任务到队列，如果没有空余并发数则阻塞
  async enqueue(task) {
    if (this.running >= this.concurrency) {
      await new Promise(resolve => {
        this.taskQueue.push(() => {
          this.runTask(task);
          resolve();
        });
      });
    } else {
      this.runTask(task).then(() => {});
    }
  }
  // 执行任务，并控制并发数
  async runTask(task) {
    this.running++;
    try {
      await task();
    } finally {
      this.running--;
      if (this.taskQueue.length > 0) {
        const nextTask = this.taskQueue.shift();
        nextTask();
      }
    }
  }
  // 等待所有任务完成
  async waitForAll() {
    return new Promise(resolve => {
      const checkFinished = () => {
        if (this.running === 0 && this.taskQueue.length === 0) {
          resolve();
        } else {
          setTimeout(checkFinished, 50);
        }
      };
      checkFinished();
    });
  }
}
class TaskManager {
  constructor() {
    __publicField(this, `\u0074\u0061\u0073\u006b\u0051\u0075\u0065\u0075\u0065`);
    __publicField(this, `\u0065\u0078\u0065\u0063\u0075\u0074\u0065\u0051\u0075\u0065\u0075\u0065`);
    __publicField(this, `\u0065\u0078\u0065\u0063\u0075\u0074\u0065\u004e\u006f\u0074\u0069\u0066\u0069\u0063\u0061\u0074\u0069\u006f\u006e`);
    __publicField(this, `\u0065\u0078\u0065\u0063\u0075\u0074\u0065\u0053\u0074\u0061\u0072\u0074\u0042\u006f\u006f\u006c`);
    __publicField(this, `\u0074\u0061\u0073\u006b\u004d\u0061\u0070`);
    this.taskQueue = [];
    this.executeNotification = null;
    this.executeQueue = new AsyncTaskQueue(1);
    this.executeStartBool = true;
    this.taskMap = {};
    this.executeStart().then(() => {});
  }
  async executeStart() {
    while (this.executeStartBool) {
      if (this.taskQueue.length === 0) {
        sendLog(`\u7b49\u5f85\u4e0b\u4e00\u4e2a\u4efb\u52a1`);
        this.executeNotification = null;
        if (this.taskQueue.length === 0) {
          await this.startNotification();
        }
      }
      while (this.executeStartBool) {
        if (this.taskQueue.length > 0) {
          const nextTask = this.taskQueue.shift();
          this.taskMap[nextTask.taskId] = nextTask;
          const openNewWindowNote = () => {
            return () => new Promise(async resolve => {
              try {
                sendLog(`\u4efb\u52a1\u006e\u0065\u0078\u0074\u0054\u0061\u0073\u006b\u002e\u0074\u0061\u0073\u006b\u0049\u0064\uff1a`, nextTask.taskId);
                await nextTask.start();
                await nextTask.executeEnd();
                sendLog(`\u4efb\u52a1\u5b8c\u6210\u006e\u0065\u0078\u0074\u0054\u0061\u0073\u006b\u002e\u0074\u0061\u0073\u006b\u0049\u0064\uff1a`, nextTask.taskId);
                resolve();
              } catch (error) {
                sendLog(`\u006f\u0070\u0065\u006e\u004e\u0065\u0077\u0057\u0069\u006e\u0064\u006f\u0077\u004e\u006f\u0074\u0065\u0020\u0065\u0072\u0072\u006f\u0072`, error, nextTask.taskId);
                resolve();
              }
            });
          };
          await this.executeQueue.enqueue(openNewWindowNote());
          sendLog(`\u0065\u0078\u0065\u0063\u0075\u0074\u0065\u0051\u0075\u0065\u0075\u0065\u002e\u0065\u006e\u0071\u0075\u0065\u0075\u0065\u0020\u5b8c\u6210`);
          await this.executeQueue.waitForAll();
          sendLog(`\u0065\u0078\u0065\u0063\u0075\u0074\u0065\u0051\u0075\u0065\u0075\u0065\u002e\u0077\u0061\u0069\u0074\u0046\u006f\u0072\u0041\u006c\u006c\u0020\u5b8c\u6210`);
        } else {
          break;
        }
      }
    }
    await this.executeQueue.waitForAll();
  }
  /**
   * 等待新数据加入
   */
  startNotification() {
    return new Promise(resolve => {
      this.executeNotification = resolve;
    });
  }
  /**
   * 加入数据
   * @param baseTask
   */
  async addTask(baseTask) {
    if (!baseTask.checkConfig()) {
      sendLog(`\u68c0\u67e5\u4efb\u52a1\u914d\u7f6e\u9519\u8bef\uff0c\u4e0d\u6dfb\u52a0\u5230\u961f\u5217`);
      return;
    }
    if (this.taskQueue.length > 0) {
      sendLog(`\u961f\u5217\u4e2d\u5b58\u5728\u5176\u4ed6\u4efb\u52a1`);
      for (let i = 0; i < this.taskQueue.length; i++) {
        sendLog(`\u0074\u0068\u0069\u0073\u002e\u0074\u0061\u0073\u006b\u0051\u0075\u0065\u0075\u0065\u005b\u0069\u005d\u002e\u0074\u0061\u0073\u006b\u0049\u0064`, this.taskQueue[i].taskId);
        sendLog(`\u0074\u0068\u0069\u0073\u002e\u0074\u0061\u0073\u006b\u0051\u0075\u0065\u0075\u0065\u005b\u0069\u005d\u002e\u0065\u0078\u0065\u0063\u0075\u0074\u0065\u0049\u0064`, this.taskQueue[i].executeId);
        sendLog(`\u0074\u0068\u0069\u0073\u002e\u0074\u0061\u0073\u006b\u0051\u0075\u0065\u0075\u0065\u005b\u0069\u005d\u002e\u0064\u0061\u0074\u0061`, JSON.stringify(this.taskQueue[i].data));
      }
    }
    console.log(`\u5c06\u4efb\u52a1\u6dfb\u52a0\u5230\u961f\u5217\u4e2d`);
    sendLog(`\u0062\u0061\u0073\u0065\u0054\u0061\u0073\u006b\u002e\u0074\u0061\u0073\u006b\u0049\u0064`, baseTask.taskId);
    sendLog(`\u0062\u0061\u0073\u0065\u0054\u0061\u0073\u006b\u002e\u0065\u0078\u0065\u0063\u0075\u0074\u0065\u0049\u0064`, baseTask.executeId);
    sendLog(`\u0062\u0061\u0073\u0065\u0054\u0061\u0073\u006b\u002e\u0064\u0061\u0074\u0061`, JSON.stringify(baseTask.data));
    this.taskQueue.push(baseTask);
    if (this.executeNotification != null) {
      sendLog(`\u901a\u77e5\u5f00\u59cb\u6267\u884c\u4efb\u52a1`);
      this.executeNotification();
      this.executeNotification = null;
    }
  }
  /**
   * 停止任务
   * @param taskId
   */
  async stopTask(taskId) {
    console.log(`\u0074\u0068\u0069\u0073\u002e\u0074\u0061\u0073\u006b\u004d\u0061\u0070`, this.taskMap);
    sendLog(`\u0074\u0068\u0069\u0073\u002e\u0074\u0061\u0073\u006b\u004d\u0061\u0070\u003a` + taskId);
    console.log(`\u0074\u0068\u0069\u0073\u002e\u0074\u0061\u0073\u006b\u004d\u0061\u0070\u005b\u0074\u0061\u0073\u006b\u0049\u0064\u005d`, this.taskMap[taskId]);
    if (this.taskMap && taskId && this.taskMap[taskId]) {
      const baseTask = this.taskMap[taskId];
      await baseTask.stopTask();
      await baseTask.checkIfTabExists();
      console.log(`\u0073\u0074\u006f\u0070\u0054\u0061\u0073\u006b`, taskId);
      return baseTask.tabId;
    }
    return 0;
  }
  /**
   * 上传报告
   * @param taskId
   */
  async report(taskId) {
    sendLog(`\u0072\u0065\u0070\u006f\u0072\u0074`);
    if (this.taskMap && taskId && this.taskMap[taskId]) {
      const baseTask = this.taskMap[taskId];
      sendLog(`\u0072\u0065\u0070\u006f\u0072\u0074\u0020\u0070\u0072\u0065`);
      await baseTask.report();
      sendLog(`\u0072\u0065\u0070\u006f\u0072\u0074\u0020\u0070\u006f\u0073\u0074`);
    }
  }
  /**
   * 窗口都关闭， 任务结束
   * @param taskId
   */
  async abortTask(taskId) {
    var _a;
    if (this.taskMap && taskId && this.taskMap[taskId]) {
      const baseTask = this.taskMap[taskId];
      (_a = baseTask.conn) == null ? void 0 : _a.clearRunTaskMqttMessage();
      await baseTask.abortTask();
      delete this.taskMap[taskId];
    }
  }
  /**
   * 主动停止正在运行的任务
   */
  async stopRunTasks(stopTaskBool) {
    if (this.taskMap && stopTaskBool) {
      console.log(`\u0073\u0074\u006f\u0070\u0052\u0075\u006e\u0054\u0061\u0073\u006b\u0073\u0020`, formatNowDateTimeSss(), stopTaskBool);
      const keys = Object.keys(this.taskMap);
      if (keys && keys.length > 0) {
        for (let i = 0; i < keys.length; i++) {
          sendLog(`\u0073\u0074\u006f\u0070\u0052\u0075\u006e\u0054\u0061\u0073\u006b\u0073\u002c\u0020\u0074\u0061\u0073\u006b\u0049\u0064\u003a`, keys[i]);
          const tabId = await this.stopTask(keys[i]);
          console.log(`\u0074\u0061\u0062\u0049\u0064`, tabId);
          if (tabId) {
            for (let i2 = 0; i2 < 10; i2++) {
              await delay(1e3);
              if (!this.taskMap[keys[i2]]) {
                break;
              }
            }
          }
          await this.abortTask(keys[i]);
          console.log(`\u0073\u0074\u006f\u0070\u0052\u0075\u006e\u0054\u0061\u0073\u006b\u0073`, keys[i]);
        }
      }
    }
    console.log(`\u0073\u0074\u006f\u0070\u0052\u0075\u006e\u0054\u0061\u0073\u006b\u0073\u0020\u0065\u006e\u0064`);
  }
  destroy() {
    this.executeStartBool = false;
  }
}
class BaseTask {
  constructor(taskId, executeId, data) {
    __publicField(this, `\u0077\u0069\u006e\u0064\u006f\u0077\u0049\u0064`);
    __publicField(this, `\u0074\u0061\u0062\u0049\u0064`);
    __publicField(this, `\u0074\u0061\u0073\u006b\u0049\u0064`);
    __publicField(this, `\u0063\u006c\u0069\u0065\u006e\u0074\u0049\u0064`);
    __publicField(this, `\u0074\u006f\u006b\u0065\u006e`);
    __publicField(this, `\u0064\u0061\u0074\u0061`);
    __publicField(this, `\u0072\u0075\u006e\u006e\u0069\u006e\u0067`);
    __publicField(this, `\u0070\u0061\u0075\u0073\u0065\u0064`);
    __publicField(this, `\u0073\u0074\u0061\u0072\u0074\u0065\u0064`);
    __publicField(this, `\u0075\u0073\u0065\u0072\u005f\u0069\u0064`);
    __publicField(this, `\u006f\u0072\u0067\u0049\u0064`);
    __publicField(this, `\u0063\u006c\u0069\u0065\u006e\u0074\u0056\u0069\u0073\u0069\u0074\u006f\u0072\u0049\u0064`);
    __publicField(this, `\u0061\u0063\u0063\u0065\u0073\u0073\u0054\u006f\u006b\u0065\u006e`);
    __publicField(this, `\u0065\u0078\u0065\u0063\u0075\u0074\u0065\u005f\u0069\u006e\u0064\u0065\u0078`);
    __publicField(this, `\u0064\u0061\u0074\u0061\u005f\u006c\u0069\u0073\u0074`);
    __publicField(this, `\u0063\u006f\u006e\u006e`);
    __publicField(this, `\u0065\u0078\u0065\u0063\u0075\u0074\u0065\u0049\u0064`);
    __publicField(this, `\u0065\u0078\u0065\u0063\u0075\u0074\u0065\u004e\u006f\u0074\u0069\u0066\u0069\u0063\u0061\u0074\u0069\u006f\u006e`);
    __publicField(this, `\u0062\u0061\u0073\u0065\u0053\u0074\u0061\u0072\u0074\u004c\u006f\u0061\u0064`);
    __publicField(this, `\u0062\u0061\u0073\u0065\u004c\u006f\u0061\u0064\u0065\u006e\u0064`);
    __publicField(this, `\u0074\u0065\u0072\u006d\u0069\u006e\u0061\u006c\u0044\u0061\u0074\u0061`);
    __publicField(this, `\u0072\u0075\u006e\u004c\u006f\u0067\u0073`);
    __publicField(this, `\u0073\u0074\u006f\u0070\u0042\u0075\u0074\u0074\u006f\u006e\u0054\u0065\u0078\u0074`);
    __publicField(this, `\u0066\u006f\u0072\u006d\u0061\u0074\u0074\u0065\u0064\u0054\u0069\u006d\u0065`);
    // async callAgent(cmd:any) {
    //     if (!this.running) {
    //         throw new Error("Task is not running or paused.");
    //     }
    //
    //     while (this.paused) {
    //         await new Promise((resolve) => setTimeout(resolve, 100));
    //     }
    //     return await this.conn.messageFromTaskToAgent(cmd);
    // }
    __publicField(this, `\u0072\u0065\u0070\u006f\u0072\u0074\u0052\u0075\u006e\u004c\u006f\u0067\u0073`, async () => {
      var _a;
      console.log(`\u0072\u0065\u0070\u006f\u0072\u0074\u0052\u0075\u006e\u004c\u006f\u0067\u0073`);
      if (!this.conn) {
        return;
      }
      console.log(`\u0072\u0075\u006e\u004c\u006f\u0067\u0073\uff1a`, this.runLogs);
      this.conn.messageToRunLogsMQTT({
        "taskId": this.taskId,
        "data": this.runLogs,
        "userId": this.user_id,
        "terminalId": (_a = this.terminalData) == null ? void 0 : _a.terminalId
      });
      this.conn.messageHeart(this.conn);
    });
    __publicField(this, `\u0062\u0061\u0073\u0065\u0043\u0061\u006c\u006c\u0042\u0061\u0063\u006b\u004c\u0069\u0073\u0074\u0065\u006e\u0065\u0072`, (changes, namespace) => {
      for (let [key, {
        oldValue,
        newValue
      }] of Object.entries(changes)) {
        console.log(`\u0063\u0075\u0073\u0074\u006f\u006d\u0069\u007a\u0065\u0054\u0061\u0073\u006b\u0020\u0053\u0074\u006f\u0072\u0061\u0067\u0065\u0020\u006b\u0065\u0079\u0020\u0022${key}\u0022\u0020\u0069\u006e\u0020\u006e\u0061\u006d\u0065\u0073\u0070\u0061\u0063\u0065\u0020\u0022${namespace}\u0022\u0020\u0063\u0068\u0061\u006e\u0067\u0065\u0064\u002e`, `\u004f\u006c\u0064\u0020\u0076\u0061\u006c\u0075\u0065\u0020\u0077\u0061\u0073\u0020\u0022${oldValue}\u0022\u002c\u0020\u006e\u0065\u0077\u0020\u0076\u0061\u006c\u0075\u0065\u0020\u0069\u0073\u0020\u0022${newValue}\u0022\u002e`);
        switch (key) {
          case `\u006f\u0072\u0067\u0049\u0064`:
            this.orgId = newValue;
            break;
          case `\u0075\u0073\u0065\u0072\u0049\u0064`:
            this.user_id = newValue;
            break;
          case `\u0063\u006c\u0069\u0065\u006e\u0074\u0056\u0069\u0073\u0069\u0074\u006f\u0072\u0049\u0064`:
            this.clientVisitorId = newValue;
            break;
          case `\u0061\u0063\u0063\u0065\u0073\u0073\u0054\u006f\u006b\u0065\u006e`:
            this.accessToken = newValue;
            break;
          case `\u0074\u0065\u0072\u006d\u0069\u006e\u0061\u006c\u0044\u0061\u0074\u0061`:
            this.terminalData = newValue == `` ? {} : JSON.parse(newValue);
            break;
          case `\u0072\u0075\u006e\u004c\u006f\u0067\u0073`:
            this.runLogs = newValue;
            this.reportRunLogs().then();
            break;
          case `\u0073\u0074\u006f\u0070\u0042\u0075\u0074\u0074\u006f\u006e\u0054\u0065\u0078\u0074`:
            this.stopButtonText = newValue;
            break;
          case `\u0066\u006f\u0072\u006d\u0061\u0074\u0074\u0065\u0064\u0054\u0069\u006d\u0065`:
            this.formattedTime = newValue;
            break;
        }
      }
    });
    this.taskId = taskId;
    this.windowId = 0;
    this.tabId = 0;
    this.clientId = null;
    this.token = null;
    this.data = data;
    this.running = false;
    this.paused = false;
    this.started = false;
    this.user_id = null;
    this.orgId = ``;
    this.clientVisitorId = ``;
    this.accessToken = ``;
    this.execute_index = 0;
    this.data_list = [];
    this.conn = null;
    this.executeId = executeId;
    this.executeNotification = null;
    this.terminalData = {};
    this.baseStartLoad = false;
    this.baseLoadend = false;
    this.runLogs = ``;
    this.stopButtonText = ``;
    this.formattedTime = ``;
    this.baseLoadFromStorage();
  }
  setConn(conn) {
    this.conn = conn;
    this.clientId = this.conn.clientId;
    this.token = this.conn.accessToken;
    this.user_id = this.conn.userId;
    this.conn.setRunTaskInstance(this);
  }
  async start() {
    if (this.running) return;
    this.started = true;
    this.running = true;
    this.paused = false;
    sendLog(`\u0054\u0061\u0073\u006b\u0020\u0073\u0074\u0061\u0072\u0074\u0065\u0064`);
    if (!this.conn) {
      return;
    }
    this.conn.messageToReplyMQTT({
      "taskId": this.taskId,
      "executeId": this.executeId,
      "status": `\u0073\u0074\u0061\u0072\u0074\u0065\u0064`,
      "meta": {},
      "message": `\u51c6\u5907\u6267\u884c`
    });
    try {
      await this.startTask();
      this.conn.setRunTaskInstance(this);
    } catch (e) {
      console.error(e);
      this.conn.setRunTaskInstance(null);
      this.conn.messageToReplyMQTT({
        "taskId": this.taskId,
        "executeId": this.executeId,
        "status": `\u0066\u0061\u0069\u006c\u0065\u0064`,
        "meta": this.getBaseStatus(),
        "message": `\u6267\u884c\u51fa\u9519\uff1a` + e
      });
    }
    this.running = false;
  }
  pause() {
    if (!this.running) return;
    this.paused = true;
    sendLog(`\u0054\u0061\u0073\u006b\u0020\u0070\u0061\u0075\u0073\u0065\u0064`);
    if (!this.conn) {
      return;
    }
    this.conn.messageToReplyMQTT({
      "taskId": this.taskId,
      "executeId": this.executeId,
      "status": `\u0072\u0075\u006e\u006e\u0069\u006e\u0067`,
      "meta": this.getBaseStatus(),
      "message": `\u5df2\u6682\u505c`
    });
  }
  async resume() {
    if (!this.running || !this.paused) return;
    if (!this.conn) {
      return;
    }
    this.paused = false;
    sendLog(`\u0054\u0061\u0073\u006b\u0020\u0072\u0065\u0073\u0075\u006d\u0065\u0064`);
    this.conn.messageToReplyMQTT({
      "taskId": this.taskId,
      "executeId": this.executeId,
      "status": `\u0072\u0075\u006e\u006e\u0069\u006e\u0067`,
      "meta": this.getBaseStatus(),
      "message": `\u5df2\u6062\u590d`
    });
    await this.startTask();
  }
  baseReportStop() {
    storageUtil.removeListener(this.baseCallBackListener);
  }
  /**
   * 通知执行任务完成，可以开始下一个任务
   */
  callExecuteNotification() {
    if (this.executeNotification) {
      this.executeNotification();
    }
  }
  getBaseStatus() {
    return {
      id: this.taskId,
      running: this.running,
      paused: this.paused,
      started: this.started,
      data: JSON.parse(JSON.stringify(this.data)),
      data_list: JSON.parse(JSON.stringify(this.data_list)),
      process: 0,
      execute_index: this.execute_index
    };
  }
  /**
   * 等待执行完成
   */
  executeEnd() {
    return new Promise(resolve => {
      this.executeNotification = resolve;
    });
  }
  checkIfTabExists() {
    return new Promise(resolve => {
      let checkIfTabExistsSetInterval = null;
      if (this.tabId !== 0 && this.tabId > 0 && this.windowId !== 0 && this.windowId > 0) {
        let maxNum = 10;
        let num = 0;
        checkIfTabExistsSetInterval = setInterval(() => {
          num++;
          if (num > maxNum) {
            clearInterval(checkIfTabExistsSetInterval);
            resolve(false);
          }
          chrome.tabs.query({
            windowId: this.windowId
          }, tabs => {
            let tabExists = tabs.some(tab => tab.id === this.tabId);
            if (!tabExists) {
              clearInterval(checkIfTabExistsSetInterval);
              resolve(true);
            } else {
              console.error(`\u7a97\u53e3\u8fd8\u5b58\u5728`);
            }
          });
        }, 3 * 1e3);
      } else {
        resolve(false);
      }
    });
  }
  // Helper function to add the authorization header (assumed to be implemented in your extension)
  addAuthorizationHeader() {
    return {
      Authorization: `\u0042\u0065\u0061\u0072\u0065\u0072\u0020${this.token}`
    };
  }
  baseLoadFromStorage() {
    if (this.baseStartLoad) {
      console.log(`\u0073\u0074\u0061\u0072\u0074\u004c\u006f\u0061\u0064`, this.baseStartLoad);
      return;
    }
    this.baseStartLoad = true;
    chrome.storage.local.get([`\u0074\u0065\u0072\u006d\u0069\u006e\u0061\u006c\u0044\u0061\u0074\u0061`, `\u0075\u0073\u0065\u0072\u0049\u0064`, `\u006f\u0072\u0067\u0049\u0064`, `\u0063\u006c\u0069\u0065\u006e\u0074\u0056\u0069\u0073\u0069\u0074\u006f\u0072\u0049\u0064`, `\u0061\u0063\u0063\u0065\u0073\u0073\u0054\u006f\u006b\u0065\u006e`, `\u0072\u0075\u006e\u004c\u006f\u0067\u0073`, `\u0073\u0074\u006f\u0070\u0042\u0075\u0074\u0074\u006f\u006e\u0054\u0065\u0078\u0074`, `\u0066\u006f\u0072\u006d\u0061\u0074\u0074\u0065\u0064\u0054\u0069\u006d\u0065`], result => {
      console.log(`\u0072\u0065\u0073\u0075\u006c\u0074\u0020\u0061\u0063\u0074\u0069\u0076\u0061\u0074\u0065\u0050\u0061\u0067\u0065`, result);
      if (!result) {
        return;
      }
      if (result.userId !== void 0) {
        this.user_id = result.userId;
      }
      if (result.orgId !== void 0) {
        this.orgId = result.orgId;
      }
      if (result.clientVisitorId !== void 0) {
        this.clientVisitorId = result.clientVisitorId;
      }
      if (result.accessToken !== void 0) {
        this.accessToken = result.accessToken;
      }
      if (result.terminalData !== void 0) {
        this.terminalData = result.terminalData == `` ? {} : JSON.parse(result.terminalData);
      }
      if (result.stopButtonText !== void 0) {
        this.stopButtonText = result.stopButtonText;
      }
      if (result.formattedTime !== void 0) {
        this.formattedTime = result.formattedTime;
      }
      this.baseStartLoad = true;
      this.baseLoadend = true;
    });
    storageUtil.addHandlers(this.baseCallBackListener);
  }
}
const VITE_CONTENT_API$9 = `\u0068\u0074\u0074\u0070\u0073\u003a\u002f\u002f\u0061\u0067\u0065\u006e\u0074\u002d\u006e\u0065\u0074\u002e\u0070\u0061\u0069\u0074\u006f\u006e\u0067\u0061\u0069\u002e\u006e\u0065\u0074\u002f\u0063\u006f\u006e\u0074\u0065\u006e\u0074`;
const store$f = UseCounterStore.getInstance();
class XiaohongshuTask extends BaseTask {
  constructor(taskId, executeId, data, executeTask2) {
    super(taskId, executeId, data);
    __publicField(this, `\u0065\u0078\u0065\u0063\u0075\u0074\u0065\u0054\u0061\u0073\u006b`);
    //评论数量
    __publicField(this, `\u0078\u0068\u0073\u005f\u0076\u0069\u0065\u0077\u0043\u006f\u0075\u006e\u0074`);
    __publicField(this, `\u0078\u0068\u0073\u005f\u0043\u006f\u006d\u006d\u0065\u006e\u0074\u0043\u006f\u0075\u006e\u0074`);
    __publicField(this, `\u0078\u0068\u0073\u005f\u006c\u0069\u006b\u0065\u0043\u006f\u0075\u006e\u0074`);
    __publicField(this, `\u0078\u0068\u0073\u005f\u0066\u006f\u006c\u006c\u006f\u0077\u0043\u006f\u0075\u006e\u0074`);
    __publicField(this, `\u0078\u0068\u0073\u005f\u0063\u006f\u006c\u006c\u0065\u0063\u0074\u0043\u006f\u0075\u006e\u0074`);
    //评论数量
    __publicField(this, `\u0064\u0079\u005f\u0076\u0069\u0065\u0077\u0043\u006f\u0075\u006e\u0074`);
    __publicField(this, `\u0064\u0079\u005f\u0043\u006f\u006d\u006d\u0065\u006e\u0074\u0043\u006f\u0075\u006e\u0074`);
    __publicField(this, `\u0064\u0079\u005f\u006c\u0069\u006b\u0065\u0043\u006f\u0075\u006e\u0074`);
    __publicField(this, `\u0064\u0079\u005f\u0066\u006f\u006c\u006c\u006f\u0077\u0043\u006f\u0075\u006e\u0074`);
    __publicField(this, `\u0064\u0079\u005f\u0063\u006f\u006c\u006c\u0065\u0063\u0074\u0043\u006f\u0075\u006e\u0074`);
    __publicField(this, `\u0074\u0061\u0073\u006b\u0050\u006c\u0061\u0074\u0066\u006f\u0072\u006d`);
    __publicField(this, `\u0058\u0069\u0061\u006f\u0048\u006f\u006e\u0067\u0053\u0068\u0075\u005f\u0053\u0065\u0074\u0074\u0069\u006e\u0067`);
    __publicField(this, `\u006f\u0070\u0065\u0072\u0061\u0074\u0069\u006f\u006e\u0054\u0069\u006d\u0065`);
    __publicField(this, `\u0072\u0075\u006e\u004d\u0069\u006e\u0075\u0074\u0065\u0054\u0069\u006d\u0065`);
    __publicField(this, `\u0073\u0074\u0061\u0072\u0074\u004c\u006f\u0061\u0064`);
    __publicField(this, `\u006c\u006f\u0061\u0064\u0065\u006e\u0064`);
    // 上报数据
    __publicField(this, `\u0065\u0078\u0065\u0063\u0075\u0074\u0065\u004f\u0070\u0065\u0072\u0061\u0074\u0069\u006f\u006e\u0053\u0074\u0061\u0072\u0074\u0054\u0069\u006d\u0065`);
    __publicField(this, `\u0065\u0078\u0065\u0063\u0075\u0074\u0065\u004f\u0070\u0065\u0072\u0061\u0074\u0069\u006f\u006e\u0045\u006e\u0064\u0054\u0069\u006d\u0065`);
    __publicField(this, `\u0078\u0068\u0073\u005f\u006b\u0065\u0079\u0077\u006f\u0072\u0064\u0073\u005f\u006c\u0069\u0073\u0074`);
    __publicField(this, `\u0064\u006f\u0075\u0059\u0069\u006e\u005f\u006b\u0065\u0079\u0077\u006f\u0072\u0064\u0073\u005f\u006c\u0069\u0073\u0074`);
    __publicField(this, `\u0078\u0068\u0073\u005f\u006d\u0069\u006e\u0075\u0074\u0065`);
    __publicField(this, `\u0064\u0079\u005f\u006d\u0069\u006e\u0075\u0074\u0065`);
    __publicField(this, `\u0072\u0065\u0070\u006f\u0072\u0074\u0052\u0075\u006e\u0044\u0061\u0074\u0061\u0053\u0074\u0061\u0074\u0075\u0073`, async () => {
      var _a;
      console.log(`\u0072\u0065\u0070\u006f\u0072\u0074\u0052\u0075\u006e\u0044\u0061\u0074\u0061\u0053\u0074\u0061\u0074\u0075\u0073`);
      if (!this.conn) {
        return;
      }
      const runData = this.getRunData();
      console.log(`\u0072\u0075\u006e\u0044\u0061\u0074\u0061`, JSON.stringify(runData));
      this.conn.messageToStatusMQTT({
        "taskId": this.taskId,
        "data": runData,
        "userId": this.user_id,
        "terminalId": (_a = this.terminalData) == null ? void 0 : _a.terminalId
      });
    });
    __publicField(this, `\u0072\u0065\u0070\u006f\u0072\u0074\u0052\u0075\u006e\u0044\u0061\u0074\u0061`, async () => {
      var _a;
      const url = VITE_CONTENT_API$9 + `\u002f\u0061\u0070\u0069\u002f\u0063\u006f\u006e\u0074\u0065\u006e\u0074\u002f`;
      const headers = {
        "Content-Type": `\u0061\u0070\u0070\u006c\u0069\u0063\u0061\u0074\u0069\u006f\u006e\u002f\u006a\u0073\u006f\u006e`,
        ...this.addAuthorizationHeader()
        // Ensure this function works in the extension
      };
      try {
        console.log(`\u0072\u0065\u0070\u006f\u0072\u0074\u0052\u0075\u006e\u0044\u0061\u0074\u0061`);
        const runData = this.getRunData();
        console.log(`\u0072\u0075\u006e\u0044\u0061\u0074\u0061`, JSON.stringify(runData));
        const postData = {
          "taskId": this.taskId,
          "data": runData,
          "userId": this.user_id,
          "terminalId": (_a = this.terminalData) == null ? void 0 : _a.terminalId
        };
        const response = await fetch(url, {
          method: `\u0050\u004f\u0053\u0054`,
          headers,
          body: JSON.stringify(postData)
        });
        if (!response.ok) {
          console.log(`\u0075\u0072\u006c\u003a` + url + `\uff0c\u0068\u0065\u0061\u0064\u0065\u0072\u003a` + JSON.stringify(headers) + `\u002c\u0020\u0072\u0065\u0073\u0070\u006f\u006e\u0073\u0065\u0020\u0073\u0074\u0061\u0074\u0075\u0073\u003a` + response.status);
          return;
        }
        const result = await response.json();
        console.log(`\u0075\u0072\u006c\u003a` + url + `\uff0c\u0068\u0065\u0061\u0064\u0065\u0072\u003a` + JSON.stringify(headers) + `\u002c\u0070\u006f\u0073\u0074\u0044\u0061\u0074\u0061\uff1a` + JSON.stringify(postData) + `\u0020\u0072\u0065\u0073\u0070\u006f\u006e\u0073\u0065\u0020\u0073\u0074\u0061\u0074\u0075\u0073\u003a` + response.status + `\u002c\u0020\u0072\u0065\u0073\u0070\u006f\u006e\u0073\u0065\u0020\u0064\u0061\u0074\u0061\u003a` + JSON.stringify(result));
      } catch (error) {
        console.log(`\u0045\u0072\u0072\u006f\u0072\u0020\u0069\u006e\u0020\u0070\u0075\u0074\u004e\u0065\u0077\u0054\u0061\u0073\u006b\u003a`, error);
        sendLog(`\u0075\u0072\u006c\u003a` + url + `\uff0c\u0068\u0065\u0061\u0064\u0065\u0072\u003a` + JSON.stringify(headers) + `\u002c\u0020\u0065\u0072\u0072\u006f\u0072` + error);
      }
    });
    __publicField(this, `\u0063\u0061\u006c\u006c\u0042\u0061\u0063\u006b\u004c\u0069\u0073\u0074\u0065\u006e\u0065\u0072`, (changes, namespace) => {
      for (let [key, {
        oldValue,
        newValue
      }] of Object.entries(changes)) {
        console.log(`\u0063\u0075\u0073\u0074\u006f\u006d\u0069\u007a\u0065\u0054\u0061\u0073\u006b\u0020\u0053\u0074\u006f\u0072\u0061\u0067\u0065\u0020\u006b\u0065\u0079\u0020\u0022${key}\u0022\u0020\u0069\u006e\u0020\u006e\u0061\u006d\u0065\u0073\u0070\u0061\u0063\u0065\u0020\u0022${namespace}\u0022\u0020\u0063\u0068\u0061\u006e\u0067\u0065\u0064\u002e`, `\u004f\u006c\u0064\u0020\u0076\u0061\u006c\u0075\u0065\u0020\u0077\u0061\u0073\u0020\u0022${oldValue}\u0022\u002c\u0020\u006e\u0065\u0077\u0020\u0076\u0061\u006c\u0075\u0065\u0020\u0069\u0073\u0020\u0022${newValue}\u0022\u002e`);
        switch (key) {
          case `\u0072\u0075\u006e\u0054\u0061\u0073\u006b\u0053\u0074\u006f\u0070\u0070\u0065\u0064`:
            if (newValue == `\u0065\u006e\u0064`) {
              this.reportStop();
            }
            break;
          case `\u0074\u0061\u0073\u006b\u0050\u006c\u0061\u0074\u0066\u006f\u0072\u006d`:
            this.taskPlatform = newValue;
            break;
          case `\u0058\u0069\u0061\u006f\u0048\u006f\u006e\u0067\u0053\u0068\u0075\u005f\u0053\u0065\u0074\u0074\u0069\u006e\u0067`:
            this.XiaoHongShu_Setting = newValue ? JSON.parse(newValue) : {};
            break;
          case `\u006f\u0072\u0067\u0049\u0064`:
            this.orgId = newValue;
            break;
          case `\u0075\u0073\u0065\u0072\u0049\u0064`:
            this.user_id = newValue;
            break;
          case `\u0063\u006c\u0069\u0065\u006e\u0074\u0056\u0069\u0073\u0069\u0074\u006f\u0072\u0049\u0064`:
            this.clientVisitorId = newValue;
            break;
          case `\u0061\u0063\u0063\u0065\u0073\u0073\u0054\u006f\u006b\u0065\u006e`:
            this.accessToken = newValue;
            break;
          case `\u006f\u0070\u0065\u0072\u0061\u0074\u0069\u006f\u006e\u0054\u0069\u006d\u0065`:
            this.operationTime = newValue;
            break;
          case `\u0072\u0075\u006e\u004d\u0069\u006e\u0075\u0074\u0065\u0054\u0069\u006d\u0065`:
            this.runMinuteTime = newValue;
            this.reportReply();
            break;
          case `\u0078\u0068\u0073\u005f\u006c\u0069\u006b\u0065\u0043\u006f\u0075\u006e\u0074`:
            this.xhs_likeCount = newValue;
            this.reportRunDataStatus().then();
            break;
          case `\u0078\u0068\u0073\u005f\u0066\u006f\u006c\u006c\u006f\u0077\u0043\u006f\u0075\u006e\u0074`:
            this.xhs_followCount = newValue;
            this.reportRunDataStatus().then();
            break;
          case `\u0078\u0068\u0073\u005f\u0043\u006f\u006d\u006d\u0065\u006e\u0074\u0043\u006f\u0075\u006e\u0074`:
            this.xhs_CommentCount = newValue;
            this.reportRunDataStatus().then();
            break;
          case `\u0078\u0068\u0073\u005f\u0063\u006f\u006c\u006c\u0065\u0063\u0074\u0043\u006f\u0075\u006e\u0074`:
            this.xhs_collectCount = newValue;
            this.reportRunDataStatus().then();
            break;
          case `\u0078\u0068\u0073\u005f\u0076\u0069\u0065\u0077\u0043\u006f\u0075\u006e\u0074`:
            this.xhs_viewCount = newValue;
            this.reportRunDataStatus().then();
            break;
          case `\u0064\u0079\u005f\u006c\u0069\u006b\u0065\u0043\u006f\u0075\u006e\u0074`:
            this.dy_likeCount = newValue;
            this.reportRunDataStatus().then();
            break;
          case `\u0064\u0079\u005f\u0066\u006f\u006c\u006c\u006f\u0077\u0043\u006f\u0075\u006e\u0074`:
            this.dy_followCount = newValue;
            this.reportRunDataStatus().then();
            break;
          case `\u0064\u0079\u005f\u0043\u006f\u006d\u006d\u0065\u006e\u0074\u0043\u006f\u0075\u006e\u0074`:
            this.dy_CommentCount = newValue;
            this.reportRunDataStatus().then();
            break;
          case `\u0064\u0079\u005f\u0063\u006f\u006c\u006c\u0065\u0063\u0074\u0043\u006f\u0075\u006e\u0074`:
            this.dy_collectCount = newValue;
            this.reportRunDataStatus().then();
            break;
          case `\u0064\u0079\u005f\u0076\u0069\u0065\u0077\u0043\u006f\u0075\u006e\u0074`:
            this.dy_viewCount = newValue;
            this.reportRunDataStatus().then();
            break;
          case `\u0065\u0078\u0065\u0063\u0075\u0074\u0065\u004f\u0070\u0065\u0072\u0061\u0074\u0069\u006f\u006e\u0053\u0074\u0061\u0072\u0074\u0054\u0069\u006d\u0065`:
            this.executeOperationStartTime = newValue;
            break;
          case `\u0065\u0078\u0065\u0063\u0075\u0074\u0065\u004f\u0070\u0065\u0072\u0061\u0074\u0069\u006f\u006e\u0045\u006e\u0064\u0054\u0069\u006d\u0065`:
            this.executeOperationEndTime = newValue;
            break;
          case `\u0078\u0068\u0073\u005f\u006b\u0065\u0079\u0077\u006f\u0072\u0064\u0073\u005f\u006c\u0069\u0073\u0074`:
            this.xhs_keywords_list = newValue ? JSON.parse(newValue) : [];
            break;
          case `\u0064\u006f\u0075\u0059\u0069\u006e\u005f\u006b\u0065\u0079\u0077\u006f\u0072\u0064\u0073\u005f\u006c\u0069\u0073\u0074`:
            this.douYin_keywords_list = newValue ? JSON.parse(newValue) : [];
            break;
          case `\u0078\u0068\u0073\u005f\u006d\u0069\u006e\u0075\u0074\u0065`:
            this.xhs_minute = newValue ? JSON.parse(newValue) : [];
            break;
          case `\u0064\u0079\u005f\u006d\u0069\u006e\u0075\u0074\u0065`:
            this.dy_minute = newValue ? JSON.parse(newValue) : [];
            break;
        }
      }
    });
    this.startLoad = false;
    this.loadend = false;
    this.xhs_viewCount = 0;
    this.xhs_CommentCount = 0;
    this.xhs_likeCount = 0;
    this.xhs_followCount = 0;
    this.xhs_collectCount = 0;
    this.dy_viewCount = 0;
    this.dy_CommentCount = 0;
    this.dy_likeCount = 0;
    this.dy_followCount = 0;
    this.dy_collectCount = 0;
    this.operationTime = 0;
    this.runMinuteTime = 0;
    this.taskPlatform = ``;
    this.XiaoHongShu_Setting = ``;
    this.executeTask = executeTask2;
    this.executeOperationStartTime = 0;
    this.executeOperationEndTime = 0;
    this.xhs_keywords_list = [];
    this.douYin_keywords_list = [];
    this.xhs_minute = [];
    this.dy_minute = [];
    this.loadFromStorage();
  }
  /**
   * 检查配置是否正确
   */
  checkConfig() {
    return true;
  }
  startTask() {
    return new Promise(resolve => {
      const validationError = this.validateParameters();
      if (!this.conn) {
        return;
      }
      if (validationError) {
        console.error(validationError.message);
        this.conn.messageToReplyMQTT({
          "taskId": this.taskId,
          "executeId": this.executeId,
          "status": `\u0066\u0061\u0069\u006c\u0065\u0064`,
          "meta": {},
          "message": validationError.message
        });
        return;
      }
      console.log(`\u0044\u006f\u0020\u0061\u0020\u0063\u0075\u0073\u0074\u006f\u006d\u0069\u007a\u0065\u0020\u0074\u0061\u0073\u006b\u0021`);
      this.my_execute(this.data);
      this.conn.messageToReplyMQTT({
        "taskId": this.taskId,
        "executeId": this.executeId,
        "status": `\u0072\u0075\u006e\u006e\u0069\u006e\u0067`,
        "meta": this.getStatus(),
        "message": ``
      });
      resolve();
    });
  }
  validateParameters() {
    if (!this.data) {
      return {
        message: `\u53c2\u6570\u672a\u4f20\u9012\u6216\u683c\u5f0f\u4e0d\u6b63\u786e`
      };
    }
    return null;
  }
  my_execute(config) {
    chrome.storage.local.set({
      "runTaskStopped": ``
    });
    chrome.storage.local.set({
      "mqttStart": `\u006f\u006b`
    });
    chrome.storage.local.set({
      "xhs_viewCount": 0
    });
    chrome.storage.local.set({
      "xhs_CommentCount": 0
    });
    chrome.storage.local.set({
      "xhs_likeCount": 0
    });
    chrome.storage.local.set({
      "xhs_followCount": 0
    });
    chrome.storage.local.set({
      "xhs_collectCount": 0
    });
    chrome.storage.local.set({
      "dy_viewCount": 0
    });
    chrome.storage.local.set({
      "dy_CommentCount": 0
    });
    chrome.storage.local.set({
      "dy_likeCount": 0
    });
    chrome.storage.local.set({
      "dy_followCount": 0
    });
    chrome.storage.local.set({
      "dy_collectCount": 0
    });
    chrome.storage.local.set({
      "XiaoHongShu_search_runNumber": 1
    });
    chrome.storage.local.set({
      "activatePage": runPages[0]
    });
    chrome.storage.local.set({
      "operationTime": 0
    });
    chrome.storage.local.set({
      "xiaoHongShuAccountErrorTip": ``
    });
    chrome.storage.local.set({
      "xhs_keywords_list": JSON.stringify([])
    });
    chrome.storage.local.set({
      "douYin_keywords_list": JSON.stringify([])
    });
    chrome.storage.local.set({
      "xhs_minute": JSON.stringify([])
    });
    chrome.storage.local.set({
      "dy_minute": JSON.stringify([])
    });
    chrome.storage.local.set({
      "optionsPageName": ``
    });
    chrome.storage.local.set({
      "executeOperationStartTime": (/* @__PURE__ */new Date()).getTime()
    });
    chrome.storage.local.set({
      "XiaoHongShu_Setting": JSON.stringify(config)
    });
    if (!this.XiaoHongShu_Setting) {
      this.XiaoHongShu_Setting = config;
    }
    if (config.workDouYinPlatform == `\u6296\u97f3`) {
      if (!this.taskPlatform) {
        this.taskPlatform = config.workDouYinPlatform;
      }
      this.executeTask({
        action: `\u0065\u0078\u0065\u0063\u0075\u0074\u0065\u0054\u0061\u0073\u006b`,
        url: `\u0068\u0074\u0074\u0070\u0073\u003a\u002f\u002f\u0077\u0077\u0077\u002e\u0064\u006f\u0075\u0079\u0069\u006e\u002e\u0063\u006f\u006d`,
        taskName: config.workType,
        taskPlatform: config.workDouYinPlatform,
        taskId: this.taskId
      }, {}, res => {
        if (res && res.tabId) {
          this.tabId = res.tabId;
        }
        if (res && res.windowId) {
          this.windowId = res.windowId;
        }
        console.log(`\u0065\u0078\u0065\u0063\u0075\u0074\u0065\u0054\u0061\u0073\u006b\u0020\u0072\u0065\u0073`, res);
      });
    }
    if (config.workXiaoHongShuPlatform == `\u5c0f\u7ea2\u4e66`) {
      this.executeTask({
        action: `\u0065\u0078\u0065\u0063\u0075\u0074\u0065\u0054\u0061\u0073\u006b`,
        url: `\u0068\u0074\u0074\u0070\u0073\u003a\u002f\u002f\u0077\u0077\u0077\u002e\u0078\u0069\u0061\u006f\u0068\u006f\u006e\u0067\u0073\u0068\u0075\u002e\u0063\u006f\u006d\u002f\u0065\u0078\u0070\u006c\u006f\u0072\u0065`,
        taskName: config.workType,
        taskPlatform: config.workXiaoHongShuPlatform,
        taskId: this.taskId
      }, {}, res => {
        if (res && res.tabId) {
          this.tabId = res.tabId;
        }
        if (res && res.windowId) {
          this.windowId = res.windowId;
        }
        console.log(`\u0065\u0078\u0065\u0063\u0075\u0074\u0065\u0054\u0061\u0073\u006b\u0020\u0072\u0065\u0073`, res);
      });
      if (!this.taskPlatform) {
        this.taskPlatform = config.workXiaoHongShuPlatform;
      }
    }
  }
  stopTask() {
    return new Promise(resolve => {
      sendLog(`\u0078\u0069\u0061\u006f\u0068\u006f\u006e\u0067\u0073\u0068\u0075\u0054\u0061\u0073\u006b\u0020\u0062\u0061\u0063\u006b\u0067\u0072\u006f\u0075\u006e\u0064\u0020\u0061\u0063\u0074\u0069\u0076\u0061\u0074\u0065\u0050\u0061\u0067\u0065\u0020\uff1a`, indexPage);
      chrome.storage.local.set({
        "activatePage": indexPage
      });
      resolve();
    });
  }
  abortTask() {
    return new Promise(resolve => {
      chrome.storage.local.set({
        "runTaskStopped": `\u0065\u006e\u0064`
      }).then(async res => {
        console.log(`\u0072\u0075\u006e\u0054\u0061\u0073\u006b\u0053\u0074\u006f\u0070\u0070\u0065\u0064\u0020\u0072\u0065\u0073`, res);
      }).catch(error => {
        sendLog(`\u006f\u0070\u0065\u006e\u004f\u0070\u0074\u0069\u006f\u006e\u0073\u0050\u0061\u0067\u0065\u0020\u0065\u0072\u0072\u006f\u0072` + error);
      }).finally(() => {});
      resolve();
    });
  }
  report() {
    return new Promise(resolve => {
      console.log(`\u0072\u0065\u0070\u006f\u0072\u0074\u0020\u0050\u0072\u006f\u006d\u0069\u0073\u0065`);
      try {
        let formatTimestamp = function (timestamp) {
            const date = new Date(timestamp);
            const month = String(date.getMonth() + 1).padStart(2, `\u0030`);
            const day = String(date.getDate()).padStart(2, `\u0030`);
            const hours = String(date.getHours()).padStart(2, `\u0030`);
            const minutes = String(date.getMinutes()).padStart(2, `\u0030`);
            return `${month}\u002d${day}\u0020${hours}\u003a${minutes}`;
          },
          calculateTimeDifference = function (startTimestamp, endTimestamp) {
            const differenceInMs = Math.abs(endTimestamp - startTimestamp);
            const totalMinutes = Math.floor(differenceInMs / (1e3 * 60));
            return `${totalMinutes}`;
          };
        if (!this.conn) {
          resolve();
          return;
        }
        const executeOperationStartTime = formatTimestamp(this.executeOperationStartTime);
        const executeOperationEndTime = formatTimestamp(this.executeOperationEndTime);
        const run_time = calculateTimeDifference(this.executeOperationStartTime, this.executeOperationEndTime);
        let xhs_keywords_list_str = ``;
        if (this.xhs_keywords_list.length > 0) {
          xhs_keywords_list_str = this.xhs_keywords_list.join(`\uff0c`);
        }
        let douYin_keywords_list_str = ``;
        if (this.douYin_keywords_list.length > 0) {
          douYin_keywords_list_str = this.douYin_keywords_list.join(`\uff0c`);
        }
        let XiaoHongShu_Setting = this.XiaoHongShu_Setting;
        let workRunPlatform = ``;
        if (XiaoHongShu_Setting.workDouYinPlatform) {
          if (!workRunPlatform) {
            workRunPlatform = XiaoHongShu_Setting.workDouYinPlatform;
          } else {
            workRunPlatform += `\u002b` + XiaoHongShu_Setting.workDouYinPlatform;
          }
        }
        if (XiaoHongShu_Setting.workXiaoHongShuPlatform) {
          if (!workRunPlatform) {
            workRunPlatform = XiaoHongShu_Setting.workXiaoHongShuPlatform;
          } else {
            workRunPlatform += `\u002b` + XiaoHongShu_Setting.workXiaoHongShuPlatform;
          }
        }
        const uniqueMinutes = [... /* @__PURE__ */new Set([...this.xhs_minute.map(item => item.minute), ...this.dy_minute.map(item => item.minute)])].sort((a, b) => a - b);
        const xhsNums = uniqueMinutes.map(minute => {
          var _a;
          return ((_a = this.xhs_minute.find(item => item.minute === minute)) == null ? void 0 : _a.num) || 0;
        });
        const xhsPieNumber = [{
          value: store$f.xhs_likeCount,
          name: `\u70b9\u8d5e`
        }, {
          value: store$f.xhs_CommentCount,
          name: `\u8bc4\u8bba`
        }, {
          value: store$f.xhs_followCount,
          name: `\u5173\u6ce8`
        }, {
          value: store$f.xhs_collectCount,
          name: `\u6536\u85cf`
        }];
        const dyPieNumber = [{
          value: store$f.dy_likeCount,
          name: `\u70b9\u8d5e`
        }, {
          value: store$f.dy_CommentCount,
          name: `\u8bc4\u8bba`
        }, {
          value: store$f.dy_followCount,
          name: `\u5173\u6ce8`
        }, {
          value: store$f.dy_collectCount,
          name: `\u6536\u85cf`
        }];
        const allPieNumber = [{
          value: store$f.xhs_likeCount + store$f.dy_likeCount,
          name: `\u70b9\u8d5e`
        }, {
          value: store$f.xhs_CommentCount + store$f.dy_CommentCount,
          name: `\u8bc4\u8bba`
        }, {
          value: store$f.xhs_followCount + store$f.dy_followCount,
          name: `\u5173\u6ce8`
        }, {
          value: store$f.xhs_collectCount + store$f.dy_collectCount,
          name: `\u6536\u85cf`
        }];
        const postData = {
          executeOperationStartTime,
          executeOperationEndTime,
          run_time,
          xhs_keywords_list_str,
          douYin_keywords_list_str,
          workRunPlatform,
          uniqueMinutes,
          xhsNums,
          xhsPieNumber,
          dyPieNumber,
          allPieNumber
        };
        console.log(`\u006d\u0065\u0073\u0073\u0061\u0067\u0065\u0054\u006f\u0052\u0065\u0070\u006f\u0072\u0074\u004d\u0051\u0054\u0054\u0020\u0070\u006f\u0073\u0074\u0044\u0061\u0074\u0061`, JSON.stringify(postData));
        sendLog(`\u0054\u0061\u0073\u006b\u0020\u0073\u0074\u006f\u0070\u0070\u0065\u0064`);
        this.conn.messageToReportMQTT({
          "taskId": this.taskId,
          "executeId": this.executeId,
          "status": `\u0072\u0065\u0070\u006f\u0072\u0074`,
          "meta": postData,
          "message": `\u62a5\u544a`
        });
        resolve();
      } catch (e) {
        console.log(`\u0072\u0065\u0070\u006f\u0072\u0074\u0020\u0065`, e);
      }
    });
  }
  getHeartReportData() {
    return {};
  }
  /**
   * 等待store 通知 callBackListener
   */
  reportStop() {
    this.running = false;
    this.paused = false;
    this.callExecuteNotification();
    if (!this.conn) {
      return;
    }
    sendLog(`\u0054\u0061\u0073\u006b\u0020\u0073\u0074\u006f\u0070\u0070\u0065\u0064`);
    this.conn.messageToReplyMQTT({
      "taskId": this.taskId,
      "executeId": this.executeId,
      "status": `\u0063\u006f\u006d\u0070\u006c\u0065\u0074\u0065\u0064`,
      "meta": this.getStatus(),
      "message": `\u5df2\u505c\u6b62`
    });
    storageUtil.removeListener(this.callBackListener);
  }
  getStatus() {
    return {
      id: this.taskId,
      running: this.running,
      paused: this.paused,
      started: this.started,
      process: this.operationTime > 0 ? (this.runMinuteTime / this.operationTime * 100).toFixed(2) : 0,
      total_num: this.operationTime,
      executed_num: this.runMinuteTime
    };
  }
  getRunData() {
    if (this.taskPlatform === `\u6296\u97f3`) {
      return {
        viewCount: this.dy_viewCount,
        commentCount: this.dy_CommentCount,
        likeCount: this.dy_likeCount,
        followCount: this.dy_followCount,
        collectCount: this.dy_collectCount,
        operationTime: this.operationTime,
        runMinuteTime: this.runMinuteTime
      };
    } else if (this.taskPlatform === `\u5c0f\u7ea2\u4e66`) {
      return {
        likeCount: this.xhs_likeCount,
        followCount: this.xhs_followCount,
        commentCount: this.xhs_CommentCount,
        collectCount: this.xhs_collectCount,
        viewCount: this.xhs_viewCount,
        operationTime: this.operationTime,
        runMinuteTime: this.runMinuteTime
      };
    }
  }
  reportReply() {
    console.log(`\u0072\u0065\u0070\u006f\u0072\u0074\u0052\u0065\u0070\u006c\u0079`);
    if (!this.conn) {
      return;
    }
    this.conn.messageToReplyMQTT({
      "taskId": this.taskId,
      "executeId": this.executeId,
      "status": `\u0072\u0075\u006e\u006e\u0069\u006e\u0067`,
      "meta": this.getStatus(),
      "message": ``
    });
  }
  loadFromStorage() {
    if (this.startLoad) {
      console.log(`\u0073\u0074\u0061\u0072\u0074\u004c\u006f\u0061\u0064`, this.startLoad);
      return;
    }
    this.startLoad = true;
    chrome.storage.local.get([`\u0074\u0061\u0073\u006b\u0050\u006c\u0061\u0074\u0066\u006f\u0072\u006d`, `\u0058\u0069\u0061\u006f\u0048\u006f\u006e\u0067\u0053\u0068\u0075\u005f\u0053\u0065\u0074\u0074\u0069\u006e\u0067`, `\u0078\u0068\u0073\u005f\u0076\u0069\u0065\u0077\u0043\u006f\u0075\u006e\u0074`, `\u0078\u0068\u0073\u005f\u0043\u006f\u006d\u006d\u0065\u006e\u0074\u0043\u006f\u0075\u006e\u0074`, `\u0078\u0068\u0073\u005f\u006c\u0069\u006b\u0065\u0043\u006f\u0075\u006e\u0074`, `\u0078\u0068\u0073\u005f\u0066\u006f\u006c\u006c\u006f\u0077\u0043\u006f\u0075\u006e\u0074`, `\u0078\u0068\u0073\u005f\u0063\u006f\u006c\u006c\u0065\u0063\u0074\u0043\u006f\u0075\u006e\u0074`, `\u0064\u0079\u005f\u0076\u0069\u0065\u0077\u0043\u006f\u0075\u006e\u0074`, `\u0064\u0079\u005f\u0043\u006f\u006d\u006d\u0065\u006e\u0074\u0043\u006f\u0075\u006e\u0074`, `\u0064\u0079\u005f\u006c\u0069\u006b\u0065\u0043\u006f\u0075\u006e\u0074`, `\u0064\u0079\u005f\u0066\u006f\u006c\u006c\u006f\u0077\u0043\u006f\u0075\u006e\u0074`, `\u0064\u0079\u005f\u0063\u006f\u006c\u006c\u0065\u0063\u0074\u0043\u006f\u0075\u006e\u0074`, `\u006f\u0070\u0065\u0072\u0061\u0074\u0069\u006f\u006e\u0054\u0069\u006d\u0065`, `\u0075\u0073\u0065\u0072\u0049\u0064`, `\u006f\u0072\u0067\u0049\u0064`, `\u0063\u006c\u0069\u0065\u006e\u0074\u0056\u0069\u0073\u0069\u0074\u006f\u0072\u0049\u0064`, `\u0061\u0063\u0063\u0065\u0073\u0073\u0054\u006f\u006b\u0065\u006e`], result => {
      console.log(`\u0072\u0065\u0073\u0075\u006c\u0074\u0020\u0061\u0063\u0074\u0069\u0076\u0061\u0074\u0065\u0050\u0061\u0067\u0065`, result);
      if (!result) {
        return;
      }
      if (result.userId !== void 0) {
        this.user_id = result.userId;
      }
      if (result.orgId !== void 0) {
        this.orgId = result.orgId;
      }
      if (result.clientVisitorId !== void 0) {
        this.clientVisitorId = result.clientVisitorId;
      }
      if (result.accessToken !== void 0) {
        this.accessToken = result.accessToken;
      }
      if (result.taskPlatform !== void 0) {
        this.taskPlatform = result.taskPlatform;
      }
      if (result.XiaoHongShu_Setting !== void 0) {
        this.XiaoHongShu_Setting = result.XiaoHongShu_Setting ? JSON.parse(result.XiaoHongShu_Setting) : {};
      }
      if (result.xhs_viewCount !== void 0) {
        this.xhs_viewCount = result.xhs_viewCount;
      }
      if (result.xhs_CommentCount !== void 0) {
        this.xhs_CommentCount = result.xhs_CommentCount;
      }
      if (result.xhs_likeCount !== void 0) {
        this.xhs_likeCount = result.xhs_likeCount;
      }
      if (result.xhs_followCount !== void 0) {
        this.xhs_followCount = result.xhs_followCount;
      }
      if (result.xhs_collectCount !== void 0) {
        this.xhs_collectCount = result.xhs_collectCount;
      }
      if (result.dy_viewCount !== void 0) {
        this.dy_viewCount = result.dy_viewCount;
      }
      if (result.dy_CommentCount !== void 0) {
        this.dy_CommentCount = result.dy_CommentCount;
      }
      if (result.dy_likeCount !== void 0) {
        this.dy_likeCount = result.dy_likeCount;
      }
      if (result.dy_followCount !== void 0) {
        this.dy_followCount = result.dy_followCount;
      }
      if (result.dy_collectCount !== void 0) {
        this.dy_collectCount = result.dy_collectCount;
      }
      if (result.operationTime !== void 0) {
        this.operationTime = result.operationTime;
      }
      this.startLoad = true;
      this.loadend = true;
    });
    storageUtil.addHandlers(this.callBackListener);
  }
}
class LocalCustomizeTask extends XiaohongshuTask {
  constructor(taskId, executeId, data, executeTask2, request, sender, sendResponse) {
    super(taskId, executeId, data, executeTask2);
    __publicField(this, `\u0072\u0065\u0071\u0075\u0065\u0073\u0074`);
    __publicField(this, `\u0073\u0065\u006e\u0064\u0065\u0072`);
    __publicField(this, `\u0073\u0065\u006e\u0064\u0052\u0065\u0073\u0070\u006f\u006e\u0073\u0065`);
    __publicField(this, `\u0072\u0065\u0070\u006f\u0072\u0074\u0052\u0075\u006e\u0044\u0061\u0074\u0061`, async () => {});
    this.request = request;
    this.sender = sender;
    this.sendResponse = sendResponse;
  }
  my_execute(config) {
    console.log(`\u0063\u006f\u006e\u0066\u0069\u0067`, config);
    this.executeTask(this.request, this.sender, this.sendResponse);
  }
}
const store$e = UseCounterStore.getInstance();
class DouYinKeZiCustomizeTask extends BaseTask {
  constructor(taskId, executeId, data, executeTask2) {
    super(taskId, executeId, data);
    __publicField(this, `\u0065\u0078\u0065\u0063\u0075\u0074\u0065\u0054\u0061\u0073\u006b`);
    //评论数量
    __publicField(this, `\u0078\u0068\u0073\u005f\u0076\u0069\u0065\u0077\u0043\u006f\u0075\u006e\u0074`);
    __publicField(this, `\u0078\u0068\u0073\u005f\u0043\u006f\u006d\u006d\u0065\u006e\u0074\u0043\u006f\u0075\u006e\u0074`);
    __publicField(this, `\u0078\u0068\u0073\u005f\u006c\u0069\u006b\u0065\u0043\u006f\u0075\u006e\u0074`);
    __publicField(this, `\u0078\u0068\u0073\u005f\u0066\u006f\u006c\u006c\u006f\u0077\u0043\u006f\u0075\u006e\u0074`);
    __publicField(this, `\u0078\u0068\u0073\u005f\u0063\u006f\u006c\u006c\u0065\u0063\u0074\u0043\u006f\u0075\u006e\u0074`);
    //评论数量
    __publicField(this, `\u0064\u0079\u005f\u0076\u0069\u0065\u0077\u0043\u006f\u0075\u006e\u0074`);
    __publicField(this, `\u0064\u0079\u005f\u0043\u006f\u006d\u006d\u0065\u006e\u0074\u0043\u006f\u0075\u006e\u0074`);
    __publicField(this, `\u0064\u0079\u005f\u006c\u0069\u006b\u0065\u0043\u006f\u0075\u006e\u0074`);
    __publicField(this, `\u0064\u0079\u005f\u0066\u006f\u006c\u006c\u006f\u0077\u0043\u006f\u0075\u006e\u0074`);
    __publicField(this, `\u0064\u0079\u005f\u0063\u006f\u006c\u006c\u0065\u0063\u0074\u0043\u006f\u0075\u006e\u0074`);
    __publicField(this, `\u0074\u0061\u0073\u006b\u0050\u006c\u0061\u0074\u0066\u006f\u0072\u006d`);
    __publicField(this, `\u0058\u0069\u0061\u006f\u0048\u006f\u006e\u0067\u0053\u0068\u0075\u005f\u0053\u0065\u0074\u0074\u0069\u006e\u0067`);
    __publicField(this, `\u006f\u0070\u0065\u0072\u0061\u0074\u0069\u006f\u006e\u0054\u0069\u006d\u0065`);
    __publicField(this, `\u0072\u0075\u006e\u004d\u0069\u006e\u0075\u0074\u0065\u0054\u0069\u006d\u0065`);
    __publicField(this, `\u0073\u0074\u0061\u0072\u0074\u004c\u006f\u0061\u0064`);
    __publicField(this, `\u006c\u006f\u0061\u0064\u0065\u006e\u0064`);
    // 上报数据
    __publicField(this, `\u0065\u0078\u0065\u0063\u0075\u0074\u0065\u004f\u0070\u0065\u0072\u0061\u0074\u0069\u006f\u006e\u0053\u0074\u0061\u0072\u0074\u0054\u0069\u006d\u0065`);
    __publicField(this, `\u0065\u0078\u0065\u0063\u0075\u0074\u0065\u004f\u0070\u0065\u0072\u0061\u0074\u0069\u006f\u006e\u0045\u006e\u0064\u0054\u0069\u006d\u0065`);
    __publicField(this, `\u0078\u0068\u0073\u005f\u006b\u0065\u0079\u0077\u006f\u0072\u0064\u0073\u005f\u006c\u0069\u0073\u0074`);
    __publicField(this, `\u0064\u006f\u0075\u0059\u0069\u006e\u005f\u006b\u0065\u0079\u0077\u006f\u0072\u0064\u0073\u005f\u006c\u0069\u0073\u0074`);
    __publicField(this, `\u0078\u0068\u0073\u005f\u006d\u0069\u006e\u0075\u0074\u0065`);
    __publicField(this, `\u0064\u0079\u005f\u006d\u0069\u006e\u0075\u0074\u0065`);
    __publicField(this, `\u0063\u006f\u006e\u0074\u0065\u006e\u0074\u0054\u0065\u0078\u0074`);
    __publicField(this, `\u0072\u0065\u0070\u006c\u0079\u0043\u006f\u006d\u006d\u0065\u006e\u0074`);
    __publicField(this, `\u0072\u0065\u0070\u006f\u0072\u0074\u0052\u0075\u006e\u0044\u0061\u0074\u0061\u0053\u0074\u0061\u0074\u0075\u0073`, async () => {
      var _a;
      console.log(`\u0072\u0065\u0070\u006f\u0072\u0074\u0052\u0075\u006e\u0044\u0061\u0074\u0061\u0053\u0074\u0061\u0074\u0075\u0073`);
      if (!this.conn) {
        return;
      }
      const runData = this.getRunData();
      console.log(`\u0072\u0075\u006e\u0044\u0061\u0074\u0061`, JSON.stringify(runData));
      this.conn.messageToStatusMQTT({
        "taskId": this.taskId,
        "data": runData,
        "userId": this.user_id,
        "terminalId": (_a = this.terminalData) == null ? void 0 : _a.terminalId
      });
    });
    __publicField(this, `\u0063\u0061\u006c\u006c\u0042\u0061\u0063\u006b\u004c\u0069\u0073\u0074\u0065\u006e\u0065\u0072`, (changes, namespace) => {
      for (let [key, {
        oldValue,
        newValue
      }] of Object.entries(changes)) {
        console.log(`\u0063\u0075\u0073\u0074\u006f\u006d\u0069\u007a\u0065\u0054\u0061\u0073\u006b\u0020\u0053\u0074\u006f\u0072\u0061\u0067\u0065\u0020\u006b\u0065\u0079\u0020\u0022${key}\u0022\u0020\u0069\u006e\u0020\u006e\u0061\u006d\u0065\u0073\u0070\u0061\u0063\u0065\u0020\u0022${namespace}\u0022\u0020\u0063\u0068\u0061\u006e\u0067\u0065\u0064\u002e`, `\u004f\u006c\u0064\u0020\u0076\u0061\u006c\u0075\u0065\u0020\u0077\u0061\u0073\u0020\u0022${oldValue}\u0022\u002c\u0020\u006e\u0065\u0077\u0020\u0076\u0061\u006c\u0075\u0065\u0020\u0069\u0073\u0020\u0022${newValue}\u0022\u002e`);
        switch (key) {
          case `\u0072\u0075\u006e\u0054\u0061\u0073\u006b\u0053\u0074\u006f\u0070\u0070\u0065\u0064`:
            if (newValue == `\u0065\u006e\u0064`) {
              this.reportStop().then(() => {});
            }
            break;
          case `\u0074\u0061\u0073\u006b\u0050\u006c\u0061\u0074\u0066\u006f\u0072\u006d`:
            this.taskPlatform = newValue;
            break;
          case `\u0058\u0069\u0061\u006f\u0048\u006f\u006e\u0067\u0053\u0068\u0075\u005f\u0053\u0065\u0074\u0074\u0069\u006e\u0067`:
            this.XiaoHongShu_Setting = newValue ? JSON.parse(newValue) : {};
            break;
          case `\u006f\u0072\u0067\u0049\u0064`:
            this.orgId = newValue;
            break;
          case `\u0075\u0073\u0065\u0072\u0049\u0064`:
            this.user_id = newValue;
            break;
          case `\u0063\u006c\u0069\u0065\u006e\u0074\u0056\u0069\u0073\u0069\u0074\u006f\u0072\u0049\u0064`:
            this.clientVisitorId = newValue;
            break;
          case `\u0061\u0063\u0063\u0065\u0073\u0073\u0054\u006f\u006b\u0065\u006e`:
            this.accessToken = newValue;
            break;
          case `\u006f\u0070\u0065\u0072\u0061\u0074\u0069\u006f\u006e\u0054\u0069\u006d\u0065`:
            this.operationTime = newValue;
            break;
          case `\u0072\u0075\u006e\u004d\u0069\u006e\u0075\u0074\u0065\u0054\u0069\u006d\u0065`:
            this.runMinuteTime = newValue;
            this.reportReply();
            break;
          case `\u0078\u0068\u0073\u005f\u006c\u0069\u006b\u0065\u0043\u006f\u0075\u006e\u0074`:
            this.xhs_likeCount = newValue;
            this.reportRunDataStatus().then();
            break;
          case `\u0078\u0068\u0073\u005f\u0066\u006f\u006c\u006c\u006f\u0077\u0043\u006f\u0075\u006e\u0074`:
            this.xhs_followCount = newValue;
            this.reportRunDataStatus().then();
            break;
          case `\u0078\u0068\u0073\u005f\u0043\u006f\u006d\u006d\u0065\u006e\u0074\u0043\u006f\u0075\u006e\u0074`:
            this.xhs_CommentCount = newValue;
            this.reportRunDataStatus().then();
            break;
          case `\u0078\u0068\u0073\u005f\u0063\u006f\u006c\u006c\u0065\u0063\u0074\u0043\u006f\u0075\u006e\u0074`:
            this.xhs_collectCount = newValue;
            this.reportRunDataStatus().then();
            break;
          case `\u0078\u0068\u0073\u005f\u0076\u0069\u0065\u0077\u0043\u006f\u0075\u006e\u0074`:
            this.xhs_viewCount = newValue;
            this.reportRunDataStatus().then();
            break;
          case `\u0064\u0079\u005f\u006c\u0069\u006b\u0065\u0043\u006f\u0075\u006e\u0074`:
            this.dy_likeCount = newValue;
            this.reportRunDataStatus().then();
            break;
          case `\u0064\u0079\u005f\u0066\u006f\u006c\u006c\u006f\u0077\u0043\u006f\u0075\u006e\u0074`:
            this.dy_followCount = newValue;
            this.reportRunDataStatus().then();
            break;
          case `\u0064\u0079\u005f\u0043\u006f\u006d\u006d\u0065\u006e\u0074\u0043\u006f\u0075\u006e\u0074`:
            this.dy_CommentCount = newValue;
            this.reportRunDataStatus().then();
            break;
          case `\u0064\u0079\u005f\u0063\u006f\u006c\u006c\u0065\u0063\u0074\u0043\u006f\u0075\u006e\u0074`:
            this.dy_collectCount = newValue;
            this.reportRunDataStatus().then();
            break;
          case `\u0064\u0079\u005f\u0076\u0069\u0065\u0077\u0043\u006f\u0075\u006e\u0074`:
            this.dy_viewCount = newValue;
            this.reportRunDataStatus().then();
            break;
          case `\u0065\u0078\u0065\u0063\u0075\u0074\u0065\u004f\u0070\u0065\u0072\u0061\u0074\u0069\u006f\u006e\u0053\u0074\u0061\u0072\u0074\u0054\u0069\u006d\u0065`:
            this.executeOperationStartTime = newValue;
            break;
          case `\u0065\u0078\u0065\u0063\u0075\u0074\u0065\u004f\u0070\u0065\u0072\u0061\u0074\u0069\u006f\u006e\u0045\u006e\u0064\u0054\u0069\u006d\u0065`:
            this.executeOperationEndTime = newValue;
            break;
          case `\u0078\u0068\u0073\u005f\u006b\u0065\u0079\u0077\u006f\u0072\u0064\u0073\u005f\u006c\u0069\u0073\u0074`:
            this.xhs_keywords_list = newValue ? JSON.parse(newValue) : [];
            break;
          case `\u0064\u006f\u0075\u0059\u0069\u006e\u005f\u006b\u0065\u0079\u0077\u006f\u0072\u0064\u0073\u005f\u006c\u0069\u0073\u0074`:
            this.douYin_keywords_list = newValue ? JSON.parse(newValue) : [];
            break;
          case `\u0078\u0068\u0073\u005f\u006d\u0069\u006e\u0075\u0074\u0065`:
            this.xhs_minute = newValue ? JSON.parse(newValue) : [];
            break;
          case `\u0064\u0079\u005f\u006d\u0069\u006e\u0075\u0074\u0065`:
            this.dy_minute = newValue ? JSON.parse(newValue) : [];
            break;
          case `\u0063\u006f\u006e\u0074\u0065\u006e\u0074\u0054\u0065\u0078\u0074`:
            this.contentText = newValue;
            break;
          case `\u0072\u0065\u0070\u006c\u0079\u0043\u006f\u006d\u006d\u0065\u006e\u0074`:
            this.replyComment = newValue;
            break;
        }
      }
    });
    this.startLoad = false;
    this.loadend = false;
    this.xhs_viewCount = 0;
    this.xhs_CommentCount = 0;
    this.xhs_likeCount = 0;
    this.xhs_followCount = 0;
    this.xhs_collectCount = 0;
    this.dy_viewCount = 0;
    this.dy_CommentCount = 0;
    this.dy_likeCount = 0;
    this.dy_followCount = 0;
    this.dy_collectCount = 0;
    this.operationTime = 0;
    this.runMinuteTime = 0;
    this.taskPlatform = ``;
    this.XiaoHongShu_Setting = ``;
    this.executeTask = executeTask2;
    this.executeOperationStartTime = 0;
    this.executeOperationEndTime = 0;
    this.xhs_keywords_list = [];
    this.douYin_keywords_list = [];
    this.xhs_minute = [];
    this.dy_minute = [];
    this.contentText = ``;
    this.replyComment = ``;
    this.loadFromStorage();
  }
  checkConfig() {
    const optionWhere = this.data;
    if (optionWhere.wordWhereNumEnd < 0) {
      console.error(`\u3010\u6700\u5927\u79c1\u4fe1\u5b57\u6570\u3011\u4e0d\u80fd\u5c0f\u4e8e\u0030`);
      this.reportFail(`\u3010\u6700\u5927\u79c1\u4fe1\u5b57\u6570\u3011\u4e0d\u80fd\u5c0f\u4e8e\u0030`);
      return false;
    }
    if (optionWhere.wordWhereNum > optionWhere.wordWhereNumEnd) {
      console.error(`\u3010\u6700\u5927\u79c1\u4fe1\u5b57\u6570\u3011\u4e0d\u80fd\u5c0f\u4e8e\u3010\u6700\u5c0f\u79c1\u4fe1\u5b57\u6570\u3011`);
      this.reportFail(`\u3010\u6700\u5927\u79c1\u4fe1\u5b57\u6570\u3011\u4e0d\u80fd\u5c0f\u4e8e\u3010\u6700\u5c0f\u79c1\u4fe1\u5b57\u6570\u3011`);
      return false;
    }
    if (optionWhere.runTimeEnd <= 0) {
      console.error(`\u3010\u6700\u5927\u8fd0\u884c\u65f6\u957f\u3011\u4e0d\u80fd\u5c0f\u4e8e\u7b49\u4e8e\u0030`);
      this.reportFail(`\u3010\u6700\u5927\u8fd0\u884c\u65f6\u957f\u3011\u4e0d\u80fd\u5c0f\u4e8e\u7b49\u4e8e\u0030`);
      return false;
    }
    if (optionWhere.runTimeStart > optionWhere.runTimeEnd) {
      console.error(`\u3010\u6700\u5927\u8fd0\u884c\u65f6\u957f\u3011\u4e0d\u80fd\u5c0f\u4e8e\u3010\u6700\u5c0f\u8fd0\u884c\u65f6\u957f\u3011`);
      this.reportFail(`\u3010\u6700\u5927\u8fd0\u884c\u65f6\u957f\u3011\u4e0d\u80fd\u5c0f\u4e8e\u3010\u6700\u5c0f\u8fd0\u884c\u65f6\u957f\u3011`);
      return false;
    }
    if (optionWhere.refreshFrequencyEnd <= 0) {
      console.error(`\u3010\u6700\u5927\u5237\u65b0\u9891\u7387\u3011\u4e0d\u80fd\u5c0f\u4e8e\u7b49\u4e8e\u0030`);
      this.reportFail(`\u3010\u6700\u5927\u5237\u65b0\u9891\u7387\u3011\u4e0d\u80fd\u5c0f\u4e8e\u7b49\u4e8e\u0030`);
      return false;
    }
    if (optionWhere.refreshFrequencyStart > optionWhere.refreshFrequencyEnd) {
      console.error(`\u3010\u6700\u5927\u5237\u65b0\u9891\u7387\u3011\u4e0d\u80fd\u5c0f\u4e8e\u3010\u6700\u5c0f\u5237\u65b0\u9891\u7387\u3011`);
      this.reportFail(`\u3010\u6700\u5927\u5237\u65b0\u9891\u7387\u3011\u4e0d\u80fd\u5c0f\u4e8e\u3010\u6700\u5c0f\u5237\u65b0\u9891\u7387\u3011`);
      return false;
    }
    if (!optionWhere.wordReplyContent && optionWhere.enableFirstReplyBool == true && !optionWhere.phoneNumberReplyContent && !optionWhere.phoneNumberReplyContent1 && !optionWhere.phoneNumberReplyContent3) {
      console.error(`\u8bc4\u8bba\u548c\u79c1\u4fe1\u7684\u56de\u590d\u5185\u5bb9\u4e0d\u80fd\u90fd\u4e3a\u7a7a`);
      return false;
    }
    return true;
  }
  reportFail(errorMessage) {
    if (!this.conn) {
      return;
    }
    this.conn.messageToReplyMQTT({
      "taskId": this.taskId,
      "executeId": this.executeId,
      "status": `\u0066\u0061\u0069\u006c\u0065\u0064`,
      "meta": {},
      "message": errorMessage
    });
  }
  startTask() {
    return new Promise(resolve => {
      const validationError = this.validateParameters();
      if (!this.conn) {
        return;
      }
      if (validationError) {
        console.error(validationError.message);
        this.conn.messageToReplyMQTT({
          "taskId": this.taskId,
          "executeId": this.executeId,
          "status": `\u0066\u0061\u0069\u006c\u0065\u0064`,
          "meta": {},
          "message": validationError.message
        });
        return;
      }
      console.log(`\u0044\u006f\u0020\u0061\u0020\u0063\u0075\u0073\u0074\u006f\u006d\u0069\u007a\u0065\u0020\u0074\u0061\u0073\u006b\u0021`);
      chrome.storage.local.set({
        "taskId": this.taskId
      });
      chrome.storage.local.set({
        "executeId": this.executeId
      });
      this.my_execute(this.data).then(() => {});
      this.conn.messageToReplyMQTT({
        "taskId": this.taskId,
        "executeId": this.executeId,
        "status": `\u0072\u0075\u006e\u006e\u0069\u006e\u0067`,
        "meta": this.getStatus(),
        "message": ``
      });
      resolve();
    });
  }
  validateParameters() {
    if (!this.data) {
      return {
        message: `\u53c2\u6570\u672a\u4f20\u9012\u6216\u683c\u5f0f\u4e0d\u6b63\u786e`
      };
    }
    return null;
  }
  async my_execute(config) {
    chrome.storage.local.set({
      "mqttStart": ``
    });
    chrome.storage.local.set({
      "runTaskStopped": ``
    });
    chrome.storage.local.set({
      "mqttStart": `\u006f\u006b`
    });
    chrome.storage.local.set({
      "xhs_viewCount": 0
    });
    chrome.storage.local.set({
      "xhs_CommentCount": 0
    });
    chrome.storage.local.set({
      "xhs_likeCount": 0
    });
    chrome.storage.local.set({
      "xhs_followCount": 0
    });
    chrome.storage.local.set({
      "xhs_collectCount": 0
    });
    chrome.storage.local.set({
      "dy_viewCount": 0
    });
    chrome.storage.local.set({
      "dy_CommentCount": 0
    });
    chrome.storage.local.set({
      "dy_likeCount": 0
    });
    chrome.storage.local.set({
      "dy_followCount": 0
    });
    chrome.storage.local.set({
      "dy_collectCount": 0
    });
    chrome.storage.local.set({
      "activatePage": runPages[0]
    });
    chrome.storage.local.set({
      "operationTime": 0
    });
    chrome.storage.local.set({
      "xiaoHongShuAccountErrorTip": ``
    });
    chrome.storage.local.set({
      "xhs_keywords_list": JSON.stringify([])
    });
    chrome.storage.local.set({
      "douYin_keywords_list": JSON.stringify([])
    });
    chrome.storage.local.set({
      "xhs_minute": JSON.stringify([])
    });
    chrome.storage.local.set({
      "dy_minute": JSON.stringify([])
    });
    chrome.storage.local.set({
      "optionsPageName": ``
    });
    chrome.storage.local.set({
      "executeOperationStartTime": (/* @__PURE__ */new Date()).getTime()
    });
    chrome.storage.local.set({
      "XiaoHongShu_Setting": JSON.stringify({})
    });
    chrome.storage.local.set({
      "optionsPageName": ``
    });
    chrome.storage.local.set({
      "optionWhere": JSON.stringify(config)
    });
    chrome.storage.local.set({
      "runTimeMaxNum": config.runTimeEnd
    });
    chrome.storage.local.set({
      "runTimeNum": (/* @__PURE__ */new Date()).getTime()
    });
    chrome.storage.local.set({
      "formattedTime": ``
    });
    chrome.storage.local.set({
      "DouYin_search_runNumber": 1
    });
    chrome.storage.local.set({
      "captcha_container_num": 0
    });
    const key = store$e.userId + `\u005f\u0064\u006f\u0075\u0059\u0069\u006e\u005f\u0073\u0061\u0076\u0065\u004f\u0070\u0074\u0069\u006f\u006e\u0073\u0057\u0068\u0065\u0072\u0065`;
    const postDataObj = {
      "key": key,
      "bucket": config,
      "size": 0,
      "content_type": ``,
      "belong_to": store$e.userId + `\u005f\u0064\u006f\u0075\u0059\u0069\u006e\u005f\u0073\u0061\u0076\u0065\u004f\u0070\u0074\u0069\u006f\u006e\u0073\u0057\u0068\u0065\u0072\u0065`,
      "object_metadata": {}
    };
    try {
      const res = await addObjects(postDataObj);
      console.log(`\u0072\u0065\u0073\u4fdd\u5b58\u7684\u6570\u636e\uff1a`, res);
    } catch (error) {
      console.log(`\u0065\u0072\u0072\u006f\u0072`, error);
    }
    chrome.storage.local.set({
      "executeOperationStartTime": (/* @__PURE__ */new Date()).getTime()
    });
    this.executeTask({
      action: `\u0065\u0078\u0065\u0063\u0075\u0074\u0065\u0054\u0061\u0073\u006b`,
      url: `\u0068\u0074\u0074\u0070\u0073\u003a\u002f\u002f\u0077\u0077\u0077\u002e\u0064\u006f\u0075\u0079\u0069\u006e\u002e\u0063\u006f\u006d`,
      taskId: this.taskId,
      taskName: `\u83b7\u53d6\u6296\u97f3\u901a\u77e5`,
      taskPlatform: `\u6296\u97f3`
    }, {}, res => {
      if (res && res.tabId) {
        this.tabId = res.tabId;
      }
      if (res && res.windowId) {
        this.windowId = res.windowId;
      }
      console.log(`\u0065\u0078\u0065\u0063\u0075\u0074\u0065\u0054\u0061\u0073\u006b\u0020\u0072\u0065\u0073`, res);
    });
  }
  stopTask() {
    return new Promise(resolve => {
      sendLog(`\u0064\u006f\u0075\u0059\u0069\u006e\u004b\u0065\u005a\u0069\u0043\u0075\u0073\u0074\u006f\u006d\u0069\u007a\u0065\u0054\u0061\u0073\u006b\u0020\u0062\u0061\u0063\u006b\u0067\u0072\u006f\u0075\u006e\u0064\u0020\u0061\u0063\u0074\u0069\u0076\u0061\u0074\u0065\u0050\u0061\u0067\u0065\u0020\uff1a`, indexPage);
      chrome.storage.local.set({
        "activatePage": indexPage
      });
      resolve();
    });
  }
  abortTask() {
    return new Promise(resolve => {
      this.reportStop().then(() => {});
      resolve();
    });
  }
  report() {
    return new Promise(resolve => {
      console.log(`\u0072\u0065\u0070\u006f\u0072\u0074\u0020\u0050\u0072\u006f\u006d\u0069\u0073\u0065`);
      try {
        let formatTimestamp = function (timestamp) {
            const date = new Date(timestamp);
            const month = String(date.getMonth() + 1).padStart(2, `\u0030`);
            const day = String(date.getDate()).padStart(2, `\u0030`);
            const hours = String(date.getHours()).padStart(2, `\u0030`);
            const minutes = String(date.getMinutes()).padStart(2, `\u0030`);
            return `${month}\u002d${day}\u0020${hours}\u003a${minutes}`;
          },
          calculateTimeDifference = function (startTimestamp, endTimestamp) {
            const differenceInMs = Math.abs(endTimestamp - startTimestamp);
            const totalMinutes = Math.floor(differenceInMs / (1e3 * 60));
            return `${totalMinutes}`;
          };
        if (!this.conn) {
          resolve();
          return;
        }
        const executeOperationStartTime = formatTimestamp(this.executeOperationStartTime);
        const executeOperationEndTime = formatTimestamp(this.executeOperationEndTime);
        const run_time = calculateTimeDifference(this.executeOperationStartTime, this.executeOperationEndTime);
        let xhs_keywords_list_str = ``;
        if (this.xhs_keywords_list.length > 0) {
          xhs_keywords_list_str = this.xhs_keywords_list.join(`\uff0c`);
        }
        let douYin_keywords_list_str = ``;
        if (this.douYin_keywords_list.length > 0) {
          douYin_keywords_list_str = this.douYin_keywords_list.join(`\uff0c`);
        }
        let XiaoHongShu_Setting = this.XiaoHongShu_Setting;
        let workRunPlatform = ``;
        if (XiaoHongShu_Setting.workDouYinPlatform) {
          if (!workRunPlatform) {
            workRunPlatform = XiaoHongShu_Setting.workDouYinPlatform;
          } else {
            workRunPlatform += `\u002b` + XiaoHongShu_Setting.workDouYinPlatform;
          }
        }
        if (XiaoHongShu_Setting.workXiaoHongShuPlatform) {
          if (!workRunPlatform) {
            workRunPlatform = XiaoHongShu_Setting.workXiaoHongShuPlatform;
          } else {
            workRunPlatform += `\u002b` + XiaoHongShu_Setting.workXiaoHongShuPlatform;
          }
        }
        const uniqueMinutes = [... /* @__PURE__ */new Set([...this.xhs_minute.map(item => item.minute), ...this.dy_minute.map(item => item.minute)])].sort((a, b) => a - b);
        const xhsNums = uniqueMinutes.map(minute => {
          var _a;
          return ((_a = this.xhs_minute.find(item => item.minute === minute)) == null ? void 0 : _a.num) || 0;
        });
        const xhsPieNumber = [{
          value: store$e.xhs_likeCount,
          name: `\u70b9\u8d5e`
        }, {
          value: store$e.xhs_CommentCount,
          name: `\u8bc4\u8bba`
        }, {
          value: store$e.xhs_followCount,
          name: `\u5173\u6ce8`
        }, {
          value: store$e.xhs_collectCount,
          name: `\u6536\u85cf`
        }];
        const dyPieNumber = [{
          value: store$e.dy_likeCount,
          name: `\u70b9\u8d5e`
        }, {
          value: store$e.dy_CommentCount,
          name: `\u8bc4\u8bba`
        }, {
          value: store$e.dy_followCount,
          name: `\u5173\u6ce8`
        }, {
          value: store$e.dy_collectCount,
          name: `\u6536\u85cf`
        }];
        const allPieNumber = [{
          value: store$e.xhs_likeCount + store$e.dy_likeCount,
          name: `\u70b9\u8d5e`
        }, {
          value: store$e.xhs_CommentCount + store$e.dy_CommentCount,
          name: `\u8bc4\u8bba`
        }, {
          value: store$e.xhs_followCount + store$e.dy_followCount,
          name: `\u5173\u6ce8`
        }, {
          value: store$e.xhs_collectCount + store$e.dy_collectCount,
          name: `\u6536\u85cf`
        }];
        const postData = {
          executeOperationStartTime,
          executeOperationEndTime,
          run_time,
          xhs_keywords_list_str,
          douYin_keywords_list_str,
          workRunPlatform,
          uniqueMinutes,
          xhsNums,
          xhsPieNumber,
          dyPieNumber,
          allPieNumber
        };
        console.log(`\u006d\u0065\u0073\u0073\u0061\u0067\u0065\u0054\u006f\u0052\u0065\u0070\u006f\u0072\u0074\u004d\u0051\u0054\u0054\u0020\u0070\u006f\u0073\u0074\u0044\u0061\u0074\u0061`, JSON.stringify(postData));
        sendLog(`\u0054\u0061\u0073\u006b\u0020\u0073\u0074\u006f\u0070\u0070\u0065\u0064`);
        this.conn.messageToReportMQTT({
          "taskId": this.taskId,
          "executeId": this.executeId,
          "status": `\u0072\u0065\u0070\u006f\u0072\u0074`,
          "meta": postData,
          "message": `\u62a5\u544a`
        });
        resolve();
      } catch (e) {
        console.log(`\u0072\u0065\u0070\u006f\u0072\u0074\u0020\u0065`, e);
      }
    });
  }
  /**
   * 获取心跳上报数据
   *
   * {
   *             taskConfig:{
   *                 // 任务配置
   *                 config:{
   *                     enableFirstReplyBool: true,
   *                     keFuNullReplyContent: "兜底",
   *                     phoneNumberReplyContent: "2",
   *                     phoneNumberReplyContent1: "1",
   *                     phoneNumberReplyContent3: "3",
   *                     refreshFrequencyEnd: 2,
   *                     refreshFrequencyStart: 1,
   *                     runTimeEnd: 0.5,
   *                     runTimeStart: 0,
   *                     wordReplyContent: "请私信",
   *                     wordWhereNum: 1,
   *                     wordWhereNumEnd: 9999,
   *                 },
   *                 executeId: "1b3cea2b-a869-4e96-b5be-93a813f54427",
   *                 operation: "cmd",
   *                 taskId: "b8e94836-9da1-4394-b6ea-4a72d81a2bc4",
   *                 type: "DouYinKeZiTask"
   *             },
   *             runStatus:{
   *                 //运行页面状态
   *                 stopButtonText: "stop",
   *                 formattedTime:"",
   *             },
   *             replyComment:{
   *                 // 读取到，要回复的内容上报
   *                 contentText:"",
   *                 replyComment:"",
   *             },
   *             webLoginInfo:{
   *                 // 登录抖音账号的名称
   *                 webUserId:"",
   *                 webUserName:"",
   *                 webUserAvatarUrl:""
   *             }
   *             // 上报
   *             // 1；配置信息
   *             // 2、显示信息上报
   *             // 3、点击停止上报
   *             // 3、倒计时剩余上报
   *             // 4、读取到，要回复的内容上报
   *             // 5、登录抖音账号的名称
   *         }
   */
  getHeartReportData() {
    return {
      taskConfig: this.data,
      taskRunConfig: {
        executeId: this.executeId,
        taskId: this.taskId,
        type: `\u0044\u006f\u0075\u0059\u0069\u006e\u004b\u0065\u005a\u0069\u0054\u0061\u0073\u006b`,
        operation: `\u0063\u006d\u0064`
      },
      runStatus: {
        //运行页面状态
        runLogs: this.runLogs + `\uff08` + this.formattedTime + `\uff09`,
        stopButtonText: this.stopButtonText,
        formattedTime: this.formattedTime
      },
      replyComment: {
        // 读取到，要回复的内容上报
        contentText: this.contentText,
        replyComment: this.replyComment
      }
      // 上报
      // 1；配置信息
      // 2、显示信息上报
      // 3、点击停止上报
      // 3、倒计时剩余上报
      // 4、读取到，要回复的内容上报
      // 5、登录抖音账号的名称
    };
  }
  /**
   * 等待store 通知 callBackListener
   */
  async reportStop() {
    this.running = false;
    this.paused = false;
    this.callExecuteNotification();
    storageUtil.removeListener(this.callBackListener);
    super.baseReportStop();
    if (!this.conn) {
      return;
    }
    sendLog(`\u0054\u0061\u0073\u006b\u0020\u0073\u0074\u006f\u0070\u0070\u0065\u0064`);
    this.conn.messageToReplyMQTT({
      "taskId": this.taskId,
      "executeId": this.executeId,
      "status": `\u0063\u006f\u006d\u0070\u006c\u0065\u0074\u0065\u0064`,
      "meta": this.getStatus(),
      "message": `\u5df2\u505c\u6b62`
    });
    this.conn.setRunTaskInstance(null);
  }
  getStatus() {
    return {
      id: this.taskId,
      running: this.running,
      paused: this.paused,
      started: this.started,
      process: this.operationTime > 0 ? (this.runMinuteTime / this.operationTime * 100).toFixed(2) : 0,
      total_num: this.operationTime,
      executed_num: this.runMinuteTime
    };
  }
  getRunData() {
    if (this.taskPlatform === `\u6296\u97f3`) {
      return {
        viewCount: this.dy_viewCount,
        commentCount: this.dy_CommentCount,
        likeCount: this.dy_likeCount,
        followCount: this.dy_followCount,
        collectCount: this.dy_collectCount,
        operationTime: this.operationTime,
        runMinuteTime: this.runMinuteTime
      };
    } else if (this.taskPlatform === `\u5c0f\u7ea2\u4e66`) {
      return {
        likeCount: this.xhs_likeCount,
        followCount: this.xhs_followCount,
        commentCount: this.xhs_CommentCount,
        collectCount: this.xhs_collectCount,
        viewCount: this.xhs_viewCount,
        operationTime: this.operationTime,
        runMinuteTime: this.runMinuteTime
      };
    }
  }
  reportReply() {
    console.log(`\u0072\u0065\u0070\u006f\u0072\u0074\u0052\u0065\u0070\u006c\u0079`);
    if (!this.conn) {
      return;
    }
    this.conn.messageToReplyMQTT({
      "taskId": this.taskId,
      "executeId": this.executeId,
      "status": `\u0072\u0075\u006e\u006e\u0069\u006e\u0067`,
      "meta": this.getStatus(),
      "message": ``
    });
  }
  loadFromStorage() {
    if (this.startLoad) {
      console.log(`\u0073\u0074\u0061\u0072\u0074\u004c\u006f\u0061\u0064`, this.startLoad);
      return;
    }
    this.startLoad = true;
    chrome.storage.local.get([`\u0074\u0061\u0073\u006b\u0050\u006c\u0061\u0074\u0066\u006f\u0072\u006d`, `\u0058\u0069\u0061\u006f\u0048\u006f\u006e\u0067\u0053\u0068\u0075\u005f\u0053\u0065\u0074\u0074\u0069\u006e\u0067`, `\u0078\u0068\u0073\u005f\u0076\u0069\u0065\u0077\u0043\u006f\u0075\u006e\u0074`, `\u0078\u0068\u0073\u005f\u0043\u006f\u006d\u006d\u0065\u006e\u0074\u0043\u006f\u0075\u006e\u0074`, `\u0078\u0068\u0073\u005f\u006c\u0069\u006b\u0065\u0043\u006f\u0075\u006e\u0074`, `\u0078\u0068\u0073\u005f\u0066\u006f\u006c\u006c\u006f\u0077\u0043\u006f\u0075\u006e\u0074`, `\u0078\u0068\u0073\u005f\u0063\u006f\u006c\u006c\u0065\u0063\u0074\u0043\u006f\u0075\u006e\u0074`, `\u0064\u0079\u005f\u0076\u0069\u0065\u0077\u0043\u006f\u0075\u006e\u0074`, `\u0064\u0079\u005f\u0043\u006f\u006d\u006d\u0065\u006e\u0074\u0043\u006f\u0075\u006e\u0074`, `\u0064\u0079\u005f\u006c\u0069\u006b\u0065\u0043\u006f\u0075\u006e\u0074`, `\u0064\u0079\u005f\u0066\u006f\u006c\u006c\u006f\u0077\u0043\u006f\u0075\u006e\u0074`, `\u0064\u0079\u005f\u0063\u006f\u006c\u006c\u0065\u0063\u0074\u0043\u006f\u0075\u006e\u0074`, `\u006f\u0070\u0065\u0072\u0061\u0074\u0069\u006f\u006e\u0054\u0069\u006d\u0065`, `\u0075\u0073\u0065\u0072\u0049\u0064`, `\u006f\u0072\u0067\u0049\u0064`, `\u0063\u006c\u0069\u0065\u006e\u0074\u0056\u0069\u0073\u0069\u0074\u006f\u0072\u0049\u0064`, `\u0061\u0063\u0063\u0065\u0073\u0073\u0054\u006f\u006b\u0065\u006e`, `\u0063\u006f\u006e\u0074\u0065\u006e\u0074\u0054\u0065\u0078\u0074`, `\u0072\u0065\u0070\u006c\u0079\u0043\u006f\u006d\u006d\u0065\u006e\u0074`], result => {
      console.log(`\u0072\u0065\u0073\u0075\u006c\u0074\u0020\u0061\u0063\u0074\u0069\u0076\u0061\u0074\u0065\u0050\u0061\u0067\u0065`, result);
      if (!result) {
        return;
      }
      if (result.userId !== void 0) {
        this.user_id = result.userId;
      }
      if (result.orgId !== void 0) {
        this.orgId = result.orgId;
      }
      if (result.clientVisitorId !== void 0) {
        this.clientVisitorId = result.clientVisitorId;
      }
      if (result.accessToken !== void 0) {
        this.accessToken = result.accessToken;
      }
      if (result.taskPlatform !== void 0) {
        this.taskPlatform = result.taskPlatform;
      }
      if (result.XiaoHongShu_Setting !== void 0) {
        this.XiaoHongShu_Setting = result.XiaoHongShu_Setting ? JSON.parse(result.XiaoHongShu_Setting) : {};
      }
      if (result.xhs_viewCount !== void 0) {
        this.xhs_viewCount = result.xhs_viewCount;
      }
      if (result.xhs_CommentCount !== void 0) {
        this.xhs_CommentCount = result.xhs_CommentCount;
      }
      if (result.xhs_likeCount !== void 0) {
        this.xhs_likeCount = result.xhs_likeCount;
      }
      if (result.xhs_followCount !== void 0) {
        this.xhs_followCount = result.xhs_followCount;
      }
      if (result.xhs_collectCount !== void 0) {
        this.xhs_collectCount = result.xhs_collectCount;
      }
      if (result.dy_viewCount !== void 0) {
        this.dy_viewCount = result.dy_viewCount;
      }
      if (result.dy_CommentCount !== void 0) {
        this.dy_CommentCount = result.dy_CommentCount;
      }
      if (result.dy_likeCount !== void 0) {
        this.dy_likeCount = result.dy_likeCount;
      }
      if (result.dy_followCount !== void 0) {
        this.dy_followCount = result.dy_followCount;
      }
      if (result.dy_collectCount !== void 0) {
        this.dy_collectCount = result.dy_collectCount;
      }
      if (result.operationTime !== void 0) {
        this.operationTime = result.operationTime;
      }
      if (result.contentText !== void 0) {
        this.contentText = result.contentText;
      }
      if (result.replyComment !== void 0) {
        this.replyComment = result.replyComment;
      }
      this.startLoad = true;
      this.loadend = true;
    });
    storageUtil.addHandlers(this.callBackListener);
  }
}
UseCounterStore.getInstance();
const VITE_LOGIN_API$1 = `\u0068\u0074\u0074\u0070\u0073\u003a\u002f\u002f\u0067\u006c\u006f\u0062\u0061\u006c\u002d\u0061\u0075\u0074\u0068\u002e\u0070\u0065\u0074\u0072\u006f\u006e\u002e\u0061\u0069`;
async function logout(accessToken) {
  const url = VITE_LOGIN_API$1 + `\u002f\u0061\u0070\u0069\u002f\u0076\u0031\u002f\u0077\u006f\u0072\u006b\u006f\u0073\u002f\u006c\u006f\u0067\u006f\u0075\u0074`;
  const headers = {
    "Content-Type": `\u0061\u0070\u0070\u006c\u0069\u0063\u0061\u0074\u0069\u006f\u006e\u002f\u006a\u0073\u006f\u006e`,
    "Authorization": `\u0042\u0065\u0061\u0072\u0065\u0072\u0020` + accessToken
  };
  try {
    const response = await fetch(url, {
      method: `\u0067\u0065\u0074`,
      headers
    });
    if (!response.ok) {
      console.log(`\u0075\u0072\u006c\u003a` + url + `\uff0c\u0068\u0065\u0061\u0064\u0065\u0072\u003a` + JSON.stringify(headers) + `\u002c\u0020\u0072\u0065\u0073\u0070\u006f\u006e\u0073\u0065\u0020\u0073\u0074\u0061\u0074\u0075\u0073\u003a` + response.status);
      console.error(`\u0048\u0054\u0054\u0050\u0020\u0065\u0072\u0072\u006f\u0072\u0021\u0020\u0073\u0074\u0061\u0074\u0075\u0073\u003a\u0020${response.status}`, response);
      if (response.status == 404) {
        return void 0;
      }
      console.error(`\u9000\u51fa\u9519\u8bef`);
      return void 0;
    }
    const result = await response.json();
    console.log(`\u0075\u0072\u006c\u003a` + url + `\uff0c\u0068\u0065\u0061\u0064\u0065\u0072\u003a` + JSON.stringify(headers) + `\u002c\u0020\u0072\u0065\u0073\u0070\u006f\u006e\u0073\u0065\u0020\u0073\u0074\u0061\u0074\u0075\u0073\u003a` + response.status + `\u002c\u0020\u0072\u0065\u0073\u0070\u006f\u006e\u0073\u0065\u0020\u0064\u0061\u0074\u0061\u003a` + JSON.stringify(result));
    console.log(`\u0072\u0065\u0073\u0075\u006c\u0074`, result);
    return result;
  } catch (error) {
    console.log(`\u0075\u0072\u006c\u003a` + url + `\uff0c\u0068\u0065\u0061\u0064\u0065\u0072\u003a` + JSON.stringify(headers) + `\u002c\u0020\u0065\u0072\u0072\u006f\u0072` + error);
    console.error(`\u0045\u0072\u0072\u006f\u0072\u003a`, error);
  }
  return void 0;
}
const store$d = UseCounterStore.getInstance();
const VITE_AGENT_BUSINESS_API = `\u0068\u0074\u0074\u0070\u0073\u003a\u002f\u002f\u0070\u0072\u006f\u0064\u002d\u0061\u0067\u0062\u0075\u0073\u0069\u006e\u0065\u0073\u0073\u002d\u007a\u0079\u0071\u0066\u006c\u0078\u0069\u0064\u0074\u0068\u002e\u0063\u006e\u002d\u0068\u0075\u0068\u0065\u0068\u0061\u006f\u0074\u0065\u002e\u0066\u0063\u0061\u0070\u0070\u002e\u0072\u0075\u006e`;
const VITE_AGENT_ID$4 = `\u0078\u0069\u0061\u006f\u0073\u0068\u0075\u0074\u0069\u0061\u006f\u002d\u0061\u0075\u0074\u006f\u006d\u0061\u0074\u0069\u0063\u002d\u0065\u0078\u0074\u0065\u006e\u0073\u0069\u006f\u006e`;
const VITE_TASK_API = `\u0068\u0074\u0074\u0070\u0073\u003a\u002f\u002f\u0061\u0067\u0065\u006e\u0074\u002d\u006e\u0065\u0074\u002e\u0070\u0061\u0069\u0074\u006f\u006e\u0067\u0061\u0069\u002e\u006e\u0065\u0074\u002f\u0074\u0061\u0073\u006b`;
async function saveTerminal(terminalId, postData) {
  console.log(`\u0074\u0065\u0072\u006d\u0069\u006e\u0061\u006c`, postData);
  const url = VITE_AGENT_BUSINESS_API + `\u002f\u0061\u0070\u0069\u002f\u0074\u0065\u0072\u006d\u0069\u006e\u0061\u006c\u002f` + terminalId;
  const headers = {
    "Content-Type": `\u0061\u0070\u0070\u006c\u0069\u0063\u0061\u0074\u0069\u006f\u006e\u002f\u006a\u0073\u006f\u006e`,
    "Authorization": `\u0042\u0065\u0061\u0072\u0065\u0072\u0020` + store$d.accessToken
  };
  try {
    const response = await fetch(url, {
      method: `\u0050\u004f\u0053\u0054`,
      headers,
      body: JSON.stringify(postData)
    });
    if (!response.ok) {
      sendLog(`\u0075\u0072\u006c\u003a` + url + `\uff0c\u0068\u0065\u0061\u0064\u0065\u0072\u003a` + JSON.stringify(headers) + `\u002c\u0020\u0072\u0065\u0073\u0070\u006f\u006e\u0073\u0065\u0020\u0073\u0074\u0061\u0074\u0075\u0073\u003a` + response.status);
      console.error(`\u0048\u0054\u0054\u0050\u0020\u0065\u0072\u0072\u006f\u0072\u0021\u0020\u0073\u0074\u0061\u0074\u0075\u0073\u003a\u0020${response.status}`);
      if (response.status === 401) {
        console.log(`\u767b\u5f55\u5931\u6548`);
        store$d.setAccessToken(``);
        store$d.set_updateVipDateTime(``);
        store$d.setUserInfoEndDate(``);
        await logout(store$d.accessToken);
      }
      if (response.status == 404) {
        return void 0;
      }
      return void 0;
    }
    const result = await response.json();
    sendLog(`\u0075\u0072\u006c\u003a` + url + `\uff0c\u0068\u0065\u0061\u0064\u0065\u0072\u003a` + JSON.stringify(headers) + `\u002c\u0070\u006f\u0073\u0074\u0044\u0061\u0074\u0061\uff1a` + JSON.stringify(postData) + `\u0020\u0072\u0065\u0073\u0070\u006f\u006e\u0073\u0065\u0020\u0073\u0074\u0061\u0074\u0075\u0073\u003a` + response.status + `\u002c\u0020\u0072\u0065\u0073\u0070\u006f\u006e\u0073\u0065\u0020\u0064\u0061\u0074\u0061\u003a` + JSON.stringify(result));
    console.log(`\u0072\u0065\u0073\u0075\u006c\u0074`, result);
    return result;
  } catch (error) {
    sendLog(`\u0075\u0072\u006c\u003a` + url + `\uff0c\u0068\u0065\u0061\u0064\u0065\u0072\u003a` + JSON.stringify(headers) + `\u002c\u0020\u0065\u0072\u0072\u006f\u0072` + error);
    console.error(`\u0045\u0072\u0072\u006f\u0072\u003a`, error);
  }
  return void 0;
}
async function queryTerminal() {
  const url = `${VITE_AGENT_BUSINESS_API}\u002f\u0061\u0070\u0069\u002f\u0074\u0065\u0072\u006d\u0069\u006e\u0061\u006c\u003f\u006f\u006e\u006c\u0079\u005f\u0062\u006f\u0075\u006e\u0064\u003d\u0074\u0072\u0075\u0065\u0026\u0061\u0067\u0065\u006e\u0074\u005f\u0069\u0064\u003d${VITE_AGENT_ID$4}\u0026\u0063\u006c\u0069\u0065\u006e\u0074\u005f\u0069\u0064\u003d${store$d.cpuSerialNumber}`;
  const headers = {
    "Content-Type": `\u0061\u0070\u0070\u006c\u0069\u0063\u0061\u0074\u0069\u006f\u006e\u002f\u006a\u0073\u006f\u006e`,
    "Authorization": `\u0042\u0065\u0061\u0072\u0065\u0072\u0020` + store$d.accessToken
  };
  try {
    const response = await fetch(url, {
      method: `\u0047\u0045\u0054`,
      headers
    });
    if (!response.ok) {
      sendLog(`\u0075\u0072\u006c\u003a` + url + `\uff0c\u0068\u0065\u0061\u0064\u0065\u0072\u003a` + JSON.stringify(headers) + `\u002c\u0020\u0072\u0065\u0073\u0070\u006f\u006e\u0073\u0065\u0020\u0073\u0074\u0061\u0074\u0075\u0073\u003a` + response.status);
      console.error(`\u0048\u0054\u0054\u0050\u0020\u0065\u0072\u0072\u006f\u0072\u0021\u0020\u0073\u0074\u0061\u0074\u0075\u0073\u003a\u0020${response.status}`);
      if (response.status === 401) {
        console.log(`\u767b\u5f55\u5931\u6548`);
        store$d.setAccessToken(``);
        store$d.set_updateVipDateTime(``);
        store$d.setUserInfoEndDate(``);
        await logout(store$d.accessToken);
      }
      if (response.status == 404) {
        return void 0;
      }
      return void 0;
    }
    const result = await response.json();
    sendLog(`\u0075\u0072\u006c\u003a` + url + `\uff0c\u0068\u0065\u0061\u0064\u0065\u0072\u003a` + JSON.stringify(headers) + `\u0020\u0072\u0065\u0073\u0070\u006f\u006e\u0073\u0065\u0020\u0073\u0074\u0061\u0074\u0075\u0073\u003a` + response.status + `\u002c\u0020\u0072\u0065\u0073\u0070\u006f\u006e\u0073\u0065\u0020\u0064\u0061\u0074\u0061\u003a` + JSON.stringify(result));
    console.log(`\u0072\u0065\u0073\u0075\u006c\u0074`, result);
    if (!result || result.total == 0 || !result.data) {
      return;
    }
    if (true) {
      if (result.data[0].terminal_id) {
        const completeTasksUrl = `${VITE_TASK_API}\u002f\u0061\u0070\u0069\u002f\u0074\u0061\u0073\u006b\u0073\u002f\u0063\u006f\u006d\u0070\u006c\u0065\u0074\u0065\u0064\u002d\u0061\u006c\u006c\u002d\u0074\u0061\u0073\u006b\u002d\u0062\u0079\u002d\u0074\u0065\u0072\u006d\u0069\u006e\u0061\u006c\u002f${result.data[0].terminal_id}`;
        const completeTasksHeaders = {
          "accept": `\u0061\u0070\u0070\u006c\u0069\u0063\u0061\u0074\u0069\u006f\u006e\u002f\u006a\u0073\u006f\u006e`,
          "Authorization": `\u0042\u0065\u0061\u0072\u0065\u0072\u0020` + store$d.accessToken
        };
        try {
          const completeTasksResponse = await fetch(completeTasksUrl, {
            method: `\u0050\u0055\u0054`,
            headers: completeTasksHeaders
          });
          if (!completeTasksResponse.ok) {
            sendLog(`\u0063\u006f\u006d\u0070\u006c\u0065\u0074\u0065\u0020\u0074\u0061\u0073\u006b\u0073\u0020\u0075\u0072\u006c\u003a` + completeTasksUrl + `\uff0c\u0068\u0065\u0061\u0064\u0065\u0072\u003a` + JSON.stringify(completeTasksHeaders) + `\u002c\u0020\u0072\u0065\u0073\u0070\u006f\u006e\u0073\u0065\u0020\u0073\u0074\u0061\u0074\u0075\u0073\u003a` + completeTasksResponse.status);
            console.error(`\u0043\u006f\u006d\u0070\u006c\u0065\u0074\u0065\u0020\u0074\u0061\u0073\u006b\u0073\u0020\u0048\u0054\u0054\u0050\u0020\u0065\u0072\u0072\u006f\u0072\u0021\u0020\u0073\u0074\u0061\u0074\u0075\u0073\u003a\u0020${completeTasksResponse.status}`);
          } else {
            sendLog(`\u0063\u006f\u006d\u0070\u006c\u0065\u0074\u0065\u0020\u0074\u0061\u0073\u006b\u0073\u0020\u0075\u0072\u006c\u003a` + completeTasksUrl + `\uff0c\u0068\u0065\u0061\u0064\u0065\u0072\u003a` + JSON.stringify(completeTasksHeaders) + `\u002c\u0020\u0072\u0065\u0073\u0070\u006f\u006e\u0073\u0065\u0020\u0073\u0074\u0061\u0074\u0075\u0073\u003a` + completeTasksResponse.status);
            console.log(`\u0053\u0075\u0063\u0063\u0065\u0073\u0073\u0066\u0075\u006c\u006c\u0079\u0020\u006d\u0061\u0072\u006b\u0065\u0064\u0020\u0061\u006c\u006c\u0020\u0074\u0061\u0073\u006b\u0073\u0020\u0061\u0073\u0020\u0063\u006f\u006d\u0070\u006c\u0065\u0074\u0065\u0064\u0020\u0066\u006f\u0072\u0020\u0074\u0065\u0072\u006d\u0069\u006e\u0061\u006c\u003a`, result.terminalId);
          }
        } catch (completeTasksError) {
          sendLog(`\u0063\u006f\u006d\u0070\u006c\u0065\u0074\u0065\u0020\u0074\u0061\u0073\u006b\u0073\u0020\u0075\u0072\u006c\u003a` + completeTasksUrl + `\uff0c\u0068\u0065\u0061\u0064\u0065\u0072\u003a` + JSON.stringify(completeTasksHeaders) + `\u002c\u0020\u0065\u0072\u0072\u006f\u0072` + completeTasksError);
          console.error(`\u0045\u0072\u0072\u006f\u0072\u0020\u0063\u006f\u006d\u0070\u006c\u0065\u0074\u0069\u006e\u0067\u0020\u0074\u0061\u0073\u006b\u0073\u003a`, completeTasksError);
        }
      }
    }
    return {
      terminalId: result.data[0].terminal_id,
      terminalName: result.data[0].terminal_name
    };
  } catch (error) {
    sendLog(`\u0075\u0072\u006c\u003a` + url + `\uff0c\u0068\u0065\u0061\u0064\u0065\u0072\u003a` + JSON.stringify(headers) + `\u002c\u0020\u0065\u0072\u0072\u006f\u0072` + error);
    console.error(`\u0045\u0072\u0072\u006f\u0072\u003a`, error);
  }
  return void 0;
}
async function saveTerminalBind(terminalId, postData) {
  console.log(`\u0074\u0065\u0072\u006d\u0069\u006e\u0061\u006c`, postData);
  const url = VITE_AGENT_BUSINESS_API + `\u002f\u0061\u0070\u0069\u002f\u0074\u0065\u0072\u006d\u0069\u006e\u0061\u006c\u002f` + terminalId + `\u002f\u0062\u0069\u006e\u0064`;
  const headers = {
    "Content-Type": `\u0061\u0070\u0070\u006c\u0069\u0063\u0061\u0074\u0069\u006f\u006e\u002f\u006a\u0073\u006f\u006e`,
    "Authorization": `\u0042\u0065\u0061\u0072\u0065\u0072\u0020` + store$d.accessToken
  };
  try {
    const response = await fetch(url, {
      method: `\u0050\u004f\u0053\u0054`,
      headers,
      body: JSON.stringify(postData)
    });
    if (!response.ok) {
      sendLog(`\u0075\u0072\u006c\u003a` + url + `\uff0c\u0068\u0065\u0061\u0064\u0065\u0072\u003a` + JSON.stringify(headers) + `\u002c\u0020\u0072\u0065\u0073\u0070\u006f\u006e\u0073\u0065\u0020\u0073\u0074\u0061\u0074\u0075\u0073\u003a` + response.status);
      console.error(`\u0048\u0054\u0054\u0050\u0020\u0065\u0072\u0072\u006f\u0072\u0021\u0020\u0073\u0074\u0061\u0074\u0075\u0073\u003a\u0020${response.status}`);
      if (response.status === 401) {
        console.log(`\u767b\u5f55\u5931\u6548`);
        store$d.setAccessToken(``);
        store$d.set_updateVipDateTime(``);
        store$d.setUserInfoEndDate(``);
        await logout(store$d.accessToken);
      }
      if (response.status == 404) {
        return void 0;
      }
      return void 0;
    }
    const result = await response.json();
    sendLog(`\u0075\u0072\u006c\u003a` + url + `\uff0c\u0068\u0065\u0061\u0064\u0065\u0072\u003a` + JSON.stringify(headers) + `\u002c\u0070\u006f\u0073\u0074\u0044\u0061\u0074\u0061\uff1a` + JSON.stringify(postData) + `\u0020\u0072\u0065\u0073\u0070\u006f\u006e\u0073\u0065\u0020\u0073\u0074\u0061\u0074\u0075\u0073\u003a` + response.status + `\u002c\u0020\u0072\u0065\u0073\u0070\u006f\u006e\u0073\u0065\u0020\u0064\u0061\u0074\u0061\u003a` + JSON.stringify(result));
    console.log(`\u0072\u0065\u0073\u0075\u006c\u0074`, result);
    return result;
  } catch (error) {
    sendLog(`\u0075\u0072\u006c\u003a` + url + `\uff0c\u0068\u0065\u0061\u0064\u0065\u0072\u003a` + JSON.stringify(headers) + `\u002c\u0020\u0065\u0072\u0072\u006f\u0072` + error);
    console.error(`\u0045\u0072\u0072\u006f\u0072\u003a`, error);
  }
  return void 0;
}
async function terminalCredentials(terminalId, accessToken) {
  const url = VITE_AGENT_BUSINESS_API + `\u002f\u0061\u0070\u0069\u002f\u0074\u0065\u0072\u006d\u0069\u006e\u0061\u006c\u002f` + terminalId + `\u002f\u0063\u0072\u0065\u0064\u0065\u006e\u0074\u0069\u0061\u006c\u0073`;
  const headers = {
    "Content-Type": `\u0061\u0070\u0070\u006c\u0069\u0063\u0061\u0074\u0069\u006f\u006e\u002f\u006a\u0073\u006f\u006e`,
    "Authorization": `\u0042\u0065\u0061\u0072\u0065\u0072\u0020` + accessToken
  };
  try {
    const response = await fetch(url, {
      method: `\u0047\u0045\u0054`,
      headers
    });
    if (!response.ok) {
      sendLog(`\u0075\u0072\u006c\u003a` + url + `\uff0c\u0068\u0065\u0061\u0064\u0065\u0072\u003a` + JSON.stringify(headers) + `\u002c\u0020\u0072\u0065\u0073\u0070\u006f\u006e\u0073\u0065\u0020\u0073\u0074\u0061\u0074\u0075\u0073\u003a` + response.status);
      console.error(`\u0048\u0054\u0054\u0050\u0020\u0065\u0072\u0072\u006f\u0072\u0021\u0020\u0073\u0074\u0061\u0074\u0075\u0073\u003a\u0020${response.status}`);
      if (response.status === 401) {
        console.log(`\u767b\u5f55\u5931\u6548`);
        store$d.setAccessToken(``);
        store$d.set_updateVipDateTime(``);
        store$d.setUserInfoEndDate(``);
        await logout(accessToken);
      }
      if (response.status == 404) {
        return void 0;
      }
      return void 0;
    }
    const result = await response.json();
    sendLog(`\u0075\u0072\u006c\u003a` + url + `\uff0c\u0068\u0065\u0061\u0064\u0065\u0072\u003a` + JSON.stringify(headers) + `\u0020\u0072\u0065\u0073\u0070\u006f\u006e\u0073\u0065\u0020\u0073\u0074\u0061\u0074\u0075\u0073\u003a` + response.status + `\u002c\u0020\u0072\u0065\u0073\u0070\u006f\u006e\u0073\u0065\u0020\u0064\u0061\u0074\u0061\u003a` + JSON.stringify(result));
    console.log(`\u0072\u0065\u0073\u0075\u006c\u0074`, result);
    return result;
  } catch (error) {
    sendLog(`\u0075\u0072\u006c\u003a` + url + `\uff0c\u0068\u0065\u0061\u0064\u0065\u0072\u003a` + JSON.stringify(headers) + `\u002c\u0020\u0065\u0072\u0072\u006f\u0072` + error);
    console.error(`\u0045\u0072\u0072\u006f\u0072\u003a`, error);
  }
  return void 0;
}
const store$c = UseCounterStore.getInstance();
const VITE_TERMINAL_API = `\u0068\u0074\u0074\u0070\u0073\u003a\u002f\u002f\u0061\u0067\u0065\u006e\u0074\u002d\u006e\u0065\u0074\u002e\u0070\u0061\u0069\u0074\u006f\u006e\u0067\u0061\u0069\u002e\u006e\u0065\u0074\u002f\u0074\u0065\u0072\u006d\u0069\u006e\u0061\u006c`;
async function register_terminal(agent_id, agent_name) {
  sendLog(`\u0072\u0065\u0067\u0069\u0073\u0074\u0065\u0072\u005f\u0074\u0065\u0072\u006d\u0069\u006e\u0061\u006c\u0020\u0061\u0063\u0063\u0065\u0073\u0073\u0054\u006f\u006b\u0065\u006e\u003a\u0020` + store$c.accessToken);
  const url = VITE_TERMINAL_API + `\u002f\u0061\u0070\u0069\u002f\u0074\u0065\u0072\u006d\u0069\u006e\u0061\u006c\u0073\u002f\u0072\u0065\u0067\u0069\u0073\u0074\u0065\u0072\u005f\u0074\u0065\u0072\u006d\u0069\u006e\u0061\u006c\u003f\u0061\u0067\u0065\u006e\u0074\u005f\u0069\u0064\u003d` + agent_id + `\u0026\u0061\u0067\u0065\u006e\u0074\u005f\u006e\u0061\u006d\u0065\u003d` + agent_name;
  const headers = {
    "Content-Type": `\u0061\u0070\u0070\u006c\u0069\u0063\u0061\u0074\u0069\u006f\u006e\u002f\u006a\u0073\u006f\u006e`,
    "Authorization": `\u0042\u0065\u0061\u0072\u0065\u0072\u0020` + store$c.accessToken
  };
  try {
    const response = await fetch(url, {
      method: `\u0050\u004f\u0053\u0054`,
      headers
    });
    if (!response.ok) {
      sendLog(`\u0075\u0072\u006c\u003a` + url + `\uff0c\u0068\u0065\u0061\u0064\u0065\u0072\u003a` + JSON.stringify(headers) + `\u002c\u0020\u0072\u0065\u0073\u0070\u006f\u006e\u0073\u0065\u0020\u0073\u0074\u0061\u0074\u0075\u0073\u003a` + response.status);
      console.error(`\u0048\u0054\u0054\u0050\u0020\u0065\u0072\u0072\u006f\u0072\u0021\u0020\u0073\u0074\u0061\u0074\u0075\u0073\u003a\u0020${response.status}`);
      if (response.status === 401) {
        console.log(`\u767b\u5f55\u5931\u6548`);
        store$c.setAccessToken(``);
        store$c.set_updateVipDateTime(``);
        store$c.setUserInfoEndDate(``);
        await logout(store$c.accessToken);
      }
      if (response.status == 404) {
        return void 0;
      }
      return void 0;
    }
    const result = await response.json();
    sendLog(`\u0075\u0072\u006c\u003a` + url + `\uff0c\u0068\u0065\u0061\u0064\u0065\u0072\u003a` + JSON.stringify(headers) + `\u0020\u0072\u0065\u0073\u0070\u006f\u006e\u0073\u0065\u0020\u0073\u0074\u0061\u0074\u0075\u0073\u003a` + response.status + `\u002c\u0020\u0072\u0065\u0073\u0070\u006f\u006e\u0073\u0065\u0020\u0064\u0061\u0074\u0061\u003a` + JSON.stringify(result));
    console.log(`\u0072\u0065\u0073\u0075\u006c\u0074`, result);
    return result;
  } catch (error) {
    sendLog(`\u0075\u0072\u006c\u003a` + url + `\uff0c\u0068\u0065\u0061\u0064\u0065\u0072\u003a` + JSON.stringify(headers) + `\u002c\u0020\u0065\u0072\u0072\u006f\u0072` + error);
    console.error(`\u0045\u0072\u0072\u006f\u0072\u003a`, error);
  }
  return void 0;
}
const store$b = UseCounterStore.getInstance();
const VITE_LOGIN_API = `\u0068\u0074\u0074\u0070\u0073\u003a\u002f\u002f\u0067\u006c\u006f\u0062\u0061\u006c\u002d\u0061\u0075\u0074\u0068\u002e\u0070\u0065\u0074\u0072\u006f\u006e\u002e\u0061\u0069`;
function getStorageValue(key) {
  return new Promise(resolve => {
    chrome.storage.local.get(key, result => {
      resolve(result[key]);
    });
  });
}
async function tenantsMine() {
  console.log(`\u0074\u0065\u006e\u0061\u006e\u0074\u0073\u004d\u0069\u006e\u0065`);
  let accessToken = await getStorageValue(`\u0061\u0063\u0063\u0065\u0073\u0073\u0054\u006f\u006b\u0065\u006e`);
  const url = VITE_LOGIN_API + `\u002f\u0061\u0070\u0069\u002f\u0076\u0031\u002f\u0074\u0065\u006e\u0061\u006e\u0074\u0073\u002f\u006d\u0069\u006e\u0065`;
  const headers = {
    "Content-Type": `\u0061\u0070\u0070\u006c\u0069\u0063\u0061\u0074\u0069\u006f\u006e\u002f\u006a\u0073\u006f\u006e`,
    "Authorization": `\u0042\u0065\u0061\u0072\u0065\u0072\u0020` + accessToken
  };
  try {
    const response = await fetch(url, {
      method: `\u0047\u0045\u0054`,
      headers
    });
    if (!response.ok) {
      sendLog(`\u0075\u0072\u006c\u003a` + url + `\uff0c\u0068\u0065\u0061\u0064\u0065\u0072\u003a` + JSON.stringify(headers) + `\u002c\u0020\u0072\u0065\u0073\u0070\u006f\u006e\u0073\u0065\u0020\u0073\u0074\u0061\u0074\u0075\u0073\u003a` + response.status);
      console.error(`\u0048\u0054\u0054\u0050\u0020\u0065\u0072\u0072\u006f\u0072\u0021\u0020\u0073\u0074\u0061\u0074\u0075\u0073\u003a\u0020${response.status}`);
      if (response.status === 401) {
        console.log(`\u767b\u5f55\u5931\u6548`);
        store$b.setAccessToken(``);
        store$b.set_updateVipDateTime(``);
        store$b.setUserInfoEndDate(``);
        if (typeof accessToken === `\u0073\u0074\u0072\u0069\u006e\u0067`) {
          await logout(accessToken);
        }
      }
      if (response.status == 404) {
        return void 0;
      }
      return void 0;
    }
    const result = await response.json();
    sendLog(`\u0075\u0072\u006c\u003a` + url + `\uff0c\u0068\u0065\u0061\u0064\u0065\u0072\u003a` + JSON.stringify(headers) + `\u002c\u0020\u0072\u0065\u0073\u0070\u006f\u006e\u0073\u0065\u0020\u0073\u0074\u0061\u0074\u0075\u0073\u003a` + response.status + `\u002c\u0020\u0072\u0065\u0073\u0070\u006f\u006e\u0073\u0065\u0020\u0064\u0061\u0074\u0061\u003a` + JSON.stringify(result));
    console.log(`\u0072\u0065\u0073\u0075\u006c\u0074`, result);
    return result;
  } catch (error) {
    sendLog(`\u0075\u0072\u006c\u003a` + url + `\uff0c\u0068\u0065\u0061\u0064\u0065\u0072\u003a` + JSON.stringify(headers) + `\u002c\u0020\u0065\u0072\u0072\u006f\u0072` + error);
    console.error(`\u0045\u0072\u0072\u006f\u0072\u003a`, error);
  }
  return void 0;
}
const agentBusiness = async (boolBind = false) => {
  try {
    let terminalInfo = await queryTerminal();
    if (!terminalInfo) {
      const VITE_AGENT_ID22 = `\u0078\u0069\u0061\u006f\u0073\u0068\u0075\u0074\u0069\u0061\u006f\u002d\u0061\u0075\u0074\u006f\u006d\u0061\u0074\u0069\u0063\u002d\u0065\u0078\u0074\u0065\u006e\u0073\u0069\u006f\u006e`;
      const VITE_AGENT_NAME = `\u5ba2\u8d44\u5de5\u5177`;
      const terminal_result = await register_terminal(VITE_AGENT_ID22, VITE_AGENT_NAME);
      if (!terminal_result || !terminal_result.terminalId) {
        console.log(`\u6ce8\u518c\u8bbe\u5907\u9519\u8bef`);
        console.error(`\u6ce8\u518c\u8bbe\u5907\u5931\u8d25`);
        return false;
      }
      const postTerminalData = {
        "agent_id": VITE_AGENT_ID22,
        "terminal_name": store$b.webUserName ? store$b.webUserName : `\u8bf7\u8bbe\u7f6e\u8bbe\u5907\u540d\u79f0`,
        "tenant_id": store$b.tenantId,
        "terminal_info": {
          "client_id": store$b.cpuSerialNumber
        }
      };
      const saveTerminalResult = await saveTerminal(terminal_result.terminalId, postTerminalData);
      if (!saveTerminalResult || !saveTerminalResult.data) {
        console.log(`\u4fdd\u5b58\u8bbe\u5907\u9519\u8bef`);
        console.error(`\u4fdd\u5b58\u8bbe\u5907\u5931\u8d25`);
        return false;
      }
      terminalInfo = await queryTerminal();
      if (!terminalInfo) {
        console.log(`\u6ca1\u6709\u8bbe\u5907\u4fe1\u606f`);
        console.error(`\u83b7\u53d6\u8bbe\u5907\u4fe1\u606f\u5931\u8d25`);
        return false;
      }
    } else {
      if (boolBind) {
        const saveTerminalBindData = {
          "terminal_name": store$b.webUserName ? store$b.webUserName : `\u8bf7\u8bbe\u7f6e\u8bbe\u5907\u540d\u79f0`
        };
        const saveTerminalBindRes = await saveTerminalBind(terminalInfo.terminalId, saveTerminalBindData);
        console.log(`\u0061\u0067\u0065\u006e\u0074\u0042\u0075\u0073\u0069\u006e\u0065\u0073\u0073\u0020\u0073\u0061\u0076\u0065\u0054\u0065\u0072\u006d\u0069\u006e\u0061\u006c\u0042\u0069\u006e\u0064\u0052\u0065\u0073`, saveTerminalBindRes);
      }
    }
    const terminalCredentialsResult = await terminalCredentials(terminalInfo.terminalId, store$b.accessToken);
    if (!terminalCredentialsResult || !terminalCredentialsResult.data || !terminalCredentialsResult.data.mqtt_username || !terminalCredentialsResult.data.mqtt_password) {
      console.log(`\u83b7\u53d6\u5bc6\u7801\u9519\u8bef`);
      console.error(`\u83b7\u53d6\u8fde\u63a5\u4fe1\u606f\u5931\u8d25`);
      return false;
    }
    const VITE_AGENT_ID2 = `\u0078\u0069\u0061\u006f\u0073\u0068\u0075\u0074\u0069\u0061\u006f\u002d\u0061\u0075\u0074\u006f\u006d\u0061\u0074\u0069\u0063\u002d\u0065\u0078\u0074\u0065\u006e\u0073\u0069\u006f\u006e`;
    store$b.setTerminalData({
      terminalId: terminalInfo.terminalId,
      terminalName: terminalInfo.terminalName,
      topic: {
        // 订阅任务
        "task_topic": `\u002f\u006d\u0073\u0067\u002f\u0074\u0061\u0073\u006b\u002f${store$b.tenantId}\u002f\u002b\u002f${VITE_AGENT_ID2}\u002f${terminalInfo.terminalId}`,
        // 任务执行状态
        "task_reply_topics": `\u002f\u006d\u0073\u0067\u002f\u0072\u0065\u0070\u006c\u0079\u002f\u0074\u0065\u0072\u006d\u0069\u006e\u0061\u006c\u002f${store$b.tenantId}\u002f${store$b.userId}\u002f${VITE_AGENT_ID2}\u002f${terminalInfo.terminalId}`,
        // 终端状态
        "status_reply_topics": `\u002f\u006d\u0073\u0067\u002f\u0072\u0065\u0070\u006c\u0079\u002f\u0074\u0065\u0072\u006d\u0069\u006e\u0061\u006c\u002f${store$b.tenantId}\u002f${store$b.userId}\u002f${VITE_AGENT_ID2}\u002f${terminalInfo.terminalId}\u002f\u0073\u0074\u0061\u0074\u0075\u0073`,
        // 运行日志
        "run_logs_reply_topics": `\u002f\u006d\u0073\u0067\u002f\u0072\u0065\u0070\u006c\u0079\u002f\u0074\u0065\u0072\u006d\u0069\u006e\u0061\u006c\u002f${store$b.tenantId}\u002f${store$b.userId}\u002f${VITE_AGENT_ID2}\u002f${terminalInfo.terminalId}\u002f\u0072\u0075\u006e\u005f\u006c\u006f\u0067\u0073`,
        // 心跳
        "heart_beat_topics": `\u002f\u006d\u0073\u0067\u002f\u0072\u0065\u0070\u006c\u0079\u002f\u0074\u0065\u0072\u006d\u0069\u006e\u0061\u006c\u002f${store$b.tenantId}\u002f${store$b.userId}\u002f${VITE_AGENT_ID2}\u002f${terminalInfo.terminalId}\u002f\u0068\u0065\u0061\u0072\u0074\u005f\u0062\u0065\u0061\u0074`,
        // 报告
        "report_topics": `\u002f\u006d\u0073\u0067\u002f\u0072\u0065\u0070\u006c\u0079\u002f\u0074\u0065\u0072\u006d\u0069\u006e\u0061\u006c\u002f${store$b.tenantId}\u002f${store$b.userId}\u002f${VITE_AGENT_ID2}\u002f${terminalInfo.terminalId}\u002f\u0072\u0065\u0070\u006f\u0072\u0074`
      },
      "mqtt_username": terminalCredentialsResult.data.mqtt_username,
      "mqtt_password": terminalCredentialsResult.data.mqtt_password
    });
    console.log(`\u83b7\u53d6\u0074\u0065\u0072\u006d\u0069\u006e\u0061\u006c\u0043\u0072\u0065\u0064\u0065\u006e\u0074\u0069\u0061\u006c\u0073\u0020\u6210\u529f`);
    return true;
  } catch (e) {
    console.log(`\u0061\u0067\u0065\u006e\u0074\u0042\u0075\u0073\u0069\u006e\u0065\u0073\u0073\u0020\u0065` + e);
    console.error(`\u8fde\u63a5\u5931\u8d25\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5`);
  }
  return false;
};
const VITE_CONTENT_API$8 = `\u0068\u0074\u0074\u0070\u0073\u003a\u002f\u002f\u0061\u0067\u0065\u006e\u0074\u002d\u006e\u0065\u0074\u002e\u0070\u0061\u0069\u0074\u006f\u006e\u0067\u0061\u0069\u002e\u006e\u0065\u0074\u002f\u0063\u006f\u006e\u0074\u0065\u006e\u0074`;
const VITE_PAYMENT_API$1 = void 0;
const store$a = UseCounterStore.getInstance();
class CustomizeDouYinPushTask extends BaseTask {
  constructor(taskId, executeId, data, executeTask2) {
    super(taskId, executeId, data);
    __publicField(this, `\u0065\u0078\u0065\u0063\u0075\u0074\u0065\u0054\u0061\u0073\u006b`);
    //评论数量
    __publicField(this, `\u0078\u0068\u0073\u005f\u0076\u0069\u0065\u0077\u0043\u006f\u0075\u006e\u0074`);
    __publicField(this, `\u0078\u0068\u0073\u005f\u0043\u006f\u006d\u006d\u0065\u006e\u0074\u0043\u006f\u0075\u006e\u0074`);
    __publicField(this, `\u0078\u0068\u0073\u005f\u006c\u0069\u006b\u0065\u0043\u006f\u0075\u006e\u0074`);
    __publicField(this, `\u0078\u0068\u0073\u005f\u0066\u006f\u006c\u006c\u006f\u0077\u0043\u006f\u0075\u006e\u0074`);
    __publicField(this, `\u0078\u0068\u0073\u005f\u0063\u006f\u006c\u006c\u0065\u0063\u0074\u0043\u006f\u0075\u006e\u0074`);
    //评论数量
    __publicField(this, `\u0064\u0079\u005f\u0076\u0069\u0065\u0077\u0043\u006f\u0075\u006e\u0074`);
    __publicField(this, `\u0064\u0079\u005f\u0043\u006f\u006d\u006d\u0065\u006e\u0074\u0043\u006f\u0075\u006e\u0074`);
    __publicField(this, `\u0064\u0079\u005f\u006c\u0069\u006b\u0065\u0043\u006f\u0075\u006e\u0074`);
    __publicField(this, `\u0064\u0079\u005f\u0066\u006f\u006c\u006c\u006f\u0077\u0043\u006f\u0075\u006e\u0074`);
    __publicField(this, `\u0064\u0079\u005f\u0063\u006f\u006c\u006c\u0065\u0063\u0074\u0043\u006f\u0075\u006e\u0074`);
    __publicField(this, `\u0074\u0061\u0073\u006b\u0050\u006c\u0061\u0074\u0066\u006f\u0072\u006d`);
    __publicField(this, `\u0058\u0069\u0061\u006f\u0048\u006f\u006e\u0067\u0053\u0068\u0075\u005f\u0053\u0065\u0074\u0074\u0069\u006e\u0067`);
    __publicField(this, `\u006f\u0070\u0065\u0072\u0061\u0074\u0069\u006f\u006e\u0054\u0069\u006d\u0065`);
    __publicField(this, `\u0072\u0075\u006e\u004d\u0069\u006e\u0075\u0074\u0065\u0054\u0069\u006d\u0065`);
    __publicField(this, `\u0073\u0074\u0061\u0072\u0074\u004c\u006f\u0061\u0064`);
    __publicField(this, `\u006c\u006f\u0061\u0064\u0065\u006e\u0064`);
    // 上报数据
    __publicField(this, `\u0065\u0078\u0065\u0063\u0075\u0074\u0065\u004f\u0070\u0065\u0072\u0061\u0074\u0069\u006f\u006e\u0053\u0074\u0061\u0072\u0074\u0054\u0069\u006d\u0065`);
    __publicField(this, `\u0065\u0078\u0065\u0063\u0075\u0074\u0065\u004f\u0070\u0065\u0072\u0061\u0074\u0069\u006f\u006e\u0045\u006e\u0064\u0054\u0069\u006d\u0065`);
    __publicField(this, `\u0078\u0068\u0073\u005f\u006b\u0065\u0079\u0077\u006f\u0072\u0064\u0073\u005f\u006c\u0069\u0073\u0074`);
    __publicField(this, `\u0064\u006f\u0075\u0059\u0069\u006e\u005f\u006b\u0065\u0079\u0077\u006f\u0072\u0064\u0073\u005f\u006c\u0069\u0073\u0074`);
    __publicField(this, `\u0078\u0068\u0073\u005f\u006d\u0069\u006e\u0075\u0074\u0065`);
    __publicField(this, `\u0064\u0079\u005f\u006d\u0069\u006e\u0075\u0074\u0065`);
    __publicField(this, `\u0076\u0069\u0064\u0065\u006f\u004c\u0069\u006e\u006b`);
    __publicField(this, `\u0070\u006f\u0073\u0074\u0049\u0074\u0065\u006d\u0055\u0073\u0061\u0067\u0065`, async () => {
      const url = VITE_PAYMENT_API$1 + `\u002f\u0069\u0074\u0065\u006d\u005f\u0075\u0073\u0061\u0067\u0065\u003f\u0075\u0073\u0061\u0067\u0065\u005f\u0074\u0079\u0070\u0065\u003d\u0070\u0075\u0062\u006c\u0069\u0073\u0068`;
      const headers = {
        accept: `\u0061\u0070\u0070\u006c\u0069\u0063\u0061\u0074\u0069\u006f\u006e\u002f\u006a\u0073\u006f\u006e`,
        ...this.addAuthorizationHeader()
      };
      try {
        const response = await fetch(url, {
          method: `\u0050\u004f\u0053\u0054`,
          headers
        });
        if (!response.ok) {
          console.log(`\u0075\u0072\u006c\u003a` + url + `\uff0c\u0068\u0065\u0061\u0064\u0065\u0072\u003a` + JSON.stringify(headers) + `\u002c\u0020\u0072\u0065\u0073\u0070\u006f\u006e\u0073\u0065\u0020\u0073\u0074\u0061\u0074\u0075\u0073\u003a` + response.status);
          return;
        }
        const result = await response.json();
        console.log(`\u0075\u0072\u006c\u003a` + url + `\uff0c\u0068\u0065\u0061\u0064\u0065\u0072\u003a` + JSON.stringify(headers) + `\u002c\u0072\u0065\u0073\u0070\u006f\u006e\u0073\u0065\u0020\u0073\u0074\u0061\u0074\u0075\u0073\u003a` + response.status + `\u002c\u0020\u0072\u0065\u0073\u0070\u006f\u006e\u0073\u0065\u0020\u0064\u0061\u0074\u0061\u003a` + JSON.stringify(result));
      } catch (error) {
        console.error(`\u8bf7\u6c42\u5931\u8d25\u003a`, error);
      }
    });
    // reportVideoLink(videoLink:string){
    //     console.log("reportVideoLink")
    //     if(!this.conn){
    //         return
    //     }
    //     const  status = this.getStatus();
    //     status.videoLink = videoLink; // 添加新属性
    //
    //     this.conn.messageToReplyMQTT({
    //         "taskId": this.taskId,
    //         "executeId": this.executeId,
    //         "status": "running",
    //         "meta": status,
    //         "message": ""
    //     });
    // }
    __publicField(this, `\u0072\u0065\u0070\u006f\u0072\u0074\u0052\u0075\u006e\u0044\u0061\u0074\u0061\u0053\u0074\u0061\u0074\u0075\u0073`, async () => {
      var _a;
      console.log(`\u0072\u0065\u0070\u006f\u0072\u0074\u0052\u0075\u006e\u0044\u0061\u0074\u0061\u0053\u0074\u0061\u0074\u0075\u0073`);
      if (!this.conn) {
        return;
      }
      const runData = this.getRunData();
      console.log(`\u0072\u0075\u006e\u0044\u0061\u0074\u0061`, JSON.stringify(runData));
      this.conn.messageToStatusMQTT({
        "taskId": this.taskId,
        "data": runData,
        "userId": this.user_id,
        "terminalId": (_a = this.terminalData) == null ? void 0 : _a.terminalId
      });
    });
    __publicField(this, `\u0072\u0065\u0070\u006f\u0072\u0074\u0052\u0075\u006e\u0044\u0061\u0074\u0061`, async () => {
      var _a;
      const url = VITE_CONTENT_API$8 + `\u002f\u0061\u0070\u0069\u002f\u0063\u006f\u006e\u0074\u0065\u006e\u0074\u002f`;
      const headers = {
        "Content-Type": `\u0061\u0070\u0070\u006c\u0069\u0063\u0061\u0074\u0069\u006f\u006e\u002f\u006a\u0073\u006f\u006e`,
        ...this.addAuthorizationHeader()
        // Ensure this function works in the extension
      };
      try {
        console.log(`\u0072\u0065\u0070\u006f\u0072\u0074\u0052\u0075\u006e\u0044\u0061\u0074\u0061`);
        const runData = this.getRunData();
        console.log(`\u0072\u0075\u006e\u0044\u0061\u0074\u0061`, JSON.stringify(runData));
        const postData = {
          "taskId": this.taskId,
          "data": runData,
          "userId": this.user_id,
          "terminalId": (_a = this.terminalData) == null ? void 0 : _a.terminalId
        };
        const response = await fetch(url, {
          method: `\u0050\u004f\u0053\u0054`,
          headers,
          body: JSON.stringify(postData)
        });
        if (!response.ok) {
          console.log(`\u0075\u0072\u006c\u003a` + url + `\uff0c\u0068\u0065\u0061\u0064\u0065\u0072\u003a` + JSON.stringify(headers) + `\u002c\u0020\u0072\u0065\u0073\u0070\u006f\u006e\u0073\u0065\u0020\u0073\u0074\u0061\u0074\u0075\u0073\u003a` + response.status);
          return;
        }
        const result = await response.json();
        console.log(`\u0075\u0072\u006c\u003a` + url + `\uff0c\u0068\u0065\u0061\u0064\u0065\u0072\u003a` + JSON.stringify(headers) + `\u002c\u0070\u006f\u0073\u0074\u0044\u0061\u0074\u0061\uff1a` + JSON.stringify(postData) + `\u0020\u0072\u0065\u0073\u0070\u006f\u006e\u0073\u0065\u0020\u0073\u0074\u0061\u0074\u0075\u0073\u003a` + response.status + `\u002c\u0020\u0072\u0065\u0073\u0070\u006f\u006e\u0073\u0065\u0020\u0064\u0061\u0074\u0061\u003a` + JSON.stringify(result));
      } catch (error) {
        console.log(`\u0045\u0072\u0072\u006f\u0072\u0020\u0069\u006e\u0020\u0070\u0075\u0074\u004e\u0065\u0077\u0054\u0061\u0073\u006b\u003a`, error);
        sendLog(`\u0075\u0072\u006c\u003a` + url + `\uff0c\u0068\u0065\u0061\u0064\u0065\u0072\u003a` + JSON.stringify(headers) + `\u002c\u0020\u0065\u0072\u0072\u006f\u0072` + error);
      }
    });
    __publicField(this, `\u0063\u0061\u006c\u006c\u0042\u0061\u0063\u006b\u004c\u0069\u0073\u0074\u0065\u006e\u0065\u0072`, (changes, namespace) => {
      for (let [key, {
        oldValue,
        newValue
      }] of Object.entries(changes)) {
        console.log(`\u0063\u0075\u0073\u0074\u006f\u006d\u0069\u007a\u0065\u0054\u0061\u0073\u006b\u0020\u0053\u0074\u006f\u0072\u0061\u0067\u0065\u0020\u006b\u0065\u0079\u0020\u0022${key}\u0022\u0020\u0069\u006e\u0020\u006e\u0061\u006d\u0065\u0073\u0070\u0061\u0063\u0065\u0020\u0022${namespace}\u0022\u0020\u0063\u0068\u0061\u006e\u0067\u0065\u0064\u002e`, `\u004f\u006c\u0064\u0020\u0076\u0061\u006c\u0075\u0065\u0020\u0077\u0061\u0073\u0020\u0022${oldValue}\u0022\u002c\u0020\u006e\u0065\u0077\u0020\u0076\u0061\u006c\u0075\u0065\u0020\u0069\u0073\u0020\u0022${newValue}\u0022\u002e`);
        switch (key) {
          case `\u0072\u0075\u006e\u0054\u0061\u0073\u006b\u0053\u0074\u006f\u0070\u0070\u0065\u0064`:
            if (newValue == `\u0065\u006e\u0064`) {
              this.reportStop().then(() => {});
            }
            break;
          case `\u0074\u0061\u0073\u006b\u0050\u006c\u0061\u0074\u0066\u006f\u0072\u006d`:
            this.taskPlatform = newValue;
            break;
          case `\u0058\u0069\u0061\u006f\u0048\u006f\u006e\u0067\u0053\u0068\u0075\u005f\u0053\u0065\u0074\u0074\u0069\u006e\u0067`:
            this.XiaoHongShu_Setting = newValue ? JSON.parse(newValue) : {};
            break;
          case `\u006f\u0072\u0067\u0049\u0064`:
            this.orgId = newValue;
            break;
          case `\u0075\u0073\u0065\u0072\u0049\u0064`:
            this.user_id = newValue;
            break;
          case `\u0063\u006c\u0069\u0065\u006e\u0074\u0056\u0069\u0073\u0069\u0074\u006f\u0072\u0049\u0064`:
            this.clientVisitorId = newValue;
            break;
          case `\u0061\u0063\u0063\u0065\u0073\u0073\u0054\u006f\u006b\u0065\u006e`:
            this.accessToken = newValue;
            break;
          case `\u006f\u0070\u0065\u0072\u0061\u0074\u0069\u006f\u006e\u0054\u0069\u006d\u0065`:
            this.operationTime = newValue;
            break;
          case `\u0072\u0075\u006e\u004d\u0069\u006e\u0075\u0074\u0065\u0054\u0069\u006d\u0065`:
            this.runMinuteTime = newValue;
            this.reportReply();
            break;
          case `\u0078\u0068\u0073\u005f\u006c\u0069\u006b\u0065\u0043\u006f\u0075\u006e\u0074`:
            this.xhs_likeCount = newValue;
            this.reportRunDataStatus().then();
            break;
          case `\u0078\u0068\u0073\u005f\u0066\u006f\u006c\u006c\u006f\u0077\u0043\u006f\u0075\u006e\u0074`:
            this.xhs_followCount = newValue;
            this.reportRunDataStatus().then();
            break;
          case `\u0078\u0068\u0073\u005f\u0043\u006f\u006d\u006d\u0065\u006e\u0074\u0043\u006f\u0075\u006e\u0074`:
            this.xhs_CommentCount = newValue;
            this.reportRunDataStatus().then();
            break;
          case `\u0078\u0068\u0073\u005f\u0063\u006f\u006c\u006c\u0065\u0063\u0074\u0043\u006f\u0075\u006e\u0074`:
            this.xhs_collectCount = newValue;
            this.reportRunDataStatus().then();
            break;
          case `\u0078\u0068\u0073\u005f\u0076\u0069\u0065\u0077\u0043\u006f\u0075\u006e\u0074`:
            this.xhs_viewCount = newValue;
            this.reportRunDataStatus().then();
            break;
          case `\u0064\u0079\u005f\u006c\u0069\u006b\u0065\u0043\u006f\u0075\u006e\u0074`:
            this.dy_likeCount = newValue;
            this.reportRunDataStatus().then();
            break;
          case `\u0064\u0079\u005f\u0066\u006f\u006c\u006c\u006f\u0077\u0043\u006f\u0075\u006e\u0074`:
            this.dy_followCount = newValue;
            this.reportRunDataStatus().then();
            break;
          case `\u0064\u0079\u005f\u0043\u006f\u006d\u006d\u0065\u006e\u0074\u0043\u006f\u0075\u006e\u0074`:
            this.dy_CommentCount = newValue;
            this.reportRunDataStatus().then();
            break;
          case `\u0064\u0079\u005f\u0063\u006f\u006c\u006c\u0065\u0063\u0074\u0043\u006f\u0075\u006e\u0074`:
            this.dy_collectCount = newValue;
            this.reportRunDataStatus().then();
            break;
          case `\u0064\u0079\u005f\u0076\u0069\u0065\u0077\u0043\u006f\u0075\u006e\u0074`:
            this.dy_viewCount = newValue;
            this.reportRunDataStatus().then();
            break;
          case `\u0065\u0078\u0065\u0063\u0075\u0074\u0065\u004f\u0070\u0065\u0072\u0061\u0074\u0069\u006f\u006e\u0053\u0074\u0061\u0072\u0074\u0054\u0069\u006d\u0065`:
            this.executeOperationStartTime = newValue;
            break;
          case `\u0065\u0078\u0065\u0063\u0075\u0074\u0065\u004f\u0070\u0065\u0072\u0061\u0074\u0069\u006f\u006e\u0045\u006e\u0064\u0054\u0069\u006d\u0065`:
            this.executeOperationEndTime = newValue;
            break;
          case `\u0078\u0068\u0073\u005f\u006b\u0065\u0079\u0077\u006f\u0072\u0064\u0073\u005f\u006c\u0069\u0073\u0074`:
            this.xhs_keywords_list = newValue ? JSON.parse(newValue) : [];
            break;
          case `\u0064\u006f\u0075\u0059\u0069\u006e\u005f\u006b\u0065\u0079\u0077\u006f\u0072\u0064\u0073\u005f\u006c\u0069\u0073\u0074`:
            this.douYin_keywords_list = newValue ? JSON.parse(newValue) : [];
            break;
          case `\u0078\u0068\u0073\u005f\u006d\u0069\u006e\u0075\u0074\u0065`:
            this.xhs_minute = newValue ? JSON.parse(newValue) : [];
            break;
          case `\u0064\u0079\u005f\u006d\u0069\u006e\u0075\u0074\u0065`:
            this.dy_minute = newValue ? JSON.parse(newValue) : [];
            break;
          case `\u0076\u0069\u0064\u0065\u006f\u004c\u0069\u006e\u006b`:
            this.videoLink = newValue;
            break;
        }
      }
    });
    this.startLoad = false;
    this.loadend = false;
    this.xhs_viewCount = 0;
    this.xhs_CommentCount = 0;
    this.xhs_likeCount = 0;
    this.xhs_followCount = 0;
    this.xhs_collectCount = 0;
    this.dy_viewCount = 0;
    this.dy_CommentCount = 0;
    this.dy_likeCount = 0;
    this.dy_followCount = 0;
    this.dy_collectCount = 0;
    this.operationTime = 0;
    this.runMinuteTime = 0;
    this.taskPlatform = ``;
    this.XiaoHongShu_Setting = ``;
    this.executeTask = executeTask2;
    this.executeOperationStartTime = 0;
    this.executeOperationEndTime = 0;
    this.xhs_keywords_list = [];
    this.douYin_keywords_list = [];
    this.xhs_minute = [];
    this.dy_minute = [];
    this.loadFromStorage();
  }
  /**
   * 检查配置是否正确
   */
  checkConfig() {
    return true;
  }
  startTask() {
    return new Promise(resolve => {
      const validationError = this.validateParameters();
      if (!this.conn) {
        return;
      }
      if (validationError) {
        console.error(validationError.message);
        this.conn.messageToReplyMQTT({
          "taskId": this.taskId,
          "executeId": this.executeId,
          "status": `\u0066\u0061\u0069\u006c\u0065\u0064`,
          "meta": {},
          "message": validationError.message
        });
        return;
      }
      console.log(`\u0044\u006f\u0020\u0061\u0020\u0063\u0075\u0073\u0074\u006f\u006d\u0069\u007a\u0065\u0020\u0074\u0061\u0073\u006b\u0021`);
      this.my_execute(this.data);
      this.conn.messageToReplyMQTT({
        "taskId": this.taskId,
        "executeId": this.executeId,
        "status": `\u0072\u0075\u006e\u006e\u0069\u006e\u0067`,
        "meta": this.getStatus(),
        "message": ``
      });
      resolve();
    });
  }
  validateParameters() {
    if (!this.data) {
      return {
        message: `\u53c2\u6570\u672a\u4f20\u9012\u6216\u683c\u5f0f\u4e0d\u6b63\u786e`
      };
    }
    return null;
  }
  my_execute(config) {
    chrome.storage.local.set({
      "runTaskStopped": ``
    });
    chrome.storage.local.set({
      "mqttStart": `\u006f\u006b`
    });
    chrome.storage.local.set({
      "xhs_viewCount": 0
    });
    chrome.storage.local.set({
      "xhs_CommentCount": 0
    });
    chrome.storage.local.set({
      "xhs_likeCount": 0
    });
    chrome.storage.local.set({
      "xhs_followCount": 0
    });
    chrome.storage.local.set({
      "xhs_collectCount": 0
    });
    chrome.storage.local.set({
      "dy_viewCount": 0
    });
    chrome.storage.local.set({
      "dy_CommentCount": 0
    });
    chrome.storage.local.set({
      "dy_likeCount": 0
    });
    chrome.storage.local.set({
      "dy_followCount": 0
    });
    chrome.storage.local.set({
      "dy_collectCount": 0
    });
    chrome.storage.local.set({
      "activatePage": runPages[0]
    });
    chrome.storage.local.set({
      "operationTime": 0
    });
    chrome.storage.local.set({
      "xiaoHongShuAccountErrorTip": ``
    });
    chrome.storage.local.set({
      "xhs_keywords_list": JSON.stringify([])
    });
    chrome.storage.local.set({
      "douYin_keywords_list": JSON.stringify([])
    });
    chrome.storage.local.set({
      "xhs_minute": JSON.stringify([])
    });
    chrome.storage.local.set({
      "dy_minute": JSON.stringify([])
    });
    chrome.storage.local.set({
      "optionsPageName": ``
    });
    chrome.storage.local.set({
      "executeOperationStartTime": (/* @__PURE__ */new Date()).getTime()
    });
    chrome.storage.local.set({
      "XiaoHongShu_Setting": JSON.stringify(config)
    });
    chrome.storage.local.set({
      "DouYin_search_runNumber": 1
    });
    if (!this.XiaoHongShu_Setting) {
      this.XiaoHongShu_Setting = config;
    }
    if (config.workDouYinPlatform == `\u6296\u97f3`) {
      if (!this.taskPlatform) {
        this.taskPlatform = config.workDouYinPlatform;
      }
      let url = `\u0068\u0074\u0074\u0070\u0073\u003a\u002f\u002f\u0063\u0072\u0065\u0061\u0074\u006f\u0072\u002e\u0064\u006f\u0075\u0079\u0069\u006e\u002e\u0063\u006f\u006d\u002f\u0063\u0072\u0065\u0061\u0074\u006f\u0072\u002d\u006d\u0069\u0063\u0072\u006f\u002f\u0063\u006f\u006e\u0074\u0065\u006e\u0074\u002f\u0075\u0070\u006c\u006f\u0061\u0064\u003f\u0064\u0065\u0066\u0061\u0075\u006c\u0074\u002d\u0074\u0061\u0062\u003d\u0033`;
      if (config.contentType == `\u89c6\u9891`) {
        url = `\u0068\u0074\u0074\u0070\u0073\u003a\u002f\u002f\u0063\u0072\u0065\u0061\u0074\u006f\u0072\u002e\u0064\u006f\u0075\u0079\u0069\u006e\u002e\u0063\u006f\u006d\u002f\u0063\u0072\u0065\u0061\u0074\u006f\u0072\u002d\u006d\u0069\u0063\u0072\u006f\u002f\u0063\u006f\u006e\u0074\u0065\u006e\u0074\u002f\u0075\u0070\u006c\u006f\u0061\u0064\u003f\u0064\u0065\u0066\u0061\u0075\u006c\u0074\u002d\u0074\u0061\u0062\u003d\u0031`;
      }
      this.executeTask({
        action: `\u0065\u0078\u0065\u0063\u0075\u0074\u0065\u0054\u0061\u0073\u006b`,
        url,
        taskName: config.taskName,
        taskPlatform: config.workDouYinPlatform,
        taskId: this.taskId
      }, {}, res => {
        if (res && res.tabId) {
          this.tabId = res.tabId;
        }
        if (res && res.windowId) {
          this.windowId = res.windowId;
        }
        console.log(`\u0065\u0078\u0065\u0063\u0075\u0074\u0065\u0054\u0061\u0073\u006b\u0020\u0072\u0065\u0073`, res);
      });
    }
    if (config.workXiaoHongShuPlatform == `\u5c0f\u7ea2\u4e66`) {
      this.executeTask({
        action: `\u0065\u0078\u0065\u0063\u0075\u0074\u0065\u0054\u0061\u0073\u006b`,
        url: `\u0068\u0074\u0074\u0070\u0073\u003a\u002f\u002f\u0077\u0077\u0077\u002e\u0078\u0069\u0061\u006f\u0068\u006f\u006e\u0067\u0073\u0068\u0075\u002e\u0063\u006f\u006d\u002f\u0065\u0078\u0070\u006c\u006f\u0072\u0065`,
        taskName: config.taskName,
        taskPlatform: config.workXiaoHongShuPlatform,
        taskId: this.taskId
      }, {}, res => {
        if (res && res.tabId) {
          this.tabId = res.tabId;
        }
        if (res && res.windowId) {
          this.windowId = res.windowId;
        }
        console.log(`\u0065\u0078\u0065\u0063\u0075\u0074\u0065\u0054\u0061\u0073\u006b\u0020\u0072\u0065\u0073`, res);
      });
      if (!this.taskPlatform) {
        this.taskPlatform = config.workXiaoHongShuPlatform;
      }
    }
  }
  stopTask() {
    return new Promise(resolve => {
      sendLog(`\u0063\u0075\u0073\u0074\u006f\u006d\u0069\u007a\u0065\u0044\u006f\u0075\u0059\u0069\u006e\u0050\u0075\u0073\u0068\u0054\u0061\u0073\u006b\u0020\u0062\u0061\u0063\u006b\u0067\u0072\u006f\u0075\u006e\u0064\u0020\u0061\u0063\u0074\u0069\u0076\u0061\u0074\u0065\u0050\u0061\u0067\u0065\u0020\uff1a`, indexPage);
      chrome.storage.local.set({
        "activatePage": indexPage
      });
      resolve();
    });
  }
  abortTask() {
    return new Promise(resolve => {
      this.reportStop().then(() => {});
      resolve();
    });
  }
  report() {
    return new Promise(resolve => {
      console.log(`\u0072\u0065\u0070\u006f\u0072\u0074\u0020\u0050\u0072\u006f\u006d\u0069\u0073\u0065`);
      try {
        let formatTimestamp = function (timestamp) {
            const date = new Date(timestamp);
            const month = String(date.getMonth() + 1).padStart(2, `\u0030`);
            const day = String(date.getDate()).padStart(2, `\u0030`);
            const hours = String(date.getHours()).padStart(2, `\u0030`);
            const minutes = String(date.getMinutes()).padStart(2, `\u0030`);
            return `${month}\u002d${day}\u0020${hours}\u003a${minutes}`;
          },
          calculateTimeDifference = function (startTimestamp, endTimestamp) {
            const differenceInMs = Math.abs(endTimestamp - startTimestamp);
            const totalMinutes = Math.floor(differenceInMs / (1e3 * 60));
            return `${totalMinutes}`;
          };
        if (!this.conn) {
          resolve();
          return;
        }
        const executeOperationStartTime = formatTimestamp(this.executeOperationStartTime);
        const executeOperationEndTime = formatTimestamp(this.executeOperationEndTime);
        const run_time = calculateTimeDifference(this.executeOperationStartTime, this.executeOperationEndTime);
        let xhs_keywords_list_str = ``;
        if (this.xhs_keywords_list.length > 0) {
          xhs_keywords_list_str = this.xhs_keywords_list.join(`\uff0c`);
        }
        let douYin_keywords_list_str = ``;
        if (this.douYin_keywords_list.length > 0) {
          douYin_keywords_list_str = this.douYin_keywords_list.join(`\uff0c`);
        }
        let XiaoHongShu_Setting = this.XiaoHongShu_Setting;
        let workRunPlatform = ``;
        if (XiaoHongShu_Setting.workDouYinPlatform) {
          if (!workRunPlatform) {
            workRunPlatform = XiaoHongShu_Setting.workDouYinPlatform;
          } else {
            workRunPlatform += `\u002b` + XiaoHongShu_Setting.workDouYinPlatform;
          }
        }
        if (XiaoHongShu_Setting.workXiaoHongShuPlatform) {
          if (!workRunPlatform) {
            workRunPlatform = XiaoHongShu_Setting.workXiaoHongShuPlatform;
          } else {
            workRunPlatform += `\u002b` + XiaoHongShu_Setting.workXiaoHongShuPlatform;
          }
        }
        const uniqueMinutes = [... /* @__PURE__ */new Set([...this.xhs_minute.map(item => item.minute), ...this.dy_minute.map(item => item.minute)])].sort((a, b) => a - b);
        const xhsNums = uniqueMinutes.map(minute => {
          var _a;
          return ((_a = this.xhs_minute.find(item => item.minute === minute)) == null ? void 0 : _a.num) || 0;
        });
        const xhsPieNumber = [{
          value: store$a.xhs_likeCount,
          name: `\u70b9\u8d5e`
        }, {
          value: store$a.xhs_CommentCount,
          name: `\u8bc4\u8bba`
        }, {
          value: store$a.xhs_followCount,
          name: `\u5173\u6ce8`
        }, {
          value: store$a.xhs_collectCount,
          name: `\u6536\u85cf`
        }];
        const dyPieNumber = [{
          value: store$a.dy_likeCount,
          name: `\u70b9\u8d5e`
        }, {
          value: store$a.dy_CommentCount,
          name: `\u8bc4\u8bba`
        }, {
          value: store$a.dy_followCount,
          name: `\u5173\u6ce8`
        }, {
          value: store$a.dy_collectCount,
          name: `\u6536\u85cf`
        }];
        const allPieNumber = [{
          value: store$a.xhs_likeCount + store$a.dy_likeCount,
          name: `\u70b9\u8d5e`
        }, {
          value: store$a.xhs_CommentCount + store$a.dy_CommentCount,
          name: `\u8bc4\u8bba`
        }, {
          value: store$a.xhs_followCount + store$a.dy_followCount,
          name: `\u5173\u6ce8`
        }, {
          value: store$a.xhs_collectCount + store$a.dy_collectCount,
          name: `\u6536\u85cf`
        }];
        const postData = {
          executeOperationStartTime,
          executeOperationEndTime,
          run_time,
          xhs_keywords_list_str,
          douYin_keywords_list_str,
          workRunPlatform,
          uniqueMinutes,
          xhsNums,
          xhsPieNumber,
          dyPieNumber,
          allPieNumber
        };
        console.log(`\u006d\u0065\u0073\u0073\u0061\u0067\u0065\u0054\u006f\u0052\u0065\u0070\u006f\u0072\u0074\u004d\u0051\u0054\u0054\u0020\u0070\u006f\u0073\u0074\u0044\u0061\u0074\u0061`, JSON.stringify(postData));
        sendLog(`\u0054\u0061\u0073\u006b\u0020\u0073\u0074\u006f\u0070\u0070\u0065\u0064`);
        this.conn.messageToReportMQTT({
          "taskId": this.taskId,
          "executeId": this.executeId,
          "status": `\u0072\u0065\u0070\u006f\u0072\u0074`,
          "meta": postData,
          "message": `\u62a5\u544a`
        });
        resolve();
      } catch (e) {
        console.log(`\u0072\u0065\u0070\u006f\u0072\u0074\u0020\u0065`, e);
      }
    });
  }
  /**
   * 获取心跳上报数据
   */
  getHeartReportData() {
    return {};
  }
  /**
   * 等待store 通知 callBackListener
   */
  async reportStop() {
    this.running = false;
    this.paused = false;
    this.callExecuteNotification();
    if (!this.conn) {
      return;
    }
    sendLog(`\u0054\u0061\u0073\u006b\u0020\u0073\u0074\u006f\u0070\u0070\u0065\u0064`);
    const status = this.getStatus();
    status.videoLink = this.videoLink;
    if (this.videoLink) {
      this.postItemUsage().then(r => {
        console.log(r);
      });
      this.conn.messageToReplyMQTT({
        "taskId": this.taskId,
        "executeId": this.executeId,
        "status": `\u0063\u006f\u006d\u0070\u006c\u0065\u0074\u0065\u0064`,
        "meta": status,
        "message": `\u5df2\u505c\u6b62`
      });
    }
    storageUtil.removeListener(this.callBackListener);
    super.baseReportStop();
  }
  getStatus() {
    return {
      id: this.taskId,
      running: this.running,
      paused: this.paused,
      started: this.started,
      process: this.operationTime > 0 ? (this.runMinuteTime / this.operationTime * 100).toFixed(2) : 0,
      total_num: this.operationTime,
      executed_num: this.runMinuteTime
    };
  }
  getRunData() {
    if (this.taskPlatform === `\u6296\u97f3`) {
      return {
        viewCount: this.dy_viewCount,
        commentCount: this.dy_CommentCount,
        likeCount: this.dy_likeCount,
        followCount: this.dy_followCount,
        collectCount: this.dy_collectCount,
        operationTime: this.operationTime,
        runMinuteTime: this.runMinuteTime
      };
    } else if (this.taskPlatform === `\u5c0f\u7ea2\u4e66`) {
      return {
        likeCount: this.xhs_likeCount,
        followCount: this.xhs_followCount,
        commentCount: this.xhs_CommentCount,
        collectCount: this.xhs_collectCount,
        viewCount: this.xhs_viewCount,
        operationTime: this.operationTime,
        runMinuteTime: this.runMinuteTime
      };
    }
  }
  reportReply() {
    console.log(`\u0072\u0065\u0070\u006f\u0072\u0074\u0052\u0065\u0070\u006c\u0079`);
    if (!this.conn) {
      return;
    }
    this.conn.messageToReplyMQTT({
      "taskId": this.taskId,
      "executeId": this.executeId,
      "status": `\u0072\u0075\u006e\u006e\u0069\u006e\u0067`,
      "meta": this.getStatus(),
      "message": ``
    });
  }
  loadFromStorage() {
    if (this.startLoad) {
      console.log(`\u0073\u0074\u0061\u0072\u0074\u004c\u006f\u0061\u0064`, this.startLoad);
      return;
    }
    this.startLoad = true;
    chrome.storage.local.get([`\u0074\u0061\u0073\u006b\u0050\u006c\u0061\u0074\u0066\u006f\u0072\u006d`, `\u0058\u0069\u0061\u006f\u0048\u006f\u006e\u0067\u0053\u0068\u0075\u005f\u0053\u0065\u0074\u0074\u0069\u006e\u0067`, `\u0078\u0068\u0073\u005f\u0076\u0069\u0065\u0077\u0043\u006f\u0075\u006e\u0074`, `\u0078\u0068\u0073\u005f\u0043\u006f\u006d\u006d\u0065\u006e\u0074\u0043\u006f\u0075\u006e\u0074`, `\u0078\u0068\u0073\u005f\u006c\u0069\u006b\u0065\u0043\u006f\u0075\u006e\u0074`, `\u0078\u0068\u0073\u005f\u0066\u006f\u006c\u006c\u006f\u0077\u0043\u006f\u0075\u006e\u0074`, `\u0078\u0068\u0073\u005f\u0063\u006f\u006c\u006c\u0065\u0063\u0074\u0043\u006f\u0075\u006e\u0074`, `\u0064\u0079\u005f\u0076\u0069\u0065\u0077\u0043\u006f\u0075\u006e\u0074`, `\u0064\u0079\u005f\u0043\u006f\u006d\u006d\u0065\u006e\u0074\u0043\u006f\u0075\u006e\u0074`, `\u0064\u0079\u005f\u006c\u0069\u006b\u0065\u0043\u006f\u0075\u006e\u0074`, `\u0064\u0079\u005f\u0066\u006f\u006c\u006c\u006f\u0077\u0043\u006f\u0075\u006e\u0074`, `\u0064\u0079\u005f\u0063\u006f\u006c\u006c\u0065\u0063\u0074\u0043\u006f\u0075\u006e\u0074`, `\u006f\u0070\u0065\u0072\u0061\u0074\u0069\u006f\u006e\u0054\u0069\u006d\u0065`, `\u0075\u0073\u0065\u0072\u0049\u0064`, `\u006f\u0072\u0067\u0049\u0064`, `\u0063\u006c\u0069\u0065\u006e\u0074\u0056\u0069\u0073\u0069\u0074\u006f\u0072\u0049\u0064`, `\u0061\u0063\u0063\u0065\u0073\u0073\u0054\u006f\u006b\u0065\u006e`], result => {
      console.log(`\u0072\u0065\u0073\u0075\u006c\u0074\u0020\u0061\u0063\u0074\u0069\u0076\u0061\u0074\u0065\u0050\u0061\u0067\u0065`, result);
      if (!result) {
        return;
      }
      if (result.userId !== void 0) {
        this.user_id = result.userId;
      }
      if (result.orgId !== void 0) {
        this.orgId = result.orgId;
      }
      if (result.clientVisitorId !== void 0) {
        this.clientVisitorId = result.clientVisitorId;
      }
      if (result.accessToken !== void 0) {
        this.accessToken = result.accessToken;
      }
      if (result.taskPlatform !== void 0) {
        this.taskPlatform = result.taskPlatform;
      }
      if (result.XiaoHongShu_Setting !== void 0) {
        this.XiaoHongShu_Setting = result.XiaoHongShu_Setting ? JSON.parse(result.XiaoHongShu_Setting) : {};
      }
      if (result.xhs_viewCount !== void 0) {
        this.xhs_viewCount = result.xhs_viewCount;
      }
      if (result.xhs_CommentCount !== void 0) {
        this.xhs_CommentCount = result.xhs_CommentCount;
      }
      if (result.xhs_likeCount !== void 0) {
        this.xhs_likeCount = result.xhs_likeCount;
      }
      if (result.xhs_followCount !== void 0) {
        this.xhs_followCount = result.xhs_followCount;
      }
      if (result.xhs_collectCount !== void 0) {
        this.xhs_collectCount = result.xhs_collectCount;
      }
      if (result.dy_viewCount !== void 0) {
        this.dy_viewCount = result.dy_viewCount;
      }
      if (result.dy_CommentCount !== void 0) {
        this.dy_CommentCount = result.dy_CommentCount;
      }
      if (result.dy_likeCount !== void 0) {
        this.dy_likeCount = result.dy_likeCount;
      }
      if (result.dy_followCount !== void 0) {
        this.dy_followCount = result.dy_followCount;
      }
      if (result.dy_collectCount !== void 0) {
        this.dy_collectCount = result.dy_collectCount;
      }
      if (result.operationTime !== void 0) {
        this.operationTime = result.operationTime;
      }
      this.startLoad = true;
      this.loadend = true;
    });
    storageUtil.addHandlers(this.callBackListener);
  }
}
const store$9 = UseCounterStore.getInstance();
const VITE_CHAT_API = `\u0068\u0074\u0074\u0070\u0073\u003a\u002f\u002f\u0077\u0065\u0063\u006f\u006d\u002d\u0063\u002d\u0072\u0065\u006c\u0065\u0061\u0073\u0065\u002d\u006c\u0062\u0065\u0063\u006b\u006c\u006b\u0068\u0061\u0061\u002e\u0063\u006e\u002d\u0068\u0075\u0068\u0065\u0068\u0061\u006f\u0074\u0065\u002e\u0066\u0063\u0061\u0070\u0070\u002e\u0072\u0075\u006e`;
async function saveTaskData(postData) {
  console.log(`\u0072\u0065\u0067\u0069\u0073\u0074\u0065\u0072\u005f\u0074\u0065\u0072\u006d\u0069\u006e\u0061\u006c\u0020\u0061\u0063\u0063\u0065\u0073\u0073\u0054\u006f\u006b\u0065\u006e\u003a\u0020` + store$9.accessToken);
  const url = VITE_CHAT_API + `\u002f\u0061\u0070\u0069\u002f\u0076\u0031\u002f\u0064\u006f\u0075\u0079\u0069\u006e\u002f\u0074\u0061\u0073\u006b`;
  const headers = {
    "Content-Type": `\u0061\u0070\u0070\u006c\u0069\u0063\u0061\u0074\u0069\u006f\u006e\u002f\u006a\u0073\u006f\u006e`,
    "Authorization": `\u0042\u0065\u0061\u0072\u0065\u0072\u0020` + store$9.accessToken
  };
  try {
    const response = await fetch(url, {
      method: `\u0050\u004f\u0053\u0054`,
      headers,
      body: JSON.stringify(postData)
    });
    if (!response.ok) {
      console.log(`\u0075\u0072\u006c\u003a` + url + `\uff0c\u0068\u0065\u0061\u0064\u0065\u0072\u003a` + JSON.stringify(headers) + `\u002c\u0020\u0072\u0065\u0073\u0070\u006f\u006e\u0073\u0065\u0020\u0073\u0074\u0061\u0074\u0075\u0073\u003a` + response.status);
      console.error(`\u0048\u0054\u0054\u0050\u0020\u0065\u0072\u0072\u006f\u0072\u0021\u0020\u0073\u0074\u0061\u0074\u0075\u0073\u003a\u0020${response.status}`);
      if (response.status == 404) {
        return void 0;
      }
      return void 0;
    }
    const result = await response.json();
    console.log(`\u0075\u0072\u006c\u003a` + url + `\uff0c\u0068\u0065\u0061\u0064\u0065\u0072\u003a` + JSON.stringify(headers) + `\u0020\u0072\u0065\u0073\u0070\u006f\u006e\u0073\u0065\u0020\u0073\u0074\u0061\u0074\u0075\u0073\u003a` + response.status + `\u002c\u0020\u0072\u0065\u0073\u0070\u006f\u006e\u0073\u0065\u0020\u0064\u0061\u0074\u0061\u003a` + JSON.stringify(result));
    console.log(`\u0072\u0065\u0073\u0075\u006c\u0074`, result);
    return result;
  } catch (error) {
    console.log(`\u0075\u0072\u006c\u003a` + url + `\uff0c\u0068\u0065\u0061\u0064\u0065\u0072\u003a` + JSON.stringify(headers) + `\u002c\u0020\u0065\u0072\u0072\u006f\u0072` + error);
    console.error(`\u0045\u0072\u0072\u006f\u0072\u003a`, error);
  }
  return void 0;
}
const VITE_CONTENT_API$7 = `\u0068\u0074\u0074\u0070\u0073\u003a\u002f\u002f\u0061\u0067\u0065\u006e\u0074\u002d\u006e\u0065\u0074\u002e\u0070\u0061\u0069\u0074\u006f\u006e\u0067\u0061\u0069\u002e\u006e\u0065\u0074\u002f\u0063\u006f\u006e\u0074\u0065\u006e\u0074`;
const VITE_AGENT_ID$3 = `\u0078\u0069\u0061\u006f\u0073\u0068\u0075\u0074\u0069\u0061\u006f\u002d\u0061\u0075\u0074\u006f\u006d\u0061\u0074\u0069\u0063\u002d\u0065\u0078\u0074\u0065\u006e\u0073\u0069\u006f\u006e`;
const store$8 = UseCounterStore.getInstance();
class DouYinYangHaoZhuShouTask extends BaseTask {
  constructor(taskId, executeId, data, executeTask2) {
    super(taskId, executeId, data);
    __publicField(this, `\u0065\u0078\u0065\u0063\u0075\u0074\u0065\u0054\u0061\u0073\u006b`);
    //评论数量
    __publicField(this, `\u0078\u0068\u0073\u005f\u0076\u0069\u0065\u0077\u0043\u006f\u0075\u006e\u0074`);
    __publicField(this, `\u0078\u0068\u0073\u005f\u0043\u006f\u006d\u006d\u0065\u006e\u0074\u0043\u006f\u0075\u006e\u0074`);
    __publicField(this, `\u0078\u0068\u0073\u005f\u006c\u0069\u006b\u0065\u0043\u006f\u0075\u006e\u0074`);
    __publicField(this, `\u0078\u0068\u0073\u005f\u0066\u006f\u006c\u006c\u006f\u0077\u0043\u006f\u0075\u006e\u0074`);
    __publicField(this, `\u0078\u0068\u0073\u005f\u0063\u006f\u006c\u006c\u0065\u0063\u0074\u0043\u006f\u0075\u006e\u0074`);
    //评论数量
    __publicField(this, `\u0064\u0079\u005f\u0076\u0069\u0065\u0077\u0043\u006f\u0075\u006e\u0074`);
    __publicField(this, `\u0064\u0079\u005f\u0043\u006f\u006d\u006d\u0065\u006e\u0074\u0043\u006f\u0075\u006e\u0074`);
    __publicField(this, `\u0064\u0079\u005f\u006c\u0069\u006b\u0065\u0043\u006f\u0075\u006e\u0074`);
    __publicField(this, `\u0064\u0079\u005f\u0066\u006f\u006c\u006c\u006f\u0077\u0043\u006f\u0075\u006e\u0074`);
    __publicField(this, `\u0064\u0079\u005f\u0063\u006f\u006c\u006c\u0065\u0063\u0074\u0043\u006f\u0075\u006e\u0074`);
    __publicField(this, `\u0074\u0061\u0073\u006b\u0050\u006c\u0061\u0074\u0066\u006f\u0072\u006d`);
    __publicField(this, `\u0058\u0069\u0061\u006f\u0048\u006f\u006e\u0067\u0053\u0068\u0075\u005f\u0053\u0065\u0074\u0074\u0069\u006e\u0067`);
    __publicField(this, `\u006f\u0070\u0065\u0072\u0061\u0074\u0069\u006f\u006e\u0054\u0069\u006d\u0065`);
    __publicField(this, `\u0072\u0075\u006e\u004d\u0069\u006e\u0075\u0074\u0065\u0054\u0069\u006d\u0065`);
    __publicField(this, `\u0073\u0074\u0061\u0072\u0074\u004c\u006f\u0061\u0064`);
    __publicField(this, `\u006c\u006f\u0061\u0064\u0065\u006e\u0064`);
    // 上报数据
    __publicField(this, `\u0065\u0078\u0065\u0063\u0075\u0074\u0065\u004f\u0070\u0065\u0072\u0061\u0074\u0069\u006f\u006e\u0053\u0074\u0061\u0072\u0074\u0054\u0069\u006d\u0065`);
    __publicField(this, `\u0065\u0078\u0065\u0063\u0075\u0074\u0065\u004f\u0070\u0065\u0072\u0061\u0074\u0069\u006f\u006e\u0045\u006e\u0064\u0054\u0069\u006d\u0065`);
    __publicField(this, `\u0078\u0068\u0073\u005f\u006b\u0065\u0079\u0077\u006f\u0072\u0064\u0073\u005f\u006c\u0069\u0073\u0074`);
    __publicField(this, `\u0064\u006f\u0075\u0059\u0069\u006e\u005f\u006b\u0065\u0079\u0077\u006f\u0072\u0064\u0073\u005f\u006c\u0069\u0073\u0074`);
    __publicField(this, `\u0078\u0068\u0073\u005f\u006d\u0069\u006e\u0075\u0074\u0065`);
    __publicField(this, `\u0064\u0079\u005f\u006d\u0069\u006e\u0075\u0074\u0065`);
    __publicField(this, `\u0072\u0065\u0070\u006f\u0072\u0074\u0052\u0075\u006e\u0044\u0061\u0074\u0061\u0053\u0074\u0061\u0074\u0075\u0073`, async () => {
      var _a;
      console.log(`\u0072\u0065\u0070\u006f\u0072\u0074\u0052\u0075\u006e\u0044\u0061\u0074\u0061\u0053\u0074\u0061\u0074\u0075\u0073`);
      if (!this.conn) {
        return;
      }
      const runData = this.getRunData();
      console.log(`\u0072\u0075\u006e\u0044\u0061\u0074\u0061`, JSON.stringify(runData));
      this.conn.messageToStatusMQTT({
        "taskId": this.taskId,
        "data": runData,
        "userId": this.user_id,
        "terminalId": (_a = this.terminalData) == null ? void 0 : _a.terminalId
      });
    });
    __publicField(this, `\u0072\u0065\u0070\u006f\u0072\u0074\u0052\u0075\u006e\u0044\u0061\u0074\u0061`, async () => {
      var _a;
      const url = VITE_CONTENT_API$7 + `\u002f\u0061\u0070\u0069\u002f\u0063\u006f\u006e\u0074\u0065\u006e\u0074\u002f`;
      const headers = {
        "Content-Type": `\u0061\u0070\u0070\u006c\u0069\u0063\u0061\u0074\u0069\u006f\u006e\u002f\u006a\u0073\u006f\u006e`,
        ...this.addAuthorizationHeader()
        // Ensure this function works in the extension
      };
      try {
        console.log(`\u0072\u0065\u0070\u006f\u0072\u0074\u0052\u0075\u006e\u0044\u0061\u0074\u0061`);
        const runData = this.getRunData();
        console.log(`\u0072\u0075\u006e\u0044\u0061\u0074\u0061`, JSON.stringify(runData));
        const postData = {
          "taskId": this.taskId,
          "data": runData,
          "userId": this.user_id,
          "terminalId": (_a = this.terminalData) == null ? void 0 : _a.terminalId
        };
        const response = await fetch(url, {
          method: `\u0050\u004f\u0053\u0054`,
          headers,
          body: JSON.stringify(postData)
        });
        if (!response.ok) {
          console.log(`\u0075\u0072\u006c\u003a` + url + `\uff0c\u0068\u0065\u0061\u0064\u0065\u0072\u003a` + JSON.stringify(headers) + `\u002c\u0020\u0072\u0065\u0073\u0070\u006f\u006e\u0073\u0065\u0020\u0073\u0074\u0061\u0074\u0075\u0073\u003a` + response.status);
          return;
        }
        const result = await response.json();
        console.log(`\u0075\u0072\u006c\u003a` + url + `\uff0c\u0068\u0065\u0061\u0064\u0065\u0072\u003a` + JSON.stringify(headers) + `\u002c\u0070\u006f\u0073\u0074\u0044\u0061\u0074\u0061\uff1a` + JSON.stringify(postData) + `\u0020\u0072\u0065\u0073\u0070\u006f\u006e\u0073\u0065\u0020\u0073\u0074\u0061\u0074\u0075\u0073\u003a` + response.status + `\u002c\u0020\u0072\u0065\u0073\u0070\u006f\u006e\u0073\u0065\u0020\u0064\u0061\u0074\u0061\u003a` + JSON.stringify(result));
      } catch (error) {
        console.log(`\u0045\u0072\u0072\u006f\u0072\u0020\u0069\u006e\u0020\u0070\u0075\u0074\u004e\u0065\u0077\u0054\u0061\u0073\u006b\u003a`, error);
        sendLog(`\u0075\u0072\u006c\u003a` + url + `\uff0c\u0068\u0065\u0061\u0064\u0065\u0072\u003a` + JSON.stringify(headers) + `\u002c\u0020\u0065\u0072\u0072\u006f\u0072` + error);
      }
    });
    __publicField(this, `\u0063\u0061\u006c\u006c\u0042\u0061\u0063\u006b\u004c\u0069\u0073\u0074\u0065\u006e\u0065\u0072`, (changes, namespace) => {
      for (let [key, {
        oldValue,
        newValue
      }] of Object.entries(changes)) {
        console.log(`\u0063\u0075\u0073\u0074\u006f\u006d\u0069\u007a\u0065\u0054\u0061\u0073\u006b\u0020\u0053\u0074\u006f\u0072\u0061\u0067\u0065\u0020\u006b\u0065\u0079\u0020\u0022${key}\u0022\u0020\u0069\u006e\u0020\u006e\u0061\u006d\u0065\u0073\u0070\u0061\u0063\u0065\u0020\u0022${namespace}\u0022\u0020\u0063\u0068\u0061\u006e\u0067\u0065\u0064\u002e`, `\u004f\u006c\u0064\u0020\u0076\u0061\u006c\u0075\u0065\u0020\u0077\u0061\u0073\u0020\u0022${oldValue}\u0022\u002c\u0020\u006e\u0065\u0077\u0020\u0076\u0061\u006c\u0075\u0065\u0020\u0069\u0073\u0020\u0022${newValue}\u0022\u002e`);
        switch (key) {
          case `\u0072\u0075\u006e\u0054\u0061\u0073\u006b\u0053\u0074\u006f\u0070\u0070\u0065\u0064`:
            if (newValue == `\u0065\u006e\u0064`) {
              this.reportStop().then(() => {});
            }
            break;
          case `\u0074\u0061\u0073\u006b\u0050\u006c\u0061\u0074\u0066\u006f\u0072\u006d`:
            this.taskPlatform = newValue;
            break;
          case `\u0058\u0069\u0061\u006f\u0048\u006f\u006e\u0067\u0053\u0068\u0075\u005f\u0053\u0065\u0074\u0074\u0069\u006e\u0067`:
            this.XiaoHongShu_Setting = newValue ? JSON.parse(newValue) : {};
            break;
          case `\u006f\u0072\u0067\u0049\u0064`:
            this.orgId = newValue;
            break;
          case `\u0075\u0073\u0065\u0072\u0049\u0064`:
            this.user_id = newValue;
            break;
          case `\u0063\u006c\u0069\u0065\u006e\u0074\u0056\u0069\u0073\u0069\u0074\u006f\u0072\u0049\u0064`:
            this.clientVisitorId = newValue;
            break;
          case `\u0061\u0063\u0063\u0065\u0073\u0073\u0054\u006f\u006b\u0065\u006e`:
            this.accessToken = newValue;
            break;
          case `\u006f\u0070\u0065\u0072\u0061\u0074\u0069\u006f\u006e\u0054\u0069\u006d\u0065`:
            this.operationTime = newValue;
            break;
          case `\u0072\u0075\u006e\u004d\u0069\u006e\u0075\u0074\u0065\u0054\u0069\u006d\u0065`:
            this.runMinuteTime = newValue;
            this.reportReply();
            break;
          case `\u0078\u0068\u0073\u005f\u006c\u0069\u006b\u0065\u0043\u006f\u0075\u006e\u0074`:
            this.xhs_likeCount = newValue;
            this.reportRunDataStatus().then();
            break;
          case `\u0078\u0068\u0073\u005f\u0066\u006f\u006c\u006c\u006f\u0077\u0043\u006f\u0075\u006e\u0074`:
            this.xhs_followCount = newValue;
            this.reportRunDataStatus().then();
            break;
          case `\u0078\u0068\u0073\u005f\u0043\u006f\u006d\u006d\u0065\u006e\u0074\u0043\u006f\u0075\u006e\u0074`:
            this.xhs_CommentCount = newValue;
            this.reportRunDataStatus().then();
            break;
          case `\u0078\u0068\u0073\u005f\u0063\u006f\u006c\u006c\u0065\u0063\u0074\u0043\u006f\u0075\u006e\u0074`:
            this.xhs_collectCount = newValue;
            this.reportRunDataStatus().then();
            break;
          case `\u0078\u0068\u0073\u005f\u0076\u0069\u0065\u0077\u0043\u006f\u0075\u006e\u0074`:
            this.xhs_viewCount = newValue;
            this.reportRunDataStatus().then();
            break;
          case `\u0064\u0079\u005f\u006c\u0069\u006b\u0065\u0043\u006f\u0075\u006e\u0074`:
            this.dy_likeCount = newValue;
            this.reportRunDataStatus().then();
            break;
          case `\u0064\u0079\u005f\u0066\u006f\u006c\u006c\u006f\u0077\u0043\u006f\u0075\u006e\u0074`:
            this.dy_followCount = newValue;
            this.reportRunDataStatus().then();
            break;
          case `\u0064\u0079\u005f\u0043\u006f\u006d\u006d\u0065\u006e\u0074\u0043\u006f\u0075\u006e\u0074`:
            this.dy_CommentCount = newValue;
            this.reportRunDataStatus().then();
            break;
          case `\u0064\u0079\u005f\u0063\u006f\u006c\u006c\u0065\u0063\u0074\u0043\u006f\u0075\u006e\u0074`:
            this.dy_collectCount = newValue;
            this.reportRunDataStatus().then();
            break;
          case `\u0064\u0079\u005f\u0076\u0069\u0065\u0077\u0043\u006f\u0075\u006e\u0074`:
            this.dy_viewCount = newValue;
            this.reportRunDataStatus().then();
            break;
          case `\u0065\u0078\u0065\u0063\u0075\u0074\u0065\u004f\u0070\u0065\u0072\u0061\u0074\u0069\u006f\u006e\u0053\u0074\u0061\u0072\u0074\u0054\u0069\u006d\u0065`:
            this.executeOperationStartTime = newValue;
            break;
          case `\u0065\u0078\u0065\u0063\u0075\u0074\u0065\u004f\u0070\u0065\u0072\u0061\u0074\u0069\u006f\u006e\u0045\u006e\u0064\u0054\u0069\u006d\u0065`:
            this.executeOperationEndTime = newValue;
            break;
          case `\u0078\u0068\u0073\u005f\u006b\u0065\u0079\u0077\u006f\u0072\u0064\u0073\u005f\u006c\u0069\u0073\u0074`:
            this.xhs_keywords_list = newValue ? JSON.parse(newValue) : [];
            break;
          case `\u0064\u006f\u0075\u0059\u0069\u006e\u005f\u006b\u0065\u0079\u0077\u006f\u0072\u0064\u0073\u005f\u006c\u0069\u0073\u0074`:
            this.douYin_keywords_list = newValue ? JSON.parse(newValue) : [];
            break;
          case `\u0078\u0068\u0073\u005f\u006d\u0069\u006e\u0075\u0074\u0065`:
            this.xhs_minute = newValue ? JSON.parse(newValue) : [];
            break;
          case `\u0064\u0079\u005f\u006d\u0069\u006e\u0075\u0074\u0065`:
            this.dy_minute = newValue ? JSON.parse(newValue) : [];
            break;
        }
      }
    });
    this.startLoad = false;
    this.loadend = false;
    this.xhs_viewCount = 0;
    this.xhs_CommentCount = 0;
    this.xhs_likeCount = 0;
    this.xhs_followCount = 0;
    this.xhs_collectCount = 0;
    this.dy_viewCount = 0;
    this.dy_CommentCount = 0;
    this.dy_likeCount = 0;
    this.dy_followCount = 0;
    this.dy_collectCount = 0;
    this.operationTime = 0;
    this.runMinuteTime = 0;
    this.taskPlatform = ``;
    this.XiaoHongShu_Setting = ``;
    this.executeTask = executeTask2;
    this.executeOperationStartTime = 0;
    this.executeOperationEndTime = 0;
    this.xhs_keywords_list = [];
    this.douYin_keywords_list = [];
    this.xhs_minute = [];
    this.dy_minute = [];
    this.loadFromStorage();
  }
  /**
   * 检查配置是否正确
   */
  checkConfig() {
    return true;
  }
  startTask() {
    return new Promise(async resolve => {
      const validationError = this.validateParameters();
      if (!this.conn) {
        resolve();
        return;
      }
      if (validationError) {
        console.error(validationError.message);
        this.conn.messageToReplyMQTT({
          "taskId": this.taskId,
          "executeId": this.executeId,
          "status": `\u0066\u0061\u0069\u006c\u0065\u0064`,
          "meta": {},
          "message": validationError.message
        });
        resolve();
        return;
      }
      console.log(`\u0044\u006f\u0020\u0061\u0020\u0063\u0075\u0073\u0074\u006f\u006d\u0069\u007a\u0065\u0020\u0074\u0061\u0073\u006b\u0021`);
      await this.my_execute(this.data);
      this.conn.messageToReplyMQTT({
        "taskId": this.taskId,
        "executeId": this.executeId,
        "status": `\u0072\u0075\u006e\u006e\u0069\u006e\u0067`,
        "meta": this.getStatus(),
        "message": ``
      });
      resolve();
    });
  }
  validateParameters() {
    if (!this.data) {
      return {
        message: `\u53c2\u6570\u672a\u4f20\u9012\u6216\u683c\u5f0f\u4e0d\u6b63\u786e`
      };
    }
    return null;
  }
  async my_execute(config) {
    var _a;
    chrome.storage.local.set({
      "runTaskStopped": ``
    });
    chrome.storage.local.set({
      "mqttStart": `\u006f\u006b`
    });
    chrome.storage.local.set({
      "xhs_viewCount": 0
    });
    chrome.storage.local.set({
      "xhs_CommentCount": 0
    });
    chrome.storage.local.set({
      "xhs_likeCount": 0
    });
    chrome.storage.local.set({
      "xhs_followCount": 0
    });
    chrome.storage.local.set({
      "xhs_collectCount": 0
    });
    chrome.storage.local.set({
      "dy_viewCount": 0
    });
    chrome.storage.local.set({
      "dy_CommentCount": 0
    });
    chrome.storage.local.set({
      "dy_likeCount": 0
    });
    chrome.storage.local.set({
      "dy_followCount": 0
    });
    chrome.storage.local.set({
      "dy_collectCount": 0
    });
    chrome.storage.local.set({
      "activatePage": runPages[0]
    });
    chrome.storage.local.set({
      "operationTime": 0
    });
    chrome.storage.local.set({
      "xiaoHongShuAccountErrorTip": ``
    });
    chrome.storage.local.set({
      "xhs_keywords_list": JSON.stringify([])
    });
    chrome.storage.local.set({
      "douYin_keywords_list": JSON.stringify([])
    });
    chrome.storage.local.set({
      "xhs_minute": JSON.stringify([])
    });
    chrome.storage.local.set({
      "dy_minute": JSON.stringify([])
    });
    chrome.storage.local.set({
      "optionsPageName": ``
    });
    chrome.storage.local.set({
      "executeOperationStartTime": (/* @__PURE__ */new Date()).getTime()
    });
    chrome.storage.local.set({
      "XiaoHongShu_Setting": JSON.stringify(config)
    });
    chrome.storage.local.set({
      "DouYin_search_runNumber": 1
    });
    if (!this.XiaoHongShu_Setting) {
      this.XiaoHongShu_Setting = config;
    }
    if (config.workDouYinPlatform == `\u6296\u97f3`) {
      if (!this.taskPlatform) {
        this.taskPlatform = config.workDouYinPlatform;
      }
      const saveTaskDataResult = await saveTaskData({
        task_options: {
          taskId: this.taskId,
          executeId: this.executeId,
          agentId: VITE_AGENT_ID$3,
          terminalId: (_a = store$8.terminalData) == null ? void 0 : _a.terminalId
        }
      });
      console.log(`\u0073\u0061\u0076\u0065\u0054\u0061\u0073\u006b\u0044\u0061\u0074\u0061\u0052\u0065\u0073\u0075\u006c\u0074`, saveTaskDataResult);
      if (saveTaskDataResult && saveTaskDataResult.code == 0) {
        store$8.setQuestTaskId(saveTaskDataResult.data.id);
      }
      this.executeTask({
        action: `\u0065\u0078\u0065\u0063\u0075\u0074\u0065\u0054\u0061\u0073\u006b`,
        url: `\u0068\u0074\u0074\u0070\u0073\u003a\u002f\u002f\u0077\u0077\u0077\u002e\u0064\u006f\u0075\u0079\u0069\u006e\u002e\u0063\u006f\u006d`,
        taskName: config.workType,
        taskPlatform: config.workDouYinPlatform,
        taskId: this.taskId
      }, {}, res => {
        if (res && res.tabId) {
          this.tabId = res.tabId;
        }
        if (res && res.windowId) {
          this.windowId = res.windowId;
        }
        console.log(`\u0065\u0078\u0065\u0063\u0075\u0074\u0065\u0054\u0061\u0073\u006b\u0020\u0072\u0065\u0073`, res);
      });
    }
    if (config.workXiaoHongShuPlatform == `\u5c0f\u7ea2\u4e66`) {
      this.executeTask({
        action: `\u0065\u0078\u0065\u0063\u0075\u0074\u0065\u0054\u0061\u0073\u006b`,
        url: `\u0068\u0074\u0074\u0070\u0073\u003a\u002f\u002f\u0077\u0077\u0077\u002e\u0078\u0069\u0061\u006f\u0068\u006f\u006e\u0067\u0073\u0068\u0075\u002e\u0063\u006f\u006d\u002f\u0065\u0078\u0070\u006c\u006f\u0072\u0065`,
        taskName: config.workType,
        taskPlatform: config.workXiaoHongShuPlatform,
        taskId: this.taskId
      }, {}, res => {
        if (res && res.tabId) {
          this.tabId = res.tabId;
        }
        if (res && res.windowId) {
          this.windowId = res.windowId;
        }
        console.log(`\u0065\u0078\u0065\u0063\u0075\u0074\u0065\u0054\u0061\u0073\u006b\u0020\u0072\u0065\u0073`, res);
      });
      if (!this.taskPlatform) {
        this.taskPlatform = config.workXiaoHongShuPlatform;
      }
    }
  }
  stopTask() {
    return new Promise(resolve => {
      sendLog(`\u0064\u006f\u0075\u0059\u0069\u006e\u0059\u0061\u006e\u0067\u0048\u0061\u006f\u005a\u0068\u0075\u0053\u0068\u006f\u0075\u0054\u0061\u0073\u006b\u0020\u0062\u0061\u0063\u006b\u0067\u0072\u006f\u0075\u006e\u0064\u0020\u0061\u0063\u0074\u0069\u0076\u0061\u0074\u0065\u0050\u0061\u0067\u0065\u0020\uff1a`, indexPage);
      chrome.storage.local.set({
        "activatePage": indexPage
      });
      resolve();
    });
  }
  abortTask() {
    return new Promise(resolve => {
      this.reportStop().then(() => {});
      resolve();
    });
  }
  report() {
    return new Promise(resolve => {
      console.log(`\u0072\u0065\u0070\u006f\u0072\u0074\u0020\u0050\u0072\u006f\u006d\u0069\u0073\u0065`);
      try {
        let formatTimestamp = function (timestamp) {
            const date = new Date(timestamp);
            const month = String(date.getMonth() + 1).padStart(2, `\u0030`);
            const day = String(date.getDate()).padStart(2, `\u0030`);
            const hours = String(date.getHours()).padStart(2, `\u0030`);
            const minutes = String(date.getMinutes()).padStart(2, `\u0030`);
            return `${month}\u002d${day}\u0020${hours}\u003a${minutes}`;
          },
          calculateTimeDifference = function (startTimestamp, endTimestamp) {
            const differenceInMs = Math.abs(endTimestamp - startTimestamp);
            const totalMinutes = Math.floor(differenceInMs / (1e3 * 60));
            return `${totalMinutes}`;
          };
        if (!this.conn) {
          resolve();
          return;
        }
        const executeOperationStartTime = formatTimestamp(this.executeOperationStartTime);
        const executeOperationEndTime = formatTimestamp(this.executeOperationEndTime);
        const run_time = calculateTimeDifference(this.executeOperationStartTime, this.executeOperationEndTime);
        let xhs_keywords_list_str = ``;
        if (this.xhs_keywords_list.length > 0) {
          xhs_keywords_list_str = this.xhs_keywords_list.join(`\uff0c`);
        }
        let douYin_keywords_list_str = ``;
        if (this.douYin_keywords_list.length > 0) {
          douYin_keywords_list_str = this.douYin_keywords_list.join(`\uff0c`);
        }
        let XiaoHongShu_Setting = this.XiaoHongShu_Setting;
        let workRunPlatform = ``;
        if (XiaoHongShu_Setting.workDouYinPlatform) {
          if (!workRunPlatform) {
            workRunPlatform = XiaoHongShu_Setting.workDouYinPlatform;
          } else {
            workRunPlatform += `\u002b` + XiaoHongShu_Setting.workDouYinPlatform;
          }
        }
        if (XiaoHongShu_Setting.workXiaoHongShuPlatform) {
          if (!workRunPlatform) {
            workRunPlatform = XiaoHongShu_Setting.workXiaoHongShuPlatform;
          } else {
            workRunPlatform += `\u002b` + XiaoHongShu_Setting.workXiaoHongShuPlatform;
          }
        }
        const uniqueMinutes = [... /* @__PURE__ */new Set([...this.xhs_minute.map(item => item.minute), ...this.dy_minute.map(item => item.minute)])].sort((a, b) => a - b);
        const xhsNums = uniqueMinutes.map(minute => {
          var _a;
          return ((_a = this.xhs_minute.find(item => item.minute === minute)) == null ? void 0 : _a.num) || 0;
        });
        const xhsPieNumber = [{
          value: store$8.xhs_likeCount,
          name: `\u70b9\u8d5e`
        }, {
          value: store$8.xhs_CommentCount,
          name: `\u8bc4\u8bba`
        }, {
          value: store$8.xhs_followCount,
          name: `\u5173\u6ce8`
        }, {
          value: store$8.xhs_collectCount,
          name: `\u6536\u85cf`
        }];
        const dyPieNumber = [{
          value: store$8.dy_likeCount,
          name: `\u70b9\u8d5e`
        }, {
          value: store$8.dy_CommentCount,
          name: `\u8bc4\u8bba`
        }, {
          value: store$8.dy_followCount,
          name: `\u5173\u6ce8`
        }, {
          value: store$8.dy_collectCount,
          name: `\u6536\u85cf`
        }];
        const allPieNumber = [{
          value: store$8.xhs_likeCount + store$8.dy_likeCount,
          name: `\u70b9\u8d5e`
        }, {
          value: store$8.xhs_CommentCount + store$8.dy_CommentCount,
          name: `\u8bc4\u8bba`
        }, {
          value: store$8.xhs_followCount + store$8.dy_followCount,
          name: `\u5173\u6ce8`
        }, {
          value: store$8.xhs_collectCount + store$8.dy_collectCount,
          name: `\u6536\u85cf`
        }];
        const postData = {
          executeOperationStartTime,
          executeOperationEndTime,
          run_time,
          xhs_keywords_list_str,
          douYin_keywords_list_str,
          workRunPlatform,
          uniqueMinutes,
          xhsNums,
          xhsPieNumber,
          dyPieNumber,
          allPieNumber
        };
        console.log(`\u006d\u0065\u0073\u0073\u0061\u0067\u0065\u0054\u006f\u0052\u0065\u0070\u006f\u0072\u0074\u004d\u0051\u0054\u0054\u0020\u0070\u006f\u0073\u0074\u0044\u0061\u0074\u0061`, JSON.stringify(postData));
        sendLog(`\u0054\u0061\u0073\u006b\u0020\u0073\u0074\u006f\u0070\u0070\u0065\u0064`);
        this.conn.messageToReportMQTT({
          "taskId": this.taskId,
          "executeId": this.executeId,
          "status": `\u0072\u0065\u0070\u006f\u0072\u0074`,
          "meta": postData,
          "message": `\u62a5\u544a`
        });
        resolve();
      } catch (e) {
        console.log(`\u0072\u0065\u0070\u006f\u0072\u0074\u0020\u0065`, e);
      }
    });
  }
  /**
   * 获取心跳上报数据
   */
  getHeartReportData() {
    return {};
  }
  /**
   * 等待store 通知 callBackListener
   */
  async reportStop() {
    this.running = false;
    this.paused = false;
    this.callExecuteNotification();
    if (!this.conn) {
      return;
    }
    sendLog(`\u0054\u0061\u0073\u006b\u0020\u0073\u0074\u006f\u0070\u0070\u0065\u0064`);
    this.conn.messageToReplyMQTT({
      "taskId": this.taskId,
      "executeId": this.executeId,
      "status": `\u0063\u006f\u006d\u0070\u006c\u0065\u0074\u0065\u0064`,
      "meta": this.getStatus(),
      "message": `\u5df2\u505c\u6b62`
    });
    storageUtil.removeListener(this.callBackListener);
    super.baseReportStop();
  }
  getStatus() {
    return {
      id: this.taskId,
      running: this.running,
      paused: this.paused,
      started: this.started,
      process: this.operationTime > 0 ? (this.runMinuteTime / this.operationTime * 100).toFixed(2) : 0,
      total_num: this.operationTime,
      executed_num: this.runMinuteTime
    };
  }
  getRunData() {
    if (this.taskPlatform === `\u6296\u97f3`) {
      return {
        viewCount: this.dy_viewCount,
        commentCount: this.dy_CommentCount,
        likeCount: this.dy_likeCount,
        followCount: this.dy_followCount,
        collectCount: this.dy_collectCount,
        operationTime: this.operationTime,
        runMinuteTime: this.runMinuteTime
      };
    } else if (this.taskPlatform === `\u5c0f\u7ea2\u4e66`) {
      return {
        likeCount: this.xhs_likeCount,
        followCount: this.xhs_followCount,
        commentCount: this.xhs_CommentCount,
        collectCount: this.xhs_collectCount,
        viewCount: this.xhs_viewCount,
        operationTime: this.operationTime,
        runMinuteTime: this.runMinuteTime
      };
    }
  }
  reportReply() {
    console.log(`\u0072\u0065\u0070\u006f\u0072\u0074\u0052\u0065\u0070\u006c\u0079`);
    if (!this.conn) {
      return;
    }
    this.conn.messageToReplyMQTT({
      "taskId": this.taskId,
      "executeId": this.executeId,
      "status": `\u0072\u0075\u006e\u006e\u0069\u006e\u0067`,
      "meta": this.getStatus(),
      "message": ``
    });
  }
  loadFromStorage() {
    if (this.startLoad) {
      console.log(`\u0073\u0074\u0061\u0072\u0074\u004c\u006f\u0061\u0064`, this.startLoad);
      return;
    }
    this.startLoad = true;
    chrome.storage.local.get([`\u0074\u0061\u0073\u006b\u0050\u006c\u0061\u0074\u0066\u006f\u0072\u006d`, `\u0058\u0069\u0061\u006f\u0048\u006f\u006e\u0067\u0053\u0068\u0075\u005f\u0053\u0065\u0074\u0074\u0069\u006e\u0067`, `\u0078\u0068\u0073\u005f\u0076\u0069\u0065\u0077\u0043\u006f\u0075\u006e\u0074`, `\u0078\u0068\u0073\u005f\u0043\u006f\u006d\u006d\u0065\u006e\u0074\u0043\u006f\u0075\u006e\u0074`, `\u0078\u0068\u0073\u005f\u006c\u0069\u006b\u0065\u0043\u006f\u0075\u006e\u0074`, `\u0078\u0068\u0073\u005f\u0066\u006f\u006c\u006c\u006f\u0077\u0043\u006f\u0075\u006e\u0074`, `\u0078\u0068\u0073\u005f\u0063\u006f\u006c\u006c\u0065\u0063\u0074\u0043\u006f\u0075\u006e\u0074`, `\u0064\u0079\u005f\u0076\u0069\u0065\u0077\u0043\u006f\u0075\u006e\u0074`, `\u0064\u0079\u005f\u0043\u006f\u006d\u006d\u0065\u006e\u0074\u0043\u006f\u0075\u006e\u0074`, `\u0064\u0079\u005f\u006c\u0069\u006b\u0065\u0043\u006f\u0075\u006e\u0074`, `\u0064\u0079\u005f\u0066\u006f\u006c\u006c\u006f\u0077\u0043\u006f\u0075\u006e\u0074`, `\u0064\u0079\u005f\u0063\u006f\u006c\u006c\u0065\u0063\u0074\u0043\u006f\u0075\u006e\u0074`, `\u006f\u0070\u0065\u0072\u0061\u0074\u0069\u006f\u006e\u0054\u0069\u006d\u0065`, `\u0075\u0073\u0065\u0072\u0049\u0064`, `\u006f\u0072\u0067\u0049\u0064`, `\u0063\u006c\u0069\u0065\u006e\u0074\u0056\u0069\u0073\u0069\u0074\u006f\u0072\u0049\u0064`, `\u0061\u0063\u0063\u0065\u0073\u0073\u0054\u006f\u006b\u0065\u006e`], result => {
      console.log(`\u0072\u0065\u0073\u0075\u006c\u0074\u0020\u0061\u0063\u0074\u0069\u0076\u0061\u0074\u0065\u0050\u0061\u0067\u0065`, result);
      if (!result) {
        return;
      }
      if (result.userId !== void 0) {
        this.user_id = result.userId;
      }
      if (result.orgId !== void 0) {
        this.orgId = result.orgId;
      }
      if (result.clientVisitorId !== void 0) {
        this.clientVisitorId = result.clientVisitorId;
      }
      if (result.accessToken !== void 0) {
        this.accessToken = result.accessToken;
      }
      if (result.taskPlatform !== void 0) {
        this.taskPlatform = result.taskPlatform;
      }
      if (result.XiaoHongShu_Setting !== void 0) {
        this.XiaoHongShu_Setting = result.XiaoHongShu_Setting ? JSON.parse(result.XiaoHongShu_Setting) : {};
      }
      if (result.xhs_viewCount !== void 0) {
        this.xhs_viewCount = result.xhs_viewCount;
      }
      if (result.xhs_CommentCount !== void 0) {
        this.xhs_CommentCount = result.xhs_CommentCount;
      }
      if (result.xhs_likeCount !== void 0) {
        this.xhs_likeCount = result.xhs_likeCount;
      }
      if (result.xhs_followCount !== void 0) {
        this.xhs_followCount = result.xhs_followCount;
      }
      if (result.xhs_collectCount !== void 0) {
        this.xhs_collectCount = result.xhs_collectCount;
      }
      if (result.dy_viewCount !== void 0) {
        this.dy_viewCount = result.dy_viewCount;
      }
      if (result.dy_CommentCount !== void 0) {
        this.dy_CommentCount = result.dy_CommentCount;
      }
      if (result.dy_likeCount !== void 0) {
        this.dy_likeCount = result.dy_likeCount;
      }
      if (result.dy_followCount !== void 0) {
        this.dy_followCount = result.dy_followCount;
      }
      if (result.dy_collectCount !== void 0) {
        this.dy_collectCount = result.dy_collectCount;
      }
      if (result.operationTime !== void 0) {
        this.operationTime = result.operationTime;
      }
      this.startLoad = true;
      this.loadend = true;
    });
    storageUtil.addHandlers(this.callBackListener);
  }
}
const VITE_CONTENT_API$6 = `\u0068\u0074\u0074\u0070\u0073\u003a\u002f\u002f\u0061\u0067\u0065\u006e\u0074\u002d\u006e\u0065\u0074\u002e\u0070\u0061\u0069\u0074\u006f\u006e\u0067\u0061\u0069\u002e\u006e\u0065\u0074\u002f\u0063\u006f\u006e\u0074\u0065\u006e\u0074`;
const store$7 = UseCounterStore.getInstance();
class ShuJuJianKongCustomizeTask extends BaseTask {
  constructor(taskId, executeId, data, executeTask2) {
    super(taskId, executeId, data);
    __publicField(this, `\u0065\u0078\u0065\u0063\u0075\u0074\u0065\u0054\u0061\u0073\u006b`);
    //评论数量
    __publicField(this, `\u0078\u0068\u0073\u005f\u0076\u0069\u0065\u0077\u0043\u006f\u0075\u006e\u0074`);
    __publicField(this, `\u0078\u0068\u0073\u005f\u0043\u006f\u006d\u006d\u0065\u006e\u0074\u0043\u006f\u0075\u006e\u0074`);
    __publicField(this, `\u0078\u0068\u0073\u005f\u006c\u0069\u006b\u0065\u0043\u006f\u0075\u006e\u0074`);
    __publicField(this, `\u0078\u0068\u0073\u005f\u0066\u006f\u006c\u006c\u006f\u0077\u0043\u006f\u0075\u006e\u0074`);
    __publicField(this, `\u0078\u0068\u0073\u005f\u0063\u006f\u006c\u006c\u0065\u0063\u0074\u0043\u006f\u0075\u006e\u0074`);
    //评论数量
    __publicField(this, `\u0064\u0079\u005f\u0076\u0069\u0065\u0077\u0043\u006f\u0075\u006e\u0074`);
    __publicField(this, `\u0064\u0079\u005f\u0043\u006f\u006d\u006d\u0065\u006e\u0074\u0043\u006f\u0075\u006e\u0074`);
    __publicField(this, `\u0064\u0079\u005f\u006c\u0069\u006b\u0065\u0043\u006f\u0075\u006e\u0074`);
    __publicField(this, `\u0064\u0079\u005f\u0066\u006f\u006c\u006c\u006f\u0077\u0043\u006f\u0075\u006e\u0074`);
    __publicField(this, `\u0064\u0079\u005f\u0063\u006f\u006c\u006c\u0065\u0063\u0074\u0043\u006f\u0075\u006e\u0074`);
    __publicField(this, `\u0074\u0061\u0073\u006b\u0050\u006c\u0061\u0074\u0066\u006f\u0072\u006d`);
    __publicField(this, `\u0058\u0069\u0061\u006f\u0048\u006f\u006e\u0067\u0053\u0068\u0075\u005f\u0053\u0065\u0074\u0074\u0069\u006e\u0067`);
    __publicField(this, `\u006f\u0070\u0065\u0072\u0061\u0074\u0069\u006f\u006e\u0054\u0069\u006d\u0065`);
    __publicField(this, `\u0072\u0075\u006e\u004d\u0069\u006e\u0075\u0074\u0065\u0054\u0069\u006d\u0065`);
    __publicField(this, `\u0073\u0074\u0061\u0072\u0074\u004c\u006f\u0061\u0064`);
    __publicField(this, `\u006c\u006f\u0061\u0064\u0065\u006e\u0064`);
    // 上报数据
    __publicField(this, `\u0065\u0078\u0065\u0063\u0075\u0074\u0065\u004f\u0070\u0065\u0072\u0061\u0074\u0069\u006f\u006e\u0053\u0074\u0061\u0072\u0074\u0054\u0069\u006d\u0065`);
    __publicField(this, `\u0065\u0078\u0065\u0063\u0075\u0074\u0065\u004f\u0070\u0065\u0072\u0061\u0074\u0069\u006f\u006e\u0045\u006e\u0064\u0054\u0069\u006d\u0065`);
    __publicField(this, `\u0078\u0068\u0073\u005f\u006b\u0065\u0079\u0077\u006f\u0072\u0064\u0073\u005f\u006c\u0069\u0073\u0074`);
    __publicField(this, `\u0064\u006f\u0075\u0059\u0069\u006e\u005f\u006b\u0065\u0079\u0077\u006f\u0072\u0064\u0073\u005f\u006c\u0069\u0073\u0074`);
    __publicField(this, `\u0078\u0068\u0073\u005f\u006d\u0069\u006e\u0075\u0074\u0065`);
    __publicField(this, `\u0064\u0079\u005f\u006d\u0069\u006e\u0075\u0074\u0065`);
    __publicField(this, `\u0072\u0065\u0070\u006f\u0072\u0074\u0052\u0075\u006e\u0044\u0061\u0074\u0061\u0053\u0074\u0061\u0074\u0075\u0073`, async () => {
      var _a;
      console.log(`\u0072\u0065\u0070\u006f\u0072\u0074\u0052\u0075\u006e\u0044\u0061\u0074\u0061\u0053\u0074\u0061\u0074\u0075\u0073`);
      if (!this.conn) {
        return;
      }
      const runData = this.getRunData();
      console.log(`\u0072\u0075\u006e\u0044\u0061\u0074\u0061`, JSON.stringify(runData));
      this.conn.messageToStatusMQTT({
        "taskId": this.taskId,
        "data": runData,
        "userId": this.user_id,
        "terminalId": (_a = this.terminalData) == null ? void 0 : _a.terminalId
      });
    });
    __publicField(this, `\u0072\u0065\u0070\u006f\u0072\u0074\u0052\u0075\u006e\u0044\u0061\u0074\u0061`, async () => {
      var _a;
      const url = VITE_CONTENT_API$6 + `\u002f\u0061\u0070\u0069\u002f\u0063\u006f\u006e\u0074\u0065\u006e\u0074\u002f`;
      const headers = {
        "Content-Type": `\u0061\u0070\u0070\u006c\u0069\u0063\u0061\u0074\u0069\u006f\u006e\u002f\u006a\u0073\u006f\u006e`,
        ...this.addAuthorizationHeader()
        // Ensure this function works in the extension
      };
      try {
        console.log(`\u0072\u0065\u0070\u006f\u0072\u0074\u0052\u0075\u006e\u0044\u0061\u0074\u0061`);
        const runData = this.getRunData();
        console.log(`\u0072\u0075\u006e\u0044\u0061\u0074\u0061`, JSON.stringify(runData));
        const postData = {
          "taskId": this.taskId,
          "data": runData,
          "userId": this.user_id,
          "terminalId": (_a = this.terminalData) == null ? void 0 : _a.terminalId
        };
        const response = await fetch(url, {
          method: `\u0050\u004f\u0053\u0054`,
          headers,
          body: JSON.stringify(postData)
        });
        if (!response.ok) {
          console.log(`\u0075\u0072\u006c\u003a` + url + `\uff0c\u0068\u0065\u0061\u0064\u0065\u0072\u003a` + JSON.stringify(headers) + `\u002c\u0020\u0072\u0065\u0073\u0070\u006f\u006e\u0073\u0065\u0020\u0073\u0074\u0061\u0074\u0075\u0073\u003a` + response.status);
          return;
        }
        const result = await response.json();
        console.log(`\u0075\u0072\u006c\u003a` + url + `\uff0c\u0068\u0065\u0061\u0064\u0065\u0072\u003a` + JSON.stringify(headers) + `\u002c\u0070\u006f\u0073\u0074\u0044\u0061\u0074\u0061\uff1a` + JSON.stringify(postData) + `\u0020\u0072\u0065\u0073\u0070\u006f\u006e\u0073\u0065\u0020\u0073\u0074\u0061\u0074\u0075\u0073\u003a` + response.status + `\u002c\u0020\u0072\u0065\u0073\u0070\u006f\u006e\u0073\u0065\u0020\u0064\u0061\u0074\u0061\u003a` + JSON.stringify(result));
      } catch (error) {
        console.log(`\u0045\u0072\u0072\u006f\u0072\u0020\u0069\u006e\u0020\u0070\u0075\u0074\u004e\u0065\u0077\u0054\u0061\u0073\u006b\u003a`, error);
        sendLog(`\u0075\u0072\u006c\u003a` + url + `\uff0c\u0068\u0065\u0061\u0064\u0065\u0072\u003a` + JSON.stringify(headers) + `\u002c\u0020\u0065\u0072\u0072\u006f\u0072` + error);
      }
    });
    __publicField(this, `\u0063\u0061\u006c\u006c\u0042\u0061\u0063\u006b\u004c\u0069\u0073\u0074\u0065\u006e\u0065\u0072`, (changes, namespace) => {
      for (let [key, {
        oldValue,
        newValue
      }] of Object.entries(changes)) {
        console.log(`\u0063\u0075\u0073\u0074\u006f\u006d\u0069\u007a\u0065\u0054\u0061\u0073\u006b\u0020\u0053\u0074\u006f\u0072\u0061\u0067\u0065\u0020\u006b\u0065\u0079\u0020\u0022${key}\u0022\u0020\u0069\u006e\u0020\u006e\u0061\u006d\u0065\u0073\u0070\u0061\u0063\u0065\u0020\u0022${namespace}\u0022\u0020\u0063\u0068\u0061\u006e\u0067\u0065\u0064\u002e`, `\u004f\u006c\u0064\u0020\u0076\u0061\u006c\u0075\u0065\u0020\u0077\u0061\u0073\u0020\u0022${oldValue}\u0022\u002c\u0020\u006e\u0065\u0077\u0020\u0076\u0061\u006c\u0075\u0065\u0020\u0069\u0073\u0020\u0022${newValue}\u0022\u002e`);
        switch (key) {
          case `\u0072\u0075\u006e\u0054\u0061\u0073\u006b\u0053\u0074\u006f\u0070\u0070\u0065\u0064`:
            if (newValue == `\u0065\u006e\u0064`) {
              this.reportStop().then(() => {});
            }
            break;
          case `\u0074\u0061\u0073\u006b\u0050\u006c\u0061\u0074\u0066\u006f\u0072\u006d`:
            this.taskPlatform = newValue;
            break;
          case `\u0058\u0069\u0061\u006f\u0048\u006f\u006e\u0067\u0053\u0068\u0075\u005f\u0053\u0065\u0074\u0074\u0069\u006e\u0067`:
            this.XiaoHongShu_Setting = newValue ? JSON.parse(newValue) : {};
            break;
          case `\u006f\u0072\u0067\u0049\u0064`:
            this.orgId = newValue;
            break;
          case `\u0075\u0073\u0065\u0072\u0049\u0064`:
            this.user_id = newValue;
            break;
          case `\u0063\u006c\u0069\u0065\u006e\u0074\u0056\u0069\u0073\u0069\u0074\u006f\u0072\u0049\u0064`:
            this.clientVisitorId = newValue;
            break;
          case `\u0061\u0063\u0063\u0065\u0073\u0073\u0054\u006f\u006b\u0065\u006e`:
            this.accessToken = newValue;
            break;
          case `\u006f\u0070\u0065\u0072\u0061\u0074\u0069\u006f\u006e\u0054\u0069\u006d\u0065`:
            this.operationTime = newValue;
            break;
          case `\u0072\u0075\u006e\u004d\u0069\u006e\u0075\u0074\u0065\u0054\u0069\u006d\u0065`:
            this.runMinuteTime = newValue;
            this.reportReply();
            break;
          case `\u0078\u0068\u0073\u005f\u006c\u0069\u006b\u0065\u0043\u006f\u0075\u006e\u0074`:
            this.xhs_likeCount = newValue;
            this.reportRunDataStatus().then();
            break;
          case `\u0078\u0068\u0073\u005f\u0066\u006f\u006c\u006c\u006f\u0077\u0043\u006f\u0075\u006e\u0074`:
            this.xhs_followCount = newValue;
            this.reportRunDataStatus().then();
            break;
          case `\u0078\u0068\u0073\u005f\u0043\u006f\u006d\u006d\u0065\u006e\u0074\u0043\u006f\u0075\u006e\u0074`:
            this.xhs_CommentCount = newValue;
            this.reportRunDataStatus().then();
            break;
          case `\u0078\u0068\u0073\u005f\u0063\u006f\u006c\u006c\u0065\u0063\u0074\u0043\u006f\u0075\u006e\u0074`:
            this.xhs_collectCount = newValue;
            this.reportRunDataStatus().then();
            break;
          case `\u0078\u0068\u0073\u005f\u0076\u0069\u0065\u0077\u0043\u006f\u0075\u006e\u0074`:
            this.xhs_viewCount = newValue;
            this.reportRunDataStatus().then();
            break;
          case `\u0064\u0079\u005f\u006c\u0069\u006b\u0065\u0043\u006f\u0075\u006e\u0074`:
            this.dy_likeCount = newValue;
            this.reportRunDataStatus().then();
            break;
          case `\u0064\u0079\u005f\u0066\u006f\u006c\u006c\u006f\u0077\u0043\u006f\u0075\u006e\u0074`:
            this.dy_followCount = newValue;
            this.reportRunDataStatus().then();
            break;
          case `\u0064\u0079\u005f\u0043\u006f\u006d\u006d\u0065\u006e\u0074\u0043\u006f\u0075\u006e\u0074`:
            this.dy_CommentCount = newValue;
            this.reportRunDataStatus().then();
            break;
          case `\u0064\u0079\u005f\u0063\u006f\u006c\u006c\u0065\u0063\u0074\u0043\u006f\u0075\u006e\u0074`:
            this.dy_collectCount = newValue;
            this.reportRunDataStatus().then();
            break;
          case `\u0064\u0079\u005f\u0076\u0069\u0065\u0077\u0043\u006f\u0075\u006e\u0074`:
            this.dy_viewCount = newValue;
            this.reportRunDataStatus().then();
            break;
          case `\u0065\u0078\u0065\u0063\u0075\u0074\u0065\u004f\u0070\u0065\u0072\u0061\u0074\u0069\u006f\u006e\u0053\u0074\u0061\u0072\u0074\u0054\u0069\u006d\u0065`:
            this.executeOperationStartTime = newValue;
            break;
          case `\u0065\u0078\u0065\u0063\u0075\u0074\u0065\u004f\u0070\u0065\u0072\u0061\u0074\u0069\u006f\u006e\u0045\u006e\u0064\u0054\u0069\u006d\u0065`:
            this.executeOperationEndTime = newValue;
            break;
          case `\u0078\u0068\u0073\u005f\u006b\u0065\u0079\u0077\u006f\u0072\u0064\u0073\u005f\u006c\u0069\u0073\u0074`:
            this.xhs_keywords_list = newValue ? JSON.parse(newValue) : [];
            break;
          case `\u0064\u006f\u0075\u0059\u0069\u006e\u005f\u006b\u0065\u0079\u0077\u006f\u0072\u0064\u0073\u005f\u006c\u0069\u0073\u0074`:
            this.douYin_keywords_list = newValue ? JSON.parse(newValue) : [];
            break;
          case `\u0078\u0068\u0073\u005f\u006d\u0069\u006e\u0075\u0074\u0065`:
            this.xhs_minute = newValue ? JSON.parse(newValue) : [];
            break;
          case `\u0064\u0079\u005f\u006d\u0069\u006e\u0075\u0074\u0065`:
            this.dy_minute = newValue ? JSON.parse(newValue) : [];
            break;
        }
      }
    });
    this.startLoad = false;
    this.loadend = false;
    this.xhs_viewCount = 0;
    this.xhs_CommentCount = 0;
    this.xhs_likeCount = 0;
    this.xhs_followCount = 0;
    this.xhs_collectCount = 0;
    this.dy_viewCount = 0;
    this.dy_CommentCount = 0;
    this.dy_likeCount = 0;
    this.dy_followCount = 0;
    this.dy_collectCount = 0;
    this.operationTime = 0;
    this.runMinuteTime = 0;
    this.taskPlatform = ``;
    this.XiaoHongShu_Setting = ``;
    this.executeTask = executeTask2;
    this.executeOperationStartTime = 0;
    this.executeOperationEndTime = 0;
    this.xhs_keywords_list = [];
    this.douYin_keywords_list = [];
    this.xhs_minute = [];
    this.dy_minute = [];
    this.loadFromStorage();
  }
  /**
   * 检查配置是否正确
   */
  checkConfig() {
    return true;
  }
  startTask() {
    return new Promise(resolve => {
      const validationError = this.validateParameters();
      if (!this.conn) {
        return;
      }
      if (validationError) {
        console.error(validationError.message);
        this.conn.messageToReplyMQTT({
          "taskId": this.taskId,
          "executeId": this.executeId,
          "status": `\u0066\u0061\u0069\u006c\u0065\u0064`,
          "meta": {},
          "message": validationError.message
        });
        return;
      }
      console.log(`\u0044\u006f\u0020\u0061\u0020\u0063\u0075\u0073\u0074\u006f\u006d\u0069\u007a\u0065\u0020\u0074\u0061\u0073\u006b\u0021`);
      this.my_execute(this.data);
      this.conn.messageToReplyMQTT({
        "taskId": this.taskId,
        "executeId": this.executeId,
        "status": `\u0072\u0075\u006e\u006e\u0069\u006e\u0067`,
        "meta": this.getStatus(),
        "message": ``
      });
      resolve();
    });
  }
  validateParameters() {
    if (!this.data) {
      return {
        message: `\u53c2\u6570\u672a\u4f20\u9012\u6216\u683c\u5f0f\u4e0d\u6b63\u786e`
      };
    }
    return null;
  }
  my_execute(config) {
    chrome.storage.local.set({
      "runTaskStopped": ``
    });
    chrome.storage.local.set({
      "mqttStart": `\u006f\u006b`
    });
    chrome.storage.local.set({
      "xhs_viewCount": 0
    });
    chrome.storage.local.set({
      "xhs_CommentCount": 0
    });
    chrome.storage.local.set({
      "xhs_likeCount": 0
    });
    chrome.storage.local.set({
      "xhs_followCount": 0
    });
    chrome.storage.local.set({
      "xhs_collectCount": 0
    });
    chrome.storage.local.set({
      "dy_viewCount": 0
    });
    chrome.storage.local.set({
      "dy_CommentCount": 0
    });
    chrome.storage.local.set({
      "dy_likeCount": 0
    });
    chrome.storage.local.set({
      "dy_followCount": 0
    });
    chrome.storage.local.set({
      "dy_collectCount": 0
    });
    chrome.storage.local.set({
      "activatePage": runPages[0]
    });
    chrome.storage.local.set({
      "operationTime": 0
    });
    chrome.storage.local.set({
      "xiaoHongShuAccountErrorTip": ``
    });
    chrome.storage.local.set({
      "xhs_keywords_list": JSON.stringify([])
    });
    chrome.storage.local.set({
      "douYin_keywords_list": JSON.stringify([])
    });
    chrome.storage.local.set({
      "xhs_minute": JSON.stringify([])
    });
    chrome.storage.local.set({
      "dy_minute": JSON.stringify([])
    });
    chrome.storage.local.set({
      "optionsPageName": ``
    });
    chrome.storage.local.set({
      "executeOperationStartTime": (/* @__PURE__ */new Date()).getTime()
    });
    chrome.storage.local.set({
      "XiaoHongShu_Setting": JSON.stringify(config)
    });
    chrome.storage.local.set({
      "DouYin_search_runNumber": 1
    });
    if (!this.XiaoHongShu_Setting) {
      this.XiaoHongShu_Setting = config;
    }
    if (config.workDouYinPlatform == `\u6296\u97f3`) {
      if (!this.taskPlatform) {
        this.taskPlatform = config.workDouYinPlatform;
      }
      this.executeTask({
        action: `\u0065\u0078\u0065\u0063\u0075\u0074\u0065\u0054\u0061\u0073\u006b`,
        url: `\u0068\u0074\u0074\u0070\u0073\u003a\u002f\u002f\u0077\u0077\u0077\u002e\u0064\u006f\u0075\u0079\u0069\u006e\u002e\u0063\u006f\u006d`,
        taskName: config.workType,
        taskPlatform: config.workDouYinPlatform,
        taskId: this.taskId
      }, {}, res => {
        if (res && res.tabId) {
          this.tabId = res.tabId;
        }
        if (res && res.windowId) {
          this.windowId = res.windowId;
        }
        console.log(`\u0065\u0078\u0065\u0063\u0075\u0074\u0065\u0054\u0061\u0073\u006b\u0020\u0072\u0065\u0073`, res);
      });
    }
    if (config.workXiaoHongShuPlatform == `\u5c0f\u7ea2\u4e66`) {
      this.executeTask({
        action: `\u0065\u0078\u0065\u0063\u0075\u0074\u0065\u0054\u0061\u0073\u006b`,
        url: `\u0068\u0074\u0074\u0070\u0073\u003a\u002f\u002f\u0077\u0077\u0077\u002e\u0078\u0069\u0061\u006f\u0068\u006f\u006e\u0067\u0073\u0068\u0075\u002e\u0063\u006f\u006d\u002f\u0065\u0078\u0070\u006c\u006f\u0072\u0065`,
        taskName: config.workType,
        taskPlatform: config.workXiaoHongShuPlatform,
        taskId: this.taskId
      }, {}, res => {
        if (res && res.tabId) {
          this.tabId = res.tabId;
        }
        if (res && res.windowId) {
          this.windowId = res.windowId;
        }
        console.log(`\u0065\u0078\u0065\u0063\u0075\u0074\u0065\u0054\u0061\u0073\u006b\u0020\u0072\u0065\u0073`, res);
      });
      if (!this.taskPlatform) {
        this.taskPlatform = config.workXiaoHongShuPlatform;
      }
    }
  }
  stopTask() {
    return new Promise(resolve => {
      sendLog(`\u0073\u0068\u0075\u004a\u0075\u004a\u0069\u0061\u006e\u004b\u006f\u006e\u0067\u0043\u0075\u0073\u0074\u006f\u006d\u0069\u007a\u0065\u0054\u0061\u0073\u006b\u0020\u0062\u0061\u0063\u006b\u0067\u0072\u006f\u0075\u006e\u0064\u0020\u0061\u0063\u0074\u0069\u0076\u0061\u0074\u0065\u0050\u0061\u0067\u0065\u0020\uff1a`, indexPage);
      chrome.storage.local.set({
        "activatePage": indexPage
      });
      resolve();
    });
  }
  abortTask() {
    return new Promise(resolve => {
      this.reportStop().then(() => {});
      resolve();
    });
  }
  report() {
    return new Promise(resolve => {
      console.log(`\u0072\u0065\u0070\u006f\u0072\u0074\u0020\u0050\u0072\u006f\u006d\u0069\u0073\u0065`);
      try {
        let formatTimestamp = function (timestamp) {
            const date = new Date(timestamp);
            const month = String(date.getMonth() + 1).padStart(2, `\u0030`);
            const day = String(date.getDate()).padStart(2, `\u0030`);
            const hours = String(date.getHours()).padStart(2, `\u0030`);
            const minutes = String(date.getMinutes()).padStart(2, `\u0030`);
            return `${month}\u002d${day}\u0020${hours}\u003a${minutes}`;
          },
          calculateTimeDifference = function (startTimestamp, endTimestamp) {
            const differenceInMs = Math.abs(endTimestamp - startTimestamp);
            const totalMinutes = Math.floor(differenceInMs / (1e3 * 60));
            return `${totalMinutes}`;
          };
        if (!this.conn) {
          resolve();
          return;
        }
        const executeOperationStartTime = formatTimestamp(this.executeOperationStartTime);
        const executeOperationEndTime = formatTimestamp(this.executeOperationEndTime);
        const run_time = calculateTimeDifference(this.executeOperationStartTime, this.executeOperationEndTime);
        let xhs_keywords_list_str = ``;
        if (this.xhs_keywords_list.length > 0) {
          xhs_keywords_list_str = this.xhs_keywords_list.join(`\uff0c`);
        }
        let douYin_keywords_list_str = ``;
        if (this.douYin_keywords_list.length > 0) {
          douYin_keywords_list_str = this.douYin_keywords_list.join(`\uff0c`);
        }
        let XiaoHongShu_Setting = this.XiaoHongShu_Setting;
        let workRunPlatform = ``;
        if (XiaoHongShu_Setting.workDouYinPlatform) {
          if (!workRunPlatform) {
            workRunPlatform = XiaoHongShu_Setting.workDouYinPlatform;
          } else {
            workRunPlatform += `\u002b` + XiaoHongShu_Setting.workDouYinPlatform;
          }
        }
        if (XiaoHongShu_Setting.workXiaoHongShuPlatform) {
          if (!workRunPlatform) {
            workRunPlatform = XiaoHongShu_Setting.workXiaoHongShuPlatform;
          } else {
            workRunPlatform += `\u002b` + XiaoHongShu_Setting.workXiaoHongShuPlatform;
          }
        }
        const uniqueMinutes = [... /* @__PURE__ */new Set([...this.xhs_minute.map(item => item.minute), ...this.dy_minute.map(item => item.minute)])].sort((a, b) => a - b);
        const xhsNums = uniqueMinutes.map(minute => {
          var _a;
          return ((_a = this.xhs_minute.find(item => item.minute === minute)) == null ? void 0 : _a.num) || 0;
        });
        const xhsPieNumber = [{
          value: store$7.xhs_likeCount,
          name: `\u70b9\u8d5e`
        }, {
          value: store$7.xhs_CommentCount,
          name: `\u8bc4\u8bba`
        }, {
          value: store$7.xhs_followCount,
          name: `\u5173\u6ce8`
        }, {
          value: store$7.xhs_collectCount,
          name: `\u6536\u85cf`
        }];
        const dyPieNumber = [{
          value: store$7.dy_likeCount,
          name: `\u70b9\u8d5e`
        }, {
          value: store$7.dy_CommentCount,
          name: `\u8bc4\u8bba`
        }, {
          value: store$7.dy_followCount,
          name: `\u5173\u6ce8`
        }, {
          value: store$7.dy_collectCount,
          name: `\u6536\u85cf`
        }];
        const allPieNumber = [{
          value: store$7.xhs_likeCount + store$7.dy_likeCount,
          name: `\u70b9\u8d5e`
        }, {
          value: store$7.xhs_CommentCount + store$7.dy_CommentCount,
          name: `\u8bc4\u8bba`
        }, {
          value: store$7.xhs_followCount + store$7.dy_followCount,
          name: `\u5173\u6ce8`
        }, {
          value: store$7.xhs_collectCount + store$7.dy_collectCount,
          name: `\u6536\u85cf`
        }];
        const postData = {
          executeOperationStartTime,
          executeOperationEndTime,
          run_time,
          xhs_keywords_list_str,
          douYin_keywords_list_str,
          workRunPlatform,
          uniqueMinutes,
          xhsNums,
          xhsPieNumber,
          dyPieNumber,
          allPieNumber
        };
        console.log(`\u006d\u0065\u0073\u0073\u0061\u0067\u0065\u0054\u006f\u0052\u0065\u0070\u006f\u0072\u0074\u004d\u0051\u0054\u0054\u0020\u0070\u006f\u0073\u0074\u0044\u0061\u0074\u0061`, JSON.stringify(postData));
        sendLog(`\u0054\u0061\u0073\u006b\u0020\u0073\u0074\u006f\u0070\u0070\u0065\u0064`);
        this.conn.messageToReportMQTT({
          "taskId": this.taskId,
          "executeId": this.executeId,
          "status": `\u0072\u0065\u0070\u006f\u0072\u0074`,
          "meta": postData,
          "message": `\u62a5\u544a`
        });
        resolve();
      } catch (e) {
        console.log(`\u0072\u0065\u0070\u006f\u0072\u0074\u0020\u0065`, e);
      }
    });
  }
  /**
   * 获取心跳上报数据
   */
  getHeartReportData() {
    return {};
  }
  /**
   * 等待store 通知 callBackListener
   */
  async reportStop() {
    this.running = false;
    this.paused = false;
    this.callExecuteNotification();
    if (!this.conn) {
      return;
    }
    sendLog(`\u0054\u0061\u0073\u006b\u0020\u0073\u0074\u006f\u0070\u0070\u0065\u0064`);
    this.conn.messageToReplyMQTT({
      "taskId": this.taskId,
      "executeId": this.executeId,
      "status": `\u0063\u006f\u006d\u0070\u006c\u0065\u0074\u0065\u0064`,
      "meta": this.getStatus(),
      "message": `\u5df2\u505c\u6b62`
    });
    storageUtil.removeListener(this.callBackListener);
    super.baseReportStop();
  }
  getStatus() {
    return {
      id: this.taskId,
      running: this.running,
      paused: this.paused,
      started: this.started,
      process: this.operationTime > 0 ? (this.runMinuteTime / this.operationTime * 100).toFixed(2) : 0,
      total_num: this.operationTime,
      executed_num: this.runMinuteTime
    };
  }
  getRunData() {
    if (this.taskPlatform === `\u6296\u97f3`) {
      return {
        viewCount: this.dy_viewCount,
        commentCount: this.dy_CommentCount,
        likeCount: this.dy_likeCount,
        followCount: this.dy_followCount,
        collectCount: this.dy_collectCount,
        operationTime: this.operationTime,
        runMinuteTime: this.runMinuteTime
      };
    } else if (this.taskPlatform === `\u5c0f\u7ea2\u4e66`) {
      return {
        likeCount: this.xhs_likeCount,
        followCount: this.xhs_followCount,
        commentCount: this.xhs_CommentCount,
        collectCount: this.xhs_collectCount,
        viewCount: this.xhs_viewCount,
        operationTime: this.operationTime,
        runMinuteTime: this.runMinuteTime
      };
    }
  }
  reportReply() {
    console.log(`\u0072\u0065\u0070\u006f\u0072\u0074\u0052\u0065\u0070\u006c\u0079`);
    if (!this.conn) {
      return;
    }
    this.conn.messageToReplyMQTT({
      "taskId": this.taskId,
      "executeId": this.executeId,
      "status": `\u0072\u0075\u006e\u006e\u0069\u006e\u0067`,
      "meta": this.getStatus(),
      "message": ``
    });
  }
  loadFromStorage() {
    if (this.startLoad) {
      console.log(`\u0073\u0074\u0061\u0072\u0074\u004c\u006f\u0061\u0064`, this.startLoad);
      return;
    }
    this.startLoad = true;
    chrome.storage.local.get([`\u0074\u0061\u0073\u006b\u0050\u006c\u0061\u0074\u0066\u006f\u0072\u006d`, `\u0058\u0069\u0061\u006f\u0048\u006f\u006e\u0067\u0053\u0068\u0075\u005f\u0053\u0065\u0074\u0074\u0069\u006e\u0067`, `\u0078\u0068\u0073\u005f\u0076\u0069\u0065\u0077\u0043\u006f\u0075\u006e\u0074`, `\u0078\u0068\u0073\u005f\u0043\u006f\u006d\u006d\u0065\u006e\u0074\u0043\u006f\u0075\u006e\u0074`, `\u0078\u0068\u0073\u005f\u006c\u0069\u006b\u0065\u0043\u006f\u0075\u006e\u0074`, `\u0078\u0068\u0073\u005f\u0066\u006f\u006c\u006c\u006f\u0077\u0043\u006f\u0075\u006e\u0074`, `\u0078\u0068\u0073\u005f\u0063\u006f\u006c\u006c\u0065\u0063\u0074\u0043\u006f\u0075\u006e\u0074`, `\u0064\u0079\u005f\u0076\u0069\u0065\u0077\u0043\u006f\u0075\u006e\u0074`, `\u0064\u0079\u005f\u0043\u006f\u006d\u006d\u0065\u006e\u0074\u0043\u006f\u0075\u006e\u0074`, `\u0064\u0079\u005f\u006c\u0069\u006b\u0065\u0043\u006f\u0075\u006e\u0074`, `\u0064\u0079\u005f\u0066\u006f\u006c\u006c\u006f\u0077\u0043\u006f\u0075\u006e\u0074`, `\u0064\u0079\u005f\u0063\u006f\u006c\u006c\u0065\u0063\u0074\u0043\u006f\u0075\u006e\u0074`, `\u006f\u0070\u0065\u0072\u0061\u0074\u0069\u006f\u006e\u0054\u0069\u006d\u0065`, `\u0075\u0073\u0065\u0072\u0049\u0064`, `\u006f\u0072\u0067\u0049\u0064`, `\u0063\u006c\u0069\u0065\u006e\u0074\u0056\u0069\u0073\u0069\u0074\u006f\u0072\u0049\u0064`, `\u0061\u0063\u0063\u0065\u0073\u0073\u0054\u006f\u006b\u0065\u006e`], result => {
      console.log(`\u0072\u0065\u0073\u0075\u006c\u0074\u0020\u0061\u0063\u0074\u0069\u0076\u0061\u0074\u0065\u0050\u0061\u0067\u0065`, result);
      if (!result) {
        return;
      }
      if (result.userId !== void 0) {
        this.user_id = result.userId;
      }
      if (result.orgId !== void 0) {
        this.orgId = result.orgId;
      }
      if (result.clientVisitorId !== void 0) {
        this.clientVisitorId = result.clientVisitorId;
      }
      if (result.accessToken !== void 0) {
        this.accessToken = result.accessToken;
      }
      if (result.taskPlatform !== void 0) {
        this.taskPlatform = result.taskPlatform;
      }
      if (result.XiaoHongShu_Setting !== void 0) {
        this.XiaoHongShu_Setting = result.XiaoHongShu_Setting ? JSON.parse(result.XiaoHongShu_Setting) : {};
      }
      if (result.xhs_viewCount !== void 0) {
        this.xhs_viewCount = result.xhs_viewCount;
      }
      if (result.xhs_CommentCount !== void 0) {
        this.xhs_CommentCount = result.xhs_CommentCount;
      }
      if (result.xhs_likeCount !== void 0) {
        this.xhs_likeCount = result.xhs_likeCount;
      }
      if (result.xhs_followCount !== void 0) {
        this.xhs_followCount = result.xhs_followCount;
      }
      if (result.xhs_collectCount !== void 0) {
        this.xhs_collectCount = result.xhs_collectCount;
      }
      if (result.dy_viewCount !== void 0) {
        this.dy_viewCount = result.dy_viewCount;
      }
      if (result.dy_CommentCount !== void 0) {
        this.dy_CommentCount = result.dy_CommentCount;
      }
      if (result.dy_likeCount !== void 0) {
        this.dy_likeCount = result.dy_likeCount;
      }
      if (result.dy_followCount !== void 0) {
        this.dy_followCount = result.dy_followCount;
      }
      if (result.dy_collectCount !== void 0) {
        this.dy_collectCount = result.dy_collectCount;
      }
      if (result.operationTime !== void 0) {
        this.operationTime = result.operationTime;
      }
      this.startLoad = true;
      this.loadend = true;
    });
    storageUtil.addHandlers(this.callBackListener);
  }
}
const VITE_CONTENT_API$5 = `\u0068\u0074\u0074\u0070\u0073\u003a\u002f\u002f\u0061\u0067\u0065\u006e\u0074\u002d\u006e\u0065\u0074\u002e\u0070\u0061\u0069\u0074\u006f\u006e\u0067\u0061\u0069\u002e\u006e\u0065\u0074\u002f\u0063\u006f\u006e\u0074\u0065\u006e\u0074`;
const VITE_AGENT_ID$2 = `\u0078\u0069\u0061\u006f\u0073\u0068\u0075\u0074\u0069\u0061\u006f\u002d\u0061\u0075\u0074\u006f\u006d\u0061\u0074\u0069\u0063\u002d\u0065\u0078\u0074\u0065\u006e\u0073\u0069\u006f\u006e`;
const store$6 = UseCounterStore.getInstance();
class DouYinSearchVideoTask extends BaseTask {
  constructor(taskId, executeId, data, executeTask2) {
    super(taskId, executeId, data);
    __publicField(this, `\u0065\u0078\u0065\u0063\u0075\u0074\u0065\u0054\u0061\u0073\u006b`);
    //评论数量
    __publicField(this, `\u0078\u0068\u0073\u005f\u0076\u0069\u0065\u0077\u0043\u006f\u0075\u006e\u0074`);
    __publicField(this, `\u0078\u0068\u0073\u005f\u0043\u006f\u006d\u006d\u0065\u006e\u0074\u0043\u006f\u0075\u006e\u0074`);
    __publicField(this, `\u0078\u0068\u0073\u005f\u006c\u0069\u006b\u0065\u0043\u006f\u0075\u006e\u0074`);
    __publicField(this, `\u0078\u0068\u0073\u005f\u0066\u006f\u006c\u006c\u006f\u0077\u0043\u006f\u0075\u006e\u0074`);
    __publicField(this, `\u0078\u0068\u0073\u005f\u0063\u006f\u006c\u006c\u0065\u0063\u0074\u0043\u006f\u0075\u006e\u0074`);
    //评论数量
    __publicField(this, `\u0064\u0079\u005f\u0076\u0069\u0065\u0077\u0043\u006f\u0075\u006e\u0074`);
    __publicField(this, `\u0064\u0079\u005f\u0043\u006f\u006d\u006d\u0065\u006e\u0074\u0043\u006f\u0075\u006e\u0074`);
    __publicField(this, `\u0064\u0079\u005f\u006c\u0069\u006b\u0065\u0043\u006f\u0075\u006e\u0074`);
    __publicField(this, `\u0064\u0079\u005f\u0066\u006f\u006c\u006c\u006f\u0077\u0043\u006f\u0075\u006e\u0074`);
    __publicField(this, `\u0064\u0079\u005f\u0063\u006f\u006c\u006c\u0065\u0063\u0074\u0043\u006f\u0075\u006e\u0074`);
    __publicField(this, `\u0074\u0061\u0073\u006b\u0050\u006c\u0061\u0074\u0066\u006f\u0072\u006d`);
    __publicField(this, `\u0058\u0069\u0061\u006f\u0048\u006f\u006e\u0067\u0053\u0068\u0075\u005f\u0053\u0065\u0074\u0074\u0069\u006e\u0067`);
    __publicField(this, `\u006f\u0070\u0065\u0072\u0061\u0074\u0069\u006f\u006e\u0054\u0069\u006d\u0065`);
    __publicField(this, `\u0072\u0075\u006e\u004d\u0069\u006e\u0075\u0074\u0065\u0054\u0069\u006d\u0065`);
    __publicField(this, `\u0073\u0074\u0061\u0072\u0074\u004c\u006f\u0061\u0064`);
    __publicField(this, `\u006c\u006f\u0061\u0064\u0065\u006e\u0064`);
    // 上报数据
    __publicField(this, `\u0065\u0078\u0065\u0063\u0075\u0074\u0065\u004f\u0070\u0065\u0072\u0061\u0074\u0069\u006f\u006e\u0053\u0074\u0061\u0072\u0074\u0054\u0069\u006d\u0065`);
    __publicField(this, `\u0065\u0078\u0065\u0063\u0075\u0074\u0065\u004f\u0070\u0065\u0072\u0061\u0074\u0069\u006f\u006e\u0045\u006e\u0064\u0054\u0069\u006d\u0065`);
    __publicField(this, `\u0078\u0068\u0073\u005f\u006b\u0065\u0079\u0077\u006f\u0072\u0064\u0073\u005f\u006c\u0069\u0073\u0074`);
    __publicField(this, `\u0064\u006f\u0075\u0059\u0069\u006e\u005f\u006b\u0065\u0079\u0077\u006f\u0072\u0064\u0073\u005f\u006c\u0069\u0073\u0074`);
    __publicField(this, `\u0078\u0068\u0073\u005f\u006d\u0069\u006e\u0075\u0074\u0065`);
    __publicField(this, `\u0064\u0079\u005f\u006d\u0069\u006e\u0075\u0074\u0065`);
    __publicField(this, `\u0072\u0065\u0070\u006f\u0072\u0074\u0052\u0075\u006e\u0044\u0061\u0074\u0061\u0053\u0074\u0061\u0074\u0075\u0073`, async () => {
      var _a;
      console.log(`\u0072\u0065\u0070\u006f\u0072\u0074\u0052\u0075\u006e\u0044\u0061\u0074\u0061\u0053\u0074\u0061\u0074\u0075\u0073`);
      if (!this.conn) {
        return;
      }
      const runData = this.getRunData();
      console.log(`\u0072\u0075\u006e\u0044\u0061\u0074\u0061`, JSON.stringify(runData));
      this.conn.messageToStatusMQTT({
        "taskId": this.taskId,
        "data": runData,
        "userId": this.user_id,
        "terminalId": (_a = this.terminalData) == null ? void 0 : _a.terminalId
      });
    });
    __publicField(this, `\u0072\u0065\u0070\u006f\u0072\u0074\u0052\u0075\u006e\u0044\u0061\u0074\u0061`, async () => {
      var _a;
      const url = VITE_CONTENT_API$5 + `\u002f\u0061\u0070\u0069\u002f\u0063\u006f\u006e\u0074\u0065\u006e\u0074\u002f`;
      const headers = {
        "Content-Type": `\u0061\u0070\u0070\u006c\u0069\u0063\u0061\u0074\u0069\u006f\u006e\u002f\u006a\u0073\u006f\u006e`,
        ...this.addAuthorizationHeader()
        // Ensure this function works in the extension
      };
      try {
        console.log(`\u0072\u0065\u0070\u006f\u0072\u0074\u0052\u0075\u006e\u0044\u0061\u0074\u0061`);
        const runData = this.getRunData();
        console.log(`\u0072\u0075\u006e\u0044\u0061\u0074\u0061`, JSON.stringify(runData));
        const postData = {
          "taskId": this.taskId,
          "data": runData,
          "userId": this.user_id,
          "terminalId": (_a = this.terminalData) == null ? void 0 : _a.terminalId
        };
        const response = await fetch(url, {
          method: `\u0050\u004f\u0053\u0054`,
          headers,
          body: JSON.stringify(postData)
        });
        if (!response.ok) {
          console.log(`\u0075\u0072\u006c\u003a` + url + `\uff0c\u0068\u0065\u0061\u0064\u0065\u0072\u003a` + JSON.stringify(headers) + `\u002c\u0020\u0072\u0065\u0073\u0070\u006f\u006e\u0073\u0065\u0020\u0073\u0074\u0061\u0074\u0075\u0073\u003a` + response.status);
          return;
        }
        const result = await response.json();
        console.log(`\u0075\u0072\u006c\u003a` + url + `\uff0c\u0068\u0065\u0061\u0064\u0065\u0072\u003a` + JSON.stringify(headers) + `\u002c\u0070\u006f\u0073\u0074\u0044\u0061\u0074\u0061\uff1a` + JSON.stringify(postData) + `\u0020\u0072\u0065\u0073\u0070\u006f\u006e\u0073\u0065\u0020\u0073\u0074\u0061\u0074\u0075\u0073\u003a` + response.status + `\u002c\u0020\u0072\u0065\u0073\u0070\u006f\u006e\u0073\u0065\u0020\u0064\u0061\u0074\u0061\u003a` + JSON.stringify(result));
      } catch (error) {
        console.log(`\u0045\u0072\u0072\u006f\u0072\u0020\u0069\u006e\u0020\u0070\u0075\u0074\u004e\u0065\u0077\u0054\u0061\u0073\u006b\u003a`, error);
        sendLog(`\u0075\u0072\u006c\u003a` + url + `\uff0c\u0068\u0065\u0061\u0064\u0065\u0072\u003a` + JSON.stringify(headers) + `\u002c\u0020\u0065\u0072\u0072\u006f\u0072` + error);
      }
    });
    __publicField(this, `\u0063\u0061\u006c\u006c\u0042\u0061\u0063\u006b\u004c\u0069\u0073\u0074\u0065\u006e\u0065\u0072`, (changes, namespace) => {
      for (let [key, {
        oldValue,
        newValue
      }] of Object.entries(changes)) {
        console.log(`\u0063\u0075\u0073\u0074\u006f\u006d\u0069\u007a\u0065\u0054\u0061\u0073\u006b\u0020\u0053\u0074\u006f\u0072\u0061\u0067\u0065\u0020\u006b\u0065\u0079\u0020\u0022${key}\u0022\u0020\u0069\u006e\u0020\u006e\u0061\u006d\u0065\u0073\u0070\u0061\u0063\u0065\u0020\u0022${namespace}\u0022\u0020\u0063\u0068\u0061\u006e\u0067\u0065\u0064\u002e`, `\u004f\u006c\u0064\u0020\u0076\u0061\u006c\u0075\u0065\u0020\u0077\u0061\u0073\u0020\u0022${oldValue}\u0022\u002c\u0020\u006e\u0065\u0077\u0020\u0076\u0061\u006c\u0075\u0065\u0020\u0069\u0073\u0020\u0022${newValue}\u0022\u002e`);
        switch (key) {
          case `\u0072\u0075\u006e\u0054\u0061\u0073\u006b\u0053\u0074\u006f\u0070\u0070\u0065\u0064`:
            if (newValue == `\u0065\u006e\u0064`) {
              this.reportStop().then(() => {});
            }
            break;
          case `\u0074\u0061\u0073\u006b\u0050\u006c\u0061\u0074\u0066\u006f\u0072\u006d`:
            this.taskPlatform = newValue;
            break;
          case `\u0058\u0069\u0061\u006f\u0048\u006f\u006e\u0067\u0053\u0068\u0075\u005f\u0053\u0065\u0074\u0074\u0069\u006e\u0067`:
            this.XiaoHongShu_Setting = newValue ? JSON.parse(newValue) : {};
            break;
          case `\u006f\u0072\u0067\u0049\u0064`:
            this.orgId = newValue;
            break;
          case `\u0075\u0073\u0065\u0072\u0049\u0064`:
            this.user_id = newValue;
            break;
          case `\u0063\u006c\u0069\u0065\u006e\u0074\u0056\u0069\u0073\u0069\u0074\u006f\u0072\u0049\u0064`:
            this.clientVisitorId = newValue;
            break;
          case `\u0061\u0063\u0063\u0065\u0073\u0073\u0054\u006f\u006b\u0065\u006e`:
            this.accessToken = newValue;
            break;
          case `\u006f\u0070\u0065\u0072\u0061\u0074\u0069\u006f\u006e\u0054\u0069\u006d\u0065`:
            this.operationTime = newValue;
            break;
          case `\u0072\u0075\u006e\u004d\u0069\u006e\u0075\u0074\u0065\u0054\u0069\u006d\u0065`:
            this.runMinuteTime = newValue;
            this.reportReply();
            break;
          case `\u0078\u0068\u0073\u005f\u006c\u0069\u006b\u0065\u0043\u006f\u0075\u006e\u0074`:
            this.xhs_likeCount = newValue;
            this.reportRunDataStatus().then();
            break;
          case `\u0078\u0068\u0073\u005f\u0066\u006f\u006c\u006c\u006f\u0077\u0043\u006f\u0075\u006e\u0074`:
            this.xhs_followCount = newValue;
            this.reportRunDataStatus().then();
            break;
          case `\u0078\u0068\u0073\u005f\u0043\u006f\u006d\u006d\u0065\u006e\u0074\u0043\u006f\u0075\u006e\u0074`:
            this.xhs_CommentCount = newValue;
            this.reportRunDataStatus().then();
            break;
          case `\u0078\u0068\u0073\u005f\u0063\u006f\u006c\u006c\u0065\u0063\u0074\u0043\u006f\u0075\u006e\u0074`:
            this.xhs_collectCount = newValue;
            this.reportRunDataStatus().then();
            break;
          case `\u0078\u0068\u0073\u005f\u0076\u0069\u0065\u0077\u0043\u006f\u0075\u006e\u0074`:
            this.xhs_viewCount = newValue;
            this.reportRunDataStatus().then();
            break;
          case `\u0064\u0079\u005f\u006c\u0069\u006b\u0065\u0043\u006f\u0075\u006e\u0074`:
            this.dy_likeCount = newValue;
            this.reportRunDataStatus().then();
            break;
          case `\u0064\u0079\u005f\u0066\u006f\u006c\u006c\u006f\u0077\u0043\u006f\u0075\u006e\u0074`:
            this.dy_followCount = newValue;
            this.reportRunDataStatus().then();
            break;
          case `\u0064\u0079\u005f\u0043\u006f\u006d\u006d\u0065\u006e\u0074\u0043\u006f\u0075\u006e\u0074`:
            this.dy_CommentCount = newValue;
            this.reportRunDataStatus().then();
            break;
          case `\u0064\u0079\u005f\u0063\u006f\u006c\u006c\u0065\u0063\u0074\u0043\u006f\u0075\u006e\u0074`:
            this.dy_collectCount = newValue;
            this.reportRunDataStatus().then();
            break;
          case `\u0064\u0079\u005f\u0076\u0069\u0065\u0077\u0043\u006f\u0075\u006e\u0074`:
            this.dy_viewCount = newValue;
            this.reportRunDataStatus().then();
            break;
          case `\u0065\u0078\u0065\u0063\u0075\u0074\u0065\u004f\u0070\u0065\u0072\u0061\u0074\u0069\u006f\u006e\u0053\u0074\u0061\u0072\u0074\u0054\u0069\u006d\u0065`:
            this.executeOperationStartTime = newValue;
            break;
          case `\u0065\u0078\u0065\u0063\u0075\u0074\u0065\u004f\u0070\u0065\u0072\u0061\u0074\u0069\u006f\u006e\u0045\u006e\u0064\u0054\u0069\u006d\u0065`:
            this.executeOperationEndTime = newValue;
            break;
          case `\u0078\u0068\u0073\u005f\u006b\u0065\u0079\u0077\u006f\u0072\u0064\u0073\u005f\u006c\u0069\u0073\u0074`:
            this.xhs_keywords_list = newValue ? JSON.parse(newValue) : [];
            break;
          case `\u0064\u006f\u0075\u0059\u0069\u006e\u005f\u006b\u0065\u0079\u0077\u006f\u0072\u0064\u0073\u005f\u006c\u0069\u0073\u0074`:
            this.douYin_keywords_list = newValue ? JSON.parse(newValue) : [];
            break;
          case `\u0078\u0068\u0073\u005f\u006d\u0069\u006e\u0075\u0074\u0065`:
            this.xhs_minute = newValue ? JSON.parse(newValue) : [];
            break;
          case `\u0064\u0079\u005f\u006d\u0069\u006e\u0075\u0074\u0065`:
            this.dy_minute = newValue ? JSON.parse(newValue) : [];
            break;
        }
      }
    });
    this.startLoad = false;
    this.loadend = false;
    this.xhs_viewCount = 0;
    this.xhs_CommentCount = 0;
    this.xhs_likeCount = 0;
    this.xhs_followCount = 0;
    this.xhs_collectCount = 0;
    this.dy_viewCount = 0;
    this.dy_CommentCount = 0;
    this.dy_likeCount = 0;
    this.dy_followCount = 0;
    this.dy_collectCount = 0;
    this.operationTime = 0;
    this.runMinuteTime = 0;
    this.taskPlatform = ``;
    this.XiaoHongShu_Setting = ``;
    this.executeTask = executeTask2;
    this.executeOperationStartTime = 0;
    this.executeOperationEndTime = 0;
    this.xhs_keywords_list = [];
    this.douYin_keywords_list = [];
    this.xhs_minute = [];
    this.dy_minute = [];
    this.loadFromStorage();
  }
  /**
   * 检查配置是否正确
   */
  checkConfig() {
    return true;
  }
  startTask() {
    return new Promise(async resolve => {
      const validationError = this.validateParameters();
      if (!this.conn) {
        resolve();
        return;
      }
      if (validationError) {
        console.error(validationError.message);
        this.conn.messageToReplyMQTT({
          "taskId": this.taskId,
          "executeId": this.executeId,
          "status": `\u0066\u0061\u0069\u006c\u0065\u0064`,
          "meta": {},
          "message": validationError.message
        });
        resolve();
        return;
      }
      console.log(`\u0044\u006f\u0020\u0061\u0020\u0063\u0075\u0073\u0074\u006f\u006d\u0069\u007a\u0065\u0020\u0074\u0061\u0073\u006b\u0021`);
      await this.my_execute(this.data);
      this.conn.messageToReplyMQTT({
        "taskId": this.taskId,
        "executeId": this.executeId,
        "status": `\u0072\u0075\u006e\u006e\u0069\u006e\u0067`,
        "meta": this.getStatus(),
        "message": ``
      });
      resolve();
    });
  }
  validateParameters() {
    if (!this.data) {
      return {
        message: `\u53c2\u6570\u672a\u4f20\u9012\u6216\u683c\u5f0f\u4e0d\u6b63\u786e`
      };
    }
    return null;
  }
  async my_execute(config) {
    var _a;
    chrome.storage.local.set({
      "runTaskStopped": ``
    });
    chrome.storage.local.set({
      "mqttStart": `\u006f\u006b`
    });
    chrome.storage.local.set({
      "xhs_viewCount": 0
    });
    chrome.storage.local.set({
      "xhs_CommentCount": 0
    });
    chrome.storage.local.set({
      "xhs_likeCount": 0
    });
    chrome.storage.local.set({
      "xhs_followCount": 0
    });
    chrome.storage.local.set({
      "xhs_collectCount": 0
    });
    chrome.storage.local.set({
      "dy_viewCount": 0
    });
    chrome.storage.local.set({
      "dy_CommentCount": 0
    });
    chrome.storage.local.set({
      "dy_likeCount": 0
    });
    chrome.storage.local.set({
      "dy_followCount": 0
    });
    chrome.storage.local.set({
      "dy_collectCount": 0
    });
    chrome.storage.local.set({
      "activatePage": runPages[0]
    });
    chrome.storage.local.set({
      "operationTime": 0
    });
    chrome.storage.local.set({
      "xiaoHongShuAccountErrorTip": ``
    });
    chrome.storage.local.set({
      "xhs_keywords_list": JSON.stringify([])
    });
    chrome.storage.local.set({
      "douYin_keywords_list": JSON.stringify([])
    });
    chrome.storage.local.set({
      "xhs_minute": JSON.stringify([])
    });
    chrome.storage.local.set({
      "dy_minute": JSON.stringify([])
    });
    chrome.storage.local.set({
      "optionsPageName": ``
    });
    chrome.storage.local.set({
      "executeOperationStartTime": (/* @__PURE__ */new Date()).getTime()
    });
    chrome.storage.local.set({
      "XiaoHongShu_Setting": JSON.stringify(config)
    });
    chrome.storage.local.set({
      "searchVideoLimitCount": 0
    });
    chrome.storage.local.set({
      "DouYin_search_runNumber": 1
    });
    if (!this.XiaoHongShu_Setting) {
      this.XiaoHongShu_Setting = config;
    }
    if (config.workDouYinPlatform == `\u6296\u97f3`) {
      if (!this.taskPlatform) {
        this.taskPlatform = config.workDouYinPlatform;
      }
      const saveTaskDataResult = await saveTaskData({
        task_options: {
          taskId: this.taskId,
          executeId: this.executeId,
          agentId: VITE_AGENT_ID$2,
          terminalId: (_a = store$6.terminalData) == null ? void 0 : _a.terminalId
        }
      });
      console.log(`\u0073\u0061\u0076\u0065\u0054\u0061\u0073\u006b\u0044\u0061\u0074\u0061\u0052\u0065\u0073\u0075\u006c\u0074`, saveTaskDataResult);
      if (saveTaskDataResult && saveTaskDataResult.code == 0) {
        store$6.setQuestTaskId(saveTaskDataResult.data.id);
      }
      const saveInputs = {
        "key": store$6.userId + (/* @__PURE__ */new Date()).getTime(),
        "bucket": {
          taskType: config.workType,
          taskPlatform: config.workDouYinPlatform,
          taskId: this.taskId,
          searchWord: this.XiaoHongShu_Setting.searchWord,
          userId: store$6.userId,
          addDate: formatNowDateTime(),
          addTime: (/* @__PURE__ */new Date()).getTime()
        },
        "size": 0,
        "content_type": `\u0073\u0074\u0072\u0069\u006e\u0067`,
        "belong_to": store$6.userId + `\u005f\u0073\u0065\u0061\u0072\u0063\u0068\u005f\u0076\u0069\u0064\u0065\u006f\u005f\u0074\u0061\u0073\u006b\u005f\u006c\u0069\u0073\u0074`,
        "object_metadata": {}
      };
      await addObjects(saveInputs);
      this.executeTask({
        action: `\u0065\u0078\u0065\u0063\u0075\u0074\u0065\u0054\u0061\u0073\u006b`,
        url: `\u0068\u0074\u0074\u0070\u0073\u003a\u002f\u002f\u0077\u0077\u0077\u002e\u0064\u006f\u0075\u0079\u0069\u006e\u002e\u0063\u006f\u006d`,
        taskName: config.workType,
        taskPlatform: config.workDouYinPlatform,
        taskId: this.taskId
      }, {}, res => {
        if (res && res.tabId) {
          this.tabId = res.tabId;
        }
        if (res && res.windowId) {
          this.windowId = res.windowId;
        }
        console.log(`\u0065\u0078\u0065\u0063\u0075\u0074\u0065\u0054\u0061\u0073\u006b\u0020\u0072\u0065\u0073`, res);
      });
    }
    if (config.workXiaoHongShuPlatform == `\u5c0f\u7ea2\u4e66`) {
      this.executeTask({
        action: `\u0065\u0078\u0065\u0063\u0075\u0074\u0065\u0054\u0061\u0073\u006b`,
        url: `\u0068\u0074\u0074\u0070\u0073\u003a\u002f\u002f\u0077\u0077\u0077\u002e\u0078\u0069\u0061\u006f\u0068\u006f\u006e\u0067\u0073\u0068\u0075\u002e\u0063\u006f\u006d\u002f\u0065\u0078\u0070\u006c\u006f\u0072\u0065`,
        taskName: config.workType,
        taskPlatform: config.workXiaoHongShuPlatform,
        taskId: this.taskId
      }, {}, res => {
        if (res && res.tabId) {
          this.tabId = res.tabId;
        }
        if (res && res.windowId) {
          this.windowId = res.windowId;
        }
        console.log(`\u0065\u0078\u0065\u0063\u0075\u0074\u0065\u0054\u0061\u0073\u006b\u0020\u0072\u0065\u0073`, res);
      });
      if (!this.taskPlatform) {
        this.taskPlatform = config.workXiaoHongShuPlatform;
      }
    }
  }
  stopTask() {
    return new Promise(resolve => {
      sendLog(`\u0064\u006f\u0075\u0059\u0069\u006e\u0059\u0061\u006e\u0067\u0048\u0061\u006f\u005a\u0068\u0075\u0053\u0068\u006f\u0075\u0054\u0061\u0073\u006b\u0020\u0062\u0061\u0063\u006b\u0067\u0072\u006f\u0075\u006e\u0064\u0020\u0061\u0063\u0074\u0069\u0076\u0061\u0074\u0065\u0050\u0061\u0067\u0065\u0020\uff1a`, indexPage);
      chrome.storage.local.set({
        "activatePage": indexPage
      });
      resolve();
    });
  }
  abortTask() {
    return new Promise(resolve => {
      this.reportStop().then(() => {});
      resolve();
    });
  }
  report() {
    return new Promise(resolve => {
      console.log(`\u0072\u0065\u0070\u006f\u0072\u0074\u0020\u0050\u0072\u006f\u006d\u0069\u0073\u0065`);
      try {
        let formatTimestamp = function (timestamp) {
            const date = new Date(timestamp);
            const month = String(date.getMonth() + 1).padStart(2, `\u0030`);
            const day = String(date.getDate()).padStart(2, `\u0030`);
            const hours = String(date.getHours()).padStart(2, `\u0030`);
            const minutes = String(date.getMinutes()).padStart(2, `\u0030`);
            return `${month}\u002d${day}\u0020${hours}\u003a${minutes}`;
          },
          calculateTimeDifference = function (startTimestamp, endTimestamp) {
            const differenceInMs = Math.abs(endTimestamp - startTimestamp);
            const totalMinutes = Math.floor(differenceInMs / (1e3 * 60));
            return `${totalMinutes}`;
          };
        if (!this.conn) {
          resolve();
          return;
        }
        const executeOperationStartTime = formatTimestamp(this.executeOperationStartTime);
        const executeOperationEndTime = formatTimestamp(this.executeOperationEndTime);
        const run_time = calculateTimeDifference(this.executeOperationStartTime, this.executeOperationEndTime);
        let xhs_keywords_list_str = ``;
        if (this.xhs_keywords_list.length > 0) {
          xhs_keywords_list_str = this.xhs_keywords_list.join(`\uff0c`);
        }
        let douYin_keywords_list_str = ``;
        if (this.douYin_keywords_list.length > 0) {
          douYin_keywords_list_str = this.douYin_keywords_list.join(`\uff0c`);
        }
        let XiaoHongShu_Setting = this.XiaoHongShu_Setting;
        let workRunPlatform = ``;
        if (XiaoHongShu_Setting.workDouYinPlatform) {
          if (!workRunPlatform) {
            workRunPlatform = XiaoHongShu_Setting.workDouYinPlatform;
          } else {
            workRunPlatform += `\u002b` + XiaoHongShu_Setting.workDouYinPlatform;
          }
        }
        if (XiaoHongShu_Setting.workXiaoHongShuPlatform) {
          if (!workRunPlatform) {
            workRunPlatform = XiaoHongShu_Setting.workXiaoHongShuPlatform;
          } else {
            workRunPlatform += `\u002b` + XiaoHongShu_Setting.workXiaoHongShuPlatform;
          }
        }
        const uniqueMinutes = [... /* @__PURE__ */new Set([...this.xhs_minute.map(item => item.minute), ...this.dy_minute.map(item => item.minute)])].sort((a, b) => a - b);
        const xhsNums = uniqueMinutes.map(minute => {
          var _a;
          return ((_a = this.xhs_minute.find(item => item.minute === minute)) == null ? void 0 : _a.num) || 0;
        });
        const xhsPieNumber = [{
          value: store$6.xhs_likeCount,
          name: `\u70b9\u8d5e`
        }, {
          value: store$6.xhs_CommentCount,
          name: `\u8bc4\u8bba`
        }, {
          value: store$6.xhs_followCount,
          name: `\u5173\u6ce8`
        }, {
          value: store$6.xhs_collectCount,
          name: `\u6536\u85cf`
        }];
        const dyPieNumber = [{
          value: store$6.dy_likeCount,
          name: `\u70b9\u8d5e`
        }, {
          value: store$6.dy_CommentCount,
          name: `\u8bc4\u8bba`
        }, {
          value: store$6.dy_followCount,
          name: `\u5173\u6ce8`
        }, {
          value: store$6.dy_collectCount,
          name: `\u6536\u85cf`
        }];
        const allPieNumber = [{
          value: store$6.xhs_likeCount + store$6.dy_likeCount,
          name: `\u70b9\u8d5e`
        }, {
          value: store$6.xhs_CommentCount + store$6.dy_CommentCount,
          name: `\u8bc4\u8bba`
        }, {
          value: store$6.xhs_followCount + store$6.dy_followCount,
          name: `\u5173\u6ce8`
        }, {
          value: store$6.xhs_collectCount + store$6.dy_collectCount,
          name: `\u6536\u85cf`
        }];
        const postData = {
          executeOperationStartTime,
          executeOperationEndTime,
          run_time,
          xhs_keywords_list_str,
          douYin_keywords_list_str,
          workRunPlatform,
          uniqueMinutes,
          xhsNums,
          xhsPieNumber,
          dyPieNumber,
          allPieNumber
        };
        console.log(`\u006d\u0065\u0073\u0073\u0061\u0067\u0065\u0054\u006f\u0052\u0065\u0070\u006f\u0072\u0074\u004d\u0051\u0054\u0054\u0020\u0070\u006f\u0073\u0074\u0044\u0061\u0074\u0061`, JSON.stringify(postData));
        sendLog(`\u0054\u0061\u0073\u006b\u0020\u0073\u0074\u006f\u0070\u0070\u0065\u0064`);
        this.conn.messageToReportMQTT({
          "taskId": this.taskId,
          "executeId": this.executeId,
          "status": `\u0072\u0065\u0070\u006f\u0072\u0074`,
          "meta": postData,
          "message": `\u62a5\u544a`
        });
        resolve();
      } catch (e) {
        console.log(`\u0072\u0065\u0070\u006f\u0072\u0074\u0020\u0065`, e);
      }
    });
  }
  /**
   * 获取心跳上报数据
   */
  getHeartReportData() {
    return {};
  }
  /**
   * 等待store 通知 callBackListener
   */
  async reportStop() {
    this.running = false;
    this.paused = false;
    this.callExecuteNotification();
    if (!this.conn) {
      return;
    }
    sendLog(`\u0054\u0061\u0073\u006b\u0020\u0073\u0074\u006f\u0070\u0070\u0065\u0064`);
    this.conn.messageToReplyMQTT({
      "taskId": this.taskId,
      "executeId": this.executeId,
      "status": `\u0063\u006f\u006d\u0070\u006c\u0065\u0074\u0065\u0064`,
      "meta": this.getStatus(),
      "message": `\u5df2\u505c\u6b62`
    });
    storageUtil.removeListener(this.callBackListener);
    super.baseReportStop();
  }
  getStatus() {
    return {
      id: this.taskId,
      running: this.running,
      paused: this.paused,
      started: this.started,
      process: this.operationTime > 0 ? (this.runMinuteTime / this.operationTime * 100).toFixed(2) : 0,
      total_num: this.operationTime,
      executed_num: this.runMinuteTime
    };
  }
  getRunData() {
    if (this.taskPlatform === `\u6296\u97f3`) {
      return {
        viewCount: this.dy_viewCount,
        commentCount: this.dy_CommentCount,
        likeCount: this.dy_likeCount,
        followCount: this.dy_followCount,
        collectCount: this.dy_collectCount,
        operationTime: this.operationTime,
        runMinuteTime: this.runMinuteTime
      };
    } else if (this.taskPlatform === `\u5c0f\u7ea2\u4e66`) {
      return {
        likeCount: this.xhs_likeCount,
        followCount: this.xhs_followCount,
        commentCount: this.xhs_CommentCount,
        collectCount: this.xhs_collectCount,
        viewCount: this.xhs_viewCount,
        operationTime: this.operationTime,
        runMinuteTime: this.runMinuteTime
      };
    }
  }
  reportReply() {
    console.log(`\u0072\u0065\u0070\u006f\u0072\u0074\u0052\u0065\u0070\u006c\u0079`);
    if (!this.conn) {
      return;
    }
    this.conn.messageToReplyMQTT({
      "taskId": this.taskId,
      "executeId": this.executeId,
      "status": `\u0072\u0075\u006e\u006e\u0069\u006e\u0067`,
      "meta": this.getStatus(),
      "message": ``
    });
  }
  loadFromStorage() {
    if (this.startLoad) {
      console.log(`\u0073\u0074\u0061\u0072\u0074\u004c\u006f\u0061\u0064`, this.startLoad);
      return;
    }
    this.startLoad = true;
    chrome.storage.local.get([`\u0074\u0061\u0073\u006b\u0050\u006c\u0061\u0074\u0066\u006f\u0072\u006d`, `\u0058\u0069\u0061\u006f\u0048\u006f\u006e\u0067\u0053\u0068\u0075\u005f\u0053\u0065\u0074\u0074\u0069\u006e\u0067`, `\u0078\u0068\u0073\u005f\u0076\u0069\u0065\u0077\u0043\u006f\u0075\u006e\u0074`, `\u0078\u0068\u0073\u005f\u0043\u006f\u006d\u006d\u0065\u006e\u0074\u0043\u006f\u0075\u006e\u0074`, `\u0078\u0068\u0073\u005f\u006c\u0069\u006b\u0065\u0043\u006f\u0075\u006e\u0074`, `\u0078\u0068\u0073\u005f\u0066\u006f\u006c\u006c\u006f\u0077\u0043\u006f\u0075\u006e\u0074`, `\u0078\u0068\u0073\u005f\u0063\u006f\u006c\u006c\u0065\u0063\u0074\u0043\u006f\u0075\u006e\u0074`, `\u0064\u0079\u005f\u0076\u0069\u0065\u0077\u0043\u006f\u0075\u006e\u0074`, `\u0064\u0079\u005f\u0043\u006f\u006d\u006d\u0065\u006e\u0074\u0043\u006f\u0075\u006e\u0074`, `\u0064\u0079\u005f\u006c\u0069\u006b\u0065\u0043\u006f\u0075\u006e\u0074`, `\u0064\u0079\u005f\u0066\u006f\u006c\u006c\u006f\u0077\u0043\u006f\u0075\u006e\u0074`, `\u0064\u0079\u005f\u0063\u006f\u006c\u006c\u0065\u0063\u0074\u0043\u006f\u0075\u006e\u0074`, `\u006f\u0070\u0065\u0072\u0061\u0074\u0069\u006f\u006e\u0054\u0069\u006d\u0065`, `\u0075\u0073\u0065\u0072\u0049\u0064`, `\u006f\u0072\u0067\u0049\u0064`, `\u0063\u006c\u0069\u0065\u006e\u0074\u0056\u0069\u0073\u0069\u0074\u006f\u0072\u0049\u0064`, `\u0061\u0063\u0063\u0065\u0073\u0073\u0054\u006f\u006b\u0065\u006e`], result => {
      console.log(`\u0072\u0065\u0073\u0075\u006c\u0074\u0020\u0061\u0063\u0074\u0069\u0076\u0061\u0074\u0065\u0050\u0061\u0067\u0065`, result);
      if (!result) {
        return;
      }
      if (result.userId !== void 0) {
        this.user_id = result.userId;
      }
      if (result.orgId !== void 0) {
        this.orgId = result.orgId;
      }
      if (result.clientVisitorId !== void 0) {
        this.clientVisitorId = result.clientVisitorId;
      }
      if (result.accessToken !== void 0) {
        this.accessToken = result.accessToken;
      }
      if (result.taskPlatform !== void 0) {
        this.taskPlatform = result.taskPlatform;
      }
      if (result.XiaoHongShu_Setting !== void 0) {
        this.XiaoHongShu_Setting = result.XiaoHongShu_Setting ? JSON.parse(result.XiaoHongShu_Setting) : {};
      }
      if (result.xhs_viewCount !== void 0) {
        this.xhs_viewCount = result.xhs_viewCount;
      }
      if (result.xhs_CommentCount !== void 0) {
        this.xhs_CommentCount = result.xhs_CommentCount;
      }
      if (result.xhs_likeCount !== void 0) {
        this.xhs_likeCount = result.xhs_likeCount;
      }
      if (result.xhs_followCount !== void 0) {
        this.xhs_followCount = result.xhs_followCount;
      }
      if (result.xhs_collectCount !== void 0) {
        this.xhs_collectCount = result.xhs_collectCount;
      }
      if (result.dy_viewCount !== void 0) {
        this.dy_viewCount = result.dy_viewCount;
      }
      if (result.dy_CommentCount !== void 0) {
        this.dy_CommentCount = result.dy_CommentCount;
      }
      if (result.dy_likeCount !== void 0) {
        this.dy_likeCount = result.dy_likeCount;
      }
      if (result.dy_followCount !== void 0) {
        this.dy_followCount = result.dy_followCount;
      }
      if (result.dy_collectCount !== void 0) {
        this.dy_collectCount = result.dy_collectCount;
      }
      if (result.operationTime !== void 0) {
        this.operationTime = result.operationTime;
      }
      this.startLoad = true;
      this.loadend = true;
    });
    storageUtil.addHandlers(this.callBackListener);
  }
}
UseCounterStore.getInstance();
const VITE_CONTENT_API$4 = `\u0068\u0074\u0074\u0070\u0073\u003a\u002f\u002f\u0061\u0067\u0065\u006e\u0074\u002d\u006e\u0065\u0074\u002e\u0070\u0061\u0069\u0074\u006f\u006e\u0067\u0061\u0069\u002e\u006e\u0065\u0074\u002f\u0063\u006f\u006e\u0074\u0065\u006e\u0074`;
const VITE_PAYMENT_API = void 0;
const store$5 = UseCounterStore.getInstance();
class CustomizeKuaiShouPushTask extends BaseTask {
  constructor(taskId, executeId, data, executeTask2) {
    super(taskId, executeId, data);
    __publicField(this, `\u0065\u0078\u0065\u0063\u0075\u0074\u0065\u0054\u0061\u0073\u006b`);
    //评论数量
    __publicField(this, `\u0078\u0068\u0073\u005f\u0076\u0069\u0065\u0077\u0043\u006f\u0075\u006e\u0074`);
    __publicField(this, `\u0078\u0068\u0073\u005f\u0043\u006f\u006d\u006d\u0065\u006e\u0074\u0043\u006f\u0075\u006e\u0074`);
    __publicField(this, `\u0078\u0068\u0073\u005f\u006c\u0069\u006b\u0065\u0043\u006f\u0075\u006e\u0074`);
    __publicField(this, `\u0078\u0068\u0073\u005f\u0066\u006f\u006c\u006c\u006f\u0077\u0043\u006f\u0075\u006e\u0074`);
    __publicField(this, `\u0078\u0068\u0073\u005f\u0063\u006f\u006c\u006c\u0065\u0063\u0074\u0043\u006f\u0075\u006e\u0074`);
    //评论数量
    __publicField(this, `\u0064\u0079\u005f\u0076\u0069\u0065\u0077\u0043\u006f\u0075\u006e\u0074`);
    __publicField(this, `\u0064\u0079\u005f\u0043\u006f\u006d\u006d\u0065\u006e\u0074\u0043\u006f\u0075\u006e\u0074`);
    __publicField(this, `\u0064\u0079\u005f\u006c\u0069\u006b\u0065\u0043\u006f\u0075\u006e\u0074`);
    __publicField(this, `\u0064\u0079\u005f\u0066\u006f\u006c\u006c\u006f\u0077\u0043\u006f\u0075\u006e\u0074`);
    __publicField(this, `\u0064\u0079\u005f\u0063\u006f\u006c\u006c\u0065\u0063\u0074\u0043\u006f\u0075\u006e\u0074`);
    __publicField(this, `\u0074\u0061\u0073\u006b\u0050\u006c\u0061\u0074\u0066\u006f\u0072\u006d`);
    __publicField(this, `\u0058\u0069\u0061\u006f\u0048\u006f\u006e\u0067\u0053\u0068\u0075\u005f\u0053\u0065\u0074\u0074\u0069\u006e\u0067`);
    __publicField(this, `\u006f\u0070\u0065\u0072\u0061\u0074\u0069\u006f\u006e\u0054\u0069\u006d\u0065`);
    __publicField(this, `\u0072\u0075\u006e\u004d\u0069\u006e\u0075\u0074\u0065\u0054\u0069\u006d\u0065`);
    __publicField(this, `\u0073\u0074\u0061\u0072\u0074\u004c\u006f\u0061\u0064`);
    __publicField(this, `\u006c\u006f\u0061\u0064\u0065\u006e\u0064`);
    // 上报数据
    __publicField(this, `\u0065\u0078\u0065\u0063\u0075\u0074\u0065\u004f\u0070\u0065\u0072\u0061\u0074\u0069\u006f\u006e\u0053\u0074\u0061\u0072\u0074\u0054\u0069\u006d\u0065`);
    __publicField(this, `\u0065\u0078\u0065\u0063\u0075\u0074\u0065\u004f\u0070\u0065\u0072\u0061\u0074\u0069\u006f\u006e\u0045\u006e\u0064\u0054\u0069\u006d\u0065`);
    __publicField(this, `\u0078\u0068\u0073\u005f\u006b\u0065\u0079\u0077\u006f\u0072\u0064\u0073\u005f\u006c\u0069\u0073\u0074`);
    __publicField(this, `\u0064\u006f\u0075\u0059\u0069\u006e\u005f\u006b\u0065\u0079\u0077\u006f\u0072\u0064\u0073\u005f\u006c\u0069\u0073\u0074`);
    __publicField(this, `\u0078\u0068\u0073\u005f\u006d\u0069\u006e\u0075\u0074\u0065`);
    __publicField(this, `\u0064\u0079\u005f\u006d\u0069\u006e\u0075\u0074\u0065`);
    __publicField(this, `\u0076\u0069\u0064\u0065\u006f\u004c\u0069\u006e\u006b`);
    __publicField(this, `\u0070\u006f\u0073\u0074\u0049\u0074\u0065\u006d\u0055\u0073\u0061\u0067\u0065`, async () => {
      const url = VITE_PAYMENT_API + `\u002f\u0069\u0074\u0065\u006d\u005f\u0075\u0073\u0061\u0067\u0065\u003f\u0075\u0073\u0061\u0067\u0065\u005f\u0074\u0079\u0070\u0065\u003d\u0070\u0075\u0062\u006c\u0069\u0073\u0068`;
      const headers = {
        accept: `\u0061\u0070\u0070\u006c\u0069\u0063\u0061\u0074\u0069\u006f\u006e\u002f\u006a\u0073\u006f\u006e`,
        ...this.addAuthorizationHeader()
      };
      try {
        const response = await fetch(url, {
          method: `\u0050\u004f\u0053\u0054`,
          headers
        });
        if (!response.ok) {
          console.log(`\u0075\u0072\u006c\u003a` + url + `\uff0c\u0068\u0065\u0061\u0064\u0065\u0072\u003a` + JSON.stringify(headers) + `\u002c\u0020\u0072\u0065\u0073\u0070\u006f\u006e\u0073\u0065\u0020\u0073\u0074\u0061\u0074\u0075\u0073\u003a` + response.status);
          return;
        }
        const result = await response.json();
        console.log(`\u0075\u0072\u006c\u003a` + url + `\uff0c\u0068\u0065\u0061\u0064\u0065\u0072\u003a` + JSON.stringify(headers) + `\u002c\u0072\u0065\u0073\u0070\u006f\u006e\u0073\u0065\u0020\u0073\u0074\u0061\u0074\u0075\u0073\u003a` + response.status + `\u002c\u0020\u0072\u0065\u0073\u0070\u006f\u006e\u0073\u0065\u0020\u0064\u0061\u0074\u0061\u003a` + JSON.stringify(result));
      } catch (error) {
        console.error(`\u8bf7\u6c42\u5931\u8d25\u003a`, error);
      }
    });
    // reportVideoLink(videoLink:string){
    //     console.log("reportVideoLink")
    //     if(!this.conn){
    //         return
    //     }
    //     const  status = this.getStatus();
    //     status.videoLink = videoLink; // 添加新属性
    //
    //     this.conn.messageToReplyMQTT({
    //         "taskId": this.taskId,
    //         "executeId": this.executeId,
    //         "status": "running",
    //         "meta": status,
    //         "message": ""
    //     });
    // }
    __publicField(this, `\u0072\u0065\u0070\u006f\u0072\u0074\u0052\u0075\u006e\u0044\u0061\u0074\u0061\u0053\u0074\u0061\u0074\u0075\u0073`, async () => {
      var _a;
      console.log(`\u0072\u0065\u0070\u006f\u0072\u0074\u0052\u0075\u006e\u0044\u0061\u0074\u0061\u0053\u0074\u0061\u0074\u0075\u0073`);
      if (!this.conn) {
        return;
      }
      const runData = this.getRunData();
      console.log(`\u0072\u0075\u006e\u0044\u0061\u0074\u0061`, JSON.stringify(runData));
      this.conn.messageToStatusMQTT({
        "taskId": this.taskId,
        "data": runData,
        "userId": this.user_id,
        "terminalId": (_a = this.terminalData) == null ? void 0 : _a.terminalId
      });
    });
    __publicField(this, `\u0072\u0065\u0070\u006f\u0072\u0074\u0052\u0075\u006e\u0044\u0061\u0074\u0061`, async () => {
      var _a;
      const url = VITE_CONTENT_API$4 + `\u002f\u0061\u0070\u0069\u002f\u0063\u006f\u006e\u0074\u0065\u006e\u0074\u002f`;
      const headers = {
        "Content-Type": `\u0061\u0070\u0070\u006c\u0069\u0063\u0061\u0074\u0069\u006f\u006e\u002f\u006a\u0073\u006f\u006e`,
        ...this.addAuthorizationHeader()
        // Ensure this function works in the extension
      };
      try {
        console.log(`\u0072\u0065\u0070\u006f\u0072\u0074\u0052\u0075\u006e\u0044\u0061\u0074\u0061`);
        const runData = this.getRunData();
        console.log(`\u0072\u0075\u006e\u0044\u0061\u0074\u0061`, JSON.stringify(runData));
        const postData = {
          "taskId": this.taskId,
          "data": runData,
          "userId": this.user_id,
          "terminalId": (_a = this.terminalData) == null ? void 0 : _a.terminalId
        };
        const response = await fetch(url, {
          method: `\u0050\u004f\u0053\u0054`,
          headers,
          body: JSON.stringify(postData)
        });
        if (!response.ok) {
          console.log(`\u0075\u0072\u006c\u003a` + url + `\uff0c\u0068\u0065\u0061\u0064\u0065\u0072\u003a` + JSON.stringify(headers) + `\u002c\u0020\u0072\u0065\u0073\u0070\u006f\u006e\u0073\u0065\u0020\u0073\u0074\u0061\u0074\u0075\u0073\u003a` + response.status);
          return;
        }
        const result = await response.json();
        console.log(`\u0075\u0072\u006c\u003a` + url + `\uff0c\u0068\u0065\u0061\u0064\u0065\u0072\u003a` + JSON.stringify(headers) + `\u002c\u0070\u006f\u0073\u0074\u0044\u0061\u0074\u0061\uff1a` + JSON.stringify(postData) + `\u0020\u0072\u0065\u0073\u0070\u006f\u006e\u0073\u0065\u0020\u0073\u0074\u0061\u0074\u0075\u0073\u003a` + response.status + `\u002c\u0020\u0072\u0065\u0073\u0070\u006f\u006e\u0073\u0065\u0020\u0064\u0061\u0074\u0061\u003a` + JSON.stringify(result));
      } catch (error) {
        console.log(`\u0045\u0072\u0072\u006f\u0072\u0020\u0069\u006e\u0020\u0070\u0075\u0074\u004e\u0065\u0077\u0054\u0061\u0073\u006b\u003a`, error);
        sendLog(`\u0075\u0072\u006c\u003a` + url + `\uff0c\u0068\u0065\u0061\u0064\u0065\u0072\u003a` + JSON.stringify(headers) + `\u002c\u0020\u0065\u0072\u0072\u006f\u0072` + error);
      }
    });
    __publicField(this, `\u0063\u0061\u006c\u006c\u0042\u0061\u0063\u006b\u004c\u0069\u0073\u0074\u0065\u006e\u0065\u0072`, (changes, namespace) => {
      for (let [key, {
        oldValue,
        newValue
      }] of Object.entries(changes)) {
        console.log(`\u0063\u0075\u0073\u0074\u006f\u006d\u0069\u007a\u0065\u0054\u0061\u0073\u006b\u0020\u0053\u0074\u006f\u0072\u0061\u0067\u0065\u0020\u006b\u0065\u0079\u0020\u0022${key}\u0022\u0020\u0069\u006e\u0020\u006e\u0061\u006d\u0065\u0073\u0070\u0061\u0063\u0065\u0020\u0022${namespace}\u0022\u0020\u0063\u0068\u0061\u006e\u0067\u0065\u0064\u002e`, `\u004f\u006c\u0064\u0020\u0076\u0061\u006c\u0075\u0065\u0020\u0077\u0061\u0073\u0020\u0022${oldValue}\u0022\u002c\u0020\u006e\u0065\u0077\u0020\u0076\u0061\u006c\u0075\u0065\u0020\u0069\u0073\u0020\u0022${newValue}\u0022\u002e`);
        switch (key) {
          case `\u0072\u0075\u006e\u0054\u0061\u0073\u006b\u0053\u0074\u006f\u0070\u0070\u0065\u0064`:
            if (newValue == `\u0065\u006e\u0064`) {
              this.reportStop().then(() => {});
            }
            break;
          case `\u0074\u0061\u0073\u006b\u0050\u006c\u0061\u0074\u0066\u006f\u0072\u006d`:
            this.taskPlatform = newValue;
            break;
          case `\u0058\u0069\u0061\u006f\u0048\u006f\u006e\u0067\u0053\u0068\u0075\u005f\u0053\u0065\u0074\u0074\u0069\u006e\u0067`:
            this.XiaoHongShu_Setting = newValue ? JSON.parse(newValue) : {};
            break;
          case `\u006f\u0072\u0067\u0049\u0064`:
            this.orgId = newValue;
            break;
          case `\u0075\u0073\u0065\u0072\u0049\u0064`:
            this.user_id = newValue;
            break;
          case `\u0063\u006c\u0069\u0065\u006e\u0074\u0056\u0069\u0073\u0069\u0074\u006f\u0072\u0049\u0064`:
            this.clientVisitorId = newValue;
            break;
          case `\u0061\u0063\u0063\u0065\u0073\u0073\u0054\u006f\u006b\u0065\u006e`:
            this.accessToken = newValue;
            break;
          case `\u006f\u0070\u0065\u0072\u0061\u0074\u0069\u006f\u006e\u0054\u0069\u006d\u0065`:
            this.operationTime = newValue;
            break;
          case `\u0072\u0075\u006e\u004d\u0069\u006e\u0075\u0074\u0065\u0054\u0069\u006d\u0065`:
            this.runMinuteTime = newValue;
            this.reportReply();
            break;
          case `\u0078\u0068\u0073\u005f\u006c\u0069\u006b\u0065\u0043\u006f\u0075\u006e\u0074`:
            this.xhs_likeCount = newValue;
            this.reportRunDataStatus().then();
            break;
          case `\u0078\u0068\u0073\u005f\u0066\u006f\u006c\u006c\u006f\u0077\u0043\u006f\u0075\u006e\u0074`:
            this.xhs_followCount = newValue;
            this.reportRunDataStatus().then();
            break;
          case `\u0078\u0068\u0073\u005f\u0043\u006f\u006d\u006d\u0065\u006e\u0074\u0043\u006f\u0075\u006e\u0074`:
            this.xhs_CommentCount = newValue;
            this.reportRunDataStatus().then();
            break;
          case `\u0078\u0068\u0073\u005f\u0063\u006f\u006c\u006c\u0065\u0063\u0074\u0043\u006f\u0075\u006e\u0074`:
            this.xhs_collectCount = newValue;
            this.reportRunDataStatus().then();
            break;
          case `\u0078\u0068\u0073\u005f\u0076\u0069\u0065\u0077\u0043\u006f\u0075\u006e\u0074`:
            this.xhs_viewCount = newValue;
            this.reportRunDataStatus().then();
            break;
          case `\u0064\u0079\u005f\u006c\u0069\u006b\u0065\u0043\u006f\u0075\u006e\u0074`:
            this.dy_likeCount = newValue;
            this.reportRunDataStatus().then();
            break;
          case `\u0064\u0079\u005f\u0066\u006f\u006c\u006c\u006f\u0077\u0043\u006f\u0075\u006e\u0074`:
            this.dy_followCount = newValue;
            this.reportRunDataStatus().then();
            break;
          case `\u0064\u0079\u005f\u0043\u006f\u006d\u006d\u0065\u006e\u0074\u0043\u006f\u0075\u006e\u0074`:
            this.dy_CommentCount = newValue;
            this.reportRunDataStatus().then();
            break;
          case `\u0064\u0079\u005f\u0063\u006f\u006c\u006c\u0065\u0063\u0074\u0043\u006f\u0075\u006e\u0074`:
            this.dy_collectCount = newValue;
            this.reportRunDataStatus().then();
            break;
          case `\u0064\u0079\u005f\u0076\u0069\u0065\u0077\u0043\u006f\u0075\u006e\u0074`:
            this.dy_viewCount = newValue;
            this.reportRunDataStatus().then();
            break;
          case `\u0065\u0078\u0065\u0063\u0075\u0074\u0065\u004f\u0070\u0065\u0072\u0061\u0074\u0069\u006f\u006e\u0053\u0074\u0061\u0072\u0074\u0054\u0069\u006d\u0065`:
            this.executeOperationStartTime = newValue;
            break;
          case `\u0065\u0078\u0065\u0063\u0075\u0074\u0065\u004f\u0070\u0065\u0072\u0061\u0074\u0069\u006f\u006e\u0045\u006e\u0064\u0054\u0069\u006d\u0065`:
            this.executeOperationEndTime = newValue;
            break;
          case `\u0078\u0068\u0073\u005f\u006b\u0065\u0079\u0077\u006f\u0072\u0064\u0073\u005f\u006c\u0069\u0073\u0074`:
            this.xhs_keywords_list = newValue ? JSON.parse(newValue) : [];
            break;
          case `\u0064\u006f\u0075\u0059\u0069\u006e\u005f\u006b\u0065\u0079\u0077\u006f\u0072\u0064\u0073\u005f\u006c\u0069\u0073\u0074`:
            this.douYin_keywords_list = newValue ? JSON.parse(newValue) : [];
            break;
          case `\u0078\u0068\u0073\u005f\u006d\u0069\u006e\u0075\u0074\u0065`:
            this.xhs_minute = newValue ? JSON.parse(newValue) : [];
            break;
          case `\u0064\u0079\u005f\u006d\u0069\u006e\u0075\u0074\u0065`:
            this.dy_minute = newValue ? JSON.parse(newValue) : [];
            break;
          case `\u0076\u0069\u0064\u0065\u006f\u004c\u0069\u006e\u006b`:
            this.videoLink = newValue;
            break;
        }
      }
    });
    this.startLoad = false;
    this.loadend = false;
    this.xhs_viewCount = 0;
    this.xhs_CommentCount = 0;
    this.xhs_likeCount = 0;
    this.xhs_followCount = 0;
    this.xhs_collectCount = 0;
    this.dy_viewCount = 0;
    this.dy_CommentCount = 0;
    this.dy_likeCount = 0;
    this.dy_followCount = 0;
    this.dy_collectCount = 0;
    this.operationTime = 0;
    this.runMinuteTime = 0;
    this.taskPlatform = ``;
    this.XiaoHongShu_Setting = ``;
    this.executeTask = executeTask2;
    this.executeOperationStartTime = 0;
    this.executeOperationEndTime = 0;
    this.xhs_keywords_list = [];
    this.douYin_keywords_list = [];
    this.xhs_minute = [];
    this.dy_minute = [];
    this.loadFromStorage();
  }
  /**
   * 检查配置是否正确
   */
  checkConfig() {
    return true;
  }
  startTask() {
    return new Promise(resolve => {
      const validationError = this.validateParameters();
      if (!this.conn) {
        return;
      }
      if (validationError) {
        console.error(validationError.message);
        this.conn.messageToReplyMQTT({
          "taskId": this.taskId,
          "executeId": this.executeId,
          "status": `\u0066\u0061\u0069\u006c\u0065\u0064`,
          "meta": {},
          "message": validationError.message
        });
        return;
      }
      console.log(`\u0044\u006f\u0020\u0061\u0020\u0063\u0075\u0073\u0074\u006f\u006d\u0069\u007a\u0065\u0020\u0074\u0061\u0073\u006b\u0021`);
      this.my_execute(this.data);
      this.conn.messageToReplyMQTT({
        "taskId": this.taskId,
        "executeId": this.executeId,
        "status": `\u0072\u0075\u006e\u006e\u0069\u006e\u0067`,
        "meta": this.getStatus(),
        "message": ``
      });
      resolve();
    });
  }
  validateParameters() {
    if (!this.data) {
      return {
        message: `\u53c2\u6570\u672a\u4f20\u9012\u6216\u683c\u5f0f\u4e0d\u6b63\u786e`
      };
    }
    return null;
  }
  my_execute(config) {
    chrome.storage.local.set({
      "runTaskStopped": ``
    });
    chrome.storage.local.set({
      "mqttStart": `\u006f\u006b`
    });
    chrome.storage.local.set({
      "xhs_viewCount": 0
    });
    chrome.storage.local.set({
      "xhs_CommentCount": 0
    });
    chrome.storage.local.set({
      "xhs_likeCount": 0
    });
    chrome.storage.local.set({
      "xhs_followCount": 0
    });
    chrome.storage.local.set({
      "xhs_collectCount": 0
    });
    chrome.storage.local.set({
      "dy_viewCount": 0
    });
    chrome.storage.local.set({
      "dy_CommentCount": 0
    });
    chrome.storage.local.set({
      "dy_likeCount": 0
    });
    chrome.storage.local.set({
      "dy_followCount": 0
    });
    chrome.storage.local.set({
      "dy_collectCount": 0
    });
    chrome.storage.local.set({
      "XiaoHongShu_search_runNumber": 1
    });
    chrome.storage.local.set({
      "activatePage": runPages[0]
    });
    chrome.storage.local.set({
      "operationTime": 0
    });
    chrome.storage.local.set({
      "xiaoHongShuAccountErrorTip": ``
    });
    chrome.storage.local.set({
      "xhs_keywords_list": JSON.stringify([])
    });
    chrome.storage.local.set({
      "douYin_keywords_list": JSON.stringify([])
    });
    chrome.storage.local.set({
      "xhs_minute": JSON.stringify([])
    });
    chrome.storage.local.set({
      "dy_minute": JSON.stringify([])
    });
    chrome.storage.local.set({
      "optionsPageName": ``
    });
    chrome.storage.local.set({
      "executeOperationStartTime": (/* @__PURE__ */new Date()).getTime()
    });
    chrome.storage.local.set({
      "XiaoHongShu_Setting": JSON.stringify(config)
    });
    if (!this.XiaoHongShu_Setting) {
      this.XiaoHongShu_Setting = config;
    }
    if (!this.taskPlatform) {
      this.taskPlatform = `\u5feb\u624b`;
    }
    let url = `\u0068\u0074\u0074\u0070\u0073\u003a\u002f\u002f\u0063\u0070\u002e\u006b\u0075\u0061\u0069\u0073\u0068\u006f\u0075\u002e\u0063\u006f\u006d\u002f\u0061\u0072\u0074\u0069\u0063\u006c\u0065\u002f\u0070\u0075\u0062\u006c\u0069\u0073\u0068\u002f\u0076\u0069\u0064\u0065\u006f\u003f\u0074\u0061\u0062\u0054\u0079\u0070\u0065\u003d\u0032`;
    if (config.contentType == `\u89c6\u9891`) {
      url = `\u0068\u0074\u0074\u0070\u0073\u003a\u002f\u002f\u0063\u0070\u002e\u006b\u0075\u0061\u0069\u0073\u0068\u006f\u0075\u002e\u0063\u006f\u006d\u002f\u0061\u0072\u0074\u0069\u0063\u006c\u0065\u002f\u0070\u0075\u0062\u006c\u0069\u0073\u0068\u002f\u0076\u0069\u0064\u0065\u006f\u003f\u0074\u0061\u0062\u0054\u0079\u0070\u0065\u003d\u0031`;
    }
    this.executeTask({
      action: `\u0065\u0078\u0065\u0063\u0075\u0074\u0065\u0054\u0061\u0073\u006b`,
      url,
      taskName: config.taskName,
      taskPlatform: `\u5feb\u624b`,
      taskId: this.taskId
    }, {}, res => {
      if (res && res.tabId) {
        this.tabId = res.tabId;
      }
      if (res && res.windowId) {
        this.windowId = res.windowId;
      }
      console.log(`\u0065\u0078\u0065\u0063\u0075\u0074\u0065\u0054\u0061\u0073\u006b\u0020\u0072\u0065\u0073`, res);
    });
  }
  stopTask() {
    return new Promise(resolve => {
      chrome.storage.local.set({
        "activatePage": indexPage
      });
      resolve();
    });
  }
  abortTask() {
    return new Promise(resolve => {
      this.reportStop().then(() => {});
      resolve();
    });
  }
  report() {
    return new Promise(resolve => {
      console.log(`\u0072\u0065\u0070\u006f\u0072\u0074\u0020\u0050\u0072\u006f\u006d\u0069\u0073\u0065`);
      try {
        let formatTimestamp = function (timestamp) {
            const date = new Date(timestamp);
            const month = String(date.getMonth() + 1).padStart(2, `\u0030`);
            const day = String(date.getDate()).padStart(2, `\u0030`);
            const hours = String(date.getHours()).padStart(2, `\u0030`);
            const minutes = String(date.getMinutes()).padStart(2, `\u0030`);
            return `${month}\u002d${day}\u0020${hours}\u003a${minutes}`;
          },
          calculateTimeDifference = function (startTimestamp, endTimestamp) {
            const differenceInMs = Math.abs(endTimestamp - startTimestamp);
            const totalMinutes = Math.floor(differenceInMs / (1e3 * 60));
            return `${totalMinutes}`;
          };
        if (!this.conn) {
          resolve();
          return;
        }
        const executeOperationStartTime = formatTimestamp(this.executeOperationStartTime);
        const executeOperationEndTime = formatTimestamp(this.executeOperationEndTime);
        const run_time = calculateTimeDifference(this.executeOperationStartTime, this.executeOperationEndTime);
        let xhs_keywords_list_str = ``;
        if (this.xhs_keywords_list.length > 0) {
          xhs_keywords_list_str = this.xhs_keywords_list.join(`\uff0c`);
        }
        let douYin_keywords_list_str = ``;
        if (this.douYin_keywords_list.length > 0) {
          douYin_keywords_list_str = this.douYin_keywords_list.join(`\uff0c`);
        }
        let XiaoHongShu_Setting = this.XiaoHongShu_Setting;
        let workRunPlatform = ``;
        if (XiaoHongShu_Setting.workDouYinPlatform) {
          if (!workRunPlatform) {
            workRunPlatform = XiaoHongShu_Setting.workDouYinPlatform;
          } else {
            workRunPlatform += `\u002b` + XiaoHongShu_Setting.workDouYinPlatform;
          }
        }
        if (XiaoHongShu_Setting.workXiaoHongShuPlatform) {
          if (!workRunPlatform) {
            workRunPlatform = XiaoHongShu_Setting.workXiaoHongShuPlatform;
          } else {
            workRunPlatform += `\u002b` + XiaoHongShu_Setting.workXiaoHongShuPlatform;
          }
        }
        const uniqueMinutes = [... /* @__PURE__ */new Set([...this.xhs_minute.map(item => item.minute), ...this.dy_minute.map(item => item.minute)])].sort((a, b) => a - b);
        const xhsNums = uniqueMinutes.map(minute => {
          var _a;
          return ((_a = this.xhs_minute.find(item => item.minute === minute)) == null ? void 0 : _a.num) || 0;
        });
        const xhsPieNumber = [{
          value: store$5.xhs_likeCount,
          name: `\u70b9\u8d5e`
        }, {
          value: store$5.xhs_CommentCount,
          name: `\u8bc4\u8bba`
        }, {
          value: store$5.xhs_followCount,
          name: `\u5173\u6ce8`
        }, {
          value: store$5.xhs_collectCount,
          name: `\u6536\u85cf`
        }];
        const dyPieNumber = [{
          value: store$5.dy_likeCount,
          name: `\u70b9\u8d5e`
        }, {
          value: store$5.dy_CommentCount,
          name: `\u8bc4\u8bba`
        }, {
          value: store$5.dy_followCount,
          name: `\u5173\u6ce8`
        }, {
          value: store$5.dy_collectCount,
          name: `\u6536\u85cf`
        }];
        const allPieNumber = [{
          value: store$5.xhs_likeCount + store$5.dy_likeCount,
          name: `\u70b9\u8d5e`
        }, {
          value: store$5.xhs_CommentCount + store$5.dy_CommentCount,
          name: `\u8bc4\u8bba`
        }, {
          value: store$5.xhs_followCount + store$5.dy_followCount,
          name: `\u5173\u6ce8`
        }, {
          value: store$5.xhs_collectCount + store$5.dy_collectCount,
          name: `\u6536\u85cf`
        }];
        const postData = {
          executeOperationStartTime,
          executeOperationEndTime,
          run_time,
          xhs_keywords_list_str,
          douYin_keywords_list_str,
          workRunPlatform,
          uniqueMinutes,
          xhsNums,
          xhsPieNumber,
          dyPieNumber,
          allPieNumber
        };
        console.log(`\u006d\u0065\u0073\u0073\u0061\u0067\u0065\u0054\u006f\u0052\u0065\u0070\u006f\u0072\u0074\u004d\u0051\u0054\u0054\u0020\u0070\u006f\u0073\u0074\u0044\u0061\u0074\u0061`, JSON.stringify(postData));
        sendLog(`\u0054\u0061\u0073\u006b\u0020\u0073\u0074\u006f\u0070\u0070\u0065\u0064`);
        this.conn.messageToReportMQTT({
          "taskId": this.taskId,
          "executeId": this.executeId,
          "status": `\u0072\u0065\u0070\u006f\u0072\u0074`,
          "meta": postData,
          "message": `\u62a5\u544a`
        });
        resolve();
      } catch (e) {
        console.log(`\u0072\u0065\u0070\u006f\u0072\u0074\u0020\u0065`, e);
      }
    });
  }
  /**
   * 等待store 通知 callBackListener
   */
  async reportStop() {
    this.running = false;
    this.paused = false;
    this.callExecuteNotification();
    if (!this.conn) {
      return;
    }
    sendLog(`\u0054\u0061\u0073\u006b\u0020\u0073\u0074\u006f\u0070\u0070\u0065\u0064`);
    const status = this.getStatus();
    status.videoLink = this.videoLink;
    if (this.videoLink) {
      this.postItemUsage().then(r => {
        console.log(r);
      });
      this.conn.messageToReplyMQTT({
        "taskId": this.taskId,
        "executeId": this.executeId,
        "status": `\u0063\u006f\u006d\u0070\u006c\u0065\u0074\u0065\u0064`,
        "meta": status,
        "message": `\u5df2\u505c\u6b62`
      });
    } else {
      this.conn.messageToReplyMQTT({
        "taskId": this.taskId,
        "executeId": this.executeId,
        "status": `\u0063\u006f\u006d\u0070\u006c\u0065\u0074\u0065\u0064`,
        "meta": {},
        "message": `\u505c\u6b62\u53d1\u5e03`
      });
    }
    storageUtil.removeListener(this.callBackListener);
    super.baseReportStop();
  }
  getStatus() {
    return {
      id: this.taskId,
      running: this.running,
      paused: this.paused,
      started: this.started,
      process: this.operationTime > 0 ? (this.runMinuteTime / this.operationTime * 100).toFixed(2) : 0,
      total_num: this.operationTime,
      executed_num: this.runMinuteTime
    };
  }
  getRunData() {
    if (this.taskPlatform === `\u6296\u97f3`) {
      return {
        viewCount: this.dy_viewCount,
        commentCount: this.dy_CommentCount,
        likeCount: this.dy_likeCount,
        followCount: this.dy_followCount,
        collectCount: this.dy_collectCount,
        operationTime: this.operationTime,
        runMinuteTime: this.runMinuteTime
      };
    } else if (this.taskPlatform === `\u5c0f\u7ea2\u4e66`) {
      return {
        likeCount: this.xhs_likeCount,
        followCount: this.xhs_followCount,
        commentCount: this.xhs_CommentCount,
        collectCount: this.xhs_collectCount,
        viewCount: this.xhs_viewCount,
        operationTime: this.operationTime,
        runMinuteTime: this.runMinuteTime
      };
    }
  }
  reportReply() {
    console.log(`\u0072\u0065\u0070\u006f\u0072\u0074\u0052\u0065\u0070\u006c\u0079`);
    if (!this.conn) {
      return;
    }
    this.conn.messageToReplyMQTT({
      "taskId": this.taskId,
      "executeId": this.executeId,
      "status": `\u0072\u0075\u006e\u006e\u0069\u006e\u0067`,
      "meta": this.getStatus(),
      "message": ``
    });
  }
  loadFromStorage() {
    if (this.startLoad) {
      console.log(`\u0073\u0074\u0061\u0072\u0074\u004c\u006f\u0061\u0064`, this.startLoad);
      return;
    }
    this.startLoad = true;
    chrome.storage.local.get([`\u0074\u0061\u0073\u006b\u0050\u006c\u0061\u0074\u0066\u006f\u0072\u006d`, `\u0058\u0069\u0061\u006f\u0048\u006f\u006e\u0067\u0053\u0068\u0075\u005f\u0053\u0065\u0074\u0074\u0069\u006e\u0067`, `\u0078\u0068\u0073\u005f\u0076\u0069\u0065\u0077\u0043\u006f\u0075\u006e\u0074`, `\u0078\u0068\u0073\u005f\u0043\u006f\u006d\u006d\u0065\u006e\u0074\u0043\u006f\u0075\u006e\u0074`, `\u0078\u0068\u0073\u005f\u006c\u0069\u006b\u0065\u0043\u006f\u0075\u006e\u0074`, `\u0078\u0068\u0073\u005f\u0066\u006f\u006c\u006c\u006f\u0077\u0043\u006f\u0075\u006e\u0074`, `\u0078\u0068\u0073\u005f\u0063\u006f\u006c\u006c\u0065\u0063\u0074\u0043\u006f\u0075\u006e\u0074`, `\u0064\u0079\u005f\u0076\u0069\u0065\u0077\u0043\u006f\u0075\u006e\u0074`, `\u0064\u0079\u005f\u0043\u006f\u006d\u006d\u0065\u006e\u0074\u0043\u006f\u0075\u006e\u0074`, `\u0064\u0079\u005f\u006c\u0069\u006b\u0065\u0043\u006f\u0075\u006e\u0074`, `\u0064\u0079\u005f\u0066\u006f\u006c\u006c\u006f\u0077\u0043\u006f\u0075\u006e\u0074`, `\u0064\u0079\u005f\u0063\u006f\u006c\u006c\u0065\u0063\u0074\u0043\u006f\u0075\u006e\u0074`, `\u006f\u0070\u0065\u0072\u0061\u0074\u0069\u006f\u006e\u0054\u0069\u006d\u0065`, `\u0075\u0073\u0065\u0072\u0049\u0064`, `\u006f\u0072\u0067\u0049\u0064`, `\u0063\u006c\u0069\u0065\u006e\u0074\u0056\u0069\u0073\u0069\u0074\u006f\u0072\u0049\u0064`, `\u0061\u0063\u0063\u0065\u0073\u0073\u0054\u006f\u006b\u0065\u006e`], result => {
      console.log(`\u0072\u0065\u0073\u0075\u006c\u0074\u0020\u0061\u0063\u0074\u0069\u0076\u0061\u0074\u0065\u0050\u0061\u0067\u0065`, result);
      if (!result) {
        return;
      }
      if (result.userId !== void 0) {
        this.user_id = result.userId;
      }
      if (result.orgId !== void 0) {
        this.orgId = result.orgId;
      }
      if (result.clientVisitorId !== void 0) {
        this.clientVisitorId = result.clientVisitorId;
      }
      if (result.accessToken !== void 0) {
        this.accessToken = result.accessToken;
      }
      if (result.taskPlatform !== void 0) {
        this.taskPlatform = result.taskPlatform;
      }
      if (result.XiaoHongShu_Setting !== void 0) {
        this.XiaoHongShu_Setting = result.XiaoHongShu_Setting ? JSON.parse(result.XiaoHongShu_Setting) : {};
      }
      if (result.xhs_viewCount !== void 0) {
        this.xhs_viewCount = result.xhs_viewCount;
      }
      if (result.xhs_CommentCount !== void 0) {
        this.xhs_CommentCount = result.xhs_CommentCount;
      }
      if (result.xhs_likeCount !== void 0) {
        this.xhs_likeCount = result.xhs_likeCount;
      }
      if (result.xhs_followCount !== void 0) {
        this.xhs_followCount = result.xhs_followCount;
      }
      if (result.xhs_collectCount !== void 0) {
        this.xhs_collectCount = result.xhs_collectCount;
      }
      if (result.dy_viewCount !== void 0) {
        this.dy_viewCount = result.dy_viewCount;
      }
      if (result.dy_CommentCount !== void 0) {
        this.dy_CommentCount = result.dy_CommentCount;
      }
      if (result.dy_likeCount !== void 0) {
        this.dy_likeCount = result.dy_likeCount;
      }
      if (result.dy_followCount !== void 0) {
        this.dy_followCount = result.dy_followCount;
      }
      if (result.dy_collectCount !== void 0) {
        this.dy_collectCount = result.dy_collectCount;
      }
      if (result.operationTime !== void 0) {
        this.operationTime = result.operationTime;
      }
      this.startLoad = true;
      this.loadend = true;
    });
    storageUtil.addHandlers(this.callBackListener);
  }
  getHeartReportData() {}
}
const VITE_CONTENT_API$3 = `\u0068\u0074\u0074\u0070\u0073\u003a\u002f\u002f\u0061\u0067\u0065\u006e\u0074\u002d\u006e\u0065\u0074\u002e\u0070\u0061\u0069\u0074\u006f\u006e\u0067\u0061\u0069\u002e\u006e\u0065\u0074\u002f\u0063\u006f\u006e\u0074\u0065\u006e\u0074`;
const VITE_AGENT_ID$1 = `\u0078\u0069\u0061\u006f\u0073\u0068\u0075\u0074\u0069\u0061\u006f\u002d\u0061\u0075\u0074\u006f\u006d\u0061\u0074\u0069\u0063\u002d\u0065\u0078\u0074\u0065\u006e\u0073\u0069\u006f\u006e`;
const store$4 = UseCounterStore.getInstance();
class KuaiShouYangHaoZhuShouTask extends BaseTask {
  constructor(taskId, executeId, data, executeTask2) {
    super(taskId, executeId, data);
    __publicField(this, `\u0065\u0078\u0065\u0063\u0075\u0074\u0065\u0054\u0061\u0073\u006b`);
    //评论数量
    __publicField(this, `\u0078\u0068\u0073\u005f\u0076\u0069\u0065\u0077\u0043\u006f\u0075\u006e\u0074`);
    __publicField(this, `\u0078\u0068\u0073\u005f\u0043\u006f\u006d\u006d\u0065\u006e\u0074\u0043\u006f\u0075\u006e\u0074`);
    __publicField(this, `\u0078\u0068\u0073\u005f\u006c\u0069\u006b\u0065\u0043\u006f\u0075\u006e\u0074`);
    __publicField(this, `\u0078\u0068\u0073\u005f\u0066\u006f\u006c\u006c\u006f\u0077\u0043\u006f\u0075\u006e\u0074`);
    __publicField(this, `\u0078\u0068\u0073\u005f\u0063\u006f\u006c\u006c\u0065\u0063\u0074\u0043\u006f\u0075\u006e\u0074`);
    //评论数量
    __publicField(this, `\u0064\u0079\u005f\u0076\u0069\u0065\u0077\u0043\u006f\u0075\u006e\u0074`);
    __publicField(this, `\u0064\u0079\u005f\u0043\u006f\u006d\u006d\u0065\u006e\u0074\u0043\u006f\u0075\u006e\u0074`);
    __publicField(this, `\u0064\u0079\u005f\u006c\u0069\u006b\u0065\u0043\u006f\u0075\u006e\u0074`);
    __publicField(this, `\u0064\u0079\u005f\u0066\u006f\u006c\u006c\u006f\u0077\u0043\u006f\u0075\u006e\u0074`);
    __publicField(this, `\u0064\u0079\u005f\u0063\u006f\u006c\u006c\u0065\u0063\u0074\u0043\u006f\u0075\u006e\u0074`);
    __publicField(this, `\u0074\u0061\u0073\u006b\u0050\u006c\u0061\u0074\u0066\u006f\u0072\u006d`);
    __publicField(this, `\u0058\u0069\u0061\u006f\u0048\u006f\u006e\u0067\u0053\u0068\u0075\u005f\u0053\u0065\u0074\u0074\u0069\u006e\u0067`);
    __publicField(this, `\u006f\u0070\u0065\u0072\u0061\u0074\u0069\u006f\u006e\u0054\u0069\u006d\u0065`);
    __publicField(this, `\u0072\u0075\u006e\u004d\u0069\u006e\u0075\u0074\u0065\u0054\u0069\u006d\u0065`);
    __publicField(this, `\u0073\u0074\u0061\u0072\u0074\u004c\u006f\u0061\u0064`);
    __publicField(this, `\u006c\u006f\u0061\u0064\u0065\u006e\u0064`);
    // 上报数据
    __publicField(this, `\u0065\u0078\u0065\u0063\u0075\u0074\u0065\u004f\u0070\u0065\u0072\u0061\u0074\u0069\u006f\u006e\u0053\u0074\u0061\u0072\u0074\u0054\u0069\u006d\u0065`);
    __publicField(this, `\u0065\u0078\u0065\u0063\u0075\u0074\u0065\u004f\u0070\u0065\u0072\u0061\u0074\u0069\u006f\u006e\u0045\u006e\u0064\u0054\u0069\u006d\u0065`);
    __publicField(this, `\u0078\u0068\u0073\u005f\u006b\u0065\u0079\u0077\u006f\u0072\u0064\u0073\u005f\u006c\u0069\u0073\u0074`);
    __publicField(this, `\u0064\u006f\u0075\u0059\u0069\u006e\u005f\u006b\u0065\u0079\u0077\u006f\u0072\u0064\u0073\u005f\u006c\u0069\u0073\u0074`);
    __publicField(this, `\u0078\u0068\u0073\u005f\u006d\u0069\u006e\u0075\u0074\u0065`);
    __publicField(this, `\u0064\u0079\u005f\u006d\u0069\u006e\u0075\u0074\u0065`);
    __publicField(this, `\u0072\u0065\u0070\u006f\u0072\u0074\u0052\u0075\u006e\u0044\u0061\u0074\u0061\u0053\u0074\u0061\u0074\u0075\u0073`, async () => {
      var _a;
      console.log(`\u0072\u0065\u0070\u006f\u0072\u0074\u0052\u0075\u006e\u0044\u0061\u0074\u0061\u0053\u0074\u0061\u0074\u0075\u0073`);
      if (!this.conn) {
        return;
      }
      const runData = this.getRunData();
      console.log(`\u0072\u0075\u006e\u0044\u0061\u0074\u0061`, JSON.stringify(runData));
      this.conn.messageToStatusMQTT({
        "taskId": this.taskId,
        "data": runData,
        "userId": this.user_id,
        "terminalId": (_a = this.terminalData) == null ? void 0 : _a.terminalId
      });
    });
    __publicField(this, `\u0072\u0065\u0070\u006f\u0072\u0074\u0052\u0075\u006e\u0044\u0061\u0074\u0061`, async () => {
      var _a;
      const url = VITE_CONTENT_API$3 + `\u002f\u0061\u0070\u0069\u002f\u0063\u006f\u006e\u0074\u0065\u006e\u0074\u002f`;
      const headers = {
        "Content-Type": `\u0061\u0070\u0070\u006c\u0069\u0063\u0061\u0074\u0069\u006f\u006e\u002f\u006a\u0073\u006f\u006e`,
        ...this.addAuthorizationHeader()
        // Ensure this function works in the extension
      };
      try {
        console.log(`\u0072\u0065\u0070\u006f\u0072\u0074\u0052\u0075\u006e\u0044\u0061\u0074\u0061`);
        const runData = this.getRunData();
        console.log(`\u0072\u0075\u006e\u0044\u0061\u0074\u0061`, JSON.stringify(runData));
        const postData = {
          "taskId": this.taskId,
          "data": runData,
          "userId": this.user_id,
          "terminalId": (_a = this.terminalData) == null ? void 0 : _a.terminalId
        };
        const response = await fetch(url, {
          method: `\u0050\u004f\u0053\u0054`,
          headers,
          body: JSON.stringify(postData)
        });
        if (!response.ok) {
          console.log(`\u0075\u0072\u006c\u003a` + url + `\uff0c\u0068\u0065\u0061\u0064\u0065\u0072\u003a` + JSON.stringify(headers) + `\u002c\u0020\u0072\u0065\u0073\u0070\u006f\u006e\u0073\u0065\u0020\u0073\u0074\u0061\u0074\u0075\u0073\u003a` + response.status);
          return;
        }
        const result = await response.json();
        console.log(`\u0075\u0072\u006c\u003a` + url + `\uff0c\u0068\u0065\u0061\u0064\u0065\u0072\u003a` + JSON.stringify(headers) + `\u002c\u0070\u006f\u0073\u0074\u0044\u0061\u0074\u0061\uff1a` + JSON.stringify(postData) + `\u0020\u0072\u0065\u0073\u0070\u006f\u006e\u0073\u0065\u0020\u0073\u0074\u0061\u0074\u0075\u0073\u003a` + response.status + `\u002c\u0020\u0072\u0065\u0073\u0070\u006f\u006e\u0073\u0065\u0020\u0064\u0061\u0074\u0061\u003a` + JSON.stringify(result));
      } catch (error) {
        console.log(`\u0045\u0072\u0072\u006f\u0072\u0020\u0069\u006e\u0020\u0070\u0075\u0074\u004e\u0065\u0077\u0054\u0061\u0073\u006b\u003a`, error);
        sendLog(`\u0075\u0072\u006c\u003a` + url + `\uff0c\u0068\u0065\u0061\u0064\u0065\u0072\u003a` + JSON.stringify(headers) + `\u002c\u0020\u0065\u0072\u0072\u006f\u0072` + error);
      }
    });
    __publicField(this, `\u0063\u0061\u006c\u006c\u0042\u0061\u0063\u006b\u004c\u0069\u0073\u0074\u0065\u006e\u0065\u0072`, (changes, namespace) => {
      for (let [key, {
        oldValue,
        newValue
      }] of Object.entries(changes)) {
        console.log(`\u0063\u0075\u0073\u0074\u006f\u006d\u0069\u007a\u0065\u0054\u0061\u0073\u006b\u0020\u0053\u0074\u006f\u0072\u0061\u0067\u0065\u0020\u006b\u0065\u0079\u0020\u0022${key}\u0022\u0020\u0069\u006e\u0020\u006e\u0061\u006d\u0065\u0073\u0070\u0061\u0063\u0065\u0020\u0022${namespace}\u0022\u0020\u0063\u0068\u0061\u006e\u0067\u0065\u0064\u002e`, `\u004f\u006c\u0064\u0020\u0076\u0061\u006c\u0075\u0065\u0020\u0077\u0061\u0073\u0020\u0022${oldValue}\u0022\u002c\u0020\u006e\u0065\u0077\u0020\u0076\u0061\u006c\u0075\u0065\u0020\u0069\u0073\u0020\u0022${newValue}\u0022\u002e`);
        switch (key) {
          case `\u0072\u0075\u006e\u0054\u0061\u0073\u006b\u0053\u0074\u006f\u0070\u0070\u0065\u0064`:
            if (newValue == `\u0065\u006e\u0064`) {
              this.reportStop().then(() => {});
            }
            break;
          case `\u0074\u0061\u0073\u006b\u0050\u006c\u0061\u0074\u0066\u006f\u0072\u006d`:
            this.taskPlatform = newValue;
            break;
          case `\u0058\u0069\u0061\u006f\u0048\u006f\u006e\u0067\u0053\u0068\u0075\u005f\u0053\u0065\u0074\u0074\u0069\u006e\u0067`:
            this.XiaoHongShu_Setting = newValue ? JSON.parse(newValue) : {};
            break;
          case `\u006f\u0072\u0067\u0049\u0064`:
            this.orgId = newValue;
            break;
          case `\u0075\u0073\u0065\u0072\u0049\u0064`:
            this.user_id = newValue;
            break;
          case `\u0063\u006c\u0069\u0065\u006e\u0074\u0056\u0069\u0073\u0069\u0074\u006f\u0072\u0049\u0064`:
            this.clientVisitorId = newValue;
            break;
          case `\u0061\u0063\u0063\u0065\u0073\u0073\u0054\u006f\u006b\u0065\u006e`:
            this.accessToken = newValue;
            break;
          case `\u006f\u0070\u0065\u0072\u0061\u0074\u0069\u006f\u006e\u0054\u0069\u006d\u0065`:
            this.operationTime = newValue;
            break;
          case `\u0072\u0075\u006e\u004d\u0069\u006e\u0075\u0074\u0065\u0054\u0069\u006d\u0065`:
            this.runMinuteTime = newValue;
            this.reportReply();
            break;
          case `\u0078\u0068\u0073\u005f\u006c\u0069\u006b\u0065\u0043\u006f\u0075\u006e\u0074`:
            this.xhs_likeCount = newValue;
            this.reportRunDataStatus().then();
            break;
          case `\u0078\u0068\u0073\u005f\u0066\u006f\u006c\u006c\u006f\u0077\u0043\u006f\u0075\u006e\u0074`:
            this.xhs_followCount = newValue;
            this.reportRunDataStatus().then();
            break;
          case `\u0078\u0068\u0073\u005f\u0043\u006f\u006d\u006d\u0065\u006e\u0074\u0043\u006f\u0075\u006e\u0074`:
            this.xhs_CommentCount = newValue;
            this.reportRunDataStatus().then();
            break;
          case `\u0078\u0068\u0073\u005f\u0063\u006f\u006c\u006c\u0065\u0063\u0074\u0043\u006f\u0075\u006e\u0074`:
            this.xhs_collectCount = newValue;
            this.reportRunDataStatus().then();
            break;
          case `\u0078\u0068\u0073\u005f\u0076\u0069\u0065\u0077\u0043\u006f\u0075\u006e\u0074`:
            this.xhs_viewCount = newValue;
            this.reportRunDataStatus().then();
            break;
          case `\u0064\u0079\u005f\u006c\u0069\u006b\u0065\u0043\u006f\u0075\u006e\u0074`:
            this.dy_likeCount = newValue;
            this.reportRunDataStatus().then();
            break;
          case `\u0064\u0079\u005f\u0066\u006f\u006c\u006c\u006f\u0077\u0043\u006f\u0075\u006e\u0074`:
            this.dy_followCount = newValue;
            this.reportRunDataStatus().then();
            break;
          case `\u0064\u0079\u005f\u0043\u006f\u006d\u006d\u0065\u006e\u0074\u0043\u006f\u0075\u006e\u0074`:
            this.dy_CommentCount = newValue;
            this.reportRunDataStatus().then();
            break;
          case `\u0064\u0079\u005f\u0063\u006f\u006c\u006c\u0065\u0063\u0074\u0043\u006f\u0075\u006e\u0074`:
            this.dy_collectCount = newValue;
            this.reportRunDataStatus().then();
            break;
          case `\u0064\u0079\u005f\u0076\u0069\u0065\u0077\u0043\u006f\u0075\u006e\u0074`:
            this.dy_viewCount = newValue;
            this.reportRunDataStatus().then();
            break;
          case `\u0065\u0078\u0065\u0063\u0075\u0074\u0065\u004f\u0070\u0065\u0072\u0061\u0074\u0069\u006f\u006e\u0053\u0074\u0061\u0072\u0074\u0054\u0069\u006d\u0065`:
            this.executeOperationStartTime = newValue;
            break;
          case `\u0065\u0078\u0065\u0063\u0075\u0074\u0065\u004f\u0070\u0065\u0072\u0061\u0074\u0069\u006f\u006e\u0045\u006e\u0064\u0054\u0069\u006d\u0065`:
            this.executeOperationEndTime = newValue;
            break;
          case `\u0078\u0068\u0073\u005f\u006b\u0065\u0079\u0077\u006f\u0072\u0064\u0073\u005f\u006c\u0069\u0073\u0074`:
            this.xhs_keywords_list = newValue ? JSON.parse(newValue) : [];
            break;
          case `\u0064\u006f\u0075\u0059\u0069\u006e\u005f\u006b\u0065\u0079\u0077\u006f\u0072\u0064\u0073\u005f\u006c\u0069\u0073\u0074`:
            this.douYin_keywords_list = newValue ? JSON.parse(newValue) : [];
            break;
          case `\u0078\u0068\u0073\u005f\u006d\u0069\u006e\u0075\u0074\u0065`:
            this.xhs_minute = newValue ? JSON.parse(newValue) : [];
            break;
          case `\u0064\u0079\u005f\u006d\u0069\u006e\u0075\u0074\u0065`:
            this.dy_minute = newValue ? JSON.parse(newValue) : [];
            break;
        }
      }
    });
    this.startLoad = false;
    this.loadend = false;
    this.xhs_viewCount = 0;
    this.xhs_CommentCount = 0;
    this.xhs_likeCount = 0;
    this.xhs_followCount = 0;
    this.xhs_collectCount = 0;
    this.dy_viewCount = 0;
    this.dy_CommentCount = 0;
    this.dy_likeCount = 0;
    this.dy_followCount = 0;
    this.dy_collectCount = 0;
    this.operationTime = 0;
    this.runMinuteTime = 0;
    this.taskPlatform = ``;
    this.XiaoHongShu_Setting = ``;
    this.executeTask = executeTask2;
    this.executeOperationStartTime = 0;
    this.executeOperationEndTime = 0;
    this.xhs_keywords_list = [];
    this.douYin_keywords_list = [];
    this.xhs_minute = [];
    this.dy_minute = [];
    this.loadFromStorage();
  }
  /**
   * 检查配置是否正确
   */
  checkConfig() {
    return true;
  }
  startTask() {
    return new Promise(async resolve => {
      const validationError = this.validateParameters();
      if (!this.conn) {
        resolve();
        return;
      }
      if (validationError) {
        console.error(validationError.message);
        this.conn.messageToReplyMQTT({
          "taskId": this.taskId,
          "executeId": this.executeId,
          "status": `\u0066\u0061\u0069\u006c\u0065\u0064`,
          "meta": {},
          "message": validationError.message
        });
        resolve();
        return;
      }
      console.log(`\u0044\u006f\u0020\u0061\u0020\u0063\u0075\u0073\u0074\u006f\u006d\u0069\u007a\u0065\u0020\u0074\u0061\u0073\u006b\u0021`);
      await this.my_execute(this.data);
      this.conn.messageToReplyMQTT({
        "taskId": this.taskId,
        "executeId": this.executeId,
        "status": `\u0072\u0075\u006e\u006e\u0069\u006e\u0067`,
        "meta": this.getStatus(),
        "message": ``
      });
      resolve();
    });
  }
  validateParameters() {
    if (!this.data) {
      return {
        message: `\u53c2\u6570\u672a\u4f20\u9012\u6216\u683c\u5f0f\u4e0d\u6b63\u786e`
      };
    }
    return null;
  }
  async my_execute(config) {
    var _a;
    chrome.storage.local.set({
      "runTaskStopped": ``
    });
    chrome.storage.local.set({
      "mqttStart": `\u006f\u006b`
    });
    chrome.storage.local.set({
      "xhs_viewCount": 0
    });
    chrome.storage.local.set({
      "xhs_CommentCount": 0
    });
    chrome.storage.local.set({
      "xhs_likeCount": 0
    });
    chrome.storage.local.set({
      "xhs_followCount": 0
    });
    chrome.storage.local.set({
      "xhs_collectCount": 0
    });
    chrome.storage.local.set({
      "dy_viewCount": 0
    });
    chrome.storage.local.set({
      "dy_CommentCount": 0
    });
    chrome.storage.local.set({
      "dy_likeCount": 0
    });
    chrome.storage.local.set({
      "dy_followCount": 0
    });
    chrome.storage.local.set({
      "dy_collectCount": 0
    });
    chrome.storage.local.set({
      "KuaiShou_search_runNumber": 1
    });
    chrome.storage.local.set({
      "activatePage": runPages[0]
    });
    chrome.storage.local.set({
      "operationTime": 0
    });
    chrome.storage.local.set({
      "xiaoHongShuAccountErrorTip": ``
    });
    chrome.storage.local.set({
      "xhs_keywords_list": JSON.stringify([])
    });
    chrome.storage.local.set({
      "douYin_keywords_list": JSON.stringify([])
    });
    chrome.storage.local.set({
      "xhs_minute": JSON.stringify([])
    });
    chrome.storage.local.set({
      "dy_minute": JSON.stringify([])
    });
    chrome.storage.local.set({
      "optionsPageName": ``
    });
    chrome.storage.local.set({
      "executeOperationStartTime": (/* @__PURE__ */new Date()).getTime()
    });
    chrome.storage.local.set({
      "XiaoHongShu_Setting": JSON.stringify(config)
    });
    if (!this.XiaoHongShu_Setting) {
      this.XiaoHongShu_Setting = config;
    }
    if (config.workDouYinPlatform == `\u6296\u97f3`) {
      if (!this.taskPlatform) {
        this.taskPlatform = config.workDouYinPlatform;
      }
      const saveTaskDataResult = await saveTaskData({
        task_options: {
          taskId: this.taskId,
          executeId: this.executeId,
          agentId: VITE_AGENT_ID$1,
          terminalId: (_a = store$4.terminalData) == null ? void 0 : _a.terminalId
        }
      });
      console.log(`\u0073\u0061\u0076\u0065\u0054\u0061\u0073\u006b\u0044\u0061\u0074\u0061\u0052\u0065\u0073\u0075\u006c\u0074`, saveTaskDataResult);
      if (saveTaskDataResult && saveTaskDataResult.code == 0) {
        store$4.setQuestTaskId(saveTaskDataResult.data.id);
      }
      this.executeTask({
        action: `\u0065\u0078\u0065\u0063\u0075\u0074\u0065\u0054\u0061\u0073\u006b`,
        url: `\u0068\u0074\u0074\u0070\u0073\u003a\u002f\u002f\u0077\u0077\u0077\u002e\u0064\u006f\u0075\u0079\u0069\u006e\u002e\u0063\u006f\u006d`,
        taskName: config.workType,
        taskPlatform: config.workDouYinPlatform,
        taskId: this.taskId
      }, {}, res => {
        if (res && res.tabId) {
          this.tabId = res.tabId;
        }
        if (res && res.windowId) {
          this.windowId = res.windowId;
        }
        console.log(`\u0065\u0078\u0065\u0063\u0075\u0074\u0065\u0054\u0061\u0073\u006b\u0020\u0072\u0065\u0073`, res);
      });
    }
    if (config.workXiaoHongShuPlatform == `\u5c0f\u7ea2\u4e66`) {
      this.executeTask({
        action: `\u0065\u0078\u0065\u0063\u0075\u0074\u0065\u0054\u0061\u0073\u006b`,
        url: `\u0068\u0074\u0074\u0070\u0073\u003a\u002f\u002f\u0077\u0077\u0077\u002e\u0078\u0069\u0061\u006f\u0068\u006f\u006e\u0067\u0073\u0068\u0075\u002e\u0063\u006f\u006d\u002f\u0065\u0078\u0070\u006c\u006f\u0072\u0065`,
        taskName: config.workType,
        taskPlatform: config.workXiaoHongShuPlatform,
        taskId: this.taskId
      }, {}, res => {
        if (res && res.tabId) {
          this.tabId = res.tabId;
        }
        if (res && res.windowId) {
          this.windowId = res.windowId;
        }
        console.log(`\u0065\u0078\u0065\u0063\u0075\u0074\u0065\u0054\u0061\u0073\u006b\u0020\u0072\u0065\u0073`, res);
      });
      if (!this.taskPlatform) {
        this.taskPlatform = config.workXiaoHongShuPlatform;
      }
    }
    if (config.workXiaoHongShuPlatform == `\u5feb\u624b`) {
      this.executeTask({
        action: `\u0065\u0078\u0065\u0063\u0075\u0074\u0065\u0054\u0061\u0073\u006b`,
        url: config.workType === `\u5173\u952e\u8bcd` ? `\u0068\u0074\u0074\u0070\u0073\u003a\u002f\u002f\u0077\u0077\u0077\u002e\u006b\u0075\u0061\u0069\u0073\u0068\u006f\u0075\u002e\u0063\u006f\u006d\u002f\u0073\u0065\u0061\u0072\u0063\u0068\u002f\u0076\u0069\u0064\u0065\u006f\u003f\u0073\u0065\u0061\u0072\u0063\u0068\u004b\u0065\u0079\u003d${config.searchWord}` : `\u0068\u0074\u0074\u0070\u0073\u003a\u002f\u002f\u0077\u0077\u0077\u002e\u006b\u0075\u0061\u0069\u0073\u0068\u006f\u0075\u002e\u0063\u006f\u006d\u002f\u0062\u0072\u0069\u006c\u006c\u0069\u0061\u006e\u0074`,
        taskName: config.workType,
        taskPlatform: config.workXiaoHongShuPlatform,
        taskId: this.taskId
      }, {}, res => {
        if (res && res.tabId) {
          this.tabId = res.tabId;
        }
        if (res && res.windowId) {
          this.windowId = res.windowId;
        }
        console.log(`\u0065\u0078\u0065\u0063\u0075\u0074\u0065\u0054\u0061\u0073\u006b\u0020\u0072\u0065\u0073`, res);
      });
      if (!this.taskPlatform) {
        this.taskPlatform = config.workXiaoHongShuPlatform;
      }
    }
  }
  stopTask() {
    return new Promise(resolve => {
      sendLog(`\u0064\u006f\u0075\u0059\u0069\u006e\u0059\u0061\u006e\u0067\u0048\u0061\u006f\u005a\u0068\u0075\u0053\u0068\u006f\u0075\u0054\u0061\u0073\u006b\u0020\u0062\u0061\u0063\u006b\u0067\u0072\u006f\u0075\u006e\u0064\u0020\u0061\u0063\u0074\u0069\u0076\u0061\u0074\u0065\u0050\u0061\u0067\u0065\u0020\uff1a`, indexPage);
      chrome.storage.local.set({
        "activatePage": indexPage
      });
      resolve();
    });
  }
  abortTask() {
    return new Promise(resolve => {
      this.reportStop().then(() => {});
      resolve();
    });
  }
  report() {
    return new Promise(resolve => {
      console.log(`\u0072\u0065\u0070\u006f\u0072\u0074\u0020\u0050\u0072\u006f\u006d\u0069\u0073\u0065`);
      try {
        let formatTimestamp = function (timestamp) {
            const date = new Date(timestamp);
            const month = String(date.getMonth() + 1).padStart(2, `\u0030`);
            const day = String(date.getDate()).padStart(2, `\u0030`);
            const hours = String(date.getHours()).padStart(2, `\u0030`);
            const minutes = String(date.getMinutes()).padStart(2, `\u0030`);
            return `${month}\u002d${day}\u0020${hours}\u003a${minutes}`;
          },
          calculateTimeDifference = function (startTimestamp, endTimestamp) {
            const differenceInMs = Math.abs(endTimestamp - startTimestamp);
            const totalMinutes = Math.floor(differenceInMs / (1e3 * 60));
            return `${totalMinutes}`;
          };
        if (!this.conn) {
          resolve();
          return;
        }
        const executeOperationStartTime = formatTimestamp(this.executeOperationStartTime);
        const executeOperationEndTime = formatTimestamp(this.executeOperationEndTime);
        const run_time = calculateTimeDifference(this.executeOperationStartTime, this.executeOperationEndTime);
        let xhs_keywords_list_str = ``;
        if (this.xhs_keywords_list.length > 0) {
          xhs_keywords_list_str = this.xhs_keywords_list.join(`\uff0c`);
        }
        let douYin_keywords_list_str = ``;
        if (this.douYin_keywords_list.length > 0) {
          douYin_keywords_list_str = this.douYin_keywords_list.join(`\uff0c`);
        }
        let XiaoHongShu_Setting = this.XiaoHongShu_Setting;
        let workRunPlatform = ``;
        if (XiaoHongShu_Setting.workDouYinPlatform) {
          if (!workRunPlatform) {
            workRunPlatform = XiaoHongShu_Setting.workDouYinPlatform;
          } else {
            workRunPlatform += `\u002b` + XiaoHongShu_Setting.workDouYinPlatform;
          }
        }
        if (XiaoHongShu_Setting.workXiaoHongShuPlatform) {
          if (!workRunPlatform) {
            workRunPlatform = XiaoHongShu_Setting.workXiaoHongShuPlatform;
          } else {
            workRunPlatform += `\u002b` + XiaoHongShu_Setting.workXiaoHongShuPlatform;
          }
        }
        const uniqueMinutes = [... /* @__PURE__ */new Set([...this.xhs_minute.map(item => item.minute), ...this.dy_minute.map(item => item.minute)])].sort((a, b) => a - b);
        const xhsNums = uniqueMinutes.map(minute => {
          var _a;
          return ((_a = this.xhs_minute.find(item => item.minute === minute)) == null ? void 0 : _a.num) || 0;
        });
        const xhsPieNumber = [{
          value: store$4.xhs_likeCount,
          name: `\u70b9\u8d5e`
        }, {
          value: store$4.xhs_CommentCount,
          name: `\u8bc4\u8bba`
        }, {
          value: store$4.xhs_followCount,
          name: `\u5173\u6ce8`
        }, {
          value: store$4.xhs_collectCount,
          name: `\u6536\u85cf`
        }];
        const dyPieNumber = [{
          value: store$4.dy_likeCount,
          name: `\u70b9\u8d5e`
        }, {
          value: store$4.dy_CommentCount,
          name: `\u8bc4\u8bba`
        }, {
          value: store$4.dy_followCount,
          name: `\u5173\u6ce8`
        }, {
          value: store$4.dy_collectCount,
          name: `\u6536\u85cf`
        }];
        const allPieNumber = [{
          value: store$4.xhs_likeCount + store$4.dy_likeCount,
          name: `\u70b9\u8d5e`
        }, {
          value: store$4.xhs_CommentCount + store$4.dy_CommentCount,
          name: `\u8bc4\u8bba`
        }, {
          value: store$4.xhs_followCount + store$4.dy_followCount,
          name: `\u5173\u6ce8`
        }, {
          value: store$4.xhs_collectCount + store$4.dy_collectCount,
          name: `\u6536\u85cf`
        }];
        const postData = {
          executeOperationStartTime,
          executeOperationEndTime,
          run_time,
          xhs_keywords_list_str,
          douYin_keywords_list_str,
          workRunPlatform,
          uniqueMinutes,
          xhsNums,
          xhsPieNumber,
          dyPieNumber,
          allPieNumber
        };
        console.log(`\u006d\u0065\u0073\u0073\u0061\u0067\u0065\u0054\u006f\u0052\u0065\u0070\u006f\u0072\u0074\u004d\u0051\u0054\u0054\u0020\u0070\u006f\u0073\u0074\u0044\u0061\u0074\u0061`, JSON.stringify(postData));
        sendLog(`\u0054\u0061\u0073\u006b\u0020\u0073\u0074\u006f\u0070\u0070\u0065\u0064`);
        this.conn.messageToReportMQTT({
          "taskId": this.taskId,
          "executeId": this.executeId,
          "status": `\u0072\u0065\u0070\u006f\u0072\u0074`,
          "meta": postData,
          "message": `\u62a5\u544a`
        });
        resolve();
      } catch (e) {
        console.log(`\u0072\u0065\u0070\u006f\u0072\u0074\u0020\u0065`, e);
      }
    });
  }
  /**
   * 获取心跳上报数据
   */
  getHeartReportData() {
    return {};
  }
  /**
   * 等待store 通知 callBackListener
   */
  async reportStop() {
    this.running = false;
    this.paused = false;
    this.callExecuteNotification();
    if (!this.conn) {
      return;
    }
    sendLog(`\u0054\u0061\u0073\u006b\u0020\u0073\u0074\u006f\u0070\u0070\u0065\u0064`);
    this.conn.messageToReplyMQTT({
      "taskId": this.taskId,
      "executeId": this.executeId,
      "status": `\u0063\u006f\u006d\u0070\u006c\u0065\u0074\u0065\u0064`,
      "meta": this.getStatus(),
      "message": `\u5df2\u505c\u6b62`
    });
    storageUtil.removeListener(this.callBackListener);
    super.baseReportStop();
  }
  getStatus() {
    return {
      id: this.taskId,
      running: this.running,
      paused: this.paused,
      started: this.started,
      process: this.operationTime > 0 ? (this.runMinuteTime / this.operationTime * 100).toFixed(2) : 0,
      total_num: this.operationTime,
      executed_num: this.runMinuteTime
    };
  }
  getRunData() {
    if (this.taskPlatform === `\u6296\u97f3`) {
      return {
        viewCount: this.dy_viewCount,
        commentCount: this.dy_CommentCount,
        likeCount: this.dy_likeCount,
        followCount: this.dy_followCount,
        collectCount: this.dy_collectCount,
        operationTime: this.operationTime,
        runMinuteTime: this.runMinuteTime
      };
    } else if (this.taskPlatform === `\u5c0f\u7ea2\u4e66`) {
      return {
        likeCount: this.xhs_likeCount,
        followCount: this.xhs_followCount,
        commentCount: this.xhs_CommentCount,
        collectCount: this.xhs_collectCount,
        viewCount: this.xhs_viewCount,
        operationTime: this.operationTime,
        runMinuteTime: this.runMinuteTime
      };
    }
  }
  reportReply() {
    console.log(`\u0072\u0065\u0070\u006f\u0072\u0074\u0052\u0065\u0070\u006c\u0079`);
    if (!this.conn) {
      return;
    }
    this.conn.messageToReplyMQTT({
      "taskId": this.taskId,
      "executeId": this.executeId,
      "status": `\u0072\u0075\u006e\u006e\u0069\u006e\u0067`,
      "meta": this.getStatus(),
      "message": ``
    });
  }
  loadFromStorage() {
    if (this.startLoad) {
      console.log(`\u0073\u0074\u0061\u0072\u0074\u004c\u006f\u0061\u0064`, this.startLoad);
      return;
    }
    this.startLoad = true;
    chrome.storage.local.get([`\u0074\u0061\u0073\u006b\u0050\u006c\u0061\u0074\u0066\u006f\u0072\u006d`, `\u0058\u0069\u0061\u006f\u0048\u006f\u006e\u0067\u0053\u0068\u0075\u005f\u0053\u0065\u0074\u0074\u0069\u006e\u0067`, `\u0078\u0068\u0073\u005f\u0076\u0069\u0065\u0077\u0043\u006f\u0075\u006e\u0074`, `\u0078\u0068\u0073\u005f\u0043\u006f\u006d\u006d\u0065\u006e\u0074\u0043\u006f\u0075\u006e\u0074`, `\u0078\u0068\u0073\u005f\u006c\u0069\u006b\u0065\u0043\u006f\u0075\u006e\u0074`, `\u0078\u0068\u0073\u005f\u0066\u006f\u006c\u006c\u006f\u0077\u0043\u006f\u0075\u006e\u0074`, `\u0078\u0068\u0073\u005f\u0063\u006f\u006c\u006c\u0065\u0063\u0074\u0043\u006f\u0075\u006e\u0074`, `\u0064\u0079\u005f\u0076\u0069\u0065\u0077\u0043\u006f\u0075\u006e\u0074`, `\u0064\u0079\u005f\u0043\u006f\u006d\u006d\u0065\u006e\u0074\u0043\u006f\u0075\u006e\u0074`, `\u0064\u0079\u005f\u006c\u0069\u006b\u0065\u0043\u006f\u0075\u006e\u0074`, `\u0064\u0079\u005f\u0066\u006f\u006c\u006c\u006f\u0077\u0043\u006f\u0075\u006e\u0074`, `\u0064\u0079\u005f\u0063\u006f\u006c\u006c\u0065\u0063\u0074\u0043\u006f\u0075\u006e\u0074`, `\u006f\u0070\u0065\u0072\u0061\u0074\u0069\u006f\u006e\u0054\u0069\u006d\u0065`, `\u0075\u0073\u0065\u0072\u0049\u0064`, `\u006f\u0072\u0067\u0049\u0064`, `\u0063\u006c\u0069\u0065\u006e\u0074\u0056\u0069\u0073\u0069\u0074\u006f\u0072\u0049\u0064`, `\u0061\u0063\u0063\u0065\u0073\u0073\u0054\u006f\u006b\u0065\u006e`], result => {
      console.log(`\u0072\u0065\u0073\u0075\u006c\u0074\u0020\u0061\u0063\u0074\u0069\u0076\u0061\u0074\u0065\u0050\u0061\u0067\u0065`, result);
      if (!result) {
        return;
      }
      if (result.userId !== void 0) {
        this.user_id = result.userId;
      }
      if (result.orgId !== void 0) {
        this.orgId = result.orgId;
      }
      if (result.clientVisitorId !== void 0) {
        this.clientVisitorId = result.clientVisitorId;
      }
      if (result.accessToken !== void 0) {
        this.accessToken = result.accessToken;
      }
      if (result.taskPlatform !== void 0) {
        this.taskPlatform = result.taskPlatform;
      }
      if (result.XiaoHongShu_Setting !== void 0) {
        this.XiaoHongShu_Setting = result.XiaoHongShu_Setting ? JSON.parse(result.XiaoHongShu_Setting) : {};
      }
      if (result.xhs_viewCount !== void 0) {
        this.xhs_viewCount = result.xhs_viewCount;
      }
      if (result.xhs_CommentCount !== void 0) {
        this.xhs_CommentCount = result.xhs_CommentCount;
      }
      if (result.xhs_likeCount !== void 0) {
        this.xhs_likeCount = result.xhs_likeCount;
      }
      if (result.xhs_followCount !== void 0) {
        this.xhs_followCount = result.xhs_followCount;
      }
      if (result.xhs_collectCount !== void 0) {
        this.xhs_collectCount = result.xhs_collectCount;
      }
      if (result.dy_viewCount !== void 0) {
        this.dy_viewCount = result.dy_viewCount;
      }
      if (result.dy_CommentCount !== void 0) {
        this.dy_CommentCount = result.dy_CommentCount;
      }
      if (result.dy_likeCount !== void 0) {
        this.dy_likeCount = result.dy_likeCount;
      }
      if (result.dy_followCount !== void 0) {
        this.dy_followCount = result.dy_followCount;
      }
      if (result.dy_collectCount !== void 0) {
        this.dy_collectCount = result.dy_collectCount;
      }
      if (result.operationTime !== void 0) {
        this.operationTime = result.operationTime;
      }
      this.startLoad = true;
      this.loadend = true;
    });
    storageUtil.addHandlers(this.callBackListener);
  }
}
const store$3 = UseCounterStore.getInstance();
const VITE_CONTENT_API$2 = `\u0068\u0074\u0074\u0070\u0073\u003a\u002f\u002f\u0061\u0067\u0065\u006e\u0074\u002d\u006e\u0065\u0074\u002e\u0070\u0061\u0069\u0074\u006f\u006e\u0067\u0061\u0069\u002e\u006e\u0065\u0074\u002f\u0063\u006f\u006e\u0074\u0065\u006e\u0074`;
class ShipinhaoKeZiCustomizeTask extends BaseTask {
  constructor(taskId, executeId, data, executeTask2) {
    super(taskId, executeId, data);
    __publicField(this, `\u0065\u0078\u0065\u0063\u0075\u0074\u0065\u0054\u0061\u0073\u006b`);
    //评论数量
    __publicField(this, `\u0078\u0068\u0073\u005f\u0076\u0069\u0065\u0077\u0043\u006f\u0075\u006e\u0074`);
    __publicField(this, `\u0078\u0068\u0073\u005f\u0043\u006f\u006d\u006d\u0065\u006e\u0074\u0043\u006f\u0075\u006e\u0074`);
    __publicField(this, `\u0078\u0068\u0073\u005f\u006c\u0069\u006b\u0065\u0043\u006f\u0075\u006e\u0074`);
    __publicField(this, `\u0078\u0068\u0073\u005f\u0066\u006f\u006c\u006c\u006f\u0077\u0043\u006f\u0075\u006e\u0074`);
    __publicField(this, `\u0078\u0068\u0073\u005f\u0063\u006f\u006c\u006c\u0065\u0063\u0074\u0043\u006f\u0075\u006e\u0074`);
    //评论数量
    __publicField(this, `\u0064\u0079\u005f\u0076\u0069\u0065\u0077\u0043\u006f\u0075\u006e\u0074`);
    __publicField(this, `\u0064\u0079\u005f\u0043\u006f\u006d\u006d\u0065\u006e\u0074\u0043\u006f\u0075\u006e\u0074`);
    __publicField(this, `\u0064\u0079\u005f\u006c\u0069\u006b\u0065\u0043\u006f\u0075\u006e\u0074`);
    __publicField(this, `\u0064\u0079\u005f\u0066\u006f\u006c\u006c\u006f\u0077\u0043\u006f\u0075\u006e\u0074`);
    __publicField(this, `\u0064\u0079\u005f\u0063\u006f\u006c\u006c\u0065\u0063\u0074\u0043\u006f\u0075\u006e\u0074`);
    __publicField(this, `\u0074\u0061\u0073\u006b\u0050\u006c\u0061\u0074\u0066\u006f\u0072\u006d`);
    __publicField(this, `\u0058\u0069\u0061\u006f\u0048\u006f\u006e\u0067\u0053\u0068\u0075\u005f\u0053\u0065\u0074\u0074\u0069\u006e\u0067`);
    __publicField(this, `\u006f\u0070\u0065\u0072\u0061\u0074\u0069\u006f\u006e\u0054\u0069\u006d\u0065`);
    __publicField(this, `\u0072\u0075\u006e\u004d\u0069\u006e\u0075\u0074\u0065\u0054\u0069\u006d\u0065`);
    __publicField(this, `\u0073\u0074\u0061\u0072\u0074\u004c\u006f\u0061\u0064`);
    __publicField(this, `\u006c\u006f\u0061\u0064\u0065\u006e\u0064`);
    // 上报数据
    __publicField(this, `\u0065\u0078\u0065\u0063\u0075\u0074\u0065\u004f\u0070\u0065\u0072\u0061\u0074\u0069\u006f\u006e\u0053\u0074\u0061\u0072\u0074\u0054\u0069\u006d\u0065`);
    __publicField(this, `\u0065\u0078\u0065\u0063\u0075\u0074\u0065\u004f\u0070\u0065\u0072\u0061\u0074\u0069\u006f\u006e\u0045\u006e\u0064\u0054\u0069\u006d\u0065`);
    __publicField(this, `\u0078\u0068\u0073\u005f\u006b\u0065\u0079\u0077\u006f\u0072\u0064\u0073\u005f\u006c\u0069\u0073\u0074`);
    __publicField(this, `\u0064\u006f\u0075\u0059\u0069\u006e\u005f\u006b\u0065\u0079\u0077\u006f\u0072\u0064\u0073\u005f\u006c\u0069\u0073\u0074`);
    __publicField(this, `\u0078\u0068\u0073\u005f\u006d\u0069\u006e\u0075\u0074\u0065`);
    __publicField(this, `\u0064\u0079\u005f\u006d\u0069\u006e\u0075\u0074\u0065`);
    __publicField(this, `\u0063\u006f\u006e\u0074\u0065\u006e\u0074\u0054\u0065\u0078\u0074`);
    __publicField(this, `\u0072\u0065\u0070\u006c\u0079\u0043\u006f\u006d\u006d\u0065\u006e\u0074`);
    __publicField(this, `\u0072\u0065\u0070\u006f\u0072\u0074\u0052\u0075\u006e\u0044\u0061\u0074\u0061\u0053\u0074\u0061\u0074\u0075\u0073`, async () => {
      var _a;
      console.log(`\u0072\u0065\u0070\u006f\u0072\u0074\u0052\u0075\u006e\u0044\u0061\u0074\u0061\u0053\u0074\u0061\u0074\u0075\u0073`);
      if (!this.conn) {
        return;
      }
      const runData = this.getRunData();
      console.log(`\u0072\u0075\u006e\u0044\u0061\u0074\u0061`, JSON.stringify(runData));
      this.conn.messageToStatusMQTT({
        "taskId": this.taskId,
        "data": runData,
        "userId": this.user_id,
        "terminalId": (_a = this.terminalData) == null ? void 0 : _a.terminalId
      });
    });
    __publicField(this, `\u0072\u0065\u0070\u006f\u0072\u0074\u0052\u0075\u006e\u0044\u0061\u0074\u0061`, async () => {
      var _a;
      const url = VITE_CONTENT_API$2 + `\u002f\u0061\u0070\u0069\u002f\u0063\u006f\u006e\u0074\u0065\u006e\u0074\u002f`;
      const headers = {
        "Content-Type": `\u0061\u0070\u0070\u006c\u0069\u0063\u0061\u0074\u0069\u006f\u006e\u002f\u006a\u0073\u006f\u006e`,
        ...this.addAuthorizationHeader()
        // Ensure this function works in the extension
      };
      try {
        console.log(`\u0072\u0065\u0070\u006f\u0072\u0074\u0052\u0075\u006e\u0044\u0061\u0074\u0061`);
        const runData = this.getRunData();
        console.log(`\u0072\u0075\u006e\u0044\u0061\u0074\u0061`, JSON.stringify(runData));
        const postData = {
          "taskId": this.taskId,
          "data": runData,
          "userId": this.user_id,
          "terminalId": (_a = this.terminalData) == null ? void 0 : _a.terminalId
        };
        const response = await fetch(url, {
          method: `\u0050\u004f\u0053\u0054`,
          headers,
          body: JSON.stringify(postData)
        });
        if (!response.ok) {
          console.log(`\u0075\u0072\u006c\u003a` + url + `\uff0c\u0068\u0065\u0061\u0064\u0065\u0072\u003a` + JSON.stringify(headers) + `\u002c\u0020\u0072\u0065\u0073\u0070\u006f\u006e\u0073\u0065\u0020\u0073\u0074\u0061\u0074\u0075\u0073\u003a` + response.status);
          return;
        }
        const result = await response.json();
        console.log(`\u0075\u0072\u006c\u003a` + url + `\uff0c\u0068\u0065\u0061\u0064\u0065\u0072\u003a` + JSON.stringify(headers) + `\u002c\u0070\u006f\u0073\u0074\u0044\u0061\u0074\u0061\uff1a` + JSON.stringify(postData) + `\u0020\u0072\u0065\u0073\u0070\u006f\u006e\u0073\u0065\u0020\u0073\u0074\u0061\u0074\u0075\u0073\u003a` + response.status + `\u002c\u0020\u0072\u0065\u0073\u0070\u006f\u006e\u0073\u0065\u0020\u0064\u0061\u0074\u0061\u003a` + JSON.stringify(result));
      } catch (error) {
        console.log(`\u0045\u0072\u0072\u006f\u0072\u0020\u0069\u006e\u0020\u0070\u0075\u0074\u004e\u0065\u0077\u0054\u0061\u0073\u006b\u003a`, error);
        sendLog(`\u0075\u0072\u006c\u003a` + url + `\uff0c\u0068\u0065\u0061\u0064\u0065\u0072\u003a` + JSON.stringify(headers) + `\u002c\u0020\u0065\u0072\u0072\u006f\u0072` + error);
      }
    });
    __publicField(this, `\u0063\u0061\u006c\u006c\u0042\u0061\u0063\u006b\u004c\u0069\u0073\u0074\u0065\u006e\u0065\u0072`, (changes, namespace) => {
      for (let [key, {
        oldValue,
        newValue
      }] of Object.entries(changes)) {
        console.log(`\u0063\u0075\u0073\u0074\u006f\u006d\u0069\u007a\u0065\u0054\u0061\u0073\u006b\u0020\u0053\u0074\u006f\u0072\u0061\u0067\u0065\u0020\u006b\u0065\u0079\u0020\u0022${key}\u0022\u0020\u0069\u006e\u0020\u006e\u0061\u006d\u0065\u0073\u0070\u0061\u0063\u0065\u0020\u0022${namespace}\u0022\u0020\u0063\u0068\u0061\u006e\u0067\u0065\u0064\u002e`, `\u004f\u006c\u0064\u0020\u0076\u0061\u006c\u0075\u0065\u0020\u0077\u0061\u0073\u0020\u0022${oldValue}\u0022\u002c\u0020\u006e\u0065\u0077\u0020\u0076\u0061\u006c\u0075\u0065\u0020\u0069\u0073\u0020\u0022${newValue}\u0022\u002e`);
        switch (key) {
          case `\u0072\u0075\u006e\u0054\u0061\u0073\u006b\u0053\u0074\u006f\u0070\u0070\u0065\u0064`:
            if (newValue == `\u0065\u006e\u0064`) {
              this.reportStop().then(() => {});
            }
            break;
          case `\u0074\u0061\u0073\u006b\u0050\u006c\u0061\u0074\u0066\u006f\u0072\u006d`:
            this.taskPlatform = newValue;
            break;
          case `\u0058\u0069\u0061\u006f\u0048\u006f\u006e\u0067\u0053\u0068\u0075\u005f\u0053\u0065\u0074\u0074\u0069\u006e\u0067`:
            this.XiaoHongShu_Setting = newValue ? JSON.parse(newValue) : {};
            break;
          case `\u006f\u0072\u0067\u0049\u0064`:
            this.orgId = newValue;
            break;
          case `\u0075\u0073\u0065\u0072\u0049\u0064`:
            this.user_id = newValue;
            break;
          case `\u0063\u006c\u0069\u0065\u006e\u0074\u0056\u0069\u0073\u0069\u0074\u006f\u0072\u0049\u0064`:
            this.clientVisitorId = newValue;
            break;
          case `\u0061\u0063\u0063\u0065\u0073\u0073\u0054\u006f\u006b\u0065\u006e`:
            this.accessToken = newValue;
            break;
          case `\u006f\u0070\u0065\u0072\u0061\u0074\u0069\u006f\u006e\u0054\u0069\u006d\u0065`:
            this.operationTime = newValue;
            break;
          case `\u0072\u0075\u006e\u004d\u0069\u006e\u0075\u0074\u0065\u0054\u0069\u006d\u0065`:
            this.runMinuteTime = newValue;
            this.reportReply();
            break;
          case `\u0078\u0068\u0073\u005f\u006c\u0069\u006b\u0065\u0043\u006f\u0075\u006e\u0074`:
            this.xhs_likeCount = newValue;
            this.reportRunDataStatus().then();
            break;
          case `\u0078\u0068\u0073\u005f\u0066\u006f\u006c\u006c\u006f\u0077\u0043\u006f\u0075\u006e\u0074`:
            this.xhs_followCount = newValue;
            this.reportRunDataStatus().then();
            break;
          case `\u0078\u0068\u0073\u005f\u0043\u006f\u006d\u006d\u0065\u006e\u0074\u0043\u006f\u0075\u006e\u0074`:
            this.xhs_CommentCount = newValue;
            this.reportRunDataStatus().then();
            break;
          case `\u0078\u0068\u0073\u005f\u0063\u006f\u006c\u006c\u0065\u0063\u0074\u0043\u006f\u0075\u006e\u0074`:
            this.xhs_collectCount = newValue;
            this.reportRunDataStatus().then();
            break;
          case `\u0078\u0068\u0073\u005f\u0076\u0069\u0065\u0077\u0043\u006f\u0075\u006e\u0074`:
            this.xhs_viewCount = newValue;
            this.reportRunDataStatus().then();
            break;
          case `\u0064\u0079\u005f\u006c\u0069\u006b\u0065\u0043\u006f\u0075\u006e\u0074`:
            this.dy_likeCount = newValue;
            this.reportRunDataStatus().then();
            break;
          case `\u0064\u0079\u005f\u0066\u006f\u006c\u006c\u006f\u0077\u0043\u006f\u0075\u006e\u0074`:
            this.dy_followCount = newValue;
            this.reportRunDataStatus().then();
            break;
          case `\u0064\u0079\u005f\u0043\u006f\u006d\u006d\u0065\u006e\u0074\u0043\u006f\u0075\u006e\u0074`:
            this.dy_CommentCount = newValue;
            this.reportRunDataStatus().then();
            break;
          case `\u0064\u0079\u005f\u0063\u006f\u006c\u006c\u0065\u0063\u0074\u0043\u006f\u0075\u006e\u0074`:
            this.dy_collectCount = newValue;
            this.reportRunDataStatus().then();
            break;
          case `\u0064\u0079\u005f\u0076\u0069\u0065\u0077\u0043\u006f\u0075\u006e\u0074`:
            this.dy_viewCount = newValue;
            this.reportRunDataStatus().then();
            break;
          case `\u0065\u0078\u0065\u0063\u0075\u0074\u0065\u004f\u0070\u0065\u0072\u0061\u0074\u0069\u006f\u006e\u0053\u0074\u0061\u0072\u0074\u0054\u0069\u006d\u0065`:
            this.executeOperationStartTime = newValue;
            break;
          case `\u0065\u0078\u0065\u0063\u0075\u0074\u0065\u004f\u0070\u0065\u0072\u0061\u0074\u0069\u006f\u006e\u0045\u006e\u0064\u0054\u0069\u006d\u0065`:
            this.executeOperationEndTime = newValue;
            break;
          case `\u0078\u0068\u0073\u005f\u006b\u0065\u0079\u0077\u006f\u0072\u0064\u0073\u005f\u006c\u0069\u0073\u0074`:
            this.xhs_keywords_list = newValue ? JSON.parse(newValue) : [];
            break;
          case `\u0064\u006f\u0075\u0059\u0069\u006e\u005f\u006b\u0065\u0079\u0077\u006f\u0072\u0064\u0073\u005f\u006c\u0069\u0073\u0074`:
            this.douYin_keywords_list = newValue ? JSON.parse(newValue) : [];
            break;
          case `\u0078\u0068\u0073\u005f\u006d\u0069\u006e\u0075\u0074\u0065`:
            this.xhs_minute = newValue ? JSON.parse(newValue) : [];
            break;
          case `\u0064\u0079\u005f\u006d\u0069\u006e\u0075\u0074\u0065`:
            this.dy_minute = newValue ? JSON.parse(newValue) : [];
            break;
          case `\u0063\u006f\u006e\u0074\u0065\u006e\u0074\u0054\u0065\u0078\u0074`:
            this.contentText = newValue;
            break;
          case `\u0072\u0065\u0070\u006c\u0079\u0043\u006f\u006d\u006d\u0065\u006e\u0074`:
            this.replyComment = newValue;
            break;
        }
      }
    });
    this.startLoad = false;
    this.loadend = false;
    this.xhs_viewCount = 0;
    this.xhs_CommentCount = 0;
    this.xhs_likeCount = 0;
    this.xhs_followCount = 0;
    this.xhs_collectCount = 0;
    this.dy_viewCount = 0;
    this.dy_CommentCount = 0;
    this.dy_likeCount = 0;
    this.dy_followCount = 0;
    this.dy_collectCount = 0;
    this.operationTime = 0;
    this.runMinuteTime = 0;
    this.taskPlatform = ``;
    this.XiaoHongShu_Setting = ``;
    this.executeTask = executeTask2;
    this.executeOperationStartTime = 0;
    this.executeOperationEndTime = 0;
    this.xhs_keywords_list = [];
    this.douYin_keywords_list = [];
    this.xhs_minute = [];
    this.dy_minute = [];
    this.contentText = ``;
    this.replyComment = ``;
    this.loadFromStorage();
  }
  checkConfig() {
    const optionWhere = this.data;
    if (optionWhere.wordWhereNumEnd < 0) {
      console.error(`\u3010\u6700\u5927\u79c1\u4fe1\u5b57\u6570\u3011\u4e0d\u80fd\u5c0f\u4e8e\u0030`);
      this.reportFail(`\u3010\u6700\u5927\u79c1\u4fe1\u5b57\u6570\u3011\u4e0d\u80fd\u5c0f\u4e8e\u0030`);
      return false;
    }
    if (optionWhere.wordWhereNum > optionWhere.wordWhereNumEnd) {
      console.error(`\u3010\u6700\u5927\u79c1\u4fe1\u5b57\u6570\u3011\u4e0d\u80fd\u5c0f\u4e8e\u3010\u6700\u5c0f\u79c1\u4fe1\u5b57\u6570\u3011`);
      this.reportFail(`\u3010\u6700\u5927\u79c1\u4fe1\u5b57\u6570\u3011\u4e0d\u80fd\u5c0f\u4e8e\u3010\u6700\u5c0f\u79c1\u4fe1\u5b57\u6570\u3011`);
      return false;
    }
    if (optionWhere.runTimeEnd <= 0) {
      console.error(`\u3010\u6700\u5927\u8fd0\u884c\u65f6\u957f\u3011\u4e0d\u80fd\u5c0f\u4e8e\u7b49\u4e8e\u0030`);
      this.reportFail(`\u3010\u6700\u5927\u8fd0\u884c\u65f6\u957f\u3011\u4e0d\u80fd\u5c0f\u4e8e\u7b49\u4e8e\u0030`);
      return false;
    }
    if (optionWhere.runTimeStart > optionWhere.runTimeEnd) {
      console.error(`\u3010\u6700\u5927\u8fd0\u884c\u65f6\u957f\u3011\u4e0d\u80fd\u5c0f\u4e8e\u3010\u6700\u5c0f\u8fd0\u884c\u65f6\u957f\u3011`);
      this.reportFail(`\u3010\u6700\u5927\u8fd0\u884c\u65f6\u957f\u3011\u4e0d\u80fd\u5c0f\u4e8e\u3010\u6700\u5c0f\u8fd0\u884c\u65f6\u957f\u3011`);
      return false;
    }
    if (optionWhere.refreshFrequencyEnd <= 0) {
      console.error(`\u3010\u6700\u5927\u5237\u65b0\u9891\u7387\u3011\u4e0d\u80fd\u5c0f\u4e8e\u7b49\u4e8e\u0030`);
      this.reportFail(`\u3010\u6700\u5927\u5237\u65b0\u9891\u7387\u3011\u4e0d\u80fd\u5c0f\u4e8e\u7b49\u4e8e\u0030`);
      return false;
    }
    if (optionWhere.refreshFrequencyStart > optionWhere.refreshFrequencyEnd) {
      console.error(`\u3010\u6700\u5927\u5237\u65b0\u9891\u7387\u3011\u4e0d\u80fd\u5c0f\u4e8e\u3010\u6700\u5c0f\u5237\u65b0\u9891\u7387\u3011`);
      this.reportFail(`\u3010\u6700\u5927\u5237\u65b0\u9891\u7387\u3011\u4e0d\u80fd\u5c0f\u4e8e\u3010\u6700\u5c0f\u5237\u65b0\u9891\u7387\u3011`);
      return false;
    }
    if (!optionWhere.wordReplyContent && optionWhere.enableFirstReplyBool == true && !optionWhere.phoneNumberReplyContent && !optionWhere.phoneNumberReplyContent1 && !optionWhere.phoneNumberReplyContent3) {
      console.error(`\u8bc4\u8bba\u548c\u79c1\u4fe1\u7684\u56de\u590d\u5185\u5bb9\u4e0d\u80fd\u90fd\u4e3a\u7a7a`);
      return false;
    }
    return true;
  }
  reportFail(errorMessage) {
    if (!this.conn) {
      return;
    }
    this.conn.messageToReplyMQTT({
      "taskId": this.taskId,
      "executeId": this.executeId,
      "status": `\u0066\u0061\u0069\u006c\u0065\u0064`,
      "meta": {},
      "message": errorMessage
    });
  }
  startTask() {
    return new Promise(resolve => {
      const validationError = this.validateParameters();
      if (!this.conn) {
        return;
      }
      if (validationError) {
        console.error(validationError.message);
        this.conn.messageToReplyMQTT({
          "taskId": this.taskId,
          "executeId": this.executeId,
          "status": `\u0066\u0061\u0069\u006c\u0065\u0064`,
          "meta": {},
          "message": validationError.message
        });
        return;
      }
      console.log(`\u0044\u006f\u0020\u0061\u0020\u0063\u0075\u0073\u0074\u006f\u006d\u0069\u007a\u0065\u0020\u0074\u0061\u0073\u006b\u0021`);
      chrome.storage.local.set({
        "taskId": this.taskId
      });
      chrome.storage.local.set({
        "executeId": this.executeId
      });
      this.my_execute(this.data);
      this.conn.messageToReplyMQTT({
        "taskId": this.taskId,
        "executeId": this.executeId,
        "status": `\u0072\u0075\u006e\u006e\u0069\u006e\u0067`,
        "meta": this.getStatus(),
        "message": ``
      });
      resolve();
    });
  }
  validateParameters() {
    if (!this.data) {
      return {
        message: `\u53c2\u6570\u672a\u4f20\u9012\u6216\u683c\u5f0f\u4e0d\u6b63\u786e`
      };
    }
    return null;
  }
  // async addObjects(postData:any) {
  //     const baseURL = import.meta.env.VITE_APP_BASE_URL;
  //     const url = baseURL+"/api/v2/oss/objects"
  //     const headers = {
  //         'Content-Type': 'application/json',
  //         'Authorization':'Bearer '+store.accessToken
  //     };
  //     try {
  //         const response = await fetch(url, {
  //             method: 'POST',
  //             headers: headers,
  //             body: JSON.stringify(postData)
  //         });
  //
  //         if (!response.ok) {
  //             console.error("addObjects url:"+url+"，header:"+JSON.stringify(headers)+", response status:"+response.status)
  //             return undefined
  //         }
  //
  //         const result = await response.json();
  //         console.log("addObjects url:"+url+"，header:"+JSON.stringify(headers)+",postData："+JSON.stringify(postData)+" response status:"+response.status+", response data:"+JSON.stringify(result))
  //
  //         return result
  //     } catch (error) {
  //         console.error("addObjects url:"+url+"，header:"+JSON.stringify(headers)+", error"+error)
  //     }
  //     return undefined
  // }
  my_execute(config) {
    console.log(`\u5f00\u59cb\u89c6\u9891\u53f7\u5ba2\u8d44\u4efb\u52a1`);
    chrome.storage.local.set({
      "mqttStart": ``
    });
    chrome.storage.local.set({
      "runTaskStopped": ``
    });
    chrome.storage.local.set({
      "mqttStart": `\u006f\u006b`
    });
    chrome.storage.local.set({
      "xhs_viewCount": 0
    });
    chrome.storage.local.set({
      "xhs_CommentCount": 0
    });
    chrome.storage.local.set({
      "xhs_likeCount": 0
    });
    chrome.storage.local.set({
      "xhs_followCount": 0
    });
    chrome.storage.local.set({
      "xhs_collectCount": 0
    });
    chrome.storage.local.set({
      "dy_viewCount": 0
    });
    chrome.storage.local.set({
      "dy_CommentCount": 0
    });
    chrome.storage.local.set({
      "dy_likeCount": 0
    });
    chrome.storage.local.set({
      "dy_followCount": 0
    });
    chrome.storage.local.set({
      "dy_collectCount": 0
    });
    chrome.storage.local.set({
      "XiaoHongShu_search_runNumber": 1
    });
    chrome.storage.local.set({
      "activatePage": runPages[0]
    });
    chrome.storage.local.set({
      "operationTime": 0
    });
    chrome.storage.local.set({
      "xiaoHongShuAccountErrorTip": ``
    });
    chrome.storage.local.set({
      "xhs_keywords_list": JSON.stringify([])
    });
    chrome.storage.local.set({
      "douYin_keywords_list": JSON.stringify([])
    });
    chrome.storage.local.set({
      "xhs_minute": JSON.stringify([])
    });
    chrome.storage.local.set({
      "dy_minute": JSON.stringify([])
    });
    chrome.storage.local.set({
      "optionsPageName": ``
    });
    chrome.storage.local.set({
      "executeOperationStartTime": (/* @__PURE__ */new Date()).getTime()
    });
    chrome.storage.local.set({
      "XiaoHongShu_Setting": JSON.stringify({})
    });
    chrome.storage.local.set({
      "optionsPageName": ``
    });
    chrome.storage.local.set({
      "optionWhere": JSON.stringify(config)
    });
    chrome.storage.local.set({
      "runTimeMaxNum": config.runTimeEnd
    });
    chrome.storage.local.set({
      "runTimeNum": (/* @__PURE__ */new Date()).getTime()
    });
    chrome.storage.local.set({
      "formattedTime": ``
    });
    const key = store$3.userId + `\u005f\u0064\u006f\u0075\u0059\u0069\u006e\u005f\u0073\u0061\u0076\u0065\u004f\u0070\u0074\u0069\u006f\u006e\u0073\u0057\u0068\u0065\u0072\u0065`;
    const postDataObj = {
      "key": key,
      "bucket": config,
      "size": 0,
      "content_type": ``,
      "belong_to": store$3.userId + `\u005f\u0064\u006f\u0075\u0059\u0069\u006e\u005f\u0073\u0061\u0076\u0065\u004f\u0070\u0074\u0069\u006f\u006e\u0073\u0057\u0068\u0065\u0072\u0065`,
      "object_metadata": {}
    };
    try {
      const res = addObjects(postDataObj);
      console.log(`\u0072\u0065\u0073\u4fdd\u5b58\u7684\u6570\u636e\uff1a`, res);
    } catch (error) {
      console.log(`\u0065\u0072\u0072\u006f\u0072`, error);
    }
    chrome.storage.local.set({
      "executeOperationStartTime": (/* @__PURE__ */new Date()).getTime()
    });
    this.executeTask({
      action: `\u0065\u0078\u0065\u0063\u0075\u0074\u0065\u0054\u0061\u0073\u006b`,
      url: `\u0068\u0074\u0074\u0070\u0073\u003a\u002f\u002f\u0063\u0068\u0061\u006e\u006e\u0065\u006c\u0073\u002e\u0077\u0065\u0069\u0078\u0069\u006e\u002e\u0071\u0071\u002e\u0063\u006f\u006d\u002f\u0070\u006c\u0061\u0074\u0066\u006f\u0072\u006d\u002f`,
      taskId: this.taskId,
      taskName: `\u83b7\u53d6\u89c6\u9891\u53f7\u901a\u77e5`,
      taskPlatform: `\u89c6\u9891\u53f7`
    }, {}, res => {
      if (res && res.tabId) {
        this.tabId = res.tabId;
      }
      if (res && res.windowId) {
        this.windowId = res.windowId;
      }
      console.log(`\u0065\u0078\u0065\u0063\u0075\u0074\u0065\u0054\u0061\u0073\u006b\u0020\u0072\u0065\u0073`, res);
    });
  }
  stopTask() {
    return new Promise(resolve => {
      chrome.storage.local.set({
        "activatePage": indexPage
      });
      resolve();
    });
  }
  abortTask() {
    return new Promise(resolve => {
      this.reportStop().then(() => {});
      resolve();
    });
  }
  report() {
    return new Promise(resolve => {
      console.log(`\u0072\u0065\u0070\u006f\u0072\u0074\u0020\u0050\u0072\u006f\u006d\u0069\u0073\u0065`);
      try {
        let formatTimestamp = function (timestamp) {
            const date = new Date(timestamp);
            const month = String(date.getMonth() + 1).padStart(2, `\u0030`);
            const day = String(date.getDate()).padStart(2, `\u0030`);
            const hours = String(date.getHours()).padStart(2, `\u0030`);
            const minutes = String(date.getMinutes()).padStart(2, `\u0030`);
            return `${month}\u002d${day}\u0020${hours}\u003a${minutes}`;
          },
          calculateTimeDifference = function (startTimestamp, endTimestamp) {
            const differenceInMs = Math.abs(endTimestamp - startTimestamp);
            const totalMinutes = Math.floor(differenceInMs / (1e3 * 60));
            return `${totalMinutes}`;
          };
        if (!this.conn) {
          resolve();
          return;
        }
        const executeOperationStartTime = formatTimestamp(this.executeOperationStartTime);
        const executeOperationEndTime = formatTimestamp(this.executeOperationEndTime);
        const run_time = calculateTimeDifference(this.executeOperationStartTime, this.executeOperationEndTime);
        let xhs_keywords_list_str = ``;
        if (this.xhs_keywords_list.length > 0) {
          xhs_keywords_list_str = this.xhs_keywords_list.join(`\uff0c`);
        }
        let douYin_keywords_list_str = ``;
        if (this.douYin_keywords_list.length > 0) {
          douYin_keywords_list_str = this.douYin_keywords_list.join(`\uff0c`);
        }
        let XiaoHongShu_Setting = this.XiaoHongShu_Setting;
        let workRunPlatform = ``;
        if (XiaoHongShu_Setting.workDouYinPlatform) {
          if (!workRunPlatform) {
            workRunPlatform = XiaoHongShu_Setting.workDouYinPlatform;
          } else {
            workRunPlatform += `\u002b` + XiaoHongShu_Setting.workDouYinPlatform;
          }
        }
        if (XiaoHongShu_Setting.workXiaoHongShuPlatform) {
          if (!workRunPlatform) {
            workRunPlatform = XiaoHongShu_Setting.workXiaoHongShuPlatform;
          } else {
            workRunPlatform += `\u002b` + XiaoHongShu_Setting.workXiaoHongShuPlatform;
          }
        }
        const uniqueMinutes = [... /* @__PURE__ */new Set([...this.xhs_minute.map(item => item.minute), ...this.dy_minute.map(item => item.minute)])].sort((a, b) => a - b);
        const xhsNums = uniqueMinutes.map(minute => {
          var _a;
          return ((_a = this.xhs_minute.find(item => item.minute === minute)) == null ? void 0 : _a.num) || 0;
        });
        const xhsPieNumber = [{
          value: store$3.xhs_likeCount,
          name: `\u70b9\u8d5e`
        }, {
          value: store$3.xhs_CommentCount,
          name: `\u8bc4\u8bba`
        }, {
          value: store$3.xhs_followCount,
          name: `\u5173\u6ce8`
        }, {
          value: store$3.xhs_collectCount,
          name: `\u6536\u85cf`
        }];
        const dyPieNumber = [{
          value: store$3.dy_likeCount,
          name: `\u70b9\u8d5e`
        }, {
          value: store$3.dy_CommentCount,
          name: `\u8bc4\u8bba`
        }, {
          value: store$3.dy_followCount,
          name: `\u5173\u6ce8`
        }, {
          value: store$3.dy_collectCount,
          name: `\u6536\u85cf`
        }];
        const allPieNumber = [{
          value: store$3.xhs_likeCount + store$3.dy_likeCount,
          name: `\u70b9\u8d5e`
        }, {
          value: store$3.xhs_CommentCount + store$3.dy_CommentCount,
          name: `\u8bc4\u8bba`
        }, {
          value: store$3.xhs_followCount + store$3.dy_followCount,
          name: `\u5173\u6ce8`
        }, {
          value: store$3.xhs_collectCount + store$3.dy_collectCount,
          name: `\u6536\u85cf`
        }];
        const postData = {
          executeOperationStartTime,
          executeOperationEndTime,
          run_time,
          xhs_keywords_list_str,
          douYin_keywords_list_str,
          workRunPlatform,
          uniqueMinutes,
          xhsNums,
          xhsPieNumber,
          dyPieNumber,
          allPieNumber
        };
        console.log(`\u006d\u0065\u0073\u0073\u0061\u0067\u0065\u0054\u006f\u0052\u0065\u0070\u006f\u0072\u0074\u004d\u0051\u0054\u0054\u0020\u0070\u006f\u0073\u0074\u0044\u0061\u0074\u0061`, JSON.stringify(postData));
        sendLog(`\u0054\u0061\u0073\u006b\u0020\u0073\u0074\u006f\u0070\u0070\u0065\u0064`);
        this.conn.messageToReportMQTT({
          "taskId": this.taskId,
          "executeId": this.executeId,
          "status": `\u0072\u0065\u0070\u006f\u0072\u0074`,
          "meta": postData,
          "message": `\u62a5\u544a`
        });
        resolve();
      } catch (e) {
        console.log(`\u0072\u0065\u0070\u006f\u0072\u0074\u0020\u0065`, e);
      }
    });
  }
  /**
   * 获取心跳上报数据
   *
   * {
   *             taskConfig:{
   *                 // 任务配置
   *                 config:{
   *                     enableFirstReplyBool: true,
   *                     keFuNullReplyContent: "兜底",
   *                     phoneNumberReplyContent: "2",
   *                     phoneNumberReplyContent1: "1",
   *                     phoneNumberReplyContent3: "3",
   *                     refreshFrequencyEnd: 2,
   *                     refreshFrequencyStart: 1,
   *                     runTimeEnd: 0.5,
   *                     runTimeStart: 0,
   *                     wordReplyContent: "请私信",
   *                     wordWhereNum: 1,
   *                     wordWhereNumEnd: 9999,
   *                 },
   *                 executeId: "1b3cea2b-a869-4e96-b5be-93a813f54427",
   *                 operation: "cmd",
   *                 taskId: "b8e94836-9da1-4394-b6ea-4a72d81a2bc4",
   *                 type: "DouYinKeZiTask"
   *             },
   *             runStatus:{
   *                 //运行页面状态
   *                 stopButtonText: "stop",
   *                 formattedTime:"",
   *             },
   *             replyComment:{
   *                 // 读取到，要回复的内容上报
   *                 contentText:"",
   *                 replyComment:"",
   *             },
   *             webLoginInfo:{
   *                 // 登录抖音账号的名称
   *                 webUserId:"",
   *                 webUserName:"",
   *                 webUserAvatarUrl:""
   *             }
   *             // 上报
   *             // 1；配置信息
   *             // 2、显示信息上报
   *             // 3、点击停止上报
   *             // 3、倒计时剩余上报
   *             // 4、读取到，要回复的内容上报
   *             // 5、登录抖音账号的名称
   *         }
   */
  getHeartReportData() {
    return {
      taskConfig: this.data,
      taskRunConfig: {
        executeId: this.executeId,
        taskId: this.taskId,
        type: `\u0053\u0068\u0069\u0050\u0069\u006e\u0048\u0061\u006f\u004b\u0065\u005a\u0069\u0054\u0061\u0073\u006b`,
        operation: `\u0063\u006d\u0064`
      },
      runStatus: {
        //运行页面状态
        runLogs: this.runLogs + `\uff08` + this.formattedTime + `\uff09`,
        stopButtonText: this.stopButtonText,
        formattedTime: this.formattedTime
      },
      replyComment: {
        // 读取到，要回复的内容上报
        contentText: this.contentText,
        replyComment: this.replyComment
      }
      // 上报
      // 1；配置信息
      // 2、显示信息上报
      // 3、点击停止上报
      // 3、倒计时剩余上报
      // 4、读取到，要回复的内容上报
      // 5、登录抖音账号的名称
    };
  }
  /**
   * 等待store 通知 callBackListener
   */
  async reportStop() {
    this.running = false;
    this.paused = false;
    this.callExecuteNotification();
    storageUtil.removeListener(this.callBackListener);
    super.baseReportStop();
    if (!this.conn) {
      return;
    }
    sendLog(`\u0054\u0061\u0073\u006b\u0020\u0073\u0074\u006f\u0070\u0070\u0065\u0064`);
    this.conn.messageToReplyMQTT({
      "taskId": this.taskId,
      "executeId": this.executeId,
      "status": `\u0063\u006f\u006d\u0070\u006c\u0065\u0074\u0065\u0064`,
      "meta": this.getStatus(),
      "message": `\u5df2\u505c\u6b62`
    });
    this.conn.setRunTaskInstance(null);
  }
  getStatus() {
    return {
      id: this.taskId,
      running: this.running,
      paused: this.paused,
      started: this.started,
      process: this.operationTime > 0 ? (this.runMinuteTime / this.operationTime * 100).toFixed(2) : 0,
      total_num: this.operationTime,
      executed_num: this.runMinuteTime
    };
  }
  getRunData() {
    if (this.taskPlatform === `\u6296\u97f3`) {
      return {
        viewCount: this.dy_viewCount,
        commentCount: this.dy_CommentCount,
        likeCount: this.dy_likeCount,
        followCount: this.dy_followCount,
        collectCount: this.dy_collectCount,
        operationTime: this.operationTime,
        runMinuteTime: this.runMinuteTime
      };
    } else if (this.taskPlatform === `\u5c0f\u7ea2\u4e66`) {
      return {
        likeCount: this.xhs_likeCount,
        followCount: this.xhs_followCount,
        commentCount: this.xhs_CommentCount,
        collectCount: this.xhs_collectCount,
        viewCount: this.xhs_viewCount,
        operationTime: this.operationTime,
        runMinuteTime: this.runMinuteTime
      };
    }
  }
  reportReply() {
    console.log(`\u0072\u0065\u0070\u006f\u0072\u0074\u0052\u0065\u0070\u006c\u0079`);
    if (!this.conn) {
      return;
    }
    this.conn.messageToReplyMQTT({
      "taskId": this.taskId,
      "executeId": this.executeId,
      "status": `\u0072\u0075\u006e\u006e\u0069\u006e\u0067`,
      "meta": this.getStatus(),
      "message": ``
    });
  }
  loadFromStorage() {
    if (this.startLoad) {
      console.log(`\u0073\u0074\u0061\u0072\u0074\u004c\u006f\u0061\u0064`, this.startLoad);
      return;
    }
    this.startLoad = true;
    chrome.storage.local.get([`\u0074\u0061\u0073\u006b\u0050\u006c\u0061\u0074\u0066\u006f\u0072\u006d`, `\u0058\u0069\u0061\u006f\u0048\u006f\u006e\u0067\u0053\u0068\u0075\u005f\u0053\u0065\u0074\u0074\u0069\u006e\u0067`, `\u0078\u0068\u0073\u005f\u0076\u0069\u0065\u0077\u0043\u006f\u0075\u006e\u0074`, `\u0078\u0068\u0073\u005f\u0043\u006f\u006d\u006d\u0065\u006e\u0074\u0043\u006f\u0075\u006e\u0074`, `\u0078\u0068\u0073\u005f\u006c\u0069\u006b\u0065\u0043\u006f\u0075\u006e\u0074`, `\u0078\u0068\u0073\u005f\u0066\u006f\u006c\u006c\u006f\u0077\u0043\u006f\u0075\u006e\u0074`, `\u0078\u0068\u0073\u005f\u0063\u006f\u006c\u006c\u0065\u0063\u0074\u0043\u006f\u0075\u006e\u0074`, `\u0064\u0079\u005f\u0076\u0069\u0065\u0077\u0043\u006f\u0075\u006e\u0074`, `\u0064\u0079\u005f\u0043\u006f\u006d\u006d\u0065\u006e\u0074\u0043\u006f\u0075\u006e\u0074`, `\u0064\u0079\u005f\u006c\u0069\u006b\u0065\u0043\u006f\u0075\u006e\u0074`, `\u0064\u0079\u005f\u0066\u006f\u006c\u006c\u006f\u0077\u0043\u006f\u0075\u006e\u0074`, `\u0064\u0079\u005f\u0063\u006f\u006c\u006c\u0065\u0063\u0074\u0043\u006f\u0075\u006e\u0074`, `\u006f\u0070\u0065\u0072\u0061\u0074\u0069\u006f\u006e\u0054\u0069\u006d\u0065`, `\u0075\u0073\u0065\u0072\u0049\u0064`, `\u006f\u0072\u0067\u0049\u0064`, `\u0063\u006c\u0069\u0065\u006e\u0074\u0056\u0069\u0073\u0069\u0074\u006f\u0072\u0049\u0064`, `\u0061\u0063\u0063\u0065\u0073\u0073\u0054\u006f\u006b\u0065\u006e`, `\u0063\u006f\u006e\u0074\u0065\u006e\u0074\u0054\u0065\u0078\u0074`, `\u0072\u0065\u0070\u006c\u0079\u0043\u006f\u006d\u006d\u0065\u006e\u0074`], result => {
      console.log(`\u0072\u0065\u0073\u0075\u006c\u0074\u0020\u0061\u0063\u0074\u0069\u0076\u0061\u0074\u0065\u0050\u0061\u0067\u0065`, result);
      if (!result) {
        return;
      }
      if (result.userId !== void 0) {
        this.user_id = result.userId;
      }
      if (result.orgId !== void 0) {
        this.orgId = result.orgId;
      }
      if (result.clientVisitorId !== void 0) {
        this.clientVisitorId = result.clientVisitorId;
      }
      if (result.accessToken !== void 0) {
        this.accessToken = result.accessToken;
      }
      if (result.taskPlatform !== void 0) {
        this.taskPlatform = result.taskPlatform;
      }
      if (result.XiaoHongShu_Setting !== void 0) {
        this.XiaoHongShu_Setting = result.XiaoHongShu_Setting ? JSON.parse(result.XiaoHongShu_Setting) : {};
      }
      if (result.xhs_viewCount !== void 0) {
        this.xhs_viewCount = result.xhs_viewCount;
      }
      if (result.xhs_CommentCount !== void 0) {
        this.xhs_CommentCount = result.xhs_CommentCount;
      }
      if (result.xhs_likeCount !== void 0) {
        this.xhs_likeCount = result.xhs_likeCount;
      }
      if (result.xhs_followCount !== void 0) {
        this.xhs_followCount = result.xhs_followCount;
      }
      if (result.xhs_collectCount !== void 0) {
        this.xhs_collectCount = result.xhs_collectCount;
      }
      if (result.dy_viewCount !== void 0) {
        this.dy_viewCount = result.dy_viewCount;
      }
      if (result.dy_CommentCount !== void 0) {
        this.dy_CommentCount = result.dy_CommentCount;
      }
      if (result.dy_likeCount !== void 0) {
        this.dy_likeCount = result.dy_likeCount;
      }
      if (result.dy_followCount !== void 0) {
        this.dy_followCount = result.dy_followCount;
      }
      if (result.dy_collectCount !== void 0) {
        this.dy_collectCount = result.dy_collectCount;
      }
      if (result.operationTime !== void 0) {
        this.operationTime = result.operationTime;
      }
      if (result.contentText !== void 0) {
        this.contentText = result.contentText;
      }
      if (result.replyComment !== void 0) {
        this.replyComment = result.replyComment;
      }
      this.startLoad = true;
      this.loadend = true;
    });
    storageUtil.addHandlers(this.callBackListener);
  }
}
const store$2 = UseCounterStore.getInstance();
const VITE_CONTENT_API$1 = `\u0068\u0074\u0074\u0070\u0073\u003a\u002f\u002f\u0061\u0067\u0065\u006e\u0074\u002d\u006e\u0065\u0074\u002e\u0070\u0061\u0069\u0074\u006f\u006e\u0067\u0061\u0069\u002e\u006e\u0065\u0074\u002f\u0063\u006f\u006e\u0074\u0065\u006e\u0074`;
class XiaoHongShuAutoReplyTask extends BaseTask {
  constructor(taskId, executeId, data, executeTask2) {
    super(taskId, executeId, data);
    __publicField(this, `\u0065\u0078\u0065\u0063\u0075\u0074\u0065\u0054\u0061\u0073\u006b`);
    //评论数量
    __publicField(this, `\u0078\u0068\u0073\u005f\u0076\u0069\u0065\u0077\u0043\u006f\u0075\u006e\u0074`);
    __publicField(this, `\u0078\u0068\u0073\u005f\u0043\u006f\u006d\u006d\u0065\u006e\u0074\u0043\u006f\u0075\u006e\u0074`);
    __publicField(this, `\u0078\u0068\u0073\u005f\u006c\u0069\u006b\u0065\u0043\u006f\u0075\u006e\u0074`);
    __publicField(this, `\u0078\u0068\u0073\u005f\u0066\u006f\u006c\u006c\u006f\u0077\u0043\u006f\u0075\u006e\u0074`);
    __publicField(this, `\u0078\u0068\u0073\u005f\u0063\u006f\u006c\u006c\u0065\u0063\u0074\u0043\u006f\u0075\u006e\u0074`);
    //评论数量
    __publicField(this, `\u0064\u0079\u005f\u0076\u0069\u0065\u0077\u0043\u006f\u0075\u006e\u0074`);
    __publicField(this, `\u0064\u0079\u005f\u0043\u006f\u006d\u006d\u0065\u006e\u0074\u0043\u006f\u0075\u006e\u0074`);
    __publicField(this, `\u0064\u0079\u005f\u006c\u0069\u006b\u0065\u0043\u006f\u0075\u006e\u0074`);
    __publicField(this, `\u0064\u0079\u005f\u0066\u006f\u006c\u006c\u006f\u0077\u0043\u006f\u0075\u006e\u0074`);
    __publicField(this, `\u0064\u0079\u005f\u0063\u006f\u006c\u006c\u0065\u0063\u0074\u0043\u006f\u0075\u006e\u0074`);
    __publicField(this, `\u0074\u0061\u0073\u006b\u0050\u006c\u0061\u0074\u0066\u006f\u0072\u006d`);
    __publicField(this, `\u0058\u0069\u0061\u006f\u0048\u006f\u006e\u0067\u0053\u0068\u0075\u005f\u0053\u0065\u0074\u0074\u0069\u006e\u0067`);
    __publicField(this, `\u006f\u0070\u0065\u0072\u0061\u0074\u0069\u006f\u006e\u0054\u0069\u006d\u0065`);
    __publicField(this, `\u0072\u0075\u006e\u004d\u0069\u006e\u0075\u0074\u0065\u0054\u0069\u006d\u0065`);
    __publicField(this, `\u0073\u0074\u0061\u0072\u0074\u004c\u006f\u0061\u0064`);
    __publicField(this, `\u006c\u006f\u0061\u0064\u0065\u006e\u0064`);
    // 上报数据
    __publicField(this, `\u0065\u0078\u0065\u0063\u0075\u0074\u0065\u004f\u0070\u0065\u0072\u0061\u0074\u0069\u006f\u006e\u0053\u0074\u0061\u0072\u0074\u0054\u0069\u006d\u0065`);
    __publicField(this, `\u0065\u0078\u0065\u0063\u0075\u0074\u0065\u004f\u0070\u0065\u0072\u0061\u0074\u0069\u006f\u006e\u0045\u006e\u0064\u0054\u0069\u006d\u0065`);
    __publicField(this, `\u0078\u0068\u0073\u005f\u006b\u0065\u0079\u0077\u006f\u0072\u0064\u0073\u005f\u006c\u0069\u0073\u0074`);
    __publicField(this, `\u0064\u006f\u0075\u0059\u0069\u006e\u005f\u006b\u0065\u0079\u0077\u006f\u0072\u0064\u0073\u005f\u006c\u0069\u0073\u0074`);
    __publicField(this, `\u0078\u0068\u0073\u005f\u006d\u0069\u006e\u0075\u0074\u0065`);
    __publicField(this, `\u0064\u0079\u005f\u006d\u0069\u006e\u0075\u0074\u0065`);
    __publicField(this, `\u0072\u0065\u0070\u006f\u0072\u0074\u0052\u0075\u006e\u0044\u0061\u0074\u0061\u0053\u0074\u0061\u0074\u0075\u0073`, async () => {
      var _a;
      console.log(`\u0072\u0065\u0070\u006f\u0072\u0074\u0052\u0075\u006e\u0044\u0061\u0074\u0061\u0053\u0074\u0061\u0074\u0075\u0073`);
      if (!this.conn) {
        return;
      }
      const runData = this.getRunData();
      console.log(`\u0072\u0075\u006e\u0044\u0061\u0074\u0061`, JSON.stringify(runData));
      this.conn.messageToStatusMQTT({
        "taskId": this.taskId,
        "data": runData,
        "userId": this.user_id,
        "terminalId": (_a = this.terminalData) == null ? void 0 : _a.terminalId
      });
    });
    __publicField(this, `\u0072\u0065\u0070\u006f\u0072\u0074\u0052\u0075\u006e\u0044\u0061\u0074\u0061`, async () => {
      var _a;
      const url = VITE_CONTENT_API$1 + `\u002f\u0061\u0070\u0069\u002f\u0063\u006f\u006e\u0074\u0065\u006e\u0074\u002f`;
      const headers = {
        "Content-Type": `\u0061\u0070\u0070\u006c\u0069\u0063\u0061\u0074\u0069\u006f\u006e\u002f\u006a\u0073\u006f\u006e`,
        ...this.addAuthorizationHeader()
        // Ensure this function works in the extension
      };
      try {
        console.log(`\u0072\u0065\u0070\u006f\u0072\u0074\u0052\u0075\u006e\u0044\u0061\u0074\u0061`);
        const runData = this.getRunData();
        console.log(`\u0072\u0075\u006e\u0044\u0061\u0074\u0061`, JSON.stringify(runData));
        const postData = {
          "taskId": this.taskId,
          "data": runData,
          "userId": this.user_id,
          "terminalId": (_a = this.terminalData) == null ? void 0 : _a.terminalId
        };
        const response = await fetch(url, {
          method: `\u0050\u004f\u0053\u0054`,
          headers,
          body: JSON.stringify(postData)
        });
        if (!response.ok) {
          console.log(`\u0075\u0072\u006c\u003a` + url + `\uff0c\u0068\u0065\u0061\u0064\u0065\u0072\u003a` + JSON.stringify(headers) + `\u002c\u0020\u0072\u0065\u0073\u0070\u006f\u006e\u0073\u0065\u0020\u0073\u0074\u0061\u0074\u0075\u0073\u003a` + response.status);
          return;
        }
        const result = await response.json();
        console.log(`\u0075\u0072\u006c\u003a` + url + `\uff0c\u0068\u0065\u0061\u0064\u0065\u0072\u003a` + JSON.stringify(headers) + `\u002c\u0070\u006f\u0073\u0074\u0044\u0061\u0074\u0061\uff1a` + JSON.stringify(postData) + `\u0020\u0072\u0065\u0073\u0070\u006f\u006e\u0073\u0065\u0020\u0073\u0074\u0061\u0074\u0075\u0073\u003a` + response.status + `\u002c\u0020\u0072\u0065\u0073\u0070\u006f\u006e\u0073\u0065\u0020\u0064\u0061\u0074\u0061\u003a` + JSON.stringify(result));
      } catch (error) {
        console.log(`\u0045\u0072\u0072\u006f\u0072\u0020\u0069\u006e\u0020\u0070\u0075\u0074\u004e\u0065\u0077\u0054\u0061\u0073\u006b\u003a`, error);
        sendLog(`\u0075\u0072\u006c\u003a` + url + `\uff0c\u0068\u0065\u0061\u0064\u0065\u0072\u003a` + JSON.stringify(headers) + `\u002c\u0020\u0065\u0072\u0072\u006f\u0072` + error);
      }
    });
    __publicField(this, `\u0063\u0061\u006c\u006c\u0042\u0061\u0063\u006b\u004c\u0069\u0073\u0074\u0065\u006e\u0065\u0072`, (changes, namespace) => {
      for (let [key, {
        oldValue,
        newValue
      }] of Object.entries(changes)) {
        console.log(`\u0063\u0075\u0073\u0074\u006f\u006d\u0069\u007a\u0065\u0054\u0061\u0073\u006b\u0020\u0053\u0074\u006f\u0072\u0061\u0067\u0065\u0020\u006b\u0065\u0079\u0020\u0022${key}\u0022\u0020\u0069\u006e\u0020\u006e\u0061\u006d\u0065\u0073\u0070\u0061\u0063\u0065\u0020\u0022${namespace}\u0022\u0020\u0063\u0068\u0061\u006e\u0067\u0065\u0064\u002e`, `\u004f\u006c\u0064\u0020\u0076\u0061\u006c\u0075\u0065\u0020\u0077\u0061\u0073\u0020\u0022${oldValue}\u0022\u002c\u0020\u006e\u0065\u0077\u0020\u0076\u0061\u006c\u0075\u0065\u0020\u0069\u0073\u0020\u0022${newValue}\u0022\u002e`);
        switch (key) {
          case `\u0072\u0075\u006e\u0054\u0061\u0073\u006b\u0053\u0074\u006f\u0070\u0070\u0065\u0064`:
            if (newValue == `\u0065\u006e\u0064`) {
              this.reportStop().then(() => {});
            }
            break;
          case `\u0074\u0061\u0073\u006b\u0050\u006c\u0061\u0074\u0066\u006f\u0072\u006d`:
            this.taskPlatform = newValue;
            break;
          case `\u0058\u0069\u0061\u006f\u0048\u006f\u006e\u0067\u0053\u0068\u0075\u005f\u0053\u0065\u0074\u0074\u0069\u006e\u0067`:
            this.XiaoHongShu_Setting = newValue ? JSON.parse(newValue) : {};
            break;
          case `\u006f\u0072\u0067\u0049\u0064`:
            this.orgId = newValue;
            break;
          case `\u0075\u0073\u0065\u0072\u0049\u0064`:
            this.user_id = newValue;
            break;
          case `\u0063\u006c\u0069\u0065\u006e\u0074\u0056\u0069\u0073\u0069\u0074\u006f\u0072\u0049\u0064`:
            this.clientVisitorId = newValue;
            break;
          case `\u0061\u0063\u0063\u0065\u0073\u0073\u0054\u006f\u006b\u0065\u006e`:
            this.accessToken = newValue;
            break;
          case `\u006f\u0070\u0065\u0072\u0061\u0074\u0069\u006f\u006e\u0054\u0069\u006d\u0065`:
            this.operationTime = newValue;
            break;
          case `\u0072\u0075\u006e\u004d\u0069\u006e\u0075\u0074\u0065\u0054\u0069\u006d\u0065`:
            this.runMinuteTime = newValue;
            this.reportReply();
            break;
          case `\u0078\u0068\u0073\u005f\u006c\u0069\u006b\u0065\u0043\u006f\u0075\u006e\u0074`:
            this.xhs_likeCount = newValue;
            this.reportRunDataStatus().then();
            break;
          case `\u0078\u0068\u0073\u005f\u0066\u006f\u006c\u006c\u006f\u0077\u0043\u006f\u0075\u006e\u0074`:
            this.xhs_followCount = newValue;
            this.reportRunDataStatus().then();
            break;
          case `\u0078\u0068\u0073\u005f\u0043\u006f\u006d\u006d\u0065\u006e\u0074\u0043\u006f\u0075\u006e\u0074`:
            this.xhs_CommentCount = newValue;
            this.reportRunDataStatus().then();
            break;
          case `\u0078\u0068\u0073\u005f\u0063\u006f\u006c\u006c\u0065\u0063\u0074\u0043\u006f\u0075\u006e\u0074`:
            this.xhs_collectCount = newValue;
            this.reportRunDataStatus().then();
            break;
          case `\u0078\u0068\u0073\u005f\u0076\u0069\u0065\u0077\u0043\u006f\u0075\u006e\u0074`:
            this.xhs_viewCount = newValue;
            this.reportRunDataStatus().then();
            break;
          case `\u0064\u0079\u005f\u006c\u0069\u006b\u0065\u0043\u006f\u0075\u006e\u0074`:
            this.dy_likeCount = newValue;
            this.reportRunDataStatus().then();
            break;
          case `\u0064\u0079\u005f\u0066\u006f\u006c\u006c\u006f\u0077\u0043\u006f\u0075\u006e\u0074`:
            this.dy_followCount = newValue;
            this.reportRunDataStatus().then();
            break;
          case `\u0064\u0079\u005f\u0043\u006f\u006d\u006d\u0065\u006e\u0074\u0043\u006f\u0075\u006e\u0074`:
            this.dy_CommentCount = newValue;
            this.reportRunDataStatus().then();
            break;
          case `\u0064\u0079\u005f\u0063\u006f\u006c\u006c\u0065\u0063\u0074\u0043\u006f\u0075\u006e\u0074`:
            this.dy_collectCount = newValue;
            this.reportRunDataStatus().then();
            break;
          case `\u0064\u0079\u005f\u0076\u0069\u0065\u0077\u0043\u006f\u0075\u006e\u0074`:
            this.dy_viewCount = newValue;
            this.reportRunDataStatus().then();
            break;
          case `\u0065\u0078\u0065\u0063\u0075\u0074\u0065\u004f\u0070\u0065\u0072\u0061\u0074\u0069\u006f\u006e\u0053\u0074\u0061\u0072\u0074\u0054\u0069\u006d\u0065`:
            this.executeOperationStartTime = newValue;
            break;
          case `\u0065\u0078\u0065\u0063\u0075\u0074\u0065\u004f\u0070\u0065\u0072\u0061\u0074\u0069\u006f\u006e\u0045\u006e\u0064\u0054\u0069\u006d\u0065`:
            this.executeOperationEndTime = newValue;
            break;
          case `\u0078\u0068\u0073\u005f\u006b\u0065\u0079\u0077\u006f\u0072\u0064\u0073\u005f\u006c\u0069\u0073\u0074`:
            this.xhs_keywords_list = newValue ? JSON.parse(newValue) : [];
            break;
          case `\u0064\u006f\u0075\u0059\u0069\u006e\u005f\u006b\u0065\u0079\u0077\u006f\u0072\u0064\u0073\u005f\u006c\u0069\u0073\u0074`:
            this.douYin_keywords_list = newValue ? JSON.parse(newValue) : [];
            break;
          case `\u0078\u0068\u0073\u005f\u006d\u0069\u006e\u0075\u0074\u0065`:
            this.xhs_minute = newValue ? JSON.parse(newValue) : [];
            break;
          case `\u0064\u0079\u005f\u006d\u0069\u006e\u0075\u0074\u0065`:
            this.dy_minute = newValue ? JSON.parse(newValue) : [];
            break;
        }
      }
    });
    this.startLoad = false;
    this.loadend = false;
    this.xhs_viewCount = 0;
    this.xhs_CommentCount = 0;
    this.xhs_likeCount = 0;
    this.xhs_followCount = 0;
    this.xhs_collectCount = 0;
    this.dy_viewCount = 0;
    this.dy_CommentCount = 0;
    this.dy_likeCount = 0;
    this.dy_followCount = 0;
    this.dy_collectCount = 0;
    this.operationTime = 0;
    this.runMinuteTime = 0;
    this.taskPlatform = ``;
    this.XiaoHongShu_Setting = ``;
    this.executeTask = executeTask2;
    this.executeOperationStartTime = 0;
    this.executeOperationEndTime = 0;
    this.xhs_keywords_list = [];
    this.douYin_keywords_list = [];
    this.xhs_minute = [];
    this.dy_minute = [];
    this.loadFromStorage();
  }
  checkConfig() {
    const optionWhere = this.data;
    if (optionWhere.wordWhereNumEnd < 0) {
      console.error(`\u3010\u6700\u5927\u79c1\u4fe1\u5b57\u6570\u3011\u4e0d\u80fd\u5c0f\u4e8e\u0030`);
      this.reportFail(`\u3010\u6700\u5927\u79c1\u4fe1\u5b57\u6570\u3011\u4e0d\u80fd\u5c0f\u4e8e\u0030`);
      return false;
    }
    if (optionWhere.wordWhereNum > optionWhere.wordWhereNumEnd) {
      console.error(`\u3010\u6700\u5927\u79c1\u4fe1\u5b57\u6570\u3011\u4e0d\u80fd\u5c0f\u4e8e\u3010\u6700\u5c0f\u79c1\u4fe1\u5b57\u6570\u3011`);
      this.reportFail(`\u3010\u6700\u5927\u79c1\u4fe1\u5b57\u6570\u3011\u4e0d\u80fd\u5c0f\u4e8e\u3010\u6700\u5c0f\u79c1\u4fe1\u5b57\u6570\u3011`);
      return false;
    }
    if (optionWhere.runTimeEnd <= 0) {
      console.error(`\u3010\u6700\u5927\u8fd0\u884c\u65f6\u957f\u3011\u4e0d\u80fd\u5c0f\u4e8e\u7b49\u4e8e\u0030`);
      this.reportFail(`\u3010\u6700\u5927\u8fd0\u884c\u65f6\u957f\u3011\u4e0d\u80fd\u5c0f\u4e8e\u7b49\u4e8e\u0030`);
      return false;
    }
    if (optionWhere.runTimeStart > optionWhere.runTimeEnd) {
      console.error(`\u3010\u6700\u5927\u8fd0\u884c\u65f6\u957f\u3011\u4e0d\u80fd\u5c0f\u4e8e\u3010\u6700\u5c0f\u8fd0\u884c\u65f6\u957f\u3011`);
      this.reportFail(`\u3010\u6700\u5927\u8fd0\u884c\u65f6\u957f\u3011\u4e0d\u80fd\u5c0f\u4e8e\u3010\u6700\u5c0f\u8fd0\u884c\u65f6\u957f\u3011`);
      return false;
    }
    if (optionWhere.refreshFrequencyEnd <= 0) {
      console.error(`\u3010\u6700\u5927\u5237\u65b0\u9891\u7387\u3011\u4e0d\u80fd\u5c0f\u4e8e\u7b49\u4e8e\u0030`);
      this.reportFail(`\u3010\u6700\u5927\u5237\u65b0\u9891\u7387\u3011\u4e0d\u80fd\u5c0f\u4e8e\u7b49\u4e8e\u0030`);
      return false;
    }
    if (optionWhere.refreshFrequencyStart > optionWhere.refreshFrequencyEnd) {
      console.error(`\u3010\u6700\u5927\u5237\u65b0\u9891\u7387\u3011\u4e0d\u80fd\u5c0f\u4e8e\u3010\u6700\u5c0f\u5237\u65b0\u9891\u7387\u3011`);
      this.reportFail(`\u3010\u6700\u5927\u5237\u65b0\u9891\u7387\u3011\u4e0d\u80fd\u5c0f\u4e8e\u3010\u6700\u5c0f\u5237\u65b0\u9891\u7387\u3011`);
      return false;
    }
    if (!optionWhere.wordReplyContent && optionWhere.enableFirstReplyBool == true && !optionWhere.phoneNumberReplyContent && !optionWhere.phoneNumberReplyContent1 && !optionWhere.phoneNumberReplyContent3) {
      console.error(`\u8bc4\u8bba\u548c\u79c1\u4fe1\u7684\u56de\u590d\u5185\u5bb9\u4e0d\u80fd\u90fd\u4e3a\u7a7a`);
      return false;
    }
    return true;
  }
  reportFail(errorMessage) {
    if (!this.conn) {
      return;
    }
    this.conn.messageToReplyMQTT({
      "taskId": this.taskId,
      "executeId": this.executeId,
      "status": `\u0066\u0061\u0069\u006c\u0065\u0064`,
      "meta": {},
      "message": errorMessage
    });
  }
  startTask() {
    return new Promise(resolve => {
      const validationError = this.validateParameters();
      if (!this.conn) {
        return;
      }
      if (validationError) {
        console.error(validationError.message);
        this.conn.messageToReplyMQTT({
          "taskId": this.taskId,
          "executeId": this.executeId,
          "status": `\u0066\u0061\u0069\u006c\u0065\u0064`,
          "meta": {},
          "message": validationError.message
        });
        return;
      }
      console.log(`\u0044\u006f\u0020\u0061\u0020\u0063\u0075\u0073\u0074\u006f\u006d\u0069\u007a\u0065\u0020\u0074\u0061\u0073\u006b\u0021`);
      chrome.storage.local.set({
        "taskId": this.taskId
      });
      chrome.storage.local.set({
        "executeId": this.executeId
      });
      this.my_execute(this.data);
      this.conn.messageToReplyMQTT({
        "taskId": this.taskId,
        "executeId": this.executeId,
        "status": `\u0072\u0075\u006e\u006e\u0069\u006e\u0067`,
        "meta": this.getStatus(),
        "message": ``
      });
      resolve();
    });
  }
  validateParameters() {
    if (!this.data) {
      return {
        message: `\u53c2\u6570\u672a\u4f20\u9012\u6216\u683c\u5f0f\u4e0d\u6b63\u786e`
      };
    }
    return null;
  }
  // async addObjects(postData:any) {
  //     const baseURL = import.meta.env.VITE_APP_BASE_URL;
  //     const url = baseURL+"/api/v2/oss/objects"
  //     const headers = {
  //         'Content-Type': 'application/json',
  //         'Authorization':'Bearer '+store.accessToken
  //     };
  //     try {
  //         const response = await fetch(url, {
  //             method: 'POST',
  //             headers: headers,
  //             body: JSON.stringify(postData)
  //         });
  //
  //         if (!response.ok) {
  //             console.error("addObjects url:"+url+"，header:"+JSON.stringify(headers)+", response status:"+response.status)
  //             return undefined
  //         }
  //
  //         const result = await response.json();
  //         console.log("addObjects url:"+url+"，header:"+JSON.stringify(headers)+",postData："+JSON.stringify(postData)+" response status:"+response.status+", response data:"+JSON.stringify(result))
  //
  //         return result
  //     } catch (error) {
  //         console.error("addObjects url:"+url+"，header:"+JSON.stringify(headers)+", error"+error)
  //     }
  //     return undefined
  // }
  my_execute(config) {
    console.log(`\u006d\u0079\u005f\u0065\u0078\u0065\u0063\u0075\u0074\u0065\u0020\u0063\u006f\u006e\u0066\u0069\u0067`, config);
    chrome.storage.local.set({
      "runTaskStopped": ``
    });
    chrome.storage.local.set({
      "mqttStart": ``
    });
    chrome.storage.local.set({
      "runTaskStopped": ``
    });
    chrome.storage.local.set({
      "mqttStart": `\u006f\u006b`
    });
    chrome.storage.local.set({
      "xhs_viewCount": 0
    });
    chrome.storage.local.set({
      "xhs_CommentCount": 0
    });
    chrome.storage.local.set({
      "xhs_likeCount": 0
    });
    chrome.storage.local.set({
      "xhs_followCount": 0
    });
    chrome.storage.local.set({
      "xhs_collectCount": 0
    });
    chrome.storage.local.set({
      "dy_viewCount": 0
    });
    chrome.storage.local.set({
      "dy_CommentCount": 0
    });
    chrome.storage.local.set({
      "dy_likeCount": 0
    });
    chrome.storage.local.set({
      "dy_followCount": 0
    });
    chrome.storage.local.set({
      "dy_collectCount": 0
    });
    chrome.storage.local.set({
      "XiaoHongShu_search_runNumber": 1
    });
    chrome.storage.local.set({
      "activatePage": runPages[0]
    });
    chrome.storage.local.set({
      "operationTime": 0
    });
    chrome.storage.local.set({
      "xiaoHongShuAccountErrorTip": ``
    });
    chrome.storage.local.set({
      "xhs_keywords_list": JSON.stringify([])
    });
    chrome.storage.local.set({
      "douYin_keywords_list": JSON.stringify([])
    });
    chrome.storage.local.set({
      "xhs_minute": JSON.stringify([])
    });
    chrome.storage.local.set({
      "dy_minute": JSON.stringify([])
    });
    chrome.storage.local.set({
      "optionsPageName": ``
    });
    chrome.storage.local.set({
      "executeOperationStartTime": (/* @__PURE__ */new Date()).getTime()
    });
    chrome.storage.local.set({
      "XiaoHongShu_Setting": JSON.stringify(config)
    });
    chrome.storage.local.set({
      "optionsPageName": ``
    });
    chrome.storage.local.set({
      "optionWhere": JSON.stringify(config)
    });
    chrome.storage.local.set({
      "runTimeMaxNum": config.runTimeEnd
    });
    chrome.storage.local.set({
      "runTimeNum": (/* @__PURE__ */new Date()).getTime()
    });
    const key = store$2.userId + `\u005f\u0078\u0068\u0073\u005f\u0073\u0061\u0076\u0065\u004f\u0070\u0074\u0069\u006f\u006e\u0073\u0057\u0068\u0065\u0072\u0065`;
    const postDataObj = {
      "key": key,
      "bucket": config,
      "size": 0,
      "content_type": ``,
      "belong_to": store$2.userId + `\u005f\u0078\u0068\u0073\u005f\u0073\u0061\u0076\u0065\u004f\u0070\u0074\u0069\u006f\u006e\u0073\u0057\u0068\u0065\u0072\u0065`,
      "object_metadata": {}
    };
    try {
      const res = addObjects(postDataObj);
      console.log(`\u0072\u0065\u0073\u4fdd\u5b58\u7684\u6570\u636e\uff1a`, res);
    } catch (error) {
      console.log(`\u0065\u0072\u0072\u006f\u0072`, error);
    }
    chrome.storage.local.set({
      "executeOperationStartTime": (/* @__PURE__ */new Date()).getTime()
    });
    let url = `\u0068\u0074\u0074\u0070\u0073\u003a\u002f\u002f\u0077\u0077\u0077\u002e\u0078\u0069\u0061\u006f\u0068\u006f\u006e\u0067\u0073\u0068\u0075\u002e\u0063\u006f\u006d\u002f\u006e\u006f\u0074\u0069\u0066\u0069\u0063\u0061\u0074\u0069\u006f\u006e`;
    if (!store$2.webUserName || store$2.webUserName == `\u672a\u7ed1\u5b9a`) {
      url = `\u0068\u0074\u0074\u0070\u0073\u003a\u002f\u002f\u0077\u0077\u0077\u002e\u0078\u0069\u0061\u006f\u0068\u006f\u006e\u0067\u0073\u0068\u0075\u002e\u0063\u006f\u006d\u002f\u0065\u0078\u0070\u006c\u006f\u0072\u0065`;
    }
    this.executeTask({
      action: `\u0065\u0078\u0065\u0063\u0075\u0074\u0065\u0054\u0061\u0073\u006b\u004e\u006f\u0054\u0061\u0073\u006b`,
      taskId: this.taskId,
      url,
      taskName: `\u81ea\u52a8\u56de\u590d`,
      taskPlatform: `\u5c0f\u7ea2\u4e66`
    }, {}, res => {
      if (res && res.tabId) {
        this.tabId = res.tabId;
      }
      if (res && res.windowId) {
        this.windowId = res.windowId;
      }
      console.log(`\u0065\u0078\u0065\u0063\u0075\u0074\u0065\u0054\u0061\u0073\u006b\u0020\u0072\u0065\u0073`, res);
    });
  }
  stopTask() {
    return new Promise(resolve => {
      chrome.storage.local.set({
        "activatePage": indexPage
      });
      resolve();
    });
  }
  abortTask() {
    return new Promise(resolve => {
      this.reportStop().then(() => {});
      resolve();
    });
  }
  report() {
    return new Promise(resolve => {
      console.log(`\u0072\u0065\u0070\u006f\u0072\u0074\u0020\u0050\u0072\u006f\u006d\u0069\u0073\u0065`);
      try {
        let formatTimestamp = function (timestamp) {
            const date = new Date(timestamp);
            const month = String(date.getMonth() + 1).padStart(2, `\u0030`);
            const day = String(date.getDate()).padStart(2, `\u0030`);
            const hours = String(date.getHours()).padStart(2, `\u0030`);
            const minutes = String(date.getMinutes()).padStart(2, `\u0030`);
            return `${month}\u002d${day}\u0020${hours}\u003a${minutes}`;
          },
          calculateTimeDifference = function (startTimestamp, endTimestamp) {
            const differenceInMs = Math.abs(endTimestamp - startTimestamp);
            const totalMinutes = Math.floor(differenceInMs / (1e3 * 60));
            return `${totalMinutes}`;
          };
        if (!this.conn) {
          resolve();
          return;
        }
        const executeOperationStartTime = formatTimestamp(this.executeOperationStartTime);
        const executeOperationEndTime = formatTimestamp(this.executeOperationEndTime);
        const run_time = calculateTimeDifference(this.executeOperationStartTime, this.executeOperationEndTime);
        let xhs_keywords_list_str = ``;
        if (this.xhs_keywords_list.length > 0) {
          xhs_keywords_list_str = this.xhs_keywords_list.join(`\uff0c`);
        }
        let douYin_keywords_list_str = ``;
        if (this.douYin_keywords_list.length > 0) {
          douYin_keywords_list_str = this.douYin_keywords_list.join(`\uff0c`);
        }
        let XiaoHongShu_Setting = this.XiaoHongShu_Setting;
        let workRunPlatform = ``;
        if (XiaoHongShu_Setting.workDouYinPlatform) {
          if (!workRunPlatform) {
            workRunPlatform = XiaoHongShu_Setting.workDouYinPlatform;
          } else {
            workRunPlatform += `\u002b` + XiaoHongShu_Setting.workDouYinPlatform;
          }
        }
        if (XiaoHongShu_Setting.workXiaoHongShuPlatform) {
          if (!workRunPlatform) {
            workRunPlatform = XiaoHongShu_Setting.workXiaoHongShuPlatform;
          } else {
            workRunPlatform += `\u002b` + XiaoHongShu_Setting.workXiaoHongShuPlatform;
          }
        }
        const uniqueMinutes = [... /* @__PURE__ */new Set([...this.xhs_minute.map(item => item.minute), ...this.dy_minute.map(item => item.minute)])].sort((a, b) => a - b);
        const xhsNums = uniqueMinutes.map(minute => {
          var _a;
          return ((_a = this.xhs_minute.find(item => item.minute === minute)) == null ? void 0 : _a.num) || 0;
        });
        const xhsPieNumber = [{
          value: store$2.xhs_likeCount,
          name: `\u70b9\u8d5e`
        }, {
          value: store$2.xhs_CommentCount,
          name: `\u8bc4\u8bba`
        }, {
          value: store$2.xhs_followCount,
          name: `\u5173\u6ce8`
        }, {
          value: store$2.xhs_collectCount,
          name: `\u6536\u85cf`
        }];
        const dyPieNumber = [{
          value: store$2.dy_likeCount,
          name: `\u70b9\u8d5e`
        }, {
          value: store$2.dy_CommentCount,
          name: `\u8bc4\u8bba`
        }, {
          value: store$2.dy_followCount,
          name: `\u5173\u6ce8`
        }, {
          value: store$2.dy_collectCount,
          name: `\u6536\u85cf`
        }];
        const allPieNumber = [{
          value: store$2.xhs_likeCount + store$2.dy_likeCount,
          name: `\u70b9\u8d5e`
        }, {
          value: store$2.xhs_CommentCount + store$2.dy_CommentCount,
          name: `\u8bc4\u8bba`
        }, {
          value: store$2.xhs_followCount + store$2.dy_followCount,
          name: `\u5173\u6ce8`
        }, {
          value: store$2.xhs_collectCount + store$2.dy_collectCount,
          name: `\u6536\u85cf`
        }];
        const postData = {
          executeOperationStartTime,
          executeOperationEndTime,
          run_time,
          xhs_keywords_list_str,
          douYin_keywords_list_str,
          workRunPlatform,
          uniqueMinutes,
          xhsNums,
          xhsPieNumber,
          dyPieNumber,
          allPieNumber
        };
        console.log(`\u006d\u0065\u0073\u0073\u0061\u0067\u0065\u0054\u006f\u0052\u0065\u0070\u006f\u0072\u0074\u004d\u0051\u0054\u0054\u0020\u0070\u006f\u0073\u0074\u0044\u0061\u0074\u0061`, JSON.stringify(postData));
        console.log(`\u0054\u0061\u0073\u006b\u0020\u0073\u0074\u006f\u0070\u0070\u0065\u0064`);
        this.conn.messageToReportMQTT({
          "taskId": this.taskId,
          "executeId": this.executeId,
          "status": `\u0072\u0065\u0070\u006f\u0072\u0074`,
          "meta": postData,
          "message": `\u62a5\u544a`
        });
        resolve();
      } catch (e) {
        console.log(`\u0072\u0065\u0070\u006f\u0072\u0074\u0020\u0065`, e);
      }
    });
  }
  /**
   * 等待store 通知 callBackListener
   */
  async reportStop() {
    this.running = false;
    this.paused = false;
    this.callExecuteNotification();
    if (!this.conn) {
      return;
    }
    console.log(`\u0054\u0061\u0073\u006b\u0020\u0073\u0074\u006f\u0070\u0070\u0065\u0064`);
    this.conn.messageToReplyMQTT({
      "taskId": this.taskId,
      "executeId": this.executeId,
      "status": `\u0063\u006f\u006d\u0070\u006c\u0065\u0074\u0065\u0064`,
      "meta": this.getStatus(),
      "message": `\u5df2\u505c\u6b62`
    });
    storageUtil.removeListener(this.callBackListener);
    super.baseReportStop();
  }
  getStatus() {
    return {
      id: this.taskId,
      running: this.running,
      paused: this.paused,
      started: this.started,
      process: this.operationTime > 0 ? (this.runMinuteTime / this.operationTime * 100).toFixed(2) : 0,
      total_num: this.operationTime,
      executed_num: this.runMinuteTime
    };
  }
  getRunData() {
    if (this.taskPlatform === `\u6296\u97f3`) {
      return {
        viewCount: this.dy_viewCount,
        commentCount: this.dy_CommentCount,
        likeCount: this.dy_likeCount,
        followCount: this.dy_followCount,
        collectCount: this.dy_collectCount,
        operationTime: this.operationTime,
        runMinuteTime: this.runMinuteTime
      };
    } else if (this.taskPlatform === `\u5c0f\u7ea2\u4e66`) {
      return {
        likeCount: this.xhs_likeCount,
        followCount: this.xhs_followCount,
        commentCount: this.xhs_CommentCount,
        collectCount: this.xhs_collectCount,
        viewCount: this.xhs_viewCount,
        operationTime: this.operationTime,
        runMinuteTime: this.runMinuteTime
      };
    }
  }
  reportReply() {
    console.log(`\u0072\u0065\u0070\u006f\u0072\u0074\u0052\u0065\u0070\u006c\u0079`);
    if (!this.conn) {
      return;
    }
    this.conn.messageToReplyMQTT({
      "taskId": this.taskId,
      "executeId": this.executeId,
      "status": `\u0072\u0075\u006e\u006e\u0069\u006e\u0067`,
      "meta": this.getStatus(),
      "message": ``
    });
  }
  loadFromStorage() {
    if (this.startLoad) {
      console.log(`\u0073\u0074\u0061\u0072\u0074\u004c\u006f\u0061\u0064`, this.startLoad);
      return;
    }
    this.startLoad = true;
    chrome.storage.local.get([`\u0074\u0061\u0073\u006b\u0050\u006c\u0061\u0074\u0066\u006f\u0072\u006d`, `\u0058\u0069\u0061\u006f\u0048\u006f\u006e\u0067\u0053\u0068\u0075\u005f\u0053\u0065\u0074\u0074\u0069\u006e\u0067`, `\u0078\u0068\u0073\u005f\u0076\u0069\u0065\u0077\u0043\u006f\u0075\u006e\u0074`, `\u0078\u0068\u0073\u005f\u0043\u006f\u006d\u006d\u0065\u006e\u0074\u0043\u006f\u0075\u006e\u0074`, `\u0078\u0068\u0073\u005f\u006c\u0069\u006b\u0065\u0043\u006f\u0075\u006e\u0074`, `\u0078\u0068\u0073\u005f\u0066\u006f\u006c\u006c\u006f\u0077\u0043\u006f\u0075\u006e\u0074`, `\u0078\u0068\u0073\u005f\u0063\u006f\u006c\u006c\u0065\u0063\u0074\u0043\u006f\u0075\u006e\u0074`, `\u0064\u0079\u005f\u0076\u0069\u0065\u0077\u0043\u006f\u0075\u006e\u0074`, `\u0064\u0079\u005f\u0043\u006f\u006d\u006d\u0065\u006e\u0074\u0043\u006f\u0075\u006e\u0074`, `\u0064\u0079\u005f\u006c\u0069\u006b\u0065\u0043\u006f\u0075\u006e\u0074`, `\u0064\u0079\u005f\u0066\u006f\u006c\u006c\u006f\u0077\u0043\u006f\u0075\u006e\u0074`, `\u0064\u0079\u005f\u0063\u006f\u006c\u006c\u0065\u0063\u0074\u0043\u006f\u0075\u006e\u0074`, `\u006f\u0070\u0065\u0072\u0061\u0074\u0069\u006f\u006e\u0054\u0069\u006d\u0065`, `\u0075\u0073\u0065\u0072\u0049\u0064`, `\u006f\u0072\u0067\u0049\u0064`, `\u0063\u006c\u0069\u0065\u006e\u0074\u0056\u0069\u0073\u0069\u0074\u006f\u0072\u0049\u0064`, `\u0061\u0063\u0063\u0065\u0073\u0073\u0054\u006f\u006b\u0065\u006e`], result => {
      console.log(`\u0072\u0065\u0073\u0075\u006c\u0074\u0020\u0061\u0063\u0074\u0069\u0076\u0061\u0074\u0065\u0050\u0061\u0067\u0065`, result);
      if (!result) {
        return;
      }
      if (result.userId !== void 0) {
        this.user_id = result.userId;
      }
      if (result.orgId !== void 0) {
        this.orgId = result.orgId;
      }
      if (result.clientVisitorId !== void 0) {
        this.clientVisitorId = result.clientVisitorId;
      }
      if (result.accessToken !== void 0) {
        this.accessToken = result.accessToken;
      }
      if (result.taskPlatform !== void 0) {
        this.taskPlatform = result.taskPlatform;
      }
      if (result.XiaoHongShu_Setting !== void 0) {
        this.XiaoHongShu_Setting = result.XiaoHongShu_Setting ? JSON.parse(result.XiaoHongShu_Setting) : {};
      }
      if (result.xhs_viewCount !== void 0) {
        this.xhs_viewCount = result.xhs_viewCount;
      }
      if (result.xhs_CommentCount !== void 0) {
        this.xhs_CommentCount = result.xhs_CommentCount;
      }
      if (result.xhs_likeCount !== void 0) {
        this.xhs_likeCount = result.xhs_likeCount;
      }
      if (result.xhs_followCount !== void 0) {
        this.xhs_followCount = result.xhs_followCount;
      }
      if (result.xhs_collectCount !== void 0) {
        this.xhs_collectCount = result.xhs_collectCount;
      }
      if (result.dy_viewCount !== void 0) {
        this.dy_viewCount = result.dy_viewCount;
      }
      if (result.dy_CommentCount !== void 0) {
        this.dy_CommentCount = result.dy_CommentCount;
      }
      if (result.dy_likeCount !== void 0) {
        this.dy_likeCount = result.dy_likeCount;
      }
      if (result.dy_followCount !== void 0) {
        this.dy_followCount = result.dy_followCount;
      }
      if (result.dy_collectCount !== void 0) {
        this.dy_collectCount = result.dy_collectCount;
      }
      if (result.operationTime !== void 0) {
        this.operationTime = result.operationTime;
      }
      this.startLoad = true;
      this.loadend = true;
    });
    storageUtil.addHandlers(this.callBackListener);
  }
  getHeartReportData() {}
}
const VITE_CONTENT_API = `\u0068\u0074\u0074\u0070\u0073\u003a\u002f\u002f\u0061\u0067\u0065\u006e\u0074\u002d\u006e\u0065\u0074\u002e\u0070\u0061\u0069\u0074\u006f\u006e\u0067\u0061\u0069\u002e\u006e\u0065\u0074\u002f\u0063\u006f\u006e\u0074\u0065\u006e\u0074`;
const VITE_AGENT_ID = `\u0078\u0069\u0061\u006f\u0073\u0068\u0075\u0074\u0069\u0061\u006f\u002d\u0061\u0075\u0074\u006f\u006d\u0061\u0074\u0069\u0063\u002d\u0065\u0078\u0074\u0065\u006e\u0073\u0069\u006f\u006e`;
const store$1 = UseCounterStore.getInstance();
class XiaoHongShuYangHaoZhuShouTask extends BaseTask {
  constructor(taskId, executeId, data, executeTask2) {
    super(taskId, executeId, data);
    __publicField(this, `\u0065\u0078\u0065\u0063\u0075\u0074\u0065\u0054\u0061\u0073\u006b`);
    //评论数量
    __publicField(this, `\u0078\u0068\u0073\u005f\u0076\u0069\u0065\u0077\u0043\u006f\u0075\u006e\u0074`);
    __publicField(this, `\u0078\u0068\u0073\u005f\u0043\u006f\u006d\u006d\u0065\u006e\u0074\u0043\u006f\u0075\u006e\u0074`);
    __publicField(this, `\u0078\u0068\u0073\u005f\u006c\u0069\u006b\u0065\u0043\u006f\u0075\u006e\u0074`);
    __publicField(this, `\u0078\u0068\u0073\u005f\u0066\u006f\u006c\u006c\u006f\u0077\u0043\u006f\u0075\u006e\u0074`);
    __publicField(this, `\u0078\u0068\u0073\u005f\u0063\u006f\u006c\u006c\u0065\u0063\u0074\u0043\u006f\u0075\u006e\u0074`);
    //评论数量
    __publicField(this, `\u0064\u0079\u005f\u0076\u0069\u0065\u0077\u0043\u006f\u0075\u006e\u0074`);
    __publicField(this, `\u0064\u0079\u005f\u0043\u006f\u006d\u006d\u0065\u006e\u0074\u0043\u006f\u0075\u006e\u0074`);
    __publicField(this, `\u0064\u0079\u005f\u006c\u0069\u006b\u0065\u0043\u006f\u0075\u006e\u0074`);
    __publicField(this, `\u0064\u0079\u005f\u0066\u006f\u006c\u006c\u006f\u0077\u0043\u006f\u0075\u006e\u0074`);
    __publicField(this, `\u0064\u0079\u005f\u0063\u006f\u006c\u006c\u0065\u0063\u0074\u0043\u006f\u0075\u006e\u0074`);
    __publicField(this, `\u0074\u0061\u0073\u006b\u0050\u006c\u0061\u0074\u0066\u006f\u0072\u006d`);
    __publicField(this, `\u0058\u0069\u0061\u006f\u0048\u006f\u006e\u0067\u0053\u0068\u0075\u005f\u0053\u0065\u0074\u0074\u0069\u006e\u0067`);
    __publicField(this, `\u006f\u0070\u0065\u0072\u0061\u0074\u0069\u006f\u006e\u0054\u0069\u006d\u0065`);
    __publicField(this, `\u0072\u0075\u006e\u004d\u0069\u006e\u0075\u0074\u0065\u0054\u0069\u006d\u0065`);
    __publicField(this, `\u0073\u0074\u0061\u0072\u0074\u004c\u006f\u0061\u0064`);
    __publicField(this, `\u006c\u006f\u0061\u0064\u0065\u006e\u0064`);
    // 上报数据
    __publicField(this, `\u0065\u0078\u0065\u0063\u0075\u0074\u0065\u004f\u0070\u0065\u0072\u0061\u0074\u0069\u006f\u006e\u0053\u0074\u0061\u0072\u0074\u0054\u0069\u006d\u0065`);
    __publicField(this, `\u0065\u0078\u0065\u0063\u0075\u0074\u0065\u004f\u0070\u0065\u0072\u0061\u0074\u0069\u006f\u006e\u0045\u006e\u0064\u0054\u0069\u006d\u0065`);
    __publicField(this, `\u0078\u0068\u0073\u005f\u006b\u0065\u0079\u0077\u006f\u0072\u0064\u0073\u005f\u006c\u0069\u0073\u0074`);
    __publicField(this, `\u0064\u006f\u0075\u0059\u0069\u006e\u005f\u006b\u0065\u0079\u0077\u006f\u0072\u0064\u0073\u005f\u006c\u0069\u0073\u0074`);
    __publicField(this, `\u0078\u0068\u0073\u005f\u006d\u0069\u006e\u0075\u0074\u0065`);
    __publicField(this, `\u0064\u0079\u005f\u006d\u0069\u006e\u0075\u0074\u0065`);
    __publicField(this, `\u0072\u0065\u0070\u006f\u0072\u0074\u0052\u0075\u006e\u0044\u0061\u0074\u0061\u0053\u0074\u0061\u0074\u0075\u0073`, async () => {
      var _a;
      console.log(`\u0072\u0065\u0070\u006f\u0072\u0074\u0052\u0075\u006e\u0044\u0061\u0074\u0061\u0053\u0074\u0061\u0074\u0075\u0073`);
      if (!this.conn) {
        return;
      }
      const runData = this.getRunData();
      console.log(`\u0072\u0075\u006e\u0044\u0061\u0074\u0061`, JSON.stringify(runData));
      this.conn.messageToStatusMQTT({
        "taskId": this.taskId,
        "data": runData,
        "userId": this.user_id,
        "terminalId": (_a = this.terminalData) == null ? void 0 : _a.terminalId
      });
    });
    __publicField(this, `\u0072\u0065\u0070\u006f\u0072\u0074\u0052\u0075\u006e\u0044\u0061\u0074\u0061`, async () => {
      var _a;
      const url = VITE_CONTENT_API + `\u002f\u0061\u0070\u0069\u002f\u0063\u006f\u006e\u0074\u0065\u006e\u0074\u002f`;
      const headers = {
        "Content-Type": `\u0061\u0070\u0070\u006c\u0069\u0063\u0061\u0074\u0069\u006f\u006e\u002f\u006a\u0073\u006f\u006e`,
        ...this.addAuthorizationHeader()
        // Ensure this function works in the extension
      };
      try {
        console.log(`\u0072\u0065\u0070\u006f\u0072\u0074\u0052\u0075\u006e\u0044\u0061\u0074\u0061`);
        const runData = this.getRunData();
        console.log(`\u0072\u0075\u006e\u0044\u0061\u0074\u0061`, JSON.stringify(runData));
        const postData = {
          "taskId": this.taskId,
          "data": runData,
          "userId": this.user_id,
          "terminalId": (_a = this.terminalData) == null ? void 0 : _a.terminalId
        };
        const response = await fetch(url, {
          method: `\u0050\u004f\u0053\u0054`,
          headers,
          body: JSON.stringify(postData)
        });
        if (!response.ok) {
          console.log(`\u0075\u0072\u006c\u003a` + url + `\uff0c\u0068\u0065\u0061\u0064\u0065\u0072\u003a` + JSON.stringify(headers) + `\u002c\u0020\u0072\u0065\u0073\u0070\u006f\u006e\u0073\u0065\u0020\u0073\u0074\u0061\u0074\u0075\u0073\u003a` + response.status);
          return;
        }
        const result = await response.json();
        console.log(`\u0075\u0072\u006c\u003a` + url + `\uff0c\u0068\u0065\u0061\u0064\u0065\u0072\u003a` + JSON.stringify(headers) + `\u002c\u0070\u006f\u0073\u0074\u0044\u0061\u0074\u0061\uff1a` + JSON.stringify(postData) + `\u0020\u0072\u0065\u0073\u0070\u006f\u006e\u0073\u0065\u0020\u0073\u0074\u0061\u0074\u0075\u0073\u003a` + response.status + `\u002c\u0020\u0072\u0065\u0073\u0070\u006f\u006e\u0073\u0065\u0020\u0064\u0061\u0074\u0061\u003a` + JSON.stringify(result));
      } catch (error) {
        console.log(`\u0045\u0072\u0072\u006f\u0072\u0020\u0069\u006e\u0020\u0070\u0075\u0074\u004e\u0065\u0077\u0054\u0061\u0073\u006b\u003a`, error);
        sendLog(`\u0075\u0072\u006c\u003a` + url + `\uff0c\u0068\u0065\u0061\u0064\u0065\u0072\u003a` + JSON.stringify(headers) + `\u002c\u0020\u0065\u0072\u0072\u006f\u0072` + error);
      }
    });
    __publicField(this, `\u0063\u0061\u006c\u006c\u0042\u0061\u0063\u006b\u004c\u0069\u0073\u0074\u0065\u006e\u0065\u0072`, (changes, namespace) => {
      for (let [key, {
        oldValue,
        newValue
      }] of Object.entries(changes)) {
        console.log(`\u0063\u0075\u0073\u0074\u006f\u006d\u0069\u007a\u0065\u0054\u0061\u0073\u006b\u0020\u0053\u0074\u006f\u0072\u0061\u0067\u0065\u0020\u006b\u0065\u0079\u0020\u0022${key}\u0022\u0020\u0069\u006e\u0020\u006e\u0061\u006d\u0065\u0073\u0070\u0061\u0063\u0065\u0020\u0022${namespace}\u0022\u0020\u0063\u0068\u0061\u006e\u0067\u0065\u0064\u002e`, `\u004f\u006c\u0064\u0020\u0076\u0061\u006c\u0075\u0065\u0020\u0077\u0061\u0073\u0020\u0022${oldValue}\u0022\u002c\u0020\u006e\u0065\u0077\u0020\u0076\u0061\u006c\u0075\u0065\u0020\u0069\u0073\u0020\u0022${newValue}\u0022\u002e`);
        switch (key) {
          case `\u0072\u0075\u006e\u0054\u0061\u0073\u006b\u0053\u0074\u006f\u0070\u0070\u0065\u0064`:
            if (newValue == `\u0065\u006e\u0064`) {
              this.reportStop().then(() => {});
            }
            break;
          case `\u0074\u0061\u0073\u006b\u0050\u006c\u0061\u0074\u0066\u006f\u0072\u006d`:
            this.taskPlatform = newValue;
            break;
          case `\u0058\u0069\u0061\u006f\u0048\u006f\u006e\u0067\u0053\u0068\u0075\u005f\u0053\u0065\u0074\u0074\u0069\u006e\u0067`:
            this.XiaoHongShu_Setting = newValue ? JSON.parse(newValue) : {};
            break;
          case `\u006f\u0072\u0067\u0049\u0064`:
            this.orgId = newValue;
            break;
          case `\u0075\u0073\u0065\u0072\u0049\u0064`:
            this.user_id = newValue;
            break;
          case `\u0063\u006c\u0069\u0065\u006e\u0074\u0056\u0069\u0073\u0069\u0074\u006f\u0072\u0049\u0064`:
            this.clientVisitorId = newValue;
            break;
          case `\u0061\u0063\u0063\u0065\u0073\u0073\u0054\u006f\u006b\u0065\u006e`:
            this.accessToken = newValue;
            break;
          case `\u006f\u0070\u0065\u0072\u0061\u0074\u0069\u006f\u006e\u0054\u0069\u006d\u0065`:
            this.operationTime = newValue;
            break;
          case `\u0072\u0075\u006e\u004d\u0069\u006e\u0075\u0074\u0065\u0054\u0069\u006d\u0065`:
            this.runMinuteTime = newValue;
            this.reportReply();
            break;
          case `\u0078\u0068\u0073\u005f\u006c\u0069\u006b\u0065\u0043\u006f\u0075\u006e\u0074`:
            this.xhs_likeCount = newValue;
            this.reportRunDataStatus().then();
            break;
          case `\u0078\u0068\u0073\u005f\u0066\u006f\u006c\u006c\u006f\u0077\u0043\u006f\u0075\u006e\u0074`:
            this.xhs_followCount = newValue;
            this.reportRunDataStatus().then();
            break;
          case `\u0078\u0068\u0073\u005f\u0043\u006f\u006d\u006d\u0065\u006e\u0074\u0043\u006f\u0075\u006e\u0074`:
            this.xhs_CommentCount = newValue;
            this.reportRunDataStatus().then();
            break;
          case `\u0078\u0068\u0073\u005f\u0063\u006f\u006c\u006c\u0065\u0063\u0074\u0043\u006f\u0075\u006e\u0074`:
            this.xhs_collectCount = newValue;
            this.reportRunDataStatus().then();
            break;
          case `\u0078\u0068\u0073\u005f\u0076\u0069\u0065\u0077\u0043\u006f\u0075\u006e\u0074`:
            this.xhs_viewCount = newValue;
            this.reportRunDataStatus().then();
            break;
          case `\u0064\u0079\u005f\u006c\u0069\u006b\u0065\u0043\u006f\u0075\u006e\u0074`:
            this.dy_likeCount = newValue;
            this.reportRunDataStatus().then();
            break;
          case `\u0064\u0079\u005f\u0066\u006f\u006c\u006c\u006f\u0077\u0043\u006f\u0075\u006e\u0074`:
            this.dy_followCount = newValue;
            this.reportRunDataStatus().then();
            break;
          case `\u0064\u0079\u005f\u0043\u006f\u006d\u006d\u0065\u006e\u0074\u0043\u006f\u0075\u006e\u0074`:
            this.dy_CommentCount = newValue;
            this.reportRunDataStatus().then();
            break;
          case `\u0064\u0079\u005f\u0063\u006f\u006c\u006c\u0065\u0063\u0074\u0043\u006f\u0075\u006e\u0074`:
            this.dy_collectCount = newValue;
            this.reportRunDataStatus().then();
            break;
          case `\u0064\u0079\u005f\u0076\u0069\u0065\u0077\u0043\u006f\u0075\u006e\u0074`:
            this.dy_viewCount = newValue;
            this.reportRunDataStatus().then();
            break;
          case `\u0065\u0078\u0065\u0063\u0075\u0074\u0065\u004f\u0070\u0065\u0072\u0061\u0074\u0069\u006f\u006e\u0053\u0074\u0061\u0072\u0074\u0054\u0069\u006d\u0065`:
            this.executeOperationStartTime = newValue;
            break;
          case `\u0065\u0078\u0065\u0063\u0075\u0074\u0065\u004f\u0070\u0065\u0072\u0061\u0074\u0069\u006f\u006e\u0045\u006e\u0064\u0054\u0069\u006d\u0065`:
            this.executeOperationEndTime = newValue;
            break;
          case `\u0078\u0068\u0073\u005f\u006b\u0065\u0079\u0077\u006f\u0072\u0064\u0073\u005f\u006c\u0069\u0073\u0074`:
            this.xhs_keywords_list = newValue ? JSON.parse(newValue) : [];
            break;
          case `\u0064\u006f\u0075\u0059\u0069\u006e\u005f\u006b\u0065\u0079\u0077\u006f\u0072\u0064\u0073\u005f\u006c\u0069\u0073\u0074`:
            this.douYin_keywords_list = newValue ? JSON.parse(newValue) : [];
            break;
          case `\u0078\u0068\u0073\u005f\u006d\u0069\u006e\u0075\u0074\u0065`:
            this.xhs_minute = newValue ? JSON.parse(newValue) : [];
            break;
          case `\u0064\u0079\u005f\u006d\u0069\u006e\u0075\u0074\u0065`:
            this.dy_minute = newValue ? JSON.parse(newValue) : [];
            break;
        }
      }
    });
    this.startLoad = false;
    this.loadend = false;
    this.xhs_viewCount = 0;
    this.xhs_CommentCount = 0;
    this.xhs_likeCount = 0;
    this.xhs_followCount = 0;
    this.xhs_collectCount = 0;
    this.dy_viewCount = 0;
    this.dy_CommentCount = 0;
    this.dy_likeCount = 0;
    this.dy_followCount = 0;
    this.dy_collectCount = 0;
    this.operationTime = 0;
    this.runMinuteTime = 0;
    this.taskPlatform = ``;
    this.XiaoHongShu_Setting = ``;
    this.executeTask = executeTask2;
    this.executeOperationStartTime = 0;
    this.executeOperationEndTime = 0;
    this.xhs_keywords_list = [];
    this.douYin_keywords_list = [];
    this.xhs_minute = [];
    this.dy_minute = [];
    this.loadFromStorage();
  }
  /**
   * 检查配置是否正确
   */
  checkConfig() {
    return true;
  }
  startTask() {
    return new Promise(async resolve => {
      const validationError = this.validateParameters();
      if (!this.conn) {
        resolve();
        return;
      }
      if (validationError) {
        console.error(validationError.message);
        this.conn.messageToReplyMQTT({
          "taskId": this.taskId,
          "executeId": this.executeId,
          "status": `\u0066\u0061\u0069\u006c\u0065\u0064`,
          "meta": {},
          "message": validationError.message
        });
        resolve();
        return;
      }
      console.log(`\u0044\u006f\u0020\u0061\u0020\u0063\u0075\u0073\u0074\u006f\u006d\u0069\u007a\u0065\u0020\u0074\u0061\u0073\u006b\u0021`);
      await this.my_execute(this.data);
      this.conn.messageToReplyMQTT({
        "taskId": this.taskId,
        "executeId": this.executeId,
        "status": `\u0072\u0075\u006e\u006e\u0069\u006e\u0067`,
        "meta": this.getStatus(),
        "message": ``
      });
      resolve();
    });
  }
  validateParameters() {
    if (!this.data) {
      return {
        message: `\u53c2\u6570\u672a\u4f20\u9012\u6216\u683c\u5f0f\u4e0d\u6b63\u786e`
      };
    }
    return null;
  }
  async my_execute(config) {
    var _a;
    chrome.storage.local.set({
      "runTaskStopped": ``
    });
    chrome.storage.local.set({
      "mqttStart": `\u006f\u006b`
    });
    chrome.storage.local.set({
      "xhs_viewCount": 0
    });
    chrome.storage.local.set({
      "xhs_CommentCount": 0
    });
    chrome.storage.local.set({
      "xhs_likeCount": 0
    });
    chrome.storage.local.set({
      "xhs_followCount": 0
    });
    chrome.storage.local.set({
      "xhs_collectCount": 0
    });
    chrome.storage.local.set({
      "dy_viewCount": 0
    });
    chrome.storage.local.set({
      "dy_CommentCount": 0
    });
    chrome.storage.local.set({
      "dy_likeCount": 0
    });
    chrome.storage.local.set({
      "dy_followCount": 0
    });
    chrome.storage.local.set({
      "dy_collectCount": 0
    });
    chrome.storage.local.set({
      "XiaoHongShu_search_runNumber": 1
    });
    chrome.storage.local.set({
      "activatePage": runPages[0]
    });
    chrome.storage.local.set({
      "operationTime": 0
    });
    chrome.storage.local.set({
      "xiaoHongShuAccountErrorTip": ``
    });
    chrome.storage.local.set({
      "xhs_keywords_list": JSON.stringify([])
    });
    chrome.storage.local.set({
      "douYin_keywords_list": JSON.stringify([])
    });
    chrome.storage.local.set({
      "xhs_minute": JSON.stringify([])
    });
    chrome.storage.local.set({
      "dy_minute": JSON.stringify([])
    });
    chrome.storage.local.set({
      "optionsPageName": ``
    });
    chrome.storage.local.set({
      "executeOperationStartTime": (/* @__PURE__ */new Date()).getTime()
    });
    chrome.storage.local.set({
      "XiaoHongShu_Setting": JSON.stringify(config)
    });
    if (!this.XiaoHongShu_Setting) {
      this.XiaoHongShu_Setting = config;
    }
    if (config.workDouYinPlatform == `\u6296\u97f3`) {
      if (!this.taskPlatform) {
        this.taskPlatform = config.workDouYinPlatform;
      }
      const saveTaskDataResult = await saveTaskData({
        task_options: {
          taskId: this.taskId,
          executeId: this.executeId,
          agentId: VITE_AGENT_ID,
          terminalId: (_a = store$1.terminalData) == null ? void 0 : _a.terminalId
        }
      });
      console.log(`\u0073\u0061\u0076\u0065\u0054\u0061\u0073\u006b\u0044\u0061\u0074\u0061\u0052\u0065\u0073\u0075\u006c\u0074`, saveTaskDataResult);
      if (saveTaskDataResult && saveTaskDataResult.code == 0) {
        store$1.setQuestTaskId(saveTaskDataResult.data.id);
      }
      this.executeTask({
        action: `\u0065\u0078\u0065\u0063\u0075\u0074\u0065\u0054\u0061\u0073\u006b`,
        url: `\u0068\u0074\u0074\u0070\u0073\u003a\u002f\u002f\u0077\u0077\u0077\u002e\u0064\u006f\u0075\u0079\u0069\u006e\u002e\u0063\u006f\u006d`,
        taskName: config.workType,
        taskPlatform: config.workDouYinPlatform,
        taskId: this.taskId
      }, {}, res => {
        if (res && res.tabId) {
          this.tabId = res.tabId;
        }
        if (res && res.windowId) {
          this.windowId = res.windowId;
        }
        console.log(`\u0065\u0078\u0065\u0063\u0075\u0074\u0065\u0054\u0061\u0073\u006b\u0020\u0072\u0065\u0073`, res);
      });
    }
    if (config.workXiaoHongShuPlatform == `\u5c0f\u7ea2\u4e66`) {
      this.executeTask({
        action: `\u0065\u0078\u0065\u0063\u0075\u0074\u0065\u0054\u0061\u0073\u006b`,
        url: `\u0068\u0074\u0074\u0070\u0073\u003a\u002f\u002f\u0077\u0077\u0077\u002e\u0078\u0069\u0061\u006f\u0068\u006f\u006e\u0067\u0073\u0068\u0075\u002e\u0063\u006f\u006d\u002f\u0065\u0078\u0070\u006c\u006f\u0072\u0065`,
        taskName: config.workType,
        taskPlatform: config.workXiaoHongShuPlatform,
        taskId: this.taskId
      }, {}, res => {
        if (res && res.tabId) {
          this.tabId = res.tabId;
        }
        if (res && res.windowId) {
          this.windowId = res.windowId;
        }
        console.log(`\u0065\u0078\u0065\u0063\u0075\u0074\u0065\u0054\u0061\u0073\u006b\u0020\u0072\u0065\u0073`, res);
      });
      if (!this.taskPlatform) {
        this.taskPlatform = config.workXiaoHongShuPlatform;
      }
    }
  }
  stopTask() {
    return new Promise(resolve => {
      sendLog(`\u0064\u006f\u0075\u0059\u0069\u006e\u0059\u0061\u006e\u0067\u0048\u0061\u006f\u005a\u0068\u0075\u0053\u0068\u006f\u0075\u0054\u0061\u0073\u006b\u0020\u0062\u0061\u0063\u006b\u0067\u0072\u006f\u0075\u006e\u0064\u0020\u0061\u0063\u0074\u0069\u0076\u0061\u0074\u0065\u0050\u0061\u0067\u0065\u0020\uff1a`, indexPage);
      chrome.storage.local.set({
        "activatePage": indexPage
      });
      resolve();
    });
  }
  abortTask() {
    return new Promise(resolve => {
      this.reportStop().then(() => {});
      resolve();
    });
  }
  report() {
    return new Promise(resolve => {
      console.log(`\u0072\u0065\u0070\u006f\u0072\u0074\u0020\u0050\u0072\u006f\u006d\u0069\u0073\u0065`);
      try {
        let formatTimestamp = function (timestamp) {
            const date = new Date(timestamp);
            const month = String(date.getMonth() + 1).padStart(2, `\u0030`);
            const day = String(date.getDate()).padStart(2, `\u0030`);
            const hours = String(date.getHours()).padStart(2, `\u0030`);
            const minutes = String(date.getMinutes()).padStart(2, `\u0030`);
            return `${month}\u002d${day}\u0020${hours}\u003a${minutes}`;
          },
          calculateTimeDifference = function (startTimestamp, endTimestamp) {
            const differenceInMs = Math.abs(endTimestamp - startTimestamp);
            const totalMinutes = Math.floor(differenceInMs / (1e3 * 60));
            return `${totalMinutes}`;
          };
        if (!this.conn) {
          resolve();
          return;
        }
        const executeOperationStartTime = formatTimestamp(this.executeOperationStartTime);
        const executeOperationEndTime = formatTimestamp(this.executeOperationEndTime);
        const run_time = calculateTimeDifference(this.executeOperationStartTime, this.executeOperationEndTime);
        let xhs_keywords_list_str = ``;
        if (this.xhs_keywords_list.length > 0) {
          xhs_keywords_list_str = this.xhs_keywords_list.join(`\uff0c`);
        }
        let douYin_keywords_list_str = ``;
        if (this.douYin_keywords_list.length > 0) {
          douYin_keywords_list_str = this.douYin_keywords_list.join(`\uff0c`);
        }
        let XiaoHongShu_Setting = this.XiaoHongShu_Setting;
        let workRunPlatform = ``;
        if (XiaoHongShu_Setting.workDouYinPlatform) {
          if (!workRunPlatform) {
            workRunPlatform = XiaoHongShu_Setting.workDouYinPlatform;
          } else {
            workRunPlatform += `\u002b` + XiaoHongShu_Setting.workDouYinPlatform;
          }
        }
        if (XiaoHongShu_Setting.workXiaoHongShuPlatform) {
          if (!workRunPlatform) {
            workRunPlatform = XiaoHongShu_Setting.workXiaoHongShuPlatform;
          } else {
            workRunPlatform += `\u002b` + XiaoHongShu_Setting.workXiaoHongShuPlatform;
          }
        }
        const uniqueMinutes = [... /* @__PURE__ */new Set([...this.xhs_minute.map(item => item.minute), ...this.dy_minute.map(item => item.minute)])].sort((a, b) => a - b);
        const xhsNums = uniqueMinutes.map(minute => {
          var _a;
          return ((_a = this.xhs_minute.find(item => item.minute === minute)) == null ? void 0 : _a.num) || 0;
        });
        const xhsPieNumber = [{
          value: store$1.xhs_likeCount,
          name: `\u70b9\u8d5e`
        }, {
          value: store$1.xhs_CommentCount,
          name: `\u8bc4\u8bba`
        }, {
          value: store$1.xhs_followCount,
          name: `\u5173\u6ce8`
        }, {
          value: store$1.xhs_collectCount,
          name: `\u6536\u85cf`
        }];
        const dyPieNumber = [{
          value: store$1.dy_likeCount,
          name: `\u70b9\u8d5e`
        }, {
          value: store$1.dy_CommentCount,
          name: `\u8bc4\u8bba`
        }, {
          value: store$1.dy_followCount,
          name: `\u5173\u6ce8`
        }, {
          value: store$1.dy_collectCount,
          name: `\u6536\u85cf`
        }];
        const allPieNumber = [{
          value: store$1.xhs_likeCount + store$1.dy_likeCount,
          name: `\u70b9\u8d5e`
        }, {
          value: store$1.xhs_CommentCount + store$1.dy_CommentCount,
          name: `\u8bc4\u8bba`
        }, {
          value: store$1.xhs_followCount + store$1.dy_followCount,
          name: `\u5173\u6ce8`
        }, {
          value: store$1.xhs_collectCount + store$1.dy_collectCount,
          name: `\u6536\u85cf`
        }];
        const postData = {
          executeOperationStartTime,
          executeOperationEndTime,
          run_time,
          xhs_keywords_list_str,
          douYin_keywords_list_str,
          workRunPlatform,
          uniqueMinutes,
          xhsNums,
          xhsPieNumber,
          dyPieNumber,
          allPieNumber
        };
        console.log(`\u006d\u0065\u0073\u0073\u0061\u0067\u0065\u0054\u006f\u0052\u0065\u0070\u006f\u0072\u0074\u004d\u0051\u0054\u0054\u0020\u0070\u006f\u0073\u0074\u0044\u0061\u0074\u0061`, JSON.stringify(postData));
        sendLog(`\u0054\u0061\u0073\u006b\u0020\u0073\u0074\u006f\u0070\u0070\u0065\u0064`);
        this.conn.messageToReportMQTT({
          "taskId": this.taskId,
          "executeId": this.executeId,
          "status": `\u0072\u0065\u0070\u006f\u0072\u0074`,
          "meta": postData,
          "message": `\u62a5\u544a`
        });
        resolve();
      } catch (e) {
        console.log(`\u0072\u0065\u0070\u006f\u0072\u0074\u0020\u0065`, e);
      }
    });
  }
  /**
   * 获取心跳上报数据
   */
  getHeartReportData() {
    return {};
  }
  /**
   * 等待store 通知 callBackListener
   */
  async reportStop() {
    this.running = false;
    this.paused = false;
    this.callExecuteNotification();
    if (!this.conn) {
      return;
    }
    sendLog(`\u0054\u0061\u0073\u006b\u0020\u0073\u0074\u006f\u0070\u0070\u0065\u0064`);
    this.conn.messageToReplyMQTT({
      "taskId": this.taskId,
      "executeId": this.executeId,
      "status": `\u0063\u006f\u006d\u0070\u006c\u0065\u0074\u0065\u0064`,
      "meta": this.getStatus(),
      "message": `\u5df2\u505c\u6b62`
    });
    storageUtil.removeListener(this.callBackListener);
    super.baseReportStop();
  }
  getStatus() {
    return {
      id: this.taskId,
      running: this.running,
      paused: this.paused,
      started: this.started,
      process: this.operationTime > 0 ? (this.runMinuteTime / this.operationTime * 100).toFixed(2) : 0,
      total_num: this.operationTime,
      executed_num: this.runMinuteTime
    };
  }
  getRunData() {
    if (this.taskPlatform === `\u6296\u97f3`) {
      return {
        viewCount: this.dy_viewCount,
        commentCount: this.dy_CommentCount,
        likeCount: this.dy_likeCount,
        followCount: this.dy_followCount,
        collectCount: this.dy_collectCount,
        operationTime: this.operationTime,
        runMinuteTime: this.runMinuteTime
      };
    } else if (this.taskPlatform === `\u5c0f\u7ea2\u4e66`) {
      return {
        likeCount: this.xhs_likeCount,
        followCount: this.xhs_followCount,
        commentCount: this.xhs_CommentCount,
        collectCount: this.xhs_collectCount,
        viewCount: this.xhs_viewCount,
        operationTime: this.operationTime,
        runMinuteTime: this.runMinuteTime
      };
    }
  }
  reportReply() {
    console.log(`\u0072\u0065\u0070\u006f\u0072\u0074\u0052\u0065\u0070\u006c\u0079`);
    if (!this.conn) {
      return;
    }
    this.conn.messageToReplyMQTT({
      "taskId": this.taskId,
      "executeId": this.executeId,
      "status": `\u0072\u0075\u006e\u006e\u0069\u006e\u0067`,
      "meta": this.getStatus(),
      "message": ``
    });
  }
  loadFromStorage() {
    if (this.startLoad) {
      console.log(`\u0073\u0074\u0061\u0072\u0074\u004c\u006f\u0061\u0064`, this.startLoad);
      return;
    }
    this.startLoad = true;
    chrome.storage.local.get([`\u0074\u0061\u0073\u006b\u0050\u006c\u0061\u0074\u0066\u006f\u0072\u006d`, `\u0058\u0069\u0061\u006f\u0048\u006f\u006e\u0067\u0053\u0068\u0075\u005f\u0053\u0065\u0074\u0074\u0069\u006e\u0067`, `\u0078\u0068\u0073\u005f\u0076\u0069\u0065\u0077\u0043\u006f\u0075\u006e\u0074`, `\u0078\u0068\u0073\u005f\u0043\u006f\u006d\u006d\u0065\u006e\u0074\u0043\u006f\u0075\u006e\u0074`, `\u0078\u0068\u0073\u005f\u006c\u0069\u006b\u0065\u0043\u006f\u0075\u006e\u0074`, `\u0078\u0068\u0073\u005f\u0066\u006f\u006c\u006c\u006f\u0077\u0043\u006f\u0075\u006e\u0074`, `\u0078\u0068\u0073\u005f\u0063\u006f\u006c\u006c\u0065\u0063\u0074\u0043\u006f\u0075\u006e\u0074`, `\u0064\u0079\u005f\u0076\u0069\u0065\u0077\u0043\u006f\u0075\u006e\u0074`, `\u0064\u0079\u005f\u0043\u006f\u006d\u006d\u0065\u006e\u0074\u0043\u006f\u0075\u006e\u0074`, `\u0064\u0079\u005f\u006c\u0069\u006b\u0065\u0043\u006f\u0075\u006e\u0074`, `\u0064\u0079\u005f\u0066\u006f\u006c\u006c\u006f\u0077\u0043\u006f\u0075\u006e\u0074`, `\u0064\u0079\u005f\u0063\u006f\u006c\u006c\u0065\u0063\u0074\u0043\u006f\u0075\u006e\u0074`, `\u006f\u0070\u0065\u0072\u0061\u0074\u0069\u006f\u006e\u0054\u0069\u006d\u0065`, `\u0075\u0073\u0065\u0072\u0049\u0064`, `\u006f\u0072\u0067\u0049\u0064`, `\u0063\u006c\u0069\u0065\u006e\u0074\u0056\u0069\u0073\u0069\u0074\u006f\u0072\u0049\u0064`, `\u0061\u0063\u0063\u0065\u0073\u0073\u0054\u006f\u006b\u0065\u006e`], result => {
      console.log(`\u0072\u0065\u0073\u0075\u006c\u0074\u0020\u0061\u0063\u0074\u0069\u0076\u0061\u0074\u0065\u0050\u0061\u0067\u0065`, result);
      if (!result) {
        return;
      }
      if (result.userId !== void 0) {
        this.user_id = result.userId;
      }
      if (result.orgId !== void 0) {
        this.orgId = result.orgId;
      }
      if (result.clientVisitorId !== void 0) {
        this.clientVisitorId = result.clientVisitorId;
      }
      if (result.accessToken !== void 0) {
        this.accessToken = result.accessToken;
      }
      if (result.taskPlatform !== void 0) {
        this.taskPlatform = result.taskPlatform;
      }
      if (result.XiaoHongShu_Setting !== void 0) {
        this.XiaoHongShu_Setting = result.XiaoHongShu_Setting ? JSON.parse(result.XiaoHongShu_Setting) : {};
      }
      if (result.xhs_viewCount !== void 0) {
        this.xhs_viewCount = result.xhs_viewCount;
      }
      if (result.xhs_CommentCount !== void 0) {
        this.xhs_CommentCount = result.xhs_CommentCount;
      }
      if (result.xhs_likeCount !== void 0) {
        this.xhs_likeCount = result.xhs_likeCount;
      }
      if (result.xhs_followCount !== void 0) {
        this.xhs_followCount = result.xhs_followCount;
      }
      if (result.xhs_collectCount !== void 0) {
        this.xhs_collectCount = result.xhs_collectCount;
      }
      if (result.dy_viewCount !== void 0) {
        this.dy_viewCount = result.dy_viewCount;
      }
      if (result.dy_CommentCount !== void 0) {
        this.dy_CommentCount = result.dy_CommentCount;
      }
      if (result.dy_likeCount !== void 0) {
        this.dy_likeCount = result.dy_likeCount;
      }
      if (result.dy_followCount !== void 0) {
        this.dy_followCount = result.dy_followCount;
      }
      if (result.dy_collectCount !== void 0) {
        this.dy_collectCount = result.dy_collectCount;
      }
      if (result.operationTime !== void 0) {
        this.operationTime = result.operationTime;
      }
      this.startLoad = true;
      this.loadend = true;
    });
    storageUtil.addHandlers(this.callBackListener);
  }
}
const store = UseCounterStore.getInstance();
console.log(`\u0074\u0068\u0069\u0073\u0020\u0069\u0073\u0020\u0062\u0061\u0063\u006b\u0067\u0072\u006f\u0075\u006e\u0064\u0020\u0073\u0065\u0072\u0076\u0069\u0063\u0065\u002d\u0077\u006f\u0072\u006b\u0065\u0072\u002e\u0074\u0073\u0020\u0066\u0069\u006c\u0065`);
const manifest = chrome.runtime.getManifest();
console.log(`\u0063\u006f\u006e\u0074\u0065\u006e\u0074\u005f\u0073\u0063\u0072\u0069\u0070\u0074\u0073`, manifest && manifest.content_scripts);
const activeDebuggerSessions = {};
const changedCallBack = (changes, namespace) => {
  for (let [key, {
    oldValue,
    newValue
  }] of Object.entries(changes)) {
    console.log(`\u0053\u0074\u006f\u0072\u0061\u0067\u0065\u0020\u006b\u0065\u0079\u0020\u0022${key}\u0022\u0020\u0069\u006e\u0020\u006e\u0061\u006d\u0065\u0073\u0070\u0061\u0063\u0065\u0020\u0022${namespace}\u0022\u0020\u0063\u0068\u0061\u006e\u0067\u0065\u0064\u002e`, `\u004f\u006c\u0064\u0020\u0076\u0061\u006c\u0075\u0065\u0020\u0077\u0061\u0073\u0020\u0022${oldValue}\u0022\u002c\u0020\u006e\u0065\u0077\u0020\u0076\u0061\u006c\u0075\u0065\u0020\u0069\u0073\u0020\u0022${newValue}\u0022\u002e`);
    switch (key) {
      case `\u0074\u0061\u0073\u006b\u0043\u006f\u006d\u0070\u006c\u0065\u0074\u0065\u0044\u0061\u0074\u0061`:
        if (newValue) {
          try {
            const newValueJson = JSON.parse(newValue);
            if (newValueJson && Object.keys(newValueJson).length > 0) {
              const key2 = parseInt(Object.keys(newValueJson)[0], 10);
              if (!isNaN(key2)) {
                delete activeDebuggerSessions[key2];
              }
            } else {
              console.log(`\u4e0d\u5b58\u5728\u8fd9\u4e2a\u0074\u0061\u0062\u0049\u0064`, newValue);
            }
          } catch (e) {
            console.log(`\u006e\u0065\u0077\u0056\u0061\u006c\u0075\u0065\u004a\u0073\u006f\u006e\u0020\u0065\u0072\u0072\u006f\u0072`, newValue);
          }
        } else {
          console.log(`\u0074\u0061\u0073\u006b\u0043\u006f\u006d\u0070\u006c\u0065\u0074\u0065\u0044\u0061\u0074\u0061\u0020\u006e\u0065\u0077\u0056\u0061\u006c\u0075\u0065\u0020\u4e3a\u7a7a`);
        }
        break;
    }
  }
};
storageUtil.addHandlers(changedCallBack);
storageUtil.startOnChangedListener();
console.log(`\u006d\u0071\u0074\u0074\u004d\u0061\u006e\u0061\u0067\u0065\u002e\u0075\u0073\u0065\u0072\u0049\u0064`, mqttManage.userId);
const taskManager = new TaskManager();
const createTask = (taskId, executeId, stopTaskBool, baseTask) => {
  taskManager.stopRunTasks(stopTaskBool).then().finally(() => {
    mqttManage.messageToReplyMQTT({
      "taskId": taskId,
      "executeId": executeId,
      "status": `\u0071\u0075\u0065\u0075\u0065\u0064`,
      "meta": {},
      "message": `\u5df2\u52a0\u5165\u961f\u5217`
    });
    chrome.storage.local.set({
      "taskId": taskId
    }).then(() => {}).finally(() => {
      baseTask.setConn(mqttManage);
      taskManager.addTask(baseTask).then(() => {}).catch(error => {
        console.error(`\u0065\u0072\u0072\u006f\u0072`, error);
      });
    });
  });
};
const chooseCreateTask = (parsedMessage, stopTaskBool) => {
  const config = parsedMessage.data;
  const type = parsedMessage.type;
  const taskId = parsedMessage.taskId;
  const executeId = parsedMessage.executeId;
  let baseTask = null;
  switch (type) {
    case `\u0058\u0069\u0061\u006f\u0068\u006f\u006e\u0067\u0073\u0068\u0075\u0054\u0061\u0073\u006b`:
      baseTask = new ShuJuJianKongCustomizeTask(taskId, executeId, config, executeTask);
      createTask(taskId, executeId, stopTaskBool, baseTask);
      break;
    case `\u0044\u006f\u0075\u0059\u0069\u006e\u0053\u0065\u0061\u0072\u0063\u0068\u0056\u0069\u0064\u0065\u006f\u0054\u0061\u0073\u006b`:
      baseTask = new DouYinSearchVideoTask(taskId, executeId, config, executeTask);
      createTask(taskId, executeId, stopTaskBool, baseTask);
      break;
    case `\u0044\u006f\u0075\u0059\u0069\u006e\u0050\u0075\u0073\u0068\u0054\u0061\u0073\u006b`:
      baseTask = new CustomizeDouYinPushTask(taskId, executeId, config, executeTask);
      createTask(taskId, executeId, stopTaskBool, baseTask);
      break;
    case `\u0044\u006f\u0075\u0059\u0069\u006e\u004b\u0065\u005a\u0069\u0054\u0061\u0073\u006b`:
      baseTask = new DouYinKeZiCustomizeTask(taskId, executeId, config, executeTask);
      createTask(taskId, executeId, stopTaskBool, baseTask);
      break;
    case `\u0044\u006f\u0075\u0059\u0069\u006e\u0059\u0061\u006e\u0067\u0048\u0061\u006f\u005a\u0068\u0075\u0053\u0068\u006f\u0075\u0054\u0061\u0073\u006b`:
      baseTask = new DouYinYangHaoZhuShouTask(taskId, executeId, config, executeTask);
      createTask(taskId, executeId, stopTaskBool, baseTask);
      break;
    case `\u004b\u0075\u0061\u0069\u0053\u0068\u006f\u0075\u0050\u0075\u0073\u0068\u0054\u0061\u0073\u006b`:
      baseTask = new CustomizeKuaiShouPushTask(taskId, executeId, config, executeTask);
      createTask(taskId, executeId, stopTaskBool, baseTask);
      break;
    case `\u004b\u0075\u0061\u0069\u0053\u0068\u006f\u0075\u0059\u0061\u006e\u0067\u0048\u0061\u006f\u005a\u0068\u0075\u0053\u0068\u006f\u0075\u0054\u0061\u0073\u006b`:
      baseTask = new KuaiShouYangHaoZhuShouTask(taskId, executeId, config, executeTask);
      createTask(taskId, executeId, stopTaskBool, baseTask);
      break;
    case `\u0053\u0068\u0069\u0050\u0069\u006e\u0048\u0061\u006f\u004b\u0065\u005a\u0069\u0054\u0061\u0073\u006b`:
      baseTask = new ShipinhaoKeZiCustomizeTask(taskId, executeId, config, executeTask);
      createTask(taskId, executeId, stopTaskBool, baseTask);
      break;
    case `\u0058\u0069\u0061\u006f\u0048\u006f\u006e\u0067\u0053\u0068\u0075\u0041\u0075\u0074\u006f\u0052\u0065\u0070\u006c\u0079\u0054\u0061\u0073\u006b`:
      baseTask = new XiaoHongShuAutoReplyTask(taskId, executeId, config, executeTask);
      createTask(taskId, executeId, stopTaskBool, baseTask);
      break;
    case `\u0058\u0069\u0061\u006f\u0048\u006f\u006e\u0067\u0053\u0068\u0075\u0059\u0061\u006e\u0067\u0048\u0061\u006f\u005a\u0068\u0075\u0053\u0068\u006f\u0075\u0054\u0061\u0073\u006b`:
      baseTask = new XiaoHongShuYangHaoZhuShouTask(taskId, executeId, config, executeTask);
      createTask(taskId, executeId, stopTaskBool, baseTask);
      break;
    default:
      console.error(`\u0055\u006e\u006b\u006e\u006f\u0077\u006e\u0020\u0074\u0079\u0070\u0065`, type);
  }
};
mqttManage.setChooseCreateTask(chooseCreateTask);
mqttManage.registeMessageFromMQTT(async message => {
  chrome.storage.local.set({
    "runLogs": JSON.stringify(message)
  });
  sendLog(`\u6536\u5230\u004d\u0051\u0054\u0054\u6d88\u606f\u003a`, formatNowDateTimeSss(), JSON.stringify(message));
  const parsedMessage = message;
  if (parsedMessage.operation === `\u0063\u006d\u0064`) {
    mqttManage.setRunTaskMqttMessage(JSON.stringify(parsedMessage));
    chooseCreateTask(parsedMessage, true);
    return;
  }
  if (parsedMessage.operation === `\u0073\u0074\u006f\u0070`) {
    const taskId = parsedMessage.taskId;
    taskManager.stopTask(taskId).then(() => {});
    return;
  }
});
const executeTask = (request, sender, sendResponse) => {
  var _a;
  console.log(`\u0072\u0075\u006e\u006e\u0069\u006e\u0067`);
  console.log(`\u0072\u0065\u0071\u0075\u0065\u0073\u0074`, (_a = sender == null ? void 0 : sender.tab) == null ? void 0 : _a.id);
  chrome.system.display.getInfo(displays => {
    const primaryDisplay = displays.find(display => display.isPrimary);
    console.log(`\u0070\u0072\u0069\u006d\u0061\u0072\u0079\u0044\u0069\u0073\u0070\u006c\u0061\u0079`, primaryDisplay);
    if (!primaryDisplay) {
      sendResponse();
      console.log(`\u9000\u51fa`);
      return;
    }
    const screenWidth = primaryDisplay.bounds.width;
    const screenHeight = primaryDisplay.bounds.height;
    const windowWidth = Math.floor(screenWidth * 0.8);
    const windowHeight = Math.floor(screenHeight * 0.8);
    const windowLeft = Math.floor((screenWidth - windowWidth) / 2);
    const windowTop = Math.floor((screenHeight - windowHeight) / 2);
    let url = request.url;
    const createWindowBack = window => {
      requestKeepAwake();
      console.log(`\u0063\u0072\u0065\u0061\u0074\u0065`, window);
      if (window && window.tabs && window.tabs[0].id !== void 0 && window.id !== void 0) {
        const tabId = window.tabs[0].id;
        activeDebuggerSessions[tabId] = {
          windowId: window.id,
          onCompleted: false,
          noCloseRun: request.noCloseRun ? true : false,
          openOptionsPage: true,
          taskComplete: false,
          parentTabId: request.parentTabId,
          tabData: {
            taskName: request.taskName,
            taskPlatform: request.taskPlatform,
            taskId: request == null ? void 0 : request.taskId
          },
          uploadFileList: request.uploadFileList
        };
        console.log(`\u0063\u0072\u0065\u0061\u0074\u0065\u0057\u0069\u006e\u0064\u006f\u0077\u0042\u0061\u0063\u006b\u0020\u6253\u5f00\u7a97\u53e3\u6210\u529f`, {
          tabId,
          windowId: window.id,
          taskId: request == null ? void 0 : request.taskId
        });
        sendResponse({
          windowId: window.id,
          tabId
        });
      } else {
        console.log(`\u6253\u5f00\u7a97\u53e3\u5931\u8d25`, {
          taskId: request == null ? void 0 : request.taskId
        });
        sendResponse();
      }
    };
    const createTabCallback = tab => {
      requestKeepAwake();
      console.log(`\u0063\u0072\u0065\u0061\u0074\u0065`, tab);
      if (tab && tab.id !== void 0 && tab.windowId !== void 0) {
        const tabId = tab.id;
        activeDebuggerSessions[tabId] = {
          windowId: tab.windowId,
          onCompleted: false,
          noCloseRun: false,
          openOptionsPage: true,
          taskComplete: false,
          parentTabId: request.parentTabId,
          tabData: {
            taskName: request.taskName,
            taskPlatform: request.taskPlatform,
            taskId: request == null ? void 0 : request.taskId
          },
          uploadFileList: request.uploadFileList
        };
        console.log(`\u0063\u0072\u0065\u0061\u0074\u0065\u0054\u0061\u0062\u0043\u0061\u006c\u006c\u0062\u0061\u0063\u006b\u0020\u6253\u5f00\u7a97\u53e3\u6210\u529f`, {
          tabId,
          windowId: tab.windowId,
          taskId: request == null ? void 0 : request.taskId
        });
        sendResponse({
          windowId: tab.windowId,
          tabId
        });
      } else {
        console.log(`\u6253\u5f00\u7a97\u53e3\u5931\u8d25`, {
          taskId: request == null ? void 0 : request.taskId
        });
        sendResponse();
      }
    };
    if (request.windowType) {
      const createProperties = {
        url
      };
      if (request.targetWindowId) {
        createProperties[`\u0077\u0069\u006e\u0064\u006f\u0077\u0049\u0064`] = request.targetWindowId;
      }
      chrome.tabs.create(createProperties, createTabCallback);
    } else {
      chrome.windows.create({
        url,
        type: `\u0070\u006f\u0070\u0075\u0070`,
        width: windowWidth,
        height: windowHeight,
        left: windowLeft,
        top: windowTop
      }, createWindowBack);
    }
  });
  return true;
};
chrome.runtime.onMessage.addListener((request, sender, sendResponse) => {
  var _a, _b, _c, _d, _e, _f, _g, _h, _i, _j, _k, _l, _m, _n, _o, _p, _q, _r, _s, _t, _u, _v, _w, _x, _y, _z, _A, _B, _C, _D, _E, _F, _G, _H;
  console.log(`\u0072\u0065\u0071\u0075\u0065\u0073\u0074`, (_a = sender.tab) == null ? void 0 : _a.id, request);
  if (request.action == `\u0072\u0065\u0073\u0074\u0061\u0072\u0074`) {
    if (store.terminalData.terminalId == request.terminalId) {
      for (const sessionId in activeDebuggerSessions) {
        if (activeDebuggerSessions.hasOwnProperty(sessionId)) {
          const session = activeDebuggerSessions[sessionId];
          session.noCloseRun = true;
          console.log(`\u0053\u0065\u0073\u0073\u0069\u006f\u006e\u0020\u0049\u0044\u003a\u0020${sessionId}`, session);
        }
      }
      chrome.runtime.reload();
    }
    sendResponse();
    return false;
  }
  if (request.action == `\u0072\u0065\u0061\u0064\u0079\u0052\u0065\u0073\u0074\u0061\u0072\u0074`) {
    for (const sessionId in activeDebuggerSessions) {
      if (activeDebuggerSessions.hasOwnProperty(sessionId)) {
        const session = activeDebuggerSessions[sessionId];
        session.noCloseRun = true;
        console.log(`\u0053\u0065\u0073\u0073\u0069\u006f\u006e\u0020\u0049\u0044\u003a\u0020${sessionId}`, session);
      }
    }
    sendResponse();
    return false;
  }
  if (request.action == `\u0061\u0075\u0074\u006f\u006c\u006f\u0067\u0069\u006e\u0032`) {
    store.setAccessToken(request.accessToken);
    store.setUserName(request.email);
    store.setUserId(request.userId);
    store.setTenantId(request.tenantId);
    store.setWebUserId(request.webUserId);
    store.setWebUserName(request.webUserName);
    store.setWebUserAvatarUrl(request.webUserAvatarUrl);
    store.setCPUSerialNumber(request.cpuSerialNumber);
    store.setWebPort(parseInt(request.webPort));
    if (request[`\u0074\u0065\u006e\u0061\u006e\u0074\u0049\u0064`]) {
      tenantsMine().then(async tenants_mine_res => {
        var _a2, _b2;
        console.log(`\u0074\u0065\u006e\u0061\u006e\u0074\u0073\u004d\u0069\u006e\u0065`, tenants_mine_res);
        if (tenants_mine_res && tenants_mine_res.data && tenants_mine_res.data.id) {
          store.setTenantId(tenants_mine_res.data.id);
          store.setTenantName(tenants_mine_res.data.name);
        }
        const agentBusinessRes = await agentBusiness(false);
        if (!agentBusinessRes) {
          console.log(`\u0067\u0065\u0074\u004c\u006f\u0067\u0069\u006e\u0054\u006f\u006b\u0065\u006e\u0046\u0075\u006e\u0020\u0061\u0067\u0065\u006e\u0074\u0042\u0075\u0073\u0069\u006e\u0065\u0073\u0073\u002c\u0020\u0073\u0074\u006f\u0072\u0065\u002e\u0074\u0065\u006e\u0061\u006e\u0074\u0049\u0064\u003a` + store.tenantId + `\u002c\u0020\u0061\u0067\u0065\u006e\u0074\u0042\u0075\u0073\u0069\u006e\u0065\u0073\u0073\u0052\u0065\u0073\u003a` + agentBusinessRes);
        }
        if (!((_a2 = store == null ? void 0 : store.terminalData) == null ? void 0 : _a2.terminalId)) {
          sendLog(`\u7ec8\u7aef\u7684\u0069\u0064\u4e3a\u7a7a`);
          return;
        }
        const saveTerminalBindData = {
          "terminal_name": store.webUserName ? store.webUserName : `\u8bf7\u8bbe\u7f6e\u8bbe\u5907\u540d\u79f0`,
          "terminal_info": {
            "webUserName": store.webUserName,
            "webUserAvatarUrl": store.webUserAvatarUrl,
            "webUserId": store.webUserId
          }
        };
        const saveTerminalBindRes = await saveTerminalBind((_b2 = store == null ? void 0 : store.terminalData) == null ? void 0 : _b2.terminalId, saveTerminalBindData);
        sendLog(`\u0061\u0067\u0065\u006e\u0074\u0042\u0075\u0073\u0069\u006e\u0065\u0073\u0073\u0020\u0073\u0061\u0076\u0065\u0054\u0065\u0072\u006d\u0069\u006e\u0061\u006c\u0042\u0069\u006e\u0064\u0052\u0065\u0073\uff1a` + JSON.stringify(saveTerminalBindRes));
        chrome.storage.local.set({
          "optionsPageName": ``
        }).then(res => {
          console.log(`\u0072\u0065\u0073`, res);
        });
      }).catch(error => {
        console.log(`\u0074\u0065\u006e\u0061\u006e\u0074\u0073\u004d\u0069\u006e\u0065\u0020\u0065\u0072\u0072\u006f\u0072`, error);
      }).finally(() => {
        console.log(`\u0074\u0065\u006e\u0061\u006e\u0074\u0073\u004d\u0069\u006e\u0065\u0020\u0066\u0069\u006e\u0061\u006c\u006c\u0079`);
      });
      sendResponse();
      return false;
    } else {
      console.log(`\u0072\u0065\u0071\u0075\u0065\u0073\u0074\u005b\u0027\u0074\u0065\u006e\u0061\u006e\u0074\u0049\u0064\u0027\u005d\u0020\u0069\u0073\u0020\u006e\u0075\u006c\u006c`, request[`\u0074\u0065\u006e\u0061\u006e\u0074\u0049\u0064`]);
    }
    sendResponse();
    return false;
  }
  if (request.action == `\u0075\u0070\u0064\u0061\u0074\u0065\u0053\u0065\u0074\u0054\u0065\u0072\u006d\u0069\u006e\u0061\u006c\u004e\u0061\u006d\u0065`) {
    (async () => {
      var _a2;
      const saveTerminalBindData = {
        "terminal_name": request.terminalName ? request.terminalName : `\u8bf7\u8bbe\u7f6e\u8bbe\u5907\u540d\u79f0`,
        "terminal_info": {
          "webUserName": store.webUserName,
          "webUserAvatarUrl": store.webUserAvatarUrl,
          "webUserId": store.webUserId
        }
      };
      const saveTerminalBindRes = await saveTerminalBind((_a2 = store == null ? void 0 : store.terminalData) == null ? void 0 : _a2.terminalId, saveTerminalBindData);
      sendLog(`\u0061\u0067\u0065\u006e\u0074\u0042\u0075\u0073\u0069\u006e\u0065\u0073\u0073\u0020\u0073\u0061\u0076\u0065\u0054\u0065\u0072\u006d\u0069\u006e\u0061\u006c\u0042\u0069\u006e\u0064\u0052\u0065\u0073\uff1a` + JSON.stringify(saveTerminalBindRes));
    })();
    sendResponse();
    return false;
  }
  if (request.action == `\u0073\u0061\u0076\u0065\u0054\u0065\u0072\u006d\u0069\u006e\u0061\u006c\u0057\u0065\u0062\u0055\u0073\u0065\u0072\u004e\u0061\u006d\u0065`) {
    executeTask(request, sender, sendResponse);
    return true;
  }
  if (request.action === `\u0065\u0078\u0065\u0063\u0075\u0074\u0065\u0054\u0061\u0073\u006b`) {
    request[`\u0074\u0061\u0073\u006b\u0049\u0064`] = (/* @__PURE__ */new Date()).getTime();
    const yt = new LocalCustomizeTask(request[`\u0074\u0061\u0073\u006b\u0049\u0064`], request[`\u0074\u0061\u0073\u006b\u0049\u0064`], `\u0063\u006f\u006e\u0066\u0069\u0067`, executeTask, request, sender, sendResponse);
    yt.setConn(mqttManage);
    taskManager.addTask(yt).then(() => {}).catch(error => {
      console.error(`\u0065\u0072\u0072\u006f\u0072`, error);
    });
    return true;
  }
  if (request.action === `\u0065\u0078\u0065\u0063\u0075\u0074\u0065\u0054\u0061\u0073\u006b\u004e\u006f\u0054\u0061\u0073\u006b`) {
    executeTask(request, sender, sendResponse);
    return true;
  }
  if (request.action === `\u0069\u006e\u0070\u0075\u0074\u004b\u0065\u0079`) {
    const debuggee = {
      tabId: (_b = sender.tab) == null ? void 0 : _b.id
    };
    const sendMessage = () => {
      return new Promise(resolve => {
        console.log(`\u0073\u0065\u006e\u0064\u004d\u0065\u0073\u0073\u0061\u0067\u0065\u0020\u0050\u0072\u006f\u006d\u0069\u0073\u0065`);
        chrome.debugger.attach(debuggee, `\u0031\u002e\u0030`, async () => {
          var _a2, _b2, _c2, _d2, _e2;
          const contentArray = Array.from(request.content);
          console.log(`\u0063\u006f\u006e\u0074\u0065\u006e\u0074\u0041\u0072\u0072\u0061\u0079`, contentArray);
          let index = 0;
          while (true) {
            if (index < contentArray.length) {
              if (!request.keyDown || contentArray[index] !== `\u000a` && contentArray[index] !== `\u000d`) {
                if (request.checkFocus) {
                  await queryActiveElementWhile((_a2 = sender.tab) == null ? void 0 : _a2.id);
                }
                const tabId = (_b2 = sender.tab) == null ? void 0 : _b2.id;
                if (tabId && !activeDebuggerSessions[tabId]) {
                  console.log(`\u7a97\u53e3\u4e0d\u5b58\u5728\u4e86\uff0c\u4e0d\u9700\u8981\u7ee7\u7eed\u8f93\u5165\u4e86`);
                  break;
                }
                let textEvt = {
                  "type": `\u0069\u006e\u0073\u0065\u0072\u0074\u0054\u0065\u0078\u0074`,
                  "text": contentArray[index]
                };
                chrome.debugger.sendCommand({
                  tabId: (_c2 = sender.tab) == null ? void 0 : _c2.id
                }, `\u0049\u006e\u0070\u0075\u0074\u002e\u0069\u006e\u0073\u0065\u0072\u0074\u0054\u0065\u0078\u0074`, textEvt).then(() => {}).catch(err => {
                  console.error(`\u0049\u006e\u0070\u0075\u0074\u002e\u0069\u006e\u0073\u0065\u0072\u0074\u0054\u0065\u0078\u0074\u0020\u0065\u0072\u0072\u006f\u0072`, err);
                });
              } else {
                if (request.checkFocus) {
                  await queryActiveElementWhile((_d2 = sender.tab) == null ? void 0 : _d2.id);
                }
                chrome.debugger.sendCommand({
                  tabId: (_e2 = sender.tab) == null ? void 0 : _e2.id
                }, `\u0049\u006e\u0070\u0075\u0074\u002e\u0064\u0069\u0073\u0070\u0061\u0074\u0063\u0068\u004b\u0065\u0079\u0045\u0076\u0065\u006e\u0074`, {
                  type: `\u006b\u0065\u0079\u0044\u006f\u0077\u006e`,
                  windowsVirtualKeyCode: 13,
                  // Enter 的虚拟键码
                  nativeVirtualKeyCode: 13,
                  macCharCode: 13
                }).then(() => {
                  var _a3;
                  return chrome.debugger.sendCommand({
                    tabId: (_a3 = sender.tab) == null ? void 0 : _a3.id
                  }, `\u0049\u006e\u0070\u0075\u0074\u002e\u0064\u0069\u0073\u0070\u0061\u0074\u0063\u0068\u004b\u0065\u0079\u0045\u0076\u0065\u006e\u0074`, {
                    type: `\u006b\u0065\u0079\u0055\u0070`,
                    windowsVirtualKeyCode: 13,
                    nativeVirtualKeyCode: 13,
                    macCharCode: 13
                  });
                }).then(() => {}).catch(err => {
                  console.error(`\u0045\u0072\u0072\u006f\u0072\u0020\u0073\u0065\u006e\u0064\u0069\u006e\u0067\u0020\u006b\u0065\u0079\u0020\u0065\u0076\u0065\u006e\u0074`, err);
                });
              }
              index++;
            } else {
              break;
            }
            await delay(request.interval_time_out ? request.interval_time_out : 200);
          }
          resolve();
        });
      });
    };
    sendMessage().then(() => {
      console.log(`\u0073\u0065\u006e\u0064\u004d\u0065\u0073\u0073\u0061\u0067\u0065`);
    }).catch(error => {
      console.log(`\u0065\u0072\u0072\u006f\u0072`, error);
    }).finally(() => {
      console.log(`\u0066\u0069\u006e\u0061\u006c\u006c\u0079`);
      setTimeout(() => {
        chrome.debugger.detach(debuggee).then(res => {
          console.log(`\u0072\u0065\u0073`, res);
        }).finally(() => {
          sendResponse();
        });
      }, 1e3);
    });
    return true;
  }
  if (request.action === `\u0063\u0074\u0072\u0069\u006c\u005f\u0076`) {
    const debuggee = {
      tabId: (_c = sender.tab) == null ? void 0 : _c.id
    };
    chrome.debugger.sendCommand(debuggee, `\u0049\u006e\u0070\u0075\u0074\u002e\u0064\u0069\u0073\u0070\u0061\u0074\u0063\u0068\u004b\u0065\u0079\u0045\u0076\u0065\u006e\u0074`, {
      type: `\u006b\u0065\u0079\u0044\u006f\u0077\u006e`,
      windowsVirtualKeyCode: 86,
      // V key code
      modifiers: 2
      // Ctrl key modifier (MacOS 可以用 Cmd 键)
    }).then(res => {
      console.log(`\u0072\u0065\u0073\u0020\u006b\u0065\u0079\u0044\u006f\u0077\u006e`, res);
    });
    chrome.debugger.sendCommand(debuggee, `\u0049\u006e\u0070\u0075\u0074\u002e\u0064\u0069\u0073\u0070\u0061\u0074\u0063\u0068\u004b\u0065\u0079\u0045\u0076\u0065\u006e\u0074`, {
      type: `\u006b\u0065\u0079\u0055\u0070`,
      windowsVirtualKeyCode: 86,
      modifiers: 2
    }).then(res => {
      console.log(`\u0072\u0065\u0073\u0020\u006b\u0065\u0079\u0055\u0070`, res);
    });
    sendResponse();
    return false;
  }
  if (request.action === `\u006f\u0070\u0065\u006e\u0041\u0075\u0074\u0068\u006f\u0072\u0069\u007a\u0061\u0074\u0069\u006f\u006e\u0055\u0072\u006c`) {
    executeTask(request, sender, sendResponse);
    return true;
  }
  if (request.action === `\u006e\u006f\u0043\u006c\u006f\u0073\u0065\u0052\u0075\u006e`) {
    if (((_d = sender.tab) == null ? void 0 : _d.id) !== void 0) {
      activeDebuggerSessions[(_e = sender.tab) == null ? void 0 : _e.id].noCloseRun = true;
      sendResponse();
      return false;
    }
  }
  if (request.action === `\u0063\u006c\u006f\u0073\u0065\u0054\u0061\u0062`) {
    if (((_f = sender.tab) == null ? void 0 : _f.id) !== void 0) {
      if (request.tag && request.tag == `\u0063\u006c\u006f\u0073\u0065\u0054\u0061\u0062\u004c\u0069\u0073\u0074\u0065\u006e\u0065\u0072` && activeDebuggerSessions[(_g = sender.tab) == null ? void 0 : _g.id] && activeDebuggerSessions[(_h = sender.tab) == null ? void 0 : _h.id].openOptionsPage) {
        if (activeDebuggerSessions && activeDebuggerSessions[(_i = sender.tab) == null ? void 0 : _i.id] && ((_k = activeDebuggerSessions[(_j = sender.tab) == null ? void 0 : _j.id]) == null ? void 0 : _k.tabData) && ((_m = activeDebuggerSessions[(_l = sender.tab) == null ? void 0 : _l.id]) == null ? void 0 : _m.tabData.taskId)) {
          console.log(`\u7ed3\u675f\u4efb\u52a1`, (_n = sender.tab) == null ? void 0 : _n.id, (_p = activeDebuggerSessions[(_o = sender.tab) == null ? void 0 : _o.id]) == null ? void 0 : _p.tabData.taskId);
          taskManager.report((_r = activeDebuggerSessions[(_q = sender.tab) == null ? void 0 : _q.id]) == null ? void 0 : _r.tabData.taskId).then();
        }
        chrome.runtime.openOptionsPage().then(() => {});
        console.log(`\u0068\u0061\u006e\u0064\u006c\u0065\u004c\u006f\u0067\u0069\u006e\u0020\u0063\u0068\u0072\u006f\u006d\u0065\u002e\u0072\u0075\u006e\u0074\u0069\u006d\u0065\u002e\u006f\u0070\u0065\u006e\u004f\u0070\u0074\u0069\u006f\u006e\u0073\u0050\u0061\u0067\u0065\u0028\u0029`);
      }
      chrome.tabs.remove(sender.tab.id, () => {
        var _a2;
        console.log(`\u0054\u0061\u0062\u0020${(_a2 = sender.tab) == null ? void 0 : _a2.id}\u0020\u5df2\u6210\u529f\u5173\u95ed\u3002`);
      });
    } else {
      console.warn(`\u65e0\u6cd5\u5173\u95ed\u6807\u7b7e\u9875\uff1a\u0073\u0065\u006e\u0064\u0065\u0072\u002e\u0074\u0061\u0062\u002e\u0069\u0064\u0020\u672a\u5b9a\u4e49\u3002`);
    }
    sendResponse();
    return false;
  }
  if (request.action === `\u0067\u0065\u0074\u0054\u0061\u0062\u0054\u0061\u0073\u006b\u0044\u0061\u0074\u0061`) {
    if (sender.tab && sender.tab.id) {
      let tabData = {};
      if (activeDebuggerSessions[sender.tab.id]) {
        console.log(`\u0067\u0065\u0074\u0054\u0061\u0062\u0054\u0061\u0073\u006b\u0044\u0061\u0074\u0061\u0020\u0073\u0065\u006e\u0064\u0065\u0072\u002e\u0074\u0061\u0062\u002e\u0069\u0064\u0020\u0061\u0063\u0074\u0069\u0076\u0065\u0044\u0065\u0062\u0075\u0067\u0067\u0065\u0072\u0053\u0065\u0073\u0073\u0069\u006f\u006e\u0073`);
        tabData = (_s = activeDebuggerSessions[sender.tab.id]) == null ? void 0 : _s.tabData;
      }
      console.log(`\u0067\u0065\u0074\u0054\u0061\u0062\u0054\u0061\u0073\u006b\u0044\u0061\u0074\u0061\u0020\u0073\u0065\u006e\u0064\u0065\u0072\u002e\u0074\u0061\u0062\u002e\u0069\u0064\u0020\u0074\u0061\u0062\u0044\u0061\u0074\u0061\u003a\u0020`, tabData);
      sendResponse({
        tabId: sender.tab.id,
        windowId: sender.tab.windowId,
        tabData
      });
    } else {
      console.log(`\u0067\u0065\u0074\u0054\u0061\u0062\u0054\u0061\u0073\u006b\u0044\u0061\u0074\u0061\u0020\u006e\u006f\u0020\u0073\u0065\u006e\u0064\u0065\u0072\u002e\u0074\u0061\u0062\u002e\u0069\u0064`);
      sendResponse({
        tabId: null
      });
    }
    return false;
  }
  if (request.action === `\u0071\u0075\u0065\u0072\u0079\u0054\u0061\u0062\u0073`) {
    chrome.tabs.query({
      windowId: request.windowId
    }, function (tabs) {
      if (chrome.runtime.lastError) {
        console.error(`\u0071\u0075\u0065\u0072\u0079\u0054\u0061\u0062\u0073\u0020\u0045\u0072\u0072\u006f\u0072\u0020\u0071\u0075\u0065\u0072\u0079\u0069\u006e\u0067\u0020\u0074\u0061\u0062\u0073\u003a`, chrome.runtime.lastError);
        sendResponse({
          tabIds: []
        });
        return;
      }
      const tabIds = tabs.map(tab => tab.id);
      console.log(`\u0071\u0075\u0065\u0072\u0079\u0054\u0061\u0062\u0073\u0020\u0074\u0061\u0062\u0049\u0064\u0073`, tabIds);
      sendResponse({
        tabIds
      });
      return;
    });
    return true;
  }
  if (request.action === `\u0073\u0065\u0074\u004f\u0070\u0065\u006e\u004f\u0070\u0074\u0069\u006f\u006e\u0073\u0050\u0061\u0067\u0065`) {
    if (((_t = sender.tab) == null ? void 0 : _t.id) !== void 0) {
      activeDebuggerSessions[(_u = sender.tab) == null ? void 0 : _u.id].openOptionsPage = false;
      sendResponse();
      return false;
    }
  }
  if (request.message === `\u0071\u0075\u0065\u0072\u0079\u0041\u0063\u0074\u0069\u0076\u0061\u0074\u0065\u0054\u0061\u0062`) {
    chrome.tabs.query({
      active: true,
      currentWindow: true
    }, tabs => {
      if (tabs.length > 0) {
        sendResponse({
          tabId: tabs[0].id,
          url: tabs[0].url
        });
      } else {
        sendResponse({
          tabId: null,
          url: null
        });
      }
    });
    return true;
  }
  if (request.action === `\u0063\u0068\u0065\u0063\u006b\u0049\u0066\u0054\u0061\u0062\u0045\u0078\u0069\u0073\u0074\u0073`) {
    chrome.tabs.query({}, function (tabs) {
      let tabExists = tabs.some(tab => tab.id === request.tabId);
      sendResponse({
        tabExists
      });
    });
    return true;
  }
  if (request.action === `\u0074\u0061\u0073\u006b\u0043\u006f\u006d\u0070\u006c\u0065\u0074\u0065`) {
    if (((_v = sender.tab) == null ? void 0 : _v.id) !== void 0) {
      activeDebuggerSessions[(_w = sender.tab) == null ? void 0 : _w.id].taskComplete = true;
      sendResponse();
      return false;
    }
  }
  if (request.action === `\u0063\u0068\u0065\u0063\u006b\u0054\u0061\u0073\u006b\u0043\u006f\u006d\u0070\u006c\u0065\u0074\u0065`) {
    if (request.tabId !== void 0) {
      sendResponse({
        taskComplete: (_x = activeDebuggerSessions[request.tabId]) == null ? void 0 : _x.taskComplete
      });
      return false;
    }
  }
  if (request.action === `\u0063\u0075\u0072\u0072\u0065\u006e\u0074\u0041\u0063\u0074\u0069\u0076\u0061\u0074\u0065\u0054\u0061\u0062`) {
    if (((_y = sender.tab) == null ? void 0 : _y.id) !== void 0) {
      const tabId = (_z = sender.tab) == null ? void 0 : _z.id;
      if (tabId) {
        let errorNum = 0;
        const tabs_update_Interval = setInterval(() => {
          chrome.tabs.update(tabId, {
            active: true
          }).then(res => {
            var _a2;
            console.log(`\u0075\u0070\u0064\u0061\u0074\u0065\u0020\u0072\u0065\u0073`, res);
            chrome.storage.local.set({
              "taskComplete": (_a2 = sender.tab) == null ? void 0 : _a2.id
            }, () => {});
            sendResponse();
            clearInterval(tabs_update_Interval);
          }).catch(err => {
            if (errorNum > 3) {
              sendResponse();
              clearInterval(tabs_update_Interval);
            }
            errorNum++;
            console.log(`\u0075\u0070\u0064\u0061\u0074\u0065\u0020\u0065\u0072\u0072`, err);
          });
        }, 200);
        return true;
      }
    }
    sendResponse();
    return false;
  }
  if (request.action === `\u0061\u0063\u0074\u0069\u0076\u0061\u0074\u0065\u0054\u0061\u0062`) {
    if (((_A = sender.tab) == null ? void 0 : _A.id) !== void 0) {
      const parentTabId = (_C = activeDebuggerSessions[(_B = sender.tab) == null ? void 0 : _B.id]) == null ? void 0 : _C.parentTabId;
      if (parentTabId) {
        let errorNum = 0;
        const tabs_update_Interval = setInterval(() => {
          chrome.tabs.update(parentTabId, {
            active: true
          }).then(res => {
            var _a2;
            console.log(`\u0075\u0070\u0064\u0061\u0074\u0065\u0020\u0072\u0065\u0073`, res);
            chrome.storage.local.set({
              "taskComplete": (_a2 = sender.tab) == null ? void 0 : _a2.id
            }, () => {});
            sendResponse();
            clearInterval(tabs_update_Interval);
          }).catch(err => {
            if (errorNum > 3) {
              sendResponse();
              clearInterval(tabs_update_Interval);
            }
            errorNum++;
            console.log(`\u0075\u0070\u0064\u0061\u0074\u0065\u0020\u0065\u0072\u0072`, err);
          });
        }, 200);
        return true;
      }
    }
    sendResponse();
    return false;
  }
  if (request.action === `\u0067\u0065\u0074\u0046\u0069\u006c\u0065\u0053\u0065\u006c\u0065\u0063\u0074\u0065\u0064`) {
    if (sender.tab && sender.tab.id) {
      let uploadFileList = [];
      if (activeDebuggerSessions[sender.tab.id]) {
        console.log(sender.tab.id, `\u0067\u0065\u0074\u0046\u0069\u006c\u0065\u0053\u0065\u006c\u0065\u0063\u0074\u0065\u0064\u0020\u0073\u0065\u006e\u0064\u0065\u0072\u002e\u0074\u0061\u0062\u002e\u0069\u0064\u0020\u0061\u0063\u0074\u0069\u0076\u0065\u0044\u0065\u0062\u0075\u0067\u0067\u0065\u0072\u0053\u0065\u0073\u0073\u0069\u006f\u006e\u0073`);
        uploadFileList = activeDebuggerSessions[sender.tab.id].uploadFileList;
      }
      console.log(sender.tab.id, `\u0067\u0065\u0074\u0046\u0069\u006c\u0065\u0053\u0065\u006c\u0065\u0063\u0074\u0065\u0064\u0020\u0073\u0065\u006e\u0064\u0065\u0072\u002e\u0074\u0061\u0062\u002e\u0069\u0064\u0020\u0074\u0061\u0062\u0044\u0061\u0074\u0061\u003a\u0020`, uploadFileList);
      sendResponse({
        tabId: sender.tab.id,
        uploadFileList
      });
    } else {
      console.log(`\u0067\u0065\u0074\u0046\u0069\u006c\u0065\u0053\u0065\u006c\u0065\u0063\u0074\u0065\u0064\u0020\u006e\u006f\u0020\u0073\u0065\u006e\u0064\u0065\u0072\u002e\u0074\u0061\u0062\u002e\u0069\u0064`);
      sendResponse({
        tabId: null
      });
    }
    return false;
  }
  if (request.action === `\u0061\u006c\u006c\u0054\u0061\u0073\u006b\u0043\u006f\u006d\u0070\u006c\u0065\u0074\u0065`) {
    if (sender.tab && sender.tab.id && ((_D = activeDebuggerSessions[sender.tab.id]) == null ? void 0 : _D.tabData)) {
      console.log(`\u7ed3\u675f\u4efb\u52a1`, sender.tab.id, (_F = (_E = activeDebuggerSessions[sender.tab.id]) == null ? void 0 : _E.tabData) == null ? void 0 : _F.taskId);
      taskManager.abortTask((_H = (_G = activeDebuggerSessions[sender.tab.id]) == null ? void 0 : _G.tabData) == null ? void 0 : _H.taskId).then();
    }
    sendResponse();
    return false;
  }
  if (request.action == `\u006c\u006f\u0067\u0073`) {
    sendResponse();
    return false;
  }
  const actionList = [`\u0074\u0061\u0062\u0043\u0068\u0061\u006e\u0067\u0065`, `\u0069\u006e\u006a\u0065\u0063\u0074\u0049\u0066\u0072\u0061\u006d\u0065`, `\u005f\u0071\u0075\u0065\u0072\u0079\u004c\u0061\u0073\u0074\u0054\u0069\u006d\u0065`, `\u0071\u0075\u0065\u0072\u0079\u0041\u0063\u0074\u0069\u0076\u0065\u0045\u006c\u0065\u006d\u0065\u006e\u0074`, `\u0073\u0065\u0074\u0041\u0063\u0074\u0069\u0076\u0065\u0045\u006c\u0065\u006d\u0065\u006e\u0074`];
  if (request.action || request.messageType) {
    let returnBool = false;
    actionList.forEach(action => {
      if (returnBool) {
        return;
      }
      const index = (request.action || request.messageType).indexOf(action);
      console.log(`\u0061\u0063\u0074\u0069\u006f\u006e\u0020`, action, index);
      if ((request.action || request.messageType).indexOf(action) > 0) {
        returnBool = true;
      }
    });
    if (!returnBool) {
      sendResponse();
      return false;
    }
  } else {
    console.error(`\u6ca1\u6709\u5339\u914d\u5230\u6d88\u606f\u7c7b\u578b`);
  }
});
const queryActiveElementWhile = async tabId => {
  let num = 0;
  while (true) {
    if (num > 60) {
      return false;
    }
    if (!activeDebuggerSessions[tabId]) {
      console.log(`\u7a97\u53e3\u4e0d\u5b58\u5728\u4e86\uff0c\u4e0d\u9700\u8981\u7ee7\u7eed\u68c0\u67e5\u4e86`);
      return false;
    }
    const boolData = await queryActiveElement(tabId);
    if (boolData) {
      return boolData;
    } else {
      await setActiveElement(tabId);
    }
    if (!activeDebuggerSessions[tabId]) {
      console.log(`\u7a97\u53e3\u4e0d\u5b58\u5728\u4e86\uff0c\u4e0d\u9700\u8981\u7ee7\u7eed\u68c0\u67e5\u4e86`);
      return false;
    }
    num++;
    await delay(1e3);
  }
};
const queryActiveElement = tabId => {
  return new Promise(resolve => {
    chrome.tabs.sendMessage(tabId, {
      messageType: `\u0071\u0075\u0065\u0072\u0079\u0041\u0063\u0074\u0069\u0076\u0065\u0045\u006c\u0065\u006d\u0065\u006e\u0074`,
      status: false,
      tabId
    }, {}, response => {
      if (response) {
        console.log(`\u0071\u0075\u0065\u0072\u0079\u0041\u0063\u0074\u0069\u0076\u0065\u0045\u006c\u0065\u006d\u0065\u006e\u0074\u0020\u0072\u0065\u0073\u003a`, response);
        resolve(true);
      } else {
        console.error(`\u0071\u0075\u0065\u0072\u0079\u0041\u0063\u0074\u0069\u0076\u0065\u0045\u006c\u0065\u006d\u0065\u006e\u0074\u0020\u0046\u0061\u0069\u006c\u0065\u0064\u0020\u0074\u006f\u0020\u0067\u0065\u0074\u0020\u0074\u0061\u0062\u0020\u0069\u006e\u0066\u006f\u0072\u006d\u0061\u0074\u0069\u006f\u006e\u002e`);
        resolve(false);
      }
    });
  });
};
const setActiveElement = tabId => {
  return new Promise(resolve => {
    chrome.tabs.sendMessage(tabId, {
      messageType: `\u0073\u0065\u0074\u0041\u0063\u0074\u0069\u0076\u0065\u0045\u006c\u0065\u006d\u0065\u006e\u0074`,
      status: false,
      tabId
    }, {}, response => {
      if (response) {
        console.log(`\u0073\u0065\u0074\u0041\u0063\u0074\u0069\u0076\u0065\u0045\u006c\u0065\u006d\u0065\u006e\u0074\u0020\u0072\u0065\u0073\u003a`, response);
        resolve(true);
      } else {
        console.error(`\u0073\u0065\u0074\u0041\u0063\u0074\u0069\u0076\u0065\u0045\u006c\u0065\u006d\u0065\u006e\u0074\u0020\u0046\u0061\u0069\u006c\u0065\u0064\u0020\u0074\u006f\u0020\u0067\u0065\u0074\u0020\u0074\u0061\u0062\u0020\u0069\u006e\u0066\u006f\u0072\u006d\u0061\u0074\u0069\u006f\u006e\u002e`);
        resolve(false);
      }
    });
  });
};
chrome.tabs.onRemoved.addListener(tabId => {
  sendLog(`\u0054\u0061\u0062\u0020${tabId}\u0020\u0072\u0065\u006d\u006f\u0076\u0065\u0064\u002e`);
  if (activeDebuggerSessions[tabId]) {
    if (!activeDebuggerSessions[tabId].noCloseRun) {
      console.log(`\u0063\u0068\u0072\u006f\u006d\u0065\u002e\u0074\u0061\u0062\u0073\u002e\u006f\u006e\u0052\u0065\u006d\u006f\u0076\u0065\u0064\u002e\u0061\u0064\u0064\u004c\u0069\u0073\u0074\u0065\u006e\u0065\u0072`, tabId);
      chrome.storage.local.set({
        "activatePage": indexPage
      }, () => {
        var _a, _b, _c, _d;
        console.log(`\u0044\u0061\u0074\u0061\u0020\u0068\u0061\u0073\u0020\u0062\u0065\u0065\u006e\u0020\u0073\u0074\u006f\u0072\u0065\u0064\u0020\u006c\u006f\u0063\u0061\u006c\u006c\u0079\u002e`, activeDebuggerSessions && activeDebuggerSessions[tabId]);
        if (activeDebuggerSessions && activeDebuggerSessions[tabId] && ((_a = activeDebuggerSessions[tabId]) == null ? void 0 : _a.tabData) && ((_b = activeDebuggerSessions[tabId]) == null ? void 0 : _b.tabData.taskId)) {
          sendLog(`\u7ed3\u675f\u4efb\u52a1`, tabId, (_c = activeDebuggerSessions[tabId]) == null ? void 0 : _c.tabData.taskId);
          taskManager.abortTask((_d = activeDebuggerSessions[tabId]) == null ? void 0 : _d.tabData.taskId).then();
        }
        releaseKeepAwake();
        chrome.storage.local.set({
          "DoneNoteId": tabId
        }, () => {});
        delete activeDebuggerSessions[tabId];
      });
    } else {
      chrome.storage.local.set({
        "DoneNoteId": tabId
      }, () => {});
      delete activeDebuggerSessions[tabId];
    }
  } else {
    console.log(`\u006e\u006f\u0074\u0020\u0061\u0063\u0074\u0069\u0076\u0065\u0044\u0065\u0062\u0075\u0067\u0067\u0065\u0072\u0053\u0065\u0073\u0073\u0069\u006f\u006e\u0073\u005b\u0074\u0061\u0062\u0049\u0064\u005d`, tabId, Object.keys(activeDebuggerSessions));
  }
});
chrome.tabs.onActivated.addListener(activeInfo => {
  var _a;
  console.log(`\u006f\u006e\u0041\u0063\u0074\u0069\u0076\u0061\u0074\u0065\u0064`, activeInfo);
  if (activeDebuggerSessions[activeInfo.tabId] && ((_a = activeDebuggerSessions[activeInfo.tabId]) == null ? void 0 : _a.onCompleted)) {
    console.log(`\u6fc0\u6d3b\u72b6\u6001`, activeInfo.tabId);
    chrome.tabs.sendMessage(activeInfo.tabId, {
      messageType: `\u0074\u0061\u0062\u0043\u0068\u0061\u006e\u0067\u0065`,
      status: true,
      tabId: activeInfo.tabId
    }, {}, res => {
      console.log(`\u6fc0\u6d3b\u72b6\u6001\u0020\u0072\u0065\u0073`, activeInfo.tabId, res);
    });
  }
  if (Object.keys(activeDebuggerSessions).length > 0) {
    Object.keys(activeDebuggerSessions).forEach(tabIdStr => {
      var _a2;
      const tabId = Number(tabIdStr);
      if (!isNaN(tabId)) {
        if (tabId != activeInfo.tabId && activeDebuggerSessions[tabId] && ((_a2 = activeDebuggerSessions[tabId]) == null ? void 0 : _a2.windowId) == activeInfo.windowId) {
          console.log(`\u5931\u53bb\u6fc0\u6d3b\u72b6\u6001`, tabId);
          chrome.tabs.sendMessage(tabId, {
            messageType: `\u0074\u0061\u0062\u0043\u0068\u0061\u006e\u0067\u0065`,
            status: false,
            tabId
          }, {}, res => {
            console.log(`\u5931\u53bb\u6fc0\u6d3b\u72b6\u6001\u0020\u0072\u0065\u0073`, tabId, res);
          });
          let errorNum = 0;
          const tabs_update_Interval = setInterval(() => {
            chrome.tabs.update(tabId, {
              active: true
            }).then(res => {
              console.log(`\u0075\u0070\u0064\u0061\u0074\u0065\u0020\u0072\u0065\u0073`, res);
              clearInterval(tabs_update_Interval);
            }).catch(err => {
              if (errorNum > 3) {
                clearInterval(tabs_update_Interval);
              }
              errorNum++;
              console.log(`\u0075\u0070\u0064\u0061\u0074\u0065\u0020\u0065\u0072\u0072`, err);
            });
          }, 200);
        }
      }
    });
  }
});
chrome.tabs.onDetached.addListener((tabId, detachInfo) => {
  console.log(`\u0054\u0061\u0062\u0020${tabId}\u0020\u0077\u0061\u0073\u0020\u0064\u0065\u0074\u0061\u0063\u0068\u0065\u0064\u0020\u0066\u0072\u006f\u006d\u0020\u0077\u0069\u006e\u0064\u006f\u0077\u0020${detachInfo.oldWindowId}\u002e`);
});
chrome.tabs.onAttached.addListener((tabId, attachInfo) => {
  console.log(`\u0054\u0061\u0062\u0020${tabId}\u0020\u0077\u0061\u0073\u0020\u0061\u0074\u0074\u0061\u0063\u0068\u0065\u0064\u0020\u0074\u006f\u0020\u0077\u0069\u006e\u0064\u006f\u0077\u0020${attachInfo.newWindowId}\u002e`);
  if (activeDebuggerSessions[tabId]) {
    activeDebuggerSessions[tabId].windowId = attachInfo.newWindowId;
  }
});
chrome.tabs.onUpdated.addListener((tabId, changeInfo, tab) => {
  console.log(`\u0063\u0068\u0061\u006e\u0067\u0065\u0049\u006e\u0066\u006f\u002e\u0073\u0074\u0061\u0074\u0075\u0073`, changeInfo, tabId, tab);
});
chrome.webNavigation.onErrorOccurred.addListener(details => {
  const errorCode = details.error;
  let errorMessage;
  switch (errorCode) {
    case `\u006e\u0065\u0074\u003a\u003a\u0045\u0052\u0052\u005f\u004e\u0041\u004d\u0045\u005f\u004e\u004f\u0054\u005f\u0052\u0045\u0053\u004f\u004c\u0056\u0045\u0044`:
      errorMessage = `\u57df\u540d\u89e3\u6790\u5931\u8d25\uff0c\u53ef\u80fd\u662f\u0020\u0044\u004e\u0053\u0020\u670d\u52a1\u5668\u914d\u7f6e\u95ee\u9898\u3001\u57df\u540d\u62fc\u5199\u9519\u8bef\u6216\u8005\u57df\u540d\u672c\u8eab\u4e0d\u5b58\u5728\u3002`;
      break;
    case `\u006e\u0065\u0074\u003a\u003a\u0045\u0052\u0052\u005f\u0044\u004e\u0053\u005f\u0054\u0049\u004d\u0045\u0044\u005f\u004f\u0055\u0054`:
      errorMessage = `\u0044\u004e\u0053\u0020\u67e5\u8be2\u8d85\u65f6\uff0c\u5728\u89c4\u5b9a\u65f6\u95f4\u5185\u672a\u80fd\u4ece\u0020\u0044\u004e\u0053\u0020\u670d\u52a1\u5668\u83b7\u53d6\u5230\u57df\u540d\u5bf9\u5e94\u7684\u0020\u0049\u0050\u0020\u5730\u5740\uff0c\u53ef\u80fd\u662f\u0020\u0044\u004e\u0053\u0020\u670d\u52a1\u5668\u54cd\u5e94\u6162\u6216\u8005\u7f51\u7edc\u8fde\u63a5\u95ee\u9898\u3002`;
      break;
    case `\u006e\u0065\u0074\u003a\u003a\u0045\u0052\u0052\u005f\u0043\u004f\u004e\u004e\u0045\u0043\u0054\u0049\u004f\u004e\u005f\u0052\u0045\u0046\u0055\u0053\u0045\u0044`:
      errorMessage = `\u8fde\u63a5\u88ab\u62d2\u7edd\uff0c\u901a\u5e38\u662f\u56e0\u4e3a\u76ee\u6807\u670d\u52a1\u5668\u6ca1\u6709\u5728\u6307\u5b9a\u7684\u7aef\u53e3\u4e0a\u76d1\u542c\u8fde\u63a5\uff0c\u53ef\u80fd\u662f\u670d\u52a1\u5668\u672a\u542f\u52a8\u3001\u7aef\u53e3\u88ab\u9632\u706b\u5899\u963b\u6b62\u7b49\u539f\u56e0\u3002`;
      break;
    case `\u006e\u0065\u0074\u003a\u003a\u0045\u0052\u0052\u005f\u0043\u004f\u004e\u004e\u0045\u0043\u0054\u0049\u004f\u004e\u005f\u0054\u0049\u004d\u0045\u0044\u005f\u004f\u0055\u0054`:
      errorMessage = `\u8fde\u63a5\u8d85\u65f6\uff0c\u5728\u5c1d\u8bd5\u8fde\u63a5\u5230\u670d\u52a1\u5668\u65f6\uff0c\u7ecf\u8fc7\u4e00\u5b9a\u65f6\u95f4\u4ecd\u672a\u5efa\u7acb\u8fde\u63a5\uff0c\u53ef\u80fd\u662f\u7f51\u7edc\u5ef6\u8fdf\u8fc7\u9ad8\u3001\u670d\u52a1\u5668\u8d1f\u8f7d\u8fc7\u5927\u6216\u8005\u7f51\u7edc\u6545\u969c\u3002`;
      break;
    case `\u006e\u0065\u0074\u003a\u003a\u0045\u0052\u0052\u005f\u0043\u004f\u004e\u004e\u0045\u0043\u0054\u0049\u004f\u004e\u005f\u0052\u0045\u0053\u0045\u0054`:
      errorMessage = `\u8fde\u63a5\u88ab\u91cd\u7f6e\uff0c\u5728\u6570\u636e\u4f20\u8f93\u8fc7\u7a0b\u4e2d\uff0c\u8fde\u63a5\u88ab\u610f\u5916\u4e2d\u65ad\uff0c\u53ef\u80fd\u662f\u7f51\u7edc\u4e0d\u7a33\u5b9a\u3001\u670d\u52a1\u5668\u5f02\u5e38\u5173\u95ed\u8fde\u63a5\u7b49\u539f\u56e0\u3002`;
      break;
    case `\u006e\u0065\u0074\u003a\u003a\u0045\u0052\u0052\u005f\u0043\u004f\u004e\u004e\u0045\u0043\u0054\u0049\u004f\u004e\u005f\u0041\u0042\u004f\u0052\u0054\u0045\u0044`:
      errorMessage = `\u8fde\u63a5\u88ab\u4e2d\u6b62\uff0c\u53ef\u80fd\u662f\u7528\u6237\u4e3b\u52a8\u53d6\u6d88\u8bf7\u6c42\u3001\u6d4f\u89c8\u5668\u5173\u95ed\u8fde\u63a5\u6216\u8005\u7a0b\u5e8f\u4ee3\u7801\u4e2d\u63d0\u524d\u7ec8\u6b62\u4e86\u8fde\u63a5\u3002`;
      break;
    case `\u006e\u0065\u0074\u003a\u003a\u0045\u0052\u0052\u005f\u0043\u004f\u004e\u004e\u0045\u0043\u0054\u0049\u004f\u004e\u005f\u0046\u0041\u0049\u004c\u0045\u0044`:
      errorMessage = `\u8fde\u63a5\u5931\u8d25\uff0c\u8fd9\u662f\u4e00\u4e2a\u901a\u7528\u7684\u8fde\u63a5\u9519\u8bef\uff0c\u53ef\u80fd\u662f\u7531\u4e8e\u591a\u79cd\u539f\u56e0\u5bfc\u81f4\uff0c\u5982\u7f51\u7edc\u914d\u7f6e\u9519\u8bef\u3001\u670d\u52a1\u5668\u4e0d\u53ef\u7528\u7b49\u3002`;
      break;
    case `\u006e\u0065\u0074\u003a\u003a\u0045\u0052\u0052\u005f\u0050\u0052\u004f\u0058\u0059\u005f\u0043\u004f\u004e\u004e\u0045\u0043\u0054\u0049\u004f\u004e\u005f\u0046\u0041\u0049\u004c\u0045\u0044`:
      errorMessage = `\u4ee3\u7406\u8fde\u63a5\u5931\u8d25\uff0c\u5f53\u4f7f\u7528\u4ee3\u7406\u670d\u52a1\u5668\u65f6\uff0c\u65e0\u6cd5\u4e0e\u4ee3\u7406\u670d\u52a1\u5668\u5efa\u7acb\u8fde\u63a5\uff0c\u53ef\u80fd\u662f\u4ee3\u7406\u670d\u52a1\u5668\u5730\u5740\u3001\u7aef\u53e3\u914d\u7f6e\u9519\u8bef\u6216\u8005\u4ee3\u7406\u670d\u52a1\u5668\u672c\u8eab\u4e0d\u53ef\u7528\u3002`;
      break;
    case `\u006e\u0065\u0074\u003a\u003a\u0045\u0052\u0052\u005f\u0054\u0055\u004e\u004e\u0045\u004c\u005f\u0043\u004f\u004e\u004e\u0045\u0043\u0054\u0049\u004f\u004e\u005f\u0046\u0041\u0049\u004c\u0045\u0044`:
      errorMessage = `\u5728\u4f7f\u7528\u0020\u0048\u0054\u0054\u0050\u0053\u0020\u4ee3\u7406\u96a7\u9053\u65f6\uff0c\u96a7\u9053\u8fde\u63a5\u5931\u8d25\uff0c\u901a\u5e38\u4e0e\u4ee3\u7406\u670d\u52a1\u5668\u7684\u914d\u7f6e\u548c\u7f51\u7edc\u73af\u5883\u6709\u5173\u3002`;
      break;
    case `\u006e\u0065\u0074\u003a\u003a\u0045\u0052\u0052\u005f\u0043\u0045\u0052\u0054\u005f\u0043\u004f\u004d\u004d\u004f\u004e\u005f\u004e\u0041\u004d\u0045\u005f\u0049\u004e\u0056\u0041\u004c\u0049\u0044`:
      errorMessage = `\u8bc1\u4e66\u7684\u901a\u7528\u540d\u79f0\u65e0\u6548\uff0c\u670d\u52a1\u5668\u63d0\u4f9b\u7684\u0020\u0053\u0053\u004c\u002f\u0054\u004c\u0053\u0020\u8bc1\u4e66\u4e2d\u7684\u901a\u7528\u540d\u79f0\uff08\u0043\u004e\uff09\u4e0e\u8bbf\u95ee\u7684\u57df\u540d\u4e0d\u5339\u914d\uff0c\u53ef\u80fd\u5b58\u5728\u4e2d\u95f4\u4eba\u653b\u51fb\u98ce\u9669\u3002`;
      break;
    case `\u006e\u0065\u0074\u003a\u003a\u0045\u0052\u0052\u005f\u0043\u0045\u0052\u0054\u005f\u0044\u0041\u0054\u0045\u005f\u0049\u004e\u0056\u0041\u004c\u0049\u0044`:
      errorMessage = `\u8bc1\u4e66\u65e5\u671f\u65e0\u6548\uff0c\u670d\u52a1\u5668\u7684\u0020\u0053\u0053\u004c\u002f\u0054\u004c\u0053\u0020\u8bc1\u4e66\u5df2\u8fc7\u671f\u6216\u8005\u5c1a\u672a\u751f\u6548\uff0c\u6d4f\u89c8\u5668\u4f1a\u963b\u6b62\u8bbf\u95ee\u4ee5\u786e\u4fdd\u5b89\u5168\u3002`;
      break;
    case `\u006e\u0065\u0074\u003a\u003a\u0045\u0052\u0052\u005f\u0043\u0045\u0052\u0054\u005f\u0041\u0055\u0054\u0048\u004f\u0052\u0049\u0054\u0059\u005f\u0049\u004e\u0056\u0041\u004c\u0049\u0044`:
      errorMessage = `\u8bc1\u4e66\u9881\u53d1\u673a\u6784\u65e0\u6548\uff0c\u670d\u52a1\u5668\u7684\u0020\u0053\u0053\u004c\u002f\u0054\u004c\u0053\u0020\u8bc1\u4e66\u4e0d\u662f\u7531\u53d7\u4fe1\u4efb\u7684\u8bc1\u4e66\u9881\u53d1\u673a\u6784\uff08\u0043\u0041\uff09\u7b7e\u53d1\u7684\uff0c\u6d4f\u89c8\u5668\u65e0\u6cd5\u9a8c\u8bc1\u8bc1\u4e66\u7684\u771f\u5b9e\u6027\u3002`;
      break;
    case `\u006e\u0065\u0074\u003a\u003a\u0045\u0052\u0052\u005f\u0053\u0053\u004c\u005f\u0050\u0052\u004f\u0054\u004f\u0043\u004f\u004c\u005f\u0045\u0052\u0052\u004f\u0052`:
      errorMessage = `\u0053\u0053\u004c\u002f\u0054\u004c\u0053\u0020\u534f\u8bae\u9519\u8bef\uff0c\u5728\u4e0e\u670d\u52a1\u5668\u8fdb\u884c\u0020\u0053\u0053\u004c\u002f\u0054\u004c\u0053\u0020\u63e1\u624b\u8fc7\u7a0b\u4e2d\u51fa\u73b0\u95ee\u9898\uff0c\u53ef\u80fd\u662f\u670d\u52a1\u5668\u548c\u5ba2\u6237\u7aef\u652f\u6301\u7684\u0020\u0053\u0053\u004c\u002f\u0054\u004c\u0053\u0020\u7248\u672c\u4e0d\u517c\u5bb9\u6216\u8005\u52a0\u5bc6\u7b97\u6cd5\u4e0d\u4e00\u81f4\u3002`;
      break;
    case `\u006e\u0065\u0074\u003a\u003a\u0045\u0052\u0052\u005f\u0049\u004e\u0054\u0045\u0052\u004e\u0045\u0054\u005f\u0044\u0049\u0053\u0043\u004f\u004e\u004e\u0045\u0043\u0054\u0045\u0044`:
      errorMessage = `\u7f51\u7edc\u8fde\u63a5\u65ad\u5f00\uff0c\u8868\u660e\u8bbe\u5907\u6ca1\u6709\u6709\u6548\u7684\u7f51\u7edc\u8fde\u63a5\uff0c\u65e0\u6cd5\u8bbf\u95ee\u4e92\u8054\u7f51\u3002`;
      break;
    case `\u006e\u0065\u0074\u003a\u003a\u0045\u0052\u0052\u005f\u0042\u004c\u004f\u0043\u004b\u0045\u0044\u005f\u0042\u0059\u005f\u0043\u004c\u0049\u0045\u004e\u0054`:
      errorMessage = `\u8bf7\u6c42\u88ab\u5ba2\u6237\u7aef\u963b\u6b62\uff0c\u53ef\u80fd\u662f\u6d4f\u89c8\u5668\u7684\u6269\u5c55\u7a0b\u5e8f\u3001\u5b89\u5168\u8f6f\u4ef6\u6216\u8005\u7528\u6237\u8bbe\u7f6e\u963b\u6b62\u4e86\u8be5\u8bf7\u6c42\u3002`;
      break;
    case `\u006e\u0065\u0074\u003a\u003a\u0045\u0052\u0052\u005f\u0055\u004e\u0053\u0041\u0046\u0045\u005f\u0050\u004f\u0052\u0054`:
      errorMessage = `\u5c1d\u8bd5\u8bbf\u95ee\u4e0d\u5b89\u5168\u7684\u7aef\u53e3\uff0c\u6d4f\u89c8\u5668\u51fa\u4e8e\u5b89\u5168\u8003\u8651\uff0c\u4f1a\u963b\u6b62\u5bf9\u67d0\u4e9b\u7aef\u53e3\u7684\u8bbf\u95ee\uff0c\u4f8b\u5982\u4e00\u4e9b\u7528\u4e8e\u5185\u90e8\u670d\u52a1\u7684\u7aef\u53e3\u3002`;
      break;
    case `\u006e\u0065\u0074\u003a\u003a\u0045\u0052\u0052\u005f\u0055\u004e\u004b\u004e\u004f\u0057\u004e\u005f\u0055\u0052\u004c\u005f\u0053\u0043\u0048\u0045\u004d\u0045`:
      errorMessage = `\u672a\u77e5\u7684\u0020\u0055\u0052\u004c\u0020\u534f\u8bae\uff0c\u6d4f\u89c8\u5668\u4e0d\u652f\u6301\u6240\u4f7f\u7528\u7684\u0020\u0055\u0052\u004c\u0020\u534f\u8bae\uff0c\u4f8b\u5982\u81ea\u5b9a\u4e49\u7684\u6216\u8005\u975e\u6cd5\u7684\u534f\u8bae\u3002`;
      break;
    default:
      errorMessage = `\u672a\u77e5\u9519\u8bef\u4ee3\u7801\u003a\u0020${errorCode}`;
  }
  if (!details.url) {
    details.url = ``;
  }
  if (details.url.length > 1e3) {
    details.url = details.url.slice(0, 1e3);
  }
  const message = `\u0077\u0065\u0062\u004e\u0061\u0076\u0069\u0067\u0061\u0074\u0069\u006f\u006e\u002e\u006f\u006e\u0045\u0072\u0072\u006f\u0072\u004f\u0063\u0063\u0075\u0072\u0072\u0065\u0064\u0020\u5bfc\u822a\u5230\u0020${details.url}\u0020\u65f6\u51fa\u9519\uff0c\u9519\u8bef\u4ee3\u7801\u003a\u0020${errorCode}\uff0c\u9519\u8bef\u539f\u56e0\u003a\u0020${errorMessage}`;
  chrome.storage.local.set({
    "runLogs": message
  });
  sendLog(message);
}, {
  url: [{
    urlMatches: `\u0068\u0074\u0074\u0070\u003a\u002f\u002f\u0077\u0077\u0077\u002e\u0078\u0069\u0061\u006f\u0068\u006f\u006e\u0067\u0073\u0068\u0075\u002e\u0063\u006f\u006d\u002f\u002a`
  }, {
    urlMatches: `\u0068\u0074\u0074\u0070\u0073\u003a\u002f\u002f\u0077\u0077\u0077\u002e\u0078\u0069\u0061\u006f\u0068\u006f\u006e\u0067\u0073\u0068\u0075\u002e\u0063\u006f\u006d\u002f\u002a`
  }, {
    urlMatches: `\u0068\u0074\u0074\u0070\u003a\u002f\u002f\u0077\u0077\u0077\u002e\u0064\u006f\u0075\u0079\u0069\u006e\u002e\u0063\u006f\u006d\u002f\u002a`
  }, {
    urlMatches: `\u0068\u0074\u0074\u0070\u0073\u003a\u002f\u002f\u0077\u0077\u0077\u002e\u0064\u006f\u0075\u0079\u0069\u006e\u002e\u0063\u006f\u006d\u002f\u002a`
  }, {
    urlMatches: `\u0068\u0074\u0074\u0070\u003a\u002f\u002f\u0077\u0077\u0077\u002e\u0066\u0061\u0063\u0065\u0062\u006f\u006f\u006b\u002e\u0063\u006f\u006d\u002f\u002a`
  }, {
    urlMatches: `\u0068\u0074\u0074\u0070\u0073\u003a\u002f\u002f\u0077\u0077\u0077\u002e\u0066\u0061\u0063\u0065\u0062\u006f\u006f\u006b\u002e\u0063\u006f\u006d\u002f\u002a`
  }]
});
chrome.webNavigation.onCompleted.addListener(details => {
  var _a, _b;
  console.log(`\u0077\u0065\u0062\u004e\u0061\u0076\u0069\u0067\u0061\u0074\u0069\u006f\u006e\u002e\u006f\u006e\u0043\u006f\u006d\u0070\u006c\u0065\u0074\u0065\u0064\u0020\u0064\u0065\u0074\u0061\u0069\u006c\u0073`, details);
  if (details.frameId === 0) {
    const tabId = details.tabId;
    if (activeDebuggerSessions[tabId]) {
      if ((manifest == null ? void 0 : manifest.content_scripts) && ((_a = manifest == null ? void 0 : manifest.content_scripts[0]) == null ? void 0 : _a.js)) {
        chrome.scripting.executeScript({
          target: {
            tabId
          },
          files: (_b = manifest == null ? void 0 : manifest.content_scripts[0]) == null ? void 0 : _b.js
        }, () => {
          console.log(`\u0065\u0078\u0065\u0063\u0075\u0074\u0065\u0053\u0063\u0072\u0069\u0070\u0074\u0020\u0066\u0069\u006c\u0065\u0020\u0063\u0061\u006c\u006c\u0062\u0061\u0063\u006b`);
          if (chrome.runtime.lastError) {
            console.log(`\u0065\u0072\u0072\u006f\u0072`, chrome.runtime.lastError.message);
          }
        });
      }
    }
  }
}, {
  url: [{
    urlMatches: `\u0068\u0074\u0074\u0070\u003a\u002f\u002f\u0077\u0077\u0077\u002e\u0078\u0069\u0061\u006f\u0068\u006f\u006e\u0067\u0073\u0068\u0075\u002e\u0063\u006f\u006d\u002f\u002a`
  }, {
    urlMatches: `\u0068\u0074\u0074\u0070\u0073\u003a\u002f\u002f\u0077\u0077\u0077\u002e\u0078\u0069\u0061\u006f\u0068\u006f\u006e\u0067\u0073\u0068\u0075\u002e\u0063\u006f\u006d\u002f\u002a`
  }, {
    urlMatches: `\u0068\u0074\u0074\u0070\u003a\u002f\u002f\u0077\u0077\u0077\u002e\u0064\u006f\u0075\u0079\u0069\u006e\u002e\u0063\u006f\u006d\u002f\u002a`
  }, {
    urlMatches: `\u0068\u0074\u0074\u0070\u0073\u003a\u002f\u002f\u0077\u0077\u0077\u002e\u0064\u006f\u0075\u0079\u0069\u006e\u002e\u0063\u006f\u006d\u002f\u002a`
  }, {
    urlMatches: `\u0068\u0074\u0074\u0070\u003a\u002f\u002f\u0077\u0077\u0077\u002e\u0066\u0061\u0063\u0065\u0062\u006f\u006f\u006b\u002e\u0063\u006f\u006d\u002f\u002a`
  }, {
    urlMatches: `\u0068\u0074\u0074\u0070\u0073\u003a\u002f\u002f\u0077\u0077\u0077\u002e\u0066\u0061\u0063\u0065\u0062\u006f\u006f\u006b\u002e\u0063\u006f\u006d\u002f\u002a`
  }]
});