import { L as Lottie } from "./js-lottie-web.js";
import { d as defineComponent, c as createElementBlock, o as openBlock, Q as normalizeStyle, r as ref, b as watchEffect, l as computed, w as watch } from "./js-@vue.js";
(function () {
  try {
    if (typeof document != `\u0075\u006e\u0064\u0065\u0066\u0069\u006e\u0065\u0064`) {
      var t = document.createElement(`\u0073\u0074\u0079\u006c\u0065`);
      t.appendChild(document.createTextNode(`\u002e\u006c\u006f\u0074\u0074\u0069\u0065\u002d\u0061\u006e\u0069\u006d\u0061\u0074\u0069\u006f\u006e\u002d\u0063\u006f\u006e\u0074\u0061\u0069\u006e\u0065\u0072\u007b\u0077\u0069\u0064\u0074\u0068\u003a\u0076\u0061\u0072\u0028\u002d\u002d\u006c\u006f\u0074\u0074\u0069\u0065\u002d\u0061\u006e\u0069\u006d\u0061\u0074\u0069\u006f\u006e\u002d\u0063\u006f\u006e\u0074\u0061\u0069\u006e\u0065\u0072\u002d\u0077\u0069\u0064\u0074\u0068\u0029\u003b\u0068\u0065\u0069\u0067\u0068\u0074\u003a\u0076\u0061\u0072\u0028\u002d\u002d\u006c\u006f\u0074\u0074\u0069\u0065\u002d\u0061\u006e\u0069\u006d\u0061\u0074\u0069\u006f\u006e\u002d\u0063\u006f\u006e\u0074\u0061\u0069\u006e\u0065\u0072\u002d\u0068\u0065\u0069\u0067\u0068\u0074\u0029\u003b\u0062\u0061\u0063\u006b\u0067\u0072\u006f\u0075\u006e\u0064\u002d\u0063\u006f\u006c\u006f\u0072\u003a\u0076\u0061\u0072\u0028\u002d\u002d\u006c\u006f\u0074\u0074\u0069\u0065\u002d\u0061\u006e\u0069\u006d\u0061\u0074\u0069\u006f\u006e\u002d\u0063\u006f\u006e\u0074\u0061\u0069\u006e\u0065\u0072\u002d\u0062\u0061\u0063\u006b\u0067\u0072\u006f\u0075\u006e\u0064\u002d\u0063\u006f\u006c\u006f\u0072\u0029\u003b\u006f\u0076\u0065\u0072\u0066\u006c\u006f\u0077\u003a\u0068\u0069\u0064\u0064\u0065\u006e\u003b\u006d\u0061\u0072\u0067\u0069\u006e\u003a\u0076\u0061\u0072\u0028\u002d\u002d\u006c\u006f\u0074\u0074\u0069\u0065\u002d\u0061\u006e\u0069\u006d\u0061\u0074\u0069\u006f\u006e\u002d\u006d\u0061\u0072\u0067\u0069\u006e\u0029\u007d\u002e\u006c\u006f\u0074\u0074\u0069\u0065\u002d\u0061\u006e\u0069\u006d\u0061\u0074\u0069\u006f\u006e\u002d\u0063\u006f\u006e\u0074\u0061\u0069\u006e\u0065\u0072\u0020\u0073\u0076\u0067\u007b\u0074\u0072\u0061\u006e\u0073\u0066\u006f\u0072\u006d\u003a\u0073\u0063\u0061\u006c\u0065\u0028\u0076\u0061\u0072\u0028\u002d\u002d\u006c\u006f\u0074\u0074\u0069\u0065\u002d\u0061\u006e\u0069\u006d\u0061\u0074\u0069\u006f\u006e\u002d\u0073\u0063\u0061\u006c\u0065\u0029\u0029\u007d`)), document.head.appendChild(t);
    }
  } catch (n) {
    console.error(`\u0076\u0069\u0074\u0065\u002d\u0070\u006c\u0075\u0067\u0069\u006e\u002d\u0063\u0073\u0073\u002d\u0069\u006e\u006a\u0065\u0063\u0074\u0065\u0064\u002d\u0062\u0079\u002d\u006a\u0073`, n);
  }
})();
var __defProp = Object.defineProperty;
var __defProps = Object.defineProperties;
var __getOwnPropDescs = Object.getOwnPropertyDescriptors;
var __getOwnPropSymbols = Object.getOwnPropertySymbols;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __propIsEnum = Object.prototype.propertyIsEnumerable;
var __defNormalProp = (obj, key, value) => key in obj ? __defProp(obj, key, {
  enumerable: true,
  configurable: true,
  writable: true,
  value
}) : obj[key] = value;
var __spreadValues = (a, b) => {
  for (var prop in b || (b = {})) if (__hasOwnProp.call(b, prop)) __defNormalProp(a, prop, b[prop]);
  if (__getOwnPropSymbols) for (var prop of __getOwnPropSymbols(b)) {
    if (__propIsEnum.call(b, prop)) __defNormalProp(a, prop, b[prop]);
  }
  return a;
};
var __spreadProps = (a, b) => __defProps(a, __getOwnPropDescs(b));
var es6 = function equal(a, b) {
  if (a === b) return true;
  if (a && b && typeof a == `\u006f\u0062\u006a\u0065\u0063\u0074` && typeof b == `\u006f\u0062\u006a\u0065\u0063\u0074`) {
    if (a.constructor !== b.constructor) return false;
    var length, i, keys;
    if (Array.isArray(a)) {
      length = a.length;
      if (length != b.length) return false;
      for (i = length; i-- !== 0;) if (!equal(a[i], b[i])) return false;
      return true;
    }
    if (a instanceof Map && b instanceof Map) {
      if (a.size !== b.size) return false;
      for (i of a.entries()) if (!b.has(i[0])) return false;
      for (i of a.entries()) if (!equal(i[1], b.get(i[0]))) return false;
      return true;
    }
    if (a instanceof Set && b instanceof Set) {
      if (a.size !== b.size) return false;
      for (i of a.entries()) if (!b.has(i[0])) return false;
      return true;
    }
    if (ArrayBuffer.isView(a) && ArrayBuffer.isView(b)) {
      length = a.length;
      if (length != b.length) return false;
      for (i = length; i-- !== 0;) if (a[i] !== b[i]) return false;
      return true;
    }
    if (a.constructor === RegExp) return a.source === b.source && a.flags === b.flags;
    if (a.valueOf !== Object.prototype.valueOf) return a.valueOf() === b.valueOf();
    if (a.toString !== Object.prototype.toString) return a.toString() === b.toString();
    keys = Object.keys(a);
    length = keys.length;
    if (length !== Object.keys(b).length) return false;
    for (i = length; i-- !== 0;) if (!Object.prototype.hasOwnProperty.call(b, keys[i])) return false;
    for (i = length; i-- !== 0;) {
      var key = keys[i];
      if (!equal(a[key], b[key])) return false;
    }
    return true;
  }
  return a !== a && b !== b;
};
function klona(val) {
  var k, out, tmp;
  if (Array.isArray(val)) {
    out = Array(k = val.length);
    while (k--) out[k] = (tmp = val[k]) && typeof tmp === `\u006f\u0062\u006a\u0065\u0063\u0074` ? klona(tmp) : tmp;
    return out;
  }
  if (Object.prototype.toString.call(val) === `\u005b\u006f\u0062\u006a\u0065\u0063\u0074\u0020\u004f\u0062\u006a\u0065\u0063\u0074\u005d`) {
    out = {};
    for (k in val) {
      if (k === `\u005f\u005f\u0070\u0072\u006f\u0074\u006f\u005f\u005f`) {
        Object.defineProperty(out, k, {
          value: klona(val[k]),
          configurable: true,
          enumerable: true,
          writable: true
        });
      } else {
        out[k] = (tmp = val[k]) && typeof tmp === `\u006f\u0062\u006a\u0065\u0063\u0074` ? klona(tmp) : tmp;
      }
    }
    return out;
  }
  return val;
}
var _export_sfc = (sfc, props) => {
  const target = sfc.__vccOpts || sfc;
  for (const [key, val] of props) {
    target[key] = val;
  }
  return target;
};
const _sfc_main = defineComponent({
  props: {
    animationData: {
      type: Object,
      default: () => ({})
    },
    animationLink: {
      type: String,
      default: ``
    },
    loop: {
      type: [Boolean, Number],
      default: true
    },
    autoPlay: {
      type: Boolean,
      default: true
    },
    width: {
      type: [Number, String],
      default: `\u0031\u0030\u0030\u0025`
    },
    height: {
      type: [Number, String],
      default: `\u0031\u0030\u0030\u0025`
    },
    speed: {
      type: Number,
      default: 1
    },
    delay: {
      type: Number,
      default: 0
    },
    direction: {
      type: String,
      default: `\u0066\u006f\u0072\u0077\u0061\u0072\u0064`
    },
    pauseOnHover: {
      type: Boolean,
      default: false
    },
    playOnHover: {
      type: Boolean,
      default: false
    },
    backgroundColor: {
      type: String,
      default: `\u0074\u0072\u0061\u006e\u0073\u0070\u0061\u0072\u0065\u006e\u0074`
    },
    pauseAnimation: {
      type: Boolean,
      default: false
    },
    noMargin: {
      type: Boolean,
      default: false
    },
    scale: {
      type: Number,
      default: 1
    },
    renderer: {
      type: String,
      default: `\u0073\u0076\u0067`
    },
    rendererSettings: {
      type: Object,
      default: () => ({})
    },
    assetsPath: {
      type: String,
      default: ``
    }
  },
  emits: {
    onComplete: null,
    onLoopComplete: null,
    onEnterFrame: null,
    onSegmentStart: null,
    onAnimationLoaded: null
  },
  setup(props, {
    emit: emits
  }) {
    const lottieAnimationContainer = ref();
    let animationData;
    let lottieAnimation = null;
    let direction = 1;
    watchEffect(async () => {
      if (!lottieAnimationContainer.value) return;
      if (props.animationLink != ``) {
        try {
          const response = await fetch(props.animationLink);
          const responseJSON = await response.json();
          animationData = responseJSON;
        } catch (error) {
          console.error(error);
          return;
        }
      } else if (es6(props.animationData, {}) === false) {
        animationData = klona(props.animationData);
      } else {
        throw new Error(`\u0059\u006f\u0075\u0020\u006d\u0075\u0073\u0074\u0020\u0070\u0072\u006f\u0076\u0069\u0064\u0065\u0020\u0065\u0069\u0074\u0068\u0065\u0072\u0020\u0061\u006e\u0069\u006d\u0061\u0074\u0069\u006f\u006e\u004c\u0069\u006e\u006b\u0020\u006f\u0072\u0020\u0061\u006e\u0069\u006d\u0061\u0074\u0069\u006f\u006e\u0044\u0061\u0074\u0061`);
      }
      loadLottie();
    });
    const loadLottie = () => {
      if (!lottieAnimationContainer.value) return;
      if (!animationData) return;
      lottieAnimation == null ? void 0 : lottieAnimation.destroy();
      lottieAnimation = null;
      let autoPlay = props.autoPlay;
      let loop = props.loop;
      if (props.playOnHover) {
        autoPlay = false;
      }
      if (typeof loop === `\u006e\u0075\u006d\u0062\u0065\u0072`) {
        if (loop > 0) {
          loop = loop - 1;
        }
      }
      if (props.delay > 0) {
        autoPlay = false;
      }
      const lottieAnimationConfig = {
        container: lottieAnimationContainer.value,
        renderer: props.renderer,
        loop,
        autoplay: autoPlay,
        animationData,
        assetsPath: props.assetsPath
      };
      if (es6(props.rendererSettings, {}) === false) {
        lottieAnimationConfig.rendererSettings = props.rendererSettings;
      }
      if (props.scale !== 1) {
        lottieAnimationConfig.rendererSettings = __spreadProps(__spreadValues({}, lottieAnimationConfig.rendererSettings), {
          viewBoxOnly: true
        });
      }
      lottieAnimation = Lottie.loadAnimation(lottieAnimationConfig);
      setTimeout(() => {
        autoPlay = props.autoPlay;
        if (props.playOnHover) {
          lottieAnimation == null ? void 0 : lottieAnimation.pause();
        } else {
          if (autoPlay) {
            lottieAnimation == null ? void 0 : lottieAnimation.play();
          } else {
            lottieAnimation == null ? void 0 : lottieAnimation.pause();
          }
        }
        emits(`\u006f\u006e\u0041\u006e\u0069\u006d\u0061\u0074\u0069\u006f\u006e\u004c\u006f\u0061\u0064\u0065\u0064`);
      }, props.delay);
      lottieAnimation.setSpeed(props.speed);
      if (props.direction === `\u0072\u0065\u0076\u0065\u0072\u0073\u0065`) {
        lottieAnimation.setDirection(-1);
      }
      if (props.direction === `\u006e\u006f\u0072\u006d\u0061\u006c`) {
        lottieAnimation.setDirection(1);
      }
      if (props.pauseAnimation) {
        lottieAnimation.pause();
      } else {
        if (props.playOnHover) {
          lottieAnimation.pause();
        }
      }
      lottieAnimation.addEventListener(`\u006c\u006f\u006f\u0070\u0043\u006f\u006d\u0070\u006c\u0065\u0074\u0065`, () => {
        if (props.direction === `\u0061\u006c\u0074\u0065\u0072\u006e\u0061\u0074\u0065`) {
          lottieAnimation == null ? void 0 : lottieAnimation.stop();
          direction = direction === -1 ? 1 : -1;
          lottieAnimation == null ? void 0 : lottieAnimation.setDirection(direction);
          lottieAnimation == null ? void 0 : lottieAnimation.play();
        }
        emits(`\u006f\u006e\u004c\u006f\u006f\u0070\u0043\u006f\u006d\u0070\u006c\u0065\u0074\u0065`);
      });
      lottieAnimation.addEventListener(`\u0063\u006f\u006d\u0070\u006c\u0065\u0074\u0065`, () => {
        emits(`\u006f\u006e\u0043\u006f\u006d\u0070\u006c\u0065\u0074\u0065`);
      });
      lottieAnimation.addEventListener(`\u0065\u006e\u0074\u0065\u0072\u0046\u0072\u0061\u006d\u0065`, () => {
        emits(`\u006f\u006e\u0045\u006e\u0074\u0065\u0072\u0046\u0072\u0061\u006d\u0065`);
      });
      lottieAnimation.addEventListener(`\u0073\u0065\u0067\u006d\u0065\u006e\u0074\u0053\u0074\u0061\u0072\u0074`, () => {
        emits(`\u006f\u006e\u0053\u0065\u0067\u006d\u0065\u006e\u0074\u0053\u0074\u0061\u0072\u0074`);
      });
    };
    const getCurrentStyle = computed(() => {
      let width = props.width;
      let height = props.height;
      if (typeof props.width === `\u006e\u0075\u006d\u0062\u0065\u0072`) {
        width = `${props.width}\u0070\u0078`;
      }
      if (typeof props.height === `\u006e\u0075\u006d\u0062\u0065\u0072`) {
        height = `${props.height}\u0070\u0078`;
      }
      let cssVariables = {
        "--lottie-animation-container-width": width,
        "--lottie-animation-container-height": height,
        "--lottie-animation-container-background-color": props.backgroundColor,
        "--lottie-animation-margin": props.noMargin ? `\u0030` : `\u0030\u0020\u0061\u0075\u0074\u006f`,
        "--lottie-animation-scale": props.scale != 1 ? props.scale : ``
      };
      return cssVariables;
    });
    const hoverStarted = () => {
      if (lottieAnimation && props.pauseOnHover) {
        lottieAnimation.pause();
      }
      if (lottieAnimation && props.playOnHover) {
        lottieAnimation.play();
      }
    };
    const hoverEnded = () => {
      if (lottieAnimation && props.pauseOnHover) {
        lottieAnimation.play();
      }
      if (lottieAnimation && props.playOnHover) {
        lottieAnimation.pause();
      }
    };
    watch(() => props.pauseAnimation, () => {
      if ((props.pauseOnHover || props.playOnHover) && props.pauseAnimation) {
        console.error(`\u0049\u0066\u0020\u0079\u006f\u0075\u0020\u0061\u0072\u0065\u0020\u0075\u0073\u0069\u006e\u0067\u0020\u0070\u0061\u0075\u0073\u0065\u0041\u006e\u0069\u006d\u0061\u0074\u0069\u006f\u006e\u0020\u0070\u0072\u006f\u0070\u0020\u0066\u006f\u0072\u0020\u0056\u0075\u0065\u0033\u002d\u004c\u006f\u0074\u0074\u0069\u0065\u002c\u0020\u0070\u006c\u0065\u0061\u0073\u0065\u0020\u0072\u0065\u006d\u006f\u0076\u0065\u0020\u0074\u0068\u0065\u0020\u0070\u0072\u006f\u0070\u0073\u0020\u0070\u0061\u0075\u0073\u0065\u004f\u006e\u0048\u006f\u0076\u0065\u0072\u0020\u0061\u006e\u0064\u0020\u0070\u006c\u0061\u0079\u004f\u006e\u0048\u006f\u0076\u0065\u0072`);
        return;
      }
      if (lottieAnimation) {
        if (props.pauseAnimation) {
          lottieAnimation.pause();
        } else {
          lottieAnimation.play();
        }
      }
    });
    const play = () => {
      if (lottieAnimation) {
        lottieAnimation.play();
      }
    };
    const pause = () => {
      if (lottieAnimation) {
        lottieAnimation.pause();
      }
    };
    const stop = () => {
      if (lottieAnimation) {
        lottieAnimation.stop();
      }
    };
    const destroy = () => {
      if (lottieAnimation) {
        lottieAnimation.destroy();
      }
    };
    const setSpeed = (speed = 1) => {
      if (speed <= 0) {
        throw new Error(`\u0053\u0070\u0065\u0065\u0064\u0020\u006d\u0075\u0073\u0074\u0020\u0062\u0065\u0020\u0067\u0072\u0065\u0061\u0074\u0065\u0072\u0020\u0074\u0068\u0061\u006e\u0020\u0030`);
      }
      if (lottieAnimation) {
        lottieAnimation.setSpeed(speed);
      }
    };
    const setDirection = direction2 => {
      if (lottieAnimation) {
        if (direction2 === `\u0066\u006f\u0072\u0077\u0061\u0072\u0064`) {
          lottieAnimation.setDirection(1);
        } else if (direction2 === `\u0072\u0065\u0076\u0065\u0072\u0073\u0065`) {
          lottieAnimation.setDirection(-1);
        }
      }
    };
    const goToAndStop = (frame, isFrame = true) => {
      if (lottieAnimation) {
        lottieAnimation.goToAndStop(frame, isFrame);
      }
    };
    const goToAndPlay = (frame, isFrame = true) => {
      if (lottieAnimation) {
        lottieAnimation.goToAndPlay(frame, isFrame);
      }
    };
    const playSegments = (segments, forceFlag = false) => {
      if (lottieAnimation) {
        lottieAnimation.playSegments(segments, forceFlag);
      }
    };
    const setSubFrame = (useSubFrame = true) => {
      if (lottieAnimation) {
        lottieAnimation.setSubframe(useSubFrame);
      }
    };
    const getDuration = (inFrames = true) => {
      if (lottieAnimation) {
        return lottieAnimation.getDuration(inFrames);
      }
    };
    const updateDocumentData = (documentData, index2 = 0) => {
      if (lottieAnimation) {
        lottieAnimation.renderer.elements[index2].updateDocumentData(documentData);
      }
    };
    return {
      lottieAnimationContainer,
      hoverEnded,
      hoverStarted,
      getCurrentStyle,
      play,
      pause,
      stop,
      destroy,
      setSpeed,
      setDirection,
      goToAndStop,
      goToAndPlay,
      playSegments,
      setSubFrame,
      getDuration,
      updateDocumentData
    };
  }
});
function _sfc_render(_ctx, _cache, $props, $setup, $data, $options) {
  return openBlock(), createElementBlock(`\u0064\u0069\u0076`, {
    ref: `\u006c\u006f\u0074\u0074\u0069\u0065\u0041\u006e\u0069\u006d\u0061\u0074\u0069\u006f\u006e\u0043\u006f\u006e\u0074\u0061\u0069\u006e\u0065\u0072`,
    class: `\u006c\u006f\u0074\u0074\u0069\u0065\u002d\u0061\u006e\u0069\u006d\u0061\u0074\u0069\u006f\u006e\u002d\u0063\u006f\u006e\u0074\u0061\u0069\u006e\u0065\u0072`,
    style: normalizeStyle(_ctx.getCurrentStyle),
    onMouseenter: _cache[0] || (_cache[0] = (...args) => _ctx.hoverStarted && _ctx.hoverStarted(...args)),
    onMouseleave: _cache[1] || (_cache[1] = (...args) => _ctx.hoverEnded && _ctx.hoverEnded(...args))
  }, null, 36);
}
var Vue3Lottie = /* @__PURE__ */_export_sfc(_sfc_main, [[`\u0072\u0065\u006e\u0064\u0065\u0072`, _sfc_render]]);
var index = {
  install(app, options) {
    var _a;
    const name = (_a = options == null ? void 0 : options.name) != null ? _a : `\u0056\u0075\u0065\u0033\u004c\u006f\u0074\u0074\u0069\u0065`;
    app.component(name, Vue3Lottie);
  }
};
export { Vue3Lottie as V, index as i };