var __defProp = Object.defineProperty;
var __defNormalProp = (obj, key, value) => key in obj ? __defProp(obj, key, {
  enumerable: true,
  configurable: true,
  writable: true,
  value
}) : obj[key] = value;
var __publicField = (obj, key, value) => __defNormalProp(obj, typeof key !== "symbol" ? key + "" : key, value);
const _StorageUtil = class _StorageUtil {
  constructor() {
    __publicField(this, "onCallBackHandlers");
    this.onCallBackHandlers = [];
  }
  // 获取唯一实例的方法
  static getInstance() {
    if (!_StorageUtil.instance) {
      _StorageUtil.instance = new _StorageUtil();
    }
    return _StorageUtil.instance;
  }
  addHandlers(handler) {
    this.onCallBackHandlers.push(handler);
  }
  removeListener(handler) {
    let removeIndex = -1;
    for (let i = 0; i < this.onCallBackHandlers.length; i++) {
      if (this.onCallBackHandlers[i] === handler) {
        removeIndex = i;
        break;
      }
    }
    if (removeIndex !== -1) {
      this.onCallBackHandlers.splice(removeIndex, 1);
    }
  }
  startOnChangedListener() {
    chrome.storage.onChanged.addListener((changes, namespace) => {
      this.onCallBackHandlers.forEach(onCallBackHandler => {
        onCallBackHandler(changes, namespace);
      });
    });
  }
};
__publicField(_StorageUtil, "instance");
let StorageUtil = _StorageUtil;
let storageUtil = StorageUtil.getInstance();
const indexPage = "DouYin_Setting";
const runPages = ["DouYin_Run"];
const reportPages = ["DouYin_Setting"];
const _UseCounterStore = class _UseCounterStore {
  constructor() {
    /**
     * 用户id
     */
    __publicField(this, "userId");
    __publicField(this, "userName");
    __publicField(this, "tenantId");
    __publicField(this, "webUserId");
    __publicField(this, "webUserName");
    __publicField(this, "webUserAvatarUrl");
    __publicField(this, "webPort");
    __publicField(this, "accessToken");
    __publicField(this, "runLogs");
    // 当前页面
    __publicField(this, "activatePage");
    // 是否关闭了
    __publicField(this, "closeStop");
    // 配置
    __publicField(this, "XiaoHongShu_Setting");
    //浏览数量
    __publicField(this, "viewCount");
    // 评论数量
    __publicField(this, "CommentCount");
    // 点赞数量
    __publicField(this, "likeCount");
    // 关注数量
    __publicField(this, "followCount");
    //收藏
    __publicField(this, "collectCount");
    __publicField(this, "xhs_viewCount");
    __publicField(this, "xhs_CommentCount");
    // 初始化
    __publicField(this, "xhs_likeCount");
    // 初始化
    __publicField(this, "xhs_followCount");
    // 初始化
    __publicField(this, "xhs_collectCount");
    __publicField(this, "dy_viewCount");
    __publicField(this, "dy_CommentCount");
    // 初始化
    __publicField(this, "dy_likeCount");
    // 初始化
    __publicField(this, "dy_followCount");
    // 初始化
    __publicField(this, "dy_collectCount");
    //弹窗验证码出现次数
    __publicField(this, "captcha_container_num");
    //工作状态
    // run：工作中
    // end: 已结束（到达底部）
    __publicField(this, "XiaoHongShu_workStatus");
    __publicField(this, "loadend");
    //当前窗口的tabId
    __publicField(this, "chromeTabId");
    __publicField(this, "isDebugMode");
    __publicField(this, "operationTime");
    __publicField(this, "XiaoHongShu_search_runNumber");
    __publicField(this, "DouYin_search_runNumber");
    __publicField(this, "XiaoHongShu_avgTime");
    //今日运行小红书的账号时间
    __publicField(this, "xiaoHongShuAccountRunTodayDate");
    //今日运行小红书的账号次数
    __publicField(this, "xiaoHongShuAccountIds");
    //今日运行小红书的账号最大次数
    __publicField(this, "xiaoHongShuAccountRunTodayMaxNum");
    __publicField(this, "executeOperationStartTime");
    __publicField(this, "executeOperationEndTime");
    //客户端id
    __publicField(this, "clientVisitorId");
    // vip到期时间
    __publicField(this, "userInfoEndDate");
    //vip日期更新
    __publicField(this, "updateVipDateTime");
    //小红书 关键词 列表
    __publicField(this, "xhs_keywords_list");
    __publicField(this, "douYin_keywords_list");
    __publicField(this, "mqttStart");
    __publicField(this, "optionWhere");
    __publicField(this, "refreshFrequencyNum");
    __publicField(this, "terminalData");
    __publicField(this, "taskId");
    __publicField(this, "executeId");
    // 运行时长
    __publicField(this, "runTimeNum");
    __publicField(this, "runTimeMaxNum");
    __publicField(this, "xhs_minute");
    __publicField(this, "dy_minute");
    __publicField(this, "corpusData");
    // 自动回复评论数量
    __publicField(this, "XiaoHongShu_CommentCount");
    //赞和收藏的
    // 取关数量
    __publicField(this, "XiaoHongShu_likes_unfollow");
    // 回关数量
    __publicField(this, "XiaoHongShu_likes_follow");
    //新增关注
    // 取关数量
    __publicField(this, "XiaoHongShu_connections_unfollow");
    // 回关数量
    __publicField(this, "XiaoHongShu_connections_follow");
    //自动回复评论的记录
    __publicField(this, "commentViewPaths");
    //回关的记录
    __publicField(this, "viewedPaths");
    //取关的记录
    __publicField(this, "connections_unfollow_viewedPaths");
    __publicField(this, "followPaths");
    __publicField(this, "lastLikeFlowDate");
    __publicField(this, "contentText");
    __publicField(this, "replyComment");
    this.userId = "";
    this.userName = "";
    this.tenantId = "";
    this.webUserId = "";
    this.webUserName = "";
    this.webUserAvatarUrl = "";
    this.webPort = 65400;
    this.accessToken = "";
    this.runLogs = "";
    this.mqttStart = "";
    this.activatePage = indexPage;
    this.closeStop = false;
    this.XiaoHongShu_Setting = "{}";
    this.viewCount = 0;
    this.CommentCount = 0;
    this.likeCount = 0;
    this.followCount = 0;
    this.collectCount = 0;
    this.xhs_viewCount = 0;
    this.xhs_CommentCount = 0;
    this.xhs_likeCount = 0;
    this.xhs_followCount = 0;
    this.xhs_collectCount = 0;
    this.dy_viewCount = 0;
    this.dy_CommentCount = 0;
    this.dy_likeCount = 0;
    this.dy_followCount = 0;
    this.dy_collectCount = 0;
    this.captcha_container_num = 0;
    this.XiaoHongShu_workStatus = "run";
    this.loadend = false;
    this.chromeTabId = 0;
    this.isDebugMode = false;
    this.operationTime = 0;
    this.XiaoHongShu_avgTime = 0;
    this.XiaoHongShu_search_runNumber = 1;
    this.DouYin_search_runNumber = 1;
    this.xiaoHongShuAccountRunTodayDate = {};
    this.xiaoHongShuAccountIds = {};
    this.xiaoHongShuAccountRunTodayMaxNum = 3;
    this.executeOperationStartTime = 0;
    this.executeOperationEndTime = 0;
    this.clientVisitorId = "";
    this.userInfoEndDate = "";
    this.updateVipDateTime = "";
    this.xhs_keywords_list = [];
    this.douYin_keywords_list = [];
    this.optionWhere = {};
    this.refreshFrequencyNum = 60 * 60 * 1e3;
    this.taskId = "";
    this.executeId = "";
    this.terminalData = {};
    this.runTimeNum = 0;
    this.runTimeMaxNum = 9999;
    this.xhs_minute = [];
    this.dy_minute = [];
    this.terminalData = {};
    this.runLogs = "";
    this.corpusData = {};
    this.contentText = "";
    this.replyComment = "";
    this.XiaoHongShu_CommentCount = 0;
    this.XiaoHongShu_likes_unfollow = 0;
    this.XiaoHongShu_likes_follow = 0;
    this.XiaoHongShu_connections_unfollow = 0;
    this.XiaoHongShu_connections_follow = 0;
    this.viewedPaths = [];
    this.connections_unfollow_viewedPaths = [];
    this.commentViewPaths = [];
    this.followPaths = [];
    this.lastLikeFlowDate = null;
  }
  // 获取唯一实例的方法
  static getInstance() {
    if (!_UseCounterStore.instance) {
      _UseCounterStore.instance = new _UseCounterStore();
      _UseCounterStore.instance.loadFromStorage();
    }
    return _UseCounterStore.instance;
  }
  setOperationTime(operationTime) {
    this.operationTime = operationTime;
    chrome.storage.local.set({
      "operationTime": this.operationTime
    });
  }
  setChromeTabId(chromeTabId) {
    this.chromeTabId = chromeTabId;
  }
  setWebUserId(userId) {
    this.webUserId = userId;
  }
  setWebUserName(webUserName) {
    this.webUserName = webUserName;
  }
  setWebUserAvatarUrl(webUserAvatarUrl) {
    this.webUserAvatarUrl = webUserAvatarUrl;
  }
  setUserId(userId) {
    this.userId = userId;
  }
  setAccessToken(accessToken) {
    this.accessToken = accessToken;
    chrome.storage.local.set({
      "accessToken": this.accessToken
    });
  }
  set_updateVipDateTime(updateVipDateTime) {
    this.updateVipDateTime = updateVipDateTime;
    chrome.storage.local.set({
      "updateVipDateTime": this.updateVipDateTime
    });
  }
  setUserInfoEndDate(userInfoEndDate) {
    this.userInfoEndDate = userInfoEndDate;
    chrome.storage.local.set({
      "userInfoEndDate": userInfoEndDate
    });
  }
  increment_xhs_viewCount() {
    this.xhs_viewCount++;
    chrome.storage.local.set({
      "xhs_viewCount": this.xhs_viewCount
    });
  }
  increment_xhs_CommentCount() {
    this.xhs_CommentCount++;
    chrome.storage.local.set({
      "xhs_CommentCount": this.xhs_CommentCount
    });
  }
  increment_xhs_likeCount() {
    this.xhs_likeCount++;
    chrome.storage.local.set({
      "xhs_likeCount": this.xhs_likeCount
    });
  }
  increment_xhs_followCount() {
    this.xhs_followCount++;
    chrome.storage.local.set({
      "xhs_followCount": this.xhs_followCount
    });
  }
  increment_xhs_collectCount() {
    this.xhs_collectCount++;
    chrome.storage.local.set({
      "xhs_collectCount": this.xhs_collectCount
    });
  }
  increment_dy_viewCount() {
    this.dy_viewCount++;
    chrome.storage.local.set({
      "dy_viewCount": this.dy_viewCount
    });
  }
  increment_dy_CommentCount() {
    this.dy_CommentCount++;
    chrome.storage.local.set({
      "dy_CommentCount": this.dy_CommentCount
    });
  }
  increment_dy_likeCount() {
    this.dy_likeCount++;
    chrome.storage.local.set({
      "dy_likeCount": this.dy_likeCount
    });
  }
  increment_dy_followCount() {
    this.dy_followCount++;
    chrome.storage.local.set({
      "dy_followCount": this.dy_followCount
    });
  }
  increment_dy_collectCount() {
    this.dy_collectCount++;
    chrome.storage.local.set({
      "dy_collectCount": this.dy_collectCount
    });
  }
  isNotRunWork() {
    console.log("isNotRunWork activatePage", this.activatePage, !runPages.includes(this.activatePage));
    return !runPages.includes(this.activatePage);
  }
  increment_captcha_container_num() {
    this.captcha_container_num++;
    chrome.storage.local.set({
      "captcha_container_num": this.captcha_container_num
    });
  }
  setActivatePage(page) {
    console.log("setActivatePage", this.activatePage);
    this.activatePage = page;
  }
  setCloseStop(closeStop) {
    this.closeStop = closeStop;
  }
  setXiaoHongShu_workStatus(status) {
    this.XiaoHongShu_workStatus = status;
    chrome.storage.local.set({
      "XiaoHongShu_workStatus": this.XiaoHongShu_workStatus
    });
  }
  setXiaoHongShu_avgTime(avgTime) {
    this.XiaoHongShu_avgTime = avgTime;
    chrome.storage.local.set({
      "XiaoHongShu_avgTime": this.XiaoHongShu_avgTime
    });
  }
  setExecuteOperationStartTime(executeOperationStartTime) {
    this.executeOperationStartTime = executeOperationStartTime;
  }
  setExecuteOperationEndTime(executeOperationEndTime) {
    this.executeOperationEndTime = executeOperationEndTime;
    chrome.storage.local.set({
      "executeOperationEndTime": this.executeOperationEndTime
    });
  }
  setXHSKeywords_list(xhs_keywords_list) {
    this.xhs_keywords_list = xhs_keywords_list;
    chrome.storage.local.set({
      "xhs_keywords_list": JSON.stringify(this.xhs_keywords_list)
    });
  }
  setDouYinKeywords_list(douYin_keywords_list) {
    this.douYin_keywords_list = douYin_keywords_list;
    chrome.storage.local.set({
      "douYin_keywords_list": JSON.stringify(this.douYin_keywords_list)
    });
  }
  increment_XiaoHongShu_search_runNumber() {
    this.XiaoHongShu_search_runNumber += 1;
    chrome.storage.local.set({
      "XiaoHongShu_search_runNumber": this.XiaoHongShu_search_runNumber
    });
  }
  increment_DouYin_search_runNumber() {
    this.DouYin_search_runNumber += 1;
    chrome.storage.local.set({
      "DouYin_search_runNumber": this.DouYin_search_runNumber
    });
  }
  increment_XiaoHongShuAccountRunTodayIds(platform, xiaoHongShuAccountIds) {
    let recordData = this.xiaoHongShuAccountIds[platform];
    if (!recordData) {
      recordData = /* @__PURE__ */new Set();
      this.xiaoHongShuAccountIds[platform] = recordData;
    }
    recordData.add(xiaoHongShuAccountIds);
  }
  setXiaoHongShuAccountRunTodayIds(platform, xiaoHongShuAccountIds) {
    this.xiaoHongShuAccountIds[platform] = xiaoHongShuAccountIds;
  }
  getXiaoHongShuAccountRunTodayIds(platform) {
    let recordData = this.xiaoHongShuAccountIds[platform];
    if (!recordData) {
      recordData = /* @__PURE__ */new Set();
    }
    return recordData;
  }
  setXiaoHongShuAccountRunTodayDate(platform, xiaoHongShuAccountRunTodayDate) {
    this.xiaoHongShuAccountRunTodayDate[platform] = xiaoHongShuAccountRunTodayDate;
  }
  getXiaoHongShuAccountRunTodayDate(platform) {
    return this.xiaoHongShuAccountRunTodayDate[platform] ?? "";
  }
  setXiaoHongShuAccountErrorTip(errorMessage) {
    chrome.storage.local.set({
      "xiaoHongShuAccountErrorTip": errorMessage
    });
  }
  setClientVisitorId(clientVisitorId) {
    this.clientVisitorId = clientVisitorId;
    chrome.storage.local.set({
      "clientVisitorId": clientVisitorId
    });
  }
  getOptionWhere() {
    return this.optionWhere;
  }
  setRefreshFrequencyNum(refreshFrequencyNum) {
    this.refreshFrequencyNum = refreshFrequencyNum;
    chrome.storage.local.set({
      "refreshFrequencyNum": refreshFrequencyNum
    });
  }
  increment_XiaoHongShu_CommentCount() {
    this.XiaoHongShu_CommentCount++;
    chrome.storage.local.set({
      "XiaoHongShu_CommentCount": this.XiaoHongShu_CommentCount
    });
  }
  increment_XiaoHongShu_likes_unfollow() {
    this.XiaoHongShu_likes_unfollow++;
    chrome.storage.local.set({
      "XiaoHongShu_likes_unfollow": this.XiaoHongShu_likes_unfollow
    });
  }
  increment_XiaoHongShu_likes_follow() {
    this.XiaoHongShu_likes_follow++;
    chrome.storage.local.set({
      "XiaoHongShu_likes_follow": this.XiaoHongShu_likes_follow
    });
  }
  increment_XiaoHongShu_connections_unfollow() {
    this.XiaoHongShu_connections_unfollow++;
    chrome.storage.local.set({
      "XiaoHongShu_connections_unfollow": this.XiaoHongShu_connections_unfollow
    });
  }
  increment_XiaoHongShu_connections_follow() {
    this.XiaoHongShu_connections_follow++;
    chrome.storage.local.set({
      "XiaoHongShu_connections_follow": this.XiaoHongShu_connections_follow
    });
  }
  setLastLikeFlowDate(lastLikeFlowDate) {
    this.lastLikeFlowDate = lastLikeFlowDate;
    let lastLikeFlowDate_str = `${lastLikeFlowDate.getFullYear()}-${String(lastLikeFlowDate.getMonth() + 1).padStart(2, "0")}-${String(lastLikeFlowDate.getDate()).padStart(2, "0")} ${String(lastLikeFlowDate.getHours()).padStart(2, "0")}:${String(lastLikeFlowDate.getMinutes()).padStart(2, "0")}:${String(lastLikeFlowDate.getSeconds()).padStart(2, "0")}`;
    chrome.storage.local.set({
      "lastLikeFlowDate": lastLikeFlowDate_str
    });
  }
  setCorpusData(corpusData) {
    if (corpusData == null) {
      corpusData = {};
    }
    this.corpusData = corpusData;
    chrome.storage.local.set({
      "corpusData": JSON.stringify(this.corpusData)
    });
  }
  setRunLogs(runLogs) {
    this.runLogs = runLogs;
    chrome.storage.local.set({
      "runLogs": this.runLogs
    });
  }
  setContentText(contentText) {
    this.contentText = contentText;
    chrome.storage.local.set({
      "contentText": this.contentText
    });
  }
  setReplyComment(replyComment2) {
    this.replyComment = replyComment2;
    chrome.storage.local.set({
      "replyComment": this.replyComment
    });
  }
  checkLoadend() {
    let maxNum = 60,
      timeout = 30;
    let num = 0;
    return new Promise(resolve => {
      const checkInterval2 = setInterval(() => {
        const loadend = this.loadend;
        if (loadend || num > maxNum) {
          if (num > maxNum) {
            console.error("checkLoadend 加载超时");
          }
          clearInterval(checkInterval2);
          resolve();
        }
        num++;
      }, timeout);
    });
  }
  loadFromStorage() {
    chrome.storage.local.get(["userId", "userName", "webUserId", "webUserName", "webUserAvatarUrl", "webPort", "tenantId", "accessToken", "activatePage", "XiaoHongShu_Setting", "xhs_viewCount", "xhs_CommentCount", "xhs_likeCount", "xhs_followCount", "xhs_collectCount", "dy_viewCount", "dy_CommentCount", "dy_likeCount", "dy_followCount", "dy_collectCount", "captcha_container_num", "XiaoHongShu_workStatus", "XiaoHongShu_avgTime", "XiaoHongShu_search_runNumber", "DouYin_search_runNumber", "executeOperationStartTime", "clientVisitorId", "userInfoEndDate", "xhs_minute", "dy_minute", "mqttStart", "optionWhere", "terminalData", "taskId", "executeId", "runTimeNum", "runTimeMaxNum", "corpusData"], result => {
      console.log("result activatePage", result);
      if (result.userId !== void 0) {
        this.userId = result.userId;
      }
      if (result.accessToken !== void 0) {
        this.accessToken = result.accessToken;
      }
      if (result.activatePage !== void 0) {
        this.activatePage = result.activatePage;
      }
      if (result.XiaoHongShu_Setting !== void 0) {
        this.XiaoHongShu_Setting = result.XiaoHongShu_Setting;
      }
      if (result.xhs_viewCount !== void 0) {
        this.xhs_viewCount = result.xhs_viewCount;
      }
      if (result.xhs_CommentCount !== void 0) {
        this.xhs_CommentCount = result.xhs_CommentCount;
      }
      if (result.xhs_likeCount !== void 0) {
        this.xhs_likeCount = result.xhs_likeCount;
      }
      if (result.xhs_followCount !== void 0) {
        this.xhs_followCount = result.xhs_followCount;
      }
      if (result.xhs_collectCount !== void 0) {
        this.xhs_collectCount = result.xhs_collectCount;
      }
      if (result.dy_viewCount !== void 0) {
        this.dy_viewCount = result.dy_viewCount;
      }
      if (result.dy_CommentCount !== void 0) {
        this.dy_CommentCount = result.dy_CommentCount;
      }
      if (result.dy_likeCount !== void 0) {
        this.dy_likeCount = result.dy_likeCount;
      }
      if (result.dy_followCount !== void 0) {
        this.dy_followCount = result.dy_followCount;
      }
      if (result.dy_collectCount !== void 0) {
        this.dy_collectCount = result.dy_collectCount;
      }
      if (result.captcha_container_num !== void 0) {
        this.captcha_container_num = result.captcha_container_num;
      }
      if (result.XiaoHongShu_workStatus !== void 0) {
        this.XiaoHongShu_workStatus = result.XiaoHongShu_workStatus;
      }
      if (result.XiaoHongShu_avgTime !== void 0) {
        this.XiaoHongShu_avgTime = result.XiaoHongShu_avgTime;
      }
      if (result.XiaoHongShu_search_runNumber !== void 0) {
        this.XiaoHongShu_search_runNumber = result.XiaoHongShu_search_runNumber;
      }
      if (result.DouYin_search_runNumber !== void 0) {
        this.DouYin_search_runNumber = result.DouYin_search_runNumber;
      }
      if (result.executeOperationStartTime !== void 0) {
        this.executeOperationStartTime = result.executeOperationStartTime;
      }
      if (result.clientVisitorId !== void 0) {
        this.clientVisitorId = result.clientVisitorId;
      }
      if (result.userInfoEndDate !== void 0) {
        this.userInfoEndDate = result.userInfoEndDate;
      }
      if (result.mqttStart !== void 0) {
        this.mqttStart = result.mqttStart;
      }
      if (result.taskId !== void 0) {
        this.taskId = result.taskId;
      }
      if (result.xhs_minute !== void 0) {
        this.xhs_minute = result.xhs_minute ? JSON.parse(result.xhs_minute) : [];
      }
      if (result.dy_minute !== void 0) {
        this.dy_minute = result.dy_minute ? JSON.parse(result.dy_minute) : [];
      }
      if (result.terminalData !== void 0) {
        this.terminalData = result.terminalData ? JSON.parse(result.terminalData) : {};
      }
      if (result.optionWhere !== void 0) {
        this.optionWhere = result.optionWhere ? JSON.parse(result.optionWhere) : {};
      }
      if (result.tenantId !== void 0) {
        this.tenantId = result.tenantId;
      }
      if (result.executeId !== void 0) {
        this.executeId = result.executeId;
      }
      if (result.runTimeNum !== void 0) {
        this.runTimeNum = result.runTimeNum;
      }
      if (result.runTimeMaxNum !== void 0) {
        this.runTimeMaxNum = result.runTimeMaxNum;
      }
      if (result.corpusData !== void 0) {
        this.corpusData = result.corpusData == "" ? {} : JSON.parse(result.corpusData);
      }
      if (result.webUserId !== void 0) {
        this.webUserId = result.webUserId;
      }
      if (result.webUserName !== void 0) {
        this.webUserName = result.webUserName;
      }
      if (result.webUserAvatarUrl !== void 0) {
        this.webUserAvatarUrl = result.webUserAvatarUrl;
      }
      if (result.webPort !== void 0) {
        this.webPort = result.webPort;
      }
      if (result.contentText !== void 0) {
        this.contentText = result.contentText;
      }
      if (result.replyComment !== void 0) {
        this.replyComment = result.replyComment;
      }
      if (result.userName !== void 0) {
        this.userName = result.userName;
      }
      this.loadend = true;
    });
    const callBackListener = (changes, namespace) => {
      for (let [key, {
        oldValue,
        newValue
      }] of Object.entries(changes)) {
        console.log(`Storage key "${key}" in namespace "${namespace}" changed.`, `Old value was "${oldValue}", new value is "${newValue}".`);
        switch (key) {
          case "activatePage":
            this.setActivatePage(newValue);
            break;
          case "xhs_likeCount":
            this.xhs_likeCount = newValue;
            break;
          case "xhs_followCount":
            this.xhs_followCount = newValue;
            break;
          case "xhs_CommentCount":
            this.xhs_CommentCount = newValue;
            break;
          case "xhs_collectCount":
            this.xhs_collectCount = newValue;
            break;
          case "xhs_viewCount":
            this.xhs_viewCount = newValue;
            break;
          case "dy_likeCount":
            this.dy_likeCount = newValue;
            break;
          case "dy_followCount":
            this.dy_followCount = newValue;
            break;
          case "dy_CommentCount":
            this.dy_CommentCount = newValue;
            break;
          case "dy_collectCount":
            this.dy_collectCount = newValue;
            break;
          case "dy_viewCount":
            this.dy_viewCount = newValue;
            break;
          case "captcha_container_num":
            this.captcha_container_num = newValue;
            break;
          case "executeOperationStartTime":
            this.executeOperationStartTime = newValue;
            break;
          case "clientVisitorId":
            this.clientVisitorId = newValue;
            break;
          case "userInfoEndDate":
            this.userInfoEndDate = newValue;
            break;
          case "taskId":
            this.taskId = newValue;
            break;
          case "xhs_minute":
            this.xhs_minute = newValue ? JSON.parse(newValue) : [];
            break;
          case "dy_minute":
            this.dy_minute = newValue ? JSON.parse(newValue) : [];
            break;
          case "optionWhere":
            this.optionWhere = newValue ? JSON.parse(newValue) : {};
            break;
          case "tenantId":
            this.tenantId = newValue;
            break;
          case "executeId":
            this.executeId = newValue;
            break;
          case "terminalData":
            this.terminalData = newValue == "" ? {} : JSON.parse(newValue);
            break;
          case "runTimeNum":
            this.runTimeNum = newValue;
            break;
          case "runTimeMaxNum":
            this.runTimeMaxNum = newValue;
            break;
          case "corpusData":
            this.corpusData = newValue == "" ? {} : JSON.parse(newValue);
            break;
          case "userName":
            this.userName = newValue;
            break;
          case "webUserId":
            this.webUserId = newValue;
            break;
          case "webUserName":
            this.webUserName = newValue;
            break;
          case "webUserAvatarUrl":
            this.webUserAvatarUrl = newValue;
            break;
          case "webPort":
            this.webPort = newValue;
            break;
          case "XiaoHongShu_avgTime":
            this.XiaoHongShu_avgTime = newValue;
            break;
          case "contentText":
            this.contentText = newValue;
            break;
          case "replyComment":
            this.replyComment = newValue;
            break;
        }
      }
    };
    storageUtil.removeListener(callBackListener);
    storageUtil.addHandlers(callBackListener);
  }
};
__publicField(_UseCounterStore, "instance");
let UseCounterStore = _UseCounterStore;
const store_console = UseCounterStore.getInstance();
store_console.isDebugMode = true;
if (!store_console.isDebugMode) {
  const originalConsoleLog = console.log;
  console.log = (...args) => {
    if (store_console.isDebugMode) {
      originalConsoleLog(...args);
    }
  };
}
if (!store_console.isDebugMode) {
  const originalConsoleError = console.error;
  console.error = (...args) => {
    if (store_console.isDebugMode) {
      originalConsoleError(...args);
    }
  };
}
if (!store_console.isDebugMode) {
  const originalConsoleInfo = console.info;
  console.info = (...args) => {
    if (store_console.isDebugMode) {
      originalConsoleInfo(...args);
    }
  };
}
const baseURL$1 = "https://plugin-api-adlrdojbyd.ap-northeast-1.fcapp.run";
const VITE_LOGIN_API$1 = "https://global-auth.petron.ai";
const store$9 = UseCounterStore.getInstance();
async function queryComment$1(refer_id) {
  const url = baseURL$1 + `/api/v2/oss/objects/${refer_id}`;
  const headers = {
    "Content-Type": "application/json",
    "Authorization": "Bearer " + store$9.accessToken
  };
  try {
    const response = await fetch(url, {
      method: "GET",
      headers
    });
    if (!response.ok) {
      if (response.status === 404) {
        const result2 = await response.json();
        console.log("result", result2);
        sendLog("查询评论错误 404" + (result2 == null ? void 0 : result2.detail));
        if ((result2 == null ? void 0 : result2.detail) == "XhsContent not found") {
          return true;
        }
      }
      if (response.status === 401) {
        sendLog("登录失效");
        store$9.setAccessToken("");
      } else {
        const result2 = await response.json();
        console.log("result", result2);
        sendLog("查询评论错误 其他" + (result2 == null ? void 0 : result2.detail));
      }
      console.error(`HTTP error! status: ${response.status}`, response);
      return false;
    }
    const result = await response.json();
    console.log("result", result);
    if (!result) {
      return true;
    }
    return false;
  } catch (error) {
    console.error("Error:", error);
    sendLog("查询评论错误" + error);
  }
  return false;
}
async function saveComment$1(saveData) {
  const url = baseURL$1 + `/api/v2/oss/objects`;
  const headers = {
    "Content-Type": "application/json",
    "Authorization": "Bearer " + store$9.accessToken
  };
  try {
    const response = await fetch(url, {
      method: "POST",
      headers,
      body: JSON.stringify(saveData)
    });
    if (!response.ok) {
      console.error(`HTTP error! status: ${response.status}`, response);
      if (response.status === 401) {
        sendLog("登录失效");
        store$9.setAccessToken("");
      } else {
        const result2 = await response.json();
        console.log("result", result2);
        sendLog("保存评论错误 其他" + (result2 == null ? void 0 : result2.detail));
      }
      return false;
    }
    const result = await response.json();
    console.log("result", result);
    return true;
  } catch (error) {
    console.error("Error:", error);
    sendLog("保存评论错误" + error);
  }
  return false;
}
async function setXiaoHongShuAccountRunTodayNum(accessToken, postData) {
  const url = baseURL$1 + "/api/v2/oss/objects";
  try {
    const headers = {
      "Content-Type": "application/json",
      "Authorization": "Bearer " + accessToken
    };
    const response = await fetch(url, {
      method: "POST",
      headers,
      body: JSON.stringify(postData)
    });
    if (!response.ok) {
      console.error(`HTTP error! status: ${response.status}`, response);
      return void 0;
    }
    const result = await response.json();
    console.log("result", result);
    return result;
  } catch (error) {
    console.error("Error:", error);
  }
  return void 0;
}
async function getXiaoHongShuAccountRunTodayNum(accessToken, key, userId) {
  const url = baseURL$1 + "/api/v2/oss/objects/" + key + "?belong_to=" + userId;
  try {
    const headers = {
      "Content-Type": "application/json",
      "Authorization": "Bearer " + accessToken
    };
    const response = await fetch(url, {
      method: "get",
      headers
    });
    if (!response.ok) {
      console.error(`HTTP error! status: ${response.status}`, response);
      return void 0;
    }
    const result = await response.json();
    console.log("result", result);
    return result;
  } catch (error) {
    console.error("Error:", error);
  }
  return void 0;
}
const addObjects = async postData => {
  const url = baseURL$1 + "/api/v2/oss/objects";
  const headers = {
    "Content-Type": "application/json",
    "Authorization": "Bearer " + store$9.accessToken
  };
  try {
    const response = await fetch(url, {
      method: "POST",
      headers,
      body: JSON.stringify(postData)
    });
    if (!response.ok) {
      sendLog("addObjects url:" + url + "，header:" + JSON.stringify(headers) + ", response status:" + response.status);
      console.error(`HTTP error! status: ${response.status}`);
      return void 0;
    }
    const result = await response.json();
    sendLog("addObjects url:" + url + "，header:" + JSON.stringify(headers) + ",postData：" + JSON.stringify(postData) + " response status:" + response.status + ", response data:" + JSON.stringify(result));
    console.log("result", result);
    return result;
  } catch (error) {
    sendLog("addObjects url:" + url + "，header:" + JSON.stringify(headers) + ", error" + error);
    console.error("Error:", error);
  }
  return void 0;
};
const getObjects = async key => {
  const url = `${baseURL$1}/api/v2/oss/objects/${key}`;
  const headers = {
    "Content-Type": "application/json",
    "Authorization": "Bearer " + store$9.accessToken
  };
  try {
    const response = await fetch(url, {
      method: "get",
      headers
    });
    if (!response.ok) {
      sendLog("getObjects url:" + url + "，header:" + JSON.stringify(headers) + ", response status:" + response.status);
      console.error(`HTTP error! status: ${response.status}`, response);
      return void 0;
    }
    const result = await response.json();
    sendLog("getObjects url:" + url + "，header:" + JSON.stringify(headers) + ", response status:" + response.status + ", response data:" + JSON.stringify(result));
    console.log("result", result);
    return result;
  } catch (error) {
    sendLog("getObjects url:" + url + "，header:" + JSON.stringify(headers) + ", error" + error);
    console.error("Error:", error);
  }
  return void 0;
};
const queryObjects = async queryParams => {
  const params = new URLSearchParams();
  queryParams.forEach(param => params.append(param.key, String(param.value)));
  const url = `${baseURL$1}/api/v2/oss/objects?${params.toString()}`;
  const headers = {
    "Content-Type": "application/json",
    "Authorization": "Bearer " + store$9.accessToken
  };
  try {
    const response = await fetch(url, {
      method: "get",
      headers
    });
    if (!response.ok) {
      sendLog("queryObjects url:" + url + "，header:" + JSON.stringify(headers) + ", response status:" + response.status);
      console.error(`queryObjects HTTP error! status: ${response.status}`, response);
      return void 0;
    }
    const result = await response.json();
    sendLog("url:" + url + "，header:" + JSON.stringify(headers) + ", response status:" + response.status + ", response data:" + JSON.stringify(result));
    console.log("queryObjects result", result);
    return result;
  } catch (error) {
    console.error("queryObjects Error:", error);
    sendLog("url:" + url + "，header:" + JSON.stringify(headers) + ", error" + error);
  }
  return void 0;
};
async function logout(accessToken) {
  const url = VITE_LOGIN_API$1 + "/api/v1/workos/logout";
  const headers = {
    "Content-Type": "application/json",
    "Authorization": "Bearer " + accessToken
  };
  try {
    const response = await fetch(url, {
      method: "get",
      headers
    });
    if (!response.ok) {
      sendLog("url:" + url + "，header:" + JSON.stringify(headers) + ", response status:" + response.status);
      console.error(`HTTP error! status: ${response.status}`, response);
      if (response.status == 404) {
        return void 0;
      }
      return void 0;
    }
    const result = await response.json();
    sendLog("url:" + url + "，header:" + JSON.stringify(headers) + ", response status:" + response.status + ", response data:" + JSON.stringify(result));
    console.log("result", result);
    return result;
  } catch (error) {
    sendLog("url:" + url + "，header:" + JSON.stringify(headers) + ", error" + error);
    console.error("Error:", error);
  }
  return void 0;
}
async function putBurialPoint(postData) {
  console.log("putBurialPoint", postData);
  const url = VITE_LOGIN_API$1 + "/api/v1/analytics_events";
  const headers = {
    "Content-Type": "application/json",
    "Authorization": "Bearer " + store$9.accessToken
  };
  try {
    const response = await fetch(url, {
      method: "POST",
      headers,
      body: JSON.stringify(postData)
    });
    if (!response.ok) {
      sendLog("url:" + url + "，header:" + JSON.stringify(headers) + ", response status:" + response.status);
      console.error(`HTTP error! status: ${response.status}`);
      if (response.status === 401) {
        console.log("登录失效");
        store$9.setAccessToken("");
        store$9.set_updateVipDateTime("");
        store$9.setUserInfoEndDate("");
        await logout(store$9.accessToken);
      }
      if (response.status == 404) {
        return void 0;
      }
      return void 0;
    }
    const result = await response.json();
    sendLog("url:" + url + "，header:" + JSON.stringify(headers) + ",postData：" + JSON.stringify(postData) + " response status:" + response.status + ", response data:" + JSON.stringify(result));
    console.log("result", result);
    return result;
  } catch (error) {
    sendLog("url:" + url + "，header:" + JSON.stringify(headers) + ", error" + error);
    console.error("Error:", error);
  }
  return void 0;
}
const dify_base_url$1 = "https://dify.fsotool.com";
UseCounterStore.getInstance();
async function runWorkflow$1(inputs, files, apiKey) {
  const url = dify_base_url$1 + "/v1/workflows/run";
  const headers = {
    "Authorization": `Bearer ${apiKey}`,
    "Content-Type": "application/json"
  };
  const data = {
    inputs,
    response_mode: "blocking",
    files,
    user: "abc-123"
  };
  try {
    const response = await fetch(url, {
      method: "POST",
      headers,
      body: JSON.stringify(data)
    });
    if (!response.ok) {
      console.error(`HTTP error! status: ${response.status}`);
      sendLog("生成评论错误" + response.status);
      return;
    }
    const result = await response.json();
    let resultText = "";
    if (result && result.data && result.data.outputs && result.data.outputs.result) {
      resultText = result.data.outputs.result;
    } else if (result && result.data && result.data.outputs && result.data.outputs.text) {
      resultText = result.data.outputs.text;
    }
    console.log("result", result);
    return resultText;
  } catch (error) {
    console.error("Error:", error);
    sendLog("生成评论错误" + error);
  }
}
async function runWorkflowVideoReviews(inputs, files) {
  const url = dify_base_url$1 + "/v1/workflows/run";
  const apiKey = "app-cmhNrLTCwezuuZ2XVGV1rV8u";
  const headers = {
    "Authorization": `Bearer ${apiKey}`,
    "Content-Type": "application/json"
  };
  const data = {
    inputs,
    response_mode: "blocking",
    files,
    user: "abc-123"
  };
  try {
    const response = await fetch(url, {
      method: "POST",
      headers,
      body: JSON.stringify(data)
    });
    if (!response.ok) {
      console.error(`HTTP error! status: ${response.status}`);
      sendLog("生成评论错误" + response.status);
      return;
    }
    const result = await response.json();
    let resultText = "";
    if (result && result.data && result.data.outputs && result.data.outputs.text) {
      resultText = result.data.outputs.text;
    }
    console.log("result", result);
    return resultText;
  } catch (error) {
    console.error("Error:", error);
    sendLog("生成评论错误" + error);
  }
}
async function keywordsIntelligentAssociation(inputs, files) {
  const url = dify_base_url$1 + "/v1/workflows/run";
  const apiKey = "app-ZDRJLNrioAP5c9destkhWnJB";
  const headers = {
    "Authorization": `Bearer ${apiKey}`,
    "Content-Type": "application/json"
  };
  const data = {
    inputs,
    response_mode: "blocking",
    files,
    user: "abc-123"
  };
  try {
    const response = await fetch(url, {
      method: "POST",
      headers,
      body: JSON.stringify(data)
    });
    if (!response.ok) {
      console.error(`HTTP error! status: ${response.status}`);
      sendLog("生成评论错误" + response.status);
      return;
    }
    const result = await response.json();
    let resultText = "";
    if (result && result.data && result.data.outputs && result.data.outputs.text) {
      resultText = result.data.outputs.text;
    }
    console.log("result", result);
    return resultText;
  } catch (error) {
    console.error("Error:", error);
    sendLog("生成评论错误" + error);
  }
}
const store$8 = UseCounterStore.getInstance();
const VITE_PLUGIN_ID = "dou-yin-automatic-reviews";
function checkDomPromises(selectors, element = void 0, maxNum = 60, timeout = 1e3) {
  let num = 0;
  return new Promise(resolve => {
    const checkInterval2 = setInterval(() => {
      try {
        console.log("正在查找：" + selectors);
        sendLog("正在查找：" + selectors);
        if (!element) {
          element = document;
        }
        if (!element) {
          clearInterval(checkInterval2);
          return;
        }
        let in_bool = false;
        for (const selector of selectors) {
          const loginContainer = element.querySelector(selector);
          if (loginContainer) {
            in_bool = true;
            break;
          }
        }
        if (in_bool || num > maxNum) {
          if (num > maxNum) {
            console.error("查找超时");
            sendLog("查找超时：" + selectors);
            resolve(false);
          } else {
            resolve(true);
            console.log("查找完成：" + selectors);
            sendLog("查找完成：" + selectors);
          }
          clearInterval(checkInterval2);
        }
        num++;
      } catch (e) {
        console.error(e);
      }
    }, timeout);
  });
}
function checkDomPromise(selectors, element = void 0, maxNum = 60, timeout = 1e3) {
  let num = 0;
  return new Promise(resolve => {
    const checkInterval2 = setInterval(() => {
      try {
        console.log("正在查找：" + selectors);
        sendLog("正在查找：" + selectors);
        if (!element) {
          element = document;
        }
        if (!element) {
          clearInterval(checkInterval2);
          return;
        }
        const loginContainer = element.querySelector(selectors);
        if (loginContainer || num > maxNum) {
          if (num > maxNum) {
            console.error("查找超时");
            sendLog("查找超时：" + selectors);
            resolve(false);
          } else {
            resolve(true);
            console.log("查找完成：" + selectors);
            sendLog("查找完成：" + selectors);
          }
          clearInterval(checkInterval2);
        }
        num++;
      } catch (e) {
        console.error(e);
      }
    }, timeout);
  });
}
function checkDomByDom(element, maxNum = 60, timeout = 1e3) {
  let num = 0;
  return new Promise(resolve => {
    const checkInterval2 = setInterval(() => {
      try {
        console.log("正在查找：");
        sendLog("正在查找：");
        if (document.documentElement.contains(element) || num > maxNum) {
          if (num > maxNum) {
            console.error("查找超时");
            sendLog("查找超时：");
            resolve(false);
          } else {
            resolve(true);
            console.log("查找完成：");
            sendLog("查找完成：");
          }
          clearInterval(checkInterval2);
        }
        num++;
      } catch (e) {
        console.error("checkDomByDom", e);
      }
    }, timeout);
  });
}
function delay(ms) {
  return new Promise(resolve => setTimeout(resolve, ms));
}
function isWithinProbability(probability) {
  if (probability < 1 || probability > 100) {
    throw new Error("概率必须在1到100之间");
  }
  const randomValue = Math.floor(Math.random() * 100) + 1;
  return randomValue <= probability;
}
function getRandomNumberInRange(start, max) {
  if (start > max) {
    throw new Error("开始数字不能大于最大数字");
  }
  return Math.floor(Math.random() * (max - start + 1)) + start;
}
function isElementInViewport(element, container = document.documentElement) {
  if (!container) {
    container = document.documentElement;
  }
  const elementRect = element.getBoundingClientRect();
  const containerRect = container.getBoundingClientRect();
  return elementRect.top >= containerRect.top && elementRect.bottom <= containerRect.bottom && elementRect.left >= containerRect.left && elementRect.right <= containerRect.right;
}
function ensureElementVisible(element, container = document.documentElement) {
  if (!container) {
    container = document.documentElement;
  }
  if (!isElementInViewport(element, container)) {
    element.scrollIntoView({
      behavior: "smooth",
      block: "start"
    });
    return true;
  }
  return false;
}
function isElementInViewport2(element) {
  const rect = element.getBoundingClientRect();
  return rect.top >= 0 && rect.left >= 0 && rect.bottom <= (window.innerHeight || document.documentElement.clientHeight) && rect.right <= (window.innerWidth || document.documentElement.clientWidth);
}
function ensureElementVisible2(element) {
  if (!isElementInViewport2(element)) {
    element.scrollIntoView({
      behavior: "smooth",
      block: "start"
    });
    return true;
  }
  return false;
}
async function ensureElementVisible3(element, offset = 0) {
  if (!isElementInViewport2(element)) {
    const rect = element.getBoundingClientRect();
    const scrollY = window.scrollY || document.documentElement.scrollTop;
    const topPosition = rect.top + scrollY - offset;
    window.scrollTo({
      top: topPosition,
      behavior: "smooth"
    });
    await delay(1e3);
    return true;
  }
  return false;
}
function sendLog(...messages) {
  const combinedMessage = messages.map(String).join(" ");
  {
    chrome.runtime.sendMessage({
      action: "logs",
      message: combinedMessage
    }, {
      includeTlsChannelId: false
    });
  }
}
function formatNowDateTimeSss() {
  const date = /* @__PURE__ */new Date();
  const year = date.getFullYear();
  const month = String(date.getMonth() + 1).padStart(2, "0");
  const day = String(date.getDate()).padStart(2, "0");
  const hours = String(date.getHours()).padStart(2, "0");
  const minutes = String(date.getMinutes()).padStart(2, "0");
  const seconds = String(date.getSeconds()).padStart(2, "0");
  const milliseconds = String(date.getMilliseconds()).padStart(3, "0");
  return `${year}-${month}-${day} ${hours}:${minutes}:${seconds}.${milliseconds}`;
}
function sendCloseTab(tag) {
  sendLog("sendCloseTab tag：" + tag);
  chrome.runtime.sendMessage({
    action: "closeTab",
    tag
  }, {
    includeTlsChannelId: false
  }, () => {
    console.info("closeTab");
  });
}
const saveReportData = async () => {
  console.log("saveReportData");
  const date = /* @__PURE__ */new Date();
  const year = date.getFullYear();
  const month = String(date.getMonth() + 1).padStart(2, "0");
  const day = String(date.getDate()).padStart(2, "0");
  const hours = String(date.getHours()).padStart(2, "0");
  const minutes = String(date.getMinutes()).padStart(2, "0");
  const addDate = `${year}-${month}-${day} ${hours}:${minutes}`;
  const saveInputs = {
    "key": store$8.userId + "_" + store$8.taskId,
    "bucket": {
      XiaoHongShu_Setting: store$8.XiaoHongShu_Setting,
      // //评论数量
      // XiaoHongShu_viewCount: store.XiaoHongShu_viewCount,
      // XiaoHongShu_CommentCount:store.XiaoHongShu_CommentCount,
      // XiaoHongShu_likeCount:store.XiaoHongShu_likeCount,
      // XiaoHongShu_followCount:store.XiaoHongShu_followCount,
      // XiaoHongShu_collectCount:store.XiaoHongShu_collectCount,
      //评论数量
      xhs_viewCount: store$8.xhs_viewCount,
      xhs_CommentCount: store$8.xhs_CommentCount,
      xhs_likeCount: store$8.xhs_likeCount,
      xhs_followCount: store$8.xhs_followCount,
      xhs_collectCount: store$8.xhs_collectCount,
      //评论数量
      dy_viewCount: store$8.dy_viewCount,
      dy_CommentCount: store$8.dy_CommentCount,
      dy_likeCount: store$8.dy_likeCount,
      dy_followCount: store$8.dy_followCount,
      dy_collectCount: store$8.dy_collectCount,
      executeOperationStartTime: store$8.executeOperationStartTime,
      executeOperationEndTime: store$8.executeOperationEndTime,
      //小红书 关键词 列表
      xhs_keywords_list: store$8.xhs_keywords_list,
      douYin_keywords_list: store$8.douYin_keywords_list,
      xhs_minute: store$8.xhs_minute,
      dy_minute: store$8.dy_minute,
      taskId: store$8.taskId,
      addDate,
      addTime: (/* @__PURE__ */new Date()).getTime()
    },
    "size": 0,
    "content_type": "",
    "belong_to": store$8.userId + "_comment_work_detail",
    "object_metadata": {}
  };
  await saveComment$1(saveInputs);
};
let closeEndBool = false;
const closeEndFun = async tag => {
  sendLog("closeEndFun store.userInfoEndDate:", store$8.userInfoEndDate, tag);
  if (store$8.userInfoEndDate) {
    try {
      await saveReportData();
      await chrome.storage.local.set({
        "optionsPageName": "runEchartsReport"
      });
    } catch (error) {
      sendLog("openOptionsPage error" + error);
    }
  }
  if (closeEndBool) {
    sendLog("closeEndBool:", closeEndBool, tag);
    return sendCloseTab(tag);
  }
  closeEndBool = true;
  store$8.setExecuteOperationEndTime((/* @__PURE__ */new Date()).getTime());
  const task_execution_time = store$8.executeOperationEndTime - store$8.executeOperationStartTime;
  const postData = {
    "app_id": VITE_PLUGIN_ID,
    "client_id": store$8.clientVisitorId,
    "event": "task_execution_time",
    "category": "",
    "data": {
      "task_execution_time": task_execution_time
    },
    "data_type": "",
    "description": ""
  };
  try {
    await putBurialPoint(postData);
  } catch (error) {
    sendLog("putBurialPoint error" + error);
  }
  sendCloseTab(tag);
};
const vipCloseEndFun = async tag => {
  if (store$8.closeStop) {
    return;
  }
  store$8.setCloseStop(true);
  if (store$8.userInfoEndDate) {
    closeEndFun("closeTabListener").then(() => {});
  } else {
    closeEndFun(tag).then(() => {});
  }
};
function closeTabListener() {
  const callBackListener = (changes, namespace) => {
    for (let [key, {
      oldValue,
      newValue
    }] of Object.entries(changes)) {
      console.log(`Storage key "${key}" in namespace "${namespace}" changed.`, `Old value was "${oldValue}", new value is "${newValue}".`);
      sendLog(`Storage key "${key}" in namespace "${namespace}" changed.Old value was "${oldValue}", new value is "${newValue}".`);
      switch (key) {
        case "activatePage":
          if (store$8.closeStop) {
            return;
          }
          store$8.setCloseStop(true);
          sendLog("store.userInfoEndDate:", store$8.userInfoEndDate, "，reportPages:", JSON.stringify(reportPages), "，store.activatePage", store$8.activatePage, "，reportPages.includes(store.activatePage)：", reportPages.includes(store$8.activatePage));
          if (store$8.userInfoEndDate && reportPages.includes(store$8.activatePage)) {
            closeEndFun("closeTabListener").then(() => {});
          } else {
            closeEndFun("closeTabListener not report").then(() => {});
          }
      }
    }
  };
  storageUtil.removeListener(callBackListener);
  storageUtil.addHandlers(callBackListener);
}
function getLastPathName$1(pathname) {
  if (pathname) {
    const extra_image_ids = pathname.split("/");
    if (extra_image_ids && extra_image_ids.length > 0) {
      pathname = extra_image_ids[extra_image_ids.length - 1];
      return pathname.replace(/!.*$/, "");
    }
  }
  return pathname;
}
function getTabTaskData() {
  return new Promise(resolve => {
    chrome.runtime.sendMessage({
      action: "getTabTaskData"
    }, {
      includeTlsChannelId: false
    }, response => {
      if (response && response.tabId) {
        console.log("Current Tab ID:", response.tabId);
        resolve(response);
      } else {
        console.error("Failed to get tab ID.");
        resolve({});
      }
    });
  });
}
function getActivateTabId() {
  return new Promise(resolve => {
    chrome.runtime.sendMessage({
      message: "queryActivateTab"
    }, {
      includeTlsChannelId: false
    }, response => {
      if (response) {
        console.log("Active Tab ID:", response.tabId);
        console.log("Active Tab URL:", response.url);
        resolve(response.tabId);
      } else {
        console.error("Failed to get tab information.");
        resolve(0);
      }
    });
  });
}
function simulateInputSendMessage(content, interval_time_out = 200, checkFocus = false, keyDown = true) {
  return new Promise(resolve => {
    chrome.runtime.sendMessage({
      action: "inputKey",
      "content": content,
      checkFocus,
      // ture: keyDown，
      // false: 使用\n
      keyDown,
      interval_time_out
    }, {
      includeTlsChannelId: false
    }).then(() => {}).finally(() => {
      resolve();
    });
  });
}
function simulateInput(content, content_textarea, interval_time_out = 200) {
  return new Promise(resolve => {
    let index = 0;
    let intervalId = setInterval(() => {
      if (index < content.length) {
        if (content_textarea instanceof HTMLTextAreaElement) {
          content_textarea.value += content[index];
        } else if (content_textarea instanceof HTMLElement) {
          content_textarea.innerText += content[index];
        }
        let input_event = new Event("input", {
          bubbles: true,
          cancelable: true
        });
        content_textarea.dispatchEvent(input_event);
        index++;
      } else {
        clearInterval(intervalId);
        resolve();
      }
    }, interval_time_out);
  });
}
function queryLastTime() {
  return new Promise(resolve => {
    console.info("queryLastTime");
    chrome.runtime.sendMessage({
      action: store$8.chromeTabId + "_queryLastTime"
    }, {
      includeTlsChannelId: false
    }, res => {
      console.info("queryLastTime", res);
      store$8.setOperationTime(res);
      resolve(res);
    });
  });
}
async function click_button(targetElement) {
  const content_edit_rect = targetElement.getBoundingClientRect();
  const content_edit_x = content_edit_rect.left + content_edit_rect.width / 2;
  const content_edit_y = content_edit_rect.top + content_edit_rect.height / 2;
  const clickEvents = ["mouseover", "mousedown", "mouseup", "click"];
  clickEvents.forEach(async eventType => {
    const event = new MouseEvent(eventType, {
      view: window,
      bubbles: true,
      cancelable: true,
      button: 0,
      clientX: content_edit_x,
      clientY: content_edit_y
    });
    targetElement.dispatchEvent(event);
    await delay(100);
  });
}
async function hover_button(hoverEl) {
  if (!hoverEl) {
    console.error("错误，重新开始");
    sendLog("没有找到 选择过滤");
    return;
  }
  const rect = hoverEl.getBoundingClientRect();
  const x = rect.left + rect.width / 2;
  const y = rect.top + rect.height / 2;
  console.log("x,y", rect, x, y);
  const mouseOverEvent = new MouseEvent("mouseover", {
    view: window,
    bubbles: true,
    cancelable: true,
    clientX: x,
    clientY: y
  });
  hoverEl.dispatchEvent(mouseOverEvent);
  const mouseMoveEvent = new MouseEvent("mousemove", {
    view: window,
    bubbles: true,
    cancelable: true,
    clientX: x,
    clientY: y
  });
  hoverEl.dispatchEvent(mouseMoveEvent);
  const mouseEnterEvent = new MouseEvent("mouseenter", {
    view: window,
    bubbles: true,
    cancelable: true,
    clientX: x,
    clientY: y
  });
  hoverEl.dispatchEvent(mouseEnterEvent);
}
async function getKeywordsIntelligentAssociation(title_texts, searchWord) {
  console.log("title_texts", title_texts);
  let test_text = "";
  for (let i = 0; i < title_texts.length; i++) {
    if (test_text) {
      test_text += "\n";
    }
    test_text += i + 1 + "、" + title_texts[i];
  }
  const inputs_comment = {
    keyword: searchWord,
    test: test_text
  };
  const files_comment = [];
  const resultText = await keywordsIntelligentAssociation(inputs_comment, files_comment);
  console.log("resultText", resultText);
  if (resultText) {
    if (resultText.includes("、")) {
      return resultText.split("、");
    }
    if (resultText.includes(",")) {
      return resultText.split(",");
    }
    if (resultText.includes("，")) {
      return resultText.split("，");
    }
  }
  return [];
}
function nowDate() {
  const date = /* @__PURE__ */new Date();
  const year = date.getFullYear();
  const month = String(date.getMonth() + 1).padStart(2, "0");
  const day = String(date.getDate()).padStart(2, "0");
  return `${year}-${month}-${day}`;
}
const checkXiaoHongShuAccountRunNum = async (platform, xiaoHongShuAccountId) => {
  switch (store$8.userInfoEndDate) {
    case "新手":
      store$8.xiaoHongShuAccountRunTodayMaxNum = 1;
      break;
    case "标准":
      store$8.xiaoHongShuAccountRunTodayMaxNum = 1;
      break;
    case "高级":
      store$8.xiaoHongShuAccountRunTodayMaxNum = 3;
      break;
    default:
      return true;
  }
  const nowDateString = nowDate();
  const key = store$8.userId + "_" + platform + "_AccountRunNum";
  if (!store$8.getXiaoHongShuAccountRunTodayDate(platform)) {
    const res = await getXiaoHongShuAccountRunTodayNum(store$8.accessToken, key, store$8.userId);
    console.log("getXiaoHongShuAccountRunTodayNum res", res, store$8.getXiaoHongShuAccountRunTodayDate(platform));
    if (res && res["bucket"]) {
      if (res["bucket"]["xiaoHongShuAccountIds"]) {
        if (res["bucket"]["xiaoHongShuAccountIds"] instanceof Set) {
          store$8.setXiaoHongShuAccountRunTodayIds(platform, res["bucket"]["xiaoHongShuAccountIds"]);
        } else if (res["bucket"]["xiaoHongShuAccountIds"] instanceof Array) {
          const xiaoHongShuAccountSet = new Set(res["bucket"]["xiaoHongShuAccountIds"]);
          store$8.setXiaoHongShuAccountRunTodayIds(platform, xiaoHongShuAccountSet);
        } else if (typeof res["bucket"]["xiaoHongShuAccountIds"] === "string") {
          const xiaoHongShuAccountSet = new Set(JSON.parse(res["bucket"]["xiaoHongShuAccountIds"]));
          store$8.setXiaoHongShuAccountRunTodayIds(platform, xiaoHongShuAccountSet);
        }
      } else {
        store$8.setXiaoHongShuAccountRunTodayIds(platform, /* @__PURE__ */new Set());
      }
      store$8.setXiaoHongShuAccountRunTodayDate(platform, res["bucket"]["runTodayDate"]);
    } else {
      store$8.increment_XiaoHongShuAccountRunTodayIds(platform, xiaoHongShuAccountId);
      store$8.setXiaoHongShuAccountRunTodayDate(platform, nowDateString);
      const postData2 = {
        "key": key,
        "bucket": {
          xiaoHongShuAccountIds: JSON.stringify(Array.from(store$8.getXiaoHongShuAccountRunTodayIds(platform))),
          runTodayDate: nowDateString
        },
        "size": 0,
        "content_type": "",
        "belong_to": store$8.userId,
        "object_metadata": {}
      };
      await setXiaoHongShuAccountRunTodayNum(store$8.accessToken, postData2);
      return true;
    }
  }
  if (store$8.getXiaoHongShuAccountRunTodayDate(platform) != nowDateString) {
    store$8.setXiaoHongShuAccountRunTodayIds(platform, /* @__PURE__ */new Set());
    store$8.increment_XiaoHongShuAccountRunTodayIds(platform, xiaoHongShuAccountId);
    store$8.setXiaoHongShuAccountRunTodayDate(platform, nowDateString);
    const postData2 = {
      "key": key,
      "bucket": {
        xiaoHongShuAccountIds: JSON.stringify(Array.from(store$8.getXiaoHongShuAccountRunTodayIds(platform))),
        runTodayDate: nowDateString
      },
      "size": 0,
      "content_type": "",
      "belong_to": store$8.userId,
      "object_metadata": {}
    };
    await setXiaoHongShuAccountRunTodayNum(store$8.accessToken, postData2);
    return true;
  }
  const newSet = new Set(store$8.getXiaoHongShuAccountRunTodayIds(platform));
  newSet.add(xiaoHongShuAccountId);
  if (newSet.size > store$8.xiaoHongShuAccountRunTodayMaxNum) {
    sendLog("超过每日免费最大次数:" + store$8.getXiaoHongShuAccountRunTodayIds(platform));
    store$8.setXiaoHongShuAccountErrorTip("账号太多了,小薯条有点累了。请明日再试,详情请咨询客服。");
    return false;
  }
  const oldSize = store$8.getXiaoHongShuAccountRunTodayIds(platform).size;
  store$8.increment_XiaoHongShuAccountRunTodayIds(platform, xiaoHongShuAccountId);
  if (oldSize == store$8.getXiaoHongShuAccountRunTodayIds(platform).size) {
    sendLog("没有新增账号，不做修改");
    return true;
  }
  store$8.setXiaoHongShuAccountRunTodayDate(platform, nowDateString);
  const postData = {
    "key": key,
    "bucket": {
      xiaoHongShuAccountIds: JSON.stringify(Array.from(store$8.getXiaoHongShuAccountRunTodayIds(platform))),
      runTodayDate: nowDateString
    },
    "size": 0,
    "content_type": "",
    "belong_to": store$8.userId,
    "object_metadata": {}
  };
  await setXiaoHongShuAccountRunTodayNum(store$8.accessToken, postData);
  return true;
};
function getNoteData(message) {
  return new Promise(resolve => {
    chrome.runtime.sendMessage(message, {
      includeTlsChannelId: false
    }, response => {
      console.log("getNoteData:", response);
      if (response) {
        resolve(response);
      } else {
        console.error("Failed to get tab information.");
        resolve(null);
      }
    });
  });
}
const openNewWindowNote = message => {
  return () => new Promise(async resolve => {
    const windowData = await getNoteData(message);
    let checkIfTabExistsSetInterval = null;
    if (windowData.tabId) {
      checkIfTabExistsSetInterval = setInterval(() => {
        chrome.runtime.sendMessage({
          action: "checkIfTabExists",
          tabId: windowData.tabId
        }, {
          includeTlsChannelId: false
        }, response => {
          if (response && !response.tabExists) {
            clearInterval(checkIfTabExistsSetInterval);
            storageUtil.removeListener(changedCallBack);
            resolve();
          } else {
            console.error("窗口还存在");
          }
        });
        chrome.runtime.sendMessage({
          action: "checkTaskComplete",
          tabId: windowData.tabId
        }, {
          includeTlsChannelId: false
        }, response => {
          if (response && response.taskComplete) {
            clearInterval(checkIfTabExistsSetInterval);
            storageUtil.removeListener(changedCallBack);
            resolve();
          } else {
            console.error("任务还没有完成");
          }
        });
      }, 60 * 1e3);
    }
    const changedCallBack = (changes, namespace) => {
      for (let [key, {
        oldValue,
        newValue
      }] of Object.entries(changes)) {
        console.log(`Storage key "${key}" in namespace "${namespace}" changed.`, `Old value was "${oldValue}", new value is "${newValue}".`);
        switch (key) {
          case "taskCompleteData":
            if (newValue) {
              try {
                const newValueJson = JSON.parse(newValue);
                if (newValueJson[windowData.tabId]) {
                  chrome.runtime.sendMessage({
                    action: "currentActivateTab"
                  }, {
                    includeTlsChannelId: false
                  }, res => {
                    console.info("currentActivateTab", res);
                  });
                  clearInterval(checkIfTabExistsSetInterval);
                  storageUtil.removeListener(changedCallBack);
                  resolve();
                } else {
                  console.log("不存在这个tabId", windowData.tabId, newValue);
                }
              } catch (e) {
                console.log("newValueJson error", newValue);
              }
            } else {
              console.log("taskCompleteData newValue 为空");
            }
            break;
          case "DoneNoteId":
            if (newValue == windowData.tabId) {
              clearInterval(checkIfTabExistsSetInterval);
              storageUtil.removeListener(changedCallBack);
              resolve();
            }
            break;
          case "taskComplete":
            if (newValue == windowData.tabId) {
              clearInterval(checkIfTabExistsSetInterval);
              storageUtil.removeListener(changedCallBack);
              resolve();
            }
            break;
        }
      }
    };
    storageUtil.removeListener(changedCallBack);
    storageUtil.addHandlers(changedCallBack);
  });
};
const extractPhoneNumbers = text => {
  const regex = /1[3-9]\d{9}/g;
  return text.match(regex) || [];
};
const setActiveElement = targetElement => {
  targetElement.focus();
  function findLastTextNode(node) {
    if (node.nodeType === Node.TEXT_NODE) {
      return node;
    }
    let lastTextNode2 = null;
    for (let i = 0; i < node.childNodes.length; i++) {
      const childTextNode = findLastTextNode(node.childNodes[i]);
      if (childTextNode) {
        lastTextNode2 = childTextNode;
      }
    }
    return lastTextNode2;
  }
  const lastTextNode = findLastTextNode(targetElement);
  if (lastTextNode) {
    const range = document.createRange();
    const selection = window.getSelection();
    range.setStart(lastTextNode, lastTextNode.length);
    range.setEnd(lastTextNode, lastTextNode.length);
    selection == null ? void 0 : selection.removeAllRanges();
    selection == null ? void 0 : selection.addRange(range);
  }
};
const queryActiveElement = (request2, sender2, sendResponse2, selectPath) => {
  console.log(`queryActiveElement。`, sender2, request2);
  if ((request2 == null ? void 0 : request2.messageType) === "queryActiveElement") {
    const textBox2List = Array.from(document.querySelectorAll(selectPath));
    if (textBox2List && textBox2List.length > 0) {
      const targetElement = textBox2List[0];
      setActiveElement(targetElement);
      sendResponse2(true);
    } else {
      sendResponse2(false);
    }
    return false;
  }
  if ((request2 == null ? void 0 : request2.messageType) === "setActiveElement") {
    const textBox2List = Array.from(document.querySelectorAll(selectPath));
    if (textBox2List && textBox2List.length > 0) {
      const targetElement = textBox2List[0];
      setActiveElement(targetElement);
      sendResponse2(true);
    } else {
      sendResponse2(false);
    }
    return false;
  }
};
const store$7 = UseCounterStore.getInstance();
const baseURL = "https://plugin-api-adlrdojbyd.ap-northeast-1.fcapp.run";
const dify_base_url = "https://dify.fsotool.com";
async function runWorkflow(inputs, files) {
  const url = dify_base_url + "/v1/workflows/run";
  const apiKey = "app-ELZGUviBrukvXEuCwZCaNxK6";
  const headers = {
    "Authorization": `Bearer ${apiKey}`,
    "Content-Type": "application/json"
  };
  const data = {
    inputs,
    response_mode: "blocking",
    files,
    user: store$7.userId
  };
  try {
    const response = await fetch(url, {
      method: "POST",
      headers,
      body: JSON.stringify(data)
    });
    if (!response.ok) {
      console.error(`HTTP error! status: ${response.status}`);
      sendLog("生成评论错误" + response.status);
      return;
    }
    const result = await response.json();
    let resultText = "";
    if (result && result.data && result.data.outputs && result.data.outputs.result) {
      resultText = result.data.outputs.result;
    }
    console.log("result", result);
    return resultText;
  } catch (error) {
    console.error("Error:", error);
    sendLog("生成评论错误" + error);
  }
}
async function queryComment(refer_id) {
  const url = baseURL + `/api/v1/xhs_contents/${refer_id}`;
  const headers = {
    "Content-Type": "application/json",
    "Authorization": "Bearer " + store$7.accessToken
  };
  try {
    const response = await fetch(url, {
      method: "GET",
      headers
    });
    if (!response.ok) {
      if (response.status === 404) {
        const result2 = await response.json();
        console.log("result", result2);
        sendLog("查询错误 404" + (result2 == null ? void 0 : result2.detail) + "_refer_id_" + refer_id);
        if ((result2 == null ? void 0 : result2.detail) == "XhsContent not found") {
          return true;
        }
      }
      if (response.status === 401) {
        sendLog("登录失效");
        store$7.setAccessToken("");
      } else {
        const result2 = await response.json();
        console.log("result", result2);
        sendLog("查询错误 其他" + (result2 == null ? void 0 : result2.detail) + "_refer_id_" + refer_id);
      }
      console.error(`HTTP error! status: ${response.status}`, response);
      return false;
    }
    const result = await response.json();
    console.log("result", result);
    return false;
  } catch (error) {
    console.error("Error:", error);
  }
  return false;
}
async function saveComment(saveData) {
  const url = baseURL + `/api/v1/xhs_contents`;
  const headers = {
    "Content-Type": "application/json",
    "Authorization": "Bearer " + store$7.accessToken
  };
  try {
    const response = await fetch(url, {
      method: "POST",
      headers,
      body: JSON.stringify({
        "data": saveData
      })
    });
    if (!response.ok) {
      console.error(`HTTP error! status: ${response.status}`, response);
      if (response.status === 401) {
        store$7.setAccessToken("");
        sendLog("登录失效");
      } else {
        const result2 = await response.json();
        console.log("result", result2);
        sendLog("保存错误 其他" + (result2 == null ? void 0 : result2.detail));
      }
      return false;
    }
    const result = await response.json();
    console.log("result", result);
    return true;
  } catch (error) {
    console.error("Error:", error);
    sendLog("保存错误 其他" + error);
  }
  return false;
}
async function saveLikeFollows(saveData) {
  const url = baseURL + `/api/v1/follows`;
  const headers = {
    "Content-Type": "application/json",
    "Authorization": "Bearer " + store$7.accessToken
  };
  try {
    const response = await fetch(url, {
      method: "POST",
      headers,
      body: JSON.stringify(saveData)
    });
    if (!response.ok) {
      console.error(`HTTP error! status: ${response.status}`, response);
      if (response.status === 401) {
        store$7.setAccessToken("");
        sendLog("登录失效");
      } else {
        const result2 = await response.json();
        console.log("result", result2);
        sendLog("保存错误 其他" + (result2 == null ? void 0 : result2.detail));
      }
      return false;
    }
    const result = await response.json();
    console.log("result", result);
    return true;
  } catch (error) {
    console.error("Error:", error);
    sendLog("保存错误 其他" + error);
  }
  return false;
}
async function saveLikeUnFollow(saveData) {
  const url = baseURL + `/api/v1/unfollow`;
  const headers = {
    "Content-Type": "application/json",
    "Authorization": "Bearer " + store$7.accessToken
  };
  try {
    const response = await fetch(url, {
      method: "POST",
      headers,
      body: JSON.stringify(saveData)
    });
    if (!response.ok) {
      console.error(`HTTP error! status: ${response.status}`, response);
      if (response.status === 401) {
        store$7.setAccessToken("");
        sendLog("登录失效");
      } else {
        const result2 = await response.json();
        console.log("result", result2);
        sendLog("保存错误 其他" + (result2 == null ? void 0 : result2.detail));
      }
      return false;
    }
    const result = await response.json();
    console.log("result", result);
    return true;
  } catch (error) {
    console.error("Error:", error);
    sendLog("保存错误 其他" + error);
  }
  return false;
}
async function queryLikeFollowsByFollowedId(followed_id, queryParams) {
  const url = `${baseURL}/api/v1/follows/${followed_id}?${queryParams}`;
  const headers = {
    "Content-Type": "application/json",
    "Authorization": "Bearer " + store$7.accessToken
  };
  try {
    const response = await fetch(url, {
      method: "GET",
      headers
    });
    if (!response.ok) {
      if (response.status === 404) {
        const result2 = await response.json();
        console.log("result", result2);
        sendLog("查询错误 404" + (result2 == null ? void 0 : result2.detail) + "_followed_id_" + followed_id);
        if ((result2 == null ? void 0 : result2.detail) == "XhsContent not found") {
          return [];
        }
      }
      if (response.status === 401) {
        sendLog("登录失效");
        store$7.setAccessToken("");
      } else {
        const result2 = await response.json();
        console.log("result", result2);
        sendLog("查询错误 404" + (result2 == null ? void 0 : result2.detail) + "_followed_id_" + followed_id);
      }
      console.error(`HTTP error! status: ${response.status}`, response);
      return [];
    }
    const result = await response.json();
    console.log("result", result);
    return result;
  } catch (error) {
    console.error("Error:", error);
  }
  return [];
}
class AsyncTaskQueue {
  constructor(concurrency) {
    __publicField(this, "concurrency");
    __publicField(this, "running", 0);
    __publicField(this, "taskQueue", []);
    this.concurrency = concurrency;
  }
  // 添加任务到队列，如果没有空余并发数则阻塞
  async enqueue(task) {
    if (this.running >= this.concurrency) {
      await new Promise(resolve => {
        this.taskQueue.push(() => {
          this.runTask(task);
          resolve();
        });
      });
    } else {
      this.runTask(task);
    }
  }
  // 执行任务，并控制并发数
  async runTask(task) {
    this.running++;
    try {
      await task();
    } finally {
      this.running--;
      if (this.taskQueue.length > 0) {
        const nextTask = this.taskQueue.shift();
        nextTask();
      }
    }
  }
  // 等待所有任务完成
  async waitForAll() {
    return new Promise(resolve => {
      const checkFinished = () => {
        if (this.running === 0 && this.taskQueue.length === 0) {
          resolve();
        } else {
          setTimeout(checkFinished, 50);
        }
      };
      checkFinished();
    });
  }
}
const store$6 = UseCounterStore.getInstance();
console.log("Content script loaded:", window.location.href);
let XiaoHongShu_Setting$3 = JSON.parse(store$6.XiaoHongShu_Setting);
const extractNumber = text => {
  const match = text.match(/\d+/);
  return match ? parseInt(match[0], 10) : 0;
};
function getLastPathName(pathname) {
  if (pathname) {
    const extra_image_ids = pathname.split("/");
    if (extra_image_ids && extra_image_ids.length > 0) {
      pathname = extra_image_ids[extra_image_ids.length - 1];
      return pathname.replace(/!.*$/, "");
    }
  }
  return pathname;
}
function parseLine(input) {
  const trimmedInput = input.trim();
  const datePattern = /(\d{2}-\d{2}|今天|昨天|\d+ 天前)/;
  const timePattern = /(\d{2}:\d{2})/;
  const editPattern = /编辑于/;
  const locationPattern = /[\u4e00-\u9fa5]+/g;
  const currentDate = /* @__PURE__ */new Date();
  let publicationDate = null;
  let location = null;
  let isEdited = false;
  if (editPattern.test(trimmedInput)) {
    isEdited = true;
  }
  const dateMatch = trimmedInput.match(datePattern);
  if (dateMatch) {
    publicationDate = dateMatch[0];
    if (publicationDate.includes("今天")) {
      publicationDate = `${currentDate.getFullYear()}-${String(currentDate.getMonth() + 1).padStart(2, "0")}-${String(currentDate.getDate()).padStart(2, "0")}`;
    } else if (publicationDate.includes("昨天")) {
      const yesterday = new Date(currentDate);
      yesterday.setDate(currentDate.getDate() - 1);
      publicationDate = `${yesterday.getFullYear()}-${String(yesterday.getMonth() + 1).padStart(2, "0")}-${String(yesterday.getDate()).padStart(2, "0")}`;
    } else if (publicationDate.includes("天前")) {
      const daysAgo = parseInt(publicationDate);
      const pastDate = new Date(currentDate);
      pastDate.setDate(currentDate.getDate() - daysAgo);
      publicationDate = `${pastDate.getFullYear()}-${String(pastDate.getMonth() + 1).padStart(2, "0")}-${String(pastDate.getDate()).padStart(2, "0")}`;
    } else {
      publicationDate = `${currentDate.getFullYear()}-${publicationDate}`;
    }
  }
  if (trimmedInput.includes("刚刚")) {
    const pastDate = currentDate;
    publicationDate = `${pastDate.getFullYear()}-${String(pastDate.getMonth() + 1).padStart(2, "0")}-${String(pastDate.getDate()).padStart(2, "0")}`;
  }
  const timeMatch = trimmedInput.match(timePattern);
  const time = timeMatch ? `${timeMatch[0]}:00` : "00:00:00";
  if (publicationDate) {
    publicationDate += ` ${time}`;
  }
  const locationMatches = trimmedInput.match(locationPattern);
  if (locationMatches) {
    for (const match of locationMatches) {
      if (!["编辑于", "今天", "昨天", "天前", "刚刚"].includes(match)) {
        location = match;
        break;
      }
    }
  }
  return {
    publicationDate,
    location,
    isEdited,
    originalStr: input
  };
}
async function auto_like_unfollow(note_url) {
  var _a, _b;
  const follow_button = document.querySelector(".user-info .info-right-area .follow-button");
  console.log("follow_button", follow_button);
  if (!follow_button) {
    return;
  }
  let follow_button_text = "";
  if (follow_button) {
    follow_button_text = ((_a = follow_button.textContent) == null ? void 0 : _a.trim()) || "";
  }
  if (follow_button_text == "已关注") {
    await click_button(follow_button);
    while (true) {
      if (follow_button) {
        follow_button_text = ((_b = follow_button.textContent) == null ? void 0 : _b.trim()) || "";
      }
      if (follow_button_text == "回关" || follow_button_text == "关注") {
        console.log("取消关注成功了");
        store$6.increment_XiaoHongShu_likes_unfollow();
        await saveLikeUnFollow({
          followed_id: store$6.userId,
          follower_id: note_url.replace("https://www.xiaohongshu.com", "")
        });
        break;
      } else {
        await delay(1e3);
      }
    }
  } else if (follow_button_text == "互相关注" || follow_button_text == "关注") {
    console.log("互相关注了");
    await saveLikeUnFollow({
      followed_id: store$6.userId,
      follower_id: note_url.replace("https://www.xiaohongshu.com", "")
    });
  }
}
async function auto_replyComment() {
  await replyComment();
  console.log("初始化处理完成");
  sendLog("初始化处理完成");
  await intervalReplyComment();
  if (XiaoHongShu_Setting$3.likes_unfollow) {
    start_auto_like_follow().then(res => {
      console.log("start_auto_like_follow res", res);
    }).catch(err => {
      console.log("start_auto_like_follow err", err);
    });
  }
}
function getDateDaysAgo(days) {
  const today = /* @__PURE__ */new Date();
  const pastDate = new Date(today);
  pastDate.setDate(today.getDate() - days);
  return pastDate;
}
function getDateYearsAgo(years) {
  const today = /* @__PURE__ */new Date();
  const pastDate = new Date(today);
  pastDate.setFullYear(today.getFullYear() - years);
  return pastDate;
}
async function start_auto_like_follow() {
  console.log("取消点赞关注数量 start_auto_like_follow");
  const pastDate = getDateDaysAgo(XiaoHongShu_Setting$3.likes_unfollow_num);
  const pastStr = `${pastDate.getFullYear()}-${String(pastDate.getMonth() + 1).padStart(2, "0")}-${String(pastDate.getDate()).padStart(2, "0")}`;
  const endedDate = getDateYearsAgo(1);
  const startDateStr = `${endedDate.getFullYear()}-${String(endedDate.getMonth() + 1).padStart(2, "0")}-${String(endedDate.getDate()).padStart(2, "0")}`;
  const queryParams = new URLSearchParams({
    started_at: startDateStr,
    ended_at: pastStr
  }).toString();
  const followList = await queryLikeFollowsByFollowedId(store$6.userId, queryParams);
  console.log("取消关注数量，followList：", followList.length);
  const taskQueue = new AsyncTaskQueue(3);
  for (const followData of followList) {
    console.log("followData", followData);
    if (followData.follower_id) {
      const message = {
        action: "executeTaskNoTask",
        url: "https://www.xiaohongshu.com" + followData.follower_id,
        taskName: "取消点赞的关注",
        taskPlatform: "小红书"
      };
      await taskQueue.enqueue(openNewWindowNote(message));
    }
  }
  await taskQueue.waitForAll();
}
async function intervalReplyComment() {
  if (!(await checkDomPromise(".reds-tab-item.tab-item .badge-container"))) {
    return;
  }
  setInterval(async () => {
    var _a, _b;
    try {
      sendLog("开始定时处理新增关注");
      console.log("开始定时处理新增关注");
      const containers = document.querySelectorAll(".reds-tab-item.tab-item .badge-container");
      for (let i = 0; i < containers.length; i++) {
        const container = containers[i];
        const count_cls = container.querySelector(".count");
        let count_text = "";
        if (count_cls) {
          count_text = ((_a = count_cls.textContent) == null ? void 0 : _a.trim()) || "";
        }
        if (!count_text) {
          continue;
        }
        const span_tag = container.querySelector("span");
        let span_txt = "";
        if (span_tag) {
          span_txt = ((_b = span_tag.textContent) == null ? void 0 : _b.trim()) || "";
        }
        if (!span_txt) {
          continue;
        }
        switch (span_txt) {
          case "评论和@":
            await refreshTabData("评论和@");
            await autoComment(store$6.commentViewPaths);
            break;
          case "新增关注":
            if (XiaoHongShu_Setting$3.connections_follow) {
              await refreshTabData("新增关注");
              await autoConnections(store$6.viewedPaths);
            }
            break;
        }
      }
    } finally {
      console.log("结束定时处理新增关注");
      sendLog("结束定时处理新增关注");
    }
  }, 10 * 1e3);
}
async function replyComment() {
  if (!(await checkDomPromise(".reds-tab-item.active.tab-item .badge-container span"))) {
    return;
  }
  if (XiaoHongShu_Setting$3.mentions) {
    try {
      await autoComment(store$6.commentViewPaths);
    } finally {}
  }
  if (XiaoHongShu_Setting$3.connections && XiaoHongShu_Setting$3.connections_follow) {
    try {
      await autoConnections(store$6.viewedPaths);
    } finally {}
  }
  if (XiaoHongShu_Setting$3.likes && XiaoHongShu_Setting$3.likes_follow) {
    try {
      await autoLikeFlow(store$6.followPaths);
    } finally {}
  }
}
async function switchTabItem(tabItem) {
  var _a;
  const detail_title_el = document.querySelector(".reds-tab-item.active.tab-item .badge-container span");
  let current_tabItem = "";
  if (detail_title_el) {
    current_tabItem = ((_a = detail_title_el.textContent) == null ? void 0 : _a.trim()) || "";
  }
  console.log("current_tabItem", current_tabItem);
  switch (current_tabItem) {
    case "评论和@":
      switch (tabItem) {
        case "评论和@":
          return;
        default:
          await clickTabItem(tabItem);
          return;
      }
    case "赞和收藏":
      switch (tabItem) {
        case "赞和收藏":
          return;
        default:
          await clickTabItem(tabItem);
          return;
      }
    case "新增关注":
      switch (tabItem) {
        case "新增关注":
          return;
        default:
          await clickTabItem(tabItem);
          return;
      }
    default:
      console.log("不匹配的数据");
      break;
  }
}
async function clickTabItem(tabItem) {
  var _a;
  const detail_tabitem_els = document.querySelectorAll(".reds-tab-item.tab-item .badge-container span");
  let tabitem_els = Array.from(detail_tabitem_els);
  for (let i = 0; i < tabitem_els.length; i++) {
    let tabitem_el = tabitem_els[i];
    let current_tabItem = ((_a = tabitem_el.textContent) == null ? void 0 : _a.trim()) || "";
    console.log("clickTabItem current_tabItem:", current_tabItem, "tabItem:", tabItem);
    if (current_tabItem && current_tabItem == tabItem) {
      await click_button(tabitem_el);
      return;
    }
  }
}
async function refreshTabData(tabItem) {
  var _a;
  const detail_title_el = document.querySelector(".reds-tab-item.active.tab-item .badge-container span");
  let current_tabItem = "";
  if (detail_title_el) {
    current_tabItem = ((_a = detail_title_el.textContent) == null ? void 0 : _a.trim()) || "";
  }
  console.log("current_tabItem", current_tabItem);
  switch (current_tabItem) {
    case "评论和@":
      switch (tabItem) {
        case "评论和@":
          await clickTabItem("赞和收藏");
          await clickTabItem("评论和@");
          return;
        default:
          await clickTabItem(tabItem);
          return;
      }
    case "赞和收藏":
      switch (tabItem) {
        case "赞和收藏":
          await clickTabItem("评论和@");
          await clickTabItem("赞和收藏");
          return;
        default:
          await clickTabItem(tabItem);
          return;
      }
    case "新增关注":
      switch (tabItem) {
        case "新增关注":
          await clickTabItem("赞和收藏");
          await clickTabItem("新增关注");
          return;
        default:
          await clickTabItem(tabItem);
          return;
      }
    default:
      console.log("不匹配的数据");
      break;
  }
}
async function autoComment(viewedPaths) {
  var _a, _b, _c, _d;
  await switchTabItem("评论和@");
  if (!(await checkDomPromise(".tabs-content-container .container"))) {
    return;
  }
  const containers = document.querySelectorAll(".tabs-content-container .container");
  for (let i = 0; i < containers.length; i++) {
    const container = containers[i];
    const user_tag = container.querySelector(".user-info .user-tag");
    let user_tag_text = "";
    if (user_tag) {
      user_tag_text = ((_a = user_tag.textContent) == null ? void 0 : _a.trim()) || "";
    }
    if (user_tag_text == "作者") {
      console.info("作者，不做回复。 user_tag_text：", user_tag_text);
      continue;
    }
    const interaction_hint_spans = container.querySelectorAll(".main .info .interaction-hint span");
    let interaction_hint_span_one_text = "";
    if (interaction_hint_spans.length > 0) {
      interaction_hint_span_one_text = ((_b = interaction_hint_spans[0].textContent) == null ? void 0 : _b.trim()) || "";
    }
    if (interaction_hint_span_one_text == "在评论中@了你") {
      console.info("@我的消息，不做回复", user_tag_text);
      continue;
    }
    const user_avatar = container.querySelector("a.user-avatar");
    if (!user_avatar) {
      console.log("如果头像不存在。不做回复");
      continue;
    }
    const comment_user_url = user_avatar.href;
    let comment_user_id = "";
    if (comment_user_url) {
      const pathname = new URL(comment_user_url).pathname;
      comment_user_id = getLastPathName(pathname);
    }
    const extra_image = container.querySelector(".extra .extra-image");
    let extra_image_url = "";
    if (extra_image) {
      extra_image_url = extra_image.src;
    }
    console.log("extra_image:", extra_image);
    console.log("extra_image_url:" + extra_image_url);
    let extra_image_id = "";
    if (extra_image_url) {
      const pathname = new URL(extra_image_url).pathname;
      extra_image_id = getLastPathName(pathname);
    }
    const interaction_content = container.querySelector(".interaction-content");
    let interaction_content_text = "";
    if (interaction_content) {
      interaction_content_text = ((_c = interaction_content.textContent) == null ? void 0 : _c.trim()) || "";
    }
    if (interaction_content_text == "[图片]") {
      console.info("评论内容只有图片，不评论。interaction_content_text：", interaction_content_text);
      continue;
    }
    const quote_info = container.querySelector(".quote-info");
    let quote_info_text = "";
    if (quote_info) {
      quote_info_text = ((_d = quote_info.textContent) == null ? void 0 : _d.trim()) || "";
    }
    const action_reply_el = container.querySelector(".action-reply");
    if (!action_reply_el) {
      console.log("没有找到回复按钮，不做评论");
      continue;
    }
    const inputs = {
      text: interaction_content_text,
      before: quote_info_text,
      style: XiaoHongShu_Setting$3 == null ? void 0 : XiaoHongShu_Setting$3.style,
      word_limit: XiaoHongShu_Setting$3 == null ? void 0 : XiaoHongShu_Setting$3.charLimit,
      key_message: XiaoHongShu_Setting$3 == null ? void 0 : XiaoHongShu_Setting$3.keywordInfo
    };
    const files = [];
    let path = "replyComment_user_" + store$6.userId + "_path_" + extra_image_id + "_comment_user_id_" + comment_user_id;
    console.log("Path: ", path);
    if (viewedPaths.includes(path)) {
      console.log("已经处理过了");
      continue;
    }
    if (await queryComment(path)) {
      let replyCommentText = "";
      if (XiaoHongShu_Setting$3.tag == "ai生成") {
        replyCommentText = await runWorkflow(inputs, files);
      } else if (XiaoHongShu_Setting$3.tag == "固定回复") {
        replyCommentText = XiaoHongShu_Setting$3.replyComment;
      } else {
        console.log("工作方式 不存在", XiaoHongShu_Setting$3.tag);
        continue;
      }
      if (replyCommentText) {
        await click_button(action_reply_el);
        console.log("增加评论后缀信息", XiaoHongShu_Setting$3 == null ? void 0 : XiaoHongShu_Setting$3.commentSuffix);
        if (XiaoHongShu_Setting$3.tag == "ai生成" && (XiaoHongShu_Setting$3 == null ? void 0 : XiaoHongShu_Setting$3.commentSuffix)) {
          console.log("增加评论后缀信息", XiaoHongShu_Setting$3 == null ? void 0 : XiaoHongShu_Setting$3.commentSuffix);
          replyCommentText += "\r\n" + (XiaoHongShu_Setting$3 == null ? void 0 : XiaoHongShu_Setting$3.commentSuffix);
        }
        const saveInputs = {
          refer_id: path,
          data_type: "replyComment",
          title: "",
          text: interaction_content_text,
          label: "",
          style: XiaoHongShu_Setting$3 == null ? void 0 : XiaoHongShu_Setting$3.style,
          word_limit: XiaoHongShu_Setting$3 == null ? void 0 : XiaoHongShu_Setting$3.charLimit,
          key_message: XiaoHongShu_Setting$3 == null ? void 0 : XiaoHongShu_Setting$3.keywordInfo,
          commentSuffix: XiaoHongShu_Setting$3 == null ? void 0 : XiaoHongShu_Setting$3.commentSuffix,
          tag: XiaoHongShu_Setting$3.tag,
          comment_user_url,
          comment_user_id,
          extra_image_url,
          extra_image_id,
          replyComment: replyCommentText,
          userId: store$6.userId
        };
        await action_reply(container, replyCommentText, saveInputs);
        viewedPaths.push(path);
        await action_like(container);
      }
    } else {
      console.log("已经回复过了");
      viewedPaths.push(path);
    }
  }
}
async function action_reply(container, replyCommentText, saveInputs) {
  if (!(await checkDomPromise(".input-wrapper .comment-input"))) {
    return;
  }
  let comment_input_el = container.querySelector(".input-wrapper .comment-input");
  if (!comment_input_el) {
    console.error("没有找到输入框，不做评论");
    return;
  }
  let comment_html_input_el = comment_input_el;
  comment_html_input_el.value = replyCommentText;
  const event = new Event("input", {
    bubbles: true,
    cancelable: true
  });
  comment_html_input_el.dispatchEvent(event);
  if (!(await checkDomPromise(".actions .submit"))) {
    return;
  }
  const submit_el = container.querySelector(".actions .submit");
  if (!submit_el) {
    console.error("没有找到输入框，不做评论");
    return;
  }
  await click_button(submit_el);
  await saveComment(saveInputs);
  store$6.increment_XiaoHongShu_CommentCount();
}
async function action_like(container) {
  if (!(await checkDomPromise(".action-like .like-lottie"))) {
    return;
  }
  const action_like_el = container.querySelector(".action-like .like-lottie");
  if (!action_like_el) {
    console.error("没有找到点赞按钮");
    return;
  }
  await click_button(action_like_el);
}
async function autoConnections(viewedPaths) {
  var _a;
  await switchTabItem("新增关注");
  if (!(await checkDomPromise(".tabs-content-container .container"))) {
    return;
  }
  const containers = document.querySelectorAll(".tabs-content-container .container");
  console.log("containers", containers.length);
  for (let i = 0; i < containers.length; i++) {
    const container = containers[i];
    const reds_button_new = container.querySelector(".reds-button-new");
    if (!reds_button_new) {
      console.log("reds_button_new 不存在", reds_button_new);
      continue;
    }
    const user_avatar = container.querySelector("a.user-avatar");
    if (!user_avatar) {
      console.log("reds_button_new 不存在", user_avatar);
      continue;
    }
    const container_href = user_avatar.href;
    let container_user_id = "";
    if (container_href) {
      const pathname = new URL(container_href).pathname;
      container_user_id = getLastPathName(pathname);
    }
    if (!container_user_id) {
      console.log("关注用户id为空", container_user_id);
      continue;
    }
    const reds_button_new_text = container.querySelector(".reds-button-new-text");
    let button_text = "";
    if (reds_button_new_text) {
      button_text = ((_a = reds_button_new_text.textContent) == null ? void 0 : _a.trim()) || "";
    }
    console.log("button_text", button_text);
    if (button_text == "回关") {
      const key = "connections_follow_" + store$6.userId + "_" + container_user_id;
      if (viewedPaths.includes(key)) {
        console.log("已回关了");
        continue;
      }
      if (await queryComment(key)) {
        await click_button(reds_button_new);
        const saveInputs = {
          "refer_id": key,
          data_type: "connections_follow",
          "user_id": store$6.userId,
          "container_user_id": container_user_id,
          "container_url": container_href
        };
        await saveComment(saveInputs);
        store$6.increment_XiaoHongShu_connections_follow();
        viewedPaths.push(key);
      } else {
        console.log("已回关了");
        viewedPaths.push(key);
      }
    } else {
      console.log("connections_unfollow", XiaoHongShu_Setting$3.connections_unfollow);
      if (XiaoHongShu_Setting$3.connections_unfollow && button_text == "互相关注") {
        await autoConnections_unfollow(container, reds_button_new, container_user_id, container_href);
      }
    }
  }
}
async function autoConnections_unfollow(container, reds_button_new, container_user_id, container_href) {
  var _a;
  const interaction_time = container.querySelector(".interaction-time");
  let interaction_time_text = "";
  if (interaction_time) {
    interaction_time_text = ((_a = interaction_time.textContent) == null ? void 0 : _a.trim()) || "";
  }
  console.log("interaction_time_text", interaction_time_text);
  if (!interaction_time_text) {
    console.log("关注的日期为空");
    return;
  }
  let num = 0;
  if (interaction_time_text.includes("今天")) {
    return;
  } else if (interaction_time_text.includes("刚刚")) {
    return;
  } else if (interaction_time_text.includes("昨天")) {
    num = 1;
  } else if (interaction_time_text.includes("天前")) {
    num = extractNumber(interaction_time_text);
    if (!num) {
      console.log("关注的日期几天前的数字为空", num);
      return;
    }
  } else {
    const interaction_time_texts = interaction_time_text.split("-");
    if (!interaction_time_texts || interaction_time_texts.length !== 2) {
      return null;
    }
    const month = parseInt(interaction_time_texts[0], 10) - 1;
    const day = parseInt(interaction_time_texts[1], 10);
    const currentDate = /* @__PURE__ */new Date();
    const currentYear = currentDate.getFullYear();
    const interactionDate = new Date(currentYear, month, day);
    const timeDifference = currentDate.getTime() - interactionDate.getTime();
    num = Math.floor(timeDifference / (1e3 * 60 * 60 * 24));
  }
  if (!XiaoHongShu_Setting$3.connections_unfollow_num) {
    console.log("取消关注的时间为空", XiaoHongShu_Setting$3.connections_unfollow_num);
    return;
  }
  if (XiaoHongShu_Setting$3.connections_unfollow_num > num) {
    console.log("取消关注的时间 还不到", XiaoHongShu_Setting$3.connections_unfollow_num, num);
    return;
  }
  const key = "connections_unfollow_" + store$6.userId + "_" + container_user_id;
  if (store$6.connections_unfollow_viewedPaths.includes(key)) {
    console.log("已经取关了");
    return;
  }
  if (await queryComment(key)) {
    await click_button(reds_button_new);
    const saveInputs = {
      "refer_id": key,
      data_type: "connections_unfollow",
      "user_id": store$6.userId,
      "container_user_id": container_user_id,
      "container_url": container_href
    };
    await saveComment(saveInputs);
    store$6.connections_unfollow_viewedPaths.push(key);
    store$6.increment_XiaoHongShu_connections_unfollow();
  } else {
    store$6.connections_unfollow_viewedPaths.push(key);
    console.log("已经取关了");
  }
}
async function autoLikeFlow(viewedPaths) {
  var _a, _b, _c, _d, _e;
  await switchTabItem("赞和收藏");
  console.log("viewedPaths", viewedPaths);
  let end_num = 0;
  let last_date = store$6.lastLikeFlowDate;
  console.log("last_date", last_date);
  try {
    while (true) {
      if (!(await checkDomPromise(".tabs-content-container .container"))) {
        return;
      }
      const containers = document.querySelectorAll(".tabs-content-container .container");
      console.log("containers", containers.length);
      for (let i = 0; i < containers.length; i++) {
        const container = containers[i];
        const user_info_a = container.querySelector(".main .info .user-info a");
        if (!user_info_a) {
          continue;
        }
        await ensureElementVisible3(user_info_a, 180);
        console.log("user_info_a", user_info_a);
        const user_info_a_url = user_info_a.getAttribute("href");
        if (!user_info_a_url) {
          continue;
        }
        if (viewedPaths.includes(user_info_a_url)) {
          continue;
        }
        viewedPaths.push(user_info_a_url);
        const user_info_user_tag = container.querySelector(".main .info .user-info .user-tag");
        let user_info_user_tag_text = "";
        if (user_info_user_tag) {
          user_info_user_tag_text = ((_a = user_info_user_tag.textContent) == null ? void 0 : _a.trim()) || "";
        }
        console.log("user_info_user_tag", user_info_user_tag, user_info_user_tag_text);
        if (user_info_user_tag_text == "你的好友" || user_info_user_tag_text == "你的关注") {
          continue;
        }
        const interaction_time = container.querySelector(".main .info .interaction-time");
        let interaction_time_text = "";
        if (interaction_time) {
          interaction_time_text = ((_b = interaction_time.textContent) == null ? void 0 : _b.trim()) || "";
        }
        if (!(interaction_time_text.includes("刚刚") || interaction_time_text.includes("今天") || interaction_time_text.includes("昨天"))) {
          console.log("interaction_time_text", interaction_time_text);
          return;
        }
        const parsedInfo = parseLine(interaction_time_text);
        let dateObject = null;
        if (parsedInfo && parsedInfo.publicationDate) {
          console.log("parsedInfo", parsedInfo);
          dateObject = new Date(parsedInfo.publicationDate);
          if (store$6.lastLikeFlowDate && dateObject && store$6.lastLikeFlowDate.getTime() > dateObject.getTime()) {
            console.log("lastLikeFlowDate 已完成", store$6.lastLikeFlowDate.getTime(), dateObject.getTime());
            return;
          }
        }
        let x = 0;
        let y = 0;
        try {
          let rect = user_info_a.getBoundingClientRect();
          x = rect.left + rect.width / 2;
          y = rect.top + rect.height / 2;
          console.log("x,y", rect, x, y);
          let mouseOverEvent = new MouseEvent("mouseover", {
            view: window,
            bubbles: true,
            cancelable: true,
            clientX: x,
            clientY: y
          });
          user_info_a.dispatchEvent(mouseOverEvent);
          let mouseMoveEvent = new MouseEvent("mousemove", {
            view: window,
            bubbles: true,
            cancelable: true,
            clientX: x,
            clientY: y
          });
          user_info_a.dispatchEvent(mouseMoveEvent);
          let mouseEnterEvent = new MouseEvent("mouseenter", {
            view: window,
            bubbles: true,
            cancelable: true,
            clientX: x,
            clientY: y
          });
          user_info_a.dispatchEvent(mouseEnterEvent);
          if (!(await checkDomPromise(".tooltip-content .user-content .header-area"))) {
            continue;
          }
          const follow_button = document.querySelector(".tooltip-content .user-content .header-area .follow-button");
          console.log("follow_button", follow_button);
          if (!follow_button) {
            continue;
          }
          let follow_button_text = "";
          if (follow_button) {
            follow_button_text = ((_c = follow_button.textContent) == null ? void 0 : _c.trim()) || "";
          }
          let focus = 0;
          let fans = 0;
          let likes_and_favorites = 0;
          const interactions = document.querySelectorAll(".tooltip-container .tooltip-content .user-content .header-area .interaction-info .interaction");
          for (const interaction of interactions) {
            let interaction_text = "";
            if (interaction) {
              interaction_text = ((_d = interaction.textContent) == null ? void 0 : _d.trim()) || "";
            }
            if (interaction_text) {
              if (interaction_text.includes("关注")) {
                focus = parseInt(interaction_text);
              } else if (interaction_text.includes("粉丝")) {
                fans = parseInt(interaction_text);
              } else if (interaction_text.includes("获赞与收藏")) {
                likes_and_favorites = parseInt(interaction_text);
              }
            }
          }
          if (fans < XiaoHongShu_Setting$3.connections_num) {
            console.log("只关注粉丝数大于多少的账号≥", fans, "<", XiaoHongShu_Setting$3.connections_num);
            continue;
          }
          if (likes_and_favorites < XiaoHongShu_Setting$3.like_num) {
            console.log("只关注获赞大于多少的账号≥", likes_and_favorites, "<", XiaoHongShu_Setting$3.like_num);
            continue;
          }
          if (XiaoHongShu_Setting$3.connections_ge_follow && fans < focus) {
            console.log("只关注于粉丝数>关注数的账号", XiaoHongShu_Setting$3.connections_ge_follow, fans, "<=", focus);
            continue;
          }
          if (follow_button_text == "关注" || follow_button_text == "回关") {
            await click_button(follow_button);
            if (follow_button) {
              follow_button_text = ((_e = follow_button.textContent) == null ? void 0 : _e.trim()) || "";
            }
            while (true) {
              if (follow_button_text == "关注" || follow_button_text == "回关") {
                console.log("关注成功了");
                if (dateObject) {
                  console.log("dateObject", dateObject, last_date);
                  if (!last_date) {
                    last_date = dateObject;
                  } else if (last_date < dateObject) {
                    last_date = dateObject;
                  }
                }
                store$6.increment_XiaoHongShu_likes_follow();
                await saveLikeFollows({
                  followed_id: store$6.userId,
                  follower_id: user_info_a_url
                });
                break;
              } else {
                await delay(1e3);
              }
            }
          }
        } finally {
          let mouseLeaveEvent2 = new MouseEvent("mouseleave", {
            view: window,
            bubbles: true,
            cancelable: true,
            clientX: x,
            clientY: y
          });
          user_info_a.dispatchEvent(mouseLeaveEvent2);
        }
      }
      const end_container = document.querySelectorAll(".end-container");
      console.log("end_container", end_container);
      if (end_container && end_container.length > 0) {
        if (end_num > 1) {
          console.log("处理完成");
          return;
        }
        end_num++;
      }
    }
  } catch (e) {
    console.log("autoLikeFlow", e);
  } finally {
    if (last_date) {
      console.log("last_date", last_date);
      store$6.setLastLikeFlowDate(last_date);
    }
  }
}
const store$5 = UseCounterStore.getInstance();
let XiaoHongShu_Setting$2 = JSON.parse(store$5.XiaoHongShu_Setting);
const isWithinProbabilityOpen$1 = 80;
const isWithinProbabilitysend_comments$1 = 20;
const isWithinProbabilityclickCommentLike$1 = 50;
const isWithinProbabilityfollow_click$1 = 5;
const isWithinProbabilitycollect_click$1 = 5;
let checkInterval$2 = null;
function runYourCode() {
  if (checkInterval$2) {
    clearInterval(checkInterval$2);
    checkInterval$2 = null;
  }
  let runBool = false;
  checkInterval$2 = setInterval(async () => {
    var _a, _b, _c, _d, _e, _f;
    if (runBool) {
      return;
    }
    runBool = true;
    try {
      const loginContainer = document.querySelector(".login-container");
      if (loginContainer) {
        console.log("User is not logged in");
      } else {
        const userEl = document.querySelector(".side-bar .user.side-bar-component .link-wrapper a");
        if (userEl) {
          const href = new URL(userEl.href).pathname;
          if (href) {
            const segments = href.split("/");
            const userId = segments.pop() || "";
            if (userId) {
              console.log("找到飞书用户Id", userId);
              sendLog("找到飞书用户Id" + userId);
              clearInterval(checkInterval$2);
              checkInterval$2 = null;
              const accountRunNum = await checkXiaoHongShuAccountRunNum("xiaoHongShu", userId);
              if (!accountRunNum) {
                return;
              }
              await store$5.checkLoadend();
              if (!XiaoHongShu_Setting$2 || Object.keys(XiaoHongShu_Setting$2).length == 0) {
                XiaoHongShu_Setting$2 = JSON.parse(store$5.XiaoHongShu_Setting);
              }
              if (store$5.isNotRunWork()) {
                vipCloseEndFun("runYourCode").then();
                return;
              }
              const taskData = await getTabTaskData();
              store$5.setChromeTabId(taskData == null ? void 0 : taskData.tabId);
              const taskName = (_a = taskData == null ? void 0 : taskData.tabData) == null ? void 0 : _a.taskName;
              sendLog("chromeTabId :" + (taskData == null ? void 0 : taskData.tabId));
              if (taskName == "关键词") {
                xiaoHongshuSearch(taskData).then(() => {}).catch(err => {
                  console.error("xiaoHongshuSearch", err);
                });
              } else if (taskName == "信息流") {
                const searchWord = "";
                const get_keyword_bool = false;
                const next_change_time = 0;
                if ((_b = taskData == null ? void 0 : taskData.tabData) == null ? void 0 : _b.taskId) {
                  const date = /* @__PURE__ */new Date();
                  const year = date.getFullYear();
                  const month = String(date.getMonth() + 1).padStart(2, "0");
                  const day = String(date.getDate()).padStart(2, "0");
                  const hours = String(date.getHours()).padStart(2, "0");
                  const minutes = String(date.getMinutes()).padStart(2, "0");
                  const addDate = `${year}-${month}-${day} ${hours}:${minutes}`;
                  const saveInputs = {
                    "key": store$5.userId + (/* @__PURE__ */new Date()).getTime(),
                    "bucket": {
                      taskType: (_c = taskData == null ? void 0 : taskData.tabData) == null ? void 0 : _c.taskName,
                      taskPlatform: (_d = taskData == null ? void 0 : taskData.tabData) == null ? void 0 : _d.taskPlatform,
                      taskId: (_e = taskData == null ? void 0 : taskData.tabData) == null ? void 0 : _e.taskId,
                      searchWord: XiaoHongShu_Setting$2 == null ? void 0 : XiaoHongShu_Setting$2.searchWord,
                      addDate,
                      addTime: (/* @__PURE__ */new Date()).getTime()
                    },
                    "size": 0,
                    "content_type": "string",
                    "belong_to": store$5.userId + "_XiaoHongShu_work_list",
                    "object_metadata": {}
                  };
                  await saveComment$1(saveInputs);
                }
                xiaoHongshuClick_cover_ld_mask([], searchWord, get_keyword_bool, next_change_time).then(res => {
                  console.log("xiaoHongshuClick_cover_ld_mask res", res);
                }).catch(err => {
                  console.error("xiaoHongshuClick_cover_ld_mask", err);
                }).finally(() => {
                  vipCloseEndFun("信息流 end").then();
                });
              } else if (taskName == "自动回复") {
                auto_replyComment().then(res => {
                  console.log("auto_replyComment res", res);
                }).catch(err => {
                  console.log("auto_replyComment err", err);
                });
              } else if (taskName == "取消点赞的关注") {
                auto_like_unfollow((_f = taskData == null ? void 0 : taskData.tabData) == null ? void 0 : _f.note_url).then(res => {
                  console.log("auto_like_unfollow res", res);
                }).catch(err => {
                  console.log("auto_like_unfollow err", err);
                }).finally(() => {
                  console.log("取消点赞的关注 finally");
                  sendCloseTab("auto_like_unfollow");
                });
              }
            } else {
              console.log("没有找到用户登录信息id");
            }
          }
        } else {
          console.log("没有找到用户登录信息");
        }
      }
    } finally {
      runBool = false;
    }
  }, 1e3);
  setTimeout(() => {
    clearInterval(checkInterval$2);
    checkInterval$2 = null;
    console.log("Finished checking login status.");
  }, 10 * 60 * getRandomNumberInRange(1e3, 5e3));
}
async function xiaoHongshuSearch(taskData) {
  var _a, _b, _c, _d;
  while (true) {
    if (!(await checkDomPromise("#search-input"))) {
      console.error("没有找到", "#search-input");
      sendLog("没有找到 搜索框");
      return;
    }
    if (!(XiaoHongShu_Setting$2 == null ? void 0 : XiaoHongShu_Setting$2.searchWord)) {
      XiaoHongShu_Setting$2 = JSON.parse(store$5.XiaoHongShu_Setting);
    }
    if (!(XiaoHongShu_Setting$2 == null ? void 0 : XiaoHongShu_Setting$2.searchWord)) {
      console.error("配置没有生效", store$5.XiaoHongShu_Setting);
      sendLog("配置没有生效");
      return;
    }
    let keywords_list = [];
    keywords_list.push(XiaoHongShu_Setting$2 == null ? void 0 : XiaoHongShu_Setting$2.searchWord);
    let get_keyword_bool = true;
    let next_change_time = 0;
    store$5.setXHSKeywords_list(keywords_list);
    if ((_a = taskData == null ? void 0 : taskData.tabData) == null ? void 0 : _a.taskId) {
      const date = /* @__PURE__ */new Date();
      const year = date.getFullYear();
      const month = String(date.getMonth() + 1).padStart(2, "0");
      const day = String(date.getDate()).padStart(2, "0");
      const hours = String(date.getHours()).padStart(2, "0");
      const minutes = String(date.getMinutes()).padStart(2, "0");
      const addDate = `${year}-${month}-${day} ${hours}:${minutes}`;
      const saveInputs = {
        "key": store$5.userId + (/* @__PURE__ */new Date()).getTime(),
        "bucket": {
          taskType: (_b = taskData == null ? void 0 : taskData.tabData) == null ? void 0 : _b.taskName,
          taskPlatform: (_c = taskData == null ? void 0 : taskData.tabData) == null ? void 0 : _c.taskPlatform,
          taskId: (_d = taskData == null ? void 0 : taskData.tabData) == null ? void 0 : _d.taskId,
          searchWord: XiaoHongShu_Setting$2 == null ? void 0 : XiaoHongShu_Setting$2.searchWord,
          addDate,
          addTime: (/* @__PURE__ */new Date()).getTime()
        },
        "size": 0,
        "content_type": "string",
        "belong_to": store$5.userId + "_XiaoHongShu_work_list",
        "object_metadata": {}
      };
      await saveComment$1(saveInputs);
    }
    for (let i = 0; i < keywords_list.length; i++) {
      console.log("xiaoHongshuSearch");
      const searchWord = keywords_list[i];
      if (store$5.isNotRunWork()) {
        return;
      }
      const searchInput = document.querySelector("#search-input");
      if (!searchInput) {
        sendLog("没有找到搜索框");
        console.error("没有找到搜索框，重新开始");
        return;
      }
      searchInput.value = searchWord;
      const event = new Event("input", {
        bubbles: true,
        cancelable: true
      });
      searchInput.dispatchEvent(event);
      if (!(await checkDomPromise('div[class="search-icon"]'))) {
        console.log('查找不到 div[class="search-icon"]');
        return;
      }
      const searchButton = document.querySelector('div[class="search-icon"]');
      if (searchButton) {
        console.log("点击搜索按钮");
        await click_button(searchButton);
      }
      if (store$5.isNotRunWork()) {
        sendLog("停止了");
        return;
      }
      const keywords_list_res = await xiaoHongshuClick_short_note(searchWord, get_keyword_bool, next_change_time);
      if (keywords_list_res && keywords_list_res.length == 2) {
        const keywords_list_data = keywords_list_res[0];
        next_change_time = keywords_list_res[1];
        get_keyword_bool = false;
        if (keywords_list_data && keywords_list_data.length > 0) {
          for (let j = 0; j < keywords_list_data.length; j++) {
            keywords_list.push(keywords_list_data[j]);
          }
          sendLog("keywords_list" + JSON.stringify(keywords_list));
          store$5.setXHSKeywords_list(keywords_list);
        }
      }
    }
    store$5.increment_XiaoHongShu_search_runNumber();
    sendLog("XiaoHongShu_search_runNumber：" + store$5.XiaoHongShu_search_runNumber);
    if (store$5.XiaoHongShu_search_runNumber > 3) {
      sendLog("content activatePage XiaoHongShu_search_runNumber：", store$5.XiaoHongShu_search_runNumber);
      chrome.storage.local.set({
        "activatePage": indexPage
      });
      return;
    }
    if (store$5.isNotRunWork()) {
      return;
    }
    sendLog("下一次开始");
  }
}
async function xiaoHongshuClick_short_note(searchWord, get_keyword_bool, next_change_time) {
  let keywords_list = [];
  try {
    if (!(await checkDomPromise(".feeds-container"))) {
      sendLog("没有找到搜索结果");
    }
    if (store$5.isNotRunWork()) {
      sendLog("停止了7");
      return;
    }
    await delay(getRandomNumberInRange(1e3, 5e3));
    keywords_list = await xiaoHongshuClick_filter_box(searchWord, get_keyword_bool, next_change_time);
  } catch (e) {
    console.error("ee", e);
    sendLog("xiaoHongshuClick_short_note" + e);
  }
  return keywords_list;
}
async function xiaoHongshuClick_filter_box(searchWord, get_keyword_bool, next_change_time) {
  console.log("选择过滤");
  if (!(await checkDomPromise(".feeds-page .filter"))) {
    console.error("没有找到", ".feeds-page .filter");
    sendLog("没有找到 选择过滤");
    return;
  }
  if (store$5.isNotRunWork()) {
    sendLog("停止了8");
    return;
  }
  const filter_box = document.querySelector(".feeds-page .filter");
  if (!filter_box) {
    console.error("错误，重新开始");
    sendLog("没有找到 选择过滤");
    return;
  }
  const rect = filter_box.getBoundingClientRect();
  const x = rect.left + rect.width / 2;
  const y = rect.top + rect.height / 2;
  console.log("x,y", rect, x, y);
  const mouseOverEvent = new MouseEvent("mouseover", {
    view: window,
    bubbles: true,
    cancelable: true,
    clientX: x,
    clientY: y
  });
  filter_box.dispatchEvent(mouseOverEvent);
  const mouseMoveEvent = new MouseEvent("mousemove", {
    view: window,
    bubbles: true,
    cancelable: true,
    clientX: x,
    clientY: y
  });
  filter_box.dispatchEvent(mouseMoveEvent);
  const mouseEnterEvent = new MouseEvent("mouseenter", {
    view: window,
    bubbles: true,
    cancelable: true,
    clientX: x,
    clientY: y
  });
  filter_box.dispatchEvent(mouseEnterEvent);
  await delay(getRandomNumberInRange(1e3, 5e3));
  return await xiaoHongshuClick_dropdown_container(searchWord, get_keyword_bool, next_change_time);
}
const getFilterElementEl = selector => {
  const xpathResult = Array.from(document.querySelectorAll(selector));
  let targetElement = null;
  if (!(XiaoHongShu_Setting$2 == null ? void 0 : XiaoHongShu_Setting$2.category)) {
    console.error("没有配置 category", XiaoHongShu_Setting$2 == null ? void 0 : XiaoHongShu_Setting$2.category);
    sendLog("没有配置 category");
    return;
  }
  for (let i = 0; i < xpathResult.length; i++) {
    const element = xpathResult[i];
    if (!element) {
      continue;
    }
    console.log(element);
    console.log(element.childElementCount, XiaoHongShu_Setting$2 == null ? void 0 : XiaoHongShu_Setting$2.category);
    if (element && element.childElementCount === 0 && element.textContent && element.textContent.trim() === (XiaoHongShu_Setting$2 == null ? void 0 : XiaoHongShu_Setting$2.category)) {
      targetElement = element;
      break;
    }
  }
  if (!targetElement) {
    console.log("Element not found", XiaoHongShu_Setting$2 == null ? void 0 : XiaoHongShu_Setting$2.category);
    sendLog("没有配置 category");
  }
  console.log("Element found:", targetElement);
  return targetElement;
};
async function xiaoHongshuClick_dropdown_container(searchWord, get_keyword_bool, next_change_time) {
  console.log("选择最新");
  if (store$5.isNotRunWork()) {
    sendLog("停止了9");
    return;
  }
  let targetElement = getFilterElementEl(".filter-container span");
  if (!targetElement) {
    targetElement = getFilterElementEl(".dropdown-container span");
  }
  if (targetElement) {
    await click_button(targetElement);
  }
  const filter_box = document.querySelector(".feeds-page .filter");
  if (filter_box) {
    await click_button(filter_box);
  }
  if (!(await checkDomPromise(".cover.ld.mask"))) {
    console.error("没有找到", ".cover.ld.mask");
    sendLog("没有找到搜索结果");
    return;
  }
  return await xiaoHongshuClick_cover_ld_mask([], searchWord, get_keyword_bool, next_change_time);
}
async function xiaoHongshuClick_cover_ld_mask(viewedPaths, searchWord, get_keyword_bool, next_change_time) {
  let keywords_list = [];
  while (true) {
    try {
      sendLog("xiaoHongshuClick_cover_ld_mask");
      if (store$5.isNotRunWork()) {
        vipCloseEndFun("xiaoHongshuClick_cover_ld_mask").then();
        return [];
      }
      let elements_ = document.querySelectorAll(".note-item");
      let elements = Array.from(elements_);
      sendLog("elements:" + elements.length);
      const title_texts = [];
      if (XiaoHongShu_Setting$2.smartKeywords == "智能关键词") {
        if (get_keyword_bool) {
          Array.from(elements).filter(element => {
            var _a;
            const title_el = element.querySelector(".title");
            if (!title_el) {
              return false;
            }
            const title_text = (_a = title_el.textContent) == null ? void 0 : _a.trim();
            title_texts.push(title_text);
          });
          sendLog("title_texts：" + JSON.stringify(title_texts));
          keywords_list = await getKeywordsIntelligentAssociation(title_texts, searchWord);
          sendLog("keywords_list：" + JSON.stringify(keywords_list));
          get_keyword_bool = false;
          const lastTime = await queryLastTime();
          sendLog("XiaoHongShu_Setting.operationTime " + lastTime + " " + XiaoHongShu_Setting$2.operationTime);
          let keywords_len = keywords_list.length;
          sendLog("keywords_len：" + keywords_len);
          const operationTime = parseInt(XiaoHongShu_Setting$2.operationTime);
          const avgTime = Math.ceil(operationTime / keywords_len);
          sendLog("XiaoHongShu_avgTime：" + avgTime);
          store$5.setXiaoHongShu_avgTime(avgTime);
          next_change_time = lastTime;
        }
      }
      if (XiaoHongShu_Setting$2.workType == "关键词" && XiaoHongShu_Setting$2.smartKeywords !== "智能关键词") {
        store$5.setXiaoHongShu_avgTime(0);
      }
      let view_bool = false;
      let element_a_els = [];
      Array.from(elements).filter(element => {
        const element_a_el = element.querySelector(".cover.ld.mask");
        if (!element_a_el) {
          return false;
        }
        const href = new URL(element_a_el.href).pathname;
        if (!viewedPaths.includes(href)) {
          element_a_els.push(element_a_el);
        }
      });
      elements = element_a_els;
      if (elements.length > 0) {
        const element = elements[0];
        await xiaoHongshu_list_processElements(element, view_bool);
        if (store$5.isNotRunWork()) {
          vipCloseEndFun("xiaoHongshuClick_cover_ld_mask2").then();
          break;
        }
        const href = new URL(element.href).pathname;
        viewedPaths.push(href);
      }
      if (!(await checkDomPromise(".cover.ld.mask"))) {
        sendLog("没有找到.cover.ld.mask");
        break;
      }
      if (elements.length == 0) {
        const end_container = document.querySelectorAll(".end-container");
        sendLog("end_container" + end_container);
        if (end_container && end_container.length > 0) {
          sendLog("end_container 处理完成");
          break;
        } else {
          sendLog("继续处理");
        }
      }
      if (XiaoHongShu_Setting$2.workType == "关键词") {
        const lastTime = await queryLastTime();
        sendLog("lastTime：" + lastTime + " " + store$5.XiaoHongShu_avgTime);
        const operationTime = parseInt(XiaoHongShu_Setting$2.operationTime);
        if (store$5.XiaoHongShu_avgTime && lastTime !== null && lastTime !== void 0 && lastTime != next_change_time && lastTime != operationTime && lastTime % store$5.XiaoHongShu_avgTime == 0) {
          sendLog("开始搜索下一个关键词 " + lastTime + " " + store$5.XiaoHongShu_avgTime + " " + operationTime);
          next_change_time = lastTime;
          break;
        }
      } else {
        const lastTime = await queryLastTime();
        sendLog("queryLastTime lastTime:" + lastTime);
        if (lastTime <= 0) {
          break;
        }
      }
    } catch (e) {
      sendLog("xiaoHongshuClick_cover_ld_mask，结束" + e);
      console.error("xiaoHongshuClick_cover_ld_mask", e);
    }
  }
  return [keywords_list, next_change_time];
}
async function xiaoHongshu_list_processElements(element, view_bool = false) {
  try {
    sendLog("开始下一个笔记1");
    if (!(await checkDomByDom(element))) {
      return;
    }
    sendLog("开始下一个笔记2");
    if (store$5.isNotRunWork()) {
      return;
    }
    console.log("element", element);
    ensureElementVisible2(element);
    if (store$5.isNotRunWork()) {
      return;
    }
    if (!view_bool) {
      if (isWithinProbability(isWithinProbabilityOpen$1)) {
        await xiaoHongshu_tuwen_open(element);
        await delay(getRandomNumberInRange(3e3, 6e3));
      } else {
        console.log("跳过 不打开图文");
        await delay(getRandomNumberInRange(1e3, 5e3));
      }
    } else {
      console.log("只是为了滚动页面，不做任何的操作");
    }
  } catch (e) {
    sendLog("xiaoHongshu_list_processElements error" + e);
    console.error(e);
  } finally {
    console.log("All elements have been processed.");
  }
}
async function xiaoHongshu_tuwen_open(element) {
  try {
    await click_button(element);
    console.log("element", element);
    store$5.increment_xhs_viewCount();
    await xiaoHongshu_tuwen_start_exec();
    if (store$5.isNotRunWork()) {
      return;
    }
    await delay(getRandomNumberInRange(1e3, 5e3));
    if (!(await checkDomPromise(".close-circle .reds-icon"))) {
      return;
    }
    if (store$5.isNotRunWork()) {
      return;
    }
    const reds_icon_el = document.querySelector(".close-circle .reds-icon");
    if (!reds_icon_el) {
      console.log("正在关闭打开的图文 没有找到关闭图标");
      return;
    }
    await click_button(reds_icon_el);
  } catch (e) {
    console.error("xiaoHongshu_tuwen_open error", e);
    sendLog("xiaoHongshu_tuwen_open error" + e);
  }
}
async function xiaoHongshu_tuwen_start_exec() {
  if (!(await checkDomPromise("#detail-desc"))) {
    console.error("没有找到", "#detail-desc");
    return;
  }
  if (store$5.isNotRunWork()) {
    return;
  }
  const stringList = [];
  if (XiaoHongShu_Setting$2.reviewProbability == "默认AI控制") {
    if (isWithinProbability(isWithinProbabilitysend_comments$1)) {
      stringList.push("xiaoHongshu_send_comments");
    } else {
      console.log("跳过 不评论");
    }
  } else if (XiaoHongShu_Setting$2.reviewProbability == "自定义概率" && XiaoHongShu_Setting$2.customProbabilitiesNum && isWithinProbability(XiaoHongShu_Setting$2.customProbabilitiesNum)) {
    stringList.push("xiaoHongshu_send_comments");
  }
  if (XiaoHongShu_Setting$2 == null ? void 0 : XiaoHongShu_Setting$2.like) {
    if (isWithinProbability(isWithinProbabilityclickCommentLike$1)) {
      stringList.push("xiaoHongShu_clickCommentLike");
    } else {
      console.log("跳过 不点赞");
    }
  }
  if (XiaoHongShu_Setting$2 == null ? void 0 : XiaoHongShu_Setting$2.follow) {
    if (isWithinProbability(isWithinProbabilityfollow_click$1)) {
      stringList.push("xiaoHongShu_follow_click");
    } else {
      console.log("跳过 不关注");
    }
  }
  if (XiaoHongShu_Setting$2 == null ? void 0 : XiaoHongShu_Setting$2.collect) {
    if (isWithinProbability(isWithinProbabilitycollect_click$1)) {
      stringList.push("xiaoHongShu_collect_click");
    } else {
      console.log("跳过 不收藏");
    }
  }
  await randomExecFunction(stringList);
}
async function randomExecFunction(strings) {
  let remainingStrings = [...strings];
  while (remainingStrings.length > 0) {
    if (store$5.isNotRunWork()) {
      return;
    }
    const randomIndex = Math.floor(Math.random() * remainingStrings.length);
    console.log(remainingStrings[randomIndex]);
    switch (remainingStrings[randomIndex]) {
      case "xiaoHongshu_send_comments":
        await xiaoHongshu_tuwen_read_info();
        break;
      case "xiaoHongShu_clickCommentLike":
        await xiaoHongShu_clickCommentLike();
        break;
      case "xiaoHongShu_follow_click":
        await xiaoHongShu_follow_click();
        break;
      case "xiaoHongShu_collect_click":
        await xiaoHongShu_collect_click();
        break;
      default:
        console.error("错误信息", remainingStrings[randomIndex]);
    }
    remainingStrings.splice(randomIndex, 1);
  }
}
async function xiaoHongshu_tuwen_read_info() {
  var _a, _b;
  if (!(await checkDomPromise("#detail-desc"))) {
    console.error("没有找到", "#detail-desc");
    return;
  }
  if (store$5.isNotRunWork()) {
    return;
  }
  const img_container_el = document.querySelector(".swiper-slide.swiper-slide-visible.swiper-slide-active .img-container .note-slider-img");
  let img_container_url = "";
  if (img_container_el) {
    img_container_url = img_container_el.src;
  }
  console.log("img_container_el:", img_container_el);
  console.log("img_container_url:" + img_container_url);
  const detail_title_el = document.querySelector("#detail-title");
  let detail_title = "";
  if (detail_title_el) {
    detail_title = ((_a = detail_title_el.textContent) == null ? void 0 : _a.trim()) || "";
  }
  console.log("detail_title_el:", detail_title_el);
  console.log("detail_title:", detail_title);
  const detail_content_els = document.querySelectorAll("#detail-desc span");
  let detail_content = "";
  if (detail_content_els && detail_content_els.length > 0) {
    detail_content = ((_b = detail_content_els[0].textContent) == null ? void 0 : _b.trim()) || "";
  }
  console.log("detail_content_els:", detail_content_els);
  console.log("detail_content:", detail_content);
  const detail_tags_els = document.querySelectorAll("#detail-desc a");
  let detail_tags = [];
  detail_tags_els.forEach(detail_tags_el => {
    var _a2;
    if (detail_tags_el && detail_tags_el.textContent) {
      detail_tags.push((_a2 = detail_tags_el.textContent) == null ? void 0 : _a2.trim());
    }
  });
  let detail_tag_str = detail_tags.join(" ");
  console.log("detail_tags_els:", detail_tags_els);
  console.log("detail_tag_str:", detail_tag_str);
  let extra_image_id = "";
  if (img_container_url) {
    const pathname = new URL(img_container_url).pathname;
    extra_image_id = getLastPathName$1(pathname);
  }
  if (store$5.isNotRunWork()) {
    return;
  }
  const currentUrl = window.location.href;
  const parsedUrl = new URL(currentUrl);
  const note_id = getLastPathName$1(parsedUrl.pathname);
  const user_infos = document.querySelectorAll(".interaction-container .author-wrapper .info a");
  let comment_user_url = "";
  let comment_user_id = "";
  if (user_infos && user_infos.length > 0) {
    const user_info = user_infos[0];
    comment_user_url = user_info.href;
    if (comment_user_url) {
      const pathname = new URL(comment_user_url).pathname;
      comment_user_id = getLastPathName$1(pathname);
    }
  }
  sendLog("Path: " + store$5.userId + "  " + note_id);
  const refer_id = "XiaoHongShu_comment_user_" + store$5.userId + "_path_" + note_id;
  const ogVideoMeta = document.querySelector('meta[name="og:video"]');
  if (await queryComment$1(refer_id)) {
    let result = null;
    if (ogVideoMeta) {
      const textContent_str = await get_xiaoHongshu_send_child_comment();
      sendLog("图文 XiaoHongShu_Setting.commentBlocking: " + XiaoHongShu_Setting$2.commentBlocking);
      console.log("图文 XiaoHongShu_Setting.commentBlocking: " + XiaoHongShu_Setting$2.commentBlocking);
      if (XiaoHongShu_Setting$2.commentBlocking == "评论截流" && XiaoHongShu_Setting$2.commentBlockingNum > 0) {
        const callbackFun = async () => {
          const inputs22 = {
            titles: detail_title,
            test: detail_content,
            tab: detail_tag_str,
            commentaries: textContent_str,
            style: XiaoHongShu_Setting$2 == null ? void 0 : XiaoHongShu_Setting$2.style,
            key_message: XiaoHongShu_Setting$2 == null ? void 0 : XiaoHongShu_Setting$2.keywordInfo
          };
          result = await runWorkflowVideoReviews(inputs22, []);
          return result;
        };
        await xiaoHongshu_send_child_comment(callbackFun);
      }
      const inputs2 = {
        titles: detail_title,
        test: detail_content,
        tab: detail_tag_str,
        commentaries: textContent_str,
        style: XiaoHongShu_Setting$2 == null ? void 0 : XiaoHongShu_Setting$2.style,
        key_message: XiaoHongShu_Setting$2 == null ? void 0 : XiaoHongShu_Setting$2.keywordInfo
      };
      result = await runWorkflowVideoReviews(inputs2, []);
    } else {
      sendLog("没有配置 style " + (XiaoHongShu_Setting$2 == null ? void 0 : XiaoHongShu_Setting$2.style) + " " + (XiaoHongShu_Setting$2 == null ? void 0 : XiaoHongShu_Setting$2.keywordInfo));
      const inputs = {
        title: detail_title,
        text: detail_content,
        label: detail_tag_str,
        style: XiaoHongShu_Setting$2 == null ? void 0 : XiaoHongShu_Setting$2.style,
        key_message: XiaoHongShu_Setting$2 == null ? void 0 : XiaoHongShu_Setting$2.keywordInfo
      };
      const files = [];
      if (img_container_url) {
        files.push({
          type: "image",
          transfer_method: "remote_url",
          url: img_container_url
        });
      }
      sendLog("图文 XiaoHongShu_Setting.commentBlocking：" + XiaoHongShu_Setting$2.commentBlocking);
      if (XiaoHongShu_Setting$2.commentBlocking == "评论截流" && XiaoHongShu_Setting$2.commentBlockingNum > 0) {
        const callbackFun = async () => {
          const apiKey2 = "app-sWEO7bEcr3u0MEEeS5QGjSKW";
          result = await runWorkflow$1(inputs, files, apiKey2);
          return result;
        };
        await xiaoHongshu_send_child_comment(callbackFun);
      }
      const apiKey = "app-sWEO7bEcr3u0MEEeS5QGjSKW";
      result = await runWorkflow$1(inputs, files, apiKey);
    }
    sendLog("result: " + result);
    if (result) {
      const date = /* @__PURE__ */new Date();
      const year = date.getFullYear();
      const month = String(date.getMonth() + 1).padStart(2, "0");
      const day = String(date.getDate()).padStart(2, "0");
      const hours = String(date.getHours()).padStart(2, "0");
      const minutes = String(date.getMinutes()).padStart(2, "0");
      const addDate = `${year}-${month}-${day} ${hours}:${minutes}`;
      const saveInputsData = {
        refer_id,
        title: detail_title,
        //标题
        text: detail_content,
        // 详情内容
        label: detail_tag_str,
        // 标签
        style: XiaoHongShu_Setting$2 == null ? void 0 : XiaoHongShu_Setting$2.style,
        key_message: XiaoHongShu_Setting$2 == null ? void 0 : XiaoHongShu_Setting$2.keywordInfo,
        workType: XiaoHongShu_Setting$2 == null ? void 0 : XiaoHongShu_Setting$2.workType,
        searchWord: XiaoHongShu_Setting$2 == null ? void 0 : XiaoHongShu_Setting$2.searchWord,
        note_url: currentUrl,
        //帖子url
        note_id,
        //帖子id
        comment_user_url,
        // 帖子的作者url
        comment_user_id,
        // 帖子的作者id
        extra_image_id,
        // 帖子图片id
        extra_image_url: img_container_url,
        // 帖子图片url
        replyComment: result,
        // 评论内容
        userId: store$5.userId,
        // 用户id
        taskId: store$5.taskId,
        addDate,
        addTime: (/* @__PURE__ */new Date()).getTime()
      };
      const saveInputs = {
        "key": refer_id,
        "bucket": saveInputsData,
        "size": 0,
        "content_type": "string",
        "belong_to": store$5.userId + "_XiaoHongShu_comment",
        "object_metadata": {}
      };
      await xiaoHongshu_send_comments(result, saveInputs);
    }
  } else {
    console.log("已评论过。跳过");
  }
}
async function get_xiaoHongshu_send_child_comment() {
  var _a;
  const textContents = [];
  const parentComments = document.querySelectorAll(".parent-comment >div:nth-child(1)");
  for (let i = 0; i < 5; i++) {
    if (parentComments[i]) {
      const reply = parentComments[i].querySelector(".content .note-text");
      if (reply) {
        const textContent = (_a = reply.textContent) == null ? void 0 : _a.trim();
        textContents.push(textContent);
      }
    }
  }
  let textContent_str = "";
  for (let i = 0; i < textContents.length; i++) {
    if (textContent_str) {
      textContent_str += "\n";
    }
    textContent_str += i + 1 + "、" + textContents[i];
  }
  return textContent_str;
}
async function xiaoHongshu_send_child_comment(callbackFun) {
  var _a;
  const chatWrapper = document.querySelectorAll(".chat-wrapper .count");
  const chatWrapperCountStr = (_a = chatWrapper[0].textContent) == null ? void 0 : _a.trim();
  console.log("chatWrapperCountStr", chatWrapperCountStr);
  if (chatWrapperCountStr) {
    let chatWrapperCount = parseInt(chatWrapperCountStr);
    if (XiaoHongShu_Setting$2.commentBlockingNum < chatWrapperCount) {
      console.log("chatWrapperCount", chatWrapperCount);
      const parentComments = document.querySelectorAll(".parent-comment >div:nth-child(1)");
      for (let i = 0; i < 3; i++) {
        if (parentComments[0]) {
          const reply = parentComments[i].querySelector(".parent-comment >div:nth-child(1) .reply");
          if (reply) {
            ensureElementVisible2(reply);
            await click_button(reply);
            let content_str = await callbackFun();
            await xiaoHongshu_send_comments2(content_str);
          }
        }
      }
    }
  }
}
async function xiaoHongshu_send_comments2(content) {
  var _a;
  if (!content) {
    return;
  }
  if (store$5.isNotRunWork()) {
    return;
  }
  if (!(await checkDomPromise("#content-textarea"))) {
    console.error("没有找到", "#content-textarea");
    return;
  }
  const content_textarea = document.querySelector("#content-textarea");
  if (!content_textarea) {
    console.error("没有找到输入框");
    return;
  }
  console.log("增加评论后缀信息", XiaoHongShu_Setting$2 == null ? void 0 : XiaoHongShu_Setting$2.commentSuffix);
  if (XiaoHongShu_Setting$2 == null ? void 0 : XiaoHongShu_Setting$2.commentSuffix) {
    console.log("增加评论后缀信息", XiaoHongShu_Setting$2 == null ? void 0 : XiaoHongShu_Setting$2.commentSuffix);
    content += "\r\n" + (XiaoHongShu_Setting$2 == null ? void 0 : XiaoHongShu_Setting$2.commentSuffix);
  }
  await simulateInput(content, content_textarea);
  await delay(getRandomNumberInRange(1e3, 5e3));
  if (store$5.isNotRunWork()) {
    return;
  }
  for (let j = 0; j < 60; j++) {
    const submitGrayButton = document.querySelector(".btn.submit.gray");
    if (submitGrayButton) {
      await delay(1e3);
    } else {
      break;
    }
  }
  const submit = document.querySelector(".btn.submit");
  if (!submit) {
    console.error("点击发表评论失败");
    return;
  }
  await click_button(submit);
  if (!(await checkDomPromise(".reds-toast-container .reds-toast.center", null, 60, 500))) {
    console.error("没有找到", ".reds-toast-container .reds-toast.center");
    return;
  }
  const response_text_el = document.querySelector(".reds-toast-container .reds-toast.center");
  if (!response_text_el) {
    console.error("点击发表评论失败2");
    return;
  }
  let response_text = ((_a = response_text_el.textContent) == null ? void 0 : _a.trim()) || "";
  if (!response_text) {
    console.error("点击发表评论失败 文本为空");
    return;
  }
  switch (response_text) {
    case "作者只允许好友评论":
      console.error("作者只允许好友评论");
      break;
    case "评论成功":
      store$5.increment_xhs_CommentCount();
      console.log("评论成功");
      break;
    default:
      console.error("response_text");
  }
  await delay(getRandomNumberInRange(1e3, 5e3));
}
async function xiaoHongshu_send_comments(content, saveInputs) {
  var _a;
  if (!(await checkDomPromise(".content-edit div div span"))) {
    console.error("没有找到", ".content-edit div div span");
    return;
  }
  if (store$5.isNotRunWork()) {
    return;
  }
  const content_edit = document.querySelector(".content-edit div div span");
  if (!content_edit) {
    console.error("没有找到输入评论的输入框");
    return;
  }
  await click_button(content_edit);
  await delay(getRandomNumberInRange(1e3, 5e3));
  if (store$5.isNotRunWork()) {
    return;
  }
  if (!(await checkDomPromise("#content-textarea"))) {
    console.error("没有找到", "#content-textarea");
    return;
  }
  const content_textarea = document.querySelector("#content-textarea");
  if (!content_textarea) {
    console.error("没有找到输入框");
    return;
  }
  console.log("增加评论后缀信息", XiaoHongShu_Setting$2 == null ? void 0 : XiaoHongShu_Setting$2.commentSuffix);
  if (XiaoHongShu_Setting$2 == null ? void 0 : XiaoHongShu_Setting$2.commentSuffix) {
    console.log("增加评论后缀信息", XiaoHongShu_Setting$2 == null ? void 0 : XiaoHongShu_Setting$2.commentSuffix);
    content += "\r\n" + (XiaoHongShu_Setting$2 == null ? void 0 : XiaoHongShu_Setting$2.commentSuffix);
  }
  await simulateInput(content, content_textarea);
  await delay(getRandomNumberInRange(1e3, 5e3));
  if (store$5.isNotRunWork()) {
    return;
  }
  for (let j = 0; j < 60; j++) {
    const submitGrayButton = document.querySelector(".btn.submit.gray");
    if (submitGrayButton) {
      await delay(1e3);
    } else {
      break;
    }
  }
  const submit = document.querySelector(".btn.submit");
  if (!submit) {
    console.error("点击发表评论失败");
    return;
  }
  await click_button(submit);
  if (!(await checkDomPromise(".reds-toast-container .reds-toast.center", null, 60, 500))) {
    console.error("没有找到", ".reds-toast-container .reds-toast.center");
    return;
  }
  const response_text_el = document.querySelector(".reds-toast-container .reds-toast.center");
  if (!response_text_el) {
    console.error("点击发表评论失败2");
    return;
  }
  let response_text = ((_a = response_text_el.textContent) == null ? void 0 : _a.trim()) || "";
  if (!response_text) {
    console.error("点击发表评论失败 文本为空");
    return;
  }
  switch (response_text) {
    case "作者只允许好友评论":
      console.error("作者只允许好友评论");
      break;
    case "评论成功":
      store$5.increment_xhs_CommentCount();
      console.log("评论成功");
      await saveComment$1(saveInputs);
      break;
    default:
      console.error("response_text");
  }
  await delay(getRandomNumberInRange(1e3, 5e3));
}
async function xiaoHongShu_clickCommentLike() {
  if (store$5.isNotRunWork()) {
    return;
  }
  if (!(XiaoHongShu_Setting$2 == null ? void 0 : XiaoHongShu_Setting$2.like)) {
    console.log("不需要点赞");
    return;
  }
  if (!(await checkDomPromise("#noteContainer .interactions.engage-bar .like-wrapper.like-active"))) {
    console.error("没有找到", "#noteContainer .interactions.engage-bar .like-wrapper.like-active");
    return;
  }
  if (store$5.isNotRunWork()) {
    return;
  }
  const like_span = document.querySelector("#noteContainer .interactions.engage-bar .like-wrapper.like-active");
  if (!like_span) {
    console.error("没有找到点赞的标签");
    return;
  }
  const like_span_use = like_span.querySelector("#noteContainer .interactions.engage-bar .like-wrapper.like-active use");
  if (!like_span_use) {
    console.error("没有找到点赞的标签 的图标");
    return;
  }
  const xlinkHref = like_span_use.getAttribute("xlink:href");
  console.log(`The use tag  ${xlinkHref}`);
  if (xlinkHref === "#liked") {
    console.log("已经点赞过了");
    return;
  } else if (xlinkHref === "#like") ;else {
    console.error("找到的图标有错误");
    return;
  }
  await click_button(like_span);
  store$5.increment_xhs_likeCount();
  await delay(getRandomNumberInRange(1e3, 5e3));
}
async function xiaoHongShu_follow_click() {
  if (store$5.isNotRunWork()) {
    return;
  }
  if (!(XiaoHongShu_Setting$2 == null ? void 0 : XiaoHongShu_Setting$2.follow)) {
    console.log("不需要关注");
    return;
  }
  if (!(await checkDomPromise("#noteContainer .interaction-container .follow-button"))) {
    console.error("没有找到", "#noteContainer .interaction-container .follow-button");
    return;
  }
  if (store$5.isNotRunWork()) {
    return;
  }
  const follow_div = document.querySelector("#noteContainer .interaction-container .follow-button");
  if (!follow_div) {
    console.error("没有找到 关注的按钮");
    return;
  }
  const follow_div_outlined = document.querySelector("#noteContainer .interaction-container .follow-button.outlined");
  if (follow_div_outlined) {
    console.error("已关注了，不需要重复关注");
    return;
  }
  await click_button(follow_div);
  store$5.increment_xhs_followCount();
  await delay(getRandomNumberInRange(1e3, 5e3));
}
async function xiaoHongShu_collect_click() {
  if (store$5.isNotRunWork()) {
    return;
  }
  if (!(XiaoHongShu_Setting$2 == null ? void 0 : XiaoHongShu_Setting$2.collect)) {
    console.log("不需要收藏");
    return;
  }
  if (!(await checkDomPromise("#noteContainer .interactions.engage-bar .collect-wrapper"))) {
    console.error("没有找到", "#noteContainer .interactions.engage-bar .collect-wrapper");
    return;
  }
  if (store$5.isNotRunWork()) {
    return;
  }
  const collect_span = document.querySelector("#noteContainer .interactions.engage-bar .collect-wrapper");
  if (!collect_span) {
    console.error("没有找到点赞的标签");
    return;
  }
  const collect_span_use = collect_span.querySelector("#noteContainer .interactions.engage-bar .collect-wrapper use");
  if (!collect_span_use) {
    console.error("没有找到点赞的标签 的图标");
    return;
  }
  const xlinkHref = collect_span_use.getAttribute("xlink:href");
  console.log(`The use tag  ${xlinkHref}`);
  if (xlinkHref === "#collected") {
    console.log("已经收藏过了");
    return;
  } else if (xlinkHref === "#collect") ;else {
    console.error("找到的图标有错误");
    return;
  }
  await click_button(collect_span);
  store$5.increment_xhs_collectCount();
  await delay(getRandomNumberInRange(1e3, 5e3));
}
async function send_fei_shu_warn_message(title, content) {
  const url = "https://open.feishu.cn/open-apis/bot/v2/hook/5e07b46e-c605-43a1-9bb4-ccdcefd4f596";
  const headers = {
    "Content-Type": "application/json"
  };
  try {
    const postData = {
      "msg_type": "text",
      "content": {
        "title": title,
        "text": `${content}
触发时间: ${formatNowDateTimeSss()}`
      }
    };
    const response = await fetch(url, {
      method: "POST",
      headers,
      body: JSON.stringify(postData)
    });
    if (!response.ok) {
      sendLog("url:" + url + "，header:" + JSON.stringify(headers) + ", response status:" + response.status);
      console.error(`HTTP error! status: ${response.status}`);
      if (response.status == 404) {
        return void 0;
      }
      return void 0;
    }
    const result = await response.json();
    sendLog("url:" + url + "，header:" + JSON.stringify(headers) + " response status:" + response.status + ", response data:" + JSON.stringify(result));
    console.log("result", result);
    return result;
  } catch (error) {
    sendLog("url:" + url + "，header:" + JSON.stringify(headers) + ", error" + error);
    console.error("Error:", error);
  }
  return void 0;
}
const VITE_LOGIN_API = "https://global-auth.petron.ai";
const store$4 = UseCounterStore.getInstance();
async function queryTenantsCorpus(tenant_id) {
  console.log("tenantsMine");
  const url = VITE_LOGIN_API + `/api/v1/tenants/${tenant_id}/corpus`;
  const headers = {
    "Content-Type": "application/json",
    "Authorization": "Bearer " + store$4.accessToken
  };
  try {
    const response = await fetch(url, {
      method: "GET",
      headers
    });
    if (!response.ok) {
      sendLog("url:" + url + "，header:" + JSON.stringify(headers) + ", response status:" + response.status);
      console.error(`HTTP error! status: ${response.status}`);
      if (response.status === 401) {
        console.log("登录失效");
        store$4.setAccessToken("");
        store$4.set_updateVipDateTime("");
        store$4.setUserInfoEndDate("");
        await logout(store$4.accessToken);
      }
      if (response.status == 404) {
        return void 0;
      }
      return void 0;
    }
    const result = await response.json();
    sendLog("url:" + url + "，header:" + JSON.stringify(headers) + ", response status:" + response.status + ", response data:" + JSON.stringify(result));
    console.log("result", result);
    return result;
  } catch (error) {
    sendLog("url:" + url + "，header:" + JSON.stringify(headers) + ", error" + error);
    console.error("Error:", error);
  }
  return void 0;
}
const VITE_CHAT_API = "https://wecom-c-release-lbecklkhaa.cn-huhehaote.fcapp.run";
const store$3 = UseCounterStore.getInstance();
const getReplyContent = async postData => {
  const url = VITE_CHAT_API + "/call";
  const headers = {
    "Content-Type": "application/json",
    "Authorization": "Bearer " + store$3.accessToken
  };
  try {
    const response = await fetch(url, {
      method: "POST",
      headers,
      body: JSON.stringify(postData)
    });
    if (!response.ok) {
      sendLog("addObjects url:" + url + "，header:" + JSON.stringify(headers) + ", response status:" + response.status);
      console.error(`HTTP error! status: ${response.status}`);
      return void 0;
    }
    const result = await response.json();
    sendLog("addObjects url:" + url + "，header:" + JSON.stringify(headers) + ",postData：" + JSON.stringify(postData) + " response status:" + response.status + ", response data:" + JSON.stringify(result));
    console.log("result", result);
    return result;
  } catch (error) {
    sendLog("addObjects url:" + url + "，header:" + JSON.stringify(headers) + ", error" + error);
    console.error("Error:", error);
  }
  return void 0;
};
async function saveChat(postData) {
  console.log("tenantsMine");
  const url = VITE_CHAT_API + `/api/v1/chat/save_chat`;
  const headers = {
    "Content-Type": "application/json",
    "Authorization": "Bearer " + store$3.accessToken
  };
  try {
    const response = await fetch(url, {
      method: "POST",
      headers,
      body: JSON.stringify(postData)
    });
    if (!response.ok) {
      sendLog("url:" + url + "，header:" + JSON.stringify(headers) + ", response status:" + response.status);
      console.error(`HTTP error! status: ${response.status}`);
      if (response.status === 401) {
        console.log("登录失效");
        store$3.setAccessToken("");
        store$3.set_updateVipDateTime("");
        store$3.setUserInfoEndDate("");
        await logout(store$3.accessToken);
      }
      if (response.status == 404) {
        return void 0;
      }
      return void 0;
    }
    const result = await response.json();
    sendLog("url:" + url + "，header:" + JSON.stringify(headers) + ", response status:" + response.status + ", response data:" + JSON.stringify(result));
    console.log("result", result);
    return result;
  } catch (error) {
    sendLog("url:" + url + "，header:" + JSON.stringify(headers) + ", error" + error);
    console.error("Error:", error);
  }
  return void 0;
}
const changeAccount = async postData => {
  const url = VITE_CHAT_API + "/api/v1/chat/change_account";
  const headers = {
    "Content-Type": "application/json",
    "Authorization": "Bearer " + store$3.accessToken
  };
  try {
    const response = await fetch(url, {
      method: "POST",
      headers,
      body: JSON.stringify(postData)
    });
    if (!response.ok) {
      sendLog("addObjects url:" + url + "，header:" + JSON.stringify(headers) + ", response status:" + response.status);
      console.error(`HTTP error! status: ${response.status}`);
      return void 0;
    }
    const result = await response.json();
    sendLog("addObjects url:" + url + "，header:" + JSON.stringify(headers) + ",postData：" + JSON.stringify(postData) + " response status:" + response.status + ", response data:" + JSON.stringify(result));
    console.log("result", result);
    return result;
  } catch (error) {
    sendLog("addObjects url:" + url + "，header:" + JSON.stringify(headers) + ", error" + error);
    console.error("Error:", error);
  }
  return void 0;
};
const store$2 = UseCounterStore.getInstance();
const VITE_AGENT_BUSINESS_API = "https://prod-agbusiness-zyqflxidth.cn-huhehaote.fcapp.run";
async function saveTerminalBind(terminalId, postData) {
  console.log("terminal", postData);
  const url = VITE_AGENT_BUSINESS_API + "/api/terminal/" + terminalId + "/bind";
  const headers = {
    "Content-Type": "application/json",
    "Authorization": "Bearer " + store$2.accessToken
  };
  try {
    const response = await fetch(url, {
      method: "POST",
      headers,
      body: JSON.stringify(postData)
    });
    if (!response.ok) {
      sendLog("url:" + url + "，header:" + JSON.stringify(headers) + ", response status:" + response.status);
      console.error(`HTTP error! status: ${response.status}`);
      if (response.status === 401) {
        console.log("登录失效");
        store$2.setAccessToken("");
        store$2.set_updateVipDateTime("");
        store$2.setUserInfoEndDate("");
        await logout(store$2.accessToken);
      }
      if (response.status == 404) {
        return void 0;
      }
      return void 0;
    }
    const result = await response.json();
    sendLog("url:" + url + "，header:" + JSON.stringify(headers) + ",postData：" + JSON.stringify(postData) + " response status:" + response.status + ", response data:" + JSON.stringify(result));
    console.log("result", result);
    return result;
  } catch (error) {
    sendLog("url:" + url + "，header:" + JSON.stringify(headers) + ", error" + error);
    console.error("Error:", error);
  }
  return void 0;
}
var define_process_env_default = {};
const ACCOUNT_DATA_BASE_URL = define_process_env_default.ACCOUNT_DATA_BASE_URL || "https://tubescanner-bkbjrmieve.cn-hangzhou.fcapp.run";
const ACCOUNT_DATA_API_AUTH_TOKEN = define_process_env_default.ACCOUNT_DATA_API_AUTH_TOKEN || "wZERFjpNgEEatp";
const store$1 = UseCounterStore.getInstance();
let XiaoHongShu_Setting$1 = JSON.parse(store$1.XiaoHongShu_Setting);
const VITE_AGENT_ID = "dou-yin-chrome-extension";
const isWithinProbabilityOpen = 80;
const isWithinProbabilitysend_comments = 20;
const isWithinProbabilityclickCommentLike = 50;
const isWithinProbabilityfollow_click = 5;
const isWithinProbabilitycollect_click = 5;
let checkInterval$1 = null;
const processedNoteIds = /* @__PURE__ */new Set();
const isNoteProcessed = noteId => {
  return processedNoteIds.has(noteId);
};
const markNoteAsProcessed = noteId => {
  processedNoteIds.add(noteId);
};
function convertTimeToSeconds(timeStr) {
  const [minutes, seconds] = timeStr.split(":").map(num => parseInt(num, 10));
  return minutes * 60 + seconds;
}
function douYin_RunYourCode() {
  if (checkInterval$1) {
    clearInterval(checkInterval$1);
    checkInterval$1 = null;
  }
  sendLog("开始任务douYin_RunYourCode start");
  let run_status = false;
  checkInterval$1 = setInterval(async () => {
    var _a;
    if (run_status) {
      return;
    }
    run_status = true;
    try {
      const loginContainer = document.querySelector("#douyin-header .semi-button");
      if (loginContainer) {
        sendLog("User is not logged in");
      } else {
        const userInfo = await getWebUserIdAndUserName();
        if (userInfo) {
          clearInterval(checkInterval$1);
          checkInterval$1 = null;
          sendLog("开始任务douYin_RunYourCode");
          const accountRunNum = await checkXiaoHongShuAccountRunNum("douYin", store$1.webUserId);
          if (!accountRunNum) {
            vipCloseEndFun("accountRunNum").then();
            return;
          }
          await store$1.checkLoadend();
          if (!XiaoHongShu_Setting$1 || Object.keys(XiaoHongShu_Setting$1).length == 0) {
            XiaoHongShu_Setting$1 = JSON.parse(store$1.XiaoHongShu_Setting);
          }
          if (store$1.isNotRunWork()) {
            vipCloseEndFun("douYin_RunYourCode").then();
            return;
          }
          const taskData = await getTabTaskData();
          store$1.setChromeTabId(taskData == null ? void 0 : taskData.tabId);
          const taskName = (_a = taskData == null ? void 0 : taskData.tabData) == null ? void 0 : _a.taskName;
          sendLog("chromeTabId :" + (taskData == null ? void 0 : taskData.tabId));
          if (taskName == "关键词") {
            await delay(getRandomNumberInRange(1e3, 5e3));
            douYinSearch(taskData).then(() => {}).catch(err => {
              console.error("douYinSearch", err);
            });
          } else if (taskName == "信息流") {
            await delay(getRandomNumberInRange(1e3, 5e3));
            douYinTuiJian().then(() => {}).catch(err => {
              console.error("douYinTuiJian", err);
            });
          } else if (taskName == "搜索关键词关注用户") {
            douYin_follow_click().then(res => {
              sendLog("douYin_follow_click res" + res);
            }).catch(err => {
              sendLog("douYin_follow_click err" + err);
            }).finally(() => {
              sendLog("douYin_follow_click finally");
              chrome.runtime.sendMessage({
                action: "noCloseRun"
              }, {
                includeTlsChannelId: false
              }, () => {
                console.log("noCloseRun hello world");
                closeEndFun("douYin_RunYourCode 搜索关键词关注用户").then();
              });
            });
          } else if (taskName == "获取抖音通知") {
            store$1.setRunLogs("开始获取抖音通知任务");
            douYin_Notifications().then(res => {
              sendLog("douYin_Notifications res" + res);
            }).catch(err => {
              console.log("err", err);
              sendLog("douYin_Notifications err" + err);
            }).finally(() => {
              sendLog("douYin_Notifications finally");
            });
          } else if (taskName == "获取网站登录账号的名称") {
            saveTerminalWebUserName().then(res => {
              sendLog("getWebUserName res" + res);
            }).finally(() => {
              closeEndFun("douYin_RunYourCode 获取网站登录账号的名称").then();
            });
          }
        } else {
          console.log("没有找到用户登录信息id");
        }
      }
    } catch (e) {
      sendLog("douYin_RunYourCode error:" + JSON.stringify(e));
    } finally {
      run_status = false;
    }
  }, 1e3);
  setTimeout(() => {
    clearInterval(checkInterval$1);
    checkInterval$1 = null;
    console.log("Finished checking login status.");
  }, 10 * 60 * getRandomNumberInRange(1e3, 5e3));
}
const getWebUserIdAndUserName = async () => {
  var _a, _b;
  const userInfo = {};
  if (!store$1.webUserId) {
    let webUserId = getWebUserIdData();
    if (webUserId) {
      userInfo["webUserId"] = webUserId;
    }
    let webUserAvatarUrl = "";
    const userAvatarEl = document.querySelector("#douyin-header .semi-avatar img");
    if (userAvatarEl) {
      let src = userAvatarEl.src;
      if (src.startsWith("//")) {
        src = "https:" + src;
      }
      webUserAvatarUrl = src;
      const href = new URL(src).pathname;
      if (href) {
        const segments = href.split("/");
        if (!webUserId) {
          webUserId = segments.pop() || "";
          webUserId = webUserId.replace(".", "");
          webUserId = webUserId.replace("-", "_");
        }
      }
    } else {
      console.log("没有找到用户登录信息");
    }
    if (!webUserId) {
      let userEl = document.querySelector("#douyin-header .semi-avatar img");
      let href = null;
      if (userEl == null) {
        userEl = document.querySelector("#header-avatar > div");
        if (userEl instanceof HTMLElement) {
          const backgroundImage = userEl.style.backgroundImage;
          console.log("backgroundImage", backgroundImage);
          const pattern = /url\("([^"]+)"\)/g;
          const result = [];
          let match;
          while ((match = pattern.exec(backgroundImage)) !== null) {
            result.push(match[1]);
          }
          href = result && result.length > 0 ? result[0] : "";
          if (href && href.startsWith("//")) {
            href = "https:" + href;
          }
          webUserAvatarUrl = href;
          console.log("backgroundImage href", href);
        }
      } else {
        href = userEl.src;
        if (href && href.startsWith("//")) {
          href = "https:" + href;
        }
        webUserAvatarUrl = href;
        console.log("backgroundImage href", href);
      }
      if (userEl) {
        if (href) {
          console.log("href", href);
          if (href && href.startsWith("//")) {
            href = "https:" + href;
          }
          href = new URL(href).pathname;
          const segments = href.split("/");
          webUserId = segments.pop() || "";
          console.log("webUserId", webUserId);
        }
      }
    }
    if (webUserId) {
      console.log("找到飞书用户Id", webUserId);
      sendLog("找到飞书用户Id" + webUserId);
      if (!store$1.webUserId) {
        userInfo["webUserId"] = webUserId;
      }
      if (!store$1.webUserAvatarUrl) {
        userInfo["webUserAvatarUrl"] = webUserAvatarUrl;
      }
    }
  } else {
    sendLog("找到飞书用户Id" + store$1.webUserId);
  }
  if (!store$1.webUserName) {
    if (!(await checkDomPromises([".userMenuPanelShadowAnimation >div:nth-child(1) >div:nth-child(1) >div >a", 'div[class*="header-"] div[class*="name-"]'], null, 20))) {
      console.log("没有找到", ".userMenuPanelShadowAnimation >div:nth-child(1) >div:nth-child(1) >div >a");
    }
    let webUserNameEl = document.querySelector(".userMenuPanelShadowAnimation >div:nth-child(1) >div:nth-child(1) >div >a");
    if (webUserNameEl) {
      const webUserNameText = (_a = webUserNameEl.textContent) == null ? void 0 : _a.trim();
      if (webUserNameText) {
        console.log("网站登录账号的名称：" + webUserNameText);
        sendLog("网站登录账号的名称：" + webUserNameText);
        if (!store$1.webUserName) {
          userInfo["webUserName"] = webUserNameText;
        }
      } else {
        sendLog("获取webUserNameText 为空");
      }
    } else {
      webUserNameEl = document.querySelector('div[class*="header-"] div[class*="name-"]');
      if (webUserNameEl) {
        const webUserNameText = (_b = webUserNameEl.textContent) == null ? void 0 : _b.trim();
        if (webUserNameText) {
          console.log("网站登录账号的名称：" + webUserNameText);
          sendLog("网站登录账号的名称：" + webUserNameText);
          if (!store$1.webUserName) {
            userInfo["webUserName"] = webUserNameText;
          }
        } else {
          sendLog("获取webUserNameText 为空");
        }
      } else {
        sendLog("没有找到 webUserNameEl");
      }
      sendLog("没有找到 webUserNameEl");
    }
  } else {
    sendLog("网站登录账号的名称：" + store$1.webUserName);
  }
  if (!store$1.webUserId && userInfo["webUserId"]) {
    store$1.setWebUserId(userInfo["webUserId"]);
  }
  if (!store$1.webUserName && userInfo["webUserName"]) {
    store$1.setWebUserName(userInfo["webUserName"]);
  }
  if (!store$1.webUserAvatarUrl && userInfo["webUserAvatarUrl"]) {
    store$1.setWebUserAvatarUrl(userInfo["webUserAvatarUrl"]);
  }
  if (!userInfo["webUserId"] && store$1.webUserId) {
    userInfo["webUserId"] = store$1.webUserId;
  }
  if (!userInfo["webUserName"] && store$1.webUserName) {
    userInfo["webUserName"] = store$1.webUserName;
  }
  if (!userInfo["webUserAvatarUrl"] && store$1.webUserAvatarUrl) {
    userInfo["webUserAvatarUrl"] = store$1.webUserAvatarUrl;
  }
  return userInfo;
};
const getWebUserIdData = () => {
  var _a;
  const render_dataEl = document.querySelector("#RENDER_DATA");
  if (render_dataEl) {
    const render_dataText = (_a = render_dataEl.textContent) == null ? void 0 : _a.trim();
    console.log("RENDER_DATA：" + render_dataText);
    if (render_dataText) {
      let render_dataJson = null;
      try {
        render_dataJson = JSON.parse(decodeURIComponent(render_dataText));
      } catch (e) {
        sendLog("JSON.parse(render_dataText) 错误" + e + ", render_dataText:" + render_dataText);
      }
      if (render_dataJson) {
        if (render_dataJson["app"]) {
          if (render_dataJson["app"]["user"]) {
            if (render_dataJson["app"]["user"]["info"]) {
              if (render_dataJson["app"]["user"]["info"]["secUid"]) {
                const secUid = render_dataJson["app"]["user"]["info"]["secUid"];
                sendLog("找到了secUid：" + secUid);
                return secUid;
              } else {
                sendLog("render_dataJson['app']['user']['info']['secUid']：为空，render_dataText：" + JSON.stringify(render_dataJson["app"]["user"]["info"]));
              }
            } else {
              sendLog("render_dataJson['app']['user']['info']：为空，render_dataText：" + JSON.stringify(render_dataJson["app"]["user"]));
            }
          } else {
            sendLog("render_dataJson['app']['user']：为空，render_dataText：" + JSON.stringify(render_dataJson["app"]));
          }
        } else {
          sendLog("render_dataJson['app']：为空，render_dataText：" + render_dataText);
        }
      } else {
        sendLog("render_dataText：为空");
      }
    } else {
      sendLog("render_dataText：为空");
    }
  } else {
    sendLog("render_dataEl：为空");
  }
  return "";
};
async function douYinSearch(taskData) {
  console.log("douYinSearch");
  while (true) {
    store$1.setRunLogs("开始关键词搜索");
    if (!(await checkDomPromise("#douyin-header input"))) {
      console.error("没有找到", "#douyin-header input");
      sendLog("没有找到 搜索框");
      store$1.setRunLogs("没有找到搜索框");
      return;
    }
    if (!(XiaoHongShu_Setting$1 == null ? void 0 : XiaoHongShu_Setting$1.searchWord)) {
      XiaoHongShu_Setting$1 = JSON.parse(store$1.XiaoHongShu_Setting);
    }
    if (!(XiaoHongShu_Setting$1 == null ? void 0 : XiaoHongShu_Setting$1.searchWord)) {
      console.error("配置没有生效", store$1.XiaoHongShu_Setting);
      sendLog("配置没有生效");
      store$1.setRunLogs("没有找到搜索关键词");
      return;
    }
    let keywords_list = [];
    keywords_list.push(XiaoHongShu_Setting$1 == null ? void 0 : XiaoHongShu_Setting$1.searchWord);
    let get_keyword_bool = true;
    let next_change_time = 0;
    store$1.setDouYinKeywords_list(keywords_list);
    store$1.setRunLogs("开始搜索");
    for (let i = 0; i < keywords_list.length; i++) {
      const searchWord = keywords_list[i];
      console.log("douYinSearch", searchWord);
      if (store$1.isNotRunWork()) {
        return;
      }
      const searchInput = document.querySelector("#douyin-header input");
      if (!searchInput) {
        sendLog("没有找到搜索框");
        console.error("没有找到搜索框，重新开始");
        return;
      }
      searchInput.value = searchWord;
      const inputEvent = new Event("input", {
        bubbles: true,
        cancelable: true
      });
      searchInput.dispatchEvent(inputEvent);
      const button_el = document.querySelector('button[data-e2e="searchbar-button"]');
      if (!button_el) {
        sendLog("没有找到搜索按钮");
        console.error("没有找到搜索按钮，重新开始");
        return;
      }
      await click_button(button_el);
      const keydownEvent = new KeyboardEvent("keydown", {
        bubbles: true,
        cancelable: true,
        key: "Enter",
        code: "Enter",
        keyCode: 13,
        // keyCode 是一些旧的代码可能需要的
        which: 13
      });
      searchInput.dispatchEvent(keydownEvent);
      const keyupEvent = new KeyboardEvent("keyup", {
        bubbles: true,
        cancelable: true,
        key: "Enter",
        code: "Enter",
        keyCode: 13,
        which: 13
      });
      searchInput.dispatchEvent(keyupEvent);
      const keypressEvent = new KeyboardEvent("keypress", {
        bubbles: true,
        cancelable: true,
        key: "Enter",
        code: "Enter",
        keyCode: 13,
        which: 13
      });
      searchInput.dispatchEvent(keypressEvent);
      if (store$1.isNotRunWork()) {
        sendLog("停止了1");
        return;
      }
      store$1.setRunLogs("搜索完成，开始功能");
      const keywords_list_res = await douYinClick_short_note(searchWord, get_keyword_bool, next_change_time);
      if (keywords_list_res && keywords_list_res.length == 2) {
        const keywords_list_data = keywords_list_res[0];
        next_change_time = keywords_list_res[1];
        get_keyword_bool = false;
        if (keywords_list_data && keywords_list_data.length > 0) {
          for (let j = 0; j < keywords_list_data.length; j++) {
            keywords_list.push(keywords_list_data[j]);
          }
          sendLog("keywords_list" + JSON.stringify(keywords_list));
          store$1.setDouYinKeywords_list(keywords_list);
        }
      }
    }
    store$1.increment_DouYin_search_runNumber();
    sendLog("DouYin_search_runNumber：" + store$1.DouYin_search_runNumber);
    if (store$1.DouYin_search_runNumber > 3) {
      sendLog("content activatePage DouYin_search_runNumber：", store$1.DouYin_search_runNumber);
      chrome.storage.local.set({
        "activatePage": indexPage
      });
      return;
    }
    if (store$1.isNotRunWork()) {
      return;
    }
    sendLog("下一次开始");
  }
}
async function douYinClick_short_note(searchWord, get_keyword_bool, next_change_time) {
  let keywords_list = [];
  try {
    if (!(await checkDomPromise("#search-content-area .ml-2"))) {
      sendLog("没有找到搜索结果");
    }
    if (store$1.isNotRunWork()) {
      sendLog("停止了2");
      return keywords_list;
    }
    await delay(getRandomNumberInRange(1e3, 5e3));
    sendLog("点击单列");
    if (!(await checkDomPromise("#search-content-area .ml-2"))) {
      console.error("没有找到", "#search-content-area .ml-2");
      sendLog("没有找到 单列按钮");
      return keywords_list;
    }
    if (store$1.isNotRunWork()) {
      sendLog("停止了3");
      return keywords_list;
    }
    let short_notes = document.querySelectorAll("#search-content-area .ml-2");
    let short_note = void 0;
    short_notes.forEach(item => {
      var _a;
      if (((_a = item.textContent) == null ? void 0 : _a.trim()) == "单列") {
        short_note = item;
      }
    });
    if (short_note == void 0) {
      sendLog("没有找到 单列按钮");
      console.error("错误，重新开始");
      return keywords_list;
    }
    await click_button(short_note);
    const parent = short_note.parentElement;
    let suaxuan_el = null;
    if (parent) {
      const sibling = parent.nextElementSibling;
      console.log("sibling", sibling);
      if (sibling) {
        suaxuan_el = sibling.querySelector("span:nth-child(1)");
        console.log("suaxuan_el", suaxuan_el);
      }
    }
    keywords_list = await douYinClick_dropdown_container(suaxuan_el, searchWord, get_keyword_bool, next_change_time);
  } catch (e) {
    console.error("ee", e);
    sendLog("xiaoHongshuClick_short_note" + e);
  }
  return keywords_list;
}
async function douYinClick_dropdown_container(filter_box, searchWord, get_keyword_bool, next_change_time) {
  var _a, _b, _c;
  console.log("选择最新");
  if (store$1.isNotRunWork()) {
    sendLog("停止了4");
    return [];
  }
  if (!(XiaoHongShu_Setting$1 == null ? void 0 : XiaoHongShu_Setting$1.category)) {
    console.error("没有配置 category", XiaoHongShu_Setting$1 == null ? void 0 : XiaoHongShu_Setting$1.category);
    sendLog("没有配置 category");
    return [];
  }
  if ((XiaoHongShu_Setting$1 == null ? void 0 : XiaoHongShu_Setting$1.category.indexOf("综合")) > -1) ;else {
    console.log("选择过滤");
    if (store$1.isNotRunWork()) {
      sendLog("停止了5");
      return [];
    }
    if (!filter_box) {
      console.error("错误，重新开始");
      sendLog("没有找到 选择过滤");
      return [];
    }
    const rect = filter_box.getBoundingClientRect();
    const x = rect.left + rect.width / 2;
    const y = rect.top + rect.height / 2;
    console.log("x,y", rect, x, y);
    const mouseOverEvent = new MouseEvent("mouseover", {
      view: window,
      bubbles: true,
      cancelable: true,
      clientX: x,
      clientY: y
    });
    filter_box.dispatchEvent(mouseOverEvent);
    const mouseMoveEvent = new MouseEvent("mousemove", {
      view: window,
      bubbles: true,
      cancelable: true,
      clientX: x,
      clientY: y
    });
    filter_box.dispatchEvent(mouseMoveEvent);
    const mouseEnterEvent = new MouseEvent("mouseenter", {
      view: window,
      bubbles: true,
      cancelable: true,
      clientX: x,
      clientY: y
    });
    filter_box.dispatchEvent(mouseEnterEvent);
    await delay(getRandomNumberInRange(1e3, 5e3));
    let elements = Array.from(document.querySelectorAll('#search-content-area span[data-index1="0"]'));
    let targetElement = null;
    let zonghe_el = null;
    for (let i = 0; i < elements.length; i++) {
      const element = elements[i];
      if (!element) {
        continue;
      }
      console.log(element);
      console.log(element.childElementCount, XiaoHongShu_Setting$1 == null ? void 0 : XiaoHongShu_Setting$1.category);
      if ((element == null ? void 0 : element.textContent) && ((_a = element == null ? void 0 : element.textContent) == null ? void 0 : _a.trim()) && ((_c = (_b = element == null ? void 0 : element.textContent) == null ? void 0 : _b.trim()) == null ? void 0 : _c.indexOf("综合")) > -1) {
        zonghe_el = element;
      }
      if (element && element.childElementCount === 0 && element.textContent && (element.textContent.trim() === (XiaoHongShu_Setting$1 == null ? void 0 : XiaoHongShu_Setting$1.category) || element.textContent.trim().indexOf(XiaoHongShu_Setting$1 == null ? void 0 : XiaoHongShu_Setting$1.category) > -1)) {
        targetElement = element;
        break;
      }
    }
    if (targetElement) {
      console.log("Element not found", XiaoHongShu_Setting$1 == null ? void 0 : XiaoHongShu_Setting$1.category);
      sendLog("没有配置 category");
      console.log("Element found:", targetElement);
      await click_button(targetElement);
    } else if (zonghe_el) {
      targetElement = zonghe_el;
      await click_button(targetElement);
    } else {
      console.log("zonghe_el 为 空");
    }
    await delay(getRandomNumberInRange(1e3, 5e3));
    await click_button(filter_box);
  }
  console.log("xiaoHongshuClick_cover_ld_mask");
  await delay(getRandomNumberInRange(1e3, 5e3));
  return await douYinClick_cover_ld_mask([], searchWord, get_keyword_bool, next_change_time);
}
async function douYinClick_cover_ld_mask(viewedPaths, searchWord, get_keyword_bool, next_change_time) {
  var _a;
  let keywords_list = [];
  if (!(await checkDomPromise('#search-content-area ul[data-e2e="scroll-list"]'))) {
    console.error("没有找到", '#search-content-area ul[data-e2e="scroll-list"]');
    sendLog("没有找到搜索结果");
    return keywords_list;
  }
  while (true) {
    try {
      sendLog("xiaoHongshuClick_cover_ld_mask");
      if (store$1.isNotRunWork()) {
        vipCloseEndFun("douYinClick_cover_ld_mask").then();
        return [];
      }
      let ul_list = document.querySelectorAll('#search-content-area ul[data-e2e="scroll-list"]');
      if (!ul_list || ul_list.length == 0) {
        sendLog("没有找到搜索列表");
        return [];
      }
      const ul_el = ul_list[0];
      let elements_list = ul_el.querySelectorAll(":scope > li");
      let elements = Array.from(elements_list);
      sendLog("elements:" + elements.length);
      savePlatformData(elements);
      const title_texts = [];
      if (XiaoHongShu_Setting$1.smartKeywords == "智能关键词") {
        if (get_keyword_bool) {
          for (let kk = 0; kk < elements.length; kk++) {
            const element = elements[kk];
            ensureElementVisible(element);
            let title_el = element.querySelector("div > div > div:nth-child(2)");
            if (!title_el) {
              let tryTimeBool = false;
              for (let i = 0; i < 3; i++) {
                await delay(getRandomNumberInRange(1e3, 3e3));
                title_el = element.querySelector("div > div > div:nth-child(2)");
                if (title_el) {
                  tryTimeBool = true;
                  break;
                }
              }
              if (!tryTimeBool) {
                continue;
              }
            }
            if (!title_el) {
              continue;
            }
            const title_text = (_a = title_el.textContent) == null ? void 0 : _a.trim();
            title_texts.push(title_text);
          }
          if (elements && elements.length > 0) {
            ensureElementVisible(elements[0]);
          }
          sendLog("title_texts：" + JSON.stringify(title_texts));
          keywords_list = await getKeywordsIntelligentAssociation(title_texts, searchWord);
          sendLog("keywords_list：" + JSON.stringify(keywords_list));
          get_keyword_bool = false;
          const lastTime2 = await queryLastTime();
          sendLog("XiaoHongShu_Setting.operationTime " + lastTime2 + " " + XiaoHongShu_Setting$1.operationTime);
          let keywords_len = keywords_list.length;
          sendLog("keywords_len：" + keywords_len);
          const operationTime2 = parseInt(XiaoHongShu_Setting$1.operationTime);
          const avgTime = Math.ceil(operationTime2 / keywords_len);
          sendLog("XiaoHongShu_avgTime：" + avgTime);
          store$1.setXiaoHongShu_avgTime(avgTime);
          next_change_time = lastTime2;
        }
      }
      if (XiaoHongShu_Setting$1.workType == "关键词" && XiaoHongShu_Setting$1.smartKeywords !== "智能关键词") {
        store$1.setXiaoHongShu_avgTime(0);
      }
      let view_bool = false;
      let element_a_els = [];
      Array.from(elements).filter(element => {
        const element_div_el = element.querySelector("#sliderVideo");
        if (!element_div_el) {
          return false;
        }
        const vid = element_div_el.getAttribute("data-e2e-vid");
        if (!viewedPaths.includes(vid)) {
          element_a_els.push(element);
        }
      });
      if (element_a_els.length == 0 && elements.length > 0) {
        ensureElementVisible(elements[elements.length - 1]);
      }
      elements = element_a_els;
      if (elements.length > 0) {
        const element = elements[0];
        await douYinList_processElements(element, view_bool);
        if (store$1.isNotRunWork()) {
          vipCloseEndFun("douYinClick_cover_ld_mask2").then();
          break;
        }
        const element_div_el = element.querySelector("#sliderVideo");
        if (!element_div_el) {
          sendLog("element_div_el #sliderVideo");
          continue;
        }
        const vid = element_div_el.getAttribute("data-e2e-vid");
        viewedPaths.push(vid);
        if (!(await checkDomPromise("#sliderVideo", elements[0]))) {
          sendLog("没有找到#sliderVideo");
          continue;
        }
      }
      if (elements.length == 0) {
        const end_container = document.querySelectorAll(".end-container");
        sendLog("end_container" + end_container);
        if (end_container && end_container.length > 0) {
          sendLog("end_container 处理完成");
          break;
        } else {
          sendLog("继续处理");
        }
        await delay(1e3);
      }
      const lastTime = await queryLastTime();
      sendLog("lastTime：" + lastTime + " " + store$1.XiaoHongShu_avgTime);
      const operationTime = parseInt(XiaoHongShu_Setting$1.operationTime);
      if (store$1.XiaoHongShu_avgTime && lastTime != next_change_time && lastTime != operationTime && lastTime % store$1.XiaoHongShu_avgTime == 0) {
        sendLog("开始搜索下一个关键词 " + lastTime + " " + store$1.XiaoHongShu_avgTime + " " + operationTime);
        next_change_time = lastTime;
        break;
      }
    } catch (e) {
      sendLog("xiaoHongshuClick_cover_ld_mask，结束" + e);
      console.error("xiaoHongshuClick_cover_ld_mask", e);
      await delay(1e3);
    }
  }
  return [keywords_list, next_change_time];
}
async function douYinList_processElements(element, view_bool = false) {
  try {
    sendLog("开始下一个笔记1");
    if (!(await checkDomByDom(element))) {
      return;
    }
    sendLog("开始下一个笔记2");
    if (store$1.isNotRunWork()) {
      return;
    }
    console.log("element", element);
    ensureElementVisible(element);
    if (store$1.isNotRunWork()) {
      return;
    }
    if (!view_bool) {
      if (isWithinProbability(isWithinProbabilityOpen)) {
        store$1.increment_dy_viewCount();
        await douYin_tuwen_start_exec(element);
        await delay(getRandomNumberInRange(3e3, 6e3));
      } else {
        console.log("跳过 不打开图文");
        await delay(getRandomNumberInRange(1e3, 5e3));
      }
    } else {
      console.log("只是为了滚动页面，不做任何的操作");
    }
  } catch (e) {
    sendLog("xiaoHongshu_list_processElements error" + e);
    console.error(e);
  } finally {
    console.log("All elements have been processed.");
  }
}
async function douYin_tuwen_start_exec(element) {
  if (!(await checkDomPromises([".search-result-card >div>div:nth-child(2) > div >span >span", ".search-result-card >div>div>div>p"], element))) {
    console.error("没有找到", ".search-result-card >div>div:nth-child(2) > div >span >span");
    return;
  }
  const zhiBo_el = element.querySelector(".semi-tag-content");
  if (zhiBo_el) {
    console.log("直播，跳过");
    return;
  }
  const guangGao_el = element.querySelector(".account svg");
  if (guangGao_el) {
    console.log("广告，跳过");
    return;
  }
  if (store$1.isNotRunWork()) {
    return;
  }
  const stringList = [];
  if (XiaoHongShu_Setting$1.reviewProbability == "默认AI控制") {
    if (isWithinProbability(isWithinProbabilitysend_comments)) {
      stringList.push("douYin_send_comments");
    } else {
      console.log("跳过 不评论");
    }
  } else if (XiaoHongShu_Setting$1.reviewProbability == "自定义概率" && XiaoHongShu_Setting$1.customProbabilitiesNum && isWithinProbability(XiaoHongShu_Setting$1.customProbabilitiesNum)) {
    stringList.push("douYin_send_comments");
  }
  if (XiaoHongShu_Setting$1 == null ? void 0 : XiaoHongShu_Setting$1.like) {
    if (isWithinProbability(isWithinProbabilityclickCommentLike)) {
      stringList.push("douYin_clickCommentLike");
    } else {
      console.log("跳过 不点赞");
    }
  }
  if (XiaoHongShu_Setting$1 == null ? void 0 : XiaoHongShu_Setting$1.follow) {
    if (isWithinProbability(isWithinProbabilityfollow_click)) {
      stringList.push("douYin_follow_click");
    } else {
      console.log("跳过 不关注");
    }
  }
  if (XiaoHongShu_Setting$1 == null ? void 0 : XiaoHongShu_Setting$1.collect) {
    if (isWithinProbability(isWithinProbabilitycollect_click)) {
      stringList.push("douYin_collect_click");
    } else {
      console.log("跳过 不收藏");
    }
  }
  await douYin_randomExecFunction(stringList, element, "搜索关键词");
}
async function douYin_randomExecFunction(strings, element, optionType) {
  let remainingStrings = [...strings];
  await delay(getRandomNumberInRange(1e3, 5e3));
  while (remainingStrings.length > 0) {
    if (store$1.isNotRunWork()) {
      return;
    }
    const randomIndex = Math.floor(Math.random() * remainingStrings.length);
    console.log(remainingStrings[randomIndex]);
    switch (remainingStrings[randomIndex]) {
      case "douYin_send_comments":
        if (optionType == "搜索关键词") {
          await douYin_tuwen_read_info(element);
        }
        if (optionType == "信息流") {
          await douYin_tuijian_comment(element);
        }
        break;
      case "douYin_clickCommentLike":
        await douYin_clickCommentLike(element);
        break;
      case "douYin_follow_click":
        if (optionType == "搜索关键词") {
          await get_follow_user_url(element);
        }
        if (optionType == "信息流") {
          await tuijian_flow(element);
        }
        break;
      case "douYin_collect_click":
        await douYin_collect_click(element);
        break;
      default:
        console.error("错误信息", remainingStrings[randomIndex]);
    }
    remainingStrings.splice(randomIndex, 1);
  }
}
async function douYin_tuwen_read_info(element) {
  var _a, _b;
  if (!(await checkDomPromises([".search-result-card >div>div:nth-child(2) > div >span >span", ".search-result-card >div>div>div>p"], element))) {
    console.error("没有找到", ".search-result-card >div>div:nth-child(2) > div >span >span");
    return;
  }
  if (store$1.isNotRunWork()) {
    return;
  }
  const img_container_el = element.querySelector(".imgBackground img");
  let img_container_url = "";
  if (img_container_el) {
    img_container_url = img_container_el.src;
  }
  console.log("img_container_el:", img_container_el);
  console.log("img_container_url:" + img_container_url);
  let detail_title_el = element.querySelector(".search-result-card >div>div:nth-child(2) > div >span >span");
  let detail_title = "";
  if (detail_title_el) {
    detail_title = ((_a = detail_title_el.textContent) == null ? void 0 : _a.trim()) || "";
  } else {
    detail_title_el = element.querySelector(".search-result-card >div>div>div>p");
  }
  if (detail_title_el) {
    detail_title = ((_b = detail_title_el.textContent) == null ? void 0 : _b.trim()) || "";
  }
  console.log("detail_title_el:", detail_title_el);
  console.log("detail_title:", detail_title);
  let detail_content = "";
  let detail_tag_str = "";
  console.log("detail_tag_str:", detail_tag_str);
  let note_id = "";
  const element_div_el = element.querySelector("#sliderVideo");
  if (!element_div_el) {
    console.log("detail_tag_str:", detail_tag_str);
    return;
  }
  if (element_div_el) {
    note_id = element_div_el.getAttribute("data-e2e-vid");
  }
  if (store$1.isNotRunWork()) {
    return;
  }
  await click_comment_button(element);
  const textContent_str = await get_douYin_send_child_comment();
  const user_infos = document.querySelectorAll(".search-result-card >div > div >div > a");
  let comment_user_url = "";
  let comment_user_id = "";
  if (user_infos && user_infos.length > 0) {
    const user_info = user_infos[0];
    comment_user_url = user_info.href;
    if (comment_user_url) {
      if (comment_user_url.startsWith("//")) {
        comment_user_url = "https:" + comment_user_url;
      }
      const pathname = new URL(comment_user_url).pathname;
      comment_user_id = getLastPathName$1(pathname);
    }
  }
  sendLog("Path: " + store$1.userId + "  " + note_id);
  const refer_id = "auto_comment_dou_yin_user_" + store$1.userId + "_path_" + note_id;
  if (await queryComment$1(refer_id)) {
    let result = null;
    sendLog("没有配置 style " + (XiaoHongShu_Setting$1 == null ? void 0 : XiaoHongShu_Setting$1.style) + " " + (XiaoHongShu_Setting$1 == null ? void 0 : XiaoHongShu_Setting$1.charLimit) + " " + (XiaoHongShu_Setting$1 == null ? void 0 : XiaoHongShu_Setting$1.keywordInfo));
    const inputs = {
      test: detail_title,
      commentaries: textContent_str,
      style: XiaoHongShu_Setting$1 == null ? void 0 : XiaoHongShu_Setting$1.style,
      word_limit: XiaoHongShu_Setting$1 == null ? void 0 : XiaoHongShu_Setting$1.charLimit,
      key_message: XiaoHongShu_Setting$1 == null ? void 0 : XiaoHongShu_Setting$1.keywordInfo
    };
    const files = [];
    if (img_container_url) {
      files.push({
        type: "image",
        transfer_method: "remote_url",
        url: img_container_url
      });
    }
    if (XiaoHongShu_Setting$1.commentBlocking == "评论截流" && XiaoHongShu_Setting$1.commentBlockingNum > 0) {
      const callbackFun = async () => {
        const apiKey2 = "app-Ii7VEbb1eRx84RhhtLLLRAD9";
        result = await runWorkflow$1(inputs, files, apiKey2);
        return result;
      };
      await douYin_send_child_comment(callbackFun, element, '.commentInput-right-ct path[fill="#FE2C55"]');
    }
    const apiKey = "app-Ii7VEbb1eRx84RhhtLLLRAD9";
    result = await runWorkflow$1(inputs, files, apiKey);
    sendLog("result: " + result);
    if (result) {
      const saveInputsData = {
        refer_id,
        // 数据唯一标识，格式为：auto_comment_dou_yin_user_{userId}_path_{note_id}
        title: detail_title,
        // 视频标题/描述文本
        text: detail_content,
        // 视频正文内容
        label: detail_tag_str,
        // 视频标签，包含话题标签
        style: XiaoHongShu_Setting$1 == null ? void 0 : XiaoHongShu_Setting$1.style,
        // 评论风格设置，如：幽默、正式等
        word_limit: XiaoHongShu_Setting$1 == null ? void 0 : XiaoHongShu_Setting$1.charLimit,
        // 评论字数限制
        key_message: XiaoHongShu_Setting$1 == null ? void 0 : XiaoHongShu_Setting$1.keywordInfo,
        // 评论关键信息/关键词设置
        note_url: `https://www.douyin.com/video/${note_id}`,
        // 视频链接地址，由视频ID拼接而成
        note_id,
        // 视频唯一ID，来自data-e2e-vid属性
        comment_user_url,
        // 视频作者主页链接
        comment_user_id,
        // 视频作者ID
        extra_image_id: "",
        // 额外图片ID（当前为空）
        extra_image_url: img_container_url,
        // 视频封面图片URL
        replyComment: result,
        // AI生成的评论内容
        userId: store$1.userId,
        // 当前操作用户的ID
        taskId: store$1.taskId,
        // 当前任务ID
        addTime: (/* @__PURE__ */new Date()).getTime()
        // 数据添加时间戳，13位毫秒级
      };
      const saveInputs = {
        "key": refer_id,
        "bucket": saveInputsData,
        "size": 0,
        "content_type": "string",
        "belong_to": store$1.userId + "_douYin_comment",
        "object_metadata": {}
      };
      await douYin_send_comments(result, saveInputs, element, '.commentInput-right-ct path[fill="#FE2C55"]');
    }
  } else {
    console.log("已评论过。跳过");
  }
}
async function click_comment_button(element) {
  if (!(await checkDomPromise('div[data-e2e="feed-comment-icon"]', element))) {
    console.error("没有找到", 'div[data-e2e="feed-comment-icon"]');
    return;
  }
  if (store$1.isNotRunWork()) {
    return;
  }
  const content_edit = element.querySelector('div[data-e2e="feed-comment-icon"]');
  if (!content_edit) {
    console.error("没有找到输入评论的输入框");
    return;
  }
  const input_el = document.querySelector("#merge-all-comment-container .comment-input-inner-container >div:nth-child(1)");
  if (input_el) {
    sendLog("输入框存在，评论已展开，不需要再点击评论按钮，展开评论");
    return;
  }
  await click_button(content_edit);
}
async function get_douYin_send_child_comment() {
  var _a, _b, _c;
  if (!(await checkDomPromise(".comment-mainContent"))) {
    console.error("没有找到", ".comment-mainContent");
    return;
  }
  const newList = [];
  const parentComments = document.querySelectorAll('.comment-mainContent div[data-e2e="comment-item"] >div:nth-child(2) >div');
  for (let i = 0; i < 10; i++) {
    if (parentComments[i]) {
      const selfEl = parentComments[i].querySelector(".semi-tag-content-center");
      if (selfEl) {
        const selfEl_text = (_a = selfEl.textContent) == null ? void 0 : _a.trim();
        if (selfEl_text == "作者") {
          continue;
        }
        continue;
      }
      const nextSibling_el = (_b = parentComments[i].querySelector(".comment-item-info-wrap")) == null ? void 0 : _b.nextElementSibling;
      if (nextSibling_el) {
        const textContent = (_c = nextSibling_el.textContent) == null ? void 0 : _c.trim();
        if (textContent) {
          newList.push(textContent);
          if (newList.length == 5) {
            break;
          }
        }
      }
    }
  }
  console.log("newList", newList);
  let textContent_str = "";
  for (let i = 0; i < newList.length; i++) {
    if (textContent_str) {
      textContent_str += "\n";
    }
    textContent_str += i + 1 + "、" + newList[i];
  }
  return textContent_str;
}
async function douYin_send_comments(content, saveInputs, element, sendButtonQuerySelector = '.commentInput-right-ct path[fill="#FE2C55"]') {
  var _a;
  console.log("douYin_send_comments");
  await delay(getRandomNumberInRange(1e3, 5e3));
  if (store$1.isNotRunWork()) {
    return;
  }
  if (!(await checkDomPromise("#merge-all-comment-container .comment-input-inner-container >div:nth-child(1)"))) {
    console.error("没有找到", "#content-textarea");
    return;
  }
  const comment_input_el = element.querySelector("#merge-all-comment-container .comment-input-inner-container >div:nth-child(1)");
  if (!comment_input_el) {
    console.error("没有找到输入评论的输入框");
    return;
  }
  await click_button(comment_input_el);
  if (!(await checkDomPromise(".notranslate.public-DraftEditor-content"))) {
    sendLog("没有找到 #content-textarea");
    return;
  }
  const targetElement = document.querySelector(".notranslate.public-DraftEditor-content");
  if (!targetElement) {
    console.error("没有找到输入框");
    return;
  }
  console.log("增加评论后缀信息", XiaoHongShu_Setting$1 == null ? void 0 : XiaoHongShu_Setting$1.commentSuffix);
  if (XiaoHongShu_Setting$1 == null ? void 0 : XiaoHongShu_Setting$1.commentSuffix) {
    console.log("增加评论后缀信息", XiaoHongShu_Setting$1 == null ? void 0 : XiaoHongShu_Setting$1.commentSuffix);
    content += "\r\n" + (XiaoHongShu_Setting$1 == null ? void 0 : XiaoHongShu_Setting$1.commentSuffix);
  }
  if (targetElement) {
    sendLog("执行 targetElement：" + store$1.chromeTabId);
    chrome.runtime.onMessage.addListener((request2, sender2, sendResponse2) => queryActiveElement(request2, sender2, sendResponse2, ".notranslate.public-DraftEditor-content"));
    await simulateInputSendMessage(content, 200, true);
    chrome.runtime.onMessage.removeListener((request2, sender2, sendResponse2) => queryActiveElement(request2, sender2, sendResponse2, ".notranslate.public-DraftEditor-content"));
  } else {
    sendLog("Target element not found.");
  }
  if (store$1.isNotRunWork()) {
    return;
  }
  if (!(await checkDomPromise(sendButtonQuerySelector))) {
    sendLog("没有找到 #content-textarea");
    return;
  }
  const submit = element.querySelector(sendButtonQuerySelector);
  if (!submit) {
    console.error("点击发表评论失败");
    return;
  }
  await click_button(submit);
  let indexNum = 0;
  while (true) {
    if (indexNum > 60) {
      break;
    }
    if (indexNum > 1) {
      console.log("indexNum", indexNum++);
      await delay(1e3);
    }
    indexNum++;
    const response_text_el = element.querySelector(".public-DraftEditor-content > div > div > div > span:nth-child(1)");
    if (!response_text_el) {
      console.log("没有找到输入框");
      continue;
    }
    let response_text = ((_a = response_text_el.textContent) == null ? void 0 : _a.trim()) || "";
    if (response_text) {
      console.log("输入框不为空");
      continue;
    }
    break;
  }
  store$1.increment_dy_CommentCount();
  console.log("评论成功");
  await saveComment$1(saveInputs);
  await delay(getRandomNumberInRange(1e3, 5e3));
}
async function douYin_clickCommentLike(element) {
  if (store$1.isNotRunWork()) {
    return;
  }
  if (!(XiaoHongShu_Setting$1 == null ? void 0 : XiaoHongShu_Setting$1.like)) {
    console.log("不需要点赞");
    return;
  }
  if (!(await checkDomPromise('div[data-e2e="video-player-digg"]', element))) {
    console.error("没有找到", 'div[data-e2e="video-player-digg"]');
    return;
  }
  if (store$1.isNotRunWork()) {
    return;
  }
  const like_el = element.querySelector('div[data-e2e="video-player-digg"]');
  if (!like_el) {
    console.log("没有点赞按钮");
    return;
  }
  const liked = like_el.getAttribute("data-e2e-state");
  if (!liked) {
    console.log("没有找到点赞情况");
    return;
  }
  console.log("liked ", liked);
  if (liked == "video-player-is-digged") {
    console.log("已点赞");
    return;
  }
  await click_button(like_el);
  store$1.increment_dy_likeCount();
  await delay(getRandomNumberInRange(1e3, 5e3));
}
async function get_follow_user_url(element) {
  if (store$1.isNotRunWork()) {
    return;
  }
  if (!(XiaoHongShu_Setting$1 == null ? void 0 : XiaoHongShu_Setting$1.follow)) {
    console.log("不需要关注");
    return;
  }
  if (!(await checkDomPromises([".search-result-card >div > div >div >div>div > a"], element))) {
    console.error("没有找到", ".search-result-card >div > div >div >div>div > a");
    return;
  }
  if (store$1.isNotRunWork()) {
    return;
  }
  let user_url_el = element.querySelector(".search-result-card >div > div >div >div>div > a");
  if (!user_url_el) {
    console.log("user_url", user_url_el);
    return;
  }
  const href_url = user_url_el.getAttribute("href");
  let protocol = "";
  try {
    let url = window.location.href;
    if (url.startsWith("//")) {
      url = "https:" + url;
    }
    const parsedUrl = new URL(url);
    protocol = parsedUrl.protocol;
  } catch (error) {
    console.error("Invalid URL:", error);
    return "Invalid URL";
  }
  const taskQueue = new AsyncTaskQueue(1);
  const message = {
    action: "executeTaskNoTask",
    url: protocol + href_url,
    taskName: "搜索关键词关注用户",
    taskPlatform: "抖音"
  };
  await taskQueue.enqueue(openNewWindowNote(message));
  await taskQueue.waitForAll();
}
async function douYin_follow_click() {
  var _a;
  if (store$1.isNotRunWork()) {
    return;
  }
  if (!(XiaoHongShu_Setting$1 == null ? void 0 : XiaoHongShu_Setting$1.follow)) {
    console.log("不需要关注");
    return;
  }
  if (!(await checkDomPromise('div[data-e2e="user-detail"] button[data-e2e="user-info-follow-btn"]'))) {
    console.error("没有找到", 'div[data-e2e="user-detail"] button[data-e2e="user-info-follow-btn"]');
    return;
  }
  if (store$1.isNotRunWork()) {
    return;
  }
  const follows_div = document.querySelectorAll('div[data-e2e="user-detail"] button[data-e2e="user-info-follow-btn"]');
  let follow_div = null;
  if (follows_div && follows_div.length > 0) {
    if (follows_div.length == 2) {
      follow_div = follows_div[1];
    } else {
      follow_div = follows_div[0];
    }
  }
  if (!follow_div) {
    console.error("没有找到 关注的按钮");
    return;
  }
  const follow_div_text = ((_a = follow_div.textContent) == null ? void 0 : _a.trim()) || "";
  if (!follow_div_text) {
    console.error("没有查到关注文本");
    return;
  }
  if (follow_div_text == "已关注") {
    console.error("已关注了，不需要重复关注");
    return;
  }
  await click_button(follow_div);
  store$1.increment_dy_followCount();
  await delay(getRandomNumberInRange(1e3, 5e3));
}
async function douYin_collect_click(element) {
  if (store$1.isNotRunWork()) {
    return;
  }
  if (!(XiaoHongShu_Setting$1 == null ? void 0 : XiaoHongShu_Setting$1.collect)) {
    console.log("不需要收藏");
    return;
  }
  if (!(await checkDomPromise('div[data-e2e="video-player-collect"]', element))) {
    console.error("没有找到", 'div[data-e2e="video-player-collect"]');
    return;
  }
  if (store$1.isNotRunWork()) {
    return;
  }
  const collect_el = element.querySelector('div[data-e2e="video-player-collect"]');
  if (!collect_el) {
    console.error("没有找到点赞的标签");
    return;
  }
  const collectd = collect_el.getAttribute("data-e2e-state");
  if (!collectd) {
    console.log("没有找到点赞情况");
    return;
  }
  console.log("collectd ", collectd);
  if (collectd == "video-player-is-collect") {
    console.log("已点赞");
    return;
  }
  await click_button(collect_el);
  store$1.increment_dy_collectCount();
  await delay(getRandomNumberInRange(1e3, 5e3));
}
async function douYinTuiJian() {
  const viewedPaths = [];
  while (true) {
    if (!(await checkDomPromise(".page-recommend-container"))) {
      console.error("没有找到", ".page-recommend-container");
      await delay(1e3);
      continue;
    }
    const feedVideo = document.querySelector('div[data-e2e="feed-active-video"]');
    if (!feedVideo) {
      await goToNext();
      continue;
    }
    const note_id = feedVideo.getAttribute("data-e2e-vid");
    sendLog("data-e2e-vid：" + note_id);
    if (viewedPaths.includes(note_id)) {
      sendLog("已存在 data-e2e-vid：" + note_id);
      continue;
    }
    store$1.increment_dy_viewCount();
    const guangGao_el = feedVideo.querySelector(".account svg");
    if (guangGao_el) {
      sendLog("广告，跳过");
      await goToNext();
      continue;
    }
    const vipZhiBo_el = feedVideo.querySelector(".pcVGRb9T");
    if (vipZhiBo_el) {
      sendLog("会员直播，跳过");
      await goToNext();
      continue;
    }
    await douYintuijian_start(feedVideo);
    await goToNext();
    viewedPaths.push(note_id);
  }
}
const douYintuijian_start = async element => {
  if (store$1.isNotRunWork()) {
    return;
  }
  const stringList = [];
  if (XiaoHongShu_Setting$1.reviewProbability == "默认AI控制") {
    if (isWithinProbability(isWithinProbabilitysend_comments)) {
      stringList.push("douYin_send_comments");
    } else {
      console.log("跳过 不评论");
    }
  } else if (XiaoHongShu_Setting$1.reviewProbability == "自定义概率" && XiaoHongShu_Setting$1.customProbabilitiesNum && isWithinProbability(XiaoHongShu_Setting$1.customProbabilitiesNum)) {
    stringList.push("douYin_send_comments");
  }
  if (XiaoHongShu_Setting$1 == null ? void 0 : XiaoHongShu_Setting$1.like) {
    if (isWithinProbability(isWithinProbabilityclickCommentLike)) {
      stringList.push("douYin_clickCommentLike");
    } else {
      console.log("跳过 不点赞");
    }
  }
  if (XiaoHongShu_Setting$1 == null ? void 0 : XiaoHongShu_Setting$1.follow) {
    if (isWithinProbability(isWithinProbabilityfollow_click)) {
      stringList.push("douYin_follow_click");
    } else {
      console.log("跳过 不关注");
    }
  }
  if (XiaoHongShu_Setting$1 == null ? void 0 : XiaoHongShu_Setting$1.collect) {
    if (isWithinProbability(isWithinProbabilitycollect_click)) {
      stringList.push("douYin_collect_click");
    } else {
      console.log("跳过 不收藏");
    }
  }
  await douYin_randomExecFunction(stringList, element, "信息流");
};
const douYin_tuijian_comment = async feedVideo => {
  var _a;
  const img_container_el = feedVideo.querySelector(".imgBackground img");
  let img_container_url = "";
  if (img_container_el) {
    img_container_url = img_container_el.src;
  }
  console.log("img_container_el:", img_container_el);
  console.log("img_container_url:" + img_container_url);
  const detail_title_el = feedVideo.querySelector('div[data-e2e="video-desc"] >div>div>span');
  let detail_title = "";
  if (detail_title_el) {
    detail_title = ((_a = detail_title_el.textContent) == null ? void 0 : _a.trim()) || "";
  }
  console.log("detail_title_el:", detail_title_el);
  console.log("detail_title:", detail_title);
  const detail_content = "";
  const detail_tag_str = "";
  const note_id = feedVideo.getAttribute("data-e2e-vid");
  const comment_input_el = feedVideo.querySelector("#merge-all-comment-container .comment-input-inner-container >div:nth-child(1)");
  if (!comment_input_el) {
    await click_comment_button(feedVideo);
  }
  const textContent_str = await get_douYin_send_child_comment();
  console.log("textContent_str", textContent_str);
  const user_infos = feedVideo.querySelectorAll('a[data-e2e="video-avatar"]');
  let comment_user_url = "";
  let comment_user_id = "";
  if (user_infos && user_infos.length > 0) {
    const user_info = user_infos[0];
    comment_user_url = user_info.href;
    if (comment_user_url) {
      if (comment_user_url.startsWith("//")) {
        comment_user_url = "https:" + comment_user_url;
      }
      const pathname = new URL(comment_user_url).pathname;
      comment_user_id = getLastPathName$1(pathname);
    }
  }
  sendLog("Path: " + store$1.userId + "  " + note_id);
  const refer_id = "auto_comment_dou_yin_user_" + store$1.userId + "_path_" + note_id;
  if (await queryComment$1(refer_id)) {
    let result = null;
    sendLog("没有配置 style " + (XiaoHongShu_Setting$1 == null ? void 0 : XiaoHongShu_Setting$1.style) + " " + (XiaoHongShu_Setting$1 == null ? void 0 : XiaoHongShu_Setting$1.charLimit) + " " + (XiaoHongShu_Setting$1 == null ? void 0 : XiaoHongShu_Setting$1.keywordInfo));
    const inputs = {
      test: detail_title,
      commentaries: textContent_str,
      style: XiaoHongShu_Setting$1 == null ? void 0 : XiaoHongShu_Setting$1.style,
      word_limit: XiaoHongShu_Setting$1 == null ? void 0 : XiaoHongShu_Setting$1.charLimit,
      key_message: XiaoHongShu_Setting$1 == null ? void 0 : XiaoHongShu_Setting$1.keywordInfo
    };
    const files = [];
    if (img_container_url) {
      files.push({
        type: "image",
        transfer_method: "remote_url",
        url: img_container_url
      });
    }
    if (XiaoHongShu_Setting$1.commentBlocking == "评论截流" && XiaoHongShu_Setting$1.commentBlockingNum > 0) {
      const callbackFun = async () => {
        const apiKey2 = "app-Ii7VEbb1eRx84RhhtLLLRAD9";
        result = await runWorkflow$1(inputs, files, apiKey2);
        return result;
      };
      await douYin_send_child_comment(callbackFun, feedVideo, '.commentInput-right-ct path[fill="#FE2C55"]');
    }
    const apiKey = "app-Ii7VEbb1eRx84RhhtLLLRAD9";
    result = await runWorkflow$1(inputs, files, apiKey);
    sendLog("result: " + result);
    if (result) {
      const saveInputsData = {
        refer_id,
        // 数据唯一标识，格式为：auto_comment_dou_yin_user_{userId}_path_{note_id}
        title: detail_title,
        // 视频标题/描述文本
        text: detail_content,
        // 视频正文内容
        label: detail_tag_str,
        // 视频标签，包含话题标签
        style: XiaoHongShu_Setting$1 == null ? void 0 : XiaoHongShu_Setting$1.style,
        // 评论风格设置，如：幽默、正式等
        word_limit: XiaoHongShu_Setting$1 == null ? void 0 : XiaoHongShu_Setting$1.charLimit,
        // 评论字数限制
        key_message: XiaoHongShu_Setting$1 == null ? void 0 : XiaoHongShu_Setting$1.keywordInfo,
        // 评论关键信息/关键词设置
        note_url: `https://www.douyin.com/video/${note_id}`,
        // 视频链接地址，由视频ID拼接而成
        note_id,
        // 视频唯一ID，来自data-e2e-vid属性
        comment_user_url,
        // 视频作者主页链接
        comment_user_id,
        // 视频作者ID
        extra_image_id: "",
        // 额外图片ID（当前为空）
        extra_image_url: img_container_url,
        // 视频封面图片URL
        replyComment: result,
        // AI生成的评论内容
        userId: store$1.userId,
        // 当前操作用户的ID
        taskId: store$1.taskId,
        // 当前任务ID
        addTime: (/* @__PURE__ */new Date()).getTime()
        // 数据添加时间戳，13位毫秒级
      };
      const saveInputs = {
        "key": refer_id,
        "bucket": saveInputsData,
        "size": 0,
        "content_type": "string",
        "belong_to": store$1.userId + "_douYin_comment",
        "object_metadata": {}
      };
      await douYin_send_comments(result, saveInputs, feedVideo, '.commentInput-right-ct path[fill="#FE2C55"]');
    }
  } else {
    console.log("已评论过。跳过");
  }
};
const goToNext = async () => {
  const next_el = document.querySelector(".xgplayer-icon .xgplayer-playswitch-next");
  if (!next_el) {
    console.error("没有找到输入评论的输入框");
    return;
  }
  await click_button(next_el);
  await delay(getRandomNumberInRange(1e3, 5e3));
};
const tuijian_flow = async element => {
  const flow_el = element.querySelector('div[data-e2e="feed-follow-icon"] .semi-icon svg');
  if (!flow_el) {
    console.log("没有找到关注按钮");
    return;
  }
  await click_button(flow_el);
  store$1.increment_dy_followCount();
};
async function douYin_send_child_comment(callbackFun, element, sendButtonQuerySelector) {
  var _a, _b, _c;
  const chatWrapper = element.querySelectorAll('div[data-e2e="feed-comment-icon"] >div:nth-child(2)');
  const chatWrapperCountStr = (_a = chatWrapper[0].textContent) == null ? void 0 : _a.trim();
  sendLog("douYin_send_child_comment 评论数量:" + chatWrapperCountStr + ", XiaoHongShu_Setting.commentBlockingNum:" + XiaoHongShu_Setting$1.commentBlockingNum);
  if (chatWrapperCountStr) {
    let chatWrapperCount = parseInt(chatWrapperCountStr);
    if (XiaoHongShu_Setting$1.commentBlockingNum < chatWrapperCount) {
      console.log("chatWrapperCount", chatWrapperCount);
      const parentComments = document.querySelectorAll('.comment-mainContent div[data-e2e="comment-item"] >div:nth-child(2) >div');
      let comment_num = 0;
      for (let i = 0; i < 10; i++) {
        if (!parentComments[i]) {
          continue;
        }
        const selfEl = parentComments[i].querySelector(".semi-tag-content-center");
        if (selfEl) {
          sendLog("子评论是作者");
          const selfEl_text = (_b = selfEl.textContent) == null ? void 0 : _b.trim();
          if (selfEl_text == "作者") {
            continue;
          }
          continue;
        }
        const reply = parentComments[i].querySelector(".comment-item-stats-container >div:nth-child(3) >div");
        if (!reply) {
          sendLog("没有找到了子评论的回复按钮");
          continue;
        }
        sendLog("找到了子评论的回复按钮");
        ensureElementVisible(reply);
        await click_button(reply);
        let replyButtonBool = false;
        for (let j = 0; j < 60; j++) {
          const reply_text = (_c = reply.textContent) == null ? void 0 : _c.trim();
          if (reply_text == "回复中") {
            replyButtonBool = true;
            break;
          }
          const reply_ = document.querySelector(".comment-input-container .ufemOFBf");
          if (reply_) {
            replyButtonBool = true;
            break;
          }
          sendLog("查找点击按钮的结果");
          await delay(1e3);
        }
        if (!replyButtonBool) {
          sendLog("没有找到回复的数据 replyButtonBool：" + replyButtonBool);
          return;
        }
        let content_str = await callbackFun();
        if (!content_str) {
          continue;
        }
        await douYin_send_comments2(content_str, element, sendButtonQuerySelector);
        comment_num++;
        if (comment_num == 3) {
          break;
        }
      }
    }
  }
}
async function douYin_send_comments2(content, element, sendButtonQuerySelector = '.commentInput-right-ct path[fill="#FE2C55"]') {
  var _a;
  console.log("douYin_send_comments");
  await delay(getRandomNumberInRange(1e3, 5e3));
  if (!(await checkDomPromise(".notranslate.public-DraftEditor-content"))) {
    sendLog("没有找到 #content-textarea");
    return;
  }
  const targetElement = document.querySelector(".notranslate.public-DraftEditor-content");
  if (!targetElement) {
    console.error("没有找到输入框");
    return;
  }
  console.log("增加评论后缀信息", XiaoHongShu_Setting$1 == null ? void 0 : XiaoHongShu_Setting$1.commentSuffix);
  if (XiaoHongShu_Setting$1 == null ? void 0 : XiaoHongShu_Setting$1.commentSuffix) {
    console.log("增加评论后缀信息", XiaoHongShu_Setting$1 == null ? void 0 : XiaoHongShu_Setting$1.commentSuffix);
    content += "\r\n" + (XiaoHongShu_Setting$1 == null ? void 0 : XiaoHongShu_Setting$1.commentSuffix);
  }
  if (targetElement) {
    sendLog("执行 targetElement：" + store$1.chromeTabId);
    chrome.runtime.onMessage.addListener((request2, sender2, sendResponse2) => queryActiveElement(request2, sender2, sendResponse2, ".notranslate.public-DraftEditor-content"));
    await simulateInputSendMessage(content, 200, true);
    chrome.runtime.onMessage.removeListener((request2, sender2, sendResponse2) => queryActiveElement(request2, sender2, sendResponse2, ".notranslate.public-DraftEditor-content"));
  } else {
    sendLog("Target element not found.");
  }
  if (store$1.isNotRunWork()) {
    return;
  }
  if (!(await checkDomPromise(sendButtonQuerySelector))) {
    sendLog("没有找到 #content-textarea");
    return;
  }
  const submit = element.querySelector(sendButtonQuerySelector);
  if (!submit) {
    console.error("点击发表评论失败");
    return;
  }
  await click_button(submit);
  let indexNum = 0;
  while (true) {
    if (indexNum > 60) {
      break;
    }
    if (indexNum > 1) {
      console.log("indexNum", indexNum++);
      await delay(1e3);
    }
    indexNum++;
    const response_text_el = element.querySelector(".public-DraftEditor-content > div > div > div > span:nth-child(1)");
    if (!response_text_el) {
      console.log("没有找到输入框");
      continue;
    }
    let response_text = ((_a = response_text_el.textContent) == null ? void 0 : _a.trim()) || "";
    if (response_text) {
      console.log("输入框不为空");
      continue;
    }
    break;
  }
  store$1.increment_dy_CommentCount();
  console.log("评论成功");
  await delay(getRandomNumberInRange(1e3, 5e3));
}
function savePlatformData(elements) {
  var _a, _b, _c, _d, _e, _f, _g, _h, _i, _j, _k, _l, _m;
  for (const element of elements) {
    const element_div_el_video = element.querySelector("#sliderVideo");
    if (!element_div_el_video) {
      continue;
    }
    const element_div_el = element.querySelector("#sliderVideo");
    const note_id = (element_div_el == null ? void 0 : element_div_el.getAttribute("data-e2e-vid")) || "";
    if (!note_id || isNoteProcessed(note_id)) {
      sendLog(`跳过重复视频: ${note_id}`);
      continue;
    }
    markNoteAsProcessed(note_id);
    let detail_title_el = element.querySelector(".search-result-card >div>div:nth-child(2) > div >span >span");
    let detail_title = "";
    if (detail_title_el) {
      detail_title = ((_a = detail_title_el.textContent) == null ? void 0 : _a.trim()) || "";
    } else {
      detail_title_el = element.querySelector(".search-result-card >div>div>div>p");
    }
    if (detail_title_el) {
      detail_title = ((_b = detail_title_el.textContent) == null ? void 0 : _b.trim()) || "";
    }
    const img_container_el = element.querySelector(".imgBackground img");
    const img_container_url = (img_container_el == null ? void 0 : img_container_el.src) || "";
    const like_count_el = (_c = element.querySelector('[data-e2e="video-player-digg"]')) == null ? void 0 : _c.lastElementChild;
    const like_count = ((_d = like_count_el == null ? void 0 : like_count_el.textContent) == null ? void 0 : _d.trim()) || "0";
    const comment_count_el = (_e = element.querySelector('[data-e2e="video-player-comment"]')) == null ? void 0 : _e.lastElementChild;
    let comment_count = ((_f = comment_count_el == null ? void 0 : comment_count_el.textContent) == null ? void 0 : _f.trim()) || null;
    if (comment_count === null) {
      const alt_comment_el = element.querySelector('[data-e2e="feed-comment-icon"] > div:nth-child(2)');
      comment_count = ((_g = alt_comment_el == null ? void 0 : alt_comment_el.textContent) == null ? void 0 : _g.trim()) || "0";
    }
    const share_count_el = (_h = element.querySelector('[data-e2e="video-player-share"]')) == null ? void 0 : _h.lastElementChild;
    const shareCount = ((_i = share_count_el == null ? void 0 : share_count_el.textContent) == null ? void 0 : _i.trim()) || "0";
    const collect_count_el = (_j = element.querySelector('[data-e2e="video-player-collect"]')) == null ? void 0 : _j.lastElementChild;
    const collectCount = ((_k = collect_count_el == null ? void 0 : collect_count_el.textContent) == null ? void 0 : _k.trim()) || "0";
    const length_el = element.querySelector("#sliderVideo .xgplayer-time .time-duration");
    const length = ((_l = length_el == null ? void 0 : length_el.textContent) == null ? void 0 : _l.trim()) || "00:00";
    const lengthInSeconds = convertTimeToSeconds(length);
    const user_info = element.querySelector(".search-result-card >div > div >div > a");
    const comment_user_url = (user_info == null ? void 0 : user_info.href) || "";
    let comment_user_id = "";
    if (comment_user_url) {
      const pathname = new URL(comment_user_url).pathname;
      comment_user_id = getLastPathName$1(pathname);
    }
    const nickname_el = element.querySelector("#search-result-container div.GRecrDuo div.R8BDCqav a");
    const nickname = ((_m = nickname_el == null ? void 0 : nickname_el.textContent) == null ? void 0 : _m.trim()) || "";
    const platform_data = {
      platform: "Douyin",
      url: `https://www.douyin.com/video/${note_id}`,
      account_id: comment_user_id,
      content: {
        // 基础信息字段
        title: detail_title,
        description: detail_title,
        share_url: `https://www.douyin.com/video/${note_id}`,
        thumbnail: img_container_url,
        // 统计数据字段
        view_count: 0,
        like_count: parseCount(like_count),
        comment_count: parseCount(comment_count),
        share_count: parseCount(shareCount),
        collect_count: parseCount(collectCount),
        // 添加收藏数
        length: lengthInSeconds,
        // 作者相关字段
        nickname,
        avatar: "",
        bio: "",
        author_url: comment_user_url,
        follower: 0,
        following: 0,
        video_count: 0,
        author_total_likes: 0,
        account_id: comment_user_id,
        // 时间相关字段
        published_time: (/* @__PURE__ */new Date()).toLocaleString("sv").replace(" ", "T")
        // 输出格式: "2024-03-21T16:30:15"
      }
    };
    if (!comment_user_id || !note_id) {
      sendLog("缺少 account_id，跳过提交数据");
    }
    if (comment_user_id && note_id) {
      setTimeout(() => {
        submitPlatformData(platform_data).then(() => {
          processedNoteIds.add(note_id);
        }).catch(error => {
          sendLog("提交平台数据失败: " + error);
        });
      }, 0);
    }
    console.log("list here platform_data:", platform_data);
  }
}
function meetsCoreMetrics(metrics) {
  try {
    if (!metrics.like_count || !metrics.comment_count || !metrics.share_count || !metrics.collect_count) {
      sendLog("指标数据不完整，跳过检查");
      return false;
    }
    if (metrics.share_count === 0) {
      sendLog("分母为0，无法计算收藏/转发比值");
      return false;
    }
    const meetsLikeThreshold = metrics.like_count >= 500;
    const meetsCommentThreshold = metrics.comment_count >= 50;
    const collectShareRatio = metrics.collect_count / metrics.share_count;
    const meetsRatioThreshold = collectShareRatio >= 0.8;
    if (!meetsLikeThreshold) sendLog(`点赞量未达标${metrics.like_count}`);
    if (!meetsCommentThreshold) sendLog(`评论量未达标${metrics.comment_count}`);
    if (!meetsRatioThreshold) sendLog(`收藏/转发比值未达标${collectShareRatio}`);
    return meetsLikeThreshold && meetsCommentThreshold && meetsRatioThreshold;
  } catch (error) {
    sendLog("检查核心指标时发生错误: " + error);
    return false;
  }
}
async function fetchAccountData(platform, author_url) {
  if (!platform || !author_url) {
    sendLog("缺少必要参数，platform或author_url为空");
    throw new Error("Missing required parameters");
  }
  try {
    const response = await fetch(`${ACCOUNT_DATA_BASE_URL}/account_data`, {
      method: "POST",
      headers: {
        "Content-Type": "application/json",
        "Authorization": `Bearer ${ACCOUNT_DATA_API_AUTH_TOKEN}`
      },
      body: JSON.stringify({
        platform,
        author_url
      })
    });
    if (!response.ok) {
      const errorText = await response.text();
      sendLog(`获取账号数据失败: HTTP ${response.status} - ${errorText}`);
      throw new Error(`HTTP error! status: ${response.status}`);
    }
    const accountData = await response.json();
    if (!accountData) {
      sendLog("获取账号数据成功但数据为空");
      throw new Error("Empty response data");
    }
    sendLog("获取账号数据成功: " + JSON.stringify(accountData));
    return accountData;
  } catch (error) {
    sendLog("获取账号数据失败: " + error);
    console.error("获取账号数据失败:", error);
    throw error;
  }
}
async function checkTaskCompletionStatus() {
  try {
    const eventSource = new EventSource(`${ACCOUNT_DATA_BASE_URL}/task_completion_status`);
    const timeout = setTimeout(() => {
      eventSource.close();
      sendLog("任务状态检查超时");
    }, 30 * 60 * 1e3);
    return new Promise((resolve, reject) => {
      eventSource.onmessage = event => {
        try {
          const data = JSON.parse(event.data);
          if (data.status === "running") {
            sendLog(`任务进行中，剩余任务数: ${data.pending_tasks}`);
          } else if (data.status === "completed") {
            sendLog("所有任务已完成");
            clearTimeout(timeout);
            eventSource.close();
            resolve();
          }
        } catch (error) {
          sendLog("解析任务状态数据失败: " + error);
        }
      };
      eventSource.onerror = error => {
        clearTimeout(timeout);
        eventSource.close();
        reject(new Error("任务状态检查失败: " + error));
      };
    });
  } catch (error) {
    sendLog("检查任务完成状态时发生错误: " + error);
    throw error;
  }
}
async function submitPlatformData(platform_data) {
  var _a;
  try {
    if (!platform_data || !platform_data.content) {
      sendLog("平台数据格式无效");
      throw new Error("Invalid platform data format");
    }
    const metrics = {
      like_count: platform_data.content.like_count || 0,
      comment_count: platform_data.content.comment_count || 0,
      share_count: platform_data.content.share_count || 0,
      collect_count: platform_data.content.collect_count || 0
    };
    if (meetsCoreMetrics(metrics)) {
      try {
        await fetchAccountData(platform_data.platform, ((_a = platform_data == null ? void 0 : platform_data.content) == null ? void 0 : _a.author_url) || "");
        await checkTaskCompletionStatus().then(() => {
          sendLog("任务状态监控完成");
        }).catch(error => {
          sendLog("任务状态监控失败: " + error);
        });
      } catch (error) {
        sendLog("获取账号数据失败，继续提交平台数据: " + error);
      }
    } else {
      sendLog("不满足核心指标，跳过提交平台数据");
      return;
    }
    const response = await fetch(`${ACCOUNT_DATA_BASE_URL}/submit`, {
      method: "POST",
      headers: {
        "Content-Type": "application/json",
        "Authorization": `Bearer ${ACCOUNT_DATA_API_AUTH_TOKEN}`
      },
      body: JSON.stringify(platform_data)
    });
    if (!response.ok) {
      const errorText = await response.text();
      sendLog(`提交平台数据失败: HTTP ${response.status} - ${errorText}`);
      throw new Error(`HTTP error! status: ${response.status}`);
    }
    const result = await response.json();
    if (!result) {
      sendLog("提交平台数据成功但返回数据为空");
      throw new Error("Empty response data");
    }
    sendLog("提交平台数据成功: " + JSON.stringify(result));
    return result;
  } catch (error) {
    sendLog("提交平台数据失败: " + error);
    console.error("提交平台数据失败:", error);
    throw error;
  }
}
function parseCount(numStr) {
  if (!numStr) return 0;
  numStr = numStr.trim().toLowerCase();
  const cnUnitMap = {
    "千": 1e3,
    "k": 1e3,
    "万": 1e4,
    "w": 1e4,
    "亿": 1e8
  };
  for (const [unit, multiplier] of Object.entries(cnUnitMap)) {
    if (numStr.includes(unit)) {
      const numberPart = numStr.replace(unit, "");
      return Math.floor(parseFloat(numberPart) * multiplier);
    }
  }
  return Math.floor(parseFloat(numStr) || 0);
}
const click_douYin_Notifications = async (paramTile, paramUrl, clickText) => {
  console.log("paramTile", paramTile, paramUrl, clickText);
  return new Promise(resolve => {
    chrome.runtime.sendMessage({
      action: "click_douYin_Notifications",
      paramTile,
      paramUrl,
      clickText
    }, {
      includeTlsChannelId: false
    }, () => {
      console.info("click_douYin_Notifications ok");
      resolve({});
    });
  });
};
const douYin_Notifications = async () => {
  var _a, _b;
  const optionWhere = store$1.getOptionWhere();
  console.log("douYin_Notifications");
  if (!(await checkDomPromise('div[data-e2e="something-button"]'))) {
    console.error("没有找到", 'div[data-e2e="something-button"]');
    return;
  }
  while (true) {
    let findBool = false;
    await delay(500);
    let navigationEl = null;
    let somethingButtonList = null;
    for (let k = 0; k <= 2; k++) {
      sendLog("douYin_Notifications i:" + k);
      somethingButtonList = Array.from(document.querySelectorAll('div[data-e2e="something-button"]'));
      navigationEl = document.querySelector('div[id="douyin-navigation"]');
      if (navigationEl && navigationEl.firstElementChild) {
        navigationEl = navigationEl.firstElementChild;
      }
      const captcha_container = document.querySelector("#captcha_container");
      if (captcha_container) {
        sendLog("出现了弹出验证码，需要验证");
        if (store$1.captcha_container_num % 10 == 0) {
          sendLog("出现了弹出验证码，需要验证 警告 captcha_container_num%10", store$1.captcha_container_num % 10, store$1.captcha_container_num);
          let message = "抖音账号：" + store$1.webUserName + "\r\n登录账号Id：" + store$1.userId + "\r\n登录账号：" + store$1.userName + "\r\n已经出现了:" + store$1.captcha_container_num + "次，请尽快处理!!!";
          await send_fei_shu_warn_message("出现了图像验证码！", message);
        }
        store$1.increment_captcha_container_num();
        await click_button(navigationEl);
        break;
      }
      for (let i = 0; i < somethingButtonList.length; i++) {
        const text = (_a = somethingButtonList[i].textContent) == null ? void 0 : _a.trim();
        sendLog("somethingButtonList text：" + text);
        if (text == "通知") {
          let contentUrl = window.location.href;
          let pageTitle = document.title;
          await click_douYin_Notifications(pageTitle, contentUrl, "通知");
          try {
            store$1.setRunLogs("开始处理抖音的通知信息");
            await handle_Notifications();
            store$1.setRunLogs("处理抖音的通知信息完成");
          } catch (err) {
            console.log("handle_Notifications err", err);
            sendLog("handle_Notifications err" + err);
          }
          contentUrl = window.location.href;
          pageTitle = document.title;
          await click_douYin_Notifications(pageTitle, contentUrl, "通知");
          findBool = true;
          continue;
        } else if (text == "私信") {
          let contentUrl = window.location.href;
          let pageTitle = document.title;
          await click_douYin_Notifications(pageTitle, contentUrl, "私信");
          store$1.setRunLogs("开始处理抖音的私信信息");
          await handle_PrivateMessage();
          store$1.setRunLogs("处理抖音的私信信息完成");
          findBool = true;
          break;
        }
        if (store$1.isNotRunWork()) {
          break;
        }
        await delay(500);
      }
      if (findBool) {
        break;
      }
    }
    if (somethingButtonList) {
      for (let i = 0; i < somethingButtonList.length; i++) {
        const text = (_b = somethingButtonList[i].textContent) == null ? void 0 : _b.trim();
        sendLog("somethingButtonList text：" + text);
        if (text == "投稿") {
          await hover_button(somethingButtonList[i]);
        }
      }
    }
    const delayNum = getRandomNumberInRange(optionWhere.refreshFrequencyStart * 60 * 1e3, optionWhere.refreshFrequencyEnd * 60 * 1e3);
    store$1.setRefreshFrequencyNum(delayNum);
    await delay(delayNum);
    if (navigationEl) {
      const nowTime = (/* @__PURE__ */new Date()).getTime();
      console.log("nowTime", nowTime);
      if (store$1.runTimeMaxNum && store$1.runTimeNum && nowTime - store$1.runTimeNum >= store$1.runTimeMaxNum * 60 * 60 * 1e3) {
        closeEndFun("douYin_RunYourCode 通知和私信 倒计时结束").then();
        return;
      }
    }
    if (store$1.isNotRunWork()) {
      break;
    }
  }
};
const handle_Notifications = async () => {
  var _a, _b, _c, _d, _e, _f, _g, _h, _i, _j, _k, _l, _m, _n, _o, _p, _q, _r, _s, _t, _u, _v, _w, _x;
  console.log("handle_Notifications");
  if (!(await checkDomPromise('div[data-e2e="listDlgTest-container"] >div:nth-child(2) > div'))) {
    sendLog('没有找到 div[data-e2e="listDlgTest-container"] >div:nth-child(2) > div');
    store$1.setRunLogs("没有找到通知信息");
    return;
  }
  const key = store$1.userId + "_" + store$1.webUserId + "_last_Notifications";
  const objectData = await getObjects(key);
  console.log("handle_Notifications objectData", objectData);
  const errorPageEl = document.querySelector('div[data-e2e="error-page"]');
  if (errorPageEl) {
    const errorPageText = (_a = errorPageEl.textContent) == null ? void 0 : _a.trim();
    if (errorPageText && errorPageText == "暂无互动消息") {
      if (!objectData) {
        const addResult2 = await addObjects({
          "key": key,
          "bucket": {
            lastText: JSON.stringify([])
          },
          "size": 0,
          "content_type": "",
          "belong_to": store$1.userId + "_last_Notifications",
          "object_metadata": {}
        });
        if (!addResult2 && !addResult2["key"]) {
          console.log("新增数据错误", addResult2);
          sendLog("handle_Notifications 新增数据错误" + JSON.stringify(addResult2));
          return;
        }
        sendLog("没有数据，初始化数据");
        return;
      } else {
        sendLog("没有互动消息，并且objectData 不为null, objectData:" + JSON.stringify({
          objectData
        }));
        return;
      }
    } else {
      store$1.setRunLogs("错误了：" + errorPageText);
      sendLog('找到了div[data-e2e="error-page"]， 但是元素的文本不是：暂无互动消息，而是：' + errorPageText);
      return;
    }
  }
  let listDlgTest = Array.from(document.querySelectorAll('div[data-e2e="listDlgTest-container"] >div:nth-child(2) > div'));
  let lastTextList = [];
  for (let i = 0; i < listDlgTest.length; i++) {
    const dlgTest = listDlgTest[i];
    if (!dlgTest) {
      continue;
    }
    const dlgText = (_b = dlgTest.textContent) == null ? void 0 : _b.trim();
    if (dlgText && dlgText.indexOf("可在【设置】-【隐私设置】中修改在线状态，开启后查看互关朋友在线状态。") > 0) {
      sendLog("这个是 【可在【设置】-【隐私设置】中修改在线状态，开启后查看互关朋友在线状态。】跳过");
      continue;
    }
    const divEl = dlgTest.querySelector(":scope  >div");
    if (divEl) {
      ensureElementVisible(divEl);
    }
    const preEl = dlgTest.querySelector("pre");
    let content = "";
    if (preEl) {
      console.log("preEl", (_c = preEl.textContent) == null ? void 0 : _c.trim());
      content = (_d = preEl.textContent) == null ? void 0 : _d.trim();
    } else {
      const noMoreText = (_e = dlgTest.textContent) == null ? void 0 : _e.trim();
      if (noMoreText == "暂时没有更多了") {
        sendLog("最后一条是没有更多数据了， 暂时没有更多了。跳过");
        continue;
      }
    }
    if (!((_f = dlgTest.textContent) == null ? void 0 : _f.trim())) {
      sendLog("找到的元素，没有任何的内容。");
      continue;
    }
    if (!(await checkDomPromise('div[data-e2e="user-name-card"]', dlgTest))) {
      console.log('没有找到 div[data-e2e="user-name-card"]');
      return;
    }
    const userNameEl = dlgTest.querySelector('div[data-e2e="user-name-card"]');
    let userName = "";
    if (userNameEl) {
      console.log("userNameEl", (_g = userNameEl.textContent) == null ? void 0 : _g.trim());
      userName = (_h = userNameEl.textContent) == null ? void 0 : _h.trim();
    }
    if (!userName) {
      console.log("没有找到用户名称");
      sendLog("没有找到用户名称");
      return;
    }
    let userPath = "";
    const aEl = dlgTest.querySelector('a[rel="noopener noreferrer"]');
    if (aEl) {
      console.log("aEl");
      let href = aEl.getAttribute("href");
      sendLog("href：" + href);
      if (href) {
        if (href.startsWith("//")) {
          href = "https:" + href;
        }
        userPath = new URL(href).pathname;
        userPath = userPath.replace("/user/", "");
        sendLog("href pathname:" + userPath);
      }
    }
    lastTextList.push({
      userName: userPath ? userPath : userName ? userName : "",
      content: content ? content : ""
    });
    await delay(1e3);
    if (i >= 1) {
      break;
    }
  }
  if (lastTextList.length == 0) {
    console.log("handle_Notifications 没有找到数据");
    sendLog("handle_Notifications 没有找到数据");
    store$1.setRunLogs("没有找到数据");
    return;
  }
  const lastText = JSON.stringify(lastTextList);
  if (objectData && objectData["bucket"] && objectData["bucket"]["lastText"] && objectData["bucket"]["lastText"] == lastText) {
    console.log("handle_Notifications lastText", lastText);
    sendLog("handle_Notifications 没有最新的数据");
    store$1.setRunLogs("没有最新的数据");
    return;
  }
  const addResult = await addObjects({
    "key": key,
    "bucket": {
      lastText
    },
    "size": 0,
    "content_type": "",
    "belong_to": store$1.userId + "_last_Notifications",
    "object_metadata": {}
  });
  if (!addResult && !addResult["key"]) {
    console.log("新增数据错误", addResult);
    sendLog("handle_Notifications 新增数据错误" + JSON.stringify(addResult));
    store$1.setRunLogs("新增数据错误");
    return;
  }
  console.log("handle_Notifications lastText:", lastText);
  lastTextList = [];
  if (objectData && objectData["bucket"] && objectData["bucket"]["lastText"] && objectData["bucket"]["lastText"]) {
    lastTextList = JSON.parse(objectData["bucket"]["lastText"]);
  }
  if (!objectData) {
    console.log("第一次初始化数据");
    sendLog("第一次初始化数据");
    store$1.setRunLogs("第一次初始化数据");
    return;
  }
  let matchNum = 0;
  const messageList = [];
  const preMessageList = [];
  let endBool = false;
  let maxNum = 60;
  let num = 0;
  while (!endBool) {
    if (!(await checkDomPromise('div[data-e2e="listDlgTest-container"] >div:nth-child(2) > div'))) {
      sendLog('没有找到 div[data-e2e="listDlgTest-container"] >div:nth-child(2) > div');
      store$1.setRunLogs("没有找到通知信息");
      return;
    }
    listDlgTest = Array.from(document.querySelectorAll('div[data-e2e="listDlgTest-container"] >div:nth-child(2) > div'));
    num++;
    if (num > maxNum) {
      endBool = true;
    }
    for (let i = 0; i < listDlgTest.length; i++) {
      const dlgTest = listDlgTest[i];
      if (!dlgTest) {
        sendLog("dlgTest 为null");
        console.log("dlgTest 为null");
        continue;
      }
      const divEl = dlgTest.querySelector(":scope >div");
      if (divEl) {
        ensureElementVisible(divEl);
      }
      const preEl2 = dlgTest.querySelector("pre");
      let content = "";
      if (preEl2) {
        console.log("preEl", (_i = preEl2.textContent) == null ? void 0 : _i.trim());
        content = (_j = preEl2.textContent) == null ? void 0 : _j.trim();
      }
      const userNameEl2 = dlgTest.querySelector('div[data-e2e="user-name-card"]');
      let userName = "";
      if (userNameEl2) {
        console.log("userNameEl", (_k = userNameEl2.textContent) == null ? void 0 : _k.trim());
        userName = (_l = userNameEl2.textContent) == null ? void 0 : _l.trim();
      }
      let userPath = "";
      const aEl2 = dlgTest.querySelector('a[rel="noopener noreferrer"]');
      if (aEl2) {
        let href = aEl2.getAttribute("href");
        sendLog("href：" + href);
        if (href) {
          if (href.startsWith("//")) {
            href = "https:" + href;
          }
          userPath = new URL(href).pathname;
          userPath = userPath.replace("/user/", "");
          sendLog("href pathname:" + userPath);
        }
      }
      const textContent = (userPath ? userPath : userName ? userName : "") + (content ? content : "");
      if (preMessageList.includes(textContent)) {
        console.log("已经回复过了");
        sendLog("已经回复过了");
        continue;
      }
      preMessageList.push(textContent);
      if (lastTextList && lastTextList[0] && matchNum == 0 && ((_m = lastTextList[0]) == null ? void 0 : _m.userName) + ((_n = lastTextList[0]) == null ? void 0 : _n.content) == textContent) {
        console.log("textContent", textContent);
        matchNum = 1;
        console.log("通知消息", (_o = dlgTest.textContent) == null ? void 0 : _o.trim());
        if (lastTextList && lastTextList.length == 1 && matchNum == 1) {
          console.log("handle_Notifications end，matchNum：" + matchNum + "，lastTextList.length：" + lastTextList.length);
          sendLog("handle_Notifications end，matchNum：" + matchNum + "，lastTextList.length：" + lastTextList.length);
          endBool = true;
          break;
        }
        continue;
      }
      if (matchNum == 1) {
        if (lastTextList && lastTextList[1] && matchNum == 1 && ((_p = lastTextList[1]) == null ? void 0 : _p.userName) + ((_q = lastTextList[1]) == null ? void 0 : _q.content) == textContent) {
          console.log("textContent", textContent);
          matchNum = 2;
          console.log("通知消息2", (_r = dlgTest.textContent) == null ? void 0 : _r.trim());
          if (lastTextList && lastTextList.length >= 2 && matchNum == 2) {
            console.log("handle_Notifications end，matchNum：" + matchNum + "，lastTextList.length：" + lastTextList.length);
            sendLog("handle_Notifications end，matchNum：" + matchNum + "，lastTextList.length：" + lastTextList.length);
            endBool = true;
            break;
          }
        } else {
          console.log("matchNum：", matchNum);
          matchNum = 0;
        }
      }
      const spanList = Array.from(dlgTest.querySelectorAll("span"));
      let spanBoolean = false;
      spanList.forEach(span => {
        var _a2;
        if (span && ((_a2 = span.textContent) == null ? void 0 : _a2.trim()) == "评论了你的作品") {
          spanBoolean = true;
        }
      });
      if (!spanBoolean) {
        console.log("不是评论了你的 作品");
        continue;
      }
      const messageData = {};
      messageData["source"] = "抖音";
      messageData["clueType"] = "通知";
      const preEl = dlgTest.querySelector("pre");
      if (preEl) {
        console.log("preEl", (_s = preEl.textContent) == null ? void 0 : _s.trim());
        messageData["content"] = (_t = preEl.textContent) == null ? void 0 : _t.trim();
        await hover_button(preEl);
        await click_button(preEl);
        await delay(1e3);
      }
      const userNameEl = dlgTest.querySelector('div[data-e2e="user-name-card"]');
      if (userNameEl) {
        console.log("userNameEl", (_u = userNameEl.textContent) == null ? void 0 : _u.trim());
        messageData["userName"] = (_v = userNameEl.textContent) == null ? void 0 : _v.trim();
      }
      const aEl = dlgTest.querySelector('a[rel="noopener noreferrer"]');
      if (aEl) {
        console.log("aEl");
        let href = aEl.getAttribute("href");
        sendLog("href：" + href);
        messageData["userUrl"] = href;
        if (href) {
          if (href.startsWith("//")) {
            href = "https:" + href;
          }
          userPath = new URL(href).pathname;
          userPath = userPath.replace("/user/", "");
          sendLog("href pathname:" + userPath);
          messageData["userPath"] = userPath;
        }
      }
      const avatarImgEl = dlgTest.querySelector('div[data-e2e="user-avatar-card"] img');
      let avatarPath = "";
      let avatarUrl = "";
      if (avatarImgEl) {
        avatarUrl = avatarImgEl.src;
        if (avatarUrl) {
          try {
            if (avatarUrl.startsWith("//")) {
              avatarUrl = "https:" + avatarUrl;
            }
            const avatarURL = new URL(avatarUrl);
            avatarPath = avatarURL.pathname;
            if (avatarPath) {
              avatarPath = getLastPathName$1(avatarPath);
            } else {
              sendLog("用户头像为空，pathname:" + avatarPath);
            }
          } catch (error) {
            sendLog("用户头像为空 url 错误 " + avatarUrl);
          }
        } else {
          sendLog("用户头像的地址不是Url:" + avatarUrl);
        }
      } else {
        sendLog("没有找到用户头像");
      }
      messageData["avatar"] = avatarUrl;
      messageData["avatarPath"] = avatarPath;
      const timeEl = dlgTest.querySelector(":scope >div >div >div >div:nth-child(3) >span:nth-child(2)");
      if (timeEl) {
        const timeText = (_w = timeEl.textContent) == null ? void 0 : _w.trim();
        console.log("timeText", timeText);
        messageData["timeText"] = timeText;
      }
      const date = /* @__PURE__ */new Date();
      const year = date.getFullYear();
      const month = String(date.getMonth() + 1).padStart(2, "0");
      const day = String(date.getDate()).padStart(2, "0");
      const hours = String(date.getHours()).padStart(2, "0");
      const minutes = String(date.getMinutes()).padStart(2, "0");
      messageData["createDate"] = `${year}-${month}-${day} ${hours}:${minutes}`;
      messageData["addTime"] = (/* @__PURE__ */new Date()).getTime();
      messageData["tenantId"] = store$1.tenantId;
      messageData["userId"] = store$1.userId;
      messageData["agentId"] = VITE_AGENT_ID;
      messageData["taskId"] = store$1.taskId;
      messageData["executeId"] = store$1.executeId;
      messageData["terminalId"] = (_x = store$1.terminalData) == null ? void 0 : _x.terminalId;
      messageData["webUserId"] = store$1.webUserId;
      messageData["webUserName"] = store$1.webUserName;
      const contentUrlData = await getContentUrl(messageData);
      if (contentUrlData && contentUrlData.contentUrl) {
        messageData["contentUrl"] = contentUrlData.contentUrl;
      }
      if (contentUrlData == null ? void 0 : contentUrlData.replayBoolean) {
        store$1.setRunLogs("开始回复抖音的通知的视频：" + contentUrlData["videoDesc"] + "的评论");
        messageList.push(messageData);
        const userData = await get_PrivateMessage_userId(messageData["avatarPath"], messageData["userName"], messageData["userPath"]);
        messageData["contentWebUserId"] = userData["webUserId"];
        messageData["contentUserId"] = userData["userId"];
        const key2 = "douYin_Notifications_" + (/* @__PURE__ */new Date()).getTime();
        const postDataObj = {
          "key": key2,
          "bucket": messageData,
          "size": 0,
          "content_type": "",
          "belong_to": store$1.userId + "_douYinList",
          "object_metadata": {}
        };
        await addObjects(postDataObj);
        if (!userData["webUserId"] && messageData["userPath"]) {
          userData["webUserId"] = messageData["userPath"];
          const bucket = userData["bucket"];
          bucket["webUserId"] = userData["webUserId"];
          await update_Private_userId(userData.key, bucket);
          const changePostData = {
            "old_id": userData["userId"],
            "new_id": userData["webUserId"]
          };
          await changeAccount(changePostData);
        }
        store$1.setContentText(messageData["content"]);
        store$1.setReplyComment(contentUrlData["replyContentText"]);
        await saveChat({
          "session": {
            // 登录网站用户id
            "account_id": store$1.webUserId,
            // 视频名称
            "video_name": contentUrlData["videoDesc"],
            // 视频地址
            "video_url": messageData["contentUrl"],
            // 会话来源，通知和私信
            "source": "通知"
          },
          "chat_list": [{
            // 发送id
            "sender": userData["webUserId"] ? userData["webUserId"] : userData["userId"],
            // 发送人的名称
            "sender_name": messageData["userName"],
            "sender_avatar": messageData["avatar"],
            // 接收人id
            "receiver": store$1.webUserId,
            // 接收人的id
            "receiver_name": store$1.webUserName,
            "receiver_avatar": store$1.webUserAvatarUrl,
            // 发送内容
            "content": messageData["content"]
          }, {
            // 发送id
            "sender": store$1.webUserId,
            // 发送人的名称
            "sender_name": store$1.webUserName,
            "sender_avatar": store$1.webUserAvatarUrl,
            // 接收人id
            "receiver": userData["webUserId"] ? userData["webUserId"] : userData["userId"],
            // 接收人的id
            "receiver_name": messageData["userName"],
            "receiver_avatar": messageData["avatar"],
            // 发送内容
            "content": contentUrlData["replyContentText"]
          }]
        });
        break;
      } else {
        console.log("contentUrlData?.replayBoolean 为 false");
      }
    }
  }
  console.log("handle_Notifications messageList", messageList);
};
const findFirstMessageToScroll = async () => {
  let preFirstChild = null;
  let num = 0;
  while (true) {
    if (num > 60) {
      sendLog("超过60还没有找到");
      break;
    }
    num++;
    let container = document.querySelector('div[data-e2e="listDlg-container"] > div:nth-child(2) > div:nth-child(1)');
    const firstChild = container == null ? void 0 : container.firstElementChild;
    if (!firstChild) {
      await delay(200);
      continue;
    }
    if (preFirstChild == null || firstChild != preFirstChild) {
      firstChild.scrollIntoView({
        behavior: "smooth",
        block: "start"
      });
    }
    await delay(200);
    if (firstChild == preFirstChild) {
      sendLog("已经滚动到了容器的顶部，找到了第一个元素");
      break;
    }
    preFirstChild = firstChild;
  }
};
const getCorpusContentText = async messageData => {
  let corpus_id = "";
  if (store$1.corpusData && store$1.corpusData["chat"]) {
    corpus_id = store$1.corpusData["chat"];
  }
  if (!corpus_id) {
    if (store$1.tenantId) {
      const corpusResult = await queryTenantsCorpus(store$1.tenantId);
      sendLog("corpusResult：" + JSON.stringify(corpusResult));
      if (corpusResult && corpusResult["code"] == 0) {
        sendLog("corpusResult['data']:" + typeof corpusResult["data"]);
        store$1.setCorpusData(corpusResult["data"]);
      }
      if (store$1.corpusData && store$1.corpusData["chat"]) {
        corpus_id = store$1.corpusData["chat"];
      }
    } else {
      sendLog("没有租户id");
    }
  }
  let contentText = "";
  if (corpus_id) {
    const postData = {
      "corpus_id": corpus_id,
      "content": messageData["content"]
    };
    const chatTextJson = await getReplyContent(postData);
    if (chatTextJson && chatTextJson["data"]) {
      contentText = chatTextJson["data"];
    } else {
      sendLog("没有获取到对话内容 chatTextJson:" + JSON.stringify(chatTextJson));
    }
  } else {
    sendLog("没有找到corpus_id：" + JSON.stringify(store$1.corpusData));
  }
  return contentText;
};
const handle_PrivateMessage = async () => {
  var _a, _b, _c, _d, _e, _f, _g, _h, _i;
  console.log("handle_PrivateMessage");
  if (!(await checkDomPromise('div[data-e2e="listDlg-container"]>div:nth-child(2) >div >div'))) {
    console.error("没有找到", 'div[data-e2e="listDlg-container"]>div:nth-child(2) >div >div');
    store$1.setRunLogs("没有找到私信信息");
    return;
  }
  const errorPageEl = document.querySelector('div[data-e2e="listDlg-container"] div[data-e2e="error-page"]');
  if (errorPageEl) {
    const errorPageText = (_a = errorPageEl.textContent) == null ? void 0 : _a.trim();
    if (errorPageText && errorPageText == "暂无私信") {
      sendLog("handle_PrivateMessage 暂无私信");
      store$1.setRunLogs("暂无私信");
      return;
    } else {
      store$1.setRunLogs("错误了" + errorPageText);
      sendLog('找到了div[data-e2e="error-page"]， 但是元素的文本不是：暂无私信，而是：' + errorPageText);
      return;
    }
  }
  sendLog("handle_PrivateMessage 展开");
  store$1.setRunLogs("展开私信");
  let num = 0;
  let findZhanKaiEl = null;
  let first_PrivateMessage_Stranger = false;
  let unreadPrivateMessageList = [];
  const noReadHandle = (i, dlg) => {
    var _a2, _b2;
    const zuoZhiEl = dlg.querySelector(":scope >div >div>div:nth-child(2) >div:nth-child(1)");
    let zuoZhiText = "";
    if (zuoZhiEl) {
      const zuoZhiText2 = (_a2 = zuoZhiEl.textContent) == null ? void 0 : _a2.trim();
      console.log("zuoZhiText2", zuoZhiText2);
      if (zuoZhiText2) {
        zuoZhiText = zuoZhiText2;
      }
    }
    if (i == 0 && zuoZhiText == "陌生人消息") {
      first_PrivateMessage_Stranger = true;
    }
    const dianEl = dlg.querySelector(":scope >div >div>div:nth-child(3) > span");
    const dianDivEl = dlg.querySelector(":scope >div >div>div:nth-child(3) > div");
    let hongDianBool = true;
    if (!dianEl && !dianDivEl) {
      sendLog("已读取过了：" + zuoZhiText);
      hongDianBool = false;
      return;
    }
    if (hongDianBool) {
      let preText = "";
      const preEl = dlg.querySelector("pre");
      if (preEl) {
        const preText2 = (_b2 = preEl.textContent) == null ? void 0 : _b2.trim();
        if (preText2) {
          preText = preText2;
        }
      }
      sendLog("找到未读的数据：" + zuoZhiText + preText);
      unreadPrivateMessageList.push(zuoZhiText + preText);
    }
  };
  while (true) {
    if (num > 60) {
      break;
    }
    num++;
    const listDlg2 = Array.from(document.querySelectorAll('div[data-e2e="listDlg-container"]>div:nth-child(2) >div >div'));
    let container2 = document.querySelector('div[data-e2e="listDlg-container"] > div:nth-child(2)');
    if (listDlg2.length == 0) {
      sendLog("没有私信内容");
      store$1.setRunLogs("没有私信内容");
      await delay(100);
      continue;
    }
    const divList = Array.from(document.querySelectorAll('div[data-e2e="listDlg-container"] div'));
    let noMoreBoolean = false;
    for (let i = divList.length - 1; i >= 0; i--) {
      const divEl = divList[i];
      if (divEl && ((_b = divEl.textContent) == null ? void 0 : _b.trim()) == "暂时没有更多了") {
        noMoreBoolean = true;
        break;
      }
    }
    let findMinNum = 3;
    for (let i = 0; i < listDlg2.length; i++) {
      const dlg = listDlg2[i];
      if (!dlg) {
        continue;
      }
      const divEl = dlg.querySelector(":scope >div");
      if (divEl) {
        ensureElementVisible(divEl, container2);
      }
      console.log("dlg", dlg);
      const dianEl = dlg.querySelector(":scope >div >div>div:nth-child(3) > span");
      const dianDivEl = dlg.querySelector(":scope >div >div>div:nth-child(3) > div");
      if (!dianEl && !dianDivEl) {
        const clickDiv = dlg.querySelector('div[data-e2e="conversation-item"]>div >div:nth-child(2)');
        if (clickDiv) {
          findZhanKaiEl = clickDiv;
          if (findMinNum <= 0) {
            break;
          }
          findMinNum--;
        }
      }
      const zuoZhiEl = dlg.querySelector(":scope >div >div>div:nth-child(2) >div:nth-child(1)");
      let zuoZhiText = "";
      if (zuoZhiEl) {
        const zuoZhiText2 = (_c = zuoZhiEl.textContent) == null ? void 0 : _c.trim();
        console.log("zuoZhiText2", zuoZhiText2);
        if (zuoZhiText2) {
          zuoZhiText = zuoZhiText2;
        }
      }
      if (i == 0 && zuoZhiText == "陌生人消息") {
        const clickDiv = dlg.querySelector("pre");
        if (clickDiv) {
          findZhanKaiEl = clickDiv;
          first_PrivateMessage_Stranger = true;
          break;
        }
      }
    }
    if (findZhanKaiEl) {
      break;
    }
    if (noMoreBoolean) {
      sendLog("找到了：暂时没有更多了");
      for (let i = listDlg2.length - 1; i >= 0; i--) {
        if (findZhanKaiEl) {
          break;
        }
        const dlg = listDlg2[i];
        const clickDiv = dlg.querySelector('div[data-e2e="conversation-item"]>div >div:nth-child(2)');
        if (clickDiv) {
          findZhanKaiEl = clickDiv;
        }
        noReadHandle(i, dlg);
      }
      break;
    }
  }
  if (findZhanKaiEl) {
    await click_button(findZhanKaiEl);
    await delay(1e3);
  } else {
    sendLog("无法展开");
    return;
  }
  if (first_PrivateMessage_Stranger) {
    store$1.setRunLogs("第一条是陌生人");
    sendLog("第一条是陌生人 展开的");
    await delay(1e3);
    await handler_PrivateMessage_Stranger();
    return;
  } else {
    if (!(await checkDomPromise('div[data-e2e="listDlg-container"] >div >span'))) {
      sendLog('没有找到 div[data-e2e="listDlg-container"] >div >span');
      return;
    }
    const rectEl = document.querySelector('div[data-e2e="listDlg-container"] >div >span rect');
    if (rectEl) {
      const y = rectEl.getAttribute("y");
      if (!y) {
        store$1.setRunLogs("展开用户列表");
        const iconEl = document.querySelector('div[data-e2e="listDlg-container"] >div >span');
        if (iconEl) {
          await click_button(iconEl);
          await delay(1e3);
        }
      } else {
        console.log("已经展开了");
        store$1.setRunLogs("已经展开了");
      }
    }
    if (!(await checkDomPromise('div[data-e2e="listDlg-container"]>div:nth-child(2) >div >div'))) {
      sendLog('没有找到 div[data-e2e="listDlg-container"]>div:nth-child(2) >div >div');
      return;
    }
  }
  first_PrivateMessage_Stranger = false;
  store$1.setRunLogs("展开之后，读取未读数据");
  sendLog("展开之后，读取未读数据");
  await findFirstMessageToScroll();
  let listDlg = Array.from(document.querySelectorAll('div[data-e2e="listDlg-container"]>div:nth-child(2) >div >div'));
  let container = document.querySelector('div[data-e2e="listDlg-container"] > div:nth-child(2)');
  for (let i = 0; i < listDlg.length; i++) {
    const dlg = listDlg[i];
    if (!dlg) {
      continue;
    }
    const divEl = dlg.querySelector(":scope >div");
    if (divEl) {
      ensureElementVisible(divEl, container);
    }
    console.log("dlg", dlg);
    noReadHandle(i, dlg);
  }
  sendLog("unreadPrivateMessageList:" + JSON.stringify(unreadPrivateMessageList));
  const messageList = [];
  if (first_PrivateMessage_Stranger) {
    store$1.setRunLogs("开始处理私信陌生人");
    sendLog("开始处理私信陌生人");
    await handler_PrivateMessage_Stranger_list();
  }
  if (!(await checkDomPromise('div[data-e2e="listDlg-container"]>div:nth-child(2) >div >div'))) {
    sendLog('没有找到 div[data-e2e="listDlg-container"]>div:nth-child(2) >div >div');
    return;
  }
  sendLog("展开之后，开始处理滚动到容器的顶部");
  store$1.setRunLogs("展开之后，开始处理滚动到容器的顶部");
  await findFirstMessageToScroll();
  sendLog("展开之后，开始处理未读的数据");
  store$1.setRunLogs("展开之后，开始处理未读的数据");
  listDlg = Array.from(document.querySelectorAll('div[data-e2e="listDlg-container"]>div:nth-child(2) >div >div'));
  container = document.querySelector('div[data-e2e="listDlg-container"] > div:nth-child(2)');
  for (let i = 0; i < listDlg.length; i++) {
    const dlg = listDlg[i];
    if (!dlg) {
      continue;
    }
    const divEl = dlg.querySelector("pre");
    if (divEl) {
      ensureElementVisible(divEl, container);
    }
    console.log("dlg", dlg);
    const zuoZhiEl = dlg.querySelector(":scope >div >div>div:nth-child(2) >div:nth-child(1)");
    let zuoZhiText = "";
    if (zuoZhiEl) {
      const zuoZhiText2 = (_d = zuoZhiEl.textContent) == null ? void 0 : _d.trim();
      console.log("zuoZhiText2", zuoZhiText2);
      if (zuoZhiText2) {
        zuoZhiText = zuoZhiText2;
      }
    }
    const avatarImgEl = dlg.querySelector("img");
    let avatarPath = "";
    let avatarUrl = "";
    if (avatarImgEl) {
      avatarUrl = avatarImgEl.src;
      if (avatarUrl) {
        try {
          if (avatarUrl.startsWith("//")) {
            avatarUrl = "https:" + avatarUrl;
          }
          const avatarURL = new URL(avatarUrl);
          avatarPath = avatarURL.pathname;
          if (avatarPath) {
            avatarPath = getLastPathName$1(avatarPath);
          } else {
            sendLog("用户头像为空，pathname:" + avatarPath);
          }
        } catch (error) {
          sendLog("用户头像为空 url 错误 " + avatarUrl);
        }
      } else {
        sendLog("用户头像的地址不是Url:" + avatarUrl);
      }
    } else {
      sendLog("没有找到用户头像");
    }
    const messageData = {};
    messageData["userName"] = zuoZhiText;
    messageData["avatar"] = avatarUrl;
    messageData["avatarPath"] = avatarPath;
    messageData["source"] = "抖音";
    messageData["clueType"] = "私信";
    const preEl = dlg.querySelector("pre");
    let preText = "";
    if (preEl) {
      const preText2 = (_e = preEl.textContent) == null ? void 0 : _e.trim();
      console.log("handle_PrivateMessage preText", preText2);
      if (preText2) {
        preText = preText2;
      }
      messageData["content"] = preText;
    }
    sendLog("unreadPrivateMessageList.includes：" + unreadPrivateMessageList.includes(zuoZhiText + preText) + "--" + zuoZhiText + preText);
    if (!unreadPrivateMessageList.includes(zuoZhiText + preText)) {
      sendLog("不是未读的 ：" + zuoZhiText + preText);
      continue;
    }
    const timeEl = dlg.querySelector(":scope >div >div>div:nth-child(2) >div:nth-child(2) >div:nth-child(2)");
    if (timeEl) {
      const timeText = (_f = timeEl.textContent) == null ? void 0 : _f.trim();
      console.log("timeText", timeText);
      messageData["timeText"] = timeText;
    }
    const clickDiv = dlg.querySelector('div[data-e2e="conversation-item"]>div >div:nth-child(2)');
    if (!clickDiv) {
      sendLog("没有找到clickDiv");
      continue;
    }
    await click_button(clickDiv);
    await delay(1e3);
    const preText3 = await getUserSendReplyContent();
    if (preText3) {
      messageData["content"] = preText3;
    }
    const date = /* @__PURE__ */new Date();
    const year = date.getFullYear();
    const month = String(date.getMonth() + 1).padStart(2, "0");
    const day = String(date.getDate()).padStart(2, "0");
    const hours = String(date.getHours()).padStart(2, "0");
    const minutes = String(date.getMinutes()).padStart(2, "0");
    messageData["createDate"] = `${year}-${month}-${day} ${hours}:${minutes}`;
    messageData["addTime"] = (/* @__PURE__ */new Date()).getTime();
    messageData["tenantId"] = store$1.tenantId;
    messageData["userId"] = store$1.userId;
    messageData["agentId"] = VITE_AGENT_ID;
    messageData["taskId"] = store$1.taskId;
    messageData["executeId"] = store$1.executeId;
    messageData["terminalId"] = (_g = store$1.terminalData) == null ? void 0 : _g.terminalId;
    messageData["webUserId"] = store$1.webUserId;
    messageData["webUserName"] = store$1.webUserName;
    if (messageData && messageData["content"]) {
      store$1.setContentText(messageData["content"]);
      const textContent = messageData["content"];
      const contentArray = Array.from(textContent);
      console.log("contentArray", contentArray);
      const phoneNums = extractPhoneNumbers(textContent);
      const optionWhere = store$1.getOptionWhere();
      console.log("phoneNums", phoneNums);
      if (phoneNums.length > 0) {
        messageData["contactInformation"] = phoneNums[0];
        messageData["contactInformationBool"] = 1;
      }
      chrome.storage.local.set({
        "douYinDataList": JSON.stringify(messageData)
      });
      const userData = await get_PrivateMessage_userId(avatarPath, zuoZhiText);
      let userFirstCommentBool = false;
      if (optionWhere.enableFirstReplyBool) {
        sendLog("使用软件程序进行 私信建立回复话术");
        userFirstCommentBool = await query_user_chat_num(userData["userId"]);
      }
      messageData["contentWebUserId"] = userData["webUserId"];
      messageData["contentUserId"] = userData["userId"];
      if (userFirstCommentBool) {
        if (optionWhere.enableFirstReplyBool && (optionWhere.phoneNumberReplyContent || optionWhere.phoneNumberReplyContent1 || optionWhere.phoneNumberReplyContent3)) {
          sendLog("第一次回复");
          store$1.setRunLogs("第一次回复");
          const chatList = [{
            // 发送id
            "sender": userData["webUserId"] ? userData["webUserId"] : userData["userId"],
            // 发送人的名称
            "sender_name": messageData["userName"],
            "sender_avatar": messageData["avatar"],
            // 接收人id
            "receiver": store$1.webUserId,
            // 接收人的id
            "receiver_name": store$1.webUserName,
            "receiver_avatar": store$1.webUserAvatarUrl,
            // 发送内容
            "content": messageData["content"]
          }];
          if (optionWhere.phoneNumberReplyContent1) {
            store$1.setRunLogs("回复内容：" + optionWhere.phoneNumberReplyContent1);
            await replyContent_PrivateMessage(optionWhere.phoneNumberReplyContent1);
            await delay(getRandomNumberInRange(3e3, 5e3));
            chatList.push({
              // 发送id
              "sender": store$1.webUserId,
              // 发送人的名称
              "sender_name": store$1.webUserName,
              "sender_avatar": store$1.webUserAvatarUrl,
              // 接收人id
              "receiver": userData["webUserId"] ? userData["webUserId"] : userData["userId"],
              // 接收人的id
              "receiver_name": messageData["userName"],
              "receiver_avatar": messageData["avatar"],
              // 发送内容
              "content": optionWhere.phoneNumberReplyContent1
            });
            store$1.setReplyComment(optionWhere.phoneNumberReplyContent1);
          }
          if (optionWhere.phoneNumberReplyContent) {
            store$1.setRunLogs("回复内容：" + optionWhere.phoneNumberReplyContent);
            await replyContent_PrivateMessage(optionWhere.phoneNumberReplyContent);
            await delay(getRandomNumberInRange(3e3, 5e3));
            chatList.push({
              // 发送id
              "sender": store$1.webUserId,
              // 发送人的名称
              "sender_name": store$1.webUserName,
              "sender_avatar": store$1.webUserAvatarUrl,
              // 接收人id
              "receiver": userData["webUserId"] ? userData["webUserId"] : userData["userId"],
              // 接收人的id
              "receiver_name": messageData["userName"],
              "receiver_avatar": messageData["avatar"],
              // 发送内容
              "content": optionWhere.phoneNumberReplyContent
            });
            store$1.setReplyComment(optionWhere.phoneNumberReplyContent);
          }
          if (optionWhere.phoneNumberReplyContent3) {
            store$1.setRunLogs("回复内容：" + optionWhere.phoneNumberReplyContent3);
            await replyContent_PrivateMessage(optionWhere.phoneNumberReplyContent3);
            chatList.push({
              // 发送id
              "sender": store$1.webUserId,
              // 发送人的名称
              "sender_name": store$1.webUserName,
              "sender_avatar": store$1.webUserAvatarUrl,
              // 接收人id
              "receiver": userData["webUserId"] ? userData["webUserId"] : userData["userId"],
              // 接收人的id
              "receiver_name": messageData["userName"],
              "receiver_avatar": messageData["avatar"],
              // 发送内容
              "content": optionWhere.phoneNumberReplyContent3
            });
            store$1.setReplyComment(optionWhere.phoneNumberReplyContent3);
          }
          await delay(getRandomNumberInRange(2 * 1e3, 10 * 1e3));
          messageData["replyText"] = optionWhere.phoneNumberReplyContent;
          messageData["replyType"] = "first";
          messageList.push(messageData);
          await delay(1e3);
          const key = "handler_PrivateMessage_Stranger_" + (/* @__PURE__ */new Date()).getTime();
          const postDataObj = {
            "key": key,
            "bucket": messageData,
            "size": 0,
            "content_type": "",
            "belong_to": store$1.userId + "_douYinList",
            "object_metadata": {}
          };
          await addObjects(postDataObj);
          store$1.setRunLogs("保存统一聚合信息");
          await saveChat({
            "session": {
              // 登录网站用户id
              "account_id": store$1.webUserId,
              // 视频名称
              "video_name": "",
              // 视频地址
              "video_url": "",
              // 会话来源，通知和私信
              "source": "私信"
            },
            "chat_list": chatList
          });
        } else {
          store$1.setRunLogs("第一次 没有回复的内容");
          sendLog("第一次 没有回复的内容");
        }
      } else {
        sendLog("第二次回复 调用对话，获取回复内容");
        store$1.setRunLogs("第二次回复 调用对话，获取回复内容");
        const msgItemContentListEl = Array.from(document.querySelectorAll('div[data-e2e="msg-item-content"]'));
        const textContentList = [];
        for (let j = 0; j < msgItemContentListEl.length; j++) {
          const textContent2 = (_h = msgItemContentListEl[0].textContent) == null ? void 0 : _h.trim();
          if (textContent2 && textContent2 != messageData["content"]) {
            textContentList.push(textContent2);
          }
        }
        console.log("textContentList：", textContentList);
        let contentText = await getCorpusContentText(messageData);
        if (contentText == "已经取得联系方式") {
          sendLog("已经取得联系方式 不在回复");
          contentText = "收到，我们会尽快联系您。";
        }
        if (optionWhere.keFuNullReplyContent && !contentText) {
          contentText = optionWhere.keFuNullReplyContent;
          sendLog("回复的内容为空，使用兜底的回复内容， keFuNullReplyContent：" + optionWhere.keFuNullReplyContent);
          messageData["keFuNullReplyContent"] = "yes";
        }
        if (!contentText) {
          sendLog("回复的内容为空，不需要回复");
          store$1.setRunLogs("回复的内容为空，不需要回复");
        } else {
          store$1.setRunLogs("回复的内容：" + contentText);
          sendLog("回复的内容：" + contentText);
          messageData["replyText"] = contentText;
          messageData["replyType"] = "second";
          await replyContent_PrivateMessage(contentText);
          store$1.setReplyComment(contentText);
          await delay(1e3);
          const key = "handler_PrivateMessage_Stranger_" + (/* @__PURE__ */new Date()).getTime();
          const postDataObj = {
            "key": key,
            "bucket": messageData,
            "size": 0,
            "content_type": "",
            "belong_to": store$1.userId + "_douYinList",
            "object_metadata": {}
          };
          await addObjects(postDataObj);
          const chatList = [{
            // 发送id
            "sender": userData["webUserId"] ? userData["webUserId"] : userData["userId"],
            // 发送人的名称
            "sender_name": messageData["userName"],
            "sender_avatar": messageData["avatar"],
            // 接收人id
            "receiver": store$1.webUserId,
            // 接收人的id
            "receiver_name": store$1.webUserName,
            "receiver_avatar": store$1.webUserAvatarUrl,
            // 发送内容
            "content": messageData["content"]
          }, {
            // 发送id
            "sender": store$1.webUserId,
            // 发送人的名称
            "sender_name": store$1.webUserName,
            "sender_avatar": store$1.webUserAvatarUrl,
            // 接收人id
            "receiver": userData["webUserId"] ? userData["webUserId"] : userData["userId"],
            // 接收人的id
            "receiver_name": messageData["userName"],
            "receiver_avatar": messageData["avatar"],
            // 发送内容
            "content": contentText
          }];
          store$1.setRunLogs("保存统一聚合信息");
          await saveChat({
            "session": {
              // 登录网站用户id
              "account_id": store$1.webUserId,
              // 视频名称
              "video_name": "",
              // 视频地址
              "video_url": "",
              // 会话来源，通知和私信
              "source": "私信"
            },
            "chat_list": chatList
          });
        }
      }
    } else {
      sendLog("messageData['content'] 不为真");
      store$1.setRunLogs("没有私信内容");
    }
  }
  console.log("handle_PrivateMessage messageList", messageList);
  sendLog("first_PrivateMessage_Stranger：" + first_PrivateMessage_Stranger);
  if (!first_PrivateMessage_Stranger) {
    sendLog("开始处理私信陌生人");
    store$1.setRunLogs("开始处理私信陌生人");
    await handler_PrivateMessage_Stranger_list();
  }
  const loginOutEls = Array.from(document.querySelectorAll('div[data-mask="conversaton-detail-content"] >div >span'));
  if (loginOutEls) {
    for (let i = 0; i < loginOutEls.length; i++) {
      const loginOutEl = loginOutEls[i];
      if (!loginOutEl) {
        continue;
      }
      if (((_i = loginOutEl.textContent) == null ? void 0 : _i.trim()) == "退出会话") {
        await click_button(loginOutEls[i]);
        sendLog("退出会话");
        console.log("退出会话");
      }
    }
  }
};
function compareHalves(str) {
  if (!str) {
    return str;
  }
  const length = str.length;
  if (length % 2 !== 0) {
    return str;
  }
  const halfLength = length / 2;
  const firstHalf = str.slice(0, halfLength);
  const secondHalf = str.slice(halfLength);
  return firstHalf === secondHalf ? firstHalf : str;
}
const getUserSendReplyContent = async () => {
  var _a;
  if (!(await checkDomPromise("#messageContent >div >div"))) {
    sendLog("没有找到 #messageContent >div >div");
    return;
  }
  const messageContentList = Array.from(document.querySelectorAll("#messageContent >div >div"));
  let textContentTotal = "";
  for (let j = 0; j < messageContentList.length; j++) {
    let textContentBool = false;
    console.log("messageContentList[j]", messageContentList[j]);
    const messageContent = messageContentList[j];
    const divList = Array.from(messageContent.querySelectorAll(":scope >div"));
    console.log("divList", divList);
    if (!divList || divList.length == 0) {
      continue;
    }
    if (divList && divList.length >= 1) {
      for (let i = 0; i < divList.length; i++) {
        const computedStyle = window.getComputedStyle(divList[i]);
        const justifyContentValue = computedStyle.getPropertyValue("justify-content");
        if (justifyContentValue) {
          if (justifyContentValue == "space-between") {
            console.log(`元素 ${divList[i].tagName} 存在 justify-content 样式，值为: ${justifyContentValue}`);
            let textContent = (_a = divList[i].textContent) == null ? void 0 : _a.trim();
            console.log("textContent", textContent);
            if (textContent && textContent == "我发布了新作品，快来看看！") {
              textContentBool = true;
              continue;
            }
            textContentBool = true;
            textContent = textContent == null ? void 0 : textContent.replace("点赞点赞回复删除", "");
            textContent = textContent == null ? void 0 : textContent.replace("点赞回复删除", "");
            textContent = compareHalves(textContent);
            textContentTotal += textContent;
          } else {
            console.log("justifyContentValue 不是 space-between", justifyContentValue);
          }
        } else {
          console.log(`元素 ${divList[i].tagName} 不存在 justify-content 样式`);
        }
      }
    }
    if (!textContentBool) {
      break;
    }
  }
  sendLog("textContentTotal: " + textContentTotal);
  return textContentTotal;
};
const update_Private_userId = async (key, bucket) => {
  const user_list_key = store$1.userId + "_" + store$1.webUserId + "_douYin_web_user_list";
  const postDataObj = {
    "key": key,
    "bucket": bucket,
    "size": 0,
    "content_type": "",
    "belong_to": user_list_key,
    "object_metadata": {}
  };
  await addObjects(postDataObj);
};
const get_PrivateMessage_userId = async (avatarPath, zuoZhiText, webUserId = "") => {
  try {
    const user_list_key = store$1.userId + "_" + store$1.webUserId + "_douYin_web_user_list";
    const userData = {
      key: "",
      webUserId: "",
      userId: "",
      bucket: {}
    };
    let userRes = null;
    if (webUserId) {
      userRes = await queryObjects([{
        key: "belong_to",
        value: user_list_key
      }, {
        key: "friendsUserId",
        value: store$1.webUserId
      }, {
        key: "webUserId",
        value: webUserId
      }]);
      console.log("queryObjects userRes", userRes);
    } else {
      userRes = await queryObjects([{
        key: "belong_to",
        value: user_list_key
      }, {
        key: "friendsUserId",
        value: store$1.webUserId
      }, {
        key: "avatarPath",
        value: avatarPath
      }]);
      console.log("queryObjects userRes", userRes);
    }
    if ((userRes == null ? void 0 : userRes.items) && (userRes == null ? void 0 : userRes.items.length) == 0) {
      userRes = await queryObjects([{
        key: "belong_to",
        value: user_list_key
      }, {
        key: "friendsUserId",
        value: store$1.webUserId
      }, {
        key: "avatarPath",
        value: avatarPath
      }]);
      console.log("queryObjects userRes", userRes);
    }
    if ((userRes == null ? void 0 : userRes.items) && (userRes == null ? void 0 : userRes.items.length) == 0) {
      userRes = await queryObjects([{
        key: "belong_to",
        value: user_list_key
      }, {
        key: "friendsUserId",
        value: store$1.webUserId
      }, {
        key: "userName",
        value: zuoZhiText
      }]);
      if ((userRes == null ? void 0 : userRes.items.length) > 1) {
        sendLog(`使用 zuoZhiText:${zuoZhiText}查询到的数据条数大于1：` + (userRes == null ? void 0 : userRes.items.length));
      }
    } else {
      if ((userRes == null ? void 0 : userRes.items.length) > 1) {
        sendLog(`使用 avatarPath:${avatarPath}查询到的数据条数大于1：` + (userRes == null ? void 0 : userRes.items.length));
      }
    }
    if ((userRes == null ? void 0 : userRes.items) && (userRes == null ? void 0 : userRes.items.length) == 0) {
      userData["userId"] = "douYin" + (/* @__PURE__ */new Date()).getTime();
      const key = "douYin_web_user_list_" + (/* @__PURE__ */new Date()).getTime();
      const postDataObj = {
        "key": key,
        "bucket": {
          // 自定义的用户Id
          userId: userData["userId"],
          // 评论或私信的用户Id
          webUserId,
          // 网站登录的用户Id
          friendsUserId: store$1.webUserId,
          // 评论作者名称
          userName: zuoZhiText,
          // 评论头像地址
          avatarPath
        },
        "size": 0,
        "content_type": "",
        "belong_to": user_list_key,
        "object_metadata": {}
      };
      userData["key"] = postDataObj["key"];
      userData["webUserId"] = postDataObj["bucket"]["webUserId"];
      userData["userId"] = postDataObj["bucket"]["userId"];
      userData["bucket"] = postDataObj["bucket"];
      await addObjects(postDataObj);
    } else {
      const item = userRes == null ? void 0 : userRes.items[0];
      userData["key"] = item["key"];
      if (item["bucket"] && item["bucket"]["webUserId"]) {
        userData["webUserId"] = item["bucket"]["webUserId"];
        userData["bucket"] = item["bucket"];
      }
      if (item["bucket"] && item["bucket"]["userId"]) {
        userData["userId"] = item["bucket"]["userId"];
        userData["bucket"] = item["bucket"];
      }
    }
    return userData;
  } catch (error) {
    sendLog("获取用户id错误");
    return {
      key: "",
      webUserId: "",
      userId: "",
      bucket: {}
    };
  }
};
const query_user_chat_num = async contentUserId => {
  console.log("query_user_chat_num userId" + contentUserId);
  let userRes = await queryObjects([{
    key: "belong_to",
    value: store$1.userId + "_douYinList"
  }, {
    key: "contentUserId",
    value: contentUserId
  }, {
    key: "replyType",
    value: "first"
  }]);
  console.log("queryObjects userRes", userRes);
  if (userRes && (userRes == null ? void 0 : userRes.items) && (userRes == null ? void 0 : userRes.items.length) > 0) {
    return false;
  }
  return true;
};
const handler_PrivateMessage_Stranger_list = async () => {
  var _a;
  sendLog("私信陌生人，滚动到容器的顶部");
  await findFirstMessageToScroll();
  const listDlg = Array.from(document.querySelectorAll('div[data-e2e="listDlg-container"]>div:nth-child(2) >div >div'));
  let container = document.querySelector('div[data-e2e="listDlg-container"] > div:nth-child(2)');
  for (let i = 0; i < listDlg.length; i++) {
    const dlg = listDlg[i];
    if (!dlg) {
      continue;
    }
    const divEl = dlg.querySelector(":scope >div");
    if (divEl) {
      ensureElementVisible(divEl, container);
    }
    console.log("dlg", dlg);
    const zuoZhiEl = dlg.querySelector(":scope >div >div>div:nth-child(2) >div:nth-child(1)");
    await delay(300);
    let zuoZhiText = "";
    if (zuoZhiEl) {
      zuoZhiText = (_a = zuoZhiEl.textContent) == null ? void 0 : _a.trim();
      sendLog("作者名称 zuoZhiText：" + zuoZhiText);
      if (zuoZhiText == "陌生人消息") {
        const clickDiv = dlg.querySelector("pre");
        if (clickDiv) {
          await click_button(clickDiv);
        }
        await delay(1e3);
        await handler_PrivateMessage_Stranger();
        break;
      }
    } else {
      sendLog("陌生人的作者zuoZhiEl为空");
    }
  }
};
const handler_PrivateMessage_Stranger = async () => {
  var _a, _b, _c, _d, _e;
  sendLog("开始处理陌生人消息 handler_PrivateMessage_Stranger");
  if (!(await checkDomPromise('div[data-e2e="listDlg-container"]>div:nth-child(2) >div >div'))) {
    sendLog('没有查到 div[data-e2e="listDlg-container"]>div:nth-child(2) >div >div');
    return;
  }
  await findFirstMessageToScroll();
  const listDlgList = document.querySelectorAll('div[data-e2e="listDlg-container"]>div:nth-child(2) >div >div');
  let container = document.querySelector('div[data-e2e="listDlg-container"] > div:nth-child(2)');
  for (let i = 0; i < listDlgList.length; i++) {
    const listDlg = listDlgList[i];
    console.log("listDlg", listDlg);
    if (!listDlg) {
      sendLog("不存在 listDlg");
      continue;
    }
    if (listDlg) {
      ensureElementVisible(listDlg, container);
    }
    const hongDianEl = listDlg.querySelector("div >div>div:nth-child(3)");
    if (!hongDianEl) {
      sendLog("红点不存在");
      continue;
    }
    const messageData = {};
    messageData["source"] = "抖音";
    messageData["clueType"] = "私信陌生人";
    const zuoZhiEl = listDlg.querySelector(":scope >div >div>div:nth-child(2) >div:nth-child(1)");
    let zuoZhiText = "";
    if (zuoZhiEl) {
      const zuoZhiText2 = (_a = zuoZhiEl.textContent) == null ? void 0 : _a.trim();
      console.log("zuoZhiText2", zuoZhiText2);
      if (zuoZhiText2) {
        zuoZhiText = zuoZhiText2;
      }
    }
    const preEl = listDlg.querySelector("pre");
    if (preEl) {
      const preText = (_b = preEl.textContent) == null ? void 0 : _b.trim();
      console.log("preText", preText);
      messageData["content"] = preText;
    }
    const timeEl = listDlg.querySelector(":scope >div >div>div:nth-child(2) >div:nth-child(2) >div:nth-child(2)");
    if (timeEl) {
      const timeText = (_c = timeEl.textContent) == null ? void 0 : _c.trim();
      console.log("timeText", timeText);
      messageData["timeText"] = timeText;
    }
    const avatarImgEl = listDlg.querySelector("img");
    let avatarPath = "";
    let avatarUrl = "";
    if (avatarImgEl) {
      avatarUrl = avatarImgEl.src;
      if (avatarUrl) {
        try {
          if (avatarUrl.startsWith("//")) {
            avatarUrl = "https:" + avatarUrl;
          }
          const avatarURL = new URL(avatarUrl);
          avatarPath = avatarURL.pathname;
          if (avatarPath) {
            avatarPath = getLastPathName$1(avatarPath);
          } else {
            sendLog("用户头像为空，pathname:" + avatarPath);
          }
        } catch (error) {
          sendLog("用户头像为空 url 错误 " + avatarUrl);
        }
      } else {
        sendLog("用户头像的地址不是Url:" + avatarUrl);
      }
    } else {
      sendLog("没有找到用户头像");
    }
    messageData["userName"] = zuoZhiText;
    messageData["avatar"] = avatarUrl;
    messageData["avatarPath"] = avatarPath;
    const clickDiv = listDlg.querySelector('div[data-e2e="conversation-item"]>div >div:nth-child(2)');
    if (!clickDiv) {
      sendLog("没有找到 clickDiv:");
      continue;
    }
    await click_button(clickDiv);
    await delay(1e3);
    const preText3 = await getUserSendReplyContent();
    if (preText3) {
      messageData["content"] = preText3;
    }
    const date = /* @__PURE__ */new Date();
    const year = date.getFullYear();
    const month = String(date.getMonth() + 1).padStart(2, "0");
    const day = String(date.getDate()).padStart(2, "0");
    const hours = String(date.getHours()).padStart(2, "0");
    const minutes = String(date.getMinutes()).padStart(2, "0");
    messageData["createDate"] = `${year}-${month}-${day} ${hours}:${minutes}`;
    messageData["addTime"] = (/* @__PURE__ */new Date()).getTime();
    messageData["tenantId"] = store$1.tenantId;
    messageData["userId"] = store$1.userId;
    messageData["agentId"] = VITE_AGENT_ID;
    messageData["taskId"] = store$1.taskId;
    messageData["executeId"] = store$1.executeId;
    messageData["terminalId"] = (_d = store$1.terminalData) == null ? void 0 : _d.terminalId;
    messageData["webUserId"] = store$1.webUserId;
    messageData["webUserName"] = store$1.webUserName;
    if (messageData && messageData["content"]) {
      store$1.setContentText(messageData["content"]);
      const textContent = messageData["content"];
      const contentArray = Array.from(textContent);
      sendLog("contentArray:" + contentArray.length);
      const phoneNums = extractPhoneNumbers(textContent);
      sendLog("extractPhoneNumbers:" + JSON.stringify({
        phoneNums,
        textContent
      }));
      const optionWhere = store$1.getOptionWhere();
      let replayBoolean = false;
      replayBoolean = true;
      sendLog("phoneNums:" + phoneNums);
      if (phoneNums.length > 0) {
        messageData["contactInformation"] = phoneNums[0];
        messageData["contactInformationBool"] = 1;
      }
      if (replayBoolean) {
        chrome.storage.local.set({
          "douYinDataList": JSON.stringify(messageData)
        });
        const userData = await get_PrivateMessage_userId(avatarPath, zuoZhiText);
        let userFirstCommentBool = false;
        if (optionWhere.enableFirstReplyBool) {
          sendLog("使用软件程序进行 私信建立回复话术");
          userFirstCommentBool = await query_user_chat_num(userData["userId"]);
        }
        messageData["contentWebUserId"] = userData["webUserId"];
        messageData["contentUserId"] = userData["userId"];
        if (userFirstCommentBool) {
          if (optionWhere.enableFirstReplyBool && (optionWhere.phoneNumberReplyContent || optionWhere.phoneNumberReplyContent1 || optionWhere.phoneNumberReplyContent3)) {
            const chatList = [{
              // 发送id
              "sender": userData["webUserId"] ? userData["webUserId"] : userData["userId"],
              // 发送人的名称
              "sender_name": messageData["userName"],
              "sender_avatar": messageData["avatar"],
              // 接收人id
              "receiver": store$1.webUserId,
              // 接收人的id
              "receiver_name": store$1.webUserName,
              "receiver_avatar": store$1.webUserAvatarUrl,
              // 发送内容
              "content": messageData["content"]
            }];
            if (optionWhere.phoneNumberReplyContent1) {
              await replyContent_PrivateMessage(optionWhere.phoneNumberReplyContent1);
              await delay(getRandomNumberInRange(3e3, 5e3));
              chatList.push({
                // 发送id
                "sender": store$1.webUserId,
                // 发送人的名称
                "sender_name": store$1.webUserName,
                "sender_avatar": store$1.webUserAvatarUrl,
                // 接收人id
                "receiver": userData["webUserId"] ? userData["webUserId"] : userData["userId"],
                // 接收人的id
                "receiver_name": messageData["userName"],
                "receiver_avatar": messageData["avatar"],
                // 发送内容
                "content": optionWhere.phoneNumberReplyContent1
              });
              store$1.setReplyComment(optionWhere.phoneNumberReplyContent1);
            }
            if (optionWhere.phoneNumberReplyContent) {
              await replyContent_PrivateMessage(optionWhere.phoneNumberReplyContent);
              await delay(getRandomNumberInRange(3e3, 5e3));
              chatList.push({
                // 发送id
                "sender": store$1.webUserId,
                // 发送人的名称
                "sender_name": store$1.webUserName,
                "sender_avatar": store$1.webUserAvatarUrl,
                // 接收人id
                "receiver": userData["webUserId"] ? userData["webUserId"] : userData["userId"],
                // 接收人的id
                "receiver_name": messageData["userName"],
                "receiver_avatar": messageData["avatar"],
                // 发送内容
                "content": optionWhere.phoneNumberReplyContent
              });
              store$1.setReplyComment(optionWhere.phoneNumberReplyContent);
            }
            if (optionWhere.phoneNumberReplyContent3) {
              await replyContent_PrivateMessage(optionWhere.phoneNumberReplyContent3);
              chatList.push({
                // 发送id
                "sender": store$1.webUserId,
                // 发送人的名称
                "sender_name": store$1.webUserName,
                "sender_avatar": store$1.webUserAvatarUrl,
                // 接收人id
                "receiver": userData["webUserId"] ? userData["webUserId"] : userData["userId"],
                // 接收人的id
                "receiver_name": messageData["userName"],
                "receiver_avatar": messageData["avatar"],
                // 发送内容
                "content": optionWhere.phoneNumberReplyContent3
              });
              store$1.setReplyComment(optionWhere.phoneNumberReplyContent3);
            }
            await delay(getRandomNumberInRange(2 * 1e3, 10 * 1e3));
            messageData["replyText"] = optionWhere.phoneNumberReplyContent;
            messageData["replyType"] = "first";
            await delay(1e3);
            const key = "handler_PrivateMessage_Stranger_" + (/* @__PURE__ */new Date()).getTime();
            const postDataObj = {
              "key": key,
              "bucket": messageData,
              "size": 0,
              "content_type": "",
              "belong_to": store$1.userId + "_douYinList",
              "object_metadata": {}
            };
            await addObjects(postDataObj);
            await saveChat({
              "session": {
                // 登录网站用户id
                "account_id": store$1.webUserId,
                // 视频名称
                "video_name": "",
                // 视频地址
                "video_url": "",
                // 会话来源，通知和私信
                "source": "私信"
              },
              "chat_list": chatList
            });
          } else {
            sendLog("第一次 没有回复的内容");
          }
        } else {
          sendLog("第二次回复 调用对话，获取回复内容");
          const msgItemContentListEl = Array.from(document.querySelectorAll('div[data-e2e="msg-item-content"]'));
          const textContentList = [];
          for (let j = 0; j < msgItemContentListEl.length; j++) {
            const textContent2 = (_e = msgItemContentListEl[0].textContent) == null ? void 0 : _e.trim();
            if (textContent2 && textContent2 != messageData["content"]) {
              textContentList.push(textContent2);
            }
          }
          console.log("textContentList：", textContentList);
          let contentText = await getCorpusContentText(messageData);
          if (contentText == "已经取得联系方式") {
            sendLog("已经取得联系方式 不在回复");
            contentText = "收到，我们会尽快联系您。";
          }
          if (optionWhere.keFuNullReplyContent && !contentText) {
            contentText = optionWhere.keFuNullReplyContent;
            sendLog("回复的内容为空，使用兜底的回复内容， keFuNullReplyContent：" + optionWhere.keFuNullReplyContent);
            messageData["keFuNullReplyContent"] = "yes";
          }
          if (!contentText) {
            sendLog("回复的内容为空，不需要回复");
          } else {
            sendLog("回复的内容：" + contentText);
            messageData["replyText"] = contentText;
            messageData["replyType"] = "second";
            await replyContent_PrivateMessage(contentText);
            store$1.setReplyComment(contentText);
            await delay(1e3);
            const key = "handler_PrivateMessage_Stranger_" + (/* @__PURE__ */new Date()).getTime();
            const postDataObj = {
              "key": key,
              "bucket": messageData,
              "size": 0,
              "content_type": "",
              "belong_to": store$1.userId + "_douYinList",
              "object_metadata": {}
            };
            await addObjects(postDataObj);
            const chatList = [{
              // 发送id
              "sender": userData["webUserId"] ? userData["webUserId"] : userData["userId"],
              // 发送人的名称
              "sender_name": messageData["userName"],
              "sender_avatar": messageData["avatar"],
              // 接收人id
              "receiver": store$1.webUserId,
              // 接收人的id
              "receiver_name": store$1.webUserName,
              "receiver_avatar": store$1.webUserAvatarUrl,
              // 发送内容
              "content": messageData["content"]
            }, {
              // 发送id
              "sender": store$1.webUserId,
              // 发送人的名称
              "sender_name": store$1.webUserName,
              "sender_avatar": store$1.webUserAvatarUrl,
              // 接收人id
              "receiver": userData["webUserId"] ? userData["webUserId"] : userData["userId"],
              // 接收人的id
              "receiver_name": messageData["userName"],
              "receiver_avatar": messageData["avatar"],
              // 发送内容
              "content": contentText
            }];
            await saveChat({
              "session": {
                // 登录网站用户id
                "account_id": store$1.webUserId,
                // 视频名称
                "video_name": "",
                // 视频地址
                "video_url": "",
                // 会话来源，通知和私信
                "source": "私信"
              },
              "chat_list": chatList
            });
          }
        }
      } else {
        sendLog("replayBoolean && replyContentText 不为真：" + replayBoolean + ", optionWhere.enableFirstReplyBool" + optionWhere.enableFirstReplyBool + "-" + JSON.stringify([optionWhere.phoneNumberReplyContent, optionWhere.phoneNumberReplyContent1, optionWhere.phoneNumberReplyContent3]));
      }
    } else {
      sendLog("messageData && messageData['content']:" + messageData && messageData["content"]);
    }
  }
  const backButtonEl = document.querySelector('div[data-e2e="listDlg-container"] svg[fill="none"]');
  if (backButtonEl) {
    await click_button(backButtonEl);
  }
  await delay(1e3);
};
const getContentUrl = async messageData => {
  var _a, _b;
  if (!(await checkDomPromise('div[data-e2e="comment-list"] div[data-e2e="comment-item"]'))) {
    sendLog('没有找到 div[data-e2e="comment-list"] div[data-e2e="comment-item"]');
    return;
  }
  const commentItemList = document.querySelectorAll('div[data-e2e="comment-list"] div[data-e2e="comment-item"]');
  if (!commentItemList || commentItemList.length == 0) {
    sendLog("commentItemList 没有找到列表");
    return;
  }
  const commentItemContentEl = commentItemList[0].querySelector(":scope >div:nth-child(2) >div >div:nth-child(3)");
  if (!commentItemContentEl) {
    sendLog("commentItemContentEl 没有找到评论内容");
    return;
  }
  let textContent = (_a = commentItemContentEl.textContent) == null ? void 0 : _a.trim();
  sendLog("getContentUrl textContent：" + textContent);
  let replayBoolean = false;
  let replyContentText = "";
  if (textContent) {
    const contentArray = Array.from(textContent);
    sendLog("contentArray: " + contentArray.length + "," + JSON.stringify(contentArray));
    const phoneNums = extractPhoneNumbers(textContent);
    const optionWhere = store$1.getOptionWhere();
    if (optionWhere && optionWhere.wordWhereNum && contentArray.length >= optionWhere.wordWhereNum && contentArray.length <= optionWhere.wordWhereNumEnd && optionWhere.wordReplyContent) {
      replayBoolean = true;
      replyContentText = optionWhere.wordReplyContent;
      sendLog("字数评论");
    }
    sendLog("replayBoolean," + replayBoolean + "，phoneNums:" + phoneNums + ",optionWhere:" + JSON.stringify(optionWhere) + ", replyContentText:" + replyContentText);
    if (replayBoolean && replyContentText) {
      chrome.storage.local.set({
        "douYinDataList": JSON.stringify(messageData)
      });
      sendLog("开始回复评论的内容，replyContentText：" + replyContentText);
      await replyContent(commentItemList[0], replyContentText);
    } else {
      sendLog("replayBoolean && replyContentText 不是真");
    }
  }
  const avatarAEl = commentItemList[0].querySelector(":scope >div.comment-item-avatar a");
  if (avatarAEl) {
    let href = avatarAEl.getAttribute("href");
    console.log("href", href);
    if (href) {
      if (href.startsWith("//")) {
        href = "https:" + href;
      }
      const pathname = new URL(href).pathname;
      console.log("pathname", pathname);
    }
  }
  const videoDescEl = document.querySelector('div[data-e2e="video-desc"]');
  let videoDesc = "";
  if (videoDescEl) {
    videoDesc = (_b = videoDescEl.textContent) == null ? void 0 : _b.trim();
  }
  const contentUrl = window.location.href;
  sendLog("contentUrl：" + contentUrl);
  let backButton = document.querySelector('span[role="img"] path[stroke="currentColor"]');
  if (backButton) {
    await click_button(backButton);
  }
  backButton = document.querySelector("#douyin-right-container >div >div:nth-child(1).isDark");
  if (backButton) {
    await click_button(backButton);
  }
  if (!backButton) {
    sendLog("没有 backButton");
  }
  return {
    contentUrl,
    videoDesc: videoDesc ? videoDesc : "",
    replyContentText,
    replayBoolean
  };
};
const replyContent = async (commentItem, content) => {
  var _a, _b;
  sendLog("进入到 replyContent");
  const replyButton = commentItem.querySelector('.comment-item-stats-container div[tabindex="0"] > div');
  if (replyButton) {
    ensureElementVisible(replyButton);
    await click_button(replyButton);
  } else {
    sendLog("没有 replyButton");
    return;
  }
  if (!(await checkDomPromise(".comment-input-container >div:nth-child(2) >div:nth-child(1)"))) {
    sendLog("是否存在回复按钮中 .comment-input-container >div:nth-child(2) >div:nth-child(1)");
  }
  const replyClickButton = commentItem.querySelector('.comment-item-stats-container div[tabindex="0"] > div');
  if (replyClickButton) {
    const replyText = (_a = replyClickButton.textContent) == null ? void 0 : _a.trim();
    if (replyText == "回复中") {
      sendLog("replyText：" + replyText);
    }
  }
  sendLog("douYin_send_comments");
  await delay(getRandomNumberInRange(1e3, 5e3));
  if (store$1.isNotRunWork()) {
    return;
  }
  if (!(await checkDomPromise("#merge-all-comment-container .comment-input-inner-container >div:nth-child(1)"))) {
    sendLog("没有找到 #content-textarea");
    return;
  }
  const comment_input_el = document.querySelector("#merge-all-comment-container .comment-input-inner-container >div:nth-child(1)");
  if (!comment_input_el) {
    sendLog("没有找到输入评论的输入框");
    return;
  }
  await click_button(comment_input_el);
  if (!(await checkDomPromise(".notranslate.public-DraftEditor-content"))) {
    sendLog("没有找到 #content-textarea");
    return;
  }
  const targetElement = document.querySelector(".notranslate.public-DraftEditor-content");
  if (!targetElement) {
    sendLog("没有找到输入框");
    return;
  }
  if (targetElement) {
    sendLog("执行 targetElement：" + store$1.chromeTabId);
    sendLog("addListener(queryActiveElement)");
    chrome.runtime.onMessage.addListener((request2, sender2, sendResponse2) => queryActiveElement(request2, sender2, sendResponse2, ".notranslate.public-DraftEditor-content"));
    await simulateInputSendMessage(content, 200, true, false);
    chrome.runtime.onMessage.removeListener((request2, sender2, sendResponse2) => queryActiveElement(request2, sender2, sendResponse2, ".notranslate.public-DraftEditor-content"));
  } else {
    sendLog("Target element not found.");
  }
  if (store$1.isNotRunWork()) {
    return;
  }
  const sendButtonQuerySelector = ".commentInput-right-ct path";
  if (!(await checkDomPromise(sendButtonQuerySelector))) {
    sendLog("没有找到 #content-textarea");
    return;
  }
  let submit = null;
  let indexNum = 0;
  while (true) {
    if (indexNum > 60) {
      break;
    }
    if (indexNum > 1) {
      console.log("indexNum", indexNum++);
      await delay(1e3);
    }
    indexNum++;
    const submitList = Array.from(document.querySelectorAll(sendButtonQuerySelector));
    for (let i = 0; i < submitList.length; i++) {
      const submitTemp = submitList[i];
      if (submitTemp) {
        const fill = submitTemp.getAttribute("fill");
        if (fill == "#FE2C55") {
          submit = submitTemp;
          sendLog("通过  #FE2C55 找到了submit");
          break;
        }
        const fillrule = submitTemp.getAttribute("fill-rule");
        const fillOpacity = submitTemp.getAttribute("fill-opacity");
        if (fillrule == "evenodd" && !fillOpacity) {
          submit = submitTemp;
          sendLog("通过 evenodd fillOpacity 找到了submit ");
          break;
        }
        const names = submitTemp.getAttributeNames();
        if (names) {
          const nameValue = [];
          names.forEach(name => {
            nameValue.push(name + ":" + submitTemp.getAttribute(name));
          });
          sendLog("submitList nameValue :" + nameValue.join(","));
        }
      }
    }
    if (submit) {
      break;
    }
  }
  if (!submit) {
    sendLog("点击发表评论失败");
    return;
  }
  await click_button(submit);
  indexNum = 0;
  while (true) {
    if (indexNum > 60) {
      break;
    }
    if (indexNum > 1) {
      console.log("indexNum", indexNum++);
      await delay(1e3);
    }
    indexNum++;
    const response_text_el = document.querySelector(".public-DraftEditor-content > div > div > div > span:nth-child(1)");
    if (!response_text_el) {
      sendLog("没有找到输入框");
      continue;
    }
    let response_text = ((_b = response_text_el.textContent) == null ? void 0 : _b.trim()) || "";
    if (response_text) {
      sendLog("输入框不为空");
      continue;
    }
    break;
  }
  await delay(getRandomNumberInRange(2 * 1e3, 10 * 1e3));
  sendLog("回复成功");
};
const replyContent_PrivateMessage = async (content, sendButtonQuerySelector = 'div[data-e2e="msg-input"] path[fill="#FE2C55"]') => {
  var _a;
  sendLog("进入到replyContent_PrivateMessage");
  if (!(await checkDomPromise(".notranslate.public-DraftEditor-content"))) {
    sendLog("没有找到 #content-textarea");
    return;
  }
  const comment_input_el = document.querySelector(".notranslate.public-DraftEditor-content");
  if (!comment_input_el) {
    sendLog("没有找到输入评论的输入框");
    return;
  }
  await click_button(comment_input_el);
  const targetElement = document.querySelector(".notranslate.public-DraftEditor-content");
  if (!targetElement) {
    sendLog("没有找到输入框");
    return;
  }
  if (targetElement) {
    sendLog("执行 targetElement：" + store$1.chromeTabId);
    sendLog("addListener(queryActiveElement)");
    chrome.runtime.onMessage.addListener((request2, sender2, sendResponse2) => queryActiveElement(request2, sender2, sendResponse2, ".notranslate.public-DraftEditor-content"));
    await simulateInputSendMessage(content, 200, true, false);
    chrome.runtime.onMessage.removeListener((request2, sender2, sendResponse2) => queryActiveElement(request2, sender2, sendResponse2, ".notranslate.public-DraftEditor-content"));
  } else {
    sendLog("Target element not found.");
  }
  if (store$1.isNotRunWork()) {
    return;
  }
  if (!(await checkDomPromise(sendButtonQuerySelector))) {
    sendLog("没有找到 #content-textarea");
    return;
  }
  const submit = document.querySelector(sendButtonQuerySelector);
  if (!submit) {
    sendLog("点击发表评论失败");
    return;
  }
  await click_button(submit);
  let indexNum = 0;
  while (true) {
    if (indexNum > 60) {
      break;
    }
    if (indexNum > 1) {
      console.log("indexNum", indexNum++);
      await delay(1e3);
    }
    indexNum++;
    const response_text_el = document.querySelector(".public-DraftEditor-content > div > div > div > span:nth-child(1)");
    if (!response_text_el) {
      sendLog("没有找到输入框");
      continue;
    }
    let response_text = ((_a = response_text_el.textContent) == null ? void 0 : _a.trim()) || "";
    if (response_text) {
      sendLog("输入框不为空");
      continue;
    }
    break;
  }
  sendLog("回复成功");
};
const saveTerminalWebUserName = async () => {
  var _a, _b;
  if (!((_a = store$1 == null ? void 0 : store$1.terminalData) == null ? void 0 : _a.terminalId)) {
    sendLog("终端的id为空");
    return;
  }
  const saveTerminalBindData = {
    "terminal_name": store$1.webUserName ? store$1.webUserName : "请设置设备名称",
    "terminal_info": {
      "webUserName": store$1.webUserName,
      "webUserAvatarUrl": store$1.webUserAvatarUrl,
      "webUserId": store$1.webUserId
    }
  };
  const saveTerminalBindRes = await saveTerminalBind((_b = store$1 == null ? void 0 : store$1.terminalData) == null ? void 0 : _b.terminalId, saveTerminalBindData);
  sendLog("agentBusiness saveTerminalBindRes：" + JSON.stringify(saveTerminalBindRes));
};
const store = UseCounterStore.getInstance();
let XiaoHongShu_Setting = JSON.parse(store.XiaoHongShu_Setting);
chrome.runtime.onMessage.addListener(async (request, sender, sendResponse) => {
  console.log(`Tab 激活了。`, sender, request);
  if ((request == null ? void 0 : request.messageType) === "tabChange") {
    if (!request.status) ;
    if (request.tabId != store.chromeTabId) {
      console.log("当前tab不是激活tab了");
      const tabInfo = await getActivateTabId();
      if (tabInfo) {
        console.log("当前激活tab", tabInfo);
      }
    }
    sendResponse("收到消息");
    return false;
  }
});
storageUtil.startOnChangedListener();
let checkInterval = null;
function distributingTasks() {
  sendLog("开始任务distributingTasks start");
  closeTabListener();
  store.setXiaoHongShu_workStatus("run");
  let runBool = false;
  if (checkInterval) {
    clearInterval(checkInterval);
    checkInterval = null;
  }
  checkInterval = setInterval(async () => {
    var _a;
    if (runBool) {
      return;
    }
    runBool = true;
    try {
      await store.checkLoadend();
      clearInterval(checkInterval);
      checkInterval = null;
      sendLog("开始任务distributingTasks");
      if (!XiaoHongShu_Setting || Object.keys(XiaoHongShu_Setting).length == 0) {
        XiaoHongShu_Setting = JSON.parse(store.XiaoHongShu_Setting);
      }
      if (store.isNotRunWork()) {
        vipCloseEndFun("distributingTasks").then();
        return;
      }
      const taskData = await getTabTaskData();
      store.setChromeTabId(taskData == null ? void 0 : taskData.tabId);
      const taskPlatform = (_a = taskData == null ? void 0 : taskData.tabData) == null ? void 0 : _a.taskPlatform;
      console.log("chromeTabId :" + (taskData == null ? void 0 : taskData.tabId) + "，taskPlatform：" + taskPlatform);
      sendLog("chromeTabId :" + (taskData == null ? void 0 : taskData.tabId) + "，taskPlatform：" + taskPlatform);
      console.log("Running your code");
      store.setXiaoHongShu_workStatus("run");
      if (taskPlatform == "小红书") {
        runYourCode();
      }
      if (taskPlatform == "抖音") {
        douYin_RunYourCode();
      }
    } catch (error) {
      console.log("distributingTasks error", error);
    } finally {
      runBool = false;
    }
  }, 1e3);
  setTimeout(() => {
    clearInterval(checkInterval);
    checkInterval = null;
    console.log("Finished checking login status.");
  }, 10 * 60 * getRandomNumberInRange(1e3, 5e3));
}
console.log("Content script loaded:", window.location.href);
if (document.readyState === "complete" || document.readyState === "interactive") {
  console.log("Document already loaded", document.readyState);
  distributingTasks();
}