var __defProp = Object.defineProperty;
var __defNormalProp = (obj, key, value) => key in obj ? __defProp(obj, key, {
  enumerable: true,
  configurable: true,
  writable: true,
  value
}) : obj[key] = value;
var __publicField = (obj, key, value) => __defNormalProp(obj, typeof key !== "symbol" ? key + "" : key, value);
import { _ as _export_sfc } from "./js-_plugin-vue_export-helper.js";
import { d as defineComponent, r as ref, k as inject, c as createElementBlock, o as openBlock, a as createBaseVNode, P as toDisplayString, u as unref, G as createCommentVNode, Q as normalizeStyle, M as createVNode, J as createBlock, al as createApp } from "./js-@vue.js";
import { g as getLocalizedMessage, s as setLocale } from "./js-i18n.js";
import { c as createPinia, d as defineStore, s as setActivePinia } from "./js-pinia.js";
import { i as indexPage } from "./js-indexConfig.js";
import { E as ElMessageBox } from "./js-element-plus.js";
import "./js-dayjs.js";
import "./js-clientjs.js";
import "./js-lodash-es.js";
import "./js-@vueuse.js";
import "./js-async-validator.js";
import "./js-@element-plus.js";
import "./js-@popperjs.js";
import "./js-normalize-wheel-es.js";
import "./js-memoize-one.js";
import "./js-@ctrl.js";
const _sfc_main$5 = {};
function _sfc_render(_ctx, _cache) {
  return null;
}
const XiaoHongShu_small_icon = /* @__PURE__ */_export_sfc(_sfc_main$5, [["render", _sfc_render]]);
const pinia = createPinia();
function sendLog(...messages) {
  const combinedMessage = messages.map(String).join(" ");
  {
    chrome.runtime.sendMessage({
      action: "logs",
      message: combinedMessage
    }).then(() => {}).catch(err => {
      console.error(err);
    });
  }
}
const useCounterStore = defineStore("counter", {
  state: () => ({
    //当前页面
    activatePage: indexPage,
    //配置
    XiaoHongShu_Setting: "{}",
    //评论数量
    viewCount: 0,
    CommentCount: 0,
    likeCount: 0,
    followCount: 0,
    collectCount: 0,
    //评论数量
    xhs_viewCount: 0,
    xhs_CommentCount: 0,
    xhs_likeCount: 0,
    xhs_followCount: 0,
    xhs_collectCount: 0,
    //评论数量
    dy_viewCount: 0,
    dy_CommentCount: 0,
    dy_likeCount: 0,
    dy_followCount: 0,
    dy_collectCount: 0,
    //工作状态
    // run：工作中
    // end: 已结束（到达底部）
    XiaoHongShu_workStatus: "run",
    loadend: false,
    loadFromStorage_load: false,
    isDebugMode: false,
    operationTime: 0,
    xiaoHongShuAccountErrorTip: "",
    //客户端id
    clientVisitorId: "",
    executeOperationStartTime: "",
    chromeTabId: 0,
    taskPlatform: "",
    xhs_minute: [],
    dy_minute: [],
    refreshFrequencyNum: 60 * 60 * 1e3,
    stopButtonText: "",
    formattedTime: ""
  }),
  actions: {
    setActivatePage(page) {
      this.activatePage = page;
      sendLog("contentPage activatePage：", page);
      chrome.storage.local.set({
        "activatePage": this.activatePage
      });
    },
    setCopy() {
      chrome.storage.local.set({
        "copy": "" + (/* @__PURE__ */new Date()).getTime()
      });
    },
    setChromeTabId(chromeTabId) {
      this.chromeTabId = chromeTabId;
    },
    getChromeTabId() {
      return this.chromeTabId;
    },
    setTaskPlatform(taskPlatform) {
      this.taskPlatform = taskPlatform;
    },
    addXHSCommentMinuteCount(xhs_minute) {
      this.xhs_minute.push(xhs_minute);
      chrome.storage.local.set({
        "xhs_minute": JSON.stringify(this.xhs_minute)
      });
    },
    addDyCommentMinuteCount(dy_minute) {
      this.dy_minute.push(dy_minute);
      chrome.storage.local.set({
        "dy_minute": JSON.stringify(this.dy_minute)
      });
    },
    setStopButtonText(stopButtonText) {
      this.stopButtonText = stopButtonText;
      chrome.storage.local.set({
        "stopButtonText": stopButtonText
      });
    },
    setFormattedTime(formattedTime) {
      this.formattedTime = formattedTime;
      chrome.storage.local.set({
        "formattedTime": formattedTime
      });
    },
    checkLoadend() {
      let maxNum = 60,
        timeout = 30;
      let num = 0;
      return new Promise(resolve => {
        const checkInterval = setInterval(() => {
          const loadend = this.loadend;
          if (loadend || num > maxNum) {
            if (num > maxNum) {
              console.error("checkLoadend 加载超时");
            }
            clearInterval(checkInterval);
            resolve();
          }
          num++;
        }, timeout);
      });
    },
    loadFromStorage() {
      if (this.loadFromStorage_load) {
        return;
      }
      this.loadFromStorage_load = true;
      chrome.storage.local.get(["activatePage", "operationTime", "XiaoHongShu_Setting", "xhs_viewCount", "xhs_CommentCount", "xhs_likeCount", "xhs_followCount", "xhs_collectCount", "dy_viewCount", "dy_CommentCount", "dy_likeCount", "dy_followCount", "dy_collectCount", "XiaoHongShu_workStatus", "xiaoHongShuAccountErrorTip", "clientVisitorId", "executeOperationStartTime", "refreshFrequencyNum"], result => {
        console.log("result activatePage", result);
        if (result.activatePage !== void 0) {
          this.activatePage = result.activatePage;
        }
        if (result.operationTime !== void 0) {
          this.operationTime = result.operationTime;
        }
        if (result.XiaoHongShu_Setting !== void 0) {
          this.XiaoHongShu_Setting = result.XiaoHongShu_Setting;
        }
        if (result.xhs_viewCount !== void 0) {
          this.xhs_viewCount = result.xhs_viewCount;
        }
        if (result.xhs_CommentCount !== void 0) {
          this.xhs_CommentCount = result.xhs_CommentCount;
        }
        if (result.xhs_likeCount !== void 0) {
          this.xhs_likeCount = result.xhs_likeCount;
        }
        if (result.xhs_followCount !== void 0) {
          this.xhs_followCount = result.xhs_followCount;
        }
        if (result.xhs_collectCount !== void 0) {
          this.xhs_collectCount = result.xhs_collectCount;
        }
        if (result.dy_viewCount !== void 0) {
          this.dy_viewCount = result.dy_viewCount;
        }
        if (result.dy_CommentCount !== void 0) {
          this.dy_CommentCount = result.dy_CommentCount;
        }
        if (result.dy_likeCount !== void 0) {
          this.dy_likeCount = result.dy_likeCount;
        }
        if (result.dy_followCount !== void 0) {
          this.dy_followCount = result.dy_followCount;
        }
        if (result.dy_collectCount !== void 0) {
          this.dy_collectCount = result.dy_collectCount;
        }
        if (result.XiaoHongShu_workStatus !== void 0) {
          this.XiaoHongShu_workStatus = result.XiaoHongShu_workStatus;
        }
        if (result.xiaoHongShuAccountErrorTip !== void 0) {
          this.xiaoHongShuAccountErrorTip = result.xiaoHongShuAccountErrorTip;
        }
        if (result.clientVisitorId !== void 0) {
          this.clientVisitorId = result.clientVisitorId;
        }
        if (result.executeOperationStartTime !== void 0) {
          this.executeOperationStartTime = result.executeOperationStartTime;
        }
        if (result.refreshFrequencyNum !== void 0) {
          this.refreshFrequencyNum = result.refreshFrequencyNum;
        }
        this.loadend = true;
      });
      chrome.storage.onChanged.addListener((changes, namespace) => {
        for (let [key, {
          oldValue,
          newValue
        }] of Object.entries(changes)) {
          console.log(`Storage key "${key}" in namespace "${namespace}" changed.`, `Old value was "${oldValue}", new value is "${newValue}".`);
          switch (key) {
            case "xhs_likeCount":
              this.xhs_likeCount = newValue;
              break;
            case "xhs_followCount":
              this.xhs_followCount = newValue;
              break;
            case "xhs_CommentCount":
              this.xhs_CommentCount = newValue;
              break;
            case "xhs_collectCount":
              this.xhs_collectCount = newValue;
              break;
            case "xhs_viewCount":
              this.xhs_viewCount = newValue;
              break;
            case "dy_likeCount":
              this.dy_likeCount = newValue;
              break;
            case "dy_followCount":
              this.dy_followCount = newValue;
              break;
            case "dy_CommentCount":
              this.dy_CommentCount = newValue;
              break;
            case "dy_collectCount":
              this.dy_collectCount = newValue;
              break;
            case "dy_viewCount":
              this.dy_viewCount = newValue;
              break;
            case "XiaoHongShu_workStatus":
              this.XiaoHongShu_workStatus = newValue;
              break;
            case "clientVisitorId":
              this.clientVisitorId = newValue;
              break;
            case "executeOperationStartTime":
              this.executeOperationStartTime = newValue;
              break;
            case "refreshFrequencyNum":
              this.refreshFrequencyNum = newValue;
              break;
          }
        }
      });
    }
  }
});
const useCounterCommentStore = defineStore("comment_counter", {
  state: () => ({
    //当前页面
    activatePage: indexPage,
    //配置
    XiaoHongShu_Setting: "{}",
    //自动回复评论数量
    XiaoHongShu_CommentCount: 0,
    //赞和收藏的
    // 取关数量
    XiaoHongShu_likes_unfollow: 0,
    // 关注数量
    XiaoHongShu_likes_follow: 0,
    //新增关注
    // 取关数量
    XiaoHongShu_connections_unfollow: 0,
    // 回关数量
    XiaoHongShu_connections_follow: 0,
    loadend: false,
    loadFromStorage_load: false
  }),
  actions: {
    increment_XiaoHongShu_CommentCount() {
      this.XiaoHongShu_CommentCount++;
    },
    setActivatePage(page) {
      this.activatePage = page;
      sendLog("contentPage activatePage2：", page);
      chrome.storage.local.set({
        "activatePage": this.activatePage
      });
    },
    setXiaoHongShu_Setting(setting) {
      this.XiaoHongShu_Setting = setting;
      chrome.storage.local.set({
        "XiaoHongShu_Setting": this.XiaoHongShu_Setting
      });
    },
    checkLoadend() {
      let maxNum = 60,
        timeout = 30;
      let num = 0;
      return new Promise(resolve => {
        const checkInterval = setInterval(() => {
          const loadend = this.loadend;
          if (loadend || num > maxNum) {
            if (num > maxNum) {
              console.error("checkLoadend 加载超时");
            }
            clearInterval(checkInterval);
            resolve();
          }
          num++;
        }, timeout);
      });
    },
    loadFromStorage() {
      if (this.loadFromStorage_load) {
        console.log("loadFromStorage");
        return;
      }
      this.loadFromStorage_load = true;
      chrome.storage.local.get(["activatePage", "XiaoHongShu_Setting", "XiaoHongShu_CommentCount", "XiaoHongShu_likes_unfollow", "XiaoHongShu_likes_follow", "XiaoHongShu_connections_unfollow", "XiaoHongShu_connections_follow"], result => {
        console.log("result activatePage", result);
        if (result.activatePage !== void 0) {
          this.activatePage = result.activatePage;
        }
        if (result.XiaoHongShu_Setting !== void 0) {
          this.XiaoHongShu_Setting = result.XiaoHongShu_Setting;
        }
        if (result.XiaoHongShu_CommentCount !== void 0) {
          this.XiaoHongShu_CommentCount = result.XiaoHongShu_CommentCount;
        }
        if (result.XiaoHongShu_likes_unfollow !== void 0) {
          this.XiaoHongShu_likes_unfollow = result.XiaoHongShu_likes_unfollow;
        }
        if (result.XiaoHongShu_likes_follow !== void 0) {
          this.XiaoHongShu_likes_follow = result.XiaoHongShu_likes_follow;
        }
        if (result.XiaoHongShu_connections_unfollow !== void 0) {
          this.XiaoHongShu_connections_unfollow = result.XiaoHongShu_connections_unfollow;
        }
        if (result.XiaoHongShu_connections_follow !== void 0) {
          this.XiaoHongShu_connections_follow = result.XiaoHongShu_connections_follow;
        }
        this.loadend = true;
      });
      chrome.storage.onChanged.addListener((changes, namespace) => {
        for (let [key, {
          oldValue,
          newValue
        }] of Object.entries(changes)) {
          console.log(`contentPage Storage key "${key}" in namespace "${namespace}" changed.`, `Old value was "${oldValue}", new value is "${newValue}".`);
          switch (key) {
            case "XiaoHongShu_likes_unfollow":
              this.XiaoHongShu_likes_unfollow = newValue;
              break;
            case "XiaoHongShu_likes_follow":
              this.XiaoHongShu_likes_follow = newValue;
              break;
            case "XiaoHongShu_CommentCount":
              this.XiaoHongShu_CommentCount = newValue;
              break;
            case "XiaoHongShu_connections_unfollow":
              this.XiaoHongShu_connections_unfollow = newValue;
              break;
            case "XiaoHongShu_connections_follow":
              this.XiaoHongShu_connections_follow = newValue;
              break;
          }
        }
      });
    }
  }
});
setActivePinia(pinia);
const store = useCounterStore();
const commentStore = useCounterCommentStore();
const _hoisted_1$3 = {
  style: {
    "padding": "20px 30px",
    "top": "32%",
    "left": "45%",
    "position": "absolute",
    "border-radius": "4px",
    "background": "#fff"
  }
};
const _hoisted_2$3 = {
  style: {
    "text-align": "center"
  }
};
const _hoisted_3$3 = {
  style: {
    "color": "red",
    "font-size": "14px",
    "padding-top": "10px",
    "padding-bottom": "20px",
    "max-width": "200px"
  }
};
const _hoisted_4$3 = {
  style: {
    "font-size": "16px",
    "font-weight": "600"
  }
};
const _hoisted_5$2 = {
  key: 0,
  style: {
    "font-size": "16px",
    "font-weight": "600"
  }
};
const _hoisted_6$2 = {
  key: 1,
  style: {
    "font-size": "16px",
    "font-weight": "600"
  }
};
const _hoisted_7$1 = {
  style: {
    "font-size": "16px",
    "font-weight": "600"
  }
};
const _hoisted_8$1 = {
  key: 2,
  style: {
    "font-size": "16px",
    "font-weight": "600"
  }
};
const _hoisted_9$1 = {
  style: {
    "padding-top": "20px",
    "display": "flex",
    "justify-content": "center",
    "align-items": "center",
    "flex-direction": "column"
  }
};
const _hoisted_10$1 = {
  style: {
    "font-size": "14px"
  }
};
const _sfc_main$4 = /* @__PURE__ */defineComponent({
  __name: "XiaoHongShu_Run",
  setup(__props) {
    let XiaoHongShu_Setting = JSON.parse(store.XiaoHongShu_Setting);
    const stop = async () => {
      store.setActivatePage("XiaoHongShu_Setting");
      stopButtonText.value = getLocalizedMessage("contentPageStopIngText");
    };
    function getTabTaskData() {
      return new Promise(resolve => {
        chrome.runtime.sendMessage({
          action: "getTabTaskData"
        }, {
          includeTlsChannelId: false
        }, response => {
          if (response && response.tabId) {
            console.log("getTabTaskData Current Tab ID:", response.tabId, response);
            resolve(response);
          } else {
            console.error("Failed to get tab ID.");
            resolve({});
          }
        });
      });
    }
    function closeTabListener() {
      chrome.storage.onChanged.addListener((changes, namespace) => {
        for (let [key, {
          oldValue,
          newValue
        }] of Object.entries(changes)) {
          console.log(`Storage key "${key}" in namespace "${namespace}" changed.`, `Old value was "${oldValue}", new value is "${newValue}".`);
          sendLog(`Storage key "${key}" in namespace "${namespace}" changed.Old value was "${oldValue}", new value is "${newValue}".`);
          switch (key) {
            case "xiaoHongShuAccountErrorTip":
              if (newValue) {
                ElMessageBox.alert(newValue, "错误", {
                  // if you want to disable its autofocus
                  // autofocus: false,
                  showCancelButton: false,
                  confirmButtonText: "OK",
                  callback: () => {
                    stop();
                  }
                });
              }
          }
        }
      });
    }
    const queryLastTime = () => {
      console.log("queryLastTime");
      chrome.runtime.onMessage.addListener(async (request, sender, sendResponse) => {
        if ((request == null ? void 0 : request.action) == store.getChromeTabId() + "_queryLastTime") {
          console.log(`queryLastTime。`, sender, request);
          sendLog("剩余时间：" + minute);
          sendResponse(minute);
          return false;
        }
      });
    };
    const formattedTime = ref("60:00");
    const stopButtonText = ref(getLocalizedMessage("contentPageStopText"));
    let minute = 0;
    let orginOperationTime = 0;
    class CountdownTimer {
      constructor(minutes) {
        __publicField(this, "totalSeconds");
        __publicField(this, "intervalId");
        orginOperationTime = minutes;
        this.totalSeconds = minutes * 60;
      }
      // Start the countdown timer
      start() {
        this.intervalId = window.setInterval(() => {
          if (this.totalSeconds <= 0) {
            console.log("Countdown finished!");
            this.stopFun();
          } else {
            this.totalSeconds--;
            this.displayTime();
          }
        }, 1e3);
      }
      // Stop the countdown timer
      stopFun() {
        if (this.intervalId !== void 0) {
          clearInterval(this.intervalId);
          stop();
        }
      }
      // Display time in minutes and seconds
      displayTime() {
        if (store.activatePage == "XiaoHongShu_Setting") {
          return;
        }
        const minutes = Math.floor(this.totalSeconds / 60);
        const seconds = this.totalSeconds % 60;
        if (minute != 0 && minute != minutes + 1) {
          console.log("minute", minute);
          if (store.taskPlatform == "小红书") {
            chrome.storage.local.set({
              "runMinuteTime": orginOperationTime - minute
            });
            store.addXHSCommentMinuteCount({
              minute: orginOperationTime - minute,
              num: store.xhs_CommentCount
            });
          } else {
            chrome.storage.local.set({
              "runMinuteTime": orginOperationTime - minute
            });
            store.addDyCommentMinuteCount({
              minute: orginOperationTime - minute,
              num: store.dy_CommentCount
            });
          }
        }
        minute = minutes + 1;
        formattedTime.value = `${this.padZero(minutes)}:${this.padZero(seconds)}`;
      }
      // Pad single digit numbers with a leading zero
      padZero(value) {
        return value < 10 ? `0${value}` : `${value}`;
      }
    }
    let timerMin = void 0;
    setTimeout(async () => {
      var _a;
      await store.checkLoadend();
      if (!XiaoHongShu_Setting || Object.keys(XiaoHongShu_Setting).length == 0) {
        XiaoHongShu_Setting = JSON.parse(store.XiaoHongShu_Setting);
      }
      if (store.operationTime !== 0) {
        console.log("operationTime 2", store.operationTime);
        timerMin = new CountdownTimer(store.operationTime);
        timerMin.start();
      } else {
        console.log("checkLoadend", store.XiaoHongShu_Setting, XiaoHongShu_Setting);
        if (XiaoHongShu_Setting.operationTime) {
          let operationTime = parseInt(XiaoHongShu_Setting.operationTime);
          console.log("operationTime", operationTime);
          chrome.storage.local.set({
            "operationTime": operationTime
          });
          timerMin = new CountdownTimer(operationTime);
          timerMin.start();
        }
      }
      sendLog("contentPage setTimeout end");
      const taskData = await getTabTaskData();
      store.setChromeTabId(taskData == null ? void 0 : taskData.tabId);
      store.setTaskPlatform((_a = taskData == null ? void 0 : taskData.tabData) == null ? void 0 : _a.taskPlatform);
      queryLastTime();
      if (store.xiaoHongShuAccountErrorTip) {
        ElMessageBox.alert(store.xiaoHongShuAccountErrorTip, "提示", {
          // if you want to disable its autofocus
          // autofocus: false,
          showCancelButton: false,
          confirmButtonText: "OK",
          callback: () => {
            stop();
          }
        });
      } else {
        closeTabListener();
      }
    }, 1);
    const $t = inject("$t");
    return (_ctx, _cache) => {
      var _a;
      return openBlock(), createElementBlock("div", _hoisted_1$3, [createBaseVNode("h1", _hoisted_2$3, toDisplayString(unref($t)("contentPageTitle")), 1), createBaseVNode("div", _hoisted_3$3, toDisplayString(unref($t)("contentPageDescription")), 1), createBaseVNode("div", null, [createBaseVNode("div", _hoisted_4$3, toDisplayString(unref($t)("contentPageViewCountText")) + "：" + toDisplayString(unref(store).taskPlatform == "小红书" ? unref(store).xhs_viewCount : unref(store).dy_viewCount), 1), unref(XiaoHongShu_Setting).like ? (openBlock(), createElementBlock("div", _hoisted_5$2, toDisplayString(unref($t)("popupOtherLike")) + "：" + toDisplayString(unref(store).taskPlatform == "小红书" ? unref(store).xhs_likeCount : unref(store).dy_likeCount), 1)) : createCommentVNode("", true), unref(XiaoHongShu_Setting).collect ? (openBlock(), createElementBlock("div", _hoisted_6$2, toDisplayString(unref($t)("popupOtherCollect")) + "：" + toDisplayString(unref(store).taskPlatform == "小红书" ? unref(store).xhs_collectCount : unref(store).dy_collectCount), 1)) : createCommentVNode("", true), createBaseVNode("div", _hoisted_7$1, toDisplayString(unref($t)("contentPageSendCommentText")) + "：" + toDisplayString(unref(store).taskPlatform == "小红书" ? unref(store).xhs_CommentCount : unref(store).dy_CommentCount), 1), unref(XiaoHongShu_Setting).follow ? (openBlock(), createElementBlock("div", _hoisted_8$1, toDisplayString(unref($t)("popupOtherFollow")) + "：" + toDisplayString(unref(store).taskPlatform == "小红书" ? unref(store).xhs_followCount : unref(store).dy_followCount), 1)) : createCommentVNode("", true)]), createBaseVNode("div", _hoisted_9$1, [createBaseVNode("div", _hoisted_10$1, toDisplayString(unref($t)("contentPageOptionsTimeText")) + "：" + toDisplayString((_a = unref(XiaoHongShu_Setting)) == null ? void 0 : _a.operationTime), 1), createBaseVNode("button", {
        style: normalizeStyle([{
          "width": unref(store).activatePage == "XiaoHongShu_Setting" ? "240px" : "180px"
        }, {
          "border-radius": "4px",
          "height": "30px",
          "background-color": "#f44336",
          "color": "#fff",
          "font-size": "16px",
          "font-weight": "600",
          "margin-top": "5px",
          "cursor": "pointer"
        }]),
        onClick: stop
      }, toDisplayString(stopButtonText.value) + "（" + toDisplayString(formattedTime.value) + "）", 5)])]);
    };
  }
});
const _hoisted_1$2 = {
  style: {
    "padding": "20px 30px",
    "top": "32%",
    "left": "50%",
    "position": "absolute",
    "border-radius": "4px",
    "background": "#fff"
  }
};
const _hoisted_2$2 = {
  style: {
    "font-size": "16px",
    "font-weight": "600"
  }
};
const _hoisted_3$2 = {
  style: {
    "font-size": "16px",
    "font-weight": "600"
  }
};
const _hoisted_4$2 = {
  style: {
    "font-size": "16px",
    "font-weight": "600"
  }
};
const _hoisted_5$1 = {
  style: {
    "font-size": "16px",
    "font-weight": "600"
  }
};
const _hoisted_6$1 = {
  style: {
    "font-size": "16px",
    "font-weight": "600"
  }
};
const _sfc_main$3 = /* @__PURE__ */defineComponent({
  __name: "XiaoHongShu_comment_Run",
  setup(__props) {
    const stop = async () => {
      commentStore.setActivatePage("XiaoHongShu_comment_Setting");
    };
    return (_ctx, _cache) => {
      return openBlock(), createElementBlock("div", _hoisted_1$2, [_cache[2] || (_cache[2] = createBaseVNode("h1", {
        style: {
          "text-align": "center"
        }
      }, "小回声努力工作中", -1)), _cache[3] || (_cache[3] = createBaseVNode("div", {
        style: {
          "color": "red",
          "font-size": "14px",
          "padding-top": "10px",
          "padding-bottom": "20px"
        }
      }, "运行中请不要关闭或最小化浏览器", -1)), createBaseVNode("div", null, [createBaseVNode("div", _hoisted_2$2, "评论数量：" + toDisplayString(unref(commentStore).XiaoHongShu_CommentCount), 1), _cache[0] || (_cache[0] = createBaseVNode("div", {
        style: {
          "font-size": "20px",
          "font-weight": "600",
          "padding-top": "10px"
        }
      }, "赞和收藏", -1)), createBaseVNode("div", _hoisted_3$2, "关注数量：" + toDisplayString(unref(commentStore).XiaoHongShu_likes_follow), 1), createBaseVNode("div", _hoisted_4$2, "取关数量：" + toDisplayString(unref(commentStore).XiaoHongShu_likes_unfollow), 1), _cache[1] || (_cache[1] = createBaseVNode("div", {
        style: {
          "font-size": "20px",
          "font-weight": "600",
          "padding-top": "10px"
        }
      }, "新增关注", -1)), createBaseVNode("div", _hoisted_5$1, "回关数量：" + toDisplayString(unref(commentStore).XiaoHongShu_connections_follow), 1), createBaseVNode("div", _hoisted_6$1, "取关数量：" + toDisplayString(unref(commentStore).XiaoHongShu_connections_unfollow), 1)]), createBaseVNode("div", {
        style: {
          "padding-top": "20px",
          "display": "flex",
          "justify-content": "center",
          "align-items": "center",
          "flex-direction": "column"
        }
      }, [createBaseVNode("button", {
        style: {
          "border-radius": "4px",
          "width": "180px",
          "height": "30px",
          "background-color": "#f44336",
          "color": "#fff",
          "font-size": "16px",
          "font-weight": "600",
          "margin-top": "5px",
          "cursor": "pointer"
        },
        onClick: stop
      }, "停止运行")])]);
    };
  }
});
const _hoisted_1$1 = {
  style: {
    "padding": "20px 30px",
    "top": "32%",
    "left": "45%",
    "position": "absolute",
    "border-radius": "4px",
    "background": "#fff"
  }
};
const _hoisted_2$1 = {
  style: {
    "text-align": "center"
  }
};
const _hoisted_3$1 = {
  style: {
    "color": "red",
    "font-size": "14px",
    "padding-top": "10px",
    "padding-bottom": "20px",
    "max-width": "200px"
  }
};
const _hoisted_4$1 = {
  style: {
    "padding-top": "20px",
    "display": "flex",
    "justify-content": "center",
    "align-items": "center",
    "flex-direction": "column"
  }
};
const _sfc_main$2 = /* @__PURE__ */defineComponent({
  __name: "douyin_kezi_run",
  setup(__props) {
    const store2 = useCounterStore();
    store2.loadFromStorage();
    let XiaoHongShu_Setting = JSON.parse(store2.XiaoHongShu_Setting);
    const stop = async () => {
      store2.setActivatePage(indexPage);
      stopButtonText.value = getLocalizedMessage("contentPageStopIngText");
      store2.setStopButtonText(stopButtonText.value);
    };
    function getTabTaskData() {
      return new Promise(resolve => {
        chrome.runtime.sendMessage({
          action: "getTabTaskData"
        }, {
          includeTlsChannelId: false
        }, response => {
          if (response && response.tabId) {
            console.log("getTabTaskData Current Tab ID:", response.tabId, response);
            resolve(response);
          } else {
            console.error("Failed to get tab ID.");
            resolve({});
          }
        });
      });
    }
    function closeTabListener() {
      chrome.storage.onChanged.addListener((changes, namespace) => {
        for (let [key, {
          oldValue,
          newValue
        }] of Object.entries(changes)) {
          console.log(`Storage key "${key}" in namespace "${namespace}" changed.`, `Old value was "${oldValue}", new value is "${newValue}".`);
          sendLog2(`Storage key "${key}" in namespace "${namespace}" changed.Old value was "${oldValue}", new value is "${newValue}".`);
          switch (key) {
            case "xiaoHongShuAccountErrorTip":
              if (newValue) {
                ElMessageBox.alert(newValue, "错误", {
                  // if you want to disable its autofocus
                  // autofocus: false,
                  showCancelButton: false,
                  confirmButtonText: "OK",
                  callback: () => {
                    stop();
                  }
                });
              }
              break;
            case "refreshFrequencyNum":
              if (newValue) {
                stopButtonText.value = getLocalizedMessage("RefreshFrequencyText");
                store2.setStopButtonText(stopButtonText.value);
                timerMin = new CountdownTimer(Math.floor(newValue / 1e3));
                timerMin.start();
              }
              break;
          }
        }
      });
    }
    const queryLastTime = () => {
      console.log("queryLastTime");
      chrome.runtime.onMessage.addListener(async (request, sender, sendResponse) => {
        if ((request == null ? void 0 : request.action) == store2.getChromeTabId() + "_queryLastTime") {
          console.log(`queryLastTime。`, sender, request);
          sendLog2("剩余时间：" + minute);
          sendResponse(minute);
          return false;
        }
      });
    };
    const formattedTime = ref("");
    const stopButtonText = ref(getLocalizedMessage("contentPageStopText"));
    store2.setStopButtonText(stopButtonText.value);
    let minute = 0;
    let orginOperationTime = 0;
    class CountdownTimer {
      constructor(seconds) {
        __publicField(this, "totalSeconds");
        __publicField(this, "intervalId");
        orginOperationTime = seconds / 60;
        this.totalSeconds = seconds;
      }
      // Start the countdown timer
      start() {
        this.intervalId = window.setInterval(() => {
          if (this.totalSeconds <= 0) {
            console.log("Countdown finished!");
            this.stopFun();
          } else {
            this.totalSeconds--;
            this.displayTime();
          }
        }, 1e3);
      }
      // Stop the countdown timer
      stopFun() {
        if (this.intervalId !== void 0) {
          clearInterval(this.intervalId);
          stopButtonText.value = getLocalizedMessage("contentPageStopText");
          store2.setStopButtonText(stopButtonText.value);
        }
      }
      // Display time in minutes and seconds
      displayTime() {
        if (store2.activatePage == "XiaoHongShu_Setting") {
          return;
        }
        const minutes = Math.floor(this.totalSeconds / 60);
        const seconds = this.totalSeconds % 60;
        if (minute != 0 && minute != minutes + 1) {
          console.log("minute", minute);
          if (store2.taskPlatform == "小红书") {
            chrome.storage.local.set({
              "runMinuteTime": orginOperationTime - minute
            });
            store2.addXHSCommentMinuteCount({
              minute: orginOperationTime - minute,
              num: store2.xhs_CommentCount
            });
          } else {
            chrome.storage.local.set({
              "runMinuteTime": orginOperationTime - minute
            });
            store2.addDyCommentMinuteCount({
              minute: orginOperationTime - minute,
              num: store2.dy_CommentCount
            });
          }
        }
        minute = minutes + 1;
        formattedTime.value = `${this.padZero(minutes)}:${this.padZero(seconds)}`;
        store2.setFormattedTime(formattedTime.value);
      }
      // Pad single digit numbers with a leading zero
      padZero(value) {
        return value < 10 ? `0${value}` : `${value}`;
      }
    }
    function sendLog2(message) {
      chrome.runtime.sendMessage({
        action: "logs",
        message
      }).then(() => {}).catch(err => {
        console.error(err);
      });
    }
    let timerMin = void 0;
    setTimeout(async () => {
      var _a;
      await store2.checkLoadend();
      if (!XiaoHongShu_Setting || Object.keys(XiaoHongShu_Setting).length == 0) {
        XiaoHongShu_Setting = JSON.parse(store2.XiaoHongShu_Setting);
      }
      if (store2.operationTime !== 0) {
        console.log("operationTime 2", store2.operationTime);
      } else {
        console.log("checkLoadend", store2.XiaoHongShu_Setting, XiaoHongShu_Setting);
      }
      sendLog2("contentPage setTimeout end");
      const taskData = await getTabTaskData();
      store2.setChromeTabId(taskData == null ? void 0 : taskData.tabId);
      store2.setTaskPlatform((_a = taskData == null ? void 0 : taskData.tabData) == null ? void 0 : _a.taskPlatform);
      queryLastTime();
      if (store2.xiaoHongShuAccountErrorTip) {
        ElMessageBox.alert(store2.xiaoHongShuAccountErrorTip, "提示", {
          // if you want to disable its autofocus
          // autofocus: false,
          showCancelButton: false,
          confirmButtonText: "OK",
          callback: () => {
            stop();
          }
        });
      } else {
        closeTabListener();
      }
    }, 1);
    const $t = inject("$t");
    return (_ctx, _cache) => {
      return openBlock(), createElementBlock("div", _hoisted_1$1, [createBaseVNode("h1", _hoisted_2$1, toDisplayString(unref($t)("contentPageTitle")), 1), createBaseVNode("div", _hoisted_3$1, toDisplayString(unref($t)("contentPageDescription")), 1), createBaseVNode("div", _hoisted_4$1, [createBaseVNode("button", {
        style: normalizeStyle([{
          "width": unref(store2).activatePage == "XiaoHongShu_Setting" ? "240px" : "180px"
        }, {
          "border-radius": "4px",
          "height": "30px",
          "background-color": "#f44336",
          "color": "#fff",
          "font-size": "16px",
          "font-weight": "600",
          "margin-top": "5px",
          "cursor": "pointer"
        }]),
        onClick: stop
      }, toDisplayString(stopButtonText.value) + toDisplayString(formattedTime.value ? `（${formattedTime.value}）` : ""), 5)])]);
    };
  }
});
const _hoisted_1 = {
  style: {
    "padding": "20px 30px",
    "top": "32%",
    "left": "45%",
    "position": "absolute",
    "border-radius": "4px",
    "background": "#fff"
  }
};
const _hoisted_2 = {
  style: {
    "text-align": "center"
  }
};
const _hoisted_3 = {
  style: {
    "color": "red",
    "font-size": "14px",
    "padding-top": "10px",
    "padding-bottom": "20px",
    "max-width": "200px"
  }
};
const _hoisted_4 = {
  style: {
    "font-size": "16px",
    "font-weight": "600"
  }
};
const _hoisted_5 = {
  key: 0,
  style: {
    "font-size": "16px",
    "font-weight": "600"
  }
};
const _hoisted_6 = {
  key: 1,
  style: {
    "font-size": "16px",
    "font-weight": "600"
  }
};
const _hoisted_7 = {
  style: {
    "font-size": "16px",
    "font-weight": "600"
  }
};
const _hoisted_8 = {
  key: 2,
  style: {
    "font-size": "16px",
    "font-weight": "600"
  }
};
const _hoisted_9 = {
  style: {
    "padding-top": "20px",
    "display": "flex",
    "justify-content": "center",
    "align-items": "center",
    "flex-direction": "column"
  }
};
const _hoisted_10 = {
  style: {
    "font-size": "14px"
  }
};
const _sfc_main$1 = /* @__PURE__ */defineComponent({
  __name: "DouYin_Run",
  setup(__props) {
    let XiaoHongShu_Setting = JSON.parse(store.XiaoHongShu_Setting);
    const stop = async () => {
      store.setActivatePage(indexPage);
      stopButtonText.value = getLocalizedMessage("contentPageStopIngText");
    };
    function getTabTaskData() {
      return new Promise(resolve => {
        chrome.runtime.sendMessage({
          action: "getTabTaskData"
        }, {
          includeTlsChannelId: false
        }, response => {
          if (response && response.tabId) {
            console.log("getTabTaskData Current Tab ID:", response.tabId, response);
            resolve(response);
          } else {
            console.error("Failed to get tab ID.");
            resolve({});
          }
        });
      });
    }
    function closeTabListener() {
      chrome.storage.onChanged.addListener((changes, namespace) => {
        for (let [key, {
          oldValue,
          newValue
        }] of Object.entries(changes)) {
          console.log(`Storage key "${key}" in namespace "${namespace}" changed.`, `Old value was "${oldValue}", new value is "${newValue}".`);
          sendLog(`Storage key "${key}" in namespace "${namespace}" changed.Old value was "${oldValue}", new value is "${newValue}".`);
          switch (key) {
            case "xiaoHongShuAccountErrorTip":
              if (newValue) {
                ElMessageBox.alert(newValue, "错误", {
                  // if you want to disable its autofocus
                  // autofocus: false,
                  showCancelButton: false,
                  confirmButtonText: "OK",
                  callback: () => {
                    stop();
                  }
                });
              }
          }
        }
      });
    }
    const queryLastTime = () => {
      console.log("queryLastTime");
      chrome.runtime.onMessage.addListener(async (request, sender, sendResponse) => {
        if ((request == null ? void 0 : request.action) == store.getChromeTabId() + "_queryLastTime") {
          console.log(`queryLastTime。`, sender, request);
          sendLog("剩余时间：" + minute);
          sendResponse(minute);
          return false;
        }
      });
    };
    const formattedTime = ref("60:00");
    const stopButtonText = ref(getLocalizedMessage("contentPageStopText"));
    let minute = 0;
    let orginOperationTime = 0;
    class CountdownTimer {
      constructor(minutes) {
        __publicField(this, "totalSeconds");
        __publicField(this, "intervalId");
        orginOperationTime = minutes;
        this.totalSeconds = minutes * 60;
      }
      // Start the countdown timer
      start() {
        this.intervalId = window.setInterval(() => {
          if (this.totalSeconds <= 0) {
            console.log("Countdown finished!");
            this.stopFun();
          } else {
            this.totalSeconds--;
            this.displayTime();
          }
        }, 1e3);
      }
      // Stop the countdown timer
      stopFun() {
        if (this.intervalId !== void 0) {
          clearInterval(this.intervalId);
          stop();
        }
      }
      // Display time in minutes and seconds
      displayTime() {
        if (store.activatePage == indexPage) {
          return;
        }
        const minutes = Math.floor(this.totalSeconds / 60);
        const seconds = this.totalSeconds % 60;
        if (minute != 0 && minute != minutes + 1) {
          console.log("minute", minute);
          if (store.taskPlatform == "小红书") {
            chrome.storage.local.set({
              "runMinuteTime": orginOperationTime - minute
            });
            store.addXHSCommentMinuteCount({
              minute: orginOperationTime - minute,
              num: store.xhs_CommentCount
            });
          } else {
            chrome.storage.local.set({
              "runMinuteTime": orginOperationTime - minute
            });
            store.addDyCommentMinuteCount({
              minute: orginOperationTime - minute,
              num: store.dy_CommentCount
            });
          }
        }
        minute = minutes + 1;
        formattedTime.value = `${this.padZero(minutes)}:${this.padZero(seconds)}`;
      }
      // Pad single digit numbers with a leading zero
      padZero(value) {
        return value < 10 ? `0${value}` : `${value}`;
      }
    }
    let timerMin = void 0;
    setTimeout(async () => {
      var _a;
      await store.checkLoadend();
      if (!XiaoHongShu_Setting || Object.keys(XiaoHongShu_Setting).length == 0) {
        XiaoHongShu_Setting = JSON.parse(store.XiaoHongShu_Setting);
      }
      if (store.operationTime !== 0) {
        console.log("operationTime 2", store.operationTime);
        timerMin = new CountdownTimer(store.operationTime);
        timerMin.start();
      } else {
        console.log("checkLoadend", store.XiaoHongShu_Setting, XiaoHongShu_Setting);
        if (XiaoHongShu_Setting.operationTime) {
          let operationTime = parseInt(XiaoHongShu_Setting.operationTime);
          console.log("operationTime", operationTime);
          chrome.storage.local.set({
            "operationTime": operationTime
          });
          timerMin = new CountdownTimer(operationTime);
          timerMin.start();
        }
      }
      sendLog("contentPage setTimeout end");
      const taskData = await getTabTaskData();
      store.setChromeTabId(taskData == null ? void 0 : taskData.tabId);
      store.setTaskPlatform((_a = taskData == null ? void 0 : taskData.tabData) == null ? void 0 : _a.taskPlatform);
      queryLastTime();
      if (store.xiaoHongShuAccountErrorTip) {
        ElMessageBox.alert(store.xiaoHongShuAccountErrorTip, "提示", {
          // if you want to disable its autofocus
          // autofocus: false,
          showCancelButton: false,
          confirmButtonText: "OK",
          callback: () => {
            stop();
          }
        });
      } else {
        closeTabListener();
      }
    }, 1);
    const $t = inject("$t");
    return (_ctx, _cache) => {
      var _a;
      return openBlock(), createElementBlock("div", _hoisted_1, [createBaseVNode("h1", _hoisted_2, toDisplayString(unref($t)("contentPageTitle")), 1), createBaseVNode("div", _hoisted_3, toDisplayString(unref($t)("contentPageDescription")), 1), createBaseVNode("div", null, [createBaseVNode("div", _hoisted_4, toDisplayString(unref($t)("contentPageViewCountText")) + "：" + toDisplayString(unref(store).taskPlatform == "小红书" ? unref(store).xhs_viewCount : unref(store).dy_viewCount), 1), unref(XiaoHongShu_Setting).like ? (openBlock(), createElementBlock("div", _hoisted_5, toDisplayString(unref($t)("popupOtherLike")) + "：" + toDisplayString(unref(store).taskPlatform == "小红书" ? unref(store).xhs_likeCount : unref(store).dy_likeCount), 1)) : createCommentVNode("", true), unref(XiaoHongShu_Setting).collect ? (openBlock(), createElementBlock("div", _hoisted_6, toDisplayString(unref($t)("popupOtherCollect")) + "：" + toDisplayString(unref(store).taskPlatform == "小红书" ? unref(store).xhs_collectCount : unref(store).dy_collectCount), 1)) : createCommentVNode("", true), createBaseVNode("div", _hoisted_7, toDisplayString(unref($t)("contentPageSendCommentText")) + "：" + toDisplayString(unref(store).taskPlatform == "小红书" ? unref(store).xhs_CommentCount : unref(store).dy_CommentCount), 1), unref(XiaoHongShu_Setting).follow ? (openBlock(), createElementBlock("div", _hoisted_8, toDisplayString(unref($t)("popupOtherFollow")) + "：" + toDisplayString(unref(store).taskPlatform == "小红书" ? unref(store).xhs_followCount : unref(store).dy_followCount), 1)) : createCommentVNode("", true)]), createBaseVNode("div", _hoisted_9, [createBaseVNode("div", _hoisted_10, toDisplayString(unref($t)("contentPageOptionsTimeText")) + "：" + toDisplayString((_a = unref(XiaoHongShu_Setting)) == null ? void 0 : _a.operationTime), 1), createBaseVNode("button", {
        style: normalizeStyle([{
          "width": unref(store).activatePage == unref(indexPage) ? "240px" : "180px"
        }, {
          "border-radius": "4px",
          "height": "30px",
          "background-color": "#f44336",
          "color": "#fff",
          "font-size": "16px",
          "font-weight": "600",
          "margin-top": "5px",
          "cursor": "pointer"
        }]),
        onClick: stop
      }, toDisplayString(stopButtonText.value) + "（" + toDisplayString(formattedTime.value) + "）", 5)])]);
    };
  }
});
const _sfc_main = /* @__PURE__ */defineComponent({
  __name: "App",
  setup(__props) {
    return (_ctx, _cache) => {
      return openBlock(), createElementBlock("div", null, [createVNode(XiaoHongShu_small_icon), unref(store).activatePage == "douyin_kezi_run" ? (openBlock(), createBlock(_sfc_main$2, {
        key: "douyin_kezi_run"
      })) : createCommentVNode("", true), unref(store).activatePage == "XiaoHongShu_Run" ? (openBlock(), createBlock(_sfc_main$4, {
        key: "XiaoHongShu_Run"
      })) : unref(store).activatePage == "XiaoHongShu_comment_Run" ? (openBlock(), createBlock(_sfc_main$3, {
        key: "XiaoHongShu_comment_Run"
      })) : unref(store).activatePage == "DouYin_Run" ? (openBlock(), createBlock(_sfc_main$1, {
        key: "DouYin_Run"
      })) : createCommentVNode("", true)]);
    };
  }
});
store.loadFromStorage();
commentStore.loadFromStorage();
const app = createApp(_sfc_main);
const uILanguage = chrome.i18n.getUILanguage();
console.log("UILanguage", uILanguage);
setLocale(uILanguage);
app.provide("$t", getLocalizedMessage);
app.use(pinia).mount("#app");