const init = () => {
  const addIframe = (id, pagePath) => {
    if (!document.querySelector("iframe#" + id)) {
      const contentIframe = document.createElement("iframe");
      contentIframe.id = id;
      contentIframe.style.cssText = "width: 100%; height: 100%; position: fixed; top: 0px; right: 0px; z-index: 10000004; border: none;background-color: rgba(0, 0, 0, 0.4);";
      const getContentPage = chrome.runtime.getURL(pagePath);
      contentIframe.src = getContentPage;
      document.body.appendChild(contentIframe);
    } else {
      console.log("iframe已经存在了");
    }
  };
  addIframe("content-iframe", "contentPage/index.html");
};
chrome.runtime.onMessage.addListener(request => {
  console.log("onMessage.addListener tab");
  if (request.action === "injectIframe") {
    if (window.top === window.self) {
      init();
    }
    return false;
  }
});
setInterval(() => {
  if (window.top == window.self) {
    if (!document.querySelector("iframe#content-iframe")) {
      console.log("定时检查不存在了，重新注入");
      init();
    }
  }
}, 5e3);