var __defProp = Object.defineProperty;
var __defNormalProp = (obj, key, value) => key in obj ? __defProp(obj, key, {
  enumerable: true,
  configurable: true,
  writable: true,
  value
}) : obj[key] = value;
var __publicField = (obj, key, value) => __defNormalProp(obj, typeof key !== "symbol" ? key + "" : key, value);
import { _ as _export_sfc } from "./js-_plugin-vue_export-helper.js";
import { d as defineComponent, j as onMounted, w as watch, D as onUnmounted, c as createElementBlock, o as openBlock, Q as normalizeStyle, J as createBlock, K as withCtx, M as createVNode, u as unref, r as ref, V as reactive, a as createBaseVNode, G as createCommentVNode, P as toDisplayString, a3 as createTextVNode, k as inject, R as onBeforeUnmount, H as Fragment, af as renderList, al as createApp } from "./js-@vue.js";
import { v as ElRow, w as ElCol, x as ElStatistic, y as ElSegmented, g as ElButton, z as ElDialog, u as ElForm, l as ElFormItem, e as ElInput, c as ElLoading, a as ElMessage } from "./js-element-plus.js";
import { i as init } from "./js-echarts.js";
import { c as createPinia, d as defineStore, s as setActivePinia } from "./js-pinia.js";
import { i as indexPage } from "./js-indexConfig.js";
import { _ as _imports_0$1, a as _imports_1$1, b as _imports_2 } from "./js-executeButton3.js";
import { t as search_default } from "./js-@element-plus.js";
import { g as getLocalizedMessage, a as splitChineseAndEnglish, s as setLocale } from "./js-i18n.js";
import { i as index } from "./js-vue3-lottie.js";
import "./js-dayjs.js";
import "./js-clientjs.js";
import "./js-lodash-es.js";
import "./js-@vueuse.js";
import "./js-async-validator.js";
import "./js-@popperjs.js";
import "./js-normalize-wheel-es.js";
import "./js-memoize-one.js";
import "./js-@ctrl.js";
import "./js-zrender.js";
import "./js-lottie-web.js";
const _hoisted_1$5 = ["id"];
const _sfc_main$6 = /* @__PURE__ */defineComponent({
  __name: "runEchartsReport",
  props: {
    option: {
      type: Object,
      default: () => ({})
    },
    id: {
      type: String,
      default: () => Math.random().toString(36).substring(2, 8)
    },
    width: {
      type: String,
      default: "100%"
    },
    height: {
      type: String,
      default: "350px"
    },
    autoResize: {
      type: Boolean,
      default: true
    }
  },
  setup(__props) {
    const props = __props;
    let myChart = null;
    onMounted(() => {
      myChart = init(document.getElementById(props.id));
      myChart.setOption(props.option);
      if (props.autoResize) {
        window.addEventListener("resize", () => {
          myChart == null ? void 0 : myChart.resize();
        });
      }
    });
    watch(props.option, () => {
      if (myChart) {
        myChart.setOption(props.option);
      }
    }, {
      deep: true
    });
    onUnmounted(() => {
      if (props.autoResize) {
        window.removeEventListener("resize", () => {
          myChart == null ? void 0 : myChart.resize();
        });
      }
      myChart == null ? void 0 : myChart.dispose();
    });
    return (_ctx, _cache) => {
      return openBlock(), createElementBlock("div", {
        style: normalizeStyle({
          width: __props.width,
          height: __props.height
        }),
        id: props.id
      }, null, 12, _hoisted_1$5);
    };
  }
});
const pinia = createPinia();
const _StorageUtil = class _StorageUtil {
  constructor() {
    __publicField(this, "onCallBackHandlers");
    this.onCallBackHandlers = [];
  }
  // 获取唯一实例的方法
  static getInstance() {
    if (!_StorageUtil.instance) {
      _StorageUtil.instance = new _StorageUtil();
    }
    return _StorageUtil.instance;
  }
  addHandlers(handler) {
    this.onCallBackHandlers.push(handler);
  }
  removeListener(handler) {
    let removeIndex = -1;
    for (let i = 0; i < this.onCallBackHandlers.length; i++) {
      if (this.onCallBackHandlers[i] === handler) {
        removeIndex = i;
        break;
      }
    }
    if (removeIndex !== -1) {
      this.onCallBackHandlers.splice(removeIndex, 1);
    }
  }
  startOnChangedListener() {
    chrome.storage.onChanged.addListener((changes, namespace) => {
      this.onCallBackHandlers.forEach(onCallBackHandler => {
        onCallBackHandler(changes, namespace);
      });
    });
  }
};
__publicField(_StorageUtil, "instance");
let StorageUtil = _StorageUtil;
let storageUtil = StorageUtil.getInstance();
const useCounterStore = defineStore("counter", {
  state: () => ({
    userId: "",
    tenantId: "",
    tenantName: "",
    terminalData: {
      "terminalName": ""
    },
    userName: "",
    //当前页面
    activatePage: indexPage,
    //配置
    XiaoHongShu_Setting: "{}",
    //评论数量
    XiaoHongShu_viewCount: 0,
    XiaoHongShu_CommentCount: 0,
    XiaoHongShu_likeCount: 0,
    XiaoHongShu_followCount: 0,
    XiaoHongShu_collectCount: 0,
    //评论数量
    xhs_viewCount: 0,
    xhs_CommentCount: 0,
    xhs_likeCount: 0,
    xhs_followCount: 0,
    xhs_collectCount: 0,
    //评论数量
    dy_viewCount: 0,
    dy_CommentCount: 0,
    dy_likeCount: 0,
    dy_followCount: 0,
    dy_collectCount: 0,
    //工作状态
    // run：工作中
    // end: 已结束（到达底部）
    XiaoHongShu_workStatus: "run",
    checkUpdateDateStr: "",
    update: false,
    loadend: false,
    isDebugMode: false,
    loadFromStorage_load: false,
    accessToken: "",
    // vip到期时间
    userInfoEndDate: "",
    //今日运行时间
    runTodayDate: "",
    //今日运行次数
    runTodayNum: 0,
    //今日运行最大次数
    runTodayMaxNum: 3,
    //vip日期更新
    updateVipDateTime: "",
    // optionsPageName 页面
    optionsPageName: "",
    loginAuthUrl: "",
    buyUrl: "",
    accessToken_request_id: "",
    gotoYearBuyOrderId: "",
    //客户端id
    clientVisitorId: "",
    executeOperationStartTime: 0,
    executeOperationEndTime: 0,
    //小红书 关键词 列表
    xhs_keywords_list: [],
    douYin_keywords_list: [],
    xhs_minute: [],
    dy_minute: []
  }),
  actions: {
    set_checkUpdateDateStr(checkUpdateDateStr) {
      this.checkUpdateDateStr = checkUpdateDateStr;
      chrome.storage.local.set({
        "checkUpdateDateStr": this.checkUpdateDateStr
      });
    },
    set_updateVipDateTime(updateVipDateTime) {
      this.updateVipDateTime = updateVipDateTime;
      chrome.storage.local.set({
        "updateVipDateTime": this.updateVipDateTime
      });
    },
    set_update(update) {
      this.update = update;
      chrome.storage.local.set({
        "update": this.update
      });
    },
    setXiaoHongShu_viewCount(count) {
      this.XiaoHongShu_viewCount = count;
      chrome.storage.local.set({
        "XiaoHongShu_viewCount": this.XiaoHongShu_viewCount
      });
    },
    setXiaoHongShu_CommentCount(count) {
      this.XiaoHongShu_CommentCount = count;
      chrome.storage.local.set({
        "XiaoHongShu_CommentCount": this.XiaoHongShu_CommentCount
      });
    },
    setXiaoHongShu_likeCount(count) {
      this.XiaoHongShu_likeCount = count;
      chrome.storage.local.set({
        "XiaoHongShu_likeCount": this.XiaoHongShu_likeCount
      });
    },
    setXiaoHongShu_followCount(count) {
      this.XiaoHongShu_followCount = count;
      chrome.storage.local.set({
        "XiaoHongShu_followCount": this.XiaoHongShu_followCount
      });
    },
    setXiaoHongShu_collectCount(count) {
      this.XiaoHongShu_collectCount = count;
      chrome.storage.local.set({
        "XiaoHongShu_collectCount": this.XiaoHongShu_collectCount
      });
    },
    setXiaoHongShu_workStatus(status) {
      this.XiaoHongShu_workStatus = status;
    },
    setUserId(userId) {
      this.userId = userId;
      chrome.storage.local.set({
        "userId": this.userId
      });
    },
    setTenantId(tenantId) {
      this.tenantId = tenantId;
      chrome.storage.local.set({
        "tenantId": this.tenantId
      });
    },
    setTenantName(tenantName) {
      this.tenantName = tenantName;
      chrome.storage.local.set({
        "tenantName": this.tenantName
      });
    },
    setTerminalData(terminalData) {
      this.terminalData = terminalData;
      chrome.storage.local.set({
        "terminalData": JSON.stringify(terminalData)
      });
    },
    setUserName(userName) {
      this.userName = userName;
      chrome.storage.local.set({
        "userName": this.userName
      });
    },
    setAccessToken(accessToken) {
      this.accessToken = accessToken;
      chrome.storage.local.set({
        "accessToken": this.accessToken
      });
    },
    setOptionsPageName(optionsPageName) {
      this.optionsPageName = optionsPageName;
    },
    setLoginAuthUrl(loginAuthUrl) {
      this.loginAuthUrl = loginAuthUrl;
    },
    setBuyUrl(buyUrl) {
      this.buyUrl = buyUrl;
    },
    setAccessToken_request_id2(request_id) {
      this.accessToken_request_id = request_id;
    },
    setAccessToken_request_id(request_id) {
      this.accessToken_request_id = request_id;
      chrome.storage.local.set({
        "accessToken_request_id": this.accessToken_request_id
      });
    },
    setGotoYearBuyOrderId(gotoYearBuyOrderId) {
      this.gotoYearBuyOrderId = gotoYearBuyOrderId;
    },
    setActivatePage(page) {
      this.activatePage = page;
    },
    setXiaoHongShu_Setting(setting) {
      this.XiaoHongShu_Setting = setting;
      chrome.storage.local.set({
        "XiaoHongShu_Setting": this.XiaoHongShu_Setting
      });
    },
    setOperationTime(operationTime) {
      chrome.storage.local.set({
        "operationTime": operationTime
      });
    },
    setUserInfoEndDate(userInfoEndDate) {
      this.userInfoEndDate = userInfoEndDate;
      chrome.storage.local.set({
        "userInfoEndDate": userInfoEndDate
      });
    },
    increment_RunTodayNum() {
      this.runTodayNum++;
      chrome.storage.local.set({
        "runTodayNum": this.runTodayNum
      });
    },
    setRunTodayNum(runTodayNum) {
      this.runTodayNum = runTodayNum;
      chrome.storage.local.set({
        "runTodayNum": this.runTodayNum
      });
    },
    setRunTodayDate(runTodayDate) {
      this.runTodayDate = runTodayDate;
      chrome.storage.local.set({
        "runTodayDate": this.runTodayDate
      });
    },
    setClientVisitorId(clientVisitorId) {
      this.clientVisitorId = clientVisitorId;
      chrome.storage.local.set({
        "clientVisitorId": clientVisitorId
      });
    },
    checkLoadend() {
      let maxNum = 60,
        timeout = 30;
      let num = 0;
      return new Promise(resolve => {
        const checkInterval = setInterval(() => {
          const loadend = this.loadend;
          if (loadend || num > maxNum) {
            if (num > maxNum) {
              console.error("checkLoadend 加载超时");
            }
            clearInterval(checkInterval);
            resolve();
          }
          num++;
        }, timeout);
      });
    },
    loadFromStorage() {
      if (this.loadFromStorage_load) {
        return;
      }
      this.loadFromStorage_load = true;
      chrome.storage.local.get(["checkUpdateDateStr", "updateVipDateTime", "userInfoEndDate", "update", "userId", "userName", "accessToken", "activatePage", "XiaoHongShu_Setting", "XiaoHongShu_viewCount", "XiaoHongShu_CommentCount", "XiaoHongShu_likeCount", "XiaoHongShu_followCount", "XiaoHongShu_collectCount", "xhs_viewCount", "xhs_CommentCount", "xhs_likeCount", "xhs_followCount", "xhs_collectCount", "dy_viewCount", "dy_CommentCount", "dy_likeCount", "dy_followCount", "dy_collectCount", "XiaoHongShu_workStatus", "runTodayDate", "runTodayNum", "optionsPageName", "loginAuthUrl", "buyUrl", "accessToken_request_id", "gotoYearBuyOrderId", "clientVisitorId", "executeOperationStartTime", "executeOperationEndTime", "xhs_keywords_list", "douYin_keywords_list", "xhs_minute", "dy_minute", "terminalData"], result => {
        console.log("result activatePage", result);
        if (result.checkUpdateDateStr !== void 0) {
          this.checkUpdateDateStr = result.checkUpdateDateStr;
        }
        if (result.updateVipDateTime !== void 0) {
          this.updateVipDateTime = result.updateVipDateTime;
        }
        if (result.userInfoEndDate !== void 0) {
          this.userInfoEndDate = result.userInfoEndDate;
        }
        if (result.update !== void 0) {
          this.update = result.update;
        }
        if (result.userId !== void 0) {
          this.userId = result.userId;
        }
        if (result.userName !== void 0) {
          this.userName = result.userName;
        }
        if (result.accessToken !== void 0) {
          this.accessToken = result.accessToken;
        }
        if (result.activatePage !== void 0) {
          this.activatePage = result.activatePage;
        }
        if (result.XiaoHongShu_Setting !== void 0) {
          this.XiaoHongShu_Setting = result.XiaoHongShu_Setting;
        }
        if (result.XiaoHongShu_viewCount !== void 0) {
          this.XiaoHongShu_viewCount = result.XiaoHongShu_viewCount;
        }
        if (result.XiaoHongShu_CommentCount !== void 0) {
          this.XiaoHongShu_CommentCount = result.XiaoHongShu_CommentCount;
        }
        if (result.XiaoHongShu_likeCount !== void 0) {
          this.XiaoHongShu_likeCount = result.XiaoHongShu_likeCount;
        }
        if (result.XiaoHongShu_followCount !== void 0) {
          this.XiaoHongShu_followCount = result.XiaoHongShu_followCount;
        }
        if (result.XiaoHongShu_collectCount !== void 0) {
          this.XiaoHongShu_collectCount = result.XiaoHongShu_collectCount;
        }
        if (result.xhs_viewCount !== void 0) {
          this.xhs_viewCount = result.xhs_viewCount;
        }
        if (result.xhs_CommentCount !== void 0) {
          this.xhs_CommentCount = result.xhs_CommentCount;
        }
        if (result.xhs_likeCount !== void 0) {
          this.xhs_likeCount = result.xhs_likeCount;
        }
        if (result.xhs_followCount !== void 0) {
          this.xhs_followCount = result.xhs_followCount;
        }
        if (result.xhs_collectCount !== void 0) {
          this.xhs_collectCount = result.xhs_collectCount;
        }
        if (result.dy_viewCount !== void 0) {
          this.dy_viewCount = result.dy_viewCount;
        }
        if (result.dy_CommentCount !== void 0) {
          this.dy_CommentCount = result.dy_CommentCount;
        }
        if (result.dy_likeCount !== void 0) {
          this.dy_likeCount = result.dy_likeCount;
        }
        if (result.dy_followCount !== void 0) {
          this.dy_followCount = result.dy_followCount;
        }
        if (result.dy_collectCount !== void 0) {
          this.dy_collectCount = result.dy_collectCount;
        }
        if (result.XiaoHongShu_workStatus !== void 0) {
          this.XiaoHongShu_workStatus = result.XiaoHongShu_workStatus;
        }
        if (result.runTodayDate !== void 0) {
          this.runTodayDate = result.runTodayDate;
        }
        if (result.runTodayNum !== void 0) {
          this.runTodayNum = result.runTodayNum;
        }
        if (result.optionsPageName !== void 0) {
          this.optionsPageName = result.optionsPageName;
        }
        if (result.loginAuthUrl !== void 0) {
          this.loginAuthUrl = result.loginAuthUrl;
        }
        if (result.buyUrl !== void 0) {
          this.buyUrl = result.buyUrl;
        }
        if (result.accessToken_request_id !== void 0) {
          this.accessToken_request_id = result.accessToken_request_id;
        }
        if (result.gotoYearBuyOrderId !== void 0) {
          this.gotoYearBuyOrderId = result.gotoYearBuyOrderId;
        }
        if (result.clientVisitorId !== void 0) {
          this.clientVisitorId = result.clientVisitorId;
        }
        if (result.executeOperationStartTime !== void 0) {
          this.executeOperationStartTime = result.executeOperationStartTime;
        }
        if (result.executeOperationEndTime !== void 0) {
          this.executeOperationEndTime = result.executeOperationEndTime;
        }
        if (result.xhs_keywords_list !== void 0) {
          this.xhs_keywords_list = result.xhs_keywords_list ? JSON.parse(result.xhs_keywords_list) : [];
        }
        if (result.douYin_keywords_list !== void 0) {
          this.douYin_keywords_list = result.douYin_keywords_list ? JSON.parse(result.douYin_keywords_list) : [];
        }
        if (result.xhs_minute !== void 0) {
          this.xhs_minute = result.xhs_minute ? JSON.parse(result.xhs_minute) : [];
        }
        if (result.dy_minute !== void 0) {
          this.dy_minute = result.dy_minute ? JSON.parse(result.dy_minute) : [];
        }
        if (result.terminalData !== void 0) {
          this.terminalData = result.terminalData ? JSON.parse(result.terminalData) : {};
        }
        this.loadend = true;
      });
      storageUtil.addHandlers((changes, namespace) => {
        for (let [key, {
          oldValue,
          newValue
        }] of Object.entries(changes)) {
          console.log(`counter Storage key "${key}" in namespace "${namespace}" changed.`, `Old value was "${oldValue}", new value is "${newValue}".`);
          switch (key) {
            case "activatePage":
              this.activatePage = newValue;
              break;
            case "XiaoHongShu_CommentCount":
              this.XiaoHongShu_CommentCount = newValue;
              break;
            case "XiaoHongShu_likeCount":
              this.XiaoHongShu_likeCount = newValue;
              break;
            case "XiaoHongShu_followCount":
              this.XiaoHongShu_followCount = newValue;
              break;
            case "XiaoHongShu_collectCount":
              this.XiaoHongShu_collectCount = newValue;
              break;
            case "XiaoHongShu_viewCount":
              this.XiaoHongShu_viewCount = newValue;
              break;
            case "XiaoHongShu_workStatus":
              this.XiaoHongShu_workStatus = newValue;
              break;
            case "accessToken":
              this.accessToken = newValue;
              this.setActivatePage(indexPage);
              break;
            case "clientVisitorId":
              this.clientVisitorId = newValue;
              break;
            case "executeOperationStartTime":
              this.executeOperationStartTime = newValue;
              break;
            case "terminalData":
              this.terminalData = newValue ? JSON.parse(newValue) : {};
          }
        }
      });
    }
  }
});
setActivePinia(pinia);
const store = useCounterStore();
const _sfc_main$5 = /* @__PURE__ */defineComponent({
  __name: "runStatistic",
  setup(__props) {
    return (_ctx, _cache) => {
      const _component_el_statistic = ElStatistic;
      const _component_el_col = ElCol;
      const _component_el_row = ElRow;
      return openBlock(), createBlock(_component_el_row, null, {
        default: withCtx(() => [createVNode(_component_el_col, {
          span: 4
        }, {
          default: withCtx(() => [createVNode(_component_el_statistic, {
            title: "浏览量",
            value: unref(store).xhs_viewCount + unref(store).dy_viewCount
          }, null, 8, ["value"])]),
          _: 1
        }), createVNode(_component_el_col, {
          span: 5
        }, {
          default: withCtx(() => [createVNode(_component_el_statistic, {
            title: "评论数",
            value: unref(store).xhs_CommentCount + unref(store).dy_CommentCount
          }, null, 8, ["value"])]),
          _: 1
        }), createVNode(_component_el_col, {
          span: 5
        }, {
          default: withCtx(() => [createVNode(_component_el_statistic, {
            title: "点赞数",
            value: unref(store).xhs_likeCount + unref(store).dy_likeCount
          }, null, 8, ["value"])]),
          _: 1
        }), createVNode(_component_el_col, {
          span: 5
        }, {
          default: withCtx(() => [createVNode(_component_el_statistic, {
            title: "收藏数",
            value: unref(store).xhs_collectCount + unref(store).dy_collectCount
          }, null, 8, ["value"])]),
          _: 1
        }), createVNode(_component_el_col, {
          span: 5
        }, {
          default: withCtx(() => [createVNode(_component_el_statistic, {
            title: "关注数",
            value: unref(store).xhs_followCount + unref(store).dy_followCount
          }, null, 8, ["value"])]),
          _: 1
        })]),
        _: 1
      });
    };
  }
});
const RunStatistic = /* @__PURE__ */_export_sfc(_sfc_main$5, [["__scopeId", "data-v-d8c533ac"]]);
const _hoisted_1$4 = {
  style: {
    "width": "100%",
    "height": "100%"
  }
};
const _hoisted_2$3 = {
  style: {
    "margin-left": "2em"
  }
};
const _hoisted_3$3 = {
  style: {
    "height": "26px",
    "line-height": "26px",
    "font-size": "14px"
  }
};
const _hoisted_4$3 = {
  style: {
    "height": "26px",
    "line-height": "26px",
    "font-size": "14px"
  }
};
const _hoisted_5$3 = {
  style: {
    "height": "26px",
    "line-height": "26px",
    "font-size": "14px"
  }
};
const _hoisted_6$3 = {
  key: 0,
  style: {
    "height": "26px",
    "line-height": "26px",
    "font-size": "14px"
  }
};
const _hoisted_7$3 = {
  key: 1,
  style: {
    "height": "26px",
    "line-height": "26px",
    "margin-left": "2em",
    "font-size": "14px"
  }
};
const _hoisted_8$2 = {
  key: 2,
  style: {
    "height": "26px",
    "line-height": "26px",
    "margin-left": "2em",
    "font-size": "14px"
  }
};
const _hoisted_9$2 = {
  style: {
    "margin-left": "2em"
  }
};
const _hoisted_10$2 = {
  style: {
    "width": "400px"
  }
};
const _sfc_main$4 = /* @__PURE__ */defineComponent({
  __name: "runEchartsReportDemo",
  setup(__props) {
    function formatTimestamp(timestamp) {
      const date = new Date(timestamp);
      const month = String(date.getMonth() + 1).padStart(2, "0");
      const day = String(date.getDate()).padStart(2, "0");
      const hours = String(date.getHours()).padStart(2, "0");
      const minutes = String(date.getMinutes()).padStart(2, "0");
      return `${month}-${day} ${hours}:${minutes}`;
    }
    function calculateTimeDifference(startTimestamp, endTimestamp) {
      const differenceInMs = Math.abs(endTimestamp - startTimestamp);
      const totalMinutes = Math.floor(differenceInMs / (1e3 * 60));
      return `${totalMinutes}`;
    }
    const executeOperationStartTime = ref(formatTimestamp(store.executeOperationStartTime));
    const executeOperationEndTime = ref(formatTimestamp(store.executeOperationEndTime));
    const run_time = ref(calculateTimeDifference(store.executeOperationStartTime, store.executeOperationEndTime));
    const xhs_keywords_list_str = ref("");
    if (store.xhs_keywords_list.length > 0) {
      xhs_keywords_list_str.value = store.xhs_keywords_list.join("，");
    }
    const douYin_keywords_list_str = ref("");
    if (store.douYin_keywords_list.length > 0) {
      douYin_keywords_list_str.value = store.douYin_keywords_list.join("，");
    }
    let XiaoHongShu_Setting = JSON.parse(store.XiaoHongShu_Setting);
    const workRunPlatform = ref("");
    if (XiaoHongShu_Setting.workDouYinPlatform) {
      if (!workRunPlatform.value) {
        workRunPlatform.value = XiaoHongShu_Setting.workDouYinPlatform;
      } else {
        workRunPlatform.value += "+" + XiaoHongShu_Setting.workDouYinPlatform;
      }
    }
    if (XiaoHongShu_Setting.workXiaoHongShuPlatform) {
      if (!workRunPlatform.value) {
        workRunPlatform.value = XiaoHongShu_Setting.workXiaoHongShuPlatform;
      } else {
        workRunPlatform.value += "+" + XiaoHongShu_Setting.workXiaoHongShuPlatform;
      }
    }
    reactive({
      title: {
        text: "ECharts 入门示例2"
      },
      tooltip: {},
      xAxis: {
        data: ["衬衫", "羊毛衫", "雪纺衫", "裤子", "高跟鞋", "袜子"]
      },
      yAxis: {},
      series: [{
        name: "销量",
        type: "bar",
        data: [5, 20, 36, 10, 10, 20]
      }]
    });
    const uniqueMinutes = [... /* @__PURE__ */new Set([...store.xhs_minute.map(item => item.minute), ...store.dy_minute.map(item => item.minute)])].sort((a, b) => a - b);
    const xhsNums = uniqueMinutes.map(minute => {
      var _a;
      return ((_a = store.xhs_minute.find(item => item.minute === minute)) == null ? void 0 : _a.num) || 0;
    });
    const dyNums = uniqueMinutes.map(minute => {
      var _a;
      return ((_a = store.dy_minute.find(item => item.minute === minute)) == null ? void 0 : _a.num) || 0;
    });
    let LineChartConfigRel = reactive({
      title: {
        text: ""
      },
      tooltip: {
        trigger: "axis"
      },
      legend: {
        data: ["小红书", "抖音"]
      },
      grid: {
        left: "3%",
        right: "4%",
        bottom: "3%",
        containLabel: true
      },
      toolbox: {
        feature: {
          saveAsImage: {}
        }
      },
      xAxis: {
        type: "category",
        boundaryGap: false,
        data: uniqueMinutes
      },
      yAxis: {
        type: "value"
      },
      series: [{
        name: "小红书",
        type: "line",
        stack: "Total",
        data: xhsNums
      }, {
        name: "抖音",
        type: "line",
        stack: "Total",
        data: dyNums
      }]
    });
    let data = reactive({
      pieNumber: []
    });
    data.pieNumber = [{
      value: 10,
      name: "点赞"
    }, {
      value: 10,
      name: "评论"
    }, {
      value: 10,
      name: "关注"
    }, {
      value: 20,
      name: "收藏"
    }];
    const setXHSPieData = () => {
      data.pieNumber = [{
        value: store.xhs_likeCount,
        name: "点赞"
      }, {
        value: store.xhs_CommentCount,
        name: "评论"
      }, {
        value: store.xhs_followCount,
        name: "关注"
      }, {
        value: store.xhs_collectCount,
        name: "收藏"
      }];
    };
    const setDyPieData = () => {
      data.pieNumber = [{
        value: store.dy_likeCount,
        name: "点赞"
      }, {
        value: store.dy_CommentCount,
        name: "评论"
      }, {
        value: store.dy_followCount,
        name: "关注"
      }, {
        value: store.dy_collectCount,
        name: "收藏"
      }];
    };
    const setAllPieData = () => {
      data.pieNumber = [{
        value: store.xhs_likeCount + store.dy_likeCount,
        name: "点赞"
      }, {
        value: store.xhs_CommentCount + store.dy_CommentCount,
        name: "评论"
      }, {
        value: store.xhs_followCount + store.dy_followCount,
        name: "关注"
      }, {
        value: store.xhs_collectCount + store.dy_collectCount,
        name: "收藏"
      }];
    };
    let PieChartConfigRel = reactive({
      tooltip: {
        trigger: "item",
        formatter: "{a} <br/>{b} : {c} 个,占比： ({d}%)"
      },
      legend: {
        orient: "vertical",
        position: "right",
        right: "2%",
        top: "20%",
        data: data.pieTitle
        //这里的渲染的数据需要与series里面渲染的数据中的name保持一致
      },
      series: [{
        name: "任务类型占比分析表",
        type: "pie",
        radius: "70%",
        center: ["45%", "55%"],
        data: data.pieNumber,
        //渲染的数据
        emphasis: {
          itemStyle: {
            shadowBlur: 10,
            shadowOffsetX: 0,
            shadowColor: "rgba(0, 0, 0, 0.5)"
          }
        },
        label: {
          show: true,
          // 显示标签
          formatter: "{b}：{c} 个,占比：{d}%"
        }
      }]
    });
    setAllPieData();
    PieChartConfigRel.series[0].data = data.pieNumber;
    const PieChartValue = ref("全部");
    const PieChartSegmentedOptions = reactive(["全部", "小红书", "抖音"]);
    const segmentedChange = val => {
      if (val == "全部") {
        setAllPieData();
        PieChartConfigRel.series[0].data = data.pieNumber;
      } else if (val == "小红书") {
        setXHSPieData();
        PieChartConfigRel.series[0].data = data.pieNumber;
      } else if (val == "抖音") {
        setDyPieData();
        PieChartConfigRel.series[0].data = data.pieNumber;
      } else {
        console.log("");
      }
    };
    console.log("runEchartsReportDemo");
    return (_ctx, _cache) => {
      const _component_el_segmented = ElSegmented;
      return openBlock(), createElementBlock("div", _hoisted_1$4, [_cache[6] || (_cache[6] = createBaseVNode("div", {
        style: {
          "height": "34px",
          "line-height": "34px",
          "font-weight": "bolder",
          "font-size": "18px"
        }
      }, "1、任务基本信息", -1)), createBaseVNode("div", _hoisted_2$3, [createBaseVNode("div", _hoisted_3$3, "时间：" + toDisplayString(executeOperationStartTime.value) + "至" + toDisplayString(executeOperationEndTime.value), 1), createBaseVNode("div", _hoisted_4$3, "平台：" + toDisplayString(workRunPlatform.value), 1), createBaseVNode("div", _hoisted_5$3, "本次运行时长：" + toDisplayString(run_time.value) + " min", 1), douYin_keywords_list_str.value || xhs_keywords_list_str.value ? (openBlock(), createElementBlock("div", _hoisted_6$3, "关键词：")) : createCommentVNode("", true), xhs_keywords_list_str.value ? (openBlock(), createElementBlock("div", _hoisted_7$3, [_cache[1] || (_cache[1] = createBaseVNode("span", {
        style: {
          "font-weight": "bolder",
          "font-size": "14px"
        }
      }, "小红书：", -1)), createTextVNode(toDisplayString(xhs_keywords_list_str.value), 1)])) : createCommentVNode("", true), douYin_keywords_list_str.value ? (openBlock(), createElementBlock("div", _hoisted_8$2, [_cache[2] || (_cache[2] = createBaseVNode("span", {
        style: {
          "font-weight": "bolder",
          "font-size": "14px"
        }
      }, "抖音：", -1)), createTextVNode(toDisplayString(douYin_keywords_list_str.value), 1)])) : createCommentVNode("", true)]), _cache[7] || (_cache[7] = createBaseVNode("div", {
        style: {
          "height": "34px",
          "line-height": "34px",
          "font-weight": "bolder",
          "font-size": "18px"
        }
      }, "2、互动数据总览", -1)), createBaseVNode("div", _hoisted_9$2, [_cache[3] || (_cache[3] = createBaseVNode("div", {
        style: {
          "height": "10px",
          "line-height": "10px"
        }
      }, null, -1)), createVNode(RunStatistic), _cache[4] || (_cache[4] = createBaseVNode("div", {
        style: {
          "height": "34px",
          "line-height": "34px"
        }
      }, null, -1)), createVNode(_sfc_main$6, {
        class: "m-10",
        height: "400px",
        option: unref(LineChartConfigRel)
      }, null, 8, ["option"]), _cache[5] || (_cache[5] = createBaseVNode("div", {
        style: {
          "height": "34px",
          "line-height": "34px"
        }
      }, null, -1)), createBaseVNode("div", _hoisted_10$2, [createVNode(_component_el_segmented, {
        modelValue: PieChartValue.value,
        "onUpdate:modelValue": _cache[0] || (_cache[0] = $event => PieChartValue.value = $event),
        options: PieChartSegmentedOptions,
        block: "",
        onChange: segmentedChange
      }, null, 8, ["modelValue", "options"])]), createVNode(_sfc_main$6, {
        class: "m-10",
        height: "400px",
        option: unref(PieChartConfigRel)
      }, null, 8, ["option"])])]);
    };
  }
});
const _imports_0 = "/assets/assets-head1.jpeg";
const _imports_1 = "/assets/assets-head2.jpeg";
const _hoisted_1$3 = {
  style: {
    "background": "#F9425B",
    "border-radius": "10px",
    "height": "30px",
    "line-height": "30px",
    "width": "200px",
    "padding-left": "8px",
    "color": "#fff",
    "font-weight": "bold"
  }
};
const _hoisted_2$2 = {
  style: {
    "font-size": "16px",
    "color": "#213547"
  }
};
const _hoisted_3$2 = {
  style: {
    "color": "black",
    "font-size": "16px",
    "font-weight": "bold"
  }
};
const _hoisted_4$2 = {
  style: {
    "font-size": "16px",
    "color": "#213547"
  }
};
const _hoisted_5$2 = {
  style: {
    "color": "black",
    "font-size": "16px",
    "font-weight": "bold"
  }
};
const _hoisted_6$2 = {
  style: {
    "font-size": "16px",
    "color": "#213547"
  }
};
const _hoisted_7$2 = {
  style: {
    "color": "black",
    "font-size": "16px",
    "font-weight": "bold"
  }
};
const _sfc_main$3 = /* @__PURE__ */defineComponent({
  __name: "installPlugins",
  setup(__props) {
    const openExtensions = async () => {
      await chrome.tabs.create({
        url: "chrome://extensions/"
      });
    };
    const $t = inject("$t");
    return (_ctx, _cache) => {
      const _component_el_button = ElButton;
      return openBlock(), createElementBlock("div", null, [createBaseVNode("div", _hoisted_1$3, toDisplayString(unref($t)("optionsWindowHowToInstallText")), 1), _cache[1] || (_cache[1] = createBaseVNode("div", {
        style: {
          "height": "10px",
          "line-height": "10px"
        }
      }, null, -1)), createBaseVNode("div", _hoisted_2$2, [createBaseVNode("span", _hoisted_3$2, toDisplayString(unref($t)("optionsWindowStepNumText")), 1), createTextVNode(toDisplayString(unref($t)("optionsWindowStepNumText2")), 1), _cache[0] || (_cache[0] = createBaseVNode("span", {
        style: {
          "color": "#F9425B",
          "font-weight": "bold",
          "padding-left": "5px"
        }
      }, "chrome://extensions", -1)), createVNode(_component_el_button, {
        round: "",
        style: {
          "margin-left": "10px"
        },
        onClick: openExtensions
      }, {
        default: withCtx(() => [createTextVNode(toDisplayString(unref($t)("optionsWindowStepNumText3")), 1)]),
        _: 1
      })]), _cache[2] || (_cache[2] = createBaseVNode("div", {
        style: {
          "height": "30px",
          "line-height": "30px"
        }
      }, null, -1)), createBaseVNode("div", _hoisted_4$2, [createBaseVNode("span", _hoisted_5$2, toDisplayString(unref($t)("optionsWindowStep2NumText")), 1), createTextVNode(toDisplayString(unref($t)("optionsWindowStep2NumText2")), 1)]), _cache[3] || (_cache[3] = createBaseVNode("div", {
        style: {
          "height": "10px",
          "line-height": "10px"
        }
      }, null, -1)), _cache[4] || (_cache[4] = createBaseVNode("img", {
        src: _imports_0,
        style: {
          "width": "600px"
        },
        alt: "Vue logo"
      }, null, -1)), _cache[5] || (_cache[5] = createBaseVNode("div", {
        style: {
          "height": "30px",
          "line-height": "30px"
        }
      }, null, -1)), createBaseVNode("div", _hoisted_6$2, [createBaseVNode("span", _hoisted_7$2, toDisplayString(unref($t)("optionsWindowStep3NumText")), 1), createTextVNode(toDisplayString(unref($t)("optionsWindowStep3NumText2")), 1)]), _cache[6] || (_cache[6] = createBaseVNode("div", {
        style: {
          "height": "10px",
          "line-height": "10px"
        }
      }, null, -1)), _cache[7] || (_cache[7] = createBaseVNode("img", {
        src: _imports_1,
        style: {
          "width": "600px"
        },
        alt: "Vue logo"
      }, null, -1))]);
    };
  }
});
function sendLog(message) {
  chrome.runtime.sendMessage({
    action: "logs",
    message
  }).then(() => {}).catch(err => {
    console.error(err);
  });
}
function sendCloseTab() {
  chrome.runtime.sendMessage({
    action: "closeTab"
  }).then(res => {
    console.info(res);
  }).catch(err => {
    console.error(err);
  });
}
function formatDate(isoString) {
  const date = new Date(isoString);
  const year = date.getFullYear();
  const month = String(date.getMonth() + 1).padStart(2, "0");
  const day = String(date.getDate()).padStart(2, "0");
  return `${year}-${month}-${day}`;
}
function delay$1(ms) {
  return new Promise(resolve => setTimeout(resolve, ms));
}
const VITE_LOGIN_API$2 = "https://global-auth.petron.ai";
async function getLoginToken(request_id, signal) {
  for (let i = 0; i < 3; i++) {
    const url = VITE_LOGIN_API$2 + "/api/v1/workos/access_token/stream?request_id=" + request_id + "&time=" + (/* @__PURE__ */new Date()).getTime();
    const headers = {};
    try {
      const response = await fetch(url, {
        method: "get",
        signal
      });
      if (!response.ok) {
        sendLog("url:" + url + "，header:" + JSON.stringify(headers) + ", response status:" + response.status);
        console.error(`HTTP error! status: ${response.status}`, response);
        if (response.status === 401) {
          console.log("登录失效");
          store.setAccessToken("");
          store.set_updateVipDateTime("");
          store.setUserInfoEndDate("");
          setTimeout(async () => {
            const accessToken = store.accessToken;
            await logout(accessToken);
          }, 1);
        }
        if (response.status == 404) {
          return void 0;
        }
        return void 0;
      }
      let result = await response.text();
      console.log("result", result);
      sendLog("url:" + url + "，header:" + JSON.stringify(headers) + ", response status:" + response.status + ", response data:" + JSON.stringify(result));
      if (result) {
        result = JSON.parse(result);
      } else {
        return void 0;
      }
      return result;
    } catch (error) {
      if (error.name === "AbortError") {
        console.log("Fetch aborted");
      } else {
        console.error("Fetch error:", error);
      }
      sendLog("url:" + url + "，header:" + JSON.stringify(headers) + ", error" + error);
    }
  }
  return void 0;
}
async function logout(accessToken) {
  const url = VITE_LOGIN_API$2 + "/api/v1/workos/logout";
  try {
    const headers = {
      "Content-Type": "application/json",
      "Authorization": "Bearer " + accessToken
    };
    const response = await fetch(url, {
      method: "get",
      headers
    });
    if (!response.ok) {
      console.error(`HTTP error! status: ${response.status}`, response);
      return void 0;
    }
    const result = await response.json();
    console.log("result", result);
    return result;
  } catch (error) {
    console.error("Error:", error);
  }
  return void 0;
}
const VITE_LOGIN_API$1 = "https://global-auth.petron.ai";
async function putBurialPoint(postData) {
  console.log("putBurialPoint", postData);
  const url = VITE_LOGIN_API$1 + "/api/v1/analytics_events";
  const headers = {
    "Content-Type": "application/json",
    "Authorization": "Bearer " + store.accessToken
  };
  try {
    const response = await fetch(url, {
      method: "POST",
      headers,
      body: JSON.stringify(postData)
    });
    if (!response.ok) {
      sendLog("url:" + url + "，header:" + JSON.stringify(headers) + ", response status:" + response.status);
      console.error(`HTTP error! status: ${response.status}`);
      if (response.status === 401) {
        console.log("登录失效");
        store.setAccessToken("");
        store.set_updateVipDateTime("");
        store.setUserInfoEndDate("");
        await logout(store.accessToken);
      }
      if (response.status == 404) {
        return void 0;
      }
      return void 0;
    }
    const result = await response.json();
    sendLog("url:" + url + "，header:" + JSON.stringify(headers) + ",postData：" + JSON.stringify(postData) + " response status:" + response.status + ", response data:" + JSON.stringify(result));
    console.log("result", result);
    return result;
  } catch (error) {
    sendLog("url:" + url + "，header:" + JSON.stringify(headers) + ", error" + error);
    console.error("Error:", error);
  }
  return void 0;
}
const VITE_LOGIN_API = "https://global-auth.petron.ai";
async function createTenants(postData) {
  console.log("createTenants", postData);
  const url = VITE_LOGIN_API + "/api/v1/tenants";
  const headers = {
    "Content-Type": "application/json",
    "Authorization": "Bearer " + store.accessToken
  };
  try {
    const response = await fetch(url, {
      method: "POST",
      headers,
      body: JSON.stringify(postData)
    });
    if (!response.ok) {
      sendLog("url:" + url + "，header:" + JSON.stringify(headers) + ", response status:" + response.status);
      console.error(`HTTP error! status: ${response.status}`);
      if (response.status === 401) {
        console.log("登录失效");
        store.setAccessToken("");
        store.set_updateVipDateTime("");
        store.setUserInfoEndDate("");
        await logout(store.accessToken);
      }
      if (response.status == 404) {
        return void 0;
      }
      return void 0;
    }
    const result = await response.json();
    sendLog("url:" + url + "，header:" + JSON.stringify(headers) + ",postData：" + JSON.stringify(postData) + " response status:" + response.status + ", response data:" + JSON.stringify(result));
    console.log("result", result);
    return result;
  } catch (error) {
    sendLog("url:" + url + "，header:" + JSON.stringify(headers) + ", error" + error);
    console.error("Error:", error);
  }
  return void 0;
}
async function queryTenants(tenantName) {
  console.log("queryTenants", tenantName);
  const url = VITE_LOGIN_API + "/api/v1/tenants?name=" + tenantName;
  const headers = {
    "Content-Type": "application/json",
    "Authorization": "Bearer " + store.accessToken
  };
  try {
    const response = await fetch(url, {
      method: "get",
      headers
    });
    if (!response.ok) {
      sendLog("url:" + url + "，header:" + JSON.stringify(headers) + ", response status:" + response.status);
      console.error(`HTTP error! status: ${response.status}`);
      if (response.status === 401) {
        console.log("登录失效");
        store.setAccessToken("");
        store.set_updateVipDateTime("");
        store.setUserInfoEndDate("");
        await logout(store.accessToken);
      }
      if (response.status == 404) {
        return void 0;
      }
      return void 0;
    }
    const result = await response.json();
    sendLog("url:" + url + "，header:" + JSON.stringify(headers) + ",tenantName：" + tenantName + " response status:" + response.status + ", response data:" + JSON.stringify(result));
    console.log("result", result);
    return result;
  } catch (error) {
    sendLog("url:" + url + ",tenantName：" + tenantName + "，header:" + JSON.stringify(headers) + ", error" + error);
    console.error("Error:", error);
  }
  return void 0;
}
async function bingingTenants(tenant_id) {
  console.log("bingingTenants", tenant_id);
  const url = VITE_LOGIN_API + `/api/v1/tenants/${tenant_id}/binding`;
  const headers = {
    "Content-Type": "application/json",
    "Authorization": "Bearer " + store.accessToken
  };
  try {
    const response = await fetch(url, {
      method: "POST",
      headers
    });
    if (!response.ok) {
      sendLog("url:" + url + "，header:" + JSON.stringify(headers) + ", response status:" + response.status);
      console.error(`HTTP error! status: ${response.status}`);
      if (response.status === 401) {
        console.log("登录失效");
        store.setAccessToken("");
        store.set_updateVipDateTime("");
        store.setUserInfoEndDate("");
        await logout(store.accessToken);
      }
      if (response.status == 404) {
        return void 0;
      }
      return void 0;
    }
    const result = await response.json();
    sendLog("url:" + url + "，header:" + JSON.stringify(headers) + ", response status:" + response.status + ", response data:" + JSON.stringify(result));
    console.log("result", result);
    return result;
  } catch (error) {
    sendLog("url:" + url + "，header:" + JSON.stringify(headers) + ", error" + error);
    console.error("Error:", error);
  }
  return void 0;
}
async function tenantsMine() {
  console.log("tenantsMine");
  const url = VITE_LOGIN_API + `/api/v1/tenants/mine`;
  const headers = {
    "Content-Type": "application/json",
    "Authorization": "Bearer " + store.accessToken
  };
  try {
    const response = await fetch(url, {
      method: "GET",
      headers
    });
    if (!response.ok) {
      sendLog("url:" + url + "，header:" + JSON.stringify(headers) + ", response status:" + response.status);
      console.error(`HTTP error! status: ${response.status}`);
      if (response.status === 401) {
        console.log("登录失效");
        store.setAccessToken("");
        store.set_updateVipDateTime("");
        store.setUserInfoEndDate("");
        await logout(store.accessToken);
      }
      if (response.status == 404) {
        return void 0;
      }
      return void 0;
    }
    const result = await response.json();
    sendLog("url:" + url + "，header:" + JSON.stringify(headers) + ", response status:" + response.status + ", response data:" + JSON.stringify(result));
    console.log("result", result);
    return result;
  } catch (error) {
    sendLog("url:" + url + "，header:" + JSON.stringify(headers) + ", error" + error);
    console.error("Error:", error);
  }
  return void 0;
}
const VITE_TERMINAL_API = "https://agent-net.paitongai.net/terminal";
async function register_terminal(agent_id, agent_name) {
  sendLog("register_terminal accessToken: " + store.accessToken);
  const url = VITE_TERMINAL_API + "/api/terminals/register_terminal?agent_id=" + agent_id + "&agent_name=" + agent_name;
  const headers = {
    "Content-Type": "application/json",
    "Authorization": "Bearer " + store.accessToken
  };
  try {
    const response = await fetch(url, {
      method: "POST",
      headers
    });
    if (!response.ok) {
      sendLog("url:" + url + "，header:" + JSON.stringify(headers) + ", response status:" + response.status);
      console.error(`HTTP error! status: ${response.status}`);
      if (response.status === 401) {
        console.log("登录失效");
        store.setAccessToken("");
        store.set_updateVipDateTime("");
        store.setUserInfoEndDate("");
        await logout(store.accessToken);
      }
      if (response.status == 404) {
        return void 0;
      }
      return void 0;
    }
    const result = await response.json();
    sendLog("url:" + url + "，header:" + JSON.stringify(headers) + " response status:" + response.status + ", response data:" + JSON.stringify(result));
    console.log("result", result);
    return result;
  } catch (error) {
    sendLog("url:" + url + "，header:" + JSON.stringify(headers) + ", error" + error);
    console.error("Error:", error);
  }
  return void 0;
}
const VITE_AGENT_BUSINESS_API = "https://prod-agbusiness-zyqflxidth.cn-huhehaote.fcapp.run";
const VITE_AGENT_ID = "dou-yin-chrome-extension";
const VITE_AGENT_NAME = "客资工具";
async function saveTerminal(terminalId, postData) {
  console.log("terminal", postData);
  const url = VITE_AGENT_BUSINESS_API + "/api/terminal/" + terminalId;
  const headers = {
    "Content-Type": "application/json",
    "Authorization": "Bearer " + store.accessToken
  };
  try {
    const response = await fetch(url, {
      method: "POST",
      headers,
      body: JSON.stringify(postData)
    });
    if (!response.ok) {
      sendLog("url:" + url + "，header:" + JSON.stringify(headers) + ", response status:" + response.status);
      console.error(`HTTP error! status: ${response.status}`);
      if (response.status === 401) {
        console.log("登录失效");
        store.setAccessToken("");
        store.set_updateVipDateTime("");
        store.setUserInfoEndDate("");
        await logout(store.accessToken);
      }
      if (response.status == 404) {
        return void 0;
      }
      return void 0;
    }
    const result = await response.json();
    sendLog("url:" + url + "，header:" + JSON.stringify(headers) + ",postData：" + JSON.stringify(postData) + " response status:" + response.status + ", response data:" + JSON.stringify(result));
    console.log("result", result);
    return result;
  } catch (error) {
    sendLog("url:" + url + "，header:" + JSON.stringify(headers) + ", error" + error);
    console.error("Error:", error);
  }
  return void 0;
}
async function queryTerminal() {
  const url = `${VITE_AGENT_BUSINESS_API}/api/terminal?only_bound=true&agent_id=${VITE_AGENT_ID}`;
  const headers = {
    "Content-Type": "application/json",
    "Authorization": "Bearer " + store.accessToken
  };
  try {
    const response = await fetch(url, {
      method: "GET",
      headers
    });
    if (!response.ok) {
      sendLog("url:" + url + "，header:" + JSON.stringify(headers) + ", response status:" + response.status);
      console.error(`HTTP error! status: ${response.status}`);
      if (response.status === 401) {
        console.log("登录失效");
        store.setAccessToken("");
        store.set_updateVipDateTime("");
        store.setUserInfoEndDate("");
        await logout(store.accessToken);
      }
      if (response.status == 404) {
        return void 0;
      }
      return void 0;
    }
    const result = await response.json();
    sendLog("url:" + url + "，header:" + JSON.stringify(headers) + " response status:" + response.status + ", response data:" + JSON.stringify(result));
    console.log("result", result);
    if (!result || result.total == 0 || !result.data) {
      return;
    }
    return {
      terminalId: result.data[0].terminal_id,
      terminalName: result.data[0].terminal_name
    };
  } catch (error) {
    sendLog("url:" + url + "，header:" + JSON.stringify(headers) + ", error" + error);
    console.error("Error:", error);
  }
  return void 0;
}
async function saveTerminalBind(terminalId, postData) {
  console.log("terminal", postData);
  const url = VITE_AGENT_BUSINESS_API + "/api/terminal/" + terminalId + "/bind";
  const headers = {
    "Content-Type": "application/json",
    "Authorization": "Bearer " + store.accessToken
  };
  try {
    const response = await fetch(url, {
      method: "POST",
      headers,
      body: JSON.stringify(postData)
    });
    if (!response.ok) {
      sendLog("url:" + url + "，header:" + JSON.stringify(headers) + ", response status:" + response.status);
      console.error(`HTTP error! status: ${response.status}`);
      if (response.status === 401) {
        console.log("登录失效");
        store.setAccessToken("");
        store.set_updateVipDateTime("");
        store.setUserInfoEndDate("");
        await logout(store.accessToken);
      }
      if (response.status == 404) {
        return void 0;
      }
      return void 0;
    }
    const result = await response.json();
    sendLog("url:" + url + "，header:" + JSON.stringify(headers) + ",postData：" + JSON.stringify(postData) + " response status:" + response.status + ", response data:" + JSON.stringify(result));
    console.log("result", result);
    return result;
  } catch (error) {
    sendLog("url:" + url + "，header:" + JSON.stringify(headers) + ", error" + error);
    console.error("Error:", error);
  }
  return void 0;
}
async function terminalCredentials(terminalId, accessToken) {
  const url = VITE_AGENT_BUSINESS_API + "/api/terminal/" + terminalId + "/credentials";
  const headers = {
    "Content-Type": "application/json",
    "Authorization": "Bearer " + accessToken
  };
  try {
    const response = await fetch(url, {
      method: "GET",
      headers
    });
    if (!response.ok) {
      sendLog("url:" + url + "，header:" + JSON.stringify(headers) + ", response status:" + response.status);
      console.error(`HTTP error! status: ${response.status}`);
      if (response.status === 401) {
        console.log("登录失效");
        store.setAccessToken("");
        store.set_updateVipDateTime("");
        store.setUserInfoEndDate("");
        await logout(accessToken);
      }
      if (response.status == 404) {
        return void 0;
      }
      return void 0;
    }
    const result = await response.json();
    sendLog("url:" + url + "，header:" + JSON.stringify(headers) + " response status:" + response.status + ", response data:" + JSON.stringify(result));
    console.log("result", result);
    return result;
  } catch (error) {
    sendLog("url:" + url + "，header:" + JSON.stringify(headers) + ", error" + error);
    console.error("Error:", error);
  }
  return void 0;
}
const agentBusiness = async (boolBind = false) => {
  try {
    let terminalInfo = await queryTerminal();
    if (!terminalInfo) {
      const terminal_result = await register_terminal(VITE_AGENT_ID, VITE_AGENT_NAME);
      if (!terminal_result || !terminal_result.terminalId) {
        sendLog("注册设备错误");
        return false;
      }
      const postTerminalData = {
        "agent_id": VITE_AGENT_ID,
        "terminal_name": store.terminalData && store.terminalData.terminalName ? store.terminalData.terminalName : "请设置设备名称",
        "tenant_id": store.tenantId
      };
      const saveTerminalResult = await saveTerminal(terminal_result.terminalId, postTerminalData);
      if (!saveTerminalResult || !saveTerminalResult.data) {
        sendLog("保存设备错误");
        return false;
      }
      terminalInfo = await queryTerminal();
      if (!terminalInfo) {
        sendLog("没有设备信息");
        return false;
      }
    } else {
      if (boolBind) {
        const saveTerminalBindData = {
          "terminal_name": terminalInfo.terminalName ? terminalInfo.terminalName : "请设置设备名称"
        };
        const saveTerminalBindRes = await saveTerminalBind(terminalInfo.terminalId, saveTerminalBindData);
        console.log("agentBusiness saveTerminalBindRes", saveTerminalBindRes);
      }
    }
    const terminalCredentialsResult = await terminalCredentials(terminalInfo.terminalId, store.accessToken);
    if (!terminalCredentialsResult || !terminalCredentialsResult.data || !terminalCredentialsResult.data.mqtt_username || !terminalCredentialsResult.data.mqtt_password) {
      sendLog("获取密码错误");
      return false;
    }
    sendLog("terminalCredentialsResult" + JSON.stringify(terminalCredentialsResult));
    sendLog("terminalInfo" + JSON.stringify(terminalInfo));
    store.setTerminalData({
      terminalId: terminalInfo.terminalId,
      terminalName: terminalInfo.terminalName,
      topic: {
        // 订阅任务
        "task_topic": `/msg/task/${store.tenantId}/+/${VITE_AGENT_ID}/${terminalInfo.terminalId}`,
        // 任务执行状态
        "task_reply_topics": `/msg/reply/terminal/${store.tenantId}/${store.userId}/${VITE_AGENT_ID}/${terminalInfo.terminalId}`,
        // 终端状态
        "status_reply_topics": `/msg/reply/terminal/${store.tenantId}/${store.userId}/${VITE_AGENT_ID}/${terminalInfo.terminalId}/status`,
        // 运行日志
        "run_logs_reply_topics": `/msg/reply/terminal/${store.tenantId}/${store.userId}/${VITE_AGENT_ID}/${terminalInfo.terminalId}/run_logs`,
        // 心跳
        "heart_beat_topics": `/msg/reply/terminal/${store.tenantId}/${store.userId}/${VITE_AGENT_ID}/${terminalInfo.terminalId}/heart_beat`,
        // 报告
        "report_topics": `/msg/reply/terminal/${store.tenantId}/${store.userId}/${VITE_AGENT_ID}/${terminalInfo.terminalId}/report`
      },
      "mqtt_username": terminalCredentialsResult.data.mqtt_username,
      "mqtt_password": terminalCredentialsResult.data.mqtt_password
    });
    return true;
  } catch (e) {
    sendLog("agentBusiness e" + e);
  }
  return false;
};
const _hoisted_1$2 = {
  key: 0,
  style: {
    "display": "flex",
    "flex-direction": "column",
    "justify-content": "center",
    "align-items": "center",
    "font-size": "24px"
  }
};
const _hoisted_2$1 = {
  style: {
    "font-size": "24px",
    "color": "#213547"
  }
};
const _hoisted_3$1 = ["src"];
const _hoisted_4$1 = {
  key: 1,
  style: {
    "display": "flex",
    "align-items": "center",
    "height": "45px",
    "line-height": "45px"
  }
};
const _hoisted_5$1 = {
  key: 0,
  style: {
    "position": "relative",
    "display": "flex",
    "cursor": "pointer"
  }
};
const _hoisted_6$1 = {
  style: {
    "position": "absolute",
    "top": "0",
    "left": "0",
    "width": "100%",
    "height": "100%",
    "display": "flex",
    "justify-content": "center",
    "align-items": "center",
    "text-align": "center"
  }
};
const _hoisted_7$1 = {
  style: {
    "display": "inline-block",
    "margin": "0 0.9em",
    "color": "white",
    "font-weight": "500",
    "font-size": "18px"
  }
};
const _hoisted_8$1 = {
  key: 1,
  style: {
    "position": "relative",
    "display": "flex",
    "cursor": "pointer"
  }
};
const _hoisted_9$1 = {
  style: {
    "position": "absolute",
    "top": "0",
    "left": "0",
    "width": "100%",
    "height": "100%",
    "display": "flex",
    "justify-content": "center",
    "align-items": "center",
    "text-align": "center"
  }
};
const _hoisted_10$1 = {
  style: {
    "display": "inline-block",
    "margin": "0 0.9em",
    "color": "white",
    "font-weight": "500",
    "font-size": "18px"
  }
};
const _hoisted_11$1 = {
  key: 2,
  style: {
    "position": "relative",
    "display": "flex",
    "cursor": "pointer"
  }
};
const _hoisted_12$1 = {
  style: {
    "position": "absolute",
    "top": "0",
    "left": "0",
    "width": "100%",
    "height": "100%",
    "display": "flex",
    "justify-content": "center",
    "align-items": "center",
    "text-align": "center"
  }
};
const _hoisted_13$1 = {
  style: {
    "display": "inline-block",
    "margin": "0 0.9em",
    "color": "white",
    "font-weight": "500",
    "font-size": "18px"
  }
};
const _hoisted_14$1 = {
  key: 2,
  style: {
    "font-size": "24px",
    "color": "#213547"
  }
};
const _hoisted_15$1 = {
  key: 3,
  style: {
    "display": "flex",
    "align-items": "center",
    "height": "45px",
    "line-height": "45px"
  }
};
const _hoisted_16$1 = {
  key: 0,
  style: {
    "position": "relative",
    "display": "flex",
    "cursor": "pointer"
  }
};
const _hoisted_17$1 = {
  style: {
    "position": "absolute",
    "top": "0",
    "left": "0",
    "width": "100%",
    "height": "100%",
    "display": "flex",
    "justify-content": "center",
    "align-items": "center",
    "text-align": "center"
  }
};
const _hoisted_18$1 = {
  style: {
    "display": "inline-block",
    "margin": "0 0.1em",
    "color": "white",
    "font-weight": "500",
    "font-size": "18px"
  }
};
const _hoisted_19$1 = {
  key: 1,
  style: {
    "position": "relative",
    "display": "flex",
    "cursor": "pointer"
  }
};
const _hoisted_20$1 = {
  style: {
    "position": "absolute",
    "top": "0",
    "left": "0",
    "width": "100%",
    "height": "100%",
    "display": "flex",
    "justify-content": "center",
    "align-items": "center",
    "text-align": "center"
  }
};
const _hoisted_21$1 = {
  style: {
    "display": "inline-block",
    "margin": "0 0.1em",
    "color": "white",
    "font-weight": "500",
    "font-size": "18px"
  }
};
const _hoisted_22$1 = {
  key: 2,
  style: {
    "position": "relative",
    "display": "flex",
    "cursor": "pointer"
  }
};
const _hoisted_23$1 = {
  style: {
    "position": "absolute",
    "top": "0",
    "left": "0",
    "width": "100%",
    "height": "100%",
    "display": "flex",
    "justify-content": "center",
    "align-items": "center",
    "text-align": "center"
  }
};
const _hoisted_24$1 = {
  style: {
    "display": "inline-block",
    "margin": "0 0.1em",
    "color": "white",
    "font-weight": "500",
    "font-size": "18px"
  }
};
const _hoisted_25 = {
  class: "dialog-footer"
};
const _hoisted_26 = {
  class: "dialog-footer"
};
const _hoisted_27 = {
  class: "dialog-footer"
};
const _sfc_main$2 = /* @__PURE__ */defineComponent({
  __name: "Login",
  setup(__props) {
    const VITE_AGENT_BOOL = "false";
    const loginStatusText = ref(getLocalizedMessage("loginLoggingText"));
    const showIframeBool = ref(false);
    const optionsPageNameOrgin = ref("");
    const getLoginTokenBool = ref(false);
    const getLoginTokenCancelBoolean = ref(false);
    const getLoginTokenFun = async () => {
      console.log("optionsPageName getAccessToken");
      window.addEventListener("message", event => {
        if (event.data.type === "open-auth") {
          window.open(event.data.url, "_blank");
        }
      });
      try {
        closeTimeOutNum.value = 10;
        getLoginTokenController = new AbortController();
        const signal = getLoginTokenController.signal;
        const res = await getLoginToken(store.accessToken_request_id, signal);
        if (getLoginTokenCancelBoolean.value) {
          console.log("getLoginTokenCancelBoolean：", getLoginTokenCancelBoolean.value);
          optionsPageNameOrgin.value = store.optionsPageName;
          chrome.storage.local.set({
            "optionsPageName": ""
          }).then(res2 => {
            console.log("res", res2);
          });
          return;
        }
        if (!res) {
          loginStatusText.value = getLocalizedMessage("loginLoginTimeOutText");
          optionsPageNameOrgin.value = store.optionsPageName;
          chrome.storage.local.set({
            "optionsPageName": ""
          }).then(res2 => {
            console.log("res", res2);
          });
          getLoginTokenBool.value = false;
          getLoginTokenCancelBoolean.value = true;
          showIframeBool.value = false;
          setTimeout(() => {
            closeTimeOutFun();
          }, 1e3);
          return;
        }
        console.log("getLoginToken", res);
        store.setUserName(res["email"]);
        store.setTenantId(res["tenant_id"]);
        store.setUserId(res["user_id"]);
        store.setAccessToken(res["access_token"]);
        store.setAccessToken_request_id("");
        console.log("VITE_AGENT_BOOL", VITE_AGENT_BOOL);
        if (VITE_AGENT_BOOL == "true") ;
        const postData = {
          "app_id": "dou-yin-automatic-reviews",
          "client_id": store.clientVisitorId,
          "event": "loginSuccess",
          "category": "",
          "data": {},
          "data_type": "",
          "description": ""
        };
        putBurialPoint(postData).then(() => {});
        loginStatusText.value = getLocalizedMessage("loginLoginSuccessText");
        showIframeBool.value = false;
        optionsPageNameOrgin.value = store.optionsPageName;
        chrome.storage.local.set({
          "optionsPageName": ""
        }).then(res2 => {
          console.log("res", res2);
        });
        getLoginTokenBool.value = false;
        if (tenantDialogVisible.value == false) {
          getLoginTokenCancelBoolean.value = true;
          setTimeout(() => {
            closeTimeOutFun();
          }, 1e3);
        }
      } catch (error) {
        getLoginTokenBool.value = false;
        console.log("error", error);
        ElMessage.error(getLocalizedMessage("loginLoginTimeOutText"));
        loginStatusText.value = getLocalizedMessage("loginLoginTimeOutText");
        optionsPageNameOrgin.value = store.optionsPageName;
        chrome.storage.local.set({
          "optionsPageName": ""
        }).then(res => {
          console.log("res", res);
        });
        getLoginTokenCancelBoolean.value = true;
        showIframeBool.value = false;
        if (tenantDialogVisible.value == false) {
          setTimeout(() => {
            closeTimeOutFun();
          }, 1e3);
        }
      } finally {
        store.setLoginAuthUrl("");
        getLoginTokenBool.value = false;
        chrome.storage.local.set({
          "loginAuthUrl": ""
        });
      }
    };
    const callBackHandler = (changes, namespace) => {
      for (let [key, {
        oldValue,
        newValue
      }] of Object.entries(changes)) {
        sendLog(`login Storage key "${key}" in namespace "${namespace}" changed.Old value was "${oldValue}", new value is "${newValue}".`);
        if (!newValue) {
          continue;
        }
        switch (key) {
          case "optionsPageName":
            store.setOptionsPageName(newValue);
            if (newValue == "getAccessToken") {
              console.log("chrome.storage.onChanged.addListener getAccessToken ", store.accessToken_request_id);
              loginStatusText.value = getLocalizedMessage("loginLoggingText");
              if (store.accessToken_request_id && getLoginTokenBool.value == false) {
                getLoginTokenBool.value = true;
                getLoginTokenCancelBoolean.value = false;
                getLoginTokenFun().then(() => {});
              }
            }
            if (newValue == "bindingTenants") {
              loginStatusText.value = getLocalizedMessage("bindingTenantsText");
              tenantDialogVisible.value = true;
            }
            chrome.storage.local.set({
              "optionsPageName": ""
            }).then(res => {
              console.log("res", res);
            });
            break;
          case "loginAuthUrl":
            store.setLoginAuthUrl(newValue);
            if (newValue) {
              showIframeBool.value = true;
            }
            chrome.storage.local.set({
              "loginAuthUrl": ""
            }).then(res => {
              console.log("res", res);
            });
            break;
          case "accessToken_request_id":
            store.setAccessToken_request_id2(newValue);
            console.log("chrome.storage.onChanged.addListener accessToken_request_id ", store.accessToken_request_id);
            if (store.accessToken_request_id && getLoginTokenBool.value == false) {
              getLoginTokenBool.value = true;
              getLoginTokenCancelBoolean.value = false;
              getLoginTokenFun().then(() => {});
            }
            chrome.storage.local.set({
              "accessToken_request_id": ""
            }).then(res => {
              console.log("res", res);
            });
            break;
        }
      }
    };
    store.checkLoadend().then(async () => {
      if (store.optionsPageName == "getAccessToken" && getLoginTokenBool.value == false) {
        getLoginTokenBool.value = true;
        getLoginTokenCancelBoolean.value = false;
        loginStatusText.value = getLocalizedMessage("loginLoggingText");
        sendLog("checkLoadend getAccessToken:" + store.optionsPageName);
        showIframeBool.value = true;
        storageUtil.addHandlers(callBackHandler);
        await getLoginTokenFun();
      }
      console.log("login bindingTenants", store.optionsPageName);
      if (store.optionsPageName == "bindingTenants" && tenantDialogVisible.value == false) {
        setTimeout(() => {
          chrome.storage.local.set({
            "optionsPageName": ""
          });
        }, 5e3);
        loginStatusText.value = getLocalizedMessage("bindingTenantsText");
        tenantDialogVisible.value = true;
        storageUtil.addHandlers(callBackHandler);
      }
    });
    onBeforeUnmount(() => {
      console.log("LOGIN onBeforeUnmount");
      storageUtil.removeListener(callBackHandler);
    });
    const cancelPayOption = ref(0);
    const closeTimeOutNum = ref(10);
    let getLoginTokenController = void 0;
    const cancelGetLoginTokenFun = () => {
      getLoginTokenBool.value = false;
      getLoginTokenCancelBoolean.value = true;
      if (getLoginTokenController) {
        getLoginTokenController.abort();
        loginStatusText.value = getLocalizedMessage("loginLoginCancelText");
        showIframeBool.value = false;
        store.setLoginAuthUrl("");
        setTimeout(() => {
          closeTimeOutFun();
        }, 1e3);
      }
    };
    const closeTimeOutFun = () => {
      if (closeTimeOutNum.value <= 0) {
        sendCloseTab();
        return;
      }
      closeTimeOutNum.value = closeTimeOutNum.value - 1;
      setTimeout(() => {
        closeTimeOutFun();
      }, 1e3);
    };
    const tenantDialogVisible = ref(false);
    const tenantJoinDialogVisible = ref(false);
    const tenantCreateDialogVisible = ref(false);
    const buttonLoading = ref(false);
    const form = reactive({
      tenantId: "",
      tenantName: "",
      tenantName2: ""
    });
    const createTenantsFun = () => {
      buttonLoading.value = true;
      createTenants({
        name: form.tenantName
      }).then(async res => {
        console.log("createTenantsFun res", res);
        if (!res) {
          ElMessage.error("创建公司错误！");
        } else {
          if (res && res.data && res.data.id) {
            store.setTenantId(res.data.id);
            store.setTenantName(res.data.name);
            if (res.data.access_token) {
              sendLog("createTenantsFun res.data.access_token" + res.data.access_token);
              store.setAccessToken(res.data.access_token);
            } else {
              sendLog("createTenantsFun not res.data.access_token" + res.data.access_token);
            }
            const agentBusinessRes = await agentBusiness(true);
            if (agentBusinessRes) {
              ElMessage.success("创建公司成功");
              tenantCreateDialogVisible.value = false;
              notTenants();
            } else {
              ElMessage.error("创建公司错误！");
            }
          } else {
            ElMessage.error("创建公司错误！");
          }
        }
      }).catch(error => {
        console.log("createTenantsFun error", error);
        ElMessage.error("创建公司错误！");
      }).finally(() => {
        console.log("createTenantsFun finally");
        buttonLoading.value = false;
      });
    };
    const queryTenantsFun = () => {
      buttonLoading.value = true;
      if (!form.tenantName) {
        buttonLoading.value = false;
        return;
      }
      queryTenants(form.tenantName).then(res => {
        console.log("queryTenantsFun res", res);
        if (!res) ;else {
          if (res && res.data && res.data.id) {
            form.tenantName2 = res.data.name;
            form.tenantId = res.data.id;
          }
        }
      }).catch(error => {
        console.log("createTenantsFun error", error);
      }).finally(() => {
        console.log("createTenantsFun finally");
        buttonLoading.value = false;
      });
    };
    const bingingTenantsFun = () => {
      buttonLoading.value = true;
      bingingTenants(form.tenantId).then(async res => {
        console.log("bingingTenants res", res);
        if (!res) {
          ElMessage.error("绑定公司错误！");
        } else {
          if (res && res.code === 0) {
            if (res.data.access_token) {
              sendLog("bingingTenants res.data.access_token" + res.data.access_token);
              store.setAccessToken(res.data.access_token);
            } else {
              sendLog("bingingTenants not res.data.access_token" + res.data.access_token);
            }
            buttonLoading.value = true;
            return tenantsMine();
          } else {
            ElMessage.error("绑定公司错误！");
          }
        }
      }).then(async res => {
        if (res && res.data && res.data.id) {
          store.setTenantId(form.tenantId);
          store.setTenantName(res.data.name);
          const agentBusinessRes = await agentBusiness(true);
          if (agentBusinessRes) {
            ElMessage.success("绑定公司成功！");
            tenantJoinDialogVisible.value = false;
            notTenants();
          } else {
            ElMessage.error("绑定公司错误！");
          }
        } else {
          ElMessage.error("绑定公司错误！");
        }
      }).catch(error => {
        console.log("bingingTenants error", error);
        ElMessage.error("绑定公司错误！");
      }).finally(() => {
        console.log("bingingTenants finally");
        buttonLoading.value = false;
      });
    };
    const handleClose = done => {
      done();
      tenantJoinDialogVisible.value = false;
      tenantCreateDialogVisible.value = false;
      notTenants();
    };
    const notTenants = () => {
      if (getLoginTokenCancelBoolean.value == true) {
        return;
      }
      if (tenantJoinDialogVisible.value || tenantCreateDialogVisible.value) {
        return;
      }
      getLoginTokenCancelBoolean.value = true;
      tenantDialogVisible.value = false;
      setTimeout(() => {
        closeTimeOutFun();
      }, 1e3);
    };
    const $t = inject("$t");
    return (_ctx, _cache) => {
      const _component_el_button = ElButton;
      const _component_el_dialog = ElDialog;
      const _component_el_input = ElInput;
      const _component_el_form_item = ElFormItem;
      const _component_el_form = ElForm;
      return unref(store).optionsPageName == "getAccessToken" || optionsPageNameOrgin.value == "getAccessToken" || unref(store).optionsPageName == "bindingTenants" ? (openBlock(), createElementBlock("div", _hoisted_1$2, [createBaseVNode("div", _hoisted_2$1, toDisplayString(loginStatusText.value), 1), showIframeBool.value ? (openBlock(), createElementBlock("iframe", {
        key: 0,
        src: unref(store).loginAuthUrl + "&open_blank=true",
        style: {
          "width": "600px",
          "height": "600px",
          "z-index": "10000004",
          "border": "none"
        }
      }, null, 8, _hoisted_3$1)) : createCommentVNode("", true), _cache[24] || (_cache[24] = createBaseVNode("div", {
        style: {
          "height": "30px",
          "line-height": "30px"
        }
      }, null, -1)), getLoginTokenBool.value ? (openBlock(), createElementBlock("div", _hoisted_4$1, [createBaseVNode("div", {
        onClick: cancelGetLoginTokenFun,
        onMouseover: _cache[0] || (_cache[0] = () => {
          cancelPayOption.value = 1;
        }),
        onMouseleave: _cache[1] || (_cache[1] = () => {
          cancelPayOption.value = 0;
        })
      }, [cancelPayOption.value == 0 ? (openBlock(), createElementBlock("div", _hoisted_5$1, [_cache[12] || (_cache[12] = createBaseVNode("img", {
        src: _imports_0$1,
        style: {
          "width": "160px",
          "cursor": "pointer"
        },
        alt: "Vue logo"
      }, null, -1)), createBaseVNode("div", _hoisted_6$1, [(openBlock(true), createElementBlock(Fragment, null, renderList(unref(splitChineseAndEnglish)(unref(getLocalizedMessage)("optionsWindowCancelText")), text => {
        return openBlock(), createElementBlock("span", _hoisted_7$1, toDisplayString(text), 1);
      }), 256))])])) : createCommentVNode("", true), cancelPayOption.value == 1 ? (openBlock(), createElementBlock("div", _hoisted_8$1, [_cache[13] || (_cache[13] = createBaseVNode("img", {
        src: _imports_1$1,
        style: {
          "width": "160px",
          "cursor": "pointer"
        },
        alt: "Vue logo"
      }, null, -1)), createBaseVNode("div", _hoisted_9$1, [(openBlock(true), createElementBlock(Fragment, null, renderList(unref(splitChineseAndEnglish)(unref(getLocalizedMessage)("optionsWindowCancelText")), text => {
        return openBlock(), createElementBlock("span", _hoisted_10$1, toDisplayString(text), 1);
      }), 256))])])) : createCommentVNode("", true), cancelPayOption.value == 2 ? (openBlock(), createElementBlock("div", _hoisted_11$1, [_cache[14] || (_cache[14] = createBaseVNode("img", {
        src: _imports_2,
        style: {
          "width": "160px",
          "cursor": "pointer"
        },
        alt: "Vue logo"
      }, null, -1)), createBaseVNode("div", _hoisted_12$1, [(openBlock(true), createElementBlock(Fragment, null, renderList(unref(splitChineseAndEnglish)(unref(getLocalizedMessage)("optionsWindowCancelText")), text => {
        return openBlock(), createElementBlock("span", _hoisted_13$1, toDisplayString(text), 1);
      }), 256))])])) : createCommentVNode("", true)], 32)])) : createCommentVNode("", true), getLoginTokenCancelBoolean.value ? (openBlock(), createElementBlock("div", _hoisted_14$1, toDisplayString(unref($t)("optionsWindowCloseTimeOutText", closeTimeOutNum.value)), 1)) : createCommentVNode("", true), getLoginTokenCancelBoolean.value ? (openBlock(), createElementBlock("div", _hoisted_15$1, [createBaseVNode("div", {
        onClick: _cache[2] || (_cache[2] =
        //@ts-ignore
        (...args) => unref(sendCloseTab) && unref(sendCloseTab)(...args)),
        onMouseover: _cache[3] || (_cache[3] = () => {
          cancelPayOption.value = 1;
        }),
        onMouseleave: _cache[4] || (_cache[4] = () => {
          cancelPayOption.value = 0;
        })
      }, [cancelPayOption.value == 0 ? (openBlock(), createElementBlock("div", _hoisted_16$1, [_cache[15] || (_cache[15] = createBaseVNode("img", {
        src: _imports_0$1,
        style: {
          "width": "160px",
          "cursor": "pointer"
        },
        alt: "Vue logo"
      }, null, -1)), createBaseVNode("div", _hoisted_17$1, [(openBlock(true), createElementBlock(Fragment, null, renderList(unref(splitChineseAndEnglish)(unref(getLocalizedMessage)("optionsWindowCloseText")), text => {
        return openBlock(), createElementBlock("span", _hoisted_18$1, toDisplayString(text), 1);
      }), 256))])])) : createCommentVNode("", true), cancelPayOption.value == 1 ? (openBlock(), createElementBlock("div", _hoisted_19$1, [_cache[16] || (_cache[16] = createBaseVNode("img", {
        src: _imports_1$1,
        style: {
          "width": "160px",
          "cursor": "pointer"
        },
        alt: "Vue logo"
      }, null, -1)), createBaseVNode("div", _hoisted_20$1, [(openBlock(true), createElementBlock(Fragment, null, renderList(unref(splitChineseAndEnglish)(unref(getLocalizedMessage)("optionsWindowCloseText")), text => {
        return openBlock(), createElementBlock("span", _hoisted_21$1, toDisplayString(text), 1);
      }), 256))])])) : createCommentVNode("", true), cancelPayOption.value == 2 ? (openBlock(), createElementBlock("div", _hoisted_22$1, [_cache[17] || (_cache[17] = createBaseVNode("img", {
        src: _imports_2,
        style: {
          "width": "160px",
          "cursor": "pointer"
        },
        alt: "Vue logo"
      }, null, -1)), createBaseVNode("div", _hoisted_23$1, [(openBlock(true), createElementBlock(Fragment, null, renderList(unref(splitChineseAndEnglish)(unref(getLocalizedMessage)("optionsWindowCloseText")), text => {
        return openBlock(), createElementBlock("span", _hoisted_24$1, toDisplayString(text), 1);
      }), 256))])])) : createCommentVNode("", true)], 32)])) : createCommentVNode("", true), createVNode(_component_el_dialog, {
        modelValue: tenantDialogVisible.value,
        "onUpdate:modelValue": _cache[7] || (_cache[7] = $event => tenantDialogVisible.value = $event),
        title: "提示",
        width: "500",
        "close-on-click-modal": false,
        "close-on-press-escape": false,
        "before-close": handleClose
      }, {
        footer: withCtx(() => [createBaseVNode("div", _hoisted_25, [createVNode(_component_el_button, {
          type: "primary",
          onClick: _cache[5] || (_cache[5] = $event => {
            tenantDialogVisible.value = false;
            tenantJoinDialogVisible.value = true;
          })
        }, {
          default: withCtx(() => _cache[18] || (_cache[18] = [createTextVNode("加入已有的公司")])),
          _: 1
        }), createVNode(_component_el_button, {
          type: "primary",
          onClick: _cache[6] || (_cache[6] = $event => {
            tenantDialogVisible.value = false;
            tenantCreateDialogVisible.value = true;
          })
        }, {
          default: withCtx(() => _cache[19] || (_cache[19] = [createTextVNode("创建新的公司")])),
          _: 1
        }), createVNode(_component_el_button, {
          onClick: notTenants
        }, {
          default: withCtx(() => _cache[20] || (_cache[20] = [createTextVNode("跳过，不需要")])),
          _: 1
        })])]),
        default: withCtx(() => [_cache[21] || (_cache[21] = createBaseVNode("span", null, "当前用户没有加入任何公司，请确认是否需要创建或加入公司！", -1))]),
        _: 1
      }, 8, ["modelValue"]), createVNode(_component_el_dialog, {
        modelValue: tenantJoinDialogVisible.value,
        "onUpdate:modelValue": _cache[9] || (_cache[9] = $event => tenantJoinDialogVisible.value = $event),
        title: "加入已有的公司",
        width: "500",
        "close-on-click-modal": false,
        "close-on-press-escape": false,
        "before-close": handleClose
      }, {
        footer: withCtx(() => [createBaseVNode("div", _hoisted_26, [createVNode(_component_el_button, {
          disabled: form.tenantId == "",
          loading: buttonLoading.value,
          type: "primary",
          onClick: bingingTenantsFun
        }, {
          default: withCtx(() => _cache[22] || (_cache[22] = [createTextVNode("加入公司")])),
          _: 1
        }, 8, ["disabled", "loading"])])]),
        default: withCtx(() => [createVNode(_component_el_form, {
          model: form,
          "label-width": "auto",
          style: {
            "max-width": "600px"
          }
        }, {
          default: withCtx(() => [createVNode(_component_el_form_item, {
            label: "公司名称"
          }, {
            default: withCtx(() => [createVNode(_component_el_input, {
              modelValue: form.tenantName,
              "onUpdate:modelValue": _cache[8] || (_cache[8] = $event => form.tenantName = $event),
              style: {
                "max-width": "600px"
              },
              placeholder: "请输入已有的公司名称查询",
              class: "input-with-select"
            }, {
              append: withCtx(() => [createVNode(_component_el_button, {
                loading: buttonLoading.value,
                icon: unref(search_default),
                onClick: queryTenantsFun
              }, null, 8, ["loading", "icon"])]),
              _: 1
            }, 8, ["modelValue"])]),
            _: 1
          }), form.tenantId ? (openBlock(), createBlock(_component_el_form_item, {
            key: 0,
            label: "公司Id"
          }, {
            default: withCtx(() => [createBaseVNode("span", null, toDisplayString(form.tenantId), 1)]),
            _: 1
          })) : createCommentVNode("", true), form.tenantId ? (openBlock(), createBlock(_component_el_form_item, {
            key: 1,
            label: "公司名称"
          }, {
            default: withCtx(() => [createBaseVNode("span", null, toDisplayString(form.tenantName2), 1)]),
            _: 1
          })) : createCommentVNode("", true)]),
          _: 1
        }, 8, ["model"])]),
        _: 1
      }, 8, ["modelValue"]), createVNode(_component_el_dialog, {
        modelValue: tenantCreateDialogVisible.value,
        "onUpdate:modelValue": _cache[11] || (_cache[11] = $event => tenantCreateDialogVisible.value = $event),
        title: "创建新的公司",
        width: "500",
        "close-on-click-modal": false,
        "close-on-press-escape": false,
        "before-close": handleClose
      }, {
        footer: withCtx(() => [createBaseVNode("div", _hoisted_27, [createVNode(_component_el_button, {
          disabled: form.tenantName == "",
          loading: buttonLoading.value,
          type: "primary",
          onClick: createTenantsFun
        }, {
          default: withCtx(() => _cache[23] || (_cache[23] = [createTextVNode("创建公司")])),
          _: 1
        }, 8, ["disabled", "loading"])])]),
        default: withCtx(() => [createVNode(_component_el_form, {
          model: form,
          "label-width": "auto",
          style: {
            "max-width": "600px"
          }
        }, {
          default: withCtx(() => [createVNode(_component_el_form_item, {
            label: "公司名称"
          }, {
            default: withCtx(() => [createVNode(_component_el_input, {
              modelValue: form.tenantName,
              "onUpdate:modelValue": _cache[10] || (_cache[10] = $event => form.tenantName = $event)
            }, null, 8, ["modelValue"])]),
            _: 1
          })]),
          _: 1
        }, 8, ["model"])]),
        _: 1
      }, 8, ["modelValue"])])) : createCommentVNode("", true);
    };
  }
});
const VITE_PAY_API = "https://prod-payment-platform.paitongai.net";
const VITE_APP_BASE_URL = "https://plugin-api-adlrdojbyd.ap-northeast-1.fcapp.run";
function delay(ms) {
  return new Promise(resolve => setTimeout(resolve, ms));
}
async function getPayResponse(order_id, accessToken, signal, gotoYearBuyCancelBoolean) {
  for (let i = 0; i < 2; i++) {
    console.log("getPayResponse", order_id, accessToken);
    try {
      const response = await getStream(order_id, accessToken, signal);
      if (gotoYearBuyCancelBoolean()) {
        return void 0;
      }
      if (!response || !response.ok) {
        if (response) {
          console.error(`HTTP error! status: ${response.status}`, response);
        }
        await delay(3 * 1e3);
        continue;
      }
      return await response.json();
    } catch (err) {
      console.error("Error:", err);
    }
  }
  return void 0;
}
function getStream(order_id, accessToken, signal) {
  return new Promise(resolve => {
    const url = VITE_PAY_API + "/api/v1/order/" + order_id + "/stream";
    const headers = {
      "Content-Type": "application/json",
      "Authorization": "Bearer " + accessToken
    };
    fetch(url, {
      method: "GET",
      headers,
      signal
    }).then(response => {
      sendLog("url:" + url + "，header:" + JSON.stringify(headers) + ", response status:" + response.status);
      resolve(response);
    }).catch(error => {
      sendLog("url:" + url + "，header:" + JSON.stringify(headers) + ", error：" + error);
      if (error.name === "AbortError") {
        console.log("Fetch aborted");
      } else {
        console.error("Fetch error:", error);
      }
      resolve(void 0);
    });
  });
}
async function getSubscriptionsPay(accessToken) {
  const url = VITE_APP_BASE_URL + "/api/v1/subscription/subscriptions/current";
  const headers = {
    "Content-Type": "application/json",
    "Authorization": "Bearer " + accessToken
  };
  try {
    const response = await fetch(url, {
      method: "get",
      headers
    });
    if (!response.ok) {
      sendLog("url:" + url + "，header:" + JSON.stringify(headers) + ", response status:" + response.status);
      console.error(`HTTP error! status: ${response.status}`, response);
      if (response.status === 401) {
        console.log("登录失效");
        store.setAccessToken("");
        store.set_updateVipDateTime("");
        store.setUserInfoEndDate("");
        await logout(accessToken);
      }
      if (response.status == 404) {
        return void 0;
      }
      return void 0;
    }
    const result = await response.json();
    sendLog("url:" + url + "，header:" + JSON.stringify(headers) + ", response status:" + response.status + ", response data:" + JSON.stringify(result));
    console.log("result", result);
    return result;
  } catch (error) {
    sendLog("url:" + url + "，header:" + JSON.stringify(headers) + ", error" + error);
    console.error("Error:", error);
  }
  return void 0;
}
const _hoisted_1$1 = {
  key: 0,
  style: {
    "background": "#fff",
    "display": "flex",
    "justify-content": "center",
    "top": "20px",
    "left": "40px",
    "z-index": "1000",
    "flex-direction": "column",
    "align-items": "center"
  }
};
const _hoisted_2 = {
  style: {
    "font-size": "24px",
    "color": "#213547"
  }
};
const _hoisted_3 = ["src"];
const _hoisted_4 = {
  key: 1,
  style: {
    "display": "flex",
    "align-items": "center",
    "height": "45px",
    "line-height": "45px"
  }
};
const _hoisted_5 = {
  key: 0,
  style: {
    "position": "relative",
    "display": "flex",
    "cursor": "pointer"
  }
};
const _hoisted_6 = {
  style: {
    "position": "absolute",
    "top": "0",
    "left": "0",
    "width": "100%",
    "height": "100%",
    "display": "flex",
    "justify-content": "center",
    "align-items": "center",
    "text-align": "center"
  }
};
const _hoisted_7 = {
  style: {
    "display": "inline-block",
    "margin": "0 0.9em",
    "color": "white",
    "font-weight": "500",
    "font-size": "18px"
  }
};
const _hoisted_8 = {
  key: 1,
  style: {
    "position": "relative",
    "display": "flex",
    "cursor": "pointer"
  }
};
const _hoisted_9 = {
  style: {
    "position": "absolute",
    "top": "0",
    "left": "0",
    "width": "100%",
    "height": "100%",
    "display": "flex",
    "justify-content": "center",
    "align-items": "center",
    "text-align": "center"
  }
};
const _hoisted_10 = {
  style: {
    "display": "inline-block",
    "margin": "0 0.9em",
    "color": "white",
    "font-weight": "500",
    "font-size": "18px"
  }
};
const _hoisted_11 = {
  key: 2,
  style: {
    "position": "relative",
    "display": "flex",
    "cursor": "pointer"
  }
};
const _hoisted_12 = {
  style: {
    "position": "absolute",
    "top": "0",
    "left": "0",
    "width": "100%",
    "height": "100%",
    "display": "flex",
    "justify-content": "center",
    "align-items": "center",
    "text-align": "center"
  }
};
const _hoisted_13 = {
  style: {
    "display": "inline-block",
    "margin": "0 0.9em",
    "color": "white",
    "font-weight": "500",
    "font-size": "18px"
  }
};
const _hoisted_14 = {
  key: 2,
  style: {
    "font-size": "24px",
    "color": "#213547"
  }
};
const _hoisted_15 = {
  key: 3,
  style: {
    "display": "flex",
    "align-items": "center",
    "height": "45px",
    "line-height": "45px"
  }
};
const _hoisted_16 = {
  key: 0,
  style: {
    "position": "relative",
    "display": "flex",
    "cursor": "pointer"
  }
};
const _hoisted_17 = {
  style: {
    "position": "absolute",
    "top": "0",
    "left": "0",
    "width": "100%",
    "height": "100%",
    "display": "flex",
    "justify-content": "center",
    "align-items": "center",
    "text-align": "center"
  }
};
const _hoisted_18 = {
  style: {
    "display": "inline-block",
    "margin": "0 0.1em",
    "color": "white",
    "font-weight": "500",
    "font-size": "18px"
  }
};
const _hoisted_19 = {
  key: 1,
  style: {
    "position": "relative",
    "display": "flex",
    "cursor": "pointer"
  }
};
const _hoisted_20 = {
  style: {
    "position": "absolute",
    "top": "0",
    "left": "0",
    "width": "100%",
    "height": "100%",
    "display": "flex",
    "justify-content": "center",
    "align-items": "center",
    "text-align": "center"
  }
};
const _hoisted_21 = {
  style: {
    "display": "inline-block",
    "margin": "0 0.1em",
    "color": "white",
    "font-weight": "500",
    "font-size": "18px"
  }
};
const _hoisted_22 = {
  key: 2,
  style: {
    "position": "relative",
    "display": "flex",
    "cursor": "pointer"
  }
};
const _hoisted_23 = {
  style: {
    "position": "absolute",
    "top": "0",
    "left": "0",
    "width": "100%",
    "height": "100%",
    "display": "flex",
    "justify-content": "center",
    "align-items": "center",
    "text-align": "center"
  }
};
const _hoisted_24 = {
  style: {
    "display": "inline-block",
    "margin": "0 0.1em",
    "color": "white",
    "font-weight": "500",
    "font-size": "18px"
  }
};
const _sfc_main$1 = /* @__PURE__ */defineComponent({
  __name: "buyProduct",
  setup(__props) {
    const loginStatusText = ref(getLocalizedMessage("loginLoggingText"));
    const showIframeBool = ref(false);
    const optionsPageNameOrgin = ref("");
    const callBackHandler = (changes, namespace) => {
      for (let [key, {
        oldValue,
        newValue
      }] of Object.entries(changes)) {
        sendLog(`buyProduct Storage key "${key}" in namespace "${namespace}" changed.Old value was "${oldValue}", new value is "${newValue}".`);
        if (!newValue) {
          continue;
        }
        switch (key) {
          case "optionsPageName":
            store.setOptionsPageName(newValue);
            if (newValue == "gotoYearBuy") {
              console.log("chrome.storage.onChanged.addListener gotoYearBuy ", store.buyUrl, store.gotoYearBuyOrderId);
              if (store.buyUrl) {
                loginStatusText.value = "";
                showIframeBool.value = true;
              } else {
                loginStatusText.value = getLocalizedMessage("payPayingNow");
                showIframeBool.value = false;
              }
              if (store.gotoYearBuyOrderId && gotoYearBuyBoolean.value == false) {
                gotoYearBuyBoolean.value = true;
                getBuy().then(() => {});
              }
            }
            chrome.storage.local.set({
              "optionsPageName": ""
            }).then(res => {
              console.log("res", res);
            });
            break;
          case "buyUrl":
            store.setBuyUrl(newValue);
            if (newValue) {
              console.log("chrome.storage.onChanged.addListener buyUrl", store.buyUrl);
              if (store.buyUrl) {
                loginStatusText.value = "";
                showIframeBool.value = true;
              } else {
                loginStatusText.value = getLocalizedMessage("payPayingNow");
                showIframeBool.value = false;
              }
              showIframeBool.value = true;
            }
            chrome.storage.local.set({
              "buyUrl": ""
            }).then(res => {
              console.log("res", res);
            });
            break;
          case "gotoYearBuyOrderId":
            store.setGotoYearBuyOrderId(newValue);
            console.log("chrome.storage.onChanged.addListener gotoYearBuyOrderId ", store.buyUrl, store.gotoYearBuyOrderId);
            if (store.gotoYearBuyOrderId && gotoYearBuyBoolean.value == false) {
              gotoYearBuyBoolean.value = true;
              if (store.buyUrl) {
                loginStatusText.value = "";
                showIframeBool.value = true;
              } else {
                loginStatusText.value = getLocalizedMessage("payPayingNow");
                showIframeBool.value = false;
              }
              getBuy().then(() => {});
            }
            chrome.storage.local.set({
              "gotoYearBuyOrderId": ""
            }).then(res => {
              console.log("res", res);
            });
            break;
        }
      }
    };
    store.checkLoadend().then(async () => {
      sendLog("buyProduct checkLoadend");
      if (store.optionsPageName == "gotoYearBuy" && gotoYearBuyBoolean.value == false) {
        gotoYearBuyBoolean.value = true;
        if (store.buyUrl) {
          loginStatusText.value = "";
          showIframeBool.value = true;
        } else {
          loginStatusText.value = getLocalizedMessage("payPayingNow");
          showIframeBool.value = false;
        }
        sendLog("checkLoadend gotoYearBuy:" + store.optionsPageName);
        storageUtil.addHandlers(callBackHandler);
        await getBuy();
      }
    });
    onBeforeUnmount(() => {
      console.log("onBeforeUnmount callBackHandler");
      storageUtil.removeListener(callBackHandler);
    });
    const gotoYearBuyBoolean = ref(false);
    const gotoYearBuyCancelBoolean = ref(false);
    let controller = void 0;
    const cancelPayOption = ref(0);
    const closeTimeOutNum = ref(10);
    const cancelPayFun = () => {
      gotoYearBuyBoolean.value = false;
      gotoYearBuyCancelBoolean.value = true;
      if (controller) {
        controller.abort();
        loginStatusText.value = getLocalizedMessage("payPayCancel");
        store.setBuyUrl("");
        showIframeBool.value = false;
        setTimeout(() => {
          closeTimeOutFun();
        }, 1e3);
      }
    };
    const closeTimeOutFun = () => {
      if (closeTimeOutNum.value <= 0) {
        sendCloseTab();
        return;
      }
      closeTimeOutNum.value = closeTimeOutNum.value - 1;
      setTimeout(() => {
        closeTimeOutFun();
      }, 1e3);
    };
    const getSubscriptionsPayDate = async () => {
      let userInfoEndDate = store.userInfoEndDate;
      await delay$1(2e3);
      for (let i = 0; i < 10; i++) {
        try {
          const subscriptionsPayRes = await getSubscriptionsPay(store.accessToken);
          sendLog("subscriptionsPayRes:" + JSON.stringify(subscriptionsPayRes));
          if (subscriptionsPayRes && subscriptionsPayRes.end_date) {
            const formattedDate = formatDate(subscriptionsPayRes.end_date);
            if (formattedDate == userInfoEndDate) {
              sendLog("getSubscriptionsPayDate formattedDate 等待1秒 formattedDate:" + formattedDate + "，userInfoEndDate:" + userInfoEndDate);
              await delay$1(1e3);
              continue;
            }
            if (formattedDate) {
              store.setUserInfoEndDate(formattedDate);
              loginStatusText.value = getLocalizedMessage("payPaySuccess");
              showIframeBool.value = false;
              sendLog("getSubscriptionsPayDate userInfoEndDate：" + store.userInfoEndDate);
              gotoYearBuyCancelBoolean.value = true;
              setTimeout(() => {
                closeTimeOutFun();
              }, 1e3);
              return;
            }
          } else {
            store.setUserInfoEndDate("");
          }
        } catch (e) {
          sendLog("getSubscriptionsPayDate e：" + JSON.stringify(e));
        }
      }
      sendLog("getSubscriptionsPayDate 支付失败");
      loginStatusText.value = getLocalizedMessage("payPayFail2");
      gotoYearBuyCancelBoolean.value = true;
      setTimeout(() => {
        closeTimeOutFun();
      }, 1e3);
    };
    const getBuy = async () => {
      try {
        closeTimeOutNum.value = 10;
        gotoYearBuyCancelBoolean.value = false;
        gotoYearBuyBoolean.value = true;
        if (store.gotoYearBuyOrderId) {
          controller = new AbortController();
          const signal = controller.signal;
          const res = await getPayResponse(store.gotoYearBuyOrderId, store.accessToken, signal, () => {
            return gotoYearBuyCancelBoolean.value;
          });
          if (gotoYearBuyCancelBoolean.value) {
            return;
          }
          if (res && res.status && res.status == "paid") {
            store.set_updateVipDateTime("");
            await getSubscriptionsPayDate();
          } else {
            loginStatusText.value = getLocalizedMessage("payPayFail");
            sendLog("getBuy 支付失败，getPayResponse:" + JSON.stringify(res));
            showIframeBool.value = false;
            gotoYearBuyCancelBoolean.value = true;
            setTimeout(() => {
              closeTimeOutFun();
            }, 1e3);
          }
        } else {
          loginStatusText.value = getLocalizedMessage("payPayFail");
          sendLog("getBuy 支付失败，gotoYearBuyOrderId is null");
          gotoYearBuyCancelBoolean.value = true;
          setTimeout(() => {
            closeTimeOutFun();
          }, 1e3);
        }
      } catch (e) {
        gotoYearBuyBoolean.value = false;
        loginStatusText.value = getLocalizedMessage("payPayFail");
        sendLog("getBuy 支付失败，error" + JSON.stringify(e));
        gotoYearBuyCancelBoolean.value = true;
        setTimeout(() => {
          closeTimeOutFun();
        }, 1e3);
      } finally {
        store.setBuyUrl("");
        chrome.storage.local.set({
          "buyUrl": ""
        });
        gotoYearBuyBoolean.value = false;
      }
    };
    const $t = inject("$t");
    return (_ctx, _cache) => {
      return unref(store).optionsPageName == "gotoYearBuy" || optionsPageNameOrgin.value == "gotoYearBuy" ? (openBlock(), createElementBlock("div", _hoisted_1$1, [createBaseVNode("div", _hoisted_2, toDisplayString(loginStatusText.value), 1), showIframeBool.value ? (openBlock(), createElementBlock("iframe", {
        key: 0,
        src: unref(store).buyUrl,
        style: {
          "width": "600px",
          "height": "600px",
          "z-index": "10000004",
          "border": "none"
        }
      }, null, 8, _hoisted_3)) : createCommentVNode("", true), _cache[11] || (_cache[11] = createBaseVNode("div", {
        style: {
          "height": "30px",
          "line-height": "30px"
        }
      }, null, -1)), gotoYearBuyBoolean.value ? (openBlock(), createElementBlock("div", _hoisted_4, [createBaseVNode("div", {
        onClick: cancelPayFun,
        onMouseover: _cache[0] || (_cache[0] = () => {
          cancelPayOption.value = 1;
        }),
        onMouseleave: _cache[1] || (_cache[1] = () => {
          cancelPayOption.value = 0;
        })
      }, [cancelPayOption.value == 0 ? (openBlock(), createElementBlock("div", _hoisted_5, [_cache[5] || (_cache[5] = createBaseVNode("img", {
        src: _imports_0$1,
        style: {
          "width": "160px",
          "cursor": "pointer"
        },
        alt: "Vue logo"
      }, null, -1)), createBaseVNode("div", _hoisted_6, [(openBlock(true), createElementBlock(Fragment, null, renderList(unref(splitChineseAndEnglish)(unref(getLocalizedMessage)("optionsWindowCancelText")), text => {
        return openBlock(), createElementBlock("span", _hoisted_7, toDisplayString(text), 1);
      }), 256))])])) : createCommentVNode("", true), cancelPayOption.value == 1 ? (openBlock(), createElementBlock("div", _hoisted_8, [_cache[6] || (_cache[6] = createBaseVNode("img", {
        src: _imports_1$1,
        style: {
          "width": "160px",
          "cursor": "pointer"
        },
        alt: "Vue logo"
      }, null, -1)), createBaseVNode("div", _hoisted_9, [(openBlock(true), createElementBlock(Fragment, null, renderList(unref(splitChineseAndEnglish)(unref(getLocalizedMessage)("optionsWindowCancelText")), text => {
        return openBlock(), createElementBlock("span", _hoisted_10, toDisplayString(text), 1);
      }), 256))])])) : createCommentVNode("", true), cancelPayOption.value == 2 ? (openBlock(), createElementBlock("div", _hoisted_11, [_cache[7] || (_cache[7] = createBaseVNode("img", {
        src: _imports_2,
        style: {
          "width": "160px",
          "cursor": "pointer"
        },
        alt: "Vue logo"
      }, null, -1)), createBaseVNode("div", _hoisted_12, [(openBlock(true), createElementBlock(Fragment, null, renderList(unref(splitChineseAndEnglish)(unref(getLocalizedMessage)("optionsWindowCancelText")), text => {
        return openBlock(), createElementBlock("span", _hoisted_13, toDisplayString(text), 1);
      }), 256))])])) : createCommentVNode("", true)], 32)])) : createCommentVNode("", true), gotoYearBuyCancelBoolean.value ? (openBlock(), createElementBlock("div", _hoisted_14, toDisplayString(unref($t)("optionsWindowCloseTimeOutText", closeTimeOutNum.value)), 1)) : createCommentVNode("", true), gotoYearBuyCancelBoolean.value ? (openBlock(), createElementBlock("div", _hoisted_15, [createBaseVNode("div", {
        onClick: _cache[2] || (_cache[2] =
        //@ts-ignore
        (...args) => unref(sendCloseTab) && unref(sendCloseTab)(...args)),
        onMouseover: _cache[3] || (_cache[3] = () => {
          cancelPayOption.value = 1;
        }),
        onMouseleave: _cache[4] || (_cache[4] = () => {
          cancelPayOption.value = 0;
        })
      }, [cancelPayOption.value == 0 ? (openBlock(), createElementBlock("div", _hoisted_16, [_cache[8] || (_cache[8] = createBaseVNode("img", {
        src: _imports_0$1,
        style: {
          "width": "160px",
          "cursor": "pointer"
        },
        alt: "Vue logo"
      }, null, -1)), createBaseVNode("div", _hoisted_17, [(openBlock(true), createElementBlock(Fragment, null, renderList(unref(splitChineseAndEnglish)(unref(getLocalizedMessage)("optionsWindowCloseText")), text => {
        return openBlock(), createElementBlock("span", _hoisted_18, toDisplayString(text), 1);
      }), 256))])])) : createCommentVNode("", true), cancelPayOption.value == 1 ? (openBlock(), createElementBlock("div", _hoisted_19, [_cache[9] || (_cache[9] = createBaseVNode("img", {
        src: _imports_1$1,
        style: {
          "width": "160px",
          "cursor": "pointer"
        },
        alt: "Vue logo"
      }, null, -1)), createBaseVNode("div", _hoisted_20, [(openBlock(true), createElementBlock(Fragment, null, renderList(unref(splitChineseAndEnglish)(unref(getLocalizedMessage)("optionsWindowCloseText")), text => {
        return openBlock(), createElementBlock("span", _hoisted_21, toDisplayString(text), 1);
      }), 256))])])) : createCommentVNode("", true), cancelPayOption.value == 2 ? (openBlock(), createElementBlock("div", _hoisted_22, [_cache[10] || (_cache[10] = createBaseVNode("img", {
        src: _imports_2,
        style: {
          "width": "160px",
          "cursor": "pointer"
        },
        alt: "Vue logo"
      }, null, -1)), createBaseVNode("div", _hoisted_23, [(openBlock(true), createElementBlock(Fragment, null, renderList(unref(splitChineseAndEnglish)(unref(getLocalizedMessage)("optionsWindowCloseText")), text => {
        return openBlock(), createElementBlock("span", _hoisted_24, toDisplayString(text), 1);
      }), 256))])])) : createCommentVNode("", true)], 32)])) : createCommentVNode("", true)])) : createCommentVNode("", true);
    };
  }
});
const _hoisted_1 = {
  class: "card-header"
};
const _sfc_main = /* @__PURE__ */defineComponent({
  __name: "App",
  setup(__props) {
    storageUtil.startOnChangedListener();
    const callBackHandler = (changes, namespace) => {
      for (let [key, {
        oldValue,
        newValue
      }] of Object.entries(changes)) {
        sendLog(`app Storage key "${key}" in namespace "${namespace}" changed.Old value was "${oldValue}", new value is "${newValue}".`);
        if (!newValue) {
          continue;
        }
        switch (key) {
          case "optionsPageName":
            store.setOptionsPageName(newValue);
        }
      }
    };
    store.checkLoadend().then(async () => {
      console.log("store.loadend", store.loadend);
      console.log("store.optionsPageName", store.optionsPageName);
      storageUtil.addHandlers(callBackHandler);
    });
    onBeforeUnmount(() => {
      console.log("APP onBeforeUnmount");
      storageUtil.removeListener(callBackHandler);
    });
    return (_ctx, _cache) => {
      return openBlock(), createElementBlock("div", _hoisted_1, [unref(store).loadend && unref(store).optionsPageName == "installPlugins" ? (openBlock(), createBlock(_sfc_main$3, {
        key: 0
      })) : createCommentVNode("", true), unref(store).loadend && (unref(store).optionsPageName == "getAccessToken" || unref(store).optionsPageName == "bindingTenants") ? (openBlock(), createBlock(_sfc_main$2, {
        key: 1
      })) : createCommentVNode("", true), unref(store).loadend && unref(store).optionsPageName == "gotoYearBuy" ? (openBlock(), createBlock(_sfc_main$1, {
        key: 2
      })) : createCommentVNode("", true), unref(store).loadend && unref(store).optionsPageName == "runEchartsReport" ? (openBlock(), createBlock(_sfc_main$4, {
        key: 3
      })) : createCommentVNode("", true)]);
    };
  }
});
const App = /* @__PURE__ */_export_sfc(_sfc_main, [["__scopeId", "data-v-b47c1f68"]]);
const app = createApp(App);
app.use(pinia);
app.use(index);
store.loadFromStorage();
const uILanguage = chrome.i18n.getUILanguage();
console.log("UILanguage", uILanguage);
setLocale(uILanguage);
app.provide("$t", getLocalizedMessage);
app.mount("#app");