var __defProp = Object.defineProperty;
var __defNormalProp = (obj, key, value) => key in obj ? __defProp(obj, key, {
  enumerable: true,
  configurable: true,
  writable: true,
  value
}) : obj[key] = value;
var __publicField = (obj, key, value) => __defNormalProp(obj, typeof key !== "symbol" ? key + "" : key, value);
import { i as indexPage, r as runPages } from "./js-indexConfig.js";
import { m as mqtt } from "./js-mqtt.js";
const store_console = {
  isDebugMode: true
};
store_console.isDebugMode = true;
if (!store_console.isDebugMode) {
  const originalConsoleLog = console.log;
  console.log = (...args) => {
    if (store_console.isDebugMode) {
      originalConsoleLog(...args);
    }
  };
}
if (!store_console.isDebugMode) {
  const originalConsoleError = console.error;
  console.error = (...args) => {
    if (store_console.isDebugMode) {
      originalConsoleError(...args);
    }
  };
}
if (!store_console.isDebugMode) {
  const originalConsoleInfo = console.info;
  console.info = (...args) => {
    if (store_console.isDebugMode) {
      originalConsoleInfo(...args);
    }
  };
}
const _StorageUtil = class _StorageUtil {
  constructor() {
    __publicField(this, "onCallBackHandlers");
    this.onCallBackHandlers = [];
  }
  // 获取唯一实例的方法
  static getInstance() {
    if (!_StorageUtil.instance) {
      _StorageUtil.instance = new _StorageUtil();
    }
    return _StorageUtil.instance;
  }
  addHandlers(handler) {
    this.onCallBackHandlers.push(handler);
  }
  removeListener(handler) {
    let removeIndex = -1;
    for (let i = 0; i < this.onCallBackHandlers.length; i++) {
      if (this.onCallBackHandlers[i] === handler) {
        removeIndex = i;
        break;
      }
    }
    if (removeIndex !== -1) {
      this.onCallBackHandlers.splice(removeIndex, 1);
    }
  }
  startOnChangedListener() {
    chrome.storage.onChanged.addListener((changes, namespace) => {
      this.onCallBackHandlers.forEach(onCallBackHandler => {
        onCallBackHandler(changes, namespace);
      });
    });
  }
};
__publicField(_StorageUtil, "instance");
let StorageUtil = _StorageUtil;
let storageUtil = StorageUtil.getInstance();
const _UseCounterStore = class _UseCounterStore {
  constructor() {
    /**
     * 用户id
     */
    __publicField(this, "userId");
    __publicField(this, "macId");
    __publicField(this, "userName");
    __publicField(this, "webUserId");
    __publicField(this, "webUserName");
    __publicField(this, "webUserAvatarUrl");
    __publicField(this, "cpuSerialNumber");
    __publicField(this, "webPort");
    __publicField(this, "accessToken");
    __publicField(this, "tenantId");
    __publicField(this, "tenantName");
    __publicField(this, "terminalData");
    // 当前页面
    __publicField(this, "activatePage");
    // 配置
    __publicField(this, "XiaoHongShu_Setting");
    //浏览数量
    __publicField(this, "viewCount");
    // 评论数量
    __publicField(this, "CommentCount");
    // 点赞数量
    __publicField(this, "likeCount");
    // 关注数量
    __publicField(this, "followCount");
    //收藏
    __publicField(this, "collectCount");
    __publicField(this, "xhs_viewCount");
    __publicField(this, "xhs_CommentCount");
    // 初始化
    __publicField(this, "xhs_likeCount");
    // 初始化
    __publicField(this, "xhs_followCount");
    // 初始化
    __publicField(this, "xhs_collectCount");
    __publicField(this, "dy_viewCount");
    __publicField(this, "dy_CommentCount");
    // 初始化
    __publicField(this, "dy_likeCount");
    // 初始化
    __publicField(this, "dy_followCount");
    // 初始化
    __publicField(this, "dy_collectCount");
    //工作状态
    // run：工作中
    // end: 已结束（到达底部）
    __publicField(this, "XiaoHongShu_workStatus");
    __publicField(this, "loadend");
    //当前窗口的tabId
    __publicField(this, "chromeTabId");
    __publicField(this, "isDebugMode");
    __publicField(this, "operationTime");
    __publicField(this, "XiaoHongShu_search_runNumber");
    __publicField(this, "DouYin_search_runNumber");
    __publicField(this, "XiaoHongShu_avgTime");
    //今日运行小红书的账号时间
    __publicField(this, "xiaoHongShuAccountRunTodayDate");
    //今日运行小红书的账号次数
    __publicField(this, "xiaoHongShuAccountIds");
    //今日运行小红书的账号最大次数
    __publicField(this, "xiaoHongShuAccountRunTodayMaxNum");
    __publicField(this, "executeOperationStartTime");
    __publicField(this, "executeOperationEndTime");
    //客户端id
    __publicField(this, "clientVisitorId");
    // vip到期时间
    __publicField(this, "userInfoEndDate");
    //vip日期更新
    __publicField(this, "updateVipDateTime");
    //小红书 关键词 列表
    __publicField(this, "xhs_keywords_list");
    __publicField(this, "douYin_keywords_list");
    __publicField(this, "mqttStart");
    __publicField(this, "questTaskId");
    __publicField(this, "optionWhere");
    __publicField(this, "refreshFrequencyNum");
    this.userId = "";
    this.macId = "";
    this.webUserId = "";
    this.webUserName = "";
    this.webUserAvatarUrl = "";
    this.webPort = 65400;
    this.accessToken = "";
    this.userName = "";
    this.tenantId = "";
    this.tenantName = "";
    this.terminalData = {
      "terminalName": ""
    };
    this.cpuSerialNumber = "";
    this.mqttStart = "";
    this.activatePage = indexPage;
    this.XiaoHongShu_Setting = "{}";
    this.viewCount = 0;
    this.CommentCount = 0;
    this.likeCount = 0;
    this.followCount = 0;
    this.collectCount = 0;
    this.xhs_viewCount = 0;
    this.xhs_CommentCount = 0;
    this.xhs_likeCount = 0;
    this.xhs_followCount = 0;
    this.xhs_collectCount = 0;
    this.dy_viewCount = 0;
    this.dy_CommentCount = 0;
    this.dy_likeCount = 0;
    this.dy_followCount = 0;
    this.dy_collectCount = 0;
    this.XiaoHongShu_workStatus = "run";
    this.loadend = false;
    this.chromeTabId = 0;
    this.isDebugMode = false;
    this.operationTime = 0;
    this.XiaoHongShu_avgTime = 0;
    this.XiaoHongShu_search_runNumber = 1;
    this.DouYin_search_runNumber = 1;
    this.xiaoHongShuAccountRunTodayDate = "";
    this.xiaoHongShuAccountIds = /* @__PURE__ */new Set();
    this.xiaoHongShuAccountRunTodayMaxNum = 3;
    this.executeOperationStartTime = 0;
    this.executeOperationEndTime = 0;
    this.clientVisitorId = "";
    this.userInfoEndDate = "";
    this.updateVipDateTime = "";
    this.xhs_keywords_list = [];
    this.douYin_keywords_list = [];
    this.terminalData = {};
    this.questTaskId = "";
    this.optionWhere = {};
    this.refreshFrequencyNum = 60 * 60 * 1e3;
  }
  // 获取唯一实例的方法
  static getInstance() {
    if (!_UseCounterStore.instance) {
      _UseCounterStore.instance = new _UseCounterStore();
      _UseCounterStore.instance.loadFromStorage();
    }
    return _UseCounterStore.instance;
  }
  setOperationTime(operationTime) {
    this.operationTime = operationTime;
    chrome.storage.local.set({
      "operationTime": this.operationTime
    });
  }
  setChromeTabId(chromeTabId) {
    this.chromeTabId = chromeTabId;
  }
  setWebUserId(userId) {
    this.webUserId = userId;
    chrome.storage.local.set({
      "webUserId": this.webUserId
    });
  }
  setWebUserName(userId) {
    this.webUserName = userId;
    chrome.storage.local.set({
      "webUserName": this.webUserName
    });
  }
  setWebUserAvatarUrl(webUserAvatarUrl) {
    this.webUserAvatarUrl = webUserAvatarUrl;
    chrome.storage.local.set({
      "webUserAvatarUrl": this.webUserAvatarUrl
    });
  }
  setCPUSerialNumber(cpuSerialNumber) {
    this.cpuSerialNumber = cpuSerialNumber;
    chrome.storage.local.set({
      "cpuSerialNumber": this.cpuSerialNumber
    });
  }
  setWebPort(webPort) {
    this.webPort = webPort;
    chrome.storage.local.set({
      "webPort": this.webPort
    });
  }
  setUserId(userId) {
    this.userId = userId;
    chrome.storage.local.set({
      "userId": this.userId
    });
  }
  setMacId(macId) {
    this.userId = macId;
    chrome.storage.local.set({
      "macId": this.macId
    });
  }
  setUserName(userName) {
    this.userName = userName;
    chrome.storage.local.set({
      "userName": this.userName
    });
  }
  setTenantId(tenantId) {
    this.tenantId = tenantId;
    chrome.storage.local.set({
      "tenantId": this.tenantId
    });
  }
  setTenantName(tenantName) {
    this.tenantName = tenantName;
    chrome.storage.local.set({
      "tenantName": this.tenantName
    });
  }
  setAccessToken(accessToken) {
    this.accessToken = accessToken;
    chrome.storage.local.set({
      "accessToken": this.accessToken
    });
  }
  set_updateVipDateTime(updateVipDateTime) {
    this.updateVipDateTime = updateVipDateTime;
    chrome.storage.local.set({
      "updateVipDateTime": this.updateVipDateTime
    });
  }
  setUserInfoEndDate(userInfoEndDate) {
    this.userInfoEndDate = userInfoEndDate;
    chrome.storage.local.set({
      "userInfoEndDate": userInfoEndDate
    });
  }
  increment_xhs_viewCount() {
    this.xhs_viewCount++;
    chrome.storage.local.set({
      "xhs_viewCount": this.xhs_viewCount
    });
  }
  increment_xhs_CommentCount() {
    this.xhs_CommentCount++;
    chrome.storage.local.set({
      "xhs_CommentCount": this.xhs_CommentCount
    });
  }
  increment_xhs_likeCount() {
    this.xhs_likeCount++;
    chrome.storage.local.set({
      "xhs_likeCount": this.xhs_likeCount
    });
  }
  increment_xhs_followCount() {
    this.xhs_followCount++;
    chrome.storage.local.set({
      "xhs_followCount": this.xhs_followCount
    });
  }
  increment_xhs_collectCount() {
    this.xhs_collectCount++;
    chrome.storage.local.set({
      "xhs_collectCount": this.xhs_collectCount
    });
  }
  increment_dy_viewCount() {
    this.dy_viewCount++;
    chrome.storage.local.set({
      "dy_viewCount": this.dy_viewCount
    });
  }
  increment_dy_CommentCount() {
    this.dy_CommentCount++;
    chrome.storage.local.set({
      "dy_CommentCount": this.dy_CommentCount
    });
  }
  increment_dy_likeCount() {
    this.dy_likeCount++;
    chrome.storage.local.set({
      "dy_likeCount": this.dy_likeCount
    });
  }
  increment_dy_followCount() {
    this.dy_followCount++;
    chrome.storage.local.set({
      "dy_followCount": this.dy_followCount
    });
  }
  increment_dy_collectCount() {
    this.dy_collectCount++;
    chrome.storage.local.set({
      "dy_collectCount": this.dy_collectCount
    });
  }
  isNotRunWork() {
    console.log("isNotRunWork activatePage", this.activatePage, !runPages.includes(this.activatePage));
    return !runPages.includes(this.activatePage);
  }
  setActivatePage(page) {
    console.log("setActivatePage", this.activatePage);
    this.activatePage = page;
  }
  setXiaoHongShu_workStatus(status) {
    this.XiaoHongShu_workStatus = status;
    chrome.storage.local.set({
      "XiaoHongShu_workStatus": this.XiaoHongShu_workStatus
    });
  }
  setXiaoHongShu_avgTime(avgTime) {
    this.XiaoHongShu_avgTime = avgTime;
    chrome.storage.local.set({
      "XiaoHongShu_avgTime": this.XiaoHongShu_avgTime
    });
  }
  setExecuteOperationStartTime(executeOperationStartTime) {
    this.executeOperationStartTime = executeOperationStartTime;
  }
  setExecuteOperationEndTime(executeOperationEndTime) {
    this.executeOperationEndTime = executeOperationEndTime;
    chrome.storage.local.set({
      "executeOperationEndTime": this.executeOperationEndTime
    });
  }
  setXHSKeywords_list(xhs_keywords_list) {
    this.xhs_keywords_list = xhs_keywords_list;
    chrome.storage.local.set({
      "xhs_keywords_list": JSON.stringify(this.xhs_keywords_list)
    });
  }
  setDouYinKeywords_list(douYin_keywords_list) {
    this.douYin_keywords_list = douYin_keywords_list;
    chrome.storage.local.set({
      "douYin_keywords_list": JSON.stringify(this.douYin_keywords_list)
    });
  }
  increment_XiaoHongShu_search_runNumber() {
    this.XiaoHongShu_search_runNumber += 1;
    chrome.storage.local.set({
      "XiaoHongShu_search_runNumber": this.XiaoHongShu_search_runNumber
    });
  }
  increment_DouYin_search_runNumber() {
    this.DouYin_search_runNumber += 1;
    chrome.storage.local.set({
      "DouYin_search_runNumber": this.DouYin_search_runNumber
    });
  }
  increment_XiaoHongShuAccountRunTodayIds(platform, xiaoHongShuAccountIds) {
    this.xiaoHongShuAccountIds.add(xiaoHongShuAccountIds);
    const xiaoHongShuAccountIds_str = JSON.stringify([...this.xiaoHongShuAccountIds]);
    console.log("increment_XiaoHongShuAccountRunTodayIds xiaoHongShuAccountIds_str", xiaoHongShuAccountIds_str, xiaoHongShuAccountIds, this.xiaoHongShuAccountIds);
    const key = platform + "_xiaoHongShuAccountIds";
    const items = {};
    items[key] = xiaoHongShuAccountIds_str;
    chrome.storage.local.set(items);
  }
  setXiaoHongShuAccountRunTodayIds(platform, xiaoHongShuAccountIds) {
    this.xiaoHongShuAccountIds = xiaoHongShuAccountIds;
    const xiaoHongShuAccountIds_str = JSON.stringify([...this.xiaoHongShuAccountIds]);
    console.log("setXiaoHongShuAccountRunTodayIds xiaoHongShuAccountIds_str", xiaoHongShuAccountIds_str, xiaoHongShuAccountIds, this.xiaoHongShuAccountIds);
    const key = platform + "_xiaoHongShuAccountIds";
    const items = {};
    items[key] = xiaoHongShuAccountIds_str;
    chrome.storage.local.set(items);
  }
  setXiaoHongShuAccountRunTodayDate(platform, xiaoHongShuAccountRunTodayDate) {
    this.xiaoHongShuAccountRunTodayDate = xiaoHongShuAccountRunTodayDate;
    const key = platform + "_xiaoHongShuAccountRunTodayDate";
    const items = {};
    items[key] = this.xiaoHongShuAccountRunTodayDate;
    chrome.storage.local.set(items);
  }
  setXiaoHongShuAccountErrorTip(errorMessage) {
    chrome.storage.local.set({
      "xiaoHongShuAccountErrorTip": errorMessage
    });
  }
  setClientVisitorId(clientVisitorId) {
    this.clientVisitorId = clientVisitorId;
    chrome.storage.local.set({
      "clientVisitorId": clientVisitorId
    });
  }
  getOptionWhere() {
    return this.optionWhere;
  }
  setRefreshFrequencyNum(refreshFrequencyNum) {
    this.refreshFrequencyNum = refreshFrequencyNum;
    chrome.storage.local.set({
      "refreshFrequencyNum": refreshFrequencyNum
    });
  }
  setTerminalData(terminalData) {
    this.terminalData = terminalData;
    chrome.storage.local.set({
      "terminalData": JSON.stringify(terminalData)
    });
  }
  setQuestTaskId(questTaskId) {
    this.questTaskId = questTaskId;
    chrome.storage.local.set({
      "questTaskId": questTaskId
    });
  }
  checkLoadend() {
    let maxNum = 60,
      timeout = 30;
    let num = 0;
    return new Promise(resolve => {
      const checkInterval = setInterval(() => {
        const loadend = this.loadend;
        if (loadend || num > maxNum) {
          if (num > maxNum) {
            console.error("checkLoadend 加载超时");
          }
          clearInterval(checkInterval);
          resolve();
        }
        num++;
      }, timeout);
    });
  }
  loadFromStorage() {
    chrome.storage.local.get(["userId", "userName", "tenantId", "webUserId", "webUserName", "webUserAvatarUrl", "cpuSerialNumber", "accessToken", "activatePage", "XiaoHongShu_Setting", "xhs_viewCount", "xhs_CommentCount", "xhs_likeCount", "xhs_followCount", "xhs_collectCount", "dy_viewCount", "dy_CommentCount", "dy_likeCount", "dy_followCount", "dy_collectCount", "XiaoHongShu_workStatus", "XiaoHongShu_avgTime", "XiaoHongShu_search_runNumber", "DouYin_search_runNumber", "xiaoHongShuAccountRunTodayDate", "xiaoHongShuAccountIds", "executeOperationStartTime", "clientVisitorId", "userInfoEndDate", "mqttStart", "optionWhere", "terminalData", "questTaskId"], result => {
      console.log("result activatePage", result);
      if (result.userId !== void 0) {
        this.userId = result.userId;
      }
      if (result.userName !== void 0) {
        this.userName = result.userName;
      }
      if (result.tenantId !== void 0) {
        this.tenantId = result.tenantId;
      }
      if (result.webUserId !== void 0) {
        this.webUserId = result.webUserId;
      }
      if (result.webUserName !== void 0) {
        this.webUserName = result.webUserName;
      }
      if (result.webUserAvatarUrl !== void 0) {
        this.webUserAvatarUrl = result.webUserAvatarUrl;
      }
      if (result.cpuSerialNumber !== void 0) {
        this.cpuSerialNumber = result.cpuSerialNumber;
      }
      if (result.accessToken !== void 0) {
        this.accessToken = result.accessToken;
      }
      if (result.activatePage !== void 0) {
        this.activatePage = result.activatePage;
      }
      if (result.XiaoHongShu_Setting !== void 0) {
        this.XiaoHongShu_Setting = result.XiaoHongShu_Setting;
      }
      if (result.xhs_viewCount !== void 0) {
        this.xhs_viewCount = result.xhs_viewCount;
      }
      if (result.xhs_CommentCount !== void 0) {
        this.xhs_CommentCount = result.xhs_CommentCount;
      }
      if (result.xhs_likeCount !== void 0) {
        this.xhs_likeCount = result.xhs_likeCount;
      }
      if (result.xhs_followCount !== void 0) {
        this.xhs_followCount = result.xhs_followCount;
      }
      if (result.xhs_collectCount !== void 0) {
        this.xhs_collectCount = result.xhs_collectCount;
      }
      if (result.dy_viewCount !== void 0) {
        this.dy_viewCount = result.dy_viewCount;
      }
      if (result.dy_CommentCount !== void 0) {
        this.dy_CommentCount = result.dy_CommentCount;
      }
      if (result.dy_likeCount !== void 0) {
        this.dy_likeCount = result.dy_likeCount;
      }
      if (result.dy_followCount !== void 0) {
        this.dy_followCount = result.dy_followCount;
      }
      if (result.dy_collectCount !== void 0) {
        this.dy_collectCount = result.dy_collectCount;
      }
      if (result.XiaoHongShu_workStatus !== void 0) {
        this.XiaoHongShu_workStatus = result.XiaoHongShu_workStatus;
      }
      if (result.XiaoHongShu_avgTime !== void 0) {
        this.XiaoHongShu_avgTime = result.XiaoHongShu_avgTime;
      }
      if (result.XiaoHongShu_search_runNumber !== void 0) {
        this.XiaoHongShu_search_runNumber = result.XiaoHongShu_search_runNumber;
      }
      if (result.DouYin_search_runNumber !== void 0) {
        this.DouYin_search_runNumber = result.DouYin_search_runNumber;
      }
      if (result.xiaoHongShuAccountRunTodayDate !== void 0) {
        this.xiaoHongShuAccountRunTodayDate = result.xiaoHongShuAccountRunTodayDate;
      }
      if (result.xiaoHongShuAccountIds !== void 0 && result.xiaoHongShuAccountIds) {
        if (typeof result.xiaoHongShuAccountIds === "string") {
          this.xiaoHongShuAccountIds = new Set(JSON.parse(result.xiaoHongShuAccountIds));
        } else if (result.xiaoHongShuAccountIds instanceof Set) {
          this.xiaoHongShuAccountIds = result.xiaoHongShuAccountIds;
        } else if (result.xiaoHongShuAccountIds instanceof Array) {
          this.xiaoHongShuAccountIds = new Set(result.xiaoHongShuAccountIds);
        }
      }
      if (result.executeOperationStartTime !== void 0) {
        this.executeOperationStartTime = result.executeOperationStartTime;
      }
      if (result.clientVisitorId !== void 0) {
        this.clientVisitorId = result.clientVisitorId;
      }
      if (result.userInfoEndDate !== void 0) {
        this.userInfoEndDate = result.userInfoEndDate;
      }
      if (result.mqttStart !== void 0) {
        this.mqttStart = result.mqttStart;
      }
      if (result.terminalData !== void 0) {
        this.terminalData = result.terminalData ? JSON.parse(result.terminalData) : {};
      }
      if (result.optionWhere !== void 0) {
        this.optionWhere = result.optionWhere ? JSON.parse(result.optionWhere) : {};
      }
      if (result.questTaskId !== void 0) {
        this.questTaskId = result.questTaskId;
      }
      this.loadend = true;
    });
    const callBackListener = (changes, namespace) => {
      for (let [key, {
        oldValue,
        newValue
      }] of Object.entries(changes)) {
        console.log(`Storage key "${key}" in namespace "${namespace}" changed.`, `Old value was "${oldValue}", new value is "${newValue}".`);
        switch (key) {
          case "userId":
            this.userId = newValue;
            break;
          case "accessToken":
            this.accessToken = newValue;
            break;
          case "activatePage":
            this.setActivatePage(newValue);
            break;
          case "xhs_likeCount":
            this.xhs_likeCount = newValue;
            break;
          case "xhs_followCount":
            this.xhs_followCount = newValue;
            break;
          case "xhs_CommentCount":
            this.xhs_CommentCount = newValue;
            break;
          case "xhs_collectCount":
            this.xhs_collectCount = newValue;
            break;
          case "xhs_viewCount":
            this.xhs_viewCount = newValue;
            break;
          case "dy_likeCount":
            this.dy_likeCount = newValue;
            break;
          case "dy_followCount":
            this.dy_followCount = newValue;
            break;
          case "dy_CommentCount":
            this.dy_CommentCount = newValue;
            break;
          case "dy_collectCount":
            this.dy_collectCount = newValue;
            break;
          case "dy_viewCount":
            this.dy_viewCount = newValue;
            break;
          case "executeOperationStartTime":
            this.executeOperationStartTime = newValue;
            break;
          case "clientVisitorId":
            this.clientVisitorId = newValue;
            break;
          case "userInfoEndDate":
            this.userInfoEndDate = newValue;
            break;
          case "terminalData":
            this.terminalData = newValue ? JSON.parse(newValue) : {};
            break;
          case "optionWhere":
            this.optionWhere = newValue ? JSON.parse(newValue) : {};
            break;
          case "questTaskId":
            this.questTaskId = newValue;
            break;
        }
      }
    };
    storageUtil.removeListener(callBackListener);
    storageUtil.addHandlers(callBackListener);
  }
};
__publicField(_UseCounterStore, "instance");
let UseCounterStore = _UseCounterStore;
const store$g = UseCounterStore.getInstance();
const addObjects = async postData => {
  if (!store$g.accessToken) {
    console.log("addObjects store.accessToken 为空", store$g.accessToken);
    return;
  }
  const baseURL = "https://plugin-api-adlrdojbyd.ap-northeast-1.fcapp.run";
  const url = baseURL + "/api/v2/oss/objects";
  const headers = {
    "Content-Type": "application/json",
    "Authorization": "Bearer " + store$g.accessToken
  };
  try {
    const response = await fetch(url, {
      method: "POST",
      headers,
      body: JSON.stringify(postData)
    });
    if (!response.ok) {
      console.error("addObjects url:" + url + "，header:" + JSON.stringify(headers) + ", response status:" + response.status);
      return void 0;
    }
    const result = await response.json();
    console.log("addObjects url:" + url + "，header:" + JSON.stringify(headers) + ",postData：" + JSON.stringify(postData) + " response status:" + response.status + ", response data:" + JSON.stringify(result));
    return result;
  } catch (error) {
    console.error("addObjects url:" + url + "，header:" + JSON.stringify(headers) + ", error" + error);
  }
  return void 0;
};
UseCounterStore.getInstance();
function sendLog(...messages) {
  const combinedMessage = messages.map(String).join(" ");
  console.log(combinedMessage);
}
function requestKeepAwake() {
  chrome.power.requestKeepAwake("display");
}
function releaseKeepAwake() {
  chrome.power.releaseKeepAwake();
}
function delay(ms) {
  return new Promise(resolve => setTimeout(resolve, ms));
}
function formatNowDateTime() {
  const date = /* @__PURE__ */new Date();
  const year = date.getFullYear();
  const month = String(date.getMonth() + 1).padStart(2, "0");
  const day = String(date.getDate()).padStart(2, "0");
  const hours = String(date.getHours()).padStart(2, "0");
  const minutes = String(date.getMinutes()).padStart(2, "0");
  return `${year}-${month}-${day} ${hours}:${minutes}`;
}
function formatNowDateTimeSss() {
  const date = /* @__PURE__ */new Date();
  const year = date.getFullYear();
  const month = String(date.getMonth() + 1).padStart(2, "0");
  const day = String(date.getDate()).padStart(2, "0");
  const hours = String(date.getHours()).padStart(2, "0");
  const minutes = String(date.getMinutes()).padStart(2, "0");
  const seconds = String(date.getSeconds()).padStart(2, "0");
  const milliseconds = String(date.getMilliseconds()).padStart(3, "0");
  return `${year}-${month}-${day} ${hours}:${minutes}:${seconds}.${milliseconds}`;
}
const lastTimeMap = /* @__PURE__ */new Map();
function throttle(func, delay2) {
  return function (...args) {
    const now = Date.now();
    const lastTime = lastTimeMap.get(func) || 0;
    if (now - lastTime >= delay2) {
      lastTimeMap.set(func, now);
      func(...args);
    }
  };
}
const VITE_PLUGIN_ID = "dou-yin-automatic-reviews";
const VITE_AGENT_ID$5 = "dou-yin-chrome-extension";
const _MqttManage = class _MqttManage {
  constructor(params, retryInterval = 5e3) {
    __publicField(this, "userId");
    __publicField(this, "userName");
    __publicField(this, "tenantId");
    __publicField(this, "tenantName");
    __publicField(this, "startLoad");
    __publicField(this, "loadend");
    __publicField(this, "mqttClient");
    __publicField(this, "agentId");
    __publicField(this, "clientId");
    __publicField(this, "clientVisitorId");
    __publicField(this, "accessToken");
    __publicField(this, "terminalData");
    __publicField(this, "retryInterval");
    __publicField(this, "onMessageHandlers");
    __publicField(this, "onDisconnectHandlers");
    __publicField(this, "callAgentHandler");
    __publicField(this, "url");
    __publicField(this, "connectBool");
    __publicField(this, "messageHeartInterval");
    __publicField(this, "isStartingInterval");
    __publicField(this, "userCloseBool");
    // 运行的task
    __publicField(this, "runTaskInstance");
    __publicField(this, "webUserId");
    __publicField(this, "webUserName");
    __publicField(this, "webUserAvatarUrl");
    __publicField(this, "macId");
    __publicField(this, "cpuSerialNumber");
    __publicField(this, "chooseCreateTask");
    __publicField(this, "runTaskMqttMessage");
    //心跳去重处理
    __publicField(this, "messageHeartIntervalTime");
    __publicField(this, "throttleMessageHeart");
    __publicField(this, "callBackHandler", (changes, namespace) => {
      for (let [key, {
        oldValue,
        newValue
      }] of Object.entries(changes)) {
        console.log(`Storage key "${key}" in namespace "${namespace}" changed.`, `Old value was "${oldValue}", new value is "${newValue}".`);
        switch (key) {
          case "clientVisitorId":
            this.clientVisitorId = newValue;
            break;
          case "accessToken":
            this.accessToken = newValue;
            break;
          case "userId":
            this.userId = newValue;
            if (newValue === "" && this.mqttClient) {
              this.closeMqtt();
              break;
            }
            if (this.userId && this.tenantId && this.terminalData && this.terminalData.terminalId) {
              this.connectMqtt();
            }
            break;
          case "userName":
            this.userName = newValue;
            break;
          case "tenantId":
            this.tenantId = newValue;
            if (newValue === "" && this.mqttClient) {
              this.closeMqtt();
              break;
            }
            if (this.userId && this.tenantId && this.terminalData && this.terminalData.terminalId) {
              this.connectMqtt();
            }
            break;
          case "tenantName":
            this.tenantName = newValue;
            break;
          case "terminalData":
            this.terminalData = newValue == "" ? {} : JSON.parse(newValue);
            if (this.userId && this.tenantId && this.terminalData && this.terminalData.terminalId) {
              this.connectMqtt();
            }
            break;
          case "webUserId":
            this.webUserId = newValue;
            break;
          case "webUserName":
            this.webUserName = newValue;
            break;
          case "webUserAvatarUrl":
            this.webUserAvatarUrl = newValue;
            break;
          case "macId":
            this.macId = newValue;
            break;
          case "cpuSerialNumber":
            this.cpuSerialNumber = newValue;
            break;
          case "runTaskMqttMessage":
            this.runTaskMqttMessage = newValue;
            break;
        }
      }
    });
    this.url = "ws://8.130.13.226:8945/ws";
    this.retryInterval = retryInterval;
    this.agentId = "default";
    this.clientId = "default";
    if (params.retryInterval) this.retryInterval = params.retryInterval;
    if (params.agentId) this.agentId = params.agentId;
    if (params.clientId) this.clientId = params.clientId;
    this.onMessageHandlers = [];
    this.onDisconnectHandlers = [];
    this.callAgentHandler = null;
    this.userId = "";
    this.userName = "";
    this.tenantId = "";
    this.tenantName = "";
    this.clientVisitorId = "";
    this.accessToken = "";
    this.userCloseBool = false;
    this.isStartingInterval = false;
    this.messageHeartIntervalTime = 5e3;
    this.throttleMessageHeart = throttle(this.messageHeart, this.messageHeartIntervalTime - 500);
    this.terminalData = {};
    this.startLoad = false;
    this.loadend = false;
    this.mqttClient = null;
    this.connectBool = false;
    this.messageHeartInterval = null;
    this.runTaskInstance = null;
    this.webUserId = "";
    this.webUserName = "";
    this.webUserAvatarUrl = "";
    this.macId = "";
    this.cpuSerialNumber = "";
    this.runTaskMqttMessage = "";
    this.chooseCreateTask = null;
    this.loadFromStorage();
  }
  updateParams(params) {
    if (params.retryInterval) this.retryInterval = params.retryInterval;
    if (params.accessToken) this.accessToken = params.accessToken;
    if (params.agentId) this.clientId = params.agentId;
    if (params.clientId) this.clientId = params.clientId;
    if (params.userId) this.userId = params.userId;
  }
  getDisconnectedStatus() {
    if (!this.mqttClient) {
      return true;
    }
    return this.mqttClient.disconnecting;
  }
  connectMqtt() {
    var _a, _b, _c, _d, _e, _f, _g, _h;
    if (!this.url) {
      sendLog("URL must be provided");
      return;
    }
    if (this.connectBool) {
      sendLog("Connecting to " + this.connectBool);
      return;
    }
    if (!((_b = (_a = this.terminalData) == null ? void 0 : _a.topic) == null ? void 0 : _b.task_topic)) {
      sendLog("this.terminalData?.topic?.task_topic 为空", (_d = (_c = this.terminalData) == null ? void 0 : _c.topic) == null ? void 0 : _d.task_topic);
      return;
    }
    this.connectBool = true;
    sendLog("clientVisitorId：" + this.clientVisitorId);
    sendLog("this.terminalData?.terminalId", (_e = this.terminalData) == null ? void 0 : _e.terminalId);
    sendLog("clientId：" + this.clientId);
    sendLog("user_id", this.userId);
    sendLog("tenantId", this.tenantId);
    sendLog("this.terminalData", JSON.stringify(this.terminalData));
    this.mqttClient = mqtt.connect(this.url, {
      username: (_f = this.terminalData) == null ? void 0 : _f.mqtt_username,
      password: (_g = this.terminalData) == null ? void 0 : _g.mqtt_password,
      reconnectPeriod: 0,
      // 设置重连间隔为 0，禁用重连
      keepalive: 15,
      // pingInterval: 5000,
      clientId: (_h = this.terminalData) == null ? void 0 : _h.terminalId
    });
    this.mqttClient.on("connect", () => {
      var _a2, _b2, _c2, _d2;
      sendLog(`[MQTTConnection::connect] Connected to ${this.url}`);
      if (!this.mqttClient) {
        sendLog("this.mqttClient is null");
        return;
      }
      sendLog("this.terminalData?.topic?.task_topic", (_b2 = (_a2 = this.terminalData) == null ? void 0 : _a2.topic) == null ? void 0 : _b2.task_topic);
      this.mqttClient.subscribe((_d2 = (_c2 = this.terminalData) == null ? void 0 : _c2.topic) == null ? void 0 : _d2.task_topic, err => {
        sendLog("subscribe1", err);
        if (!err) {
          sendLog("Subscribed to topic");
          this.connectSuccess();
          this.checkRunTaskAndRestartTask();
          chrome.storage.local.set({
            "mqttConnectBool": true
          }, () => {});
          this.startMessageHeartInterval();
        }
      });
    });
    this.mqttClient.on("reconnect", () => {
      sendLog(`[MQTTConnection::reconnect] Reconnected to ${this.url}`);
    });
    this.mqttClient.on("message", async (topic, message) => {
      sendLog("topic", topic);
      const parsedMessage = JSON.parse(message.toString());
      this.onMessageHandlers.forEach(handler => handler(parsedMessage));
    });
    this.mqttClient.on("close", () => {
      sendLog("MQTT connection closed");
      if (!this.userCloseBool) {
        this.reconnectingMqtt();
      }
    });
    this.mqttClient.on("error", error => {
      console.error("MQTT error:", error);
      sendLog("MQTT error:", error);
      if (this.mqttClient) {
        this.mqttClient.end(true, {
          reasonCode: 500,
          properties: {
            reasonString: "错误处理" + JSON.stringify(error)
          }
        }, () => {
          console.log("close end");
        });
      }
    });
    this.mqttClient.on("disconnect", packet => {
      sendLog("disconnect this.userCloseBool", packet, this.userCloseBool);
      if (!this.userCloseBool) {
        this.reconnectingMqtt();
      }
    });
    this.mqttClient.on("offline", () => {
      sendLog("offline: this.userCloseBool" + this.userCloseBool);
      if (!this.userCloseBool) {
        this.reconnectingMqtt();
      }
    });
  }
  registeMessageFromMQTT(handler) {
    this.onMessageHandlers.push(handler);
  }
  registeDisconnect(handler) {
    this.onDisconnectHandlers.push(handler);
  }
  clearMessageHeartInterval() {
    if (this.messageHeartInterval) {
      clearInterval(this.messageHeartInterval);
      this.messageHeartInterval = null;
    }
  }
  startMessageHeartInterval() {
    if (this.isStartingInterval) return;
    this.isStartingInterval = true;
    this.clearMessageHeartInterval();
    this.messageHeartInterval = setInterval(() => {
      this.throttleMessageHeart(this);
    }, this.messageHeartIntervalTime);
    this.isStartingInterval = false;
  }
  messageHeart(that) {
    var _a, _b, _c, _d;
    if (that && that.mqttClient && that.mqttClient.connected) {
      let heartReportData = (_a = that.runTaskInstance) == null ? void 0 : _a.getHeartReportData();
      if (!heartReportData) {
        heartReportData = {
          runStatus: {
            //运行页面状态
            stopButtonText: "没有运行任务",
            formattedTime: ""
          }
        };
      }
      heartReportData = {
        ...heartReportData,
        webLoginInfo: {
          // 登录抖音账号的名称
          webUserId: that.webUserId,
          webUserName: that.webUserName,
          webUserAvatarUrl: that.webUserAvatarUrl,
          tenantId: that.tenantId,
          tenantName: that.tenantName,
          pluginName: "客资工具",
          userId: that.userId,
          userName: that.userName,
          macId: that.macId,
          cpuSerialNumber: that.cpuSerialNumber
        }
      };
      const postMessage = {
        "s": "ok",
        "n": (_b = that.terminalData) == null ? void 0 : _b.terminalName,
        "t": (/* @__PURE__ */new Date()).getTime(),
        taskData: heartReportData
      };
      console.log("messageHeart", postMessage);
      that.mqttClient.publish((_d = (_c = that.terminalData) == null ? void 0 : _c.topic) == null ? void 0 : _d.heart_beat_topics, JSON.stringify(postMessage));
    } else {
      console.log("mqttClient 没有连接成功");
    }
  }
  connectSuccess() {
    setTimeout(() => {
      var _a, _b, _c;
      try {
        if (this.mqttClient && this.mqttClient.connected) {
          let heartReportData = {
            runStatus: {
              runLogs: "Mqtt链接成功",
              //运行页面状态
              stopButtonText: "没有运行任务",
              formattedTime: ""
            },
            webLoginInfo: {
              // 登录抖音账号的名称
              webUserId: this.webUserId,
              webUserName: this.webUserName,
              webUserAvatarUrl: this.webUserAvatarUrl,
              tenantId: this.tenantId,
              tenantName: this.tenantName,
              pluginName: "客资工具",
              userId: this.userId,
              userName: this.userName,
              macId: this.macId,
              cpuSerialNumber: this.cpuSerialNumber
            }
          };
          const postMessage = {
            "s": "ok",
            "n": (_a = this.terminalData) == null ? void 0 : _a.terminalName,
            "t": (/* @__PURE__ */new Date()).getTime(),
            taskData: heartReportData
          };
          sendLog("connectSuccess messageHeart", JSON.stringify(postMessage));
          this.mqttClient.publish((_c = (_b = this.terminalData) == null ? void 0 : _b.topic) == null ? void 0 : _c.heart_beat_topics, JSON.stringify(postMessage));
        }
      } catch (e) {
        console.log("connectSuccess", e);
      } finally {
        sendLog("connectSuccess messageHeart end");
      }
    }, 1e3);
  }
  setChooseCreateTask(chooseCreateTask2) {
    this.chooseCreateTask = chooseCreateTask2;
  }
  checkRunTaskAndRestartTask() {
    console.log("checkRunTaskAndRestartTask");
    if (this.runTaskMqttMessage && this.chooseCreateTask && false) ;
  }
  messageToReplyMQTT(message) {
    var _a, _b, _c, _d;
    if (this.mqttClient && this.mqttClient.connected) {
      sendLog("task_reply_topics message", JSON.stringify({
        task_reply_topics: (_b = (_a = this.terminalData) == null ? void 0 : _a.topic) == null ? void 0 : _b.task_reply_topics,
        message
      }));
      this.mqttClient.publish((_d = (_c = this.terminalData) == null ? void 0 : _c.topic) == null ? void 0 : _d.task_reply_topics, JSON.stringify(message));
    } else {
      sendLog("mqttClient 没有连接成功");
    }
  }
  messageToStatusMQTT(message) {
    var _a, _b, _c, _d;
    if (this.mqttClient && this.mqttClient.connected) {
      sendLog("status_reply_topics message", JSON.stringify({
        status_reply_topics: (_b = (_a = this.terminalData) == null ? void 0 : _a.topic) == null ? void 0 : _b.status_reply_topics,
        message
      }));
      this.mqttClient.publish((_d = (_c = this.terminalData) == null ? void 0 : _c.topic) == null ? void 0 : _d.status_reply_topics, JSON.stringify(message));
    } else {
      console.log("mqttClient 没有连接成功");
    }
  }
  messageToReportMQTT(message) {
    var _a, _b, _c, _d;
    if (this.mqttClient && this.mqttClient.connected) {
      sendLog("report_topics message", JSON.stringify({
        report_topics: (_b = (_a = this.terminalData) == null ? void 0 : _a.topic) == null ? void 0 : _b.report_topics,
        message
      }));
      this.mqttClient.publish((_d = (_c = this.terminalData) == null ? void 0 : _c.topic) == null ? void 0 : _d.report_topics, JSON.stringify(message));
    } else {
      sendLog("mqttClient 没有连接成功");
    }
  }
  messageToRunLogsMQTT(message) {
    var _a, _b, _c, _d;
    if (this.mqttClient && this.mqttClient.connected) {
      sendLog("run_logs_reply_topics message", JSON.stringify({
        run_logs_reply_topics: (_b = (_a = this.terminalData) == null ? void 0 : _a.topic) == null ? void 0 : _b.run_logs_reply_topics,
        message
      }));
      this.mqttClient.publish((_d = (_c = this.terminalData) == null ? void 0 : _c.topic) == null ? void 0 : _d.run_logs_reply_topics, JSON.stringify(message));
    } else {
      sendLog("mqttClient 没有连接成功");
    }
  }
  setRunTaskMqttMessage(runTaskMqttMessage) {
    this.runTaskMqttMessage = runTaskMqttMessage;
    chrome.storage.local.set({
      "runTaskMqttMessage": this.runTaskMqttMessage
    });
  }
  clearRunTaskMqttMessage() {
    this.runTaskMqttMessage = "";
    chrome.storage.local.set({
      "runTaskMqttMessage": ""
    });
  }
  reconnectingMqtt() {
    if (this.connectBool) {
      this.connectBool = false;
      this.clearMessageHeartInterval();
      chrome.storage.local.set({
        "mqttConnectBool": false
      }, () => {});
      this.mqttClient = null;
      setTimeout(() => {
        this.connectMqtt();
      }, this.retryInterval);
      this.onDisconnectHandlers.forEach(handler => handler());
    } else {
      sendLog("已经开始重新连接了");
    }
  }
  setRunTaskInstance(runTaskInstance) {
    this.runTaskInstance = runTaskInstance;
  }
  //
  // async messageFromTaskToAgent(message:any) {
  //     if(!this.callAgentHandler){
  //         return
  //     }
  //     return this.callAgentHandler(message);
  // }
  // disconnect() {
  //     console.log("disconnect")
  //     if (this.mqttClient && this.mqttClient.connected) {
  //         this.mqttClient.end();
  //     } else {
  //         console.warn("MQTT is already disconnected.");
  //     }
  // }
  // 获取唯一实例的方法
  static getInstance() {
    if (!_MqttManage.instance) {
      _MqttManage.instance = new _MqttManage({
        agentId: VITE_AGENT_ID$5,
        clientId: VITE_PLUGIN_ID
      });
    }
    return _MqttManage.instance;
  }
  closeMqtt() {
    sendLog("closeMqtt");
    if (this.mqttClient) {
      this.userCloseBool = true;
      this.mqttClient.end(true, {
        reasonCode: 500,
        properties: {
          reasonString: "用户退出"
        }
      }, () => {
        sendLog("closeMqtt close end");
      });
    }
  }
  loadFromStorage() {
    if (this.startLoad) {
      sendLog("startLoad", this.startLoad);
      return;
    }
    this.startLoad = true;
    chrome.storage.local.get(["userId", "userName", "tenantId", "tenantName", "clientVisitorId", "accessToken", "terminalData", "webUserId", "webUserName", "webUserAvatarUrl", "macId", "cpuSerialNumber", "runTaskMqttMessage"], result => {
      console.log("result activatePage", result);
      if (result.userId !== void 0) {
        this.userId = result.userId;
      }
      if (result.userName !== void 0) {
        this.userName = result.userName;
      }
      if (result.tenantId !== void 0) {
        this.tenantId = result.tenantId;
      }
      if (result.tenantName !== void 0) {
        this.tenantName = result.tenantName;
      }
      if (result.clientVisitorId !== void 0) {
        this.clientVisitorId = result.clientVisitorId;
      }
      if (result.accessToken !== void 0) {
        this.accessToken = result.accessToken;
      }
      if (result.terminalData !== void 0) {
        this.terminalData = result.terminalData == "" ? {} : JSON.parse(result.terminalData);
      }
      if (this.userId && this.tenantId && this.terminalData && this.terminalData.terminalId) {
        this.connectMqtt();
      }
      if (result.webUserId !== void 0) {
        this.webUserId = result.webUserId;
      }
      if (result.webUserName !== void 0) {
        this.webUserName = result.webUserName;
      }
      if (result.webUserAvatarUrl !== void 0) {
        this.webUserAvatarUrl = result.webUserAvatarUrl;
      }
      if (result.macId !== void 0) {
        this.macId = result.macId;
      }
      if (result.cpuSerialNumber !== void 0) {
        this.cpuSerialNumber = result.cpuSerialNumber;
      }
      if (result.runTaskMqttMessage !== void 0) {
        this.runTaskMqttMessage = result.runTaskMqttMessage;
      }
      this.startLoad = true;
      this.loadend = true;
    });
    storageUtil.removeListener(this.callBackHandler);
    storageUtil.addHandlers(this.callBackHandler);
  }
};
__publicField(_MqttManage, "instance");
let MqttManage = _MqttManage;
const mqttManage = MqttManage.getInstance();
class AsyncTaskQueue {
  constructor(concurrency) {
    __publicField(this, "concurrency");
    __publicField(this, "running", 0);
    __publicField(this, "taskQueue", []);
    this.concurrency = concurrency;
  }
  // 添加任务到队列，如果没有空余并发数则阻塞
  async enqueue(task) {
    if (this.running >= this.concurrency) {
      await new Promise(resolve => {
        this.taskQueue.push(() => {
          this.runTask(task);
          resolve();
        });
      });
    } else {
      this.runTask(task).then(() => {});
    }
  }
  // 执行任务，并控制并发数
  async runTask(task) {
    this.running++;
    try {
      await task();
    } finally {
      this.running--;
      if (this.taskQueue.length > 0) {
        const nextTask = this.taskQueue.shift();
        nextTask();
      }
    }
  }
  // 等待所有任务完成
  async waitForAll() {
    return new Promise(resolve => {
      const checkFinished = () => {
        if (this.running === 0 && this.taskQueue.length === 0) {
          resolve();
        } else {
          setTimeout(checkFinished, 50);
        }
      };
      checkFinished();
    });
  }
}
class TaskManager {
  constructor() {
    __publicField(this, "taskQueue");
    __publicField(this, "executeQueue");
    __publicField(this, "executeNotification");
    __publicField(this, "executeStartBool");
    __publicField(this, "taskMap");
    this.taskQueue = [];
    this.executeNotification = null;
    this.executeQueue = new AsyncTaskQueue(1);
    this.executeStartBool = true;
    this.taskMap = {};
    this.executeStart().then(() => {});
  }
  async executeStart() {
    while (this.executeStartBool) {
      if (this.taskQueue.length === 0) {
        sendLog("等待下一个任务");
        this.executeNotification = null;
        if (this.taskQueue.length === 0) {
          await this.startNotification();
        }
      }
      while (this.executeStartBool) {
        if (this.taskQueue.length > 0) {
          const nextTask = this.taskQueue.shift();
          this.taskMap[nextTask.taskId] = nextTask;
          const openNewWindowNote = () => {
            return () => new Promise(async resolve => {
              try {
                sendLog("任务nextTask.taskId：", nextTask.taskId);
                await nextTask.start();
                await nextTask.executeEnd();
                sendLog("任务完成nextTask.taskId：", nextTask.taskId);
                resolve();
              } catch (error) {
                sendLog("openNewWindowNote error", error, nextTask.taskId);
                resolve();
              }
            });
          };
          await this.executeQueue.enqueue(openNewWindowNote());
          sendLog("executeQueue.enqueue 完成");
          await this.executeQueue.waitForAll();
          sendLog("executeQueue.waitForAll 完成");
        } else {
          break;
        }
      }
    }
    await this.executeQueue.waitForAll();
  }
  /**
   * 等待新数据加入
   */
  startNotification() {
    return new Promise(resolve => {
      this.executeNotification = resolve;
    });
  }
  /**
   * 加入数据
   * @param baseTask
   */
  async addTask(baseTask) {
    if (!baseTask.checkConfig()) {
      sendLog("检查任务配置错误，不添加到队列");
      return;
    }
    if (this.taskQueue.length > 0) {
      sendLog("队列中存在其他任务");
      for (let i = 0; i < this.taskQueue.length; i++) {
        sendLog("this.taskQueue[i].taskId", this.taskQueue[i].taskId);
        sendLog("this.taskQueue[i].executeId", this.taskQueue[i].executeId);
        sendLog("this.taskQueue[i].data", JSON.stringify(this.taskQueue[i].data));
      }
    }
    console.log("将任务添加到队列中");
    sendLog("baseTask.taskId", baseTask.taskId);
    sendLog("baseTask.executeId", baseTask.executeId);
    sendLog("baseTask.data", JSON.stringify(baseTask.data));
    this.taskQueue.push(baseTask);
    if (this.executeNotification != null) {
      sendLog("通知开始执行任务");
      this.executeNotification();
      this.executeNotification = null;
    }
  }
  /**
   * 停止任务
   * @param taskId
   */
  async stopTask(taskId) {
    console.log("this.taskMap", this.taskMap);
    sendLog("this.taskMap:" + taskId);
    console.log("this.taskMap[taskId]", this.taskMap[taskId]);
    if (this.taskMap && taskId && this.taskMap[taskId]) {
      const baseTask = this.taskMap[taskId];
      await baseTask.stopTask();
      await baseTask.checkIfTabExists();
      console.log("stopTask", taskId);
      return baseTask.tabId;
    }
    return 0;
  }
  /**
   * 上传报告
   * @param taskId
   */
  async report(taskId) {
    sendLog("report");
    if (this.taskMap && taskId && this.taskMap[taskId]) {
      const baseTask = this.taskMap[taskId];
      sendLog("report pre");
      await baseTask.report();
      sendLog("report post");
    }
  }
  /**
   * 窗口都关闭， 任务结束
   * @param taskId
   */
  async abortTask(taskId) {
    var _a;
    if (this.taskMap && taskId && this.taskMap[taskId]) {
      const baseTask = this.taskMap[taskId];
      (_a = baseTask.conn) == null ? void 0 : _a.clearRunTaskMqttMessage();
      await baseTask.abortTask();
      delete this.taskMap[taskId];
    }
  }
  /**
   * 主动停止正在运行的任务
   */
  async stopRunTasks(stopTaskBool) {
    if (this.taskMap && stopTaskBool) {
      console.log("stopRunTasks ", formatNowDateTimeSss(), stopTaskBool);
      const keys = Object.keys(this.taskMap);
      if (keys && keys.length > 0) {
        for (let i = 0; i < keys.length; i++) {
          sendLog("stopRunTasks, taskId:", keys[i]);
          const tabId = await this.stopTask(keys[i]);
          console.log("tabId", tabId);
          if (tabId) {
            for (let i2 = 0; i2 < 10; i2++) {
              await delay(1e3);
              if (!this.taskMap[keys[i2]]) {
                break;
              }
            }
          }
          await this.abortTask(keys[i]);
          console.log("stopRunTasks", keys[i]);
        }
      }
    }
    console.log("stopRunTasks end");
  }
  destroy() {
    this.executeStartBool = false;
  }
}
class BaseTask {
  constructor(taskId, executeId, data) {
    __publicField(this, "windowId");
    __publicField(this, "tabId");
    __publicField(this, "taskId");
    __publicField(this, "clientId");
    __publicField(this, "token");
    __publicField(this, "data");
    __publicField(this, "running");
    __publicField(this, "paused");
    __publicField(this, "started");
    __publicField(this, "user_id");
    __publicField(this, "orgId");
    __publicField(this, "clientVisitorId");
    __publicField(this, "accessToken");
    __publicField(this, "execute_index");
    __publicField(this, "data_list");
    __publicField(this, "conn");
    __publicField(this, "executeId");
    __publicField(this, "executeNotification");
    __publicField(this, "baseStartLoad");
    __publicField(this, "baseLoadend");
    __publicField(this, "terminalData");
    __publicField(this, "runLogs");
    __publicField(this, "stopButtonText");
    __publicField(this, "formattedTime");
    // async callAgent(cmd:any) {
    //     if (!this.running) {
    //         throw new Error("Task is not running or paused.");
    //     }
    //
    //     while (this.paused) {
    //         await new Promise((resolve) => setTimeout(resolve, 100));
    //     }
    //     return await this.conn.messageFromTaskToAgent(cmd);
    // }
    __publicField(this, "reportRunLogs", async () => {
      var _a;
      console.log("reportRunLogs");
      if (!this.conn) {
        return;
      }
      console.log("runLogs：", this.runLogs);
      this.conn.messageToRunLogsMQTT({
        "taskId": this.taskId,
        "data": this.runLogs,
        "userId": this.user_id,
        "terminalId": (_a = this.terminalData) == null ? void 0 : _a.terminalId
      });
      this.conn.messageHeart(this.conn);
    });
    __publicField(this, "baseCallBackListener", (changes, namespace) => {
      for (let [key, {
        oldValue,
        newValue
      }] of Object.entries(changes)) {
        console.log(`customizeTask Storage key "${key}" in namespace "${namespace}" changed.`, `Old value was "${oldValue}", new value is "${newValue}".`);
        switch (key) {
          case "orgId":
            this.orgId = newValue;
            break;
          case "userId":
            this.user_id = newValue;
            break;
          case "clientVisitorId":
            this.clientVisitorId = newValue;
            break;
          case "accessToken":
            this.accessToken = newValue;
            break;
          case "terminalData":
            this.terminalData = newValue == "" ? {} : JSON.parse(newValue);
            break;
          case "runLogs":
            this.runLogs = newValue;
            this.reportRunLogs().then();
            break;
          case "stopButtonText":
            this.stopButtonText = newValue;
            break;
          case "formattedTime":
            this.formattedTime = newValue;
            break;
        }
      }
    });
    this.taskId = taskId;
    this.windowId = 0;
    this.tabId = 0;
    this.clientId = null;
    this.token = null;
    this.data = data;
    this.running = false;
    this.paused = false;
    this.started = false;
    this.user_id = null;
    this.orgId = "";
    this.clientVisitorId = "";
    this.accessToken = "";
    this.execute_index = 0;
    this.data_list = [];
    this.conn = null;
    this.executeId = executeId;
    this.executeNotification = null;
    this.terminalData = {};
    this.baseStartLoad = false;
    this.baseLoadend = false;
    this.runLogs = "";
    this.stopButtonText = "";
    this.formattedTime = "";
    this.baseLoadFromStorage();
  }
  setConn(conn) {
    this.conn = conn;
    this.clientId = this.conn.clientId;
    this.token = this.conn.accessToken;
    this.user_id = this.conn.userId;
    this.conn.setRunTaskInstance(this);
  }
  async start() {
    if (this.running) return;
    this.started = true;
    this.running = true;
    this.paused = false;
    sendLog("Task started");
    if (!this.conn) {
      return;
    }
    this.conn.messageToReplyMQTT({
      "taskId": this.taskId,
      "executeId": this.executeId,
      "status": "started",
      "meta": {},
      "message": "准备执行"
    });
    try {
      await this.startTask();
      this.conn.setRunTaskInstance(this);
    } catch (e) {
      console.error(e);
      this.conn.setRunTaskInstance(null);
      this.conn.messageToReplyMQTT({
        "taskId": this.taskId,
        "executeId": this.executeId,
        "status": "failed",
        "meta": this.getBaseStatus(),
        "message": "执行出错：" + e
      });
    }
    this.running = false;
  }
  pause() {
    if (!this.running) return;
    this.paused = true;
    sendLog("Task paused");
    if (!this.conn) {
      return;
    }
    this.conn.messageToReplyMQTT({
      "taskId": this.taskId,
      "executeId": this.executeId,
      "status": "running",
      "meta": this.getBaseStatus(),
      "message": "已暂停"
    });
  }
  async resume() {
    if (!this.running || !this.paused) return;
    if (!this.conn) {
      return;
    }
    this.paused = false;
    sendLog("Task resumed");
    this.conn.messageToReplyMQTT({
      "taskId": this.taskId,
      "executeId": this.executeId,
      "status": "running",
      "meta": this.getBaseStatus(),
      "message": "已恢复"
    });
    await this.startTask();
  }
  baseReportStop() {
    storageUtil.removeListener(this.baseCallBackListener);
  }
  /**
   * 通知执行任务完成，可以开始下一个任务
   */
  callExecuteNotification() {
    if (this.executeNotification) {
      this.executeNotification();
    }
  }
  getBaseStatus() {
    return {
      id: this.taskId,
      running: this.running,
      paused: this.paused,
      started: this.started,
      data: JSON.parse(JSON.stringify(this.data)),
      data_list: JSON.parse(JSON.stringify(this.data_list)),
      process: 0,
      execute_index: this.execute_index
    };
  }
  /**
   * 等待执行完成
   */
  executeEnd() {
    return new Promise(resolve => {
      this.executeNotification = resolve;
    });
  }
  checkIfTabExists() {
    return new Promise(resolve => {
      let checkIfTabExistsSetInterval = null;
      if (this.tabId !== 0 && this.tabId > 0 && this.windowId !== 0 && this.windowId > 0) {
        let maxNum = 10;
        let num = 0;
        checkIfTabExistsSetInterval = setInterval(() => {
          num++;
          if (num > maxNum) {
            clearInterval(checkIfTabExistsSetInterval);
            resolve(false);
          }
          chrome.tabs.query({
            windowId: this.windowId
          }, tabs => {
            let tabExists = tabs.some(tab => tab.id === this.tabId);
            if (!tabExists) {
              clearInterval(checkIfTabExistsSetInterval);
              resolve(true);
            } else {
              console.error("窗口还存在");
            }
          });
        }, 3 * 1e3);
      } else {
        resolve(false);
      }
    });
  }
  // Helper function to add the authorization header (assumed to be implemented in your extension)
  addAuthorizationHeader() {
    return {
      Authorization: `Bearer ${this.token}`
    };
  }
  baseLoadFromStorage() {
    if (this.baseStartLoad) {
      console.log("startLoad", this.baseStartLoad);
      return;
    }
    this.baseStartLoad = true;
    chrome.storage.local.get(["terminalData", "userId", "orgId", "clientVisitorId", "accessToken", "runLogs", "stopButtonText", "formattedTime"], result => {
      console.log("result activatePage", result);
      if (!result) {
        return;
      }
      if (result.userId !== void 0) {
        this.user_id = result.userId;
      }
      if (result.orgId !== void 0) {
        this.orgId = result.orgId;
      }
      if (result.clientVisitorId !== void 0) {
        this.clientVisitorId = result.clientVisitorId;
      }
      if (result.accessToken !== void 0) {
        this.accessToken = result.accessToken;
      }
      if (result.terminalData !== void 0) {
        this.terminalData = result.terminalData == "" ? {} : JSON.parse(result.terminalData);
      }
      if (result.stopButtonText !== void 0) {
        this.stopButtonText = result.stopButtonText;
      }
      if (result.formattedTime !== void 0) {
        this.formattedTime = result.formattedTime;
      }
      this.baseStartLoad = true;
      this.baseLoadend = true;
    });
    storageUtil.addHandlers(this.baseCallBackListener);
  }
}
const VITE_CONTENT_API$9 = "https://agent-net.paitongai.net/content";
const store$f = UseCounterStore.getInstance();
class XiaohongshuTask extends BaseTask {
  constructor(taskId, executeId, data, executeTask2) {
    super(taskId, executeId, data);
    __publicField(this, "executeTask");
    //评论数量
    __publicField(this, "xhs_viewCount");
    __publicField(this, "xhs_CommentCount");
    __publicField(this, "xhs_likeCount");
    __publicField(this, "xhs_followCount");
    __publicField(this, "xhs_collectCount");
    //评论数量
    __publicField(this, "dy_viewCount");
    __publicField(this, "dy_CommentCount");
    __publicField(this, "dy_likeCount");
    __publicField(this, "dy_followCount");
    __publicField(this, "dy_collectCount");
    __publicField(this, "taskPlatform");
    __publicField(this, "XiaoHongShu_Setting");
    __publicField(this, "operationTime");
    __publicField(this, "runMinuteTime");
    __publicField(this, "startLoad");
    __publicField(this, "loadend");
    // 上报数据
    __publicField(this, "executeOperationStartTime");
    __publicField(this, "executeOperationEndTime");
    __publicField(this, "xhs_keywords_list");
    __publicField(this, "douYin_keywords_list");
    __publicField(this, "xhs_minute");
    __publicField(this, "dy_minute");
    __publicField(this, "reportRunDataStatus", async () => {
      var _a;
      console.log("reportRunDataStatus");
      if (!this.conn) {
        return;
      }
      const runData = this.getRunData();
      console.log("runData", JSON.stringify(runData));
      this.conn.messageToStatusMQTT({
        "taskId": this.taskId,
        "data": runData,
        "userId": this.user_id,
        "terminalId": (_a = this.terminalData) == null ? void 0 : _a.terminalId
      });
    });
    __publicField(this, "reportRunData", async () => {
      var _a;
      const url = VITE_CONTENT_API$9 + "/api/content/";
      const headers = {
        "Content-Type": "application/json",
        ...this.addAuthorizationHeader()
        // Ensure this function works in the extension
      };
      try {
        console.log("reportRunData");
        const runData = this.getRunData();
        console.log("runData", JSON.stringify(runData));
        const postData = {
          "taskId": this.taskId,
          "data": runData,
          "userId": this.user_id,
          "terminalId": (_a = this.terminalData) == null ? void 0 : _a.terminalId
        };
        const response = await fetch(url, {
          method: "POST",
          headers,
          body: JSON.stringify(postData)
        });
        if (!response.ok) {
          console.log("url:" + url + "，header:" + JSON.stringify(headers) + ", response status:" + response.status);
          return;
        }
        const result = await response.json();
        console.log("url:" + url + "，header:" + JSON.stringify(headers) + ",postData：" + JSON.stringify(postData) + " response status:" + response.status + ", response data:" + JSON.stringify(result));
      } catch (error) {
        console.log("Error in putNewTask:", error);
        sendLog("url:" + url + "，header:" + JSON.stringify(headers) + ", error" + error);
      }
    });
    __publicField(this, "callBackListener", (changes, namespace) => {
      for (let [key, {
        oldValue,
        newValue
      }] of Object.entries(changes)) {
        console.log(`customizeTask Storage key "${key}" in namespace "${namespace}" changed.`, `Old value was "${oldValue}", new value is "${newValue}".`);
        switch (key) {
          case "runTaskStopped":
            if (newValue == "end") {
              this.reportStop();
            }
            break;
          case "taskPlatform":
            this.taskPlatform = newValue;
            break;
          case "XiaoHongShu_Setting":
            this.XiaoHongShu_Setting = newValue ? JSON.parse(newValue) : {};
            break;
          case "orgId":
            this.orgId = newValue;
            break;
          case "userId":
            this.user_id = newValue;
            break;
          case "clientVisitorId":
            this.clientVisitorId = newValue;
            break;
          case "accessToken":
            this.accessToken = newValue;
            break;
          case "operationTime":
            this.operationTime = newValue;
            break;
          case "runMinuteTime":
            this.runMinuteTime = newValue;
            this.reportReply();
            break;
          case "xhs_likeCount":
            this.xhs_likeCount = newValue;
            this.reportRunDataStatus().then();
            break;
          case "xhs_followCount":
            this.xhs_followCount = newValue;
            this.reportRunDataStatus().then();
            break;
          case "xhs_CommentCount":
            this.xhs_CommentCount = newValue;
            this.reportRunDataStatus().then();
            break;
          case "xhs_collectCount":
            this.xhs_collectCount = newValue;
            this.reportRunDataStatus().then();
            break;
          case "xhs_viewCount":
            this.xhs_viewCount = newValue;
            this.reportRunDataStatus().then();
            break;
          case "dy_likeCount":
            this.dy_likeCount = newValue;
            this.reportRunDataStatus().then();
            break;
          case "dy_followCount":
            this.dy_followCount = newValue;
            this.reportRunDataStatus().then();
            break;
          case "dy_CommentCount":
            this.dy_CommentCount = newValue;
            this.reportRunDataStatus().then();
            break;
          case "dy_collectCount":
            this.dy_collectCount = newValue;
            this.reportRunDataStatus().then();
            break;
          case "dy_viewCount":
            this.dy_viewCount = newValue;
            this.reportRunDataStatus().then();
            break;
          case "executeOperationStartTime":
            this.executeOperationStartTime = newValue;
            break;
          case "executeOperationEndTime":
            this.executeOperationEndTime = newValue;
            break;
          case "xhs_keywords_list":
            this.xhs_keywords_list = newValue ? JSON.parse(newValue) : [];
            break;
          case "douYin_keywords_list":
            this.douYin_keywords_list = newValue ? JSON.parse(newValue) : [];
            break;
          case "xhs_minute":
            this.xhs_minute = newValue ? JSON.parse(newValue) : [];
            break;
          case "dy_minute":
            this.dy_minute = newValue ? JSON.parse(newValue) : [];
            break;
        }
      }
    });
    this.startLoad = false;
    this.loadend = false;
    this.xhs_viewCount = 0;
    this.xhs_CommentCount = 0;
    this.xhs_likeCount = 0;
    this.xhs_followCount = 0;
    this.xhs_collectCount = 0;
    this.dy_viewCount = 0;
    this.dy_CommentCount = 0;
    this.dy_likeCount = 0;
    this.dy_followCount = 0;
    this.dy_collectCount = 0;
    this.operationTime = 0;
    this.runMinuteTime = 0;
    this.taskPlatform = "";
    this.XiaoHongShu_Setting = "";
    this.executeTask = executeTask2;
    this.executeOperationStartTime = 0;
    this.executeOperationEndTime = 0;
    this.xhs_keywords_list = [];
    this.douYin_keywords_list = [];
    this.xhs_minute = [];
    this.dy_minute = [];
    this.loadFromStorage();
  }
  /**
   * 检查配置是否正确
   */
  checkConfig() {
    return true;
  }
  startTask() {
    return new Promise(resolve => {
      const validationError = this.validateParameters();
      if (!this.conn) {
        return;
      }
      if (validationError) {
        console.error(validationError.message);
        this.conn.messageToReplyMQTT({
          "taskId": this.taskId,
          "executeId": this.executeId,
          "status": "failed",
          "meta": {},
          "message": validationError.message
        });
        return;
      }
      console.log("Do a customize task!");
      this.my_execute(this.data);
      this.conn.messageToReplyMQTT({
        "taskId": this.taskId,
        "executeId": this.executeId,
        "status": "running",
        "meta": this.getStatus(),
        "message": ""
      });
      resolve();
    });
  }
  validateParameters() {
    if (!this.data) {
      return {
        message: "参数未传递或格式不正确"
      };
    }
    return null;
  }
  my_execute(config) {
    chrome.storage.local.set({
      "runTaskStopped": ""
    });
    chrome.storage.local.set({
      "mqttStart": "ok"
    });
    chrome.storage.local.set({
      "xhs_viewCount": 0
    });
    chrome.storage.local.set({
      "xhs_CommentCount": 0
    });
    chrome.storage.local.set({
      "xhs_likeCount": 0
    });
    chrome.storage.local.set({
      "xhs_followCount": 0
    });
    chrome.storage.local.set({
      "xhs_collectCount": 0
    });
    chrome.storage.local.set({
      "dy_viewCount": 0
    });
    chrome.storage.local.set({
      "dy_CommentCount": 0
    });
    chrome.storage.local.set({
      "dy_likeCount": 0
    });
    chrome.storage.local.set({
      "dy_followCount": 0
    });
    chrome.storage.local.set({
      "dy_collectCount": 0
    });
    chrome.storage.local.set({
      "XiaoHongShu_search_runNumber": 1
    });
    chrome.storage.local.set({
      "activatePage": runPages[0]
    });
    chrome.storage.local.set({
      "operationTime": 0
    });
    chrome.storage.local.set({
      "xiaoHongShuAccountErrorTip": ""
    });
    chrome.storage.local.set({
      "xhs_keywords_list": JSON.stringify([])
    });
    chrome.storage.local.set({
      "douYin_keywords_list": JSON.stringify([])
    });
    chrome.storage.local.set({
      "xhs_minute": JSON.stringify([])
    });
    chrome.storage.local.set({
      "dy_minute": JSON.stringify([])
    });
    chrome.storage.local.set({
      "optionsPageName": ""
    });
    chrome.storage.local.set({
      "executeOperationStartTime": (/* @__PURE__ */new Date()).getTime()
    });
    chrome.storage.local.set({
      "XiaoHongShu_Setting": JSON.stringify(config)
    });
    if (!this.XiaoHongShu_Setting) {
      this.XiaoHongShu_Setting = config;
    }
    if (config.workDouYinPlatform == "抖音") {
      if (!this.taskPlatform) {
        this.taskPlatform = config.workDouYinPlatform;
      }
      this.executeTask({
        action: "executeTask",
        url: "https://www.douyin.com",
        taskName: config.workType,
        taskPlatform: config.workDouYinPlatform,
        taskId: this.taskId
      }, {}, res => {
        if (res && res.tabId) {
          this.tabId = res.tabId;
        }
        if (res && res.windowId) {
          this.windowId = res.windowId;
        }
        console.log("executeTask res", res);
      });
    }
    if (config.workXiaoHongShuPlatform == "小红书") {
      this.executeTask({
        action: "executeTask",
        url: "https://www.xiaohongshu.com/explore",
        taskName: config.workType,
        taskPlatform: config.workXiaoHongShuPlatform,
        taskId: this.taskId
      }, {}, res => {
        if (res && res.tabId) {
          this.tabId = res.tabId;
        }
        if (res && res.windowId) {
          this.windowId = res.windowId;
        }
        console.log("executeTask res", res);
      });
      if (!this.taskPlatform) {
        this.taskPlatform = config.workXiaoHongShuPlatform;
      }
    }
  }
  stopTask() {
    return new Promise(resolve => {
      sendLog("xiaohongshuTask background activatePage ：", indexPage);
      chrome.storage.local.set({
        "activatePage": indexPage
      });
      resolve();
    });
  }
  abortTask() {
    return new Promise(resolve => {
      chrome.storage.local.set({
        "runTaskStopped": "end"
      }).then(async res => {
        console.log("runTaskStopped res", res);
      }).catch(error => {
        sendLog("openOptionsPage error" + error);
      }).finally(() => {});
      resolve();
    });
  }
  report() {
    return new Promise(resolve => {
      console.log("report Promise");
      try {
        let formatTimestamp = function (timestamp) {
            const date = new Date(timestamp);
            const month = String(date.getMonth() + 1).padStart(2, "0");
            const day = String(date.getDate()).padStart(2, "0");
            const hours = String(date.getHours()).padStart(2, "0");
            const minutes = String(date.getMinutes()).padStart(2, "0");
            return `${month}-${day} ${hours}:${minutes}`;
          },
          calculateTimeDifference = function (startTimestamp, endTimestamp) {
            const differenceInMs = Math.abs(endTimestamp - startTimestamp);
            const totalMinutes = Math.floor(differenceInMs / (1e3 * 60));
            return `${totalMinutes}`;
          };
        if (!this.conn) {
          resolve();
          return;
        }
        const executeOperationStartTime = formatTimestamp(this.executeOperationStartTime);
        const executeOperationEndTime = formatTimestamp(this.executeOperationEndTime);
        const run_time = calculateTimeDifference(this.executeOperationStartTime, this.executeOperationEndTime);
        let xhs_keywords_list_str = "";
        if (this.xhs_keywords_list.length > 0) {
          xhs_keywords_list_str = this.xhs_keywords_list.join("，");
        }
        let douYin_keywords_list_str = "";
        if (this.douYin_keywords_list.length > 0) {
          douYin_keywords_list_str = this.douYin_keywords_list.join("，");
        }
        let XiaoHongShu_Setting = this.XiaoHongShu_Setting;
        let workRunPlatform = "";
        if (XiaoHongShu_Setting.workDouYinPlatform) {
          if (!workRunPlatform) {
            workRunPlatform = XiaoHongShu_Setting.workDouYinPlatform;
          } else {
            workRunPlatform += "+" + XiaoHongShu_Setting.workDouYinPlatform;
          }
        }
        if (XiaoHongShu_Setting.workXiaoHongShuPlatform) {
          if (!workRunPlatform) {
            workRunPlatform = XiaoHongShu_Setting.workXiaoHongShuPlatform;
          } else {
            workRunPlatform += "+" + XiaoHongShu_Setting.workXiaoHongShuPlatform;
          }
        }
        const uniqueMinutes = [... /* @__PURE__ */new Set([...this.xhs_minute.map(item => item.minute), ...this.dy_minute.map(item => item.minute)])].sort((a, b) => a - b);
        const xhsNums = uniqueMinutes.map(minute => {
          var _a;
          return ((_a = this.xhs_minute.find(item => item.minute === minute)) == null ? void 0 : _a.num) || 0;
        });
        const xhsPieNumber = [{
          value: store$f.xhs_likeCount,
          name: "点赞"
        }, {
          value: store$f.xhs_CommentCount,
          name: "评论"
        }, {
          value: store$f.xhs_followCount,
          name: "关注"
        }, {
          value: store$f.xhs_collectCount,
          name: "收藏"
        }];
        const dyPieNumber = [{
          value: store$f.dy_likeCount,
          name: "点赞"
        }, {
          value: store$f.dy_CommentCount,
          name: "评论"
        }, {
          value: store$f.dy_followCount,
          name: "关注"
        }, {
          value: store$f.dy_collectCount,
          name: "收藏"
        }];
        const allPieNumber = [{
          value: store$f.xhs_likeCount + store$f.dy_likeCount,
          name: "点赞"
        }, {
          value: store$f.xhs_CommentCount + store$f.dy_CommentCount,
          name: "评论"
        }, {
          value: store$f.xhs_followCount + store$f.dy_followCount,
          name: "关注"
        }, {
          value: store$f.xhs_collectCount + store$f.dy_collectCount,
          name: "收藏"
        }];
        const postData = {
          executeOperationStartTime,
          executeOperationEndTime,
          run_time,
          xhs_keywords_list_str,
          douYin_keywords_list_str,
          workRunPlatform,
          uniqueMinutes,
          xhsNums,
          xhsPieNumber,
          dyPieNumber,
          allPieNumber
        };
        console.log("messageToReportMQTT postData", JSON.stringify(postData));
        sendLog("Task stopped");
        this.conn.messageToReportMQTT({
          "taskId": this.taskId,
          "executeId": this.executeId,
          "status": "report",
          "meta": postData,
          "message": "报告"
        });
        resolve();
      } catch (e) {
        console.log("report e", e);
      }
    });
  }
  getHeartReportData() {
    return {};
  }
  /**
   * 等待store 通知 callBackListener
   */
  reportStop() {
    this.running = false;
    this.paused = false;
    this.callExecuteNotification();
    if (!this.conn) {
      return;
    }
    sendLog("Task stopped");
    this.conn.messageToReplyMQTT({
      "taskId": this.taskId,
      "executeId": this.executeId,
      "status": "completed",
      "meta": this.getStatus(),
      "message": "已停止"
    });
    storageUtil.removeListener(this.callBackListener);
  }
  getStatus() {
    return {
      id: this.taskId,
      running: this.running,
      paused: this.paused,
      started: this.started,
      process: this.operationTime > 0 ? (this.runMinuteTime / this.operationTime * 100).toFixed(2) : 0,
      total_num: this.operationTime,
      executed_num: this.runMinuteTime
    };
  }
  getRunData() {
    if (this.taskPlatform === "抖音") {
      return {
        viewCount: this.dy_viewCount,
        commentCount: this.dy_CommentCount,
        likeCount: this.dy_likeCount,
        followCount: this.dy_followCount,
        collectCount: this.dy_collectCount,
        operationTime: this.operationTime,
        runMinuteTime: this.runMinuteTime
      };
    } else if (this.taskPlatform === "小红书") {
      return {
        likeCount: this.xhs_likeCount,
        followCount: this.xhs_followCount,
        commentCount: this.xhs_CommentCount,
        collectCount: this.xhs_collectCount,
        viewCount: this.xhs_viewCount,
        operationTime: this.operationTime,
        runMinuteTime: this.runMinuteTime
      };
    }
  }
  reportReply() {
    console.log("reportReply");
    if (!this.conn) {
      return;
    }
    this.conn.messageToReplyMQTT({
      "taskId": this.taskId,
      "executeId": this.executeId,
      "status": "running",
      "meta": this.getStatus(),
      "message": ""
    });
  }
  loadFromStorage() {
    if (this.startLoad) {
      console.log("startLoad", this.startLoad);
      return;
    }
    this.startLoad = true;
    chrome.storage.local.get(["taskPlatform", "XiaoHongShu_Setting", "xhs_viewCount", "xhs_CommentCount", "xhs_likeCount", "xhs_followCount", "xhs_collectCount", "dy_viewCount", "dy_CommentCount", "dy_likeCount", "dy_followCount", "dy_collectCount", "operationTime", "userId", "orgId", "clientVisitorId", "accessToken"], result => {
      console.log("result activatePage", result);
      if (!result) {
        return;
      }
      if (result.userId !== void 0) {
        this.user_id = result.userId;
      }
      if (result.orgId !== void 0) {
        this.orgId = result.orgId;
      }
      if (result.clientVisitorId !== void 0) {
        this.clientVisitorId = result.clientVisitorId;
      }
      if (result.accessToken !== void 0) {
        this.accessToken = result.accessToken;
      }
      if (result.taskPlatform !== void 0) {
        this.taskPlatform = result.taskPlatform;
      }
      if (result.XiaoHongShu_Setting !== void 0) {
        this.XiaoHongShu_Setting = result.XiaoHongShu_Setting ? JSON.parse(result.XiaoHongShu_Setting) : {};
      }
      if (result.xhs_viewCount !== void 0) {
        this.xhs_viewCount = result.xhs_viewCount;
      }
      if (result.xhs_CommentCount !== void 0) {
        this.xhs_CommentCount = result.xhs_CommentCount;
      }
      if (result.xhs_likeCount !== void 0) {
        this.xhs_likeCount = result.xhs_likeCount;
      }
      if (result.xhs_followCount !== void 0) {
        this.xhs_followCount = result.xhs_followCount;
      }
      if (result.xhs_collectCount !== void 0) {
        this.xhs_collectCount = result.xhs_collectCount;
      }
      if (result.dy_viewCount !== void 0) {
        this.dy_viewCount = result.dy_viewCount;
      }
      if (result.dy_CommentCount !== void 0) {
        this.dy_CommentCount = result.dy_CommentCount;
      }
      if (result.dy_likeCount !== void 0) {
        this.dy_likeCount = result.dy_likeCount;
      }
      if (result.dy_followCount !== void 0) {
        this.dy_followCount = result.dy_followCount;
      }
      if (result.dy_collectCount !== void 0) {
        this.dy_collectCount = result.dy_collectCount;
      }
      if (result.operationTime !== void 0) {
        this.operationTime = result.operationTime;
      }
      this.startLoad = true;
      this.loadend = true;
    });
    storageUtil.addHandlers(this.callBackListener);
  }
}
class LocalCustomizeTask extends XiaohongshuTask {
  constructor(taskId, executeId, data, executeTask2, request, sender, sendResponse) {
    super(taskId, executeId, data, executeTask2);
    __publicField(this, "request");
    __publicField(this, "sender");
    __publicField(this, "sendResponse");
    __publicField(this, "reportRunData", async () => {});
    this.request = request;
    this.sender = sender;
    this.sendResponse = sendResponse;
  }
  my_execute(config) {
    console.log("config", config);
    this.executeTask(this.request, this.sender, this.sendResponse);
  }
}
const store$e = UseCounterStore.getInstance();
class DouYinKeZiCustomizeTask extends BaseTask {
  constructor(taskId, executeId, data, executeTask2) {
    super(taskId, executeId, data);
    __publicField(this, "executeTask");
    //评论数量
    __publicField(this, "xhs_viewCount");
    __publicField(this, "xhs_CommentCount");
    __publicField(this, "xhs_likeCount");
    __publicField(this, "xhs_followCount");
    __publicField(this, "xhs_collectCount");
    //评论数量
    __publicField(this, "dy_viewCount");
    __publicField(this, "dy_CommentCount");
    __publicField(this, "dy_likeCount");
    __publicField(this, "dy_followCount");
    __publicField(this, "dy_collectCount");
    __publicField(this, "taskPlatform");
    __publicField(this, "XiaoHongShu_Setting");
    __publicField(this, "operationTime");
    __publicField(this, "runMinuteTime");
    __publicField(this, "startLoad");
    __publicField(this, "loadend");
    // 上报数据
    __publicField(this, "executeOperationStartTime");
    __publicField(this, "executeOperationEndTime");
    __publicField(this, "xhs_keywords_list");
    __publicField(this, "douYin_keywords_list");
    __publicField(this, "xhs_minute");
    __publicField(this, "dy_minute");
    __publicField(this, "contentText");
    __publicField(this, "replyComment");
    __publicField(this, "reportRunDataStatus", async () => {
      var _a;
      console.log("reportRunDataStatus");
      if (!this.conn) {
        return;
      }
      const runData = this.getRunData();
      console.log("runData", JSON.stringify(runData));
      this.conn.messageToStatusMQTT({
        "taskId": this.taskId,
        "data": runData,
        "userId": this.user_id,
        "terminalId": (_a = this.terminalData) == null ? void 0 : _a.terminalId
      });
    });
    __publicField(this, "callBackListener", (changes, namespace) => {
      for (let [key, {
        oldValue,
        newValue
      }] of Object.entries(changes)) {
        console.log(`customizeTask Storage key "${key}" in namespace "${namespace}" changed.`, `Old value was "${oldValue}", new value is "${newValue}".`);
        switch (key) {
          case "runTaskStopped":
            if (newValue == "end") {
              this.reportStop().then(() => {});
            }
            break;
          case "taskPlatform":
            this.taskPlatform = newValue;
            break;
          case "XiaoHongShu_Setting":
            this.XiaoHongShu_Setting = newValue ? JSON.parse(newValue) : {};
            break;
          case "orgId":
            this.orgId = newValue;
            break;
          case "userId":
            this.user_id = newValue;
            break;
          case "clientVisitorId":
            this.clientVisitorId = newValue;
            break;
          case "accessToken":
            this.accessToken = newValue;
            break;
          case "operationTime":
            this.operationTime = newValue;
            break;
          case "runMinuteTime":
            this.runMinuteTime = newValue;
            this.reportReply();
            break;
          case "xhs_likeCount":
            this.xhs_likeCount = newValue;
            this.reportRunDataStatus().then();
            break;
          case "xhs_followCount":
            this.xhs_followCount = newValue;
            this.reportRunDataStatus().then();
            break;
          case "xhs_CommentCount":
            this.xhs_CommentCount = newValue;
            this.reportRunDataStatus().then();
            break;
          case "xhs_collectCount":
            this.xhs_collectCount = newValue;
            this.reportRunDataStatus().then();
            break;
          case "xhs_viewCount":
            this.xhs_viewCount = newValue;
            this.reportRunDataStatus().then();
            break;
          case "dy_likeCount":
            this.dy_likeCount = newValue;
            this.reportRunDataStatus().then();
            break;
          case "dy_followCount":
            this.dy_followCount = newValue;
            this.reportRunDataStatus().then();
            break;
          case "dy_CommentCount":
            this.dy_CommentCount = newValue;
            this.reportRunDataStatus().then();
            break;
          case "dy_collectCount":
            this.dy_collectCount = newValue;
            this.reportRunDataStatus().then();
            break;
          case "dy_viewCount":
            this.dy_viewCount = newValue;
            this.reportRunDataStatus().then();
            break;
          case "executeOperationStartTime":
            this.executeOperationStartTime = newValue;
            break;
          case "executeOperationEndTime":
            this.executeOperationEndTime = newValue;
            break;
          case "xhs_keywords_list":
            this.xhs_keywords_list = newValue ? JSON.parse(newValue) : [];
            break;
          case "douYin_keywords_list":
            this.douYin_keywords_list = newValue ? JSON.parse(newValue) : [];
            break;
          case "xhs_minute":
            this.xhs_minute = newValue ? JSON.parse(newValue) : [];
            break;
          case "dy_minute":
            this.dy_minute = newValue ? JSON.parse(newValue) : [];
            break;
          case "contentText":
            this.contentText = newValue;
            break;
          case "replyComment":
            this.replyComment = newValue;
            break;
        }
      }
    });
    this.startLoad = false;
    this.loadend = false;
    this.xhs_viewCount = 0;
    this.xhs_CommentCount = 0;
    this.xhs_likeCount = 0;
    this.xhs_followCount = 0;
    this.xhs_collectCount = 0;
    this.dy_viewCount = 0;
    this.dy_CommentCount = 0;
    this.dy_likeCount = 0;
    this.dy_followCount = 0;
    this.dy_collectCount = 0;
    this.operationTime = 0;
    this.runMinuteTime = 0;
    this.taskPlatform = "";
    this.XiaoHongShu_Setting = "";
    this.executeTask = executeTask2;
    this.executeOperationStartTime = 0;
    this.executeOperationEndTime = 0;
    this.xhs_keywords_list = [];
    this.douYin_keywords_list = [];
    this.xhs_minute = [];
    this.dy_minute = [];
    this.contentText = "";
    this.replyComment = "";
    this.loadFromStorage();
  }
  checkConfig() {
    const optionWhere = this.data;
    if (optionWhere.wordWhereNumEnd < 0) {
      console.error("【最大私信字数】不能小于0");
      this.reportFail("【最大私信字数】不能小于0");
      return false;
    }
    if (optionWhere.wordWhereNum > optionWhere.wordWhereNumEnd) {
      console.error("【最大私信字数】不能小于【最小私信字数】");
      this.reportFail("【最大私信字数】不能小于【最小私信字数】");
      return false;
    }
    if (optionWhere.runTimeEnd <= 0) {
      console.error("【最大运行时长】不能小于等于0");
      this.reportFail("【最大运行时长】不能小于等于0");
      return false;
    }
    if (optionWhere.runTimeStart > optionWhere.runTimeEnd) {
      console.error("【最大运行时长】不能小于【最小运行时长】");
      this.reportFail("【最大运行时长】不能小于【最小运行时长】");
      return false;
    }
    if (optionWhere.refreshFrequencyEnd <= 0) {
      console.error("【最大刷新频率】不能小于等于0");
      this.reportFail("【最大刷新频率】不能小于等于0");
      return false;
    }
    if (optionWhere.refreshFrequencyStart > optionWhere.refreshFrequencyEnd) {
      console.error("【最大刷新频率】不能小于【最小刷新频率】");
      this.reportFail("【最大刷新频率】不能小于【最小刷新频率】");
      return false;
    }
    if (!optionWhere.wordReplyContent && optionWhere.enableFirstReplyBool == true && !optionWhere.phoneNumberReplyContent && !optionWhere.phoneNumberReplyContent1 && !optionWhere.phoneNumberReplyContent3) {
      console.error("评论和私信的回复内容不能都为空");
      return false;
    }
    return true;
  }
  reportFail(errorMessage) {
    if (!this.conn) {
      return;
    }
    this.conn.messageToReplyMQTT({
      "taskId": this.taskId,
      "executeId": this.executeId,
      "status": "failed",
      "meta": {},
      "message": errorMessage
    });
  }
  startTask() {
    return new Promise(resolve => {
      const validationError = this.validateParameters();
      if (!this.conn) {
        return;
      }
      if (validationError) {
        console.error(validationError.message);
        this.conn.messageToReplyMQTT({
          "taskId": this.taskId,
          "executeId": this.executeId,
          "status": "failed",
          "meta": {},
          "message": validationError.message
        });
        return;
      }
      console.log("Do a customize task!");
      chrome.storage.local.set({
        "taskId": this.taskId
      });
      chrome.storage.local.set({
        "executeId": this.executeId
      });
      this.my_execute(this.data).then(() => {});
      this.conn.messageToReplyMQTT({
        "taskId": this.taskId,
        "executeId": this.executeId,
        "status": "running",
        "meta": this.getStatus(),
        "message": ""
      });
      resolve();
    });
  }
  validateParameters() {
    if (!this.data) {
      return {
        message: "参数未传递或格式不正确"
      };
    }
    return null;
  }
  async my_execute(config) {
    chrome.storage.local.set({
      "mqttStart": ""
    });
    chrome.storage.local.set({
      "runTaskStopped": ""
    });
    chrome.storage.local.set({
      "mqttStart": "ok"
    });
    chrome.storage.local.set({
      "xhs_viewCount": 0
    });
    chrome.storage.local.set({
      "xhs_CommentCount": 0
    });
    chrome.storage.local.set({
      "xhs_likeCount": 0
    });
    chrome.storage.local.set({
      "xhs_followCount": 0
    });
    chrome.storage.local.set({
      "xhs_collectCount": 0
    });
    chrome.storage.local.set({
      "dy_viewCount": 0
    });
    chrome.storage.local.set({
      "dy_CommentCount": 0
    });
    chrome.storage.local.set({
      "dy_likeCount": 0
    });
    chrome.storage.local.set({
      "dy_followCount": 0
    });
    chrome.storage.local.set({
      "dy_collectCount": 0
    });
    chrome.storage.local.set({
      "activatePage": runPages[0]
    });
    chrome.storage.local.set({
      "operationTime": 0
    });
    chrome.storage.local.set({
      "xiaoHongShuAccountErrorTip": ""
    });
    chrome.storage.local.set({
      "xhs_keywords_list": JSON.stringify([])
    });
    chrome.storage.local.set({
      "douYin_keywords_list": JSON.stringify([])
    });
    chrome.storage.local.set({
      "xhs_minute": JSON.stringify([])
    });
    chrome.storage.local.set({
      "dy_minute": JSON.stringify([])
    });
    chrome.storage.local.set({
      "optionsPageName": ""
    });
    chrome.storage.local.set({
      "executeOperationStartTime": (/* @__PURE__ */new Date()).getTime()
    });
    chrome.storage.local.set({
      "XiaoHongShu_Setting": JSON.stringify({})
    });
    chrome.storage.local.set({
      "optionsPageName": ""
    });
    chrome.storage.local.set({
      "optionWhere": JSON.stringify(config)
    });
    chrome.storage.local.set({
      "runTimeMaxNum": config.runTimeEnd
    });
    chrome.storage.local.set({
      "runTimeNum": (/* @__PURE__ */new Date()).getTime()
    });
    chrome.storage.local.set({
      "formattedTime": ""
    });
    chrome.storage.local.set({
      "DouYin_search_runNumber": 1
    });
    chrome.storage.local.set({
      "captcha_container_num": 0
    });
    const key = store$e.userId + "_douYin_saveOptionsWhere";
    const postDataObj = {
      "key": key,
      "bucket": config,
      "size": 0,
      "content_type": "",
      "belong_to": store$e.userId + "_douYin_saveOptionsWhere",
      "object_metadata": {}
    };
    try {
      const res = await addObjects(postDataObj);
      console.log("res保存的数据：", res);
    } catch (error) {
      console.log("error", error);
    }
    chrome.storage.local.set({
      "executeOperationStartTime": (/* @__PURE__ */new Date()).getTime()
    });
    this.executeTask({
      action: "executeTask",
      url: "https://www.douyin.com",
      taskId: this.taskId,
      taskName: "获取抖音通知",
      taskPlatform: "抖音"
    }, {}, res => {
      if (res && res.tabId) {
        this.tabId = res.tabId;
      }
      if (res && res.windowId) {
        this.windowId = res.windowId;
      }
      console.log("executeTask res", res);
    });
  }
  stopTask() {
    return new Promise(resolve => {
      sendLog("douYinKeZiCustomizeTask background activatePage ：", indexPage);
      chrome.storage.local.set({
        "activatePage": indexPage
      });
      resolve();
    });
  }
  abortTask() {
    return new Promise(resolve => {
      this.reportStop().then(() => {});
      resolve();
    });
  }
  report() {
    return new Promise(resolve => {
      console.log("report Promise");
      try {
        let formatTimestamp = function (timestamp) {
            const date = new Date(timestamp);
            const month = String(date.getMonth() + 1).padStart(2, "0");
            const day = String(date.getDate()).padStart(2, "0");
            const hours = String(date.getHours()).padStart(2, "0");
            const minutes = String(date.getMinutes()).padStart(2, "0");
            return `${month}-${day} ${hours}:${minutes}`;
          },
          calculateTimeDifference = function (startTimestamp, endTimestamp) {
            const differenceInMs = Math.abs(endTimestamp - startTimestamp);
            const totalMinutes = Math.floor(differenceInMs / (1e3 * 60));
            return `${totalMinutes}`;
          };
        if (!this.conn) {
          resolve();
          return;
        }
        const executeOperationStartTime = formatTimestamp(this.executeOperationStartTime);
        const executeOperationEndTime = formatTimestamp(this.executeOperationEndTime);
        const run_time = calculateTimeDifference(this.executeOperationStartTime, this.executeOperationEndTime);
        let xhs_keywords_list_str = "";
        if (this.xhs_keywords_list.length > 0) {
          xhs_keywords_list_str = this.xhs_keywords_list.join("，");
        }
        let douYin_keywords_list_str = "";
        if (this.douYin_keywords_list.length > 0) {
          douYin_keywords_list_str = this.douYin_keywords_list.join("，");
        }
        let XiaoHongShu_Setting = this.XiaoHongShu_Setting;
        let workRunPlatform = "";
        if (XiaoHongShu_Setting.workDouYinPlatform) {
          if (!workRunPlatform) {
            workRunPlatform = XiaoHongShu_Setting.workDouYinPlatform;
          } else {
            workRunPlatform += "+" + XiaoHongShu_Setting.workDouYinPlatform;
          }
        }
        if (XiaoHongShu_Setting.workXiaoHongShuPlatform) {
          if (!workRunPlatform) {
            workRunPlatform = XiaoHongShu_Setting.workXiaoHongShuPlatform;
          } else {
            workRunPlatform += "+" + XiaoHongShu_Setting.workXiaoHongShuPlatform;
          }
        }
        const uniqueMinutes = [... /* @__PURE__ */new Set([...this.xhs_minute.map(item => item.minute), ...this.dy_minute.map(item => item.minute)])].sort((a, b) => a - b);
        const xhsNums = uniqueMinutes.map(minute => {
          var _a;
          return ((_a = this.xhs_minute.find(item => item.minute === minute)) == null ? void 0 : _a.num) || 0;
        });
        const xhsPieNumber = [{
          value: store$e.xhs_likeCount,
          name: "点赞"
        }, {
          value: store$e.xhs_CommentCount,
          name: "评论"
        }, {
          value: store$e.xhs_followCount,
          name: "关注"
        }, {
          value: store$e.xhs_collectCount,
          name: "收藏"
        }];
        const dyPieNumber = [{
          value: store$e.dy_likeCount,
          name: "点赞"
        }, {
          value: store$e.dy_CommentCount,
          name: "评论"
        }, {
          value: store$e.dy_followCount,
          name: "关注"
        }, {
          value: store$e.dy_collectCount,
          name: "收藏"
        }];
        const allPieNumber = [{
          value: store$e.xhs_likeCount + store$e.dy_likeCount,
          name: "点赞"
        }, {
          value: store$e.xhs_CommentCount + store$e.dy_CommentCount,
          name: "评论"
        }, {
          value: store$e.xhs_followCount + store$e.dy_followCount,
          name: "关注"
        }, {
          value: store$e.xhs_collectCount + store$e.dy_collectCount,
          name: "收藏"
        }];
        const postData = {
          executeOperationStartTime,
          executeOperationEndTime,
          run_time,
          xhs_keywords_list_str,
          douYin_keywords_list_str,
          workRunPlatform,
          uniqueMinutes,
          xhsNums,
          xhsPieNumber,
          dyPieNumber,
          allPieNumber
        };
        console.log("messageToReportMQTT postData", JSON.stringify(postData));
        sendLog("Task stopped");
        this.conn.messageToReportMQTT({
          "taskId": this.taskId,
          "executeId": this.executeId,
          "status": "report",
          "meta": postData,
          "message": "报告"
        });
        resolve();
      } catch (e) {
        console.log("report e", e);
      }
    });
  }
  /**
   * 获取心跳上报数据
   *
   * {
   *             taskConfig:{
   *                 // 任务配置
   *                 config:{
   *                     enableFirstReplyBool: true,
   *                     keFuNullReplyContent: "兜底",
   *                     phoneNumberReplyContent: "2",
   *                     phoneNumberReplyContent1: "1",
   *                     phoneNumberReplyContent3: "3",
   *                     refreshFrequencyEnd: 2,
   *                     refreshFrequencyStart: 1,
   *                     runTimeEnd: 0.5,
   *                     runTimeStart: 0,
   *                     wordReplyContent: "请私信",
   *                     wordWhereNum: 1,
   *                     wordWhereNumEnd: 9999,
   *                 },
   *                 executeId: "1b3cea2b-a869-4e96-b5be-93a813f54427",
   *                 operation: "cmd",
   *                 taskId: "b8e94836-9da1-4394-b6ea-4a72d81a2bc4",
   *                 type: "DouYinKeZiTask"
   *             },
   *             runStatus:{
   *                 //运行页面状态
   *                 stopButtonText: "stop",
   *                 formattedTime:"",
   *             },
   *             replyComment:{
   *                 // 读取到，要回复的内容上报
   *                 contentText:"",
   *                 replyComment:"",
   *             },
   *             webLoginInfo:{
   *                 // 登录抖音账号的名称
   *                 webUserId:"",
   *                 webUserName:"",
   *                 webUserAvatarUrl:""
   *             }
   *             // 上报
   *             // 1；配置信息
   *             // 2、显示信息上报
   *             // 3、点击停止上报
   *             // 3、倒计时剩余上报
   *             // 4、读取到，要回复的内容上报
   *             // 5、登录抖音账号的名称
   *         }
   */
  getHeartReportData() {
    return {
      taskConfig: this.data,
      taskRunConfig: {
        executeId: this.executeId,
        taskId: this.taskId,
        type: "DouYinKeZiTask",
        operation: "cmd"
      },
      runStatus: {
        //运行页面状态
        runLogs: this.runLogs + "（" + this.formattedTime + "）",
        stopButtonText: this.stopButtonText,
        formattedTime: this.formattedTime
      },
      replyComment: {
        // 读取到，要回复的内容上报
        contentText: this.contentText,
        replyComment: this.replyComment
      }
      // 上报
      // 1；配置信息
      // 2、显示信息上报
      // 3、点击停止上报
      // 3、倒计时剩余上报
      // 4、读取到，要回复的内容上报
      // 5、登录抖音账号的名称
    };
  }
  /**
   * 等待store 通知 callBackListener
   */
  async reportStop() {
    this.running = false;
    this.paused = false;
    this.callExecuteNotification();
    storageUtil.removeListener(this.callBackListener);
    super.baseReportStop();
    if (!this.conn) {
      return;
    }
    sendLog("Task stopped");
    this.conn.messageToReplyMQTT({
      "taskId": this.taskId,
      "executeId": this.executeId,
      "status": "completed",
      "meta": this.getStatus(),
      "message": "已停止"
    });
    this.conn.setRunTaskInstance(null);
  }
  getStatus() {
    return {
      id: this.taskId,
      running: this.running,
      paused: this.paused,
      started: this.started,
      process: this.operationTime > 0 ? (this.runMinuteTime / this.operationTime * 100).toFixed(2) : 0,
      total_num: this.operationTime,
      executed_num: this.runMinuteTime
    };
  }
  getRunData() {
    if (this.taskPlatform === "抖音") {
      return {
        viewCount: this.dy_viewCount,
        commentCount: this.dy_CommentCount,
        likeCount: this.dy_likeCount,
        followCount: this.dy_followCount,
        collectCount: this.dy_collectCount,
        operationTime: this.operationTime,
        runMinuteTime: this.runMinuteTime
      };
    } else if (this.taskPlatform === "小红书") {
      return {
        likeCount: this.xhs_likeCount,
        followCount: this.xhs_followCount,
        commentCount: this.xhs_CommentCount,
        collectCount: this.xhs_collectCount,
        viewCount: this.xhs_viewCount,
        operationTime: this.operationTime,
        runMinuteTime: this.runMinuteTime
      };
    }
  }
  reportReply() {
    console.log("reportReply");
    if (!this.conn) {
      return;
    }
    this.conn.messageToReplyMQTT({
      "taskId": this.taskId,
      "executeId": this.executeId,
      "status": "running",
      "meta": this.getStatus(),
      "message": ""
    });
  }
  loadFromStorage() {
    if (this.startLoad) {
      console.log("startLoad", this.startLoad);
      return;
    }
    this.startLoad = true;
    chrome.storage.local.get(["taskPlatform", "XiaoHongShu_Setting", "xhs_viewCount", "xhs_CommentCount", "xhs_likeCount", "xhs_followCount", "xhs_collectCount", "dy_viewCount", "dy_CommentCount", "dy_likeCount", "dy_followCount", "dy_collectCount", "operationTime", "userId", "orgId", "clientVisitorId", "accessToken", "contentText", "replyComment"], result => {
      console.log("result activatePage", result);
      if (!result) {
        return;
      }
      if (result.userId !== void 0) {
        this.user_id = result.userId;
      }
      if (result.orgId !== void 0) {
        this.orgId = result.orgId;
      }
      if (result.clientVisitorId !== void 0) {
        this.clientVisitorId = result.clientVisitorId;
      }
      if (result.accessToken !== void 0) {
        this.accessToken = result.accessToken;
      }
      if (result.taskPlatform !== void 0) {
        this.taskPlatform = result.taskPlatform;
      }
      if (result.XiaoHongShu_Setting !== void 0) {
        this.XiaoHongShu_Setting = result.XiaoHongShu_Setting ? JSON.parse(result.XiaoHongShu_Setting) : {};
      }
      if (result.xhs_viewCount !== void 0) {
        this.xhs_viewCount = result.xhs_viewCount;
      }
      if (result.xhs_CommentCount !== void 0) {
        this.xhs_CommentCount = result.xhs_CommentCount;
      }
      if (result.xhs_likeCount !== void 0) {
        this.xhs_likeCount = result.xhs_likeCount;
      }
      if (result.xhs_followCount !== void 0) {
        this.xhs_followCount = result.xhs_followCount;
      }
      if (result.xhs_collectCount !== void 0) {
        this.xhs_collectCount = result.xhs_collectCount;
      }
      if (result.dy_viewCount !== void 0) {
        this.dy_viewCount = result.dy_viewCount;
      }
      if (result.dy_CommentCount !== void 0) {
        this.dy_CommentCount = result.dy_CommentCount;
      }
      if (result.dy_likeCount !== void 0) {
        this.dy_likeCount = result.dy_likeCount;
      }
      if (result.dy_followCount !== void 0) {
        this.dy_followCount = result.dy_followCount;
      }
      if (result.dy_collectCount !== void 0) {
        this.dy_collectCount = result.dy_collectCount;
      }
      if (result.operationTime !== void 0) {
        this.operationTime = result.operationTime;
      }
      if (result.contentText !== void 0) {
        this.contentText = result.contentText;
      }
      if (result.replyComment !== void 0) {
        this.replyComment = result.replyComment;
      }
      this.startLoad = true;
      this.loadend = true;
    });
    storageUtil.addHandlers(this.callBackListener);
  }
}
UseCounterStore.getInstance();
const VITE_LOGIN_API$1 = "https://global-auth.petron.ai";
async function logout(accessToken) {
  const url = VITE_LOGIN_API$1 + "/api/v1/workos/logout";
  const headers = {
    "Content-Type": "application/json",
    "Authorization": "Bearer " + accessToken
  };
  try {
    const response = await fetch(url, {
      method: "get",
      headers
    });
    if (!response.ok) {
      console.log("url:" + url + "，header:" + JSON.stringify(headers) + ", response status:" + response.status);
      console.error(`HTTP error! status: ${response.status}`, response);
      if (response.status == 404) {
        return void 0;
      }
      console.error("退出错误");
      return void 0;
    }
    const result = await response.json();
    console.log("url:" + url + "，header:" + JSON.stringify(headers) + ", response status:" + response.status + ", response data:" + JSON.stringify(result));
    console.log("result", result);
    return result;
  } catch (error) {
    console.log("url:" + url + "，header:" + JSON.stringify(headers) + ", error" + error);
    console.error("Error:", error);
  }
  return void 0;
}
const store$d = UseCounterStore.getInstance();
const VITE_AGENT_BUSINESS_API = "https://prod-agbusiness-zyqflxidth.cn-huhehaote.fcapp.run";
const VITE_AGENT_ID$4 = "dou-yin-chrome-extension";
const VITE_TASK_API = "https://agent-net.paitongai.net/task";
async function saveTerminal(terminalId, postData) {
  console.log("terminal", postData);
  const url = VITE_AGENT_BUSINESS_API + "/api/terminal/" + terminalId;
  const headers = {
    "Content-Type": "application/json",
    "Authorization": "Bearer " + store$d.accessToken
  };
  try {
    const response = await fetch(url, {
      method: "POST",
      headers,
      body: JSON.stringify(postData)
    });
    if (!response.ok) {
      sendLog("url:" + url + "，header:" + JSON.stringify(headers) + ", response status:" + response.status);
      console.error(`HTTP error! status: ${response.status}`);
      if (response.status === 401) {
        console.log("登录失效");
        store$d.setAccessToken("");
        store$d.set_updateVipDateTime("");
        store$d.setUserInfoEndDate("");
        await logout(store$d.accessToken);
      }
      if (response.status == 404) {
        return void 0;
      }
      return void 0;
    }
    const result = await response.json();
    sendLog("url:" + url + "，header:" + JSON.stringify(headers) + ",postData：" + JSON.stringify(postData) + " response status:" + response.status + ", response data:" + JSON.stringify(result));
    console.log("result", result);
    return result;
  } catch (error) {
    sendLog("url:" + url + "，header:" + JSON.stringify(headers) + ", error" + error);
    console.error("Error:", error);
  }
  return void 0;
}
async function queryTerminal() {
  const url = `${VITE_AGENT_BUSINESS_API}/api/terminal?only_bound=true&agent_id=${VITE_AGENT_ID$4}&client_id=${store$d.cpuSerialNumber}`;
  const headers = {
    "Content-Type": "application/json",
    "Authorization": "Bearer " + store$d.accessToken
  };
  try {
    const response = await fetch(url, {
      method: "GET",
      headers
    });
    if (!response.ok) {
      sendLog("url:" + url + "，header:" + JSON.stringify(headers) + ", response status:" + response.status);
      console.error(`HTTP error! status: ${response.status}`);
      if (response.status === 401) {
        console.log("登录失效");
        store$d.setAccessToken("");
        store$d.set_updateVipDateTime("");
        store$d.setUserInfoEndDate("");
        await logout(store$d.accessToken);
      }
      if (response.status == 404) {
        return void 0;
      }
      return void 0;
    }
    const result = await response.json();
    sendLog("url:" + url + "，header:" + JSON.stringify(headers) + " response status:" + response.status + ", response data:" + JSON.stringify(result));
    console.log("result", result);
    if (!result || result.total == 0 || !result.data) {
      return;
    }
    if (true) {
      if (result.data[0].terminal_id) {
        const completeTasksUrl = `${VITE_TASK_API}/api/tasks/completed-all-task-by-terminal/${result.data[0].terminal_id}`;
        const completeTasksHeaders = {
          "accept": "application/json",
          "Authorization": "Bearer " + store$d.accessToken
        };
        try {
          const completeTasksResponse = await fetch(completeTasksUrl, {
            method: "PUT",
            headers: completeTasksHeaders
          });
          if (!completeTasksResponse.ok) {
            sendLog("complete tasks url:" + completeTasksUrl + "，header:" + JSON.stringify(completeTasksHeaders) + ", response status:" + completeTasksResponse.status);
            console.error(`Complete tasks HTTP error! status: ${completeTasksResponse.status}`);
          } else {
            sendLog("complete tasks url:" + completeTasksUrl + "，header:" + JSON.stringify(completeTasksHeaders) + ", response status:" + completeTasksResponse.status);
            console.log("Successfully marked all tasks as completed for terminal:", result.terminalId);
          }
        } catch (completeTasksError) {
          sendLog("complete tasks url:" + completeTasksUrl + "，header:" + JSON.stringify(completeTasksHeaders) + ", error" + completeTasksError);
          console.error("Error completing tasks:", completeTasksError);
        }
      }
    }
    return {
      terminalId: result.data[0].terminal_id,
      terminalName: result.data[0].terminal_name
    };
  } catch (error) {
    sendLog("url:" + url + "，header:" + JSON.stringify(headers) + ", error" + error);
    console.error("Error:", error);
  }
  return void 0;
}
async function saveTerminalBind(terminalId, postData) {
  console.log("terminal", postData);
  const url = VITE_AGENT_BUSINESS_API + "/api/terminal/" + terminalId + "/bind";
  const headers = {
    "Content-Type": "application/json",
    "Authorization": "Bearer " + store$d.accessToken
  };
  try {
    const response = await fetch(url, {
      method: "POST",
      headers,
      body: JSON.stringify(postData)
    });
    if (!response.ok) {
      sendLog("url:" + url + "，header:" + JSON.stringify(headers) + ", response status:" + response.status);
      console.error(`HTTP error! status: ${response.status}`);
      if (response.status === 401) {
        console.log("登录失效");
        store$d.setAccessToken("");
        store$d.set_updateVipDateTime("");
        store$d.setUserInfoEndDate("");
        await logout(store$d.accessToken);
      }
      if (response.status == 404) {
        return void 0;
      }
      return void 0;
    }
    const result = await response.json();
    sendLog("url:" + url + "，header:" + JSON.stringify(headers) + ",postData：" + JSON.stringify(postData) + " response status:" + response.status + ", response data:" + JSON.stringify(result));
    console.log("result", result);
    return result;
  } catch (error) {
    sendLog("url:" + url + "，header:" + JSON.stringify(headers) + ", error" + error);
    console.error("Error:", error);
  }
  return void 0;
}
async function terminalCredentials(terminalId, accessToken) {
  const url = VITE_AGENT_BUSINESS_API + "/api/terminal/" + terminalId + "/credentials";
  const headers = {
    "Content-Type": "application/json",
    "Authorization": "Bearer " + accessToken
  };
  try {
    const response = await fetch(url, {
      method: "GET",
      headers
    });
    if (!response.ok) {
      sendLog("url:" + url + "，header:" + JSON.stringify(headers) + ", response status:" + response.status);
      console.error(`HTTP error! status: ${response.status}`);
      if (response.status === 401) {
        console.log("登录失效");
        store$d.setAccessToken("");
        store$d.set_updateVipDateTime("");
        store$d.setUserInfoEndDate("");
        await logout(accessToken);
      }
      if (response.status == 404) {
        return void 0;
      }
      return void 0;
    }
    const result = await response.json();
    sendLog("url:" + url + "，header:" + JSON.stringify(headers) + " response status:" + response.status + ", response data:" + JSON.stringify(result));
    console.log("result", result);
    return result;
  } catch (error) {
    sendLog("url:" + url + "，header:" + JSON.stringify(headers) + ", error" + error);
    console.error("Error:", error);
  }
  return void 0;
}
const store$c = UseCounterStore.getInstance();
const VITE_TERMINAL_API = "https://agent-net.paitongai.net/terminal";
async function register_terminal(agent_id, agent_name) {
  sendLog("register_terminal accessToken: " + store$c.accessToken);
  const url = VITE_TERMINAL_API + "/api/terminals/register_terminal?agent_id=" + agent_id + "&agent_name=" + agent_name;
  const headers = {
    "Content-Type": "application/json",
    "Authorization": "Bearer " + store$c.accessToken
  };
  try {
    const response = await fetch(url, {
      method: "POST",
      headers
    });
    if (!response.ok) {
      sendLog("url:" + url + "，header:" + JSON.stringify(headers) + ", response status:" + response.status);
      console.error(`HTTP error! status: ${response.status}`);
      if (response.status === 401) {
        console.log("登录失效");
        store$c.setAccessToken("");
        store$c.set_updateVipDateTime("");
        store$c.setUserInfoEndDate("");
        await logout(store$c.accessToken);
      }
      if (response.status == 404) {
        return void 0;
      }
      return void 0;
    }
    const result = await response.json();
    sendLog("url:" + url + "，header:" + JSON.stringify(headers) + " response status:" + response.status + ", response data:" + JSON.stringify(result));
    console.log("result", result);
    return result;
  } catch (error) {
    sendLog("url:" + url + "，header:" + JSON.stringify(headers) + ", error" + error);
    console.error("Error:", error);
  }
  return void 0;
}
const store$b = UseCounterStore.getInstance();
const VITE_LOGIN_API = "https://global-auth.petron.ai";
function getStorageValue(key) {
  return new Promise(resolve => {
    chrome.storage.local.get(key, result => {
      resolve(result[key]);
    });
  });
}
async function tenantsMine() {
  console.log("tenantsMine");
  let accessToken = await getStorageValue("accessToken");
  const url = VITE_LOGIN_API + `/api/v1/tenants/mine`;
  const headers = {
    "Content-Type": "application/json",
    "Authorization": "Bearer " + accessToken
  };
  try {
    const response = await fetch(url, {
      method: "GET",
      headers
    });
    if (!response.ok) {
      sendLog("url:" + url + "，header:" + JSON.stringify(headers) + ", response status:" + response.status);
      console.error(`HTTP error! status: ${response.status}`);
      if (response.status === 401) {
        console.log("登录失效");
        store$b.setAccessToken("");
        store$b.set_updateVipDateTime("");
        store$b.setUserInfoEndDate("");
        if (typeof accessToken === "string") {
          await logout(accessToken);
        }
      }
      if (response.status == 404) {
        return void 0;
      }
      return void 0;
    }
    const result = await response.json();
    sendLog("url:" + url + "，header:" + JSON.stringify(headers) + ", response status:" + response.status + ", response data:" + JSON.stringify(result));
    console.log("result", result);
    return result;
  } catch (error) {
    sendLog("url:" + url + "，header:" + JSON.stringify(headers) + ", error" + error);
    console.error("Error:", error);
  }
  return void 0;
}
const agentBusiness = async (boolBind = false) => {
  try {
    let terminalInfo = await queryTerminal();
    if (!terminalInfo) {
      const VITE_AGENT_ID22 = "dou-yin-chrome-extension";
      const VITE_AGENT_NAME = "客资工具";
      const terminal_result = await register_terminal(VITE_AGENT_ID22, VITE_AGENT_NAME);
      if (!terminal_result || !terminal_result.terminalId) {
        console.log("注册设备错误");
        console.error("注册设备失败");
        return false;
      }
      const postTerminalData = {
        "agent_id": VITE_AGENT_ID22,
        "terminal_name": store$b.webUserName ? store$b.webUserName : "请设置设备名称",
        "tenant_id": store$b.tenantId,
        "terminal_info": {
          "client_id": store$b.cpuSerialNumber
        }
      };
      const saveTerminalResult = await saveTerminal(terminal_result.terminalId, postTerminalData);
      if (!saveTerminalResult || !saveTerminalResult.data) {
        console.log("保存设备错误");
        console.error("保存设备失败");
        return false;
      }
      terminalInfo = await queryTerminal();
      if (!terminalInfo) {
        console.log("没有设备信息");
        console.error("获取设备信息失败");
        return false;
      }
    } else {
      if (boolBind) {
        const saveTerminalBindData = {
          "terminal_name": store$b.webUserName ? store$b.webUserName : "请设置设备名称"
        };
        const saveTerminalBindRes = await saveTerminalBind(terminalInfo.terminalId, saveTerminalBindData);
        console.log("agentBusiness saveTerminalBindRes", saveTerminalBindRes);
      }
    }
    const terminalCredentialsResult = await terminalCredentials(terminalInfo.terminalId, store$b.accessToken);
    if (!terminalCredentialsResult || !terminalCredentialsResult.data || !terminalCredentialsResult.data.mqtt_username || !terminalCredentialsResult.data.mqtt_password) {
      console.log("获取密码错误");
      console.error("获取连接信息失败");
      return false;
    }
    const VITE_AGENT_ID2 = "dou-yin-chrome-extension";
    store$b.setTerminalData({
      terminalId: terminalInfo.terminalId,
      terminalName: terminalInfo.terminalName,
      topic: {
        // 订阅任务
        "task_topic": `/msg/task/${store$b.tenantId}/+/${VITE_AGENT_ID2}/${terminalInfo.terminalId}`,
        // 任务执行状态
        "task_reply_topics": `/msg/reply/terminal/${store$b.tenantId}/${store$b.userId}/${VITE_AGENT_ID2}/${terminalInfo.terminalId}`,
        // 终端状态
        "status_reply_topics": `/msg/reply/terminal/${store$b.tenantId}/${store$b.userId}/${VITE_AGENT_ID2}/${terminalInfo.terminalId}/status`,
        // 运行日志
        "run_logs_reply_topics": `/msg/reply/terminal/${store$b.tenantId}/${store$b.userId}/${VITE_AGENT_ID2}/${terminalInfo.terminalId}/run_logs`,
        // 心跳
        "heart_beat_topics": `/msg/reply/terminal/${store$b.tenantId}/${store$b.userId}/${VITE_AGENT_ID2}/${terminalInfo.terminalId}/heart_beat`,
        // 报告
        "report_topics": `/msg/reply/terminal/${store$b.tenantId}/${store$b.userId}/${VITE_AGENT_ID2}/${terminalInfo.terminalId}/report`
      },
      "mqtt_username": terminalCredentialsResult.data.mqtt_username,
      "mqtt_password": terminalCredentialsResult.data.mqtt_password
    });
    console.log("获取terminalCredentials 成功");
    return true;
  } catch (e) {
    console.log("agentBusiness e" + e);
    console.error("连接失败，请稍后再试");
  }
  return false;
};
const VITE_CONTENT_API$8 = "https://agent-net.paitongai.net/content";
const VITE_PAYMENT_API$1 = void 0;
const store$a = UseCounterStore.getInstance();
class CustomizeDouYinPushTask extends BaseTask {
  constructor(taskId, executeId, data, executeTask2) {
    super(taskId, executeId, data);
    __publicField(this, "executeTask");
    //评论数量
    __publicField(this, "xhs_viewCount");
    __publicField(this, "xhs_CommentCount");
    __publicField(this, "xhs_likeCount");
    __publicField(this, "xhs_followCount");
    __publicField(this, "xhs_collectCount");
    //评论数量
    __publicField(this, "dy_viewCount");
    __publicField(this, "dy_CommentCount");
    __publicField(this, "dy_likeCount");
    __publicField(this, "dy_followCount");
    __publicField(this, "dy_collectCount");
    __publicField(this, "taskPlatform");
    __publicField(this, "XiaoHongShu_Setting");
    __publicField(this, "operationTime");
    __publicField(this, "runMinuteTime");
    __publicField(this, "startLoad");
    __publicField(this, "loadend");
    // 上报数据
    __publicField(this, "executeOperationStartTime");
    __publicField(this, "executeOperationEndTime");
    __publicField(this, "xhs_keywords_list");
    __publicField(this, "douYin_keywords_list");
    __publicField(this, "xhs_minute");
    __publicField(this, "dy_minute");
    __publicField(this, "videoLink");
    __publicField(this, "postItemUsage", async () => {
      const url = VITE_PAYMENT_API$1 + "/item_usage?usage_type=publish";
      const headers = {
        accept: "application/json",
        ...this.addAuthorizationHeader()
      };
      try {
        const response = await fetch(url, {
          method: "POST",
          headers
        });
        if (!response.ok) {
          console.log("url:" + url + "，header:" + JSON.stringify(headers) + ", response status:" + response.status);
          return;
        }
        const result = await response.json();
        console.log("url:" + url + "，header:" + JSON.stringify(headers) + ",response status:" + response.status + ", response data:" + JSON.stringify(result));
      } catch (error) {
        console.error("请求失败:", error);
      }
    });
    // reportVideoLink(videoLink:string){
    //     console.log("reportVideoLink")
    //     if(!this.conn){
    //         return
    //     }
    //     const  status = this.getStatus();
    //     status.videoLink = videoLink; // 添加新属性
    //
    //     this.conn.messageToReplyMQTT({
    //         "taskId": this.taskId,
    //         "executeId": this.executeId,
    //         "status": "running",
    //         "meta": status,
    //         "message": ""
    //     });
    // }
    __publicField(this, "reportRunDataStatus", async () => {
      var _a;
      console.log("reportRunDataStatus");
      if (!this.conn) {
        return;
      }
      const runData = this.getRunData();
      console.log("runData", JSON.stringify(runData));
      this.conn.messageToStatusMQTT({
        "taskId": this.taskId,
        "data": runData,
        "userId": this.user_id,
        "terminalId": (_a = this.terminalData) == null ? void 0 : _a.terminalId
      });
    });
    __publicField(this, "reportRunData", async () => {
      var _a;
      const url = VITE_CONTENT_API$8 + "/api/content/";
      const headers = {
        "Content-Type": "application/json",
        ...this.addAuthorizationHeader()
        // Ensure this function works in the extension
      };
      try {
        console.log("reportRunData");
        const runData = this.getRunData();
        console.log("runData", JSON.stringify(runData));
        const postData = {
          "taskId": this.taskId,
          "data": runData,
          "userId": this.user_id,
          "terminalId": (_a = this.terminalData) == null ? void 0 : _a.terminalId
        };
        const response = await fetch(url, {
          method: "POST",
          headers,
          body: JSON.stringify(postData)
        });
        if (!response.ok) {
          console.log("url:" + url + "，header:" + JSON.stringify(headers) + ", response status:" + response.status);
          return;
        }
        const result = await response.json();
        console.log("url:" + url + "，header:" + JSON.stringify(headers) + ",postData：" + JSON.stringify(postData) + " response status:" + response.status + ", response data:" + JSON.stringify(result));
      } catch (error) {
        console.log("Error in putNewTask:", error);
        sendLog("url:" + url + "，header:" + JSON.stringify(headers) + ", error" + error);
      }
    });
    __publicField(this, "callBackListener", (changes, namespace) => {
      for (let [key, {
        oldValue,
        newValue
      }] of Object.entries(changes)) {
        console.log(`customizeTask Storage key "${key}" in namespace "${namespace}" changed.`, `Old value was "${oldValue}", new value is "${newValue}".`);
        switch (key) {
          case "runTaskStopped":
            if (newValue == "end") {
              this.reportStop().then(() => {});
            }
            break;
          case "taskPlatform":
            this.taskPlatform = newValue;
            break;
          case "XiaoHongShu_Setting":
            this.XiaoHongShu_Setting = newValue ? JSON.parse(newValue) : {};
            break;
          case "orgId":
            this.orgId = newValue;
            break;
          case "userId":
            this.user_id = newValue;
            break;
          case "clientVisitorId":
            this.clientVisitorId = newValue;
            break;
          case "accessToken":
            this.accessToken = newValue;
            break;
          case "operationTime":
            this.operationTime = newValue;
            break;
          case "runMinuteTime":
            this.runMinuteTime = newValue;
            this.reportReply();
            break;
          case "xhs_likeCount":
            this.xhs_likeCount = newValue;
            this.reportRunDataStatus().then();
            break;
          case "xhs_followCount":
            this.xhs_followCount = newValue;
            this.reportRunDataStatus().then();
            break;
          case "xhs_CommentCount":
            this.xhs_CommentCount = newValue;
            this.reportRunDataStatus().then();
            break;
          case "xhs_collectCount":
            this.xhs_collectCount = newValue;
            this.reportRunDataStatus().then();
            break;
          case "xhs_viewCount":
            this.xhs_viewCount = newValue;
            this.reportRunDataStatus().then();
            break;
          case "dy_likeCount":
            this.dy_likeCount = newValue;
            this.reportRunDataStatus().then();
            break;
          case "dy_followCount":
            this.dy_followCount = newValue;
            this.reportRunDataStatus().then();
            break;
          case "dy_CommentCount":
            this.dy_CommentCount = newValue;
            this.reportRunDataStatus().then();
            break;
          case "dy_collectCount":
            this.dy_collectCount = newValue;
            this.reportRunDataStatus().then();
            break;
          case "dy_viewCount":
            this.dy_viewCount = newValue;
            this.reportRunDataStatus().then();
            break;
          case "executeOperationStartTime":
            this.executeOperationStartTime = newValue;
            break;
          case "executeOperationEndTime":
            this.executeOperationEndTime = newValue;
            break;
          case "xhs_keywords_list":
            this.xhs_keywords_list = newValue ? JSON.parse(newValue) : [];
            break;
          case "douYin_keywords_list":
            this.douYin_keywords_list = newValue ? JSON.parse(newValue) : [];
            break;
          case "xhs_minute":
            this.xhs_minute = newValue ? JSON.parse(newValue) : [];
            break;
          case "dy_minute":
            this.dy_minute = newValue ? JSON.parse(newValue) : [];
            break;
          case "videoLink":
            this.videoLink = newValue;
            break;
        }
      }
    });
    this.startLoad = false;
    this.loadend = false;
    this.xhs_viewCount = 0;
    this.xhs_CommentCount = 0;
    this.xhs_likeCount = 0;
    this.xhs_followCount = 0;
    this.xhs_collectCount = 0;
    this.dy_viewCount = 0;
    this.dy_CommentCount = 0;
    this.dy_likeCount = 0;
    this.dy_followCount = 0;
    this.dy_collectCount = 0;
    this.operationTime = 0;
    this.runMinuteTime = 0;
    this.taskPlatform = "";
    this.XiaoHongShu_Setting = "";
    this.executeTask = executeTask2;
    this.executeOperationStartTime = 0;
    this.executeOperationEndTime = 0;
    this.xhs_keywords_list = [];
    this.douYin_keywords_list = [];
    this.xhs_minute = [];
    this.dy_minute = [];
    this.loadFromStorage();
  }
  /**
   * 检查配置是否正确
   */
  checkConfig() {
    return true;
  }
  startTask() {
    return new Promise(resolve => {
      const validationError = this.validateParameters();
      if (!this.conn) {
        return;
      }
      if (validationError) {
        console.error(validationError.message);
        this.conn.messageToReplyMQTT({
          "taskId": this.taskId,
          "executeId": this.executeId,
          "status": "failed",
          "meta": {},
          "message": validationError.message
        });
        return;
      }
      console.log("Do a customize task!");
      this.my_execute(this.data);
      this.conn.messageToReplyMQTT({
        "taskId": this.taskId,
        "executeId": this.executeId,
        "status": "running",
        "meta": this.getStatus(),
        "message": ""
      });
      resolve();
    });
  }
  validateParameters() {
    if (!this.data) {
      return {
        message: "参数未传递或格式不正确"
      };
    }
    return null;
  }
  my_execute(config) {
    chrome.storage.local.set({
      "runTaskStopped": ""
    });
    chrome.storage.local.set({
      "mqttStart": "ok"
    });
    chrome.storage.local.set({
      "xhs_viewCount": 0
    });
    chrome.storage.local.set({
      "xhs_CommentCount": 0
    });
    chrome.storage.local.set({
      "xhs_likeCount": 0
    });
    chrome.storage.local.set({
      "xhs_followCount": 0
    });
    chrome.storage.local.set({
      "xhs_collectCount": 0
    });
    chrome.storage.local.set({
      "dy_viewCount": 0
    });
    chrome.storage.local.set({
      "dy_CommentCount": 0
    });
    chrome.storage.local.set({
      "dy_likeCount": 0
    });
    chrome.storage.local.set({
      "dy_followCount": 0
    });
    chrome.storage.local.set({
      "dy_collectCount": 0
    });
    chrome.storage.local.set({
      "activatePage": runPages[0]
    });
    chrome.storage.local.set({
      "operationTime": 0
    });
    chrome.storage.local.set({
      "xiaoHongShuAccountErrorTip": ""
    });
    chrome.storage.local.set({
      "xhs_keywords_list": JSON.stringify([])
    });
    chrome.storage.local.set({
      "douYin_keywords_list": JSON.stringify([])
    });
    chrome.storage.local.set({
      "xhs_minute": JSON.stringify([])
    });
    chrome.storage.local.set({
      "dy_minute": JSON.stringify([])
    });
    chrome.storage.local.set({
      "optionsPageName": ""
    });
    chrome.storage.local.set({
      "executeOperationStartTime": (/* @__PURE__ */new Date()).getTime()
    });
    chrome.storage.local.set({
      "XiaoHongShu_Setting": JSON.stringify(config)
    });
    chrome.storage.local.set({
      "DouYin_search_runNumber": 1
    });
    if (!this.XiaoHongShu_Setting) {
      this.XiaoHongShu_Setting = config;
    }
    if (config.workDouYinPlatform == "抖音") {
      if (!this.taskPlatform) {
        this.taskPlatform = config.workDouYinPlatform;
      }
      let url = "https://creator.douyin.com/creator-micro/content/upload?default-tab=3";
      if (config.contentType == "视频") {
        url = "https://creator.douyin.com/creator-micro/content/upload?default-tab=1";
      }
      this.executeTask({
        action: "executeTask",
        url,
        taskName: config.taskName,
        taskPlatform: config.workDouYinPlatform,
        taskId: this.taskId
      }, {}, res => {
        if (res && res.tabId) {
          this.tabId = res.tabId;
        }
        if (res && res.windowId) {
          this.windowId = res.windowId;
        }
        console.log("executeTask res", res);
      });
    }
    if (config.workXiaoHongShuPlatform == "小红书") {
      this.executeTask({
        action: "executeTask",
        url: "https://www.xiaohongshu.com/explore",
        taskName: config.taskName,
        taskPlatform: config.workXiaoHongShuPlatform,
        taskId: this.taskId
      }, {}, res => {
        if (res && res.tabId) {
          this.tabId = res.tabId;
        }
        if (res && res.windowId) {
          this.windowId = res.windowId;
        }
        console.log("executeTask res", res);
      });
      if (!this.taskPlatform) {
        this.taskPlatform = config.workXiaoHongShuPlatform;
      }
    }
  }
  stopTask() {
    return new Promise(resolve => {
      sendLog("customizeDouYinPushTask background activatePage ：", indexPage);
      chrome.storage.local.set({
        "activatePage": indexPage
      });
      resolve();
    });
  }
  abortTask() {
    return new Promise(resolve => {
      this.reportStop().then(() => {});
      resolve();
    });
  }
  report() {
    return new Promise(resolve => {
      console.log("report Promise");
      try {
        let formatTimestamp = function (timestamp) {
            const date = new Date(timestamp);
            const month = String(date.getMonth() + 1).padStart(2, "0");
            const day = String(date.getDate()).padStart(2, "0");
            const hours = String(date.getHours()).padStart(2, "0");
            const minutes = String(date.getMinutes()).padStart(2, "0");
            return `${month}-${day} ${hours}:${minutes}`;
          },
          calculateTimeDifference = function (startTimestamp, endTimestamp) {
            const differenceInMs = Math.abs(endTimestamp - startTimestamp);
            const totalMinutes = Math.floor(differenceInMs / (1e3 * 60));
            return `${totalMinutes}`;
          };
        if (!this.conn) {
          resolve();
          return;
        }
        const executeOperationStartTime = formatTimestamp(this.executeOperationStartTime);
        const executeOperationEndTime = formatTimestamp(this.executeOperationEndTime);
        const run_time = calculateTimeDifference(this.executeOperationStartTime, this.executeOperationEndTime);
        let xhs_keywords_list_str = "";
        if (this.xhs_keywords_list.length > 0) {
          xhs_keywords_list_str = this.xhs_keywords_list.join("，");
        }
        let douYin_keywords_list_str = "";
        if (this.douYin_keywords_list.length > 0) {
          douYin_keywords_list_str = this.douYin_keywords_list.join("，");
        }
        let XiaoHongShu_Setting = this.XiaoHongShu_Setting;
        let workRunPlatform = "";
        if (XiaoHongShu_Setting.workDouYinPlatform) {
          if (!workRunPlatform) {
            workRunPlatform = XiaoHongShu_Setting.workDouYinPlatform;
          } else {
            workRunPlatform += "+" + XiaoHongShu_Setting.workDouYinPlatform;
          }
        }
        if (XiaoHongShu_Setting.workXiaoHongShuPlatform) {
          if (!workRunPlatform) {
            workRunPlatform = XiaoHongShu_Setting.workXiaoHongShuPlatform;
          } else {
            workRunPlatform += "+" + XiaoHongShu_Setting.workXiaoHongShuPlatform;
          }
        }
        const uniqueMinutes = [... /* @__PURE__ */new Set([...this.xhs_minute.map(item => item.minute), ...this.dy_minute.map(item => item.minute)])].sort((a, b) => a - b);
        const xhsNums = uniqueMinutes.map(minute => {
          var _a;
          return ((_a = this.xhs_minute.find(item => item.minute === minute)) == null ? void 0 : _a.num) || 0;
        });
        const xhsPieNumber = [{
          value: store$a.xhs_likeCount,
          name: "点赞"
        }, {
          value: store$a.xhs_CommentCount,
          name: "评论"
        }, {
          value: store$a.xhs_followCount,
          name: "关注"
        }, {
          value: store$a.xhs_collectCount,
          name: "收藏"
        }];
        const dyPieNumber = [{
          value: store$a.dy_likeCount,
          name: "点赞"
        }, {
          value: store$a.dy_CommentCount,
          name: "评论"
        }, {
          value: store$a.dy_followCount,
          name: "关注"
        }, {
          value: store$a.dy_collectCount,
          name: "收藏"
        }];
        const allPieNumber = [{
          value: store$a.xhs_likeCount + store$a.dy_likeCount,
          name: "点赞"
        }, {
          value: store$a.xhs_CommentCount + store$a.dy_CommentCount,
          name: "评论"
        }, {
          value: store$a.xhs_followCount + store$a.dy_followCount,
          name: "关注"
        }, {
          value: store$a.xhs_collectCount + store$a.dy_collectCount,
          name: "收藏"
        }];
        const postData = {
          executeOperationStartTime,
          executeOperationEndTime,
          run_time,
          xhs_keywords_list_str,
          douYin_keywords_list_str,
          workRunPlatform,
          uniqueMinutes,
          xhsNums,
          xhsPieNumber,
          dyPieNumber,
          allPieNumber
        };
        console.log("messageToReportMQTT postData", JSON.stringify(postData));
        sendLog("Task stopped");
        this.conn.messageToReportMQTT({
          "taskId": this.taskId,
          "executeId": this.executeId,
          "status": "report",
          "meta": postData,
          "message": "报告"
        });
        resolve();
      } catch (e) {
        console.log("report e", e);
      }
    });
  }
  /**
   * 获取心跳上报数据
   */
  getHeartReportData() {
    return {};
  }
  /**
   * 等待store 通知 callBackListener
   */
  async reportStop() {
    this.running = false;
    this.paused = false;
    this.callExecuteNotification();
    if (!this.conn) {
      return;
    }
    sendLog("Task stopped");
    const status = this.getStatus();
    status.videoLink = this.videoLink;
    if (this.videoLink) {
      this.postItemUsage().then(r => {
        console.log(r);
      });
      this.conn.messageToReplyMQTT({
        "taskId": this.taskId,
        "executeId": this.executeId,
        "status": "completed",
        "meta": status,
        "message": "已停止"
      });
    }
    storageUtil.removeListener(this.callBackListener);
    super.baseReportStop();
  }
  getStatus() {
    return {
      id: this.taskId,
      running: this.running,
      paused: this.paused,
      started: this.started,
      process: this.operationTime > 0 ? (this.runMinuteTime / this.operationTime * 100).toFixed(2) : 0,
      total_num: this.operationTime,
      executed_num: this.runMinuteTime
    };
  }
  getRunData() {
    if (this.taskPlatform === "抖音") {
      return {
        viewCount: this.dy_viewCount,
        commentCount: this.dy_CommentCount,
        likeCount: this.dy_likeCount,
        followCount: this.dy_followCount,
        collectCount: this.dy_collectCount,
        operationTime: this.operationTime,
        runMinuteTime: this.runMinuteTime
      };
    } else if (this.taskPlatform === "小红书") {
      return {
        likeCount: this.xhs_likeCount,
        followCount: this.xhs_followCount,
        commentCount: this.xhs_CommentCount,
        collectCount: this.xhs_collectCount,
        viewCount: this.xhs_viewCount,
        operationTime: this.operationTime,
        runMinuteTime: this.runMinuteTime
      };
    }
  }
  reportReply() {
    console.log("reportReply");
    if (!this.conn) {
      return;
    }
    this.conn.messageToReplyMQTT({
      "taskId": this.taskId,
      "executeId": this.executeId,
      "status": "running",
      "meta": this.getStatus(),
      "message": ""
    });
  }
  loadFromStorage() {
    if (this.startLoad) {
      console.log("startLoad", this.startLoad);
      return;
    }
    this.startLoad = true;
    chrome.storage.local.get(["taskPlatform", "XiaoHongShu_Setting", "xhs_viewCount", "xhs_CommentCount", "xhs_likeCount", "xhs_followCount", "xhs_collectCount", "dy_viewCount", "dy_CommentCount", "dy_likeCount", "dy_followCount", "dy_collectCount", "operationTime", "userId", "orgId", "clientVisitorId", "accessToken"], result => {
      console.log("result activatePage", result);
      if (!result) {
        return;
      }
      if (result.userId !== void 0) {
        this.user_id = result.userId;
      }
      if (result.orgId !== void 0) {
        this.orgId = result.orgId;
      }
      if (result.clientVisitorId !== void 0) {
        this.clientVisitorId = result.clientVisitorId;
      }
      if (result.accessToken !== void 0) {
        this.accessToken = result.accessToken;
      }
      if (result.taskPlatform !== void 0) {
        this.taskPlatform = result.taskPlatform;
      }
      if (result.XiaoHongShu_Setting !== void 0) {
        this.XiaoHongShu_Setting = result.XiaoHongShu_Setting ? JSON.parse(result.XiaoHongShu_Setting) : {};
      }
      if (result.xhs_viewCount !== void 0) {
        this.xhs_viewCount = result.xhs_viewCount;
      }
      if (result.xhs_CommentCount !== void 0) {
        this.xhs_CommentCount = result.xhs_CommentCount;
      }
      if (result.xhs_likeCount !== void 0) {
        this.xhs_likeCount = result.xhs_likeCount;
      }
      if (result.xhs_followCount !== void 0) {
        this.xhs_followCount = result.xhs_followCount;
      }
      if (result.xhs_collectCount !== void 0) {
        this.xhs_collectCount = result.xhs_collectCount;
      }
      if (result.dy_viewCount !== void 0) {
        this.dy_viewCount = result.dy_viewCount;
      }
      if (result.dy_CommentCount !== void 0) {
        this.dy_CommentCount = result.dy_CommentCount;
      }
      if (result.dy_likeCount !== void 0) {
        this.dy_likeCount = result.dy_likeCount;
      }
      if (result.dy_followCount !== void 0) {
        this.dy_followCount = result.dy_followCount;
      }
      if (result.dy_collectCount !== void 0) {
        this.dy_collectCount = result.dy_collectCount;
      }
      if (result.operationTime !== void 0) {
        this.operationTime = result.operationTime;
      }
      this.startLoad = true;
      this.loadend = true;
    });
    storageUtil.addHandlers(this.callBackListener);
  }
}
const store$9 = UseCounterStore.getInstance();
const VITE_CHAT_API = "https://wecom-c-release-lbecklkhaa.cn-huhehaote.fcapp.run";
async function saveTaskData(postData) {
  console.log("register_terminal accessToken: " + store$9.accessToken);
  const url = VITE_CHAT_API + "/api/v1/douyin/task";
  const headers = {
    "Content-Type": "application/json",
    "Authorization": "Bearer " + store$9.accessToken
  };
  try {
    const response = await fetch(url, {
      method: "POST",
      headers,
      body: JSON.stringify(postData)
    });
    if (!response.ok) {
      console.log("url:" + url + "，header:" + JSON.stringify(headers) + ", response status:" + response.status);
      console.error(`HTTP error! status: ${response.status}`);
      if (response.status == 404) {
        return void 0;
      }
      return void 0;
    }
    const result = await response.json();
    console.log("url:" + url + "，header:" + JSON.stringify(headers) + " response status:" + response.status + ", response data:" + JSON.stringify(result));
    console.log("result", result);
    return result;
  } catch (error) {
    console.log("url:" + url + "，header:" + JSON.stringify(headers) + ", error" + error);
    console.error("Error:", error);
  }
  return void 0;
}
const VITE_CONTENT_API$7 = "https://agent-net.paitongai.net/content";
const VITE_AGENT_ID$3 = "dou-yin-chrome-extension";
const store$8 = UseCounterStore.getInstance();
class DouYinYangHaoZhuShouTask extends BaseTask {
  constructor(taskId, executeId, data, executeTask2) {
    super(taskId, executeId, data);
    __publicField(this, "executeTask");
    //评论数量
    __publicField(this, "xhs_viewCount");
    __publicField(this, "xhs_CommentCount");
    __publicField(this, "xhs_likeCount");
    __publicField(this, "xhs_followCount");
    __publicField(this, "xhs_collectCount");
    //评论数量
    __publicField(this, "dy_viewCount");
    __publicField(this, "dy_CommentCount");
    __publicField(this, "dy_likeCount");
    __publicField(this, "dy_followCount");
    __publicField(this, "dy_collectCount");
    __publicField(this, "taskPlatform");
    __publicField(this, "XiaoHongShu_Setting");
    __publicField(this, "operationTime");
    __publicField(this, "runMinuteTime");
    __publicField(this, "startLoad");
    __publicField(this, "loadend");
    // 上报数据
    __publicField(this, "executeOperationStartTime");
    __publicField(this, "executeOperationEndTime");
    __publicField(this, "xhs_keywords_list");
    __publicField(this, "douYin_keywords_list");
    __publicField(this, "xhs_minute");
    __publicField(this, "dy_minute");
    __publicField(this, "reportRunDataStatus", async () => {
      var _a;
      console.log("reportRunDataStatus");
      if (!this.conn) {
        return;
      }
      const runData = this.getRunData();
      console.log("runData", JSON.stringify(runData));
      this.conn.messageToStatusMQTT({
        "taskId": this.taskId,
        "data": runData,
        "userId": this.user_id,
        "terminalId": (_a = this.terminalData) == null ? void 0 : _a.terminalId
      });
    });
    __publicField(this, "reportRunData", async () => {
      var _a;
      const url = VITE_CONTENT_API$7 + "/api/content/";
      const headers = {
        "Content-Type": "application/json",
        ...this.addAuthorizationHeader()
        // Ensure this function works in the extension
      };
      try {
        console.log("reportRunData");
        const runData = this.getRunData();
        console.log("runData", JSON.stringify(runData));
        const postData = {
          "taskId": this.taskId,
          "data": runData,
          "userId": this.user_id,
          "terminalId": (_a = this.terminalData) == null ? void 0 : _a.terminalId
        };
        const response = await fetch(url, {
          method: "POST",
          headers,
          body: JSON.stringify(postData)
        });
        if (!response.ok) {
          console.log("url:" + url + "，header:" + JSON.stringify(headers) + ", response status:" + response.status);
          return;
        }
        const result = await response.json();
        console.log("url:" + url + "，header:" + JSON.stringify(headers) + ",postData：" + JSON.stringify(postData) + " response status:" + response.status + ", response data:" + JSON.stringify(result));
      } catch (error) {
        console.log("Error in putNewTask:", error);
        sendLog("url:" + url + "，header:" + JSON.stringify(headers) + ", error" + error);
      }
    });
    __publicField(this, "callBackListener", (changes, namespace) => {
      for (let [key, {
        oldValue,
        newValue
      }] of Object.entries(changes)) {
        console.log(`customizeTask Storage key "${key}" in namespace "${namespace}" changed.`, `Old value was "${oldValue}", new value is "${newValue}".`);
        switch (key) {
          case "runTaskStopped":
            if (newValue == "end") {
              this.reportStop().then(() => {});
            }
            break;
          case "taskPlatform":
            this.taskPlatform = newValue;
            break;
          case "XiaoHongShu_Setting":
            this.XiaoHongShu_Setting = newValue ? JSON.parse(newValue) : {};
            break;
          case "orgId":
            this.orgId = newValue;
            break;
          case "userId":
            this.user_id = newValue;
            break;
          case "clientVisitorId":
            this.clientVisitorId = newValue;
            break;
          case "accessToken":
            this.accessToken = newValue;
            break;
          case "operationTime":
            this.operationTime = newValue;
            break;
          case "runMinuteTime":
            this.runMinuteTime = newValue;
            this.reportReply();
            break;
          case "xhs_likeCount":
            this.xhs_likeCount = newValue;
            this.reportRunDataStatus().then();
            break;
          case "xhs_followCount":
            this.xhs_followCount = newValue;
            this.reportRunDataStatus().then();
            break;
          case "xhs_CommentCount":
            this.xhs_CommentCount = newValue;
            this.reportRunDataStatus().then();
            break;
          case "xhs_collectCount":
            this.xhs_collectCount = newValue;
            this.reportRunDataStatus().then();
            break;
          case "xhs_viewCount":
            this.xhs_viewCount = newValue;
            this.reportRunDataStatus().then();
            break;
          case "dy_likeCount":
            this.dy_likeCount = newValue;
            this.reportRunDataStatus().then();
            break;
          case "dy_followCount":
            this.dy_followCount = newValue;
            this.reportRunDataStatus().then();
            break;
          case "dy_CommentCount":
            this.dy_CommentCount = newValue;
            this.reportRunDataStatus().then();
            break;
          case "dy_collectCount":
            this.dy_collectCount = newValue;
            this.reportRunDataStatus().then();
            break;
          case "dy_viewCount":
            this.dy_viewCount = newValue;
            this.reportRunDataStatus().then();
            break;
          case "executeOperationStartTime":
            this.executeOperationStartTime = newValue;
            break;
          case "executeOperationEndTime":
            this.executeOperationEndTime = newValue;
            break;
          case "xhs_keywords_list":
            this.xhs_keywords_list = newValue ? JSON.parse(newValue) : [];
            break;
          case "douYin_keywords_list":
            this.douYin_keywords_list = newValue ? JSON.parse(newValue) : [];
            break;
          case "xhs_minute":
            this.xhs_minute = newValue ? JSON.parse(newValue) : [];
            break;
          case "dy_minute":
            this.dy_minute = newValue ? JSON.parse(newValue) : [];
            break;
        }
      }
    });
    this.startLoad = false;
    this.loadend = false;
    this.xhs_viewCount = 0;
    this.xhs_CommentCount = 0;
    this.xhs_likeCount = 0;
    this.xhs_followCount = 0;
    this.xhs_collectCount = 0;
    this.dy_viewCount = 0;
    this.dy_CommentCount = 0;
    this.dy_likeCount = 0;
    this.dy_followCount = 0;
    this.dy_collectCount = 0;
    this.operationTime = 0;
    this.runMinuteTime = 0;
    this.taskPlatform = "";
    this.XiaoHongShu_Setting = "";
    this.executeTask = executeTask2;
    this.executeOperationStartTime = 0;
    this.executeOperationEndTime = 0;
    this.xhs_keywords_list = [];
    this.douYin_keywords_list = [];
    this.xhs_minute = [];
    this.dy_minute = [];
    this.loadFromStorage();
  }
  /**
   * 检查配置是否正确
   */
  checkConfig() {
    return true;
  }
  startTask() {
    return new Promise(async resolve => {
      const validationError = this.validateParameters();
      if (!this.conn) {
        resolve();
        return;
      }
      if (validationError) {
        console.error(validationError.message);
        this.conn.messageToReplyMQTT({
          "taskId": this.taskId,
          "executeId": this.executeId,
          "status": "failed",
          "meta": {},
          "message": validationError.message
        });
        resolve();
        return;
      }
      console.log("Do a customize task!");
      await this.my_execute(this.data);
      this.conn.messageToReplyMQTT({
        "taskId": this.taskId,
        "executeId": this.executeId,
        "status": "running",
        "meta": this.getStatus(),
        "message": ""
      });
      resolve();
    });
  }
  validateParameters() {
    if (!this.data) {
      return {
        message: "参数未传递或格式不正确"
      };
    }
    return null;
  }
  async my_execute(config) {
    var _a;
    chrome.storage.local.set({
      "runTaskStopped": ""
    });
    chrome.storage.local.set({
      "mqttStart": "ok"
    });
    chrome.storage.local.set({
      "xhs_viewCount": 0
    });
    chrome.storage.local.set({
      "xhs_CommentCount": 0
    });
    chrome.storage.local.set({
      "xhs_likeCount": 0
    });
    chrome.storage.local.set({
      "xhs_followCount": 0
    });
    chrome.storage.local.set({
      "xhs_collectCount": 0
    });
    chrome.storage.local.set({
      "dy_viewCount": 0
    });
    chrome.storage.local.set({
      "dy_CommentCount": 0
    });
    chrome.storage.local.set({
      "dy_likeCount": 0
    });
    chrome.storage.local.set({
      "dy_followCount": 0
    });
    chrome.storage.local.set({
      "dy_collectCount": 0
    });
    chrome.storage.local.set({
      "activatePage": runPages[0]
    });
    chrome.storage.local.set({
      "operationTime": 0
    });
    chrome.storage.local.set({
      "xiaoHongShuAccountErrorTip": ""
    });
    chrome.storage.local.set({
      "xhs_keywords_list": JSON.stringify([])
    });
    chrome.storage.local.set({
      "douYin_keywords_list": JSON.stringify([])
    });
    chrome.storage.local.set({
      "xhs_minute": JSON.stringify([])
    });
    chrome.storage.local.set({
      "dy_minute": JSON.stringify([])
    });
    chrome.storage.local.set({
      "optionsPageName": ""
    });
    chrome.storage.local.set({
      "executeOperationStartTime": (/* @__PURE__ */new Date()).getTime()
    });
    chrome.storage.local.set({
      "XiaoHongShu_Setting": JSON.stringify(config)
    });
    chrome.storage.local.set({
      "DouYin_search_runNumber": 1
    });
    if (!this.XiaoHongShu_Setting) {
      this.XiaoHongShu_Setting = config;
    }
    if (config.workDouYinPlatform == "抖音") {
      if (!this.taskPlatform) {
        this.taskPlatform = config.workDouYinPlatform;
      }
      const saveTaskDataResult = await saveTaskData({
        task_options: {
          taskId: this.taskId,
          executeId: this.executeId,
          agentId: VITE_AGENT_ID$3,
          terminalId: (_a = store$8.terminalData) == null ? void 0 : _a.terminalId
        }
      });
      console.log("saveTaskDataResult", saveTaskDataResult);
      if (saveTaskDataResult && saveTaskDataResult.code == 0) {
        store$8.setQuestTaskId(saveTaskDataResult.data.id);
      }
      this.executeTask({
        action: "executeTask",
        url: "https://www.douyin.com",
        taskName: config.workType,
        taskPlatform: config.workDouYinPlatform,
        taskId: this.taskId
      }, {}, res => {
        if (res && res.tabId) {
          this.tabId = res.tabId;
        }
        if (res && res.windowId) {
          this.windowId = res.windowId;
        }
        console.log("executeTask res", res);
      });
    }
    if (config.workXiaoHongShuPlatform == "小红书") {
      this.executeTask({
        action: "executeTask",
        url: "https://www.xiaohongshu.com/explore",
        taskName: config.workType,
        taskPlatform: config.workXiaoHongShuPlatform,
        taskId: this.taskId
      }, {}, res => {
        if (res && res.tabId) {
          this.tabId = res.tabId;
        }
        if (res && res.windowId) {
          this.windowId = res.windowId;
        }
        console.log("executeTask res", res);
      });
      if (!this.taskPlatform) {
        this.taskPlatform = config.workXiaoHongShuPlatform;
      }
    }
  }
  stopTask() {
    return new Promise(resolve => {
      sendLog("douYinYangHaoZhuShouTask background activatePage ：", indexPage);
      chrome.storage.local.set({
        "activatePage": indexPage
      });
      resolve();
    });
  }
  abortTask() {
    return new Promise(resolve => {
      this.reportStop().then(() => {});
      resolve();
    });
  }
  report() {
    return new Promise(resolve => {
      console.log("report Promise");
      try {
        let formatTimestamp = function (timestamp) {
            const date = new Date(timestamp);
            const month = String(date.getMonth() + 1).padStart(2, "0");
            const day = String(date.getDate()).padStart(2, "0");
            const hours = String(date.getHours()).padStart(2, "0");
            const minutes = String(date.getMinutes()).padStart(2, "0");
            return `${month}-${day} ${hours}:${minutes}`;
          },
          calculateTimeDifference = function (startTimestamp, endTimestamp) {
            const differenceInMs = Math.abs(endTimestamp - startTimestamp);
            const totalMinutes = Math.floor(differenceInMs / (1e3 * 60));
            return `${totalMinutes}`;
          };
        if (!this.conn) {
          resolve();
          return;
        }
        const executeOperationStartTime = formatTimestamp(this.executeOperationStartTime);
        const executeOperationEndTime = formatTimestamp(this.executeOperationEndTime);
        const run_time = calculateTimeDifference(this.executeOperationStartTime, this.executeOperationEndTime);
        let xhs_keywords_list_str = "";
        if (this.xhs_keywords_list.length > 0) {
          xhs_keywords_list_str = this.xhs_keywords_list.join("，");
        }
        let douYin_keywords_list_str = "";
        if (this.douYin_keywords_list.length > 0) {
          douYin_keywords_list_str = this.douYin_keywords_list.join("，");
        }
        let XiaoHongShu_Setting = this.XiaoHongShu_Setting;
        let workRunPlatform = "";
        if (XiaoHongShu_Setting.workDouYinPlatform) {
          if (!workRunPlatform) {
            workRunPlatform = XiaoHongShu_Setting.workDouYinPlatform;
          } else {
            workRunPlatform += "+" + XiaoHongShu_Setting.workDouYinPlatform;
          }
        }
        if (XiaoHongShu_Setting.workXiaoHongShuPlatform) {
          if (!workRunPlatform) {
            workRunPlatform = XiaoHongShu_Setting.workXiaoHongShuPlatform;
          } else {
            workRunPlatform += "+" + XiaoHongShu_Setting.workXiaoHongShuPlatform;
          }
        }
        const uniqueMinutes = [... /* @__PURE__ */new Set([...this.xhs_minute.map(item => item.minute), ...this.dy_minute.map(item => item.minute)])].sort((a, b) => a - b);
        const xhsNums = uniqueMinutes.map(minute => {
          var _a;
          return ((_a = this.xhs_minute.find(item => item.minute === minute)) == null ? void 0 : _a.num) || 0;
        });
        const xhsPieNumber = [{
          value: store$8.xhs_likeCount,
          name: "点赞"
        }, {
          value: store$8.xhs_CommentCount,
          name: "评论"
        }, {
          value: store$8.xhs_followCount,
          name: "关注"
        }, {
          value: store$8.xhs_collectCount,
          name: "收藏"
        }];
        const dyPieNumber = [{
          value: store$8.dy_likeCount,
          name: "点赞"
        }, {
          value: store$8.dy_CommentCount,
          name: "评论"
        }, {
          value: store$8.dy_followCount,
          name: "关注"
        }, {
          value: store$8.dy_collectCount,
          name: "收藏"
        }];
        const allPieNumber = [{
          value: store$8.xhs_likeCount + store$8.dy_likeCount,
          name: "点赞"
        }, {
          value: store$8.xhs_CommentCount + store$8.dy_CommentCount,
          name: "评论"
        }, {
          value: store$8.xhs_followCount + store$8.dy_followCount,
          name: "关注"
        }, {
          value: store$8.xhs_collectCount + store$8.dy_collectCount,
          name: "收藏"
        }];
        const postData = {
          executeOperationStartTime,
          executeOperationEndTime,
          run_time,
          xhs_keywords_list_str,
          douYin_keywords_list_str,
          workRunPlatform,
          uniqueMinutes,
          xhsNums,
          xhsPieNumber,
          dyPieNumber,
          allPieNumber
        };
        console.log("messageToReportMQTT postData", JSON.stringify(postData));
        sendLog("Task stopped");
        this.conn.messageToReportMQTT({
          "taskId": this.taskId,
          "executeId": this.executeId,
          "status": "report",
          "meta": postData,
          "message": "报告"
        });
        resolve();
      } catch (e) {
        console.log("report e", e);
      }
    });
  }
  /**
   * 获取心跳上报数据
   */
  getHeartReportData() {
    return {};
  }
  /**
   * 等待store 通知 callBackListener
   */
  async reportStop() {
    this.running = false;
    this.paused = false;
    this.callExecuteNotification();
    if (!this.conn) {
      return;
    }
    sendLog("Task stopped");
    this.conn.messageToReplyMQTT({
      "taskId": this.taskId,
      "executeId": this.executeId,
      "status": "completed",
      "meta": this.getStatus(),
      "message": "已停止"
    });
    storageUtil.removeListener(this.callBackListener);
    super.baseReportStop();
  }
  getStatus() {
    return {
      id: this.taskId,
      running: this.running,
      paused: this.paused,
      started: this.started,
      process: this.operationTime > 0 ? (this.runMinuteTime / this.operationTime * 100).toFixed(2) : 0,
      total_num: this.operationTime,
      executed_num: this.runMinuteTime
    };
  }
  getRunData() {
    if (this.taskPlatform === "抖音") {
      return {
        viewCount: this.dy_viewCount,
        commentCount: this.dy_CommentCount,
        likeCount: this.dy_likeCount,
        followCount: this.dy_followCount,
        collectCount: this.dy_collectCount,
        operationTime: this.operationTime,
        runMinuteTime: this.runMinuteTime
      };
    } else if (this.taskPlatform === "小红书") {
      return {
        likeCount: this.xhs_likeCount,
        followCount: this.xhs_followCount,
        commentCount: this.xhs_CommentCount,
        collectCount: this.xhs_collectCount,
        viewCount: this.xhs_viewCount,
        operationTime: this.operationTime,
        runMinuteTime: this.runMinuteTime
      };
    }
  }
  reportReply() {
    console.log("reportReply");
    if (!this.conn) {
      return;
    }
    this.conn.messageToReplyMQTT({
      "taskId": this.taskId,
      "executeId": this.executeId,
      "status": "running",
      "meta": this.getStatus(),
      "message": ""
    });
  }
  loadFromStorage() {
    if (this.startLoad) {
      console.log("startLoad", this.startLoad);
      return;
    }
    this.startLoad = true;
    chrome.storage.local.get(["taskPlatform", "XiaoHongShu_Setting", "xhs_viewCount", "xhs_CommentCount", "xhs_likeCount", "xhs_followCount", "xhs_collectCount", "dy_viewCount", "dy_CommentCount", "dy_likeCount", "dy_followCount", "dy_collectCount", "operationTime", "userId", "orgId", "clientVisitorId", "accessToken"], result => {
      console.log("result activatePage", result);
      if (!result) {
        return;
      }
      if (result.userId !== void 0) {
        this.user_id = result.userId;
      }
      if (result.orgId !== void 0) {
        this.orgId = result.orgId;
      }
      if (result.clientVisitorId !== void 0) {
        this.clientVisitorId = result.clientVisitorId;
      }
      if (result.accessToken !== void 0) {
        this.accessToken = result.accessToken;
      }
      if (result.taskPlatform !== void 0) {
        this.taskPlatform = result.taskPlatform;
      }
      if (result.XiaoHongShu_Setting !== void 0) {
        this.XiaoHongShu_Setting = result.XiaoHongShu_Setting ? JSON.parse(result.XiaoHongShu_Setting) : {};
      }
      if (result.xhs_viewCount !== void 0) {
        this.xhs_viewCount = result.xhs_viewCount;
      }
      if (result.xhs_CommentCount !== void 0) {
        this.xhs_CommentCount = result.xhs_CommentCount;
      }
      if (result.xhs_likeCount !== void 0) {
        this.xhs_likeCount = result.xhs_likeCount;
      }
      if (result.xhs_followCount !== void 0) {
        this.xhs_followCount = result.xhs_followCount;
      }
      if (result.xhs_collectCount !== void 0) {
        this.xhs_collectCount = result.xhs_collectCount;
      }
      if (result.dy_viewCount !== void 0) {
        this.dy_viewCount = result.dy_viewCount;
      }
      if (result.dy_CommentCount !== void 0) {
        this.dy_CommentCount = result.dy_CommentCount;
      }
      if (result.dy_likeCount !== void 0) {
        this.dy_likeCount = result.dy_likeCount;
      }
      if (result.dy_followCount !== void 0) {
        this.dy_followCount = result.dy_followCount;
      }
      if (result.dy_collectCount !== void 0) {
        this.dy_collectCount = result.dy_collectCount;
      }
      if (result.operationTime !== void 0) {
        this.operationTime = result.operationTime;
      }
      this.startLoad = true;
      this.loadend = true;
    });
    storageUtil.addHandlers(this.callBackListener);
  }
}
const VITE_CONTENT_API$6 = "https://agent-net.paitongai.net/content";
const store$7 = UseCounterStore.getInstance();
class ShuJuJianKongCustomizeTask extends BaseTask {
  constructor(taskId, executeId, data, executeTask2) {
    super(taskId, executeId, data);
    __publicField(this, "executeTask");
    //评论数量
    __publicField(this, "xhs_viewCount");
    __publicField(this, "xhs_CommentCount");
    __publicField(this, "xhs_likeCount");
    __publicField(this, "xhs_followCount");
    __publicField(this, "xhs_collectCount");
    //评论数量
    __publicField(this, "dy_viewCount");
    __publicField(this, "dy_CommentCount");
    __publicField(this, "dy_likeCount");
    __publicField(this, "dy_followCount");
    __publicField(this, "dy_collectCount");
    __publicField(this, "taskPlatform");
    __publicField(this, "XiaoHongShu_Setting");
    __publicField(this, "operationTime");
    __publicField(this, "runMinuteTime");
    __publicField(this, "startLoad");
    __publicField(this, "loadend");
    // 上报数据
    __publicField(this, "executeOperationStartTime");
    __publicField(this, "executeOperationEndTime");
    __publicField(this, "xhs_keywords_list");
    __publicField(this, "douYin_keywords_list");
    __publicField(this, "xhs_minute");
    __publicField(this, "dy_minute");
    __publicField(this, "reportRunDataStatus", async () => {
      var _a;
      console.log("reportRunDataStatus");
      if (!this.conn) {
        return;
      }
      const runData = this.getRunData();
      console.log("runData", JSON.stringify(runData));
      this.conn.messageToStatusMQTT({
        "taskId": this.taskId,
        "data": runData,
        "userId": this.user_id,
        "terminalId": (_a = this.terminalData) == null ? void 0 : _a.terminalId
      });
    });
    __publicField(this, "reportRunData", async () => {
      var _a;
      const url = VITE_CONTENT_API$6 + "/api/content/";
      const headers = {
        "Content-Type": "application/json",
        ...this.addAuthorizationHeader()
        // Ensure this function works in the extension
      };
      try {
        console.log("reportRunData");
        const runData = this.getRunData();
        console.log("runData", JSON.stringify(runData));
        const postData = {
          "taskId": this.taskId,
          "data": runData,
          "userId": this.user_id,
          "terminalId": (_a = this.terminalData) == null ? void 0 : _a.terminalId
        };
        const response = await fetch(url, {
          method: "POST",
          headers,
          body: JSON.stringify(postData)
        });
        if (!response.ok) {
          console.log("url:" + url + "，header:" + JSON.stringify(headers) + ", response status:" + response.status);
          return;
        }
        const result = await response.json();
        console.log("url:" + url + "，header:" + JSON.stringify(headers) + ",postData：" + JSON.stringify(postData) + " response status:" + response.status + ", response data:" + JSON.stringify(result));
      } catch (error) {
        console.log("Error in putNewTask:", error);
        sendLog("url:" + url + "，header:" + JSON.stringify(headers) + ", error" + error);
      }
    });
    __publicField(this, "callBackListener", (changes, namespace) => {
      for (let [key, {
        oldValue,
        newValue
      }] of Object.entries(changes)) {
        console.log(`customizeTask Storage key "${key}" in namespace "${namespace}" changed.`, `Old value was "${oldValue}", new value is "${newValue}".`);
        switch (key) {
          case "runTaskStopped":
            if (newValue == "end") {
              this.reportStop().then(() => {});
            }
            break;
          case "taskPlatform":
            this.taskPlatform = newValue;
            break;
          case "XiaoHongShu_Setting":
            this.XiaoHongShu_Setting = newValue ? JSON.parse(newValue) : {};
            break;
          case "orgId":
            this.orgId = newValue;
            break;
          case "userId":
            this.user_id = newValue;
            break;
          case "clientVisitorId":
            this.clientVisitorId = newValue;
            break;
          case "accessToken":
            this.accessToken = newValue;
            break;
          case "operationTime":
            this.operationTime = newValue;
            break;
          case "runMinuteTime":
            this.runMinuteTime = newValue;
            this.reportReply();
            break;
          case "xhs_likeCount":
            this.xhs_likeCount = newValue;
            this.reportRunDataStatus().then();
            break;
          case "xhs_followCount":
            this.xhs_followCount = newValue;
            this.reportRunDataStatus().then();
            break;
          case "xhs_CommentCount":
            this.xhs_CommentCount = newValue;
            this.reportRunDataStatus().then();
            break;
          case "xhs_collectCount":
            this.xhs_collectCount = newValue;
            this.reportRunDataStatus().then();
            break;
          case "xhs_viewCount":
            this.xhs_viewCount = newValue;
            this.reportRunDataStatus().then();
            break;
          case "dy_likeCount":
            this.dy_likeCount = newValue;
            this.reportRunDataStatus().then();
            break;
          case "dy_followCount":
            this.dy_followCount = newValue;
            this.reportRunDataStatus().then();
            break;
          case "dy_CommentCount":
            this.dy_CommentCount = newValue;
            this.reportRunDataStatus().then();
            break;
          case "dy_collectCount":
            this.dy_collectCount = newValue;
            this.reportRunDataStatus().then();
            break;
          case "dy_viewCount":
            this.dy_viewCount = newValue;
            this.reportRunDataStatus().then();
            break;
          case "executeOperationStartTime":
            this.executeOperationStartTime = newValue;
            break;
          case "executeOperationEndTime":
            this.executeOperationEndTime = newValue;
            break;
          case "xhs_keywords_list":
            this.xhs_keywords_list = newValue ? JSON.parse(newValue) : [];
            break;
          case "douYin_keywords_list":
            this.douYin_keywords_list = newValue ? JSON.parse(newValue) : [];
            break;
          case "xhs_minute":
            this.xhs_minute = newValue ? JSON.parse(newValue) : [];
            break;
          case "dy_minute":
            this.dy_minute = newValue ? JSON.parse(newValue) : [];
            break;
        }
      }
    });
    this.startLoad = false;
    this.loadend = false;
    this.xhs_viewCount = 0;
    this.xhs_CommentCount = 0;
    this.xhs_likeCount = 0;
    this.xhs_followCount = 0;
    this.xhs_collectCount = 0;
    this.dy_viewCount = 0;
    this.dy_CommentCount = 0;
    this.dy_likeCount = 0;
    this.dy_followCount = 0;
    this.dy_collectCount = 0;
    this.operationTime = 0;
    this.runMinuteTime = 0;
    this.taskPlatform = "";
    this.XiaoHongShu_Setting = "";
    this.executeTask = executeTask2;
    this.executeOperationStartTime = 0;
    this.executeOperationEndTime = 0;
    this.xhs_keywords_list = [];
    this.douYin_keywords_list = [];
    this.xhs_minute = [];
    this.dy_minute = [];
    this.loadFromStorage();
  }
  /**
   * 检查配置是否正确
   */
  checkConfig() {
    return true;
  }
  startTask() {
    return new Promise(resolve => {
      const validationError = this.validateParameters();
      if (!this.conn) {
        return;
      }
      if (validationError) {
        console.error(validationError.message);
        this.conn.messageToReplyMQTT({
          "taskId": this.taskId,
          "executeId": this.executeId,
          "status": "failed",
          "meta": {},
          "message": validationError.message
        });
        return;
      }
      console.log("Do a customize task!");
      this.my_execute(this.data);
      this.conn.messageToReplyMQTT({
        "taskId": this.taskId,
        "executeId": this.executeId,
        "status": "running",
        "meta": this.getStatus(),
        "message": ""
      });
      resolve();
    });
  }
  validateParameters() {
    if (!this.data) {
      return {
        message: "参数未传递或格式不正确"
      };
    }
    return null;
  }
  my_execute(config) {
    chrome.storage.local.set({
      "runTaskStopped": ""
    });
    chrome.storage.local.set({
      "mqttStart": "ok"
    });
    chrome.storage.local.set({
      "xhs_viewCount": 0
    });
    chrome.storage.local.set({
      "xhs_CommentCount": 0
    });
    chrome.storage.local.set({
      "xhs_likeCount": 0
    });
    chrome.storage.local.set({
      "xhs_followCount": 0
    });
    chrome.storage.local.set({
      "xhs_collectCount": 0
    });
    chrome.storage.local.set({
      "dy_viewCount": 0
    });
    chrome.storage.local.set({
      "dy_CommentCount": 0
    });
    chrome.storage.local.set({
      "dy_likeCount": 0
    });
    chrome.storage.local.set({
      "dy_followCount": 0
    });
    chrome.storage.local.set({
      "dy_collectCount": 0
    });
    chrome.storage.local.set({
      "activatePage": runPages[0]
    });
    chrome.storage.local.set({
      "operationTime": 0
    });
    chrome.storage.local.set({
      "xiaoHongShuAccountErrorTip": ""
    });
    chrome.storage.local.set({
      "xhs_keywords_list": JSON.stringify([])
    });
    chrome.storage.local.set({
      "douYin_keywords_list": JSON.stringify([])
    });
    chrome.storage.local.set({
      "xhs_minute": JSON.stringify([])
    });
    chrome.storage.local.set({
      "dy_minute": JSON.stringify([])
    });
    chrome.storage.local.set({
      "optionsPageName": ""
    });
    chrome.storage.local.set({
      "executeOperationStartTime": (/* @__PURE__ */new Date()).getTime()
    });
    chrome.storage.local.set({
      "XiaoHongShu_Setting": JSON.stringify(config)
    });
    chrome.storage.local.set({
      "DouYin_search_runNumber": 1
    });
    if (!this.XiaoHongShu_Setting) {
      this.XiaoHongShu_Setting = config;
    }
    if (config.workDouYinPlatform == "抖音") {
      if (!this.taskPlatform) {
        this.taskPlatform = config.workDouYinPlatform;
      }
      this.executeTask({
        action: "executeTask",
        url: "https://www.douyin.com",
        taskName: config.workType,
        taskPlatform: config.workDouYinPlatform,
        taskId: this.taskId
      }, {}, res => {
        if (res && res.tabId) {
          this.tabId = res.tabId;
        }
        if (res && res.windowId) {
          this.windowId = res.windowId;
        }
        console.log("executeTask res", res);
      });
    }
    if (config.workXiaoHongShuPlatform == "小红书") {
      this.executeTask({
        action: "executeTask",
        url: "https://www.xiaohongshu.com/explore",
        taskName: config.workType,
        taskPlatform: config.workXiaoHongShuPlatform,
        taskId: this.taskId
      }, {}, res => {
        if (res && res.tabId) {
          this.tabId = res.tabId;
        }
        if (res && res.windowId) {
          this.windowId = res.windowId;
        }
        console.log("executeTask res", res);
      });
      if (!this.taskPlatform) {
        this.taskPlatform = config.workXiaoHongShuPlatform;
      }
    }
  }
  stopTask() {
    return new Promise(resolve => {
      sendLog("shuJuJianKongCustomizeTask background activatePage ：", indexPage);
      chrome.storage.local.set({
        "activatePage": indexPage
      });
      resolve();
    });
  }
  abortTask() {
    return new Promise(resolve => {
      this.reportStop().then(() => {});
      resolve();
    });
  }
  report() {
    return new Promise(resolve => {
      console.log("report Promise");
      try {
        let formatTimestamp = function (timestamp) {
            const date = new Date(timestamp);
            const month = String(date.getMonth() + 1).padStart(2, "0");
            const day = String(date.getDate()).padStart(2, "0");
            const hours = String(date.getHours()).padStart(2, "0");
            const minutes = String(date.getMinutes()).padStart(2, "0");
            return `${month}-${day} ${hours}:${minutes}`;
          },
          calculateTimeDifference = function (startTimestamp, endTimestamp) {
            const differenceInMs = Math.abs(endTimestamp - startTimestamp);
            const totalMinutes = Math.floor(differenceInMs / (1e3 * 60));
            return `${totalMinutes}`;
          };
        if (!this.conn) {
          resolve();
          return;
        }
        const executeOperationStartTime = formatTimestamp(this.executeOperationStartTime);
        const executeOperationEndTime = formatTimestamp(this.executeOperationEndTime);
        const run_time = calculateTimeDifference(this.executeOperationStartTime, this.executeOperationEndTime);
        let xhs_keywords_list_str = "";
        if (this.xhs_keywords_list.length > 0) {
          xhs_keywords_list_str = this.xhs_keywords_list.join("，");
        }
        let douYin_keywords_list_str = "";
        if (this.douYin_keywords_list.length > 0) {
          douYin_keywords_list_str = this.douYin_keywords_list.join("，");
        }
        let XiaoHongShu_Setting = this.XiaoHongShu_Setting;
        let workRunPlatform = "";
        if (XiaoHongShu_Setting.workDouYinPlatform) {
          if (!workRunPlatform) {
            workRunPlatform = XiaoHongShu_Setting.workDouYinPlatform;
          } else {
            workRunPlatform += "+" + XiaoHongShu_Setting.workDouYinPlatform;
          }
        }
        if (XiaoHongShu_Setting.workXiaoHongShuPlatform) {
          if (!workRunPlatform) {
            workRunPlatform = XiaoHongShu_Setting.workXiaoHongShuPlatform;
          } else {
            workRunPlatform += "+" + XiaoHongShu_Setting.workXiaoHongShuPlatform;
          }
        }
        const uniqueMinutes = [... /* @__PURE__ */new Set([...this.xhs_minute.map(item => item.minute), ...this.dy_minute.map(item => item.minute)])].sort((a, b) => a - b);
        const xhsNums = uniqueMinutes.map(minute => {
          var _a;
          return ((_a = this.xhs_minute.find(item => item.minute === minute)) == null ? void 0 : _a.num) || 0;
        });
        const xhsPieNumber = [{
          value: store$7.xhs_likeCount,
          name: "点赞"
        }, {
          value: store$7.xhs_CommentCount,
          name: "评论"
        }, {
          value: store$7.xhs_followCount,
          name: "关注"
        }, {
          value: store$7.xhs_collectCount,
          name: "收藏"
        }];
        const dyPieNumber = [{
          value: store$7.dy_likeCount,
          name: "点赞"
        }, {
          value: store$7.dy_CommentCount,
          name: "评论"
        }, {
          value: store$7.dy_followCount,
          name: "关注"
        }, {
          value: store$7.dy_collectCount,
          name: "收藏"
        }];
        const allPieNumber = [{
          value: store$7.xhs_likeCount + store$7.dy_likeCount,
          name: "点赞"
        }, {
          value: store$7.xhs_CommentCount + store$7.dy_CommentCount,
          name: "评论"
        }, {
          value: store$7.xhs_followCount + store$7.dy_followCount,
          name: "关注"
        }, {
          value: store$7.xhs_collectCount + store$7.dy_collectCount,
          name: "收藏"
        }];
        const postData = {
          executeOperationStartTime,
          executeOperationEndTime,
          run_time,
          xhs_keywords_list_str,
          douYin_keywords_list_str,
          workRunPlatform,
          uniqueMinutes,
          xhsNums,
          xhsPieNumber,
          dyPieNumber,
          allPieNumber
        };
        console.log("messageToReportMQTT postData", JSON.stringify(postData));
        sendLog("Task stopped");
        this.conn.messageToReportMQTT({
          "taskId": this.taskId,
          "executeId": this.executeId,
          "status": "report",
          "meta": postData,
          "message": "报告"
        });
        resolve();
      } catch (e) {
        console.log("report e", e);
      }
    });
  }
  /**
   * 获取心跳上报数据
   */
  getHeartReportData() {
    return {};
  }
  /**
   * 等待store 通知 callBackListener
   */
  async reportStop() {
    this.running = false;
    this.paused = false;
    this.callExecuteNotification();
    if (!this.conn) {
      return;
    }
    sendLog("Task stopped");
    this.conn.messageToReplyMQTT({
      "taskId": this.taskId,
      "executeId": this.executeId,
      "status": "completed",
      "meta": this.getStatus(),
      "message": "已停止"
    });
    storageUtil.removeListener(this.callBackListener);
    super.baseReportStop();
  }
  getStatus() {
    return {
      id: this.taskId,
      running: this.running,
      paused: this.paused,
      started: this.started,
      process: this.operationTime > 0 ? (this.runMinuteTime / this.operationTime * 100).toFixed(2) : 0,
      total_num: this.operationTime,
      executed_num: this.runMinuteTime
    };
  }
  getRunData() {
    if (this.taskPlatform === "抖音") {
      return {
        viewCount: this.dy_viewCount,
        commentCount: this.dy_CommentCount,
        likeCount: this.dy_likeCount,
        followCount: this.dy_followCount,
        collectCount: this.dy_collectCount,
        operationTime: this.operationTime,
        runMinuteTime: this.runMinuteTime
      };
    } else if (this.taskPlatform === "小红书") {
      return {
        likeCount: this.xhs_likeCount,
        followCount: this.xhs_followCount,
        commentCount: this.xhs_CommentCount,
        collectCount: this.xhs_collectCount,
        viewCount: this.xhs_viewCount,
        operationTime: this.operationTime,
        runMinuteTime: this.runMinuteTime
      };
    }
  }
  reportReply() {
    console.log("reportReply");
    if (!this.conn) {
      return;
    }
    this.conn.messageToReplyMQTT({
      "taskId": this.taskId,
      "executeId": this.executeId,
      "status": "running",
      "meta": this.getStatus(),
      "message": ""
    });
  }
  loadFromStorage() {
    if (this.startLoad) {
      console.log("startLoad", this.startLoad);
      return;
    }
    this.startLoad = true;
    chrome.storage.local.get(["taskPlatform", "XiaoHongShu_Setting", "xhs_viewCount", "xhs_CommentCount", "xhs_likeCount", "xhs_followCount", "xhs_collectCount", "dy_viewCount", "dy_CommentCount", "dy_likeCount", "dy_followCount", "dy_collectCount", "operationTime", "userId", "orgId", "clientVisitorId", "accessToken"], result => {
      console.log("result activatePage", result);
      if (!result) {
        return;
      }
      if (result.userId !== void 0) {
        this.user_id = result.userId;
      }
      if (result.orgId !== void 0) {
        this.orgId = result.orgId;
      }
      if (result.clientVisitorId !== void 0) {
        this.clientVisitorId = result.clientVisitorId;
      }
      if (result.accessToken !== void 0) {
        this.accessToken = result.accessToken;
      }
      if (result.taskPlatform !== void 0) {
        this.taskPlatform = result.taskPlatform;
      }
      if (result.XiaoHongShu_Setting !== void 0) {
        this.XiaoHongShu_Setting = result.XiaoHongShu_Setting ? JSON.parse(result.XiaoHongShu_Setting) : {};
      }
      if (result.xhs_viewCount !== void 0) {
        this.xhs_viewCount = result.xhs_viewCount;
      }
      if (result.xhs_CommentCount !== void 0) {
        this.xhs_CommentCount = result.xhs_CommentCount;
      }
      if (result.xhs_likeCount !== void 0) {
        this.xhs_likeCount = result.xhs_likeCount;
      }
      if (result.xhs_followCount !== void 0) {
        this.xhs_followCount = result.xhs_followCount;
      }
      if (result.xhs_collectCount !== void 0) {
        this.xhs_collectCount = result.xhs_collectCount;
      }
      if (result.dy_viewCount !== void 0) {
        this.dy_viewCount = result.dy_viewCount;
      }
      if (result.dy_CommentCount !== void 0) {
        this.dy_CommentCount = result.dy_CommentCount;
      }
      if (result.dy_likeCount !== void 0) {
        this.dy_likeCount = result.dy_likeCount;
      }
      if (result.dy_followCount !== void 0) {
        this.dy_followCount = result.dy_followCount;
      }
      if (result.dy_collectCount !== void 0) {
        this.dy_collectCount = result.dy_collectCount;
      }
      if (result.operationTime !== void 0) {
        this.operationTime = result.operationTime;
      }
      this.startLoad = true;
      this.loadend = true;
    });
    storageUtil.addHandlers(this.callBackListener);
  }
}
const VITE_CONTENT_API$5 = "https://agent-net.paitongai.net/content";
const VITE_AGENT_ID$2 = "dou-yin-chrome-extension";
const store$6 = UseCounterStore.getInstance();
class DouYinSearchVideoTask extends BaseTask {
  constructor(taskId, executeId, data, executeTask2) {
    super(taskId, executeId, data);
    __publicField(this, "executeTask");
    //评论数量
    __publicField(this, "xhs_viewCount");
    __publicField(this, "xhs_CommentCount");
    __publicField(this, "xhs_likeCount");
    __publicField(this, "xhs_followCount");
    __publicField(this, "xhs_collectCount");
    //评论数量
    __publicField(this, "dy_viewCount");
    __publicField(this, "dy_CommentCount");
    __publicField(this, "dy_likeCount");
    __publicField(this, "dy_followCount");
    __publicField(this, "dy_collectCount");
    __publicField(this, "taskPlatform");
    __publicField(this, "XiaoHongShu_Setting");
    __publicField(this, "operationTime");
    __publicField(this, "runMinuteTime");
    __publicField(this, "startLoad");
    __publicField(this, "loadend");
    // 上报数据
    __publicField(this, "executeOperationStartTime");
    __publicField(this, "executeOperationEndTime");
    __publicField(this, "xhs_keywords_list");
    __publicField(this, "douYin_keywords_list");
    __publicField(this, "xhs_minute");
    __publicField(this, "dy_minute");
    __publicField(this, "reportRunDataStatus", async () => {
      var _a;
      console.log("reportRunDataStatus");
      if (!this.conn) {
        return;
      }
      const runData = this.getRunData();
      console.log("runData", JSON.stringify(runData));
      this.conn.messageToStatusMQTT({
        "taskId": this.taskId,
        "data": runData,
        "userId": this.user_id,
        "terminalId": (_a = this.terminalData) == null ? void 0 : _a.terminalId
      });
    });
    __publicField(this, "reportRunData", async () => {
      var _a;
      const url = VITE_CONTENT_API$5 + "/api/content/";
      const headers = {
        "Content-Type": "application/json",
        ...this.addAuthorizationHeader()
        // Ensure this function works in the extension
      };
      try {
        console.log("reportRunData");
        const runData = this.getRunData();
        console.log("runData", JSON.stringify(runData));
        const postData = {
          "taskId": this.taskId,
          "data": runData,
          "userId": this.user_id,
          "terminalId": (_a = this.terminalData) == null ? void 0 : _a.terminalId
        };
        const response = await fetch(url, {
          method: "POST",
          headers,
          body: JSON.stringify(postData)
        });
        if (!response.ok) {
          console.log("url:" + url + "，header:" + JSON.stringify(headers) + ", response status:" + response.status);
          return;
        }
        const result = await response.json();
        console.log("url:" + url + "，header:" + JSON.stringify(headers) + ",postData：" + JSON.stringify(postData) + " response status:" + response.status + ", response data:" + JSON.stringify(result));
      } catch (error) {
        console.log("Error in putNewTask:", error);
        sendLog("url:" + url + "，header:" + JSON.stringify(headers) + ", error" + error);
      }
    });
    __publicField(this, "callBackListener", (changes, namespace) => {
      for (let [key, {
        oldValue,
        newValue
      }] of Object.entries(changes)) {
        console.log(`customizeTask Storage key "${key}" in namespace "${namespace}" changed.`, `Old value was "${oldValue}", new value is "${newValue}".`);
        switch (key) {
          case "runTaskStopped":
            if (newValue == "end") {
              this.reportStop().then(() => {});
            }
            break;
          case "taskPlatform":
            this.taskPlatform = newValue;
            break;
          case "XiaoHongShu_Setting":
            this.XiaoHongShu_Setting = newValue ? JSON.parse(newValue) : {};
            break;
          case "orgId":
            this.orgId = newValue;
            break;
          case "userId":
            this.user_id = newValue;
            break;
          case "clientVisitorId":
            this.clientVisitorId = newValue;
            break;
          case "accessToken":
            this.accessToken = newValue;
            break;
          case "operationTime":
            this.operationTime = newValue;
            break;
          case "runMinuteTime":
            this.runMinuteTime = newValue;
            this.reportReply();
            break;
          case "xhs_likeCount":
            this.xhs_likeCount = newValue;
            this.reportRunDataStatus().then();
            break;
          case "xhs_followCount":
            this.xhs_followCount = newValue;
            this.reportRunDataStatus().then();
            break;
          case "xhs_CommentCount":
            this.xhs_CommentCount = newValue;
            this.reportRunDataStatus().then();
            break;
          case "xhs_collectCount":
            this.xhs_collectCount = newValue;
            this.reportRunDataStatus().then();
            break;
          case "xhs_viewCount":
            this.xhs_viewCount = newValue;
            this.reportRunDataStatus().then();
            break;
          case "dy_likeCount":
            this.dy_likeCount = newValue;
            this.reportRunDataStatus().then();
            break;
          case "dy_followCount":
            this.dy_followCount = newValue;
            this.reportRunDataStatus().then();
            break;
          case "dy_CommentCount":
            this.dy_CommentCount = newValue;
            this.reportRunDataStatus().then();
            break;
          case "dy_collectCount":
            this.dy_collectCount = newValue;
            this.reportRunDataStatus().then();
            break;
          case "dy_viewCount":
            this.dy_viewCount = newValue;
            this.reportRunDataStatus().then();
            break;
          case "executeOperationStartTime":
            this.executeOperationStartTime = newValue;
            break;
          case "executeOperationEndTime":
            this.executeOperationEndTime = newValue;
            break;
          case "xhs_keywords_list":
            this.xhs_keywords_list = newValue ? JSON.parse(newValue) : [];
            break;
          case "douYin_keywords_list":
            this.douYin_keywords_list = newValue ? JSON.parse(newValue) : [];
            break;
          case "xhs_minute":
            this.xhs_minute = newValue ? JSON.parse(newValue) : [];
            break;
          case "dy_minute":
            this.dy_minute = newValue ? JSON.parse(newValue) : [];
            break;
        }
      }
    });
    this.startLoad = false;
    this.loadend = false;
    this.xhs_viewCount = 0;
    this.xhs_CommentCount = 0;
    this.xhs_likeCount = 0;
    this.xhs_followCount = 0;
    this.xhs_collectCount = 0;
    this.dy_viewCount = 0;
    this.dy_CommentCount = 0;
    this.dy_likeCount = 0;
    this.dy_followCount = 0;
    this.dy_collectCount = 0;
    this.operationTime = 0;
    this.runMinuteTime = 0;
    this.taskPlatform = "";
    this.XiaoHongShu_Setting = "";
    this.executeTask = executeTask2;
    this.executeOperationStartTime = 0;
    this.executeOperationEndTime = 0;
    this.xhs_keywords_list = [];
    this.douYin_keywords_list = [];
    this.xhs_minute = [];
    this.dy_minute = [];
    this.loadFromStorage();
  }
  /**
   * 检查配置是否正确
   */
  checkConfig() {
    return true;
  }
  startTask() {
    return new Promise(async resolve => {
      const validationError = this.validateParameters();
      if (!this.conn) {
        resolve();
        return;
      }
      if (validationError) {
        console.error(validationError.message);
        this.conn.messageToReplyMQTT({
          "taskId": this.taskId,
          "executeId": this.executeId,
          "status": "failed",
          "meta": {},
          "message": validationError.message
        });
        resolve();
        return;
      }
      console.log("Do a customize task!");
      await this.my_execute(this.data);
      this.conn.messageToReplyMQTT({
        "taskId": this.taskId,
        "executeId": this.executeId,
        "status": "running",
        "meta": this.getStatus(),
        "message": ""
      });
      resolve();
    });
  }
  validateParameters() {
    if (!this.data) {
      return {
        message: "参数未传递或格式不正确"
      };
    }
    return null;
  }
  async my_execute(config) {
    var _a;
    chrome.storage.local.set({
      "runTaskStopped": ""
    });
    chrome.storage.local.set({
      "mqttStart": "ok"
    });
    chrome.storage.local.set({
      "xhs_viewCount": 0
    });
    chrome.storage.local.set({
      "xhs_CommentCount": 0
    });
    chrome.storage.local.set({
      "xhs_likeCount": 0
    });
    chrome.storage.local.set({
      "xhs_followCount": 0
    });
    chrome.storage.local.set({
      "xhs_collectCount": 0
    });
    chrome.storage.local.set({
      "dy_viewCount": 0
    });
    chrome.storage.local.set({
      "dy_CommentCount": 0
    });
    chrome.storage.local.set({
      "dy_likeCount": 0
    });
    chrome.storage.local.set({
      "dy_followCount": 0
    });
    chrome.storage.local.set({
      "dy_collectCount": 0
    });
    chrome.storage.local.set({
      "activatePage": runPages[0]
    });
    chrome.storage.local.set({
      "operationTime": 0
    });
    chrome.storage.local.set({
      "xiaoHongShuAccountErrorTip": ""
    });
    chrome.storage.local.set({
      "xhs_keywords_list": JSON.stringify([])
    });
    chrome.storage.local.set({
      "douYin_keywords_list": JSON.stringify([])
    });
    chrome.storage.local.set({
      "xhs_minute": JSON.stringify([])
    });
    chrome.storage.local.set({
      "dy_minute": JSON.stringify([])
    });
    chrome.storage.local.set({
      "optionsPageName": ""
    });
    chrome.storage.local.set({
      "executeOperationStartTime": (/* @__PURE__ */new Date()).getTime()
    });
    chrome.storage.local.set({
      "XiaoHongShu_Setting": JSON.stringify(config)
    });
    chrome.storage.local.set({
      "searchVideoLimitCount": 0
    });
    chrome.storage.local.set({
      "DouYin_search_runNumber": 1
    });
    if (!this.XiaoHongShu_Setting) {
      this.XiaoHongShu_Setting = config;
    }
    if (config.workDouYinPlatform == "抖音") {
      if (!this.taskPlatform) {
        this.taskPlatform = config.workDouYinPlatform;
      }
      const saveTaskDataResult = await saveTaskData({
        task_options: {
          taskId: this.taskId,
          executeId: this.executeId,
          agentId: VITE_AGENT_ID$2,
          terminalId: (_a = store$6.terminalData) == null ? void 0 : _a.terminalId
        }
      });
      console.log("saveTaskDataResult", saveTaskDataResult);
      if (saveTaskDataResult && saveTaskDataResult.code == 0) {
        store$6.setQuestTaskId(saveTaskDataResult.data.id);
      }
      const saveInputs = {
        "key": store$6.userId + (/* @__PURE__ */new Date()).getTime(),
        "bucket": {
          taskType: config.workType,
          taskPlatform: config.workDouYinPlatform,
          taskId: this.taskId,
          searchWord: this.XiaoHongShu_Setting.searchWord,
          userId: store$6.userId,
          addDate: formatNowDateTime(),
          addTime: (/* @__PURE__ */new Date()).getTime()
        },
        "size": 0,
        "content_type": "string",
        "belong_to": store$6.userId + "_search_video_task_list",
        "object_metadata": {}
      };
      await addObjects(saveInputs);
      this.executeTask({
        action: "executeTask",
        url: "https://www.douyin.com",
        taskName: config.workType,
        taskPlatform: config.workDouYinPlatform,
        taskId: this.taskId
      }, {}, res => {
        if (res && res.tabId) {
          this.tabId = res.tabId;
        }
        if (res && res.windowId) {
          this.windowId = res.windowId;
        }
        console.log("executeTask res", res);
      });
    }
    if (config.workXiaoHongShuPlatform == "小红书") {
      this.executeTask({
        action: "executeTask",
        url: "https://www.xiaohongshu.com/explore",
        taskName: config.workType,
        taskPlatform: config.workXiaoHongShuPlatform,
        taskId: this.taskId
      }, {}, res => {
        if (res && res.tabId) {
          this.tabId = res.tabId;
        }
        if (res && res.windowId) {
          this.windowId = res.windowId;
        }
        console.log("executeTask res", res);
      });
      if (!this.taskPlatform) {
        this.taskPlatform = config.workXiaoHongShuPlatform;
      }
    }
  }
  stopTask() {
    return new Promise(resolve => {
      sendLog("douYinYangHaoZhuShouTask background activatePage ：", indexPage);
      chrome.storage.local.set({
        "activatePage": indexPage
      });
      resolve();
    });
  }
  abortTask() {
    return new Promise(resolve => {
      this.reportStop().then(() => {});
      resolve();
    });
  }
  report() {
    return new Promise(resolve => {
      console.log("report Promise");
      try {
        let formatTimestamp = function (timestamp) {
            const date = new Date(timestamp);
            const month = String(date.getMonth() + 1).padStart(2, "0");
            const day = String(date.getDate()).padStart(2, "0");
            const hours = String(date.getHours()).padStart(2, "0");
            const minutes = String(date.getMinutes()).padStart(2, "0");
            return `${month}-${day} ${hours}:${minutes}`;
          },
          calculateTimeDifference = function (startTimestamp, endTimestamp) {
            const differenceInMs = Math.abs(endTimestamp - startTimestamp);
            const totalMinutes = Math.floor(differenceInMs / (1e3 * 60));
            return `${totalMinutes}`;
          };
        if (!this.conn) {
          resolve();
          return;
        }
        const executeOperationStartTime = formatTimestamp(this.executeOperationStartTime);
        const executeOperationEndTime = formatTimestamp(this.executeOperationEndTime);
        const run_time = calculateTimeDifference(this.executeOperationStartTime, this.executeOperationEndTime);
        let xhs_keywords_list_str = "";
        if (this.xhs_keywords_list.length > 0) {
          xhs_keywords_list_str = this.xhs_keywords_list.join("，");
        }
        let douYin_keywords_list_str = "";
        if (this.douYin_keywords_list.length > 0) {
          douYin_keywords_list_str = this.douYin_keywords_list.join("，");
        }
        let XiaoHongShu_Setting = this.XiaoHongShu_Setting;
        let workRunPlatform = "";
        if (XiaoHongShu_Setting.workDouYinPlatform) {
          if (!workRunPlatform) {
            workRunPlatform = XiaoHongShu_Setting.workDouYinPlatform;
          } else {
            workRunPlatform += "+" + XiaoHongShu_Setting.workDouYinPlatform;
          }
        }
        if (XiaoHongShu_Setting.workXiaoHongShuPlatform) {
          if (!workRunPlatform) {
            workRunPlatform = XiaoHongShu_Setting.workXiaoHongShuPlatform;
          } else {
            workRunPlatform += "+" + XiaoHongShu_Setting.workXiaoHongShuPlatform;
          }
        }
        const uniqueMinutes = [... /* @__PURE__ */new Set([...this.xhs_minute.map(item => item.minute), ...this.dy_minute.map(item => item.minute)])].sort((a, b) => a - b);
        const xhsNums = uniqueMinutes.map(minute => {
          var _a;
          return ((_a = this.xhs_minute.find(item => item.minute === minute)) == null ? void 0 : _a.num) || 0;
        });
        const xhsPieNumber = [{
          value: store$6.xhs_likeCount,
          name: "点赞"
        }, {
          value: store$6.xhs_CommentCount,
          name: "评论"
        }, {
          value: store$6.xhs_followCount,
          name: "关注"
        }, {
          value: store$6.xhs_collectCount,
          name: "收藏"
        }];
        const dyPieNumber = [{
          value: store$6.dy_likeCount,
          name: "点赞"
        }, {
          value: store$6.dy_CommentCount,
          name: "评论"
        }, {
          value: store$6.dy_followCount,
          name: "关注"
        }, {
          value: store$6.dy_collectCount,
          name: "收藏"
        }];
        const allPieNumber = [{
          value: store$6.xhs_likeCount + store$6.dy_likeCount,
          name: "点赞"
        }, {
          value: store$6.xhs_CommentCount + store$6.dy_CommentCount,
          name: "评论"
        }, {
          value: store$6.xhs_followCount + store$6.dy_followCount,
          name: "关注"
        }, {
          value: store$6.xhs_collectCount + store$6.dy_collectCount,
          name: "收藏"
        }];
        const postData = {
          executeOperationStartTime,
          executeOperationEndTime,
          run_time,
          xhs_keywords_list_str,
          douYin_keywords_list_str,
          workRunPlatform,
          uniqueMinutes,
          xhsNums,
          xhsPieNumber,
          dyPieNumber,
          allPieNumber
        };
        console.log("messageToReportMQTT postData", JSON.stringify(postData));
        sendLog("Task stopped");
        this.conn.messageToReportMQTT({
          "taskId": this.taskId,
          "executeId": this.executeId,
          "status": "report",
          "meta": postData,
          "message": "报告"
        });
        resolve();
      } catch (e) {
        console.log("report e", e);
      }
    });
  }
  /**
   * 获取心跳上报数据
   */
  getHeartReportData() {
    return {};
  }
  /**
   * 等待store 通知 callBackListener
   */
  async reportStop() {
    this.running = false;
    this.paused = false;
    this.callExecuteNotification();
    if (!this.conn) {
      return;
    }
    sendLog("Task stopped");
    this.conn.messageToReplyMQTT({
      "taskId": this.taskId,
      "executeId": this.executeId,
      "status": "completed",
      "meta": this.getStatus(),
      "message": "已停止"
    });
    storageUtil.removeListener(this.callBackListener);
    super.baseReportStop();
  }
  getStatus() {
    return {
      id: this.taskId,
      running: this.running,
      paused: this.paused,
      started: this.started,
      process: this.operationTime > 0 ? (this.runMinuteTime / this.operationTime * 100).toFixed(2) : 0,
      total_num: this.operationTime,
      executed_num: this.runMinuteTime
    };
  }
  getRunData() {
    if (this.taskPlatform === "抖音") {
      return {
        viewCount: this.dy_viewCount,
        commentCount: this.dy_CommentCount,
        likeCount: this.dy_likeCount,
        followCount: this.dy_followCount,
        collectCount: this.dy_collectCount,
        operationTime: this.operationTime,
        runMinuteTime: this.runMinuteTime
      };
    } else if (this.taskPlatform === "小红书") {
      return {
        likeCount: this.xhs_likeCount,
        followCount: this.xhs_followCount,
        commentCount: this.xhs_CommentCount,
        collectCount: this.xhs_collectCount,
        viewCount: this.xhs_viewCount,
        operationTime: this.operationTime,
        runMinuteTime: this.runMinuteTime
      };
    }
  }
  reportReply() {
    console.log("reportReply");
    if (!this.conn) {
      return;
    }
    this.conn.messageToReplyMQTT({
      "taskId": this.taskId,
      "executeId": this.executeId,
      "status": "running",
      "meta": this.getStatus(),
      "message": ""
    });
  }
  loadFromStorage() {
    if (this.startLoad) {
      console.log("startLoad", this.startLoad);
      return;
    }
    this.startLoad = true;
    chrome.storage.local.get(["taskPlatform", "XiaoHongShu_Setting", "xhs_viewCount", "xhs_CommentCount", "xhs_likeCount", "xhs_followCount", "xhs_collectCount", "dy_viewCount", "dy_CommentCount", "dy_likeCount", "dy_followCount", "dy_collectCount", "operationTime", "userId", "orgId", "clientVisitorId", "accessToken"], result => {
      console.log("result activatePage", result);
      if (!result) {
        return;
      }
      if (result.userId !== void 0) {
        this.user_id = result.userId;
      }
      if (result.orgId !== void 0) {
        this.orgId = result.orgId;
      }
      if (result.clientVisitorId !== void 0) {
        this.clientVisitorId = result.clientVisitorId;
      }
      if (result.accessToken !== void 0) {
        this.accessToken = result.accessToken;
      }
      if (result.taskPlatform !== void 0) {
        this.taskPlatform = result.taskPlatform;
      }
      if (result.XiaoHongShu_Setting !== void 0) {
        this.XiaoHongShu_Setting = result.XiaoHongShu_Setting ? JSON.parse(result.XiaoHongShu_Setting) : {};
      }
      if (result.xhs_viewCount !== void 0) {
        this.xhs_viewCount = result.xhs_viewCount;
      }
      if (result.xhs_CommentCount !== void 0) {
        this.xhs_CommentCount = result.xhs_CommentCount;
      }
      if (result.xhs_likeCount !== void 0) {
        this.xhs_likeCount = result.xhs_likeCount;
      }
      if (result.xhs_followCount !== void 0) {
        this.xhs_followCount = result.xhs_followCount;
      }
      if (result.xhs_collectCount !== void 0) {
        this.xhs_collectCount = result.xhs_collectCount;
      }
      if (result.dy_viewCount !== void 0) {
        this.dy_viewCount = result.dy_viewCount;
      }
      if (result.dy_CommentCount !== void 0) {
        this.dy_CommentCount = result.dy_CommentCount;
      }
      if (result.dy_likeCount !== void 0) {
        this.dy_likeCount = result.dy_likeCount;
      }
      if (result.dy_followCount !== void 0) {
        this.dy_followCount = result.dy_followCount;
      }
      if (result.dy_collectCount !== void 0) {
        this.dy_collectCount = result.dy_collectCount;
      }
      if (result.operationTime !== void 0) {
        this.operationTime = result.operationTime;
      }
      this.startLoad = true;
      this.loadend = true;
    });
    storageUtil.addHandlers(this.callBackListener);
  }
}
UseCounterStore.getInstance();
const VITE_CONTENT_API$4 = "https://agent-net.paitongai.net/content";
const VITE_PAYMENT_API = void 0;
const store$5 = UseCounterStore.getInstance();
class CustomizeKuaiShouPushTask extends BaseTask {
  constructor(taskId, executeId, data, executeTask2) {
    super(taskId, executeId, data);
    __publicField(this, "executeTask");
    //评论数量
    __publicField(this, "xhs_viewCount");
    __publicField(this, "xhs_CommentCount");
    __publicField(this, "xhs_likeCount");
    __publicField(this, "xhs_followCount");
    __publicField(this, "xhs_collectCount");
    //评论数量
    __publicField(this, "dy_viewCount");
    __publicField(this, "dy_CommentCount");
    __publicField(this, "dy_likeCount");
    __publicField(this, "dy_followCount");
    __publicField(this, "dy_collectCount");
    __publicField(this, "taskPlatform");
    __publicField(this, "XiaoHongShu_Setting");
    __publicField(this, "operationTime");
    __publicField(this, "runMinuteTime");
    __publicField(this, "startLoad");
    __publicField(this, "loadend");
    // 上报数据
    __publicField(this, "executeOperationStartTime");
    __publicField(this, "executeOperationEndTime");
    __publicField(this, "xhs_keywords_list");
    __publicField(this, "douYin_keywords_list");
    __publicField(this, "xhs_minute");
    __publicField(this, "dy_minute");
    __publicField(this, "videoLink");
    __publicField(this, "postItemUsage", async () => {
      const url = VITE_PAYMENT_API + "/item_usage?usage_type=publish";
      const headers = {
        accept: "application/json",
        ...this.addAuthorizationHeader()
      };
      try {
        const response = await fetch(url, {
          method: "POST",
          headers
        });
        if (!response.ok) {
          console.log("url:" + url + "，header:" + JSON.stringify(headers) + ", response status:" + response.status);
          return;
        }
        const result = await response.json();
        console.log("url:" + url + "，header:" + JSON.stringify(headers) + ",response status:" + response.status + ", response data:" + JSON.stringify(result));
      } catch (error) {
        console.error("请求失败:", error);
      }
    });
    // reportVideoLink(videoLink:string){
    //     console.log("reportVideoLink")
    //     if(!this.conn){
    //         return
    //     }
    //     const  status = this.getStatus();
    //     status.videoLink = videoLink; // 添加新属性
    //
    //     this.conn.messageToReplyMQTT({
    //         "taskId": this.taskId,
    //         "executeId": this.executeId,
    //         "status": "running",
    //         "meta": status,
    //         "message": ""
    //     });
    // }
    __publicField(this, "reportRunDataStatus", async () => {
      var _a;
      console.log("reportRunDataStatus");
      if (!this.conn) {
        return;
      }
      const runData = this.getRunData();
      console.log("runData", JSON.stringify(runData));
      this.conn.messageToStatusMQTT({
        "taskId": this.taskId,
        "data": runData,
        "userId": this.user_id,
        "terminalId": (_a = this.terminalData) == null ? void 0 : _a.terminalId
      });
    });
    __publicField(this, "reportRunData", async () => {
      var _a;
      const url = VITE_CONTENT_API$4 + "/api/content/";
      const headers = {
        "Content-Type": "application/json",
        ...this.addAuthorizationHeader()
        // Ensure this function works in the extension
      };
      try {
        console.log("reportRunData");
        const runData = this.getRunData();
        console.log("runData", JSON.stringify(runData));
        const postData = {
          "taskId": this.taskId,
          "data": runData,
          "userId": this.user_id,
          "terminalId": (_a = this.terminalData) == null ? void 0 : _a.terminalId
        };
        const response = await fetch(url, {
          method: "POST",
          headers,
          body: JSON.stringify(postData)
        });
        if (!response.ok) {
          console.log("url:" + url + "，header:" + JSON.stringify(headers) + ", response status:" + response.status);
          return;
        }
        const result = await response.json();
        console.log("url:" + url + "，header:" + JSON.stringify(headers) + ",postData：" + JSON.stringify(postData) + " response status:" + response.status + ", response data:" + JSON.stringify(result));
      } catch (error) {
        console.log("Error in putNewTask:", error);
        sendLog("url:" + url + "，header:" + JSON.stringify(headers) + ", error" + error);
      }
    });
    __publicField(this, "callBackListener", (changes, namespace) => {
      for (let [key, {
        oldValue,
        newValue
      }] of Object.entries(changes)) {
        console.log(`customizeTask Storage key "${key}" in namespace "${namespace}" changed.`, `Old value was "${oldValue}", new value is "${newValue}".`);
        switch (key) {
          case "runTaskStopped":
            if (newValue == "end") {
              this.reportStop().then(() => {});
            }
            break;
          case "taskPlatform":
            this.taskPlatform = newValue;
            break;
          case "XiaoHongShu_Setting":
            this.XiaoHongShu_Setting = newValue ? JSON.parse(newValue) : {};
            break;
          case "orgId":
            this.orgId = newValue;
            break;
          case "userId":
            this.user_id = newValue;
            break;
          case "clientVisitorId":
            this.clientVisitorId = newValue;
            break;
          case "accessToken":
            this.accessToken = newValue;
            break;
          case "operationTime":
            this.operationTime = newValue;
            break;
          case "runMinuteTime":
            this.runMinuteTime = newValue;
            this.reportReply();
            break;
          case "xhs_likeCount":
            this.xhs_likeCount = newValue;
            this.reportRunDataStatus().then();
            break;
          case "xhs_followCount":
            this.xhs_followCount = newValue;
            this.reportRunDataStatus().then();
            break;
          case "xhs_CommentCount":
            this.xhs_CommentCount = newValue;
            this.reportRunDataStatus().then();
            break;
          case "xhs_collectCount":
            this.xhs_collectCount = newValue;
            this.reportRunDataStatus().then();
            break;
          case "xhs_viewCount":
            this.xhs_viewCount = newValue;
            this.reportRunDataStatus().then();
            break;
          case "dy_likeCount":
            this.dy_likeCount = newValue;
            this.reportRunDataStatus().then();
            break;
          case "dy_followCount":
            this.dy_followCount = newValue;
            this.reportRunDataStatus().then();
            break;
          case "dy_CommentCount":
            this.dy_CommentCount = newValue;
            this.reportRunDataStatus().then();
            break;
          case "dy_collectCount":
            this.dy_collectCount = newValue;
            this.reportRunDataStatus().then();
            break;
          case "dy_viewCount":
            this.dy_viewCount = newValue;
            this.reportRunDataStatus().then();
            break;
          case "executeOperationStartTime":
            this.executeOperationStartTime = newValue;
            break;
          case "executeOperationEndTime":
            this.executeOperationEndTime = newValue;
            break;
          case "xhs_keywords_list":
            this.xhs_keywords_list = newValue ? JSON.parse(newValue) : [];
            break;
          case "douYin_keywords_list":
            this.douYin_keywords_list = newValue ? JSON.parse(newValue) : [];
            break;
          case "xhs_minute":
            this.xhs_minute = newValue ? JSON.parse(newValue) : [];
            break;
          case "dy_minute":
            this.dy_minute = newValue ? JSON.parse(newValue) : [];
            break;
          case "videoLink":
            this.videoLink = newValue;
            break;
        }
      }
    });
    this.startLoad = false;
    this.loadend = false;
    this.xhs_viewCount = 0;
    this.xhs_CommentCount = 0;
    this.xhs_likeCount = 0;
    this.xhs_followCount = 0;
    this.xhs_collectCount = 0;
    this.dy_viewCount = 0;
    this.dy_CommentCount = 0;
    this.dy_likeCount = 0;
    this.dy_followCount = 0;
    this.dy_collectCount = 0;
    this.operationTime = 0;
    this.runMinuteTime = 0;
    this.taskPlatform = "";
    this.XiaoHongShu_Setting = "";
    this.executeTask = executeTask2;
    this.executeOperationStartTime = 0;
    this.executeOperationEndTime = 0;
    this.xhs_keywords_list = [];
    this.douYin_keywords_list = [];
    this.xhs_minute = [];
    this.dy_minute = [];
    this.loadFromStorage();
  }
  /**
   * 检查配置是否正确
   */
  checkConfig() {
    return true;
  }
  startTask() {
    return new Promise(resolve => {
      const validationError = this.validateParameters();
      if (!this.conn) {
        return;
      }
      if (validationError) {
        console.error(validationError.message);
        this.conn.messageToReplyMQTT({
          "taskId": this.taskId,
          "executeId": this.executeId,
          "status": "failed",
          "meta": {},
          "message": validationError.message
        });
        return;
      }
      console.log("Do a customize task!");
      this.my_execute(this.data);
      this.conn.messageToReplyMQTT({
        "taskId": this.taskId,
        "executeId": this.executeId,
        "status": "running",
        "meta": this.getStatus(),
        "message": ""
      });
      resolve();
    });
  }
  validateParameters() {
    if (!this.data) {
      return {
        message: "参数未传递或格式不正确"
      };
    }
    return null;
  }
  my_execute(config) {
    chrome.storage.local.set({
      "runTaskStopped": ""
    });
    chrome.storage.local.set({
      "mqttStart": "ok"
    });
    chrome.storage.local.set({
      "xhs_viewCount": 0
    });
    chrome.storage.local.set({
      "xhs_CommentCount": 0
    });
    chrome.storage.local.set({
      "xhs_likeCount": 0
    });
    chrome.storage.local.set({
      "xhs_followCount": 0
    });
    chrome.storage.local.set({
      "xhs_collectCount": 0
    });
    chrome.storage.local.set({
      "dy_viewCount": 0
    });
    chrome.storage.local.set({
      "dy_CommentCount": 0
    });
    chrome.storage.local.set({
      "dy_likeCount": 0
    });
    chrome.storage.local.set({
      "dy_followCount": 0
    });
    chrome.storage.local.set({
      "dy_collectCount": 0
    });
    chrome.storage.local.set({
      "XiaoHongShu_search_runNumber": 1
    });
    chrome.storage.local.set({
      "activatePage": runPages[0]
    });
    chrome.storage.local.set({
      "operationTime": 0
    });
    chrome.storage.local.set({
      "xiaoHongShuAccountErrorTip": ""
    });
    chrome.storage.local.set({
      "xhs_keywords_list": JSON.stringify([])
    });
    chrome.storage.local.set({
      "douYin_keywords_list": JSON.stringify([])
    });
    chrome.storage.local.set({
      "xhs_minute": JSON.stringify([])
    });
    chrome.storage.local.set({
      "dy_minute": JSON.stringify([])
    });
    chrome.storage.local.set({
      "optionsPageName": ""
    });
    chrome.storage.local.set({
      "executeOperationStartTime": (/* @__PURE__ */new Date()).getTime()
    });
    chrome.storage.local.set({
      "XiaoHongShu_Setting": JSON.stringify(config)
    });
    if (!this.XiaoHongShu_Setting) {
      this.XiaoHongShu_Setting = config;
    }
    if (!this.taskPlatform) {
      this.taskPlatform = "快手";
    }
    let url = "https://cp.kuaishou.com/article/publish/video?tabType=2";
    if (config.contentType == "视频") {
      url = "https://cp.kuaishou.com/article/publish/video?tabType=1";
    }
    this.executeTask({
      action: "executeTask",
      url,
      taskName: config.taskName,
      taskPlatform: "快手",
      taskId: this.taskId
    }, {}, res => {
      if (res && res.tabId) {
        this.tabId = res.tabId;
      }
      if (res && res.windowId) {
        this.windowId = res.windowId;
      }
      console.log("executeTask res", res);
    });
  }
  stopTask() {
    return new Promise(resolve => {
      chrome.storage.local.set({
        "activatePage": indexPage
      });
      resolve();
    });
  }
  abortTask() {
    return new Promise(resolve => {
      this.reportStop().then(() => {});
      resolve();
    });
  }
  report() {
    return new Promise(resolve => {
      console.log("report Promise");
      try {
        let formatTimestamp = function (timestamp) {
            const date = new Date(timestamp);
            const month = String(date.getMonth() + 1).padStart(2, "0");
            const day = String(date.getDate()).padStart(2, "0");
            const hours = String(date.getHours()).padStart(2, "0");
            const minutes = String(date.getMinutes()).padStart(2, "0");
            return `${month}-${day} ${hours}:${minutes}`;
          },
          calculateTimeDifference = function (startTimestamp, endTimestamp) {
            const differenceInMs = Math.abs(endTimestamp - startTimestamp);
            const totalMinutes = Math.floor(differenceInMs / (1e3 * 60));
            return `${totalMinutes}`;
          };
        if (!this.conn) {
          resolve();
          return;
        }
        const executeOperationStartTime = formatTimestamp(this.executeOperationStartTime);
        const executeOperationEndTime = formatTimestamp(this.executeOperationEndTime);
        const run_time = calculateTimeDifference(this.executeOperationStartTime, this.executeOperationEndTime);
        let xhs_keywords_list_str = "";
        if (this.xhs_keywords_list.length > 0) {
          xhs_keywords_list_str = this.xhs_keywords_list.join("，");
        }
        let douYin_keywords_list_str = "";
        if (this.douYin_keywords_list.length > 0) {
          douYin_keywords_list_str = this.douYin_keywords_list.join("，");
        }
        let XiaoHongShu_Setting = this.XiaoHongShu_Setting;
        let workRunPlatform = "";
        if (XiaoHongShu_Setting.workDouYinPlatform) {
          if (!workRunPlatform) {
            workRunPlatform = XiaoHongShu_Setting.workDouYinPlatform;
          } else {
            workRunPlatform += "+" + XiaoHongShu_Setting.workDouYinPlatform;
          }
        }
        if (XiaoHongShu_Setting.workXiaoHongShuPlatform) {
          if (!workRunPlatform) {
            workRunPlatform = XiaoHongShu_Setting.workXiaoHongShuPlatform;
          } else {
            workRunPlatform += "+" + XiaoHongShu_Setting.workXiaoHongShuPlatform;
          }
        }
        const uniqueMinutes = [... /* @__PURE__ */new Set([...this.xhs_minute.map(item => item.minute), ...this.dy_minute.map(item => item.minute)])].sort((a, b) => a - b);
        const xhsNums = uniqueMinutes.map(minute => {
          var _a;
          return ((_a = this.xhs_minute.find(item => item.minute === minute)) == null ? void 0 : _a.num) || 0;
        });
        const xhsPieNumber = [{
          value: store$5.xhs_likeCount,
          name: "点赞"
        }, {
          value: store$5.xhs_CommentCount,
          name: "评论"
        }, {
          value: store$5.xhs_followCount,
          name: "关注"
        }, {
          value: store$5.xhs_collectCount,
          name: "收藏"
        }];
        const dyPieNumber = [{
          value: store$5.dy_likeCount,
          name: "点赞"
        }, {
          value: store$5.dy_CommentCount,
          name: "评论"
        }, {
          value: store$5.dy_followCount,
          name: "关注"
        }, {
          value: store$5.dy_collectCount,
          name: "收藏"
        }];
        const allPieNumber = [{
          value: store$5.xhs_likeCount + store$5.dy_likeCount,
          name: "点赞"
        }, {
          value: store$5.xhs_CommentCount + store$5.dy_CommentCount,
          name: "评论"
        }, {
          value: store$5.xhs_followCount + store$5.dy_followCount,
          name: "关注"
        }, {
          value: store$5.xhs_collectCount + store$5.dy_collectCount,
          name: "收藏"
        }];
        const postData = {
          executeOperationStartTime,
          executeOperationEndTime,
          run_time,
          xhs_keywords_list_str,
          douYin_keywords_list_str,
          workRunPlatform,
          uniqueMinutes,
          xhsNums,
          xhsPieNumber,
          dyPieNumber,
          allPieNumber
        };
        console.log("messageToReportMQTT postData", JSON.stringify(postData));
        sendLog("Task stopped");
        this.conn.messageToReportMQTT({
          "taskId": this.taskId,
          "executeId": this.executeId,
          "status": "report",
          "meta": postData,
          "message": "报告"
        });
        resolve();
      } catch (e) {
        console.log("report e", e);
      }
    });
  }
  /**
   * 等待store 通知 callBackListener
   */
  async reportStop() {
    this.running = false;
    this.paused = false;
    this.callExecuteNotification();
    if (!this.conn) {
      return;
    }
    sendLog("Task stopped");
    const status = this.getStatus();
    status.videoLink = this.videoLink;
    if (this.videoLink) {
      this.postItemUsage().then(r => {
        console.log(r);
      });
      this.conn.messageToReplyMQTT({
        "taskId": this.taskId,
        "executeId": this.executeId,
        "status": "completed",
        "meta": status,
        "message": "已停止"
      });
    } else {
      this.conn.messageToReplyMQTT({
        "taskId": this.taskId,
        "executeId": this.executeId,
        "status": "completed",
        "meta": {},
        "message": "停止发布"
      });
    }
    storageUtil.removeListener(this.callBackListener);
    super.baseReportStop();
  }
  getStatus() {
    return {
      id: this.taskId,
      running: this.running,
      paused: this.paused,
      started: this.started,
      process: this.operationTime > 0 ? (this.runMinuteTime / this.operationTime * 100).toFixed(2) : 0,
      total_num: this.operationTime,
      executed_num: this.runMinuteTime
    };
  }
  getRunData() {
    if (this.taskPlatform === "抖音") {
      return {
        viewCount: this.dy_viewCount,
        commentCount: this.dy_CommentCount,
        likeCount: this.dy_likeCount,
        followCount: this.dy_followCount,
        collectCount: this.dy_collectCount,
        operationTime: this.operationTime,
        runMinuteTime: this.runMinuteTime
      };
    } else if (this.taskPlatform === "小红书") {
      return {
        likeCount: this.xhs_likeCount,
        followCount: this.xhs_followCount,
        commentCount: this.xhs_CommentCount,
        collectCount: this.xhs_collectCount,
        viewCount: this.xhs_viewCount,
        operationTime: this.operationTime,
        runMinuteTime: this.runMinuteTime
      };
    }
  }
  reportReply() {
    console.log("reportReply");
    if (!this.conn) {
      return;
    }
    this.conn.messageToReplyMQTT({
      "taskId": this.taskId,
      "executeId": this.executeId,
      "status": "running",
      "meta": this.getStatus(),
      "message": ""
    });
  }
  loadFromStorage() {
    if (this.startLoad) {
      console.log("startLoad", this.startLoad);
      return;
    }
    this.startLoad = true;
    chrome.storage.local.get(["taskPlatform", "XiaoHongShu_Setting", "xhs_viewCount", "xhs_CommentCount", "xhs_likeCount", "xhs_followCount", "xhs_collectCount", "dy_viewCount", "dy_CommentCount", "dy_likeCount", "dy_followCount", "dy_collectCount", "operationTime", "userId", "orgId", "clientVisitorId", "accessToken"], result => {
      console.log("result activatePage", result);
      if (!result) {
        return;
      }
      if (result.userId !== void 0) {
        this.user_id = result.userId;
      }
      if (result.orgId !== void 0) {
        this.orgId = result.orgId;
      }
      if (result.clientVisitorId !== void 0) {
        this.clientVisitorId = result.clientVisitorId;
      }
      if (result.accessToken !== void 0) {
        this.accessToken = result.accessToken;
      }
      if (result.taskPlatform !== void 0) {
        this.taskPlatform = result.taskPlatform;
      }
      if (result.XiaoHongShu_Setting !== void 0) {
        this.XiaoHongShu_Setting = result.XiaoHongShu_Setting ? JSON.parse(result.XiaoHongShu_Setting) : {};
      }
      if (result.xhs_viewCount !== void 0) {
        this.xhs_viewCount = result.xhs_viewCount;
      }
      if (result.xhs_CommentCount !== void 0) {
        this.xhs_CommentCount = result.xhs_CommentCount;
      }
      if (result.xhs_likeCount !== void 0) {
        this.xhs_likeCount = result.xhs_likeCount;
      }
      if (result.xhs_followCount !== void 0) {
        this.xhs_followCount = result.xhs_followCount;
      }
      if (result.xhs_collectCount !== void 0) {
        this.xhs_collectCount = result.xhs_collectCount;
      }
      if (result.dy_viewCount !== void 0) {
        this.dy_viewCount = result.dy_viewCount;
      }
      if (result.dy_CommentCount !== void 0) {
        this.dy_CommentCount = result.dy_CommentCount;
      }
      if (result.dy_likeCount !== void 0) {
        this.dy_likeCount = result.dy_likeCount;
      }
      if (result.dy_followCount !== void 0) {
        this.dy_followCount = result.dy_followCount;
      }
      if (result.dy_collectCount !== void 0) {
        this.dy_collectCount = result.dy_collectCount;
      }
      if (result.operationTime !== void 0) {
        this.operationTime = result.operationTime;
      }
      this.startLoad = true;
      this.loadend = true;
    });
    storageUtil.addHandlers(this.callBackListener);
  }
  getHeartReportData() {}
}
const VITE_CONTENT_API$3 = "https://agent-net.paitongai.net/content";
const VITE_AGENT_ID$1 = "dou-yin-chrome-extension";
const store$4 = UseCounterStore.getInstance();
class KuaiShouYangHaoZhuShouTask extends BaseTask {
  constructor(taskId, executeId, data, executeTask2) {
    super(taskId, executeId, data);
    __publicField(this, "executeTask");
    //评论数量
    __publicField(this, "xhs_viewCount");
    __publicField(this, "xhs_CommentCount");
    __publicField(this, "xhs_likeCount");
    __publicField(this, "xhs_followCount");
    __publicField(this, "xhs_collectCount");
    //评论数量
    __publicField(this, "dy_viewCount");
    __publicField(this, "dy_CommentCount");
    __publicField(this, "dy_likeCount");
    __publicField(this, "dy_followCount");
    __publicField(this, "dy_collectCount");
    __publicField(this, "taskPlatform");
    __publicField(this, "XiaoHongShu_Setting");
    __publicField(this, "operationTime");
    __publicField(this, "runMinuteTime");
    __publicField(this, "startLoad");
    __publicField(this, "loadend");
    // 上报数据
    __publicField(this, "executeOperationStartTime");
    __publicField(this, "executeOperationEndTime");
    __publicField(this, "xhs_keywords_list");
    __publicField(this, "douYin_keywords_list");
    __publicField(this, "xhs_minute");
    __publicField(this, "dy_minute");
    __publicField(this, "reportRunDataStatus", async () => {
      var _a;
      console.log("reportRunDataStatus");
      if (!this.conn) {
        return;
      }
      const runData = this.getRunData();
      console.log("runData", JSON.stringify(runData));
      this.conn.messageToStatusMQTT({
        "taskId": this.taskId,
        "data": runData,
        "userId": this.user_id,
        "terminalId": (_a = this.terminalData) == null ? void 0 : _a.terminalId
      });
    });
    __publicField(this, "reportRunData", async () => {
      var _a;
      const url = VITE_CONTENT_API$3 + "/api/content/";
      const headers = {
        "Content-Type": "application/json",
        ...this.addAuthorizationHeader()
        // Ensure this function works in the extension
      };
      try {
        console.log("reportRunData");
        const runData = this.getRunData();
        console.log("runData", JSON.stringify(runData));
        const postData = {
          "taskId": this.taskId,
          "data": runData,
          "userId": this.user_id,
          "terminalId": (_a = this.terminalData) == null ? void 0 : _a.terminalId
        };
        const response = await fetch(url, {
          method: "POST",
          headers,
          body: JSON.stringify(postData)
        });
        if (!response.ok) {
          console.log("url:" + url + "，header:" + JSON.stringify(headers) + ", response status:" + response.status);
          return;
        }
        const result = await response.json();
        console.log("url:" + url + "，header:" + JSON.stringify(headers) + ",postData：" + JSON.stringify(postData) + " response status:" + response.status + ", response data:" + JSON.stringify(result));
      } catch (error) {
        console.log("Error in putNewTask:", error);
        sendLog("url:" + url + "，header:" + JSON.stringify(headers) + ", error" + error);
      }
    });
    __publicField(this, "callBackListener", (changes, namespace) => {
      for (let [key, {
        oldValue,
        newValue
      }] of Object.entries(changes)) {
        console.log(`customizeTask Storage key "${key}" in namespace "${namespace}" changed.`, `Old value was "${oldValue}", new value is "${newValue}".`);
        switch (key) {
          case "runTaskStopped":
            if (newValue == "end") {
              this.reportStop().then(() => {});
            }
            break;
          case "taskPlatform":
            this.taskPlatform = newValue;
            break;
          case "XiaoHongShu_Setting":
            this.XiaoHongShu_Setting = newValue ? JSON.parse(newValue) : {};
            break;
          case "orgId":
            this.orgId = newValue;
            break;
          case "userId":
            this.user_id = newValue;
            break;
          case "clientVisitorId":
            this.clientVisitorId = newValue;
            break;
          case "accessToken":
            this.accessToken = newValue;
            break;
          case "operationTime":
            this.operationTime = newValue;
            break;
          case "runMinuteTime":
            this.runMinuteTime = newValue;
            this.reportReply();
            break;
          case "xhs_likeCount":
            this.xhs_likeCount = newValue;
            this.reportRunDataStatus().then();
            break;
          case "xhs_followCount":
            this.xhs_followCount = newValue;
            this.reportRunDataStatus().then();
            break;
          case "xhs_CommentCount":
            this.xhs_CommentCount = newValue;
            this.reportRunDataStatus().then();
            break;
          case "xhs_collectCount":
            this.xhs_collectCount = newValue;
            this.reportRunDataStatus().then();
            break;
          case "xhs_viewCount":
            this.xhs_viewCount = newValue;
            this.reportRunDataStatus().then();
            break;
          case "dy_likeCount":
            this.dy_likeCount = newValue;
            this.reportRunDataStatus().then();
            break;
          case "dy_followCount":
            this.dy_followCount = newValue;
            this.reportRunDataStatus().then();
            break;
          case "dy_CommentCount":
            this.dy_CommentCount = newValue;
            this.reportRunDataStatus().then();
            break;
          case "dy_collectCount":
            this.dy_collectCount = newValue;
            this.reportRunDataStatus().then();
            break;
          case "dy_viewCount":
            this.dy_viewCount = newValue;
            this.reportRunDataStatus().then();
            break;
          case "executeOperationStartTime":
            this.executeOperationStartTime = newValue;
            break;
          case "executeOperationEndTime":
            this.executeOperationEndTime = newValue;
            break;
          case "xhs_keywords_list":
            this.xhs_keywords_list = newValue ? JSON.parse(newValue) : [];
            break;
          case "douYin_keywords_list":
            this.douYin_keywords_list = newValue ? JSON.parse(newValue) : [];
            break;
          case "xhs_minute":
            this.xhs_minute = newValue ? JSON.parse(newValue) : [];
            break;
          case "dy_minute":
            this.dy_minute = newValue ? JSON.parse(newValue) : [];
            break;
        }
      }
    });
    this.startLoad = false;
    this.loadend = false;
    this.xhs_viewCount = 0;
    this.xhs_CommentCount = 0;
    this.xhs_likeCount = 0;
    this.xhs_followCount = 0;
    this.xhs_collectCount = 0;
    this.dy_viewCount = 0;
    this.dy_CommentCount = 0;
    this.dy_likeCount = 0;
    this.dy_followCount = 0;
    this.dy_collectCount = 0;
    this.operationTime = 0;
    this.runMinuteTime = 0;
    this.taskPlatform = "";
    this.XiaoHongShu_Setting = "";
    this.executeTask = executeTask2;
    this.executeOperationStartTime = 0;
    this.executeOperationEndTime = 0;
    this.xhs_keywords_list = [];
    this.douYin_keywords_list = [];
    this.xhs_minute = [];
    this.dy_minute = [];
    this.loadFromStorage();
  }
  /**
   * 检查配置是否正确
   */
  checkConfig() {
    return true;
  }
  startTask() {
    return new Promise(async resolve => {
      const validationError = this.validateParameters();
      if (!this.conn) {
        resolve();
        return;
      }
      if (validationError) {
        console.error(validationError.message);
        this.conn.messageToReplyMQTT({
          "taskId": this.taskId,
          "executeId": this.executeId,
          "status": "failed",
          "meta": {},
          "message": validationError.message
        });
        resolve();
        return;
      }
      console.log("Do a customize task!");
      await this.my_execute(this.data);
      this.conn.messageToReplyMQTT({
        "taskId": this.taskId,
        "executeId": this.executeId,
        "status": "running",
        "meta": this.getStatus(),
        "message": ""
      });
      resolve();
    });
  }
  validateParameters() {
    if (!this.data) {
      return {
        message: "参数未传递或格式不正确"
      };
    }
    return null;
  }
  async my_execute(config) {
    var _a;
    chrome.storage.local.set({
      "runTaskStopped": ""
    });
    chrome.storage.local.set({
      "mqttStart": "ok"
    });
    chrome.storage.local.set({
      "xhs_viewCount": 0
    });
    chrome.storage.local.set({
      "xhs_CommentCount": 0
    });
    chrome.storage.local.set({
      "xhs_likeCount": 0
    });
    chrome.storage.local.set({
      "xhs_followCount": 0
    });
    chrome.storage.local.set({
      "xhs_collectCount": 0
    });
    chrome.storage.local.set({
      "dy_viewCount": 0
    });
    chrome.storage.local.set({
      "dy_CommentCount": 0
    });
    chrome.storage.local.set({
      "dy_likeCount": 0
    });
    chrome.storage.local.set({
      "dy_followCount": 0
    });
    chrome.storage.local.set({
      "dy_collectCount": 0
    });
    chrome.storage.local.set({
      "KuaiShou_search_runNumber": 1
    });
    chrome.storage.local.set({
      "activatePage": runPages[0]
    });
    chrome.storage.local.set({
      "operationTime": 0
    });
    chrome.storage.local.set({
      "xiaoHongShuAccountErrorTip": ""
    });
    chrome.storage.local.set({
      "xhs_keywords_list": JSON.stringify([])
    });
    chrome.storage.local.set({
      "douYin_keywords_list": JSON.stringify([])
    });
    chrome.storage.local.set({
      "xhs_minute": JSON.stringify([])
    });
    chrome.storage.local.set({
      "dy_minute": JSON.stringify([])
    });
    chrome.storage.local.set({
      "optionsPageName": ""
    });
    chrome.storage.local.set({
      "executeOperationStartTime": (/* @__PURE__ */new Date()).getTime()
    });
    chrome.storage.local.set({
      "XiaoHongShu_Setting": JSON.stringify(config)
    });
    if (!this.XiaoHongShu_Setting) {
      this.XiaoHongShu_Setting = config;
    }
    if (config.workDouYinPlatform == "抖音") {
      if (!this.taskPlatform) {
        this.taskPlatform = config.workDouYinPlatform;
      }
      const saveTaskDataResult = await saveTaskData({
        task_options: {
          taskId: this.taskId,
          executeId: this.executeId,
          agentId: VITE_AGENT_ID$1,
          terminalId: (_a = store$4.terminalData) == null ? void 0 : _a.terminalId
        }
      });
      console.log("saveTaskDataResult", saveTaskDataResult);
      if (saveTaskDataResult && saveTaskDataResult.code == 0) {
        store$4.setQuestTaskId(saveTaskDataResult.data.id);
      }
      this.executeTask({
        action: "executeTask",
        url: "https://www.douyin.com",
        taskName: config.workType,
        taskPlatform: config.workDouYinPlatform,
        taskId: this.taskId
      }, {}, res => {
        if (res && res.tabId) {
          this.tabId = res.tabId;
        }
        if (res && res.windowId) {
          this.windowId = res.windowId;
        }
        console.log("executeTask res", res);
      });
    }
    if (config.workXiaoHongShuPlatform == "小红书") {
      this.executeTask({
        action: "executeTask",
        url: "https://www.xiaohongshu.com/explore",
        taskName: config.workType,
        taskPlatform: config.workXiaoHongShuPlatform,
        taskId: this.taskId
      }, {}, res => {
        if (res && res.tabId) {
          this.tabId = res.tabId;
        }
        if (res && res.windowId) {
          this.windowId = res.windowId;
        }
        console.log("executeTask res", res);
      });
      if (!this.taskPlatform) {
        this.taskPlatform = config.workXiaoHongShuPlatform;
      }
    }
    if (config.workXiaoHongShuPlatform == "快手") {
      this.executeTask({
        action: "executeTask",
        url: config.workType === "关键词" ? `https://www.kuaishou.com/search/video?searchKey=${config.searchWord}` : "https://www.kuaishou.com/brilliant",
        taskName: config.workType,
        taskPlatform: config.workXiaoHongShuPlatform,
        taskId: this.taskId
      }, {}, res => {
        if (res && res.tabId) {
          this.tabId = res.tabId;
        }
        if (res && res.windowId) {
          this.windowId = res.windowId;
        }
        console.log("executeTask res", res);
      });
      if (!this.taskPlatform) {
        this.taskPlatform = config.workXiaoHongShuPlatform;
      }
    }
  }
  stopTask() {
    return new Promise(resolve => {
      sendLog("douYinYangHaoZhuShouTask background activatePage ：", indexPage);
      chrome.storage.local.set({
        "activatePage": indexPage
      });
      resolve();
    });
  }
  abortTask() {
    return new Promise(resolve => {
      this.reportStop().then(() => {});
      resolve();
    });
  }
  report() {
    return new Promise(resolve => {
      console.log("report Promise");
      try {
        let formatTimestamp = function (timestamp) {
            const date = new Date(timestamp);
            const month = String(date.getMonth() + 1).padStart(2, "0");
            const day = String(date.getDate()).padStart(2, "0");
            const hours = String(date.getHours()).padStart(2, "0");
            const minutes = String(date.getMinutes()).padStart(2, "0");
            return `${month}-${day} ${hours}:${minutes}`;
          },
          calculateTimeDifference = function (startTimestamp, endTimestamp) {
            const differenceInMs = Math.abs(endTimestamp - startTimestamp);
            const totalMinutes = Math.floor(differenceInMs / (1e3 * 60));
            return `${totalMinutes}`;
          };
        if (!this.conn) {
          resolve();
          return;
        }
        const executeOperationStartTime = formatTimestamp(this.executeOperationStartTime);
        const executeOperationEndTime = formatTimestamp(this.executeOperationEndTime);
        const run_time = calculateTimeDifference(this.executeOperationStartTime, this.executeOperationEndTime);
        let xhs_keywords_list_str = "";
        if (this.xhs_keywords_list.length > 0) {
          xhs_keywords_list_str = this.xhs_keywords_list.join("，");
        }
        let douYin_keywords_list_str = "";
        if (this.douYin_keywords_list.length > 0) {
          douYin_keywords_list_str = this.douYin_keywords_list.join("，");
        }
        let XiaoHongShu_Setting = this.XiaoHongShu_Setting;
        let workRunPlatform = "";
        if (XiaoHongShu_Setting.workDouYinPlatform) {
          if (!workRunPlatform) {
            workRunPlatform = XiaoHongShu_Setting.workDouYinPlatform;
          } else {
            workRunPlatform += "+" + XiaoHongShu_Setting.workDouYinPlatform;
          }
        }
        if (XiaoHongShu_Setting.workXiaoHongShuPlatform) {
          if (!workRunPlatform) {
            workRunPlatform = XiaoHongShu_Setting.workXiaoHongShuPlatform;
          } else {
            workRunPlatform += "+" + XiaoHongShu_Setting.workXiaoHongShuPlatform;
          }
        }
        const uniqueMinutes = [... /* @__PURE__ */new Set([...this.xhs_minute.map(item => item.minute), ...this.dy_minute.map(item => item.minute)])].sort((a, b) => a - b);
        const xhsNums = uniqueMinutes.map(minute => {
          var _a;
          return ((_a = this.xhs_minute.find(item => item.minute === minute)) == null ? void 0 : _a.num) || 0;
        });
        const xhsPieNumber = [{
          value: store$4.xhs_likeCount,
          name: "点赞"
        }, {
          value: store$4.xhs_CommentCount,
          name: "评论"
        }, {
          value: store$4.xhs_followCount,
          name: "关注"
        }, {
          value: store$4.xhs_collectCount,
          name: "收藏"
        }];
        const dyPieNumber = [{
          value: store$4.dy_likeCount,
          name: "点赞"
        }, {
          value: store$4.dy_CommentCount,
          name: "评论"
        }, {
          value: store$4.dy_followCount,
          name: "关注"
        }, {
          value: store$4.dy_collectCount,
          name: "收藏"
        }];
        const allPieNumber = [{
          value: store$4.xhs_likeCount + store$4.dy_likeCount,
          name: "点赞"
        }, {
          value: store$4.xhs_CommentCount + store$4.dy_CommentCount,
          name: "评论"
        }, {
          value: store$4.xhs_followCount + store$4.dy_followCount,
          name: "关注"
        }, {
          value: store$4.xhs_collectCount + store$4.dy_collectCount,
          name: "收藏"
        }];
        const postData = {
          executeOperationStartTime,
          executeOperationEndTime,
          run_time,
          xhs_keywords_list_str,
          douYin_keywords_list_str,
          workRunPlatform,
          uniqueMinutes,
          xhsNums,
          xhsPieNumber,
          dyPieNumber,
          allPieNumber
        };
        console.log("messageToReportMQTT postData", JSON.stringify(postData));
        sendLog("Task stopped");
        this.conn.messageToReportMQTT({
          "taskId": this.taskId,
          "executeId": this.executeId,
          "status": "report",
          "meta": postData,
          "message": "报告"
        });
        resolve();
      } catch (e) {
        console.log("report e", e);
      }
    });
  }
  /**
   * 获取心跳上报数据
   */
  getHeartReportData() {
    return {};
  }
  /**
   * 等待store 通知 callBackListener
   */
  async reportStop() {
    this.running = false;
    this.paused = false;
    this.callExecuteNotification();
    if (!this.conn) {
      return;
    }
    sendLog("Task stopped");
    this.conn.messageToReplyMQTT({
      "taskId": this.taskId,
      "executeId": this.executeId,
      "status": "completed",
      "meta": this.getStatus(),
      "message": "已停止"
    });
    storageUtil.removeListener(this.callBackListener);
    super.baseReportStop();
  }
  getStatus() {
    return {
      id: this.taskId,
      running: this.running,
      paused: this.paused,
      started: this.started,
      process: this.operationTime > 0 ? (this.runMinuteTime / this.operationTime * 100).toFixed(2) : 0,
      total_num: this.operationTime,
      executed_num: this.runMinuteTime
    };
  }
  getRunData() {
    if (this.taskPlatform === "抖音") {
      return {
        viewCount: this.dy_viewCount,
        commentCount: this.dy_CommentCount,
        likeCount: this.dy_likeCount,
        followCount: this.dy_followCount,
        collectCount: this.dy_collectCount,
        operationTime: this.operationTime,
        runMinuteTime: this.runMinuteTime
      };
    } else if (this.taskPlatform === "小红书") {
      return {
        likeCount: this.xhs_likeCount,
        followCount: this.xhs_followCount,
        commentCount: this.xhs_CommentCount,
        collectCount: this.xhs_collectCount,
        viewCount: this.xhs_viewCount,
        operationTime: this.operationTime,
        runMinuteTime: this.runMinuteTime
      };
    }
  }
  reportReply() {
    console.log("reportReply");
    if (!this.conn) {
      return;
    }
    this.conn.messageToReplyMQTT({
      "taskId": this.taskId,
      "executeId": this.executeId,
      "status": "running",
      "meta": this.getStatus(),
      "message": ""
    });
  }
  loadFromStorage() {
    if (this.startLoad) {
      console.log("startLoad", this.startLoad);
      return;
    }
    this.startLoad = true;
    chrome.storage.local.get(["taskPlatform", "XiaoHongShu_Setting", "xhs_viewCount", "xhs_CommentCount", "xhs_likeCount", "xhs_followCount", "xhs_collectCount", "dy_viewCount", "dy_CommentCount", "dy_likeCount", "dy_followCount", "dy_collectCount", "operationTime", "userId", "orgId", "clientVisitorId", "accessToken"], result => {
      console.log("result activatePage", result);
      if (!result) {
        return;
      }
      if (result.userId !== void 0) {
        this.user_id = result.userId;
      }
      if (result.orgId !== void 0) {
        this.orgId = result.orgId;
      }
      if (result.clientVisitorId !== void 0) {
        this.clientVisitorId = result.clientVisitorId;
      }
      if (result.accessToken !== void 0) {
        this.accessToken = result.accessToken;
      }
      if (result.taskPlatform !== void 0) {
        this.taskPlatform = result.taskPlatform;
      }
      if (result.XiaoHongShu_Setting !== void 0) {
        this.XiaoHongShu_Setting = result.XiaoHongShu_Setting ? JSON.parse(result.XiaoHongShu_Setting) : {};
      }
      if (result.xhs_viewCount !== void 0) {
        this.xhs_viewCount = result.xhs_viewCount;
      }
      if (result.xhs_CommentCount !== void 0) {
        this.xhs_CommentCount = result.xhs_CommentCount;
      }
      if (result.xhs_likeCount !== void 0) {
        this.xhs_likeCount = result.xhs_likeCount;
      }
      if (result.xhs_followCount !== void 0) {
        this.xhs_followCount = result.xhs_followCount;
      }
      if (result.xhs_collectCount !== void 0) {
        this.xhs_collectCount = result.xhs_collectCount;
      }
      if (result.dy_viewCount !== void 0) {
        this.dy_viewCount = result.dy_viewCount;
      }
      if (result.dy_CommentCount !== void 0) {
        this.dy_CommentCount = result.dy_CommentCount;
      }
      if (result.dy_likeCount !== void 0) {
        this.dy_likeCount = result.dy_likeCount;
      }
      if (result.dy_followCount !== void 0) {
        this.dy_followCount = result.dy_followCount;
      }
      if (result.dy_collectCount !== void 0) {
        this.dy_collectCount = result.dy_collectCount;
      }
      if (result.operationTime !== void 0) {
        this.operationTime = result.operationTime;
      }
      this.startLoad = true;
      this.loadend = true;
    });
    storageUtil.addHandlers(this.callBackListener);
  }
}
const store$3 = UseCounterStore.getInstance();
const VITE_CONTENT_API$2 = "https://agent-net.paitongai.net/content";
class ShipinhaoKeZiCustomizeTask extends BaseTask {
  constructor(taskId, executeId, data, executeTask2) {
    super(taskId, executeId, data);
    __publicField(this, "executeTask");
    //评论数量
    __publicField(this, "xhs_viewCount");
    __publicField(this, "xhs_CommentCount");
    __publicField(this, "xhs_likeCount");
    __publicField(this, "xhs_followCount");
    __publicField(this, "xhs_collectCount");
    //评论数量
    __publicField(this, "dy_viewCount");
    __publicField(this, "dy_CommentCount");
    __publicField(this, "dy_likeCount");
    __publicField(this, "dy_followCount");
    __publicField(this, "dy_collectCount");
    __publicField(this, "taskPlatform");
    __publicField(this, "XiaoHongShu_Setting");
    __publicField(this, "operationTime");
    __publicField(this, "runMinuteTime");
    __publicField(this, "startLoad");
    __publicField(this, "loadend");
    // 上报数据
    __publicField(this, "executeOperationStartTime");
    __publicField(this, "executeOperationEndTime");
    __publicField(this, "xhs_keywords_list");
    __publicField(this, "douYin_keywords_list");
    __publicField(this, "xhs_minute");
    __publicField(this, "dy_minute");
    __publicField(this, "contentText");
    __publicField(this, "replyComment");
    __publicField(this, "reportRunDataStatus", async () => {
      var _a;
      console.log("reportRunDataStatus");
      if (!this.conn) {
        return;
      }
      const runData = this.getRunData();
      console.log("runData", JSON.stringify(runData));
      this.conn.messageToStatusMQTT({
        "taskId": this.taskId,
        "data": runData,
        "userId": this.user_id,
        "terminalId": (_a = this.terminalData) == null ? void 0 : _a.terminalId
      });
    });
    __publicField(this, "reportRunData", async () => {
      var _a;
      const url = VITE_CONTENT_API$2 + "/api/content/";
      const headers = {
        "Content-Type": "application/json",
        ...this.addAuthorizationHeader()
        // Ensure this function works in the extension
      };
      try {
        console.log("reportRunData");
        const runData = this.getRunData();
        console.log("runData", JSON.stringify(runData));
        const postData = {
          "taskId": this.taskId,
          "data": runData,
          "userId": this.user_id,
          "terminalId": (_a = this.terminalData) == null ? void 0 : _a.terminalId
        };
        const response = await fetch(url, {
          method: "POST",
          headers,
          body: JSON.stringify(postData)
        });
        if (!response.ok) {
          console.log("url:" + url + "，header:" + JSON.stringify(headers) + ", response status:" + response.status);
          return;
        }
        const result = await response.json();
        console.log("url:" + url + "，header:" + JSON.stringify(headers) + ",postData：" + JSON.stringify(postData) + " response status:" + response.status + ", response data:" + JSON.stringify(result));
      } catch (error) {
        console.log("Error in putNewTask:", error);
        sendLog("url:" + url + "，header:" + JSON.stringify(headers) + ", error" + error);
      }
    });
    __publicField(this, "callBackListener", (changes, namespace) => {
      for (let [key, {
        oldValue,
        newValue
      }] of Object.entries(changes)) {
        console.log(`customizeTask Storage key "${key}" in namespace "${namespace}" changed.`, `Old value was "${oldValue}", new value is "${newValue}".`);
        switch (key) {
          case "runTaskStopped":
            if (newValue == "end") {
              this.reportStop().then(() => {});
            }
            break;
          case "taskPlatform":
            this.taskPlatform = newValue;
            break;
          case "XiaoHongShu_Setting":
            this.XiaoHongShu_Setting = newValue ? JSON.parse(newValue) : {};
            break;
          case "orgId":
            this.orgId = newValue;
            break;
          case "userId":
            this.user_id = newValue;
            break;
          case "clientVisitorId":
            this.clientVisitorId = newValue;
            break;
          case "accessToken":
            this.accessToken = newValue;
            break;
          case "operationTime":
            this.operationTime = newValue;
            break;
          case "runMinuteTime":
            this.runMinuteTime = newValue;
            this.reportReply();
            break;
          case "xhs_likeCount":
            this.xhs_likeCount = newValue;
            this.reportRunDataStatus().then();
            break;
          case "xhs_followCount":
            this.xhs_followCount = newValue;
            this.reportRunDataStatus().then();
            break;
          case "xhs_CommentCount":
            this.xhs_CommentCount = newValue;
            this.reportRunDataStatus().then();
            break;
          case "xhs_collectCount":
            this.xhs_collectCount = newValue;
            this.reportRunDataStatus().then();
            break;
          case "xhs_viewCount":
            this.xhs_viewCount = newValue;
            this.reportRunDataStatus().then();
            break;
          case "dy_likeCount":
            this.dy_likeCount = newValue;
            this.reportRunDataStatus().then();
            break;
          case "dy_followCount":
            this.dy_followCount = newValue;
            this.reportRunDataStatus().then();
            break;
          case "dy_CommentCount":
            this.dy_CommentCount = newValue;
            this.reportRunDataStatus().then();
            break;
          case "dy_collectCount":
            this.dy_collectCount = newValue;
            this.reportRunDataStatus().then();
            break;
          case "dy_viewCount":
            this.dy_viewCount = newValue;
            this.reportRunDataStatus().then();
            break;
          case "executeOperationStartTime":
            this.executeOperationStartTime = newValue;
            break;
          case "executeOperationEndTime":
            this.executeOperationEndTime = newValue;
            break;
          case "xhs_keywords_list":
            this.xhs_keywords_list = newValue ? JSON.parse(newValue) : [];
            break;
          case "douYin_keywords_list":
            this.douYin_keywords_list = newValue ? JSON.parse(newValue) : [];
            break;
          case "xhs_minute":
            this.xhs_minute = newValue ? JSON.parse(newValue) : [];
            break;
          case "dy_minute":
            this.dy_minute = newValue ? JSON.parse(newValue) : [];
            break;
          case "contentText":
            this.contentText = newValue;
            break;
          case "replyComment":
            this.replyComment = newValue;
            break;
        }
      }
    });
    this.startLoad = false;
    this.loadend = false;
    this.xhs_viewCount = 0;
    this.xhs_CommentCount = 0;
    this.xhs_likeCount = 0;
    this.xhs_followCount = 0;
    this.xhs_collectCount = 0;
    this.dy_viewCount = 0;
    this.dy_CommentCount = 0;
    this.dy_likeCount = 0;
    this.dy_followCount = 0;
    this.dy_collectCount = 0;
    this.operationTime = 0;
    this.runMinuteTime = 0;
    this.taskPlatform = "";
    this.XiaoHongShu_Setting = "";
    this.executeTask = executeTask2;
    this.executeOperationStartTime = 0;
    this.executeOperationEndTime = 0;
    this.xhs_keywords_list = [];
    this.douYin_keywords_list = [];
    this.xhs_minute = [];
    this.dy_minute = [];
    this.contentText = "";
    this.replyComment = "";
    this.loadFromStorage();
  }
  checkConfig() {
    const optionWhere = this.data;
    if (optionWhere.wordWhereNumEnd < 0) {
      console.error("【最大私信字数】不能小于0");
      this.reportFail("【最大私信字数】不能小于0");
      return false;
    }
    if (optionWhere.wordWhereNum > optionWhere.wordWhereNumEnd) {
      console.error("【最大私信字数】不能小于【最小私信字数】");
      this.reportFail("【最大私信字数】不能小于【最小私信字数】");
      return false;
    }
    if (optionWhere.runTimeEnd <= 0) {
      console.error("【最大运行时长】不能小于等于0");
      this.reportFail("【最大运行时长】不能小于等于0");
      return false;
    }
    if (optionWhere.runTimeStart > optionWhere.runTimeEnd) {
      console.error("【最大运行时长】不能小于【最小运行时长】");
      this.reportFail("【最大运行时长】不能小于【最小运行时长】");
      return false;
    }
    if (optionWhere.refreshFrequencyEnd <= 0) {
      console.error("【最大刷新频率】不能小于等于0");
      this.reportFail("【最大刷新频率】不能小于等于0");
      return false;
    }
    if (optionWhere.refreshFrequencyStart > optionWhere.refreshFrequencyEnd) {
      console.error("【最大刷新频率】不能小于【最小刷新频率】");
      this.reportFail("【最大刷新频率】不能小于【最小刷新频率】");
      return false;
    }
    if (!optionWhere.wordReplyContent && optionWhere.enableFirstReplyBool == true && !optionWhere.phoneNumberReplyContent && !optionWhere.phoneNumberReplyContent1 && !optionWhere.phoneNumberReplyContent3) {
      console.error("评论和私信的回复内容不能都为空");
      return false;
    }
    return true;
  }
  reportFail(errorMessage) {
    if (!this.conn) {
      return;
    }
    this.conn.messageToReplyMQTT({
      "taskId": this.taskId,
      "executeId": this.executeId,
      "status": "failed",
      "meta": {},
      "message": errorMessage
    });
  }
  startTask() {
    return new Promise(resolve => {
      const validationError = this.validateParameters();
      if (!this.conn) {
        return;
      }
      if (validationError) {
        console.error(validationError.message);
        this.conn.messageToReplyMQTT({
          "taskId": this.taskId,
          "executeId": this.executeId,
          "status": "failed",
          "meta": {},
          "message": validationError.message
        });
        return;
      }
      console.log("Do a customize task!");
      chrome.storage.local.set({
        "taskId": this.taskId
      });
      chrome.storage.local.set({
        "executeId": this.executeId
      });
      this.my_execute(this.data);
      this.conn.messageToReplyMQTT({
        "taskId": this.taskId,
        "executeId": this.executeId,
        "status": "running",
        "meta": this.getStatus(),
        "message": ""
      });
      resolve();
    });
  }
  validateParameters() {
    if (!this.data) {
      return {
        message: "参数未传递或格式不正确"
      };
    }
    return null;
  }
  // async addObjects(postData:any) {
  //     const baseURL = import.meta.env.VITE_APP_BASE_URL;
  //     const url = baseURL+"/api/v2/oss/objects"
  //     const headers = {
  //         'Content-Type': 'application/json',
  //         'Authorization':'Bearer '+store.accessToken
  //     };
  //     try {
  //         const response = await fetch(url, {
  //             method: 'POST',
  //             headers: headers,
  //             body: JSON.stringify(postData)
  //         });
  //
  //         if (!response.ok) {
  //             console.error("addObjects url:"+url+"，header:"+JSON.stringify(headers)+", response status:"+response.status)
  //             return undefined
  //         }
  //
  //         const result = await response.json();
  //         console.log("addObjects url:"+url+"，header:"+JSON.stringify(headers)+",postData："+JSON.stringify(postData)+" response status:"+response.status+", response data:"+JSON.stringify(result))
  //
  //         return result
  //     } catch (error) {
  //         console.error("addObjects url:"+url+"，header:"+JSON.stringify(headers)+", error"+error)
  //     }
  //     return undefined
  // }
  my_execute(config) {
    console.log("开始视频号客资任务");
    chrome.storage.local.set({
      "mqttStart": ""
    });
    chrome.storage.local.set({
      "runTaskStopped": ""
    });
    chrome.storage.local.set({
      "mqttStart": "ok"
    });
    chrome.storage.local.set({
      "xhs_viewCount": 0
    });
    chrome.storage.local.set({
      "xhs_CommentCount": 0
    });
    chrome.storage.local.set({
      "xhs_likeCount": 0
    });
    chrome.storage.local.set({
      "xhs_followCount": 0
    });
    chrome.storage.local.set({
      "xhs_collectCount": 0
    });
    chrome.storage.local.set({
      "dy_viewCount": 0
    });
    chrome.storage.local.set({
      "dy_CommentCount": 0
    });
    chrome.storage.local.set({
      "dy_likeCount": 0
    });
    chrome.storage.local.set({
      "dy_followCount": 0
    });
    chrome.storage.local.set({
      "dy_collectCount": 0
    });
    chrome.storage.local.set({
      "XiaoHongShu_search_runNumber": 1
    });
    chrome.storage.local.set({
      "activatePage": runPages[0]
    });
    chrome.storage.local.set({
      "operationTime": 0
    });
    chrome.storage.local.set({
      "xiaoHongShuAccountErrorTip": ""
    });
    chrome.storage.local.set({
      "xhs_keywords_list": JSON.stringify([])
    });
    chrome.storage.local.set({
      "douYin_keywords_list": JSON.stringify([])
    });
    chrome.storage.local.set({
      "xhs_minute": JSON.stringify([])
    });
    chrome.storage.local.set({
      "dy_minute": JSON.stringify([])
    });
    chrome.storage.local.set({
      "optionsPageName": ""
    });
    chrome.storage.local.set({
      "executeOperationStartTime": (/* @__PURE__ */new Date()).getTime()
    });
    chrome.storage.local.set({
      "XiaoHongShu_Setting": JSON.stringify({})
    });
    chrome.storage.local.set({
      "optionsPageName": ""
    });
    chrome.storage.local.set({
      "optionWhere": JSON.stringify(config)
    });
    chrome.storage.local.set({
      "runTimeMaxNum": config.runTimeEnd
    });
    chrome.storage.local.set({
      "runTimeNum": (/* @__PURE__ */new Date()).getTime()
    });
    chrome.storage.local.set({
      "formattedTime": ""
    });
    const key = store$3.userId + "_douYin_saveOptionsWhere";
    const postDataObj = {
      "key": key,
      "bucket": config,
      "size": 0,
      "content_type": "",
      "belong_to": store$3.userId + "_douYin_saveOptionsWhere",
      "object_metadata": {}
    };
    try {
      const res = addObjects(postDataObj);
      console.log("res保存的数据：", res);
    } catch (error) {
      console.log("error", error);
    }
    chrome.storage.local.set({
      "executeOperationStartTime": (/* @__PURE__ */new Date()).getTime()
    });
    this.executeTask({
      action: "executeTask",
      url: "https://channels.weixin.qq.com/platform/",
      taskId: this.taskId,
      taskName: "获取视频号通知",
      taskPlatform: "视频号"
    }, {}, res => {
      if (res && res.tabId) {
        this.tabId = res.tabId;
      }
      if (res && res.windowId) {
        this.windowId = res.windowId;
      }
      console.log("executeTask res", res);
    });
  }
  stopTask() {
    return new Promise(resolve => {
      chrome.storage.local.set({
        "activatePage": indexPage
      });
      resolve();
    });
  }
  abortTask() {
    return new Promise(resolve => {
      this.reportStop().then(() => {});
      resolve();
    });
  }
  report() {
    return new Promise(resolve => {
      console.log("report Promise");
      try {
        let formatTimestamp = function (timestamp) {
            const date = new Date(timestamp);
            const month = String(date.getMonth() + 1).padStart(2, "0");
            const day = String(date.getDate()).padStart(2, "0");
            const hours = String(date.getHours()).padStart(2, "0");
            const minutes = String(date.getMinutes()).padStart(2, "0");
            return `${month}-${day} ${hours}:${minutes}`;
          },
          calculateTimeDifference = function (startTimestamp, endTimestamp) {
            const differenceInMs = Math.abs(endTimestamp - startTimestamp);
            const totalMinutes = Math.floor(differenceInMs / (1e3 * 60));
            return `${totalMinutes}`;
          };
        if (!this.conn) {
          resolve();
          return;
        }
        const executeOperationStartTime = formatTimestamp(this.executeOperationStartTime);
        const executeOperationEndTime = formatTimestamp(this.executeOperationEndTime);
        const run_time = calculateTimeDifference(this.executeOperationStartTime, this.executeOperationEndTime);
        let xhs_keywords_list_str = "";
        if (this.xhs_keywords_list.length > 0) {
          xhs_keywords_list_str = this.xhs_keywords_list.join("，");
        }
        let douYin_keywords_list_str = "";
        if (this.douYin_keywords_list.length > 0) {
          douYin_keywords_list_str = this.douYin_keywords_list.join("，");
        }
        let XiaoHongShu_Setting = this.XiaoHongShu_Setting;
        let workRunPlatform = "";
        if (XiaoHongShu_Setting.workDouYinPlatform) {
          if (!workRunPlatform) {
            workRunPlatform = XiaoHongShu_Setting.workDouYinPlatform;
          } else {
            workRunPlatform += "+" + XiaoHongShu_Setting.workDouYinPlatform;
          }
        }
        if (XiaoHongShu_Setting.workXiaoHongShuPlatform) {
          if (!workRunPlatform) {
            workRunPlatform = XiaoHongShu_Setting.workXiaoHongShuPlatform;
          } else {
            workRunPlatform += "+" + XiaoHongShu_Setting.workXiaoHongShuPlatform;
          }
        }
        const uniqueMinutes = [... /* @__PURE__ */new Set([...this.xhs_minute.map(item => item.minute), ...this.dy_minute.map(item => item.minute)])].sort((a, b) => a - b);
        const xhsNums = uniqueMinutes.map(minute => {
          var _a;
          return ((_a = this.xhs_minute.find(item => item.minute === minute)) == null ? void 0 : _a.num) || 0;
        });
        const xhsPieNumber = [{
          value: store$3.xhs_likeCount,
          name: "点赞"
        }, {
          value: store$3.xhs_CommentCount,
          name: "评论"
        }, {
          value: store$3.xhs_followCount,
          name: "关注"
        }, {
          value: store$3.xhs_collectCount,
          name: "收藏"
        }];
        const dyPieNumber = [{
          value: store$3.dy_likeCount,
          name: "点赞"
        }, {
          value: store$3.dy_CommentCount,
          name: "评论"
        }, {
          value: store$3.dy_followCount,
          name: "关注"
        }, {
          value: store$3.dy_collectCount,
          name: "收藏"
        }];
        const allPieNumber = [{
          value: store$3.xhs_likeCount + store$3.dy_likeCount,
          name: "点赞"
        }, {
          value: store$3.xhs_CommentCount + store$3.dy_CommentCount,
          name: "评论"
        }, {
          value: store$3.xhs_followCount + store$3.dy_followCount,
          name: "关注"
        }, {
          value: store$3.xhs_collectCount + store$3.dy_collectCount,
          name: "收藏"
        }];
        const postData = {
          executeOperationStartTime,
          executeOperationEndTime,
          run_time,
          xhs_keywords_list_str,
          douYin_keywords_list_str,
          workRunPlatform,
          uniqueMinutes,
          xhsNums,
          xhsPieNumber,
          dyPieNumber,
          allPieNumber
        };
        console.log("messageToReportMQTT postData", JSON.stringify(postData));
        sendLog("Task stopped");
        this.conn.messageToReportMQTT({
          "taskId": this.taskId,
          "executeId": this.executeId,
          "status": "report",
          "meta": postData,
          "message": "报告"
        });
        resolve();
      } catch (e) {
        console.log("report e", e);
      }
    });
  }
  /**
   * 获取心跳上报数据
   *
   * {
   *             taskConfig:{
   *                 // 任务配置
   *                 config:{
   *                     enableFirstReplyBool: true,
   *                     keFuNullReplyContent: "兜底",
   *                     phoneNumberReplyContent: "2",
   *                     phoneNumberReplyContent1: "1",
   *                     phoneNumberReplyContent3: "3",
   *                     refreshFrequencyEnd: 2,
   *                     refreshFrequencyStart: 1,
   *                     runTimeEnd: 0.5,
   *                     runTimeStart: 0,
   *                     wordReplyContent: "请私信",
   *                     wordWhereNum: 1,
   *                     wordWhereNumEnd: 9999,
   *                 },
   *                 executeId: "1b3cea2b-a869-4e96-b5be-93a813f54427",
   *                 operation: "cmd",
   *                 taskId: "b8e94836-9da1-4394-b6ea-4a72d81a2bc4",
   *                 type: "DouYinKeZiTask"
   *             },
   *             runStatus:{
   *                 //运行页面状态
   *                 stopButtonText: "stop",
   *                 formattedTime:"",
   *             },
   *             replyComment:{
   *                 // 读取到，要回复的内容上报
   *                 contentText:"",
   *                 replyComment:"",
   *             },
   *             webLoginInfo:{
   *                 // 登录抖音账号的名称
   *                 webUserId:"",
   *                 webUserName:"",
   *                 webUserAvatarUrl:""
   *             }
   *             // 上报
   *             // 1；配置信息
   *             // 2、显示信息上报
   *             // 3、点击停止上报
   *             // 3、倒计时剩余上报
   *             // 4、读取到，要回复的内容上报
   *             // 5、登录抖音账号的名称
   *         }
   */
  getHeartReportData() {
    return {
      taskConfig: this.data,
      taskRunConfig: {
        executeId: this.executeId,
        taskId: this.taskId,
        type: "ShiPinHaoKeZiTask",
        operation: "cmd"
      },
      runStatus: {
        //运行页面状态
        runLogs: this.runLogs + "（" + this.formattedTime + "）",
        stopButtonText: this.stopButtonText,
        formattedTime: this.formattedTime
      },
      replyComment: {
        // 读取到，要回复的内容上报
        contentText: this.contentText,
        replyComment: this.replyComment
      }
      // 上报
      // 1；配置信息
      // 2、显示信息上报
      // 3、点击停止上报
      // 3、倒计时剩余上报
      // 4、读取到，要回复的内容上报
      // 5、登录抖音账号的名称
    };
  }
  /**
   * 等待store 通知 callBackListener
   */
  async reportStop() {
    this.running = false;
    this.paused = false;
    this.callExecuteNotification();
    storageUtil.removeListener(this.callBackListener);
    super.baseReportStop();
    if (!this.conn) {
      return;
    }
    sendLog("Task stopped");
    this.conn.messageToReplyMQTT({
      "taskId": this.taskId,
      "executeId": this.executeId,
      "status": "completed",
      "meta": this.getStatus(),
      "message": "已停止"
    });
    this.conn.setRunTaskInstance(null);
  }
  getStatus() {
    return {
      id: this.taskId,
      running: this.running,
      paused: this.paused,
      started: this.started,
      process: this.operationTime > 0 ? (this.runMinuteTime / this.operationTime * 100).toFixed(2) : 0,
      total_num: this.operationTime,
      executed_num: this.runMinuteTime
    };
  }
  getRunData() {
    if (this.taskPlatform === "抖音") {
      return {
        viewCount: this.dy_viewCount,
        commentCount: this.dy_CommentCount,
        likeCount: this.dy_likeCount,
        followCount: this.dy_followCount,
        collectCount: this.dy_collectCount,
        operationTime: this.operationTime,
        runMinuteTime: this.runMinuteTime
      };
    } else if (this.taskPlatform === "小红书") {
      return {
        likeCount: this.xhs_likeCount,
        followCount: this.xhs_followCount,
        commentCount: this.xhs_CommentCount,
        collectCount: this.xhs_collectCount,
        viewCount: this.xhs_viewCount,
        operationTime: this.operationTime,
        runMinuteTime: this.runMinuteTime
      };
    }
  }
  reportReply() {
    console.log("reportReply");
    if (!this.conn) {
      return;
    }
    this.conn.messageToReplyMQTT({
      "taskId": this.taskId,
      "executeId": this.executeId,
      "status": "running",
      "meta": this.getStatus(),
      "message": ""
    });
  }
  loadFromStorage() {
    if (this.startLoad) {
      console.log("startLoad", this.startLoad);
      return;
    }
    this.startLoad = true;
    chrome.storage.local.get(["taskPlatform", "XiaoHongShu_Setting", "xhs_viewCount", "xhs_CommentCount", "xhs_likeCount", "xhs_followCount", "xhs_collectCount", "dy_viewCount", "dy_CommentCount", "dy_likeCount", "dy_followCount", "dy_collectCount", "operationTime", "userId", "orgId", "clientVisitorId", "accessToken", "contentText", "replyComment"], result => {
      console.log("result activatePage", result);
      if (!result) {
        return;
      }
      if (result.userId !== void 0) {
        this.user_id = result.userId;
      }
      if (result.orgId !== void 0) {
        this.orgId = result.orgId;
      }
      if (result.clientVisitorId !== void 0) {
        this.clientVisitorId = result.clientVisitorId;
      }
      if (result.accessToken !== void 0) {
        this.accessToken = result.accessToken;
      }
      if (result.taskPlatform !== void 0) {
        this.taskPlatform = result.taskPlatform;
      }
      if (result.XiaoHongShu_Setting !== void 0) {
        this.XiaoHongShu_Setting = result.XiaoHongShu_Setting ? JSON.parse(result.XiaoHongShu_Setting) : {};
      }
      if (result.xhs_viewCount !== void 0) {
        this.xhs_viewCount = result.xhs_viewCount;
      }
      if (result.xhs_CommentCount !== void 0) {
        this.xhs_CommentCount = result.xhs_CommentCount;
      }
      if (result.xhs_likeCount !== void 0) {
        this.xhs_likeCount = result.xhs_likeCount;
      }
      if (result.xhs_followCount !== void 0) {
        this.xhs_followCount = result.xhs_followCount;
      }
      if (result.xhs_collectCount !== void 0) {
        this.xhs_collectCount = result.xhs_collectCount;
      }
      if (result.dy_viewCount !== void 0) {
        this.dy_viewCount = result.dy_viewCount;
      }
      if (result.dy_CommentCount !== void 0) {
        this.dy_CommentCount = result.dy_CommentCount;
      }
      if (result.dy_likeCount !== void 0) {
        this.dy_likeCount = result.dy_likeCount;
      }
      if (result.dy_followCount !== void 0) {
        this.dy_followCount = result.dy_followCount;
      }
      if (result.dy_collectCount !== void 0) {
        this.dy_collectCount = result.dy_collectCount;
      }
      if (result.operationTime !== void 0) {
        this.operationTime = result.operationTime;
      }
      if (result.contentText !== void 0) {
        this.contentText = result.contentText;
      }
      if (result.replyComment !== void 0) {
        this.replyComment = result.replyComment;
      }
      this.startLoad = true;
      this.loadend = true;
    });
    storageUtil.addHandlers(this.callBackListener);
  }
}
const store$2 = UseCounterStore.getInstance();
const VITE_CONTENT_API$1 = "https://agent-net.paitongai.net/content";
class XiaoHongShuAutoReplyTask extends BaseTask {
  constructor(taskId, executeId, data, executeTask2) {
    super(taskId, executeId, data);
    __publicField(this, "executeTask");
    //评论数量
    __publicField(this, "xhs_viewCount");
    __publicField(this, "xhs_CommentCount");
    __publicField(this, "xhs_likeCount");
    __publicField(this, "xhs_followCount");
    __publicField(this, "xhs_collectCount");
    //评论数量
    __publicField(this, "dy_viewCount");
    __publicField(this, "dy_CommentCount");
    __publicField(this, "dy_likeCount");
    __publicField(this, "dy_followCount");
    __publicField(this, "dy_collectCount");
    __publicField(this, "taskPlatform");
    __publicField(this, "XiaoHongShu_Setting");
    __publicField(this, "operationTime");
    __publicField(this, "runMinuteTime");
    __publicField(this, "startLoad");
    __publicField(this, "loadend");
    // 上报数据
    __publicField(this, "executeOperationStartTime");
    __publicField(this, "executeOperationEndTime");
    __publicField(this, "xhs_keywords_list");
    __publicField(this, "douYin_keywords_list");
    __publicField(this, "xhs_minute");
    __publicField(this, "dy_minute");
    __publicField(this, "reportRunDataStatus", async () => {
      var _a;
      console.log("reportRunDataStatus");
      if (!this.conn) {
        return;
      }
      const runData = this.getRunData();
      console.log("runData", JSON.stringify(runData));
      this.conn.messageToStatusMQTT({
        "taskId": this.taskId,
        "data": runData,
        "userId": this.user_id,
        "terminalId": (_a = this.terminalData) == null ? void 0 : _a.terminalId
      });
    });
    __publicField(this, "reportRunData", async () => {
      var _a;
      const url = VITE_CONTENT_API$1 + "/api/content/";
      const headers = {
        "Content-Type": "application/json",
        ...this.addAuthorizationHeader()
        // Ensure this function works in the extension
      };
      try {
        console.log("reportRunData");
        const runData = this.getRunData();
        console.log("runData", JSON.stringify(runData));
        const postData = {
          "taskId": this.taskId,
          "data": runData,
          "userId": this.user_id,
          "terminalId": (_a = this.terminalData) == null ? void 0 : _a.terminalId
        };
        const response = await fetch(url, {
          method: "POST",
          headers,
          body: JSON.stringify(postData)
        });
        if (!response.ok) {
          console.log("url:" + url + "，header:" + JSON.stringify(headers) + ", response status:" + response.status);
          return;
        }
        const result = await response.json();
        console.log("url:" + url + "，header:" + JSON.stringify(headers) + ",postData：" + JSON.stringify(postData) + " response status:" + response.status + ", response data:" + JSON.stringify(result));
      } catch (error) {
        console.log("Error in putNewTask:", error);
        sendLog("url:" + url + "，header:" + JSON.stringify(headers) + ", error" + error);
      }
    });
    __publicField(this, "callBackListener", (changes, namespace) => {
      for (let [key, {
        oldValue,
        newValue
      }] of Object.entries(changes)) {
        console.log(`customizeTask Storage key "${key}" in namespace "${namespace}" changed.`, `Old value was "${oldValue}", new value is "${newValue}".`);
        switch (key) {
          case "runTaskStopped":
            if (newValue == "end") {
              this.reportStop().then(() => {});
            }
            break;
          case "taskPlatform":
            this.taskPlatform = newValue;
            break;
          case "XiaoHongShu_Setting":
            this.XiaoHongShu_Setting = newValue ? JSON.parse(newValue) : {};
            break;
          case "orgId":
            this.orgId = newValue;
            break;
          case "userId":
            this.user_id = newValue;
            break;
          case "clientVisitorId":
            this.clientVisitorId = newValue;
            break;
          case "accessToken":
            this.accessToken = newValue;
            break;
          case "operationTime":
            this.operationTime = newValue;
            break;
          case "runMinuteTime":
            this.runMinuteTime = newValue;
            this.reportReply();
            break;
          case "xhs_likeCount":
            this.xhs_likeCount = newValue;
            this.reportRunDataStatus().then();
            break;
          case "xhs_followCount":
            this.xhs_followCount = newValue;
            this.reportRunDataStatus().then();
            break;
          case "xhs_CommentCount":
            this.xhs_CommentCount = newValue;
            this.reportRunDataStatus().then();
            break;
          case "xhs_collectCount":
            this.xhs_collectCount = newValue;
            this.reportRunDataStatus().then();
            break;
          case "xhs_viewCount":
            this.xhs_viewCount = newValue;
            this.reportRunDataStatus().then();
            break;
          case "dy_likeCount":
            this.dy_likeCount = newValue;
            this.reportRunDataStatus().then();
            break;
          case "dy_followCount":
            this.dy_followCount = newValue;
            this.reportRunDataStatus().then();
            break;
          case "dy_CommentCount":
            this.dy_CommentCount = newValue;
            this.reportRunDataStatus().then();
            break;
          case "dy_collectCount":
            this.dy_collectCount = newValue;
            this.reportRunDataStatus().then();
            break;
          case "dy_viewCount":
            this.dy_viewCount = newValue;
            this.reportRunDataStatus().then();
            break;
          case "executeOperationStartTime":
            this.executeOperationStartTime = newValue;
            break;
          case "executeOperationEndTime":
            this.executeOperationEndTime = newValue;
            break;
          case "xhs_keywords_list":
            this.xhs_keywords_list = newValue ? JSON.parse(newValue) : [];
            break;
          case "douYin_keywords_list":
            this.douYin_keywords_list = newValue ? JSON.parse(newValue) : [];
            break;
          case "xhs_minute":
            this.xhs_minute = newValue ? JSON.parse(newValue) : [];
            break;
          case "dy_minute":
            this.dy_minute = newValue ? JSON.parse(newValue) : [];
            break;
        }
      }
    });
    this.startLoad = false;
    this.loadend = false;
    this.xhs_viewCount = 0;
    this.xhs_CommentCount = 0;
    this.xhs_likeCount = 0;
    this.xhs_followCount = 0;
    this.xhs_collectCount = 0;
    this.dy_viewCount = 0;
    this.dy_CommentCount = 0;
    this.dy_likeCount = 0;
    this.dy_followCount = 0;
    this.dy_collectCount = 0;
    this.operationTime = 0;
    this.runMinuteTime = 0;
    this.taskPlatform = "";
    this.XiaoHongShu_Setting = "";
    this.executeTask = executeTask2;
    this.executeOperationStartTime = 0;
    this.executeOperationEndTime = 0;
    this.xhs_keywords_list = [];
    this.douYin_keywords_list = [];
    this.xhs_minute = [];
    this.dy_minute = [];
    this.loadFromStorage();
  }
  checkConfig() {
    const optionWhere = this.data;
    if (optionWhere.wordWhereNumEnd < 0) {
      console.error("【最大私信字数】不能小于0");
      this.reportFail("【最大私信字数】不能小于0");
      return false;
    }
    if (optionWhere.wordWhereNum > optionWhere.wordWhereNumEnd) {
      console.error("【最大私信字数】不能小于【最小私信字数】");
      this.reportFail("【最大私信字数】不能小于【最小私信字数】");
      return false;
    }
    if (optionWhere.runTimeEnd <= 0) {
      console.error("【最大运行时长】不能小于等于0");
      this.reportFail("【最大运行时长】不能小于等于0");
      return false;
    }
    if (optionWhere.runTimeStart > optionWhere.runTimeEnd) {
      console.error("【最大运行时长】不能小于【最小运行时长】");
      this.reportFail("【最大运行时长】不能小于【最小运行时长】");
      return false;
    }
    if (optionWhere.refreshFrequencyEnd <= 0) {
      console.error("【最大刷新频率】不能小于等于0");
      this.reportFail("【最大刷新频率】不能小于等于0");
      return false;
    }
    if (optionWhere.refreshFrequencyStart > optionWhere.refreshFrequencyEnd) {
      console.error("【最大刷新频率】不能小于【最小刷新频率】");
      this.reportFail("【最大刷新频率】不能小于【最小刷新频率】");
      return false;
    }
    if (!optionWhere.wordReplyContent && optionWhere.enableFirstReplyBool == true && !optionWhere.phoneNumberReplyContent && !optionWhere.phoneNumberReplyContent1 && !optionWhere.phoneNumberReplyContent3) {
      console.error("评论和私信的回复内容不能都为空");
      return false;
    }
    return true;
  }
  reportFail(errorMessage) {
    if (!this.conn) {
      return;
    }
    this.conn.messageToReplyMQTT({
      "taskId": this.taskId,
      "executeId": this.executeId,
      "status": "failed",
      "meta": {},
      "message": errorMessage
    });
  }
  startTask() {
    return new Promise(resolve => {
      const validationError = this.validateParameters();
      if (!this.conn) {
        return;
      }
      if (validationError) {
        console.error(validationError.message);
        this.conn.messageToReplyMQTT({
          "taskId": this.taskId,
          "executeId": this.executeId,
          "status": "failed",
          "meta": {},
          "message": validationError.message
        });
        return;
      }
      console.log("Do a customize task!");
      chrome.storage.local.set({
        "taskId": this.taskId
      });
      chrome.storage.local.set({
        "executeId": this.executeId
      });
      this.my_execute(this.data);
      this.conn.messageToReplyMQTT({
        "taskId": this.taskId,
        "executeId": this.executeId,
        "status": "running",
        "meta": this.getStatus(),
        "message": ""
      });
      resolve();
    });
  }
  validateParameters() {
    if (!this.data) {
      return {
        message: "参数未传递或格式不正确"
      };
    }
    return null;
  }
  // async addObjects(postData:any) {
  //     const baseURL = import.meta.env.VITE_APP_BASE_URL;
  //     const url = baseURL+"/api/v2/oss/objects"
  //     const headers = {
  //         'Content-Type': 'application/json',
  //         'Authorization':'Bearer '+store.accessToken
  //     };
  //     try {
  //         const response = await fetch(url, {
  //             method: 'POST',
  //             headers: headers,
  //             body: JSON.stringify(postData)
  //         });
  //
  //         if (!response.ok) {
  //             console.error("addObjects url:"+url+"，header:"+JSON.stringify(headers)+", response status:"+response.status)
  //             return undefined
  //         }
  //
  //         const result = await response.json();
  //         console.log("addObjects url:"+url+"，header:"+JSON.stringify(headers)+",postData："+JSON.stringify(postData)+" response status:"+response.status+", response data:"+JSON.stringify(result))
  //
  //         return result
  //     } catch (error) {
  //         console.error("addObjects url:"+url+"，header:"+JSON.stringify(headers)+", error"+error)
  //     }
  //     return undefined
  // }
  my_execute(config) {
    console.log("my_execute config", config);
    chrome.storage.local.set({
      "runTaskStopped": ""
    });
    chrome.storage.local.set({
      "mqttStart": ""
    });
    chrome.storage.local.set({
      "runTaskStopped": ""
    });
    chrome.storage.local.set({
      "mqttStart": "ok"
    });
    chrome.storage.local.set({
      "xhs_viewCount": 0
    });
    chrome.storage.local.set({
      "xhs_CommentCount": 0
    });
    chrome.storage.local.set({
      "xhs_likeCount": 0
    });
    chrome.storage.local.set({
      "xhs_followCount": 0
    });
    chrome.storage.local.set({
      "xhs_collectCount": 0
    });
    chrome.storage.local.set({
      "dy_viewCount": 0
    });
    chrome.storage.local.set({
      "dy_CommentCount": 0
    });
    chrome.storage.local.set({
      "dy_likeCount": 0
    });
    chrome.storage.local.set({
      "dy_followCount": 0
    });
    chrome.storage.local.set({
      "dy_collectCount": 0
    });
    chrome.storage.local.set({
      "XiaoHongShu_search_runNumber": 1
    });
    chrome.storage.local.set({
      "activatePage": runPages[0]
    });
    chrome.storage.local.set({
      "operationTime": 0
    });
    chrome.storage.local.set({
      "xiaoHongShuAccountErrorTip": ""
    });
    chrome.storage.local.set({
      "xhs_keywords_list": JSON.stringify([])
    });
    chrome.storage.local.set({
      "douYin_keywords_list": JSON.stringify([])
    });
    chrome.storage.local.set({
      "xhs_minute": JSON.stringify([])
    });
    chrome.storage.local.set({
      "dy_minute": JSON.stringify([])
    });
    chrome.storage.local.set({
      "optionsPageName": ""
    });
    chrome.storage.local.set({
      "executeOperationStartTime": (/* @__PURE__ */new Date()).getTime()
    });
    chrome.storage.local.set({
      "XiaoHongShu_Setting": JSON.stringify(config)
    });
    chrome.storage.local.set({
      "optionsPageName": ""
    });
    chrome.storage.local.set({
      "optionWhere": JSON.stringify(config)
    });
    chrome.storage.local.set({
      "runTimeMaxNum": config.runTimeEnd
    });
    chrome.storage.local.set({
      "runTimeNum": (/* @__PURE__ */new Date()).getTime()
    });
    const key = store$2.userId + "_xhs_saveOptionsWhere";
    const postDataObj = {
      "key": key,
      "bucket": config,
      "size": 0,
      "content_type": "",
      "belong_to": store$2.userId + "_xhs_saveOptionsWhere",
      "object_metadata": {}
    };
    try {
      const res = addObjects(postDataObj);
      console.log("res保存的数据：", res);
    } catch (error) {
      console.log("error", error);
    }
    chrome.storage.local.set({
      "executeOperationStartTime": (/* @__PURE__ */new Date()).getTime()
    });
    let url = "https://www.xiaohongshu.com/notification";
    if (!store$2.webUserName || store$2.webUserName == "未绑定") {
      url = "https://www.xiaohongshu.com/explore";
    }
    this.executeTask({
      action: "executeTaskNoTask",
      taskId: this.taskId,
      url,
      taskName: "自动回复",
      taskPlatform: "小红书"
    }, {}, res => {
      if (res && res.tabId) {
        this.tabId = res.tabId;
      }
      if (res && res.windowId) {
        this.windowId = res.windowId;
      }
      console.log("executeTask res", res);
    });
  }
  stopTask() {
    return new Promise(resolve => {
      chrome.storage.local.set({
        "activatePage": indexPage
      });
      resolve();
    });
  }
  abortTask() {
    return new Promise(resolve => {
      this.reportStop().then(() => {});
      resolve();
    });
  }
  report() {
    return new Promise(resolve => {
      console.log("report Promise");
      try {
        let formatTimestamp = function (timestamp) {
            const date = new Date(timestamp);
            const month = String(date.getMonth() + 1).padStart(2, "0");
            const day = String(date.getDate()).padStart(2, "0");
            const hours = String(date.getHours()).padStart(2, "0");
            const minutes = String(date.getMinutes()).padStart(2, "0");
            return `${month}-${day} ${hours}:${minutes}`;
          },
          calculateTimeDifference = function (startTimestamp, endTimestamp) {
            const differenceInMs = Math.abs(endTimestamp - startTimestamp);
            const totalMinutes = Math.floor(differenceInMs / (1e3 * 60));
            return `${totalMinutes}`;
          };
        if (!this.conn) {
          resolve();
          return;
        }
        const executeOperationStartTime = formatTimestamp(this.executeOperationStartTime);
        const executeOperationEndTime = formatTimestamp(this.executeOperationEndTime);
        const run_time = calculateTimeDifference(this.executeOperationStartTime, this.executeOperationEndTime);
        let xhs_keywords_list_str = "";
        if (this.xhs_keywords_list.length > 0) {
          xhs_keywords_list_str = this.xhs_keywords_list.join("，");
        }
        let douYin_keywords_list_str = "";
        if (this.douYin_keywords_list.length > 0) {
          douYin_keywords_list_str = this.douYin_keywords_list.join("，");
        }
        let XiaoHongShu_Setting = this.XiaoHongShu_Setting;
        let workRunPlatform = "";
        if (XiaoHongShu_Setting.workDouYinPlatform) {
          if (!workRunPlatform) {
            workRunPlatform = XiaoHongShu_Setting.workDouYinPlatform;
          } else {
            workRunPlatform += "+" + XiaoHongShu_Setting.workDouYinPlatform;
          }
        }
        if (XiaoHongShu_Setting.workXiaoHongShuPlatform) {
          if (!workRunPlatform) {
            workRunPlatform = XiaoHongShu_Setting.workXiaoHongShuPlatform;
          } else {
            workRunPlatform += "+" + XiaoHongShu_Setting.workXiaoHongShuPlatform;
          }
        }
        const uniqueMinutes = [... /* @__PURE__ */new Set([...this.xhs_minute.map(item => item.minute), ...this.dy_minute.map(item => item.minute)])].sort((a, b) => a - b);
        const xhsNums = uniqueMinutes.map(minute => {
          var _a;
          return ((_a = this.xhs_minute.find(item => item.minute === minute)) == null ? void 0 : _a.num) || 0;
        });
        const xhsPieNumber = [{
          value: store$2.xhs_likeCount,
          name: "点赞"
        }, {
          value: store$2.xhs_CommentCount,
          name: "评论"
        }, {
          value: store$2.xhs_followCount,
          name: "关注"
        }, {
          value: store$2.xhs_collectCount,
          name: "收藏"
        }];
        const dyPieNumber = [{
          value: store$2.dy_likeCount,
          name: "点赞"
        }, {
          value: store$2.dy_CommentCount,
          name: "评论"
        }, {
          value: store$2.dy_followCount,
          name: "关注"
        }, {
          value: store$2.dy_collectCount,
          name: "收藏"
        }];
        const allPieNumber = [{
          value: store$2.xhs_likeCount + store$2.dy_likeCount,
          name: "点赞"
        }, {
          value: store$2.xhs_CommentCount + store$2.dy_CommentCount,
          name: "评论"
        }, {
          value: store$2.xhs_followCount + store$2.dy_followCount,
          name: "关注"
        }, {
          value: store$2.xhs_collectCount + store$2.dy_collectCount,
          name: "收藏"
        }];
        const postData = {
          executeOperationStartTime,
          executeOperationEndTime,
          run_time,
          xhs_keywords_list_str,
          douYin_keywords_list_str,
          workRunPlatform,
          uniqueMinutes,
          xhsNums,
          xhsPieNumber,
          dyPieNumber,
          allPieNumber
        };
        console.log("messageToReportMQTT postData", JSON.stringify(postData));
        console.log("Task stopped");
        this.conn.messageToReportMQTT({
          "taskId": this.taskId,
          "executeId": this.executeId,
          "status": "report",
          "meta": postData,
          "message": "报告"
        });
        resolve();
      } catch (e) {
        console.log("report e", e);
      }
    });
  }
  /**
   * 等待store 通知 callBackListener
   */
  async reportStop() {
    this.running = false;
    this.paused = false;
    this.callExecuteNotification();
    if (!this.conn) {
      return;
    }
    console.log("Task stopped");
    this.conn.messageToReplyMQTT({
      "taskId": this.taskId,
      "executeId": this.executeId,
      "status": "completed",
      "meta": this.getStatus(),
      "message": "已停止"
    });
    storageUtil.removeListener(this.callBackListener);
    super.baseReportStop();
  }
  getStatus() {
    return {
      id: this.taskId,
      running: this.running,
      paused: this.paused,
      started: this.started,
      process: this.operationTime > 0 ? (this.runMinuteTime / this.operationTime * 100).toFixed(2) : 0,
      total_num: this.operationTime,
      executed_num: this.runMinuteTime
    };
  }
  getRunData() {
    if (this.taskPlatform === "抖音") {
      return {
        viewCount: this.dy_viewCount,
        commentCount: this.dy_CommentCount,
        likeCount: this.dy_likeCount,
        followCount: this.dy_followCount,
        collectCount: this.dy_collectCount,
        operationTime: this.operationTime,
        runMinuteTime: this.runMinuteTime
      };
    } else if (this.taskPlatform === "小红书") {
      return {
        likeCount: this.xhs_likeCount,
        followCount: this.xhs_followCount,
        commentCount: this.xhs_CommentCount,
        collectCount: this.xhs_collectCount,
        viewCount: this.xhs_viewCount,
        operationTime: this.operationTime,
        runMinuteTime: this.runMinuteTime
      };
    }
  }
  reportReply() {
    console.log("reportReply");
    if (!this.conn) {
      return;
    }
    this.conn.messageToReplyMQTT({
      "taskId": this.taskId,
      "executeId": this.executeId,
      "status": "running",
      "meta": this.getStatus(),
      "message": ""
    });
  }
  loadFromStorage() {
    if (this.startLoad) {
      console.log("startLoad", this.startLoad);
      return;
    }
    this.startLoad = true;
    chrome.storage.local.get(["taskPlatform", "XiaoHongShu_Setting", "xhs_viewCount", "xhs_CommentCount", "xhs_likeCount", "xhs_followCount", "xhs_collectCount", "dy_viewCount", "dy_CommentCount", "dy_likeCount", "dy_followCount", "dy_collectCount", "operationTime", "userId", "orgId", "clientVisitorId", "accessToken"], result => {
      console.log("result activatePage", result);
      if (!result) {
        return;
      }
      if (result.userId !== void 0) {
        this.user_id = result.userId;
      }
      if (result.orgId !== void 0) {
        this.orgId = result.orgId;
      }
      if (result.clientVisitorId !== void 0) {
        this.clientVisitorId = result.clientVisitorId;
      }
      if (result.accessToken !== void 0) {
        this.accessToken = result.accessToken;
      }
      if (result.taskPlatform !== void 0) {
        this.taskPlatform = result.taskPlatform;
      }
      if (result.XiaoHongShu_Setting !== void 0) {
        this.XiaoHongShu_Setting = result.XiaoHongShu_Setting ? JSON.parse(result.XiaoHongShu_Setting) : {};
      }
      if (result.xhs_viewCount !== void 0) {
        this.xhs_viewCount = result.xhs_viewCount;
      }
      if (result.xhs_CommentCount !== void 0) {
        this.xhs_CommentCount = result.xhs_CommentCount;
      }
      if (result.xhs_likeCount !== void 0) {
        this.xhs_likeCount = result.xhs_likeCount;
      }
      if (result.xhs_followCount !== void 0) {
        this.xhs_followCount = result.xhs_followCount;
      }
      if (result.xhs_collectCount !== void 0) {
        this.xhs_collectCount = result.xhs_collectCount;
      }
      if (result.dy_viewCount !== void 0) {
        this.dy_viewCount = result.dy_viewCount;
      }
      if (result.dy_CommentCount !== void 0) {
        this.dy_CommentCount = result.dy_CommentCount;
      }
      if (result.dy_likeCount !== void 0) {
        this.dy_likeCount = result.dy_likeCount;
      }
      if (result.dy_followCount !== void 0) {
        this.dy_followCount = result.dy_followCount;
      }
      if (result.dy_collectCount !== void 0) {
        this.dy_collectCount = result.dy_collectCount;
      }
      if (result.operationTime !== void 0) {
        this.operationTime = result.operationTime;
      }
      this.startLoad = true;
      this.loadend = true;
    });
    storageUtil.addHandlers(this.callBackListener);
  }
  getHeartReportData() {}
}
const VITE_CONTENT_API = "https://agent-net.paitongai.net/content";
const VITE_AGENT_ID = "dou-yin-chrome-extension";
const store$1 = UseCounterStore.getInstance();
class XiaoHongShuYangHaoZhuShouTask extends BaseTask {
  constructor(taskId, executeId, data, executeTask2) {
    super(taskId, executeId, data);
    __publicField(this, "executeTask");
    //评论数量
    __publicField(this, "xhs_viewCount");
    __publicField(this, "xhs_CommentCount");
    __publicField(this, "xhs_likeCount");
    __publicField(this, "xhs_followCount");
    __publicField(this, "xhs_collectCount");
    //评论数量
    __publicField(this, "dy_viewCount");
    __publicField(this, "dy_CommentCount");
    __publicField(this, "dy_likeCount");
    __publicField(this, "dy_followCount");
    __publicField(this, "dy_collectCount");
    __publicField(this, "taskPlatform");
    __publicField(this, "XiaoHongShu_Setting");
    __publicField(this, "operationTime");
    __publicField(this, "runMinuteTime");
    __publicField(this, "startLoad");
    __publicField(this, "loadend");
    // 上报数据
    __publicField(this, "executeOperationStartTime");
    __publicField(this, "executeOperationEndTime");
    __publicField(this, "xhs_keywords_list");
    __publicField(this, "douYin_keywords_list");
    __publicField(this, "xhs_minute");
    __publicField(this, "dy_minute");
    __publicField(this, "reportRunDataStatus", async () => {
      var _a;
      console.log("reportRunDataStatus");
      if (!this.conn) {
        return;
      }
      const runData = this.getRunData();
      console.log("runData", JSON.stringify(runData));
      this.conn.messageToStatusMQTT({
        "taskId": this.taskId,
        "data": runData,
        "userId": this.user_id,
        "terminalId": (_a = this.terminalData) == null ? void 0 : _a.terminalId
      });
    });
    __publicField(this, "reportRunData", async () => {
      var _a;
      const url = VITE_CONTENT_API + "/api/content/";
      const headers = {
        "Content-Type": "application/json",
        ...this.addAuthorizationHeader()
        // Ensure this function works in the extension
      };
      try {
        console.log("reportRunData");
        const runData = this.getRunData();
        console.log("runData", JSON.stringify(runData));
        const postData = {
          "taskId": this.taskId,
          "data": runData,
          "userId": this.user_id,
          "terminalId": (_a = this.terminalData) == null ? void 0 : _a.terminalId
        };
        const response = await fetch(url, {
          method: "POST",
          headers,
          body: JSON.stringify(postData)
        });
        if (!response.ok) {
          console.log("url:" + url + "，header:" + JSON.stringify(headers) + ", response status:" + response.status);
          return;
        }
        const result = await response.json();
        console.log("url:" + url + "，header:" + JSON.stringify(headers) + ",postData：" + JSON.stringify(postData) + " response status:" + response.status + ", response data:" + JSON.stringify(result));
      } catch (error) {
        console.log("Error in putNewTask:", error);
        sendLog("url:" + url + "，header:" + JSON.stringify(headers) + ", error" + error);
      }
    });
    __publicField(this, "callBackListener", (changes, namespace) => {
      for (let [key, {
        oldValue,
        newValue
      }] of Object.entries(changes)) {
        console.log(`customizeTask Storage key "${key}" in namespace "${namespace}" changed.`, `Old value was "${oldValue}", new value is "${newValue}".`);
        switch (key) {
          case "runTaskStopped":
            if (newValue == "end") {
              this.reportStop().then(() => {});
            }
            break;
          case "taskPlatform":
            this.taskPlatform = newValue;
            break;
          case "XiaoHongShu_Setting":
            this.XiaoHongShu_Setting = newValue ? JSON.parse(newValue) : {};
            break;
          case "orgId":
            this.orgId = newValue;
            break;
          case "userId":
            this.user_id = newValue;
            break;
          case "clientVisitorId":
            this.clientVisitorId = newValue;
            break;
          case "accessToken":
            this.accessToken = newValue;
            break;
          case "operationTime":
            this.operationTime = newValue;
            break;
          case "runMinuteTime":
            this.runMinuteTime = newValue;
            this.reportReply();
            break;
          case "xhs_likeCount":
            this.xhs_likeCount = newValue;
            this.reportRunDataStatus().then();
            break;
          case "xhs_followCount":
            this.xhs_followCount = newValue;
            this.reportRunDataStatus().then();
            break;
          case "xhs_CommentCount":
            this.xhs_CommentCount = newValue;
            this.reportRunDataStatus().then();
            break;
          case "xhs_collectCount":
            this.xhs_collectCount = newValue;
            this.reportRunDataStatus().then();
            break;
          case "xhs_viewCount":
            this.xhs_viewCount = newValue;
            this.reportRunDataStatus().then();
            break;
          case "dy_likeCount":
            this.dy_likeCount = newValue;
            this.reportRunDataStatus().then();
            break;
          case "dy_followCount":
            this.dy_followCount = newValue;
            this.reportRunDataStatus().then();
            break;
          case "dy_CommentCount":
            this.dy_CommentCount = newValue;
            this.reportRunDataStatus().then();
            break;
          case "dy_collectCount":
            this.dy_collectCount = newValue;
            this.reportRunDataStatus().then();
            break;
          case "dy_viewCount":
            this.dy_viewCount = newValue;
            this.reportRunDataStatus().then();
            break;
          case "executeOperationStartTime":
            this.executeOperationStartTime = newValue;
            break;
          case "executeOperationEndTime":
            this.executeOperationEndTime = newValue;
            break;
          case "xhs_keywords_list":
            this.xhs_keywords_list = newValue ? JSON.parse(newValue) : [];
            break;
          case "douYin_keywords_list":
            this.douYin_keywords_list = newValue ? JSON.parse(newValue) : [];
            break;
          case "xhs_minute":
            this.xhs_minute = newValue ? JSON.parse(newValue) : [];
            break;
          case "dy_minute":
            this.dy_minute = newValue ? JSON.parse(newValue) : [];
            break;
        }
      }
    });
    this.startLoad = false;
    this.loadend = false;
    this.xhs_viewCount = 0;
    this.xhs_CommentCount = 0;
    this.xhs_likeCount = 0;
    this.xhs_followCount = 0;
    this.xhs_collectCount = 0;
    this.dy_viewCount = 0;
    this.dy_CommentCount = 0;
    this.dy_likeCount = 0;
    this.dy_followCount = 0;
    this.dy_collectCount = 0;
    this.operationTime = 0;
    this.runMinuteTime = 0;
    this.taskPlatform = "";
    this.XiaoHongShu_Setting = "";
    this.executeTask = executeTask2;
    this.executeOperationStartTime = 0;
    this.executeOperationEndTime = 0;
    this.xhs_keywords_list = [];
    this.douYin_keywords_list = [];
    this.xhs_minute = [];
    this.dy_minute = [];
    this.loadFromStorage();
  }
  /**
   * 检查配置是否正确
   */
  checkConfig() {
    return true;
  }
  startTask() {
    return new Promise(async resolve => {
      const validationError = this.validateParameters();
      if (!this.conn) {
        resolve();
        return;
      }
      if (validationError) {
        console.error(validationError.message);
        this.conn.messageToReplyMQTT({
          "taskId": this.taskId,
          "executeId": this.executeId,
          "status": "failed",
          "meta": {},
          "message": validationError.message
        });
        resolve();
        return;
      }
      console.log("Do a customize task!");
      await this.my_execute(this.data);
      this.conn.messageToReplyMQTT({
        "taskId": this.taskId,
        "executeId": this.executeId,
        "status": "running",
        "meta": this.getStatus(),
        "message": ""
      });
      resolve();
    });
  }
  validateParameters() {
    if (!this.data) {
      return {
        message: "参数未传递或格式不正确"
      };
    }
    return null;
  }
  async my_execute(config) {
    var _a;
    chrome.storage.local.set({
      "runTaskStopped": ""
    });
    chrome.storage.local.set({
      "mqttStart": "ok"
    });
    chrome.storage.local.set({
      "xhs_viewCount": 0
    });
    chrome.storage.local.set({
      "xhs_CommentCount": 0
    });
    chrome.storage.local.set({
      "xhs_likeCount": 0
    });
    chrome.storage.local.set({
      "xhs_followCount": 0
    });
    chrome.storage.local.set({
      "xhs_collectCount": 0
    });
    chrome.storage.local.set({
      "dy_viewCount": 0
    });
    chrome.storage.local.set({
      "dy_CommentCount": 0
    });
    chrome.storage.local.set({
      "dy_likeCount": 0
    });
    chrome.storage.local.set({
      "dy_followCount": 0
    });
    chrome.storage.local.set({
      "dy_collectCount": 0
    });
    chrome.storage.local.set({
      "XiaoHongShu_search_runNumber": 1
    });
    chrome.storage.local.set({
      "activatePage": runPages[0]
    });
    chrome.storage.local.set({
      "operationTime": 0
    });
    chrome.storage.local.set({
      "xiaoHongShuAccountErrorTip": ""
    });
    chrome.storage.local.set({
      "xhs_keywords_list": JSON.stringify([])
    });
    chrome.storage.local.set({
      "douYin_keywords_list": JSON.stringify([])
    });
    chrome.storage.local.set({
      "xhs_minute": JSON.stringify([])
    });
    chrome.storage.local.set({
      "dy_minute": JSON.stringify([])
    });
    chrome.storage.local.set({
      "optionsPageName": ""
    });
    chrome.storage.local.set({
      "executeOperationStartTime": (/* @__PURE__ */new Date()).getTime()
    });
    chrome.storage.local.set({
      "XiaoHongShu_Setting": JSON.stringify(config)
    });
    if (!this.XiaoHongShu_Setting) {
      this.XiaoHongShu_Setting = config;
    }
    if (config.workDouYinPlatform == "抖音") {
      if (!this.taskPlatform) {
        this.taskPlatform = config.workDouYinPlatform;
      }
      const saveTaskDataResult = await saveTaskData({
        task_options: {
          taskId: this.taskId,
          executeId: this.executeId,
          agentId: VITE_AGENT_ID,
          terminalId: (_a = store$1.terminalData) == null ? void 0 : _a.terminalId
        }
      });
      console.log("saveTaskDataResult", saveTaskDataResult);
      if (saveTaskDataResult && saveTaskDataResult.code == 0) {
        store$1.setQuestTaskId(saveTaskDataResult.data.id);
      }
      this.executeTask({
        action: "executeTask",
        url: "https://www.douyin.com",
        taskName: config.workType,
        taskPlatform: config.workDouYinPlatform,
        taskId: this.taskId
      }, {}, res => {
        if (res && res.tabId) {
          this.tabId = res.tabId;
        }
        if (res && res.windowId) {
          this.windowId = res.windowId;
        }
        console.log("executeTask res", res);
      });
    }
    if (config.workXiaoHongShuPlatform == "小红书") {
      this.executeTask({
        action: "executeTask",
        url: "https://www.xiaohongshu.com/explore",
        taskName: config.workType,
        taskPlatform: config.workXiaoHongShuPlatform,
        taskId: this.taskId
      }, {}, res => {
        if (res && res.tabId) {
          this.tabId = res.tabId;
        }
        if (res && res.windowId) {
          this.windowId = res.windowId;
        }
        console.log("executeTask res", res);
      });
      if (!this.taskPlatform) {
        this.taskPlatform = config.workXiaoHongShuPlatform;
      }
    }
  }
  stopTask() {
    return new Promise(resolve => {
      sendLog("douYinYangHaoZhuShouTask background activatePage ：", indexPage);
      chrome.storage.local.set({
        "activatePage": indexPage
      });
      resolve();
    });
  }
  abortTask() {
    return new Promise(resolve => {
      this.reportStop().then(() => {});
      resolve();
    });
  }
  report() {
    return new Promise(resolve => {
      console.log("report Promise");
      try {
        let formatTimestamp = function (timestamp) {
            const date = new Date(timestamp);
            const month = String(date.getMonth() + 1).padStart(2, "0");
            const day = String(date.getDate()).padStart(2, "0");
            const hours = String(date.getHours()).padStart(2, "0");
            const minutes = String(date.getMinutes()).padStart(2, "0");
            return `${month}-${day} ${hours}:${minutes}`;
          },
          calculateTimeDifference = function (startTimestamp, endTimestamp) {
            const differenceInMs = Math.abs(endTimestamp - startTimestamp);
            const totalMinutes = Math.floor(differenceInMs / (1e3 * 60));
            return `${totalMinutes}`;
          };
        if (!this.conn) {
          resolve();
          return;
        }
        const executeOperationStartTime = formatTimestamp(this.executeOperationStartTime);
        const executeOperationEndTime = formatTimestamp(this.executeOperationEndTime);
        const run_time = calculateTimeDifference(this.executeOperationStartTime, this.executeOperationEndTime);
        let xhs_keywords_list_str = "";
        if (this.xhs_keywords_list.length > 0) {
          xhs_keywords_list_str = this.xhs_keywords_list.join("，");
        }
        let douYin_keywords_list_str = "";
        if (this.douYin_keywords_list.length > 0) {
          douYin_keywords_list_str = this.douYin_keywords_list.join("，");
        }
        let XiaoHongShu_Setting = this.XiaoHongShu_Setting;
        let workRunPlatform = "";
        if (XiaoHongShu_Setting.workDouYinPlatform) {
          if (!workRunPlatform) {
            workRunPlatform = XiaoHongShu_Setting.workDouYinPlatform;
          } else {
            workRunPlatform += "+" + XiaoHongShu_Setting.workDouYinPlatform;
          }
        }
        if (XiaoHongShu_Setting.workXiaoHongShuPlatform) {
          if (!workRunPlatform) {
            workRunPlatform = XiaoHongShu_Setting.workXiaoHongShuPlatform;
          } else {
            workRunPlatform += "+" + XiaoHongShu_Setting.workXiaoHongShuPlatform;
          }
        }
        const uniqueMinutes = [... /* @__PURE__ */new Set([...this.xhs_minute.map(item => item.minute), ...this.dy_minute.map(item => item.minute)])].sort((a, b) => a - b);
        const xhsNums = uniqueMinutes.map(minute => {
          var _a;
          return ((_a = this.xhs_minute.find(item => item.minute === minute)) == null ? void 0 : _a.num) || 0;
        });
        const xhsPieNumber = [{
          value: store$1.xhs_likeCount,
          name: "点赞"
        }, {
          value: store$1.xhs_CommentCount,
          name: "评论"
        }, {
          value: store$1.xhs_followCount,
          name: "关注"
        }, {
          value: store$1.xhs_collectCount,
          name: "收藏"
        }];
        const dyPieNumber = [{
          value: store$1.dy_likeCount,
          name: "点赞"
        }, {
          value: store$1.dy_CommentCount,
          name: "评论"
        }, {
          value: store$1.dy_followCount,
          name: "关注"
        }, {
          value: store$1.dy_collectCount,
          name: "收藏"
        }];
        const allPieNumber = [{
          value: store$1.xhs_likeCount + store$1.dy_likeCount,
          name: "点赞"
        }, {
          value: store$1.xhs_CommentCount + store$1.dy_CommentCount,
          name: "评论"
        }, {
          value: store$1.xhs_followCount + store$1.dy_followCount,
          name: "关注"
        }, {
          value: store$1.xhs_collectCount + store$1.dy_collectCount,
          name: "收藏"
        }];
        const postData = {
          executeOperationStartTime,
          executeOperationEndTime,
          run_time,
          xhs_keywords_list_str,
          douYin_keywords_list_str,
          workRunPlatform,
          uniqueMinutes,
          xhsNums,
          xhsPieNumber,
          dyPieNumber,
          allPieNumber
        };
        console.log("messageToReportMQTT postData", JSON.stringify(postData));
        sendLog("Task stopped");
        this.conn.messageToReportMQTT({
          "taskId": this.taskId,
          "executeId": this.executeId,
          "status": "report",
          "meta": postData,
          "message": "报告"
        });
        resolve();
      } catch (e) {
        console.log("report e", e);
      }
    });
  }
  /**
   * 获取心跳上报数据
   */
  getHeartReportData() {
    return {};
  }
  /**
   * 等待store 通知 callBackListener
   */
  async reportStop() {
    this.running = false;
    this.paused = false;
    this.callExecuteNotification();
    if (!this.conn) {
      return;
    }
    sendLog("Task stopped");
    this.conn.messageToReplyMQTT({
      "taskId": this.taskId,
      "executeId": this.executeId,
      "status": "completed",
      "meta": this.getStatus(),
      "message": "已停止"
    });
    storageUtil.removeListener(this.callBackListener);
    super.baseReportStop();
  }
  getStatus() {
    return {
      id: this.taskId,
      running: this.running,
      paused: this.paused,
      started: this.started,
      process: this.operationTime > 0 ? (this.runMinuteTime / this.operationTime * 100).toFixed(2) : 0,
      total_num: this.operationTime,
      executed_num: this.runMinuteTime
    };
  }
  getRunData() {
    if (this.taskPlatform === "抖音") {
      return {
        viewCount: this.dy_viewCount,
        commentCount: this.dy_CommentCount,
        likeCount: this.dy_likeCount,
        followCount: this.dy_followCount,
        collectCount: this.dy_collectCount,
        operationTime: this.operationTime,
        runMinuteTime: this.runMinuteTime
      };
    } else if (this.taskPlatform === "小红书") {
      return {
        likeCount: this.xhs_likeCount,
        followCount: this.xhs_followCount,
        commentCount: this.xhs_CommentCount,
        collectCount: this.xhs_collectCount,
        viewCount: this.xhs_viewCount,
        operationTime: this.operationTime,
        runMinuteTime: this.runMinuteTime
      };
    }
  }
  reportReply() {
    console.log("reportReply");
    if (!this.conn) {
      return;
    }
    this.conn.messageToReplyMQTT({
      "taskId": this.taskId,
      "executeId": this.executeId,
      "status": "running",
      "meta": this.getStatus(),
      "message": ""
    });
  }
  loadFromStorage() {
    if (this.startLoad) {
      console.log("startLoad", this.startLoad);
      return;
    }
    this.startLoad = true;
    chrome.storage.local.get(["taskPlatform", "XiaoHongShu_Setting", "xhs_viewCount", "xhs_CommentCount", "xhs_likeCount", "xhs_followCount", "xhs_collectCount", "dy_viewCount", "dy_CommentCount", "dy_likeCount", "dy_followCount", "dy_collectCount", "operationTime", "userId", "orgId", "clientVisitorId", "accessToken"], result => {
      console.log("result activatePage", result);
      if (!result) {
        return;
      }
      if (result.userId !== void 0) {
        this.user_id = result.userId;
      }
      if (result.orgId !== void 0) {
        this.orgId = result.orgId;
      }
      if (result.clientVisitorId !== void 0) {
        this.clientVisitorId = result.clientVisitorId;
      }
      if (result.accessToken !== void 0) {
        this.accessToken = result.accessToken;
      }
      if (result.taskPlatform !== void 0) {
        this.taskPlatform = result.taskPlatform;
      }
      if (result.XiaoHongShu_Setting !== void 0) {
        this.XiaoHongShu_Setting = result.XiaoHongShu_Setting ? JSON.parse(result.XiaoHongShu_Setting) : {};
      }
      if (result.xhs_viewCount !== void 0) {
        this.xhs_viewCount = result.xhs_viewCount;
      }
      if (result.xhs_CommentCount !== void 0) {
        this.xhs_CommentCount = result.xhs_CommentCount;
      }
      if (result.xhs_likeCount !== void 0) {
        this.xhs_likeCount = result.xhs_likeCount;
      }
      if (result.xhs_followCount !== void 0) {
        this.xhs_followCount = result.xhs_followCount;
      }
      if (result.xhs_collectCount !== void 0) {
        this.xhs_collectCount = result.xhs_collectCount;
      }
      if (result.dy_viewCount !== void 0) {
        this.dy_viewCount = result.dy_viewCount;
      }
      if (result.dy_CommentCount !== void 0) {
        this.dy_CommentCount = result.dy_CommentCount;
      }
      if (result.dy_likeCount !== void 0) {
        this.dy_likeCount = result.dy_likeCount;
      }
      if (result.dy_followCount !== void 0) {
        this.dy_followCount = result.dy_followCount;
      }
      if (result.dy_collectCount !== void 0) {
        this.dy_collectCount = result.dy_collectCount;
      }
      if (result.operationTime !== void 0) {
        this.operationTime = result.operationTime;
      }
      this.startLoad = true;
      this.loadend = true;
    });
    storageUtil.addHandlers(this.callBackListener);
  }
}
const store = UseCounterStore.getInstance();
console.log("this is background service-worker.ts file");
const manifest = chrome.runtime.getManifest();
console.log("content_scripts", manifest && manifest.content_scripts);
const activeDebuggerSessions = {};
const changedCallBack = (changes, namespace) => {
  for (let [key, {
    oldValue,
    newValue
  }] of Object.entries(changes)) {
    console.log(`Storage key "${key}" in namespace "${namespace}" changed.`, `Old value was "${oldValue}", new value is "${newValue}".`);
    switch (key) {
      case "taskCompleteData":
        if (newValue) {
          try {
            const newValueJson = JSON.parse(newValue);
            if (newValueJson && Object.keys(newValueJson).length > 0) {
              const key2 = parseInt(Object.keys(newValueJson)[0], 10);
              if (!isNaN(key2)) {
                delete activeDebuggerSessions[key2];
              }
            } else {
              console.log("不存在这个tabId", newValue);
            }
          } catch (e) {
            console.log("newValueJson error", newValue);
          }
        } else {
          console.log("taskCompleteData newValue 为空");
        }
        break;
    }
  }
};
storageUtil.addHandlers(changedCallBack);
storageUtil.startOnChangedListener();
console.log("mqttManage.userId", mqttManage.userId);
const taskManager = new TaskManager();
const createTask = (taskId, executeId, stopTaskBool, baseTask) => {
  taskManager.stopRunTasks(stopTaskBool).then().finally(() => {
    mqttManage.messageToReplyMQTT({
      "taskId": taskId,
      "executeId": executeId,
      "status": "queued",
      "meta": {},
      "message": "已加入队列"
    });
    chrome.storage.local.set({
      "taskId": taskId
    }).then(() => {}).finally(() => {
      baseTask.setConn(mqttManage);
      taskManager.addTask(baseTask).then(() => {}).catch(error => {
        console.error("error", error);
      });
    });
  });
};
const chooseCreateTask = (parsedMessage, stopTaskBool) => {
  const config = parsedMessage.data;
  const type = parsedMessage.type;
  const taskId = parsedMessage.taskId;
  const executeId = parsedMessage.executeId;
  let baseTask = null;
  switch (type) {
    case "XiaohongshuTask":
      baseTask = new ShuJuJianKongCustomizeTask(taskId, executeId, config, executeTask);
      createTask(taskId, executeId, stopTaskBool, baseTask);
      break;
    case "DouYinSearchVideoTask":
      baseTask = new DouYinSearchVideoTask(taskId, executeId, config, executeTask);
      createTask(taskId, executeId, stopTaskBool, baseTask);
      break;
    case "DouYinPushTask":
      baseTask = new CustomizeDouYinPushTask(taskId, executeId, config, executeTask);
      createTask(taskId, executeId, stopTaskBool, baseTask);
      break;
    case "DouYinKeZiTask":
      baseTask = new DouYinKeZiCustomizeTask(taskId, executeId, config, executeTask);
      createTask(taskId, executeId, stopTaskBool, baseTask);
      break;
    case "DouYinYangHaoZhuShouTask":
      baseTask = new DouYinYangHaoZhuShouTask(taskId, executeId, config, executeTask);
      createTask(taskId, executeId, stopTaskBool, baseTask);
      break;
    case "KuaiShouPushTask":
      baseTask = new CustomizeKuaiShouPushTask(taskId, executeId, config, executeTask);
      createTask(taskId, executeId, stopTaskBool, baseTask);
      break;
    case "KuaiShouYangHaoZhuShouTask":
      baseTask = new KuaiShouYangHaoZhuShouTask(taskId, executeId, config, executeTask);
      createTask(taskId, executeId, stopTaskBool, baseTask);
      break;
    case "ShiPinHaoKeZiTask":
      baseTask = new ShipinhaoKeZiCustomizeTask(taskId, executeId, config, executeTask);
      createTask(taskId, executeId, stopTaskBool, baseTask);
      break;
    case "XiaoHongShuAutoReplyTask":
      baseTask = new XiaoHongShuAutoReplyTask(taskId, executeId, config, executeTask);
      createTask(taskId, executeId, stopTaskBool, baseTask);
      break;
    case "XiaoHongShuYangHaoZhuShouTask":
      baseTask = new XiaoHongShuYangHaoZhuShouTask(taskId, executeId, config, executeTask);
      createTask(taskId, executeId, stopTaskBool, baseTask);
      break;
    default:
      console.error("Unknown type", type);
  }
};
mqttManage.setChooseCreateTask(chooseCreateTask);
mqttManage.registeMessageFromMQTT(async message => {
  chrome.storage.local.set({
    "runLogs": JSON.stringify(message)
  });
  sendLog("收到MQTT消息:", formatNowDateTimeSss(), JSON.stringify(message));
  const parsedMessage = message;
  if (parsedMessage.operation === "cmd") {
    mqttManage.setRunTaskMqttMessage(JSON.stringify(parsedMessage));
    chooseCreateTask(parsedMessage, true);
    return;
  }
  if (parsedMessage.operation === "stop") {
    const taskId = parsedMessage.taskId;
    taskManager.stopTask(taskId).then(() => {});
    return;
  }
});
const executeTask = (request, sender, sendResponse) => {
  var _a;
  console.log("running");
  console.log("request", (_a = sender == null ? void 0 : sender.tab) == null ? void 0 : _a.id);
  chrome.system.display.getInfo(displays => {
    const primaryDisplay = displays.find(display => display.isPrimary);
    console.log("primaryDisplay", primaryDisplay);
    if (!primaryDisplay) {
      sendResponse();
      console.log("退出");
      return;
    }
    const screenWidth = primaryDisplay.bounds.width;
    const screenHeight = primaryDisplay.bounds.height;
    const windowWidth = Math.floor(screenWidth * 0.8);
    const windowHeight = Math.floor(screenHeight * 0.8);
    const windowLeft = Math.floor((screenWidth - windowWidth) / 2);
    const windowTop = Math.floor((screenHeight - windowHeight) / 2);
    let url = request.url;
    const createWindowBack = window => {
      requestKeepAwake();
      console.log("create", window);
      if (window && window.tabs && window.tabs[0].id !== void 0 && window.id !== void 0) {
        const tabId = window.tabs[0].id;
        activeDebuggerSessions[tabId] = {
          windowId: window.id,
          onCompleted: false,
          noCloseRun: request.noCloseRun ? true : false,
          openOptionsPage: true,
          taskComplete: false,
          parentTabId: request.parentTabId,
          tabData: {
            taskName: request.taskName,
            taskPlatform: request.taskPlatform,
            taskId: request == null ? void 0 : request.taskId
          },
          uploadFileList: request.uploadFileList
        };
        console.log("createWindowBack 打开窗口成功", {
          tabId,
          windowId: window.id,
          taskId: request == null ? void 0 : request.taskId
        });
        sendResponse({
          windowId: window.id,
          tabId
        });
      } else {
        console.log("打开窗口失败", {
          taskId: request == null ? void 0 : request.taskId
        });
        sendResponse();
      }
    };
    const createTabCallback = tab => {
      requestKeepAwake();
      console.log("create", tab);
      if (tab && tab.id !== void 0 && tab.windowId !== void 0) {
        const tabId = tab.id;
        activeDebuggerSessions[tabId] = {
          windowId: tab.windowId,
          onCompleted: false,
          noCloseRun: false,
          openOptionsPage: true,
          taskComplete: false,
          parentTabId: request.parentTabId,
          tabData: {
            taskName: request.taskName,
            taskPlatform: request.taskPlatform,
            taskId: request == null ? void 0 : request.taskId
          },
          uploadFileList: request.uploadFileList
        };
        console.log("createTabCallback 打开窗口成功", {
          tabId,
          windowId: tab.windowId,
          taskId: request == null ? void 0 : request.taskId
        });
        sendResponse({
          windowId: tab.windowId,
          tabId
        });
      } else {
        console.log("打开窗口失败", {
          taskId: request == null ? void 0 : request.taskId
        });
        sendResponse();
      }
    };
    if (request.windowType) {
      const createProperties = {
        url
      };
      if (request.targetWindowId) {
        createProperties["windowId"] = request.targetWindowId;
      }
      chrome.tabs.create(createProperties, createTabCallback);
    } else {
      chrome.windows.create({
        url,
        type: "popup",
        width: windowWidth,
        height: windowHeight,
        left: windowLeft,
        top: windowTop
      }, createWindowBack);
    }
  });
  return true;
};
chrome.runtime.onMessage.addListener((request, sender, sendResponse) => {
  var _a, _b, _c, _d, _e, _f, _g, _h, _i, _j, _k, _l, _m, _n, _o, _p, _q, _r, _s, _t, _u, _v, _w, _x, _y, _z, _A, _B, _C, _D, _E, _F, _G, _H;
  console.log("request", (_a = sender.tab) == null ? void 0 : _a.id, request);
  if (request.action == "restart") {
    if (store.terminalData.terminalId == request.terminalId) {
      for (const sessionId in activeDebuggerSessions) {
        if (activeDebuggerSessions.hasOwnProperty(sessionId)) {
          const session = activeDebuggerSessions[sessionId];
          session.noCloseRun = true;
          console.log(`Session ID: ${sessionId}`, session);
        }
      }
      chrome.runtime.reload();
    }
    sendResponse();
    return false;
  }
  if (request.action == "readyRestart") {
    for (const sessionId in activeDebuggerSessions) {
      if (activeDebuggerSessions.hasOwnProperty(sessionId)) {
        const session = activeDebuggerSessions[sessionId];
        session.noCloseRun = true;
        console.log(`Session ID: ${sessionId}`, session);
      }
    }
    sendResponse();
    return false;
  }
  if (request.action == "autologin2") {
    store.setAccessToken(request.accessToken);
    store.setUserName(request.email);
    store.setUserId(request.userId);
    store.setTenantId(request.tenantId);
    store.setWebUserId(request.webUserId);
    store.setWebUserName(request.webUserName);
    store.setWebUserAvatarUrl(request.webUserAvatarUrl);
    store.setCPUSerialNumber(request.cpuSerialNumber);
    store.setWebPort(parseInt(request.webPort));
    if (request["tenantId"]) {
      tenantsMine().then(async tenants_mine_res => {
        var _a2, _b2;
        console.log("tenantsMine", tenants_mine_res);
        if (tenants_mine_res && tenants_mine_res.data && tenants_mine_res.data.id) {
          store.setTenantId(tenants_mine_res.data.id);
          store.setTenantName(tenants_mine_res.data.name);
        }
        const agentBusinessRes = await agentBusiness(false);
        if (!agentBusinessRes) {
          console.log("getLoginTokenFun agentBusiness, store.tenantId:" + store.tenantId + ", agentBusinessRes:" + agentBusinessRes);
        }
        if (!((_a2 = store == null ? void 0 : store.terminalData) == null ? void 0 : _a2.terminalId)) {
          sendLog("终端的id为空");
          return;
        }
        const saveTerminalBindData = {
          "terminal_name": store.webUserName ? store.webUserName : "请设置设备名称",
          "terminal_info": {
            "webUserName": store.webUserName,
            "webUserAvatarUrl": store.webUserAvatarUrl,
            "webUserId": store.webUserId
          }
        };
        const saveTerminalBindRes = await saveTerminalBind((_b2 = store == null ? void 0 : store.terminalData) == null ? void 0 : _b2.terminalId, saveTerminalBindData);
        sendLog("agentBusiness saveTerminalBindRes：" + JSON.stringify(saveTerminalBindRes));
        chrome.storage.local.set({
          "optionsPageName": ""
        }).then(res => {
          console.log("res", res);
        });
      }).catch(error => {
        console.log("tenantsMine error", error);
      }).finally(() => {
        console.log("tenantsMine finally");
      });
      sendResponse();
      return false;
    } else {
      console.log("request['tenantId'] is null", request["tenantId"]);
    }
    sendResponse();
    return false;
  }
  if (request.action == "updateSetTerminalName") {
    (async () => {
      var _a2;
      const saveTerminalBindData = {
        "terminal_name": request.terminalName ? request.terminalName : "请设置设备名称",
        "terminal_info": {
          "webUserName": store.webUserName,
          "webUserAvatarUrl": store.webUserAvatarUrl,
          "webUserId": store.webUserId
        }
      };
      const saveTerminalBindRes = await saveTerminalBind((_a2 = store == null ? void 0 : store.terminalData) == null ? void 0 : _a2.terminalId, saveTerminalBindData);
      sendLog("agentBusiness saveTerminalBindRes：" + JSON.stringify(saveTerminalBindRes));
    })();
    sendResponse();
    return false;
  }
  if (request.action == "saveTerminalWebUserName") {
    executeTask(request, sender, sendResponse);
    return true;
  }
  if (request.action === "executeTask") {
    request["taskId"] = (/* @__PURE__ */new Date()).getTime();
    const yt = new LocalCustomizeTask(request["taskId"], request["taskId"], "config", executeTask, request, sender, sendResponse);
    yt.setConn(mqttManage);
    taskManager.addTask(yt).then(() => {}).catch(error => {
      console.error("error", error);
    });
    return true;
  }
  if (request.action === "executeTaskNoTask") {
    executeTask(request, sender, sendResponse);
    return true;
  }
  if (request.action === "inputKey") {
    const debuggee = {
      tabId: (_b = sender.tab) == null ? void 0 : _b.id
    };
    const sendMessage = () => {
      return new Promise(resolve => {
        console.log("sendMessage Promise");
        chrome.debugger.attach(debuggee, "1.0", async () => {
          var _a2, _b2, _c2, _d2, _e2;
          const contentArray = Array.from(request.content);
          console.log("contentArray", contentArray);
          let index = 0;
          while (true) {
            if (index < contentArray.length) {
              if (!request.keyDown || contentArray[index] !== "\n" && contentArray[index] !== "\r") {
                if (request.checkFocus) {
                  await queryActiveElementWhile((_a2 = sender.tab) == null ? void 0 : _a2.id);
                }
                const tabId = (_b2 = sender.tab) == null ? void 0 : _b2.id;
                if (tabId && !activeDebuggerSessions[tabId]) {
                  console.log("窗口不存在了，不需要继续输入了");
                  break;
                }
                let textEvt = {
                  "type": "insertText",
                  "text": contentArray[index]
                };
                chrome.debugger.sendCommand({
                  tabId: (_c2 = sender.tab) == null ? void 0 : _c2.id
                }, "Input.insertText", textEvt).then(() => {}).catch(err => {
                  console.error("Input.insertText error", err);
                });
              } else {
                if (request.checkFocus) {
                  await queryActiveElementWhile((_d2 = sender.tab) == null ? void 0 : _d2.id);
                }
                chrome.debugger.sendCommand({
                  tabId: (_e2 = sender.tab) == null ? void 0 : _e2.id
                }, "Input.dispatchKeyEvent", {
                  type: "keyDown",
                  windowsVirtualKeyCode: 13,
                  // Enter 的虚拟键码
                  nativeVirtualKeyCode: 13,
                  macCharCode: 13
                }).then(() => {
                  var _a3;
                  return chrome.debugger.sendCommand({
                    tabId: (_a3 = sender.tab) == null ? void 0 : _a3.id
                  }, "Input.dispatchKeyEvent", {
                    type: "keyUp",
                    windowsVirtualKeyCode: 13,
                    nativeVirtualKeyCode: 13,
                    macCharCode: 13
                  });
                }).then(() => {}).catch(err => {
                  console.error("Error sending key event", err);
                });
              }
              index++;
            } else {
              break;
            }
            await delay(request.interval_time_out ? request.interval_time_out : 200);
          }
          resolve();
        });
      });
    };
    sendMessage().then(() => {
      console.log("sendMessage");
    }).catch(error => {
      console.log("error", error);
    }).finally(() => {
      console.log("finally");
      setTimeout(() => {
        chrome.debugger.detach(debuggee).then(res => {
          console.log("res", res);
        }).finally(() => {
          sendResponse();
        });
      }, 1e3);
    });
    return true;
  }
  if (request.action === "ctril_v") {
    const debuggee = {
      tabId: (_c = sender.tab) == null ? void 0 : _c.id
    };
    chrome.debugger.sendCommand(debuggee, "Input.dispatchKeyEvent", {
      type: "keyDown",
      windowsVirtualKeyCode: 86,
      // V key code
      modifiers: 2
      // Ctrl key modifier (MacOS 可以用 Cmd 键)
    }).then(res => {
      console.log("res keyDown", res);
    });
    chrome.debugger.sendCommand(debuggee, "Input.dispatchKeyEvent", {
      type: "keyUp",
      windowsVirtualKeyCode: 86,
      modifiers: 2
    }).then(res => {
      console.log("res keyUp", res);
    });
    sendResponse();
    return false;
  }
  if (request.action === "openAuthorizationUrl") {
    executeTask(request, sender, sendResponse);
    return true;
  }
  if (request.action === "noCloseRun") {
    if (((_d = sender.tab) == null ? void 0 : _d.id) !== void 0) {
      activeDebuggerSessions[(_e = sender.tab) == null ? void 0 : _e.id].noCloseRun = true;
      sendResponse();
      return false;
    }
  }
  if (request.action === "closeTab") {
    if (((_f = sender.tab) == null ? void 0 : _f.id) !== void 0) {
      if (request.tag && request.tag == "closeTabListener" && activeDebuggerSessions[(_g = sender.tab) == null ? void 0 : _g.id] && activeDebuggerSessions[(_h = sender.tab) == null ? void 0 : _h.id].openOptionsPage) {
        if (activeDebuggerSessions && activeDebuggerSessions[(_i = sender.tab) == null ? void 0 : _i.id] && ((_k = activeDebuggerSessions[(_j = sender.tab) == null ? void 0 : _j.id]) == null ? void 0 : _k.tabData) && ((_m = activeDebuggerSessions[(_l = sender.tab) == null ? void 0 : _l.id]) == null ? void 0 : _m.tabData.taskId)) {
          console.log("结束任务", (_n = sender.tab) == null ? void 0 : _n.id, (_p = activeDebuggerSessions[(_o = sender.tab) == null ? void 0 : _o.id]) == null ? void 0 : _p.tabData.taskId);
          taskManager.report((_r = activeDebuggerSessions[(_q = sender.tab) == null ? void 0 : _q.id]) == null ? void 0 : _r.tabData.taskId).then();
        }
        chrome.runtime.openOptionsPage().then(() => {});
        console.log("handleLogin chrome.runtime.openOptionsPage()");
      }
      chrome.tabs.remove(sender.tab.id, () => {
        var _a2;
        console.log(`Tab ${(_a2 = sender.tab) == null ? void 0 : _a2.id} 已成功关闭。`);
      });
    } else {
      console.warn("无法关闭标签页：sender.tab.id 未定义。");
    }
    sendResponse();
    return false;
  }
  if (request.action === "getTabTaskData") {
    if (sender.tab && sender.tab.id) {
      let tabData = {};
      if (activeDebuggerSessions[sender.tab.id]) {
        console.log("getTabTaskData sender.tab.id activeDebuggerSessions");
        tabData = (_s = activeDebuggerSessions[sender.tab.id]) == null ? void 0 : _s.tabData;
      }
      console.log("getTabTaskData sender.tab.id tabData: ", tabData);
      sendResponse({
        tabId: sender.tab.id,
        windowId: sender.tab.windowId,
        tabData
      });
    } else {
      console.log("getTabTaskData no sender.tab.id");
      sendResponse({
        tabId: null
      });
    }
    return false;
  }
  if (request.action === "queryTabs") {
    chrome.tabs.query({
      windowId: request.windowId
    }, function (tabs) {
      if (chrome.runtime.lastError) {
        console.error("queryTabs Error querying tabs:", chrome.runtime.lastError);
        sendResponse({
          tabIds: []
        });
        return;
      }
      const tabIds = tabs.map(tab => tab.id);
      console.log("queryTabs tabIds", tabIds);
      sendResponse({
        tabIds
      });
      return;
    });
    return true;
  }
  if (request.action === "setOpenOptionsPage") {
    if (((_t = sender.tab) == null ? void 0 : _t.id) !== void 0) {
      activeDebuggerSessions[(_u = sender.tab) == null ? void 0 : _u.id].openOptionsPage = false;
      sendResponse();
      return false;
    }
  }
  if (request.message === "queryActivateTab") {
    chrome.tabs.query({
      active: true,
      currentWindow: true
    }, tabs => {
      if (tabs.length > 0) {
        sendResponse({
          tabId: tabs[0].id,
          url: tabs[0].url
        });
      } else {
        sendResponse({
          tabId: null,
          url: null
        });
      }
    });
    return true;
  }
  if (request.action === "checkIfTabExists") {
    chrome.tabs.query({}, function (tabs) {
      let tabExists = tabs.some(tab => tab.id === request.tabId);
      sendResponse({
        tabExists
      });
    });
    return true;
  }
  if (request.action === "taskComplete") {
    if (((_v = sender.tab) == null ? void 0 : _v.id) !== void 0) {
      activeDebuggerSessions[(_w = sender.tab) == null ? void 0 : _w.id].taskComplete = true;
      sendResponse();
      return false;
    }
  }
  if (request.action === "checkTaskComplete") {
    if (request.tabId !== void 0) {
      sendResponse({
        taskComplete: (_x = activeDebuggerSessions[request.tabId]) == null ? void 0 : _x.taskComplete
      });
      return false;
    }
  }
  if (request.action === "currentActivateTab") {
    if (((_y = sender.tab) == null ? void 0 : _y.id) !== void 0) {
      const tabId = (_z = sender.tab) == null ? void 0 : _z.id;
      if (tabId) {
        let errorNum = 0;
        const tabs_update_Interval = setInterval(() => {
          chrome.tabs.update(tabId, {
            active: true
          }).then(res => {
            var _a2;
            console.log("update res", res);
            chrome.storage.local.set({
              "taskComplete": (_a2 = sender.tab) == null ? void 0 : _a2.id
            }, () => {});
            sendResponse();
            clearInterval(tabs_update_Interval);
          }).catch(err => {
            if (errorNum > 3) {
              sendResponse();
              clearInterval(tabs_update_Interval);
            }
            errorNum++;
            console.log("update err", err);
          });
        }, 200);
        return true;
      }
    }
    sendResponse();
    return false;
  }
  if (request.action === "activateTab") {
    if (((_A = sender.tab) == null ? void 0 : _A.id) !== void 0) {
      const parentTabId = (_C = activeDebuggerSessions[(_B = sender.tab) == null ? void 0 : _B.id]) == null ? void 0 : _C.parentTabId;
      if (parentTabId) {
        let errorNum = 0;
        const tabs_update_Interval = setInterval(() => {
          chrome.tabs.update(parentTabId, {
            active: true
          }).then(res => {
            var _a2;
            console.log("update res", res);
            chrome.storage.local.set({
              "taskComplete": (_a2 = sender.tab) == null ? void 0 : _a2.id
            }, () => {});
            sendResponse();
            clearInterval(tabs_update_Interval);
          }).catch(err => {
            if (errorNum > 3) {
              sendResponse();
              clearInterval(tabs_update_Interval);
            }
            errorNum++;
            console.log("update err", err);
          });
        }, 200);
        return true;
      }
    }
    sendResponse();
    return false;
  }
  if (request.action === "getFileSelected") {
    if (sender.tab && sender.tab.id) {
      let uploadFileList = [];
      if (activeDebuggerSessions[sender.tab.id]) {
        console.log(sender.tab.id, "getFileSelected sender.tab.id activeDebuggerSessions");
        uploadFileList = activeDebuggerSessions[sender.tab.id].uploadFileList;
      }
      console.log(sender.tab.id, "getFileSelected sender.tab.id tabData: ", uploadFileList);
      sendResponse({
        tabId: sender.tab.id,
        uploadFileList
      });
    } else {
      console.log("getFileSelected no sender.tab.id");
      sendResponse({
        tabId: null
      });
    }
    return false;
  }
  if (request.action === "allTaskComplete") {
    if (sender.tab && sender.tab.id && ((_D = activeDebuggerSessions[sender.tab.id]) == null ? void 0 : _D.tabData)) {
      console.log("结束任务", sender.tab.id, (_F = (_E = activeDebuggerSessions[sender.tab.id]) == null ? void 0 : _E.tabData) == null ? void 0 : _F.taskId);
      taskManager.abortTask((_H = (_G = activeDebuggerSessions[sender.tab.id]) == null ? void 0 : _G.tabData) == null ? void 0 : _H.taskId).then();
    }
    sendResponse();
    return false;
  }
  if (request.action == "logs") {
    sendResponse();
    return false;
  }
  const actionList = ["tabChange", "injectIframe", "_queryLastTime", "queryActiveElement", "setActiveElement"];
  if (request.action || request.messageType) {
    let returnBool = false;
    actionList.forEach(action => {
      if (returnBool) {
        return;
      }
      const index = (request.action || request.messageType).indexOf(action);
      console.log("action ", action, index);
      if ((request.action || request.messageType).indexOf(action) > 0) {
        returnBool = true;
      }
    });
    if (!returnBool) {
      sendResponse();
      return false;
    }
  } else {
    console.error("没有匹配到消息类型");
  }
});
const queryActiveElementWhile = async tabId => {
  let num = 0;
  while (true) {
    if (num > 60) {
      return false;
    }
    if (!activeDebuggerSessions[tabId]) {
      console.log("窗口不存在了，不需要继续检查了");
      return false;
    }
    const boolData = await queryActiveElement(tabId);
    if (boolData) {
      return boolData;
    } else {
      await setActiveElement(tabId);
    }
    if (!activeDebuggerSessions[tabId]) {
      console.log("窗口不存在了，不需要继续检查了");
      return false;
    }
    num++;
    await delay(1e3);
  }
};
const queryActiveElement = tabId => {
  return new Promise(resolve => {
    chrome.tabs.sendMessage(tabId, {
      messageType: "queryActiveElement",
      status: false,
      tabId
    }, {}, response => {
      if (response) {
        console.log("queryActiveElement res:", response);
        resolve(true);
      } else {
        console.error("queryActiveElement Failed to get tab information.");
        resolve(false);
      }
    });
  });
};
const setActiveElement = tabId => {
  return new Promise(resolve => {
    chrome.tabs.sendMessage(tabId, {
      messageType: "setActiveElement",
      status: false,
      tabId
    }, {}, response => {
      if (response) {
        console.log("setActiveElement res:", response);
        resolve(true);
      } else {
        console.error("setActiveElement Failed to get tab information.");
        resolve(false);
      }
    });
  });
};
chrome.tabs.onRemoved.addListener(tabId => {
  sendLog(`Tab ${tabId} removed.`);
  if (activeDebuggerSessions[tabId]) {
    if (!activeDebuggerSessions[tabId].noCloseRun) {
      console.log("chrome.tabs.onRemoved.addListener", tabId);
      chrome.storage.local.set({
        "activatePage": indexPage
      }, () => {
        var _a, _b, _c, _d;
        console.log("Data has been stored locally.", activeDebuggerSessions && activeDebuggerSessions[tabId]);
        if (activeDebuggerSessions && activeDebuggerSessions[tabId] && ((_a = activeDebuggerSessions[tabId]) == null ? void 0 : _a.tabData) && ((_b = activeDebuggerSessions[tabId]) == null ? void 0 : _b.tabData.taskId)) {
          sendLog("结束任务", tabId, (_c = activeDebuggerSessions[tabId]) == null ? void 0 : _c.tabData.taskId);
          taskManager.abortTask((_d = activeDebuggerSessions[tabId]) == null ? void 0 : _d.tabData.taskId).then();
        }
        releaseKeepAwake();
        chrome.storage.local.set({
          "DoneNoteId": tabId
        }, () => {});
        delete activeDebuggerSessions[tabId];
      });
    } else {
      chrome.storage.local.set({
        "DoneNoteId": tabId
      }, () => {});
      delete activeDebuggerSessions[tabId];
    }
  } else {
    console.log("not activeDebuggerSessions[tabId]", tabId, Object.keys(activeDebuggerSessions));
  }
});
chrome.tabs.onActivated.addListener(activeInfo => {
  var _a;
  console.log("onActivated", activeInfo);
  if (activeDebuggerSessions[activeInfo.tabId] && ((_a = activeDebuggerSessions[activeInfo.tabId]) == null ? void 0 : _a.onCompleted)) {
    console.log("激活状态", activeInfo.tabId);
    chrome.tabs.sendMessage(activeInfo.tabId, {
      messageType: "tabChange",
      status: true,
      tabId: activeInfo.tabId
    }, {}, res => {
      console.log("激活状态 res", activeInfo.tabId, res);
    });
  }
  if (Object.keys(activeDebuggerSessions).length > 0) {
    Object.keys(activeDebuggerSessions).forEach(tabIdStr => {
      var _a2;
      const tabId = Number(tabIdStr);
      if (!isNaN(tabId)) {
        if (tabId != activeInfo.tabId && activeDebuggerSessions[tabId] && ((_a2 = activeDebuggerSessions[tabId]) == null ? void 0 : _a2.windowId) == activeInfo.windowId) {
          console.log("失去激活状态", tabId);
          chrome.tabs.sendMessage(tabId, {
            messageType: "tabChange",
            status: false,
            tabId
          }, {}, res => {
            console.log("失去激活状态 res", tabId, res);
          });
          let errorNum = 0;
          const tabs_update_Interval = setInterval(() => {
            chrome.tabs.update(tabId, {
              active: true
            }).then(res => {
              console.log("update res", res);
              clearInterval(tabs_update_Interval);
            }).catch(err => {
              if (errorNum > 3) {
                clearInterval(tabs_update_Interval);
              }
              errorNum++;
              console.log("update err", err);
            });
          }, 200);
        }
      }
    });
  }
});
chrome.tabs.onDetached.addListener((tabId, detachInfo) => {
  console.log(`Tab ${tabId} was detached from window ${detachInfo.oldWindowId}.`);
});
chrome.tabs.onAttached.addListener((tabId, attachInfo) => {
  console.log(`Tab ${tabId} was attached to window ${attachInfo.newWindowId}.`);
  if (activeDebuggerSessions[tabId]) {
    activeDebuggerSessions[tabId].windowId = attachInfo.newWindowId;
  }
});
chrome.tabs.onUpdated.addListener((tabId, changeInfo, tab) => {
  console.log("changeInfo.status", changeInfo, tabId, tab);
});
chrome.webNavigation.onErrorOccurred.addListener(details => {
  const errorCode = details.error;
  let errorMessage;
  switch (errorCode) {
    case "net::ERR_NAME_NOT_RESOLVED":
      errorMessage = "域名解析失败，可能是 DNS 服务器配置问题、域名拼写错误或者域名本身不存在。";
      break;
    case "net::ERR_DNS_TIMED_OUT":
      errorMessage = "DNS 查询超时，在规定时间内未能从 DNS 服务器获取到域名对应的 IP 地址，可能是 DNS 服务器响应慢或者网络连接问题。";
      break;
    case "net::ERR_CONNECTION_REFUSED":
      errorMessage = "连接被拒绝，通常是因为目标服务器没有在指定的端口上监听连接，可能是服务器未启动、端口被防火墙阻止等原因。";
      break;
    case "net::ERR_CONNECTION_TIMED_OUT":
      errorMessage = "连接超时，在尝试连接到服务器时，经过一定时间仍未建立连接，可能是网络延迟过高、服务器负载过大或者网络故障。";
      break;
    case "net::ERR_CONNECTION_RESET":
      errorMessage = "连接被重置，在数据传输过程中，连接被意外中断，可能是网络不稳定、服务器异常关闭连接等原因。";
      break;
    case "net::ERR_CONNECTION_ABORTED":
      errorMessage = "连接被中止，可能是用户主动取消请求、浏览器关闭连接或者程序代码中提前终止了连接。";
      break;
    case "net::ERR_CONNECTION_FAILED":
      errorMessage = "连接失败，这是一个通用的连接错误，可能是由于多种原因导致，如网络配置错误、服务器不可用等。";
      break;
    case "net::ERR_PROXY_CONNECTION_FAILED":
      errorMessage = "代理连接失败，当使用代理服务器时，无法与代理服务器建立连接，可能是代理服务器地址、端口配置错误或者代理服务器本身不可用。";
      break;
    case "net::ERR_TUNNEL_CONNECTION_FAILED":
      errorMessage = "在使用 HTTPS 代理隧道时，隧道连接失败，通常与代理服务器的配置和网络环境有关。";
      break;
    case "net::ERR_CERT_COMMON_NAME_INVALID":
      errorMessage = "证书的通用名称无效，服务器提供的 SSL/TLS 证书中的通用名称（CN）与访问的域名不匹配，可能存在中间人攻击风险。";
      break;
    case "net::ERR_CERT_DATE_INVALID":
      errorMessage = "证书日期无效，服务器的 SSL/TLS 证书已过期或者尚未生效，浏览器会阻止访问以确保安全。";
      break;
    case "net::ERR_CERT_AUTHORITY_INVALID":
      errorMessage = "证书颁发机构无效，服务器的 SSL/TLS 证书不是由受信任的证书颁发机构（CA）签发的，浏览器无法验证证书的真实性。";
      break;
    case "net::ERR_SSL_PROTOCOL_ERROR":
      errorMessage = "SSL/TLS 协议错误，在与服务器进行 SSL/TLS 握手过程中出现问题，可能是服务器和客户端支持的 SSL/TLS 版本不兼容或者加密算法不一致。";
      break;
    case "net::ERR_INTERNET_DISCONNECTED":
      errorMessage = "网络连接断开，表明设备没有有效的网络连接，无法访问互联网。";
      break;
    case "net::ERR_BLOCKED_BY_CLIENT":
      errorMessage = "请求被客户端阻止，可能是浏览器的扩展程序、安全软件或者用户设置阻止了该请求。";
      break;
    case "net::ERR_UNSAFE_PORT":
      errorMessage = "尝试访问不安全的端口，浏览器出于安全考虑，会阻止对某些端口的访问，例如一些用于内部服务的端口。";
      break;
    case "net::ERR_UNKNOWN_URL_SCHEME":
      errorMessage = "未知的 URL 协议，浏览器不支持所使用的 URL 协议，例如自定义的或者非法的协议。";
      break;
    default:
      errorMessage = `未知错误代码: ${errorCode}`;
  }
  if (!details.url) {
    details.url = "";
  }
  if (details.url.length > 1e3) {
    details.url = details.url.slice(0, 1e3);
  }
  const message = `webNavigation.onErrorOccurred 导航到 ${details.url} 时出错，错误代码: ${errorCode}，错误原因: ${errorMessage}`;
  chrome.storage.local.set({
    "runLogs": message
  });
  sendLog(message);
}, {
  url: [{
    urlMatches: "http://www.xiaohongshu.com/*"
  }, {
    urlMatches: "https://www.xiaohongshu.com/*"
  }, {
    urlMatches: "http://www.douyin.com/*"
  }, {
    urlMatches: "https://www.douyin.com/*"
  }, {
    urlMatches: "http://www.facebook.com/*"
  }, {
    urlMatches: "https://www.facebook.com/*"
  }]
});
chrome.webNavigation.onCompleted.addListener(details => {
  var _a, _b;
  console.log("webNavigation.onCompleted details", details);
  if (details.frameId === 0) {
    const tabId = details.tabId;
    if (activeDebuggerSessions[tabId]) {
      if ((manifest == null ? void 0 : manifest.content_scripts) && ((_a = manifest == null ? void 0 : manifest.content_scripts[0]) == null ? void 0 : _a.js)) {
        chrome.scripting.executeScript({
          target: {
            tabId
          },
          files: (_b = manifest == null ? void 0 : manifest.content_scripts[0]) == null ? void 0 : _b.js
        }, () => {
          console.log("executeScript file callback");
          if (chrome.runtime.lastError) {
            console.log("error", chrome.runtime.lastError.message);
          }
        });
      }
    }
  }
}, {
  url: [{
    urlMatches: "http://www.xiaohongshu.com/*"
  }, {
    urlMatches: "https://www.xiaohongshu.com/*"
  }, {
    urlMatches: "http://www.douyin.com/*"
  }, {
    urlMatches: "https://www.douyin.com/*"
  }, {
    urlMatches: "http://www.facebook.com/*"
  }, {
    urlMatches: "https://www.facebook.com/*"
  }]
});